/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.1
 *
 * Copyright (c) 2024 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt5.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtBluetooth.h"

#line 27 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtBluetooth/qpybluetooth_qlist.sip"
#include <qlist.h>
#line 29 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtBluetooth/sipQtBluetoothQList1600.cpp"



extern "C" {static void assign_QList_1600(void *, Py_ssize_t, void *);}
static void assign_QList_1600(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QList< ::quint16> *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QList< ::quint16> *>(sipSrc);
}


extern "C" {static void *array_QList_1600(Py_ssize_t);}
static void *array_QList_1600(Py_ssize_t sipNrElem)
{
    return new ::QList< ::quint16>[sipNrElem];
}


extern "C" {static void *copy_QList_1600(const void *, Py_ssize_t);}
static void *copy_QList_1600(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QList< ::quint16>(reinterpret_cast<const ::QList< ::quint16> *>(sipSrc)[sipSrcIdx]);
}


/* Call the mapped type's destructor. */
extern "C" {static void release_QList_1600(void *, int);}
static void release_QList_1600(void *sipCppV, int)
{
    ::QList< ::quint16> *sipCpp = reinterpret_cast< ::QList< ::quint16> *>(sipCppV);
    delete sipCpp;
}



extern "C" {static int convertTo_QList_1600(PyObject *, void **, int *, PyObject *);}
static int convertTo_QList_1600(PyObject *sipPy, void **sipCppPtrV, int *sipIsErr, PyObject *sipTransferObj)
{
    ::QList< ::quint16> **sipCppPtr = reinterpret_cast< ::QList< ::quint16> **>(sipCppPtrV);

#line 56 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtBluetooth/qpybluetooth_qlist.sip"
    PyObject *iter = PyObject_GetIter(sipPy);

    if (!sipIsErr)
    {
        PyErr_Clear();
        Py_XDECREF(iter);

        return (iter
#if PY_MAJOR_VERSION < 3
                && !PyString_Check(sipPy)
#endif
                && !PyUnicode_Check(sipPy));
    }

    if (!iter)
    {
        *sipIsErr = 1;

        return 0;
    }

    QList<quint16> *qv = new QList<quint16>;

    for (Py_ssize_t i = 0; ; ++i)
    {
        PyErr_Clear();
        PyObject *itm = PyIter_Next(iter);

        if (!itm)
        {
            if (PyErr_Occurred())
            {
                delete qv;
                Py_DECREF(iter);
                *sipIsErr = 1;

                return 0;
            }

            break;
        }

        PyErr_Clear();
        unsigned long val = PyLong_AsUnsignedLongMask(itm);

        if (PyErr_Occurred())
        {
            PyErr_Format(PyExc_TypeError,
                    "index %zd has type '%s' but 'int' is expected", i,
                    sipPyTypeName(Py_TYPE(itm)));

            Py_DECREF(itm);
            delete qv;
            Py_DECREF(iter);
            *sipIsErr = 1;

            return 0;
        }

        qv->append(val);

        Py_DECREF(itm);
    }

    Py_DECREF(iter);

    *sipCppPtr = qv;

    return sipGetState(sipTransferObj);
#line 139 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtBluetooth/sipQtBluetoothQList1600.cpp"
}


extern "C" {static PyObject *convertFrom_QList_1600(void *, PyObject *);}
static PyObject *convertFrom_QList_1600(void *sipCppV, PyObject *)
{
    ::QList< ::quint16> *sipCpp = reinterpret_cast< ::QList< ::quint16> *>(sipCppV);

#line 31 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtBluetooth/qpybluetooth_qlist.sip"
    PyObject *l = PyList_New(sipCpp->size());

    if (!l)
        return 0;

    for (int i = 0; i < sipCpp->size(); ++i)
    {
        // Convert to a Python long to make sure it doesn't get interpreted as
        // a signed value.
        PyObject *pobj = PyLong_FromUnsignedLongLong(sipCpp->value(i));

        if (!pobj)
        {
            Py_DECREF(l);

            return 0;
        }

        PyList_SetItem(l, i, pobj);
    }

    return l;
#line 171 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtBluetooth/sipQtBluetoothQList1600.cpp"
}


sipMappedTypeDef sipTypeDef_QtBluetooth_QList_1600 = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_MAPPED,
        sipNameNr_11247,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        -1,
        {0, 0, 1},
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR}
    },
    assign_QList_1600,
    array_QList_1600,
    copy_QList_1600,
    release_QList_1600,
    convertTo_QList_1600,
    convertFrom_QList_1600
};
