/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.1
 *
 * Copyright (c) 2024 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt5.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtCore.h"

#line 26 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtCore/qeasingcurve.sip"
#include <qeasingcurve.h>
#line 29 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQEasingCurve.cpp"

#line 28 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtCore/qpycore_qvector.sip"
#include <qvector.h>
#line 33 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQEasingCurve.cpp"
#line 98 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtCore/qpoint.sip"
#include <qpoint.h>
#line 36 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQEasingCurve.cpp"
#line 30 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtCore/qeasingcurve.sip"
// The EasingFunction callback doesn't provide a context so we support a fixed
// number of different functions.

const int ec_nr_custom_types = 10;

struct ec_custom_type {
    PyObject *py_func;
    QEasingCurve::EasingFunction func;
};

static qreal ec_call(int ec, qreal v);

static qreal ec_func_0(qreal v)
{
    return ec_call(0, v);
}

static qreal ec_func_1(qreal v)
{
    return ec_call(1, v);
}

static qreal ec_func_2(qreal v)
{
    return ec_call(2, v);
}

static qreal ec_func_3(qreal v)
{
    return ec_call(3, v);
}

static qreal ec_func_4(qreal v)
{
    return ec_call(4, v);
}

static qreal ec_func_5(qreal v)
{
    return ec_call(5, v);
}

static qreal ec_func_6(qreal v)
{
    return ec_call(6, v);
}

static qreal ec_func_7(qreal v)
{
    return ec_call(7, v);
}

static qreal ec_func_8(qreal v)
{
    return ec_call(8, v);
}

static qreal ec_func_9(qreal v)
{
    return ec_call(9, v);
}

static ec_custom_type ec_custom_types[ec_nr_custom_types] = {
    {0, ec_func_0},
    {0, ec_func_1},
    {0, ec_func_2},
    {0, ec_func_3},
    {0, ec_func_4},
    {0, ec_func_5},
    {0, ec_func_6},
    {0, ec_func_7},
    {0, ec_func_8},
    {0, ec_func_9},
};

static qreal ec_call(int ec, qreal v)
{
    PyObject *res_obj;
    qreal res = 0.0;

    SIP_BLOCK_THREADS

    res_obj = PyObject_CallFunction(ec_custom_types[ec].py_func, (char *)"(d)", (double)v);

    if (res_obj)
    {
        PyErr_Clear();

        res = PyFloat_AsDouble(res_obj);
        Py_DECREF(res_obj);

        if (PyErr_Occurred())
            res_obj = 0;
    }

    if (!res_obj)
        pyqt5_err_print();

    SIP_UNBLOCK_THREADS

    return res;
}
#line 140 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQEasingCurve.cpp"


PyDoc_STRVAR(doc_QEasingCurve_amplitude, "amplitude(self) -> float");

extern "C" {static PyObject *meth_QEasingCurve_amplitude(PyObject *, PyObject *);}
static PyObject *meth_QEasingCurve_amplitude(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QEasingCurve *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QEasingCurve, &sipCpp))
        {
            ::qreal sipRes;

            sipRes = sipCpp->amplitude();

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QEasingCurve, sipName_amplitude, doc_QEasingCurve_amplitude);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QEasingCurve_setAmplitude, "setAmplitude(self, amplitude: float)");

extern "C" {static PyObject *meth_QEasingCurve_setAmplitude(PyObject *, PyObject *);}
static PyObject *meth_QEasingCurve_setAmplitude(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qreal a0;
        ::QEasingCurve *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bd", &sipSelf, sipType_QEasingCurve, &sipCpp, &a0))
        {
            sipCpp->setAmplitude(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QEasingCurve, sipName_setAmplitude, doc_QEasingCurve_setAmplitude);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QEasingCurve_period, "period(self) -> float");

extern "C" {static PyObject *meth_QEasingCurve_period(PyObject *, PyObject *);}
static PyObject *meth_QEasingCurve_period(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QEasingCurve *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QEasingCurve, &sipCpp))
        {
            ::qreal sipRes;

            sipRes = sipCpp->period();

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QEasingCurve, sipName_period, doc_QEasingCurve_period);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QEasingCurve_setPeriod, "setPeriod(self, period: float)");

extern "C" {static PyObject *meth_QEasingCurve_setPeriod(PyObject *, PyObject *);}
static PyObject *meth_QEasingCurve_setPeriod(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qreal a0;
        ::QEasingCurve *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bd", &sipSelf, sipType_QEasingCurve, &sipCpp, &a0))
        {
            sipCpp->setPeriod(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QEasingCurve, sipName_setPeriod, doc_QEasingCurve_setPeriod);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QEasingCurve_overshoot, "overshoot(self) -> float");

extern "C" {static PyObject *meth_QEasingCurve_overshoot(PyObject *, PyObject *);}
static PyObject *meth_QEasingCurve_overshoot(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QEasingCurve *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QEasingCurve, &sipCpp))
        {
            ::qreal sipRes;

            sipRes = sipCpp->overshoot();

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QEasingCurve, sipName_overshoot, doc_QEasingCurve_overshoot);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QEasingCurve_setOvershoot, "setOvershoot(self, overshoot: float)");

extern "C" {static PyObject *meth_QEasingCurve_setOvershoot(PyObject *, PyObject *);}
static PyObject *meth_QEasingCurve_setOvershoot(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qreal a0;
        ::QEasingCurve *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bd", &sipSelf, sipType_QEasingCurve, &sipCpp, &a0))
        {
            sipCpp->setOvershoot(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QEasingCurve, sipName_setOvershoot, doc_QEasingCurve_setOvershoot);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QEasingCurve_type, "type(self) -> QEasingCurve.Type");

extern "C" {static PyObject *meth_QEasingCurve_type(PyObject *, PyObject *);}
static PyObject *meth_QEasingCurve_type(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QEasingCurve *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QEasingCurve, &sipCpp))
        {
            ::QEasingCurve::Type sipRes;

            sipRes = sipCpp->type();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QEasingCurve_Type);
        }
    }

    sipNoMethod(sipParseErr, sipName_QEasingCurve, sipName_type, doc_QEasingCurve_type);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QEasingCurve_setType, "setType(self, type: QEasingCurve.Type)");

extern "C" {static PyObject *meth_QEasingCurve_setType(PyObject *, PyObject *);}
static PyObject *meth_QEasingCurve_setType(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QEasingCurve::Type a0;
        ::QEasingCurve *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BE", &sipSelf, sipType_QEasingCurve, &sipCpp, sipType_QEasingCurve_Type, &a0))
        {
            sipCpp->setType(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QEasingCurve, sipName_setType, doc_QEasingCurve_setType);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QEasingCurve_setCustomType, "setCustomType(self, func: Callable[[float], float])");

extern "C" {static PyObject *meth_QEasingCurve_setCustomType(PyObject *, PyObject *);}
static PyObject *meth_QEasingCurve_setCustomType(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        PyObject * a0;
        ::QEasingCurve *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BF", &sipSelf, sipType_QEasingCurve, &sipCpp, &a0))
        {
            sipErrorState sipError = sipErrorNone;

#line 228 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtCore/qeasingcurve.sip"
        int i;
        ec_custom_type *ct;
        
        for (i = 0; i < ec_nr_custom_types; ++i)
        {
            ct = &ec_custom_types[i];
        
            if (!ct->py_func || ct->py_func == a0)
                break;
        }
        
        if (i == ec_nr_custom_types)
        {
            PyErr_Format(PyExc_ValueError, "a maximum of %d different easing functions are supported", ec_nr_custom_types);
            sipError = sipErrorFail;
        }
        else
        {
            if (!ct->py_func)
            {
                ct->py_func = a0;
                Py_INCREF(a0);
            }
        
            sipCpp->setCustomType(ct->func);
        }
#line 393 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQEasingCurve.cpp"

            if (sipError == sipErrorFail)
                return 0;

            if (sipError == sipErrorNone)
            {
            Py_INCREF(Py_None);
            return Py_None;
            }

            sipAddException(sipError, &sipParseErr);
        }
    }

    sipNoMethod(sipParseErr, sipName_QEasingCurve, sipName_setCustomType, doc_QEasingCurve_setCustomType);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QEasingCurve_customType, "customType(self) -> Callable[[float], float]");

extern "C" {static PyObject *meth_QEasingCurve_customType(PyObject *, PyObject *);}
static PyObject *meth_QEasingCurve_customType(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QEasingCurve *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QEasingCurve, &sipCpp))
        {
            PyObject * sipRes = SIP_NULLPTR;

#line 258 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtCore/qeasingcurve.sip"
        QEasingCurve::EasingFunction func = sipCpp->customType();
        
        sipRes = Py_None;
        
        if (func)
        {
            for (int i = 0; i < ec_nr_custom_types; ++i)
            {
                if (ec_custom_types[i].func == func)
                {
                    sipRes = ec_custom_types[i].py_func;
                    break;
                }
            }
        }
        
        Py_INCREF(sipRes);
#line 446 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQEasingCurve.cpp"

            return sipRes;
        }
    }

    sipNoMethod(sipParseErr, sipName_QEasingCurve, sipName_customType, doc_QEasingCurve_customType);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QEasingCurve_valueForProgress, "valueForProgress(self, progress: float) -> float");

extern "C" {static PyObject *meth_QEasingCurve_valueForProgress(PyObject *, PyObject *);}
static PyObject *meth_QEasingCurve_valueForProgress(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qreal a0;
        const ::QEasingCurve *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bd", &sipSelf, sipType_QEasingCurve, &sipCpp, &a0))
        {
            ::qreal sipRes;

            sipRes = sipCpp->valueForProgress(a0);

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QEasingCurve, sipName_valueForProgress, doc_QEasingCurve_valueForProgress);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QEasingCurve_swap, "swap(self, other: QEasingCurve)");

extern "C" {static PyObject *meth_QEasingCurve_swap(PyObject *, PyObject *);}
static PyObject *meth_QEasingCurve_swap(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QEasingCurve* a0;
        ::QEasingCurve *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QEasingCurve, &sipCpp, sipType_QEasingCurve, &a0))
        {
            sipCpp->swap(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QEasingCurve, sipName_swap, doc_QEasingCurve_swap);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QEasingCurve_addCubicBezierSegment, "addCubicBezierSegment(self, c1: QPointF|QPoint, c2: QPointF|QPoint, endPoint: QPointF|QPoint)");

extern "C" {static PyObject *meth_QEasingCurve_addCubicBezierSegment(PyObject *, PyObject *);}
static PyObject *meth_QEasingCurve_addCubicBezierSegment(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPointF* a0;
        int a0State = 0;
        const ::QPointF* a1;
        int a1State = 0;
        const ::QPointF* a2;
        int a2State = 0;
        ::QEasingCurve *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1J1J1", &sipSelf, sipType_QEasingCurve, &sipCpp, sipType_QPointF, &a0, &a0State, sipType_QPointF, &a1, &a1State, sipType_QPointF, &a2, &a2State))
        {
            sipCpp->addCubicBezierSegment(*a0, *a1, *a2);
            sipReleaseType(const_cast< ::QPointF *>(a0), sipType_QPointF, a0State);
            sipReleaseType(const_cast< ::QPointF *>(a1), sipType_QPointF, a1State);
            sipReleaseType(const_cast< ::QPointF *>(a2), sipType_QPointF, a2State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QEasingCurve, sipName_addCubicBezierSegment, doc_QEasingCurve_addCubicBezierSegment);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QEasingCurve_addTCBSegment, "addTCBSegment(self, nextPoint: QPointF|QPoint, t: float, c: float, b: float)");

extern "C" {static PyObject *meth_QEasingCurve_addTCBSegment(PyObject *, PyObject *);}
static PyObject *meth_QEasingCurve_addTCBSegment(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPointF* a0;
        int a0State = 0;
        ::qreal a1;
        ::qreal a2;
        ::qreal a3;
        ::QEasingCurve *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1ddd", &sipSelf, sipType_QEasingCurve, &sipCpp, sipType_QPointF, &a0, &a0State, &a1, &a2, &a3))
        {
            sipCpp->addTCBSegment(*a0, a1, a2, a3);
            sipReleaseType(const_cast< ::QPointF *>(a0), sipType_QPointF, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QEasingCurve, sipName_addTCBSegment, doc_QEasingCurve_addTCBSegment);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QEasingCurve_toCubicSpline, "toCubicSpline(self) -> list[QPointF]");

extern "C" {static PyObject *meth_QEasingCurve_toCubicSpline(PyObject *, PyObject *);}
static PyObject *meth_QEasingCurve_toCubicSpline(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QEasingCurve *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QEasingCurve, &sipCpp))
        {
            QVector< ::QPointF>*sipRes;

            sipRes = new QVector< ::QPointF>(sipCpp->toCubicSpline());

            return sipConvertFromNewType(sipRes, sipType_QVector_0100QPointF, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QEasingCurve, sipName_toCubicSpline, doc_QEasingCurve_toCubicSpline);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_QEasingCurve___ne__(PyObject *, PyObject *);}
static PyObject *slot_QEasingCurve___ne__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QEasingCurve *sipCpp = reinterpret_cast< ::QEasingCurve *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QEasingCurve));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QEasingCurve* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QEasingCurve, &a0, &a0State))
        {
            bool sipRes;

            sipRes = sipCpp->::QEasingCurve::operator!=(*a0);
            sipReleaseType(const_cast< ::QEasingCurve *>(a0), sipType_QEasingCurve, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtCore, ne_slot, sipType_QEasingCurve, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QEasingCurve___eq__(PyObject *, PyObject *);}
static PyObject *slot_QEasingCurve___eq__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QEasingCurve *sipCpp = reinterpret_cast< ::QEasingCurve *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QEasingCurve));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QEasingCurve* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QEasingCurve, &a0, &a0State))
        {
            bool sipRes;

            sipRes = sipCpp->::QEasingCurve::operator==(*a0);
            sipReleaseType(const_cast< ::QEasingCurve *>(a0), sipType_QEasingCurve, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtCore, eq_slot, sipType_QEasingCurve, sipSelf, sipArg);
}


/* Call the instance's destructor. */
extern "C" {static void release_QEasingCurve(void *, int);}
static void release_QEasingCurve(void *sipCppV, int)
{
    delete reinterpret_cast< ::QEasingCurve *>(sipCppV);
}


extern "C" {static void *array_QEasingCurve(Py_ssize_t);}
static void *array_QEasingCurve(Py_ssize_t sipNrElem)
{
    return new ::QEasingCurve[sipNrElem];
}


extern "C" {static void array_delete_QEasingCurve(void *);}
static void array_delete_QEasingCurve(void *sipCpp)
{
    delete[] reinterpret_cast< ::QEasingCurve *>(sipCpp);
}


extern "C" {static void assign_QEasingCurve(void *, Py_ssize_t, void *);}
static void assign_QEasingCurve(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QEasingCurve *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QEasingCurve *>(sipSrc);
}


extern "C" {static void *copy_QEasingCurve(const void *, Py_ssize_t);}
static void *copy_QEasingCurve(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QEasingCurve(reinterpret_cast<const ::QEasingCurve *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QEasingCurve(sipSimpleWrapper *);}
static void dealloc_QEasingCurve(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QEasingCurve(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QEasingCurve(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QEasingCurve(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QEasingCurve *sipCpp = SIP_NULLPTR;

    {
        ::QEasingCurve::Type a0 = QEasingCurve::Linear;

        static const char *sipKwdList[] = {
            sipName_type,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|E", sipType_QEasingCurve_Type, &a0))
        {
            sipCpp = new ::QEasingCurve(a0);

            return sipCpp;
        }
    }

    {
        const ::QEasingCurve* a0;
        int a0State = 0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J1", sipType_QEasingCurve, &a0, &a0State))
        {
            sipCpp = new ::QEasingCurve(*a0);
            sipReleaseType(const_cast< ::QEasingCurve *>(a0), sipType_QEasingCurve, a0State);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


extern "C" {static int convertTo_QEasingCurve(PyObject *, void **, int *, PyObject *);}
static int convertTo_QEasingCurve(PyObject *sipPy, void **sipCppPtrV, int *sipIsErr, PyObject *sipTransferObj)
{
    ::QEasingCurve **sipCppPtr = reinterpret_cast< ::QEasingCurve **>(sipCppPtrV);

#line 135 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtCore/qeasingcurve.sip"
// Allow a QEasingCurve::Type whenever a QEasingCurve is expected.

if (sipIsErr == NULL)
{
    if (sipCanConvertToType(sipPy, sipType_QEasingCurve, SIP_NO_CONVERTORS))
        return 1;

    if (PyObject_TypeCheck(sipPy, sipTypeAsPyTypeObject(sipType_QEasingCurve_Type)))
        return 1;

    return 0;
}

if (sipCanConvertToType(sipPy, sipType_QEasingCurve, SIP_NO_CONVERTORS))
{
    *sipCppPtr = reinterpret_cast<QEasingCurve *>(sipConvertToType(sipPy, sipType_QEasingCurve, sipTransferObj, SIP_NO_CONVERTORS, 0, sipIsErr));

    return 0;
}

*sipCppPtr = new QEasingCurve((QEasingCurve::Type)SIPLong_AsLong(sipPy));

return sipGetState(sipTransferObj);
#line 776 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQEasingCurve.cpp"
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QEasingCurve[] = {
    {(void *)slot_QEasingCurve___ne__, ne_slot},
    {(void *)slot_QEasingCurve___eq__, eq_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QEasingCurve[] = {
    {sipName_addCubicBezierSegment, meth_QEasingCurve_addCubicBezierSegment, METH_VARARGS, doc_QEasingCurve_addCubicBezierSegment},
    {sipName_addTCBSegment, meth_QEasingCurve_addTCBSegment, METH_VARARGS, doc_QEasingCurve_addTCBSegment},
    {sipName_amplitude, meth_QEasingCurve_amplitude, METH_VARARGS, doc_QEasingCurve_amplitude},
    {sipName_customType, meth_QEasingCurve_customType, METH_VARARGS, doc_QEasingCurve_customType},
    {sipName_overshoot, meth_QEasingCurve_overshoot, METH_VARARGS, doc_QEasingCurve_overshoot},
    {sipName_period, meth_QEasingCurve_period, METH_VARARGS, doc_QEasingCurve_period},
    {sipName_setAmplitude, meth_QEasingCurve_setAmplitude, METH_VARARGS, doc_QEasingCurve_setAmplitude},
    {sipName_setCustomType, meth_QEasingCurve_setCustomType, METH_VARARGS, doc_QEasingCurve_setCustomType},
    {sipName_setOvershoot, meth_QEasingCurve_setOvershoot, METH_VARARGS, doc_QEasingCurve_setOvershoot},
    {sipName_setPeriod, meth_QEasingCurve_setPeriod, METH_VARARGS, doc_QEasingCurve_setPeriod},
    {sipName_setType, meth_QEasingCurve_setType, METH_VARARGS, doc_QEasingCurve_setType},
    {sipName_swap, meth_QEasingCurve_swap, METH_VARARGS, doc_QEasingCurve_swap},
    {sipName_toCubicSpline, meth_QEasingCurve_toCubicSpline, METH_VARARGS, doc_QEasingCurve_toCubicSpline},
    {sipName_type, meth_QEasingCurve_type, METH_VARARGS, doc_QEasingCurve_type},
    {sipName_valueForProgress, meth_QEasingCurve_valueForProgress, METH_VARARGS, doc_QEasingCurve_valueForProgress}
};

static sipEnumMemberDef enummembers_QEasingCurve[] = {
    {sipName_BezierSpline, static_cast<int>(::QEasingCurve::BezierSpline), 73},
    {sipName_CosineCurve, static_cast<int>(::QEasingCurve::CosineCurve), 73},
    {sipName_Custom, static_cast<int>(::QEasingCurve::Custom), 73},
    {sipName_InBack, static_cast<int>(::QEasingCurve::InBack), 73},
    {sipName_InBounce, static_cast<int>(::QEasingCurve::InBounce), 73},
    {sipName_InCirc, static_cast<int>(::QEasingCurve::InCirc), 73},
    {sipName_InCubic, static_cast<int>(::QEasingCurve::InCubic), 73},
    {sipName_InCurve, static_cast<int>(::QEasingCurve::InCurve), 73},
    {sipName_InElastic, static_cast<int>(::QEasingCurve::InElastic), 73},
    {sipName_InExpo, static_cast<int>(::QEasingCurve::InExpo), 73},
    {sipName_InOutBack, static_cast<int>(::QEasingCurve::InOutBack), 73},
    {sipName_InOutBounce, static_cast<int>(::QEasingCurve::InOutBounce), 73},
    {sipName_InOutCirc, static_cast<int>(::QEasingCurve::InOutCirc), 73},
    {sipName_InOutCubic, static_cast<int>(::QEasingCurve::InOutCubic), 73},
    {sipName_InOutElastic, static_cast<int>(::QEasingCurve::InOutElastic), 73},
    {sipName_InOutExpo, static_cast<int>(::QEasingCurve::InOutExpo), 73},
    {sipName_InOutQuad, static_cast<int>(::QEasingCurve::InOutQuad), 73},
    {sipName_InOutQuart, static_cast<int>(::QEasingCurve::InOutQuart), 73},
    {sipName_InOutQuint, static_cast<int>(::QEasingCurve::InOutQuint), 73},
    {sipName_InOutSine, static_cast<int>(::QEasingCurve::InOutSine), 73},
    {sipName_InQuad, static_cast<int>(::QEasingCurve::InQuad), 73},
    {sipName_InQuart, static_cast<int>(::QEasingCurve::InQuart), 73},
    {sipName_InQuint, static_cast<int>(::QEasingCurve::InQuint), 73},
    {sipName_InSine, static_cast<int>(::QEasingCurve::InSine), 73},
    {sipName_Linear, static_cast<int>(::QEasingCurve::Linear), 73},
    {sipName_OutBack, static_cast<int>(::QEasingCurve::OutBack), 73},
    {sipName_OutBounce, static_cast<int>(::QEasingCurve::OutBounce), 73},
    {sipName_OutCirc, static_cast<int>(::QEasingCurve::OutCirc), 73},
    {sipName_OutCubic, static_cast<int>(::QEasingCurve::OutCubic), 73},
    {sipName_OutCurve, static_cast<int>(::QEasingCurve::OutCurve), 73},
    {sipName_OutElastic, static_cast<int>(::QEasingCurve::OutElastic), 73},
    {sipName_OutExpo, static_cast<int>(::QEasingCurve::OutExpo), 73},
    {sipName_OutInBack, static_cast<int>(::QEasingCurve::OutInBack), 73},
    {sipName_OutInBounce, static_cast<int>(::QEasingCurve::OutInBounce), 73},
    {sipName_OutInCirc, static_cast<int>(::QEasingCurve::OutInCirc), 73},
    {sipName_OutInCubic, static_cast<int>(::QEasingCurve::OutInCubic), 73},
    {sipName_OutInElastic, static_cast<int>(::QEasingCurve::OutInElastic), 73},
    {sipName_OutInExpo, static_cast<int>(::QEasingCurve::OutInExpo), 73},
    {sipName_OutInQuad, static_cast<int>(::QEasingCurve::OutInQuad), 73},
    {sipName_OutInQuart, static_cast<int>(::QEasingCurve::OutInQuart), 73},
    {sipName_OutInQuint, static_cast<int>(::QEasingCurve::OutInQuint), 73},
    {sipName_OutInSine, static_cast<int>(::QEasingCurve::OutInSine), 73},
    {sipName_OutQuad, static_cast<int>(::QEasingCurve::OutQuad), 73},
    {sipName_OutQuart, static_cast<int>(::QEasingCurve::OutQuart), 73},
    {sipName_OutQuint, static_cast<int>(::QEasingCurve::OutQuint), 73},
    {sipName_OutSine, static_cast<int>(::QEasingCurve::OutSine), 73},
    {sipName_SineCurve, static_cast<int>(::QEasingCurve::SineCurve), 73},
    {sipName_TCBSpline, static_cast<int>(::QEasingCurve::TCBSpline), 73},
};

PyDoc_STRVAR(doc_QEasingCurve, "\1QEasingCurve(type: QEasingCurve.Type = QEasingCurve.Linear)\n"
"QEasingCurve(other: QEasingCurve|QEasingCurve.Type)");


static pyqt5ClassPluginDef plugin_QEasingCurve = {
    SIP_NULLPTR,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef_QtCore_QEasingCurve = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QEasingCurve,
        SIP_NULLPTR,
        &plugin_QEasingCurve,
    },
    {
        sipNameNr_QEasingCurve,
        {0, 0, 1},
        15, methods_QEasingCurve,
        48, enummembers_QEasingCurve,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QEasingCurve,
    -1,
    sipNameNr_sip_simplewrapper,
    SIP_NULLPTR,
    slots_QEasingCurve,
    init_type_QEasingCurve,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QEasingCurve,
    assign_QEasingCurve,
    array_QEasingCurve,
    copy_QEasingCurve,
    release_QEasingCurve,
    SIP_NULLPTR,
    convertTo_QEasingCurve,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QEasingCurve,
    sizeof (::QEasingCurve),
};
