/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.1
 *
 * Copyright (c) 2024 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt5.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtGui.h"

#line 30 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtGui/qvector3d.sip"
#include <qvector3d.h>
#line 29 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQVector3D.cpp"

#line 26 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtCore/qpoint.sip"
#include <qpoint.h>
#line 33 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQVector3D.cpp"
#line 98 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtCore/qpoint.sip"
#include <qpoint.h>
#line 36 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQVector3D.cpp"
#line 30 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtGui/qvector2d.sip"
#include <qvector2d.h>
#line 39 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQVector3D.cpp"
#line 30 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtGui/qvector4d.sip"
#include <qvector4d.h>
#line 42 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQVector3D.cpp"
#line 30 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtGui/qmatrix4x4.sip"
#include <qmatrix4x4.h>
#line 45 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQVector3D.cpp"
#line 26 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtCore/qrect.sip"
#include <qrect.h>
#line 48 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQVector3D.cpp"


PyDoc_STRVAR(doc_QVector3D_length, "length(self) -> float");

extern "C" {static PyObject *meth_QVector3D_length(PyObject *, PyObject *);}
static PyObject *meth_QVector3D_length(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVector3D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVector3D, &sipCpp))
        {
            float sipRes;

            sipRes = sipCpp->length();

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector3D, sipName_length, doc_QVector3D_length);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVector3D_lengthSquared, "lengthSquared(self) -> float");

extern "C" {static PyObject *meth_QVector3D_lengthSquared(PyObject *, PyObject *);}
static PyObject *meth_QVector3D_lengthSquared(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVector3D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVector3D, &sipCpp))
        {
            float sipRes;

            sipRes = sipCpp->lengthSquared();

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector3D, sipName_lengthSquared, doc_QVector3D_lengthSquared);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVector3D_normalized, "normalized(self) -> QVector3D");

extern "C" {static PyObject *meth_QVector3D_normalized(PyObject *, PyObject *);}
static PyObject *meth_QVector3D_normalized(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVector3D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVector3D, &sipCpp))
        {
            ::QVector3D*sipRes;

            sipRes = new ::QVector3D(sipCpp->normalized());

            return sipConvertFromNewType(sipRes, sipType_QVector3D, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector3D, sipName_normalized, doc_QVector3D_normalized);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVector3D_normalize, "normalize(self)");

extern "C" {static PyObject *meth_QVector3D_normalize(PyObject *, PyObject *);}
static PyObject *meth_QVector3D_normalize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QVector3D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVector3D, &sipCpp))
        {
            sipCpp->normalize();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector3D, sipName_normalize, doc_QVector3D_normalize);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVector3D_dotProduct, "dotProduct(v1: QVector3D, v2: QVector3D) -> float");

extern "C" {static PyObject *meth_QVector3D_dotProduct(PyObject *, PyObject *);}
static PyObject *meth_QVector3D_dotProduct(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVector3D* a0;
        const ::QVector3D* a1;

        if (sipParseArgs(&sipParseErr, sipArgs, "J9J9", sipType_QVector3D, &a0, sipType_QVector3D, &a1))
        {
            float sipRes;

            sipRes = ::QVector3D::dotProduct(*a0, *a1);

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector3D, sipName_dotProduct, doc_QVector3D_dotProduct);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVector3D_crossProduct, "crossProduct(v1: QVector3D, v2: QVector3D) -> QVector3D");

extern "C" {static PyObject *meth_QVector3D_crossProduct(PyObject *, PyObject *);}
static PyObject *meth_QVector3D_crossProduct(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVector3D* a0;
        const ::QVector3D* a1;

        if (sipParseArgs(&sipParseErr, sipArgs, "J9J9", sipType_QVector3D, &a0, sipType_QVector3D, &a1))
        {
            ::QVector3D*sipRes;

            sipRes = new ::QVector3D(::QVector3D::crossProduct(*a0, *a1));

            return sipConvertFromNewType(sipRes, sipType_QVector3D, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector3D, sipName_crossProduct, doc_QVector3D_crossProduct);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVector3D_normal, "normal(v1: QVector3D, v2: QVector3D) -> QVector3D\n"
"normal(v1: QVector3D, v2: QVector3D, v3: QVector3D) -> QVector3D");

extern "C" {static PyObject *meth_QVector3D_normal(PyObject *, PyObject *);}
static PyObject *meth_QVector3D_normal(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVector3D* a0;
        const ::QVector3D* a1;

        if (sipParseArgs(&sipParseErr, sipArgs, "J9J9", sipType_QVector3D, &a0, sipType_QVector3D, &a1))
        {
            ::QVector3D*sipRes;

            sipRes = new ::QVector3D(::QVector3D::normal(*a0, *a1));

            return sipConvertFromNewType(sipRes, sipType_QVector3D, SIP_NULLPTR);
        }
    }

    {
        const ::QVector3D* a0;
        const ::QVector3D* a1;
        const ::QVector3D* a2;

        if (sipParseArgs(&sipParseErr, sipArgs, "J9J9J9", sipType_QVector3D, &a0, sipType_QVector3D, &a1, sipType_QVector3D, &a2))
        {
            ::QVector3D*sipRes;

            sipRes = new ::QVector3D(::QVector3D::normal(*a0, *a1, *a2));

            return sipConvertFromNewType(sipRes, sipType_QVector3D, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector3D, sipName_normal, doc_QVector3D_normal);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVector3D_distanceToPlane, "distanceToPlane(self, plane: QVector3D, normal: QVector3D) -> float\n"
"distanceToPlane(self, plane1: QVector3D, plane2: QVector3D, plane3: QVector3D) -> float");

extern "C" {static PyObject *meth_QVector3D_distanceToPlane(PyObject *, PyObject *);}
static PyObject *meth_QVector3D_distanceToPlane(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVector3D* a0;
        const ::QVector3D* a1;
        const ::QVector3D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9J9", &sipSelf, sipType_QVector3D, &sipCpp, sipType_QVector3D, &a0, sipType_QVector3D, &a1))
        {
            float sipRes;

            sipRes = sipCpp->distanceToPlane(*a0, *a1);

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    {
        const ::QVector3D* a0;
        const ::QVector3D* a1;
        const ::QVector3D* a2;
        const ::QVector3D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9J9J9", &sipSelf, sipType_QVector3D, &sipCpp, sipType_QVector3D, &a0, sipType_QVector3D, &a1, sipType_QVector3D, &a2))
        {
            float sipRes;

            sipRes = sipCpp->distanceToPlane(*a0, *a1, *a2);

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector3D, sipName_distanceToPlane, doc_QVector3D_distanceToPlane);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVector3D_distanceToLine, "distanceToLine(self, point: QVector3D, direction: QVector3D) -> float");

extern "C" {static PyObject *meth_QVector3D_distanceToLine(PyObject *, PyObject *);}
static PyObject *meth_QVector3D_distanceToLine(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVector3D* a0;
        const ::QVector3D* a1;
        const ::QVector3D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9J9", &sipSelf, sipType_QVector3D, &sipCpp, sipType_QVector3D, &a0, sipType_QVector3D, &a1))
        {
            float sipRes;

            sipRes = sipCpp->distanceToLine(*a0, *a1);

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector3D, sipName_distanceToLine, doc_QVector3D_distanceToLine);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVector3D_toVector2D, "toVector2D(self) -> QVector2D");

extern "C" {static PyObject *meth_QVector3D_toVector2D(PyObject *, PyObject *);}
static PyObject *meth_QVector3D_toVector2D(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVector3D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVector3D, &sipCpp))
        {
            ::QVector2D*sipRes;

            sipRes = new ::QVector2D(sipCpp->toVector2D());

            return sipConvertFromNewType(sipRes, sipType_QVector2D, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector3D, sipName_toVector2D, doc_QVector3D_toVector2D);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVector3D_toVector4D, "toVector4D(self) -> QVector4D");

extern "C" {static PyObject *meth_QVector3D_toVector4D(PyObject *, PyObject *);}
static PyObject *meth_QVector3D_toVector4D(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVector3D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVector3D, &sipCpp))
        {
            ::QVector4D*sipRes;

            sipRes = new ::QVector4D(sipCpp->toVector4D());

            return sipConvertFromNewType(sipRes, sipType_QVector4D, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector3D, sipName_toVector4D, doc_QVector3D_toVector4D);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVector3D_isNull, "isNull(self) -> bool");

extern "C" {static PyObject *meth_QVector3D_isNull(PyObject *, PyObject *);}
static PyObject *meth_QVector3D_isNull(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVector3D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVector3D, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isNull();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector3D, sipName_isNull, doc_QVector3D_isNull);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVector3D_x, "x(self) -> float");

extern "C" {static PyObject *meth_QVector3D_x(PyObject *, PyObject *);}
static PyObject *meth_QVector3D_x(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVector3D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVector3D, &sipCpp))
        {
            float sipRes;

            sipRes = sipCpp->x();

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector3D, sipName_x, doc_QVector3D_x);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVector3D_y, "y(self) -> float");

extern "C" {static PyObject *meth_QVector3D_y(PyObject *, PyObject *);}
static PyObject *meth_QVector3D_y(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVector3D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVector3D, &sipCpp))
        {
            float sipRes;

            sipRes = sipCpp->y();

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector3D, sipName_y, doc_QVector3D_y);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVector3D_z, "z(self) -> float");

extern "C" {static PyObject *meth_QVector3D_z(PyObject *, PyObject *);}
static PyObject *meth_QVector3D_z(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVector3D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVector3D, &sipCpp))
        {
            float sipRes;

            sipRes = sipCpp->z();

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector3D, sipName_z, doc_QVector3D_z);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVector3D_setX, "setX(self, aX: float)");

extern "C" {static PyObject *meth_QVector3D_setX(PyObject *, PyObject *);}
static PyObject *meth_QVector3D_setX(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        float a0;
        ::QVector3D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bf", &sipSelf, sipType_QVector3D, &sipCpp, &a0))
        {
            sipCpp->setX(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector3D, sipName_setX, doc_QVector3D_setX);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVector3D_setY, "setY(self, aY: float)");

extern "C" {static PyObject *meth_QVector3D_setY(PyObject *, PyObject *);}
static PyObject *meth_QVector3D_setY(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        float a0;
        ::QVector3D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bf", &sipSelf, sipType_QVector3D, &sipCpp, &a0))
        {
            sipCpp->setY(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector3D, sipName_setY, doc_QVector3D_setY);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVector3D_setZ, "setZ(self, aZ: float)");

extern "C" {static PyObject *meth_QVector3D_setZ(PyObject *, PyObject *);}
static PyObject *meth_QVector3D_setZ(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        float a0;
        ::QVector3D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bf", &sipSelf, sipType_QVector3D, &sipCpp, &a0))
        {
            sipCpp->setZ(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector3D, sipName_setZ, doc_QVector3D_setZ);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVector3D_toPoint, "toPoint(self) -> QPoint");

extern "C" {static PyObject *meth_QVector3D_toPoint(PyObject *, PyObject *);}
static PyObject *meth_QVector3D_toPoint(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVector3D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVector3D, &sipCpp))
        {
            ::QPoint*sipRes;

            sipRes = new ::QPoint(sipCpp->toPoint());

            return sipConvertFromNewType(sipRes, sipType_QPoint, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector3D, sipName_toPoint, doc_QVector3D_toPoint);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVector3D_toPointF, "toPointF(self) -> QPointF");

extern "C" {static PyObject *meth_QVector3D_toPointF(PyObject *, PyObject *);}
static PyObject *meth_QVector3D_toPointF(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVector3D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVector3D, &sipCpp))
        {
            ::QPointF*sipRes;

            sipRes = new ::QPointF(sipCpp->toPointF());

            return sipConvertFromNewType(sipRes, sipType_QPointF, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector3D, sipName_toPointF, doc_QVector3D_toPointF);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVector3D_distanceToPoint, "distanceToPoint(self, point: QVector3D) -> float");

extern "C" {static PyObject *meth_QVector3D_distanceToPoint(PyObject *, PyObject *);}
static PyObject *meth_QVector3D_distanceToPoint(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVector3D* a0;
        const ::QVector3D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QVector3D, &sipCpp, sipType_QVector3D, &a0))
        {
            float sipRes;

            sipRes = sipCpp->distanceToPoint(*a0);

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector3D, sipName_distanceToPoint, doc_QVector3D_distanceToPoint);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVector3D_project, "project(self, modelView: QMatrix4x4, projection: QMatrix4x4, viewport: QRect) -> QVector3D");

extern "C" {static PyObject *meth_QVector3D_project(PyObject *, PyObject *);}
static PyObject *meth_QVector3D_project(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QMatrix4x4* a0;
        const ::QMatrix4x4* a1;
        const ::QRect* a2;
        const ::QVector3D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9J9J9", &sipSelf, sipType_QVector3D, &sipCpp, sipType_QMatrix4x4, &a0, sipType_QMatrix4x4, &a1, sipType_QRect, &a2))
        {
            ::QVector3D*sipRes;

            sipRes = new ::QVector3D(sipCpp->project(*a0, *a1, *a2));

            return sipConvertFromNewType(sipRes, sipType_QVector3D, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector3D, sipName_project, doc_QVector3D_project);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVector3D_unproject, "unproject(self, modelView: QMatrix4x4, projection: QMatrix4x4, viewport: QRect) -> QVector3D");

extern "C" {static PyObject *meth_QVector3D_unproject(PyObject *, PyObject *);}
static PyObject *meth_QVector3D_unproject(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QMatrix4x4* a0;
        const ::QMatrix4x4* a1;
        const ::QRect* a2;
        const ::QVector3D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9J9J9", &sipSelf, sipType_QVector3D, &sipCpp, sipType_QMatrix4x4, &a0, sipType_QMatrix4x4, &a1, sipType_QRect, &a2))
        {
            ::QVector3D*sipRes;

            sipRes = new ::QVector3D(sipCpp->unproject(*a0, *a1, *a2));

            return sipConvertFromNewType(sipRes, sipType_QVector3D, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector3D, sipName_unproject, doc_QVector3D_unproject);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_QVector3D___eq__(PyObject *, PyObject *);}
static PyObject *slot_QVector3D___eq__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QVector3D *sipCpp = reinterpret_cast< ::QVector3D *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QVector3D));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVector3D* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QVector3D, &a0))
        {
            bool sipRes;

            sipRes = operator==((*sipCpp), *a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtGui, eq_slot, sipType_QVector3D, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QVector3D___ne__(PyObject *, PyObject *);}
static PyObject *slot_QVector3D___ne__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QVector3D *sipCpp = reinterpret_cast< ::QVector3D *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QVector3D));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVector3D* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QVector3D, &a0))
        {
            bool sipRes;

            sipRes = operator!=((*sipCpp), *a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtGui, ne_slot, sipType_QVector3D, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QVector3D___truediv__(PyObject *, PyObject *);}
static PyObject *slot_QVector3D___truediv__(PyObject *sipArg0, PyObject *sipArg1)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVector3D* a0;
        float a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9f", sipType_QVector3D, &a0, &a1))
        {
            ::QVector3D*sipRes;

            sipRes = new ::QVector3D((*a0 / a1));

            return sipConvertFromNewType(sipRes, sipType_QVector3D, SIP_NULLPTR);
        }
    }

    {
        const ::QVector3D* a0;
        const ::QVector3D* a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9J9", sipType_QVector3D, &a0, sipType_QVector3D, &a1))
        {
            ::QVector3D*sipRes;

            sipRes = new ::QVector3D((*a0 / *a1));

            return sipConvertFromNewType(sipRes, sipType_QVector3D, SIP_NULLPTR);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtGui, truediv_slot, SIP_NULLPTR, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_QVector3D___add__(PyObject *, PyObject *);}
static PyObject *slot_QVector3D___add__(PyObject *sipArg0, PyObject *sipArg1)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVector3D* a0;
        const ::QVector3D* a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9J9", sipType_QVector3D, &a0, sipType_QVector3D, &a1))
        {
            ::QVector3D*sipRes;

            sipRes = new ::QVector3D((*a0 + *a1));

            return sipConvertFromNewType(sipRes, sipType_QVector3D, SIP_NULLPTR);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtGui, add_slot, SIP_NULLPTR, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_QVector3D___sub__(PyObject *, PyObject *);}
static PyObject *slot_QVector3D___sub__(PyObject *sipArg0, PyObject *sipArg1)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVector3D* a0;
        const ::QVector3D* a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9J9", sipType_QVector3D, &a0, sipType_QVector3D, &a1))
        {
            ::QVector3D*sipRes;

            sipRes = new ::QVector3D((*a0 - *a1));

            return sipConvertFromNewType(sipRes, sipType_QVector3D, SIP_NULLPTR);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtGui, sub_slot, SIP_NULLPTR, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_QVector3D___mul__(PyObject *, PyObject *);}
static PyObject *slot_QVector3D___mul__(PyObject *sipArg0, PyObject *sipArg1)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVector3D* a0;
        const ::QMatrix4x4* a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9J9", sipType_QVector3D, &a0, sipType_QMatrix4x4, &a1))
        {
            ::QVector3D*sipRes;

            sipRes = new ::QVector3D((*a0 * *a1));

            return sipConvertFromNewType(sipRes, sipType_QVector3D, SIP_NULLPTR);
        }
    }

    {
        float a0;
        const ::QVector3D* a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "fJ9", &a0, sipType_QVector3D, &a1))
        {
            ::QVector3D*sipRes;

            sipRes = new ::QVector3D((a0 * *a1));

            return sipConvertFromNewType(sipRes, sipType_QVector3D, SIP_NULLPTR);
        }
    }

    {
        const ::QVector3D* a0;
        float a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9f", sipType_QVector3D, &a0, &a1))
        {
            ::QVector3D*sipRes;

            sipRes = new ::QVector3D((*a0 * a1));

            return sipConvertFromNewType(sipRes, sipType_QVector3D, SIP_NULLPTR);
        }
    }

    {
        const ::QVector3D* a0;
        const ::QVector3D* a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9J9", sipType_QVector3D, &a0, sipType_QVector3D, &a1))
        {
            ::QVector3D*sipRes;

            sipRes = new ::QVector3D((*a0 * *a1));

            return sipConvertFromNewType(sipRes, sipType_QVector3D, SIP_NULLPTR);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtGui, mul_slot, SIP_NULLPTR, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_QVector3D___neg__(PyObject *);}
static PyObject *slot_QVector3D___neg__(PyObject *sipSelf)
{
    ::QVector3D *sipCpp = reinterpret_cast< ::QVector3D *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QVector3D));

    if (!sipCpp)
        return SIP_NULLPTR;


    {
        {
            ::QVector3D*sipRes;

            sipRes = new ::QVector3D(-(*sipCpp));

            return sipConvertFromNewType(sipRes, sipType_QVector3D, SIP_NULLPTR);
        }
    }

    return 0;
}


extern "C" {static PyObject *slot_QVector3D___getitem__(PyObject *, PyObject *);}
static PyObject *slot_QVector3D___getitem__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QVector3D *sipCpp = reinterpret_cast< ::QVector3D *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QVector3D));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1i", &a0))
        {
            float sipRes;

            sipRes = (*sipCpp)[a0];

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector3D, sipName___getitem__, SIP_NULLPTR);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_QVector3D___itruediv__(PyObject *, PyObject *);}
static PyObject *slot_QVector3D___itruediv__(PyObject *sipSelf, PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_QVector3D)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    ::QVector3D *sipCpp = reinterpret_cast< ::QVector3D *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QVector3D));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        float a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1f", &a0))
        {
            sipCpp->::QVector3D::operator/=(a0);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    {
        const ::QVector3D* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QVector3D, &a0))
        {
            sipCpp->::QVector3D::operator/=(*a0);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_QVector3D___imul__(PyObject *, PyObject *);}
static PyObject *slot_QVector3D___imul__(PyObject *sipSelf, PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_QVector3D)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    ::QVector3D *sipCpp = reinterpret_cast< ::QVector3D *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QVector3D));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        float a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1f", &a0))
        {
            sipCpp->::QVector3D::operator*=(a0);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    {
        const ::QVector3D* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QVector3D, &a0))
        {
            sipCpp->::QVector3D::operator*=(*a0);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_QVector3D___isub__(PyObject *, PyObject *);}
static PyObject *slot_QVector3D___isub__(PyObject *sipSelf, PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_QVector3D)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    ::QVector3D *sipCpp = reinterpret_cast< ::QVector3D *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QVector3D));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVector3D* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QVector3D, &a0))
        {
            sipCpp->::QVector3D::operator-=(*a0);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_QVector3D___iadd__(PyObject *, PyObject *);}
static PyObject *slot_QVector3D___iadd__(PyObject *sipSelf, PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_QVector3D)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    ::QVector3D *sipCpp = reinterpret_cast< ::QVector3D *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QVector3D));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVector3D* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QVector3D, &a0))
        {
            sipCpp->::QVector3D::operator+=(*a0);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_QVector3D___repr__(PyObject *);}
static PyObject *slot_QVector3D___repr__(PyObject *sipSelf)
{
    ::QVector3D *sipCpp = reinterpret_cast< ::QVector3D *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QVector3D));

    if (!sipCpp)
        return SIP_NULLPTR;


    {
        {
            PyObject * sipRes = SIP_NULLPTR;

#line 48 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtGui/qvector3d.sip"
        PyObject *x = PyFloat_FromDouble(sipCpp->x());
        PyObject *y = PyFloat_FromDouble(sipCpp->y());
        PyObject *z = PyFloat_FromDouble(sipCpp->z());
        
        if (x && y && z)
        {
        #if PY_MAJOR_VERSION >= 3
            sipRes = PyUnicode_FromFormat("PyQt5.QtGui.QVector3D(%R, %R, %R)", x, y,
                    z);
        #else
            sipRes = PyString_FromString("PyQt5.QtGui.QVector3D(");
            PyString_ConcatAndDel(&sipRes, PyObject_Repr(x));
            PyString_ConcatAndDel(&sipRes, PyString_FromString(", "));
            PyString_ConcatAndDel(&sipRes, PyObject_Repr(y));
            PyString_ConcatAndDel(&sipRes, PyString_FromString(", "));
            PyString_ConcatAndDel(&sipRes, PyObject_Repr(z));
            PyString_ConcatAndDel(&sipRes, PyString_FromString(")"));
        #endif
        }
        
        Py_XDECREF(x);
        Py_XDECREF(y);
        Py_XDECREF(z);
#line 1194 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQVector3D.cpp"

            return sipRes;
        }
    }

    return 0;
}


/* Call the instance's destructor. */
extern "C" {static void release_QVector3D(void *, int);}
static void release_QVector3D(void *sipCppV, int)
{
    delete reinterpret_cast< ::QVector3D *>(sipCppV);
}


extern "C" {static PyObject *pickle_QVector3D(void *);}
static PyObject *pickle_QVector3D(void *sipCppV)
{
    ::QVector3D *sipCpp = reinterpret_cast< ::QVector3D *>(sipCppV);
    PyObject *sipRes;

#line 34 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtGui/qvector3d.sip"
    sipRes = Py_BuildValue((char *)"ddd", (double)sipCpp->x(), (double)sipCpp->y(),
            (double)sipCpp->z());
#line 1221 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQVector3D.cpp"

    return sipRes;
}


extern "C" {static void *array_QVector3D(Py_ssize_t);}
static void *array_QVector3D(Py_ssize_t sipNrElem)
{
    return new ::QVector3D[sipNrElem];
}


extern "C" {static void array_delete_QVector3D(void *);}
static void array_delete_QVector3D(void *sipCpp)
{
    delete[] reinterpret_cast< ::QVector3D *>(sipCpp);
}


extern "C" {static void assign_QVector3D(void *, Py_ssize_t, void *);}
static void assign_QVector3D(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QVector3D *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QVector3D *>(sipSrc);
}


extern "C" {static void *copy_QVector3D(const void *, Py_ssize_t);}
static void *copy_QVector3D(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QVector3D(reinterpret_cast<const ::QVector3D *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QVector3D(sipSimpleWrapper *);}
static void dealloc_QVector3D(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QVector3D(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QVector3D(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QVector3D(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QVector3D *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            sipCpp = new ::QVector3D();

            return sipCpp;
        }
    }

    {
        float a0;
        float a1;
        float a2;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "fff", &a0, &a1, &a2))
        {
            sipCpp = new ::QVector3D(a0, a1, a2);

            return sipCpp;
        }
    }

    {
        const ::QPoint* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QPoint, &a0))
        {
            sipCpp = new ::QVector3D(*a0);

            return sipCpp;
        }
    }

    {
        const ::QPointF* a0;
        int a0State = 0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J1", sipType_QPointF, &a0, &a0State))
        {
            sipCpp = new ::QVector3D(*a0);
            sipReleaseType(const_cast< ::QPointF *>(a0), sipType_QPointF, a0State);

            return sipCpp;
        }
    }

    {
        const ::QVector2D* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QVector2D, &a0))
        {
            sipCpp = new ::QVector3D(*a0);

            return sipCpp;
        }
    }

    {
        const ::QVector2D* a0;
        float a1;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9f", sipType_QVector2D, &a0, &a1))
        {
            sipCpp = new ::QVector3D(*a0, a1);

            return sipCpp;
        }
    }

    {
        const ::QVector4D* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QVector4D, &a0))
        {
            sipCpp = new ::QVector3D(*a0);

            return sipCpp;
        }
    }

    {
        const ::QVector3D* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QVector3D, &a0))
        {
            sipCpp = new ::QVector3D(*a0);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QVector3D[] = {
    {(void *)slot_QVector3D___eq__, eq_slot},
    {(void *)slot_QVector3D___ne__, ne_slot},
    {(void *)slot_QVector3D___truediv__, truediv_slot},
    {(void *)slot_QVector3D___add__, add_slot},
    {(void *)slot_QVector3D___sub__, sub_slot},
    {(void *)slot_QVector3D___mul__, mul_slot},
    {(void *)slot_QVector3D___neg__, neg_slot},
    {(void *)slot_QVector3D___getitem__, getitem_slot},
    {(void *)slot_QVector3D___itruediv__, itruediv_slot},
    {(void *)slot_QVector3D___imul__, imul_slot},
    {(void *)slot_QVector3D___isub__, isub_slot},
    {(void *)slot_QVector3D___iadd__, iadd_slot},
    {(void *)slot_QVector3D___repr__, repr_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QVector3D[] = {
    {sipName_crossProduct, meth_QVector3D_crossProduct, METH_VARARGS, doc_QVector3D_crossProduct},
    {sipName_distanceToLine, meth_QVector3D_distanceToLine, METH_VARARGS, doc_QVector3D_distanceToLine},
    {sipName_distanceToPlane, meth_QVector3D_distanceToPlane, METH_VARARGS, doc_QVector3D_distanceToPlane},
    {sipName_distanceToPoint, meth_QVector3D_distanceToPoint, METH_VARARGS, doc_QVector3D_distanceToPoint},
    {sipName_dotProduct, meth_QVector3D_dotProduct, METH_VARARGS, doc_QVector3D_dotProduct},
    {sipName_isNull, meth_QVector3D_isNull, METH_VARARGS, doc_QVector3D_isNull},
    {sipName_length, meth_QVector3D_length, METH_VARARGS, doc_QVector3D_length},
    {sipName_lengthSquared, meth_QVector3D_lengthSquared, METH_VARARGS, doc_QVector3D_lengthSquared},
    {sipName_normal, meth_QVector3D_normal, METH_VARARGS, doc_QVector3D_normal},
    {sipName_normalize, meth_QVector3D_normalize, METH_VARARGS, doc_QVector3D_normalize},
    {sipName_normalized, meth_QVector3D_normalized, METH_VARARGS, doc_QVector3D_normalized},
    {sipName_project, meth_QVector3D_project, METH_VARARGS, doc_QVector3D_project},
    {sipName_setX, meth_QVector3D_setX, METH_VARARGS, doc_QVector3D_setX},
    {sipName_setY, meth_QVector3D_setY, METH_VARARGS, doc_QVector3D_setY},
    {sipName_setZ, meth_QVector3D_setZ, METH_VARARGS, doc_QVector3D_setZ},
    {sipName_toPoint, meth_QVector3D_toPoint, METH_VARARGS, doc_QVector3D_toPoint},
    {sipName_toPointF, meth_QVector3D_toPointF, METH_VARARGS, doc_QVector3D_toPointF},
    {sipName_toVector2D, meth_QVector3D_toVector2D, METH_VARARGS, doc_QVector3D_toVector2D},
    {sipName_toVector4D, meth_QVector3D_toVector4D, METH_VARARGS, doc_QVector3D_toVector4D},
    {sipName_unproject, meth_QVector3D_unproject, METH_VARARGS, doc_QVector3D_unproject},
    {sipName_x, meth_QVector3D_x, METH_VARARGS, doc_QVector3D_x},
    {sipName_y, meth_QVector3D_y, METH_VARARGS, doc_QVector3D_y},
    {sipName_z, meth_QVector3D_z, METH_VARARGS, doc_QVector3D_z}
};

PyDoc_STRVAR(doc_QVector3D, "\1QVector3D()\n"
"QVector3D(xpos: float, ypos: float, zpos: float)\n"
"QVector3D(point: QPoint)\n"
"QVector3D(point: QPointF|QPoint)\n"
"QVector3D(vector: QVector2D)\n"
"QVector3D(vector: QVector2D, zpos: float)\n"
"QVector3D(vector: QVector4D)\n"
"QVector3D(a0: QVector3D)");


static pyqt5ClassPluginDef plugin_QVector3D = {
    SIP_NULLPTR,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef_QtGui_QVector3D = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QVector3D,
        SIP_NULLPTR,
        &plugin_QVector3D,
    },
    {
        sipNameNr_QVector3D,
        {0, 0, 1},
        23, methods_QVector3D,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QVector3D,
    -1,
    sipNameNr_sip_simplewrapper,
    SIP_NULLPTR,
    slots_QVector3D,
    init_type_QVector3D,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QVector3D,
    assign_QVector3D,
    array_QVector3D,
    copy_QVector3D,
    release_QVector3D,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    pickle_QVector3D,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QVector3D,
    sizeof (::QVector3D),
};
