/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.1
 *
 * Copyright (c) 2024 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt5.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtMultimedia.h"

#line 26 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtMultimedia/qaudioformat.sip"
#include <qaudioformat.h>
#line 29 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtMultimedia/sipQtMultimediaQAudioFormat.cpp"

#line 27 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtCore/qstring.sip"
#include <qstring.h>
#line 33 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtMultimedia/sipQtMultimediaQAudioFormat.cpp"


PyDoc_STRVAR(doc_QAudioFormat_isValid, "isValid(self) -> bool");

extern "C" {static PyObject *meth_QAudioFormat_isValid(PyObject *, PyObject *);}
static PyObject *meth_QAudioFormat_isValid(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QAudioFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QAudioFormat, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isValid();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QAudioFormat, sipName_isValid, doc_QAudioFormat_isValid);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QAudioFormat_setSampleSize, "setSampleSize(self, sampleSize: int)");

extern "C" {static PyObject *meth_QAudioFormat_setSampleSize(PyObject *, PyObject *);}
static PyObject *meth_QAudioFormat_setSampleSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        ::QAudioFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QAudioFormat, &sipCpp, &a0))
        {
            sipCpp->setSampleSize(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QAudioFormat, sipName_setSampleSize, doc_QAudioFormat_setSampleSize);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QAudioFormat_sampleSize, "sampleSize(self) -> int");

extern "C" {static PyObject *meth_QAudioFormat_sampleSize(PyObject *, PyObject *);}
static PyObject *meth_QAudioFormat_sampleSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QAudioFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QAudioFormat, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->sampleSize();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QAudioFormat, sipName_sampleSize, doc_QAudioFormat_sampleSize);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QAudioFormat_setCodec, "setCodec(self, codec: str|None)");

extern "C" {static PyObject *meth_QAudioFormat_setCodec(PyObject *, PyObject *);}
static PyObject *meth_QAudioFormat_setCodec(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        ::QAudioFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QAudioFormat, &sipCpp, sipType_QString, &a0, &a0State))
        {
            sipCpp->setCodec(*a0);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QAudioFormat, sipName_setCodec, doc_QAudioFormat_setCodec);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QAudioFormat_codec, "codec(self) -> str");

extern "C" {static PyObject *meth_QAudioFormat_codec(PyObject *, PyObject *);}
static PyObject *meth_QAudioFormat_codec(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QAudioFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QAudioFormat, &sipCpp))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->codec());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QAudioFormat, sipName_codec, doc_QAudioFormat_codec);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QAudioFormat_setByteOrder, "setByteOrder(self, byteOrder: QAudioFormat.Endian)");

extern "C" {static PyObject *meth_QAudioFormat_setByteOrder(PyObject *, PyObject *);}
static PyObject *meth_QAudioFormat_setByteOrder(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QAudioFormat::Endian a0;
        ::QAudioFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BE", &sipSelf, sipType_QAudioFormat, &sipCpp, sipType_QAudioFormat_Endian, &a0))
        {
            sipCpp->setByteOrder(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QAudioFormat, sipName_setByteOrder, doc_QAudioFormat_setByteOrder);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QAudioFormat_byteOrder, "byteOrder(self) -> QAudioFormat.Endian");

extern "C" {static PyObject *meth_QAudioFormat_byteOrder(PyObject *, PyObject *);}
static PyObject *meth_QAudioFormat_byteOrder(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QAudioFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QAudioFormat, &sipCpp))
        {
            ::QAudioFormat::Endian sipRes;

            sipRes = sipCpp->byteOrder();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QAudioFormat_Endian);
        }
    }

    sipNoMethod(sipParseErr, sipName_QAudioFormat, sipName_byteOrder, doc_QAudioFormat_byteOrder);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QAudioFormat_setSampleType, "setSampleType(self, sampleType: QAudioFormat.SampleType)");

extern "C" {static PyObject *meth_QAudioFormat_setSampleType(PyObject *, PyObject *);}
static PyObject *meth_QAudioFormat_setSampleType(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QAudioFormat::SampleType a0;
        ::QAudioFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BE", &sipSelf, sipType_QAudioFormat, &sipCpp, sipType_QAudioFormat_SampleType, &a0))
        {
            sipCpp->setSampleType(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QAudioFormat, sipName_setSampleType, doc_QAudioFormat_setSampleType);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QAudioFormat_sampleType, "sampleType(self) -> QAudioFormat.SampleType");

extern "C" {static PyObject *meth_QAudioFormat_sampleType(PyObject *, PyObject *);}
static PyObject *meth_QAudioFormat_sampleType(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QAudioFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QAudioFormat, &sipCpp))
        {
            ::QAudioFormat::SampleType sipRes;

            sipRes = sipCpp->sampleType();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QAudioFormat_SampleType);
        }
    }

    sipNoMethod(sipParseErr, sipName_QAudioFormat, sipName_sampleType, doc_QAudioFormat_sampleType);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QAudioFormat_setSampleRate, "setSampleRate(self, sampleRate: int)");

extern "C" {static PyObject *meth_QAudioFormat_setSampleRate(PyObject *, PyObject *);}
static PyObject *meth_QAudioFormat_setSampleRate(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        ::QAudioFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QAudioFormat, &sipCpp, &a0))
        {
            sipCpp->setSampleRate(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QAudioFormat, sipName_setSampleRate, doc_QAudioFormat_setSampleRate);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QAudioFormat_sampleRate, "sampleRate(self) -> int");

extern "C" {static PyObject *meth_QAudioFormat_sampleRate(PyObject *, PyObject *);}
static PyObject *meth_QAudioFormat_sampleRate(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QAudioFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QAudioFormat, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->sampleRate();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QAudioFormat, sipName_sampleRate, doc_QAudioFormat_sampleRate);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QAudioFormat_setChannelCount, "setChannelCount(self, channelCount: int)");

extern "C" {static PyObject *meth_QAudioFormat_setChannelCount(PyObject *, PyObject *);}
static PyObject *meth_QAudioFormat_setChannelCount(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        ::QAudioFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QAudioFormat, &sipCpp, &a0))
        {
            sipCpp->setChannelCount(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QAudioFormat, sipName_setChannelCount, doc_QAudioFormat_setChannelCount);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QAudioFormat_channelCount, "channelCount(self) -> int");

extern "C" {static PyObject *meth_QAudioFormat_channelCount(PyObject *, PyObject *);}
static PyObject *meth_QAudioFormat_channelCount(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QAudioFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QAudioFormat, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->channelCount();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QAudioFormat, sipName_channelCount, doc_QAudioFormat_channelCount);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QAudioFormat_bytesForDuration, "bytesForDuration(self, duration: int) -> int");

extern "C" {static PyObject *meth_QAudioFormat_bytesForDuration(PyObject *, PyObject *);}
static PyObject *meth_QAudioFormat_bytesForDuration(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qint64 a0;
        const ::QAudioFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bn", &sipSelf, sipType_QAudioFormat, &sipCpp, &a0))
        {
            ::qint32 sipRes;

            sipRes = sipCpp->bytesForDuration(a0);

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QAudioFormat, sipName_bytesForDuration, doc_QAudioFormat_bytesForDuration);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QAudioFormat_durationForBytes, "durationForBytes(self, byteCount: int) -> int");

extern "C" {static PyObject *meth_QAudioFormat_durationForBytes(PyObject *, PyObject *);}
static PyObject *meth_QAudioFormat_durationForBytes(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qint32 a0;
        const ::QAudioFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QAudioFormat, &sipCpp, &a0))
        {
            ::qint64 sipRes;

            sipRes = sipCpp->durationForBytes(a0);

            return PyLong_FromLongLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QAudioFormat, sipName_durationForBytes, doc_QAudioFormat_durationForBytes);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QAudioFormat_bytesForFrames, "bytesForFrames(self, frameCount: int) -> int");

extern "C" {static PyObject *meth_QAudioFormat_bytesForFrames(PyObject *, PyObject *);}
static PyObject *meth_QAudioFormat_bytesForFrames(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qint32 a0;
        const ::QAudioFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QAudioFormat, &sipCpp, &a0))
        {
            ::qint32 sipRes;

            sipRes = sipCpp->bytesForFrames(a0);

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QAudioFormat, sipName_bytesForFrames, doc_QAudioFormat_bytesForFrames);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QAudioFormat_framesForBytes, "framesForBytes(self, byteCount: int) -> int");

extern "C" {static PyObject *meth_QAudioFormat_framesForBytes(PyObject *, PyObject *);}
static PyObject *meth_QAudioFormat_framesForBytes(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qint32 a0;
        const ::QAudioFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QAudioFormat, &sipCpp, &a0))
        {
            ::qint32 sipRes;

            sipRes = sipCpp->framesForBytes(a0);

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QAudioFormat, sipName_framesForBytes, doc_QAudioFormat_framesForBytes);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QAudioFormat_framesForDuration, "framesForDuration(self, duration: int) -> int");

extern "C" {static PyObject *meth_QAudioFormat_framesForDuration(PyObject *, PyObject *);}
static PyObject *meth_QAudioFormat_framesForDuration(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qint64 a0;
        const ::QAudioFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bn", &sipSelf, sipType_QAudioFormat, &sipCpp, &a0))
        {
            ::qint32 sipRes;

            sipRes = sipCpp->framesForDuration(a0);

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QAudioFormat, sipName_framesForDuration, doc_QAudioFormat_framesForDuration);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QAudioFormat_durationForFrames, "durationForFrames(self, frameCount: int) -> int");

extern "C" {static PyObject *meth_QAudioFormat_durationForFrames(PyObject *, PyObject *);}
static PyObject *meth_QAudioFormat_durationForFrames(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qint32 a0;
        const ::QAudioFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QAudioFormat, &sipCpp, &a0))
        {
            ::qint64 sipRes;

            sipRes = sipCpp->durationForFrames(a0);

            return PyLong_FromLongLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QAudioFormat, sipName_durationForFrames, doc_QAudioFormat_durationForFrames);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QAudioFormat_bytesPerFrame, "bytesPerFrame(self) -> int");

extern "C" {static PyObject *meth_QAudioFormat_bytesPerFrame(PyObject *, PyObject *);}
static PyObject *meth_QAudioFormat_bytesPerFrame(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QAudioFormat *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QAudioFormat, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->bytesPerFrame();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QAudioFormat, sipName_bytesPerFrame, doc_QAudioFormat_bytesPerFrame);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_QAudioFormat___ne__(PyObject *, PyObject *);}
static PyObject *slot_QAudioFormat___ne__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QAudioFormat *sipCpp = reinterpret_cast< ::QAudioFormat *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QAudioFormat));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QAudioFormat* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QAudioFormat, &a0))
        {
            bool sipRes;

            sipRes = sipCpp->::QAudioFormat::operator!=(*a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtMultimedia, ne_slot, sipType_QAudioFormat, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QAudioFormat___eq__(PyObject *, PyObject *);}
static PyObject *slot_QAudioFormat___eq__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QAudioFormat *sipCpp = reinterpret_cast< ::QAudioFormat *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QAudioFormat));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QAudioFormat* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QAudioFormat, &a0))
        {
            bool sipRes;

            sipRes = sipCpp->::QAudioFormat::operator==(*a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtMultimedia, eq_slot, sipType_QAudioFormat, sipSelf, sipArg);
}


/* Call the instance's destructor. */
extern "C" {static void release_QAudioFormat(void *, int);}
static void release_QAudioFormat(void *sipCppV, int)
{
    delete reinterpret_cast< ::QAudioFormat *>(sipCppV);
}


extern "C" {static void *array_QAudioFormat(Py_ssize_t);}
static void *array_QAudioFormat(Py_ssize_t sipNrElem)
{
    return new ::QAudioFormat[sipNrElem];
}


extern "C" {static void array_delete_QAudioFormat(void *);}
static void array_delete_QAudioFormat(void *sipCpp)
{
    delete[] reinterpret_cast< ::QAudioFormat *>(sipCpp);
}


extern "C" {static void assign_QAudioFormat(void *, Py_ssize_t, void *);}
static void assign_QAudioFormat(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QAudioFormat *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QAudioFormat *>(sipSrc);
}


extern "C" {static void *copy_QAudioFormat(const void *, Py_ssize_t);}
static void *copy_QAudioFormat(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QAudioFormat(reinterpret_cast<const ::QAudioFormat *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QAudioFormat(sipSimpleWrapper *);}
static void dealloc_QAudioFormat(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QAudioFormat(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QAudioFormat(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QAudioFormat(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QAudioFormat *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            sipCpp = new ::QAudioFormat();

            return sipCpp;
        }
    }

    {
        const ::QAudioFormat* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QAudioFormat, &a0))
        {
            sipCpp = new ::QAudioFormat(*a0);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QAudioFormat[] = {
    {(void *)slot_QAudioFormat___ne__, ne_slot},
    {(void *)slot_QAudioFormat___eq__, eq_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QAudioFormat[] = {
    {sipName_byteOrder, meth_QAudioFormat_byteOrder, METH_VARARGS, doc_QAudioFormat_byteOrder},
    {sipName_bytesForDuration, meth_QAudioFormat_bytesForDuration, METH_VARARGS, doc_QAudioFormat_bytesForDuration},
    {sipName_bytesForFrames, meth_QAudioFormat_bytesForFrames, METH_VARARGS, doc_QAudioFormat_bytesForFrames},
    {sipName_bytesPerFrame, meth_QAudioFormat_bytesPerFrame, METH_VARARGS, doc_QAudioFormat_bytesPerFrame},
    {sipName_channelCount, meth_QAudioFormat_channelCount, METH_VARARGS, doc_QAudioFormat_channelCount},
    {sipName_codec, meth_QAudioFormat_codec, METH_VARARGS, doc_QAudioFormat_codec},
    {sipName_durationForBytes, meth_QAudioFormat_durationForBytes, METH_VARARGS, doc_QAudioFormat_durationForBytes},
    {sipName_durationForFrames, meth_QAudioFormat_durationForFrames, METH_VARARGS, doc_QAudioFormat_durationForFrames},
    {sipName_framesForBytes, meth_QAudioFormat_framesForBytes, METH_VARARGS, doc_QAudioFormat_framesForBytes},
    {sipName_framesForDuration, meth_QAudioFormat_framesForDuration, METH_VARARGS, doc_QAudioFormat_framesForDuration},
    {sipName_isValid, meth_QAudioFormat_isValid, METH_VARARGS, doc_QAudioFormat_isValid},
    {sipName_sampleRate, meth_QAudioFormat_sampleRate, METH_VARARGS, doc_QAudioFormat_sampleRate},
    {sipName_sampleSize, meth_QAudioFormat_sampleSize, METH_VARARGS, doc_QAudioFormat_sampleSize},
    {sipName_sampleType, meth_QAudioFormat_sampleType, METH_VARARGS, doc_QAudioFormat_sampleType},
    {sipName_setByteOrder, meth_QAudioFormat_setByteOrder, METH_VARARGS, doc_QAudioFormat_setByteOrder},
    {sipName_setChannelCount, meth_QAudioFormat_setChannelCount, METH_VARARGS, doc_QAudioFormat_setChannelCount},
    {sipName_setCodec, meth_QAudioFormat_setCodec, METH_VARARGS, doc_QAudioFormat_setCodec},
    {sipName_setSampleRate, meth_QAudioFormat_setSampleRate, METH_VARARGS, doc_QAudioFormat_setSampleRate},
    {sipName_setSampleSize, meth_QAudioFormat_setSampleSize, METH_VARARGS, doc_QAudioFormat_setSampleSize},
    {sipName_setSampleType, meth_QAudioFormat_setSampleType, METH_VARARGS, doc_QAudioFormat_setSampleType}
};

static sipEnumMemberDef enummembers_QAudioFormat[] = {
    {sipName_BigEndian, static_cast<int>(::QAudioFormat::BigEndian), 21},
    {sipName_Float, static_cast<int>(::QAudioFormat::Float), 22},
    {sipName_LittleEndian, static_cast<int>(::QAudioFormat::LittleEndian), 21},
    {sipName_SignedInt, static_cast<int>(::QAudioFormat::SignedInt), 22},
    {sipName_UnSignedInt, static_cast<int>(::QAudioFormat::UnSignedInt), 22},
    {sipName_Unknown, static_cast<int>(::QAudioFormat::Unknown), 22},
};

PyDoc_STRVAR(doc_QAudioFormat, "\1QAudioFormat()\n"
"QAudioFormat(other: QAudioFormat)");


static pyqt5ClassPluginDef plugin_QAudioFormat = {
    SIP_NULLPTR,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef_QtMultimedia_QAudioFormat = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QAudioFormat,
        SIP_NULLPTR,
        &plugin_QAudioFormat,
    },
    {
        sipNameNr_QAudioFormat,
        {0, 0, 1},
        20, methods_QAudioFormat,
        6, enummembers_QAudioFormat,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QAudioFormat,
    -1,
    sipNameNr_sip_simplewrapper,
    SIP_NULLPTR,
    slots_QAudioFormat,
    init_type_QAudioFormat,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QAudioFormat,
    assign_QAudioFormat,
    array_QAudioFormat,
    copy_QAudioFormat,
    release_QAudioFormat,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QAudioFormat,
    sizeof (::QAudioFormat),
};
