/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.1
 *
 * Copyright (c) 2024 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt5.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtNetwork.h"

#line 26 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtNetwork/qnetworkrequest.sip"
#include <qnetworkrequest.h>
#line 29 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtNetwork/sipQtNetworkQNetworkRequest.cpp"

#line 109 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtCore/qurl.sip"
#include <qurl.h>
#line 33 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtNetwork/sipQtNetworkQNetworkRequest.cpp"
#line 28 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtNetwork/qhttp2configuration.sip"
#include <qhttp2configuration.h>
#line 36 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtNetwork/sipQtNetworkQNetworkRequest.cpp"
#line 27 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtCore/qstring.sip"
#include <qstring.h>
#line 39 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtNetwork/sipQtNetworkQNetworkRequest.cpp"
#line 28 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtCore/qobject.sip"
#include <qobject.h>
#line 42 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtNetwork/sipQtNetworkQNetworkRequest.cpp"
#line 28 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtNetwork/qsslconfiguration.sip"
#include <qsslconfiguration.h>
#line 45 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtNetwork/sipQtNetworkQNetworkRequest.cpp"
#line 26 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtCore/qvariant.sip"
#include <qvariant.h>
#line 48 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtNetwork/sipQtNetworkQNetworkRequest.cpp"
#line 30 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtCore/qbytearray.sip"
#include <qbytearray.h>
#line 51 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtNetwork/sipQtNetworkQNetworkRequest.cpp"
#line 38 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 54 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtNetwork/sipQtNetworkQNetworkRequest.cpp"


PyDoc_STRVAR(doc_QNetworkRequest_url, "url(self) -> QUrl");

extern "C" {static PyObject *meth_QNetworkRequest_url(PyObject *, PyObject *);}
static PyObject *meth_QNetworkRequest_url(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QNetworkRequest *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QNetworkRequest, &sipCpp))
        {
            ::QUrl*sipRes;

            sipRes = new ::QUrl(sipCpp->url());

            return sipConvertFromNewType(sipRes, sipType_QUrl, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkRequest, sipName_url, doc_QNetworkRequest_url);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkRequest_setUrl, "setUrl(self, url: QUrl)");

extern "C" {static PyObject *meth_QNetworkRequest_setUrl(PyObject *, PyObject *);}
static PyObject *meth_QNetworkRequest_setUrl(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QUrl* a0;
        ::QNetworkRequest *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QNetworkRequest, &sipCpp, sipType_QUrl, &a0))
        {
            sipCpp->setUrl(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkRequest, sipName_setUrl, doc_QNetworkRequest_setUrl);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkRequest_header, "header(self, header: QNetworkRequest.KnownHeaders) -> Any");

extern "C" {static PyObject *meth_QNetworkRequest_header(PyObject *, PyObject *);}
static PyObject *meth_QNetworkRequest_header(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QNetworkRequest::KnownHeaders a0;
        const ::QNetworkRequest *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BE", &sipSelf, sipType_QNetworkRequest, &sipCpp, sipType_QNetworkRequest_KnownHeaders, &a0))
        {
            ::QVariant*sipRes;

            sipRes = new ::QVariant(sipCpp->header(a0));

            return sipConvertFromNewType(sipRes, sipType_QVariant, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkRequest, sipName_header, doc_QNetworkRequest_header);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkRequest_setHeader, "setHeader(self, header: QNetworkRequest.KnownHeaders, value: Any)");

extern "C" {static PyObject *meth_QNetworkRequest_setHeader(PyObject *, PyObject *);}
static PyObject *meth_QNetworkRequest_setHeader(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QNetworkRequest::KnownHeaders a0;
        const ::QVariant* a1;
        int a1State = 0;
        ::QNetworkRequest *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BEJ1", &sipSelf, sipType_QNetworkRequest, &sipCpp, sipType_QNetworkRequest_KnownHeaders, &a0, sipType_QVariant, &a1, &a1State))
        {
            sipCpp->setHeader(a0, *a1);
            sipReleaseType(const_cast< ::QVariant *>(a1), sipType_QVariant, a1State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkRequest, sipName_setHeader, doc_QNetworkRequest_setHeader);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkRequest_hasRawHeader, "hasRawHeader(self, headerName: QByteArray|bytes|bytearray) -> bool");

extern "C" {static PyObject *meth_QNetworkRequest_hasRawHeader(PyObject *, PyObject *);}
static PyObject *meth_QNetworkRequest_hasRawHeader(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QByteArray* a0;
        int a0State = 0;
        const ::QNetworkRequest *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QNetworkRequest, &sipCpp, sipType_QByteArray, &a0, &a0State))
        {
            bool sipRes;

            sipRes = sipCpp->hasRawHeader(*a0);
            sipReleaseType(const_cast< ::QByteArray *>(a0), sipType_QByteArray, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkRequest, sipName_hasRawHeader, doc_QNetworkRequest_hasRawHeader);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkRequest_rawHeaderList, "rawHeaderList(self) -> list[QByteArray]");

extern "C" {static PyObject *meth_QNetworkRequest_rawHeaderList(PyObject *, PyObject *);}
static PyObject *meth_QNetworkRequest_rawHeaderList(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QNetworkRequest *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QNetworkRequest, &sipCpp))
        {
            QList< ::QByteArray>*sipRes;

            sipRes = new QList< ::QByteArray>(sipCpp->rawHeaderList());

            return sipConvertFromNewType(sipRes, sipType_QList_0100QByteArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkRequest, sipName_rawHeaderList, doc_QNetworkRequest_rawHeaderList);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkRequest_rawHeader, "rawHeader(self, headerName: QByteArray|bytes|bytearray) -> QByteArray");

extern "C" {static PyObject *meth_QNetworkRequest_rawHeader(PyObject *, PyObject *);}
static PyObject *meth_QNetworkRequest_rawHeader(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QByteArray* a0;
        int a0State = 0;
        const ::QNetworkRequest *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QNetworkRequest, &sipCpp, sipType_QByteArray, &a0, &a0State))
        {
            ::QByteArray*sipRes;

            sipRes = new ::QByteArray(sipCpp->rawHeader(*a0));
            sipReleaseType(const_cast< ::QByteArray *>(a0), sipType_QByteArray, a0State);

            return sipConvertFromNewType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkRequest, sipName_rawHeader, doc_QNetworkRequest_rawHeader);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkRequest_setRawHeader, "setRawHeader(self, headerName: QByteArray|bytes|bytearray, value: QByteArray|bytes|bytearray)");

extern "C" {static PyObject *meth_QNetworkRequest_setRawHeader(PyObject *, PyObject *);}
static PyObject *meth_QNetworkRequest_setRawHeader(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QByteArray* a0;
        int a0State = 0;
        const ::QByteArray* a1;
        int a1State = 0;
        ::QNetworkRequest *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1J1", &sipSelf, sipType_QNetworkRequest, &sipCpp, sipType_QByteArray, &a0, &a0State, sipType_QByteArray, &a1, &a1State))
        {
            sipCpp->setRawHeader(*a0, *a1);
            sipReleaseType(const_cast< ::QByteArray *>(a0), sipType_QByteArray, a0State);
            sipReleaseType(const_cast< ::QByteArray *>(a1), sipType_QByteArray, a1State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkRequest, sipName_setRawHeader, doc_QNetworkRequest_setRawHeader);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkRequest_attribute, "attribute(self, code: QNetworkRequest.Attribute, defaultValue: Any = None) -> Any");

extern "C" {static PyObject *meth_QNetworkRequest_attribute(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QNetworkRequest_attribute(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QNetworkRequest::Attribute a0;
        const ::QVariant& a1def = QVariant();
        const ::QVariant* a1 = &a1def;
        int a1State = 0;
        const ::QNetworkRequest *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_defaultValue,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BE|J1", &sipSelf, sipType_QNetworkRequest, &sipCpp, sipType_QNetworkRequest_Attribute, &a0, sipType_QVariant, &a1, &a1State))
        {
            ::QVariant*sipRes;

            sipRes = new ::QVariant(sipCpp->attribute(a0, *a1));
            sipReleaseType(const_cast< ::QVariant *>(a1), sipType_QVariant, a1State);

            return sipConvertFromNewType(sipRes, sipType_QVariant, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkRequest, sipName_attribute, doc_QNetworkRequest_attribute);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkRequest_setAttribute, "setAttribute(self, code: QNetworkRequest.Attribute, value: Any)");

extern "C" {static PyObject *meth_QNetworkRequest_setAttribute(PyObject *, PyObject *);}
static PyObject *meth_QNetworkRequest_setAttribute(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QNetworkRequest::Attribute a0;
        const ::QVariant* a1;
        int a1State = 0;
        ::QNetworkRequest *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BEJ1", &sipSelf, sipType_QNetworkRequest, &sipCpp, sipType_QNetworkRequest_Attribute, &a0, sipType_QVariant, &a1, &a1State))
        {
            sipCpp->setAttribute(a0, *a1);
            sipReleaseType(const_cast< ::QVariant *>(a1), sipType_QVariant, a1State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkRequest, sipName_setAttribute, doc_QNetworkRequest_setAttribute);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkRequest_sslConfiguration, "sslConfiguration(self) -> QSslConfiguration");

extern "C" {static PyObject *meth_QNetworkRequest_sslConfiguration(PyObject *, PyObject *);}
static PyObject *meth_QNetworkRequest_sslConfiguration(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QNetworkRequest *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QNetworkRequest, &sipCpp))
        {
            ::QSslConfiguration*sipRes;

            sipRes = new ::QSslConfiguration(sipCpp->sslConfiguration());

            return sipConvertFromNewType(sipRes, sipType_QSslConfiguration, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkRequest, sipName_sslConfiguration, doc_QNetworkRequest_sslConfiguration);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkRequest_setSslConfiguration, "setSslConfiguration(self, configuration: QSslConfiguration)");

extern "C" {static PyObject *meth_QNetworkRequest_setSslConfiguration(PyObject *, PyObject *);}
static PyObject *meth_QNetworkRequest_setSslConfiguration(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSslConfiguration* a0;
        ::QNetworkRequest *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QNetworkRequest, &sipCpp, sipType_QSslConfiguration, &a0))
        {
            sipCpp->setSslConfiguration(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkRequest, sipName_setSslConfiguration, doc_QNetworkRequest_setSslConfiguration);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkRequest_setOriginatingObject, "setOriginatingObject(self, object: QObject|None)");

extern "C" {static PyObject *meth_QNetworkRequest_setOriginatingObject(PyObject *, PyObject *);}
static PyObject *meth_QNetworkRequest_setOriginatingObject(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QObject* a0;
        PyObject *a0Keep;
        ::QNetworkRequest *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B@J8", &sipSelf, sipType_QNetworkRequest, &sipCpp, &a0Keep, sipType_QObject, &a0))
        {
            sipCpp->setOriginatingObject(a0);

            sipKeepReference(sipSelf, -1, a0Keep);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkRequest, sipName_setOriginatingObject, doc_QNetworkRequest_setOriginatingObject);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkRequest_originatingObject, "originatingObject(self) -> QObject|None");

extern "C" {static PyObject *meth_QNetworkRequest_originatingObject(PyObject *, PyObject *);}
static PyObject *meth_QNetworkRequest_originatingObject(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QNetworkRequest *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QNetworkRequest, &sipCpp))
        {
            ::QObject*sipRes;

            sipRes = sipCpp->originatingObject();

            return sipConvertFromType(sipRes, sipType_QObject, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkRequest, sipName_originatingObject, doc_QNetworkRequest_originatingObject);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkRequest_priority, "priority(self) -> QNetworkRequest.Priority");

extern "C" {static PyObject *meth_QNetworkRequest_priority(PyObject *, PyObject *);}
static PyObject *meth_QNetworkRequest_priority(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QNetworkRequest *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QNetworkRequest, &sipCpp))
        {
            ::QNetworkRequest::Priority sipRes;

            sipRes = sipCpp->priority();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QNetworkRequest_Priority);
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkRequest, sipName_priority, doc_QNetworkRequest_priority);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkRequest_setPriority, "setPriority(self, priority: QNetworkRequest.Priority)");

extern "C" {static PyObject *meth_QNetworkRequest_setPriority(PyObject *, PyObject *);}
static PyObject *meth_QNetworkRequest_setPriority(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QNetworkRequest::Priority a0;
        ::QNetworkRequest *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BE", &sipSelf, sipType_QNetworkRequest, &sipCpp, sipType_QNetworkRequest_Priority, &a0))
        {
            sipCpp->setPriority(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkRequest, sipName_setPriority, doc_QNetworkRequest_setPriority);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkRequest_swap, "swap(self, other: QNetworkRequest)");

extern "C" {static PyObject *meth_QNetworkRequest_swap(PyObject *, PyObject *);}
static PyObject *meth_QNetworkRequest_swap(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QNetworkRequest* a0;
        ::QNetworkRequest *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QNetworkRequest, &sipCpp, sipType_QNetworkRequest, &a0))
        {
            sipCpp->swap(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkRequest, sipName_swap, doc_QNetworkRequest_swap);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkRequest_maximumRedirectsAllowed, "maximumRedirectsAllowed(self) -> int");

extern "C" {static PyObject *meth_QNetworkRequest_maximumRedirectsAllowed(PyObject *, PyObject *);}
static PyObject *meth_QNetworkRequest_maximumRedirectsAllowed(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QNetworkRequest *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QNetworkRequest, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->maximumRedirectsAllowed();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkRequest, sipName_maximumRedirectsAllowed, doc_QNetworkRequest_maximumRedirectsAllowed);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkRequest_setMaximumRedirectsAllowed, "setMaximumRedirectsAllowed(self, maximumRedirectsAllowed: int)");

extern "C" {static PyObject *meth_QNetworkRequest_setMaximumRedirectsAllowed(PyObject *, PyObject *);}
static PyObject *meth_QNetworkRequest_setMaximumRedirectsAllowed(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        ::QNetworkRequest *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QNetworkRequest, &sipCpp, &a0))
        {
            sipCpp->setMaximumRedirectsAllowed(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkRequest, sipName_setMaximumRedirectsAllowed, doc_QNetworkRequest_setMaximumRedirectsAllowed);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkRequest_peerVerifyName, "peerVerifyName(self) -> str");

extern "C" {static PyObject *meth_QNetworkRequest_peerVerifyName(PyObject *, PyObject *);}
static PyObject *meth_QNetworkRequest_peerVerifyName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QNetworkRequest *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QNetworkRequest, &sipCpp))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->peerVerifyName());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkRequest, sipName_peerVerifyName, doc_QNetworkRequest_peerVerifyName);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkRequest_setPeerVerifyName, "setPeerVerifyName(self, peerName: str|None)");

extern "C" {static PyObject *meth_QNetworkRequest_setPeerVerifyName(PyObject *, PyObject *);}
static PyObject *meth_QNetworkRequest_setPeerVerifyName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        ::QNetworkRequest *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QNetworkRequest, &sipCpp, sipType_QString, &a0, &a0State))
        {
            sipCpp->setPeerVerifyName(*a0);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkRequest, sipName_setPeerVerifyName, doc_QNetworkRequest_setPeerVerifyName);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkRequest_http2Configuration, "http2Configuration(self) -> QHttp2Configuration");

extern "C" {static PyObject *meth_QNetworkRequest_http2Configuration(PyObject *, PyObject *);}
static PyObject *meth_QNetworkRequest_http2Configuration(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QNetworkRequest *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QNetworkRequest, &sipCpp))
        {
            ::QHttp2Configuration*sipRes;

            sipRes = new ::QHttp2Configuration(sipCpp->http2Configuration());

            return sipConvertFromNewType(sipRes, sipType_QHttp2Configuration, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkRequest, sipName_http2Configuration, doc_QNetworkRequest_http2Configuration);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkRequest_setHttp2Configuration, "setHttp2Configuration(self, configuration: QHttp2Configuration)");

extern "C" {static PyObject *meth_QNetworkRequest_setHttp2Configuration(PyObject *, PyObject *);}
static PyObject *meth_QNetworkRequest_setHttp2Configuration(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QHttp2Configuration* a0;
        ::QNetworkRequest *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QNetworkRequest, &sipCpp, sipType_QHttp2Configuration, &a0))
        {
            sipCpp->setHttp2Configuration(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkRequest, sipName_setHttp2Configuration, doc_QNetworkRequest_setHttp2Configuration);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkRequest_transferTimeout, "transferTimeout(self) -> int");

extern "C" {static PyObject *meth_QNetworkRequest_transferTimeout(PyObject *, PyObject *);}
static PyObject *meth_QNetworkRequest_transferTimeout(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QNetworkRequest *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QNetworkRequest, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->transferTimeout();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkRequest, sipName_transferTimeout, doc_QNetworkRequest_transferTimeout);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QNetworkRequest_setTransferTimeout, "setTransferTimeout(self, timeout: int = QNetworkRequest.TransferTimeoutConstant.DefaultTransferTimeoutConstant)");

extern "C" {static PyObject *meth_QNetworkRequest_setTransferTimeout(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QNetworkRequest_setTransferTimeout(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0 = QNetworkRequest::TransferTimeoutConstant::DefaultTransferTimeoutConstant;
        ::QNetworkRequest *sipCpp;

        static const char *sipKwdList[] = {
            sipName_timeout,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|i", &sipSelf, sipType_QNetworkRequest, &sipCpp, &a0))
        {
            sipCpp->setTransferTimeout(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QNetworkRequest, sipName_setTransferTimeout, doc_QNetworkRequest_setTransferTimeout);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_QNetworkRequest___ne__(PyObject *, PyObject *);}
static PyObject *slot_QNetworkRequest___ne__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QNetworkRequest *sipCpp = reinterpret_cast< ::QNetworkRequest *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QNetworkRequest));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QNetworkRequest* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QNetworkRequest, &a0))
        {
            bool sipRes;

            sipRes = sipCpp->::QNetworkRequest::operator!=(*a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtNetwork, ne_slot, sipType_QNetworkRequest, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QNetworkRequest___eq__(PyObject *, PyObject *);}
static PyObject *slot_QNetworkRequest___eq__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QNetworkRequest *sipCpp = reinterpret_cast< ::QNetworkRequest *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QNetworkRequest));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QNetworkRequest* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QNetworkRequest, &a0))
        {
            bool sipRes;

            sipRes = sipCpp->::QNetworkRequest::operator==(*a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtNetwork, eq_slot, sipType_QNetworkRequest, sipSelf, sipArg);
}


/* Call the instance's destructor. */
extern "C" {static void release_QNetworkRequest(void *, int);}
static void release_QNetworkRequest(void *sipCppV, int)
{
    delete reinterpret_cast< ::QNetworkRequest *>(sipCppV);
}


extern "C" {static void *array_QNetworkRequest(Py_ssize_t);}
static void *array_QNetworkRequest(Py_ssize_t sipNrElem)
{
    return new ::QNetworkRequest[sipNrElem];
}


extern "C" {static void array_delete_QNetworkRequest(void *);}
static void array_delete_QNetworkRequest(void *sipCpp)
{
    delete[] reinterpret_cast< ::QNetworkRequest *>(sipCpp);
}


extern "C" {static void assign_QNetworkRequest(void *, Py_ssize_t, void *);}
static void assign_QNetworkRequest(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QNetworkRequest *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QNetworkRequest *>(sipSrc);
}


extern "C" {static void *copy_QNetworkRequest(const void *, Py_ssize_t);}
static void *copy_QNetworkRequest(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QNetworkRequest(reinterpret_cast<const ::QNetworkRequest *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QNetworkRequest(sipSimpleWrapper *);}
static void dealloc_QNetworkRequest(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QNetworkRequest(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QNetworkRequest(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QNetworkRequest(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QNetworkRequest *sipCpp = SIP_NULLPTR;

    {
        const ::QUrl& a0def = QUrl();
        const ::QUrl* a0 = &a0def;

        static const char *sipKwdList[] = {
            sipName_url,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|J9", sipType_QUrl, &a0))
        {
            sipCpp = new ::QNetworkRequest(*a0);

            return sipCpp;
        }
    }

    {
        const ::QNetworkRequest* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QNetworkRequest, &a0))
        {
            sipCpp = new ::QNetworkRequest(*a0);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QNetworkRequest[] = {
    {(void *)slot_QNetworkRequest___ne__, ne_slot},
    {(void *)slot_QNetworkRequest___eq__, eq_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QNetworkRequest[] = {
    {sipName_attribute, SIP_MLMETH_CAST(meth_QNetworkRequest_attribute), METH_VARARGS|METH_KEYWORDS, doc_QNetworkRequest_attribute},
    {sipName_hasRawHeader, meth_QNetworkRequest_hasRawHeader, METH_VARARGS, doc_QNetworkRequest_hasRawHeader},
    {sipName_header, meth_QNetworkRequest_header, METH_VARARGS, doc_QNetworkRequest_header},
    {sipName_http2Configuration, meth_QNetworkRequest_http2Configuration, METH_VARARGS, doc_QNetworkRequest_http2Configuration},
    {sipName_maximumRedirectsAllowed, meth_QNetworkRequest_maximumRedirectsAllowed, METH_VARARGS, doc_QNetworkRequest_maximumRedirectsAllowed},
    {sipName_originatingObject, meth_QNetworkRequest_originatingObject, METH_VARARGS, doc_QNetworkRequest_originatingObject},
    {sipName_peerVerifyName, meth_QNetworkRequest_peerVerifyName, METH_VARARGS, doc_QNetworkRequest_peerVerifyName},
    {sipName_priority, meth_QNetworkRequest_priority, METH_VARARGS, doc_QNetworkRequest_priority},
    {sipName_rawHeader, meth_QNetworkRequest_rawHeader, METH_VARARGS, doc_QNetworkRequest_rawHeader},
    {sipName_rawHeaderList, meth_QNetworkRequest_rawHeaderList, METH_VARARGS, doc_QNetworkRequest_rawHeaderList},
    {sipName_setAttribute, meth_QNetworkRequest_setAttribute, METH_VARARGS, doc_QNetworkRequest_setAttribute},
    {sipName_setHeader, meth_QNetworkRequest_setHeader, METH_VARARGS, doc_QNetworkRequest_setHeader},
    {sipName_setHttp2Configuration, meth_QNetworkRequest_setHttp2Configuration, METH_VARARGS, doc_QNetworkRequest_setHttp2Configuration},
    {sipName_setMaximumRedirectsAllowed, meth_QNetworkRequest_setMaximumRedirectsAllowed, METH_VARARGS, doc_QNetworkRequest_setMaximumRedirectsAllowed},
    {sipName_setOriginatingObject, meth_QNetworkRequest_setOriginatingObject, METH_VARARGS, doc_QNetworkRequest_setOriginatingObject},
    {sipName_setPeerVerifyName, meth_QNetworkRequest_setPeerVerifyName, METH_VARARGS, doc_QNetworkRequest_setPeerVerifyName},
    {sipName_setPriority, meth_QNetworkRequest_setPriority, METH_VARARGS, doc_QNetworkRequest_setPriority},
    {sipName_setRawHeader, meth_QNetworkRequest_setRawHeader, METH_VARARGS, doc_QNetworkRequest_setRawHeader},
    {sipName_setSslConfiguration, meth_QNetworkRequest_setSslConfiguration, METH_VARARGS, doc_QNetworkRequest_setSslConfiguration},
    {sipName_setTransferTimeout, SIP_MLMETH_CAST(meth_QNetworkRequest_setTransferTimeout), METH_VARARGS|METH_KEYWORDS, doc_QNetworkRequest_setTransferTimeout},
    {sipName_setUrl, meth_QNetworkRequest_setUrl, METH_VARARGS, doc_QNetworkRequest_setUrl},
    {sipName_sslConfiguration, meth_QNetworkRequest_sslConfiguration, METH_VARARGS, doc_QNetworkRequest_sslConfiguration},
    {sipName_swap, meth_QNetworkRequest_swap, METH_VARARGS, doc_QNetworkRequest_swap},
    {sipName_transferTimeout, meth_QNetworkRequest_transferTimeout, METH_VARARGS, doc_QNetworkRequest_transferTimeout},
    {sipName_url, meth_QNetworkRequest_url, METH_VARARGS, doc_QNetworkRequest_url}
};

static sipEnumMemberDef enummembers_QNetworkRequest[] = {
    {sipName_AlwaysCache, static_cast<int>(::QNetworkRequest::AlwaysCache), 93},
    {sipName_AlwaysNetwork, static_cast<int>(::QNetworkRequest::AlwaysNetwork), 93},
    {sipName_AuthenticationReuseAttribute, static_cast<int>(::QNetworkRequest::AuthenticationReuseAttribute), 92},
    {sipName_AutoDeleteReplyOnFinishAttribute, static_cast<int>(::QNetworkRequest::AutoDeleteReplyOnFinishAttribute), 92},
    {sipName_Automatic, static_cast<int>(::QNetworkRequest::Automatic), 95},
    {sipName_BackgroundRequestAttribute, static_cast<int>(::QNetworkRequest::BackgroundRequestAttribute), 92},
    {sipName_CacheLoadControlAttribute, static_cast<int>(::QNetworkRequest::CacheLoadControlAttribute), 92},
    {sipName_CacheSaveControlAttribute, static_cast<int>(::QNetworkRequest::CacheSaveControlAttribute), 92},
    {sipName_ConnectionEncryptedAttribute, static_cast<int>(::QNetworkRequest::ConnectionEncryptedAttribute), 92},
    {sipName_ContentDispositionHeader, static_cast<int>(::QNetworkRequest::ContentDispositionHeader), 94},
    {sipName_ContentLengthHeader, static_cast<int>(::QNetworkRequest::ContentLengthHeader), 94},
    {sipName_ContentTypeHeader, static_cast<int>(::QNetworkRequest::ContentTypeHeader), 94},
    {sipName_CookieHeader, static_cast<int>(::QNetworkRequest::CookieHeader), 94},
    {sipName_CookieLoadControlAttribute, static_cast<int>(::QNetworkRequest::CookieLoadControlAttribute), 92},
    {sipName_CookieSaveControlAttribute, static_cast<int>(::QNetworkRequest::CookieSaveControlAttribute), 92},
    {sipName_CustomVerbAttribute, static_cast<int>(::QNetworkRequest::CustomVerbAttribute), 92},
    {sipName_DefaultTransferTimeoutConstant, static_cast<int>(::QNetworkRequest::DefaultTransferTimeoutConstant), 98},
    {sipName_DoNotBufferUploadDataAttribute, static_cast<int>(::QNetworkRequest::DoNotBufferUploadDataAttribute), 92},
    {sipName_ETagHeader, static_cast<int>(::QNetworkRequest::ETagHeader), 94},
    {sipName_EmitAllUploadProgressSignalsAttribute, static_cast<int>(::QNetworkRequest::EmitAllUploadProgressSignalsAttribute), 92},
    {sipName_FollowRedirectsAttribute, static_cast<int>(::QNetworkRequest::FollowRedirectsAttribute), 92},
    {sipName_HTTP2AllowedAttribute, static_cast<int>(::QNetworkRequest::HTTP2AllowedAttribute), 92},
    {sipName_HTTP2WasUsedAttribute, static_cast<int>(::QNetworkRequest::HTTP2WasUsedAttribute), 92},
    {sipName_HighPriority, static_cast<int>(::QNetworkRequest::HighPriority), 96},
    {sipName_Http2AllowedAttribute, static_cast<int>(::QNetworkRequest::Http2AllowedAttribute), 92},
    {sipName_Http2DirectAttribute, static_cast<int>(::QNetworkRequest::Http2DirectAttribute), 92},
    {sipName_Http2WasUsedAttribute, static_cast<int>(::QNetworkRequest::Http2WasUsedAttribute), 92},
    {sipName_HttpPipeliningAllowedAttribute, static_cast<int>(::QNetworkRequest::HttpPipeliningAllowedAttribute), 92},
    {sipName_HttpPipeliningWasUsedAttribute, static_cast<int>(::QNetworkRequest::HttpPipeliningWasUsedAttribute), 92},
    {sipName_HttpReasonPhraseAttribute, static_cast<int>(::QNetworkRequest::HttpReasonPhraseAttribute), 92},
    {sipName_HttpStatusCodeAttribute, static_cast<int>(::QNetworkRequest::HttpStatusCodeAttribute), 92},
    {sipName_IfMatchHeader, static_cast<int>(::QNetworkRequest::IfMatchHeader), 94},
    {sipName_IfModifiedSinceHeader, static_cast<int>(::QNetworkRequest::IfModifiedSinceHeader), 94},
    {sipName_IfNoneMatchHeader, static_cast<int>(::QNetworkRequest::IfNoneMatchHeader), 94},
    {sipName_LastModifiedHeader, static_cast<int>(::QNetworkRequest::LastModifiedHeader), 94},
    {sipName_LocationHeader, static_cast<int>(::QNetworkRequest::LocationHeader), 94},
    {sipName_LowPriority, static_cast<int>(::QNetworkRequest::LowPriority), 96},
    {sipName_Manual, static_cast<int>(::QNetworkRequest::Manual), 95},
    {sipName_ManualRedirectPolicy, static_cast<int>(::QNetworkRequest::ManualRedirectPolicy), 97},
    {sipName_NoLessSafeRedirectPolicy, static_cast<int>(::QNetworkRequest::NoLessSafeRedirectPolicy), 97},
    {sipName_NormalPriority, static_cast<int>(::QNetworkRequest::NormalPriority), 96},
    {sipName_OriginalContentLengthAttribute, static_cast<int>(::QNetworkRequest::OriginalContentLengthAttribute), 92},
    {sipName_PreferCache, static_cast<int>(::QNetworkRequest::PreferCache), 93},
    {sipName_PreferNetwork, static_cast<int>(::QNetworkRequest::PreferNetwork), 93},
    {sipName_RedirectPolicyAttribute, static_cast<int>(::QNetworkRequest::RedirectPolicyAttribute), 92},
    {sipName_RedirectionTargetAttribute, static_cast<int>(::QNetworkRequest::RedirectionTargetAttribute), 92},
    {sipName_SameOriginRedirectPolicy, static_cast<int>(::QNetworkRequest::SameOriginRedirectPolicy), 97},
    {sipName_ServerHeader, static_cast<int>(::QNetworkRequest::ServerHeader), 94},
    {sipName_SetCookieHeader, static_cast<int>(::QNetworkRequest::SetCookieHeader), 94},
    {sipName_SourceIsFromCacheAttribute, static_cast<int>(::QNetworkRequest::SourceIsFromCacheAttribute), 92},
    {sipName_SpdyAllowedAttribute, static_cast<int>(::QNetworkRequest::SpdyAllowedAttribute), 92},
    {sipName_SpdyWasUsedAttribute, static_cast<int>(::QNetworkRequest::SpdyWasUsedAttribute), 92},
    {sipName_User, static_cast<int>(::QNetworkRequest::User), 92},
    {sipName_UserAgentHeader, static_cast<int>(::QNetworkRequest::UserAgentHeader), 94},
    {sipName_UserMax, static_cast<int>(::QNetworkRequest::UserMax), 92},
    {sipName_UserVerifiedRedirectPolicy, static_cast<int>(::QNetworkRequest::UserVerifiedRedirectPolicy), 97},
};

PyDoc_STRVAR(doc_QNetworkRequest, "\1QNetworkRequest(url: QUrl = QUrl())\n"
"QNetworkRequest(other: QNetworkRequest)");


static pyqt5ClassPluginDef plugin_QNetworkRequest = {
    SIP_NULLPTR,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef_QtNetwork_QNetworkRequest = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QNetworkRequest,
        SIP_NULLPTR,
        &plugin_QNetworkRequest,
    },
    {
        sipNameNr_QNetworkRequest,
        {0, 0, 1},
        25, methods_QNetworkRequest,
        56, enummembers_QNetworkRequest,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QNetworkRequest,
    -1,
    sipNameNr_sip_simplewrapper,
    SIP_NULLPTR,
    slots_QNetworkRequest,
    init_type_QNetworkRequest,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QNetworkRequest,
    assign_QNetworkRequest,
    array_QNetworkRequest,
    copy_QNetworkRequest,
    release_QNetworkRequest,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QNetworkRequest,
    sizeof (::QNetworkRequest),
};
