#define _CFFI_

/* We try to define Py_LIMITED_API before including Python.h.

   Mess: we can only define it if Py_DEBUG, Py_TRACE_REFS and
   Py_REF_DEBUG are not defined.  This is a best-effort approximation:
   we can learn about Py_DEBUG from pyconfig.h, but it is unclear if
   the same works for the other two macros.  Py_DEBUG implies them,
   but not the other way around.

   The implementation is messy (issue #350): on Windows, with _MSC_VER,
   we have to define Py_LIMITED_API even before including pyconfig.h.
   In that case, we guess what pyconfig.h will do to the macros above,
   and check our guess after the #include.

   Note that on Windows, with CPython 3.x, you need >= 3.5 and virtualenv
   version >= 16.0.0.  With older versions of either, you don't get a
   copy of PYTHON3.DLL in the virtualenv.  We can't check the version of
   CPython *before* we even include pyconfig.h.  ffi.set_source() puts
   a ``#define _CFFI_NO_LIMITED_API'' at the start of this file if it is
   running on Windows < 3.5, as an attempt at fixing it, but that's
   arguably wrong because it may not be the target version of Python.
   Still better than nothing I guess.  As another workaround, you can
   remove the definition of Py_LIMITED_API here.

   See also 'py_limited_api' in cffi/setuptools_ext.py.
*/
#if !defined(_CFFI_USE_EMBEDDING) && !defined(Py_LIMITED_API)
#  ifdef _MSC_VER
#    if !defined(_DEBUG) && !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#    include <pyconfig.h>
     /* sanity-check: Py_LIMITED_API will cause crashes if any of these
        are also defined.  Normally, the Python file PC/pyconfig.h does not
        cause any of these to be defined, with the exception that _DEBUG
        causes Py_DEBUG.  Double-check that. */
#    ifdef Py_LIMITED_API
#      if defined(Py_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_DEBUG, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_TRACE_REFS)
#        error "pyconfig.h unexpectedly defines Py_TRACE_REFS, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_REF_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_REF_DEBUG, but Py_LIMITED_API is set"
#      endif
#    endif
#  else
#    include <pyconfig.h>
#    if !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#  endif
#endif

#include <Python.h>
#ifdef __cplusplus
extern "C" {
#endif
#include <stddef.h>

/* This part is from file 'cffi/parse_c_type.h'.  It is copied at the
   beginning of C sources generated by CFFI's ffi.set_source(). */

typedef void *_cffi_opcode_t;

#define _CFFI_OP(opcode, arg)   (_cffi_opcode_t)(opcode | (((uintptr_t)(arg)) << 8))
#define _CFFI_GETOP(cffi_opcode)    ((unsigned char)(uintptr_t)cffi_opcode)
#define _CFFI_GETARG(cffi_opcode)   (((intptr_t)cffi_opcode) >> 8)

#define _CFFI_OP_PRIMITIVE       1
#define _CFFI_OP_POINTER         3
#define _CFFI_OP_ARRAY           5
#define _CFFI_OP_OPEN_ARRAY      7
#define _CFFI_OP_STRUCT_UNION    9
#define _CFFI_OP_ENUM           11
#define _CFFI_OP_FUNCTION       13
#define _CFFI_OP_FUNCTION_END   15
#define _CFFI_OP_NOOP           17
#define _CFFI_OP_BITFIELD       19
#define _CFFI_OP_TYPENAME       21
#define _CFFI_OP_CPYTHON_BLTN_V 23   // varargs
#define _CFFI_OP_CPYTHON_BLTN_N 25   // noargs
#define _CFFI_OP_CPYTHON_BLTN_O 27   // O  (i.e. a single arg)
#define _CFFI_OP_CONSTANT       29
#define _CFFI_OP_CONSTANT_INT   31
#define _CFFI_OP_GLOBAL_VAR     33
#define _CFFI_OP_DLOPEN_FUNC    35
#define _CFFI_OP_DLOPEN_CONST   37
#define _CFFI_OP_GLOBAL_VAR_F   39
#define _CFFI_OP_EXTERN_PYTHON  41

#define _CFFI_PRIM_VOID          0
#define _CFFI_PRIM_BOOL          1
#define _CFFI_PRIM_CHAR          2
#define _CFFI_PRIM_SCHAR         3
#define _CFFI_PRIM_UCHAR         4
#define _CFFI_PRIM_SHORT         5
#define _CFFI_PRIM_USHORT        6
#define _CFFI_PRIM_INT           7
#define _CFFI_PRIM_UINT          8
#define _CFFI_PRIM_LONG          9
#define _CFFI_PRIM_ULONG        10
#define _CFFI_PRIM_LONGLONG     11
#define _CFFI_PRIM_ULONGLONG    12
#define _CFFI_PRIM_FLOAT        13
#define _CFFI_PRIM_DOUBLE       14
#define _CFFI_PRIM_LONGDOUBLE   15

#define _CFFI_PRIM_WCHAR        16
#define _CFFI_PRIM_INT8         17
#define _CFFI_PRIM_UINT8        18
#define _CFFI_PRIM_INT16        19
#define _CFFI_PRIM_UINT16       20
#define _CFFI_PRIM_INT32        21
#define _CFFI_PRIM_UINT32       22
#define _CFFI_PRIM_INT64        23
#define _CFFI_PRIM_UINT64       24
#define _CFFI_PRIM_INTPTR       25
#define _CFFI_PRIM_UINTPTR      26
#define _CFFI_PRIM_PTRDIFF      27
#define _CFFI_PRIM_SIZE         28
#define _CFFI_PRIM_SSIZE        29
#define _CFFI_PRIM_INT_LEAST8   30
#define _CFFI_PRIM_UINT_LEAST8  31
#define _CFFI_PRIM_INT_LEAST16  32
#define _CFFI_PRIM_UINT_LEAST16 33
#define _CFFI_PRIM_INT_LEAST32  34
#define _CFFI_PRIM_UINT_LEAST32 35
#define _CFFI_PRIM_INT_LEAST64  36
#define _CFFI_PRIM_UINT_LEAST64 37
#define _CFFI_PRIM_INT_FAST8    38
#define _CFFI_PRIM_UINT_FAST8   39
#define _CFFI_PRIM_INT_FAST16   40
#define _CFFI_PRIM_UINT_FAST16  41
#define _CFFI_PRIM_INT_FAST32   42
#define _CFFI_PRIM_UINT_FAST32  43
#define _CFFI_PRIM_INT_FAST64   44
#define _CFFI_PRIM_UINT_FAST64  45
#define _CFFI_PRIM_INTMAX       46
#define _CFFI_PRIM_UINTMAX      47
#define _CFFI_PRIM_FLOATCOMPLEX 48
#define _CFFI_PRIM_DOUBLECOMPLEX 49
#define _CFFI_PRIM_CHAR16       50
#define _CFFI_PRIM_CHAR32       51

#define _CFFI__NUM_PRIM         52
#define _CFFI__UNKNOWN_PRIM           (-1)
#define _CFFI__UNKNOWN_FLOAT_PRIM     (-2)
#define _CFFI__UNKNOWN_LONG_DOUBLE    (-3)

#define _CFFI__IO_FILE_STRUCT         (-1)


struct _cffi_global_s {
    const char *name;
    void *address;
    _cffi_opcode_t type_op;
    void *size_or_direct_fn;  // OP_GLOBAL_VAR: size, or 0 if unknown
                              // OP_CPYTHON_BLTN_*: addr of direct function
};

struct _cffi_getconst_s {
    unsigned long long value;
    const struct _cffi_type_context_s *ctx;
    int gindex;
};

struct _cffi_struct_union_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_STRUCT_UNION
    int flags;               // _CFFI_F_* flags below
    size_t size;
    int alignment;
    int first_field_index;   // -> _cffi_fields array
    int num_fields;
};
#define _CFFI_F_UNION         0x01   // is a union, not a struct
#define _CFFI_F_CHECK_FIELDS  0x02   // complain if fields are not in the
                                     // "standard layout" or if some are missing
#define _CFFI_F_PACKED        0x04   // for CHECK_FIELDS, assume a packed struct
#define _CFFI_F_EXTERNAL      0x08   // in some other ffi.include()
#define _CFFI_F_OPAQUE        0x10   // opaque

struct _cffi_field_s {
    const char *name;
    size_t field_offset;
    size_t field_size;
    _cffi_opcode_t field_type_op;
};

struct _cffi_enum_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_ENUM
    int type_prim;           // _CFFI_PRIM_xxx
    const char *enumerators; // comma-delimited string
};

struct _cffi_typename_s {
    const char *name;
    int type_index;   /* if opaque, points to a possibly artificial
                         OP_STRUCT which is itself opaque */
};

struct _cffi_type_context_s {
    _cffi_opcode_t *types;
    const struct _cffi_global_s *globals;
    const struct _cffi_field_s *fields;
    const struct _cffi_struct_union_s *struct_unions;
    const struct _cffi_enum_s *enums;
    const struct _cffi_typename_s *typenames;
    int num_globals;
    int num_struct_unions;
    int num_enums;
    int num_typenames;
    const char *const *includes;
    int num_types;
    int flags;      /* future extension */
};

struct _cffi_parse_info_s {
    const struct _cffi_type_context_s *ctx;
    _cffi_opcode_t *output;
    unsigned int output_size;
    size_t error_location;
    const char *error_message;
};

struct _cffi_externpy_s {
    const char *name;
    size_t size_of_result;
    void *reserved1, *reserved2;
};

#ifdef _CFFI_INTERNAL
static int parse_c_type(struct _cffi_parse_info_s *info, const char *input);
static int search_in_globals(const struct _cffi_type_context_s *ctx,
                             const char *search, size_t search_len);
static int search_in_struct_unions(const struct _cffi_type_context_s *ctx,
                                   const char *search, size_t search_len);
#endif

/* this block of #ifs should be kept exactly identical between
   c/_cffi_backend.c, cffi/vengine_cpy.py, cffi/vengine_gen.py
   and cffi/_cffi_include.h */
#if defined(_MSC_VER)
# include <malloc.h>   /* for alloca() */
# if _MSC_VER < 1600   /* MSVC < 2010 */
   typedef __int8 int8_t;
   typedef __int16 int16_t;
   typedef __int32 int32_t;
   typedef __int64 int64_t;
   typedef unsigned __int8 uint8_t;
   typedef unsigned __int16 uint16_t;
   typedef unsigned __int32 uint32_t;
   typedef unsigned __int64 uint64_t;
   typedef __int8 int_least8_t;
   typedef __int16 int_least16_t;
   typedef __int32 int_least32_t;
   typedef __int64 int_least64_t;
   typedef unsigned __int8 uint_least8_t;
   typedef unsigned __int16 uint_least16_t;
   typedef unsigned __int32 uint_least32_t;
   typedef unsigned __int64 uint_least64_t;
   typedef __int8 int_fast8_t;
   typedef __int16 int_fast16_t;
   typedef __int32 int_fast32_t;
   typedef __int64 int_fast64_t;
   typedef unsigned __int8 uint_fast8_t;
   typedef unsigned __int16 uint_fast16_t;
   typedef unsigned __int32 uint_fast32_t;
   typedef unsigned __int64 uint_fast64_t;
   typedef __int64 intmax_t;
   typedef unsigned __int64 uintmax_t;
# else
#  include <stdint.h>
# endif
# if _MSC_VER < 1800   /* MSVC < 2013 */
#  ifndef __cplusplus
    typedef unsigned char _Bool;
#  endif
# endif
# define _cffi_float_complex_t   _Fcomplex    /* include <complex.h> for it */
# define _cffi_double_complex_t  _Dcomplex    /* include <complex.h> for it */
#else
# include <stdint.h>
# if (defined (__SVR4) && defined (__sun)) || defined(_AIX) || defined(__hpux)
#  include <alloca.h>
# endif
# define _cffi_float_complex_t   float _Complex
# define _cffi_double_complex_t  double _Complex
#endif

#ifdef __GNUC__
# define _CFFI_UNUSED_FN  __attribute__((unused))
#else
# define _CFFI_UNUSED_FN  /* nothing */
#endif

#ifdef __cplusplus
# ifndef _Bool
   typedef bool _Bool;   /* semi-hackish: C++ has no _Bool; bool is builtin */
# endif
#endif

/**********  CPython-specific section  **********/
#ifndef PYPY_VERSION


#if PY_MAJOR_VERSION >= 3
# define PyInt_FromLong PyLong_FromLong
#endif

#define _cffi_from_c_double PyFloat_FromDouble
#define _cffi_from_c_float PyFloat_FromDouble
#define _cffi_from_c_long PyInt_FromLong
#define _cffi_from_c_ulong PyLong_FromUnsignedLong
#define _cffi_from_c_longlong PyLong_FromLongLong
#define _cffi_from_c_ulonglong PyLong_FromUnsignedLongLong
#define _cffi_from_c__Bool PyBool_FromLong

#define _cffi_to_c_double PyFloat_AsDouble
#define _cffi_to_c_float PyFloat_AsDouble

#define _cffi_from_c_int(x, type)                                        \
    (((type)-1) > 0 ? /* unsigned */                                     \
        (sizeof(type) < sizeof(long) ?                                   \
            PyInt_FromLong((long)x) :                                    \
         sizeof(type) == sizeof(long) ?                                  \
            PyLong_FromUnsignedLong((unsigned long)x) :                  \
            PyLong_FromUnsignedLongLong((unsigned long long)x)) :        \
        (sizeof(type) <= sizeof(long) ?                                  \
            PyInt_FromLong((long)x) :                                    \
            PyLong_FromLongLong((long long)x)))

#define _cffi_to_c_int(o, type)                                          \
    ((type)(                                                             \
     sizeof(type) == 1 ? (((type)-1) > 0 ? (type)_cffi_to_c_u8(o)        \
                                         : (type)_cffi_to_c_i8(o)) :     \
     sizeof(type) == 2 ? (((type)-1) > 0 ? (type)_cffi_to_c_u16(o)       \
                                         : (type)_cffi_to_c_i16(o)) :    \
     sizeof(type) == 4 ? (((type)-1) > 0 ? (type)_cffi_to_c_u32(o)       \
                                         : (type)_cffi_to_c_i32(o)) :    \
     sizeof(type) == 8 ? (((type)-1) > 0 ? (type)_cffi_to_c_u64(o)       \
                                         : (type)_cffi_to_c_i64(o)) :    \
     (Py_FatalError("unsupported size for type " #type), (type)0)))

#define _cffi_to_c_i8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[1])
#define _cffi_to_c_u8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[2])
#define _cffi_to_c_i16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[3])
#define _cffi_to_c_u16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[4])
#define _cffi_to_c_i32                                                   \
                 ((int(*)(PyObject *))_cffi_exports[5])
#define _cffi_to_c_u32                                                   \
                 ((unsigned int(*)(PyObject *))_cffi_exports[6])
#define _cffi_to_c_i64                                                   \
                 ((long long(*)(PyObject *))_cffi_exports[7])
#define _cffi_to_c_u64                                                   \
                 ((unsigned long long(*)(PyObject *))_cffi_exports[8])
#define _cffi_to_c_char                                                  \
                 ((int(*)(PyObject *))_cffi_exports[9])
#define _cffi_from_c_pointer                                             \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[10])
#define _cffi_to_c_pointer                                               \
    ((char *(*)(PyObject *, struct _cffi_ctypedescr *))_cffi_exports[11])
#define _cffi_get_struct_layout                                          \
    not used any more
#define _cffi_restore_errno                                              \
    ((void(*)(void))_cffi_exports[13])
#define _cffi_save_errno                                                 \
    ((void(*)(void))_cffi_exports[14])
#define _cffi_from_c_char                                                \
    ((PyObject *(*)(char))_cffi_exports[15])
#define _cffi_from_c_deref                                               \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[16])
#define _cffi_to_c                                                       \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[17])
#define _cffi_from_c_struct                                              \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[18])
#define _cffi_to_c_wchar_t                                               \
    ((_cffi_wchar_t(*)(PyObject *))_cffi_exports[19])
#define _cffi_from_c_wchar_t                                             \
    ((PyObject *(*)(_cffi_wchar_t))_cffi_exports[20])
#define _cffi_to_c_long_double                                           \
    ((long double(*)(PyObject *))_cffi_exports[21])
#define _cffi_to_c__Bool                                                 \
    ((_Bool(*)(PyObject *))_cffi_exports[22])
#define _cffi_prepare_pointer_call_argument                              \
    ((Py_ssize_t(*)(struct _cffi_ctypedescr *,                           \
                    PyObject *, char **))_cffi_exports[23])
#define _cffi_convert_array_from_object                                  \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[24])
#define _CFFI_CPIDX  25
#define _cffi_call_python                                                \
    ((void(*)(struct _cffi_externpy_s *, char *))_cffi_exports[_CFFI_CPIDX])
#define _cffi_to_c_wchar3216_t                                           \
    ((int(*)(PyObject *))_cffi_exports[26])
#define _cffi_from_c_wchar3216_t                                         \
    ((PyObject *(*)(int))_cffi_exports[27])
#define _CFFI_NUM_EXPORTS 28

struct _cffi_ctypedescr;

static void *_cffi_exports[_CFFI_NUM_EXPORTS];

#define _cffi_type(index)   (                           \
    assert((((uintptr_t)_cffi_types[index]) & 1) == 0), \
    (struct _cffi_ctypedescr *)_cffi_types[index])

static PyObject *_cffi_init(const char *module_name, Py_ssize_t version,
                            const struct _cffi_type_context_s *ctx)
{
    PyObject *module, *o_arg, *new_module;
    void *raw[] = {
        (void *)module_name,
        (void *)version,
        (void *)_cffi_exports,
        (void *)ctx,
    };

    module = PyImport_ImportModule("_cffi_backend");
    if (module == NULL)
        goto failure;

    o_arg = PyLong_FromVoidPtr((void *)raw);
    if (o_arg == NULL)
        goto failure;

    new_module = PyObject_CallMethod(
        module, (char *)"_init_cffi_1_0_external_module", (char *)"O", o_arg);

    Py_DECREF(o_arg);
    Py_DECREF(module);
    return new_module;

  failure:
    Py_XDECREF(module);
    return NULL;
}


#ifdef HAVE_WCHAR_H
typedef wchar_t _cffi_wchar_t;
#else
typedef uint16_t _cffi_wchar_t;   /* same random pick as _cffi_backend.c */
#endif

_CFFI_UNUSED_FN static uint16_t _cffi_to_c_char16_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return (uint16_t)_cffi_to_c_wchar_t(o);
    else
        return (uint16_t)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char16_t(uint16_t x)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

_CFFI_UNUSED_FN static int _cffi_to_c_char32_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return (int)_cffi_to_c_wchar_t(o);
    else
        return (int)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char32_t(unsigned int x)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

union _cffi_union_alignment_u {
    unsigned char m_char;
    unsigned short m_short;
    unsigned int m_int;
    unsigned long m_long;
    unsigned long long m_longlong;
    float m_float;
    double m_double;
    long double m_longdouble;
};

struct _cffi_freeme_s {
    struct _cffi_freeme_s *next;
    union _cffi_union_alignment_u alignment;
};

_CFFI_UNUSED_FN static int
_cffi_convert_array_argument(struct _cffi_ctypedescr *ctptr, PyObject *arg,
                             char **output_data, Py_ssize_t datasize,
                             struct _cffi_freeme_s **freeme)
{
    char *p;
    if (datasize < 0)
        return -1;

    p = *output_data;
    if (p == NULL) {
        struct _cffi_freeme_s *fp = (struct _cffi_freeme_s *)PyObject_Malloc(
            offsetof(struct _cffi_freeme_s, alignment) + (size_t)datasize);
        if (fp == NULL)
            return -1;
        fp->next = *freeme;
        *freeme = fp;
        p = *output_data = (char *)&fp->alignment;
    }
    memset((void *)p, 0, (size_t)datasize);
    return _cffi_convert_array_from_object(p, ctptr, arg);
}

_CFFI_UNUSED_FN static void
_cffi_free_array_arguments(struct _cffi_freeme_s *freeme)
{
    do {
        void *p = (void *)freeme;
        freeme = freeme->next;
        PyObject_Free(p);
    } while (freeme != NULL);
}

/**********  end CPython-specific section  **********/
#else
_CFFI_UNUSED_FN
static void (*_cffi_call_python_org)(struct _cffi_externpy_s *, char *);
# define _cffi_call_python  _cffi_call_python_org
#endif


#define _cffi_array_len(array)   (sizeof(array) / sizeof((array)[0]))

#define _cffi_prim_int(size, sign)                                      \
    ((size) == 1 ? ((sign) ? _CFFI_PRIM_INT8  : _CFFI_PRIM_UINT8)  :    \
     (size) == 2 ? ((sign) ? _CFFI_PRIM_INT16 : _CFFI_PRIM_UINT16) :    \
     (size) == 4 ? ((sign) ? _CFFI_PRIM_INT32 : _CFFI_PRIM_UINT32) :    \
     (size) == 8 ? ((sign) ? _CFFI_PRIM_INT64 : _CFFI_PRIM_UINT64) :    \
     _CFFI__UNKNOWN_PRIM)

#define _cffi_prim_float(size)                                          \
    ((size) == sizeof(float) ? _CFFI_PRIM_FLOAT :                       \
     (size) == sizeof(double) ? _CFFI_PRIM_DOUBLE :                     \
     (size) == sizeof(long double) ? _CFFI__UNKNOWN_LONG_DOUBLE :       \
     _CFFI__UNKNOWN_FLOAT_PRIM)

#define _cffi_check_int(got, got_nonpos, expected)      \
    ((got_nonpos) == (expected <= 0) &&                 \
     (got) == (unsigned long long)expected)

#ifdef MS_WIN32
# define _cffi_stdcall  __stdcall
#else
# define _cffi_stdcall  /* nothing */
#endif

#ifdef __cplusplus
}
#endif

/************************************************************/


    # include "gil.h"
    # include "libR.h"
    # include "parse.h"
    # include "process_events.h"
    

/************************************************************/

static void *_cffi_types[] = {
/*  0 */ _CFFI_OP(_CFFI_OP_FUNCTION, 286), // DllInfo *()(void)
/*  1 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  2 */ _CFFI_OP(_CFFI_OP_FUNCTION, 7), // Rboolean()(SEXPREC *)
/*  3 */ _CFFI_OP(_CFFI_OP_POINTER, 569), // SEXPREC *
/*  4 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  5 */ _CFFI_OP(_CFFI_OP_FUNCTION, 7), // Rboolean()(SEXPREC *, Rboolean)
/*  6 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/*  7 */ _CFFI_OP(_CFFI_OP_ENUM, 1), // Rboolean
/*  8 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  9 */ _CFFI_OP(_CFFI_OP_FUNCTION, 7), // Rboolean()(SEXPREC *, SEXPREC *)
/* 10 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 11 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 12 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 13 */ _CFFI_OP(_CFFI_OP_FUNCTION, 7), // Rboolean()(SEXPREC *, SEXPREC *, Rboolean)
/* 14 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 15 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 16 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 17 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 18 */ _CFFI_OP(_CFFI_OP_FUNCTION, 7), // Rboolean()(SEXPREC *, SEXPREC *, int)
/* 19 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 20 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 21 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7), // int
/* 22 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 23 */ _CFFI_OP(_CFFI_OP_FUNCTION, 7), // Rboolean()(SEXPREC *, char const *)
/* 24 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 25 */ _CFFI_OP(_CFFI_OP_POINTER, 577), // char const *
/* 26 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 27 */ _CFFI_OP(_CFFI_OP_FUNCTION, 7), // Rboolean()(char const *, char const *, Rboolean)
/* 28 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 29 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 30 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 31 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 32 */ _CFFI_OP(_CFFI_OP_FUNCTION, 7), // Rboolean()(void(*)(void *), void *)
/* 33 */ _CFFI_OP(_CFFI_OP_POINTER, 502), // void(*)(void *)
/* 34 */ _CFFI_OP(_CFFI_OP_POINTER, 648), // void *
/* 35 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 36 */ _CFFI_OP(_CFFI_OP_FUNCTION, 527), // Rcomplex *()(SEXPREC *)
/* 37 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 38 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 39 */ _CFFI_OP(_CFFI_OP_FUNCTION, 43), // Rcomplex()(SEXPREC *)
/* 40 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 41 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 42 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3), // SEXPREC *()(Rcomplex)
/* 43 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 2), // Rcomplex
/* 44 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 45 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3), // SEXPREC *()(SEXPREC *(*)(void *), void *, SEXPREC *(*)(SEXPREC *, void *), void *)
/* 46 */ _CFFI_OP(_CFFI_OP_POINTER, 240), // SEXPREC *(*)(void *)
/* 47 */ _CFFI_OP(_CFFI_OP_NOOP, 34),
/* 48 */ _CFFI_OP(_CFFI_OP_POINTER, 163), // SEXPREC *(*)(SEXPREC *, void *)
/* 49 */ _CFFI_OP(_CFFI_OP_NOOP, 34),
/* 50 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 51 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3), // SEXPREC *()(SEXPREC *(*)(void *), void *, SEXPREC *, SEXPREC *(*)(SEXPREC *, void *), void *, void(*)(void *), void *)
/* 52 */ _CFFI_OP(_CFFI_OP_NOOP, 46),
/* 53 */ _CFFI_OP(_CFFI_OP_NOOP, 34),
/* 54 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 55 */ _CFFI_OP(_CFFI_OP_NOOP, 48),
/* 56 */ _CFFI_OP(_CFFI_OP_NOOP, 34),
/* 57 */ _CFFI_OP(_CFFI_OP_NOOP, 33),
/* 58 */ _CFFI_OP(_CFFI_OP_NOOP, 34),
/* 59 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 60 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3), // SEXPREC *()(SEXPREC *)
/* 61 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 62 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 63 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3), // SEXPREC *()(SEXPREC *, Rboolean)
/* 64 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 65 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 66 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 67 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3), // SEXPREC *()(SEXPREC *, Rboolean, Rboolean)
/* 68 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 69 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 70 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 71 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 72 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3), // SEXPREC *()(SEXPREC *, Rboolean, int)
/* 73 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 74 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 75 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 76 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 77 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3), // SEXPREC *()(SEXPREC *, SEXPREC *)
/* 78 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 79 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 80 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 81 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3), // SEXPREC *()(SEXPREC *, SEXPREC *, Rboolean)
/* 82 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 83 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 84 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 85 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 86 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3), // SEXPREC *()(SEXPREC *, SEXPREC *, SEXPREC *)
/* 87 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 88 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 89 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 90 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 91 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3), // SEXPREC *()(SEXPREC *, SEXPREC *, SEXPREC *, Rboolean)
/* 92 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 93 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 94 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 95 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 96 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 97 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3), // SEXPREC *()(SEXPREC *, SEXPREC *, SEXPREC *, SEXPREC *)
/* 98 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 99 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 100 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 101 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 102 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 103 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3), // SEXPREC *()(SEXPREC *, SEXPREC *, SEXPREC *, SEXPREC *, SEXPREC *)
/* 104 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 105 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 106 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 107 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 108 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 109 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 110 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3), // SEXPREC *()(SEXPREC *, SEXPREC *, SEXPREC *, SEXPREC *, SEXPREC *, SEXPREC *)
/* 111 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 112 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 113 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 114 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 115 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 116 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 117 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 118 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3), // SEXPREC *()(SEXPREC *, SEXPREC *, int *)
/* 119 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 120 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 121 */ _CFFI_OP(_CFFI_OP_POINTER, 21), // int *
/* 122 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 123 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3), // SEXPREC *()(SEXPREC *, SEXPREC *, int)
/* 124 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 125 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 126 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 127 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 128 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3), // SEXPREC *()(SEXPREC *, SEXPREC *, int, SEXPREC *)
/* 129 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 130 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 131 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 132 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 133 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 134 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3), // SEXPREC *()(SEXPREC *, SEXPREC *, void(*)(SEXPREC *), Rboolean)
/* 135 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 136 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 137 */ _CFFI_OP(_CFFI_OP_POINTER, 404), // void(*)(SEXPREC *)
/* 138 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 139 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 140 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3), // SEXPREC *()(SEXPREC *, int)
/* 141 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 142 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 143 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 144 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3), // SEXPREC *()(SEXPREC *, int, ParseStatus *, SEXPREC *)
/* 145 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 146 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 147 */ _CFFI_OP(_CFFI_OP_POINTER, 516), // ParseStatus *
/* 148 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 149 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 150 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3), // SEXPREC *()(SEXPREC *, ptrdiff_t)
/* 151 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 152 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 27), // ptrdiff_t
/* 153 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 154 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3), // SEXPREC *()(SEXPREC *, ptrdiff_t, SEXPREC *)
/* 155 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 156 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 27),
/* 157 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 158 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 159 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3), // SEXPREC *()(SEXPREC *, unsigned int)
/* 160 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 161 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8), // unsigned int
/* 162 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 163 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3), // SEXPREC *()(SEXPREC *, void *)
/* 164 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 165 */ _CFFI_OP(_CFFI_OP_NOOP, 34),
/* 166 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 167 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3), // SEXPREC *()(char const *)
/* 168 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 169 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 170 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3), // SEXPREC *()(char const *, SEXPREC *)
/* 171 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 172 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 173 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 174 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3), // SEXPREC *()(char const *, cetype_t)
/* 175 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 176 */ _CFFI_OP(_CFFI_OP_ENUM, 2), // cetype_t
/* 177 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 178 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3), // SEXPREC *()(char const *, int)
/* 179 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 180 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 181 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 182 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3), // SEXPREC *()(char const *, int, cetype_t)
/* 183 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 184 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 185 */ _CFFI_OP(_CFFI_OP_NOOP, 176),
/* 186 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 187 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3), // SEXPREC *()(double)
/* 188 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14), // double
/* 189 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 190 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3), // SEXPREC *()(int)
/* 191 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 192 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 193 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3), // SEXPREC *()(int, SEXPREC *, SEXPREC *, SEXPREC *(*)(SEXPREC *, SEXPREC *), SEXPREC *(*)(SEXPREC *, int), SEXPREC *)
/* 194 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 195 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 196 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 197 */ _CFFI_OP(_CFFI_OP_POINTER, 77), // SEXPREC *(*)(SEXPREC *, SEXPREC *)
/* 198 */ _CFFI_OP(_CFFI_OP_POINTER, 140), // SEXPREC *(*)(SEXPREC *, int)
/* 199 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 200 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 201 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3), // SEXPREC *()(unsigned char)
/* 202 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 4), // unsigned char
/* 203 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 204 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3), // SEXPREC *()(unsigned int)
/* 205 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 206 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 207 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3), // SEXPREC *()(unsigned int, SEXPREC *)
/* 208 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 209 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 210 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 211 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3), // SEXPREC *()(unsigned int, char const * *)
/* 212 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 213 */ _CFFI_OP(_CFFI_OP_POINTER, 25), // char const * *
/* 214 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 215 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3), // SEXPREC *()(unsigned int, int, int)
/* 216 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 217 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 218 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 219 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 220 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3), // SEXPREC *()(unsigned int, int, int, int)
/* 221 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 222 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 223 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 224 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 225 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 226 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3), // SEXPREC *()(unsigned int, ptrdiff_t)
/* 227 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 228 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 27),
/* 229 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 230 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3), // SEXPREC *()(unsigned int, ptrdiff_t, void *)
/* 231 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 232 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 27),
/* 233 */ _CFFI_OP(_CFFI_OP_NOOP, 34),
/* 234 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 235 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3), // SEXPREC *()(void *(*)(void), SEXPREC *, SEXPREC *)
/* 236 */ _CFFI_OP(_CFFI_OP_POINTER, 394), // void *(*)(void)
/* 237 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 238 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 239 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 240 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3), // SEXPREC *()(void *)
/* 241 */ _CFFI_OP(_CFFI_OP_NOOP, 34),
/* 242 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 243 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3), // SEXPREC *()(void *, SEXPREC *, SEXPREC *)
/* 244 */ _CFFI_OP(_CFFI_OP_NOOP, 34),
/* 245 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 246 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 247 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 248 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3), // SEXPREC *()(void)
/* 249 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 250 */ _CFFI_OP(_CFFI_OP_FUNCTION, 176), // cetype_t()(SEXPREC *)
/* 251 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 252 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 253 */ _CFFI_OP(_CFFI_OP_FUNCTION, 338), // char *()(char const *)
/* 254 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 255 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 256 */ _CFFI_OP(_CFFI_OP_FUNCTION, 338), // char *()(size_t, int)
/* 257 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28), // size_t
/* 258 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 259 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 260 */ _CFFI_OP(_CFFI_OP_FUNCTION, 338), // char *()(void)
/* 261 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 262 */ _CFFI_OP(_CFFI_OP_FUNCTION, 25), // char const *()(SEXPREC *)
/* 263 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 264 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 265 */ _CFFI_OP(_CFFI_OP_FUNCTION, 25), // char const *()(char const *, cetype_t, cetype_t, int)
/* 266 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 267 */ _CFFI_OP(_CFFI_OP_NOOP, 176),
/* 268 */ _CFFI_OP(_CFFI_OP_NOOP, 176),
/* 269 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 270 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 271 */ _CFFI_OP(_CFFI_OP_FUNCTION, 25), // char const *()(unsigned int)
/* 272 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8),
/* 273 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 274 */ _CFFI_OP(_CFFI_OP_FUNCTION, 25), // char const *()(void)
/* 275 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 276 */ _CFFI_OP(_CFFI_OP_FUNCTION, 581), // double *()(SEXPREC *)
/* 277 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 278 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 279 */ _CFFI_OP(_CFFI_OP_FUNCTION, 188), // double()(SEXPREC *)
/* 280 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 281 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 282 */ _CFFI_OP(_CFFI_OP_FUNCTION, 121), // int *()(SEXPREC *)
/* 283 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 284 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 285 */ _CFFI_OP(_CFFI_OP_FUNCTION, 21), // int()(DllInfo *, void *, void *, void *, void *)
/* 286 */ _CFFI_OP(_CFFI_OP_POINTER, 515), // DllInfo *
/* 287 */ _CFFI_OP(_CFFI_OP_NOOP, 34),
/* 288 */ _CFFI_OP(_CFFI_OP_NOOP, 34),
/* 289 */ _CFFI_OP(_CFFI_OP_NOOP, 34),
/* 290 */ _CFFI_OP(_CFFI_OP_NOOP, 34),
/* 291 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 292 */ _CFFI_OP(_CFFI_OP_FUNCTION, 21), // int()(SEXPREC *)
/* 293 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 294 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 295 */ _CFFI_OP(_CFFI_OP_FUNCTION, 21), // int()(SEXPREC *, SEXPREC *)
/* 296 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 297 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 298 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 299 */ _CFFI_OP(_CFFI_OP_FUNCTION, 21), // int()(SEXPREC *, char const *)
/* 300 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 301 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 302 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 303 */ _CFFI_OP(_CFFI_OP_FUNCTION, 21), // int()(SEXPREC *, int)
/* 304 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 305 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 306 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 307 */ _CFFI_OP(_CFFI_OP_FUNCTION, 21), // int()(SEXPREC *, int, SEXPREC *, SEXPREC *)
/* 308 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 309 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 310 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 311 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 312 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 313 */ _CFFI_OP(_CFFI_OP_FUNCTION, 21), // int()(SEXPREC *, nchar_type, Rboolean, Rboolean, char const *)
/* 314 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 315 */ _CFFI_OP(_CFFI_OP_ENUM, 3), // nchar_type
/* 316 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 317 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 318 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 319 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 320 */ _CFFI_OP(_CFFI_OP_FUNCTION, 21), // int()(char const *)
/* 321 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 322 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 323 */ _CFFI_OP(_CFFI_OP_FUNCTION, 21), // int()(char const *, unsigned char *, int, int)
/* 324 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 325 */ _CFFI_OP(_CFFI_OP_POINTER, 202), // unsigned char *
/* 326 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 327 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 328 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 329 */ _CFFI_OP(_CFFI_OP_FUNCTION, 21), // int()(double)
/* 330 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 14),
/* 331 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 332 */ _CFFI_OP(_CFFI_OP_FUNCTION, 21), // int()(int, char * *)
/* 333 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 334 */ _CFFI_OP(_CFFI_OP_POINTER, 338), // char * *
/* 335 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 336 */ _CFFI_OP(_CFFI_OP_FUNCTION, 21), // int()(int, char *, int)
/* 337 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 338 */ _CFFI_OP(_CFFI_OP_POINTER, 577), // char *
/* 339 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 340 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 341 */ _CFFI_OP(_CFFI_OP_FUNCTION, 21), // int()(int, char const * *, char const * *, char const *)
/* 342 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 343 */ _CFFI_OP(_CFFI_OP_NOOP, 213),
/* 344 */ _CFFI_OP(_CFFI_OP_NOOP, 213),
/* 345 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 346 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 347 */ _CFFI_OP(_CFFI_OP_FUNCTION, 21), // int()(int, char const * *, char const * *, char const *, Rboolean, char const *)
/* 348 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 349 */ _CFFI_OP(_CFFI_OP_NOOP, 213),
/* 350 */ _CFFI_OP(_CFFI_OP_NOOP, 213),
/* 351 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 352 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 353 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 354 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 355 */ _CFFI_OP(_CFFI_OP_FUNCTION, 21), // int()(int, int)
/* 356 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 357 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 358 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 359 */ _CFFI_OP(_CFFI_OP_FUNCTION, 21), // int()(int, int, int)
/* 360 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 361 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 362 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 363 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 364 */ _CFFI_OP(_CFFI_OP_FUNCTION, 21), // int()(void)
/* 365 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 366 */ _CFFI_OP(_CFFI_OP_FUNCTION, 602), // long double *()(size_t)
/* 367 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 368 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 369 */ _CFFI_OP(_CFFI_OP_FUNCTION, 152), // ptrdiff_t()(SEXPREC *)
/* 370 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 371 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 372 */ _CFFI_OP(_CFFI_OP_FUNCTION, 152), // ptrdiff_t()(SEXPREC *, Rboolean)
/* 373 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 374 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 375 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 376 */ _CFFI_OP(_CFFI_OP_FUNCTION, 152), // ptrdiff_t()(SEXPREC *, SEXPREC *, Rboolean)
/* 377 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 378 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 379 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 380 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 381 */ _CFFI_OP(_CFFI_OP_FUNCTION, 325), // unsigned char *()(SEXPREC *)
/* 382 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 383 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 384 */ _CFFI_OP(_CFFI_OP_FUNCTION, 161), // unsigned int()(char const *)
/* 385 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 386 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 387 */ _CFFI_OP(_CFFI_OP_FUNCTION, 34), // void *()(SEXPREC *)
/* 388 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 389 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 390 */ _CFFI_OP(_CFFI_OP_FUNCTION, 34), // void *()(int, int)
/* 391 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 392 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 393 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 394 */ _CFFI_OP(_CFFI_OP_FUNCTION, 34), // void *()(void)
/* 395 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 396 */ _CFFI_OP(_CFFI_OP_FUNCTION, 236), // void *(*()(SEXPREC *))(void)
/* 397 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 398 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 399 */ _CFFI_OP(_CFFI_OP_FUNCTION, 648), // void()(SEXPREC * *, int, SEXPREC *)
/* 400 */ _CFFI_OP(_CFFI_OP_POINTER, 3), // SEXPREC * *
/* 401 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 402 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 403 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 404 */ _CFFI_OP(_CFFI_OP_FUNCTION, 648), // void()(SEXPREC *)
/* 405 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 406 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 407 */ _CFFI_OP(_CFFI_OP_FUNCTION, 648), // void()(SEXPREC *, Rboolean)
/* 408 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 409 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 410 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 411 */ _CFFI_OP(_CFFI_OP_FUNCTION, 648), // void()(SEXPREC *, SEXPREC * *, SEXPREC * *, char const * *, char const * *)
/* 412 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 413 */ _CFFI_OP(_CFFI_OP_NOOP, 400),
/* 414 */ _CFFI_OP(_CFFI_OP_NOOP, 400),
/* 415 */ _CFFI_OP(_CFFI_OP_NOOP, 213),
/* 416 */ _CFFI_OP(_CFFI_OP_NOOP, 213),
/* 417 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 418 */ _CFFI_OP(_CFFI_OP_FUNCTION, 648), // void()(SEXPREC *, SEXPREC *)
/* 419 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 420 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 421 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 422 */ _CFFI_OP(_CFFI_OP_FUNCTION, 648), // void()(SEXPREC *, SEXPREC *, Rboolean)
/* 423 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 424 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 425 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 426 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 427 */ _CFFI_OP(_CFFI_OP_FUNCTION, 648), // void()(SEXPREC *, SEXPREC *, SEXPREC *)
/* 428 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 429 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 430 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 431 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 432 */ _CFFI_OP(_CFFI_OP_FUNCTION, 648), // void()(SEXPREC *, SEXPREC *, SEXPREC *, SEXPREC *)
/* 433 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 434 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 435 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 436 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 437 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 438 */ _CFFI_OP(_CFFI_OP_FUNCTION, 648), // void()(SEXPREC *, char const *, ...)
/* 439 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 440 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 441 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 1),
/* 442 */ _CFFI_OP(_CFFI_OP_FUNCTION, 648), // void()(SEXPREC *, int)
/* 443 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 444 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 445 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 446 */ _CFFI_OP(_CFFI_OP_FUNCTION, 648), // void()(SEXPREC *, ptrdiff_t)
/* 447 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 448 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 27),
/* 449 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 450 */ _CFFI_OP(_CFFI_OP_FUNCTION, 648), // void()(SEXPREC *, ptrdiff_t, SEXPREC *)
/* 451 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 452 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 27),
/* 453 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 454 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 455 */ _CFFI_OP(_CFFI_OP_FUNCTION, 648), // void()(SEXPREC *, void *)
/* 456 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 457 */ _CFFI_OP(_CFFI_OP_NOOP, 34),
/* 458 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 459 */ _CFFI_OP(_CFFI_OP_FUNCTION, 648), // void()(SEXPREC *, void(*)(SEXPREC *))
/* 460 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 461 */ _CFFI_OP(_CFFI_OP_NOOP, 137),
/* 462 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 463 */ _CFFI_OP(_CFFI_OP_FUNCTION, 648), // void()(SEXPREC *, void(*)(SEXPREC *), Rboolean)
/* 464 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 465 */ _CFFI_OP(_CFFI_OP_NOOP, 137),
/* 466 */ _CFFI_OP(_CFFI_OP_NOOP, 7),
/* 467 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 468 */ _CFFI_OP(_CFFI_OP_FUNCTION, 648), // void()(char *, void *)
/* 469 */ _CFFI_OP(_CFFI_OP_NOOP, 338),
/* 470 */ _CFFI_OP(_CFFI_OP_NOOP, 34),
/* 471 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 472 */ _CFFI_OP(_CFFI_OP_FUNCTION, 648), // void()(char const *)
/* 473 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 474 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 475 */ _CFFI_OP(_CFFI_OP_FUNCTION, 648), // void()(char const *, ...)
/* 476 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 477 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 1),
/* 478 */ _CFFI_OP(_CFFI_OP_FUNCTION, 648), // void()(char const *, int)
/* 479 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 480 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 481 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 482 */ _CFFI_OP(_CFFI_OP_FUNCTION, 648), // void()(char const *, int, int)
/* 483 */ _CFFI_OP(_CFFI_OP_NOOP, 25),
/* 484 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 485 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 486 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 487 */ _CFFI_OP(_CFFI_OP_FUNCTION, 648), // void()(int)
/* 488 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 489 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 490 */ _CFFI_OP(_CFFI_OP_FUNCTION, 648), // void()(int, char * *)
/* 491 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 492 */ _CFFI_OP(_CFFI_OP_NOOP, 334),
/* 493 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 494 */ _CFFI_OP(_CFFI_OP_FUNCTION, 648), // void()(int, int, int)
/* 495 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 496 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 497 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 498 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 499 */ _CFFI_OP(_CFFI_OP_FUNCTION, 648), // void()(structRstart *)
/* 500 */ _CFFI_OP(_CFFI_OP_POINTER, 615), // structRstart *
/* 501 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 502 */ _CFFI_OP(_CFFI_OP_FUNCTION, 648), // void()(void *)
/* 503 */ _CFFI_OP(_CFFI_OP_NOOP, 34),
/* 504 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 505 */ _CFFI_OP(_CFFI_OP_FUNCTION, 648), // void()(void *, void *)
/* 506 */ _CFFI_OP(_CFFI_OP_NOOP, 34),
/* 507 */ _CFFI_OP(_CFFI_OP_NOOP, 34),
/* 508 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 509 */ _CFFI_OP(_CFFI_OP_FUNCTION, 648), // void()(void const *)
/* 510 */ _CFFI_OP(_CFFI_OP_POINTER, 648), // void const *
/* 511 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 512 */ _CFFI_OP(_CFFI_OP_FUNCTION, 648), // void()(void)
/* 513 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 514 */ _CFFI_OP(_CFFI_OP_POINTER, 0), // DllInfo *(*)(void)
/* 515 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 5), // DllInfo
/* 516 */ _CFFI_OP(_CFFI_OP_ENUM, 0), // ParseStatus
/* 517 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 1), // R_CallMethodDef
/* 518 */ _CFFI_OP(_CFFI_OP_POINTER, 2), // Rboolean(*)(SEXPREC *)
/* 519 */ _CFFI_OP(_CFFI_OP_POINTER, 5), // Rboolean(*)(SEXPREC *, Rboolean)
/* 520 */ _CFFI_OP(_CFFI_OP_POINTER, 9), // Rboolean(*)(SEXPREC *, SEXPREC *)
/* 521 */ _CFFI_OP(_CFFI_OP_POINTER, 13), // Rboolean(*)(SEXPREC *, SEXPREC *, Rboolean)
/* 522 */ _CFFI_OP(_CFFI_OP_POINTER, 18), // Rboolean(*)(SEXPREC *, SEXPREC *, int)
/* 523 */ _CFFI_OP(_CFFI_OP_POINTER, 23), // Rboolean(*)(SEXPREC *, char const *)
/* 524 */ _CFFI_OP(_CFFI_OP_POINTER, 27), // Rboolean(*)(char const *, char const *, Rboolean)
/* 525 */ _CFFI_OP(_CFFI_OP_POINTER, 32), // Rboolean(*)(void(*)(void *), void *)
/* 526 */ _CFFI_OP(_CFFI_OP_POINTER, 36), // Rcomplex *(*)(SEXPREC *)
/* 527 */ _CFFI_OP(_CFFI_OP_POINTER, 43), // Rcomplex *
/* 528 */ _CFFI_OP(_CFFI_OP_POINTER, 39), // Rcomplex(*)(SEXPREC *)
/* 529 */ _CFFI_OP(_CFFI_OP_POINTER, 42), // SEXPREC *(*)(Rcomplex)
/* 530 */ _CFFI_OP(_CFFI_OP_POINTER, 45), // SEXPREC *(*)(SEXPREC *(*)(void *), void *, SEXPREC *(*)(SEXPREC *, void *), void *)
/* 531 */ _CFFI_OP(_CFFI_OP_POINTER, 51), // SEXPREC *(*)(SEXPREC *(*)(void *), void *, SEXPREC *, SEXPREC *(*)(SEXPREC *, void *), void *, void(*)(void *), void *)
/* 532 */ _CFFI_OP(_CFFI_OP_POINTER, 60), // SEXPREC *(*)(SEXPREC *)
/* 533 */ _CFFI_OP(_CFFI_OP_POINTER, 63), // SEXPREC *(*)(SEXPREC *, Rboolean)
/* 534 */ _CFFI_OP(_CFFI_OP_POINTER, 67), // SEXPREC *(*)(SEXPREC *, Rboolean, Rboolean)
/* 535 */ _CFFI_OP(_CFFI_OP_POINTER, 72), // SEXPREC *(*)(SEXPREC *, Rboolean, int)
/* 536 */ _CFFI_OP(_CFFI_OP_POINTER, 81), // SEXPREC *(*)(SEXPREC *, SEXPREC *, Rboolean)
/* 537 */ _CFFI_OP(_CFFI_OP_POINTER, 86), // SEXPREC *(*)(SEXPREC *, SEXPREC *, SEXPREC *)
/* 538 */ _CFFI_OP(_CFFI_OP_POINTER, 91), // SEXPREC *(*)(SEXPREC *, SEXPREC *, SEXPREC *, Rboolean)
/* 539 */ _CFFI_OP(_CFFI_OP_POINTER, 97), // SEXPREC *(*)(SEXPREC *, SEXPREC *, SEXPREC *, SEXPREC *)
/* 540 */ _CFFI_OP(_CFFI_OP_POINTER, 103), // SEXPREC *(*)(SEXPREC *, SEXPREC *, SEXPREC *, SEXPREC *, SEXPREC *)
/* 541 */ _CFFI_OP(_CFFI_OP_POINTER, 110), // SEXPREC *(*)(SEXPREC *, SEXPREC *, SEXPREC *, SEXPREC *, SEXPREC *, SEXPREC *)
/* 542 */ _CFFI_OP(_CFFI_OP_POINTER, 118), // SEXPREC *(*)(SEXPREC *, SEXPREC *, int *)
/* 543 */ _CFFI_OP(_CFFI_OP_POINTER, 123), // SEXPREC *(*)(SEXPREC *, SEXPREC *, int)
/* 544 */ _CFFI_OP(_CFFI_OP_POINTER, 128), // SEXPREC *(*)(SEXPREC *, SEXPREC *, int, SEXPREC *)
/* 545 */ _CFFI_OP(_CFFI_OP_POINTER, 134), // SEXPREC *(*)(SEXPREC *, SEXPREC *, void(*)(SEXPREC *), Rboolean)
/* 546 */ _CFFI_OP(_CFFI_OP_POINTER, 144), // SEXPREC *(*)(SEXPREC *, int, ParseStatus *, SEXPREC *)
/* 547 */ _CFFI_OP(_CFFI_OP_POINTER, 150), // SEXPREC *(*)(SEXPREC *, ptrdiff_t)
/* 548 */ _CFFI_OP(_CFFI_OP_POINTER, 154), // SEXPREC *(*)(SEXPREC *, ptrdiff_t, SEXPREC *)
/* 549 */ _CFFI_OP(_CFFI_OP_POINTER, 159), // SEXPREC *(*)(SEXPREC *, unsigned int)
/* 550 */ _CFFI_OP(_CFFI_OP_POINTER, 167), // SEXPREC *(*)(char const *)
/* 551 */ _CFFI_OP(_CFFI_OP_POINTER, 170), // SEXPREC *(*)(char const *, SEXPREC *)
/* 552 */ _CFFI_OP(_CFFI_OP_POINTER, 174), // SEXPREC *(*)(char const *, cetype_t)
/* 553 */ _CFFI_OP(_CFFI_OP_POINTER, 178), // SEXPREC *(*)(char const *, int)
/* 554 */ _CFFI_OP(_CFFI_OP_POINTER, 182), // SEXPREC *(*)(char const *, int, cetype_t)
/* 555 */ _CFFI_OP(_CFFI_OP_POINTER, 187), // SEXPREC *(*)(double)
/* 556 */ _CFFI_OP(_CFFI_OP_POINTER, 190), // SEXPREC *(*)(int)
/* 557 */ _CFFI_OP(_CFFI_OP_POINTER, 193), // SEXPREC *(*)(int, SEXPREC *, SEXPREC *, SEXPREC *(*)(SEXPREC *, SEXPREC *), SEXPREC *(*)(SEXPREC *, int), SEXPREC *)
/* 558 */ _CFFI_OP(_CFFI_OP_POINTER, 201), // SEXPREC *(*)(unsigned char)
/* 559 */ _CFFI_OP(_CFFI_OP_POINTER, 204), // SEXPREC *(*)(unsigned int)
/* 560 */ _CFFI_OP(_CFFI_OP_POINTER, 207), // SEXPREC *(*)(unsigned int, SEXPREC *)
/* 561 */ _CFFI_OP(_CFFI_OP_POINTER, 211), // SEXPREC *(*)(unsigned int, char const * *)
/* 562 */ _CFFI_OP(_CFFI_OP_POINTER, 215), // SEXPREC *(*)(unsigned int, int, int)
/* 563 */ _CFFI_OP(_CFFI_OP_POINTER, 220), // SEXPREC *(*)(unsigned int, int, int, int)
/* 564 */ _CFFI_OP(_CFFI_OP_POINTER, 226), // SEXPREC *(*)(unsigned int, ptrdiff_t)
/* 565 */ _CFFI_OP(_CFFI_OP_POINTER, 230), // SEXPREC *(*)(unsigned int, ptrdiff_t, void *)
/* 566 */ _CFFI_OP(_CFFI_OP_POINTER, 235), // SEXPREC *(*)(void *(*)(void), SEXPREC *, SEXPREC *)
/* 567 */ _CFFI_OP(_CFFI_OP_POINTER, 243), // SEXPREC *(*)(void *, SEXPREC *, SEXPREC *)
/* 568 */ _CFFI_OP(_CFFI_OP_POINTER, 248), // SEXPREC *(*)(void)
/* 569 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 4), // SEXPREC
/* 570 */ _CFFI_OP(_CFFI_OP_POINTER, 250), // cetype_t(*)(SEXPREC *)
/* 571 */ _CFFI_OP(_CFFI_OP_POINTER, 253), // char *(*)(char const *)
/* 572 */ _CFFI_OP(_CFFI_OP_POINTER, 256), // char *(*)(size_t, int)
/* 573 */ _CFFI_OP(_CFFI_OP_POINTER, 262), // char const *(*)(SEXPREC *)
/* 574 */ _CFFI_OP(_CFFI_OP_POINTER, 265), // char const *(*)(char const *, cetype_t, cetype_t, int)
/* 575 */ _CFFI_OP(_CFFI_OP_POINTER, 271), // char const *(*)(unsigned int)
/* 576 */ _CFFI_OP(_CFFI_OP_POINTER, 274), // char const *(*)(void)
/* 577 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 2), // char
/* 578 */ _CFFI_OP(_CFFI_OP_ARRAY, 577), // char[100]
/* 579 */ (_cffi_opcode_t)(100),
/* 580 */ _CFFI_OP(_CFFI_OP_POINTER, 276), // double *(*)(SEXPREC *)
/* 581 */ _CFFI_OP(_CFFI_OP_POINTER, 188), // double *
/* 582 */ _CFFI_OP(_CFFI_OP_POINTER, 279), // double(*)(SEXPREC *)
/* 583 */ _CFFI_OP(_CFFI_OP_POINTER, 282), // int *(*)(SEXPREC *)
/* 584 */ _CFFI_OP(_CFFI_OP_POINTER, 285), // int(*)(DllInfo *, void *, void *, void *, void *)
/* 585 */ _CFFI_OP(_CFFI_OP_POINTER, 292), // int(*)(SEXPREC *)
/* 586 */ _CFFI_OP(_CFFI_OP_POINTER, 295), // int(*)(SEXPREC *, SEXPREC *)
/* 587 */ _CFFI_OP(_CFFI_OP_POINTER, 299), // int(*)(SEXPREC *, char const *)
/* 588 */ _CFFI_OP(_CFFI_OP_POINTER, 303), // int(*)(SEXPREC *, int)
/* 589 */ _CFFI_OP(_CFFI_OP_POINTER, 307), // int(*)(SEXPREC *, int, SEXPREC *, SEXPREC *)
/* 590 */ _CFFI_OP(_CFFI_OP_POINTER, 313), // int(*)(SEXPREC *, nchar_type, Rboolean, Rboolean, char const *)
/* 591 */ _CFFI_OP(_CFFI_OP_POINTER, 320), // int(*)(char const *)
/* 592 */ _CFFI_OP(_CFFI_OP_POINTER, 323), // int(*)(char const *, unsigned char *, int, int)
/* 593 */ _CFFI_OP(_CFFI_OP_POINTER, 329), // int(*)(double)
/* 594 */ _CFFI_OP(_CFFI_OP_POINTER, 332), // int(*)(int, char * *)
/* 595 */ _CFFI_OP(_CFFI_OP_POINTER, 336), // int(*)(int, char *, int)
/* 596 */ _CFFI_OP(_CFFI_OP_POINTER, 341), // int(*)(int, char const * *, char const * *, char const *)
/* 597 */ _CFFI_OP(_CFFI_OP_POINTER, 347), // int(*)(int, char const * *, char const * *, char const *, Rboolean, char const *)
/* 598 */ _CFFI_OP(_CFFI_OP_POINTER, 355), // int(*)(int, int)
/* 599 */ _CFFI_OP(_CFFI_OP_POINTER, 359), // int(*)(int, int, int)
/* 600 */ _CFFI_OP(_CFFI_OP_POINTER, 364), // int(*)(void)
/* 601 */ _CFFI_OP(_CFFI_OP_POINTER, 366), // long double *(*)(size_t)
/* 602 */ _CFFI_OP(_CFFI_OP_POINTER, 603), // long double *
/* 603 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 15), // long double
/* 604 */ _CFFI_OP(_CFFI_OP_POINTER, 369), // ptrdiff_t(*)(SEXPREC *)
/* 605 */ _CFFI_OP(_CFFI_OP_POINTER, 372), // ptrdiff_t(*)(SEXPREC *, Rboolean)
/* 606 */ _CFFI_OP(_CFFI_OP_POINTER, 376), // ptrdiff_t(*)(SEXPREC *, SEXPREC *, Rboolean)
/* 607 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 6), // struct closxp_struct
/* 608 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 7), // struct envsxp_struct
/* 609 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 8), // struct listsxp_struct
/* 610 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 9), // struct primsxp_struct
/* 611 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 10), // struct promsxp_struct
/* 612 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 11), // struct sxpinfo_struct
/* 613 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 12), // struct symsxp_struct
/* 614 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 13), // struct vecsxp_struct
/* 615 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 3), // structRstart
/* 616 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 0), // union $1
/* 617 */ _CFFI_OP(_CFFI_OP_POINTER, 381), // unsigned char *(*)(SEXPREC *)
/* 618 */ _CFFI_OP(_CFFI_OP_POINTER, 384), // unsigned int(*)(char const *)
/* 619 */ _CFFI_OP(_CFFI_OP_POINTER, 396), // void *(*(*)(SEXPREC *))(void)
/* 620 */ _CFFI_OP(_CFFI_OP_POINTER, 387), // void *(*)(SEXPREC *)
/* 621 */ _CFFI_OP(_CFFI_OP_POINTER, 390), // void *(*)(int, int)
/* 622 */ _CFFI_OP(_CFFI_OP_POINTER, 647), // void(* *)(void)
/* 623 */ _CFFI_OP(_CFFI_OP_POINTER, 399), // void(*)(SEXPREC * *, int, SEXPREC *)
/* 624 */ _CFFI_OP(_CFFI_OP_POINTER, 407), // void(*)(SEXPREC *, Rboolean)
/* 625 */ _CFFI_OP(_CFFI_OP_POINTER, 411), // void(*)(SEXPREC *, SEXPREC * *, SEXPREC * *, char const * *, char const * *)
/* 626 */ _CFFI_OP(_CFFI_OP_POINTER, 418), // void(*)(SEXPREC *, SEXPREC *)
/* 627 */ _CFFI_OP(_CFFI_OP_POINTER, 422), // void(*)(SEXPREC *, SEXPREC *, Rboolean)
/* 628 */ _CFFI_OP(_CFFI_OP_POINTER, 427), // void(*)(SEXPREC *, SEXPREC *, SEXPREC *)
/* 629 */ _CFFI_OP(_CFFI_OP_POINTER, 432), // void(*)(SEXPREC *, SEXPREC *, SEXPREC *, SEXPREC *)
/* 630 */ _CFFI_OP(_CFFI_OP_POINTER, 438), // void(*)(SEXPREC *, char const *, ...)
/* 631 */ _CFFI_OP(_CFFI_OP_POINTER, 442), // void(*)(SEXPREC *, int)
/* 632 */ _CFFI_OP(_CFFI_OP_POINTER, 446), // void(*)(SEXPREC *, ptrdiff_t)
/* 633 */ _CFFI_OP(_CFFI_OP_POINTER, 450), // void(*)(SEXPREC *, ptrdiff_t, SEXPREC *)
/* 634 */ _CFFI_OP(_CFFI_OP_POINTER, 455), // void(*)(SEXPREC *, void *)
/* 635 */ _CFFI_OP(_CFFI_OP_POINTER, 459), // void(*)(SEXPREC *, void(*)(SEXPREC *))
/* 636 */ _CFFI_OP(_CFFI_OP_POINTER, 463), // void(*)(SEXPREC *, void(*)(SEXPREC *), Rboolean)
/* 637 */ _CFFI_OP(_CFFI_OP_POINTER, 472), // void(*)(char const *)
/* 638 */ _CFFI_OP(_CFFI_OP_POINTER, 475), // void(*)(char const *, ...)
/* 639 */ _CFFI_OP(_CFFI_OP_POINTER, 478), // void(*)(char const *, int)
/* 640 */ _CFFI_OP(_CFFI_OP_POINTER, 482), // void(*)(char const *, int, int)
/* 641 */ _CFFI_OP(_CFFI_OP_POINTER, 487), // void(*)(int)
/* 642 */ _CFFI_OP(_CFFI_OP_POINTER, 490), // void(*)(int, char * *)
/* 643 */ _CFFI_OP(_CFFI_OP_POINTER, 494), // void(*)(int, int, int)
/* 644 */ _CFFI_OP(_CFFI_OP_POINTER, 499), // void(*)(structRstart *)
/* 645 */ _CFFI_OP(_CFFI_OP_POINTER, 505), // void(*)(void *, void *)
/* 646 */ _CFFI_OP(_CFFI_OP_POINTER, 509), // void(*)(void const *)
/* 647 */ _CFFI_OP(_CFFI_OP_POINTER, 512), // void(*)(void)
/* 648 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 0), // void
};

static int _cffi_const_PARSE_NULL(unsigned long long *o)
{
  int n = (PARSE_NULL) <= 0;
  *o = (unsigned long long)((PARSE_NULL) | 0);  /* check that PARSE_NULL is an integer */
  return n;
}

static int _cffi_const_PARSE_OK(unsigned long long *o)
{
  int n = (PARSE_OK) <= 0;
  *o = (unsigned long long)((PARSE_OK) | 0);  /* check that PARSE_OK is an integer */
  return n;
}

static int _cffi_const_PARSE_INCOMPLETE(unsigned long long *o)
{
  int n = (PARSE_INCOMPLETE) <= 0;
  *o = (unsigned long long)((PARSE_INCOMPLETE) | 0);  /* check that PARSE_INCOMPLETE is an integer */
  return n;
}

static int _cffi_const_PARSE_ERROR(unsigned long long *o)
{
  int n = (PARSE_ERROR) <= 0;
  *o = (unsigned long long)((PARSE_ERROR) | 0);  /* check that PARSE_ERROR is an integer */
  return n;
}

static int _cffi_const_PARSE_EOF(unsigned long long *o)
{
  int n = (PARSE_EOF) <= 0;
  *o = (unsigned long long)((PARSE_EOF) | 0);  /* check that PARSE_EOF is an integer */
  return n;
}

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_R_CallMethodDef(R_CallMethodDef *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { char const * *tmp = &p->name; (void)tmp; }
  { void *(* *tmp)(void) = &p->fun; (void)tmp; }
  (void)((p->numArgs) | 0);  /* check that 'R_CallMethodDef.numArgs' is an integer */
}
struct _cffi_align_typedef_R_CallMethodDef { char x; R_CallMethodDef y; };

static int _cffi_const_FALSE(unsigned long long *o)
{
  int n = (FALSE) <= 0;
  *o = (unsigned long long)((FALSE) | 0);  /* check that FALSE is an integer */
  return n;
}

static int _cffi_const_TRUE(unsigned long long *o)
{
  int n = (TRUE) <= 0;
  *o = (unsigned long long)((TRUE) | 0);  /* check that TRUE is an integer */
  return n;
}

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_Rcomplex(Rcomplex *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { double *tmp = &p->r; (void)tmp; }
  { double *tmp = &p->i; (void)tmp; }
}
struct _cffi_align_typedef_Rcomplex { char x; Rcomplex y; };

static int _cffi_const_CE_NATIVE(unsigned long long *o)
{
  int n = (CE_NATIVE) <= 0;
  *o = (unsigned long long)((CE_NATIVE) | 0);  /* check that CE_NATIVE is an integer */
  return n;
}

static int _cffi_const_CE_UTF8(unsigned long long *o)
{
  int n = (CE_UTF8) <= 0;
  *o = (unsigned long long)((CE_UTF8) | 0);  /* check that CE_UTF8 is an integer */
  return n;
}

static int _cffi_const_CE_LATIN1(unsigned long long *o)
{
  int n = (CE_LATIN1) <= 0;
  *o = (unsigned long long)((CE_LATIN1) | 0);  /* check that CE_LATIN1 is an integer */
  return n;
}

static int _cffi_const_CE_BYTES(unsigned long long *o)
{
  int n = (CE_BYTES) <= 0;
  *o = (unsigned long long)((CE_BYTES) | 0);  /* check that CE_BYTES is an integer */
  return n;
}

static int _cffi_const_CE_SYMBOL(unsigned long long *o)
{
  int n = (CE_SYMBOL) <= 0;
  *o = (unsigned long long)((CE_SYMBOL) | 0);  /* check that CE_SYMBOL is an integer */
  return n;
}

static int _cffi_const_CE_ANY(unsigned long long *o)
{
  int n = (CE_ANY) <= 0;
  *o = (unsigned long long)((CE_ANY) | 0);  /* check that CE_ANY is an integer */
  return n;
}

static int _cffi_const_Bytes(unsigned long long *o)
{
  int n = (Bytes) <= 0;
  *o = (unsigned long long)((Bytes) | 0);  /* check that Bytes is an integer */
  return n;
}

static int _cffi_const_Chars(unsigned long long *o)
{
  int n = (Chars) <= 0;
  *o = (unsigned long long)((Chars) | 0);  /* check that Chars is an integer */
  return n;
}

static int _cffi_const_Width(unsigned long long *o)
{
  int n = (Width) <= 0;
  *o = (unsigned long long)((Width) | 0);  /* check that Width is an integer */
  return n;
}

_CFFI_UNUSED_FN
static void _cffi_checkfld_typedef_structRstart(structRstart *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { Rboolean *tmp = &p->R_Quiet; (void)tmp; }
  { Rboolean *tmp = &p->R_Slave; (void)tmp; }
  { Rboolean *tmp = &p->R_Interactive; (void)tmp; }
  { Rboolean *tmp = &p->R_Verbose; (void)tmp; }
  { Rboolean *tmp = &p->LoadSiteFile; (void)tmp; }
  { Rboolean *tmp = &p->LoadInitFile; (void)tmp; }
  { Rboolean *tmp = &p->DebugInitFile; (void)tmp; }
  (void)((p->RestoreAction) | 0);  /* check that 'structRstart.RestoreAction' is an integer */
  (void)((p->SaveAction) | 0);  /* check that 'structRstart.SaveAction' is an integer */
  (void)((p->vsize) | 0);  /* check that 'structRstart.vsize' is an integer */
  (void)((p->nsize) | 0);  /* check that 'structRstart.nsize' is an integer */
  (void)((p->max_vsize) | 0);  /* check that 'structRstart.max_vsize' is an integer */
  (void)((p->max_nsize) | 0);  /* check that 'structRstart.max_nsize' is an integer */
  (void)((p->ppsize) | 0);  /* check that 'structRstart.ppsize' is an integer */
  (void)((p->NoRenviron) | 0);  /* check that 'structRstart.NoRenviron' is an integer */
  { char * *tmp = &p->rhome; (void)tmp; }
  { char * *tmp = &p->home; (void)tmp; }
  { int(* *tmp)(char const *, unsigned char *, int, int) = &p->_ReadConsole; (void)tmp; }
  { void(* *tmp)(char const *, int) = &p->_WriteConsole; (void)tmp; }
  { void(* *tmp)(void) = &p->CallBack; (void)tmp; }
  { void(* *tmp)(char const *) = &p->ShowMessage; (void)tmp; }
  { int(* *tmp)(char const *) = &p->YesNoCancel; (void)tmp; }
  { void(* *tmp)(int) = &p->Busy; (void)tmp; }
  (void)((p->CharacterMode) | 0);  /* check that 'structRstart.CharacterMode' is an integer */
  { void(* *tmp)(char const *, int, int) = &p->WriteConsoleEx; (void)tmp; }
}
struct _cffi_align_typedef_structRstart { char x; structRstart y; };

static struct _cffi_externpy_s _cffi_externpy__cb_addhistory =
  { "rchitect._cffi.cb_addhistory", 0, 0, 0 };

void cb_addhistory(SEXPREC * a0, SEXPREC * a1, SEXPREC * a2, SEXPREC * a3)
{
  char a[32];
  char *p = a;
  *(SEXPREC * *)(p + 0) = a0;
  *(SEXPREC * *)(p + 8) = a1;
  *(SEXPREC * *)(p + 16) = a2;
  *(SEXPREC * *)(p + 24) = a3;
  _cffi_call_python(&_cffi_externpy__cb_addhistory, p);
}

static struct _cffi_externpy_s _cffi_externpy__cb_busy =
  { "rchitect._cffi.cb_busy", 0, 0, 0 };

void cb_busy(int a0)
{
  char a[8];
  char *p = a;
  *(int *)(p + 0) = a0;
  _cffi_call_python(&_cffi_externpy__cb_busy, p);
}

static struct _cffi_externpy_s _cffi_externpy__cb_choose_file =
  { "rchitect._cffi.cb_choose_file", (int)sizeof(int), 0, 0 };

int cb_choose_file(int a0, char * a1, int a2)
{
  char a[24];
  char *p = a;
  *(int *)(p + 0) = a0;
  *(char * *)(p + 8) = a1;
  *(int *)(p + 16) = a2;
  _cffi_call_python(&_cffi_externpy__cb_choose_file, p);
  return *(int *)p;
}

static struct _cffi_externpy_s _cffi_externpy__cb_clean_up =
  { "rchitect._cffi.cb_clean_up", 0, 0, 0 };

void cb_clean_up(int a0, int a1, int a2)
{
  char a[24];
  char *p = a;
  *(int *)(p + 0) = a0;
  *(int *)(p + 8) = a1;
  *(int *)(p + 16) = a2;
  _cffi_call_python(&_cffi_externpy__cb_clean_up, p);
}

static struct _cffi_externpy_s _cffi_externpy__cb_clearerr_console =
  { "rchitect._cffi.cb_clearerr_console", 0, 0, 0 };

void cb_clearerr_console(void)
{
  char a[8];
  char *p = a;
  _cffi_call_python(&_cffi_externpy__cb_clearerr_console, p);
}

static struct _cffi_externpy_s _cffi_externpy__cb_do_dataentry =
  { "rchitect._cffi.cb_do_dataentry", (int)sizeof(SEXPREC *), 0, 0 };

SEXPREC * cb_do_dataentry(SEXPREC * a0, SEXPREC * a1, SEXPREC * a2, SEXPREC * a3)
{
  char a[32];
  char *p = a;
  *(SEXPREC * *)(p + 0) = a0;
  *(SEXPREC * *)(p + 8) = a1;
  *(SEXPREC * *)(p + 16) = a2;
  *(SEXPREC * *)(p + 24) = a3;
  _cffi_call_python(&_cffi_externpy__cb_do_dataentry, p);
  return *(SEXPREC * *)p;
}

static struct _cffi_externpy_s _cffi_externpy__cb_do_dataviewer =
  { "rchitect._cffi.cb_do_dataviewer", (int)sizeof(SEXPREC *), 0, 0 };

SEXPREC * cb_do_dataviewer(SEXPREC * a0, SEXPREC * a1, SEXPREC * a2, SEXPREC * a3)
{
  char a[32];
  char *p = a;
  *(SEXPREC * *)(p + 0) = a0;
  *(SEXPREC * *)(p + 8) = a1;
  *(SEXPREC * *)(p + 16) = a2;
  *(SEXPREC * *)(p + 24) = a3;
  _cffi_call_python(&_cffi_externpy__cb_do_dataviewer, p);
  return *(SEXPREC * *)p;
}

static struct _cffi_externpy_s _cffi_externpy__cb_do_selectlist =
  { "rchitect._cffi.cb_do_selectlist", (int)sizeof(SEXPREC *), 0, 0 };

SEXPREC * cb_do_selectlist(SEXPREC * a0, SEXPREC * a1, SEXPREC * a2, SEXPREC * a3)
{
  char a[32];
  char *p = a;
  *(SEXPREC * *)(p + 0) = a0;
  *(SEXPREC * *)(p + 8) = a1;
  *(SEXPREC * *)(p + 16) = a2;
  *(SEXPREC * *)(p + 24) = a3;
  _cffi_call_python(&_cffi_externpy__cb_do_selectlist, p);
  return *(SEXPREC * *)p;
}

static struct _cffi_externpy_s _cffi_externpy__cb_edit_file =
  { "rchitect._cffi.cb_edit_file", (int)sizeof(int), 0, 0 };

int cb_edit_file(char const * a0)
{
  char a[8];
  char *p = a;
  *(char const * *)(p + 0) = a0;
  _cffi_call_python(&_cffi_externpy__cb_edit_file, p);
  return *(int *)p;
}

static struct _cffi_externpy_s _cffi_externpy__cb_edit_files =
  { "rchitect._cffi.cb_edit_files", (int)sizeof(int), 0, 0 };

int cb_edit_files(int a0, char const * * a1, char const * * a2, char const * a3)
{
  char a[32];
  char *p = a;
  *(int *)(p + 0) = a0;
  *(char const * * *)(p + 8) = a1;
  *(char const * * *)(p + 16) = a2;
  *(char const * *)(p + 24) = a3;
  _cffi_call_python(&_cffi_externpy__cb_edit_files, p);
  return *(int *)p;
}

static struct _cffi_externpy_s _cffi_externpy__cb_flush_console =
  { "rchitect._cffi.cb_flush_console", 0, 0, 0 };

void cb_flush_console(void)
{
  char a[8];
  char *p = a;
  _cffi_call_python(&_cffi_externpy__cb_flush_console, p);
}

static struct _cffi_externpy_s _cffi_externpy__cb_loadhistory =
  { "rchitect._cffi.cb_loadhistory", 0, 0, 0 };

void cb_loadhistory(SEXPREC * a0, SEXPREC * a1, SEXPREC * a2, SEXPREC * a3)
{
  char a[32];
  char *p = a;
  *(SEXPREC * *)(p + 0) = a0;
  *(SEXPREC * *)(p + 8) = a1;
  *(SEXPREC * *)(p + 16) = a2;
  *(SEXPREC * *)(p + 24) = a3;
  _cffi_call_python(&_cffi_externpy__cb_loadhistory, p);
}

static struct _cffi_externpy_s _cffi_externpy__cb_polled_events =
  { "rchitect._cffi.cb_polled_events", 0, 0, 0 };

void cb_polled_events(void)
{
  char a[8];
  char *p = a;
  _cffi_call_python(&_cffi_externpy__cb_polled_events, p);
}

static struct _cffi_externpy_s _cffi_externpy__cb_process_events =
  { "rchitect._cffi.cb_process_events", 0, 0, 0 };

void cb_process_events(void)
{
  char a[8];
  char *p = a;
  _cffi_call_python(&_cffi_externpy__cb_process_events, p);
}

static struct _cffi_externpy_s _cffi_externpy__cb_read_console =
  { "rchitect._cffi.cb_read_console", (int)sizeof(int), 0, 0 };

int cb_read_console(char const * a0, unsigned char * a1, int a2, int a3)
{
  char a[32];
  char *p = a;
  *(char const * *)(p + 0) = a0;
  *(unsigned char * *)(p + 8) = a1;
  *(int *)(p + 16) = a2;
  *(int *)(p + 24) = a3;
  _cffi_call_python(&_cffi_externpy__cb_read_console, p);
  return *(int *)p;
}

static struct _cffi_externpy_s _cffi_externpy__cb_reset_console =
  { "rchitect._cffi.cb_reset_console", 0, 0, 0 };

void cb_reset_console(void)
{
  char a[8];
  char *p = a;
  _cffi_call_python(&_cffi_externpy__cb_reset_console, p);
}

static struct _cffi_externpy_s _cffi_externpy__cb_savehistory =
  { "rchitect._cffi.cb_savehistory", 0, 0, 0 };

void cb_savehistory(SEXPREC * a0, SEXPREC * a1, SEXPREC * a2, SEXPREC * a3)
{
  char a[32];
  char *p = a;
  *(SEXPREC * *)(p + 0) = a0;
  *(SEXPREC * *)(p + 8) = a1;
  *(SEXPREC * *)(p + 16) = a2;
  *(SEXPREC * *)(p + 24) = a3;
  _cffi_call_python(&_cffi_externpy__cb_savehistory, p);
}

static struct _cffi_externpy_s _cffi_externpy__cb_show_files =
  { "rchitect._cffi.cb_show_files", (int)sizeof(int), 0, 0 };

int cb_show_files(int a0, char const * * a1, char const * * a2, char const * a3, Rboolean a4, char const * a5)
{
  char a[48];
  char *p = a;
  *(int *)(p + 0) = a0;
  *(char const * * *)(p + 8) = a1;
  *(char const * * *)(p + 16) = a2;
  *(char const * *)(p + 24) = a3;
  *(Rboolean *)(p + 32) = a4;
  *(char const * *)(p + 40) = a5;
  _cffi_call_python(&_cffi_externpy__cb_show_files, p);
  return *(int *)p;
}

static struct _cffi_externpy_s _cffi_externpy__cb_show_message =
  { "rchitect._cffi.cb_show_message", 0, 0, 0 };

void cb_show_message(char const * a0)
{
  char a[8];
  char *p = a;
  *(char const * *)(p + 0) = a0;
  _cffi_call_python(&_cffi_externpy__cb_show_message, p);
}

static struct _cffi_externpy_s _cffi_externpy__cb_suicide =
  { "rchitect._cffi.cb_suicide", 0, 0, 0 };

void cb_suicide(char const * a0)
{
  char a[8];
  char *p = a;
  *(char const * *)(p + 0) = a0;
  _cffi_call_python(&_cffi_externpy__cb_suicide, p);
}

static struct _cffi_externpy_s _cffi_externpy__cb_write_console =
  { "rchitect._cffi.cb_write_console", 0, 0, 0 };

void cb_write_console(char const * a0, int a1)
{
  char a[16];
  char *p = a;
  *(char const * *)(p + 0) = a0;
  *(int *)(p + 8) = a1;
  _cffi_call_python(&_cffi_externpy__cb_write_console, p);
}

static struct _cffi_externpy_s _cffi_externpy__cb_write_console_capturable =
  { "rchitect._cffi.cb_write_console_capturable", 0, 0, 0 };

void cb_write_console_capturable(char const * a0, int a1, int a2)
{
  char a[24];
  char *p = a;
  *(char const * *)(p + 0) = a0;
  *(int *)(p + 8) = a1;
  *(int *)(p + 16) = a2;
  _cffi_call_python(&_cffi_externpy__cb_write_console_capturable, p);
}

static struct _cffi_externpy_s _cffi_externpy__cb_write_console_ex =
  { "rchitect._cffi.cb_write_console_ex", 0, 0, 0 };

void cb_write_console_ex(char const * a0, int a1, int a2)
{
  char a[24];
  char *p = a;
  *(char const * *)(p + 0) = a0;
  *(int *)(p + 8) = a1;
  *(int *)(p + 16) = a2;
  _cffi_call_python(&_cffi_externpy__cb_write_console_ex, p);
}

static struct _cffi_externpy_s _cffi_externpy__cb_yes_no_cancel =
  { "rchitect._cffi.cb_yes_no_cancel", (int)sizeof(int), 0, 0 };

int cb_yes_no_cancel(char const * a0)
{
  char a[8];
  char *p = a;
  *(char const * *)(p + 0) = a0;
  _cffi_call_python(&_cffi_externpy__cb_yes_no_cancel, p);
  return *(int *)p;
}

static struct _cffi_externpy_s _cffi_externpy__xptr_callback =
  { "rchitect._cffi.xptr_callback", (int)sizeof(SEXPREC *), 0, 0 };

SEXPREC * xptr_callback(SEXPREC * a0, SEXPREC * a1, SEXPREC * a2, SEXPREC * a3)
{
  char a[32];
  char *p = a;
  *(SEXPREC * *)(p + 0) = a0;
  *(SEXPREC * *)(p + 8) = a1;
  *(SEXPREC * *)(p + 16) = a2;
  *(SEXPREC * *)(p + 24) = a3;
  _cffi_call_python(&_cffi_externpy__xptr_callback, p);
  return *(SEXPREC * *)p;
}

static struct _cffi_externpy_s _cffi_externpy__xptr_finalizer =
  { "rchitect._cffi.xptr_finalizer", 0, 0, 0 };

void xptr_finalizer(SEXPREC * a0)
{
  char a[8];
  char *p = a;
  *(SEXPREC * *)(p + 0) = a0;
  _cffi_call_python(&_cffi_externpy__xptr_finalizer, p);
}

static SEXPREC * _cffi_d_R_ParseVector(SEXPREC * x0, int x1, ParseStatus * x2, SEXPREC * x3)
{
  return R_ParseVector(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_R_ParseVector(PyObject *self, PyObject *args)
{
  SEXPREC * x0;
  int x1;
  ParseStatus * x2;
  SEXPREC * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  SEXPREC * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "R_ParseVector", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(147), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (ParseStatus *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(147), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = R_ParseVector(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(3));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_R_ParseVector _cffi_d_R_ParseVector
#endif

static SEXPREC * _cffi_d_R_tryEval(SEXPREC * x0, SEXPREC * x1, int * x2)
{
  return R_tryEval(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_R_tryEval(PyObject *self, PyObject *args)
{
  SEXPREC * x0;
  SEXPREC * x1;
  int * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  SEXPREC * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "R_tryEval", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(121), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(121), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = R_tryEval(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(3));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_R_tryEval _cffi_d_R_tryEval
#endif

static char * _cffi_d__libR_dl_error_message(void)
{
  return _libR_dl_error_message();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f__libR_dl_error_message(PyObject *self, PyObject *noarg)
{
  char * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = _libR_dl_error_message(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(338));
  return pyresult;
}
#else
#  define _cffi_f__libR_dl_error_message _cffi_d__libR_dl_error_message
#endif

static int _cffi_d__libR_is_initialized(void)
{
  return _libR_is_initialized();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f__libR_is_initialized(PyObject *self, PyObject *noarg)
{
  int result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = _libR_is_initialized(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f__libR_is_initialized _cffi_d__libR_is_initialized
#endif

static char * _cffi_d__libR_last_loaded_symbol(void)
{
  return _libR_last_loaded_symbol();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f__libR_last_loaded_symbol(PyObject *self, PyObject *noarg)
{
  char * result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = _libR_last_loaded_symbol(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(338));
  return pyresult;
}
#else
#  define _cffi_f__libR_last_loaded_symbol _cffi_d__libR_last_loaded_symbol
#endif

static int _cffi_d__libR_load(char const * x0)
{
  return _libR_load(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f__libR_load(PyObject *self, PyObject *arg0)
{
  char const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = _libR_load(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f__libR_load _cffi_d__libR_load
#endif

static int _cffi_d__libR_load_constants(void)
{
  return _libR_load_constants();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f__libR_load_constants(PyObject *self, PyObject *noarg)
{
  int result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = _libR_load_constants(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f__libR_load_constants _cffi_d__libR_load_constants
#endif

static int _cffi_d__libR_load_symbols(void)
{
  return _libR_load_symbols();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f__libR_load_symbols(PyObject *self, PyObject *noarg)
{
  int result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = _libR_load_symbols(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f__libR_load_symbols _cffi_d__libR_load_symbols
#endif

static void _cffi_d__libR_set_callback(char * x0, void * x1)
{
  _libR_set_callback(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f__libR_set_callback(PyObject *self, PyObject *args)
{
  char * x0;
  void * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "_libR_set_callback", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(338), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(338), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(34), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(34), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { _libR_set_callback(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f__libR_set_callback _cffi_d__libR_set_callback
#endif

static void _cffi_d__libR_setup_xptr_callback(void)
{
  _libR_setup_xptr_callback();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f__libR_setup_xptr_callback(PyObject *self, PyObject *noarg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { _libR_setup_xptr_callback(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f__libR_setup_xptr_callback _cffi_d__libR_setup_xptr_callback
#endif

static SEXPREC * _cffi_d__libR_xptr_callback(SEXPREC * x0, SEXPREC * x1, SEXPREC * x2, SEXPREC * x3)
{
  return _libR_xptr_callback(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f__libR_xptr_callback(PyObject *self, PyObject *args)
{
  SEXPREC * x0;
  SEXPREC * x1;
  SEXPREC * x2;
  SEXPREC * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  SEXPREC * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "_libR_xptr_callback", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (SEXPREC *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = _libR_xptr_callback(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(3));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f__libR_xptr_callback _cffi_d__libR_xptr_callback
#endif

static void _cffi_d_cb_busy_safe(int x0)
{
  cb_busy_safe(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_cb_busy_safe(PyObject *self, PyObject *arg0)
{
  int x0;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { cb_busy_safe(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_cb_busy_safe _cffi_d_cb_busy_safe
#endif

static void _cffi_d_cb_polled_events_interruptible(void)
{
  cb_polled_events_interruptible();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_cb_polled_events_interruptible(PyObject *self, PyObject *noarg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { cb_polled_events_interruptible(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_cb_polled_events_interruptible _cffi_d_cb_polled_events_interruptible
#endif

static int _cffi_d_cb_read_console_interruptible(char const * x0, unsigned char * x1, int x2, int x3)
{
  return cb_read_console_interruptible(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_cb_read_console_interruptible(PyObject *self, PyObject *args)
{
  char const * x0;
  unsigned char * x1;
  int x2;
  int x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "cb_read_console_interruptible", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(325), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(325), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = cb_read_console_interruptible(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_cb_read_console_interruptible _cffi_d_cb_read_console_interruptible
#endif

static void _cffi_d_cb_write_console_safe(char const * x0, int x1, int x2)
{
  cb_write_console_safe(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_cb_write_console_safe(PyObject *self, PyObject *args)
{
  char const * x0;
  int x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "cb_write_console_safe", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(25), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(25), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { cb_write_console_safe(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_cb_write_console_safe _cffi_d_cb_write_console_safe
#endif

static int _cffi_d_peek_event(void)
{
  return peek_event();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_peek_event(PyObject *self, PyObject *noarg)
{
  int result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = peek_event(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_peek_event _cffi_d_peek_event
#endif

static void _cffi_d_polled_events(void)
{
  polled_events();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_polled_events(PyObject *self, PyObject *noarg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { polled_events(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_polled_events _cffi_d_polled_events
#endif

static void _cffi_d_process_events(void)
{
  process_events();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_process_events(PyObject *self, PyObject *noarg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { process_events(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_process_events _cffi_d_process_events
#endif

static void _cffi_d_run_Rmainloop(void)
{
  run_Rmainloop();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_run_Rmainloop(PyObject *self, PyObject *noarg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { run_Rmainloop(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_run_Rmainloop _cffi_d_run_Rmainloop
#endif

static int _cffi_const_ANYSXP(unsigned long long *o)
{
  int n = (ANYSXP) <= 0;
  *o = (unsigned long long)((ANYSXP) | 0);  /* check that ANYSXP is an integer */
  if (!_cffi_check_int(*o, n, 18U))
    n |= 2;
  return n;
}

static int _cffi_const_BCODESXP(unsigned long long *o)
{
  int n = (BCODESXP) <= 0;
  *o = (unsigned long long)((BCODESXP) | 0);  /* check that BCODESXP is an integer */
  if (!_cffi_check_int(*o, n, 21U))
    n |= 2;
  return n;
}

static int _cffi_const_BUILTINSXP(unsigned long long *o)
{
  int n = (BUILTINSXP) <= 0;
  *o = (unsigned long long)((BUILTINSXP) | 0);  /* check that BUILTINSXP is an integer */
  if (!_cffi_check_int(*o, n, 8U))
    n |= 2;
  return n;
}

static int _cffi_const_CHARSXP(unsigned long long *o)
{
  int n = (CHARSXP) <= 0;
  *o = (unsigned long long)((CHARSXP) | 0);  /* check that CHARSXP is an integer */
  if (!_cffi_check_int(*o, n, 9U))
    n |= 2;
  return n;
}

static int _cffi_const_CLOSXP(unsigned long long *o)
{
  int n = (CLOSXP) <= 0;
  *o = (unsigned long long)((CLOSXP) | 0);  /* check that CLOSXP is an integer */
  if (!_cffi_check_int(*o, n, 3U))
    n |= 2;
  return n;
}

static int _cffi_const_CPLXSXP(unsigned long long *o)
{
  int n = (CPLXSXP) <= 0;
  *o = (unsigned long long)((CPLXSXP) | 0);  /* check that CPLXSXP is an integer */
  if (!_cffi_check_int(*o, n, 15U))
    n |= 2;
  return n;
}

static int _cffi_const_DOTSXP(unsigned long long *o)
{
  int n = (DOTSXP) <= 0;
  *o = (unsigned long long)((DOTSXP) | 0);  /* check that DOTSXP is an integer */
  if (!_cffi_check_int(*o, n, 17U))
    n |= 2;
  return n;
}

static int _cffi_const_ENVSXP(unsigned long long *o)
{
  int n = (ENVSXP) <= 0;
  *o = (unsigned long long)((ENVSXP) | 0);  /* check that ENVSXP is an integer */
  if (!_cffi_check_int(*o, n, 4U))
    n |= 2;
  return n;
}

static int _cffi_const_EXPRSXP(unsigned long long *o)
{
  int n = (EXPRSXP) <= 0;
  *o = (unsigned long long)((EXPRSXP) | 0);  /* check that EXPRSXP is an integer */
  if (!_cffi_check_int(*o, n, 20U))
    n |= 2;
  return n;
}

static int _cffi_const_EXTPTRSXP(unsigned long long *o)
{
  int n = (EXTPTRSXP) <= 0;
  *o = (unsigned long long)((EXTPTRSXP) | 0);  /* check that EXTPTRSXP is an integer */
  if (!_cffi_check_int(*o, n, 22U))
    n |= 2;
  return n;
}

static int _cffi_const_FREESXP(unsigned long long *o)
{
  int n = (FREESXP) <= 0;
  *o = (unsigned long long)((FREESXP) | 0);  /* check that FREESXP is an integer */
  if (!_cffi_check_int(*o, n, 31U))
    n |= 2;
  return n;
}

static int _cffi_const_FUNSXP(unsigned long long *o)
{
  int n = (FUNSXP) <= 0;
  *o = (unsigned long long)((FUNSXP) | 0);  /* check that FUNSXP is an integer */
  if (!_cffi_check_int(*o, n, 99U))
    n |= 2;
  return n;
}

static int _cffi_const_INTSXP(unsigned long long *o)
{
  int n = (INTSXP) <= 0;
  *o = (unsigned long long)((INTSXP) | 0);  /* check that INTSXP is an integer */
  if (!_cffi_check_int(*o, n, 13U))
    n |= 2;
  return n;
}

static int _cffi_const_LANGSXP(unsigned long long *o)
{
  int n = (LANGSXP) <= 0;
  *o = (unsigned long long)((LANGSXP) | 0);  /* check that LANGSXP is an integer */
  if (!_cffi_check_int(*o, n, 6U))
    n |= 2;
  return n;
}

static int _cffi_const_LGLSXP(unsigned long long *o)
{
  int n = (LGLSXP) <= 0;
  *o = (unsigned long long)((LGLSXP) | 0);  /* check that LGLSXP is an integer */
  if (!_cffi_check_int(*o, n, 10U))
    n |= 2;
  return n;
}

static int _cffi_const_LISTSXP(unsigned long long *o)
{
  int n = (LISTSXP) <= 0;
  *o = (unsigned long long)((LISTSXP) | 0);  /* check that LISTSXP is an integer */
  if (!_cffi_check_int(*o, n, 2U))
    n |= 2;
  return n;
}

static int _cffi_const_NEWSXP(unsigned long long *o)
{
  int n = (NEWSXP) <= 0;
  *o = (unsigned long long)((NEWSXP) | 0);  /* check that NEWSXP is an integer */
  if (!_cffi_check_int(*o, n, 30U))
    n |= 2;
  return n;
}

static int _cffi_const_NILSXP(unsigned long long *o)
{
  int n = (NILSXP) <= 0;
  *o = (unsigned long long)((NILSXP) | 0);  /* check that NILSXP is an integer */
  if (!_cffi_check_int(*o, n, 0))
    n |= 2;
  return n;
}

static int _cffi_const_PROMSXP(unsigned long long *o)
{
  int n = (PROMSXP) <= 0;
  *o = (unsigned long long)((PROMSXP) | 0);  /* check that PROMSXP is an integer */
  if (!_cffi_check_int(*o, n, 5U))
    n |= 2;
  return n;
}

static int _cffi_const_RAWSXP(unsigned long long *o)
{
  int n = (RAWSXP) <= 0;
  *o = (unsigned long long)((RAWSXP) | 0);  /* check that RAWSXP is an integer */
  if (!_cffi_check_int(*o, n, 24U))
    n |= 2;
  return n;
}

static int _cffi_const_REALSXP(unsigned long long *o)
{
  int n = (REALSXP) <= 0;
  *o = (unsigned long long)((REALSXP) | 0);  /* check that REALSXP is an integer */
  if (!_cffi_check_int(*o, n, 14U))
    n |= 2;
  return n;
}

static int _cffi_const_S4SXP(unsigned long long *o)
{
  int n = (S4SXP) <= 0;
  *o = (unsigned long long)((S4SXP) | 0);  /* check that S4SXP is an integer */
  if (!_cffi_check_int(*o, n, 25U))
    n |= 2;
  return n;
}

static int _cffi_const_SPECIALSXP(unsigned long long *o)
{
  int n = (SPECIALSXP) <= 0;
  *o = (unsigned long long)((SPECIALSXP) | 0);  /* check that SPECIALSXP is an integer */
  if (!_cffi_check_int(*o, n, 7U))
    n |= 2;
  return n;
}

static int _cffi_const_STRSXP(unsigned long long *o)
{
  int n = (STRSXP) <= 0;
  *o = (unsigned long long)((STRSXP) | 0);  /* check that STRSXP is an integer */
  if (!_cffi_check_int(*o, n, 16U))
    n |= 2;
  return n;
}

static int _cffi_const_SYMSXP(unsigned long long *o)
{
  int n = (SYMSXP) <= 0;
  *o = (unsigned long long)((SYMSXP) | 0);  /* check that SYMSXP is an integer */
  if (!_cffi_check_int(*o, n, 1U))
    n |= 2;
  return n;
}

static int _cffi_const_VECSXP(unsigned long long *o)
{
  int n = (VECSXP) <= 0;
  *o = (unsigned long long)((VECSXP) | 0);  /* check that VECSXP is an integer */
  if (!_cffi_check_int(*o, n, 19U))
    n |= 2;
  return n;
}

static int _cffi_const_WEAKREFSXP(unsigned long long *o)
{
  int n = (WEAKREFSXP) <= 0;
  *o = (unsigned long long)((WEAKREFSXP) | 0);  /* check that WEAKREFSXP is an integer */
  if (!_cffi_check_int(*o, n, 23U))
    n |= 2;
  return n;
}

_CFFI_UNUSED_FN
static void _cffi_checkfld__SEXPREC(SEXPREC *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct sxpinfo_struct *tmp = &p->sxpinfo; (void)tmp; }
  { SEXPREC * *tmp = &p->attrib; (void)tmp; }
  { SEXPREC * *tmp = &p->gengc_next_node; (void)tmp; }
  { SEXPREC * *tmp = &p->gengc_prev_node; (void)tmp; }
  /* cannot generate 'union $1' in field 'u': unknown type name */
}
struct _cffi_align__SEXPREC { char x; SEXPREC y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_closxp_struct(struct closxp_struct *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct SEXPREC * *tmp = &p->formals; (void)tmp; }
  { struct SEXPREC * *tmp = &p->body; (void)tmp; }
  { struct SEXPREC * *tmp = &p->env; (void)tmp; }
}
struct _cffi_align_struct_closxp_struct { char x; struct closxp_struct y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_envsxp_struct(struct envsxp_struct *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct SEXPREC * *tmp = &p->frame; (void)tmp; }
  { struct SEXPREC * *tmp = &p->enclos; (void)tmp; }
  { struct SEXPREC * *tmp = &p->hashtab; (void)tmp; }
}
struct _cffi_align_struct_envsxp_struct { char x; struct envsxp_struct y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_listsxp_struct(struct listsxp_struct *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct SEXPREC * *tmp = &p->carval; (void)tmp; }
  { struct SEXPREC * *tmp = &p->cdrval; (void)tmp; }
  { struct SEXPREC * *tmp = &p->tagval; (void)tmp; }
}
struct _cffi_align_struct_listsxp_struct { char x; struct listsxp_struct y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_primsxp_struct(struct primsxp_struct *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->offset) | 0);  /* check that 'struct primsxp_struct.offset' is an integer */
}
struct _cffi_align_struct_primsxp_struct { char x; struct primsxp_struct y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_promsxp_struct(struct promsxp_struct *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct SEXPREC * *tmp = &p->value; (void)tmp; }
  { struct SEXPREC * *tmp = &p->expr; (void)tmp; }
  { struct SEXPREC * *tmp = &p->env; (void)tmp; }
}
struct _cffi_align_struct_promsxp_struct { char x; struct promsxp_struct y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_sxpinfo_struct(struct sxpinfo_struct *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->type) | 0);  /* check that 'struct sxpinfo_struct.type' is an integer */
  (void)((p->scalar) | 0);  /* check that 'struct sxpinfo_struct.scalar' is an integer */
  (void)((p->obj) | 0);  /* check that 'struct sxpinfo_struct.obj' is an integer */
  (void)((p->alt) | 0);  /* check that 'struct sxpinfo_struct.alt' is an integer */
  (void)((p->gp) | 0);  /* check that 'struct sxpinfo_struct.gp' is an integer */
  (void)((p->mark) | 0);  /* check that 'struct sxpinfo_struct.mark' is an integer */
  (void)((p->debug) | 0);  /* check that 'struct sxpinfo_struct.debug' is an integer */
  (void)((p->trace) | 0);  /* check that 'struct sxpinfo_struct.trace' is an integer */
  (void)((p->spare) | 0);  /* check that 'struct sxpinfo_struct.spare' is an integer */
  (void)((p->gcgen) | 0);  /* check that 'struct sxpinfo_struct.gcgen' is an integer */
  (void)((p->gccls) | 0);  /* check that 'struct sxpinfo_struct.gccls' is an integer */
  (void)((p->named) | 0);  /* check that 'struct sxpinfo_struct.named' is an integer */
  (void)((p->extra) | 0);  /* check that 'struct sxpinfo_struct.extra' is an integer */
}
struct _cffi_align_struct_sxpinfo_struct { char x; struct sxpinfo_struct y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_symsxp_struct(struct symsxp_struct *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct SEXPREC * *tmp = &p->pname; (void)tmp; }
  { struct SEXPREC * *tmp = &p->value; (void)tmp; }
  { struct SEXPREC * *tmp = &p->internal; (void)tmp; }
}
struct _cffi_align_struct_symsxp_struct { char x; struct symsxp_struct y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_vecsxp_struct(struct vecsxp_struct *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->length) | 0);  /* check that 'struct vecsxp_struct.length' is an integer */
  (void)((p->truelength) | 0);  /* check that 'struct vecsxp_struct.truelength' is an integer */
}
struct _cffi_align_struct_vecsxp_struct { char x; struct vecsxp_struct y; };

static SEXPREC *(* *_cffi_var_CAAR(void))(SEXPREC *)
{
  return &(CAAR);
}

static SEXPREC *(* *_cffi_var_CAD4R(void))(SEXPREC *)
{
  return &(CAD4R);
}

static SEXPREC *(* *_cffi_var_CADDDR(void))(SEXPREC *)
{
  return &(CADDDR);
}

static SEXPREC *(* *_cffi_var_CADDR(void))(SEXPREC *)
{
  return &(CADDR);
}

static SEXPREC *(* *_cffi_var_CADR(void))(SEXPREC *)
{
  return &(CADR);
}

static SEXPREC *(* *_cffi_var_CAR(void))(SEXPREC *)
{
  return &(CAR);
}

static SEXPREC *(* *_cffi_var_CDAR(void))(SEXPREC *)
{
  return &(CDAR);
}

static SEXPREC *(* *_cffi_var_CDDDR(void))(SEXPREC *)
{
  return &(CDDDR);
}

static SEXPREC *(* *_cffi_var_CDDR(void))(SEXPREC *)
{
  return &(CDDR);
}

static SEXPREC *(* *_cffi_var_CDR(void))(SEXPREC *)
{
  return &(CDR);
}

static Rcomplex *(* *_cffi_var_COMPLEX(void))(SEXPREC *)
{
  return &(COMPLEX);
}

static SEXPREC *(* *_cffi_var_CONS_NR(void))(SEXPREC *, SEXPREC *)
{
  return &(CONS_NR);
}

static int *(* *_cffi_var_INTEGER(void))(SEXPREC *)
{
  return &(INTEGER);
}

static int(* *_cffi_var_IS_LONG_VEC(void))(SEXPREC *)
{
  return &(IS_LONG_VEC);
}

static int(* *_cffi_var_IS_S4_OBJECT(void))(SEXPREC *)
{
  return &(IS_S4_OBJECT);
}

static int(* *_cffi_var_LENGTH(void))(SEXPREC *)
{
  return &(LENGTH);
}

static int(* *_cffi_var_LEVELS(void))(SEXPREC *)
{
  return &(LEVELS);
}

static int *(* *_cffi_var_LOGICAL(void))(SEXPREC *)
{
  return &(LOGICAL);
}

static int(* *_cffi_var_MISSING(void))(SEXPREC *)
{
  return &(MISSING);
}

static SEXPREC *(* *_cffi_var_PRINTNAME(void))(SEXPREC *)
{
  return &(PRINTNAME);
}

static unsigned char *(* *_cffi_var_RAW(void))(SEXPREC *)
{
  return &(RAW);
}

static double *(* *_cffi_var_REAL(void))(SEXPREC *)
{
  return &(REAL);
}

static SEXPREC * *_cffi_var_R_AsCharacterSymbol(void)
{
  return &(R_AsCharacterSymbol);
}

static SEXPREC * *_cffi_var_R_BaseEnv(void)
{
  return &(R_BaseEnv);
}

static SEXPREC * *_cffi_var_R_BaseNamespace(void)
{
  return &(R_BaseNamespace);
}

static SEXPREC * *_cffi_var_R_BaseSymbol(void)
{
  return &(R_BaseSymbol);
}

static Rboolean(* *_cffi_var_R_BindingIsActive(void))(SEXPREC *, SEXPREC *)
{
  return &(R_BindingIsActive);
}

static Rboolean(* *_cffi_var_R_BindingIsLocked(void))(SEXPREC *, SEXPREC *)
{
  return &(R_BindingIsLocked);
}

static SEXPREC * *_cffi_var_R_BlankScalarString(void)
{
  return &(R_BlankScalarString);
}

static SEXPREC * *_cffi_var_R_BlankString(void)
{
  return &(R_BlankString);
}

static SEXPREC * *_cffi_var_R_BraceSymbol(void)
{
  return &(R_BraceSymbol);
}

static SEXPREC * *_cffi_var_R_Bracket2Symbol(void)
{
  return &(R_Bracket2Symbol);
}

static SEXPREC * *_cffi_var_R_BracketSymbol(void)
{
  return &(R_BracketSymbol);
}

static SEXPREC *(* *_cffi_var_R_BytecodeExpr(void))(SEXPREC *)
{
  return &(R_BytecodeExpr);
}

static char const *(* *_cffi_var_R_CHAR(void))(SEXPREC *)
{
  return &(R_CHAR);
}

static void(* *_cffi_var_R_CheckUserInterrupt(void))(void)
{
  return &(R_CheckUserInterrupt);
}

static SEXPREC * *_cffi_var_R_ClassSymbol(void)
{
  return &(R_ClassSymbol);
}

static void(* *_cffi_var_R_ClearExternalPtr(void))(SEXPREC *)
{
  return &(R_ClearExternalPtr);
}

static SEXPREC *(* *_cffi_var_R_ClosureExpr(void))(SEXPREC *)
{
  return &(R_ClosureExpr);
}

static SEXPREC * *_cffi_var_R_CurrentExpression(void)
{
  return &(R_CurrentExpression);
}

static void(* *_cffi_var_R_DefParams(void))(structRstart *)
{
  return &(R_DefParams);
}

static SEXPREC * *_cffi_var_R_DeviceSymbol(void)
{
  return &(R_DeviceSymbol);
}

static SEXPREC * *_cffi_var_R_DimNamesSymbol(void)
{
  return &(R_DimNamesSymbol);
}

static SEXPREC * *_cffi_var_R_DimSymbol(void)
{
  return &(R_DimSymbol);
}

static SEXPREC * *_cffi_var_R_DollarSymbol(void)
{
  return &(R_DollarSymbol);
}

static SEXPREC * *_cffi_var_R_DotsSymbol(void)
{
  return &(R_DotsSymbol);
}

static SEXPREC * *_cffi_var_R_DoubleColonSymbol(void)
{
  return &(R_DoubleColonSymbol);
}

static SEXPREC * *_cffi_var_R_DropSymbol(void)
{
  return &(R_DropSymbol);
}

static SEXPREC * *_cffi_var_R_EmptyEnv(void)
{
  return &(R_EmptyEnv);
}

static Rboolean(* *_cffi_var_R_EnvironmentIsLocked(void))(SEXPREC *)
{
  return &(R_EnvironmentIsLocked);
}

static void *(* *_cffi_var_R_ExternalPtrAddr(void))(SEXPREC *)
{
  return &(R_ExternalPtrAddr);
}

static void *(*(* *_cffi_var_R_ExternalPtrAddrFn(void))(SEXPREC *))(void)
{
  return &(R_ExternalPtrAddrFn);
}

static SEXPREC *(* *_cffi_var_R_ExternalPtrProtected(void))(SEXPREC *)
{
  return &(R_ExternalPtrProtected);
}

static SEXPREC *(* *_cffi_var_R_ExternalPtrTag(void))(SEXPREC *)
{
  return &(R_ExternalPtrTag);
}

static SEXPREC *(* *_cffi_var_R_FindNamespace(void))(SEXPREC *)
{
  return &(R_FindNamespace);
}

static SEXPREC *(* *_cffi_var_R_FindPackageEnv(void))(SEXPREC *)
{
  return &(R_FindPackageEnv);
}

static SEXPREC * *_cffi_var_R_GlobalEnv(void)
{
  return &(R_GlobalEnv);
}

static Rboolean(* *_cffi_var_R_HasFancyBindings(void))(SEXPREC *)
{
  return &(R_HasFancyBindings);
}

static SEXPREC * *_cffi_var_R_InBCInterpreter(void)
{
  return &(R_InBCInterpreter);
}

static void * *_cffi_var_R_InputHandlers(void)
{
  return &(R_InputHandlers);
}

static int(* *_cffi_var_R_IsNA(void))(double)
{
  return &(R_IsNA);
}

static int(* *_cffi_var_R_IsNaN(void))(double)
{
  return &(R_IsNaN);
}

static Rboolean(* *_cffi_var_R_IsNamespaceEnv(void))(SEXPREC *)
{
  return &(R_IsNamespaceEnv);
}

static Rboolean(* *_cffi_var_R_IsPackageEnv(void))(SEXPREC *)
{
  return &(R_IsPackageEnv);
}

static SEXPREC * *_cffi_var_R_LastvalueSymbol(void)
{
  return &(R_LastvalueSymbol);
}

static SEXPREC * *_cffi_var_R_LevelsSymbol(void)
{
  return &(R_LevelsSymbol);
}

static void(* *_cffi_var_R_LockBinding(void))(SEXPREC *, SEXPREC *)
{
  return &(R_LockBinding);
}

static void(* *_cffi_var_R_LockEnvironment(void))(SEXPREC *, Rboolean)
{
  return &(R_LockEnvironment);
}

static void(* *_cffi_var_R_MakeActiveBinding(void))(SEXPREC *, SEXPREC *, SEXPREC *)
{
  return &(R_MakeActiveBinding);
}

static SEXPREC *(* *_cffi_var_R_MakeExternalPtr(void))(void *, SEXPREC *, SEXPREC *)
{
  return &(R_MakeExternalPtr);
}

static SEXPREC *(* *_cffi_var_R_MakeExternalPtrFn(void))(void *(*)(void), SEXPREC *, SEXPREC *)
{
  return &(R_MakeExternalPtrFn);
}

static SEXPREC *(* *_cffi_var_R_MakeWeakRef(void))(SEXPREC *, SEXPREC *, SEXPREC *, Rboolean)
{
  return &(R_MakeWeakRef);
}

static SEXPREC *(* *_cffi_var_R_MakeWeakRefC(void))(SEXPREC *, SEXPREC *, void(*)(SEXPREC *), Rboolean)
{
  return &(R_MakeWeakRefC);
}

static SEXPREC * *_cffi_var_R_MissingArg(void)
{
  return &(R_MissingArg);
}

static SEXPREC * *_cffi_var_R_ModeSymbol(void)
{
  return &(R_ModeSymbol);
}

static SEXPREC * *_cffi_var_R_NaRmSymbol(void)
{
  return &(R_NaRmSymbol);
}

static SEXPREC * *_cffi_var_R_NaString(void)
{
  return &(R_NaString);
}

static SEXPREC * *_cffi_var_R_NameSymbol(void)
{
  return &(R_NameSymbol);
}

static SEXPREC * *_cffi_var_R_NamesSymbol(void)
{
  return &(R_NamesSymbol);
}

static SEXPREC *(* *_cffi_var_R_NamespaceEnvSpec(void))(SEXPREC *)
{
  return &(R_NamespaceEnvSpec);
}

static SEXPREC * *_cffi_var_R_NamespaceEnvSymbol(void)
{
  return &(R_NamespaceEnvSymbol);
}

static SEXPREC * *_cffi_var_R_NamespaceRegistry(void)
{
  return &(R_NamespaceRegistry);
}

static SEXPREC * *_cffi_var_R_NilValue(void)
{
  return &(R_NilValue);
}

static SEXPREC *(* *_cffi_var_R_PackageEnvName(void))(SEXPREC *)
{
  return &(R_PackageEnvName);
}

static SEXPREC * *_cffi_var_R_PackageSymbol(void)
{
  return &(R_PackageSymbol);
}

static SEXPREC *(* *_cffi_var_R_ParseEvalString(void))(char const *, SEXPREC *)
{
  return &(R_ParseEvalString);
}

static void(* * *_cffi_var_R_PolledEvents_t(void))(void)
{
  return &(R_PolledEvents_t);
}

static void(* *_cffi_var_R_PreserveObject(void))(SEXPREC *)
{
  return &(R_PreserveObject);
}

static SEXPREC * *_cffi_var_R_PreviousSymbol(void)
{
  return &(R_PreviousSymbol);
}

static void(* *_cffi_var_R_ProcessEvents(void))(void)
{
  return &(R_ProcessEvents);
}

static SEXPREC *(* *_cffi_var_R_PromiseExpr(void))(SEXPREC *)
{
  return &(R_PromiseExpr);
}

static SEXPREC * *_cffi_var_R_QuoteSymbol(void)
{
  return &(R_QuoteSymbol);
}

static void(* *_cffi_var_R_RegisterCFinalizer(void))(SEXPREC *, void(*)(SEXPREC *))
{
  return &(R_RegisterCFinalizer);
}

static void(* *_cffi_var_R_RegisterCFinalizerEx(void))(SEXPREC *, void(*)(SEXPREC *), Rboolean)
{
  return &(R_RegisterCFinalizerEx);
}

static void(* *_cffi_var_R_RegisterFinalizer(void))(SEXPREC *, SEXPREC *)
{
  return &(R_RegisterFinalizer);
}

static void(* *_cffi_var_R_RegisterFinalizerEx(void))(SEXPREC *, SEXPREC *, Rboolean)
{
  return &(R_RegisterFinalizerEx);
}

static void(* *_cffi_var_R_ReleaseObject(void))(SEXPREC *)
{
  return &(R_ReleaseObject);
}

static void(* *_cffi_var_R_RestoreHashCount(void))(SEXPREC *)
{
  return &(R_RestoreHashCount);
}

static SEXPREC * *_cffi_var_R_RowNamesSymbol(void)
{
  return &(R_RowNamesSymbol);
}

static void(* *_cffi_var_R_RunExitFinalizers(void))(void)
{
  return &(R_RunExitFinalizers);
}

static void(* *_cffi_var_R_RunPendingFinalizers(void))(void)
{
  return &(R_RunPendingFinalizers);
}

static void(* *_cffi_var_R_RunWeakRefFinalizer(void))(SEXPREC *)
{
  return &(R_RunWeakRefFinalizer);
}

static SEXPREC *(* *_cffi_var_R_S4_extends(void))(SEXPREC *, SEXPREC *)
{
  return &(R_S4_extends);
}

static SEXPREC * *_cffi_var_R_SeedsSymbol(void)
{
  return &(R_SeedsSymbol);
}

static void(* *_cffi_var_R_SetExternalPtrAddr(void))(SEXPREC *, void *)
{
  return &(R_SetExternalPtrAddr);
}

static void(* *_cffi_var_R_SetExternalPtrProtected(void))(SEXPREC *, SEXPREC *)
{
  return &(R_SetExternalPtrProtected);
}

static void(* *_cffi_var_R_SetExternalPtrTag(void))(SEXPREC *, SEXPREC *)
{
  return &(R_SetExternalPtrTag);
}

static void(* *_cffi_var_R_SetParams(void))(structRstart *)
{
  return &(R_SetParams);
}

static void(* *_cffi_var_R_ShowMessage(void))(char const *)
{
  return &(R_ShowMessage);
}

static int * *_cffi_var_R_SignalHandlers_t(void)
{
  return &(R_SignalHandlers_t);
}

static SEXPREC * *_cffi_var_R_SortListSymbol(void)
{
  return &(R_SortListSymbol);
}

static SEXPREC * *_cffi_var_R_SourceSymbol(void)
{
  return &(R_SourceSymbol);
}

static SEXPREC * *_cffi_var_R_SpecSymbol(void)
{
  return &(R_SpecSymbol);
}

static SEXPREC * *_cffi_var_R_Srcref(void)
{
  return &(R_Srcref);
}

static Rboolean(* *_cffi_var_R_ToplevelExec(void))(void(*)(void *), void *)
{
  return &(R_ToplevelExec);
}

static SEXPREC * *_cffi_var_R_TripleColonSymbol(void)
{
  return &(R_TripleColonSymbol);
}

static SEXPREC * *_cffi_var_R_TspSymbol(void)
{
  return &(R_TspSymbol);
}

static SEXPREC * *_cffi_var_R_UnboundValue(void)
{
  return &(R_UnboundValue);
}

static SEXPREC *(* *_cffi_var_R_WeakRefKey(void))(SEXPREC *)
{
  return &(R_WeakRefKey);
}

static SEXPREC *(* *_cffi_var_R_WeakRefValue(void))(SEXPREC *)
{
  return &(R_WeakRefValue);
}

static char *(* *_cffi_var_R_alloc(void))(size_t, int)
{
  return &(R_alloc);
}

static long double *(* *_cffi_var_R_allocLD(void))(size_t)
{
  return &(R_allocLD);
}

static SEXPREC * *_cffi_var_R_baseSymbol(void)
{
  return &(R_baseSymbol);
}

static void *(* *_cffi_var_R_checkActivity(void))(int, int)
{
  return &(R_checkActivity);
}

static Rboolean(* *_cffi_var_R_compute_identical(void))(SEXPREC *, SEXPREC *, int)
{
  return &(R_compute_identical);
}

static char const *(* *_cffi_var_R_curErrorBuf(void))(void)
{
  return &(R_curErrorBuf);
}

static SEXPREC *(* *_cffi_var_R_data_class(void))(SEXPREC *, Rboolean)
{
  return &(R_data_class);
}

static SEXPREC *(* *_cffi_var_R_do_slot(void))(SEXPREC *, SEXPREC *)
{
  return &(R_do_slot);
}

static SEXPREC *(* *_cffi_var_R_do_slot_assign(void))(SEXPREC *, SEXPREC *, SEXPREC *)
{
  return &(R_do_slot_assign);
}

static SEXPREC * *_cffi_var_R_dot_Generic(void)
{
  return &(R_dot_Generic);
}

static void(* *_cffi_var_R_dot_Last(void))(void)
{
  return &(R_dot_Last);
}

static SEXPREC * *_cffi_var_R_dot_Method(void)
{
  return &(R_dot_Method);
}

static SEXPREC * *_cffi_var_R_dot_defined(void)
{
  return &(R_dot_defined);
}

static SEXPREC * *_cffi_var_R_dot_packageName(void)
{
  return &(R_dot_packageName);
}

static SEXPREC * *_cffi_var_R_dot_target(void)
{
  return &(R_dot_target);
}

static Rboolean(* *_cffi_var_R_envHasNoSpecialSymbols(void))(SEXPREC *)
{
  return &(R_envHasNoSpecialSymbols);
}

static int(* *_cffi_var_R_finite(void))(double)
{
  return &(R_finite);
}

static void(* *_cffi_var_R_gc(void))(void)
{
  return &(R_gc);
}

static int(* *_cffi_var_R_gc_running(void))(void)
{
  return &(R_gc_running);
}

static DllInfo *(* *_cffi_var_R_getEmbeddingDllInfo(void))(void)
{
  return &(R_getEmbeddingDllInfo);
}

static int(* *_cffi_var_R_has_slot(void))(SEXPREC *, SEXPREC *)
{
  return &(R_has_slot);
}

static int * *_cffi_var_R_interrupts_pending_t(void)
{
  return &(R_interrupts_pending_t);
}

static SEXPREC *(* *_cffi_var_R_lsInternal(void))(SEXPREC *, Rboolean)
{
  return &(R_lsInternal);
}

static SEXPREC *(* *_cffi_var_R_lsInternal3(void))(SEXPREC *, Rboolean, Rboolean)
{
  return &(R_lsInternal3);
}

static int(* *_cffi_var_R_nchar(void))(SEXPREC *, nchar_type, Rboolean, Rboolean, char const *)
{
  return &(R_nchar);
}

static int(* *_cffi_var_R_registerRoutines(void))(DllInfo *, void *, void *, void *, void *)
{
  return &(R_registerRoutines);
}

static void(* *_cffi_var_R_runHandlers(void))(void *, void *)
{
  return &(R_runHandlers);
}

static void(* *_cffi_var_R_set_command_line_arguments(void))(int, char * *)
{
  return &(R_set_command_line_arguments);
}

static SEXPREC *(* *_cffi_var_R_tryCatch(void))(SEXPREC *(*)(void *), void *, SEXPREC *, SEXPREC *(*)(SEXPREC *, void *), void *, void(*)(void *), void *)
{
  return &(R_tryCatch);
}

static SEXPREC *(* *_cffi_var_R_tryCatchError(void))(SEXPREC *(*)(void *), void *, SEXPREC *(*)(SEXPREC *, void *), void *)
{
  return &(R_tryCatchError);
}

static SEXPREC *(* *_cffi_var_R_tryEvalSilent(void))(SEXPREC *, SEXPREC *, int *)
{
  return &(R_tryEvalSilent);
}

static void(* *_cffi_var_R_unLockBinding(void))(SEXPREC *, SEXPREC *)
{
  return &(R_unLockBinding);
}

static SEXPREC *(* *_cffi_var_Rf_CreateTag(void))(SEXPREC *)
{
  return &(Rf_CreateTag);
}

static SEXPREC *(* *_cffi_var_Rf_DropDims(void))(SEXPREC *)
{
  return &(Rf_DropDims);
}

static SEXPREC *(* *_cffi_var_Rf_GetArrayDimnames(void))(SEXPREC *)
{
  return &(Rf_GetArrayDimnames);
}

static SEXPREC *(* *_cffi_var_Rf_GetColNames(void))(SEXPREC *)
{
  return &(Rf_GetColNames);
}

static void(* *_cffi_var_Rf_GetMatrixDimnames(void))(SEXPREC *, SEXPREC * *, SEXPREC * *, char const * *, char const * *)
{
  return &(Rf_GetMatrixDimnames);
}

static SEXPREC *(* *_cffi_var_Rf_GetOption1(void))(SEXPREC *)
{
  return &(Rf_GetOption1);
}

static int(* *_cffi_var_Rf_GetOptionDigits(void))(void)
{
  return &(Rf_GetOptionDigits);
}

static int(* *_cffi_var_Rf_GetOptionWidth(void))(void)
{
  return &(Rf_GetOptionWidth);
}

static SEXPREC *(* *_cffi_var_Rf_GetRowNames(void))(SEXPREC *)
{
  return &(Rf_GetRowNames);
}

static SEXPREC *(* *_cffi_var_Rf_NewEnvironment(void))(SEXPREC *, SEXPREC *, SEXPREC *)
{
  return &(Rf_NewEnvironment);
}

static Rboolean(* *_cffi_var_Rf_NonNullStringMatch(void))(SEXPREC *, SEXPREC *)
{
  return &(Rf_NonNullStringMatch);
}

static SEXPREC *(* *_cffi_var_Rf_PairToVectorList(void))(SEXPREC *)
{
  return &(Rf_PairToVectorList);
}

static void(* *_cffi_var_Rf_PrintValue(void))(SEXPREC *)
{
  return &(Rf_PrintValue);
}

static SEXPREC *(* *_cffi_var_Rf_S3Class(void))(SEXPREC *)
{
  return &(Rf_S3Class);
}

static SEXPREC *(* *_cffi_var_Rf_ScalarComplex(void))(Rcomplex)
{
  return &(Rf_ScalarComplex);
}

static SEXPREC *(* *_cffi_var_Rf_ScalarInteger(void))(int)
{
  return &(Rf_ScalarInteger);
}

static SEXPREC *(* *_cffi_var_Rf_ScalarLogical(void))(int)
{
  return &(Rf_ScalarLogical);
}

static SEXPREC *(* *_cffi_var_Rf_ScalarRaw(void))(unsigned char)
{
  return &(Rf_ScalarRaw);
}

static SEXPREC *(* *_cffi_var_Rf_ScalarReal(void))(double)
{
  return &(Rf_ScalarReal);
}

static SEXPREC *(* *_cffi_var_Rf_ScalarString(void))(SEXPREC *)
{
  return &(Rf_ScalarString);
}

static Rboolean(* *_cffi_var_Rf_StringBlank(void))(SEXPREC *)
{
  return &(Rf_StringBlank);
}

static SEXPREC *(* *_cffi_var_Rf_VectorToPairList(void))(SEXPREC *)
{
  return &(Rf_VectorToPairList);
}

static char *(* *_cffi_var_Rf_acopy_string(void))(char const *)
{
  return &(Rf_acopy_string);
}

static SEXPREC *(* *_cffi_var_Rf_alloc3DArray(void))(unsigned int, int, int, int)
{
  return &(Rf_alloc3DArray);
}

static SEXPREC *(* *_cffi_var_Rf_allocArray(void))(unsigned int, SEXPREC *)
{
  return &(Rf_allocArray);
}

static SEXPREC *(* *_cffi_var_Rf_allocFormalsList2(void))(SEXPREC *, SEXPREC *)
{
  return &(Rf_allocFormalsList2);
}

static SEXPREC *(* *_cffi_var_Rf_allocFormalsList3(void))(SEXPREC *, SEXPREC *, SEXPREC *)
{
  return &(Rf_allocFormalsList3);
}

static SEXPREC *(* *_cffi_var_Rf_allocFormalsList4(void))(SEXPREC *, SEXPREC *, SEXPREC *, SEXPREC *)
{
  return &(Rf_allocFormalsList4);
}

static SEXPREC *(* *_cffi_var_Rf_allocFormalsList5(void))(SEXPREC *, SEXPREC *, SEXPREC *, SEXPREC *, SEXPREC *)
{
  return &(Rf_allocFormalsList5);
}

static SEXPREC *(* *_cffi_var_Rf_allocFormalsList6(void))(SEXPREC *, SEXPREC *, SEXPREC *, SEXPREC *, SEXPREC *, SEXPREC *)
{
  return &(Rf_allocFormalsList6);
}

static SEXPREC *(* *_cffi_var_Rf_allocList(void))(int)
{
  return &(Rf_allocList);
}

static SEXPREC *(* *_cffi_var_Rf_allocMatrix(void))(unsigned int, int, int)
{
  return &(Rf_allocMatrix);
}

static SEXPREC *(* *_cffi_var_Rf_allocS4Object(void))(void)
{
  return &(Rf_allocS4Object);
}

static SEXPREC *(* *_cffi_var_Rf_allocSExp(void))(unsigned int)
{
  return &(Rf_allocSExp);
}

static SEXPREC *(* *_cffi_var_Rf_allocVector(void))(unsigned int, ptrdiff_t)
{
  return &(Rf_allocVector);
}

static SEXPREC *(* *_cffi_var_Rf_allocVector3(void))(unsigned int, ptrdiff_t, void *)
{
  return &(Rf_allocVector3);
}

static ptrdiff_t(* *_cffi_var_Rf_any_duplicated(void))(SEXPREC *, Rboolean)
{
  return &(Rf_any_duplicated);
}

static ptrdiff_t(* *_cffi_var_Rf_any_duplicated3(void))(SEXPREC *, SEXPREC *, Rboolean)
{
  return &(Rf_any_duplicated3);
}

static SEXPREC *(* *_cffi_var_Rf_arraySubscript(void))(int, SEXPREC *, SEXPREC *, SEXPREC *(*)(SEXPREC *, SEXPREC *), SEXPREC *(*)(SEXPREC *, int), SEXPREC *)
{
  return &(Rf_arraySubscript);
}

static SEXPREC *(* *_cffi_var_Rf_asChar(void))(SEXPREC *)
{
  return &(Rf_asChar);
}

static SEXPREC *(* *_cffi_var_Rf_asCharacterFactor(void))(SEXPREC *)
{
  return &(Rf_asCharacterFactor);
}

static Rcomplex(* *_cffi_var_Rf_asComplex(void))(SEXPREC *)
{
  return &(Rf_asComplex);
}

static int(* *_cffi_var_Rf_asInteger(void))(SEXPREC *)
{
  return &(Rf_asInteger);
}

static int(* *_cffi_var_Rf_asLogical(void))(SEXPREC *)
{
  return &(Rf_asLogical);
}

static int(* *_cffi_var_Rf_asLogical2(void))(SEXPREC *, int, SEXPREC *, SEXPREC *)
{
  return &(Rf_asLogical2);
}

static double(* *_cffi_var_Rf_asReal(void))(SEXPREC *)
{
  return &(Rf_asReal);
}

static SEXPREC *(* *_cffi_var_Rf_asS4(void))(SEXPREC *, Rboolean, int)
{
  return &(Rf_asS4);
}

static SEXPREC *(* *_cffi_var_Rf_classgets(void))(SEXPREC *, SEXPREC *)
{
  return &(Rf_classgets);
}

static SEXPREC *(* *_cffi_var_Rf_coerceVector(void))(SEXPREC *, unsigned int)
{
  return &(Rf_coerceVector);
}

static Rboolean(* *_cffi_var_Rf_conformable(void))(SEXPREC *, SEXPREC *)
{
  return &(Rf_conformable);
}

static SEXPREC *(* *_cffi_var_Rf_cons(void))(SEXPREC *, SEXPREC *)
{
  return &(Rf_cons);
}

static void(* *_cffi_var_Rf_copyListMatrix(void))(SEXPREC *, SEXPREC *, Rboolean)
{
  return &(Rf_copyListMatrix);
}

static void(* *_cffi_var_Rf_copyMatrix(void))(SEXPREC *, SEXPREC *, Rboolean)
{
  return &(Rf_copyMatrix);
}

static void(* *_cffi_var_Rf_copyMostAttrib(void))(SEXPREC *, SEXPREC *)
{
  return &(Rf_copyMostAttrib);
}

static void(* *_cffi_var_Rf_copyVector(void))(SEXPREC *, SEXPREC *)
{
  return &(Rf_copyVector);
}

static int(* *_cffi_var_Rf_countContexts(void))(int, int)
{
  return &(Rf_countContexts);
}

static void(* *_cffi_var_Rf_defineVar(void))(SEXPREC *, SEXPREC *, SEXPREC *)
{
  return &(Rf_defineVar);
}

static SEXPREC *(* *_cffi_var_Rf_dimgets(void))(SEXPREC *, SEXPREC *)
{
  return &(Rf_dimgets);
}

static SEXPREC *(* *_cffi_var_Rf_dimnamesgets(void))(SEXPREC *, SEXPREC *)
{
  return &(Rf_dimnamesgets);
}

static SEXPREC *(* *_cffi_var_Rf_duplicate(void))(SEXPREC *)
{
  return &(Rf_duplicate);
}

static SEXPREC *(* *_cffi_var_Rf_duplicated(void))(SEXPREC *, Rboolean)
{
  return &(Rf_duplicated);
}

static SEXPREC *(* *_cffi_var_Rf_elt(void))(SEXPREC *, int)
{
  return &(Rf_elt);
}

static void(* *_cffi_var_Rf_error(void))(char const *, ...)
{
  return &(Rf_error);
}

static void(* *_cffi_var_Rf_errorcall(void))(SEXPREC *, char const *, ...)
{
  return &(Rf_errorcall);
}

static SEXPREC *(* *_cffi_var_Rf_eval(void))(SEXPREC *, SEXPREC *)
{
  return &(Rf_eval);
}

static SEXPREC *(* *_cffi_var_Rf_findFun(void))(SEXPREC *, SEXPREC *)
{
  return &(Rf_findFun);
}

static SEXPREC *(* *_cffi_var_Rf_findVar(void))(SEXPREC *, SEXPREC *)
{
  return &(Rf_findVar);
}

static SEXPREC *(* *_cffi_var_Rf_findVarInFrame(void))(SEXPREC *, SEXPREC *)
{
  return &(Rf_findVarInFrame);
}

static SEXPREC *(* *_cffi_var_Rf_findVarInFrame3(void))(SEXPREC *, SEXPREC *, Rboolean)
{
  return &(Rf_findVarInFrame3);
}

static SEXPREC *(* *_cffi_var_Rf_getAttrib(void))(SEXPREC *, SEXPREC *)
{
  return &(Rf_getAttrib);
}

static cetype_t(* *_cffi_var_Rf_getCharCE(void))(SEXPREC *)
{
  return &(Rf_getCharCE);
}

static void(* *_cffi_var_Rf_gsetVar(void))(SEXPREC *, SEXPREC *, SEXPREC *)
{
  return &(Rf_gsetVar);
}

static Rboolean(* *_cffi_var_Rf_inherits(void))(SEXPREC *, char const *)
{
  return &(Rf_inherits);
}

static int(* *_cffi_var_Rf_initialize_R(void))(int, char * *)
{
  return &(Rf_initialize_R);
}

static SEXPREC *(* *_cffi_var_Rf_install(void))(char const *)
{
  return &(Rf_install);
}

static SEXPREC *(* *_cffi_var_Rf_installChar(void))(SEXPREC *)
{
  return &(Rf_installChar);
}

static Rboolean(* *_cffi_var_Rf_isArray(void))(SEXPREC *)
{
  return &(Rf_isArray);
}

static int(* *_cffi_var_Rf_isBasicClass(void))(char const *)
{
  return &(Rf_isBasicClass);
}

static Rboolean(* *_cffi_var_Rf_isComplex(void))(SEXPREC *)
{
  return &(Rf_isComplex);
}

static Rboolean(* *_cffi_var_Rf_isEnvironment(void))(SEXPREC *)
{
  return &(Rf_isEnvironment);
}

static Rboolean(* *_cffi_var_Rf_isExpression(void))(SEXPREC *)
{
  return &(Rf_isExpression);
}

static Rboolean(* *_cffi_var_Rf_isFactor(void))(SEXPREC *)
{
  return &(Rf_isFactor);
}

static Rboolean(* *_cffi_var_Rf_isFrame(void))(SEXPREC *)
{
  return &(Rf_isFrame);
}

static Rboolean(* *_cffi_var_Rf_isFree(void))(SEXPREC *)
{
  return &(Rf_isFree);
}

static Rboolean(* *_cffi_var_Rf_isFunction(void))(SEXPREC *)
{
  return &(Rf_isFunction);
}

static Rboolean(* *_cffi_var_Rf_isInteger(void))(SEXPREC *)
{
  return &(Rf_isInteger);
}

static Rboolean(* *_cffi_var_Rf_isLanguage(void))(SEXPREC *)
{
  return &(Rf_isLanguage);
}

static Rboolean(* *_cffi_var_Rf_isList(void))(SEXPREC *)
{
  return &(Rf_isList);
}

static Rboolean(* *_cffi_var_Rf_isLogical(void))(SEXPREC *)
{
  return &(Rf_isLogical);
}

static Rboolean(* *_cffi_var_Rf_isMatrix(void))(SEXPREC *)
{
  return &(Rf_isMatrix);
}

static Rboolean(* *_cffi_var_Rf_isNewList(void))(SEXPREC *)
{
  return &(Rf_isNewList);
}

static Rboolean(* *_cffi_var_Rf_isNull(void))(SEXPREC *)
{
  return &(Rf_isNull);
}

static Rboolean(* *_cffi_var_Rf_isNumber(void))(SEXPREC *)
{
  return &(Rf_isNumber);
}

static Rboolean(* *_cffi_var_Rf_isNumeric(void))(SEXPREC *)
{
  return &(Rf_isNumeric);
}

static Rboolean(* *_cffi_var_Rf_isObject(void))(SEXPREC *)
{
  return &(Rf_isObject);
}

static Rboolean(* *_cffi_var_Rf_isOrdered(void))(SEXPREC *)
{
  return &(Rf_isOrdered);
}

static Rboolean(* *_cffi_var_Rf_isPairList(void))(SEXPREC *)
{
  return &(Rf_isPairList);
}

static Rboolean(* *_cffi_var_Rf_isPrimitive(void))(SEXPREC *)
{
  return &(Rf_isPrimitive);
}

static Rboolean(* *_cffi_var_Rf_isReal(void))(SEXPREC *)
{
  return &(Rf_isReal);
}

static Rboolean(* *_cffi_var_Rf_isS4(void))(SEXPREC *)
{
  return &(Rf_isS4);
}

static Rboolean(* *_cffi_var_Rf_isString(void))(SEXPREC *)
{
  return &(Rf_isString);
}

static Rboolean(* *_cffi_var_Rf_isSymbol(void))(SEXPREC *)
{
  return &(Rf_isSymbol);
}

static Rboolean(* *_cffi_var_Rf_isTs(void))(SEXPREC *)
{
  return &(Rf_isTs);
}

static Rboolean(* *_cffi_var_Rf_isUnordered(void))(SEXPREC *)
{
  return &(Rf_isUnordered);
}

static Rboolean(* *_cffi_var_Rf_isUnsorted(void))(SEXPREC *, Rboolean)
{
  return &(Rf_isUnsorted);
}

static Rboolean(* *_cffi_var_Rf_isUserBinop(void))(SEXPREC *)
{
  return &(Rf_isUserBinop);
}

static Rboolean(* *_cffi_var_Rf_isValidString(void))(SEXPREC *)
{
  return &(Rf_isValidString);
}

static Rboolean(* *_cffi_var_Rf_isValidStringF(void))(SEXPREC *)
{
  return &(Rf_isValidStringF);
}

static Rboolean(* *_cffi_var_Rf_isVector(void))(SEXPREC *)
{
  return &(Rf_isVector);
}

static Rboolean(* *_cffi_var_Rf_isVectorAtomic(void))(SEXPREC *)
{
  return &(Rf_isVectorAtomic);
}

static Rboolean(* *_cffi_var_Rf_isVectorList(void))(SEXPREC *)
{
  return &(Rf_isVectorList);
}

static Rboolean(* *_cffi_var_Rf_isVectorizable(void))(SEXPREC *)
{
  return &(Rf_isVectorizable);
}

static SEXPREC *(* *_cffi_var_Rf_lang1(void))(SEXPREC *)
{
  return &(Rf_lang1);
}

static SEXPREC *(* *_cffi_var_Rf_lang2(void))(SEXPREC *, SEXPREC *)
{
  return &(Rf_lang2);
}

static SEXPREC *(* *_cffi_var_Rf_lang3(void))(SEXPREC *, SEXPREC *, SEXPREC *)
{
  return &(Rf_lang3);
}

static SEXPREC *(* *_cffi_var_Rf_lang4(void))(SEXPREC *, SEXPREC *, SEXPREC *, SEXPREC *)
{
  return &(Rf_lang4);
}

static SEXPREC *(* *_cffi_var_Rf_lang5(void))(SEXPREC *, SEXPREC *, SEXPREC *, SEXPREC *, SEXPREC *)
{
  return &(Rf_lang5);
}

static SEXPREC *(* *_cffi_var_Rf_lang6(void))(SEXPREC *, SEXPREC *, SEXPREC *, SEXPREC *, SEXPREC *, SEXPREC *)
{
  return &(Rf_lang6);
}

static SEXPREC *(* *_cffi_var_Rf_lastElt(void))(SEXPREC *)
{
  return &(Rf_lastElt);
}

static SEXPREC *(* *_cffi_var_Rf_lazy_duplicate(void))(SEXPREC *)
{
  return &(Rf_lazy_duplicate);
}

static SEXPREC *(* *_cffi_var_Rf_lcons(void))(SEXPREC *, SEXPREC *)
{
  return &(Rf_lcons);
}

static int(* *_cffi_var_Rf_length(void))(SEXPREC *)
{
  return &(Rf_length);
}

static SEXPREC *(* *_cffi_var_Rf_lengthgets(void))(SEXPREC *, int)
{
  return &(Rf_lengthgets);
}

static SEXPREC *(* *_cffi_var_Rf_list1(void))(SEXPREC *)
{
  return &(Rf_list1);
}

static SEXPREC *(* *_cffi_var_Rf_list2(void))(SEXPREC *, SEXPREC *)
{
  return &(Rf_list2);
}

static SEXPREC *(* *_cffi_var_Rf_list3(void))(SEXPREC *, SEXPREC *, SEXPREC *)
{
  return &(Rf_list3);
}

static SEXPREC *(* *_cffi_var_Rf_list4(void))(SEXPREC *, SEXPREC *, SEXPREC *, SEXPREC *)
{
  return &(Rf_list4);
}

static SEXPREC *(* *_cffi_var_Rf_list5(void))(SEXPREC *, SEXPREC *, SEXPREC *, SEXPREC *, SEXPREC *)
{
  return &(Rf_list5);
}

static SEXPREC *(* *_cffi_var_Rf_list6(void))(SEXPREC *, SEXPREC *, SEXPREC *, SEXPREC *, SEXPREC *, SEXPREC *)
{
  return &(Rf_list6);
}

static SEXPREC *(* *_cffi_var_Rf_listAppend(void))(SEXPREC *, SEXPREC *)
{
  return &(Rf_listAppend);
}

static SEXPREC *(* *_cffi_var_Rf_match(void))(SEXPREC *, SEXPREC *, int)
{
  return &(Rf_match);
}

static SEXPREC *(* *_cffi_var_Rf_matchE(void))(SEXPREC *, SEXPREC *, int, SEXPREC *)
{
  return &(Rf_matchE);
}

static SEXPREC *(* *_cffi_var_Rf_mkChar(void))(char const *)
{
  return &(Rf_mkChar);
}

static SEXPREC *(* *_cffi_var_Rf_mkCharCE(void))(char const *, cetype_t)
{
  return &(Rf_mkCharCE);
}

static SEXPREC *(* *_cffi_var_Rf_mkCharLen(void))(char const *, int)
{
  return &(Rf_mkCharLen);
}

static SEXPREC *(* *_cffi_var_Rf_mkCharLenCE(void))(char const *, int, cetype_t)
{
  return &(Rf_mkCharLenCE);
}

static SEXPREC *(* *_cffi_var_Rf_mkNamed(void))(unsigned int, char const * *)
{
  return &(Rf_mkNamed);
}

static SEXPREC *(* *_cffi_var_Rf_mkString(void))(char const *)
{
  return &(Rf_mkString);
}

static SEXPREC *(* *_cffi_var_Rf_namesgets(void))(SEXPREC *, SEXPREC *)
{
  return &(Rf_namesgets);
}

static int(* *_cffi_var_Rf_ncols(void))(SEXPREC *)
{
  return &(Rf_ncols);
}

static int(* *_cffi_var_Rf_nlevels(void))(SEXPREC *)
{
  return &(Rf_nlevels);
}

static int(* *_cffi_var_Rf_nrows(void))(SEXPREC *)
{
  return &(Rf_nrows);
}

static SEXPREC *(* *_cffi_var_Rf_nthcdr(void))(SEXPREC *, int)
{
  return &(Rf_nthcdr);
}

static Rboolean(* *_cffi_var_Rf_pmatch(void))(SEXPREC *, SEXPREC *, Rboolean)
{
  return &(Rf_pmatch);
}

static SEXPREC *(* *_cffi_var_Rf_protect(void))(SEXPREC *)
{
  return &(Rf_protect);
}

static Rboolean(* *_cffi_var_Rf_psmatch(void))(char const *, char const *, Rboolean)
{
  return &(Rf_psmatch);
}

static char const *(* *_cffi_var_Rf_reEnc(void))(char const *, cetype_t, cetype_t, int)
{
  return &(Rf_reEnc);
}

static SEXPREC *(* *_cffi_var_Rf_setAttrib(void))(SEXPREC *, SEXPREC *, SEXPREC *)
{
  return &(Rf_setAttrib);
}

static void(* *_cffi_var_Rf_setSVector(void))(SEXPREC * *, int, SEXPREC *)
{
  return &(Rf_setSVector);
}

static void(* *_cffi_var_Rf_setVar(void))(SEXPREC *, SEXPREC *, SEXPREC *)
{
  return &(Rf_setVar);
}

static SEXPREC *(* *_cffi_var_Rf_shallow_duplicate(void))(SEXPREC *)
{
  return &(Rf_shallow_duplicate);
}

static unsigned int(* *_cffi_var_Rf_str2type(void))(char const *)
{
  return &(Rf_str2type);
}

static int(* *_cffi_var_Rf_stringPositionTr(void))(SEXPREC *, char const *)
{
  return &(Rf_stringPositionTr);
}

static SEXPREC *(* *_cffi_var_Rf_substitute(void))(SEXPREC *, SEXPREC *)
{
  return &(Rf_substitute);
}

static SEXPREC *(* *_cffi_var_Rf_topenv(void))(SEXPREC *, SEXPREC *)
{
  return &(Rf_topenv);
}

static char const *(* *_cffi_var_Rf_translateChar(void))(SEXPREC *)
{
  return &(Rf_translateChar);
}

static char const *(* *_cffi_var_Rf_translateChar0(void))(SEXPREC *)
{
  return &(Rf_translateChar0);
}

static char const *(* *_cffi_var_Rf_translateCharUTF8(void))(SEXPREC *)
{
  return &(Rf_translateCharUTF8);
}

static char const *(* *_cffi_var_Rf_type2char(void))(unsigned int)
{
  return &(Rf_type2char);
}

static SEXPREC *(* *_cffi_var_Rf_type2rstr(void))(unsigned int)
{
  return &(Rf_type2rstr);
}

static SEXPREC *(* *_cffi_var_Rf_type2str(void))(unsigned int)
{
  return &(Rf_type2str);
}

static SEXPREC *(* *_cffi_var_Rf_type2str_nowarn(void))(unsigned int)
{
  return &(Rf_type2str_nowarn);
}

static void(* *_cffi_var_Rf_unprotect(void))(int)
{
  return &(Rf_unprotect);
}

static void(* *_cffi_var_Rf_warning(void))(char const *, ...)
{
  return &(Rf_warning);
}

static void(* *_cffi_var_Rf_warningcall(void))(SEXPREC *, char const *, ...)
{
  return &(Rf_warningcall);
}

static ptrdiff_t(* *_cffi_var_Rf_xlength(void))(SEXPREC *)
{
  return &(Rf_xlength);
}

static SEXPREC *(* *_cffi_var_Rf_xlengthgets(void))(SEXPREC *, ptrdiff_t)
{
  return &(Rf_xlengthgets);
}

static int(* *_cffi_var_Rstd_CleanUp(void))(int, int, int)
{
  return &(Rstd_CleanUp);
}

static SEXPREC *(* *_cffi_var_SETCAD4R(void))(SEXPREC *, SEXPREC *)
{
  return &(SETCAD4R);
}

static SEXPREC *(* *_cffi_var_SETCADDDR(void))(SEXPREC *, SEXPREC *)
{
  return &(SETCADDDR);
}

static SEXPREC *(* *_cffi_var_SETCADDR(void))(SEXPREC *, SEXPREC *)
{
  return &(SETCADDR);
}

static SEXPREC *(* *_cffi_var_SETCADR(void))(SEXPREC *, SEXPREC *)
{
  return &(SETCADR);
}

static SEXPREC *(* *_cffi_var_SETCAR(void))(SEXPREC *, SEXPREC *)
{
  return &(SETCAR);
}

static SEXPREC *(* *_cffi_var_SETCDR(void))(SEXPREC *, SEXPREC *)
{
  return &(SETCDR);
}

static void(* *_cffi_var_SETLENGTH(void))(SEXPREC *, ptrdiff_t)
{
  return &(SETLENGTH);
}

static int(* *_cffi_var_SETLEVELS(void))(SEXPREC *, int)
{
  return &(SETLEVELS);
}

static void(* *_cffi_var_SET_MISSING(void))(SEXPREC *, int)
{
  return &(SET_MISSING);
}

static void(* *_cffi_var_SET_STRING_ELT(void))(SEXPREC *, ptrdiff_t, SEXPREC *)
{
  return &(SET_STRING_ELT);
}

static void(* *_cffi_var_SET_TAG(void))(SEXPREC *, SEXPREC *)
{
  return &(SET_TAG);
}

static void(* *_cffi_var_SET_TRUELENGTH(void))(SEXPREC *, ptrdiff_t)
{
  return &(SET_TRUELENGTH);
}

static SEXPREC *(* *_cffi_var_SET_VECTOR_ELT(void))(SEXPREC *, ptrdiff_t, SEXPREC *)
{
  return &(SET_VECTOR_ELT);
}

static SEXPREC *(* *_cffi_var_STRING_ELT(void))(SEXPREC *, ptrdiff_t)
{
  return &(STRING_ELT);
}

static SEXPREC *(* *_cffi_var_TAG(void))(SEXPREC *)
{
  return &(TAG);
}

static ptrdiff_t(* *_cffi_var_TRUELENGTH(void))(SEXPREC *)
{
  return &(TRUELENGTH);
}

static int(* *_cffi_var_TYPEOF(void))(SEXPREC *)
{
  return &(TYPEOF);
}

static SEXPREC *(* *_cffi_var_VECTOR_ELT(void))(SEXPREC *, ptrdiff_t)
{
  return &(VECTOR_ELT);
}

static ptrdiff_t(* *_cffi_var_XLENGTH(void))(SEXPREC *)
{
  return &(XLENGTH);
}

static ptrdiff_t(* *_cffi_var_XTRUELENGTH(void))(SEXPREC *)
{
  return &(XTRUELENGTH);
}

static SEXPREC *(* *_cffi_var__R_ParseVector(void))(SEXPREC *, int, ParseStatus *, SEXPREC *)
{
  return &(_R_ParseVector);
}

static SEXPREC *(* *_cffi_var__R_tryEval(void))(SEXPREC *, SEXPREC *, int *)
{
  return &(_R_tryEval);
}

static void(* *_cffi_var__run_Rmainloop(void))(void)
{
  return &(_run_Rmainloop);
}

static int *_cffi_var_cb_interrupted(void)
{
  return &(cb_interrupted);
}

static void(* *_cffi_var_setup_Rmainloop(void))(void)
{
  return &(setup_Rmainloop);
}

static void *(* *_cffi_var_vmaxget(void))(void)
{
  return &(vmaxget);
}

static void(* *_cffi_var_vmaxset(void))(void const *)
{
  return &(vmaxset);
}

static char(*_cffi_var_xptr_callback_error_message(void))[100]
{
  return &(xptr_callback_error_message);
}

static int *_cffi_var_xptr_callback_error_occured(void)
{
  return &(xptr_callback_error_occured);
}

static const struct _cffi_global_s _cffi_globals[] = {
  { "ANYSXP", (void *)_cffi_const_ANYSXP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "BCODESXP", (void *)_cffi_const_BCODESXP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "BUILTINSXP", (void *)_cffi_const_BUILTINSXP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "Bytes", (void *)_cffi_const_Bytes, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "CAAR", (void *)_cffi_var_CAAR, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 532), (void *)0 },
  { "CAD4R", (void *)_cffi_var_CAD4R, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 532), (void *)0 },
  { "CADDDR", (void *)_cffi_var_CADDDR, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 532), (void *)0 },
  { "CADDR", (void *)_cffi_var_CADDR, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 532), (void *)0 },
  { "CADR", (void *)_cffi_var_CADR, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 532), (void *)0 },
  { "CAR", (void *)_cffi_var_CAR, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 532), (void *)0 },
  { "CDAR", (void *)_cffi_var_CDAR, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 532), (void *)0 },
  { "CDDDR", (void *)_cffi_var_CDDDR, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 532), (void *)0 },
  { "CDDR", (void *)_cffi_var_CDDR, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 532), (void *)0 },
  { "CDR", (void *)_cffi_var_CDR, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 532), (void *)0 },
  { "CE_ANY", (void *)_cffi_const_CE_ANY, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "CE_BYTES", (void *)_cffi_const_CE_BYTES, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "CE_LATIN1", (void *)_cffi_const_CE_LATIN1, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "CE_NATIVE", (void *)_cffi_const_CE_NATIVE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "CE_SYMBOL", (void *)_cffi_const_CE_SYMBOL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "CE_UTF8", (void *)_cffi_const_CE_UTF8, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "CHARSXP", (void *)_cffi_const_CHARSXP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "CLOSXP", (void *)_cffi_const_CLOSXP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "COMPLEX", (void *)_cffi_var_COMPLEX, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 526), (void *)0 },
  { "CONS_NR", (void *)_cffi_var_CONS_NR, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 197), (void *)0 },
  { "CPLXSXP", (void *)_cffi_const_CPLXSXP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "Chars", (void *)_cffi_const_Chars, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "DOTSXP", (void *)_cffi_const_DOTSXP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ENVSXP", (void *)_cffi_const_ENVSXP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EXPRSXP", (void *)_cffi_const_EXPRSXP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "EXTPTRSXP", (void *)_cffi_const_EXTPTRSXP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "FALSE", (void *)_cffi_const_FALSE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "FREESXP", (void *)_cffi_const_FREESXP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "FUNSXP", (void *)_cffi_const_FUNSXP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "INTEGER", (void *)_cffi_var_INTEGER, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 583), (void *)0 },
  { "INTSXP", (void *)_cffi_const_INTSXP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "IS_LONG_VEC", (void *)_cffi_var_IS_LONG_VEC, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 585), (void *)0 },
  { "IS_S4_OBJECT", (void *)_cffi_var_IS_S4_OBJECT, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 585), (void *)0 },
  { "LANGSXP", (void *)_cffi_const_LANGSXP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "LENGTH", (void *)_cffi_var_LENGTH, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 585), (void *)0 },
  { "LEVELS", (void *)_cffi_var_LEVELS, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 585), (void *)0 },
  { "LGLSXP", (void *)_cffi_const_LGLSXP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "LISTSXP", (void *)_cffi_const_LISTSXP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "LOGICAL", (void *)_cffi_var_LOGICAL, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 583), (void *)0 },
  { "MISSING", (void *)_cffi_var_MISSING, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 585), (void *)0 },
  { "NEWSXP", (void *)_cffi_const_NEWSXP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "NILSXP", (void *)_cffi_const_NILSXP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "PARSE_EOF", (void *)_cffi_const_PARSE_EOF, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PARSE_ERROR", (void *)_cffi_const_PARSE_ERROR, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PARSE_INCOMPLETE", (void *)_cffi_const_PARSE_INCOMPLETE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PARSE_NULL", (void *)_cffi_const_PARSE_NULL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PARSE_OK", (void *)_cffi_const_PARSE_OK, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "PRINTNAME", (void *)_cffi_var_PRINTNAME, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 532), (void *)0 },
  { "PROMSXP", (void *)_cffi_const_PROMSXP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "RAW", (void *)_cffi_var_RAW, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 617), (void *)0 },
  { "RAWSXP", (void *)_cffi_const_RAWSXP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "REAL", (void *)_cffi_var_REAL, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 580), (void *)0 },
  { "REALSXP", (void *)_cffi_const_REALSXP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "R_AsCharacterSymbol", (void *)_cffi_var_R_AsCharacterSymbol, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 3), (void *)0 },
  { "R_BaseEnv", (void *)_cffi_var_R_BaseEnv, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 3), (void *)0 },
  { "R_BaseNamespace", (void *)_cffi_var_R_BaseNamespace, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 3), (void *)0 },
  { "R_BaseSymbol", (void *)_cffi_var_R_BaseSymbol, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 3), (void *)0 },
  { "R_BindingIsActive", (void *)_cffi_var_R_BindingIsActive, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 520), (void *)0 },
  { "R_BindingIsLocked", (void *)_cffi_var_R_BindingIsLocked, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 520), (void *)0 },
  { "R_BlankScalarString", (void *)_cffi_var_R_BlankScalarString, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 3), (void *)0 },
  { "R_BlankString", (void *)_cffi_var_R_BlankString, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 3), (void *)0 },
  { "R_BraceSymbol", (void *)_cffi_var_R_BraceSymbol, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 3), (void *)0 },
  { "R_Bracket2Symbol", (void *)_cffi_var_R_Bracket2Symbol, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 3), (void *)0 },
  { "R_BracketSymbol", (void *)_cffi_var_R_BracketSymbol, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 3), (void *)0 },
  { "R_BytecodeExpr", (void *)_cffi_var_R_BytecodeExpr, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 532), (void *)0 },
  { "R_CHAR", (void *)_cffi_var_R_CHAR, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 573), (void *)0 },
  { "R_CheckUserInterrupt", (void *)_cffi_var_R_CheckUserInterrupt, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 647), (void *)0 },
  { "R_ClassSymbol", (void *)_cffi_var_R_ClassSymbol, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 3), (void *)0 },
  { "R_ClearExternalPtr", (void *)_cffi_var_R_ClearExternalPtr, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 137), (void *)0 },
  { "R_ClosureExpr", (void *)_cffi_var_R_ClosureExpr, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 532), (void *)0 },
  { "R_CurrentExpression", (void *)_cffi_var_R_CurrentExpression, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 3), (void *)0 },
  { "R_DefParams", (void *)_cffi_var_R_DefParams, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 644), (void *)0 },
  { "R_DeviceSymbol", (void *)_cffi_var_R_DeviceSymbol, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 3), (void *)0 },
  { "R_DimNamesSymbol", (void *)_cffi_var_R_DimNamesSymbol, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 3), (void *)0 },
  { "R_DimSymbol", (void *)_cffi_var_R_DimSymbol, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 3), (void *)0 },
  { "R_DollarSymbol", (void *)_cffi_var_R_DollarSymbol, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 3), (void *)0 },
  { "R_DotsSymbol", (void *)_cffi_var_R_DotsSymbol, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 3), (void *)0 },
  { "R_DoubleColonSymbol", (void *)_cffi_var_R_DoubleColonSymbol, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 3), (void *)0 },
  { "R_DropSymbol", (void *)_cffi_var_R_DropSymbol, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 3), (void *)0 },
  { "R_EmptyEnv", (void *)_cffi_var_R_EmptyEnv, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 3), (void *)0 },
  { "R_EnvironmentIsLocked", (void *)_cffi_var_R_EnvironmentIsLocked, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 518), (void *)0 },
  { "R_ExternalPtrAddr", (void *)_cffi_var_R_ExternalPtrAddr, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 620), (void *)0 },
  { "R_ExternalPtrAddrFn", (void *)_cffi_var_R_ExternalPtrAddrFn, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 619), (void *)0 },
  { "R_ExternalPtrProtected", (void *)_cffi_var_R_ExternalPtrProtected, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 532), (void *)0 },
  { "R_ExternalPtrTag", (void *)_cffi_var_R_ExternalPtrTag, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 532), (void *)0 },
  { "R_FindNamespace", (void *)_cffi_var_R_FindNamespace, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 532), (void *)0 },
  { "R_FindPackageEnv", (void *)_cffi_var_R_FindPackageEnv, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 532), (void *)0 },
  { "R_GlobalEnv", (void *)_cffi_var_R_GlobalEnv, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 3), (void *)0 },
  { "R_HasFancyBindings", (void *)_cffi_var_R_HasFancyBindings, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 518), (void *)0 },
  { "R_InBCInterpreter", (void *)_cffi_var_R_InBCInterpreter, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 3), (void *)0 },
  { "R_InputHandlers", (void *)_cffi_var_R_InputHandlers, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 34), (void *)0 },
  { "R_IsNA", (void *)_cffi_var_R_IsNA, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 593), (void *)0 },
  { "R_IsNaN", (void *)_cffi_var_R_IsNaN, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 593), (void *)0 },
  { "R_IsNamespaceEnv", (void *)_cffi_var_R_IsNamespaceEnv, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 518), (void *)0 },
  { "R_IsPackageEnv", (void *)_cffi_var_R_IsPackageEnv, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 518), (void *)0 },
  { "R_LastvalueSymbol", (void *)_cffi_var_R_LastvalueSymbol, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 3), (void *)0 },
  { "R_LevelsSymbol", (void *)_cffi_var_R_LevelsSymbol, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 3), (void *)0 },
  { "R_LockBinding", (void *)_cffi_var_R_LockBinding, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 626), (void *)0 },
  { "R_LockEnvironment", (void *)_cffi_var_R_LockEnvironment, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 624), (void *)0 },
  { "R_MakeActiveBinding", (void *)_cffi_var_R_MakeActiveBinding, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 628), (void *)0 },
  { "R_MakeExternalPtr", (void *)_cffi_var_R_MakeExternalPtr, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 567), (void *)0 },
  { "R_MakeExternalPtrFn", (void *)_cffi_var_R_MakeExternalPtrFn, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 566), (void *)0 },
  { "R_MakeWeakRef", (void *)_cffi_var_R_MakeWeakRef, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 538), (void *)0 },
  { "R_MakeWeakRefC", (void *)_cffi_var_R_MakeWeakRefC, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 545), (void *)0 },
  { "R_MissingArg", (void *)_cffi_var_R_MissingArg, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 3), (void *)0 },
  { "R_ModeSymbol", (void *)_cffi_var_R_ModeSymbol, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 3), (void *)0 },
  { "R_NaRmSymbol", (void *)_cffi_var_R_NaRmSymbol, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 3), (void *)0 },
  { "R_NaString", (void *)_cffi_var_R_NaString, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 3), (void *)0 },
  { "R_NameSymbol", (void *)_cffi_var_R_NameSymbol, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 3), (void *)0 },
  { "R_NamesSymbol", (void *)_cffi_var_R_NamesSymbol, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 3), (void *)0 },
  { "R_NamespaceEnvSpec", (void *)_cffi_var_R_NamespaceEnvSpec, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 532), (void *)0 },
  { "R_NamespaceEnvSymbol", (void *)_cffi_var_R_NamespaceEnvSymbol, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 3), (void *)0 },
  { "R_NamespaceRegistry", (void *)_cffi_var_R_NamespaceRegistry, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 3), (void *)0 },
  { "R_NilValue", (void *)_cffi_var_R_NilValue, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 3), (void *)0 },
  { "R_PackageEnvName", (void *)_cffi_var_R_PackageEnvName, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 532), (void *)0 },
  { "R_PackageSymbol", (void *)_cffi_var_R_PackageSymbol, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 3), (void *)0 },
  { "R_ParseEvalString", (void *)_cffi_var_R_ParseEvalString, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 551), (void *)0 },
  { "R_ParseVector", (void *)_cffi_f_R_ParseVector, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 144), (void *)_cffi_d_R_ParseVector },
  { "R_PolledEvents_t", (void *)_cffi_var_R_PolledEvents_t, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 622), (void *)0 },
  { "R_PreserveObject", (void *)_cffi_var_R_PreserveObject, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 137), (void *)0 },
  { "R_PreviousSymbol", (void *)_cffi_var_R_PreviousSymbol, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 3), (void *)0 },
  { "R_ProcessEvents", (void *)_cffi_var_R_ProcessEvents, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 647), (void *)0 },
  { "R_PromiseExpr", (void *)_cffi_var_R_PromiseExpr, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 532), (void *)0 },
  { "R_QuoteSymbol", (void *)_cffi_var_R_QuoteSymbol, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 3), (void *)0 },
  { "R_RegisterCFinalizer", (void *)_cffi_var_R_RegisterCFinalizer, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 635), (void *)0 },
  { "R_RegisterCFinalizerEx", (void *)_cffi_var_R_RegisterCFinalizerEx, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 636), (void *)0 },
  { "R_RegisterFinalizer", (void *)_cffi_var_R_RegisterFinalizer, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 626), (void *)0 },
  { "R_RegisterFinalizerEx", (void *)_cffi_var_R_RegisterFinalizerEx, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 627), (void *)0 },
  { "R_ReleaseObject", (void *)_cffi_var_R_ReleaseObject, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 137), (void *)0 },
  { "R_RestoreHashCount", (void *)_cffi_var_R_RestoreHashCount, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 137), (void *)0 },
  { "R_RowNamesSymbol", (void *)_cffi_var_R_RowNamesSymbol, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 3), (void *)0 },
  { "R_RunExitFinalizers", (void *)_cffi_var_R_RunExitFinalizers, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 647), (void *)0 },
  { "R_RunPendingFinalizers", (void *)_cffi_var_R_RunPendingFinalizers, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 647), (void *)0 },
  { "R_RunWeakRefFinalizer", (void *)_cffi_var_R_RunWeakRefFinalizer, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 137), (void *)0 },
  { "R_S4_extends", (void *)_cffi_var_R_S4_extends, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 197), (void *)0 },
  { "R_SeedsSymbol", (void *)_cffi_var_R_SeedsSymbol, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 3), (void *)0 },
  { "R_SetExternalPtrAddr", (void *)_cffi_var_R_SetExternalPtrAddr, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 634), (void *)0 },
  { "R_SetExternalPtrProtected", (void *)_cffi_var_R_SetExternalPtrProtected, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 626), (void *)0 },
  { "R_SetExternalPtrTag", (void *)_cffi_var_R_SetExternalPtrTag, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 626), (void *)0 },
  { "R_SetParams", (void *)_cffi_var_R_SetParams, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 644), (void *)0 },
  { "R_ShowMessage", (void *)_cffi_var_R_ShowMessage, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 637), (void *)0 },
  { "R_SignalHandlers_t", (void *)_cffi_var_R_SignalHandlers_t, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 121), (void *)0 },
  { "R_SortListSymbol", (void *)_cffi_var_R_SortListSymbol, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 3), (void *)0 },
  { "R_SourceSymbol", (void *)_cffi_var_R_SourceSymbol, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 3), (void *)0 },
  { "R_SpecSymbol", (void *)_cffi_var_R_SpecSymbol, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 3), (void *)0 },
  { "R_Srcref", (void *)_cffi_var_R_Srcref, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 3), (void *)0 },
  { "R_ToplevelExec", (void *)_cffi_var_R_ToplevelExec, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 525), (void *)0 },
  { "R_TripleColonSymbol", (void *)_cffi_var_R_TripleColonSymbol, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 3), (void *)0 },
  { "R_TspSymbol", (void *)_cffi_var_R_TspSymbol, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 3), (void *)0 },
  { "R_UnboundValue", (void *)_cffi_var_R_UnboundValue, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 3), (void *)0 },
  { "R_WeakRefKey", (void *)_cffi_var_R_WeakRefKey, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 532), (void *)0 },
  { "R_WeakRefValue", (void *)_cffi_var_R_WeakRefValue, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 532), (void *)0 },
  { "R_alloc", (void *)_cffi_var_R_alloc, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 572), (void *)0 },
  { "R_allocLD", (void *)_cffi_var_R_allocLD, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 601), (void *)0 },
  { "R_baseSymbol", (void *)_cffi_var_R_baseSymbol, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 3), (void *)0 },
  { "R_checkActivity", (void *)_cffi_var_R_checkActivity, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 621), (void *)0 },
  { "R_compute_identical", (void *)_cffi_var_R_compute_identical, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 522), (void *)0 },
  { "R_curErrorBuf", (void *)_cffi_var_R_curErrorBuf, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 576), (void *)0 },
  { "R_data_class", (void *)_cffi_var_R_data_class, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 533), (void *)0 },
  { "R_do_slot", (void *)_cffi_var_R_do_slot, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 197), (void *)0 },
  { "R_do_slot_assign", (void *)_cffi_var_R_do_slot_assign, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 537), (void *)0 },
  { "R_dot_Generic", (void *)_cffi_var_R_dot_Generic, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 3), (void *)0 },
  { "R_dot_Last", (void *)_cffi_var_R_dot_Last, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 647), (void *)0 },
  { "R_dot_Method", (void *)_cffi_var_R_dot_Method, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 3), (void *)0 },
  { "R_dot_defined", (void *)_cffi_var_R_dot_defined, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 3), (void *)0 },
  { "R_dot_packageName", (void *)_cffi_var_R_dot_packageName, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 3), (void *)0 },
  { "R_dot_target", (void *)_cffi_var_R_dot_target, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 3), (void *)0 },
  { "R_envHasNoSpecialSymbols", (void *)_cffi_var_R_envHasNoSpecialSymbols, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 518), (void *)0 },
  { "R_finite", (void *)_cffi_var_R_finite, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 593), (void *)0 },
  { "R_gc", (void *)_cffi_var_R_gc, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 647), (void *)0 },
  { "R_gc_running", (void *)_cffi_var_R_gc_running, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 600), (void *)0 },
  { "R_getEmbeddingDllInfo", (void *)_cffi_var_R_getEmbeddingDllInfo, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 514), (void *)0 },
  { "R_has_slot", (void *)_cffi_var_R_has_slot, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 586), (void *)0 },
  { "R_interrupts_pending_t", (void *)_cffi_var_R_interrupts_pending_t, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 121), (void *)0 },
  { "R_lsInternal", (void *)_cffi_var_R_lsInternal, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 533), (void *)0 },
  { "R_lsInternal3", (void *)_cffi_var_R_lsInternal3, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 534), (void *)0 },
  { "R_nchar", (void *)_cffi_var_R_nchar, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 590), (void *)0 },
  { "R_registerRoutines", (void *)_cffi_var_R_registerRoutines, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 584), (void *)0 },
  { "R_runHandlers", (void *)_cffi_var_R_runHandlers, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 645), (void *)0 },
  { "R_set_command_line_arguments", (void *)_cffi_var_R_set_command_line_arguments, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 642), (void *)0 },
  { "R_tryCatch", (void *)_cffi_var_R_tryCatch, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 531), (void *)0 },
  { "R_tryCatchError", (void *)_cffi_var_R_tryCatchError, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 530), (void *)0 },
  { "R_tryEval", (void *)_cffi_f_R_tryEval, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 118), (void *)_cffi_d_R_tryEval },
  { "R_tryEvalSilent", (void *)_cffi_var_R_tryEvalSilent, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 542), (void *)0 },
  { "R_unLockBinding", (void *)_cffi_var_R_unLockBinding, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 626), (void *)0 },
  { "Rf_CreateTag", (void *)_cffi_var_Rf_CreateTag, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 532), (void *)0 },
  { "Rf_DropDims", (void *)_cffi_var_Rf_DropDims, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 532), (void *)0 },
  { "Rf_GetArrayDimnames", (void *)_cffi_var_Rf_GetArrayDimnames, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 532), (void *)0 },
  { "Rf_GetColNames", (void *)_cffi_var_Rf_GetColNames, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 532), (void *)0 },
  { "Rf_GetMatrixDimnames", (void *)_cffi_var_Rf_GetMatrixDimnames, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 625), (void *)0 },
  { "Rf_GetOption1", (void *)_cffi_var_Rf_GetOption1, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 532), (void *)0 },
  { "Rf_GetOptionDigits", (void *)_cffi_var_Rf_GetOptionDigits, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 600), (void *)0 },
  { "Rf_GetOptionWidth", (void *)_cffi_var_Rf_GetOptionWidth, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 600), (void *)0 },
  { "Rf_GetRowNames", (void *)_cffi_var_Rf_GetRowNames, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 532), (void *)0 },
  { "Rf_NewEnvironment", (void *)_cffi_var_Rf_NewEnvironment, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 537), (void *)0 },
  { "Rf_NonNullStringMatch", (void *)_cffi_var_Rf_NonNullStringMatch, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 520), (void *)0 },
  { "Rf_PairToVectorList", (void *)_cffi_var_Rf_PairToVectorList, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 532), (void *)0 },
  { "Rf_PrintValue", (void *)_cffi_var_Rf_PrintValue, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 137), (void *)0 },
  { "Rf_S3Class", (void *)_cffi_var_Rf_S3Class, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 532), (void *)0 },
  { "Rf_ScalarComplex", (void *)_cffi_var_Rf_ScalarComplex, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 529), (void *)0 },
  { "Rf_ScalarInteger", (void *)_cffi_var_Rf_ScalarInteger, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 556), (void *)0 },
  { "Rf_ScalarLogical", (void *)_cffi_var_Rf_ScalarLogical, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 556), (void *)0 },
  { "Rf_ScalarRaw", (void *)_cffi_var_Rf_ScalarRaw, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 558), (void *)0 },
  { "Rf_ScalarReal", (void *)_cffi_var_Rf_ScalarReal, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 555), (void *)0 },
  { "Rf_ScalarString", (void *)_cffi_var_Rf_ScalarString, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 532), (void *)0 },
  { "Rf_StringBlank", (void *)_cffi_var_Rf_StringBlank, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 518), (void *)0 },
  { "Rf_VectorToPairList", (void *)_cffi_var_Rf_VectorToPairList, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 532), (void *)0 },
  { "Rf_acopy_string", (void *)_cffi_var_Rf_acopy_string, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 571), (void *)0 },
  { "Rf_alloc3DArray", (void *)_cffi_var_Rf_alloc3DArray, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 563), (void *)0 },
  { "Rf_allocArray", (void *)_cffi_var_Rf_allocArray, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 560), (void *)0 },
  { "Rf_allocFormalsList2", (void *)_cffi_var_Rf_allocFormalsList2, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 197), (void *)0 },
  { "Rf_allocFormalsList3", (void *)_cffi_var_Rf_allocFormalsList3, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 537), (void *)0 },
  { "Rf_allocFormalsList4", (void *)_cffi_var_Rf_allocFormalsList4, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 539), (void *)0 },
  { "Rf_allocFormalsList5", (void *)_cffi_var_Rf_allocFormalsList5, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 540), (void *)0 },
  { "Rf_allocFormalsList6", (void *)_cffi_var_Rf_allocFormalsList6, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 541), (void *)0 },
  { "Rf_allocList", (void *)_cffi_var_Rf_allocList, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 556), (void *)0 },
  { "Rf_allocMatrix", (void *)_cffi_var_Rf_allocMatrix, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 562), (void *)0 },
  { "Rf_allocS4Object", (void *)_cffi_var_Rf_allocS4Object, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 568), (void *)0 },
  { "Rf_allocSExp", (void *)_cffi_var_Rf_allocSExp, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 559), (void *)0 },
  { "Rf_allocVector", (void *)_cffi_var_Rf_allocVector, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 564), (void *)0 },
  { "Rf_allocVector3", (void *)_cffi_var_Rf_allocVector3, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 565), (void *)0 },
  { "Rf_any_duplicated", (void *)_cffi_var_Rf_any_duplicated, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 605), (void *)0 },
  { "Rf_any_duplicated3", (void *)_cffi_var_Rf_any_duplicated3, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 606), (void *)0 },
  { "Rf_arraySubscript", (void *)_cffi_var_Rf_arraySubscript, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 557), (void *)0 },
  { "Rf_asChar", (void *)_cffi_var_Rf_asChar, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 532), (void *)0 },
  { "Rf_asCharacterFactor", (void *)_cffi_var_Rf_asCharacterFactor, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 532), (void *)0 },
  { "Rf_asComplex", (void *)_cffi_var_Rf_asComplex, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 528), (void *)0 },
  { "Rf_asInteger", (void *)_cffi_var_Rf_asInteger, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 585), (void *)0 },
  { "Rf_asLogical", (void *)_cffi_var_Rf_asLogical, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 585), (void *)0 },
  { "Rf_asLogical2", (void *)_cffi_var_Rf_asLogical2, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 589), (void *)0 },
  { "Rf_asReal", (void *)_cffi_var_Rf_asReal, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 582), (void *)0 },
  { "Rf_asS4", (void *)_cffi_var_Rf_asS4, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 535), (void *)0 },
  { "Rf_classgets", (void *)_cffi_var_Rf_classgets, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 197), (void *)0 },
  { "Rf_coerceVector", (void *)_cffi_var_Rf_coerceVector, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 549), (void *)0 },
  { "Rf_conformable", (void *)_cffi_var_Rf_conformable, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 520), (void *)0 },
  { "Rf_cons", (void *)_cffi_var_Rf_cons, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 197), (void *)0 },
  { "Rf_copyListMatrix", (void *)_cffi_var_Rf_copyListMatrix, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 627), (void *)0 },
  { "Rf_copyMatrix", (void *)_cffi_var_Rf_copyMatrix, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 627), (void *)0 },
  { "Rf_copyMostAttrib", (void *)_cffi_var_Rf_copyMostAttrib, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 626), (void *)0 },
  { "Rf_copyVector", (void *)_cffi_var_Rf_copyVector, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 626), (void *)0 },
  { "Rf_countContexts", (void *)_cffi_var_Rf_countContexts, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 598), (void *)0 },
  { "Rf_defineVar", (void *)_cffi_var_Rf_defineVar, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 628), (void *)0 },
  { "Rf_dimgets", (void *)_cffi_var_Rf_dimgets, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 197), (void *)0 },
  { "Rf_dimnamesgets", (void *)_cffi_var_Rf_dimnamesgets, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 197), (void *)0 },
  { "Rf_duplicate", (void *)_cffi_var_Rf_duplicate, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 532), (void *)0 },
  { "Rf_duplicated", (void *)_cffi_var_Rf_duplicated, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 533), (void *)0 },
  { "Rf_elt", (void *)_cffi_var_Rf_elt, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 198), (void *)0 },
  { "Rf_error", (void *)_cffi_var_Rf_error, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 638), (void *)0 },
  { "Rf_errorcall", (void *)_cffi_var_Rf_errorcall, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 630), (void *)0 },
  { "Rf_eval", (void *)_cffi_var_Rf_eval, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 197), (void *)0 },
  { "Rf_findFun", (void *)_cffi_var_Rf_findFun, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 197), (void *)0 },
  { "Rf_findVar", (void *)_cffi_var_Rf_findVar, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 197), (void *)0 },
  { "Rf_findVarInFrame", (void *)_cffi_var_Rf_findVarInFrame, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 197), (void *)0 },
  { "Rf_findVarInFrame3", (void *)_cffi_var_Rf_findVarInFrame3, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 536), (void *)0 },
  { "Rf_getAttrib", (void *)_cffi_var_Rf_getAttrib, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 197), (void *)0 },
  { "Rf_getCharCE", (void *)_cffi_var_Rf_getCharCE, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 570), (void *)0 },
  { "Rf_gsetVar", (void *)_cffi_var_Rf_gsetVar, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 628), (void *)0 },
  { "Rf_inherits", (void *)_cffi_var_Rf_inherits, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 523), (void *)0 },
  { "Rf_initialize_R", (void *)_cffi_var_Rf_initialize_R, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 594), (void *)0 },
  { "Rf_install", (void *)_cffi_var_Rf_install, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 550), (void *)0 },
  { "Rf_installChar", (void *)_cffi_var_Rf_installChar, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 532), (void *)0 },
  { "Rf_isArray", (void *)_cffi_var_Rf_isArray, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 518), (void *)0 },
  { "Rf_isBasicClass", (void *)_cffi_var_Rf_isBasicClass, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 591), (void *)0 },
  { "Rf_isComplex", (void *)_cffi_var_Rf_isComplex, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 518), (void *)0 },
  { "Rf_isEnvironment", (void *)_cffi_var_Rf_isEnvironment, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 518), (void *)0 },
  { "Rf_isExpression", (void *)_cffi_var_Rf_isExpression, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 518), (void *)0 },
  { "Rf_isFactor", (void *)_cffi_var_Rf_isFactor, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 518), (void *)0 },
  { "Rf_isFrame", (void *)_cffi_var_Rf_isFrame, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 518), (void *)0 },
  { "Rf_isFree", (void *)_cffi_var_Rf_isFree, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 518), (void *)0 },
  { "Rf_isFunction", (void *)_cffi_var_Rf_isFunction, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 518), (void *)0 },
  { "Rf_isInteger", (void *)_cffi_var_Rf_isInteger, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 518), (void *)0 },
  { "Rf_isLanguage", (void *)_cffi_var_Rf_isLanguage, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 518), (void *)0 },
  { "Rf_isList", (void *)_cffi_var_Rf_isList, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 518), (void *)0 },
  { "Rf_isLogical", (void *)_cffi_var_Rf_isLogical, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 518), (void *)0 },
  { "Rf_isMatrix", (void *)_cffi_var_Rf_isMatrix, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 518), (void *)0 },
  { "Rf_isNewList", (void *)_cffi_var_Rf_isNewList, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 518), (void *)0 },
  { "Rf_isNull", (void *)_cffi_var_Rf_isNull, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 518), (void *)0 },
  { "Rf_isNumber", (void *)_cffi_var_Rf_isNumber, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 518), (void *)0 },
  { "Rf_isNumeric", (void *)_cffi_var_Rf_isNumeric, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 518), (void *)0 },
  { "Rf_isObject", (void *)_cffi_var_Rf_isObject, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 518), (void *)0 },
  { "Rf_isOrdered", (void *)_cffi_var_Rf_isOrdered, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 518), (void *)0 },
  { "Rf_isPairList", (void *)_cffi_var_Rf_isPairList, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 518), (void *)0 },
  { "Rf_isPrimitive", (void *)_cffi_var_Rf_isPrimitive, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 518), (void *)0 },
  { "Rf_isReal", (void *)_cffi_var_Rf_isReal, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 518), (void *)0 },
  { "Rf_isS4", (void *)_cffi_var_Rf_isS4, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 518), (void *)0 },
  { "Rf_isString", (void *)_cffi_var_Rf_isString, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 518), (void *)0 },
  { "Rf_isSymbol", (void *)_cffi_var_Rf_isSymbol, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 518), (void *)0 },
  { "Rf_isTs", (void *)_cffi_var_Rf_isTs, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 518), (void *)0 },
  { "Rf_isUnordered", (void *)_cffi_var_Rf_isUnordered, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 518), (void *)0 },
  { "Rf_isUnsorted", (void *)_cffi_var_Rf_isUnsorted, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 519), (void *)0 },
  { "Rf_isUserBinop", (void *)_cffi_var_Rf_isUserBinop, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 518), (void *)0 },
  { "Rf_isValidString", (void *)_cffi_var_Rf_isValidString, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 518), (void *)0 },
  { "Rf_isValidStringF", (void *)_cffi_var_Rf_isValidStringF, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 518), (void *)0 },
  { "Rf_isVector", (void *)_cffi_var_Rf_isVector, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 518), (void *)0 },
  { "Rf_isVectorAtomic", (void *)_cffi_var_Rf_isVectorAtomic, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 518), (void *)0 },
  { "Rf_isVectorList", (void *)_cffi_var_Rf_isVectorList, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 518), (void *)0 },
  { "Rf_isVectorizable", (void *)_cffi_var_Rf_isVectorizable, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 518), (void *)0 },
  { "Rf_lang1", (void *)_cffi_var_Rf_lang1, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 532), (void *)0 },
  { "Rf_lang2", (void *)_cffi_var_Rf_lang2, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 197), (void *)0 },
  { "Rf_lang3", (void *)_cffi_var_Rf_lang3, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 537), (void *)0 },
  { "Rf_lang4", (void *)_cffi_var_Rf_lang4, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 539), (void *)0 },
  { "Rf_lang5", (void *)_cffi_var_Rf_lang5, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 540), (void *)0 },
  { "Rf_lang6", (void *)_cffi_var_Rf_lang6, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 541), (void *)0 },
  { "Rf_lastElt", (void *)_cffi_var_Rf_lastElt, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 532), (void *)0 },
  { "Rf_lazy_duplicate", (void *)_cffi_var_Rf_lazy_duplicate, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 532), (void *)0 },
  { "Rf_lcons", (void *)_cffi_var_Rf_lcons, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 197), (void *)0 },
  { "Rf_length", (void *)_cffi_var_Rf_length, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 585), (void *)0 },
  { "Rf_lengthgets", (void *)_cffi_var_Rf_lengthgets, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 198), (void *)0 },
  { "Rf_list1", (void *)_cffi_var_Rf_list1, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 532), (void *)0 },
  { "Rf_list2", (void *)_cffi_var_Rf_list2, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 197), (void *)0 },
  { "Rf_list3", (void *)_cffi_var_Rf_list3, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 537), (void *)0 },
  { "Rf_list4", (void *)_cffi_var_Rf_list4, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 539), (void *)0 },
  { "Rf_list5", (void *)_cffi_var_Rf_list5, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 540), (void *)0 },
  { "Rf_list6", (void *)_cffi_var_Rf_list6, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 541), (void *)0 },
  { "Rf_listAppend", (void *)_cffi_var_Rf_listAppend, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 197), (void *)0 },
  { "Rf_match", (void *)_cffi_var_Rf_match, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 543), (void *)0 },
  { "Rf_matchE", (void *)_cffi_var_Rf_matchE, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 544), (void *)0 },
  { "Rf_mkChar", (void *)_cffi_var_Rf_mkChar, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 550), (void *)0 },
  { "Rf_mkCharCE", (void *)_cffi_var_Rf_mkCharCE, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 552), (void *)0 },
  { "Rf_mkCharLen", (void *)_cffi_var_Rf_mkCharLen, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 553), (void *)0 },
  { "Rf_mkCharLenCE", (void *)_cffi_var_Rf_mkCharLenCE, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 554), (void *)0 },
  { "Rf_mkNamed", (void *)_cffi_var_Rf_mkNamed, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 561), (void *)0 },
  { "Rf_mkString", (void *)_cffi_var_Rf_mkString, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 550), (void *)0 },
  { "Rf_namesgets", (void *)_cffi_var_Rf_namesgets, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 197), (void *)0 },
  { "Rf_ncols", (void *)_cffi_var_Rf_ncols, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 585), (void *)0 },
  { "Rf_nlevels", (void *)_cffi_var_Rf_nlevels, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 585), (void *)0 },
  { "Rf_nrows", (void *)_cffi_var_Rf_nrows, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 585), (void *)0 },
  { "Rf_nthcdr", (void *)_cffi_var_Rf_nthcdr, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 198), (void *)0 },
  { "Rf_pmatch", (void *)_cffi_var_Rf_pmatch, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 521), (void *)0 },
  { "Rf_protect", (void *)_cffi_var_Rf_protect, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 532), (void *)0 },
  { "Rf_psmatch", (void *)_cffi_var_Rf_psmatch, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 524), (void *)0 },
  { "Rf_reEnc", (void *)_cffi_var_Rf_reEnc, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 574), (void *)0 },
  { "Rf_setAttrib", (void *)_cffi_var_Rf_setAttrib, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 537), (void *)0 },
  { "Rf_setSVector", (void *)_cffi_var_Rf_setSVector, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 623), (void *)0 },
  { "Rf_setVar", (void *)_cffi_var_Rf_setVar, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 628), (void *)0 },
  { "Rf_shallow_duplicate", (void *)_cffi_var_Rf_shallow_duplicate, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 532), (void *)0 },
  { "Rf_str2type", (void *)_cffi_var_Rf_str2type, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 618), (void *)0 },
  { "Rf_stringPositionTr", (void *)_cffi_var_Rf_stringPositionTr, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 587), (void *)0 },
  { "Rf_substitute", (void *)_cffi_var_Rf_substitute, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 197), (void *)0 },
  { "Rf_topenv", (void *)_cffi_var_Rf_topenv, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 197), (void *)0 },
  { "Rf_translateChar", (void *)_cffi_var_Rf_translateChar, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 573), (void *)0 },
  { "Rf_translateChar0", (void *)_cffi_var_Rf_translateChar0, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 573), (void *)0 },
  { "Rf_translateCharUTF8", (void *)_cffi_var_Rf_translateCharUTF8, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 573), (void *)0 },
  { "Rf_type2char", (void *)_cffi_var_Rf_type2char, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 575), (void *)0 },
  { "Rf_type2rstr", (void *)_cffi_var_Rf_type2rstr, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 559), (void *)0 },
  { "Rf_type2str", (void *)_cffi_var_Rf_type2str, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 559), (void *)0 },
  { "Rf_type2str_nowarn", (void *)_cffi_var_Rf_type2str_nowarn, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 559), (void *)0 },
  { "Rf_unprotect", (void *)_cffi_var_Rf_unprotect, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 641), (void *)0 },
  { "Rf_warning", (void *)_cffi_var_Rf_warning, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 638), (void *)0 },
  { "Rf_warningcall", (void *)_cffi_var_Rf_warningcall, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 630), (void *)0 },
  { "Rf_xlength", (void *)_cffi_var_Rf_xlength, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 604), (void *)0 },
  { "Rf_xlengthgets", (void *)_cffi_var_Rf_xlengthgets, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 547), (void *)0 },
  { "Rstd_CleanUp", (void *)_cffi_var_Rstd_CleanUp, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 599), (void *)0 },
  { "S4SXP", (void *)_cffi_const_S4SXP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SETCAD4R", (void *)_cffi_var_SETCAD4R, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 197), (void *)0 },
  { "SETCADDDR", (void *)_cffi_var_SETCADDDR, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 197), (void *)0 },
  { "SETCADDR", (void *)_cffi_var_SETCADDR, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 197), (void *)0 },
  { "SETCADR", (void *)_cffi_var_SETCADR, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 197), (void *)0 },
  { "SETCAR", (void *)_cffi_var_SETCAR, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 197), (void *)0 },
  { "SETCDR", (void *)_cffi_var_SETCDR, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 197), (void *)0 },
  { "SETLENGTH", (void *)_cffi_var_SETLENGTH, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 632), (void *)0 },
  { "SETLEVELS", (void *)_cffi_var_SETLEVELS, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 588), (void *)0 },
  { "SET_MISSING", (void *)_cffi_var_SET_MISSING, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 631), (void *)0 },
  { "SET_STRING_ELT", (void *)_cffi_var_SET_STRING_ELT, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 633), (void *)0 },
  { "SET_TAG", (void *)_cffi_var_SET_TAG, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 626), (void *)0 },
  { "SET_TRUELENGTH", (void *)_cffi_var_SET_TRUELENGTH, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 632), (void *)0 },
  { "SET_VECTOR_ELT", (void *)_cffi_var_SET_VECTOR_ELT, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 548), (void *)0 },
  { "SPECIALSXP", (void *)_cffi_const_SPECIALSXP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "STRING_ELT", (void *)_cffi_var_STRING_ELT, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 547), (void *)0 },
  { "STRSXP", (void *)_cffi_const_STRSXP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "SYMSXP", (void *)_cffi_const_SYMSXP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "TAG", (void *)_cffi_var_TAG, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 532), (void *)0 },
  { "TRUE", (void *)_cffi_const_TRUE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "TRUELENGTH", (void *)_cffi_var_TRUELENGTH, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 604), (void *)0 },
  { "TYPEOF", (void *)_cffi_var_TYPEOF, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 585), (void *)0 },
  { "VECSXP", (void *)_cffi_const_VECSXP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "VECTOR_ELT", (void *)_cffi_var_VECTOR_ELT, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 547), (void *)0 },
  { "WEAKREFSXP", (void *)_cffi_const_WEAKREFSXP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "Width", (void *)_cffi_const_Width, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "XLENGTH", (void *)_cffi_var_XLENGTH, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 604), (void *)0 },
  { "XTRUELENGTH", (void *)_cffi_var_XTRUELENGTH, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 604), (void *)0 },
  { "_R_ParseVector", (void *)_cffi_var__R_ParseVector, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 546), (void *)0 },
  { "_R_tryEval", (void *)_cffi_var__R_tryEval, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 542), (void *)0 },
  { "_libR_dl_error_message", (void *)_cffi_f__libR_dl_error_message, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 260), (void *)_cffi_d__libR_dl_error_message },
  { "_libR_is_initialized", (void *)_cffi_f__libR_is_initialized, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 364), (void *)_cffi_d__libR_is_initialized },
  { "_libR_last_loaded_symbol", (void *)_cffi_f__libR_last_loaded_symbol, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 260), (void *)_cffi_d__libR_last_loaded_symbol },
  { "_libR_load", (void *)_cffi_f__libR_load, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 320), (void *)_cffi_d__libR_load },
  { "_libR_load_constants", (void *)_cffi_f__libR_load_constants, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 364), (void *)_cffi_d__libR_load_constants },
  { "_libR_load_symbols", (void *)_cffi_f__libR_load_symbols, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 364), (void *)_cffi_d__libR_load_symbols },
  { "_libR_set_callback", (void *)_cffi_f__libR_set_callback, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 468), (void *)_cffi_d__libR_set_callback },
  { "_libR_setup_xptr_callback", (void *)_cffi_f__libR_setup_xptr_callback, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 512), (void *)_cffi_d__libR_setup_xptr_callback },
  { "_libR_xptr_callback", (void *)_cffi_f__libR_xptr_callback, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 97), (void *)_cffi_d__libR_xptr_callback },
  { "_run_Rmainloop", (void *)_cffi_var__run_Rmainloop, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 647), (void *)0 },
  { "cb_addhistory", (void *)&_cffi_externpy__cb_addhistory, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 629), (void *)cb_addhistory },
  { "cb_busy", (void *)&_cffi_externpy__cb_busy, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 641), (void *)cb_busy },
  { "cb_busy_safe", (void *)_cffi_f_cb_busy_safe, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 487), (void *)_cffi_d_cb_busy_safe },
  { "cb_choose_file", (void *)&_cffi_externpy__cb_choose_file, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 595), (void *)cb_choose_file },
  { "cb_clean_up", (void *)&_cffi_externpy__cb_clean_up, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 643), (void *)cb_clean_up },
  { "cb_clearerr_console", (void *)&_cffi_externpy__cb_clearerr_console, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 647), (void *)cb_clearerr_console },
  { "cb_do_dataentry", (void *)&_cffi_externpy__cb_do_dataentry, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 539), (void *)cb_do_dataentry },
  { "cb_do_dataviewer", (void *)&_cffi_externpy__cb_do_dataviewer, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 539), (void *)cb_do_dataviewer },
  { "cb_do_selectlist", (void *)&_cffi_externpy__cb_do_selectlist, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 539), (void *)cb_do_selectlist },
  { "cb_edit_file", (void *)&_cffi_externpy__cb_edit_file, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 591), (void *)cb_edit_file },
  { "cb_edit_files", (void *)&_cffi_externpy__cb_edit_files, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 596), (void *)cb_edit_files },
  { "cb_flush_console", (void *)&_cffi_externpy__cb_flush_console, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 647), (void *)cb_flush_console },
  { "cb_interrupted", (void *)_cffi_var_cb_interrupted, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 21), (void *)0 },
  { "cb_loadhistory", (void *)&_cffi_externpy__cb_loadhistory, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 629), (void *)cb_loadhistory },
  { "cb_polled_events", (void *)&_cffi_externpy__cb_polled_events, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 647), (void *)cb_polled_events },
  { "cb_polled_events_interruptible", (void *)_cffi_f_cb_polled_events_interruptible, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 512), (void *)_cffi_d_cb_polled_events_interruptible },
  { "cb_process_events", (void *)&_cffi_externpy__cb_process_events, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 647), (void *)cb_process_events },
  { "cb_read_console", (void *)&_cffi_externpy__cb_read_console, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 592), (void *)cb_read_console },
  { "cb_read_console_interruptible", (void *)_cffi_f_cb_read_console_interruptible, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 323), (void *)_cffi_d_cb_read_console_interruptible },
  { "cb_reset_console", (void *)&_cffi_externpy__cb_reset_console, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 647), (void *)cb_reset_console },
  { "cb_savehistory", (void *)&_cffi_externpy__cb_savehistory, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 629), (void *)cb_savehistory },
  { "cb_show_files", (void *)&_cffi_externpy__cb_show_files, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 597), (void *)cb_show_files },
  { "cb_show_message", (void *)&_cffi_externpy__cb_show_message, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 637), (void *)cb_show_message },
  { "cb_suicide", (void *)&_cffi_externpy__cb_suicide, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 637), (void *)cb_suicide },
  { "cb_write_console", (void *)&_cffi_externpy__cb_write_console, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 639), (void *)cb_write_console },
  { "cb_write_console_capturable", (void *)&_cffi_externpy__cb_write_console_capturable, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 640), (void *)cb_write_console_capturable },
  { "cb_write_console_ex", (void *)&_cffi_externpy__cb_write_console_ex, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 640), (void *)cb_write_console_ex },
  { "cb_write_console_safe", (void *)_cffi_f_cb_write_console_safe, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 482), (void *)_cffi_d_cb_write_console_safe },
  { "cb_yes_no_cancel", (void *)&_cffi_externpy__cb_yes_no_cancel, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 591), (void *)cb_yes_no_cancel },
  { "peek_event", (void *)_cffi_f_peek_event, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 364), (void *)_cffi_d_peek_event },
  { "polled_events", (void *)_cffi_f_polled_events, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 512), (void *)_cffi_d_polled_events },
  { "process_events", (void *)_cffi_f_process_events, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 512), (void *)_cffi_d_process_events },
  { "run_Rmainloop", (void *)_cffi_f_run_Rmainloop, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 512), (void *)_cffi_d_run_Rmainloop },
  { "setup_Rmainloop", (void *)_cffi_var_setup_Rmainloop, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 647), (void *)0 },
  { "vmaxget", (void *)_cffi_var_vmaxget, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 236), (void *)0 },
  { "vmaxset", (void *)_cffi_var_vmaxset, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 646), (void *)0 },
  { "xptr_callback", (void *)&_cffi_externpy__xptr_callback, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 539), (void *)xptr_callback },
  { "xptr_callback_error_message", (void *)_cffi_var_xptr_callback_error_message, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 578), (void *)0 },
  { "xptr_callback_error_occured", (void *)_cffi_var_xptr_callback_error_occured, _CFFI_OP(_CFFI_OP_GLOBAL_VAR_F, 21), (void *)0 },
  { "xptr_finalizer", (void *)&_cffi_externpy__xptr_finalizer, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 137), (void *)xptr_finalizer },
};

static const struct _cffi_field_s _cffi_fields[] = {
  { "name", offsetof(R_CallMethodDef, name),
            sizeof(((R_CallMethodDef *)0)->name),
            _CFFI_OP(_CFFI_OP_NOOP, 25) },
  { "fun", offsetof(R_CallMethodDef, fun),
           sizeof(((R_CallMethodDef *)0)->fun),
           _CFFI_OP(_CFFI_OP_NOOP, 236) },
  { "numArgs", offsetof(R_CallMethodDef, numArgs),
               sizeof(((R_CallMethodDef *)0)->numArgs),
               _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "r", offsetof(Rcomplex, r),
         sizeof(((Rcomplex *)0)->r),
         _CFFI_OP(_CFFI_OP_NOOP, 188) },
  { "i", offsetof(Rcomplex, i),
         sizeof(((Rcomplex *)0)->i),
         _CFFI_OP(_CFFI_OP_NOOP, 188) },
  { "R_Quiet", offsetof(structRstart, R_Quiet),
               sizeof(((structRstart *)0)->R_Quiet),
               _CFFI_OP(_CFFI_OP_NOOP, 7) },
  { "R_Slave", offsetof(structRstart, R_Slave),
               sizeof(((structRstart *)0)->R_Slave),
               _CFFI_OP(_CFFI_OP_NOOP, 7) },
  { "R_Interactive", offsetof(structRstart, R_Interactive),
                     sizeof(((structRstart *)0)->R_Interactive),
                     _CFFI_OP(_CFFI_OP_NOOP, 7) },
  { "R_Verbose", offsetof(structRstart, R_Verbose),
                 sizeof(((structRstart *)0)->R_Verbose),
                 _CFFI_OP(_CFFI_OP_NOOP, 7) },
  { "LoadSiteFile", offsetof(structRstart, LoadSiteFile),
                    sizeof(((structRstart *)0)->LoadSiteFile),
                    _CFFI_OP(_CFFI_OP_NOOP, 7) },
  { "LoadInitFile", offsetof(structRstart, LoadInitFile),
                    sizeof(((structRstart *)0)->LoadInitFile),
                    _CFFI_OP(_CFFI_OP_NOOP, 7) },
  { "DebugInitFile", offsetof(structRstart, DebugInitFile),
                     sizeof(((structRstart *)0)->DebugInitFile),
                     _CFFI_OP(_CFFI_OP_NOOP, 7) },
  { "RestoreAction", offsetof(structRstart, RestoreAction),
                     sizeof(((structRstart *)0)->RestoreAction),
                     _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "SaveAction", offsetof(structRstart, SaveAction),
                  sizeof(((structRstart *)0)->SaveAction),
                  _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "vsize", offsetof(structRstart, vsize),
             sizeof(((structRstart *)0)->vsize),
             _CFFI_OP(_CFFI_OP_NOOP, 257) },
  { "nsize", offsetof(structRstart, nsize),
             sizeof(((structRstart *)0)->nsize),
             _CFFI_OP(_CFFI_OP_NOOP, 257) },
  { "max_vsize", offsetof(structRstart, max_vsize),
                 sizeof(((structRstart *)0)->max_vsize),
                 _CFFI_OP(_CFFI_OP_NOOP, 257) },
  { "max_nsize", offsetof(structRstart, max_nsize),
                 sizeof(((structRstart *)0)->max_nsize),
                 _CFFI_OP(_CFFI_OP_NOOP, 257) },
  { "ppsize", offsetof(structRstart, ppsize),
              sizeof(((structRstart *)0)->ppsize),
              _CFFI_OP(_CFFI_OP_NOOP, 257) },
  { "NoRenviron", offsetof(structRstart, NoRenviron),
                  sizeof(((structRstart *)0)->NoRenviron),
                  _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "rhome", offsetof(structRstart, rhome),
             sizeof(((structRstart *)0)->rhome),
             _CFFI_OP(_CFFI_OP_NOOP, 338) },
  { "home", offsetof(structRstart, home),
            sizeof(((structRstart *)0)->home),
            _CFFI_OP(_CFFI_OP_NOOP, 338) },
  { "_ReadConsole", offsetof(structRstart, _ReadConsole),
                    sizeof(((structRstart *)0)->_ReadConsole),
                    _CFFI_OP(_CFFI_OP_NOOP, 592) },
  { "_WriteConsole", offsetof(structRstart, _WriteConsole),
                     sizeof(((structRstart *)0)->_WriteConsole),
                     _CFFI_OP(_CFFI_OP_NOOP, 639) },
  { "CallBack", offsetof(structRstart, CallBack),
                sizeof(((structRstart *)0)->CallBack),
                _CFFI_OP(_CFFI_OP_NOOP, 647) },
  { "ShowMessage", offsetof(structRstart, ShowMessage),
                   sizeof(((structRstart *)0)->ShowMessage),
                   _CFFI_OP(_CFFI_OP_NOOP, 637) },
  { "YesNoCancel", offsetof(structRstart, YesNoCancel),
                   sizeof(((structRstart *)0)->YesNoCancel),
                   _CFFI_OP(_CFFI_OP_NOOP, 591) },
  { "Busy", offsetof(structRstart, Busy),
            sizeof(((structRstart *)0)->Busy),
            _CFFI_OP(_CFFI_OP_NOOP, 641) },
  { "CharacterMode", offsetof(structRstart, CharacterMode),
                     sizeof(((structRstart *)0)->CharacterMode),
                     _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "WriteConsoleEx", offsetof(structRstart, WriteConsoleEx),
                      sizeof(((structRstart *)0)->WriteConsoleEx),
                      _CFFI_OP(_CFFI_OP_NOOP, 640) },
  { "sxpinfo", offsetof(SEXPREC, sxpinfo),
               sizeof(((SEXPREC *)0)->sxpinfo),
               _CFFI_OP(_CFFI_OP_NOOP, 612) },
  { "attrib", offsetof(SEXPREC, attrib),
              sizeof(((SEXPREC *)0)->attrib),
              _CFFI_OP(_CFFI_OP_NOOP, 3) },
  { "gengc_next_node", offsetof(SEXPREC, gengc_next_node),
                       sizeof(((SEXPREC *)0)->gengc_next_node),
                       _CFFI_OP(_CFFI_OP_NOOP, 3) },
  { "gengc_prev_node", offsetof(SEXPREC, gengc_prev_node),
                       sizeof(((SEXPREC *)0)->gengc_prev_node),
                       _CFFI_OP(_CFFI_OP_NOOP, 3) },
  { "u", offsetof(SEXPREC, u),
         sizeof(((SEXPREC *)0)->u),
         _CFFI_OP(_CFFI_OP_NOOP, 616) },
  { "formals", offsetof(struct closxp_struct, formals),
               sizeof(((struct closxp_struct *)0)->formals),
               _CFFI_OP(_CFFI_OP_NOOP, 3) },
  { "body", offsetof(struct closxp_struct, body),
            sizeof(((struct closxp_struct *)0)->body),
            _CFFI_OP(_CFFI_OP_NOOP, 3) },
  { "env", offsetof(struct closxp_struct, env),
           sizeof(((struct closxp_struct *)0)->env),
           _CFFI_OP(_CFFI_OP_NOOP, 3) },
  { "frame", offsetof(struct envsxp_struct, frame),
             sizeof(((struct envsxp_struct *)0)->frame),
             _CFFI_OP(_CFFI_OP_NOOP, 3) },
  { "enclos", offsetof(struct envsxp_struct, enclos),
              sizeof(((struct envsxp_struct *)0)->enclos),
              _CFFI_OP(_CFFI_OP_NOOP, 3) },
  { "hashtab", offsetof(struct envsxp_struct, hashtab),
               sizeof(((struct envsxp_struct *)0)->hashtab),
               _CFFI_OP(_CFFI_OP_NOOP, 3) },
  { "carval", offsetof(struct listsxp_struct, carval),
              sizeof(((struct listsxp_struct *)0)->carval),
              _CFFI_OP(_CFFI_OP_NOOP, 3) },
  { "cdrval", offsetof(struct listsxp_struct, cdrval),
              sizeof(((struct listsxp_struct *)0)->cdrval),
              _CFFI_OP(_CFFI_OP_NOOP, 3) },
  { "tagval", offsetof(struct listsxp_struct, tagval),
              sizeof(((struct listsxp_struct *)0)->tagval),
              _CFFI_OP(_CFFI_OP_NOOP, 3) },
  { "offset", offsetof(struct primsxp_struct, offset),
              sizeof(((struct primsxp_struct *)0)->offset),
              _CFFI_OP(_CFFI_OP_NOOP, 21) },
  { "value", offsetof(struct promsxp_struct, value),
             sizeof(((struct promsxp_struct *)0)->value),
             _CFFI_OP(_CFFI_OP_NOOP, 3) },
  { "expr", offsetof(struct promsxp_struct, expr),
            sizeof(((struct promsxp_struct *)0)->expr),
            _CFFI_OP(_CFFI_OP_NOOP, 3) },
  { "env", offsetof(struct promsxp_struct, env),
           sizeof(((struct promsxp_struct *)0)->env),
           _CFFI_OP(_CFFI_OP_NOOP, 3) },
  { "type", (size_t)-1,
            5 /* bits */,
            _CFFI_OP(_CFFI_OP_BITFIELD, 161) },
  { "scalar", (size_t)-1,
              1 /* bits */,
              _CFFI_OP(_CFFI_OP_BITFIELD, 161) },
  { "obj", (size_t)-1,
           1 /* bits */,
           _CFFI_OP(_CFFI_OP_BITFIELD, 161) },
  { "alt", (size_t)-1,
           1 /* bits */,
           _CFFI_OP(_CFFI_OP_BITFIELD, 161) },
  { "gp", (size_t)-1,
          16 /* bits */,
          _CFFI_OP(_CFFI_OP_BITFIELD, 161) },
  { "mark", (size_t)-1,
            1 /* bits */,
            _CFFI_OP(_CFFI_OP_BITFIELD, 161) },
  { "debug", (size_t)-1,
             1 /* bits */,
             _CFFI_OP(_CFFI_OP_BITFIELD, 161) },
  { "trace", (size_t)-1,
             1 /* bits */,
             _CFFI_OP(_CFFI_OP_BITFIELD, 161) },
  { "spare", (size_t)-1,
             1 /* bits */,
             _CFFI_OP(_CFFI_OP_BITFIELD, 161) },
  { "gcgen", (size_t)-1,
             1 /* bits */,
             _CFFI_OP(_CFFI_OP_BITFIELD, 161) },
  { "gccls", (size_t)-1,
             3 /* bits */,
             _CFFI_OP(_CFFI_OP_BITFIELD, 161) },
  { "named", (size_t)-1,
             16 /* bits */,
             _CFFI_OP(_CFFI_OP_BITFIELD, 161) },
  { "extra", (size_t)-1,
             16 /* bits */,
             _CFFI_OP(_CFFI_OP_BITFIELD, 161) },
  { "pname", offsetof(struct symsxp_struct, pname),
             sizeof(((struct symsxp_struct *)0)->pname),
             _CFFI_OP(_CFFI_OP_NOOP, 3) },
  { "value", offsetof(struct symsxp_struct, value),
             sizeof(((struct symsxp_struct *)0)->value),
             _CFFI_OP(_CFFI_OP_NOOP, 3) },
  { "internal", offsetof(struct symsxp_struct, internal),
                sizeof(((struct symsxp_struct *)0)->internal),
                _CFFI_OP(_CFFI_OP_NOOP, 3) },
  { "length", offsetof(struct vecsxp_struct, length),
              sizeof(((struct vecsxp_struct *)0)->length),
              _CFFI_OP(_CFFI_OP_NOOP, 152) },
  { "truelength", offsetof(struct vecsxp_struct, truelength),
                  sizeof(((struct vecsxp_struct *)0)->truelength),
                  _CFFI_OP(_CFFI_OP_NOOP, 152) },
  { "primsxp", (size_t)-1,
               (size_t)-1,
               _CFFI_OP(_CFFI_OP_NOOP, 610) },
  { "symsxp", (size_t)-1,
              (size_t)-1,
              _CFFI_OP(_CFFI_OP_NOOP, 613) },
  { "listsxp", (size_t)-1,
               (size_t)-1,
               _CFFI_OP(_CFFI_OP_NOOP, 609) },
  { "envsxp", (size_t)-1,
              (size_t)-1,
              _CFFI_OP(_CFFI_OP_NOOP, 608) },
  { "closxp", (size_t)-1,
              (size_t)-1,
              _CFFI_OP(_CFFI_OP_NOOP, 607) },
  { "promsxp", (size_t)-1,
               (size_t)-1,
               _CFFI_OP(_CFFI_OP_NOOP, 611) },
};

static const struct _cffi_struct_union_s _cffi_struct_unions[] = {
  { "$1", 616, _CFFI_F_UNION|_CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 66, 6 /* unnamed */ },
  { "$R_CallMethodDef", 517, _CFFI_F_CHECK_FIELDS,
    sizeof(R_CallMethodDef), offsetof(struct _cffi_align_typedef_R_CallMethodDef, y), 0, 3 },
  { "$Rcomplex", 43, _CFFI_F_CHECK_FIELDS,
    sizeof(Rcomplex), offsetof(struct _cffi_align_typedef_Rcomplex, y), 3, 2 },
  { "$structRstart", 615, _CFFI_F_CHECK_FIELDS,
    sizeof(structRstart), offsetof(struct _cffi_align_typedef_structRstart, y), 5, 25 },
  { "SEXPREC", 569, _CFFI_F_CHECK_FIELDS,
    sizeof(SEXPREC), offsetof(struct _cffi_align__SEXPREC, y), 30, 5 },
  { "_DllInfo", 515, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "closxp_struct", 607, _CFFI_F_CHECK_FIELDS,
    sizeof(struct closxp_struct), offsetof(struct _cffi_align_struct_closxp_struct, y), 35, 3 },
  { "envsxp_struct", 608, _CFFI_F_CHECK_FIELDS,
    sizeof(struct envsxp_struct), offsetof(struct _cffi_align_struct_envsxp_struct, y), 38, 3 },
  { "listsxp_struct", 609, _CFFI_F_CHECK_FIELDS,
    sizeof(struct listsxp_struct), offsetof(struct _cffi_align_struct_listsxp_struct, y), 41, 3 },
  { "primsxp_struct", 610, _CFFI_F_CHECK_FIELDS,
    sizeof(struct primsxp_struct), offsetof(struct _cffi_align_struct_primsxp_struct, y), 44, 1 },
  { "promsxp_struct", 611, _CFFI_F_CHECK_FIELDS,
    sizeof(struct promsxp_struct), offsetof(struct _cffi_align_struct_promsxp_struct, y), 45, 3 },
  { "sxpinfo_struct", 612, _CFFI_F_CHECK_FIELDS,
    sizeof(struct sxpinfo_struct), offsetof(struct _cffi_align_struct_sxpinfo_struct, y), 48, 13 },
  { "symsxp_struct", 613, _CFFI_F_CHECK_FIELDS,
    sizeof(struct symsxp_struct), offsetof(struct _cffi_align_struct_symsxp_struct, y), 61, 3 },
  { "vecsxp_struct", 614, _CFFI_F_CHECK_FIELDS,
    sizeof(struct vecsxp_struct), offsetof(struct _cffi_align_struct_vecsxp_struct, y), 64, 2 },
};

static const struct _cffi_enum_s _cffi_enums[] = {
  { "$ParseStatus", 516, _cffi_prim_int(sizeof(ParseStatus), ((ParseStatus)-1) <= 0),
    "PARSE_NULL,PARSE_OK,PARSE_INCOMPLETE,PARSE_ERROR,PARSE_EOF" },
  { "$Rboolean", 7, _cffi_prim_int(sizeof(Rboolean), ((Rboolean)-1) <= 0),
    "FALSE,TRUE" },
  { "$cetype_t", 176, _cffi_prim_int(sizeof(cetype_t), ((cetype_t)-1) <= 0),
    "CE_NATIVE,CE_UTF8,CE_LATIN1,CE_BYTES,CE_SYMBOL,CE_ANY" },
  { "$nchar_type", 315, _cffi_prim_int(sizeof(nchar_type), ((nchar_type)-1) <= 0),
    "Bytes,Chars,Width" },
};

static const struct _cffi_typename_s _cffi_typenames[] = {
  { "DL_FUNC", 236 },
  { "DllInfo", 515 },
  { "ParseStatus", 516 },
  { "R_CFinalizer_t", 137 },
  { "R_CallMethodDef", 517 },
  { "R_ExternalMethodDef", 517 },
  { "R_len_t", 21 },
  { "R_xlen_t", 152 },
  { "Rboolean", 7 },
  { "Rbyte", 202 },
  { "Rcomplex", 43 },
  { "Rstart", 500 },
  { "SEXP", 3 },
  { "SEXPREC", 569 },
  { "SEXPTYPE", 161 },
  { "cetype_t", 176 },
  { "nchar_type", 315 },
  { "structRstart", 615 },
};

static const struct _cffi_type_context_s _cffi_type_context = {
  _cffi_types,
  _cffi_globals,
  _cffi_fields,
  _cffi_struct_unions,
  _cffi_enums,
  _cffi_typenames,
  437,  /* num_globals */
  14,  /* num_struct_unions */
  4,  /* num_enums */
  18,  /* num_typenames */
  NULL,  /* no includes */
  649,  /* num_types */
  1,  /* flags */
};

#ifdef __GNUC__
#  pragma GCC visibility push(default)  /* for -fvisibility= */
#endif

#ifdef PYPY_VERSION
PyMODINIT_FUNC
_cffi_pypyinit__cffi(const void *p[])
{
    if (((intptr_t)p[0]) >= 0x0A03) {
        _cffi_call_python_org = (void(*)(struct _cffi_externpy_s *, char *))p[1];
    }
    p[0] = (const void *)0x2601;
    p[1] = &_cffi_type_context;
#if PY_MAJOR_VERSION >= 3
    return NULL;
#endif
}
#  ifdef _MSC_VER
     PyMODINIT_FUNC
#  if PY_MAJOR_VERSION >= 3
     PyInit__cffi(void) { return NULL; }
#  else
     init_cffi(void) { }
#  endif
#  endif
#elif PY_MAJOR_VERSION >= 3
PyMODINIT_FUNC
PyInit__cffi(void)
{
  return _cffi_init("rchitect._cffi", 0x2601, &_cffi_type_context);
}
#else
PyMODINIT_FUNC
init_cffi(void)
{
  _cffi_init("rchitect._cffi", 0x2601, &_cffi_type_context);
}
#endif

#ifdef __GNUC__
#  pragma GCC visibility pop
#endif
