// See <https://github.com/apache/pdfbox/blob/4438b8fdc67a3a9ebfb194595d0e81f88b708a37/pdfbox/src/main/java/org/apache/pdfbox/pdmodel/font/encoding/MacRomanEncoding.java>
use phf::phf_map;

pub(crate) fn get(code: u8) -> Option<&'static str> {
    MAC_ROMAN.get(&code).copied()
}

pub(crate) fn get_inverse(name: &str) -> Option<u8> {
    MAC_ROMAN_INVERSE.get(name).copied()
}

static MAC_ROMAN: phf::Map<u8, &'static str> = phf_map! {
    65_u8 => "A",
    174_u8 => "AE",
    231_u8 => "Aacute",
    229_u8 => "Acircumflex",
    128_u8 => "Adieresis",
    203_u8 => "Agrave",
    129_u8 => "Aring",
    204_u8 => "Atilde",
    66_u8 => "B",
    67_u8 => "C",
    130_u8 => "Ccedilla",
    68_u8 => "D",
    69_u8 => "E",
    131_u8 => "Eacute",
    230_u8 => "Ecircumflex",
    232_u8 => "Edieresis",
    233_u8 => "Egrave",
    70_u8 => "F",
    71_u8 => "G",
    72_u8 => "H",
    73_u8 => "I",
    234_u8 => "Iacute",
    235_u8 => "Icircumflex",
    236_u8 => "Idieresis",
    237_u8 => "Igrave",
    74_u8 => "J",
    75_u8 => "K",
    76_u8 => "L",
    77_u8 => "M",
    78_u8 => "N",
    132_u8 => "Ntilde",
    79_u8 => "O",
    206_u8 => "OE",
    238_u8 => "Oacute",
    239_u8 => "Ocircumflex",
    133_u8 => "Odieresis",
    241_u8 => "Ograve",
    175_u8 => "Oslash",
    205_u8 => "Otilde",
    80_u8 => "P",
    81_u8 => "Q",
    82_u8 => "R",
    83_u8 => "S",
    84_u8 => "T",
    85_u8 => "U",
    242_u8 => "Uacute",
    243_u8 => "Ucircumflex",
    134_u8 => "Udieresis",
    244_u8 => "Ugrave",
    86_u8 => "V",
    87_u8 => "W",
    88_u8 => "X",
    89_u8 => "Y",
    217_u8 => "Ydieresis",
    90_u8 => "Z",
    97_u8 => "a",
    135_u8 => "aacute",
    137_u8 => "acircumflex",
    171_u8 => "acute",
    138_u8 => "adieresis",
    190_u8 => "ae",
    136_u8 => "agrave",
    38_u8 => "ampersand",
    140_u8 => "aring",
    94_u8 => "asciicircum",
    126_u8 => "asciitilde",
    42_u8 => "asterisk",
    64_u8 => "at",
    139_u8 => "atilde",
    98_u8 => "b",
    92_u8 => "backslash",
    124_u8 => "bar",
    123_u8 => "braceleft",
    125_u8 => "braceright",
    91_u8 => "bracketleft",
    93_u8 => "bracketright",
    249_u8 => "breve",
    165_u8 => "bullet",
    99_u8 => "c",
    255_u8 => "caron",
    141_u8 => "ccedilla",
    252_u8 => "cedilla",
    162_u8 => "cent",
    246_u8 => "circumflex",
    58_u8 => "colon",
    44_u8 => "comma",
    169_u8 => "copyright",
    219_u8 => "currency",
    100_u8 => "d",
    160_u8 => "dagger",
    224_u8 => "daggerdbl",
    161_u8 => "degree",
    172_u8 => "dieresis",
    214_u8 => "divide",
    36_u8 => "dollar",
    250_u8 => "dotaccent",
    245_u8 => "dotlessi",
    101_u8 => "e",
    142_u8 => "eacute",
    144_u8 => "ecircumflex",
    145_u8 => "edieresis",
    143_u8 => "egrave",
    56_u8 => "eight",
    201_u8 => "ellipsis",
    209_u8 => "emdash",
    208_u8 => "endash",
    61_u8 => "equal",
    33_u8 => "exclam",
    193_u8 => "exclamdown",
    102_u8 => "f",
    222_u8 => "fi",
    53_u8 => "five",
    223_u8 => "fl",
    196_u8 => "florin",
    52_u8 => "four",
    218_u8 => "fraction",
    103_u8 => "g",
    167_u8 => "germandbls",
    96_u8 => "grave",
    62_u8 => "greater",
    199_u8 => "guillemotleft",
    200_u8 => "guillemotright",
    220_u8 => "guilsinglleft",
    221_u8 => "guilsinglright",
    104_u8 => "h",
    253_u8 => "hungarumlaut",
    45_u8 => "hyphen",
    105_u8 => "i",
    146_u8 => "iacute",
    148_u8 => "icircumflex",
    149_u8 => "idieresis",
    147_u8 => "igrave",
    106_u8 => "j",
    107_u8 => "k",
    108_u8 => "l",
    60_u8 => "less",
    194_u8 => "logicalnot",
    109_u8 => "m",
    248_u8 => "macron",
    181_u8 => "mu",
    110_u8 => "n",
    57_u8 => "nine",
    150_u8 => "ntilde",
    35_u8 => "numbersign",
    111_u8 => "o",
    151_u8 => "oacute",
    153_u8 => "ocircumflex",
    154_u8 => "odieresis",
    207_u8 => "oe",
    254_u8 => "ogonek",
    152_u8 => "ograve",
    49_u8 => "one",
    187_u8 => "ordfeminine",
    188_u8 => "ordmasculine",
    191_u8 => "oslash",
    155_u8 => "otilde",
    112_u8 => "p",
    166_u8 => "paragraph",
    40_u8 => "parenleft",
    41_u8 => "parenright",
    37_u8 => "percent",
    46_u8 => "period",
    225_u8 => "periodcentered",
    228_u8 => "perthousand",
    43_u8 => "plus",
    177_u8 => "plusminus",
    113_u8 => "q",
    63_u8 => "question",
    192_u8 => "questiondown",
    34_u8 => "quotedbl",
    227_u8 => "quotedblbase",
    210_u8 => "quotedblleft",
    211_u8 => "quotedblright",
    212_u8 => "quoteleft",
    213_u8 => "quoteright",
    226_u8 => "quotesinglbase",
    39_u8 => "quotesingle",
    114_u8 => "r",
    168_u8 => "registered",
    251_u8 => "ring",
    115_u8 => "s",
    164_u8 => "section",
    59_u8 => "semicolon",
    55_u8 => "seven",
    54_u8 => "six",
    47_u8 => "slash",
    32_u8 => "space",
    163_u8 => "sterling",
    116_u8 => "t",
    51_u8 => "three",
    247_u8 => "tilde",
    170_u8 => "trademark",
    50_u8 => "two",
    117_u8 => "u",
    156_u8 => "uacute",
    158_u8 => "ucircumflex",
    159_u8 => "udieresis",
    157_u8 => "ugrave",
    95_u8 => "underscore",
    118_u8 => "v",
    119_u8 => "w",
    120_u8 => "x",
    121_u8 => "y",
    216_u8 => "ydieresis",
    180_u8 => "yen",
    122_u8 => "z",
    48_u8 => "zero",
    202_u8 => "nbspace",
};

static MAC_ROMAN_INVERSE: phf::Map<&'static str, u8> = phf_map! {
     "A" => 65_u8,
     "AE" => 174_u8,
     "Aacute" => 231_u8,
     "Acircumflex" => 229_u8,
     "Adieresis" => 128_u8,
     "Agrave" => 203_u8,
     "Aring" => 129_u8,
     "Atilde" => 204_u8,
     "B" => 66_u8,
     "C" => 67_u8,
     "Ccedilla" => 130_u8,
     "D" => 68_u8,
     "E" => 69_u8,
     "Eacute" => 131_u8,
     "Ecircumflex" => 230_u8,
     "Edieresis" => 232_u8,
     "Egrave" => 233_u8,
     "F" => 70_u8,
     "G" => 71_u8,
     "H" => 72_u8,
     "I" => 73_u8,
     "Iacute" => 234_u8,
     "Icircumflex" => 235_u8,
     "Idieresis" => 236_u8,
     "Igrave" => 237_u8,
     "J" => 74_u8,
     "K" => 75_u8,
     "L" => 76_u8,
     "M" => 77_u8,
     "N" => 78_u8,
     "Ntilde" => 132_u8,
     "O" => 79_u8,
     "OE" => 206_u8,
     "Oacute" => 238_u8,
     "Ocircumflex" => 239_u8,
     "Odieresis" => 133_u8,
     "Ograve" => 241_u8,
     "Oslash" => 175_u8,
     "Otilde" => 205_u8,
     "P" => 80_u8,
     "Q" => 81_u8,
     "R" => 82_u8,
     "S" => 83_u8,
     "T" => 84_u8,
     "U" => 85_u8,
     "Uacute" => 242_u8,
     "Ucircumflex" => 243_u8,
     "Udieresis" => 134_u8,
     "Ugrave" => 244_u8,
     "V" => 86_u8,
     "W" => 87_u8,
     "X" => 88_u8,
     "Y" => 89_u8,
     "Ydieresis" => 217_u8,
     "Z" => 90_u8,
     "a" => 97_u8,
     "aacute" => 135_u8,
     "acircumflex" => 137_u8,
     "acute" => 171_u8,
     "adieresis" => 138_u8,
     "ae" => 190_u8,
     "agrave" => 136_u8,
     "ampersand" => 38_u8,
     "aring" => 140_u8,
     "asciicircum" => 94_u8,
     "asciitilde" => 126_u8,
     "asterisk" => 42_u8,
     "at" => 64_u8,
     "atilde" => 139_u8,
     "b" => 98_u8,
     "backslash" => 92_u8,
     "bar" => 124_u8,
     "braceleft" => 123_u8,
     "braceright" => 125_u8,
     "bracketleft" => 91_u8,
     "bracketright" => 93_u8,
     "breve" => 249_u8,
     "bullet" => 165_u8,
     "c" => 99_u8,
     "caron" => 255_u8,
     "ccedilla" => 141_u8,
     "cedilla" => 252_u8,
     "cent" => 162_u8,
     "circumflex" => 246_u8,
     "colon" => 58_u8,
     "comma" => 44_u8,
     "copyright" => 169_u8,
     "currency" => 219_u8,
     "d" => 100_u8,
     "dagger" => 160_u8,
     "daggerdbl" => 224_u8,
     "degree" => 161_u8,
     "dieresis" => 172_u8,
     "divide" => 214_u8,
     "dollar" => 36_u8,
     "dotaccent" => 250_u8,
     "dotlessi" => 245_u8,
     "e" => 101_u8,
     "eacute" => 142_u8,
     "ecircumflex" => 144_u8,
     "edieresis" => 145_u8,
     "egrave" => 143_u8,
     "eight" => 56_u8,
     "ellipsis" => 201_u8,
     "emdash" => 209_u8,
     "endash" => 208_u8,
     "equal" => 61_u8,
     "exclam" => 33_u8,
     "exclamdown" => 193_u8,
     "f" => 102_u8,
     "fi" => 222_u8,
     "five" => 53_u8,
     "fl" => 223_u8,
     "florin" => 196_u8,
     "four" => 52_u8,
     "fraction" => 218_u8,
     "g" => 103_u8,
     "germandbls" => 167_u8,
     "grave" => 96_u8,
     "greater" => 62_u8,
     "guillemotleft" => 199_u8,
     "guillemotright" => 200_u8,
     "guilsinglleft" => 220_u8,
     "guilsinglright" => 221_u8,
     "h" => 104_u8,
     "hungarumlaut" => 253_u8,
     "hyphen" => 45_u8,
     "i" => 105_u8,
     "iacute" => 146_u8,
     "icircumflex" => 148_u8,
     "idieresis" => 149_u8,
     "igrave" => 147_u8,
     "j" => 106_u8,
     "k" => 107_u8,
     "l" => 108_u8,
     "less" => 60_u8,
     "logicalnot" => 194_u8,
     "m" => 109_u8,
     "macron" => 248_u8,
     "mu" => 181_u8,
     "n" => 110_u8,
     "nine" => 57_u8,
     "ntilde" => 150_u8,
     "numbersign" => 35_u8,
     "o" => 111_u8,
     "oacute" => 151_u8,
     "ocircumflex" => 153_u8,
     "odieresis" => 154_u8,
     "oe" => 207_u8,
     "ogonek" => 254_u8,
     "ograve" => 152_u8,
     "one" => 49_u8,
     "ordfeminine" => 187_u8,
     "ordmasculine" => 188_u8,
     "oslash" => 191_u8,
     "otilde" => 155_u8,
     "p" => 112_u8,
     "paragraph" => 166_u8,
     "parenleft" => 40_u8,
     "parenright" => 41_u8,
     "percent" => 37_u8,
     "period" => 46_u8,
     "periodcentered" => 225_u8,
     "perthousand" => 228_u8,
     "plus" => 43_u8,
     "plusminus" => 177_u8,
     "q" => 113_u8,
     "question" => 63_u8,
     "questiondown" => 192_u8,
     "quotedbl" => 34_u8,
     "quotedblbase" => 227_u8,
     "quotedblleft" => 210_u8,
     "quotedblright" => 211_u8,
     "quoteleft" => 212_u8,
     "quoteright" => 213_u8,
     "quotesinglbase" => 226_u8,
     "quotesingle" => 39_u8,
     "r" => 114_u8,
     "registered" => 168_u8,
     "ring" => 251_u8,
     "s" => 115_u8,
     "section" => 164_u8,
     "semicolon" => 59_u8,
     "seven" => 55_u8,
     "six" => 54_u8,
     "slash" => 47_u8,
     "space" => 32_u8,
     "sterling" => 163_u8,
     "t" => 116_u8,
     "three" => 51_u8,
     "tilde" => 247_u8,
     "trademark" => 170_u8,
     "two" => 50_u8,
     "u" => 117_u8,
     "uacute" => 156_u8,
     "ucircumflex" => 158_u8,
     "udieresis" => 159_u8,
     "ugrave" => 157_u8,
     "underscore" => 95_u8,
     "v" => 118_u8,
     "w" => 119_u8,
     "x" => 120_u8,
     "y" => 121_u8,
     "ydieresis" => 216_u8,
     "yen" => 180_u8,
     "z" => 122_u8,
     "zero" => 48_u8,
     "nbspace" => 202_u8,
};
