use phf::phf_map;

pub(crate) fn get(code: u8) -> Option<&'static str> {
    SYMBOL.get(&code).copied()
}

static SYMBOL: phf::Map<u8, &'static str> = phf_map! {
    32_u8 => "space",
    33_u8 => "exclam",
    34_u8 => "universal",
    35_u8 => "numbersign",
    36_u8 => "existential",
    37_u8 => "percent",
    38_u8 => "ampersand",
    39_u8 => "suchthat",
    40_u8 => "parenleft",
    41_u8 => "parenright",
    42_u8 => "asteriskmath",
    43_u8 => "plus",
    44_u8 => "comma",
    45_u8 => "minus",
    46_u8 => "period",
    47_u8 => "slash",
    48_u8 => "zero",
    49_u8 => "one",
    50_u8 => "two",
    51_u8 => "three",
    52_u8 => "four",
    53_u8 => "five",
    54_u8 => "six",
    55_u8 => "seven",
    56_u8 => "eight",
    57_u8 => "nine",
    58_u8 => "colon",
    59_u8 => "semicolon",
    60_u8 => "less",
    61_u8 => "equal",
    62_u8 => "greater",
    63_u8 => "question",
    64_u8 => "congruent",
    65_u8 => "Alpha",
    66_u8 => "Beta",
    67_u8 => "Chi",
    68_u8 => "Delta",
    69_u8 => "Epsilon",
    70_u8 => "Phi",
    71_u8 => "Gamma",
    72_u8 => "Eta",
    73_u8 => "Iota",
    74_u8 => "theta1",
    75_u8 => "Kappa",
    76_u8 => "Lambda",
    77_u8 => "Mu",
    78_u8 => "Nu",
    79_u8 => "Omicron",
    80_u8 => "Pi",
    81_u8 => "Theta",
    82_u8 => "Rho",
    83_u8 => "Sigma",
    84_u8 => "Tau",
    85_u8 => "Upsilon",
    86_u8 => "sigma1",
    87_u8 => "Omega",
    88_u8 => "Xi",
    89_u8 => "Psi",
    90_u8 => "Zeta",
    91_u8 => "bracketleft",
    92_u8 => "therefore",
    93_u8 => "bracketright",
    94_u8 => "perpendicular",
    95_u8 => "underscore",
    96_u8 => "radicalex",
    97_u8 => "alpha",
    98_u8 => "beta",
    99_u8 => "chi",
    100_u8 => "delta",
    101_u8 => "epsilon",
    102_u8 => "phi",
    103_u8 => "gamma",
    104_u8 => "eta",
    105_u8 => "iota",
    106_u8 => "phi1",
    107_u8 => "kappa",
    108_u8 => "lambda",
    109_u8 => "mu",
    110_u8 => "nu",
    111_u8 => "omicron",
    112_u8 => "pi",
    113_u8 => "theta",
    114_u8 => "rho",
    115_u8 => "sigma",
    116_u8 => "tau",
    117_u8 => "upsilon",
    118_u8 => "omega1",
    119_u8 => "omega",
    120_u8 => "xi",
    121_u8 => "psi",
    122_u8 => "zeta",
    123_u8 => "braceleft",
    124_u8 => "bar",
    125_u8 => "braceright",
    126_u8 => "similar",
    160_u8 => "Euro",
    161_u8 => "Upsilon1",
    162_u8 => "minute",
    163_u8 => "lessequal",
    164_u8 => "fraction",
    165_u8 => "infinity",
    166_u8 => "florin",
    167_u8 => "club",
    168_u8 => "diamond",
    169_u8 => "heart",
    170_u8 => "spade",
    171_u8 => "arrowboth",
    172_u8 => "arrowleft",
    173_u8 => "arrowup",
    174_u8 => "arrowright",
    175_u8 => "arrowdown",
    176_u8 => "degree",
    177_u8 => "plusminus",
    178_u8 => "second",
    179_u8 => "greaterequal",
    180_u8 => "multiply",
    181_u8 => "proportional",
    182_u8 => "partialdiff",
    183_u8 => "bullet",
    184_u8 => "divide",
    185_u8 => "notequal",
    186_u8 => "equivalence",
    187_u8 => "approxequal",
    188_u8 => "ellipsis",
    189_u8 => "arrowvertex",
    190_u8 => "arrowhorizex",
    191_u8 => "carriagereturn",
    192_u8 => "aleph",
    193_u8 => "Ifraktur",
    194_u8 => "Rfraktur",
    195_u8 => "weierstrass",
    196_u8 => "circlemultiply",
    197_u8 => "circleplus",
    198_u8 => "emptyset",
    199_u8 => "intersection",
    200_u8 => "union",
    201_u8 => "propersuperset",
    202_u8 => "reflexsuperset",
    203_u8 => "notsubset",
    204_u8 => "propersubset",
    205_u8 => "reflexsubset",
    206_u8 => "element",
    207_u8 => "notelement",
    208_u8 => "angle",
    209_u8 => "gradient",
    210_u8 => "registerserif",
    211_u8 => "copyrightserif",
    212_u8 => "trademarkserif",
    213_u8 => "product",
    214_u8 => "radical",
    215_u8 => "dotmath",
    216_u8 => "logicalnot",
    217_u8 => "logicaland",
    218_u8 => "logicalor",
    219_u8 => "arrowdblboth",
    220_u8 => "arrowdblleft",
    221_u8 => "arrowdblup",
    222_u8 => "arrowdblright",
    223_u8 => "arrowdbldown",
    224_u8 => "lozenge",
    225_u8 => "angleleft",
    226_u8 => "registersans",
    227_u8 => "copyrightsans",
    228_u8 => "trademarksans",
    229_u8 => "summation",
    230_u8 => "parenlefttp",
    231_u8 => "parenleftex",
    232_u8 => "parenleftbt",
    233_u8 => "bracketlefttp",
    234_u8 => "bracketleftex",
    235_u8 => "bracketleftbt",
    236_u8 => "bracelefttp",
    237_u8 => "braceleftmid",
    238_u8 => "braceleftbt",
    239_u8 => "braceex",
    241_u8 => "angleright",
    242_u8 => "integral",
    243_u8 => "integraltp",
    244_u8 => "integralex",
    245_u8 => "integralbt",
    246_u8 => "parenrighttp",
    247_u8 => "parenrightex",
    248_u8 => "parenrightbt",
    249_u8 => "bracketrighttp",
    250_u8 => "bracketrightex",
    251_u8 => "bracketrightbt",
    252_u8 => "bracerighttp",
    253_u8 => "bracerightmid",
    254_u8 => "bracerightbt",
};
