// See <https://github.com/apache/pdfbox/blob/4438b8fdc67a3a9ebfb194595d0e81f88b708a37/pdfbox/src/main/java/org/apache/pdfbox/pdmodel/font/encoding/WinAnsiEncoding.java>
use phf::phf_map;

pub(crate) fn get(code: u8) -> Option<&'static str> {
    WIN_ANSI
        .get(&code)
        .or(if code > 40 { Some(&"bullet") } else { None })
        .copied()
}

static WIN_ANSI: phf::Map<u8, &'static str> = phf_map! {
        65_u8 => "A",
    198_u8 => "AE",
    193_u8 => "Aacute",
    194_u8 => "Acircumflex",
    196_u8 => "Adieresis",
    192_u8 => "Agrave",
    197_u8 => "Aring",
    195_u8 => "Atilde",
    66_u8 => "B",
    67_u8 => "C",
    199_u8 => "Ccedilla",
    68_u8 => "D",
    69_u8 => "E",
    201_u8 => "Eacute",
    202_u8 => "Ecircumflex",
    203_u8 => "Edieresis",
    200_u8 => "Egrave",
    208_u8 => "Eth",
    128_u8 => "Euro",
    70_u8 => "F",
    71_u8 => "G",
    72_u8 => "H",
    73_u8 => "I",
    205_u8 => "Iacute",
    206_u8 => "Icircumflex",
    207_u8 => "Idieresis",
    204_u8 => "Igrave",
    74_u8 => "J",
    75_u8 => "K",
    76_u8 => "L",
    77_u8 => "M",
    78_u8 => "N",
    209_u8 => "Ntilde",
    79_u8 => "O",
    140_u8 => "OE",
    211_u8 => "Oacute",
    212_u8 => "Ocircumflex",
    214_u8 => "Odieresis",
    210_u8 => "Ograve",
    216_u8 => "Oslash",
    213_u8 => "Otilde",
    80_u8 => "P",
    81_u8 => "Q",
    82_u8 => "R",
    83_u8 => "S",
    138_u8 => "Scaron",
    84_u8 => "T",
    222_u8 => "Thorn",
    85_u8 => "U",
    218_u8 => "Uacute",
    219_u8 => "Ucircumflex",
    220_u8 => "Udieresis",
    217_u8 => "Ugrave",
    86_u8 => "V",
    87_u8 => "W",
    88_u8 => "X",
    89_u8 => "Y",
    221_u8 => "Yacute",
    159_u8 => "Ydieresis",
    90_u8 => "Z",
    142_u8 => "Zcaron",
    97_u8 => "a",
    225_u8 => "aacute",
    226_u8 => "acircumflex",
    180_u8 => "acute",
    228_u8 => "adieresis",
    230_u8 => "ae",
    224_u8 => "agrave",
    38_u8 => "ampersand",
    229_u8 => "aring",
    94_u8 => "asciicircum",
    126_u8 => "asciitilde",
    42_u8 => "asterisk",
    64_u8 => "at",
    227_u8 => "atilde",
    98_u8 => "b",
    92_u8 => "backslash",
    124_u8 => "bar",
    123_u8 => "braceleft",
    125_u8 => "braceright",
    91_u8 => "bracketleft",
    93_u8 => "bracketright",
    166_u8 => "brokenbar",
    149_u8 => "bullet",
    99_u8 => "c",
    231_u8 => "ccedilla",
    184_u8 => "cedilla",
    162_u8 => "cent",
    136_u8 => "circumflex",
    58_u8 => "colon",
    44_u8 => "comma",
    169_u8 => "copyright",
    164_u8 => "currency",
    100_u8 => "d",
    134_u8 => "dagger",
    135_u8 => "daggerdbl",
    176_u8 => "degree",
    168_u8 => "dieresis",
    247_u8 => "divide",
    36_u8 => "dollar",
    101_u8 => "e",
    233_u8 => "eacute",
    234_u8 => "ecircumflex",
    235_u8 => "edieresis",
    232_u8 => "egrave",
    56_u8 => "eight",
    133_u8 => "ellipsis",
    151_u8 => "emdash",
    150_u8 => "endash",
    61_u8 => "equal",
    240_u8 => "eth",
    33_u8 => "exclam",
    161_u8 => "exclamdown",
    102_u8 => "f",
    53_u8 => "five",
    131_u8 => "florin",
    52_u8 => "four",
    103_u8 => "g",
    223_u8 => "germandbls",
    96_u8 => "grave",
    62_u8 => "greater",
    171_u8 => "guillemotleft",
    187_u8 => "guillemotright",
    139_u8 => "guilsinglleft",
    155_u8 => "guilsinglright",
    104_u8 => "h",
    45_u8 => "hyphen",
    105_u8 => "i",
    237_u8 => "iacute",
    238_u8 => "icircumflex",
    239_u8 => "idieresis",
    236_u8 => "igrave",
    106_u8 => "j",
    107_u8 => "k",
    108_u8 => "l",
    60_u8 => "less",
    172_u8 => "logicalnot",
    109_u8 => "m",
    175_u8 => "macron",
    181_u8 => "mu",
    215_u8 => "multiply",
    110_u8 => "n",
    57_u8 => "nine",
    241_u8 => "ntilde",
    35_u8 => "numbersign",
    111_u8 => "o",
    243_u8 => "oacute",
    244_u8 => "ocircumflex",
    246_u8 => "odieresis",
    156_u8 => "oe",
    242_u8 => "ograve",
    49_u8 => "one",
    189_u8 => "onehalf",
    188_u8 => "onequarter",
    185_u8 => "onesuperior",
    170_u8 => "ordfeminine",
    186_u8 => "ordmasculine",
    248_u8 => "oslash",
    245_u8 => "otilde",
    112_u8 => "p",
    182_u8 => "paragraph",
    40_u8 => "parenleft",
    41_u8 => "parenright",
    37_u8 => "percent",
    46_u8 => "period",
    183_u8 => "periodcentered",
    137_u8 => "perthousand",
    43_u8 => "plus",
    177_u8 => "plusminus",
    113_u8 => "q",
    63_u8 => "question",
    191_u8 => "questiondown",
    34_u8 => "quotedbl",
    132_u8 => "quotedblbase",
    147_u8 => "quotedblleft",
    148_u8 => "quotedblright",
    145_u8 => "quoteleft",
    146_u8 => "quoteright",
    130_u8 => "quotesinglbase",
    39_u8 => "quotesingle",
    114_u8 => "r",
    174_u8 => "registered",
    115_u8 => "s",
    154_u8 => "scaron",
    167_u8 => "section",
    59_u8 => "semicolon",
    55_u8 => "seven",
    54_u8 => "six",
    47_u8 => "slash",
    32_u8 => "space",
    163_u8 => "sterling",
    116_u8 => "t",
    254_u8 => "thorn",
    51_u8 => "three",
    190_u8 => "threequarters",
    179_u8 => "threesuperior",
    152_u8 => "tilde",
    153_u8 => "trademark",
    50_u8 => "two",
    178_u8 => "twosuperior",
    117_u8 => "u",
    250_u8 => "uacute",
    251_u8 => "ucircumflex",
    252_u8 => "udieresis",
    249_u8 => "ugrave",
    95_u8 => "underscore",
    118_u8 => "v",
    119_u8 => "w",
    120_u8 => "x",
    121_u8 => "y",
    253_u8 => "yacute",
    255_u8 => "ydieresis",
    165_u8 => "yen",
    122_u8 => "z",
    158_u8 => "zcaron",
    48_u8 => "zero",
    160_u8 => "nbspace",
    173_u8 => "sfthyphen",
};
