use phf::phf_map;

pub(crate) fn get(name: &str) -> Option<&'static str> {
    GLYPH_NAMES.get(name).copied()
}

static GLYPH_NAMES: phf::Map<&'static str, &'static str> = phf_map! {
    "A" => "\u{0041}",
    "AE" => "\u{00C6}",
    "AEacute" => "\u{01FC}",
    "AEmacron" => "\u{01E2}",
    "AEsmall" => "\u{F7E6}",
    "Aacute" => "\u{00C1}",
    "Aacutesmall" => "\u{F7E1}",
    "Abreve" => "\u{0102}",
    "Abreveacute" => "\u{1EAE}",
    "Abrevecyrillic" => "\u{04D0}",
    "Abrevedotbelow" => "\u{1EB6}",
    "Abrevegrave" => "\u{1EB0}",
    "Abrevehookabove" => "\u{1EB2}",
    "Abrevetilde" => "\u{1EB4}",
    "Acaron" => "\u{01CD}",
    "Acircle" => "\u{24B6}",
    "Acircumflex" => "\u{00C2}",
    "Acircumflexacute" => "\u{1EA4}",
    "Acircumflexdotbelow" => "\u{1EAC}",
    "Acircumflexgrave" => "\u{1EA6}",
    "Acircumflexhookabove" => "\u{1EA8}",
    "Acircumflexsmall" => "\u{F7E2}",
    "Acircumflextilde" => "\u{1EAA}",
    "Acute" => "\u{F6C9}",
    "Acutesmall" => "\u{F7B4}",
    "Acyrillic" => "\u{0410}",
    "Adblgrave" => "\u{0200}",
    "Adieresis" => "\u{00C4}",
    "Adieresiscyrillic" => "\u{04D2}",
    "Adieresismacron" => "\u{01DE}",
    "Adieresissmall" => "\u{F7E4}",
    "Adotbelow" => "\u{1EA0}",
    "Adotmacron" => "\u{01E0}",
    "Agrave" => "\u{00C0}",
    "Agravesmall" => "\u{F7E0}",
    "Ahookabove" => "\u{1EA2}",
    "Aiecyrillic" => "\u{04D4}",
    "Ainvertedbreve" => "\u{0202}",
    "Alpha" => "\u{0391}",
    "Alphatonos" => "\u{0386}",
    "Amacron" => "\u{0100}",
    "Amonospace" => "\u{FF21}",
    "Aogonek" => "\u{0104}",
    "Aring" => "\u{00C5}",
    "Aringacute" => "\u{01FA}",
    "Aringbelow" => "\u{1E00}",
    "Aringsmall" => "\u{F7E5}",
    "Asmall" => "\u{F761}",
    "Atilde" => "\u{00C3}",
    "Atildesmall" => "\u{F7E3}",
    "Aybarmenian" => "\u{0531}",
    "B" => "\u{0042}",
    "Bcircle" => "\u{24B7}",
    "Bdotaccent" => "\u{1E02}",
    "Bdotbelow" => "\u{1E04}",
    "Becyrillic" => "\u{0411}",
    "Benarmenian" => "\u{0532}",
    "Beta" => "\u{0392}",
    "Bhook" => "\u{0181}",
    "Blinebelow" => "\u{1E06}",
    "Bmonospace" => "\u{FF22}",
    "Brevesmall" => "\u{F6F4}",
    "Bsmall" => "\u{F762}",
    "Btopbar" => "\u{0182}",
    "C" => "\u{0043}",
    "Caarmenian" => "\u{053E}",
    "Cacute" => "\u{0106}",
    "Caron" => "\u{F6CA}",
    "Caronsmall" => "\u{F6F5}",
    "Ccaron" => "\u{010C}",
    "Ccedilla" => "\u{00C7}",
    "Ccedillaacute" => "\u{1E08}",
    "Ccedillasmall" => "\u{F7E7}",
    "Ccircle" => "\u{24B8}",
    "Ccircumflex" => "\u{0108}",
    "Cdot" => "\u{010A}",
    "Cdotaccent" => "\u{010A}",
    "Cedillasmall" => "\u{F7B8}",
    "Chaarmenian" => "\u{0549}",
    "Cheabkhasiancyrillic" => "\u{04BC}",
    "Checyrillic" => "\u{0427}",
    "Chedescenderabkhasiancyrillic" => "\u{04BE}",
    "Chedescendercyrillic" => "\u{04B6}",
    "Chedieresiscyrillic" => "\u{04F4}",
    "Cheharmenian" => "\u{0543}",
    "Chekhakassiancyrillic" => "\u{04CB}",
    "Cheverticalstrokecyrillic" => "\u{04B8}",
    "Chi" => "\u{03A7}",
    "Chook" => "\u{0187}",
    "Circumflexsmall" => "\u{F6F6}",
    "Cmonospace" => "\u{FF23}",
    "Coarmenian" => "\u{0551}",
    "Csmall" => "\u{F763}",
    "D" => "\u{0044}",
    "DZ" => "\u{01F1}",
    "DZcaron" => "\u{01C4}",
    "Daarmenian" => "\u{0534}",
    "Dafrican" => "\u{0189}",
    "Dcaron" => "\u{010E}",
    "Dcedilla" => "\u{1E10}",
    "Dcircle" => "\u{24B9}",
    "Dcircumflexbelow" => "\u{1E12}",
    "Dcroat" => "\u{0110}",
    "Ddotaccent" => "\u{1E0A}",
    "Ddotbelow" => "\u{1E0C}",
    "Decyrillic" => "\u{0414}",
    "Deicoptic" => "\u{03EE}",
    "Delta" => "\u{2206}",
    "Deltagreek" => "\u{0394}",
    "Dhook" => "\u{018A}",
    "Dieresis" => "\u{F6CB}",
    "DieresisAcute" => "\u{F6CC}",
    "DieresisGrave" => "\u{F6CD}",
    "Dieresissmall" => "\u{F7A8}",
    "Digammagreek" => "\u{03DC}",
    "Djecyrillic" => "\u{0402}",
    "Dlinebelow" => "\u{1E0E}",
    "Dmonospace" => "\u{FF24}",
    "Dotaccentsmall" => "\u{F6F7}",
    "Dslash" => "\u{0110}",
    "Dsmall" => "\u{F764}",
    "Dtopbar" => "\u{018B}",
    "Dz" => "\u{01F2}",
    "Dzcaron" => "\u{01C5}",
    "Dzeabkhasiancyrillic" => "\u{04E0}",
    "Dzecyrillic" => "\u{0405}",
    "Dzhecyrillic" => "\u{040F}",
    "E" => "\u{0045}",
    "Eacute" => "\u{00C9}",
    "Eacutesmall" => "\u{F7E9}",
    "Ebreve" => "\u{0114}",
    "Ecaron" => "\u{011A}",
    "Ecedillabreve" => "\u{1E1C}",
    "Echarmenian" => "\u{0535}",
    "Ecircle" => "\u{24BA}",
    "Ecircumflex" => "\u{00CA}",
    "Ecircumflexacute" => "\u{1EBE}",
    "Ecircumflexbelow" => "\u{1E18}",
    "Ecircumflexdotbelow" => "\u{1EC6}",
    "Ecircumflexgrave" => "\u{1EC0}",
    "Ecircumflexhookabove" => "\u{1EC2}",
    "Ecircumflexsmall" => "\u{F7EA}",
    "Ecircumflextilde" => "\u{1EC4}",
    "Ecyrillic" => "\u{0404}",
    "Edblgrave" => "\u{0204}",
    "Edieresis" => "\u{00CB}",
    "Edieresissmall" => "\u{F7EB}",
    "Edot" => "\u{0116}",
    "Edotaccent" => "\u{0116}",
    "Edotbelow" => "\u{1EB8}",
    "Efcyrillic" => "\u{0424}",
    "Egrave" => "\u{00C8}",
    "Egravesmall" => "\u{F7E8}",
    "Eharmenian" => "\u{0537}",
    "Ehookabove" => "\u{1EBA}",
    "Eightroman" => "\u{2167}",
    "Einvertedbreve" => "\u{0206}",
    "Eiotifiedcyrillic" => "\u{0464}",
    "Elcyrillic" => "\u{041B}",
    "Elevenroman" => "\u{216A}",
    "Emacron" => "\u{0112}",
    "Emacronacute" => "\u{1E16}",
    "Emacrongrave" => "\u{1E14}",
    "Emcyrillic" => "\u{041C}",
    "Emonospace" => "\u{FF25}",
    "Encyrillic" => "\u{041D}",
    "Endescendercyrillic" => "\u{04A2}",
    "Eng" => "\u{014A}",
    "Enghecyrillic" => "\u{04A4}",
    "Enhookcyrillic" => "\u{04C7}",
    "Eogonek" => "\u{0118}",
    "Eopen" => "\u{0190}",
    "Epsilon" => "\u{0395}",
    "Epsilontonos" => "\u{0388}",
    "Ercyrillic" => "\u{0420}",
    "Ereversed" => "\u{018E}",
    "Ereversedcyrillic" => "\u{042D}",
    "Escyrillic" => "\u{0421}",
    "Esdescendercyrillic" => "\u{04AA}",
    "Esh" => "\u{01A9}",
    "Esmall" => "\u{F765}",
    "Eta" => "\u{0397}",
    "Etarmenian" => "\u{0538}",
    "Etatonos" => "\u{0389}",
    "Eth" => "\u{00D0}",
    "Ethsmall" => "\u{F7F0}",
    "Etilde" => "\u{1EBC}",
    "Etildebelow" => "\u{1E1A}",
    "Euro" => "\u{20AC}",
    "Ezh" => "\u{01B7}",
    "Ezhcaron" => "\u{01EE}",
    "Ezhreversed" => "\u{01B8}",
    "F" => "\u{0046}",
    "Fcircle" => "\u{24BB}",
    "Fdotaccent" => "\u{1E1E}",
    "Feharmenian" => "\u{0556}",
    "Feicoptic" => "\u{03E4}",
    "Fhook" => "\u{0191}",
    "Fitacyrillic" => "\u{0472}",
    "Fiveroman" => "\u{2164}",
    "Fmonospace" => "\u{FF26}",
    "Fourroman" => "\u{2163}",
    "Fsmall" => "\u{F766}",
    "G" => "\u{0047}",
    "GBsquare" => "\u{3387}",
    "Gacute" => "\u{01F4}",
    "Gamma" => "\u{0393}",
    "Gammaafrican" => "\u{0194}",
    "Gangiacoptic" => "\u{03EA}",
    "Gbreve" => "\u{011E}",
    "Gcaron" => "\u{01E6}",
    "Gcedilla" => "\u{0122}",
    "Gcircle" => "\u{24BC}",
    "Gcircumflex" => "\u{011C}",
    "Gcommaaccent" => "\u{0122}",
    "Gdot" => "\u{0120}",
    "Gdotaccent" => "\u{0120}",
    "Gecyrillic" => "\u{0413}",
    "Ghadarmenian" => "\u{0542}",
    "Ghemiddlehookcyrillic" => "\u{0494}",
    "Ghestrokecyrillic" => "\u{0492}",
    "Gheupturncyrillic" => "\u{0490}",
    "Ghook" => "\u{0193}",
    "Gimarmenian" => "\u{0533}",
    "Gjecyrillic" => "\u{0403}",
    "Gmacron" => "\u{1E20}",
    "Gmonospace" => "\u{FF27}",
    "Grave" => "\u{F6CE}",
    "Gravesmall" => "\u{F760}",
    "Gsmall" => "\u{F767}",
    "Gsmallhook" => "\u{029B}",
    "Gstroke" => "\u{01E4}",
    "H" => "\u{0048}",
    "H18533" => "\u{25CF}",
    "H18543" => "\u{25AA}",
    "H18551" => "\u{25AB}",
    "H22073" => "\u{25A1}",
    "HPsquare" => "\u{33CB}",
    "Haabkhasiancyrillic" => "\u{04A8}",
    "Hadescendercyrillic" => "\u{04B2}",
    "Hardsigncyrillic" => "\u{042A}",
    "Hbar" => "\u{0126}",
    "Hbrevebelow" => "\u{1E2A}",
    "Hcedilla" => "\u{1E28}",
    "Hcircle" => "\u{24BD}",
    "Hcircumflex" => "\u{0124}",
    "Hdieresis" => "\u{1E26}",
    "Hdotaccent" => "\u{1E22}",
    "Hdotbelow" => "\u{1E24}",
    "Hmonospace" => "\u{FF28}",
    "Hoarmenian" => "\u{0540}",
    "Horicoptic" => "\u{03E8}",
    "Hsmall" => "\u{F768}",
    "Hungarumlaut" => "\u{F6CF}",
    "Hungarumlautsmall" => "\u{F6F8}",
    "Hzsquare" => "\u{3390}",
    "I" => "\u{0049}",
    "IAcyrillic" => "\u{042F}",
    "IJ" => "\u{0132}",
    "IUcyrillic" => "\u{042E}",
    "Iacute" => "\u{00CD}",
    "Iacutesmall" => "\u{F7ED}",
    "Ibreve" => "\u{012C}",
    "Icaron" => "\u{01CF}",
    "Icircle" => "\u{24BE}",
    "Icircumflex" => "\u{00CE}",
    "Icircumflexsmall" => "\u{F7EE}",
    "Icyrillic" => "\u{0406}",
    "Idblgrave" => "\u{0208}",
    "Idieresis" => "\u{00CF}",
    "Idieresisacute" => "\u{1E2E}",
    "Idieresiscyrillic" => "\u{04E4}",
    "Idieresissmall" => "\u{F7EF}",
    "Idot" => "\u{0130}",
    "Idotaccent" => "\u{0130}",
    "Idotbelow" => "\u{1ECA}",
    "Iebrevecyrillic" => "\u{04D6}",
    "Iecyrillic" => "\u{0415}",
    "Ifraktur" => "\u{2111}",
    "Igrave" => "\u{00CC}",
    "Igravesmall" => "\u{F7EC}",
    "Ihookabove" => "\u{1EC8}",
    "Iicyrillic" => "\u{0418}",
    "Iinvertedbreve" => "\u{020A}",
    "Iishortcyrillic" => "\u{0419}",
    "Imacron" => "\u{012A}",
    "Imacroncyrillic" => "\u{04E2}",
    "Imonospace" => "\u{FF29}",
    "Iniarmenian" => "\u{053B}",
    "Iocyrillic" => "\u{0401}",
    "Iogonek" => "\u{012E}",
    "Iota" => "\u{0399}",
    "Iotaafrican" => "\u{0196}",
    "Iotadieresis" => "\u{03AA}",
    "Iotatonos" => "\u{038A}",
    "Ismall" => "\u{F769}",
    "Istroke" => "\u{0197}",
    "Itilde" => "\u{0128}",
    "Itildebelow" => "\u{1E2C}",
    "Izhitsacyrillic" => "\u{0474}",
    "Izhitsadblgravecyrillic" => "\u{0476}",
    "J" => "\u{004A}",
    "Jaarmenian" => "\u{0541}",
    "Jcircle" => "\u{24BF}",
    "Jcircumflex" => "\u{0134}",
    "Jecyrillic" => "\u{0408}",
    "Jheharmenian" => "\u{054B}",
    "Jmonospace" => "\u{FF2A}",
    "Jsmall" => "\u{F76A}",
    "K" => "\u{004B}",
    "KBsquare" => "\u{3385}",
    "KKsquare" => "\u{33CD}",
    "Kabashkircyrillic" => "\u{04A0}",
    "Kacute" => "\u{1E30}",
    "Kacyrillic" => "\u{041A}",
    "Kadescendercyrillic" => "\u{049A}",
    "Kahookcyrillic" => "\u{04C3}",
    "Kappa" => "\u{039A}",
    "Kastrokecyrillic" => "\u{049E}",
    "Kaverticalstrokecyrillic" => "\u{049C}",
    "Kcaron" => "\u{01E8}",
    "Kcedilla" => "\u{0136}",
    "Kcircle" => "\u{24C0}",
    "Kcommaaccent" => "\u{0136}",
    "Kdotbelow" => "\u{1E32}",
    "Keharmenian" => "\u{0554}",
    "Kenarmenian" => "\u{053F}",
    "Khacyrillic" => "\u{0425}",
    "Kheicoptic" => "\u{03E6}",
    "Khook" => "\u{0198}",
    "Kjecyrillic" => "\u{040C}",
    "Klinebelow" => "\u{1E34}",
    "Kmonospace" => "\u{FF2B}",
    "Koppacyrillic" => "\u{0480}",
    "Koppagreek" => "\u{03DE}",
    "Ksicyrillic" => "\u{046E}",
    "Ksmall" => "\u{F76B}",
    "L" => "\u{004C}",
    "LJ" => "\u{01C7}",
    "LL" => "\u{F6BF}",
    "Lacute" => "\u{0139}",
    "Lambda" => "\u{039B}",
    "Lcaron" => "\u{013D}",
    "Lcedilla" => "\u{013B}",
    "Lcircle" => "\u{24C1}",
    "Lcircumflexbelow" => "\u{1E3C}",
    "Lcommaaccent" => "\u{013B}",
    "Ldot" => "\u{013F}",
    "Ldotaccent" => "\u{013F}",
    "Ldotbelow" => "\u{1E36}",
    "Ldotbelowmacron" => "\u{1E38}",
    "Liwnarmenian" => "\u{053C}",
    "Lj" => "\u{01C8}",
    "Ljecyrillic" => "\u{0409}",
    "Llinebelow" => "\u{1E3A}",
    "Lmonospace" => "\u{FF2C}",
    "Lslash" => "\u{0141}",
    "Lslashsmall" => "\u{F6F9}",
    "Lsmall" => "\u{F76C}",
    "M" => "\u{004D}",
    "MBsquare" => "\u{3386}",
    "Macron" => "\u{F6D0}",
    "Macronsmall" => "\u{F7AF}",
    "Macute" => "\u{1E3E}",
    "Mcircle" => "\u{24C2}",
    "Mdotaccent" => "\u{1E40}",
    "Mdotbelow" => "\u{1E42}",
    "Menarmenian" => "\u{0544}",
    "Mmonospace" => "\u{FF2D}",
    "Msmall" => "\u{F76D}",
    "Mturned" => "\u{019C}",
    "Mu" => "\u{039C}",
    "N" => "\u{004E}",
    "NJ" => "\u{01CA}",
    "Nacute" => "\u{0143}",
    "Ncaron" => "\u{0147}",
    "Ncedilla" => "\u{0145}",
    "Ncircle" => "\u{24C3}",
    "Ncircumflexbelow" => "\u{1E4A}",
    "Ncommaaccent" => "\u{0145}",
    "Ndotaccent" => "\u{1E44}",
    "Ndotbelow" => "\u{1E46}",
    "Nhookleft" => "\u{019D}",
    "Nineroman" => "\u{2168}",
    "Nj" => "\u{01CB}",
    "Njecyrillic" => "\u{040A}",
    "Nlinebelow" => "\u{1E48}",
    "Nmonospace" => "\u{FF2E}",
    "Nowarmenian" => "\u{0546}",
    "Nsmall" => "\u{F76E}",
    "Ntilde" => "\u{00D1}",
    "Ntildesmall" => "\u{F7F1}",
    "Nu" => "\u{039D}",
    "O" => "\u{004F}",
    "OE" => "\u{0152}",
    "OEsmall" => "\u{F6FA}",
    "Oacute" => "\u{00D3}",
    "Oacutesmall" => "\u{F7F3}",
    "Obarredcyrillic" => "\u{04E8}",
    "Obarreddieresiscyrillic" => "\u{04EA}",
    "Obreve" => "\u{014E}",
    "Ocaron" => "\u{01D1}",
    "Ocenteredtilde" => "\u{019F}",
    "Ocircle" => "\u{24C4}",
    "Ocircumflex" => "\u{00D4}",
    "Ocircumflexacute" => "\u{1ED0}",
    "Ocircumflexdotbelow" => "\u{1ED8}",
    "Ocircumflexgrave" => "\u{1ED2}",
    "Ocircumflexhookabove" => "\u{1ED4}",
    "Ocircumflexsmall" => "\u{F7F4}",
    "Ocircumflextilde" => "\u{1ED6}",
    "Ocyrillic" => "\u{041E}",
    "Odblacute" => "\u{0150}",
    "Odblgrave" => "\u{020C}",
    "Odieresis" => "\u{00D6}",
    "Odieresiscyrillic" => "\u{04E6}",
    "Odieresissmall" => "\u{F7F6}",
    "Odotbelow" => "\u{1ECC}",
    "Ogoneksmall" => "\u{F6FB}",
    "Ograve" => "\u{00D2}",
    "Ogravesmall" => "\u{F7F2}",
    "Oharmenian" => "\u{0555}",
    "Ohm" => "\u{2126}",
    "Ohookabove" => "\u{1ECE}",
    "Ohorn" => "\u{01A0}",
    "Ohornacute" => "\u{1EDA}",
    "Ohorndotbelow" => "\u{1EE2}",
    "Ohorngrave" => "\u{1EDC}",
    "Ohornhookabove" => "\u{1EDE}",
    "Ohorntilde" => "\u{1EE0}",
    "Ohungarumlaut" => "\u{0150}",
    "Oi" => "\u{01A2}",
    "Oinvertedbreve" => "\u{020E}",
    "Omacron" => "\u{014C}",
    "Omacronacute" => "\u{1E52}",
    "Omacrongrave" => "\u{1E50}",
    "Omega" => "\u{2126}",
    "Omegacyrillic" => "\u{0460}",
    "Omegagreek" => "\u{03A9}",
    "Omegaroundcyrillic" => "\u{047A}",
    "Omegatitlocyrillic" => "\u{047C}",
    "Omegatonos" => "\u{038F}",
    "Omicron" => "\u{039F}",
    "Omicrontonos" => "\u{038C}",
    "Omonospace" => "\u{FF2F}",
    "Oneroman" => "\u{2160}",
    "Oogonek" => "\u{01EA}",
    "Oogonekmacron" => "\u{01EC}",
    "Oopen" => "\u{0186}",
    "Oslash" => "\u{00D8}",
    "Oslashacute" => "\u{01FE}",
    "Oslashsmall" => "\u{F7F8}",
    "Osmall" => "\u{F76F}",
    "Ostrokeacute" => "\u{01FE}",
    "Otcyrillic" => "\u{047E}",
    "Otilde" => "\u{00D5}",
    "Otildeacute" => "\u{1E4C}",
    "Otildedieresis" => "\u{1E4E}",
    "Otildesmall" => "\u{F7F5}",
    "P" => "\u{0050}",
    "Pacute" => "\u{1E54}",
    "Pcircle" => "\u{24C5}",
    "Pdotaccent" => "\u{1E56}",
    "Pecyrillic" => "\u{041F}",
    "Peharmenian" => "\u{054A}",
    "Pemiddlehookcyrillic" => "\u{04A6}",
    "Phi" => "\u{03A6}",
    "Phook" => "\u{01A4}",
    "Pi" => "\u{03A0}",
    "Piwrarmenian" => "\u{0553}",
    "Pmonospace" => "\u{FF30}",
    "Psi" => "\u{03A8}",
    "Psicyrillic" => "\u{0470}",
    "Psmall" => "\u{F770}",
    "Q" => "\u{0051}",
    "Qcircle" => "\u{24C6}",
    "Qmonospace" => "\u{FF31}",
    "Qsmall" => "\u{F771}",
    "R" => "\u{0052}",
    "Raarmenian" => "\u{054C}",
    "Racute" => "\u{0154}",
    "Rcaron" => "\u{0158}",
    "Rcedilla" => "\u{0156}",
    "Rcircle" => "\u{24C7}",
    "Rcommaaccent" => "\u{0156}",
    "Rdblgrave" => "\u{0210}",
    "Rdotaccent" => "\u{1E58}",
    "Rdotbelow" => "\u{1E5A}",
    "Rdotbelowmacron" => "\u{1E5C}",
    "Reharmenian" => "\u{0550}",
    "Rfraktur" => "\u{211C}",
    "Rho" => "\u{03A1}",
    "Ringsmall" => "\u{F6FC}",
    "Rinvertedbreve" => "\u{0212}",
    "Rlinebelow" => "\u{1E5E}",
    "Rmonospace" => "\u{FF32}",
    "Rsmall" => "\u{F772}",
    "Rsmallinverted" => "\u{0281}",
    "Rsmallinvertedsuperior" => "\u{02B6}",
    "S" => "\u{0053}",
    "SF010000" => "\u{250C}",
    "SF020000" => "\u{2514}",
    "SF030000" => "\u{2510}",
    "SF040000" => "\u{2518}",
    "SF050000" => "\u{253C}",
    "SF060000" => "\u{252C}",
    "SF070000" => "\u{2534}",
    "SF080000" => "\u{251C}",
    "SF090000" => "\u{2524}",
    "SF100000" => "\u{2500}",
    "SF110000" => "\u{2502}",
    "SF190000" => "\u{2561}",
    "SF200000" => "\u{2562}",
    "SF210000" => "\u{2556}",
    "SF220000" => "\u{2555}",
    "SF230000" => "\u{2563}",
    "SF240000" => "\u{2551}",
    "SF250000" => "\u{2557}",
    "SF260000" => "\u{255D}",
    "SF270000" => "\u{255C}",
    "SF280000" => "\u{255B}",
    "SF360000" => "\u{255E}",
    "SF370000" => "\u{255F}",
    "SF380000" => "\u{255A}",
    "SF390000" => "\u{2554}",
    "SF400000" => "\u{2569}",
    "SF410000" => "\u{2566}",
    "SF420000" => "\u{2560}",
    "SF430000" => "\u{2550}",
    "SF440000" => "\u{256C}",
    "SF450000" => "\u{2567}",
    "SF460000" => "\u{2568}",
    "SF470000" => "\u{2564}",
    "SF480000" => "\u{2565}",
    "SF490000" => "\u{2559}",
    "SF500000" => "\u{2558}",
    "SF510000" => "\u{2552}",
    "SF520000" => "\u{2553}",
    "SF530000" => "\u{256B}",
    "SF540000" => "\u{256A}",
    "Sacute" => "\u{015A}",
    "Sacutedotaccent" => "\u{1E64}",
    "Sampigreek" => "\u{03E0}",
    "Scaron" => "\u{0160}",
    "Scarondotaccent" => "\u{1E66}",
    "Scaronsmall" => "\u{F6FD}",
    "Scedilla" => "\u{015E}",
    "Schwa" => "\u{018F}",
    "Schwacyrillic" => "\u{04D8}",
    "Schwadieresiscyrillic" => "\u{04DA}",
    "Scircle" => "\u{24C8}",
    "Scircumflex" => "\u{015C}",
    "Scommaaccent" => "\u{0218}",
    "Sdotaccent" => "\u{1E60}",
    "Sdotbelow" => "\u{1E62}",
    "Sdotbelowdotaccent" => "\u{1E68}",
    "Seharmenian" => "\u{054D}",
    "Sevenroman" => "\u{2166}",
    "Shaarmenian" => "\u{0547}",
    "Shacyrillic" => "\u{0428}",
    "Shchacyrillic" => "\u{0429}",
    "Sheicoptic" => "\u{03E2}",
    "Shhacyrillic" => "\u{04BA}",
    "Shimacoptic" => "\u{03EC}",
    "Sigma" => "\u{03A3}",
    "Sixroman" => "\u{2165}",
    "Smonospace" => "\u{FF33}",
    "Softsigncyrillic" => "\u{042C}",
    "Ssmall" => "\u{F773}",
    "Stigmagreek" => "\u{03DA}",
    "T" => "\u{0054}",
    "Tau" => "\u{03A4}",
    "Tbar" => "\u{0166}",
    "Tcaron" => "\u{0164}",
    "Tcedilla" => "\u{0162}",
    "Tcircle" => "\u{24C9}",
    "Tcircumflexbelow" => "\u{1E70}",
    "Tcommaaccent" => "\u{0162}",
    "Tdotaccent" => "\u{1E6A}",
    "Tdotbelow" => "\u{1E6C}",
    "Tecyrillic" => "\u{0422}",
    "Tedescendercyrillic" => "\u{04AC}",
    "Tenroman" => "\u{2169}",
    "Tetsecyrillic" => "\u{04B4}",
    "Theta" => "\u{0398}",
    "Thook" => "\u{01AC}",
    "Thorn" => "\u{00DE}",
    "Thornsmall" => "\u{F7FE}",
    "Threeroman" => "\u{2162}",
    "Tildesmall" => "\u{F6FE}",
    "Tiwnarmenian" => "\u{054F}",
    "Tlinebelow" => "\u{1E6E}",
    "Tmonospace" => "\u{FF34}",
    "Toarmenian" => "\u{0539}",
    "Tonefive" => "\u{01BC}",
    "Tonesix" => "\u{0184}",
    "Tonetwo" => "\u{01A7}",
    "Tretroflexhook" => "\u{01AE}",
    "Tsecyrillic" => "\u{0426}",
    "Tshecyrillic" => "\u{040B}",
    "Tsmall" => "\u{F774}",
    "Twelveroman" => "\u{216B}",
    "Tworoman" => "\u{2161}",
    "U" => "\u{0055}",
    "Uacute" => "\u{00DA}",
    "Uacutesmall" => "\u{F7FA}",
    "Ubreve" => "\u{016C}",
    "Ucaron" => "\u{01D3}",
    "Ucircle" => "\u{24CA}",
    "Ucircumflex" => "\u{00DB}",
    "Ucircumflexbelow" => "\u{1E76}",
    "Ucircumflexsmall" => "\u{F7FB}",
    "Ucyrillic" => "\u{0423}",
    "Udblacute" => "\u{0170}",
    "Udblgrave" => "\u{0214}",
    "Udieresis" => "\u{00DC}",
    "Udieresisacute" => "\u{01D7}",
    "Udieresisbelow" => "\u{1E72}",
    "Udieresiscaron" => "\u{01D9}",
    "Udieresiscyrillic" => "\u{04F0}",
    "Udieresisgrave" => "\u{01DB}",
    "Udieresismacron" => "\u{01D5}",
    "Udieresissmall" => "\u{F7FC}",
    "Udotbelow" => "\u{1EE4}",
    "Ugrave" => "\u{00D9}",
    "Ugravesmall" => "\u{F7F9}",
    "Uhookabove" => "\u{1EE6}",
    "Uhorn" => "\u{01AF}",
    "Uhornacute" => "\u{1EE8}",
    "Uhorndotbelow" => "\u{1EF0}",
    "Uhorngrave" => "\u{1EEA}",
    "Uhornhookabove" => "\u{1EEC}",
    "Uhorntilde" => "\u{1EEE}",
    "Uhungarumlaut" => "\u{0170}",
    "Uhungarumlautcyrillic" => "\u{04F2}",
    "Uinvertedbreve" => "\u{0216}",
    "Ukcyrillic" => "\u{0478}",
    "Umacron" => "\u{016A}",
    "Umacroncyrillic" => "\u{04EE}",
    "Umacrondieresis" => "\u{1E7A}",
    "Umonospace" => "\u{FF35}",
    "Uogonek" => "\u{0172}",
    "Upsilon" => "\u{03A5}",
    "Upsilon1" => "\u{03D2}",
    "Upsilonacutehooksymbolgreek" => "\u{03D3}",
    "Upsilonafrican" => "\u{01B1}",
    "Upsilondieresis" => "\u{03AB}",
    "Upsilondieresishooksymbolgreek" => "\u{03D4}",
    "Upsilonhooksymbol" => "\u{03D2}",
    "Upsilontonos" => "\u{038E}",
    "Uring" => "\u{016E}",
    "Ushortcyrillic" => "\u{040E}",
    "Usmall" => "\u{F775}",
    "Ustraightcyrillic" => "\u{04AE}",
    "Ustraightstrokecyrillic" => "\u{04B0}",
    "Utilde" => "\u{0168}",
    "Utildeacute" => "\u{1E78}",
    "Utildebelow" => "\u{1E74}",
    "V" => "\u{0056}",
    "Vcircle" => "\u{24CB}",
    "Vdotbelow" => "\u{1E7E}",
    "Vecyrillic" => "\u{0412}",
    "Vewarmenian" => "\u{054E}",
    "Vhook" => "\u{01B2}",
    "Vmonospace" => "\u{FF36}",
    "Voarmenian" => "\u{0548}",
    "Vsmall" => "\u{F776}",
    "Vtilde" => "\u{1E7C}",
    "W" => "\u{0057}",
    "Wacute" => "\u{1E82}",
    "Wcircle" => "\u{24CC}",
    "Wcircumflex" => "\u{0174}",
    "Wdieresis" => "\u{1E84}",
    "Wdotaccent" => "\u{1E86}",
    "Wdotbelow" => "\u{1E88}",
    "Wgrave" => "\u{1E80}",
    "Wmonospace" => "\u{FF37}",
    "Wsmall" => "\u{F777}",
    "X" => "\u{0058}",
    "Xcircle" => "\u{24CD}",
    "Xdieresis" => "\u{1E8C}",
    "Xdotaccent" => "\u{1E8A}",
    "Xeharmenian" => "\u{053D}",
    "Xi" => "\u{039E}",
    "Xmonospace" => "\u{FF38}",
    "Xsmall" => "\u{F778}",
    "Y" => "\u{0059}",
    "Yacute" => "\u{00DD}",
    "Yacutesmall" => "\u{F7FD}",
    "Yatcyrillic" => "\u{0462}",
    "Ycircle" => "\u{24CE}",
    "Ycircumflex" => "\u{0176}",
    "Ydieresis" => "\u{0178}",
    "Ydieresissmall" => "\u{F7FF}",
    "Ydotaccent" => "\u{1E8E}",
    "Ydotbelow" => "\u{1EF4}",
    "Yericyrillic" => "\u{042B}",
    "Yerudieresiscyrillic" => "\u{04F8}",
    "Ygrave" => "\u{1EF2}",
    "Yhook" => "\u{01B3}",
    "Yhookabove" => "\u{1EF6}",
    "Yiarmenian" => "\u{0545}",
    "Yicyrillic" => "\u{0407}",
    "Yiwnarmenian" => "\u{0552}",
    "Ymonospace" => "\u{FF39}",
    "Ysmall" => "\u{F779}",
    "Ytilde" => "\u{1EF8}",
    "Yusbigcyrillic" => "\u{046A}",
    "Yusbigiotifiedcyrillic" => "\u{046C}",
    "Yuslittlecyrillic" => "\u{0466}",
    "Yuslittleiotifiedcyrillic" => "\u{0468}",
    "Z" => "\u{005A}",
    "Zaarmenian" => "\u{0536}",
    "Zacute" => "\u{0179}",
    "Zcaron" => "\u{017D}",
    "Zcaronsmall" => "\u{F6FF}",
    "Zcircle" => "\u{24CF}",
    "Zcircumflex" => "\u{1E90}",
    "Zdot" => "\u{017B}",
    "Zdotaccent" => "\u{017B}",
    "Zdotbelow" => "\u{1E92}",
    "Zecyrillic" => "\u{0417}",
    "Zedescendercyrillic" => "\u{0498}",
    "Zedieresiscyrillic" => "\u{04DE}",
    "Zeta" => "\u{0396}",
    "Zhearmenian" => "\u{053A}",
    "Zhebrevecyrillic" => "\u{04C1}",
    "Zhecyrillic" => "\u{0416}",
    "Zhedescendercyrillic" => "\u{0496}",
    "Zhedieresiscyrillic" => "\u{04DC}",
    "Zlinebelow" => "\u{1E94}",
    "Zmonospace" => "\u{FF3A}",
    "Zsmall" => "\u{F77A}",
    "Zstroke" => "\u{01B5}",
    "a" => "\u{0061}",
    "aabengali" => "\u{0986}",
    "aacute" => "\u{00E1}",
    "aadeva" => "\u{0906}",
    "aagujarati" => "\u{0A86}",
    "aagurmukhi" => "\u{0A06}",
    "aamatragurmukhi" => "\u{0A3E}",
    "aarusquare" => "\u{3303}",
    "aavowelsignbengali" => "\u{09BE}",
    "aavowelsigndeva" => "\u{093E}",
    "aavowelsigngujarati" => "\u{0ABE}",
    "abbreviationmarkarmenian" => "\u{055F}",
    "abbreviationsigndeva" => "\u{0970}",
    "abengali" => "\u{0985}",
    "abopomofo" => "\u{311A}",
    "abreve" => "\u{0103}",
    "abreveacute" => "\u{1EAF}",
    "abrevecyrillic" => "\u{04D1}",
    "abrevedotbelow" => "\u{1EB7}",
    "abrevegrave" => "\u{1EB1}",
    "abrevehookabove" => "\u{1EB3}",
    "abrevetilde" => "\u{1EB5}",
    "acaron" => "\u{01CE}",
    "acircle" => "\u{24D0}",
    "acircumflex" => "\u{00E2}",
    "acircumflexacute" => "\u{1EA5}",
    "acircumflexdotbelow" => "\u{1EAD}",
    "acircumflexgrave" => "\u{1EA7}",
    "acircumflexhookabove" => "\u{1EA9}",
    "acircumflextilde" => "\u{1EAB}",
    "acute" => "\u{00B4}",
    "acutebelowcmb" => "\u{0317}",
    "acutecmb" => "\u{0301}",
    "acutecomb" => "\u{0301}",
    "acutedeva" => "\u{0954}",
    "acutelowmod" => "\u{02CF}",
    "acutetonecmb" => "\u{0341}",
    "acyrillic" => "\u{0430}",
    "adblgrave" => "\u{0201}",
    "addakgurmukhi" => "\u{0A71}",
    "adeva" => "\u{0905}",
    "adieresis" => "\u{00E4}",
    "adieresiscyrillic" => "\u{04D3}",
    "adieresismacron" => "\u{01DF}",
    "adotbelow" => "\u{1EA1}",
    "adotmacron" => "\u{01E1}",
    "ae" => "\u{00E6}",
    "aeacute" => "\u{01FD}",
    "aekorean" => "\u{3150}",
    "aemacron" => "\u{01E3}",
    "afii00208" => "\u{2015}",
    "afii08941" => "\u{20A4}",
    "afii10017" => "\u{0410}",
    "afii10018" => "\u{0411}",
    "afii10019" => "\u{0412}",
    "afii10020" => "\u{0413}",
    "afii10021" => "\u{0414}",
    "afii10022" => "\u{0415}",
    "afii10023" => "\u{0401}",
    "afii10024" => "\u{0416}",
    "afii10025" => "\u{0417}",
    "afii10026" => "\u{0418}",
    "afii10027" => "\u{0419}",
    "afii10028" => "\u{041A}",
    "afii10029" => "\u{041B}",
    "afii10030" => "\u{041C}",
    "afii10031" => "\u{041D}",
    "afii10032" => "\u{041E}",
    "afii10033" => "\u{041F}",
    "afii10034" => "\u{0420}",
    "afii10035" => "\u{0421}",
    "afii10036" => "\u{0422}",
    "afii10037" => "\u{0423}",
    "afii10038" => "\u{0424}",
    "afii10039" => "\u{0425}",
    "afii10040" => "\u{0426}",
    "afii10041" => "\u{0427}",
    "afii10042" => "\u{0428}",
    "afii10043" => "\u{0429}",
    "afii10044" => "\u{042A}",
    "afii10045" => "\u{042B}",
    "afii10046" => "\u{042C}",
    "afii10047" => "\u{042D}",
    "afii10048" => "\u{042E}",
    "afii10049" => "\u{042F}",
    "afii10050" => "\u{0490}",
    "afii10051" => "\u{0402}",
    "afii10052" => "\u{0403}",
    "afii10053" => "\u{0404}",
    "afii10054" => "\u{0405}",
    "afii10055" => "\u{0406}",
    "afii10056" => "\u{0407}",
    "afii10057" => "\u{0408}",
    "afii10058" => "\u{0409}",
    "afii10059" => "\u{040A}",
    "afii10060" => "\u{040B}",
    "afii10061" => "\u{040C}",
    "afii10062" => "\u{040E}",
    "afii10063" => "\u{F6C4}",
    "afii10064" => "\u{F6C5}",
    "afii10065" => "\u{0430}",
    "afii10066" => "\u{0431}",
    "afii10067" => "\u{0432}",
    "afii10068" => "\u{0433}",
    "afii10069" => "\u{0434}",
    "afii10070" => "\u{0435}",
    "afii10071" => "\u{0451}",
    "afii10072" => "\u{0436}",
    "afii10073" => "\u{0437}",
    "afii10074" => "\u{0438}",
    "afii10075" => "\u{0439}",
    "afii10076" => "\u{043A}",
    "afii10077" => "\u{043B}",
    "afii10078" => "\u{043C}",
    "afii10079" => "\u{043D}",
    "afii10080" => "\u{043E}",
    "afii10081" => "\u{043F}",
    "afii10082" => "\u{0440}",
    "afii10083" => "\u{0441}",
    "afii10084" => "\u{0442}",
    "afii10085" => "\u{0443}",
    "afii10086" => "\u{0444}",
    "afii10087" => "\u{0445}",
    "afii10088" => "\u{0446}",
    "afii10089" => "\u{0447}",
    "afii10090" => "\u{0448}",
    "afii10091" => "\u{0449}",
    "afii10092" => "\u{044A}",
    "afii10093" => "\u{044B}",
    "afii10094" => "\u{044C}",
    "afii10095" => "\u{044D}",
    "afii10096" => "\u{044E}",
    "afii10097" => "\u{044F}",
    "afii10098" => "\u{0491}",
    "afii10099" => "\u{0452}",
    "afii10100" => "\u{0453}",
    "afii10101" => "\u{0454}",
    "afii10102" => "\u{0455}",
    "afii10103" => "\u{0456}",
    "afii10104" => "\u{0457}",
    "afii10105" => "\u{0458}",
    "afii10106" => "\u{0459}",
    "afii10107" => "\u{045A}",
    "afii10108" => "\u{045B}",
    "afii10109" => "\u{045C}",
    "afii10110" => "\u{045E}",
    "afii10145" => "\u{040F}",
    "afii10146" => "\u{0462}",
    "afii10147" => "\u{0472}",
    "afii10148" => "\u{0474}",
    "afii10192" => "\u{F6C6}",
    "afii10193" => "\u{045F}",
    "afii10194" => "\u{0463}",
    "afii10195" => "\u{0473}",
    "afii10196" => "\u{0475}",
    "afii10831" => "\u{F6C7}",
    "afii10832" => "\u{F6C8}",
    "afii10846" => "\u{04D9}",
    "afii299" => "\u{200E}",
    "afii300" => "\u{200F}",
    "afii301" => "\u{200D}",
    "afii57381" => "\u{066A}",
    "afii57388" => "\u{060C}",
    "afii57392" => "\u{0660}",
    "afii57393" => "\u{0661}",
    "afii57394" => "\u{0662}",
    "afii57395" => "\u{0663}",
    "afii57396" => "\u{0664}",
    "afii57397" => "\u{0665}",
    "afii57398" => "\u{0666}",
    "afii57399" => "\u{0667}",
    "afii57400" => "\u{0668}",
    "afii57401" => "\u{0669}",
    "afii57403" => "\u{061B}",
    "afii57407" => "\u{061F}",
    "afii57409" => "\u{0621}",
    "afii57410" => "\u{0622}",
    "afii57411" => "\u{0623}",
    "afii57412" => "\u{0624}",
    "afii57413" => "\u{0625}",
    "afii57414" => "\u{0626}",
    "afii57415" => "\u{0627}",
    "afii57416" => "\u{0628}",
    "afii57417" => "\u{0629}",
    "afii57418" => "\u{062A}",
    "afii57419" => "\u{062B}",
    "afii57420" => "\u{062C}",
    "afii57421" => "\u{062D}",
    "afii57422" => "\u{062E}",
    "afii57423" => "\u{062F}",
    "afii57424" => "\u{0630}",
    "afii57425" => "\u{0631}",
    "afii57426" => "\u{0632}",
    "afii57427" => "\u{0633}",
    "afii57428" => "\u{0634}",
    "afii57429" => "\u{0635}",
    "afii57430" => "\u{0636}",
    "afii57431" => "\u{0637}",
    "afii57432" => "\u{0638}",
    "afii57433" => "\u{0639}",
    "afii57434" => "\u{063A}",
    "afii57440" => "\u{0640}",
    "afii57441" => "\u{0641}",
    "afii57442" => "\u{0642}",
    "afii57443" => "\u{0643}",
    "afii57444" => "\u{0644}",
    "afii57445" => "\u{0645}",
    "afii57446" => "\u{0646}",
    "afii57448" => "\u{0648}",
    "afii57449" => "\u{0649}",
    "afii57450" => "\u{064A}",
    "afii57451" => "\u{064B}",
    "afii57452" => "\u{064C}",
    "afii57453" => "\u{064D}",
    "afii57454" => "\u{064E}",
    "afii57455" => "\u{064F}",
    "afii57456" => "\u{0650}",
    "afii57457" => "\u{0651}",
    "afii57458" => "\u{0652}",
    "afii57470" => "\u{0647}",
    "afii57505" => "\u{06A4}",
    "afii57506" => "\u{067E}",
    "afii57507" => "\u{0686}",
    "afii57508" => "\u{0698}",
    "afii57509" => "\u{06AF}",
    "afii57511" => "\u{0679}",
    "afii57512" => "\u{0688}",
    "afii57513" => "\u{0691}",
    "afii57514" => "\u{06BA}",
    "afii57519" => "\u{06D2}",
    "afii57534" => "\u{06D5}",
    "afii57636" => "\u{20AA}",
    "afii57645" => "\u{05BE}",
    "afii57658" => "\u{05C3}",
    "afii57664" => "\u{05D0}",
    "afii57665" => "\u{05D1}",
    "afii57666" => "\u{05D2}",
    "afii57667" => "\u{05D3}",
    "afii57668" => "\u{05D4}",
    "afii57669" => "\u{05D5}",
    "afii57670" => "\u{05D6}",
    "afii57671" => "\u{05D7}",
    "afii57672" => "\u{05D8}",
    "afii57673" => "\u{05D9}",
    "afii57674" => "\u{05DA}",
    "afii57675" => "\u{05DB}",
    "afii57676" => "\u{05DC}",
    "afii57677" => "\u{05DD}",
    "afii57678" => "\u{05DE}",
    "afii57679" => "\u{05DF}",
    "afii57680" => "\u{05E0}",
    "afii57681" => "\u{05E1}",
    "afii57682" => "\u{05E2}",
    "afii57683" => "\u{05E3}",
    "afii57684" => "\u{05E4}",
    "afii57685" => "\u{05E5}",
    "afii57686" => "\u{05E6}",
    "afii57687" => "\u{05E7}",
    "afii57688" => "\u{05E8}",
    "afii57689" => "\u{05E9}",
    "afii57690" => "\u{05EA}",
    "afii57694" => "\u{FB2A}",
    "afii57695" => "\u{FB2B}",
    "afii57700" => "\u{FB4B}",
    "afii57705" => "\u{FB1F}",
    "afii57716" => "\u{05F0}",
    "afii57717" => "\u{05F1}",
    "afii57718" => "\u{05F2}",
    "afii57723" => "\u{FB35}",
    "afii57793" => "\u{05B4}",
    "afii57794" => "\u{05B5}",
    "afii57795" => "\u{05B6}",
    "afii57796" => "\u{05BB}",
    "afii57797" => "\u{05B8}",
    "afii57798" => "\u{05B7}",
    "afii57799" => "\u{05B0}",
    "afii57800" => "\u{05B2}",
    "afii57801" => "\u{05B1}",
    "afii57802" => "\u{05B3}",
    "afii57803" => "\u{05C2}",
    "afii57804" => "\u{05C1}",
    "afii57806" => "\u{05B9}",
    "afii57807" => "\u{05BC}",
    "afii57839" => "\u{05BD}",
    "afii57841" => "\u{05BF}",
    "afii57842" => "\u{05C0}",
    "afii57929" => "\u{02BC}",
    "afii61248" => "\u{2105}",
    "afii61289" => "\u{2113}",
    "afii61352" => "\u{2116}",
    "afii61573" => "\u{202C}",
    "afii61574" => "\u{202D}",
    "afii61575" => "\u{202E}",
    "afii61664" => "\u{200C}",
    "afii63167" => "\u{066D}",
    "afii64937" => "\u{02BD}",
    "agrave" => "\u{00E0}",
    "agujarati" => "\u{0A85}",
    "agurmukhi" => "\u{0A05}",
    "ahiragana" => "\u{3042}",
    "ahookabove" => "\u{1EA3}",
    "aibengali" => "\u{0990}",
    "aibopomofo" => "\u{311E}",
    "aideva" => "\u{0910}",
    "aiecyrillic" => "\u{04D5}",
    "aigujarati" => "\u{0A90}",
    "aigurmukhi" => "\u{0A10}",
    "aimatragurmukhi" => "\u{0A48}",
    "ainarabic" => "\u{0639}",
    "ainfinalarabic" => "\u{FECA}",
    "aininitialarabic" => "\u{FECB}",
    "ainmedialarabic" => "\u{FECC}",
    "ainvertedbreve" => "\u{0203}",
    "aivowelsignbengali" => "\u{09C8}",
    "aivowelsigndeva" => "\u{0948}",
    "aivowelsigngujarati" => "\u{0AC8}",
    "akatakana" => "\u{30A2}",
    "akatakanahalfwidth" => "\u{FF71}",
    "akorean" => "\u{314F}",
    "alef" => "\u{05D0}",
    "alefarabic" => "\u{0627}",
    "alefdageshhebrew" => "\u{FB30}",
    "aleffinalarabic" => "\u{FE8E}",
    "alefhamzaabovearabic" => "\u{0623}",
    "alefhamzaabovefinalarabic" => "\u{FE84}",
    "alefhamzabelowarabic" => "\u{0625}",
    "alefhamzabelowfinalarabic" => "\u{FE88}",
    "alefhebrew" => "\u{05D0}",
    "aleflamedhebrew" => "\u{FB4F}",
    "alefmaddaabovearabic" => "\u{0622}",
    "alefmaddaabovefinalarabic" => "\u{FE82}",
    "alefmaksuraarabic" => "\u{0649}",
    "alefmaksurafinalarabic" => "\u{FEF0}",
    "alefmaksurainitialarabic" => "\u{FEF3}",
    "alefmaksuramedialarabic" => "\u{FEF4}",
    "alefpatahhebrew" => "\u{FB2E}",
    "alefqamatshebrew" => "\u{FB2F}",
    "aleph" => "\u{2135}",
    "allequal" => "\u{224C}",
    "alpha" => "\u{03B1}",
    "alphatonos" => "\u{03AC}",
    "amacron" => "\u{0101}",
    "amonospace" => "\u{FF41}",
    "ampersand" => "\u{0026}",
    "ampersandmonospace" => "\u{FF06}",
    "ampersandsmall" => "\u{F726}",
    "amsquare" => "\u{33C2}",
    "anbopomofo" => "\u{3122}",
    "angbopomofo" => "\u{3124}",
    "angkhankhuthai" => "\u{0E5A}",
    "angle" => "\u{2220}",
    "anglebracketleft" => "\u{3008}",
    "anglebracketleftvertical" => "\u{FE3F}",
    "anglebracketright" => "\u{3009}",
    "anglebracketrightvertical" => "\u{FE40}",
    "angleleft" => "\u{2329}",
    "angleright" => "\u{232A}",
    "angstrom" => "\u{212B}",
    "anoteleia" => "\u{0387}",
    "anudattadeva" => "\u{0952}",
    "anusvarabengali" => "\u{0982}",
    "anusvaradeva" => "\u{0902}",
    "anusvaragujarati" => "\u{0A82}",
    "aogonek" => "\u{0105}",
    "apaatosquare" => "\u{3300}",
    "aparen" => "\u{249C}",
    "apostrophearmenian" => "\u{055A}",
    "apostrophemod" => "\u{02BC}",
    "apple" => "\u{F8FF}",
    "approaches" => "\u{2250}",
    "approxequal" => "\u{2248}",
    "approxequalorimage" => "\u{2252}",
    "approximatelyequal" => "\u{2245}",
    "araeaekorean" => "\u{318E}",
    "araeakorean" => "\u{318D}",
    "arc" => "\u{2312}",
    "arighthalfring" => "\u{1E9A}",
    "aring" => "\u{00E5}",
    "aringacute" => "\u{01FB}",
    "aringbelow" => "\u{1E01}",
    "arrowboth" => "\u{2194}",
    "arrowdashdown" => "\u{21E3}",
    "arrowdashleft" => "\u{21E0}",
    "arrowdashright" => "\u{21E2}",
    "arrowdashup" => "\u{21E1}",
    "arrowdblboth" => "\u{21D4}",
    "arrowdbldown" => "\u{21D3}",
    "arrowdblleft" => "\u{21D0}",
    "arrowdblright" => "\u{21D2}",
    "arrowdblup" => "\u{21D1}",
    "arrowdown" => "\u{2193}",
    "arrowdownleft" => "\u{2199}",
    "arrowdownright" => "\u{2198}",
    "arrowdownwhite" => "\u{21E9}",
    "arrowheaddownmod" => "\u{02C5}",
    "arrowheadleftmod" => "\u{02C2}",
    "arrowheadrightmod" => "\u{02C3}",
    "arrowheadupmod" => "\u{02C4}",
    "arrowhorizex" => "\u{F8E7}",
    "arrowleft" => "\u{2190}",
    "arrowleftdbl" => "\u{21D0}",
    "arrowleftdblstroke" => "\u{21CD}",
    "arrowleftoverright" => "\u{21C6}",
    "arrowleftwhite" => "\u{21E6}",
    "arrowright" => "\u{2192}",
    "arrowrightdblstroke" => "\u{21CF}",
    "arrowrightheavy" => "\u{279E}",
    "arrowrightoverleft" => "\u{21C4}",
    "arrowrightwhite" => "\u{21E8}",
    "arrowtableft" => "\u{21E4}",
    "arrowtabright" => "\u{21E5}",
    "arrowup" => "\u{2191}",
    "arrowupdn" => "\u{2195}",
    "arrowupdnbse" => "\u{21A8}",
    "arrowupdownbase" => "\u{21A8}",
    "arrowupleft" => "\u{2196}",
    "arrowupleftofdown" => "\u{21C5}",
    "arrowupright" => "\u{2197}",
    "arrowupwhite" => "\u{21E7}",
    "arrowvertex" => "\u{F8E6}",
    "asciicircum" => "\u{005E}",
    "asciicircummonospace" => "\u{FF3E}",
    "asciitilde" => "\u{007E}",
    "asciitildemonospace" => "\u{FF5E}",
    "ascript" => "\u{0251}",
    "ascriptturned" => "\u{0252}",
    "asmallhiragana" => "\u{3041}",
    "asmallkatakana" => "\u{30A1}",
    "asmallkatakanahalfwidth" => "\u{FF67}",
    "asterisk" => "\u{002A}",
    "asteriskaltonearabic" => "\u{066D}",
    "asteriskarabic" => "\u{066D}",
    "asteriskmath" => "\u{2217}",
    "asteriskmonospace" => "\u{FF0A}",
    "asterisksmall" => "\u{FE61}",
    "asterism" => "\u{2042}",
    "asuperior" => "\u{F6E9}",
    "asymptoticallyequal" => "\u{2243}",
    "at" => "\u{0040}",
    "atilde" => "\u{00E3}",
    "atmonospace" => "\u{FF20}",
    "atsmall" => "\u{FE6B}",
    "aturned" => "\u{0250}",
    "aubengali" => "\u{0994}",
    "aubopomofo" => "\u{3120}",
    "audeva" => "\u{0914}",
    "augujarati" => "\u{0A94}",
    "augurmukhi" => "\u{0A14}",
    "aulengthmarkbengali" => "\u{09D7}",
    "aumatragurmukhi" => "\u{0A4C}",
    "auvowelsignbengali" => "\u{09CC}",
    "auvowelsigndeva" => "\u{094C}",
    "auvowelsigngujarati" => "\u{0ACC}",
    "avagrahadeva" => "\u{093D}",
    "aybarmenian" => "\u{0561}",
    "ayin" => "\u{05E2}",
    "ayinaltonehebrew" => "\u{FB20}",
    "ayinhebrew" => "\u{05E2}",
    "b" => "\u{0062}",
    "babengali" => "\u{09AC}",
    "backslash" => "\u{005C}",
    "backslashmonospace" => "\u{FF3C}",
    "badeva" => "\u{092C}",
    "bagujarati" => "\u{0AAC}",
    "bagurmukhi" => "\u{0A2C}",
    "bahiragana" => "\u{3070}",
    "bahtthai" => "\u{0E3F}",
    "bakatakana" => "\u{30D0}",
    "bar" => "\u{007C}",
    "barmonospace" => "\u{FF5C}",
    "bbopomofo" => "\u{3105}",
    "bcircle" => "\u{24D1}",
    "bdotaccent" => "\u{1E03}",
    "bdotbelow" => "\u{1E05}",
    "beamedsixteenthnotes" => "\u{266C}",
    "because" => "\u{2235}",
    "becyrillic" => "\u{0431}",
    "beharabic" => "\u{0628}",
    "behfinalarabic" => "\u{FE90}",
    "behinitialarabic" => "\u{FE91}",
    "behiragana" => "\u{3079}",
    "behmedialarabic" => "\u{FE92}",
    "behmeeminitialarabic" => "\u{FC9F}",
    "behmeemisolatedarabic" => "\u{FC08}",
    "behnoonfinalarabic" => "\u{FC6D}",
    "bekatakana" => "\u{30D9}",
    "benarmenian" => "\u{0562}",
    "bet" => "\u{05D1}",
    "beta" => "\u{03B2}",
    "betasymbolgreek" => "\u{03D0}",
    "betdagesh" => "\u{FB31}",
    "betdageshhebrew" => "\u{FB31}",
    "bethebrew" => "\u{05D1}",
    "betrafehebrew" => "\u{FB4C}",
    "bhabengali" => "\u{09AD}",
    "bhadeva" => "\u{092D}",
    "bhagujarati" => "\u{0AAD}",
    "bhagurmukhi" => "\u{0A2D}",
    "bhook" => "\u{0253}",
    "bihiragana" => "\u{3073}",
    "bikatakana" => "\u{30D3}",
    "bilabialclick" => "\u{0298}",
    "bindigurmukhi" => "\u{0A02}",
    "birusquare" => "\u{3331}",
    "blackcircle" => "\u{25CF}",
    "blackdiamond" => "\u{25C6}",
    "blackdownpointingtriangle" => "\u{25BC}",
    "blackleftpointingpointer" => "\u{25C4}",
    "blackleftpointingtriangle" => "\u{25C0}",
    "blacklenticularbracketleft" => "\u{3010}",
    "blacklenticularbracketleftvertical" => "\u{FE3B}",
    "blacklenticularbracketright" => "\u{3011}",
    "blacklenticularbracketrightvertical" => "\u{FE3C}",
    "blacklowerlefttriangle" => "\u{25E3}",
    "blacklowerrighttriangle" => "\u{25E2}",
    "blackrectangle" => "\u{25AC}",
    "blackrightpointingpointer" => "\u{25BA}",
    "blackrightpointingtriangle" => "\u{25B6}",
    "blacksmallsquare" => "\u{25AA}",
    "blacksmilingface" => "\u{263B}",
    "blacksquare" => "\u{25A0}",
    "blackstar" => "\u{2605}",
    "blackupperlefttriangle" => "\u{25E4}",
    "blackupperrighttriangle" => "\u{25E5}",
    "blackuppointingsmalltriangle" => "\u{25B4}",
    "blackuppointingtriangle" => "\u{25B2}",
    "blank" => "\u{2423}",
    "blinebelow" => "\u{1E07}",
    "block" => "\u{2588}",
    "bmonospace" => "\u{FF42}",
    "bobaimaithai" => "\u{0E1A}",
    "bohiragana" => "\u{307C}",
    "bokatakana" => "\u{30DC}",
    "bparen" => "\u{249D}",
    "bqsquare" => "\u{33C3}",
    "braceex" => "\u{F8F4}",
    "braceleft" => "\u{007B}",
    "braceleftbt" => "\u{F8F3}",
    "braceleftmid" => "\u{F8F2}",
    "braceleftmonospace" => "\u{FF5B}",
    "braceleftsmall" => "\u{FE5B}",
    "bracelefttp" => "\u{F8F1}",
    "braceleftvertical" => "\u{FE37}",
    "braceright" => "\u{007D}",
    "bracerightbt" => "\u{F8FE}",
    "bracerightmid" => "\u{F8FD}",
    "bracerightmonospace" => "\u{FF5D}",
    "bracerightsmall" => "\u{FE5C}",
    "bracerighttp" => "\u{F8FC}",
    "bracerightvertical" => "\u{FE38}",
    "bracketleft" => "\u{005B}",
    "bracketleftbt" => "\u{F8F0}",
    "bracketleftex" => "\u{F8EF}",
    "bracketleftmonospace" => "\u{FF3B}",
    "bracketlefttp" => "\u{F8EE}",
    "bracketright" => "\u{005D}",
    "bracketrightbt" => "\u{F8FB}",
    "bracketrightex" => "\u{F8FA}",
    "bracketrightmonospace" => "\u{FF3D}",
    "bracketrighttp" => "\u{F8F9}",
    "breve" => "\u{02D8}",
    "brevebelowcmb" => "\u{032E}",
    "brevecmb" => "\u{0306}",
    "breveinvertedbelowcmb" => "\u{032F}",
    "breveinvertedcmb" => "\u{0311}",
    "breveinverteddoublecmb" => "\u{0361}",
    "bridgebelowcmb" => "\u{032A}",
    "bridgeinvertedbelowcmb" => "\u{033A}",
    "brokenbar" => "\u{00A6}",
    "bstroke" => "\u{0180}",
    "bsuperior" => "\u{F6EA}",
    "btopbar" => "\u{0183}",
    "buhiragana" => "\u{3076}",
    "bukatakana" => "\u{30D6}",
    "bullet" => "\u{2022}",
    "bulletinverse" => "\u{25D8}",
    "bulletoperator" => "\u{2219}",
    "bullseye" => "\u{25CE}",
    "c" => "\u{0063}",
    "caarmenian" => "\u{056E}",
    "cabengali" => "\u{099A}",
    "cacute" => "\u{0107}",
    "cadeva" => "\u{091A}",
    "cagujarati" => "\u{0A9A}",
    "cagurmukhi" => "\u{0A1A}",
    "calsquare" => "\u{3388}",
    "candrabindubengali" => "\u{0981}",
    "candrabinducmb" => "\u{0310}",
    "candrabindudeva" => "\u{0901}",
    "candrabindugujarati" => "\u{0A81}",
    "capslock" => "\u{21EA}",
    "careof" => "\u{2105}",
    "caron" => "\u{02C7}",
    "caronbelowcmb" => "\u{032C}",
    "caroncmb" => "\u{030C}",
    "carriagereturn" => "\u{21B5}",
    "cbopomofo" => "\u{3118}",
    "ccaron" => "\u{010D}",
    "ccedilla" => "\u{00E7}",
    "ccedillaacute" => "\u{1E09}",
    "ccircle" => "\u{24D2}",
    "ccircumflex" => "\u{0109}",
    "ccurl" => "\u{0255}",
    "cdot" => "\u{010B}",
    "cdotaccent" => "\u{010B}",
    "cdsquare" => "\u{33C5}",
    "cedilla" => "\u{00B8}",
    "cedillacmb" => "\u{0327}",
    "cent" => "\u{00A2}",
    "centigrade" => "\u{2103}",
    "centinferior" => "\u{F6DF}",
    "centmonospace" => "\u{FFE0}",
    "centoldstyle" => "\u{F7A2}",
    "centsuperior" => "\u{F6E0}",
    "chaarmenian" => "\u{0579}",
    "chabengali" => "\u{099B}",
    "chadeva" => "\u{091B}",
    "chagujarati" => "\u{0A9B}",
    "chagurmukhi" => "\u{0A1B}",
    "chbopomofo" => "\u{3114}",
    "cheabkhasiancyrillic" => "\u{04BD}",
    "checkmark" => "\u{2713}",
    "checyrillic" => "\u{0447}",
    "chedescenderabkhasiancyrillic" => "\u{04BF}",
    "chedescendercyrillic" => "\u{04B7}",
    "chedieresiscyrillic" => "\u{04F5}",
    "cheharmenian" => "\u{0573}",
    "chekhakassiancyrillic" => "\u{04CC}",
    "cheverticalstrokecyrillic" => "\u{04B9}",
    "chi" => "\u{03C7}",
    "chieuchacirclekorean" => "\u{3277}",
    "chieuchaparenkorean" => "\u{3217}",
    "chieuchcirclekorean" => "\u{3269}",
    "chieuchkorean" => "\u{314A}",
    "chieuchparenkorean" => "\u{3209}",
    "chochangthai" => "\u{0E0A}",
    "chochanthai" => "\u{0E08}",
    "chochingthai" => "\u{0E09}",
    "chochoethai" => "\u{0E0C}",
    "chook" => "\u{0188}",
    "cieucacirclekorean" => "\u{3276}",
    "cieucaparenkorean" => "\u{3216}",
    "cieuccirclekorean" => "\u{3268}",
    "cieuckorean" => "\u{3148}",
    "cieucparenkorean" => "\u{3208}",
    "cieucuparenkorean" => "\u{321C}",
    "circle" => "\u{25CB}",
    "circlemultiply" => "\u{2297}",
    "circleot" => "\u{2299}",
    "circleplus" => "\u{2295}",
    "circlepostalmark" => "\u{3036}",
    "circlewithlefthalfblack" => "\u{25D0}",
    "circlewithrighthalfblack" => "\u{25D1}",
    "circumflex" => "\u{02C6}",
    "circumflexbelowcmb" => "\u{032D}",
    "circumflexcmb" => "\u{0302}",
    "clear" => "\u{2327}",
    "clickalveolar" => "\u{01C2}",
    "clickdental" => "\u{01C0}",
    "clicklateral" => "\u{01C1}",
    "clickretroflex" => "\u{01C3}",
    "club" => "\u{2663}",
    "clubsuitblack" => "\u{2663}",
    "clubsuitwhite" => "\u{2667}",
    "cmcubedsquare" => "\u{33A4}",
    "cmonospace" => "\u{FF43}",
    "cmsquaredsquare" => "\u{33A0}",
    "coarmenian" => "\u{0581}",
    "colon" => "\u{003A}",
    "colonmonetary" => "\u{20A1}",
    "colonmonospace" => "\u{FF1A}",
    "colonsign" => "\u{20A1}",
    "colonsmall" => "\u{FE55}",
    "colontriangularhalfmod" => "\u{02D1}",
    "colontriangularmod" => "\u{02D0}",
    "comma" => "\u{002C}",
    "commaabovecmb" => "\u{0313}",
    "commaaboverightcmb" => "\u{0315}",
    "commaaccent" => "\u{F6C3}",
    "commaarabic" => "\u{060C}",
    "commaarmenian" => "\u{055D}",
    "commainferior" => "\u{F6E1}",
    "commamonospace" => "\u{FF0C}",
    "commareversedabovecmb" => "\u{0314}",
    "commareversedmod" => "\u{02BD}",
    "commasmall" => "\u{FE50}",
    "commasuperior" => "\u{F6E2}",
    "commaturnedabovecmb" => "\u{0312}",
    "commaturnedmod" => "\u{02BB}",
    "compass" => "\u{263C}",
    "congruent" => "\u{2245}",
    "contourintegral" => "\u{222E}",
    "control" => "\u{2303}",
    "controlACK" => "\u{0006}",
    "controlBEL" => "\u{0007}",
    "controlBS" => "\u{0008}",
    "controlCAN" => "\u{0018}",
    "controlCR" => "\u{000D}",
    "controlDC1" => "\u{0011}",
    "controlDC2" => "\u{0012}",
    "controlDC3" => "\u{0013}",
    "controlDC4" => "\u{0014}",
    "controlDEL" => "\u{007F}",
    "controlDLE" => "\u{0010}",
    "controlEM" => "\u{0019}",
    "controlENQ" => "\u{0005}",
    "controlEOT" => "\u{0004}",
    "controlESC" => "\u{001B}",
    "controlETB" => "\u{0017}",
    "controlETX" => "\u{0003}",
    "controlFF" => "\u{000C}",
    "controlFS" => "\u{001C}",
    "controlGS" => "\u{001D}",
    "controlHT" => "\u{0009}",
    "controlLF" => "\u{000A}",
    "controlNAK" => "\u{0015}",
    "controlRS" => "\u{001E}",
    "controlSI" => "\u{000F}",
    "controlSO" => "\u{000E}",
    "controlSOT" => "\u{0002}",
    "controlSTX" => "\u{0001}",
    "controlSUB" => "\u{001A}",
    "controlSYN" => "\u{0016}",
    "controlUS" => "\u{001F}",
    "controlVT" => "\u{000B}",
    "copyright" => "\u{00A9}",
    "copyrightsans" => "\u{F8E9}",
    "copyrightserif" => "\u{F6D9}",
    "cornerbracketleft" => "\u{300C}",
    "cornerbracketlefthalfwidth" => "\u{FF62}",
    "cornerbracketleftvertical" => "\u{FE41}",
    "cornerbracketright" => "\u{300D}",
    "cornerbracketrighthalfwidth" => "\u{FF63}",
    "cornerbracketrightvertical" => "\u{FE42}",
    "corporationsquare" => "\u{337F}",
    "cosquare" => "\u{33C7}",
    "coverkgsquare" => "\u{33C6}",
    "cparen" => "\u{249E}",
    "cruzeiro" => "\u{20A2}",
    "cstretched" => "\u{0297}",
    "curlyand" => "\u{22CF}",
    "curlyor" => "\u{22CE}",
    "currency" => "\u{00A4}",
    "cyrBreve" => "\u{F6D1}",
    "cyrFlex" => "\u{F6D2}",
    "cyrbreve" => "\u{F6D4}",
    "cyrflex" => "\u{F6D5}",
    "d" => "\u{0064}",
    "daarmenian" => "\u{0564}",
    "dabengali" => "\u{09A6}",
    "dadarabic" => "\u{0636}",
    "dadeva" => "\u{0926}",
    "dadfinalarabic" => "\u{FEBE}",
    "dadinitialarabic" => "\u{FEBF}",
    "dadmedialarabic" => "\u{FEC0}",
    "dagesh" => "\u{05BC}",
    "dageshhebrew" => "\u{05BC}",
    "dagger" => "\u{2020}",
    "daggerdbl" => "\u{2021}",
    "dagujarati" => "\u{0AA6}",
    "dagurmukhi" => "\u{0A26}",
    "dahiragana" => "\u{3060}",
    "dakatakana" => "\u{30C0}",
    "dalarabic" => "\u{062F}",
    "dalet" => "\u{05D3}",
    "daletdagesh" => "\u{FB33}",
    "daletdageshhebrew" => "\u{FB33}",
    "dalethatafpatah" => "\u{05D3}\u{05B2}",
    "dalethatafpatahhebrew" => "\u{05D3}\u{05B2}",
    "dalethatafsegol" => "\u{05D3}\u{05B1}",
    "dalethatafsegolhebrew" => "\u{05D3}\u{05B1}",
    "dalethebrew" => "\u{05D3}",
    "dalethiriq" => "\u{05D3}\u{05B4}",
    "dalethiriqhebrew" => "\u{05D3}\u{05B4}",
    "daletholam" => "\u{05D3}\u{05B9}",
    "daletholamhebrew" => "\u{05D3}\u{05B9}",
    "daletpatah" => "\u{05D3}\u{05B7}",
    "daletpatahhebrew" => "\u{05D3}\u{05B7}",
    "daletqamats" => "\u{05D3}\u{05B8}",
    "daletqamatshebrew" => "\u{05D3}\u{05B8}",
    "daletqubuts" => "\u{05D3}\u{05BB}",
    "daletqubutshebrew" => "\u{05D3}\u{05BB}",
    "daletsegol" => "\u{05D3}\u{05B6}",
    "daletsegolhebrew" => "\u{05D3}\u{05B6}",
    "daletsheva" => "\u{05D3}\u{05B0}",
    "daletshevahebrew" => "\u{05D3}\u{05B0}",
    "dalettsere" => "\u{05D3}\u{05B5}",
    "dalettserehebrew" => "\u{05D3}\u{05B5}",
    "dalfinalarabic" => "\u{FEAA}",
    "dammaarabic" => "\u{064F}",
    "dammalowarabic" => "\u{064F}",
    "dammatanaltonearabic" => "\u{064C}",
    "dammatanarabic" => "\u{064C}",
    "danda" => "\u{0964}",
    "dargahebrew" => "\u{05A7}",
    "dargalefthebrew" => "\u{05A7}",
    "dasiapneumatacyrilliccmb" => "\u{0485}",
    "dblGrave" => "\u{F6D3}",
    "dblanglebracketleft" => "\u{300A}",
    "dblanglebracketleftvertical" => "\u{FE3D}",
    "dblanglebracketright" => "\u{300B}",
    "dblanglebracketrightvertical" => "\u{FE3E}",
    "dblarchinvertedbelowcmb" => "\u{032B}",
    "dblarrowleft" => "\u{21D4}",
    "dblarrowright" => "\u{21D2}",
    "dbldanda" => "\u{0965}",
    "dblgrave" => "\u{F6D6}",
    "dblgravecmb" => "\u{030F}",
    "dblintegral" => "\u{222C}",
    "dbllowline" => "\u{2017}",
    "dbllowlinecmb" => "\u{0333}",
    "dbloverlinecmb" => "\u{033F}",
    "dblprimemod" => "\u{02BA}",
    "dblverticalbar" => "\u{2016}",
    "dblverticallineabovecmb" => "\u{030E}",
    "dbopomofo" => "\u{3109}",
    "dbsquare" => "\u{33C8}",
    "dcaron" => "\u{010F}",
    "dcedilla" => "\u{1E11}",
    "dcircle" => "\u{24D3}",
    "dcircumflexbelow" => "\u{1E13}",
    "dcroat" => "\u{0111}",
    "ddabengali" => "\u{09A1}",
    "ddadeva" => "\u{0921}",
    "ddagujarati" => "\u{0AA1}",
    "ddagurmukhi" => "\u{0A21}",
    "ddalarabic" => "\u{0688}",
    "ddalfinalarabic" => "\u{FB89}",
    "dddhadeva" => "\u{095C}",
    "ddhabengali" => "\u{09A2}",
    "ddhadeva" => "\u{0922}",
    "ddhagujarati" => "\u{0AA2}",
    "ddhagurmukhi" => "\u{0A22}",
    "ddotaccent" => "\u{1E0B}",
    "ddotbelow" => "\u{1E0D}",
    "decimalseparatorarabic" => "\u{066B}",
    "decimalseparatorpersian" => "\u{066B}",
    "decyrillic" => "\u{0434}",
    "degree" => "\u{00B0}",
    "dehihebrew" => "\u{05AD}",
    "dehiragana" => "\u{3067}",
    "deicoptic" => "\u{03EF}",
    "dekatakana" => "\u{30C7}",
    "deleteleft" => "\u{232B}",
    "deleteright" => "\u{2326}",
    "delta" => "\u{03B4}",
    "deltaturned" => "\u{018D}",
    "denominatorminusonenumeratorbengali" => "\u{09F8}",
    "dezh" => "\u{02A4}",
    "dhabengali" => "\u{09A7}",
    "dhadeva" => "\u{0927}",
    "dhagujarati" => "\u{0AA7}",
    "dhagurmukhi" => "\u{0A27}",
    "dhook" => "\u{0257}",
    "dialytikatonos" => "\u{0385}",
    "dialytikatonoscmb" => "\u{0344}",
    "diamond" => "\u{2666}",
    "diamondsuitwhite" => "\u{2662}",
    "dieresis" => "\u{00A8}",
    "dieresisacute" => "\u{F6D7}",
    "dieresisbelowcmb" => "\u{0324}",
    "dieresiscmb" => "\u{0308}",
    "dieresisgrave" => "\u{F6D8}",
    "dieresistonos" => "\u{0385}",
    "dihiragana" => "\u{3062}",
    "dikatakana" => "\u{30C2}",
    "dittomark" => "\u{3003}",
    "divide" => "\u{00F7}",
    "divides" => "\u{2223}",
    "divisionslash" => "\u{2215}",
    "djecyrillic" => "\u{0452}",
    "dkshade" => "\u{2593}",
    "dlinebelow" => "\u{1E0F}",
    "dlsquare" => "\u{3397}",
    "dmacron" => "\u{0111}",
    "dmonospace" => "\u{FF44}",
    "dnblock" => "\u{2584}",
    "dochadathai" => "\u{0E0E}",
    "dodekthai" => "\u{0E14}",
    "dohiragana" => "\u{3069}",
    "dokatakana" => "\u{30C9}",
    "dollar" => "\u{0024}",
    "dollarinferior" => "\u{F6E3}",
    "dollarmonospace" => "\u{FF04}",
    "dollaroldstyle" => "\u{F724}",
    "dollarsmall" => "\u{FE69}",
    "dollarsuperior" => "\u{F6E4}",
    "dong" => "\u{20AB}",
    "dorusquare" => "\u{3326}",
    "dotaccent" => "\u{02D9}",
    "dotaccentcmb" => "\u{0307}",
    "dotbelowcmb" => "\u{0323}",
    "dotbelowcomb" => "\u{0323}",
    "dotkatakana" => "\u{30FB}",
    "dotlessi" => "\u{0131}",
    "dotlessj" => "\u{F6BE}",
    "dotlessjstrokehook" => "\u{0284}",
    "dotmath" => "\u{22C5}",
    "dottedcircle" => "\u{25CC}",
    "doubleyodpatah" => "\u{FB1F}",
    "doubleyodpatahhebrew" => "\u{FB1F}",
    "downtackbelowcmb" => "\u{031E}",
    "downtackmod" => "\u{02D5}",
    "dparen" => "\u{249F}",
    "dsuperior" => "\u{F6EB}",
    "dtail" => "\u{0256}",
    "dtopbar" => "\u{018C}",
    "duhiragana" => "\u{3065}",
    "dukatakana" => "\u{30C5}",
    "dz" => "\u{01F3}",
    "dzaltone" => "\u{02A3}",
    "dzcaron" => "\u{01C6}",
    "dzcurl" => "\u{02A5}",
    "dzeabkhasiancyrillic" => "\u{04E1}",
    "dzecyrillic" => "\u{0455}",
    "dzhecyrillic" => "\u{045F}",
    "e" => "\u{0065}",
    "eacute" => "\u{00E9}",
    "earth" => "\u{2641}",
    "ebengali" => "\u{098F}",
    "ebopomofo" => "\u{311C}",
    "ebreve" => "\u{0115}",
    "ecandradeva" => "\u{090D}",
    "ecandragujarati" => "\u{0A8D}",
    "ecandravowelsigndeva" => "\u{0945}",
    "ecandravowelsigngujarati" => "\u{0AC5}",
    "ecaron" => "\u{011B}",
    "ecedillabreve" => "\u{1E1D}",
    "echarmenian" => "\u{0565}",
    "echyiwnarmenian" => "\u{0587}",
    "ecircle" => "\u{24D4}",
    "ecircumflex" => "\u{00EA}",
    "ecircumflexacute" => "\u{1EBF}",
    "ecircumflexbelow" => "\u{1E19}",
    "ecircumflexdotbelow" => "\u{1EC7}",
    "ecircumflexgrave" => "\u{1EC1}",
    "ecircumflexhookabove" => "\u{1EC3}",
    "ecircumflextilde" => "\u{1EC5}",
    "ecyrillic" => "\u{0454}",
    "edblgrave" => "\u{0205}",
    "edeva" => "\u{090F}",
    "edieresis" => "\u{00EB}",
    "edot" => "\u{0117}",
    "edotaccent" => "\u{0117}",
    "edotbelow" => "\u{1EB9}",
    "eegurmukhi" => "\u{0A0F}",
    "eematragurmukhi" => "\u{0A47}",
    "efcyrillic" => "\u{0444}",
    "egrave" => "\u{00E8}",
    "egujarati" => "\u{0A8F}",
    "eharmenian" => "\u{0567}",
    "ehbopomofo" => "\u{311D}",
    "ehiragana" => "\u{3048}",
    "ehookabove" => "\u{1EBB}",
    "eibopomofo" => "\u{311F}",
    "eight" => "\u{0038}",
    "eightarabic" => "\u{0668}",
    "eightbengali" => "\u{09EE}",
    "eightcircle" => "\u{2467}",
    "eightcircleinversesansserif" => "\u{2791}",
    "eightdeva" => "\u{096E}",
    "eighteencircle" => "\u{2471}",
    "eighteenparen" => "\u{2485}",
    "eighteenperiod" => "\u{2499}",
    "eightgujarati" => "\u{0AEE}",
    "eightgurmukhi" => "\u{0A6E}",
    "eighthackarabic" => "\u{0668}",
    "eighthangzhou" => "\u{3028}",
    "eighthnotebeamed" => "\u{266B}",
    "eightideographicparen" => "\u{3227}",
    "eightinferior" => "\u{2088}",
    "eightmonospace" => "\u{FF18}",
    "eightoldstyle" => "\u{F738}",
    "eightparen" => "\u{247B}",
    "eightperiod" => "\u{248F}",
    "eightpersian" => "\u{06F8}",
    "eightroman" => "\u{2177}",
    "eightsuperior" => "\u{2078}",
    "eightthai" => "\u{0E58}",
    "einvertedbreve" => "\u{0207}",
    "eiotifiedcyrillic" => "\u{0465}",
    "ekatakana" => "\u{30A8}",
    "ekatakanahalfwidth" => "\u{FF74}",
    "ekonkargurmukhi" => "\u{0A74}",
    "ekorean" => "\u{3154}",
    "elcyrillic" => "\u{043B}",
    "element" => "\u{2208}",
    "elevencircle" => "\u{246A}",
    "elevenparen" => "\u{247E}",
    "elevenperiod" => "\u{2492}",
    "elevenroman" => "\u{217A}",
    "ellipsis" => "\u{2026}",
    "ellipsisvertical" => "\u{22EE}",
    "emacron" => "\u{0113}",
    "emacronacute" => "\u{1E17}",
    "emacrongrave" => "\u{1E15}",
    "emcyrillic" => "\u{043C}",
    "emdash" => "\u{2014}",
    "emdashvertical" => "\u{FE31}",
    "emonospace" => "\u{FF45}",
    "emphasismarkarmenian" => "\u{055B}",
    "emptyset" => "\u{2205}",
    "enbopomofo" => "\u{3123}",
    "encyrillic" => "\u{043D}",
    "endash" => "\u{2013}",
    "endashvertical" => "\u{FE32}",
    "endescendercyrillic" => "\u{04A3}",
    "eng" => "\u{014B}",
    "engbopomofo" => "\u{3125}",
    "enghecyrillic" => "\u{04A5}",
    "enhookcyrillic" => "\u{04C8}",
    "enspace" => "\u{2002}",
    "eogonek" => "\u{0119}",
    "eokorean" => "\u{3153}",
    "eopen" => "\u{025B}",
    "eopenclosed" => "\u{029A}",
    "eopenreversed" => "\u{025C}",
    "eopenreversedclosed" => "\u{025E}",
    "eopenreversedhook" => "\u{025D}",
    "eparen" => "\u{24A0}",
    "epsilon" => "\u{03B5}",
    "epsilontonos" => "\u{03AD}",
    "equal" => "\u{003D}",
    "equalmonospace" => "\u{FF1D}",
    "equalsmall" => "\u{FE66}",
    "equalsuperior" => "\u{207C}",
    "equivalence" => "\u{2261}",
    "erbopomofo" => "\u{3126}",
    "ercyrillic" => "\u{0440}",
    "ereversed" => "\u{0258}",
    "ereversedcyrillic" => "\u{044D}",
    "escyrillic" => "\u{0441}",
    "esdescendercyrillic" => "\u{04AB}",
    "esh" => "\u{0283}",
    "eshcurl" => "\u{0286}",
    "eshortdeva" => "\u{090E}",
    "eshortvowelsigndeva" => "\u{0946}",
    "eshreversedloop" => "\u{01AA}",
    "eshsquatreversed" => "\u{0285}",
    "esmallhiragana" => "\u{3047}",
    "esmallkatakana" => "\u{30A7}",
    "esmallkatakanahalfwidth" => "\u{FF6A}",
    "estimated" => "\u{212E}",
    "esuperior" => "\u{F6EC}",
    "eta" => "\u{03B7}",
    "etarmenian" => "\u{0568}",
    "etatonos" => "\u{03AE}",
    "eth" => "\u{00F0}",
    "etilde" => "\u{1EBD}",
    "etildebelow" => "\u{1E1B}",
    "etnahtafoukhhebrew" => "\u{0591}",
    "etnahtafoukhlefthebrew" => "\u{0591}",
    "etnahtahebrew" => "\u{0591}",
    "etnahtalefthebrew" => "\u{0591}",
    "eturned" => "\u{01DD}",
    "eukorean" => "\u{3161}",
    "euro" => "\u{20AC}",
    "evowelsignbengali" => "\u{09C7}",
    "evowelsigndeva" => "\u{0947}",
    "evowelsigngujarati" => "\u{0AC7}",
    "exclam" => "\u{0021}",
    "exclamarmenian" => "\u{055C}",
    "exclamdbl" => "\u{203C}",
    "exclamdown" => "\u{00A1}",
    "exclamdownsmall" => "\u{F7A1}",
    "exclammonospace" => "\u{FF01}",
    "exclamsmall" => "\u{F721}",
    "existential" => "\u{2203}",
    "ezh" => "\u{0292}",
    "ezhcaron" => "\u{01EF}",
    "ezhcurl" => "\u{0293}",
    "ezhreversed" => "\u{01B9}",
    "ezhtail" => "\u{01BA}",
    "f" => "\u{0066}",
    "fadeva" => "\u{095E}",
    "fagurmukhi" => "\u{0A5E}",
    "fahrenheit" => "\u{2109}",
    "fathaarabic" => "\u{064E}",
    "fathalowarabic" => "\u{064E}",
    "fathatanarabic" => "\u{064B}",
    "fbopomofo" => "\u{3108}",
    "fcircle" => "\u{24D5}",
    "fdotaccent" => "\u{1E1F}",
    "feharabic" => "\u{0641}",
    "feharmenian" => "\u{0586}",
    "fehfinalarabic" => "\u{FED2}",
    "fehinitialarabic" => "\u{FED3}",
    "fehmedialarabic" => "\u{FED4}",
    "feicoptic" => "\u{03E5}",
    "female" => "\u{2640}",
    "ff" => "\u{FB00}",
    "ffi" => "\u{FB03}",
    "ffl" => "\u{FB04}",
    "fi" => "\u{FB01}",
    "fifteencircle" => "\u{246E}",
    "fifteenparen" => "\u{2482}",
    "fifteenperiod" => "\u{2496}",
    "figuredash" => "\u{2012}",
    "filledbox" => "\u{25A0}",
    "filledrect" => "\u{25AC}",
    "finalkaf" => "\u{05DA}",
    "finalkafdagesh" => "\u{FB3A}",
    "finalkafdageshhebrew" => "\u{FB3A}",
    "finalkafhebrew" => "\u{05DA}",
    "finalkafqamats" => "\u{05DA}\u{05B8}",
    "finalkafqamatshebrew" => "\u{05DA}\u{05B8}",
    "finalkafsheva" => "\u{05DA}\u{05B0}",
    "finalkafshevahebrew" => "\u{05DA}\u{05B0}",
    "finalmem" => "\u{05DD}",
    "finalmemhebrew" => "\u{05DD}",
    "finalnun" => "\u{05DF}",
    "finalnunhebrew" => "\u{05DF}",
    "finalpe" => "\u{05E3}",
    "finalpehebrew" => "\u{05E3}",
    "finaltsadi" => "\u{05E5}",
    "finaltsadihebrew" => "\u{05E5}",
    "firsttonechinese" => "\u{02C9}",
    "fisheye" => "\u{25C9}",
    "fitacyrillic" => "\u{0473}",
    "five" => "\u{0035}",
    "fivearabic" => "\u{0665}",
    "fivebengali" => "\u{09EB}",
    "fivecircle" => "\u{2464}",
    "fivecircleinversesansserif" => "\u{278E}",
    "fivedeva" => "\u{096B}",
    "fiveeighths" => "\u{215D}",
    "fivegujarati" => "\u{0AEB}",
    "fivegurmukhi" => "\u{0A6B}",
    "fivehackarabic" => "\u{0665}",
    "fivehangzhou" => "\u{3025}",
    "fiveideographicparen" => "\u{3224}",
    "fiveinferior" => "\u{2085}",
    "fivemonospace" => "\u{FF15}",
    "fiveoldstyle" => "\u{F735}",
    "fiveparen" => "\u{2478}",
    "fiveperiod" => "\u{248C}",
    "fivepersian" => "\u{06F5}",
    "fiveroman" => "\u{2174}",
    "fivesuperior" => "\u{2075}",
    "fivethai" => "\u{0E55}",
    "fl" => "\u{FB02}",
    "florin" => "\u{0192}",
    "fmonospace" => "\u{FF46}",
    "fmsquare" => "\u{3399}",
    "fofanthai" => "\u{0E1F}",
    "fofathai" => "\u{0E1D}",
    "fongmanthai" => "\u{0E4F}",
    "forall" => "\u{2200}",
    "four" => "\u{0034}",
    "fourarabic" => "\u{0664}",
    "fourbengali" => "\u{09EA}",
    "fourcircle" => "\u{2463}",
    "fourcircleinversesansserif" => "\u{278D}",
    "fourdeva" => "\u{096A}",
    "fourgujarati" => "\u{0AEA}",
    "fourgurmukhi" => "\u{0A6A}",
    "fourhackarabic" => "\u{0664}",
    "fourhangzhou" => "\u{3024}",
    "fourideographicparen" => "\u{3223}",
    "fourinferior" => "\u{2084}",
    "fourmonospace" => "\u{FF14}",
    "fournumeratorbengali" => "\u{09F7}",
    "fouroldstyle" => "\u{F734}",
    "fourparen" => "\u{2477}",
    "fourperiod" => "\u{248B}",
    "fourpersian" => "\u{06F4}",
    "fourroman" => "\u{2173}",
    "foursuperior" => "\u{2074}",
    "fourteencircle" => "\u{246D}",
    "fourteenparen" => "\u{2481}",
    "fourteenperiod" => "\u{2495}",
    "fourthai" => "\u{0E54}",
    "fourthtonechinese" => "\u{02CB}",
    "fparen" => "\u{24A1}",
    "fraction" => "\u{2044}",
    "franc" => "\u{20A3}",
    "g" => "\u{0067}",
    "gabengali" => "\u{0997}",
    "gacute" => "\u{01F5}",
    "gadeva" => "\u{0917}",
    "gafarabic" => "\u{06AF}",
    "gaffinalarabic" => "\u{FB93}",
    "gafinitialarabic" => "\u{FB94}",
    "gafmedialarabic" => "\u{FB95}",
    "gagujarati" => "\u{0A97}",
    "gagurmukhi" => "\u{0A17}",
    "gahiragana" => "\u{304C}",
    "gakatakana" => "\u{30AC}",
    "gamma" => "\u{03B3}",
    "gammalatinsmall" => "\u{0263}",
    "gammasuperior" => "\u{02E0}",
    "gangiacoptic" => "\u{03EB}",
    "gbopomofo" => "\u{310D}",
    "gbreve" => "\u{011F}",
    "gcaron" => "\u{01E7}",
    "gcedilla" => "\u{0123}",
    "gcircle" => "\u{24D6}",
    "gcircumflex" => "\u{011D}",
    "gcommaaccent" => "\u{0123}",
    "gdot" => "\u{0121}",
    "gdotaccent" => "\u{0121}",
    "gecyrillic" => "\u{0433}",
    "gehiragana" => "\u{3052}",
    "gekatakana" => "\u{30B2}",
    "geometricallyequal" => "\u{2251}",
    "gereshaccenthebrew" => "\u{059C}",
    "gereshhebrew" => "\u{05F3}",
    "gereshmuqdamhebrew" => "\u{059D}",
    "germandbls" => "\u{00DF}",
    "gershayimaccenthebrew" => "\u{059E}",
    "gershayimhebrew" => "\u{05F4}",
    "getamark" => "\u{3013}",
    "ghabengali" => "\u{0998}",
    "ghadarmenian" => "\u{0572}",
    "ghadeva" => "\u{0918}",
    "ghagujarati" => "\u{0A98}",
    "ghagurmukhi" => "\u{0A18}",
    "ghainarabic" => "\u{063A}",
    "ghainfinalarabic" => "\u{FECE}",
    "ghaininitialarabic" => "\u{FECF}",
    "ghainmedialarabic" => "\u{FED0}",
    "ghemiddlehookcyrillic" => "\u{0495}",
    "ghestrokecyrillic" => "\u{0493}",
    "gheupturncyrillic" => "\u{0491}",
    "ghhadeva" => "\u{095A}",
    "ghhagurmukhi" => "\u{0A5A}",
    "ghook" => "\u{0260}",
    "ghzsquare" => "\u{3393}",
    "gihiragana" => "\u{304E}",
    "gikatakana" => "\u{30AE}",
    "gimarmenian" => "\u{0563}",
    "gimel" => "\u{05D2}",
    "gimeldagesh" => "\u{FB32}",
    "gimeldageshhebrew" => "\u{FB32}",
    "gimelhebrew" => "\u{05D2}",
    "gjecyrillic" => "\u{0453}",
    "glottalinvertedstroke" => "\u{01BE}",
    "glottalstop" => "\u{0294}",
    "glottalstopinverted" => "\u{0296}",
    "glottalstopmod" => "\u{02C0}",
    "glottalstopreversed" => "\u{0295}",
    "glottalstopreversedmod" => "\u{02C1}",
    "glottalstopreversedsuperior" => "\u{02E4}",
    "glottalstopstroke" => "\u{02A1}",
    "glottalstopstrokereversed" => "\u{02A2}",
    "gmacron" => "\u{1E21}",
    "gmonospace" => "\u{FF47}",
    "gohiragana" => "\u{3054}",
    "gokatakana" => "\u{30B4}",
    "gparen" => "\u{24A2}",
    "gpasquare" => "\u{33AC}",
    "gradient" => "\u{2207}",
    "grave" => "\u{0060}",
    "gravebelowcmb" => "\u{0316}",
    "gravecmb" => "\u{0300}",
    "gravecomb" => "\u{0300}",
    "gravedeva" => "\u{0953}",
    "gravelowmod" => "\u{02CE}",
    "gravemonospace" => "\u{FF40}",
    "gravetonecmb" => "\u{0340}",
    "greater" => "\u{003E}",
    "greaterequal" => "\u{2265}",
    "greaterequalorless" => "\u{22DB}",
    "greatermonospace" => "\u{FF1E}",
    "greaterorequivalent" => "\u{2273}",
    "greaterorless" => "\u{2277}",
    "greateroverequal" => "\u{2267}",
    "greatersmall" => "\u{FE65}",
    "gscript" => "\u{0261}",
    "gstroke" => "\u{01E5}",
    "guhiragana" => "\u{3050}",
    "guillemotleft" => "\u{00AB}",
    "guillemotright" => "\u{00BB}",
    "guilsinglleft" => "\u{2039}",
    "guilsinglright" => "\u{203A}",
    "gukatakana" => "\u{30B0}",
    "guramusquare" => "\u{3318}",
    "gysquare" => "\u{33C9}",
    "h" => "\u{0068}",
    "haabkhasiancyrillic" => "\u{04A9}",
    "haaltonearabic" => "\u{06C1}",
    "habengali" => "\u{09B9}",
    "hadescendercyrillic" => "\u{04B3}",
    "hadeva" => "\u{0939}",
    "hagujarati" => "\u{0AB9}",
    "hagurmukhi" => "\u{0A39}",
    "haharabic" => "\u{062D}",
    "hahfinalarabic" => "\u{FEA2}",
    "hahinitialarabic" => "\u{FEA3}",
    "hahiragana" => "\u{306F}",
    "hahmedialarabic" => "\u{FEA4}",
    "haitusquare" => "\u{332A}",
    "hakatakana" => "\u{30CF}",
    "hakatakanahalfwidth" => "\u{FF8A}",
    "halantgurmukhi" => "\u{0A4D}",
    "hamzaarabic" => "\u{0621}",
    "hamzadammaarabic" => "\u{0621}\u{064F}",
    "hamzadammatanarabic" => "\u{0621}\u{064C}",
    "hamzafathaarabic" => "\u{0621}\u{064E}",
    "hamzafathatanarabic" => "\u{0621}\u{064B}",
    "hamzalowarabic" => "\u{0621}",
    "hamzalowkasraarabic" => "\u{0621}\u{0650}",
    "hamzalowkasratanarabic" => "\u{0621}\u{064D}",
    "hamzasukunarabic" => "\u{0621}\u{0652}",
    "hangulfiller" => "\u{3164}",
    "hardsigncyrillic" => "\u{044A}",
    "harpoonleftbarbup" => "\u{21BC}",
    "harpoonrightbarbup" => "\u{21C0}",
    "hasquare" => "\u{33CA}",
    "hatafpatah" => "\u{05B2}",
    "hatafpatah16" => "\u{05B2}",
    "hatafpatah23" => "\u{05B2}",
    "hatafpatah2f" => "\u{05B2}",
    "hatafpatahhebrew" => "\u{05B2}",
    "hatafpatahnarrowhebrew" => "\u{05B2}",
    "hatafpatahquarterhebrew" => "\u{05B2}",
    "hatafpatahwidehebrew" => "\u{05B2}",
    "hatafqamats" => "\u{05B3}",
    "hatafqamats1b" => "\u{05B3}",
    "hatafqamats28" => "\u{05B3}",
    "hatafqamats34" => "\u{05B3}",
    "hatafqamatshebrew" => "\u{05B3}",
    "hatafqamatsnarrowhebrew" => "\u{05B3}",
    "hatafqamatsquarterhebrew" => "\u{05B3}",
    "hatafqamatswidehebrew" => "\u{05B3}",
    "hatafsegol" => "\u{05B1}",
    "hatafsegol17" => "\u{05B1}",
    "hatafsegol24" => "\u{05B1}",
    "hatafsegol30" => "\u{05B1}",
    "hatafsegolhebrew" => "\u{05B1}",
    "hatafsegolnarrowhebrew" => "\u{05B1}",
    "hatafsegolquarterhebrew" => "\u{05B1}",
    "hatafsegolwidehebrew" => "\u{05B1}",
    "hbar" => "\u{0127}",
    "hbopomofo" => "\u{310F}",
    "hbrevebelow" => "\u{1E2B}",
    "hcedilla" => "\u{1E29}",
    "hcircle" => "\u{24D7}",
    "hcircumflex" => "\u{0125}",
    "hdieresis" => "\u{1E27}",
    "hdotaccent" => "\u{1E23}",
    "hdotbelow" => "\u{1E25}",
    "he" => "\u{05D4}",
    "heart" => "\u{2665}",
    "heartsuitblack" => "\u{2665}",
    "heartsuitwhite" => "\u{2661}",
    "hedagesh" => "\u{FB34}",
    "hedageshhebrew" => "\u{FB34}",
    "hehaltonearabic" => "\u{06C1}",
    "heharabic" => "\u{0647}",
    "hehebrew" => "\u{05D4}",
    "hehfinalaltonearabic" => "\u{FBA7}",
    "hehfinalalttwoarabic" => "\u{FEEA}",
    "hehfinalarabic" => "\u{FEEA}",
    "hehhamzaabovefinalarabic" => "\u{FBA5}",
    "hehhamzaaboveisolatedarabic" => "\u{FBA4}",
    "hehinitialaltonearabic" => "\u{FBA8}",
    "hehinitialarabic" => "\u{FEEB}",
    "hehiragana" => "\u{3078}",
    "hehmedialaltonearabic" => "\u{FBA9}",
    "hehmedialarabic" => "\u{FEEC}",
    "heiseierasquare" => "\u{337B}",
    "hekatakana" => "\u{30D8}",
    "hekatakanahalfwidth" => "\u{FF8D}",
    "hekutaarusquare" => "\u{3336}",
    "henghook" => "\u{0267}",
    "herutusquare" => "\u{3339}",
    "het" => "\u{05D7}",
    "hethebrew" => "\u{05D7}",
    "hhook" => "\u{0266}",
    "hhooksuperior" => "\u{02B1}",
    "hieuhacirclekorean" => "\u{327B}",
    "hieuhaparenkorean" => "\u{321B}",
    "hieuhcirclekorean" => "\u{326D}",
    "hieuhkorean" => "\u{314E}",
    "hieuhparenkorean" => "\u{320D}",
    "hihiragana" => "\u{3072}",
    "hikatakana" => "\u{30D2}",
    "hikatakanahalfwidth" => "\u{FF8B}",
    "hiriq" => "\u{05B4}",
    "hiriq14" => "\u{05B4}",
    "hiriq21" => "\u{05B4}",
    "hiriq2d" => "\u{05B4}",
    "hiriqhebrew" => "\u{05B4}",
    "hiriqnarrowhebrew" => "\u{05B4}",
    "hiriqquarterhebrew" => "\u{05B4}",
    "hiriqwidehebrew" => "\u{05B4}",
    "hlinebelow" => "\u{1E96}",
    "hmonospace" => "\u{FF48}",
    "hoarmenian" => "\u{0570}",
    "hohipthai" => "\u{0E2B}",
    "hohiragana" => "\u{307B}",
    "hokatakana" => "\u{30DB}",
    "hokatakanahalfwidth" => "\u{FF8E}",
    "holam" => "\u{05B9}",
    "holam19" => "\u{05B9}",
    "holam26" => "\u{05B9}",
    "holam32" => "\u{05B9}",
    "holamhebrew" => "\u{05B9}",
    "holamnarrowhebrew" => "\u{05B9}",
    "holamquarterhebrew" => "\u{05B9}",
    "holamwidehebrew" => "\u{05B9}",
    "honokhukthai" => "\u{0E2E}",
    "hookabovecomb" => "\u{0309}",
    "hookcmb" => "\u{0309}",
    "hookpalatalizedbelowcmb" => "\u{0321}",
    "hookretroflexbelowcmb" => "\u{0322}",
    "hoonsquare" => "\u{3342}",
    "horicoptic" => "\u{03E9}",
    "horizontalbar" => "\u{2015}",
    "horncmb" => "\u{031B}",
    "hotsprings" => "\u{2668}",
    "house" => "\u{2302}",
    "hparen" => "\u{24A3}",
    "hsuperior" => "\u{02B0}",
    "hturned" => "\u{0265}",
    "huhiragana" => "\u{3075}",
    "huiitosquare" => "\u{3333}",
    "hukatakana" => "\u{30D5}",
    "hukatakanahalfwidth" => "\u{FF8C}",
    "hungarumlaut" => "\u{02DD}",
    "hungarumlautcmb" => "\u{030B}",
    "hv" => "\u{0195}",
    "hyphen" => "\u{002D}",
    "hypheninferior" => "\u{F6E5}",
    "hyphenmonospace" => "\u{FF0D}",
    "hyphensmall" => "\u{FE63}",
    "hyphensuperior" => "\u{F6E6}",
    "hyphentwo" => "\u{2010}",
    "i" => "\u{0069}",
    "iacute" => "\u{00ED}",
    "iacyrillic" => "\u{044F}",
    "ibengali" => "\u{0987}",
    "ibopomofo" => "\u{3127}",
    "ibreve" => "\u{012D}",
    "icaron" => "\u{01D0}",
    "icircle" => "\u{24D8}",
    "icircumflex" => "\u{00EE}",
    "icyrillic" => "\u{0456}",
    "idblgrave" => "\u{0209}",
    "ideographearthcircle" => "\u{328F}",
    "ideographfirecircle" => "\u{328B}",
    "ideographicallianceparen" => "\u{323F}",
    "ideographiccallparen" => "\u{323A}",
    "ideographiccentrecircle" => "\u{32A5}",
    "ideographicclose" => "\u{3006}",
    "ideographiccomma" => "\u{3001}",
    "ideographiccommaleft" => "\u{FF64}",
    "ideographiccongratulationparen" => "\u{3237}",
    "ideographiccorrectcircle" => "\u{32A3}",
    "ideographicearthparen" => "\u{322F}",
    "ideographicenterpriseparen" => "\u{323D}",
    "ideographicexcellentcircle" => "\u{329D}",
    "ideographicfestivalparen" => "\u{3240}",
    "ideographicfinancialcircle" => "\u{3296}",
    "ideographicfinancialparen" => "\u{3236}",
    "ideographicfireparen" => "\u{322B}",
    "ideographichaveparen" => "\u{3232}",
    "ideographichighcircle" => "\u{32A4}",
    "ideographiciterationmark" => "\u{3005}",
    "ideographiclaborcircle" => "\u{3298}",
    "ideographiclaborparen" => "\u{3238}",
    "ideographicleftcircle" => "\u{32A7}",
    "ideographiclowcircle" => "\u{32A6}",
    "ideographicmedicinecircle" => "\u{32A9}",
    "ideographicmetalparen" => "\u{322E}",
    "ideographicmoonparen" => "\u{322A}",
    "ideographicnameparen" => "\u{3234}",
    "ideographicperiod" => "\u{3002}",
    "ideographicprintcircle" => "\u{329E}",
    "ideographicreachparen" => "\u{3243}",
    "ideographicrepresentparen" => "\u{3239}",
    "ideographicresourceparen" => "\u{323E}",
    "ideographicrightcircle" => "\u{32A8}",
    "ideographicsecretcircle" => "\u{3299}",
    "ideographicselfparen" => "\u{3242}",
    "ideographicsocietyparen" => "\u{3233}",
    "ideographicspace" => "\u{3000}",
    "ideographicspecialparen" => "\u{3235}",
    "ideographicstockparen" => "\u{3231}",
    "ideographicstudyparen" => "\u{323B}",
    "ideographicsunparen" => "\u{3230}",
    "ideographicsuperviseparen" => "\u{323C}",
    "ideographicwaterparen" => "\u{322C}",
    "ideographicwoodparen" => "\u{322D}",
    "ideographiczero" => "\u{3007}",
    "ideographmetalcircle" => "\u{328E}",
    "ideographmooncircle" => "\u{328A}",
    "ideographnamecircle" => "\u{3294}",
    "ideographsuncircle" => "\u{3290}",
    "ideographwatercircle" => "\u{328C}",
    "ideographwoodcircle" => "\u{328D}",
    "ideva" => "\u{0907}",
    "idieresis" => "\u{00EF}",
    "idieresisacute" => "\u{1E2F}",
    "idieresiscyrillic" => "\u{04E5}",
    "idotbelow" => "\u{1ECB}",
    "iebrevecyrillic" => "\u{04D7}",
    "iecyrillic" => "\u{0435}",
    "ieungacirclekorean" => "\u{3275}",
    "ieungaparenkorean" => "\u{3215}",
    "ieungcirclekorean" => "\u{3267}",
    "ieungkorean" => "\u{3147}",
    "ieungparenkorean" => "\u{3207}",
    "igrave" => "\u{00EC}",
    "igujarati" => "\u{0A87}",
    "igurmukhi" => "\u{0A07}",
    "ihiragana" => "\u{3044}",
    "ihookabove" => "\u{1EC9}",
    "iibengali" => "\u{0988}",
    "iicyrillic" => "\u{0438}",
    "iideva" => "\u{0908}",
    "iigujarati" => "\u{0A88}",
    "iigurmukhi" => "\u{0A08}",
    "iimatragurmukhi" => "\u{0A40}",
    "iinvertedbreve" => "\u{020B}",
    "iishortcyrillic" => "\u{0439}",
    "iivowelsignbengali" => "\u{09C0}",
    "iivowelsigndeva" => "\u{0940}",
    "iivowelsigngujarati" => "\u{0AC0}",
    "ij" => "\u{0133}",
    "ikatakana" => "\u{30A4}",
    "ikatakanahalfwidth" => "\u{FF72}",
    "ikorean" => "\u{3163}",
    "ilde" => "\u{02DC}",
    "iluyhebrew" => "\u{05AC}",
    "imacron" => "\u{012B}",
    "imacroncyrillic" => "\u{04E3}",
    "imageorapproximatelyequal" => "\u{2253}",
    "imatragurmukhi" => "\u{0A3F}",
    "imonospace" => "\u{FF49}",
    "increment" => "\u{2206}",
    "infinity" => "\u{221E}",
    "iniarmenian" => "\u{056B}",
    "integral" => "\u{222B}",
    "integralbottom" => "\u{2321}",
    "integralbt" => "\u{2321}",
    "integralex" => "\u{F8F5}",
    "integraltop" => "\u{2320}",
    "integraltp" => "\u{2320}",
    "intersection" => "\u{2229}",
    "intisquare" => "\u{3305}",
    "invbullet" => "\u{25D8}",
    "invcircle" => "\u{25D9}",
    "invsmileface" => "\u{263B}",
    "iocyrillic" => "\u{0451}",
    "iogonek" => "\u{012F}",
    "iota" => "\u{03B9}",
    "iotadieresis" => "\u{03CA}",
    "iotadieresistonos" => "\u{0390}",
    "iotalatin" => "\u{0269}",
    "iotatonos" => "\u{03AF}",
    "iparen" => "\u{24A4}",
    "irigurmukhi" => "\u{0A72}",
    "ismallhiragana" => "\u{3043}",
    "ismallkatakana" => "\u{30A3}",
    "ismallkatakanahalfwidth" => "\u{FF68}",
    "issharbengali" => "\u{09FA}",
    "istroke" => "\u{0268}",
    "isuperior" => "\u{F6ED}",
    "iterationhiragana" => "\u{309D}",
    "iterationkatakana" => "\u{30FD}",
    "itilde" => "\u{0129}",
    "itildebelow" => "\u{1E2D}",
    "iubopomofo" => "\u{3129}",
    "iucyrillic" => "\u{044E}",
    "ivowelsignbengali" => "\u{09BF}",
    "ivowelsigndeva" => "\u{093F}",
    "ivowelsigngujarati" => "\u{0ABF}",
    "izhitsacyrillic" => "\u{0475}",
    "izhitsadblgravecyrillic" => "\u{0477}",
    "j" => "\u{006A}",
    "jaarmenian" => "\u{0571}",
    "jabengali" => "\u{099C}",
    "jadeva" => "\u{091C}",
    "jagujarati" => "\u{0A9C}",
    "jagurmukhi" => "\u{0A1C}",
    "jbopomofo" => "\u{3110}",
    "jcaron" => "\u{01F0}",
    "jcircle" => "\u{24D9}",
    "jcircumflex" => "\u{0135}",
    "jcrossedtail" => "\u{029D}",
    "jdotlessstroke" => "\u{025F}",
    "jecyrillic" => "\u{0458}",
    "jeemarabic" => "\u{062C}",
    "jeemfinalarabic" => "\u{FE9E}",
    "jeeminitialarabic" => "\u{FE9F}",
    "jeemmedialarabic" => "\u{FEA0}",
    "jeharabic" => "\u{0698}",
    "jehfinalarabic" => "\u{FB8B}",
    "jhabengali" => "\u{099D}",
    "jhadeva" => "\u{091D}",
    "jhagujarati" => "\u{0A9D}",
    "jhagurmukhi" => "\u{0A1D}",
    "jheharmenian" => "\u{057B}",
    "jis" => "\u{3004}",
    "jmonospace" => "\u{FF4A}",
    "jparen" => "\u{24A5}",
    "jsuperior" => "\u{02B2}",
    "k" => "\u{006B}",
    "kabashkircyrillic" => "\u{04A1}",
    "kabengali" => "\u{0995}",
    "kacute" => "\u{1E31}",
    "kacyrillic" => "\u{043A}",
    "kadescendercyrillic" => "\u{049B}",
    "kadeva" => "\u{0915}",
    "kaf" => "\u{05DB}",
    "kafarabic" => "\u{0643}",
    "kafdagesh" => "\u{FB3B}",
    "kafdageshhebrew" => "\u{FB3B}",
    "kaffinalarabic" => "\u{FEDA}",
    "kafhebrew" => "\u{05DB}",
    "kafinitialarabic" => "\u{FEDB}",
    "kafmedialarabic" => "\u{FEDC}",
    "kafrafehebrew" => "\u{FB4D}",
    "kagujarati" => "\u{0A95}",
    "kagurmukhi" => "\u{0A15}",
    "kahiragana" => "\u{304B}",
    "kahookcyrillic" => "\u{04C4}",
    "kakatakana" => "\u{30AB}",
    "kakatakanahalfwidth" => "\u{FF76}",
    "kappa" => "\u{03BA}",
    "kappasymbolgreek" => "\u{03F0}",
    "kapyeounmieumkorean" => "\u{3171}",
    "kapyeounphieuphkorean" => "\u{3184}",
    "kapyeounpieupkorean" => "\u{3178}",
    "kapyeounssangpieupkorean" => "\u{3179}",
    "karoriisquare" => "\u{330D}",
    "kashidaautoarabic" => "\u{0640}",
    "kashidaautonosidebearingarabic" => "\u{0640}",
    "kasmallkatakana" => "\u{30F5}",
    "kasquare" => "\u{3384}",
    "kasraarabic" => "\u{0650}",
    "kasratanarabic" => "\u{064D}",
    "kastrokecyrillic" => "\u{049F}",
    "katahiraprolongmarkhalfwidth" => "\u{FF70}",
    "kaverticalstrokecyrillic" => "\u{049D}",
    "kbopomofo" => "\u{310E}",
    "kcalsquare" => "\u{3389}",
    "kcaron" => "\u{01E9}",
    "kcedilla" => "\u{0137}",
    "kcircle" => "\u{24DA}",
    "kcommaaccent" => "\u{0137}",
    "kdotbelow" => "\u{1E33}",
    "keharmenian" => "\u{0584}",
    "kehiragana" => "\u{3051}",
    "kekatakana" => "\u{30B1}",
    "kekatakanahalfwidth" => "\u{FF79}",
    "kenarmenian" => "\u{056F}",
    "kesmallkatakana" => "\u{30F6}",
    "kgreenlandic" => "\u{0138}",
    "khabengali" => "\u{0996}",
    "khacyrillic" => "\u{0445}",
    "khadeva" => "\u{0916}",
    "khagujarati" => "\u{0A96}",
    "khagurmukhi" => "\u{0A16}",
    "khaharabic" => "\u{062E}",
    "khahfinalarabic" => "\u{FEA6}",
    "khahinitialarabic" => "\u{FEA7}",
    "khahmedialarabic" => "\u{FEA8}",
    "kheicoptic" => "\u{03E7}",
    "khhadeva" => "\u{0959}",
    "khhagurmukhi" => "\u{0A59}",
    "khieukhacirclekorean" => "\u{3278}",
    "khieukhaparenkorean" => "\u{3218}",
    "khieukhcirclekorean" => "\u{326A}",
    "khieukhkorean" => "\u{314B}",
    "khieukhparenkorean" => "\u{320A}",
    "khokhaithai" => "\u{0E02}",
    "khokhonthai" => "\u{0E05}",
    "khokhuatthai" => "\u{0E03}",
    "khokhwaithai" => "\u{0E04}",
    "khomutthai" => "\u{0E5B}",
    "khook" => "\u{0199}",
    "khorakhangthai" => "\u{0E06}",
    "khzsquare" => "\u{3391}",
    "kihiragana" => "\u{304D}",
    "kikatakana" => "\u{30AD}",
    "kikatakanahalfwidth" => "\u{FF77}",
    "kiroguramusquare" => "\u{3315}",
    "kiromeetorusquare" => "\u{3316}",
    "kirosquare" => "\u{3314}",
    "kiyeokacirclekorean" => "\u{326E}",
    "kiyeokaparenkorean" => "\u{320E}",
    "kiyeokcirclekorean" => "\u{3260}",
    "kiyeokkorean" => "\u{3131}",
    "kiyeokparenkorean" => "\u{3200}",
    "kiyeoksioskorean" => "\u{3133}",
    "kjecyrillic" => "\u{045C}",
    "klinebelow" => "\u{1E35}",
    "klsquare" => "\u{3398}",
    "kmcubedsquare" => "\u{33A6}",
    "kmonospace" => "\u{FF4B}",
    "kmsquaredsquare" => "\u{33A2}",
    "kohiragana" => "\u{3053}",
    "kohmsquare" => "\u{33C0}",
    "kokaithai" => "\u{0E01}",
    "kokatakana" => "\u{30B3}",
    "kokatakanahalfwidth" => "\u{FF7A}",
    "kooposquare" => "\u{331E}",
    "koppacyrillic" => "\u{0481}",
    "koreanstandardsymbol" => "\u{327F}",
    "koroniscmb" => "\u{0343}",
    "kparen" => "\u{24A6}",
    "kpasquare" => "\u{33AA}",
    "ksicyrillic" => "\u{046F}",
    "ktsquare" => "\u{33CF}",
    "kturned" => "\u{029E}",
    "kuhiragana" => "\u{304F}",
    "kukatakana" => "\u{30AF}",
    "kukatakanahalfwidth" => "\u{FF78}",
    "kvsquare" => "\u{33B8}",
    "kwsquare" => "\u{33BE}",
    "l" => "\u{006C}",
    "labengali" => "\u{09B2}",
    "lacute" => "\u{013A}",
    "ladeva" => "\u{0932}",
    "lagujarati" => "\u{0AB2}",
    "lagurmukhi" => "\u{0A32}",
    "lakkhangyaothai" => "\u{0E45}",
    "lamaleffinalarabic" => "\u{FEFC}",
    "lamalefhamzaabovefinalarabic" => "\u{FEF8}",
    "lamalefhamzaaboveisolatedarabic" => "\u{FEF7}",
    "lamalefhamzabelowfinalarabic" => "\u{FEFA}",
    "lamalefhamzabelowisolatedarabic" => "\u{FEF9}",
    "lamalefisolatedarabic" => "\u{FEFB}",
    "lamalefmaddaabovefinalarabic" => "\u{FEF6}",
    "lamalefmaddaaboveisolatedarabic" => "\u{FEF5}",
    "lamarabic" => "\u{0644}",
    "lambda" => "\u{03BB}",
    "lambdastroke" => "\u{019B}",
    "lamed" => "\u{05DC}",
    "lameddagesh" => "\u{FB3C}",
    "lameddageshhebrew" => "\u{FB3C}",
    "lamedhebrew" => "\u{05DC}",
    "lamedholam" => "\u{05DC}\u{05B9}",
    "lamedholamdagesh" => "\u{05DC}\u{05B9}\u{05BC}",
    "lamedholamdageshhebrew" => "\u{05DC}\u{05B9}\u{05BC}",
    "lamedholamhebrew" => "\u{05DC}\u{05B9}",
    "lamfinalarabic" => "\u{FEDE}",
    "lamhahinitialarabic" => "\u{FCCA}",
    "laminitialarabic" => "\u{FEDF}",
    "lamjeeminitialarabic" => "\u{FCC9}",
    "lamkhahinitialarabic" => "\u{FCCB}",
    "lamlamhehisolatedarabic" => "\u{FDF2}",
    "lammedialarabic" => "\u{FEE0}",
    "lammeemhahinitialarabic" => "\u{FD88}",
    "lammeeminitialarabic" => "\u{FCCC}",
    "lammeemjeeminitialarabic" => "\u{FEDF}\u{FEE4}\u{FEA0}",
    "lammeemkhahinitialarabic" => "\u{FEDF}\u{FEE4}\u{FEA8}",
    "largecircle" => "\u{25EF}",
    "lbar" => "\u{019A}",
    "lbelt" => "\u{026C}",
    "lbopomofo" => "\u{310C}",
    "lcaron" => "\u{013E}",
    "lcedilla" => "\u{013C}",
    "lcircle" => "\u{24DB}",
    "lcircumflexbelow" => "\u{1E3D}",
    "lcommaaccent" => "\u{013C}",
    "ldot" => "\u{0140}",
    "ldotaccent" => "\u{0140}",
    "ldotbelow" => "\u{1E37}",
    "ldotbelowmacron" => "\u{1E39}",
    "leftangleabovecmb" => "\u{031A}",
    "lefttackbelowcmb" => "\u{0318}",
    "less" => "\u{003C}",
    "lessequal" => "\u{2264}",
    "lessequalorgreater" => "\u{22DA}",
    "lessmonospace" => "\u{FF1C}",
    "lessorequivalent" => "\u{2272}",
    "lessorgreater" => "\u{2276}",
    "lessoverequal" => "\u{2266}",
    "lesssmall" => "\u{FE64}",
    "lezh" => "\u{026E}",
    "lfblock" => "\u{258C}",
    "lhookretroflex" => "\u{026D}",
    "lira" => "\u{20A4}",
    "liwnarmenian" => "\u{056C}",
    "lj" => "\u{01C9}",
    "ljecyrillic" => "\u{0459}",
    "ll" => "\u{F6C0}",
    "lladeva" => "\u{0933}",
    "llagujarati" => "\u{0AB3}",
    "llinebelow" => "\u{1E3B}",
    "llladeva" => "\u{0934}",
    "llvocalicbengali" => "\u{09E1}",
    "llvocalicdeva" => "\u{0961}",
    "llvocalicvowelsignbengali" => "\u{09E3}",
    "llvocalicvowelsigndeva" => "\u{0963}",
    "lmiddletilde" => "\u{026B}",
    "lmonospace" => "\u{FF4C}",
    "lmsquare" => "\u{33D0}",
    "lochulathai" => "\u{0E2C}",
    "logicaland" => "\u{2227}",
    "logicalnot" => "\u{00AC}",
    "logicalnotreversed" => "\u{2310}",
    "logicalor" => "\u{2228}",
    "lolingthai" => "\u{0E25}",
    "longs" => "\u{017F}",
    "lowlinecenterline" => "\u{FE4E}",
    "lowlinecmb" => "\u{0332}",
    "lowlinedashed" => "\u{FE4D}",
    "lozenge" => "\u{25CA}",
    "lparen" => "\u{24A7}",
    "lslash" => "\u{0142}",
    "lsquare" => "\u{2113}",
    "lsuperior" => "\u{F6EE}",
    "ltshade" => "\u{2591}",
    "luthai" => "\u{0E26}",
    "lvocalicbengali" => "\u{098C}",
    "lvocalicdeva" => "\u{090C}",
    "lvocalicvowelsignbengali" => "\u{09E2}",
    "lvocalicvowelsigndeva" => "\u{0962}",
    "lxsquare" => "\u{33D3}",
    "m" => "\u{006D}",
    "mabengali" => "\u{09AE}",
    "macron" => "\u{00AF}",
    "macronbelowcmb" => "\u{0331}",
    "macroncmb" => "\u{0304}",
    "macronlowmod" => "\u{02CD}",
    "macronmonospace" => "\u{FFE3}",
    "macute" => "\u{1E3F}",
    "madeva" => "\u{092E}",
    "magujarati" => "\u{0AAE}",
    "magurmukhi" => "\u{0A2E}",
    "mahapakhhebrew" => "\u{05A4}",
    "mahapakhlefthebrew" => "\u{05A4}",
    "mahiragana" => "\u{307E}",
    "maichattawalowleftthai" => "\u{F895}",
    "maichattawalowrightthai" => "\u{F894}",
    "maichattawathai" => "\u{0E4B}",
    "maichattawaupperleftthai" => "\u{F893}",
    "maieklowleftthai" => "\u{F88C}",
    "maieklowrightthai" => "\u{F88B}",
    "maiekthai" => "\u{0E48}",
    "maiekupperleftthai" => "\u{F88A}",
    "maihanakatleftthai" => "\u{F884}",
    "maihanakatthai" => "\u{0E31}",
    "maitaikhuleftthai" => "\u{F889}",
    "maitaikhuthai" => "\u{0E47}",
    "maitholowleftthai" => "\u{F88F}",
    "maitholowrightthai" => "\u{F88E}",
    "maithothai" => "\u{0E49}",
    "maithoupperleftthai" => "\u{F88D}",
    "maitrilowleftthai" => "\u{F892}",
    "maitrilowrightthai" => "\u{F891}",
    "maitrithai" => "\u{0E4A}",
    "maitriupperleftthai" => "\u{F890}",
    "maiyamokthai" => "\u{0E46}",
    "makatakana" => "\u{30DE}",
    "makatakanahalfwidth" => "\u{FF8F}",
    "male" => "\u{2642}",
    "mansyonsquare" => "\u{3347}",
    "maqafhebrew" => "\u{05BE}",
    "mars" => "\u{2642}",
    "masoracirclehebrew" => "\u{05AF}",
    "masquare" => "\u{3383}",
    "mbopomofo" => "\u{3107}",
    "mbsquare" => "\u{33D4}",
    "mcircle" => "\u{24DC}",
    "mcubedsquare" => "\u{33A5}",
    "mdotaccent" => "\u{1E41}",
    "mdotbelow" => "\u{1E43}",
    "meemarabic" => "\u{0645}",
    "meemfinalarabic" => "\u{FEE2}",
    "meeminitialarabic" => "\u{FEE3}",
    "meemmedialarabic" => "\u{FEE4}",
    "meemmeeminitialarabic" => "\u{FCD1}",
    "meemmeemisolatedarabic" => "\u{FC48}",
    "meetorusquare" => "\u{334D}",
    "mehiragana" => "\u{3081}",
    "meizierasquare" => "\u{337E}",
    "mekatakana" => "\u{30E1}",
    "mekatakanahalfwidth" => "\u{FF92}",
    "mem" => "\u{05DE}",
    "memdagesh" => "\u{FB3E}",
    "memdageshhebrew" => "\u{FB3E}",
    "memhebrew" => "\u{05DE}",
    "menarmenian" => "\u{0574}",
    "merkhahebrew" => "\u{05A5}",
    "merkhakefulahebrew" => "\u{05A6}",
    "merkhakefulalefthebrew" => "\u{05A6}",
    "merkhalefthebrew" => "\u{05A5}",
    "mhook" => "\u{0271}",
    "mhzsquare" => "\u{3392}",
    "middledotkatakanahalfwidth" => "\u{FF65}",
    "middot" => "\u{00B7}",
    "mieumacirclekorean" => "\u{3272}",
    "mieumaparenkorean" => "\u{3212}",
    "mieumcirclekorean" => "\u{3264}",
    "mieumkorean" => "\u{3141}",
    "mieumpansioskorean" => "\u{3170}",
    "mieumparenkorean" => "\u{3204}",
    "mieumpieupkorean" => "\u{316E}",
    "mieumsioskorean" => "\u{316F}",
    "mihiragana" => "\u{307F}",
    "mikatakana" => "\u{30DF}",
    "mikatakanahalfwidth" => "\u{FF90}",
    "minus" => "\u{2212}",
    "minusbelowcmb" => "\u{0320}",
    "minuscircle" => "\u{2296}",
    "minusmod" => "\u{02D7}",
    "minusplus" => "\u{2213}",
    "minute" => "\u{2032}",
    "miribaarusquare" => "\u{334A}",
    "mirisquare" => "\u{3349}",
    "mlonglegturned" => "\u{0270}",
    "mlsquare" => "\u{3396}",
    "mmcubedsquare" => "\u{33A3}",
    "mmonospace" => "\u{FF4D}",
    "mmsquaredsquare" => "\u{339F}",
    "mohiragana" => "\u{3082}",
    "mohmsquare" => "\u{33C1}",
    "mokatakana" => "\u{30E2}",
    "mokatakanahalfwidth" => "\u{FF93}",
    "molsquare" => "\u{33D6}",
    "momathai" => "\u{0E21}",
    "moverssquare" => "\u{33A7}",
    "moverssquaredsquare" => "\u{33A8}",
    "mparen" => "\u{24A8}",
    "mpasquare" => "\u{33AB}",
    "mssquare" => "\u{33B3}",
    "msuperior" => "\u{F6EF}",
    "mturned" => "\u{026F}",
    "mu" => "\u{00B5}",
    "mu1" => "\u{00B5}",
    "muasquare" => "\u{3382}",
    "muchgreater" => "\u{226B}",
    "muchless" => "\u{226A}",
    "mufsquare" => "\u{338C}",
    "mugreek" => "\u{03BC}",
    "mugsquare" => "\u{338D}",
    "muhiragana" => "\u{3080}",
    "mukatakana" => "\u{30E0}",
    "mukatakanahalfwidth" => "\u{FF91}",
    "mulsquare" => "\u{3395}",
    "multiply" => "\u{00D7}",
    "mumsquare" => "\u{339B}",
    "munahhebrew" => "\u{05A3}",
    "munahlefthebrew" => "\u{05A3}",
    "musicalnote" => "\u{266A}",
    "musicalnotedbl" => "\u{266B}",
    "musicflatsign" => "\u{266D}",
    "musicsharpsign" => "\u{266F}",
    "mussquare" => "\u{33B2}",
    "muvsquare" => "\u{33B6}",
    "muwsquare" => "\u{33BC}",
    "mvmegasquare" => "\u{33B9}",
    "mvsquare" => "\u{33B7}",
    "mwmegasquare" => "\u{33BF}",
    "mwsquare" => "\u{33BD}",
    "n" => "\u{006E}",
    "nabengali" => "\u{09A8}",
    "nabla" => "\u{2207}",
    "nacute" => "\u{0144}",
    "nadeva" => "\u{0928}",
    "nagujarati" => "\u{0AA8}",
    "nagurmukhi" => "\u{0A28}",
    "nahiragana" => "\u{306A}",
    "nakatakana" => "\u{30CA}",
    "nakatakanahalfwidth" => "\u{FF85}",
    "napostrophe" => "\u{0149}",
    "nasquare" => "\u{3381}",
    "nbopomofo" => "\u{310B}",
    "nbspace" => "\u{00A0}",
    "ncaron" => "\u{0148}",
    "ncedilla" => "\u{0146}",
    "ncircle" => "\u{24DD}",
    "ncircumflexbelow" => "\u{1E4B}",
    "ncommaaccent" => "\u{0146}",
    "ndotaccent" => "\u{1E45}",
    "ndotbelow" => "\u{1E47}",
    "nehiragana" => "\u{306D}",
    "nekatakana" => "\u{30CD}",
    "nekatakanahalfwidth" => "\u{FF88}",
    "newsheqelsign" => "\u{20AA}",
    "nfsquare" => "\u{338B}",
    "ngabengali" => "\u{0999}",
    "ngadeva" => "\u{0919}",
    "ngagujarati" => "\u{0A99}",
    "ngagurmukhi" => "\u{0A19}",
    "ngonguthai" => "\u{0E07}",
    "nhiragana" => "\u{3093}",
    "nhookleft" => "\u{0272}",
    "nhookretroflex" => "\u{0273}",
    "nieunacirclekorean" => "\u{326F}",
    "nieunaparenkorean" => "\u{320F}",
    "nieuncieuckorean" => "\u{3135}",
    "nieuncirclekorean" => "\u{3261}",
    "nieunhieuhkorean" => "\u{3136}",
    "nieunkorean" => "\u{3134}",
    "nieunpansioskorean" => "\u{3168}",
    "nieunparenkorean" => "\u{3201}",
    "nieunsioskorean" => "\u{3167}",
    "nieuntikeutkorean" => "\u{3166}",
    "nihiragana" => "\u{306B}",
    "nikatakana" => "\u{30CB}",
    "nikatakanahalfwidth" => "\u{FF86}",
    "nikhahitleftthai" => "\u{F899}",
    "nikhahitthai" => "\u{0E4D}",
    "nine" => "\u{0039}",
    "ninearabic" => "\u{0669}",
    "ninebengali" => "\u{09EF}",
    "ninecircle" => "\u{2468}",
    "ninecircleinversesansserif" => "\u{2792}",
    "ninedeva" => "\u{096F}",
    "ninegujarati" => "\u{0AEF}",
    "ninegurmukhi" => "\u{0A6F}",
    "ninehackarabic" => "\u{0669}",
    "ninehangzhou" => "\u{3029}",
    "nineideographicparen" => "\u{3228}",
    "nineinferior" => "\u{2089}",
    "ninemonospace" => "\u{FF19}",
    "nineoldstyle" => "\u{F739}",
    "nineparen" => "\u{247C}",
    "nineperiod" => "\u{2490}",
    "ninepersian" => "\u{06F9}",
    "nineroman" => "\u{2178}",
    "ninesuperior" => "\u{2079}",
    "nineteencircle" => "\u{2472}",
    "nineteenparen" => "\u{2486}",
    "nineteenperiod" => "\u{249A}",
    "ninethai" => "\u{0E59}",
    "nj" => "\u{01CC}",
    "njecyrillic" => "\u{045A}",
    "nkatakana" => "\u{30F3}",
    "nkatakanahalfwidth" => "\u{FF9D}",
    "nlegrightlong" => "\u{019E}",
    "nlinebelow" => "\u{1E49}",
    "nmonospace" => "\u{FF4E}",
    "nmsquare" => "\u{339A}",
    "nnabengali" => "\u{09A3}",
    "nnadeva" => "\u{0923}",
    "nnagujarati" => "\u{0AA3}",
    "nnagurmukhi" => "\u{0A23}",
    "nnnadeva" => "\u{0929}",
    "nohiragana" => "\u{306E}",
    "nokatakana" => "\u{30CE}",
    "nokatakanahalfwidth" => "\u{FF89}",
    "nonbreakingspace" => "\u{00A0}",
    "nonenthai" => "\u{0E13}",
    "nonuthai" => "\u{0E19}",
    "noonarabic" => "\u{0646}",
    "noonfinalarabic" => "\u{FEE6}",
    "noonghunnaarabic" => "\u{06BA}",
    "noonghunnafinalarabic" => "\u{FB9F}",
    "noonhehinitialarabic" => "\u{FEE7}\u{FEEC}",
    "nooninitialarabic" => "\u{FEE7}",
    "noonjeeminitialarabic" => "\u{FCD2}",
    "noonjeemisolatedarabic" => "\u{FC4B}",
    "noonmedialarabic" => "\u{FEE8}",
    "noonmeeminitialarabic" => "\u{FCD5}",
    "noonmeemisolatedarabic" => "\u{FC4E}",
    "noonnoonfinalarabic" => "\u{FC8D}",
    "notcontains" => "\u{220C}",
    "notelement" => "\u{2209}",
    "notelementof" => "\u{2209}",
    "notequal" => "\u{2260}",
    "notgreater" => "\u{226F}",
    "notgreaternorequal" => "\u{2271}",
    "notgreaternorless" => "\u{2279}",
    "notidentical" => "\u{2262}",
    "notless" => "\u{226E}",
    "notlessnorequal" => "\u{2270}",
    "notparallel" => "\u{2226}",
    "notprecedes" => "\u{2280}",
    "notsubset" => "\u{2284}",
    "notsucceeds" => "\u{2281}",
    "notsuperset" => "\u{2285}",
    "nowarmenian" => "\u{0576}",
    "nparen" => "\u{24A9}",
    "nssquare" => "\u{33B1}",
    "nsuperior" => "\u{207F}",
    "ntilde" => "\u{00F1}",
    "nu" => "\u{03BD}",
    "nuhiragana" => "\u{306C}",
    "nukatakana" => "\u{30CC}",
    "nukatakanahalfwidth" => "\u{FF87}",
    "nuktabengali" => "\u{09BC}",
    "nuktadeva" => "\u{093C}",
    "nuktagujarati" => "\u{0ABC}",
    "nuktagurmukhi" => "\u{0A3C}",
    "numbersign" => "\u{0023}",
    "numbersignmonospace" => "\u{FF03}",
    "numbersignsmall" => "\u{FE5F}",
    "numeralsigngreek" => "\u{0374}",
    "numeralsignlowergreek" => "\u{0375}",
    "numero" => "\u{2116}",
    "nun" => "\u{05E0}",
    "nundagesh" => "\u{FB40}",
    "nundageshhebrew" => "\u{FB40}",
    "nunhebrew" => "\u{05E0}",
    "nvsquare" => "\u{33B5}",
    "nwsquare" => "\u{33BB}",
    "nyabengali" => "\u{099E}",
    "nyadeva" => "\u{091E}",
    "nyagujarati" => "\u{0A9E}",
    "nyagurmukhi" => "\u{0A1E}",
    "o" => "\u{006F}",
    "oacute" => "\u{00F3}",
    "oangthai" => "\u{0E2D}",
    "obarred" => "\u{0275}",
    "obarredcyrillic" => "\u{04E9}",
    "obarreddieresiscyrillic" => "\u{04EB}",
    "obengali" => "\u{0993}",
    "obopomofo" => "\u{311B}",
    "obreve" => "\u{014F}",
    "ocandradeva" => "\u{0911}",
    "ocandragujarati" => "\u{0A91}",
    "ocandravowelsigndeva" => "\u{0949}",
    "ocandravowelsigngujarati" => "\u{0AC9}",
    "ocaron" => "\u{01D2}",
    "ocircle" => "\u{24DE}",
    "ocircumflex" => "\u{00F4}",
    "ocircumflexacute" => "\u{1ED1}",
    "ocircumflexdotbelow" => "\u{1ED9}",
    "ocircumflexgrave" => "\u{1ED3}",
    "ocircumflexhookabove" => "\u{1ED5}",
    "ocircumflextilde" => "\u{1ED7}",
    "ocyrillic" => "\u{043E}",
    "odblacute" => "\u{0151}",
    "odblgrave" => "\u{020D}",
    "odeva" => "\u{0913}",
    "odieresis" => "\u{00F6}",
    "odieresiscyrillic" => "\u{04E7}",
    "odotbelow" => "\u{1ECD}",
    "oe" => "\u{0153}",
    "oekorean" => "\u{315A}",
    "ogonek" => "\u{02DB}",
    "ogonekcmb" => "\u{0328}",
    "ograve" => "\u{00F2}",
    "ogujarati" => "\u{0A93}",
    "oharmenian" => "\u{0585}",
    "ohiragana" => "\u{304A}",
    "ohookabove" => "\u{1ECF}",
    "ohorn" => "\u{01A1}",
    "ohornacute" => "\u{1EDB}",
    "ohorndotbelow" => "\u{1EE3}",
    "ohorngrave" => "\u{1EDD}",
    "ohornhookabove" => "\u{1EDF}",
    "ohorntilde" => "\u{1EE1}",
    "ohungarumlaut" => "\u{0151}",
    "oi" => "\u{01A3}",
    "oinvertedbreve" => "\u{020F}",
    "okatakana" => "\u{30AA}",
    "okatakanahalfwidth" => "\u{FF75}",
    "okorean" => "\u{3157}",
    "olehebrew" => "\u{05AB}",
    "omacron" => "\u{014D}",
    "omacronacute" => "\u{1E53}",
    "omacrongrave" => "\u{1E51}",
    "omdeva" => "\u{0950}",
    "omega" => "\u{03C9}",
    "omega1" => "\u{03D6}",
    "omegacyrillic" => "\u{0461}",
    "omegalatinclosed" => "\u{0277}",
    "omegaroundcyrillic" => "\u{047B}",
    "omegatitlocyrillic" => "\u{047D}",
    "omegatonos" => "\u{03CE}",
    "omgujarati" => "\u{0AD0}",
    "omicron" => "\u{03BF}",
    "omicrontonos" => "\u{03CC}",
    "omonospace" => "\u{FF4F}",
    "one" => "\u{0031}",
    "onearabic" => "\u{0661}",
    "onebengali" => "\u{09E7}",
    "onecircle" => "\u{2460}",
    "onecircleinversesansserif" => "\u{278A}",
    "onedeva" => "\u{0967}",
    "onedotenleader" => "\u{2024}",
    "oneeighth" => "\u{215B}",
    "onefitted" => "\u{F6DC}",
    "onegujarati" => "\u{0AE7}",
    "onegurmukhi" => "\u{0A67}",
    "onehackarabic" => "\u{0661}",
    "onehalf" => "\u{00BD}",
    "onehangzhou" => "\u{3021}",
    "oneideographicparen" => "\u{3220}",
    "oneinferior" => "\u{2081}",
    "onemonospace" => "\u{FF11}",
    "onenumeratorbengali" => "\u{09F4}",
    "oneoldstyle" => "\u{F731}",
    "oneparen" => "\u{2474}",
    "oneperiod" => "\u{2488}",
    "onepersian" => "\u{06F1}",
    "onequarter" => "\u{00BC}",
    "oneroman" => "\u{2170}",
    "onesuperior" => "\u{00B9}",
    "onethai" => "\u{0E51}",
    "onethird" => "\u{2153}",
    "oogonek" => "\u{01EB}",
    "oogonekmacron" => "\u{01ED}",
    "oogurmukhi" => "\u{0A13}",
    "oomatragurmukhi" => "\u{0A4B}",
    "oopen" => "\u{0254}",
    "oparen" => "\u{24AA}",
    "openbullet" => "\u{25E6}",
    "option" => "\u{2325}",
    "ordfeminine" => "\u{00AA}",
    "ordmasculine" => "\u{00BA}",
    "orthogonal" => "\u{221F}",
    "oshortdeva" => "\u{0912}",
    "oshortvowelsigndeva" => "\u{094A}",
    "oslash" => "\u{00F8}",
    "oslashacute" => "\u{01FF}",
    "osmallhiragana" => "\u{3049}",
    "osmallkatakana" => "\u{30A9}",
    "osmallkatakanahalfwidth" => "\u{FF6B}",
    "ostrokeacute" => "\u{01FF}",
    "osuperior" => "\u{F6F0}",
    "otcyrillic" => "\u{047F}",
    "otilde" => "\u{00F5}",
    "otildeacute" => "\u{1E4D}",
    "otildedieresis" => "\u{1E4F}",
    "oubopomofo" => "\u{3121}",
    "overline" => "\u{203E}",
    "overlinecenterline" => "\u{FE4A}",
    "overlinecmb" => "\u{0305}",
    "overlinedashed" => "\u{FE49}",
    "overlinedblwavy" => "\u{FE4C}",
    "overlinewavy" => "\u{FE4B}",
    "overscore" => "\u{00AF}",
    "ovowelsignbengali" => "\u{09CB}",
    "ovowelsigndeva" => "\u{094B}",
    "ovowelsigngujarati" => "\u{0ACB}",
    "p" => "\u{0070}",
    "paampssquare" => "\u{3380}",
    "paasentosquare" => "\u{332B}",
    "pabengali" => "\u{09AA}",
    "pacute" => "\u{1E55}",
    "padeva" => "\u{092A}",
    "pagedown" => "\u{21DF}",
    "pageup" => "\u{21DE}",
    "pagujarati" => "\u{0AAA}",
    "pagurmukhi" => "\u{0A2A}",
    "pahiragana" => "\u{3071}",
    "paiyannoithai" => "\u{0E2F}",
    "pakatakana" => "\u{30D1}",
    "palatalizationcyrilliccmb" => "\u{0484}",
    "palochkacyrillic" => "\u{04C0}",
    "pansioskorean" => "\u{317F}",
    "paragraph" => "\u{00B6}",
    "parallel" => "\u{2225}",
    "parenleft" => "\u{0028}",
    "parenleftaltonearabic" => "\u{FD3E}",
    "parenleftbt" => "\u{F8ED}",
    "parenleftex" => "\u{F8EC}",
    "parenleftinferior" => "\u{208D}",
    "parenleftmonospace" => "\u{FF08}",
    "parenleftsmall" => "\u{FE59}",
    "parenleftsuperior" => "\u{207D}",
    "parenlefttp" => "\u{F8EB}",
    "parenleftvertical" => "\u{FE35}",
    "parenright" => "\u{0029}",
    "parenrightaltonearabic" => "\u{FD3F}",
    "parenrightbt" => "\u{F8F8}",
    "parenrightex" => "\u{F8F7}",
    "parenrightinferior" => "\u{208E}",
    "parenrightmonospace" => "\u{FF09}",
    "parenrightsmall" => "\u{FE5A}",
    "parenrightsuperior" => "\u{207E}",
    "parenrighttp" => "\u{F8F6}",
    "parenrightvertical" => "\u{FE36}",
    "partialdiff" => "\u{2202}",
    "paseqhebrew" => "\u{05C0}",
    "pashtahebrew" => "\u{0599}",
    "pasquare" => "\u{33A9}",
    "patah" => "\u{05B7}",
    "patah11" => "\u{05B7}",
    "patah1d" => "\u{05B7}",
    "patah2a" => "\u{05B7}",
    "patahhebrew" => "\u{05B7}",
    "patahnarrowhebrew" => "\u{05B7}",
    "patahquarterhebrew" => "\u{05B7}",
    "patahwidehebrew" => "\u{05B7}",
    "pazerhebrew" => "\u{05A1}",
    "pbopomofo" => "\u{3106}",
    "pcircle" => "\u{24DF}",
    "pdotaccent" => "\u{1E57}",
    "pe" => "\u{05E4}",
    "pecyrillic" => "\u{043F}",
    "pedagesh" => "\u{FB44}",
    "pedageshhebrew" => "\u{FB44}",
    "peezisquare" => "\u{333B}",
    "pefinaldageshhebrew" => "\u{FB43}",
    "peharabic" => "\u{067E}",
    "peharmenian" => "\u{057A}",
    "pehebrew" => "\u{05E4}",
    "pehfinalarabic" => "\u{FB57}",
    "pehinitialarabic" => "\u{FB58}",
    "pehiragana" => "\u{307A}",
    "pehmedialarabic" => "\u{FB59}",
    "pekatakana" => "\u{30DA}",
    "pemiddlehookcyrillic" => "\u{04A7}",
    "perafehebrew" => "\u{FB4E}",
    "percent" => "\u{0025}",
    "percentarabic" => "\u{066A}",
    "percentmonospace" => "\u{FF05}",
    "percentsmall" => "\u{FE6A}",
    "period" => "\u{002E}",
    "periodarmenian" => "\u{0589}",
    "periodcentered" => "\u{00B7}",
    "periodhalfwidth" => "\u{FF61}",
    "periodinferior" => "\u{F6E7}",
    "periodmonospace" => "\u{FF0E}",
    "periodsmall" => "\u{FE52}",
    "periodsuperior" => "\u{F6E8}",
    "perispomenigreekcmb" => "\u{0342}",
    "perpendicular" => "\u{22A5}",
    "perthousand" => "\u{2030}",
    "peseta" => "\u{20A7}",
    "pfsquare" => "\u{338A}",
    "phabengali" => "\u{09AB}",
    "phadeva" => "\u{092B}",
    "phagujarati" => "\u{0AAB}",
    "phagurmukhi" => "\u{0A2B}",
    "phi" => "\u{03C6}",
    "phi1" => "\u{03D5}",
    "phieuphacirclekorean" => "\u{327A}",
    "phieuphaparenkorean" => "\u{321A}",
    "phieuphcirclekorean" => "\u{326C}",
    "phieuphkorean" => "\u{314D}",
    "phieuphparenkorean" => "\u{320C}",
    "philatin" => "\u{0278}",
    "phinthuthai" => "\u{0E3A}",
    "phisymbolgreek" => "\u{03D5}",
    "phook" => "\u{01A5}",
    "phophanthai" => "\u{0E1E}",
    "phophungthai" => "\u{0E1C}",
    "phosamphaothai" => "\u{0E20}",
    "pi" => "\u{03C0}",
    "pieupacirclekorean" => "\u{3273}",
    "pieupaparenkorean" => "\u{3213}",
    "pieupcieuckorean" => "\u{3176}",
    "pieupcirclekorean" => "\u{3265}",
    "pieupkiyeokkorean" => "\u{3172}",
    "pieupkorean" => "\u{3142}",
    "pieupparenkorean" => "\u{3205}",
    "pieupsioskiyeokkorean" => "\u{3174}",
    "pieupsioskorean" => "\u{3144}",
    "pieupsiostikeutkorean" => "\u{3175}",
    "pieupthieuthkorean" => "\u{3177}",
    "pieuptikeutkorean" => "\u{3173}",
    "pihiragana" => "\u{3074}",
    "pikatakana" => "\u{30D4}",
    "pisymbolgreek" => "\u{03D6}",
    "piwrarmenian" => "\u{0583}",
    "plus" => "\u{002B}",
    "plusbelowcmb" => "\u{031F}",
    "pluscircle" => "\u{2295}",
    "plusminus" => "\u{00B1}",
    "plusmod" => "\u{02D6}",
    "plusmonospace" => "\u{FF0B}",
    "plussmall" => "\u{FE62}",
    "plussuperior" => "\u{207A}",
    "pmonospace" => "\u{FF50}",
    "pmsquare" => "\u{33D8}",
    "pohiragana" => "\u{307D}",
    "pointingindexdownwhite" => "\u{261F}",
    "pointingindexleftwhite" => "\u{261C}",
    "pointingindexrightwhite" => "\u{261E}",
    "pointingindexupwhite" => "\u{261D}",
    "pokatakana" => "\u{30DD}",
    "poplathai" => "\u{0E1B}",
    "postalmark" => "\u{3012}",
    "postalmarkface" => "\u{3020}",
    "pparen" => "\u{24AB}",
    "precedes" => "\u{227A}",
    "prescription" => "\u{211E}",
    "primemod" => "\u{02B9}",
    "primereversed" => "\u{2035}",
    "product" => "\u{220F}",
    "projective" => "\u{2305}",
    "prolongedkana" => "\u{30FC}",
    "propellor" => "\u{2318}",
    "propersubset" => "\u{2282}",
    "propersuperset" => "\u{2283}",
    "proportion" => "\u{2237}",
    "proportional" => "\u{221D}",
    "psi" => "\u{03C8}",
    "psicyrillic" => "\u{0471}",
    "psilipneumatacyrilliccmb" => "\u{0486}",
    "pssquare" => "\u{33B0}",
    "puhiragana" => "\u{3077}",
    "pukatakana" => "\u{30D7}",
    "pvsquare" => "\u{33B4}",
    "pwsquare" => "\u{33BA}",
    "q" => "\u{0071}",
    "qadeva" => "\u{0958}",
    "qadmahebrew" => "\u{05A8}",
    "qafarabic" => "\u{0642}",
    "qaffinalarabic" => "\u{FED6}",
    "qafinitialarabic" => "\u{FED7}",
    "qafmedialarabic" => "\u{FED8}",
    "qamats" => "\u{05B8}",
    "qamats10" => "\u{05B8}",
    "qamats1a" => "\u{05B8}",
    "qamats1c" => "\u{05B8}",
    "qamats27" => "\u{05B8}",
    "qamats29" => "\u{05B8}",
    "qamats33" => "\u{05B8}",
    "qamatsde" => "\u{05B8}",
    "qamatshebrew" => "\u{05B8}",
    "qamatsnarrowhebrew" => "\u{05B8}",
    "qamatsqatanhebrew" => "\u{05B8}",
    "qamatsqatannarrowhebrew" => "\u{05B8}",
    "qamatsqatanquarterhebrew" => "\u{05B8}",
    "qamatsqatanwidehebrew" => "\u{05B8}",
    "qamatsquarterhebrew" => "\u{05B8}",
    "qamatswidehebrew" => "\u{05B8}",
    "qarneyparahebrew" => "\u{059F}",
    "qbopomofo" => "\u{3111}",
    "qcircle" => "\u{24E0}",
    "qhook" => "\u{02A0}",
    "qmonospace" => "\u{FF51}",
    "qof" => "\u{05E7}",
    "qofdagesh" => "\u{FB47}",
    "qofdageshhebrew" => "\u{FB47}",
    "qofhatafpatah" => "\u{05E7}\u{05B2}",
    "qofhatafpatahhebrew" => "\u{05E7}\u{05B2}",
    "qofhatafsegol" => "\u{05E7}\u{05B1}",
    "qofhatafsegolhebrew" => "\u{05E7}\u{05B1}",
    "qofhebrew" => "\u{05E7}",
    "qofhiriq" => "\u{05E7}\u{05B4}",
    "qofhiriqhebrew" => "\u{05E7}\u{05B4}",
    "qofholam" => "\u{05E7}\u{05B9}",
    "qofholamhebrew" => "\u{05E7}\u{05B9}",
    "qofpatah" => "\u{05E7}\u{05B7}",
    "qofpatahhebrew" => "\u{05E7}\u{05B7}",
    "qofqamats" => "\u{05E7}\u{05B8}",
    "qofqamatshebrew" => "\u{05E7}\u{05B8}",
    "qofqubuts" => "\u{05E7}\u{05BB}",
    "qofqubutshebrew" => "\u{05E7}\u{05BB}",
    "qofsegol" => "\u{05E7}\u{05B6}",
    "qofsegolhebrew" => "\u{05E7}\u{05B6}",
    "qofsheva" => "\u{05E7}\u{05B0}",
    "qofshevahebrew" => "\u{05E7}\u{05B0}",
    "qoftsere" => "\u{05E7}\u{05B5}",
    "qoftserehebrew" => "\u{05E7}\u{05B5}",
    "qparen" => "\u{24AC}",
    "quarternote" => "\u{2669}",
    "qubuts" => "\u{05BB}",
    "qubuts18" => "\u{05BB}",
    "qubuts25" => "\u{05BB}",
    "qubuts31" => "\u{05BB}",
    "qubutshebrew" => "\u{05BB}",
    "qubutsnarrowhebrew" => "\u{05BB}",
    "qubutsquarterhebrew" => "\u{05BB}",
    "qubutswidehebrew" => "\u{05BB}",
    "question" => "\u{003F}",
    "questionarabic" => "\u{061F}",
    "questionarmenian" => "\u{055E}",
    "questiondown" => "\u{00BF}",
    "questiondownsmall" => "\u{F7BF}",
    "questiongreek" => "\u{037E}",
    "questionmonospace" => "\u{FF1F}",
    "questionsmall" => "\u{F73F}",
    "quotedbl" => "\u{0022}",
    "quotedblbase" => "\u{201E}",
    "quotedblleft" => "\u{201C}",
    "quotedblmonospace" => "\u{FF02}",
    "quotedblprime" => "\u{301E}",
    "quotedblprimereversed" => "\u{301D}",
    "quotedblright" => "\u{201D}",
    "quoteleft" => "\u{2018}",
    "quoteleftreversed" => "\u{201B}",
    "quotereversed" => "\u{201B}",
    "quoteright" => "\u{2019}",
    "quoterightn" => "\u{0149}",
    "quotesinglbase" => "\u{201A}",
    "quotesingle" => "\u{0027}",
    "quotesinglemonospace" => "\u{FF07}",
    "r" => "\u{0072}",
    "raarmenian" => "\u{057C}",
    "rabengali" => "\u{09B0}",
    "racute" => "\u{0155}",
    "radeva" => "\u{0930}",
    "radical" => "\u{221A}",
    "radicalex" => "\u{F8E5}",
    "radoverssquare" => "\u{33AE}",
    "radoverssquaredsquare" => "\u{33AF}",
    "radsquare" => "\u{33AD}",
    "rafe" => "\u{05BF}",
    "rafehebrew" => "\u{05BF}",
    "ragujarati" => "\u{0AB0}",
    "ragurmukhi" => "\u{0A30}",
    "rahiragana" => "\u{3089}",
    "rakatakana" => "\u{30E9}",
    "rakatakanahalfwidth" => "\u{FF97}",
    "ralowerdiagonalbengali" => "\u{09F1}",
    "ramiddlediagonalbengali" => "\u{09F0}",
    "ramshorn" => "\u{0264}",
    "ratio" => "\u{2236}",
    "rbopomofo" => "\u{3116}",
    "rcaron" => "\u{0159}",
    "rcedilla" => "\u{0157}",
    "rcircle" => "\u{24E1}",
    "rcommaaccent" => "\u{0157}",
    "rdblgrave" => "\u{0211}",
    "rdotaccent" => "\u{1E59}",
    "rdotbelow" => "\u{1E5B}",
    "rdotbelowmacron" => "\u{1E5D}",
    "referencemark" => "\u{203B}",
    "reflexsubset" => "\u{2286}",
    "reflexsuperset" => "\u{2287}",
    "registered" => "\u{00AE}",
    "registersans" => "\u{F8E8}",
    "registerserif" => "\u{F6DA}",
    "reharabic" => "\u{0631}",
    "reharmenian" => "\u{0580}",
    "rehfinalarabic" => "\u{FEAE}",
    "rehiragana" => "\u{308C}",
    "rehyehaleflamarabic" => "\u{0631}\u{FEF3}\u{FE8E}\u{0644}",
    "rekatakana" => "\u{30EC}",
    "rekatakanahalfwidth" => "\u{FF9A}",
    "resh" => "\u{05E8}",
    "reshdageshhebrew" => "\u{FB48}",
    "reshhatafpatah" => "\u{05E8}\u{05B2}",
    "reshhatafpatahhebrew" => "\u{05E8}\u{05B2}",
    "reshhatafsegol" => "\u{05E8}\u{05B1}",
    "reshhatafsegolhebrew" => "\u{05E8}\u{05B1}",
    "reshhebrew" => "\u{05E8}",
    "reshhiriq" => "\u{05E8}\u{05B4}",
    "reshhiriqhebrew" => "\u{05E8}\u{05B4}",
    "reshholam" => "\u{05E8}\u{05B9}",
    "reshholamhebrew" => "\u{05E8}\u{05B9}",
    "reshpatah" => "\u{05E8}\u{05B7}",
    "reshpatahhebrew" => "\u{05E8}\u{05B7}",
    "reshqamats" => "\u{05E8}\u{05B8}",
    "reshqamatshebrew" => "\u{05E8}\u{05B8}",
    "reshqubuts" => "\u{05E8}\u{05BB}",
    "reshqubutshebrew" => "\u{05E8}\u{05BB}",
    "reshsegol" => "\u{05E8}\u{05B6}",
    "reshsegolhebrew" => "\u{05E8}\u{05B6}",
    "reshsheva" => "\u{05E8}\u{05B0}",
    "reshshevahebrew" => "\u{05E8}\u{05B0}",
    "reshtsere" => "\u{05E8}\u{05B5}",
    "reshtserehebrew" => "\u{05E8}\u{05B5}",
    "reversedtilde" => "\u{223D}",
    "reviahebrew" => "\u{0597}",
    "reviamugrashhebrew" => "\u{0597}",
    "revlogicalnot" => "\u{2310}",
    "rfishhook" => "\u{027E}",
    "rfishhookreversed" => "\u{027F}",
    "rhabengali" => "\u{09DD}",
    "rhadeva" => "\u{095D}",
    "rho" => "\u{03C1}",
    "rhook" => "\u{027D}",
    "rhookturned" => "\u{027B}",
    "rhookturnedsuperior" => "\u{02B5}",
    "rhosymbolgreek" => "\u{03F1}",
    "rhotichookmod" => "\u{02DE}",
    "rieulacirclekorean" => "\u{3271}",
    "rieulaparenkorean" => "\u{3211}",
    "rieulcirclekorean" => "\u{3263}",
    "rieulhieuhkorean" => "\u{3140}",
    "rieulkiyeokkorean" => "\u{313A}",
    "rieulkiyeoksioskorean" => "\u{3169}",
    "rieulkorean" => "\u{3139}",
    "rieulmieumkorean" => "\u{313B}",
    "rieulpansioskorean" => "\u{316C}",
    "rieulparenkorean" => "\u{3203}",
    "rieulphieuphkorean" => "\u{313F}",
    "rieulpieupkorean" => "\u{313C}",
    "rieulpieupsioskorean" => "\u{316B}",
    "rieulsioskorean" => "\u{313D}",
    "rieulthieuthkorean" => "\u{313E}",
    "rieultikeutkorean" => "\u{316A}",
    "rieulyeorinhieuhkorean" => "\u{316D}",
    "rightangle" => "\u{221F}",
    "righttackbelowcmb" => "\u{0319}",
    "righttriangle" => "\u{22BF}",
    "rihiragana" => "\u{308A}",
    "rikatakana" => "\u{30EA}",
    "rikatakanahalfwidth" => "\u{FF98}",
    "ring" => "\u{02DA}",
    "ringbelowcmb" => "\u{0325}",
    "ringcmb" => "\u{030A}",
    "ringhalfleft" => "\u{02BF}",
    "ringhalfleftarmenian" => "\u{0559}",
    "ringhalfleftbelowcmb" => "\u{031C}",
    "ringhalfleftcentered" => "\u{02D3}",
    "ringhalfright" => "\u{02BE}",
    "ringhalfrightbelowcmb" => "\u{0339}",
    "ringhalfrightcentered" => "\u{02D2}",
    "rinvertedbreve" => "\u{0213}",
    "rittorusquare" => "\u{3351}",
    "rlinebelow" => "\u{1E5F}",
    "rlongleg" => "\u{027C}",
    "rlonglegturned" => "\u{027A}",
    "rmonospace" => "\u{FF52}",
    "rohiragana" => "\u{308D}",
    "rokatakana" => "\u{30ED}",
    "rokatakanahalfwidth" => "\u{FF9B}",
    "roruathai" => "\u{0E23}",
    "rparen" => "\u{24AD}",
    "rrabengali" => "\u{09DC}",
    "rradeva" => "\u{0931}",
    "rragurmukhi" => "\u{0A5C}",
    "rreharabic" => "\u{0691}",
    "rrehfinalarabic" => "\u{FB8D}",
    "rrvocalicbengali" => "\u{09E0}",
    "rrvocalicdeva" => "\u{0960}",
    "rrvocalicgujarati" => "\u{0AE0}",
    "rrvocalicvowelsignbengali" => "\u{09C4}",
    "rrvocalicvowelsigndeva" => "\u{0944}",
    "rrvocalicvowelsigngujarati" => "\u{0AC4}",
    "rsuperior" => "\u{F6F1}",
    "rtblock" => "\u{2590}",
    "rturned" => "\u{0279}",
    "rturnedsuperior" => "\u{02B4}",
    "ruhiragana" => "\u{308B}",
    "rukatakana" => "\u{30EB}",
    "rukatakanahalfwidth" => "\u{FF99}",
    "rupeemarkbengali" => "\u{09F2}",
    "rupeesignbengali" => "\u{09F3}",
    "rupiah" => "\u{F6DD}",
    "ruthai" => "\u{0E24}",
    "rvocalicbengali" => "\u{098B}",
    "rvocalicdeva" => "\u{090B}",
    "rvocalicgujarati" => "\u{0A8B}",
    "rvocalicvowelsignbengali" => "\u{09C3}",
    "rvocalicvowelsigndeva" => "\u{0943}",
    "rvocalicvowelsigngujarati" => "\u{0AC3}",
    "s" => "\u{0073}",
    "sabengali" => "\u{09B8}",
    "sacute" => "\u{015B}",
    "sacutedotaccent" => "\u{1E65}",
    "sadarabic" => "\u{0635}",
    "sadeva" => "\u{0938}",
    "sadfinalarabic" => "\u{FEBA}",
    "sadinitialarabic" => "\u{FEBB}",
    "sadmedialarabic" => "\u{FEBC}",
    "sagujarati" => "\u{0AB8}",
    "sagurmukhi" => "\u{0A38}",
    "sahiragana" => "\u{3055}",
    "sakatakana" => "\u{30B5}",
    "sakatakanahalfwidth" => "\u{FF7B}",
    "sallallahoualayhewasallamarabic" => "\u{FDFA}",
    "samekh" => "\u{05E1}",
    "samekhdagesh" => "\u{FB41}",
    "samekhdageshhebrew" => "\u{FB41}",
    "samekhhebrew" => "\u{05E1}",
    "saraaathai" => "\u{0E32}",
    "saraaethai" => "\u{0E41}",
    "saraaimaimalaithai" => "\u{0E44}",
    "saraaimaimuanthai" => "\u{0E43}",
    "saraamthai" => "\u{0E33}",
    "saraathai" => "\u{0E30}",
    "saraethai" => "\u{0E40}",
    "saraiileftthai" => "\u{F886}",
    "saraiithai" => "\u{0E35}",
    "saraileftthai" => "\u{F885}",
    "saraithai" => "\u{0E34}",
    "saraothai" => "\u{0E42}",
    "saraueeleftthai" => "\u{F888}",
    "saraueethai" => "\u{0E37}",
    "saraueleftthai" => "\u{F887}",
    "sarauethai" => "\u{0E36}",
    "sarauthai" => "\u{0E38}",
    "sarauuthai" => "\u{0E39}",
    "sbopomofo" => "\u{3119}",
    "scaron" => "\u{0161}",
    "scarondotaccent" => "\u{1E67}",
    "scedilla" => "\u{015F}",
    "schwa" => "\u{0259}",
    "schwacyrillic" => "\u{04D9}",
    "schwadieresiscyrillic" => "\u{04DB}",
    "schwahook" => "\u{025A}",
    "scircle" => "\u{24E2}",
    "scircumflex" => "\u{015D}",
    "scommaaccent" => "\u{0219}",
    "sdotaccent" => "\u{1E61}",
    "sdotbelow" => "\u{1E63}",
    "sdotbelowdotaccent" => "\u{1E69}",
    "seagullbelowcmb" => "\u{033C}",
    "second" => "\u{2033}",
    "secondtonechinese" => "\u{02CA}",
    "section" => "\u{00A7}",
    "seenarabic" => "\u{0633}",
    "seenfinalarabic" => "\u{FEB2}",
    "seeninitialarabic" => "\u{FEB3}",
    "seenmedialarabic" => "\u{FEB4}",
    "segol" => "\u{05B6}",
    "segol13" => "\u{05B6}",
    "segol1f" => "\u{05B6}",
    "segol2c" => "\u{05B6}",
    "segolhebrew" => "\u{05B6}",
    "segolnarrowhebrew" => "\u{05B6}",
    "segolquarterhebrew" => "\u{05B6}",
    "segoltahebrew" => "\u{0592}",
    "segolwidehebrew" => "\u{05B6}",
    "seharmenian" => "\u{057D}",
    "sehiragana" => "\u{305B}",
    "sekatakana" => "\u{30BB}",
    "sekatakanahalfwidth" => "\u{FF7E}",
    "semicolon" => "\u{003B}",
    "semicolonarabic" => "\u{061B}",
    "semicolonmonospace" => "\u{FF1B}",
    "semicolonsmall" => "\u{FE54}",
    "semivoicedmarkkana" => "\u{309C}",
    "semivoicedmarkkanahalfwidth" => "\u{FF9F}",
    "sentisquare" => "\u{3322}",
    "sentosquare" => "\u{3323}",
    "seven" => "\u{0037}",
    "sevenarabic" => "\u{0667}",
    "sevenbengali" => "\u{09ED}",
    "sevencircle" => "\u{2466}",
    "sevencircleinversesansserif" => "\u{2790}",
    "sevendeva" => "\u{096D}",
    "seveneighths" => "\u{215E}",
    "sevengujarati" => "\u{0AED}",
    "sevengurmukhi" => "\u{0A6D}",
    "sevenhackarabic" => "\u{0667}",
    "sevenhangzhou" => "\u{3027}",
    "sevenideographicparen" => "\u{3226}",
    "seveninferior" => "\u{2087}",
    "sevenmonospace" => "\u{FF17}",
    "sevenoldstyle" => "\u{F737}",
    "sevenparen" => "\u{247A}",
    "sevenperiod" => "\u{248E}",
    "sevenpersian" => "\u{06F7}",
    "sevenroman" => "\u{2176}",
    "sevensuperior" => "\u{2077}",
    "seventeencircle" => "\u{2470}",
    "seventeenparen" => "\u{2484}",
    "seventeenperiod" => "\u{2498}",
    "seventhai" => "\u{0E57}",
    "sfthyphen" => "\u{00AD}",
    "shaarmenian" => "\u{0577}",
    "shabengali" => "\u{09B6}",
    "shacyrillic" => "\u{0448}",
    "shaddaarabic" => "\u{0651}",
    "shaddadammaarabic" => "\u{FC61}",
    "shaddadammatanarabic" => "\u{FC5E}",
    "shaddafathaarabic" => "\u{FC60}",
    "shaddafathatanarabic" => "\u{0651}\u{064B}",
    "shaddakasraarabic" => "\u{FC62}",
    "shaddakasratanarabic" => "\u{FC5F}",
    "shade" => "\u{2592}",
    "shadedark" => "\u{2593}",
    "shadelight" => "\u{2591}",
    "shademedium" => "\u{2592}",
    "shadeva" => "\u{0936}",
    "shagujarati" => "\u{0AB6}",
    "shagurmukhi" => "\u{0A36}",
    "shalshelethebrew" => "\u{0593}",
    "shbopomofo" => "\u{3115}",
    "shchacyrillic" => "\u{0449}",
    "sheenarabic" => "\u{0634}",
    "sheenfinalarabic" => "\u{FEB6}",
    "sheeninitialarabic" => "\u{FEB7}",
    "sheenmedialarabic" => "\u{FEB8}",
    "sheicoptic" => "\u{03E3}",
    "sheqel" => "\u{20AA}",
    "sheqelhebrew" => "\u{20AA}",
    "sheva" => "\u{05B0}",
    "sheva115" => "\u{05B0}",
    "sheva15" => "\u{05B0}",
    "sheva22" => "\u{05B0}",
    "sheva2e" => "\u{05B0}",
    "shevahebrew" => "\u{05B0}",
    "shevanarrowhebrew" => "\u{05B0}",
    "shevaquarterhebrew" => "\u{05B0}",
    "shevawidehebrew" => "\u{05B0}",
    "shhacyrillic" => "\u{04BB}",
    "shimacoptic" => "\u{03ED}",
    "shin" => "\u{05E9}",
    "shindagesh" => "\u{FB49}",
    "shindageshhebrew" => "\u{FB49}",
    "shindageshshindot" => "\u{FB2C}",
    "shindageshshindothebrew" => "\u{FB2C}",
    "shindageshsindot" => "\u{FB2D}",
    "shindageshsindothebrew" => "\u{FB2D}",
    "shindothebrew" => "\u{05C1}",
    "shinhebrew" => "\u{05E9}",
    "shinshindot" => "\u{FB2A}",
    "shinshindothebrew" => "\u{FB2A}",
    "shinsindot" => "\u{FB2B}",
    "shinsindothebrew" => "\u{FB2B}",
    "shook" => "\u{0282}",
    "sigma" => "\u{03C3}",
    "sigma1" => "\u{03C2}",
    "sigmafinal" => "\u{03C2}",
    "sigmalunatesymbolgreek" => "\u{03F2}",
    "sihiragana" => "\u{3057}",
    "sikatakana" => "\u{30B7}",
    "sikatakanahalfwidth" => "\u{FF7C}",
    "siluqhebrew" => "\u{05BD}",
    "siluqlefthebrew" => "\u{05BD}",
    "similar" => "\u{223C}",
    "sindothebrew" => "\u{05C2}",
    "siosacirclekorean" => "\u{3274}",
    "siosaparenkorean" => "\u{3214}",
    "sioscieuckorean" => "\u{317E}",
    "sioscirclekorean" => "\u{3266}",
    "sioskiyeokkorean" => "\u{317A}",
    "sioskorean" => "\u{3145}",
    "siosnieunkorean" => "\u{317B}",
    "siosparenkorean" => "\u{3206}",
    "siospieupkorean" => "\u{317D}",
    "siostikeutkorean" => "\u{317C}",
    "six" => "\u{0036}",
    "sixarabic" => "\u{0666}",
    "sixbengali" => "\u{09EC}",
    "sixcircle" => "\u{2465}",
    "sixcircleinversesansserif" => "\u{278F}",
    "sixdeva" => "\u{096C}",
    "sixgujarati" => "\u{0AEC}",
    "sixgurmukhi" => "\u{0A6C}",
    "sixhackarabic" => "\u{0666}",
    "sixhangzhou" => "\u{3026}",
    "sixideographicparen" => "\u{3225}",
    "sixinferior" => "\u{2086}",
    "sixmonospace" => "\u{FF16}",
    "sixoldstyle" => "\u{F736}",
    "sixparen" => "\u{2479}",
    "sixperiod" => "\u{248D}",
    "sixpersian" => "\u{06F6}",
    "sixroman" => "\u{2175}",
    "sixsuperior" => "\u{2076}",
    "sixteencircle" => "\u{246F}",
    "sixteencurrencydenominatorbengali" => "\u{09F9}",
    "sixteenparen" => "\u{2483}",
    "sixteenperiod" => "\u{2497}",
    "sixthai" => "\u{0E56}",
    "slash" => "\u{002F}",
    "slashmonospace" => "\u{FF0F}",
    "slong" => "\u{017F}",
    "slongdotaccent" => "\u{1E9B}",
    "smileface" => "\u{263A}",
    "smonospace" => "\u{FF53}",
    "sofpasuqhebrew" => "\u{05C3}",
    "softhyphen" => "\u{00AD}",
    "softsigncyrillic" => "\u{044C}",
    "sohiragana" => "\u{305D}",
    "sokatakana" => "\u{30BD}",
    "sokatakanahalfwidth" => "\u{FF7F}",
    "soliduslongoverlaycmb" => "\u{0338}",
    "solidusshortoverlaycmb" => "\u{0337}",
    "sorusithai" => "\u{0E29}",
    "sosalathai" => "\u{0E28}",
    "sosothai" => "\u{0E0B}",
    "sosuathai" => "\u{0E2A}",
    "space" => "\u{0020}",
    "spacehackarabic" => "\u{0020}",
    "spade" => "\u{2660}",
    "spadesuitblack" => "\u{2660}",
    "spadesuitwhite" => "\u{2664}",
    "sparen" => "\u{24AE}",
    "squarebelowcmb" => "\u{033B}",
    "squarecc" => "\u{33C4}",
    "squarecm" => "\u{339D}",
    "squarediagonalcrosshatchfill" => "\u{25A9}",
    "squarehorizontalfill" => "\u{25A4}",
    "squarekg" => "\u{338F}",
    "squarekm" => "\u{339E}",
    "squarekmcapital" => "\u{33CE}",
    "squareln" => "\u{33D1}",
    "squarelog" => "\u{33D2}",
    "squaremg" => "\u{338E}",
    "squaremil" => "\u{33D5}",
    "squaremm" => "\u{339C}",
    "squaremsquared" => "\u{33A1}",
    "squareorthogonalcrosshatchfill" => "\u{25A6}",
    "squareupperlefttolowerrightfill" => "\u{25A7}",
    "squareupperrighttolowerleftfill" => "\u{25A8}",
    "squareverticalfill" => "\u{25A5}",
    "squarewhitewithsmallblack" => "\u{25A3}",
    "srsquare" => "\u{33DB}",
    "ssabengali" => "\u{09B7}",
    "ssadeva" => "\u{0937}",
    "ssagujarati" => "\u{0AB7}",
    "ssangcieuckorean" => "\u{3149}",
    "ssanghieuhkorean" => "\u{3185}",
    "ssangieungkorean" => "\u{3180}",
    "ssangkiyeokkorean" => "\u{3132}",
    "ssangnieunkorean" => "\u{3165}",
    "ssangpieupkorean" => "\u{3143}",
    "ssangsioskorean" => "\u{3146}",
    "ssangtikeutkorean" => "\u{3138}",
    "ssuperior" => "\u{F6F2}",
    "sterling" => "\u{00A3}",
    "sterlingmonospace" => "\u{FFE1}",
    "strokelongoverlaycmb" => "\u{0336}",
    "strokeshortoverlaycmb" => "\u{0335}",
    "subset" => "\u{2282}",
    "subsetnotequal" => "\u{228A}",
    "subsetorequal" => "\u{2286}",
    "succeeds" => "\u{227B}",
    "suchthat" => "\u{220B}",
    "suhiragana" => "\u{3059}",
    "sukatakana" => "\u{30B9}",
    "sukatakanahalfwidth" => "\u{FF7D}",
    "sukunarabic" => "\u{0652}",
    "summation" => "\u{2211}",
    "sun" => "\u{263C}",
    "superset" => "\u{2283}",
    "supersetnotequal" => "\u{228B}",
    "supersetorequal" => "\u{2287}",
    "svsquare" => "\u{33DC}",
    "syouwaerasquare" => "\u{337C}",
    "t" => "\u{0074}",
    "tabengali" => "\u{09A4}",
    "tackdown" => "\u{22A4}",
    "tackleft" => "\u{22A3}",
    "tadeva" => "\u{0924}",
    "tagujarati" => "\u{0AA4}",
    "tagurmukhi" => "\u{0A24}",
    "taharabic" => "\u{0637}",
    "tahfinalarabic" => "\u{FEC2}",
    "tahinitialarabic" => "\u{FEC3}",
    "tahiragana" => "\u{305F}",
    "tahmedialarabic" => "\u{FEC4}",
    "taisyouerasquare" => "\u{337D}",
    "takatakana" => "\u{30BF}",
    "takatakanahalfwidth" => "\u{FF80}",
    "tatweelarabic" => "\u{0640}",
    "tau" => "\u{03C4}",
    "tav" => "\u{05EA}",
    "tavdages" => "\u{FB4A}",
    "tavdagesh" => "\u{FB4A}",
    "tavdageshhebrew" => "\u{FB4A}",
    "tavhebrew" => "\u{05EA}",
    "tbar" => "\u{0167}",
    "tbopomofo" => "\u{310A}",
    "tcaron" => "\u{0165}",
    "tccurl" => "\u{02A8}",
    "tcedilla" => "\u{0163}",
    "tcheharabic" => "\u{0686}",
    "tchehfinalarabic" => "\u{FB7B}",
    "tchehinitialarabic" => "\u{FB7C}",
    "tchehmedialarabic" => "\u{FB7D}",
    "tchehmeeminitialarabic" => "\u{FB7C}\u{FEE4}",
    "tcircle" => "\u{24E3}",
    "tcircumflexbelow" => "\u{1E71}",
    "tcommaaccent" => "\u{0163}",
    "tdieresis" => "\u{1E97}",
    "tdotaccent" => "\u{1E6B}",
    "tdotbelow" => "\u{1E6D}",
    "tecyrillic" => "\u{0442}",
    "tedescendercyrillic" => "\u{04AD}",
    "teharabic" => "\u{062A}",
    "tehfinalarabic" => "\u{FE96}",
    "tehhahinitialarabic" => "\u{FCA2}",
    "tehhahisolatedarabic" => "\u{FC0C}",
    "tehinitialarabic" => "\u{FE97}",
    "tehiragana" => "\u{3066}",
    "tehjeeminitialarabic" => "\u{FCA1}",
    "tehjeemisolatedarabic" => "\u{FC0B}",
    "tehmarbutaarabic" => "\u{0629}",
    "tehmarbutafinalarabic" => "\u{FE94}",
    "tehmedialarabic" => "\u{FE98}",
    "tehmeeminitialarabic" => "\u{FCA4}",
    "tehmeemisolatedarabic" => "\u{FC0E}",
    "tehnoonfinalarabic" => "\u{FC73}",
    "tekatakana" => "\u{30C6}",
    "tekatakanahalfwidth" => "\u{FF83}",
    "telephone" => "\u{2121}",
    "telephoneblack" => "\u{260E}",
    "telishagedolahebrew" => "\u{05A0}",
    "telishaqetanahebrew" => "\u{05A9}",
    "tencircle" => "\u{2469}",
    "tenideographicparen" => "\u{3229}",
    "tenparen" => "\u{247D}",
    "tenperiod" => "\u{2491}",
    "tenroman" => "\u{2179}",
    "tesh" => "\u{02A7}",
    "tet" => "\u{05D8}",
    "tetdagesh" => "\u{FB38}",
    "tetdageshhebrew" => "\u{FB38}",
    "tethebrew" => "\u{05D8}",
    "tetsecyrillic" => "\u{04B5}",
    "tevirhebrew" => "\u{059B}",
    "tevirlefthebrew" => "\u{059B}",
    "thabengali" => "\u{09A5}",
    "thadeva" => "\u{0925}",
    "thagujarati" => "\u{0AA5}",
    "thagurmukhi" => "\u{0A25}",
    "thalarabic" => "\u{0630}",
    "thalfinalarabic" => "\u{FEAC}",
    "thanthakhatlowleftthai" => "\u{F898}",
    "thanthakhatlowrightthai" => "\u{F897}",
    "thanthakhatthai" => "\u{0E4C}",
    "thanthakhatupperleftthai" => "\u{F896}",
    "theharabic" => "\u{062B}",
    "thehfinalarabic" => "\u{FE9A}",
    "thehinitialarabic" => "\u{FE9B}",
    "thehmedialarabic" => "\u{FE9C}",
    "thereexists" => "\u{2203}",
    "therefore" => "\u{2234}",
    "theta" => "\u{03B8}",
    "theta1" => "\u{03D1}",
    "thetasymbolgreek" => "\u{03D1}",
    "thieuthacirclekorean" => "\u{3279}",
    "thieuthaparenkorean" => "\u{3219}",
    "thieuthcirclekorean" => "\u{326B}",
    "thieuthkorean" => "\u{314C}",
    "thieuthparenkorean" => "\u{320B}",
    "thirteencircle" => "\u{246C}",
    "thirteenparen" => "\u{2480}",
    "thirteenperiod" => "\u{2494}",
    "thonangmonthothai" => "\u{0E11}",
    "thook" => "\u{01AD}",
    "thophuthaothai" => "\u{0E12}",
    "thorn" => "\u{00FE}",
    "thothahanthai" => "\u{0E17}",
    "thothanthai" => "\u{0E10}",
    "thothongthai" => "\u{0E18}",
    "thothungthai" => "\u{0E16}",
    "thousandcyrillic" => "\u{0482}",
    "thousandsseparatorarabic" => "\u{066C}",
    "thousandsseparatorpersian" => "\u{066C}",
    "three" => "\u{0033}",
    "threearabic" => "\u{0663}",
    "threebengali" => "\u{09E9}",
    "threecircle" => "\u{2462}",
    "threecircleinversesansserif" => "\u{278C}",
    "threedeva" => "\u{0969}",
    "threeeighths" => "\u{215C}",
    "threegujarati" => "\u{0AE9}",
    "threegurmukhi" => "\u{0A69}",
    "threehackarabic" => "\u{0663}",
    "threehangzhou" => "\u{3023}",
    "threeideographicparen" => "\u{3222}",
    "threeinferior" => "\u{2083}",
    "threemonospace" => "\u{FF13}",
    "threenumeratorbengali" => "\u{09F6}",
    "threeoldstyle" => "\u{F733}",
    "threeparen" => "\u{2476}",
    "threeperiod" => "\u{248A}",
    "threepersian" => "\u{06F3}",
    "threequarters" => "\u{00BE}",
    "threequartersemdash" => "\u{F6DE}",
    "threeroman" => "\u{2172}",
    "threesuperior" => "\u{00B3}",
    "threethai" => "\u{0E53}",
    "thzsquare" => "\u{3394}",
    "tihiragana" => "\u{3061}",
    "tikatakana" => "\u{30C1}",
    "tikatakanahalfwidth" => "\u{FF81}",
    "tikeutacirclekorean" => "\u{3270}",
    "tikeutaparenkorean" => "\u{3210}",
    "tikeutcirclekorean" => "\u{3262}",
    "tikeutkorean" => "\u{3137}",
    "tikeutparenkorean" => "\u{3202}",
    "tilde" => "\u{02DC}",
    "tildebelowcmb" => "\u{0330}",
    "tildecmb" => "\u{0303}",
    "tildecomb" => "\u{0303}",
    "tildedoublecmb" => "\u{0360}",
    "tildeoperator" => "\u{223C}",
    "tildeoverlaycmb" => "\u{0334}",
    "tildeverticalcmb" => "\u{033E}",
    "timescircle" => "\u{2297}",
    "tipehahebrew" => "\u{0596}",
    "tipehalefthebrew" => "\u{0596}",
    "tippigurmukhi" => "\u{0A70}",
    "titlocyrilliccmb" => "\u{0483}",
    "tiwnarmenian" => "\u{057F}",
    "tlinebelow" => "\u{1E6F}",
    "tmonospace" => "\u{FF54}",
    "toarmenian" => "\u{0569}",
    "tohiragana" => "\u{3068}",
    "tokatakana" => "\u{30C8}",
    "tokatakanahalfwidth" => "\u{FF84}",
    "tonebarextrahighmod" => "\u{02E5}",
    "tonebarextralowmod" => "\u{02E9}",
    "tonebarhighmod" => "\u{02E6}",
    "tonebarlowmod" => "\u{02E8}",
    "tonebarmidmod" => "\u{02E7}",
    "tonefive" => "\u{01BD}",
    "tonesix" => "\u{0185}",
    "tonetwo" => "\u{01A8}",
    "tonos" => "\u{0384}",
    "tonsquare" => "\u{3327}",
    "topatakthai" => "\u{0E0F}",
    "tortoiseshellbracketleft" => "\u{3014}",
    "tortoiseshellbracketleftsmall" => "\u{FE5D}",
    "tortoiseshellbracketleftvertical" => "\u{FE39}",
    "tortoiseshellbracketright" => "\u{3015}",
    "tortoiseshellbracketrightsmall" => "\u{FE5E}",
    "tortoiseshellbracketrightvertical" => "\u{FE3A}",
    "totaothai" => "\u{0E15}",
    "tpalatalhook" => "\u{01AB}",
    "tparen" => "\u{24AF}",
    "trademark" => "\u{2122}",
    "trademarksans" => "\u{F8EA}",
    "trademarkserif" => "\u{F6DB}",
    "tretroflexhook" => "\u{0288}",
    "triagdn" => "\u{25BC}",
    "triaglf" => "\u{25C4}",
    "triagrt" => "\u{25BA}",
    "triagup" => "\u{25B2}",
    "ts" => "\u{02A6}",
    "tsadi" => "\u{05E6}",
    "tsadidagesh" => "\u{FB46}",
    "tsadidageshhebrew" => "\u{FB46}",
    "tsadihebrew" => "\u{05E6}",
    "tsecyrillic" => "\u{0446}",
    "tsere" => "\u{05B5}",
    "tsere12" => "\u{05B5}",
    "tsere1e" => "\u{05B5}",
    "tsere2b" => "\u{05B5}",
    "tserehebrew" => "\u{05B5}",
    "tserenarrowhebrew" => "\u{05B5}",
    "tserequarterhebrew" => "\u{05B5}",
    "tserewidehebrew" => "\u{05B5}",
    "tshecyrillic" => "\u{045B}",
    "tsuperior" => "\u{F6F3}",
    "ttabengali" => "\u{099F}",
    "ttadeva" => "\u{091F}",
    "ttagujarati" => "\u{0A9F}",
    "ttagurmukhi" => "\u{0A1F}",
    "tteharabic" => "\u{0679}",
    "ttehfinalarabic" => "\u{FB67}",
    "ttehinitialarabic" => "\u{FB68}",
    "ttehmedialarabic" => "\u{FB69}",
    "tthabengali" => "\u{09A0}",
    "tthadeva" => "\u{0920}",
    "tthagujarati" => "\u{0AA0}",
    "tthagurmukhi" => "\u{0A20}",
    "tturned" => "\u{0287}",
    "tuhiragana" => "\u{3064}",
    "tukatakana" => "\u{30C4}",
    "tukatakanahalfwidth" => "\u{FF82}",
    "tusmallhiragana" => "\u{3063}",
    "tusmallkatakana" => "\u{30C3}",
    "tusmallkatakanahalfwidth" => "\u{FF6F}",
    "twelvecircle" => "\u{246B}",
    "twelveparen" => "\u{247F}",
    "twelveperiod" => "\u{2493}",
    "twelveroman" => "\u{217B}",
    "twentycircle" => "\u{2473}",
    "twentyhangzhou" => "\u{5344}",
    "twentyparen" => "\u{2487}",
    "twentyperiod" => "\u{249B}",
    "two" => "\u{0032}",
    "twoarabic" => "\u{0662}",
    "twobengali" => "\u{09E8}",
    "twocircle" => "\u{2461}",
    "twocircleinversesansserif" => "\u{278B}",
    "twodeva" => "\u{0968}",
    "twodotenleader" => "\u{2025}",
    "twodotleader" => "\u{2025}",
    "twodotleadervertical" => "\u{FE30}",
    "twogujarati" => "\u{0AE8}",
    "twogurmukhi" => "\u{0A68}",
    "twohackarabic" => "\u{0662}",
    "twohangzhou" => "\u{3022}",
    "twoideographicparen" => "\u{3221}",
    "twoinferior" => "\u{2082}",
    "twomonospace" => "\u{FF12}",
    "twonumeratorbengali" => "\u{09F5}",
    "twooldstyle" => "\u{F732}",
    "twoparen" => "\u{2475}",
    "twoperiod" => "\u{2489}",
    "twopersian" => "\u{06F2}",
    "tworoman" => "\u{2171}",
    "twostroke" => "\u{01BB}",
    "twosuperior" => "\u{00B2}",
    "twothai" => "\u{0E52}",
    "twothirds" => "\u{2154}",
    "u" => "\u{0075}",
    "uacute" => "\u{00FA}",
    "ubar" => "\u{0289}",
    "ubengali" => "\u{0989}",
    "ubopomofo" => "\u{3128}",
    "ubreve" => "\u{016D}",
    "ucaron" => "\u{01D4}",
    "ucircle" => "\u{24E4}",
    "ucircumflex" => "\u{00FB}",
    "ucircumflexbelow" => "\u{1E77}",
    "ucyrillic" => "\u{0443}",
    "udattadeva" => "\u{0951}",
    "udblacute" => "\u{0171}",
    "udblgrave" => "\u{0215}",
    "udeva" => "\u{0909}",
    "udieresis" => "\u{00FC}",
    "udieresisacute" => "\u{01D8}",
    "udieresisbelow" => "\u{1E73}",
    "udieresiscaron" => "\u{01DA}",
    "udieresiscyrillic" => "\u{04F1}",
    "udieresisgrave" => "\u{01DC}",
    "udieresismacron" => "\u{01D6}",
    "udotbelow" => "\u{1EE5}",
    "ugrave" => "\u{00F9}",
    "ugujarati" => "\u{0A89}",
    "ugurmukhi" => "\u{0A09}",
    "uhiragana" => "\u{3046}",
    "uhookabove" => "\u{1EE7}",
    "uhorn" => "\u{01B0}",
    "uhornacute" => "\u{1EE9}",
    "uhorndotbelow" => "\u{1EF1}",
    "uhorngrave" => "\u{1EEB}",
    "uhornhookabove" => "\u{1EED}",
    "uhorntilde" => "\u{1EEF}",
    "uhungarumlaut" => "\u{0171}",
    "uhungarumlautcyrillic" => "\u{04F3}",
    "uinvertedbreve" => "\u{0217}",
    "ukatakana" => "\u{30A6}",
    "ukatakanahalfwidth" => "\u{FF73}",
    "ukcyrillic" => "\u{0479}",
    "ukorean" => "\u{315C}",
    "umacron" => "\u{016B}",
    "umacroncyrillic" => "\u{04EF}",
    "umacrondieresis" => "\u{1E7B}",
    "umatragurmukhi" => "\u{0A41}",
    "umonospace" => "\u{FF55}",
    "underscore" => "\u{005F}",
    "underscoredbl" => "\u{2017}",
    "underscoremonospace" => "\u{FF3F}",
    "underscorevertical" => "\u{FE33}",
    "underscorewavy" => "\u{FE4F}",
    "union" => "\u{222A}",
    "universal" => "\u{2200}",
    "uogonek" => "\u{0173}",
    "uparen" => "\u{24B0}",
    "upblock" => "\u{2580}",
    "upperdothebrew" => "\u{05C4}",
    "upsilon" => "\u{03C5}",
    "upsilondieresis" => "\u{03CB}",
    "upsilondieresistonos" => "\u{03B0}",
    "upsilonlatin" => "\u{028A}",
    "upsilontonos" => "\u{03CD}",
    "uptackbelowcmb" => "\u{031D}",
    "uptackmod" => "\u{02D4}",
    "uragurmukhi" => "\u{0A73}",
    "uring" => "\u{016F}",
    "ushortcyrillic" => "\u{045E}",
    "usmallhiragana" => "\u{3045}",
    "usmallkatakana" => "\u{30A5}",
    "usmallkatakanahalfwidth" => "\u{FF69}",
    "ustraightcyrillic" => "\u{04AF}",
    "ustraightstrokecyrillic" => "\u{04B1}",
    "utilde" => "\u{0169}",
    "utildeacute" => "\u{1E79}",
    "utildebelow" => "\u{1E75}",
    "uubengali" => "\u{098A}",
    "uudeva" => "\u{090A}",
    "uugujarati" => "\u{0A8A}",
    "uugurmukhi" => "\u{0A0A}",
    "uumatragurmukhi" => "\u{0A42}",
    "uuvowelsignbengali" => "\u{09C2}",
    "uuvowelsigndeva" => "\u{0942}",
    "uuvowelsigngujarati" => "\u{0AC2}",
    "uvowelsignbengali" => "\u{09C1}",
    "uvowelsigndeva" => "\u{0941}",
    "uvowelsigngujarati" => "\u{0AC1}",
    "v" => "\u{0076}",
    "vadeva" => "\u{0935}",
    "vagujarati" => "\u{0AB5}",
    "vagurmukhi" => "\u{0A35}",
    "vakatakana" => "\u{30F7}",
    "vav" => "\u{05D5}",
    "vavdagesh" => "\u{FB35}",
    "vavdagesh65" => "\u{FB35}",
    "vavdageshhebrew" => "\u{FB35}",
    "vavhebrew" => "\u{05D5}",
    "vavholam" => "\u{FB4B}",
    "vavholamhebrew" => "\u{FB4B}",
    "vavvavhebrew" => "\u{05F0}",
    "vavyodhebrew" => "\u{05F1}",
    "vcircle" => "\u{24E5}",
    "vdotbelow" => "\u{1E7F}",
    "vecyrillic" => "\u{0432}",
    "veharabic" => "\u{06A4}",
    "vehfinalarabic" => "\u{FB6B}",
    "vehinitialarabic" => "\u{FB6C}",
    "vehmedialarabic" => "\u{FB6D}",
    "vekatakana" => "\u{30F9}",
    "venus" => "\u{2640}",
    "verticalbar" => "\u{007C}",
    "verticallineabovecmb" => "\u{030D}",
    "verticallinebelowcmb" => "\u{0329}",
    "verticallinelowmod" => "\u{02CC}",
    "verticallinemod" => "\u{02C8}",
    "vewarmenian" => "\u{057E}",
    "vhook" => "\u{028B}",
    "vikatakana" => "\u{30F8}",
    "viramabengali" => "\u{09CD}",
    "viramadeva" => "\u{094D}",
    "viramagujarati" => "\u{0ACD}",
    "visargabengali" => "\u{0983}",
    "visargadeva" => "\u{0903}",
    "visargagujarati" => "\u{0A83}",
    "vmonospace" => "\u{FF56}",
    "voarmenian" => "\u{0578}",
    "voicediterationhiragana" => "\u{309E}",
    "voicediterationkatakana" => "\u{30FE}",
    "voicedmarkkana" => "\u{309B}",
    "voicedmarkkanahalfwidth" => "\u{FF9E}",
    "vokatakana" => "\u{30FA}",
    "vparen" => "\u{24B1}",
    "vtilde" => "\u{1E7D}",
    "vturned" => "\u{028C}",
    "vuhiragana" => "\u{3094}",
    "vukatakana" => "\u{30F4}",
    "w" => "\u{0077}",
    "wacute" => "\u{1E83}",
    "waekorean" => "\u{3159}",
    "wahiragana" => "\u{308F}",
    "wakatakana" => "\u{30EF}",
    "wakatakanahalfwidth" => "\u{FF9C}",
    "wakorean" => "\u{3158}",
    "wasmallhiragana" => "\u{308E}",
    "wasmallkatakana" => "\u{30EE}",
    "wattosquare" => "\u{3357}",
    "wavedash" => "\u{301C}",
    "wavyunderscorevertical" => "\u{FE34}",
    "wawarabic" => "\u{0648}",
    "wawfinalarabic" => "\u{FEEE}",
    "wawhamzaabovearabic" => "\u{0624}",
    "wawhamzaabovefinalarabic" => "\u{FE86}",
    "wbsquare" => "\u{33DD}",
    "wcircle" => "\u{24E6}",
    "wcircumflex" => "\u{0175}",
    "wdieresis" => "\u{1E85}",
    "wdotaccent" => "\u{1E87}",
    "wdotbelow" => "\u{1E89}",
    "wehiragana" => "\u{3091}",
    "weierstrass" => "\u{2118}",
    "wekatakana" => "\u{30F1}",
    "wekorean" => "\u{315E}",
    "weokorean" => "\u{315D}",
    "wgrave" => "\u{1E81}",
    "whitebullet" => "\u{25E6}",
    "whitecircle" => "\u{25CB}",
    "whitecircleinverse" => "\u{25D9}",
    "whitecornerbracketleft" => "\u{300E}",
    "whitecornerbracketleftvertical" => "\u{FE43}",
    "whitecornerbracketright" => "\u{300F}",
    "whitecornerbracketrightvertical" => "\u{FE44}",
    "whitediamond" => "\u{25C7}",
    "whitediamondcontainingblacksmalldiamond" => "\u{25C8}",
    "whitedownpointingsmalltriangle" => "\u{25BF}",
    "whitedownpointingtriangle" => "\u{25BD}",
    "whiteleftpointingsmalltriangle" => "\u{25C3}",
    "whiteleftpointingtriangle" => "\u{25C1}",
    "whitelenticularbracketleft" => "\u{3016}",
    "whitelenticularbracketright" => "\u{3017}",
    "whiterightpointingsmalltriangle" => "\u{25B9}",
    "whiterightpointingtriangle" => "\u{25B7}",
    "whitesmallsquare" => "\u{25AB}",
    "whitesmilingface" => "\u{263A}",
    "whitesquare" => "\u{25A1}",
    "whitestar" => "\u{2606}",
    "whitetelephone" => "\u{260F}",
    "whitetortoiseshellbracketleft" => "\u{3018}",
    "whitetortoiseshellbracketright" => "\u{3019}",
    "whiteuppointingsmalltriangle" => "\u{25B5}",
    "whiteuppointingtriangle" => "\u{25B3}",
    "wihiragana" => "\u{3090}",
    "wikatakana" => "\u{30F0}",
    "wikorean" => "\u{315F}",
    "wmonospace" => "\u{FF57}",
    "wohiragana" => "\u{3092}",
    "wokatakana" => "\u{30F2}",
    "wokatakanahalfwidth" => "\u{FF66}",
    "won" => "\u{20A9}",
    "wonmonospace" => "\u{FFE6}",
    "wowaenthai" => "\u{0E27}",
    "wparen" => "\u{24B2}",
    "wring" => "\u{1E98}",
    "wsuperior" => "\u{02B7}",
    "wturned" => "\u{028D}",
    "wynn" => "\u{01BF}",
    "x" => "\u{0078}",
    "xabovecmb" => "\u{033D}",
    "xbopomofo" => "\u{3112}",
    "xcircle" => "\u{24E7}",
    "xdieresis" => "\u{1E8D}",
    "xdotaccent" => "\u{1E8B}",
    "xeharmenian" => "\u{056D}",
    "xi" => "\u{03BE}",
    "xmonospace" => "\u{FF58}",
    "xparen" => "\u{24B3}",
    "xsuperior" => "\u{02E3}",
    "y" => "\u{0079}",
    "yaadosquare" => "\u{334E}",
    "yabengali" => "\u{09AF}",
    "yacute" => "\u{00FD}",
    "yadeva" => "\u{092F}",
    "yaekorean" => "\u{3152}",
    "yagujarati" => "\u{0AAF}",
    "yagurmukhi" => "\u{0A2F}",
    "yahiragana" => "\u{3084}",
    "yakatakana" => "\u{30E4}",
    "yakatakanahalfwidth" => "\u{FF94}",
    "yakorean" => "\u{3151}",
    "yamakkanthai" => "\u{0E4E}",
    "yasmallhiragana" => "\u{3083}",
    "yasmallkatakana" => "\u{30E3}",
    "yasmallkatakanahalfwidth" => "\u{FF6C}",
    "yatcyrillic" => "\u{0463}",
    "ycircle" => "\u{24E8}",
    "ycircumflex" => "\u{0177}",
    "ydieresis" => "\u{00FF}",
    "ydotaccent" => "\u{1E8F}",
    "ydotbelow" => "\u{1EF5}",
    "yeharabic" => "\u{064A}",
    "yehbarreearabic" => "\u{06D2}",
    "yehbarreefinalarabic" => "\u{FBAF}",
    "yehfinalarabic" => "\u{FEF2}",
    "yehhamzaabovearabic" => "\u{0626}",
    "yehhamzaabovefinalarabic" => "\u{FE8A}",
    "yehhamzaaboveinitialarabic" => "\u{FE8B}",
    "yehhamzaabovemedialarabic" => "\u{FE8C}",
    "yehinitialarabic" => "\u{FEF3}",
    "yehmedialarabic" => "\u{FEF4}",
    "yehmeeminitialarabic" => "\u{FCDD}",
    "yehmeemisolatedarabic" => "\u{FC58}",
    "yehnoonfinalarabic" => "\u{FC94}",
    "yehthreedotsbelowarabic" => "\u{06D1}",
    "yekorean" => "\u{3156}",
    "yen" => "\u{00A5}",
    "yenmonospace" => "\u{FFE5}",
    "yeokorean" => "\u{3155}",
    "yeorinhieuhkorean" => "\u{3186}",
    "yerahbenyomohebrew" => "\u{05AA}",
    "yerahbenyomolefthebrew" => "\u{05AA}",
    "yericyrillic" => "\u{044B}",
    "yerudieresiscyrillic" => "\u{04F9}",
    "yesieungkorean" => "\u{3181}",
    "yesieungpansioskorean" => "\u{3183}",
    "yesieungsioskorean" => "\u{3182}",
    "yetivhebrew" => "\u{059A}",
    "ygrave" => "\u{1EF3}",
    "yhook" => "\u{01B4}",
    "yhookabove" => "\u{1EF7}",
    "yiarmenian" => "\u{0575}",
    "yicyrillic" => "\u{0457}",
    "yikorean" => "\u{3162}",
    "yinyang" => "\u{262F}",
    "yiwnarmenian" => "\u{0582}",
    "ymonospace" => "\u{FF59}",
    "yod" => "\u{05D9}",
    "yoddagesh" => "\u{FB39}",
    "yoddageshhebrew" => "\u{FB39}",
    "yodhebrew" => "\u{05D9}",
    "yodyodhebrew" => "\u{05F2}",
    "yodyodpatahhebrew" => "\u{FB1F}",
    "yohiragana" => "\u{3088}",
    "yoikorean" => "\u{3189}",
    "yokatakana" => "\u{30E8}",
    "yokatakanahalfwidth" => "\u{FF96}",
    "yokorean" => "\u{315B}",
    "yosmallhiragana" => "\u{3087}",
    "yosmallkatakana" => "\u{30E7}",
    "yosmallkatakanahalfwidth" => "\u{FF6E}",
    "yotgreek" => "\u{03F3}",
    "yoyaekorean" => "\u{3188}",
    "yoyakorean" => "\u{3187}",
    "yoyakthai" => "\u{0E22}",
    "yoyingthai" => "\u{0E0D}",
    "yparen" => "\u{24B4}",
    "ypogegrammeni" => "\u{037A}",
    "ypogegrammenigreekcmb" => "\u{0345}",
    "yr" => "\u{01A6}",
    "yring" => "\u{1E99}",
    "ysuperior" => "\u{02B8}",
    "ytilde" => "\u{1EF9}",
    "yturned" => "\u{028E}",
    "yuhiragana" => "\u{3086}",
    "yuikorean" => "\u{318C}",
    "yukatakana" => "\u{30E6}",
    "yukatakanahalfwidth" => "\u{FF95}",
    "yukorean" => "\u{3160}",
    "yusbigcyrillic" => "\u{046B}",
    "yusbigiotifiedcyrillic" => "\u{046D}",
    "yuslittlecyrillic" => "\u{0467}",
    "yuslittleiotifiedcyrillic" => "\u{0469}",
    "yusmallhiragana" => "\u{3085}",
    "yusmallkatakana" => "\u{30E5}",
    "yusmallkatakanahalfwidth" => "\u{FF6D}",
    "yuyekorean" => "\u{318B}",
    "yuyeokorean" => "\u{318A}",
    "yyabengali" => "\u{09DF}",
    "yyadeva" => "\u{095F}",
    "z" => "\u{007A}",
    "zaarmenian" => "\u{0566}",
    "zacute" => "\u{017A}",
    "zadeva" => "\u{095B}",
    "zagurmukhi" => "\u{0A5B}",
    "zaharabic" => "\u{0638}",
    "zahfinalarabic" => "\u{FEC6}",
    "zahinitialarabic" => "\u{FEC7}",
    "zahiragana" => "\u{3056}",
    "zahmedialarabic" => "\u{FEC8}",
    "zainarabic" => "\u{0632}",
    "zainfinalarabic" => "\u{FEB0}",
    "zakatakana" => "\u{30B6}",
    "zaqefgadolhebrew" => "\u{0595}",
    "zaqefqatanhebrew" => "\u{0594}",
    "zarqahebrew" => "\u{0598}",
    "zayin" => "\u{05D6}",
    "zayindagesh" => "\u{FB36}",
    "zayindageshhebrew" => "\u{FB36}",
    "zayinhebrew" => "\u{05D6}",
    "zbopomofo" => "\u{3117}",
    "zcaron" => "\u{017E}",
    "zcircle" => "\u{24E9}",
    "zcircumflex" => "\u{1E91}",
    "zcurl" => "\u{0291}",
    "zdot" => "\u{017C}",
    "zdotaccent" => "\u{017C}",
    "zdotbelow" => "\u{1E93}",
    "zecyrillic" => "\u{0437}",
    "zedescendercyrillic" => "\u{0499}",
    "zedieresiscyrillic" => "\u{04DF}",
    "zehiragana" => "\u{305C}",
    "zekatakana" => "\u{30BC}",
    "zero" => "\u{0030}",
    "zeroarabic" => "\u{0660}",
    "zerobengali" => "\u{09E6}",
    "zerodeva" => "\u{0966}",
    "zerogujarati" => "\u{0AE6}",
    "zerogurmukhi" => "\u{0A66}",
    "zerohackarabic" => "\u{0660}",
    "zeroinferior" => "\u{2080}",
    "zeromonospace" => "\u{FF10}",
    "zerooldstyle" => "\u{F730}",
    "zeropersian" => "\u{06F0}",
    "zerosuperior" => "\u{2070}",
    "zerothai" => "\u{0E50}",
    "zerowidthjoiner" => "\u{FEFF}",
    "zerowidthnonjoiner" => "\u{200C}",
    "zerowidthspace" => "\u{200B}",
    "zeta" => "\u{03B6}",
    "zhbopomofo" => "\u{3113}",
    "zhearmenian" => "\u{056A}",
    "zhebrevecyrillic" => "\u{04C2}",
    "zhecyrillic" => "\u{0436}",
    "zhedescendercyrillic" => "\u{0497}",
    "zhedieresiscyrillic" => "\u{04DD}",
    "zihiragana" => "\u{3058}",
    "zikatakana" => "\u{30B8}",
    "zinorhebrew" => "\u{05AE}",
    "zlinebelow" => "\u{1E95}",
    "zmonospace" => "\u{FF5A}",
    "zohiragana" => "\u{305E}",
    "zokatakana" => "\u{30BE}",
    "zparen" => "\u{24B5}",
    "zretroflexhook" => "\u{0290}",
    "zstroke" => "\u{01B6}",
    "zuhiragana" => "\u{305A}",
    "zukatakana" => "\u{30BA}",
    "angbracketleft" => "\u{3008}",
    "angbracketright" => "\u{3009}",
    "circlecopyrt" => "\u{00A9}",
    "controlNULL" => "\u{0000}",
    "angbracketleftbig" => "\u{2329}",
    "angbracketleftBig" => "\u{2329}",
    "angbracketleftbigg" => "\u{2329}",
    "angbracketleftBigg" => "\u{2329}",
    "angbracketrightBig" => "\u{232A}",
    "angbracketrightbig" => "\u{232A}",
    "angbracketrightBigg" => "\u{232A}",
    "angbracketrightbigg" => "\u{232A}",
    "arrowhookleft" => "\u{21AA}",
    "arrowhookright" => "\u{21A9}",
    "arrowlefttophalf" => "\u{21BC}",
    "arrowleftbothalf" => "\u{21BD}",
    "arrownortheast" => "\u{2197}",
    "arrownorthwest" => "\u{2196}",
    "arrowrighttophalf" => "\u{21C0}",
    "arrowrightbothalf" => "\u{21C1}",
    "arrowsoutheast" => "\u{2198}",
    "arrowsouthwest" => "\u{2199}",
    "backslashbig" => "\u{2216}",
    "backslashBig" => "\u{2216}",
    "backslashBigg" => "\u{2216}",
    "backslashbigg" => "\u{2216}",
    "bardbl" => "\u{2016}",
    "bracehtipdownleft" => "\u{FE37}",
    "bracehtipdownright" => "\u{FE37}",
    "bracehtipupleft" => "\u{FE38}",
    "bracehtipupright" => "\u{FE38}",
    "braceleftBig" => "\u{007B}",
    "braceleftbig" => "\u{007B}",
    "braceleftbigg" => "\u{007B}",
    "braceleftBigg" => "\u{007B}",
    "bracerightBig" => "\u{007D}",
    "bracerightbig" => "\u{007D}",
    "bracerightbigg" => "\u{007D}",
    "bracerightBigg" => "\u{007D}",
    "bracketleftbig" => "\u{005B}",
    "bracketleftBig" => "\u{005B}",
    "bracketleftbigg" => "\u{005B}",
    "bracketleftBigg" => "\u{005B}",
    "bracketleftmath" => "\u{005B}",
    "bracketrightBig" => "\u{005D}",
    "bracketrightbig" => "\u{005D}",
    "bracketrightbigg" => "\u{005D}",
    "bracketrightBigg" => "\u{005D}",
    "bracketrightmath" => "\u{005D}",
    "ceilingleftbig" => "\u{2308}",
    "ceilingleftBig" => "\u{2308}",
    "ceilingleftBigg" => "\u{2308}",
    "ceilingleftbigg" => "\u{2308}",
    "ceilingrightbig" => "\u{2309}",
    "ceilingrightBig" => "\u{2309}",
    "ceilingrightbigg" => "\u{2309}",
    "ceilingrightBigg" => "\u{2309}",
    "circledotdisplay" => "\u{2299}",
    "circledottext" => "\u{2299}",
    "circlemultiplydisplay" => "\u{2297}",
    "circlemultiplytext" => "\u{2297}",
    "circleplusdisplay" => "\u{2295}",
    "circleplustext" => "\u{2295}",
    "contintegraldisplay" => "\u{222E}",
    "contintegraltext" => "\u{222E}",
    "coproductdisplay" => "\u{2210}",
    "coproducttext" => "\u{2210}",
    "epsilon1" => "\u{03B5}",
    "equalmath" => "\u{003D}",
    "floorleftBig" => "\u{230A}",
    "floorleftbig" => "\u{230A}",
    "floorleftbigg" => "\u{230A}",
    "floorleftBigg" => "\u{230A}",
    "floorrightbig" => "\u{230B}",
    "floorrightBig" => "\u{230B}",
    "floorrightBigg" => "\u{230B}",
    "floorrightbigg" => "\u{230B}",
    "hatwide" => "\u{0302}",
    "hatwider" => "\u{0302}",
    "hatwidest" => "\u{0302}",
    "intercal" => "\u{1D40}",
    "integraldisplay" => "\u{222B}",
    "integraltext" => "\u{222B}",
    "intersectiondisplay" => "\u{22C2}",
    "intersectiontext" => "\u{22C2}",
    "logicalanddisplay" => "\u{2227}",
    "logicalandtext" => "\u{2227}",
    "logicalordisplay" => "\u{2228}",
    "logicalortext" => "\u{2228}",
    "parenleftBig" => "\u{0028}",
    "parenleftbig" => "\u{0028}",
    "parenleftBigg" => "\u{0028}",
    "parenleftbigg" => "\u{0028}",
    "parenleftmath" => "\u{0028}",
    "parenrightBig" => "\u{0029}",
    "parenrightbig" => "\u{0029}",
    "parenrightBigg" => "\u{0029}",
    "parenrightbigg" => "\u{0029}",
    "parenrightmath" => "\u{0029}",
    "plusmath" => "\u{002B}",
    "prime" => "\u{2032}",
    "productdisplay" => "\u{220F}",
    "producttext" => "\u{220F}",
    "radicalbig" => "\u{221A}",
    "radicalBig" => "\u{221A}",
    "radicalBigg" => "\u{221A}",
    "radicalbigg" => "\u{221A}",
    "radicalbt" => "\u{221A}",
    "radicaltp" => "\u{221A}",
    "radicalvertex" => "\u{221A}",
    "slashbig" => "\u{002F}",
    "slashBig" => "\u{002F}",
    "slashBigg" => "\u{002F}",
    "slashbigg" => "\u{002F}",
    "summationdisplay" => "\u{2211}",
    "summationtext" => "\u{2211}",
    "tildewide" => "\u{02DC}",
    "tildewider" => "\u{02DC}",
    "tildewidest" => "\u{02DC}",
    "uniondisplay" => "\u{22C3}",
    "unionmultidisplay" => "\u{228E}",
    "unionmultitext" => "\u{228E}",
    "unionsqdisplay" => "\u{2294}",
    "unionsqtext" => "\u{2294}",
    "uniontext" => "\u{22C3}",
    "vextenddouble" => "\u{2225}",
    "vextendsingle" => "\u{2223}",
};
