#pragma once

// Return Codes (CELL_MUSIC_DECODE2 codes are omitted if they are identical)
enum CellMusicDecodeError : u32
{
	CELL_MUSIC_DECODE_CANCELED                = 1,
	CELL_MUSIC_DECODE_DECODE_FINISHED         = 0x8002C101,
	CELL_MUSIC_DECODE_ERROR_PARAM             = 0x8002C102,
	CELL_MUSIC_DECODE_ERROR_BUSY              = 0x8002C103,
	CELL_MUSIC_DECODE_ERROR_NO_ACTIVE_CONTENT = 0x8002C104,
	CELL_MUSIC_DECODE_ERROR_NO_MATCH_FOUND    = 0x8002C105,
	CELL_MUSIC_DECODE_ERROR_INVALID_CONTEXT   = 0x8002C106,
	CELL_MUSIC_DECODE_ERROR_DECODE_FAILURE    = 0x8002C107,
	CELL_MUSIC_DECODE_ERROR_NO_MORE_CONTENT   = 0x8002C108,
	CELL_MUSIC_DECODE_DIALOG_OPEN             = 0x8002C109,
	CELL_MUSIC_DECODE_DIALOG_CLOSE            = 0x8002C10A,
	CELL_MUSIC_DECODE_ERROR_NO_LPCM_DATA      = 0x8002C10B,
	CELL_MUSIC_DECODE_NEXT_CONTENTS_READY     = 0x8002C10C,
	CELL_MUSIC_DECODE_ERROR_GENERIC           = 0x8002C1FF,
};

// Constants (CELL_MUSIC_DECODE2 codes are omitted if they are identical)
enum
{
	CELL_MUSIC_DECODE_EVENT_STATUS_NOTIFICATION = 0,
	CELL_MUSIC_DECODE_EVENT_INITIALIZE_RESULT = 1,
	CELL_MUSIC_DECODE_EVENT_FINALIZE_RESULT = 2,
	CELL_MUSIC_DECODE_EVENT_SELECT_CONTENTS_RESULT = 3,
	CELL_MUSIC_DECODE_EVENT_SET_DECODE_COMMAND_RESULT = 4,
	CELL_MUSIC_DECODE_EVENT_SET_SELECTION_CONTEXT_RESULT = 5,
	CELL_MUSIC_DECODE_EVENT_UI_NOTIFICATION = 6,
	CELL_MUSIC_DECODE_EVENT_NEXT_CONTENTS_READY_RESULT = 7,

	CELL_MUSIC_DECODE_MODE_NORMAL = 0,

	CELL_MUSIC_DECODE_CMD_STOP  = 0,
	CELL_MUSIC_DECODE_CMD_START = 1,
	CELL_MUSIC_DECODE_CMD_NEXT  = 2,
	CELL_MUSIC_DECODE_CMD_PREV  = 3,

	CELL_MUSIC_DECODE_STATUS_DORMANT  = 0,
	CELL_MUSIC_DECODE_STATUS_DECODING = 1,

	CELL_MUSIC_DECODE_POSITION_NONE         = 0,
	CELL_MUSIC_DECODE_POSITION_START        = 1,
	CELL_MUSIC_DECODE_POSITION_MID          = 2,
	CELL_MUSIC_DECODE_POSITION_END          = 3,
	CELL_MUSIC_DECODE_POSITION_END_LIST_END = 4,

	CELL_MUSIC_DECODE2_MODE_NORMAL = 0,

	CELL_MUSIC_DECODE2_SPEED_MAX = 0,
	CELL_MUSIC_DECODE2_SPEED_2   = 2,

	CELL_SYSUTIL_MUSIC_DECODE2_INITIALIZING_FINISHED = 1,
	CELL_SYSUTIL_MUSIC_DECODE2_SHUTDOWN_FINISHED     = 4, // 3(SDK103) -> 4(SDK110)
	CELL_SYSUTIL_MUSIC_DECODE2_LOADING_FINISHED      = 5,
	CELL_SYSUTIL_MUSIC_DECODE2_UNLOADING_FINISHED    = 7,
	CELL_SYSUTIL_MUSIC_DECODE2_RELEASED              = 9,
	CELL_SYSUTIL_MUSIC_DECODE2_GRABBED               = 11,

	CELL_MUSIC_DECODE2_MIN_BUFFER_SIZE = 448 * 1024,
	CELL_MUSIC_DECODE2_MANAGEMENT_SIZE = 64 * 1024,
	CELL_MUSIC_DECODE2_PAGESIZE_64K    = 64 * 1024,
	CELL_MUSIC_DECODE2_PAGESIZE_1M     = 1 * 1024 * 1024,
};

using CellMusicDecodeCallback = void(u32, vm::ptr<void> param, vm::ptr<void> userData);
using CellMusicDecode2Callback = void(u32, vm::ptr<void> param, vm::ptr<void> userData);
