import type { NodeContent, StringNode } from "@bbob/types";
import type { TagNode } from "./TagNode.js";
declare function isTagNode(el: unknown): el is TagNode;
declare function isStringNode(el: unknown): el is StringNode;
declare function isEOL(el: string): boolean;
declare function getNodeLength(node: NodeContent): number;
declare function appendToNode(node: TagNode, value: NodeContent): void;
/**
 * Replaces " to &qquot;
 * @param {string} value
 */
declare function escapeAttrValue(value: string): string;
/**
 * @deprecated use escapeAttrValue
 */
declare const escapeHTML: typeof escapeAttrValue;
/**
 * Accept name and value and return valid html5 attribute string
 */
declare function attrValue<AttrValue = unknown>(name: string, value: AttrValue): string;
/**
 * Transforms attrs to html params string
 * @example
 * attrsToString({ 'foo': true, 'bar': bar' }) => 'foo="true" bar="bar"'
 */
declare function attrsToString<AttrValue = unknown>(values?: Record<string, AttrValue> | null): string;
/**
 * Gets value from
 * @example
 * getUniqAttr({ 'foo': true, 'bar': bar' }) => 'bar'
 */
declare function getUniqAttr<Value>(attrs?: Record<string, Value>): Value | null;
export { attrsToString, attrValue, appendToNode, escapeHTML, escapeAttrValue, getNodeLength, getUniqAttr, isTagNode, isStringNode, isEOL, };
//# sourceMappingURL=helpers.d.ts.map