import { GenericPoolInstrumentation } from '@opentelemetry/instrumentation-generic-pool';
export declare const instrumentGenericPool: ((options?: unknown) => GenericPoolInstrumentation) & {
    id: string;
};
/**
 * Adds Sentry tracing instrumentation for the [generic-pool](https://www.npmjs.com/package/generic-pool) library.
 *
 * For more information, see the [`genericPoolIntegration` documentation](https://docs.sentry.io/platforms/javascript/guides/node/configuration/integrations/genericpool/).
 *
 * @example
 * ```javascript
 * const Sentry = require('@sentry/node');
 *
 * Sentry.init({
 *  integrations: [Sentry.genericPoolIntegration()],
 * });
 * ```
 */
export declare const genericPoolIntegration: () => import("@sentry/core").Integration;
//# sourceMappingURL=genericPool.d.ts.map