var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.ts
var index_exports = {};
__export(index_exports, {
  randUserAgent: () => randUserAgent
});
module.exports = __toCommonJS(index_exports);

// node_modules/.pnpm/tsup@8.3.6_typescript@5.7.3_yaml@2.4.5/node_modules/tsup/assets/cjs_shims.js
var getImportMetaUrl = () => typeof document === "undefined" ? new URL(`file:${__filename}`).href : document.currentScript && document.currentScript.src || new URL("main.js", document.baseURI).href;
var importMetaUrl = /* @__PURE__ */ getImportMetaUrl();

// src/helpers.ts
var randomElement = function(array) {
  let index = Math.floor(
    Math.random() * (array[Object.keys(array).pop()].maxIndex + 1)
  );
  for (let [userAgent, indexes] of Object.entries(array)) {
    if (index >= indexes.minIndex && index <= indexes.maxIndex) {
      return userAgent;
    }
  }
  return "No Agent Found";
};
var JSONIsFrequency = function(json) {
  const [userAgent, frequency] = Object.entries(json[Object.keys(json)[0]])[0];
  return !isNaN(frequency);
};
var JSONfrequencyNormalize = function(content2) {
  let contentParsed = {};
  for (let key in content2) {
    contentParsed[key] = {};
    let sortedFrequencies = Array.from(
      new Set(Object.values(content2[key]))
    ).sort();
    for (let [userAgent, frequency] of Object.entries(content2[key])) {
      contentParsed[key][userAgent] = sortedFrequencies.indexOf(frequency) + 1;
    }
  }
  return contentParsed;
};
var JSONinterval = function(content2) {
  let contentParsed = {};
  for (let key in content2) {
    contentParsed[key] = {};
    let minIndex = 0;
    for (let [userAgent, frequency] of Object.entries(content2[key])) {
      contentParsed[key][userAgent] = {
        minIndex,
        maxIndex: minIndex + frequency - 1
      };
      minIndex = minIndex + frequency;
    }
  }
  return contentParsed;
};

// src/index.ts
var fs = __toESM(require("fs"), 1);
var path = __toESM(require("path"), 1);
var import_url = require("url");
var __filename2 = (0, import_url.fileURLToPath)(importMetaUrl);
var __dirname = path.dirname(__filename2);
var content = JSON.parse(
  fs.readFileSync(path.join(__dirname, "../data/user-agents.json"), "utf8")
);
content = JSONfrequencyNormalize(content);
if (JSONIsFrequency(content)) {
  content = JSONinterval(content);
}
var randUserAgent = function(device, browser = null, os = null) {
  let options = [];
  const keys = Object.keys(content);
  for (const index in keys) {
    let filter = true;
    if (keys[index].indexOf(device) === -1) {
      filter = false;
    }
    if (browser && keys[index].indexOf(browser) === -1) {
      filter = false;
    }
    if (os && keys[index].indexOf(os) === -1) {
      filter = false;
    }
    if (filter) {
      options.push(keys[index]);
    }
  }
  if (options.length === 0) {
    return randomElement(content);
  }
  return randomElement(
    content[options[Math.floor(Math.random() * options.length)]]
  );
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  randUserAgent
});
