"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/user-search.ts
var user_search_exports = {};
__export(user_search_exports, {
  default: () => UserSearchBuilder
});
module.exports = __toCommonJS(user_search_exports);

// src/params.ts
var R18Site = {
  /** ノクターンノベルズ(男性向け) */
  Nocturne: 1,
  /** ムーンライトノベルズ(女性向け) */
  MoonLight: 2,
  /** ムーンライトノベルズ(BL) */
  MoonLightBL: 3,
  /** ミッドナイトノベルズ(大人向け) */
  Midnight: 4
};
var R18SiteNotation = {
  [R18Site.Nocturne]: "\u30CE\u30AF\u30BF\u30FC\u30F3\u30CE\u30D9\u30EB\u30BA(\u7537\u6027\u5411\u3051)",
  [R18Site.MoonLight]: "\u30E0\u30FC\u30F3\u30E9\u30A4\u30C8\u30CE\u30D9\u30EB\u30BA(\u5973\u6027\u5411\u3051)",
  [R18Site.MoonLightBL]: "\u30E0\u30FC\u30F3\u30E9\u30A4\u30C8\u30CE\u30D9\u30EB\u30BA(BL)",
  [R18Site.Midnight]: "\u30DF\u30C3\u30C9\u30CA\u30A4\u30C8\u30CE\u30D9\u30EB\u30BA(\u5927\u4EBA\u5411\u3051)"
};
var BigGenre = {
  /** 恋愛 */
  Renai: 1,
  /** ファンタジー */
  Fantasy: 2,
  /** 文芸 */
  Bungei: 3,
  /** SF */
  Sf: 4,
  /** その他 */
  Sonota: 99,
  /** ノンジャンル */
  NonGenre: 98
};
var BigGenreNotation = {
  [BigGenre.Renai]: "\u604B\u611B",
  [BigGenre.Fantasy]: "\u30D5\u30A1\u30F3\u30BF\u30B8\u30FC",
  [BigGenre.Bungei]: "\u6587\u82B8",
  [BigGenre.Sf]: "SF",
  [BigGenre.Sonota]: "\u305D\u306E\u4ED6",
  [BigGenre.NonGenre]: "\u30CE\u30F3\u30B8\u30E3\u30F3\u30EB"
};
var Genre = {
  /** 異世界〔恋愛〕*/
  RenaiIsekai: 101,
  /** 現実世界〔恋愛〕*/
  RenaiGenjitsusekai: 102,
  /** ハイファンタジー〔ファンタジー〕*/
  FantasyHigh: 201,
  /** ローファンタジー〔ファンタジー〕*/
  FantasyLow: 202,
  /** 純文学〔文芸〕*/
  BungeiJyunbungei: 301,
  /** ヒューマンドラマ〔文芸〕*/
  BungeiHumanDrama: 302,
  /** 歴史〔文芸〕*/
  BungeiHistory: 303,
  /** 推理〔文芸〕*/
  BungeiSuiri: 304,
  /** ホラー〔文芸〕*/
  BungeiHorror: 305,
  /** アクション〔文芸〕*/
  BungeiAction: 306,
  /** コメディー〔文芸〕*/
  BungeiComedy: 307,
  /** VRゲーム〔SF〕*/
  SfVrgame: 401,
  /** 宇宙〔SF〕*/
  SfSpace: 402,
  /** 空想科学〔SF〕*/
  SfKuusoukagaku: 403,
  /** パニック〔SF〕*/
  SfPanic: 404,
  /** 童話〔その他〕*/
  SonotaDouwa: 9901,
  /** 詩〔その他〕*/
  SonotaShi: 9902,
  /** エッセイ〔その他〕*/
  SonotaEssei: 9903,
  /** リプレイ〔その他〕*/
  SonotaReplay: 9904,
  /** その他〔その他〕 */
  SonotaSonota: 9999,
  /** ノンジャンル〔ノンジャンル〕*/
  NonGenre: 9801
};
var GenreNotation = {
  [Genre.RenaiIsekai]: "\u7570\u4E16\u754C\u3014\u604B\u611B\u3015",
  [Genre.RenaiGenjitsusekai]: "\u73FE\u5B9F\u4E16\u754C\u3014\u604B\u611B\u3015",
  [Genre.FantasyHigh]: "\u30CF\u30A4\u30D5\u30A1\u30F3\u30BF\u30B8\u30FC\u3014\u30D5\u30A1\u30F3\u30BF\u30B8\u30FC\u3015",
  [Genre.FantasyLow]: "\u30ED\u30FC\u30D5\u30A1\u30F3\u30BF\u30B8\u30FC\u3014\u30D5\u30A1\u30F3\u30BF\u30B8\u30FC\u3015",
  [Genre.BungeiJyunbungei]: "\u7D14\u6587\u5B66\u3014\u6587\u82B8\u3015",
  [Genre.BungeiHumanDrama]: "\u30D2\u30E5\u30FC\u30DE\u30F3\u30C9\u30E9\u30DE\u3014\u6587\u82B8\u3015",
  [Genre.BungeiHistory]: "\u6B74\u53F2\u3014\u6587\u82B8\u3015",
  [Genre.BungeiSuiri]: "\u63A8\u7406\u3014\u6587\u82B8\u3015",
  [Genre.BungeiHorror]: "\u30DB\u30E9\u30FC\u3014\u6587\u82B8\u3015",
  [Genre.BungeiAction]: "\u30A2\u30AF\u30B7\u30E7\u30F3\u3014\u6587\u82B8\u3015",
  [Genre.BungeiComedy]: "\u30B3\u30E1\u30C7\u30A3\u30FC\u3014\u6587\u82B8\u3015",
  [Genre.SfVrgame]: "VR\u30B2\u30FC\u30E0\u3014SF\u3015",
  [Genre.SfSpace]: "\u5B87\u5B99\u3014SF\u3015",
  [Genre.SfKuusoukagaku]: "\u7A7A\u60F3\u79D1\u5B66\u3014SF\u3015",
  [Genre.SfPanic]: "\u30D1\u30CB\u30C3\u30AF\u3014SF\u3015",
  [Genre.SonotaDouwa]: "\u7AE5\u8A71\u3014\u305D\u306E\u4ED6\u3015",
  [Genre.SonotaShi]: "\u8A69\u3014\u305D\u306E\u4ED6\u3015",
  [Genre.SonotaEssei]: "\u30A8\u30C3\u30BB\u30A4\u3014\u305D\u306E\u4ED6\u3015",
  [Genre.SonotaReplay]: "\u30EA\u30D7\u30EC\u30A4\u3014\u305D\u306E\u4ED6\u3015",
  [Genre.SonotaSonota]: "\u305D\u306E\u4ED6\u3014\u305D\u306E\u4ED6\u3015",
  [Genre.NonGenre]: "\u30CE\u30F3\u30B8\u30E3\u30F3\u30EB\u3014\u30CE\u30F3\u30B8\u30E3\u30F3\u30EB\u3015"
};

// src/search-builder.ts
var SearchBuilderBase = class {
  /**
   * constructor
   * @private
   * @param params クエリパラメータ
   * @param api NarouNovel インスタンス
   */
  constructor(params = {}, api) {
    this.params = params;
    this.api = api;
  }
  /**
   * 配列から重複を除去する
   * @protected
   * @static
   * @param array 配列
   * @returns 重複を除去した配列
   */
  static distinct(array) {
    return Array.from(new Set(array));
  }
  /**
   * 配列をハイフン区切りの文字列に変換する
   * @protected
   * @static
   * @param n 文字列または数値の配列、あるいは単一の文字列または数値
   * @returns ハイフン区切りの文字列
   */
  static array2string(n) {
    if (Array.isArray(n)) {
      return this.distinct(n).join("-");
    } else {
      return n.toString();
    }
  }
  /**
   * 取得件数を指定する (lim)
   * @param num 取得件数 (1-500)
   * @return {this}
   */
  limit(num) {
    this.set({ lim: num });
    return this;
  }
  /**
   * 取得開始位置を指定する (st)
   * @param num 取得開始位置 (1-)
   * @return {this}
   */
  start(num) {
    this.set({ st: num });
    return this;
  }
  /**
   * ページ番号と1ページあたりの件数で取得範囲を指定する
   * @param no ページ番号 (0-)
   * @param count 1ページあたりの件数 (デフォルト: 20)
   * @return {this}
   */
  page(no, count = 20) {
    return this.limit(count).start(no * count);
  }
  /**
   * 出力順序を指定する (order)
   * 指定しない場合は新着順となります。
   * @param {TOrder} order 出力順序
   * @return {this}
   */
  order(order) {
    this.set({ order });
    return this;
  }
  /**
   * gzip圧縮レベルを指定する (gzip)
   *
   * 転送量上限を減らすためにも推奨
   * @param {GzipLevel} level gzip圧縮レベル(1～5)
   * @return {this}
   */
  gzip(level) {
    this.set({ gzip: level });
    return this;
  }
  /**
   * クエリパラメータをセットする
   * @protected
   * @param obj セットするパラメータ
   * @return {this}
   */
  set(obj) {
    this.params = { ...this.params, ...obj };
    return this;
  }
  /**
   * クエリパラメータを削除する
   * @protected
   * @param key 削除するパラメータのキー
   * @returns {this}
   */
  unset(key) {
    delete this.params[key];
    return this;
  }
};

// src/user-search.ts
var UserSearchBuilder = class _UserSearchBuilder extends SearchBuilderBase {
  /**
   * 単語を指定できます。
   * 半角または全角スペースで区切るとAND抽出になります。
   * 部分一致でHITします。検索の対象はユーザ名とユーザ名のフリガナです。
   */
  word(word) {
    this.set({ word });
    return this;
  }
  /**
   * 含みたくない単語を指定できます。
   * スペースで区切ることにより含ませない単語を増やせます。部分一致で除外されます。
   * 除外の対象はユーザ名とユーザ名のフリガナです。
   */
  notWord(notword) {
    this.set({ notword });
    return this;
  }
  /**
   * ユーザIDで抽出可能。
   */
  userId(userid) {
    this.set({ userid });
    return this;
  }
  /**
   * 抽出するユーザのユーザ名のフリガナの頭文字を指定できます。
   * 頭文字はユーザ名のフリガナをひらがなに変換し、最初の1文字が「ぁ」～「ん」の場合に対象となります。
   * 「ぱ」や「ば」等の半濁音や濁音は清音として扱われます。
   * 漢字や英数字が頭文字のユーザは対象外です。
   */
  name1st(name1st) {
    this.set({ name1st });
    return this;
  }
  /**
   * 抽出するユーザの小説投稿数の下限を指定できます。
   * 小説投稿件数が指定された数値以上のユーザを抽出します。
   */
  minNovel(minnovel) {
    this.set({ minnovel });
    return this;
  }
  /**
   * 抽出するユーザの小説投稿数の上限を指定できます。
   * 小説投稿件数が指定された数値以下のユーザを抽出します。
   */
  maxNovel(maxnovel) {
    this.set({ maxnovel });
    return this;
  }
  /**
   * 抽出するユーザのレビュー投稿数の下限を指定できます。
   * レビュー投稿件数が指定された数値以上のユーザを抽出します。
   */
  minReview(minreview) {
    this.set({ minreview });
    return this;
  }
  /**
   * 抽出するユーザのレビュー投稿数の上限を指定できます。
   * レビュー投稿件数が指定された数値以下のユーザを抽出します。
   */
  maxReview(maxreview) {
    this.set({ maxreview });
    return this;
  }
  /**
   * 出力する項目を個別に指定できます。未指定時は全項目出力されます。転送量軽減のため、このパラメータの使用が推奨されます。
   * @return {SearchBuilder} this
   */
  fields(fields) {
    this.set({ of: _UserSearchBuilder.array2string(fields) });
    return this;
  }
  /**
   * なろう小説APIへのリクエストを実行する
   * @returns ランキング
   */
  execute() {
    return this.api.executeUserSearch(this.params);
  }
};
//# sourceMappingURL=user-search.cjs.map