//#region src/types.d.ts
declare enum AuthenticationLanguageCode {
  AUTHENTICATION_LANGUAGE_CODE_JP = 0,
  AUTHENTICATION_LANGUAGE_CODE_EN = 1,
}
declare enum AuthenticationPlatform {
  AUTHENTICATION_PLATFORM_UNKNOWN = 0,
  AUTHENTICATION_PLATFORM_IOS = 1,
  AUTHENTICATION_PLATFORM_ANDROID = 2,
  AUTHENTICATION_PLATFORM_WEB = 3,
}
declare enum AuthenticationType {
  AUTHENTICATION_TYPE_UNKNOWN = 0,
  AUTHENTICATION_TYPE_REGISTER = 1,
  AUTHENTICATION_TYPE_LOGIN = 2,
}
declare enum Category {
  CATEGORY_UNKNOWN = 0,
  CATEGORY_AVATAR = 1,
  CATEGORY_POST_IMAGE = 2,
  CATEGORY_POST_VIDEO = 3,
  CATEGORY_COMMUNITY_COVER_IMAGE = 4,
  CATEGORY_COMMUNITY_STAMP = 5,
}
declare enum ChatRoomMessageType {
  CHAT_ROOM_MESSAGE_TYPE_MESSAGE = 0,
  CHAT_ROOM_MESSAGE_TYPE_SYSTEM_MESSAGE_INVITE = 1,
  CHAT_ROOM_MESSAGE_TYPE_SYSTEM_MESSAGE_JOIN = 2,
  CHAT_ROOM_MESSAGE_TYPE_SYSTEM_MESSAGE_LEAVE = 3,
  CHAT_ROOM_MESSAGE_TYPE_SYSTEM_MESSAGE_CHANGE_TITLE = 4,
  CHAT_ROOM_MESSAGE_TYPE_SYSTEM_MESSAGE_CHANGE_ICON = 5,
}
declare enum ChatRoomStatus {
  CHAT_ROOM_STATUS_UNKNOWN = 0,
  CHAT_ROOM_STATUS_ACCEPTED = 1,
  CHAT_ROOM_STATUS_REQUESTED = 2,
  CHAT_ROOM_STATUS_REQUESTING = 3,
}
declare enum CommunityAccessLevel {
  COMMUNITY_ACCESS_LEVEL_PUBLIC = 0,
  COMMUNITY_ACCESS_LEVEL_APPROVAL_REQUIRED = 1,
}
declare enum CommunityApproveStatus {
  COMMUNITY_APPROVE_STATUS_REQUEST = 0,
  COMMUNITY_APPROVE_STATUS_APPROVE = 1,
  COMMUNITY_APPROVE_STATUS_REJECT = 2,
  COMMUNITY_APPROVE_STATUS_CANCEL = 3,
}
declare enum CommunityEventLocationType {
  COMMUNITY_EVENT_LOCATION_TYPE_UNSPECIFIED = 0,
  COMMUNITY_EVENT_LOCATION_TYPE_ONLINE = 1,
  COMMUNITY_EVENT_LOCATION_TYPE_OFFLINE = 2,
}
declare enum CommunityEventStatus {
  COMMUNITY_EVENT_STATUS_OPENED = 0,
  COMMUNITY_EVENT_STATUS_CLOSED = 1,
}
declare enum CommunityMemberStatus {
  COMMUNITY_MEMBER_STATUS_PARTICIPATING = 0,
  COMMUNITY_MEMBER_STATUS_WAITING_FOR_APPROVAL = 1,
  COMMUNITY_MEMBER_STATUS_EXCLUDED = 3,
}
declare enum CommunityPostConstraint {
  COMMUNITY_POST_CONSTRAINT_MEMBER_ONLY = 0,
  COMMUNITY_POST_CONSTRAINT_ADMIN_ONLY = 1,
}
declare enum CommunityPostSubscriptionType {
  COMMUNITY_POST_SUBSCRIPTION_TYPE_ALL = 0,
  COMMUNITY_POST_SUBSCRIPTION_TYPE_AGGREGATION = 1,
  COMMUNITY_POST_SUBSCRIPTION_TYPE_STOP = 2,
}
declare enum CommunityType {
  COMMUNITY_TYPE_TOPIC = 0,
  COMMUNITY_TYPE_EVENT = 1,
}
declare enum CommunityVisibility {
  COMMUNITY_VISIBILITY_UNSPECIFIED = 0,
  COMMUNITY_VISIBILITY_VISIBLE = 1,
  COMMUNITY_VISIBILITY_INVISIBLE = 2,
}
declare enum ContentType {
  CONTENT_TYPE_UNKNOWN = 0,
  CONTENT_TYPE_VIDEO = 1,
  CONTENT_TYPE_MUSIC = 2,
  CONTENT_TYPE_WEBSITE = 3,
  CONTENT_TYPE_ARTICLE = 4,
  CONTENT_TYPE_BOOK = 5,
  CONTENT_TYPE_PROFILE = 6,
}
declare enum FeedSourceType {
  FEED_SOURCE_TYPE_UNSPECIFIED = 0,
  FEED_SOURCE_TYPE_FOLLOWING = 1,
  FEED_SOURCE_TYPE_COMMUNITY = 2,
}
declare enum FeedType {
  FEED_TYPE_UNSPECIFIED = 0,
  FEED_TYPE_POST = 1,
  FEED_TYPE_COMMUNITY_AGGREGATION_POST = 2,
}
declare enum FollowingRequestStatus {
  FOLLOWING_REQUEST_STATUS_REQUESTING = 0,
  FOLLOWING_REQUEST_STATUS_APPROVED = 1,
  FOLLOWING_REQUEST_STATUS_REJECTED = 2,
  FOLLOWING_REQUEST_STATUS_CANCELED = 3,
}
declare enum FollowingStatus {
  FOLLOWING_STATUS_NONE = 0,
  FOLLOWING_STATUS_FOLLOWING = 1,
  FOLLOWING_STATUS_REQUESTING = 2,
}
declare enum GiftCampaignKey {
  GIFT_CAMPAIGN_KEY_UNSPECIFIED = 0,
  GIFT_CAMPAIGN_KEY_2025_SPRING_INVITATION_STAMP_CAMPAIGN = 1,
}
declare enum GlobalCounterKey {
  GLOBAL_COUNTER_KEY_UNSPECIFIED = 0,
  GLOBAL_COUNTER_KEY_2025_WEB_COMMING_SOON = 1,
}
declare enum InvitationKind {
  INVITATION_KIND_PERSONA = 0,
  INVITATION_KIND_COMMUNITY = 1,
}
declare enum ItemType {
  ITEM_TYPE_PERSONA = 0,
}
declare enum LanguageCode {
  LANGUAGE_CODE_UNKNOWN = 0,
  LANGUAGE_CODE_JP = 1,
  LANGUAGE_CODE_EN = 2,
}
declare enum LinkCardStatus {
  STATUS_PROCESSING = 0,
  STATUS_RESOLVED = 1,
  STATUS_FAILED = 2,
}
declare enum MediaStatus {
  STATUS_UNKNOWN = 0,
  STATUS_WAIT_FOR_UPLOADING = 1,
  STATUS_IN_PROGRESS = 2,
  STATUS_SUCCESS = 3,
  STATUS_FAILURE = 4,
}
declare enum NotificationActivityType {
  NOTIFICATION_ACTIVITY_TYPE_UNKNOWN = 0,
  NOTIFICATION_ACTIVITY_TYPE_FOLLOW = 100,
  NOTIFICATION_ACTIVITY_TYPE_FOLLOWING_REQUEST_RECEIVED = 101,
  NOTIFICATION_ACTIVITY_TYPE_FOLLOWING_REQUEST_APPROVED = 102,
  NOTIFICATION_ACTIVITY_TYPE_INVITATION_FOLLOW = 103,
  NOTIFICATION_ACTIVITY_TYPE_LIKE = 200,
  NOTIFICATION_ACTIVITY_TYPE_REPOST = 201,
  NOTIFICATION_ACTIVITY_TYPE_QUOTE = 202,
  NOTIFICATION_ACTIVITY_TYPE_REPLY = 204,
  NOTIFICATION_ACTIVITY_TYPE_MENTION = 205,
  NOTIFICATION_ACTIVITY_TYPE_REACTION = 206,
  NOTIFICATION_ACTIVITY_TYPE_COMMUNITY_JOIN_REQUEST = 300,
  NOTIFICATION_ACTIVITY_TYPE_COMMUNITY_JOIN_ACCEPT = 301,
  NOTIFICATION_ACTIVITY_TYPE_COMMUNITY_INVITATION = 310,
  NOTIFICATION_ACTIVITY_TYPE_COMMUNITY_GRANT_ADMIN_PRIVILEGES = 311,
  NOTIFICATION_ACTIVITY_TYPE_COMMUNITY_JOIN = 312,
  NOTIFICATION_ACTIVITY_TYPE_EVENT_JOIN = 400,
  NOTIFICATION_ACTIVITY_TYPE_EVENT_REMINDER = 401,
}
declare enum Operation {
  OPERATION_FOLLOWING_PERSONA = 0,
  OPERATION_COMMUNITY = 1,
  OPERATION_ROOKIE_PERSONA = 2,
  OPERATION_NEW_COMMUNITY = 3,
  OPERATION_PICKUP_COMMUNITY = 4,
  OPERATION_VERIFIED_PERSONA = 5,
}
declare enum PersonaInAppEventStatus {
  PERSONA_IN_APP_EVENT_STATUS_UNSPECIFIED = 0,
  PERSONA_IN_APP_EVENT_STATUS_UNKNOWN = 1,
  PERSONA_IN_APP_EVENT_STATUS_ACTIVE = 2,
  PERSONA_IN_APP_EVENT_STATUS_INACTIVE = 3,
  PERSONA_IN_APP_EVENT_STATUS_DONE = 4,
}
declare enum PersonaInAppEventType {
  PERSONA_IN_APP_EVENT_TYPE_UNSPECIFIED = 0,
  PERSONA_IN_APP_EVENT_TYPE_VIEW_STORE_REVIEW_POPUP = 1,
  PERSONA_IN_APP_EVENT_TYPE_INVITATION_DIALOG_AFTER_NEW_REGISTRATION = 2,
  PERSONA_IN_APP_EVENT_TYPE_INVITATION_FROM_HOME = 3,
  PERSONA_IN_APP_EVENT_TYPE_VERIFIED_BADGE_AWARDED_POPUP = 4,
}
declare enum PersonaType {
  PERSONA_TYPE_UNSPECIFIED = 0,
  PERSONA_TYPE_ACCOUNT = 1,
  PERSONA_TYPE_BOT = 2,
}
declare enum PersonaVisibility {
  PERSONA_VISIBILITY_PUBLIC = 0,
  PERSONA_VISIBILITY_APPROVAL_REQUIRED = 1,
}
declare enum PickupCommunityCategory {
  PICKUP_COMMUNITY_CATEGORY_UNSPECIFIED = 0,
  PICKUP_COMMUNITY_CATEGORY_SPORT = 1,
  PICKUP_COMMUNITY_CATEGORY_TECHNOLOGY = 2,
  PICKUP_COMMUNITY_CATEGORY_ART_AND_CREATIVE = 3,
  PICKUP_COMMUNITY_CATEGORY_GAME = 4,
  PICKUP_COMMUNITY_CATEGORY_BUSINESS_AND_CAREER = 5,
  PICKUP_COMMUNITY_CATEGORY_ENTERTAINMENT = 6,
  PICKUP_COMMUNITY_CATEGORY_AREA_AND_TRAVEL = 7,
  PICKUP_COMMUNITY_CATEGORY_LIFE = 8,
  PICKUP_COMMUNITY_CATEGORY_FOOD_AND_COOKING = 9,
  PICKUP_COMMUNITY_CATEGORY_FASHION = 10,
  PICKUP_COMMUNITY_CATEGORY_ANIMAL = 11,
  PICKUP_COMMUNITY_CATEGORY_HOBBY = 12,
  PICKUP_COMMUNITY_CATEGORY_PHOTOGRAPH = 13,
  PICKUP_COMMUNITY_CATEGORY_COMICS_AND_ANIMATION = 14,
  PICKUP_COMMUNITY_CATEGORY_MUSIC_AND_CINEMA = 15,
}
declare enum PlatformType {
  PLATFORM_TYPE_UNKNOWN = 0,
  PLATFORM_TYPE_IOS = 1,
  PLATFORM_TYPE_ANDROID = 2,
  PLATFORM_TYPE_WEB = 3,
}
declare enum PostMaskType {
  POST_MASK_TYPE_NONE = 0,
  POST_MASK_TYPE_SENSITIVE = 1,
  POST_MASK_TYPE_SPOILER = 2,
}
declare enum PostPublishingType {
  POST_PUBLISHING_TYPE_UNSPECIFIED = 0,
  POST_PUBLISHING_TYPE_FOLLOW_AND_COMMUNITY = 1,
}
declare enum PostReactionType {
  POST_REACTION_TYPE_UNKNOWN = 0,
  POST_REACTION_TYPE_REPLY = 100,
  POST_REACTION_TYPE_REPOST = 101,
  POST_REACTION_TYPE_QUOTE = 102,
  POST_REACTION_TYPE_LIKE = 200,
  POST_REACTION_TYPE_BOOKMARK = 201,
}
declare enum PostVisibility {
  POST_VISIBILITY_PUBLIC = 0,
  POST_VISIBILITY_PRIVATE = 1,
  POST_VISIBILITY_SEALED = 2,
}
declare enum ProfileSocialMediaType {
  PROFILE_SOCIAL_MEDIA_TYPE_UNSPECIFIED = 0,
  PROFILE_SOCIAL_MEDIA_TYPE_TWITTER = 1,
  PROFILE_SOCIAL_MEDIA_TYPE_INSTAGRAM = 2,
  PROFILE_SOCIAL_MEDIA_TYPE_TIKTOK = 3,
  PROFILE_SOCIAL_MEDIA_TYPE_YOUTUBE = 4,
}
declare enum ReportReasonType {
  REPORT_REASON_TYPE_UNSPECIFIED = 0,
  REPORT_REASON_TYPE_SPAM = 1,
  REPORT_REASON_TYPE_DISTURBING_OR_OFFENSIVE_BEHAVIOR = 2,
  REPORT_REASON_TYPE_SEXUAL_HARASSMENT_ENCOUNTER = 3,
  REPORT_REASON_TYPE_COPYRIGHT_INFRINGEMENT = 4,
  REPORT_REASON_TYPE_INVASION_OF_PRIVACY = 5,
  REPORT_REASON_TYPE_OTHER = 6,
  REPORT_REASON_TYPE_RIGHT_INFRINGEMENT = 7,
}
declare enum ReportRightInfringementTarget {
  REPORT_RIGHT_INFRINGEMENT_TARGET_UNSPECIFIED = 0,
  REPORT_RIGHT_INFRINGEMENT_TARGET_SELF = 1,
  REPORT_RIGHT_INFRINGEMENT_TARGET_OTHERS = 2,
}
declare enum RewardType {
  REWARD_TYPE_UNSPECIFIED = 0,
  REWARD_TYPE_STAMP = 1,
}
declare enum SearchType {
  SEARCH_TYPE_PERSONAS = 0,
  SEARCH_TYPE_POSTS = 1,
  SEARCH_TYPE_COMMUNITIES = 2,
  SEARCH_TYPE_TOPIC = 3,
  SEARCH_TYPE_EVENT = 4,
}
declare enum StampSetType {
  STAMP_SET_TYPE_UNSPECIFIED = 0,
  STAMP_SET_TYPE_DEFAULT = 1,
  STAMP_SET_TYPE_SECRET = 2,
  STAMP_SET_TYPE_SEASONAL = 3,
  STAMP_SET_TYPE_CAMPAIGN = 4,
}
declare enum StatusIconType {
  STATUS_ICON_TYPE_NONE = 0,
  STATUS_ICON_TYPE_EMOJI = 1,
}
declare enum TokenProvider {
  TOKEN_PROVIDER_MIXIM = 0,
}
declare enum VerificationType {
  VERIFICATION_TYPE_UNVERIFIED = 0,
  VERIFICATION_TYPE_SERVICE = 1,
  VERIFICATION_TYPE_BUSINESS = 2,
  VERIFICATION_TYPE_PUBLIC_FIGURE = 3,
}
interface AcceptChatRoomRequest {
  roomId: string;
}
interface AcceptChatRoomResponse {
  room: ChatRoom;
}
interface AddMembersToChatRoomRequest {
  roomId: string;
  memberIds: string[];
}
interface AddMembersToChatRoomResponse {
  room: ChatRoom;
}
interface AddStampToPostRequest {
  postId: string;
  stampId: string;
}
interface AddStampToPostResponse {
  post: Post;
}
interface Announcement {
  announcementId: string;
  caption: string;
  expiresAt: Timestamp;
  postId?: string;
  createdAt: Timestamp;
}
interface ApplyForVerificationRequest {
  socialMediaTypes: ProfileSocialMediaType[];
}
interface ApplyForVerificationResponse {}
interface ApproveFollowingRequestRequest {
  requestId: string;
}
interface ApproveFollowingRequestResponse {}
interface ApproveJoinCommunityRequest {
  communityId: string;
  personaId: string;
}
interface ApproveJoinCommunityResponse {
  community: Community;
}
interface ArchiveCommunityRequest {
  communityId: string;
}
interface ArchiveCommunityResponse {
  community: Community;
}
interface Avatar {
  iconUrl: string;
  iconMimeType: string;
  iconHeight: number;
  iconWidth: number;
  profileImageUrl: string;
  profileImageMimeType: string;
  profileImageHeight: number;
  profileImageWidth: number;
  blurhash: string;
}
interface BookmarkCommunityRequest {
  communityId: string;
}
interface BookmarkCommunityResponse {
  community: Community;
}
interface CancelFollowingRequestRequest {
  personaId: string;
}
interface CancelFollowingRequestResponse {
  persona: Persona;
}
interface CancelJoinCommunityRequestRequest {
  communityId: string;
}
interface CancelJoinCommunityRequestResponse {
  community: Community;
}
interface ChangeCommunityAdminsRequest {
  communityId: string;
  addedPersonaIds: string[];
  removedPersonaIds: string[];
}
interface ChangeCommunityAdminsResponse {
  admins: CommunityMember[];
}
interface ChangeCommunityPostSubscriptionTypeRequest {
  communityId: string;
  postSubscriptionType: CommunityPostSubscriptionType;
}
interface ChangeCommunityPostSubscriptionTypeResponse {
  community: Community;
}
interface ChangeMyPersonaVisibilityRequest {
  visibility: PersonaVisibility;
}
interface ChangeMyPersonaVisibilityResponse {
  persona: Persona;
}
interface ChatRoom {
  roomId: string;
  isGroup: boolean;
  title?: string;
  members: ChatRoomMember[];
  createdAt: Timestamp;
  message?: ChatRoomMessage;
  status: ChatRoomStatus;
  isMute: boolean;
  isInvisible: boolean;
}
interface ChatRoomMember {
  personaId: string;
  readMessageId?: string;
}
interface ChatRoomMessage {
  roomId: string;
  messageId: string;
  personaId: string;
  messageType: ChatRoomMessageType;
  messageTargetId?: string;
  text?: string;
  createdAt: Timestamp;
  media: Media[];
  post?: Post;
}
interface CheckPendingPostRequest {
  postId: string;
}
interface CheckPendingPostResponse {
  post: Post;
  isPending: boolean;
}
interface CloseEventCommunityRequest {
  eventCommunityId: string;
}
interface CloseEventCommunityResponse {
  community: Community;
}
interface CommunitiesResult {
  communities: Community[];
  nextCursor?: string;
}
interface Community {
  communityId: string;
  name: string;
  purpose: string;
  accessLevel: CommunityAccessLevel;
  admins: CommunityMember[];
  rules: CommunityRule[];
  myself?: CommunityMember;
  countOfMembers: number;
  createdAt: Timestamp;
  isArchived: boolean;
  coverImage: Media;
  members: CommunityMember[];
  type: CommunityType;
  parent?: CommunitySummary;
  children: CommunitySummary[];
  eventSchedule?: EventSchedule;
  postPins: CommunityPostPin[];
  lastPurposeEditor?: Persona;
  lastPurposeEditorId?: string;
  tags: string[];
  visibility: CommunityVisibility;
  creatorId?: string;
  creator?: Persona;
  postConstraint: CommunityPostConstraint;
  isPostNotificationTarget: boolean;
  isSubscriptionDisabled: boolean;
  isSearchable: boolean;
  hasAggregationFeed: boolean;
  postSubscriptionType: CommunityPostSubscriptionType;
}
interface CommunityAggregationPost {
  communityId: string;
  post: Post;
  aggregationCount: number;
  hasMore: boolean;
  community: CommunitySummary;
  untilCursor: string;
  endCursor: string;
}
interface CommunityJoinRequest {
  communityId: string;
  requestId: string;
  timeSeriesId: string;
  approverPersonaId: string;
  requestorPersonaId: string;
  status: CommunityApproveStatus;
}
interface CommunityMember {
  communityId: string;
  persona: Persona;
  status: CommunityMemberStatus;
  isAdmin: boolean;
  isCreator: boolean;
  createdAt: Timestamp;
  personaId: string;
}
interface CommunityPostPin {
  communityPostPinId: string;
  postId: string;
  operatorPersonaId: string;
}
interface CommunityResponse {
  communities: Community[];
  recommendedCommunities: RecommendedCommunity[];
}
interface CommunityRule {
  communityId: string;
  ruleId: string;
  createdAt: Timestamp;
  text: string;
}
interface CommunityStamp {
  stampId: string;
  url: string;
  searchTags: string[];
}
interface CommunityStampDetail {
  stampId: string;
  url: string;
  searchTags: string[];
  createdAt: Timestamp;
}
interface CommunityStampSet {
  communityId: string;
  stamps: CommunityStamp[];
}
interface CommunitySummary {
  communityId: string;
  name: string;
  accessLevel: CommunityAccessLevel;
  isArchived: boolean;
  myself?: CommunityMember;
  coverImage: Media;
  type: CommunityType;
  eventSchedule?: EventSchedule;
  parent?: CommunitySummary;
  postConstraint: CommunityPostConstraint;
  creatorId?: string;
}
interface CreateBookmarkRequest {
  postId: string;
}
interface CreateBookmarkResponse {
  post: Post;
}
interface CreateChatRoomRequest {
  isGroup: boolean;
  memberIds: string[];
}
interface CreateChatRoomResponse {
  room: ChatRoom;
}
interface CreateCommunityRequest {
  name: string;
  purpose: string;
  accessLevel: CommunityAccessLevel;
}
interface CreateCommunityResponse {
  community: Community;
}
interface CreateEventCommunityRequest {
  eventName: string;
  eventPurpose: string;
  accessLevel: CommunityAccessLevel;
  startAt: Timestamp;
  endAt?: Timestamp;
  defaultCoverImageIndex?: number;
  communityId?: string;
  postConstraint?: CommunityPostConstraint;
  locationType?: CommunityEventLocationType;
}
interface CreateEventCommunityResponse {
  community: Community;
}
interface CreateFollowingRequest {
  followingId: string;
}
interface CreateFollowingResponse {
  following: Following;
}
interface CreateLikeRequest {
  postId: string;
}
interface CreateLikeResponse {
  post: Post;
}
interface CreatePersonaFromSessionRequest {
  name: string;
  displayName: string;
}
interface CreatePersonaRequest {
  refreshToken: string;
  name: string;
  displayName: string;
}
interface CreatePostAndEventCommunityRequest {
  postText: string;
  communityId?: string;
  eventName: string;
  eventPurpose: string;
  accessLevel: CommunityAccessLevel;
  startAt: Timestamp;
  endAt?: Timestamp;
  defaultCoverImageIndex?: number;
  decorations: number[];
  eventLocationType?: CommunityEventLocationType;
  publishingType?: PostPublishingType;
}
interface CreatePostAndEventCommunityResponse {
  post: Post;
}
interface CreatePostRequest {
  text: string;
  inReplyToPostId?: string;
  quotePostId?: string;
  mediaIds: string[];
  repostId?: string;
  isSensitive: boolean;
  communityId?: string;
  attachedCommunityId?: string;
  decorations: number[];
  maskType?: PostMaskType;
  maskCaption?: string;
  publishingType?: PostPublishingType;
}
interface CreatePostResponse {
  post: Post;
  isPending: boolean;
}
interface CreateTopicCommunityRequest {
  name: string;
  purpose: string;
  accessLevel: CommunityAccessLevel;
  defaultCoverImageIndex?: number;
  postConstraint?: CommunityPostConstraint;
  searchable?: boolean;
}
interface CreateTopicCommunityResponse {
  community: Community;
}
interface DeleteAccountRequest {
  refreshToken: string;
}
interface DeleteAccountResponse {}
interface DeleteBookmarkRequest {
  postId: string;
}
interface DeleteBookmarkResponse {
  post: Post;
}
interface DeleteCommunityStampRequest {
  communityId: string;
  stampId: string;
}
interface DeleteCommunityStampResponse {}
interface DeleteExcludedCommunityMemberRequest {
  communityId: string;
  personaId: string;
}
interface DeleteExcludedCommunityMemberResponse {}
interface DeleteExcludedCommunityMembersRequest {
  communityId: string;
  personaIds: string[];
}
interface DeleteExcludedCommunityMembersResponse {}
interface DeleteFCMTokenRequest {
  fcmToken: string;
}
interface DeleteFCMTokenResponse {}
interface DeleteFollowingRequest {
  followingId: string;
}
interface DeleteFollowingResponse {
  following: Following;
}
interface DeleteLikeRequest {
  postId: string;
}
interface DeleteLikeResponse {
  post: Post;
}
interface DeletePostRequest {
  postId: string;
}
interface DeletePostResponse {
  deleted: boolean;
}
interface DeleteRepostRequest {
  referencePostId: string;
}
interface DeleteRepostResponse {
  deletedPostId: string;
  referencePost: Post;
}
interface DeleteSessionRequest {
  fcmToken?: string;
}
interface DeleteSessionResponse {}
interface DenyJoinCommunityRequest {
  communityId: string;
  personaId: string;
}
interface DenyJoinCommunityResponse {}
interface EventSchedule {
  startAt: Timestamp;
  endAt?: Timestamp;
  status: CommunityEventStatus;
  closedAt?: Timestamp;
  eventLocationType?: CommunityEventLocationType;
}
interface ExcludeCommunityMemberRequest {
  communityId: string;
  personaId: string;
}
interface ExcludeCommunityMemberResponse {
  member: CommunityMember;
  community: Community;
}
interface ExcludeCommunityMembersRequest {
  communityId: string;
  personaIds: string[];
}
interface ExcludeCommunityMembersResponse {
  members: CommunityMember[];
  community: Community;
}
interface ExitChatRoomRequest {
  roomId: string;
}
interface ExitChatRoomResponse {}
interface Feed {
  feedType: FeedType;
  timeSeriesId: string;
  post: Post;
  communityAggregationPost: CommunityAggregationPost;
}
interface Follower {
  personaId: string;
  createdAt: Timestamp;
  persona: Persona;
  connectivity: PersonaConnectivity;
}
interface Following {
  personaId: string;
  createdAt: Timestamp;
  persona: Persona;
  connectivity: PersonaConnectivity;
}
interface FollowingCount {
  followingCount: number;
  followedCount: number;
}
interface FollowingPersonaResponse {
  personas: PersonaWithConnectivity[];
  recommendedPersonas: RecommendedPersona[];
}
interface FollowingRequest {
  requestId: string;
  senderId: string;
  receiverId: string;
  createdAt: Timestamp;
  status: FollowingRequestStatus;
}
interface GetAnnouncementsRequest {}
interface GetAnnouncementsResponse {
  announcements: Announcement[];
}
interface GetBadgeCountRequest {}
interface GetBadgeCountResponse {
  accountUnreadCount: number;
  personaUnreadNotificationCount: number;
  personaUnreadActiveRoomCount: number;
  personaUnreadRequestedRoomCount: number;
  personaUnreadMutedRoomCount: number;
  unreadList: boolean[];
}
interface GetBlockingMembersInCommunityRequest {
  communityId: string;
}
interface GetBlockingMembersInCommunityResponse {
  blockingMembersCount: number;
}
interface GetBlockPersonasRequest {}
interface GetBlockPersonasResponse {
  personaIds: string[];
}
interface GetChatRoomMessagesRequest {
  roomId: string;
  limit?: number;
  untilMessageId?: string;
  sinceMessageId?: string;
}
interface GetChatRoomMessagesResponse {
  messages: ChatRoomMessage[];
  hasNext: boolean;
}
interface GetChatRoomRequest {
  roomId: string;
}
interface GetChatRoomResponse {
  room: ChatRoom;
}
interface GetChatRoomsRequest {
  limit?: number;
  untilMessageId?: string;
  sinceMessageId?: string;
}
interface GetChatRoomsResponse {
  rooms: ChatRoom[];
  hasNext: boolean;
}
interface GetCommunitiesPostNotificationsRequest {
  type: CommunityType;
}
interface GetCommunitiesPostNotificationsResponse {
  communityIds: string[];
}
interface GetCommunitiesRequest {
  communityIds: string[];
}
interface GetCommunitiesResponse {
  communities: Community[];
}
interface GetCommunityBookmarksRequest {
  personaId: string;
}
interface GetCommunityBookmarksResponse {
  communities: Community[];
}
interface GetCommunityInvitablePersonasRequest {
  communityId: string;
  cursor?: string;
}
interface GetCommunityInvitablePersonasResponse {
  invitablePersonas: InvitablePersona[];
  nextCursor?: string;
}
interface GetCommunityInvitationCodeRequest {
  communityId: string;
}
interface GetCommunityInvitationCodeResponse {
  invitationCode: string;
}
interface GetCommunityInvitationRequest {
  invitationCode: string;
}
interface GetCommunityInvitationResponse {
  expiresAt: Timestamp;
  community: Community;
  inviter: Persona;
}
interface GetCommunityJoinRequestsRequest {
  requestIds: string[];
}
interface GetCommunityJoinRequestsResponse {
  joinRequests: CommunityJoinRequest[];
}
interface GetCommunityPostPinRequest {
  postId: string;
}
interface GetCommunityPostPinResponse {
  postPin?: CommunityPostPin;
}
interface GetCommunityRequest {
  communityId: string;
}
interface GetCommunityResponse {
  community: Community;
}
interface GetCommunityStampsRequest {
  communityId: string;
}
interface GetCommunityStampsResponse {
  stamps: CommunityStampDetail[];
}
interface GetCommunityTimelineRequest {
  communityId: string;
  untilCursorId?: string;
  sinceCursorId?: string;
  limit?: number;
  endCursorId?: string;
  mediaOnly?: boolean;
}
interface GetCompletedOrClosedEventCommunitiesRequest {
  cursor?: string;
  limit?: number;
  isAdminOnly?: boolean;
  personaId?: string;
}
interface GetCompletedOrClosedEventCommunitiesResponse {
  communities: Community[];
  nextCursor?: string;
}
interface GetEventCommunitiesWithinCommunityRequest {
  parentCommunityId: string;
  limit?: number;
  cursor?: string;
}
interface GetEventCommunitiesWithinCommunityResponse {
  communities: Community[];
  nextCursor?: string;
}
interface GetExclusiveCommunityMembersRequest {
  communityId: string;
  status: CommunityMemberStatus;
  limit?: number;
  cursor?: string;
}
interface GetExclusiveCommunityMembersResponse {
  members: CommunityMember[];
  cursor?: string;
}
interface GetFeatureFlagsRequest {}
interface GetFeatureFlagsResponse {
  featureFlags: boolean;
}
interface GetFollowersRequest {
  cursorId?: string;
  limit?: number;
  personaId?: string;
}
interface GetFollowersResponse {
  followers: Follower[];
  cursorId: string;
}
interface GetFollowingCountRequest {
  personaId: string;
}
interface GetFollowingCountResponse {
  followingCount: FollowingCount;
}
interface GetFollowingRequestsRequest {
  requestIds: string[];
}
interface GetFollowingRequestsResponse {
  followingRequests: FollowingRequest[];
}
interface GetFollowingsRequest {
  cursorId?: string;
  limit?: number;
  personaId?: string;
}
interface GetFollowingsResponse {
  followings: Following[];
  cursorId: string;
}
interface GetFollowingsTimelineRequest {
  untilCursorId?: string;
  sinceCursorId?: string;
  limit?: number;
  endCursorId?: string;
}
interface GetGlobalCountRequest {
  key: GlobalCounterKey;
}
interface GetGlobalCountResponse {
  count: number;
}
interface GetHashtagTimelineRequest {
  hashtag: string;
  mediaOnly?: boolean;
  untilCursorId?: string;
  sinceCursorId?: string;
  limit?: number;
  endCursorId?: string;
}
interface GetInAppEventStatusAllRequest {}
interface GetInAppEventStatusAllResponse {
  eventStatusAll: InAppEventStatusAll;
}
interface GetInAppEventStatusRequest {
  eventType: PersonaInAppEventType;
}
interface GetInAppEventStatusResponse {
  eventStatus: PersonaInAppEventStatus;
}
interface GetInvitationCodeRequest {
  disableCampaign?: boolean;
}
interface GetInvitationCodeResponse {
  invitationCode: string;
  campaign?: InvitationCampaign;
}
interface GetInvitationRequest {
  invitationCode: string;
}
interface GetInvitationResponse {
  expiresAt: Timestamp;
  profile: Profile;
  campaign?: InvitationCampaign;
}
interface GetLatestRenameLogRequest {}
interface GetLatestRenameLogResponse {
  renameLog?: RenameLog;
  isRenamable: boolean;
}
interface GetLikingPersonasRequest {
  postId: string;
  limit?: number;
  cursor?: string;
}
interface GetLikingPersonasResponse {
  personas: Persona[];
  nextCursor: string;
  hasNext: boolean;
}
interface GetLimitedTimeCampaignRequest {}
interface GetLimitedTimeCampaignResponse {
  giftCampaignInfo: GiftCampaignInfo[];
}
interface GetMediaRequest {
  mediaId: string;
}
interface GetMediaResponse {
  media: Media;
}
interface GetMuteChatRoomsRequest {
  limit?: number;
  untilMessageId?: string;
  sinceMessageId?: string;
}
interface GetMuteChatRoomsResponse {
  rooms: ChatRoom[];
  hasNext: boolean;
}
interface GetMutePersonasRequest {}
interface GetMutePersonasResponse {
  personaIds: string[];
}
interface GetNotificationsRequest {
  activityType?: NotificationActivityType;
  limit?: number;
  untilTimeSeriesId?: string;
  endTimeSeriesId?: string;
  activityTypes: NotificationActivityType[];
}
interface GetNotificationsResponse {
  notifications: Notification[];
  hasNext: boolean;
}
interface GetOngoingEventCommunitiesRequest {
  cursor?: string;
  limit?: number;
  isAdminOnly?: boolean;
  personaId?: string;
}
interface GetOngoingEventCommunitiesResponse {
  communities: Community[];
  nextCursor?: string;
}
interface GetOngoingOrUpcomingEventCommunitiesRequest {
  cursor?: string;
  limit?: number;
  isAdminOnly?: boolean;
  personaId?: string;
}
interface GetOngoingOrUpcomingEventCommunitiesResponse {
  communities: Community[];
  nextCursor?: string;
}
interface GetParticipatingCommunitiesRequest {
  personaId?: string;
  type?: CommunityType;
  limit?: number;
  cursor?: string;
  isAdminOnly?: boolean;
  rejectArchived?: boolean;
}
interface GetParticipatingCommunitiesResponse {
  communities: Community[];
  nextCursor?: string;
}
interface GetParticipatingCommunityMembersRequest {
  communityId: string;
  limit?: number;
  cursor?: string;
}
interface GetParticipatingCommunityMembersResponse {
  members: CommunityMember[];
  cursor?: string;
}
interface GetPastOrClosedEventCommunitiesRequest {
  cursor?: string;
  limit?: number;
  isAdminOnly?: boolean;
}
interface GetPastOrClosedEventCommunitiesResponse {
  communities: Community[];
  nextCursor?: string;
}
interface GetPendingFollowingRequestsRequest {
  cursor?: string;
}
interface GetPendingFollowingRequestsResponse {
  followingRequests: FollowingRequest[];
  nextCursor?: string;
}
interface GetPendingVerificationSocialMediaRequest {}
interface GetPendingVerificationSocialMediaResponse {
  socialMediaTypes: ProfileSocialMediaType[];
}
interface GetPersonaByNameRequest {
  name: string;
}
interface GetPersonalCommunityPostsRequest {
  untilCursorId?: string;
  sinceCursorId?: string;
  limit?: number;
  endCursorId?: string;
}
interface GetPersonalInformationRequest {}
interface GetPersonalInformationResponse {
  email: string;
}
interface GetPersonalTimelineRequest {
  personaId: string;
  untilCursorId?: string;
  sinceCursorId?: string;
  limit?: number;
  endCursorId?: string;
  mediaOnly?: boolean;
}
interface GetPersonaResponse {
  persona: Persona;
}
interface GetPersonasPostNotificationsRequest {}
interface GetPersonasPostNotificationsResponse {
  personaIds: string[];
}
interface GetPersonasRequest {
  personaIds: string[];
}
interface GetPersonasResponse {
  personas: Persona[];
}
interface GetPostableCommunitiesRequest {
  limit?: number;
  cursor?: string;
}
interface GetPostableCommunitiesResponse {
  communities: CommunitySummary[];
  nextCursor?: string;
}
interface GetPostRequest {
  postId: string;
}
interface GetPostResponse {
  post: Post;
}
interface GetPostsRequest {
  postIds: string[];
}
interface GetPostsResponse {
  posts: Post[];
}
interface GetPostStampReactionsRequest {
  postId: string;
  cursor?: string;
  limit?: number;
}
interface GetPostStampReactionsResponse {
  stamps: PostStamp[];
  stampReactions: StampReaction[];
  nextCursor?: string;
}
interface GetProfileByNameRequest {
  name: string;
}
interface GetProfilePostPinRequest {
  postId: string;
}
interface GetProfilePostPinResponse {
  postPin?: ProfilePostPin;
}
interface GetProfileRequest {
  personaId: string;
}
interface GetProfileResponse {
  profile: Profile;
}
interface GetQuotePostsRequest {
  postId: string;
  limit?: number;
  cursor?: string;
}
interface GetQuotePostsResponse {
  posts: Post[];
  nextCursor: string;
  hasNext: boolean;
}
interface GetReactionPostsRequest {
  reactionType: PostReactionType;
  limit?: number;
  cursor?: string;
}
interface GetReactionPostsResponse {
  posts: Post[];
  nextCursor: string;
  hasNext: boolean;
}
interface GetRecommendationsRequest {
  operations: Operation[];
  limit?: number;
}
interface GetRecommendationsResponse {
  followingPersona?: FollowingPersonaResponse;
  community?: CommunityResponse;
  rookiePersona?: RookiePersonaResponse;
  newCommunity?: NewCommunityResponse;
  pickupCommunity?: PickupCommunityResponse;
  verifiedPersona?: VerifiedPersonaResponse;
}
interface GetRecommendedCommunitiesRequest {
  limit?: number;
}
interface GetRecommendedCommunitiesResponse {
  communities: Community[];
}
interface GetRecommendedTimelineRequest {
  untilCursorId?: string;
  sinceCursorId?: string;
  limit?: number;
  endCursorId?: string;
}
interface GetRemoteConfigRequest {}
interface GetRemoteConfigResponse {
  invitationDisabled: boolean;
}
interface GetRemotePushSettingsRequest {}
interface GetRemotePushSettingsResponse {
  like: boolean;
  reply: boolean;
  repost: boolean;
  quote: boolean;
  mention: boolean;
  follow: boolean;
  chat: boolean;
  communityApproval: boolean;
  event: boolean;
  communityInvitation: boolean;
  recommendedPost: boolean;
  reaction: boolean;
  communityGrantAdminPrivileges: boolean;
  communityJoin: boolean;
  followingRequest: boolean;
  personaPostLike: boolean;
  personaPostReaction: boolean;
  personaPostReply: boolean;
  personaPostRepost: boolean;
  personaPostQuote: boolean;
  personaPostMention: boolean;
  communityPostLike: boolean;
  communityPostReaction: boolean;
  communityPostReply: boolean;
  communityPostRepost: boolean;
  communityPostQuote: boolean;
  communityPostMention: boolean;
  serviceAnnouncement: boolean;
}
interface GetRepliesRequest {
  postId: string;
  limit?: number;
  cursor?: string;
}
interface GetRepliesResponse {
  posts: Post[];
  nextCursor: string;
  hasNext: boolean;
  repliesFromOriginalSender: Post[];
}
interface GetReplyAncestorsRequest {
  postId: string;
  limit?: number;
}
interface GetReplyAncestorsResponse {
  posts: Post[];
  basePost: Post;
}
interface GetRepostingPersonasRequest {
  postId: string;
  limit?: number;
  cursor?: string;
}
interface GetRepostingPersonasResponse {
  personas: Persona[];
  nextCursor: string;
  hasNext: boolean;
}
interface GetRequestedChatRoomsRequest {
  limit?: number;
  untilMessageId?: string;
  sinceMessageId?: string;
}
interface GetRequestedChatRoomsResponse {
  rooms: ChatRoom[];
  hasNext: boolean;
}
interface GetSessionRequest {}
interface GetStampsRequest {
  officialStampLanguage?: LanguageCode;
  communityIds: string[];
}
interface GetStampsResponse {
  officialStampSets: OfficialStampSet[];
  communityStampSets: CommunityStampSet[];
  personaObtainedStampSets: PersonaObtainedStampSet[];
}
interface GetStorageRateLimitRequest {}
interface GetStorageRateLimitResponse {
  usage: number;
  limit: number;
  startTime: Timestamp;
  endTime: Timestamp;
}
interface GetSubscribingFeedsRequest {
  untilCursor?: string;
  limit?: number;
  sinceCursor?: string;
  endCursor?: string;
  feedSourceType?: FeedSourceType;
}
interface GetSubscribingFeedsResponse {
  feeds: Feed[];
  nextCursor?: string;
}
interface GetThreadPostsRequest {
  threadPostId: string;
  untilCursorId?: string;
  sinceCursorId?: string;
  limit?: number;
  endCursorId?: string;
}
interface GetTimelineResponse {
  posts: Post[];
}
interface GetTimelineSettingRequest {}
interface GetTimelineSettingResponse {
  personalPostReplySubscribingDisabled: boolean;
  communityPostReplySubscribingDisabled: boolean;
  topicPostReplySubscribingDisabled: boolean;
  eventPostReplySubscribingDisabled: boolean;
}
interface GetUnreadChatRoomCountRequest {}
interface GetUnreadChatRoomCountResponse {
  activeRoomCount: number;
  requestedRoomCount: number;
  mutedRoomCount: number;
}
interface GetUpcomingEventCommunitiesRequest {
  cursor?: string;
  limit?: number;
  isAdminOnly?: boolean;
  personaId?: string;
}
interface GetUpcomingEventCommunitiesResponse {
  communities: Community[];
  nextCursor?: string;
}
interface GetWaitingCommunitiesRequest {
  type?: CommunityType;
  limit?: number;
  cursor?: string;
}
interface GetWaitingCommunitiesResponse {
  communities: Community[];
  nextCursor?: string;
}
interface GiftCampaignInfo {
  campaignId: string;
  campaignKey: GiftCampaignKey;
  startAt: Timestamp;
  endAt: Timestamp;
  campaignRewards: GiftCampaignReward[];
}
interface GiftCampaignReward {
  campaignId: string;
  rewardType: RewardType;
  rewardItemId: string;
  rewardSubItemId?: string;
  rewardOrder: number;
}
interface Header {
  key: string;
  value: string;
}
interface InAppEventStatusAll {
  statuses: number;
}
interface IncrementGlobalCountRequest {
  key: GlobalCounterKey;
}
interface IncrementGlobalCountResponse {
  count: number;
}
interface InvitablePersona {
  personaId: string;
  isSent: boolean;
}
interface InvitationCampaign {
  campaignId: string;
  ogpBackgroundUrl?: string;
  ogpTitleUrl?: string;
  ticketBackgroundTopUrl?: string;
  ticketBackgroundMiddleUrl?: string;
  ticketBackgroundBottomUrl?: string;
  ticketTitleUrl?: string;
  backgroundUrl?: string;
  backgroundColor?: string;
  ticketButtonColor?: string;
  instagramCardStartColor?: string;
  instagramCardEndColor?: string;
  instagramCardTitleUrl?: string;
  ticketStep1Url?: string;
  ticketStep2Url?: string;
}
interface JoinCommunityRequest {
  communityId: string;
  skipBlockingMemberCheck: boolean;
}
interface JoinCommunityResponse {
  community: Community;
}
interface LeaveCommunityRequest {
  communityId: string;
}
interface LeaveCommunityResponse {
  leftChildCommunityIds: string[];
}
interface LinkCard {
  cardId: string;
  url: string;
  status: LinkCardStatus;
  contentType: ContentType;
  title: string;
  description: string;
  imageUrl: string;
  faviconUrl: string;
}
interface MakeChatRoomInvisibleRequest {
  roomId: string;
}
interface MakeChatRoomInvisibleResponse {
  room: ChatRoom;
}
interface MakeChatRoomMuteRequest {
  roomId: string;
}
interface MakeChatRoomMuteResponse {
  room: ChatRoom;
}
interface MakeChatRoomUnmuteRequest {
  roomId: string;
}
interface MakeChatRoomUnmuteResponse {
  room: ChatRoom;
}
interface MakeCommunityPostNotificationDisabledRequest {
  communityId: string;
}
interface MakeCommunityPostNotificationDisabledResponse {
  community: Community;
}
interface MakeCommunityPostNotificationEnabledRequest {
  communityId: string;
}
interface MakeCommunityPostNotificationEnabledResponse {
  community: Community;
}
interface MakeCommunitySubscriptionDisabledRequest {
  communityId: string;
}
interface MakeCommunitySubscriptionDisabledResponse {
  community: Community;
}
interface MakeCommunitySubscriptionEnabledRequest {
  communityId: string;
}
interface MakeCommunitySubscriptionEnabledResponse {
  community: Community;
}
interface MakePersonaBlockRequest {
  personaId: string;
}
interface MakePersonaBlockResponse {
  profile: Profile;
}
interface MakePersonaMuteRequest {
  personaId: string;
}
interface MakePersonaMuteResponse {
  persona: Persona;
}
interface MakePersonaPostNotificationDisabledRequest {
  personaId: string;
}
interface MakePersonaPostNotificationDisabledResponse {
  profile: Profile;
}
interface MakePersonaPostNotificationEnabledRequest {
  personaId: string;
}
interface MakePersonaPostNotificationEnabledResponse {
  profile: Profile;
}
interface MakePersonaUnblockRequest {
  personaId: string;
}
interface MakePersonaUnblockResponse {
  profile: Profile;
}
interface MakePersonaUnmuteRequest {
  personaId: string;
}
interface MakePersonaUnmuteResponse {
  persona: Persona;
}
interface ManagedPersona {
  profile: Profile;
  accessToken: string;
  isSharedPersona: boolean;
  eventStatusAll: InAppEventStatusAll;
}
interface MarkAnnouncementAsReadRequest {
  announcementId: string;
}
interface MarkAnnouncementAsReadResponse {}
interface MarkNotificationAsReadRequest {
  timeSeriesId: string;
}
interface MarkNotificationAsReadResponse {}
interface MarkNotificationsAsReadBeforeTimeRequest {
  latestTimeSeriesId: string;
}
interface MarkNotificationsAsReadResponse {}
interface Media {
  mediaId: string;
  category: Category;
  status: MediaStatus;
  avatar?: Avatar;
  postImage?: PostImage;
  postVideo?: PostVideo;
  stamp?: MediaStamp;
  description?: string;
}
interface MediaStamp {
  url: string;
  mimeType: string;
  height: number;
  width: number;
}
interface NewCommunityResponse {
  communities: Community[];
  recommendedCommunities: RecommendedCommunity[];
}
interface NewTokenResponse {
  refreshToken: string;
  expiresAt: Timestamp;
  managedPersonas: ManagedPersona[];
  isAccountFrozen: boolean;
  warnings: PersonaWarning[];
}
interface Notification {
  activityType: NotificationActivityType;
  createdAt: Timestamp;
  timeSeriesId: string;
  issuerId: string;
  postId?: string;
  communityRequestId?: string;
  communityId?: string;
  reaction?: NotificationReaction;
  followingRequestId?: string;
}
interface NotificationReaction {
  stampId: string;
  imageUrl: string;
}
interface OfficialStamp {
  stampId: string;
  index: number;
  searchTags: string[];
  url: string;
}
interface OfficialStampSet {
  name: string;
  spriteUrl: string;
  stamps: OfficialStamp[];
  stampSetId: string;
  startAt?: Timestamp;
  endAt?: Timestamp;
  stampSetType: StampSetType;
}
interface Persona {
  personaId: string;
  name: string;
  displayName: string;
  avatarUrl: string;
  isDeleted: boolean;
  following: boolean;
  followed: boolean;
  profileText: string;
  profileImageUrl: string;
  statusIcon?: StatusIcon;
  statusText?: string;
  isPersonaFrozen: boolean;
  verificationType: VerificationType;
  isBlocking: boolean;
  visibility: PersonaVisibility;
  followingStatus: FollowingStatus;
  createdAt: Timestamp;
  personaType: PersonaType;
}
interface PersonaConnectivity {
  following: boolean;
  countOfFollowingAmongMyFollowings: number;
  followingPersonasAmongMyFollowings: Persona[];
  followed: boolean;
  followingStatus: FollowingStatus;
}
interface PersonaName {
  personaId: string;
  name: string;
}
interface PersonaObtainedStampSet {
  name: string;
  spriteUrl: string;
  stamps: OfficialStamp[];
  obtainedStamps: OfficialStamp[];
  stampSetId: string;
  startAt?: Timestamp;
  endAt?: Timestamp;
}
interface PersonasResult {
  personaWithConnectivities: PersonaWithConnectivity[];
  nextCursor: string;
}
interface PersonaWarning {
  warningId: string;
  personaId: string;
  titleJp: string;
  bodyJp: string;
  titleEn: string;
  bodyEn: string;
}
interface PersonaWithConnectivity {
  persona: Persona;
  connectivity: PersonaConnectivity;
}
interface PickupCommunityResponse {
  recommendedCommunities: RecommendedCommunity[];
}
interface PinCommunityPostRequest {
  communityId: string;
  postId: string;
}
interface PinCommunityPostResponse {
  community: Community;
}
interface PinProfilePostRequest {
  postId: string;
}
interface PinProfilePostResponse {
  profile: Profile;
}
interface Post {
  postId: string;
  timeSeriesId: string;
  createdAt: Timestamp;
  personaId: string;
  visibility?: PostVisibility;
  isDeleted?: boolean;
  medias?: Media[];
  repostCount?: number;
  likesCount?: number;
  repliesCount?: number;
  quotedCount?: number;
  text?: string;
  inReplyToPostId?: string;
  repostId?: string;
  quotePostId?: string;
  liked?: boolean;
  reposted?: boolean;
  bookmarked?: boolean;
  referencePost?: Post;
  quoted?: boolean;
  replied?: boolean;
  linkCards?: LinkCard[];
  isMuted?: boolean;
  isSensitive?: boolean;
  community?: CommunitySummary;
  attachedCommunity?: Community;
  mentions?: PersonaName[];
  decorations?: number[];
  stamps?: PostStamp[];
  readerStampId?: string;
  isRestricted?: boolean;
  maskType?: PostMaskType;
  maskCaption?: string;
  publishingType?: PostPublishingType;
}
interface PostImage {
  largeImageUrl: string;
  largeImageMimeType: string;
  largeImageHeight: number;
  largeImageWidth: number;
  smallImageUrl: string;
  smallImageMimeType: string;
  smallImageHeight: number;
  smallImageWidth: number;
  blurhash: string;
}
interface PostsResult {
  posts: Post[];
  nextCursor: string;
}
interface PostStamp {
  stamp: Stamp;
  count: number;
}
interface PostVideo {
  url: string;
  mimeType: string;
  height: number;
  width: number;
  previewImageUrl: string;
  previewImageMimeType: string;
  previewImageHeight: number;
  previewImageWidth: number;
  blurhash: string;
  duration: number;
}
interface PrepareMediaUploadingRequest {
  mimeType: string;
  dataSize: number;
  category: Category;
  communityId?: string;
  description?: string;
}
interface PrepareMediaUploadingResponse {
  mediaId: string;
  request: Request;
}
interface Profile {
  persona: Persona;
  followingCount: number;
  followedCount: number;
  text: string;
  profileImageUrl: string;
  link: string;
  personaConnectivity: PersonaConnectivity;
  isMuted: boolean;
  postPins: ProfilePostPin[];
  isBlocking: boolean;
  isBlocked: boolean;
  isPostNotificationTarget: boolean;
  socialMedia: ProfileSocialMedia[];
}
interface ProfilePostPin {
  postPinId: string;
  postId: string;
}
interface ProfileSocialMedia {
  socialMediaType: ProfileSocialMediaType;
  username: string;
  verified: boolean;
}
interface ReadPersonaWarningRequest {
  warningId: string;
}
interface ReadPersonaWarningResponse {}
interface RecommendedCommunity {
  community: Community;
  isNew: boolean;
  pickupCommunityCategory: PickupCommunityCategory;
}
interface RecommendedPersona {
  persona: PersonaWithConnectivity;
  isNew: boolean;
}
interface RefreshTokenRequest {
  refreshToken: string;
}
interface RegisterFCMTokenRequest {
  fcmToken: string;
  platform: PlatformType;
}
interface RegisterFCMTokenResponse {}
interface RejectFollowingRequestRequest {
  requestId: string;
}
interface RejectFollowingRequestResponse {}
interface RemoveCommunityBookmarkRequest {
  communityId: string;
}
interface RemoveCommunityBookmarkResponse {
  community: Community;
}
interface RemoveCommunityPostPinRequest {
  communityPostPinId: string;
}
interface RemoveCommunityPostPinResponse {
  community: Community;
}
interface RemoveProfilePostPinRequest {
  postPinId: string;
}
interface RemoveProfilePostPinResponse {
  profile: Profile;
}
interface RemoveStampFromOwnPostRequest {
  postId: string;
  personaId: string;
  stampId: string;
}
interface RemoveStampFromOwnPostResponse {
  post: Post;
}
interface RemoveStampFromPostRequest {
  postId: string;
  stampId: string;
}
interface RemoveStampFromPostResponse {
  post: Post;
}
interface RenameLog {
  oldName: string;
  newName: string;
  createdAt: Timestamp;
}
interface ReportChatRoomMessageRequest {
  roomId: string;
  messageId: string;
  reasonType: ReportReasonType;
  reasonContent: string;
}
interface ReportChatRoomMessageResponse {
  message: ChatRoomMessage;
}
interface ReportCommunityRequest {
  communityId: string;
  reasonType: ReportReasonType;
  reasonContent: string;
}
interface ReportCommunityResponse {
  community: Community;
}
interface ReportPersonaRequest {
  personaId: string;
  reasonType: ReportReasonType;
  reasonContent: string;
  rightInfringementTarget?: ReportRightInfringementTarget;
}
interface ReportPersonaResponse {
  persona: Persona;
}
interface ReportPostRequest {
  postId: string;
  reasonType: ReportReasonType;
  reasonContent: string;
  rightInfringementTarget?: ReportRightInfringementTarget;
}
interface ReportPostResponse {
  post: Post;
}
interface Request {
  url: string;
  method: string;
  headers: Header[];
}
interface RequestJoinCommunityRequest {
  communityId: string;
  skipBlockingMemberCheck: boolean;
}
interface RequestJoinCommunityResponse {
  community: Community;
}
interface ResendEmailPassCodeRequest {
  verificationId: string;
}
interface ResendEmailPassCodeResponse {}
interface ResendSMSPassCodeRequest {
  verificationId: string;
}
interface ResendSMSPassCodeResponse {}
interface RestrictCommunityPostRequest {
  postId: string;
}
interface RestrictCommunityPostResponse {
  post: Post;
}
interface RookiePersonaResponse {
  personas: PersonaWithConnectivity[];
  recommendedPersonas: RecommendedPersona[];
}
interface SearchChatRoomsRequest {
  isGroup: boolean;
  memberIds: string[];
}
interface SearchChatRoomsResponse {
  rooms: ChatRoom[];
}
interface SearchEventOption {
  startTimeAfter?: Timestamp;
  endTimeAfter?: Timestamp;
}
interface SearchOperation {
  type: SearchType;
  operationId: number;
  untilCursor?: string;
  sinceCursor?: string;
  limit?: number;
  endCursor?: string;
  mediaAttachedOnly?: boolean;
  startTimeAfter?: Timestamp;
  endTimeAfter?: Timestamp;
  personaOption?: SearchPersonaOption;
  postOption?: SearchPostOption;
  eventOption?: SearchEventOption;
}
interface SearchPersonaOption {
  botOnly: boolean;
}
interface SearchPostOption {
  mediaAttachedOnly: boolean;
  personaId?: string;
}
interface SearchRequest {
  query: string;
  operations: SearchOperation[];
}
interface SearchResponse {
  results: SearchResult[];
}
interface SearchResult {
  operationId: number;
  personasResult?: PersonasResult;
  postsResult?: PostsResult;
  communitiesResult?: CommunitiesResult;
}
interface SearchTypeaheadItem {
  itemType: ItemType;
  persona?: Persona;
}
interface SearchTypeaheadRequest {
  query: string;
}
interface SearchTypeaheadResponse {
  items: SearchTypeaheadItem[];
}
interface SendCommunityInvitationRequest {
  communityId: string;
  personaIds: string[];
}
interface SendCommunityInvitationResponse {}
interface SendDirectMessageRequest {
  receiverId: string;
  text?: string;
  mediaIds: string[];
  postId?: string;
}
interface SendDirectMessageResponse {
  message: ChatRoomMessage;
}
interface SendFollowingRequestRequest {
  personaId: string;
}
interface SendFollowingRequestResponse {
  persona: Persona;
}
interface SendGroupMessageRequest {
  receiverIds: string[];
  text?: string;
  mediaIds: string[];
}
interface SendGroupMessageResponse {
  message: ChatRoomMessage;
}
interface SendMessageToRoomRequest {
  roomId: string;
  text?: string;
  mediaIds: string[];
}
interface SendMessageToRoomResponse {
  message: ChatRoomMessage;
}
interface SessionManagedPersona {
  profile: Profile;
  isSharedPersona: boolean;
  eventStatusAll: InAppEventStatusAll;
}
interface SessionResponse {
  sessionManagedPersonas: SessionManagedPersona[];
  activePersonaId?: string;
  isAccountFrozen: boolean;
}
interface SetCommunityTagsRequest {
  communityId: string;
  tags: string[];
}
interface SetCommunityTagsResponse {
  community: Community;
}
interface SigninRequest {
  tokenProvider: TokenProvider;
  idToken: string;
}
interface SignOutRequest {
  refreshToken: string;
  fcmToken?: string;
}
interface SignOutResponse {}
interface SignupRequest {
  tokenProvider: TokenProvider;
  idToken: string;
  invitationCode?: string;
  invitationKind?: InvitationKind;
}
interface Stamp {
  stampId: string;
  url: string;
}
interface StampReaction {
  stampId: string;
  persona: Persona;
}
interface StartEmailAuthenticationRequest {
  email: string;
  languageCode: AuthenticationLanguageCode;
  type: AuthenticationType;
  platform: AuthenticationPlatform;
  invitationCode?: string;
  invitationKind?: InvitationKind;
}
interface StartEmailAuthenticationResponse {
  verificationId: string;
}
interface StartSMSAuthenticationRequest {
  countryCode: string;
  phoneNumber: string;
  languageCode: AuthenticationLanguageCode;
  type: AuthenticationType;
  platform: AuthenticationPlatform;
  invitationCode?: string;
  invitationKind?: InvitationKind;
}
interface StartSMSAuthenticationResponse {
  verificationId: string;
}
interface StatusIcon {
  statusIconType: StatusIconType;
  statusIcon: string;
}
interface SwitchPersonaRequest {
  personaId: string;
}
interface SwitchPersonaResponse {}
interface Timestamp {
  seconds: number;
  nanos: number;
}
interface UpdateChatRoomTitleRequest {
  roomId: string;
  title: string;
}
interface UpdateChatRoomTitleResponse {
  room: ChatRoom;
}
interface UpdateCommunityLastAccessTimeRequest {
  communityId: string;
}
interface UpdateCommunityLastAccessTimeResponse {}
interface UpdateCommunityRequest {
  communityId: string;
  name?: string;
  purpose?: string;
  coverImageMediaId?: string;
  accessLevel?: CommunityAccessLevel;
}
interface UpdateCommunityResponse {
  community: Community;
}
interface UpdateDisplayNameRequest {
  displayName: string;
}
interface UpdateDisplayNameResponse {
  persona: Persona;
}
interface UpdateEventCommunityRequest {
  communityId: string;
  name?: string;
  purpose?: string;
  coverImageMediaId?: string;
  accessLevel?: CommunityAccessLevel;
  startAt?: Timestamp;
  endAt?: Timestamp;
  locationType?: CommunityEventLocationType;
}
interface UpdateEventCommunityResponse {
  community: Community;
}
interface UpdateInAppEventDoneRequest {
  eventType: PersonaInAppEventType;
}
interface UpdateInAppEventDoneResponse {}
interface UpdateNameRequest {
  name: string;
}
interface UpdateNameResponse {
  profile: Profile;
}
interface UpdateProfileRequest {
  displayName?: string;
  profileText?: string;
  statusIcon?: StatusIcon;
  statusText?: string;
  link?: string;
}
interface UpdateProfileResponse {
  profile: Profile;
}
interface UpdateProfileSocialMediaRequest {
  socialMediaType: ProfileSocialMediaType;
  username: string;
  forceVerifiedUpdate: boolean;
}
interface UpdateProfileSocialMediaResponse {
  profile: Profile;
}
interface UpdateRemotePushSettingsRequest {
  like?: boolean;
  reply?: boolean;
  repost?: boolean;
  quote?: boolean;
  mention?: boolean;
  follow?: boolean;
  chat?: boolean;
  communityApproval?: boolean;
  event?: boolean;
  communityInvitation?: boolean;
  recommendedPost?: boolean;
  reaction?: boolean;
  communityGrantAdminPrivileges?: boolean;
  communityJoin?: boolean;
  followingRequest?: boolean;
  personaPostLike?: boolean;
  personaPostReaction?: boolean;
  personaPostReply?: boolean;
  personaPostRepost?: boolean;
  personaPostQuote?: boolean;
  personaPostMention?: boolean;
  communityPostLike?: boolean;
  communityPostReaction?: boolean;
  communityPostReply?: boolean;
  communityPostRepost?: boolean;
  communityPostQuote?: boolean;
  communityPostMention?: boolean;
  serviceAnnouncement?: boolean;
}
interface UpdateRemotePushSettingsResponse {}
interface UpdateTimelineSettingRequest {
  personalPostReplySubscribingDisabled?: boolean;
  communityPostReplySubscribingDisabled?: boolean;
  topicPostReplySubscribingDisabled?: boolean;
  eventPostReplySubscribingDisabled?: boolean;
}
interface UpdateTimelineSettingResponse {}
interface UpdateTopicCommunityRequest {
  communityId: string;
  name?: string;
  purpose?: string;
  coverImageMediaId?: string;
  accessLevel?: CommunityAccessLevel;
  searchable?: boolean;
}
interface UpdateTopicCommunityResponse {
  community: Community;
}
interface VerifiedPersonaResponse {
  recommendedPersonas: RecommendedPersona[];
}
interface VerifyEmailAuthenticationRequest {
  verificationId: string;
  passCode: number;
}
interface VerifyEmailSessionAuthenticationRequest {
  verificationId: string;
  passCode: number;
}
interface VerifyEmailSessionAuthenticationResponse {
  sessionResponse: SessionResponse;
}
interface VerifySMSAuthenticationRequest {
  verificationId: string;
  passCode: number;
}
//#endregion
export { AcceptChatRoomRequest, AcceptChatRoomResponse, AddMembersToChatRoomRequest, AddMembersToChatRoomResponse, AddStampToPostRequest, AddStampToPostResponse, Announcement, ApplyForVerificationRequest, ApplyForVerificationResponse, ApproveFollowingRequestRequest, ApproveFollowingRequestResponse, ApproveJoinCommunityRequest, ApproveJoinCommunityResponse, ArchiveCommunityRequest, ArchiveCommunityResponse, AuthenticationLanguageCode, AuthenticationPlatform, AuthenticationType, Avatar, BookmarkCommunityRequest, BookmarkCommunityResponse, CancelFollowingRequestRequest, CancelFollowingRequestResponse, CancelJoinCommunityRequestRequest, CancelJoinCommunityRequestResponse, Category, ChangeCommunityAdminsRequest, ChangeCommunityAdminsResponse, ChangeCommunityPostSubscriptionTypeRequest, ChangeCommunityPostSubscriptionTypeResponse, ChangeMyPersonaVisibilityRequest, ChangeMyPersonaVisibilityResponse, ChatRoom, ChatRoomMember, ChatRoomMessage, ChatRoomMessageType, ChatRoomStatus, CheckPendingPostRequest, CheckPendingPostResponse, CloseEventCommunityRequest, CloseEventCommunityResponse, CommunitiesResult, Community, CommunityAccessLevel, CommunityAggregationPost, CommunityApproveStatus, CommunityEventLocationType, CommunityEventStatus, CommunityJoinRequest, CommunityMember, CommunityMemberStatus, CommunityPostConstraint, CommunityPostPin, CommunityPostSubscriptionType, CommunityResponse, CommunityRule, CommunityStamp, CommunityStampDetail, CommunityStampSet, CommunitySummary, CommunityType, CommunityVisibility, ContentType, CreateBookmarkRequest, CreateBookmarkResponse, CreateChatRoomRequest, CreateChatRoomResponse, CreateCommunityRequest, CreateCommunityResponse, CreateEventCommunityRequest, CreateEventCommunityResponse, CreateFollowingRequest, CreateFollowingResponse, CreateLikeRequest, CreateLikeResponse, CreatePersonaFromSessionRequest, CreatePersonaRequest, CreatePostAndEventCommunityRequest, CreatePostAndEventCommunityResponse, CreatePostRequest, CreatePostResponse, CreateTopicCommunityRequest, CreateTopicCommunityResponse, DeleteAccountRequest, DeleteAccountResponse, DeleteBookmarkRequest, DeleteBookmarkResponse, DeleteCommunityStampRequest, DeleteCommunityStampResponse, DeleteExcludedCommunityMemberRequest, DeleteExcludedCommunityMemberResponse, DeleteExcludedCommunityMembersRequest, DeleteExcludedCommunityMembersResponse, DeleteFCMTokenRequest, DeleteFCMTokenResponse, DeleteFollowingRequest, DeleteFollowingResponse, DeleteLikeRequest, DeleteLikeResponse, DeletePostRequest, DeletePostResponse, DeleteRepostRequest, DeleteRepostResponse, DeleteSessionRequest, DeleteSessionResponse, DenyJoinCommunityRequest, DenyJoinCommunityResponse, EventSchedule, ExcludeCommunityMemberRequest, ExcludeCommunityMemberResponse, ExcludeCommunityMembersRequest, ExcludeCommunityMembersResponse, ExitChatRoomRequest, ExitChatRoomResponse, Feed, FeedSourceType, FeedType, Follower, Following, FollowingCount, FollowingPersonaResponse, FollowingRequest, FollowingRequestStatus, FollowingStatus, GetAnnouncementsRequest, GetAnnouncementsResponse, GetBadgeCountRequest, GetBadgeCountResponse, GetBlockPersonasRequest, GetBlockPersonasResponse, GetBlockingMembersInCommunityRequest, GetBlockingMembersInCommunityResponse, GetChatRoomMessagesRequest, GetChatRoomMessagesResponse, GetChatRoomRequest, GetChatRoomResponse, GetChatRoomsRequest, GetChatRoomsResponse, GetCommunitiesPostNotificationsRequest, GetCommunitiesPostNotificationsResponse, GetCommunitiesRequest, GetCommunitiesResponse, GetCommunityBookmarksRequest, GetCommunityBookmarksResponse, GetCommunityInvitablePersonasRequest, GetCommunityInvitablePersonasResponse, GetCommunityInvitationCodeRequest, GetCommunityInvitationCodeResponse, GetCommunityInvitationRequest, GetCommunityInvitationResponse, GetCommunityJoinRequestsRequest, GetCommunityJoinRequestsResponse, GetCommunityPostPinRequest, GetCommunityPostPinResponse, GetCommunityRequest, GetCommunityResponse, GetCommunityStampsRequest, GetCommunityStampsResponse, GetCommunityTimelineRequest, GetCompletedOrClosedEventCommunitiesRequest, GetCompletedOrClosedEventCommunitiesResponse, GetEventCommunitiesWithinCommunityRequest, GetEventCommunitiesWithinCommunityResponse, GetExclusiveCommunityMembersRequest, GetExclusiveCommunityMembersResponse, GetFeatureFlagsRequest, GetFeatureFlagsResponse, GetFollowersRequest, GetFollowersResponse, GetFollowingCountRequest, GetFollowingCountResponse, GetFollowingRequestsRequest, GetFollowingRequestsResponse, GetFollowingsRequest, GetFollowingsResponse, GetFollowingsTimelineRequest, GetGlobalCountRequest, GetGlobalCountResponse, GetHashtagTimelineRequest, GetInAppEventStatusAllRequest, GetInAppEventStatusAllResponse, GetInAppEventStatusRequest, GetInAppEventStatusResponse, GetInvitationCodeRequest, GetInvitationCodeResponse, GetInvitationRequest, GetInvitationResponse, GetLatestRenameLogRequest, GetLatestRenameLogResponse, GetLikingPersonasRequest, GetLikingPersonasResponse, GetLimitedTimeCampaignRequest, GetLimitedTimeCampaignResponse, GetMediaRequest, GetMediaResponse, GetMuteChatRoomsRequest, GetMuteChatRoomsResponse, GetMutePersonasRequest, GetMutePersonasResponse, GetNotificationsRequest, GetNotificationsResponse, GetOngoingEventCommunitiesRequest, GetOngoingEventCommunitiesResponse, GetOngoingOrUpcomingEventCommunitiesRequest, GetOngoingOrUpcomingEventCommunitiesResponse, GetParticipatingCommunitiesRequest, GetParticipatingCommunitiesResponse, GetParticipatingCommunityMembersRequest, GetParticipatingCommunityMembersResponse, GetPastOrClosedEventCommunitiesRequest, GetPastOrClosedEventCommunitiesResponse, GetPendingFollowingRequestsRequest, GetPendingFollowingRequestsResponse, GetPendingVerificationSocialMediaRequest, GetPendingVerificationSocialMediaResponse, GetPersonaByNameRequest, GetPersonaResponse, GetPersonalCommunityPostsRequest, GetPersonalInformationRequest, GetPersonalInformationResponse, GetPersonalTimelineRequest, GetPersonasPostNotificationsRequest, GetPersonasPostNotificationsResponse, GetPersonasRequest, GetPersonasResponse, GetPostRequest, GetPostResponse, GetPostStampReactionsRequest, GetPostStampReactionsResponse, GetPostableCommunitiesRequest, GetPostableCommunitiesResponse, GetPostsRequest, GetPostsResponse, GetProfileByNameRequest, GetProfilePostPinRequest, GetProfilePostPinResponse, GetProfileRequest, GetProfileResponse, GetQuotePostsRequest, GetQuotePostsResponse, GetReactionPostsRequest, GetReactionPostsResponse, GetRecommendationsRequest, GetRecommendationsResponse, GetRecommendedCommunitiesRequest, GetRecommendedCommunitiesResponse, GetRecommendedTimelineRequest, GetRemoteConfigRequest, GetRemoteConfigResponse, GetRemotePushSettingsRequest, GetRemotePushSettingsResponse, GetRepliesRequest, GetRepliesResponse, GetReplyAncestorsRequest, GetReplyAncestorsResponse, GetRepostingPersonasRequest, GetRepostingPersonasResponse, GetRequestedChatRoomsRequest, GetRequestedChatRoomsResponse, GetSessionRequest, GetStampsRequest, GetStampsResponse, GetStorageRateLimitRequest, GetStorageRateLimitResponse, GetSubscribingFeedsRequest, GetSubscribingFeedsResponse, GetThreadPostsRequest, GetTimelineResponse, GetTimelineSettingRequest, GetTimelineSettingResponse, GetUnreadChatRoomCountRequest, GetUnreadChatRoomCountResponse, GetUpcomingEventCommunitiesRequest, GetUpcomingEventCommunitiesResponse, GetWaitingCommunitiesRequest, GetWaitingCommunitiesResponse, GiftCampaignInfo, GiftCampaignKey, GiftCampaignReward, GlobalCounterKey, Header, InAppEventStatusAll, IncrementGlobalCountRequest, IncrementGlobalCountResponse, InvitablePersona, InvitationCampaign, InvitationKind, ItemType, JoinCommunityRequest, JoinCommunityResponse, LanguageCode, LeaveCommunityRequest, LeaveCommunityResponse, LinkCard, LinkCardStatus, MakeChatRoomInvisibleRequest, MakeChatRoomInvisibleResponse, MakeChatRoomMuteRequest, MakeChatRoomMuteResponse, MakeChatRoomUnmuteRequest, MakeChatRoomUnmuteResponse, MakeCommunityPostNotificationDisabledRequest, MakeCommunityPostNotificationDisabledResponse, MakeCommunityPostNotificationEnabledRequest, MakeCommunityPostNotificationEnabledResponse, MakeCommunitySubscriptionDisabledRequest, MakeCommunitySubscriptionDisabledResponse, MakeCommunitySubscriptionEnabledRequest, MakeCommunitySubscriptionEnabledResponse, MakePersonaBlockRequest, MakePersonaBlockResponse, MakePersonaMuteRequest, MakePersonaMuteResponse, MakePersonaPostNotificationDisabledRequest, MakePersonaPostNotificationDisabledResponse, MakePersonaPostNotificationEnabledRequest, MakePersonaPostNotificationEnabledResponse, MakePersonaUnblockRequest, MakePersonaUnblockResponse, MakePersonaUnmuteRequest, MakePersonaUnmuteResponse, ManagedPersona, MarkAnnouncementAsReadRequest, MarkAnnouncementAsReadResponse, MarkNotificationAsReadRequest, MarkNotificationAsReadResponse, MarkNotificationsAsReadBeforeTimeRequest, MarkNotificationsAsReadResponse, Media, MediaStamp, MediaStatus, NewCommunityResponse, NewTokenResponse, Notification, NotificationActivityType, NotificationReaction, OfficialStamp, OfficialStampSet, Operation, Persona, PersonaConnectivity, PersonaInAppEventStatus, PersonaInAppEventType, PersonaName, PersonaObtainedStampSet, PersonaType, PersonaVisibility, PersonaWarning, PersonaWithConnectivity, PersonasResult, PickupCommunityCategory, PickupCommunityResponse, PinCommunityPostRequest, PinCommunityPostResponse, PinProfilePostRequest, PinProfilePostResponse, PlatformType, Post, PostImage, PostMaskType, PostPublishingType, PostReactionType, PostStamp, PostVideo, PostVisibility, PostsResult, PrepareMediaUploadingRequest, PrepareMediaUploadingResponse, Profile, ProfilePostPin, ProfileSocialMedia, ProfileSocialMediaType, ReadPersonaWarningRequest, ReadPersonaWarningResponse, RecommendedCommunity, RecommendedPersona, RefreshTokenRequest, RegisterFCMTokenRequest, RegisterFCMTokenResponse, RejectFollowingRequestRequest, RejectFollowingRequestResponse, RemoveCommunityBookmarkRequest, RemoveCommunityBookmarkResponse, RemoveCommunityPostPinRequest, RemoveCommunityPostPinResponse, RemoveProfilePostPinRequest, RemoveProfilePostPinResponse, RemoveStampFromOwnPostRequest, RemoveStampFromOwnPostResponse, RemoveStampFromPostRequest, RemoveStampFromPostResponse, RenameLog, ReportChatRoomMessageRequest, ReportChatRoomMessageResponse, ReportCommunityRequest, ReportCommunityResponse, ReportPersonaRequest, ReportPersonaResponse, ReportPostRequest, ReportPostResponse, ReportReasonType, ReportRightInfringementTarget, Request, RequestJoinCommunityRequest, RequestJoinCommunityResponse, ResendEmailPassCodeRequest, ResendEmailPassCodeResponse, ResendSMSPassCodeRequest, ResendSMSPassCodeResponse, RestrictCommunityPostRequest, RestrictCommunityPostResponse, RewardType, RookiePersonaResponse, SearchChatRoomsRequest, SearchChatRoomsResponse, SearchEventOption, SearchOperation, SearchPersonaOption, SearchPostOption, SearchRequest, SearchResponse, SearchResult, SearchType, SearchTypeaheadItem, SearchTypeaheadRequest, SearchTypeaheadResponse, SendCommunityInvitationRequest, SendCommunityInvitationResponse, SendDirectMessageRequest, SendDirectMessageResponse, SendFollowingRequestRequest, SendFollowingRequestResponse, SendGroupMessageRequest, SendGroupMessageResponse, SendMessageToRoomRequest, SendMessageToRoomResponse, SessionManagedPersona, SessionResponse, SetCommunityTagsRequest, SetCommunityTagsResponse, SignOutRequest, SignOutResponse, SigninRequest, SignupRequest, Stamp, StampReaction, StampSetType, StartEmailAuthenticationRequest, StartEmailAuthenticationResponse, StartSMSAuthenticationRequest, StartSMSAuthenticationResponse, StatusIcon, StatusIconType, SwitchPersonaRequest, SwitchPersonaResponse, Timestamp, TokenProvider, UpdateChatRoomTitleRequest, UpdateChatRoomTitleResponse, UpdateCommunityLastAccessTimeRequest, UpdateCommunityLastAccessTimeResponse, UpdateCommunityRequest, UpdateCommunityResponse, UpdateDisplayNameRequest, UpdateDisplayNameResponse, UpdateEventCommunityRequest, UpdateEventCommunityResponse, UpdateInAppEventDoneRequest, UpdateInAppEventDoneResponse, UpdateNameRequest, UpdateNameResponse, UpdateProfileRequest, UpdateProfileResponse, UpdateProfileSocialMediaRequest, UpdateProfileSocialMediaResponse, UpdateRemotePushSettingsRequest, UpdateRemotePushSettingsResponse, UpdateTimelineSettingRequest, UpdateTimelineSettingResponse, UpdateTopicCommunityRequest, UpdateTopicCommunityResponse, VerificationType, VerifiedPersonaResponse, VerifyEmailAuthenticationRequest, VerifyEmailSessionAuthenticationRequest, VerifyEmailSessionAuthenticationResponse, VerifySMSAuthenticationRequest };