/* eslint-disable no-plusplus,no-lonely-if */ "use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    default: function() {
        return _default;
    },
    defaultTags: function() {
        return defaultTags;
    },
    defineStyleNode: function() {
        return defineStyleNode;
    },
    toListNodes: function() {
        return toListNodes;
    }
});
var _pluginhelper = require("@bbob/plugin-helper");
function _extends() {
    _extends = Object.assign || function(target) {
        for(var i = 1; i < arguments.length; i++){
            var source = arguments[i];
            for(var key in source){
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }
        return target;
    };
    return _extends.apply(this, arguments);
}
var isStartsWith = function(node, type) {
    return node[0] === type;
};
var styleAttrs = function(attrs) {
    var values = attrs || {};
    return Object.keys(values).reduce(function(acc, key) {
        var value = values[key];
        if (typeof value === "string") {
            if (key === "color") {
                return acc.concat("color:" + value + ";");
            }
            if (key === "size") {
                return acc.concat("font-size:" + value + ";");
            }
        }
        return acc;
    }, []).join(" ");
};
var toListNodes = function(content) {
    if (content && Array.isArray(content)) {
        return content.reduce(function(acc, node) {
            var listItem = acc[acc.length - 1];
            // *Entry
            if ((0, _pluginhelper.isStringNode)(node) && isStartsWith(String(node), "*")) {
                // from '*Entry' to 'Entry'
                var _$content = String(node).slice(1);
                acc.push(_pluginhelper.TagNode.create("li", {}, [
                    _$content
                ]));
                return acc;
            }
            // { tag: '*', attrs: {}, content: [] }
            if ((0, _pluginhelper.isTagNode)(node) && _pluginhelper.TagNode.isOf(node, "*")) {
                acc.push(_pluginhelper.TagNode.create("li", {}, []));
                return acc;
            }
            if (!(0, _pluginhelper.isTagNode)(listItem)) {
                acc.push(node);
                return acc;
            }
            if (listItem && (0, _pluginhelper.isTagNode)(listItem) && Array.isArray(listItem.content)) {
                listItem.content = listItem.content.concat(node);
                return acc;
            }
            acc.push(node);
            return acc;
        }, []);
    }
    return content;
};
var renderUrl = function(node, render) {
    return (0, _pluginhelper.getUniqAttr)(node.attrs) ? (0, _pluginhelper.getUniqAttr)(node.attrs) : render(node.content || []);
};
var toNode = function(tag, attrs, content) {
    return _pluginhelper.TagNode.create(tag, attrs, content);
};
var toStyle = function(style) {
    return {
        style: style
    };
};
var defineStyleNode = function(tag, style) {
    return function(node) {
        return toNode(tag, toStyle(style), node.content);
    };
};
var defaultTags = function createTags() {
    var tags = {
        b: defineStyleNode("span", "font-weight: bold;"),
        i: defineStyleNode("span", "font-style: italic;"),
        u: defineStyleNode("span", "text-decoration: underline;"),
        s: defineStyleNode("span", "text-decoration: line-through;"),
        url: function(node, param) {
            var render = param.render;
            return toNode("a", {
                href: renderUrl(node, render)
            }, node.content);
        },
        img: function(node, param) {
            var render = param.render;
            return toNode("img", _extends({}, node.attrs, {
                src: render(node.content)
            }), null);
        },
        quote: function(node) {
            return toNode("blockquote", {}, [
                toNode("p", {}, node.content)
            ]);
        },
        code: function(node) {
            return toNode("pre", {}, node.content);
        },
        style: function(node) {
            return toNode("span", toStyle(styleAttrs(node.attrs)), node.content);
        },
        list: function(node) {
            var type = (0, _pluginhelper.getUniqAttr)(node.attrs);
            return toNode(type ? "ol" : "ul", type ? {
                type: type
            } : {}, toListNodes(node.content));
        },
        color: function(node) {
            return toNode("span", toStyle("color: " + (0, _pluginhelper.getUniqAttr)(node.attrs) + ";"), node.content);
        }
    };
    return tags;
}();
var _default = defaultTags;
