'use strict';

var _createClient = require('openapi-fetch');

function _interopDefault (e) { return e && e.__esModule ? e : { default: e }; }

var _createClient__default = /*#__PURE__*/_interopDefault(_createClient);

let client = null;
function getDefaultClient() {
  if (!client) {
    client = createClient();
  }
  return client;
}
function setDefaultClient(newClient) {
  client = newClient;
}
function createClient({
  baseUrl = "https://gi.rss3.io",
  ...options
} = {}) {
  return Object.freeze(
    Object.assign({ baseUrl }, _createClient__default.default({ baseUrl, ...options }))
  );
}

exports.createClient = createClient;
exports.getDefaultClient = getDefaultClient;
exports.setDefaultClient = setDefaultClient;
//# sourceMappingURL=client.cjs.map
//# sourceMappingURL=client.cjs.map