import { isSupportedNS } from '../../name-service.js';

function isAddress(address) {
  return /^(0x)?[\dA-Fa-f]{40}$/.test(address);
}
function isMastodon(handle) {
  return /^\w{1,30}@[\d.A-Za-z-]+\.[A-Za-z]{2,}$/.test(handle);
}
function formatAddress(address) {
  if (!address) return "";
  if (!isAddress(address)) return address;
  return `${address.slice(0, 6)}...${address.slice(-4)}`;
}
function formatAddressAndNS(address) {
  if (isAddress(address)) {
    return formatAddress(address);
  }
  if (isSupportedNS(address)) {
    return address.split(".").map((value) => formatAddress(value)).join(".");
  }
  return address;
}
function addressToAvatarURL(address, size) {
  return `https://cdn.stamp.fyi/avatar/${address}?s=${size}`;
}

export { addressToAvatarURL, formatAddress, formatAddressAndNS, isAddress, isMastodon };
//# sourceMappingURL=index.js.map
//# sourceMappingURL=index.js.map