/// <reference path="./Attribute.d.ts" />
/// <reference path="./AttributeList.d.ts" />
/// <reference path="./CMSUtil.d.ts" />
/// <reference path="./CMSUtil.d.ts" />
/// <reference path="./ContentInfo.d.ts" />
/// <reference path="./ContentType.d.ts" />
/// <reference path="./EncapsulatedContentInfo.d.ts" />
/// <reference path="./IssuerAndSerialNumber.d.ts" />
/// <reference path="./MessageDigest.d.ts" />
/// <reference path="./SignedData.d.ts" />
/// <reference path="./SignerInfo.d.ts" />
/// <reference path="./SigningCertificate.d.ts" />
/// <reference path="./SigningCertificateV2.d.ts" />
/// <reference path="./SigningTime.d.ts" />

declare namespace jsrsasign.KJUR.asn1 {
    /**
     * kjur's ASN.1 class for Cryptographic Message Syntax(CMS)
     *
     * This name space provides
     * [RFC 5652 Cryptographic Message Syntax (CMS)](https://tools.ietf.org/html/rfc5652) SignedData generator.
     *
     * __FEATURES__
     *
     * - easily generate CMS SignedData
     * - easily verify CMS SignedData
     * - APIs are very similar to BouncyCastle library ASN.1 classes. So easy to learn.
     *
     * __PROVIDED CLASSES__
     *
     * - `KJUR.asn1.cms.SignedData`
     * - `KJUR.asn1.cms.SignerInfo`
     * - `KJUR.asn1.cms.AttributeList`
     * - `KJUR.asn1.cms.ContentInfo`
     * - `KJUR.asn1.cms.EncapsulatedContentInfo`
     * - `KJUR.asn1.cms.IssuerAndSerialNumber`
     * - `KJUR.asn1.cms.CMSUtil`
     * - `KJUR.asn1.cms.Attribute`
     * - `KJUR.asn1.cms.ContentType`
     * - `KJUR.asn1.cms.MessageDigest`
     * - `KJUR.asn1.cms.SigningTime`
     * - `KJUR.asn1.cms.SigningCertificate`
     * - `KJUR.asn1.cms.SigningCertificateV2`
     */
    namespace cms {
        //
    }
}
