export const searchPublicTimeline = async (ff, options) => ff.get('/search/public_timeline', options);
export const searchUsers = async (ff, options) => ff.get('/search/users', options);
export const searchUserTimeline = async (ff, options) => ff.get('/search/user_timeline', options);
export const getBlockedIds = async (ff) => ff.get('/blocks/ids');
export const getBlockedUsers = async (ff, options) => ff.get('/blocks/blocking', options);
export const createBlockedUser = async (ff, options) => ff.post('/blocks/create', options);
export const checkBlockExists = async (ff, options) => ff.get('/blocks/exists', options);
export const dropBlockedUser = async (ff, options) => ff.post('/blocks/destroy', options);
export const getTaggedUsers = async (ff, options) => ff.post('/users/tagged', options);
export const getUser = async (ff, options) => ff.get('/users/show', options);
export const getUserTags = async (ff, options) => ff.get('/users/tag_list', options);
export const getRecentFollowers = async (ff, options) => ff.get('/users/followers', options);
export const getRecommendedUsers = async (ff, options) => ff.get('/users/recommendation', options);
export const dismissRecommendedUser = async (ff, options) => ff.post('/users/cancel_recommendation', options);
export const getRecentUsers = async (ff, options) => ff.get('/users/friends', options);
export const verifyCredentials = async (ff, options) => ff.get('/account/verify_credentials', options);
export const updateProfileImage = async (ff, options) => ff.post('/account/update_profile_image', options);
export const getRateLimitStatus = async (ff, options) => ff.get('/account/rate_limit_status', options);
export const updateProfile = async (ff, options) => ff.post('/account/update_profile', options);
export const getNotification = async (ff) => ff.get('/account/notification');
export const updateNotifyNumber = async (ff, options) => ff.post('/account/update_notify_num', options);
export const createSavedSearch = async (ff, options) => ff.post('/saved_searches/create', options);
export const dropSavedSearch = async (ff, options) => ff.post('/saved_searches/destroy', options);
export const getSavedSearch = async (ff, options) => ff.get('/saved_searches/show', options);
export const getSavedSearches = async (ff, options) => ff.get('/saved_searches/list', options);
export const getUserPhotos = async (ff, options) => ff.get('/photos/user_timeline', options);
export const uploadPhoto = async (ff, options) => ff.post('/photos/upload', options);
export const getTrends = async (ff, options) => ff.get('/trends/list', options);
export const getFollowerIds = async (ff, options) => ff.get('/follower/ids', options);
export const dropFavorite = async (ff, options) => {
    const { id, ...restOptions } = options;
    return ff.post(`/favorites/destroy/${id}`, restOptions);
};
export const getFavorites = async (ff, options = {}) => {
    const { id = '', ...restOptions } = options;
    return ff.get(`/favorites/${id}`, restOptions);
};
export const createFavorite = async (ff, options) => {
    const { id, ...restOptions } = options;
    return ff.post(`/favorites/create/${id}`, restOptions);
};
export const createFriendship = async (ff, options) => ff.post('/friendships/create', options);
export const dropFriendship = async (ff, options) => ff.post('/friendships/destroy', options);
export const checkFriendshipRequests = async (ff, options) => ff.get('/friendships/requests', options);
export const denyFriendship = async (ff, options) => ff.post('/friendships/deny', options);
export const checkFriendship = async (ff, options) => {
    const result = await ff.get('/friendships/exists', options);
    return result === 'true';
};
export const acceptFriendship = async (ff, options) => ff.post('/friendships/accept', options);
const parseRelationship = (friendship) => {
    friendship.following &&= String(friendship.following) === 'true';
    friendship.followedBy &&= String(friendship.followedBy) === 'true';
    friendship.notificationEnabled &&=
        String(friendship.notificationEnabled) === 'true';
    friendship.blocking &&= String(friendship.blocking) === 'true';
    return friendship;
};
export const checkFriendshipDetail = async (ff, options) => {
    const result = await ff.get('/friendships/show', options);
    const { source, target } = result.relationship;
    const parsedResult = {
        relationship: {
            source: parseRelationship(source),
            target: parseRelationship(target),
        },
    };
    return parsedResult;
};
export const getFollowingIds = async (ff, options) => ff.get('/friends/ids', options);
export const dropStatus = async (ff, options) => ff.post('/statuses/destroy', options);
export const getHomeTimeline = async (ff, options) => ff.get('/statuses/home_timeline', options);
export const getPublicTimeline = async (ff, options) => ff.get('/statuses/public_timeline', options);
export const getReplies = async (ff, options) => ff.get('/statuses/replies', options);
export const getFollowers = async (ff, options) => ff.get('/statuses/followers', options);
export const createStatus = async (ff, options) => ff.post('/statuses/update', options);
export const getUserTimeline = async (ff, options) => ff.get('/statuses/user_timeline', options);
export const getFollowings = async (ff, options) => ff.get('/statuses/friends', options);
export const getContextTimeline = async (ff, options) => ff.get('/statuses/context_timeline', options);
export const getMentions = async (ff, options) => ff.get('/statuses/mentions', options);
export const getStatus = async (ff, options) => ff.get('/statuses/show', options);
export const dropDirectMessage = async (ff, options) => ff.post('/direct_messages/destroy', options);
export const getConversation = async (ff, options) => ff.get('/direct_messages/conversation', options);
export const createDirectMessage = async (ff, options) => ff.post('/direct_messages/new', options);
export const getConversations = async (ff, options) => ff.get('/direct_messages/conversation_list', options);
export const getInbox = async (ff, options) => ff.get('/direct_messages/inbox', options);
export const getSent = async (ff, options) => ff.get('/direct_messages/sent', options);
/* c8 ignore stop */
