import * as api from './api.js';
export type FanfouToken = {
    oauthToken: string;
    oauthTokenSecret: string;
};
export type FanfouHooks = {
    baseString?: (s: string) => string;
};
export type FanfouOptions = {
    consumerKey?: string;
    consumerSecret?: string;
    oauthToken?: string;
    oauthTokenSecret?: string;
    username?: string;
    password?: string;
    protocol?: string;
    apiDomain?: string;
    oauthDomain?: string;
    hooks?: FanfouHooks;
};
declare class Fanfou {
    consumerKey: string;
    consumerSecret: string;
    oauthToken: string;
    oauthTokenSecret: string;
    username: string;
    password: string;
    protocol: string;
    apiDomain: string;
    oauthDomain: string;
    hooks: FanfouHooks;
    private readonly apiEndPoint;
    private readonly oauthEndPoint;
    private readonly o;
    constructor(options?: FanfouOptions);
    getRequestToken(): Promise<this>;
    getAccessToken(token: FanfouToken): Promise<this>;
    xauth(): Promise<this>;
    get<T>(uri: string, parameters?: Record<string, any>): Promise<T>;
    post<T>(uri: string, parameters?: Record<string, any>): Promise<T>;
    acceptFriendship: (options: api.AcceptFriendshipOptions) => Promise<import("./types.js").User>;
    checkBlockExists: (options: api.CheckBlockExistsOptions) => Promise<import("./types.js").User>;
    checkFriendship: (options: api.CheckFriendshipOptions) => Promise<boolean>;
    checkFriendshipDetail: (options: api.CheckFriendshipDetailOptions) => Promise<api.CheckFriendshipDetailResult>;
    checkFriendshipRequests: (options: api.CheckFriendshipRequestsOptions) => Promise<import("./types.js").User[]>;
    createBlockedUser: (options: api.CreateBlockedUserOptions) => Promise<import("./types.js").User>;
    createDirectMessage: (options: api.CreateDirectMessageOptions) => Promise<import("./types.js").DirectMessage>;
    createFavorite: (options: api.CreateFavoriteOptions) => Promise<import("./types.js").Status>;
    createFriendship: (options: api.CreateFriendshipOptions) => Promise<import("./types.js").User>;
    createSavedSearch: (options: api.CreateSavedSearchOptions) => Promise<import("./types.js").Trend>;
    createStatus: (options: api.CreateStatusOptions) => Promise<import("./types.js").Status>;
    denyFriendship: (options: api.DenyFriendshipOptions) => Promise<import("./types.js").User>;
    dismissRecommendedUser: (options: api.DismissRecommendedUserOptions) => Promise<import("./types.js").User>;
    dropBlockedUser: (options: api.DropBlockedUserOptions) => Promise<import("./types.js").User>;
    dropDirectMessage: (options: api.DropDirectMessageOptions) => Promise<import("./types.js").DirectMessage>;
    dropFavorite: (options: api.DropFavoriteOptions) => Promise<import("./types.js").Status>;
    dropFriendship: (options: api.DropFriendshipOptions) => Promise<import("./types.js").User>;
    dropSavedSearch: (options: api.DropSavedSearchOptions) => Promise<import("./types.js").Trend>;
    dropStatus: (options: api.DropStatusOptions) => Promise<import("./types.js").User>;
    getBlockedIds: () => Promise<string[]>;
    getBlockedUsers: (options?: api.GetBlockedUsersOptions) => Promise<import("./types.js").User[]>;
    getContextTimeline: (options: api.GetContextTimelineOptions) => Promise<import("./types.js").Status[]>;
    getConversation: (options: api.GetConversationOptions) => Promise<import("./types.js").DirectMessage[]>;
    getConversations: (options?: api.GetConversationsOptions) => Promise<api.GetConversationsOptions>;
    getFavorites: (options?: api.GetFavoritesOptions) => Promise<import("./types.js").Status[]>;
    getFollowerIds: (options?: api.GetFollowerIdsOptions) => Promise<string[]>;
    getFollowers: (options?: api.GetFollowersOptions) => Promise<import("./types.js").User[]>;
    getFollowingIds: (options?: api.GetFollowingIdsOptions) => Promise<string[]>;
    getFollowings: (options?: api.GetFollowingsOptions) => Promise<import("./types.js").User[]>;
    getHomeTimeline: (options?: api.GetHomeTimelineOptions) => Promise<import("./types.js").Status[]>;
    getInbox: (options?: api.GetInboxOptions) => Promise<import("./types.js").DirectMessage[]>;
    getMentions: (options: api.GetMentionsOptions) => Promise<import("./types.js").Status[]>;
    getNotification: () => Promise<api.GetNotificationResult>;
    getPublicTimeline: (options: api.GetPublicTimelineOptions) => Promise<import("./types.js").Status[]>;
    getRateLimitStatus: (options: api.GetRateLimitStatusOptions) => Promise<api.GetRateLimitStatusResult>;
    getRecentFollowers: (options: api.GetRecentFollowersOptions) => Promise<import("./types.js").User[]>;
    getRecentUsers: (options: api.GetRecentUsersOptions) => Promise<import("./types.js").User[]>;
    getRecommendedUsers: (options: api.GetRecommendedUsersOptions) => Promise<import("./types.js").User[]>;
    getReplies: (options: api.GetRepliesOptions) => Promise<import("./types.js").Status[]>;
    getSavedSearch: (options: api.GetSavedSearchOptions) => Promise<import("./types.js").Trend>;
    getSavedSearches: (options: api.GetSavedSearchesOptions) => Promise<import("./types.js").Trend[]>;
    getSent: (options: api.GetSentOptions) => Promise<import("./types.js").DirectMessage[]>;
    getStatus: (options: api.GetStatusOptions) => Promise<import("./types.js").Status>;
    getTaggedUsers: (options: api.GetTaggedUsersOptions) => Promise<import("./types.js").User[]>;
    getTrends: (options: api.GetTrendsOptions) => Promise<api.GetTrendsResult>;
    getUser: (options: api.GetUserOptions) => Promise<import("./types.js").User>;
    getUserPhotos: (options: api.GetUserPhotosOptions) => Promise<import("./types.js").Status>;
    getUserTags: (options: api.GetUserTagsOptions) => Promise<string[]>;
    getUserTimeline: (options: api.GetUserTimelineOptions) => Promise<import("./types.js").Status[]>;
    searchPublicTimeline: (options: api.SearchPublicTimelineOptions) => Promise<import("./types.js").Status[]>;
    searchUserTimeline: (options: api.SearchUserTimelineOptions) => Promise<import("./types.js").Status[]>;
    searchUsers: (options: api.SearchUsersOptions) => Promise<api.SearchUsersResult>;
    updateNotifyNumber: (options: api.UpdateNotifyNumberOptions) => Promise<api.UpdateNotifyNumberResult>;
    updateProfile: (options: api.UpdateProfileOptions) => Promise<import("./types.js").User>;
    updateProfileImage: (options: api.UpdateProfileImageOptions) => Promise<import("./types.js").User>;
    uploadPhoto: (options: api.UploadPhotoOptions) => Promise<import("./types.js").Status>;
    verifyCredentials: (options: api.VerifyCredentialsOptions) => Promise<import("./types.js").User>;
}
export default Fanfou;
