"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g = Object.create((typeof Iterator === "function" ? Iterator : Object).prototype);
    return g.next = verb(0), g["throw"] = verb(1), g["return"] = verb(2), typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createCursor = exports.getRandomPagePoint = exports.installMouseHelper = void 0;
exports.path = path;
var debug_1 = __importDefault(require("debug"));
var math_1 = require("./math");
var mouse_helper_1 = require("./mouse-helper");
Object.defineProperty(exports, "installMouseHelper", { enumerable: true, get: function () { return __importDefault(mouse_helper_1).default; } });
var log = (0, debug_1.default)('ghost-cursor');
/** Helper function to wait a specified number of milliseconds  */
var delay = function (ms) { return __awaiter(void 0, void 0, void 0, function () {
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                if (ms < 1)
                    return [2 /*return*/];
                return [4 /*yield*/, new Promise(function (resolve) { return setTimeout(resolve, ms); })];
            case 1: return [2 /*return*/, _a.sent()];
        }
    });
}); };
/**
 * Calculate the amount of time needed to move from (x1, y1) to (x2, y2)
 * given the width of the element being clicked on
 * https://en.wikipedia.org/wiki/Fitts%27s_law
 */
var fitts = function (distance, width) {
    var a = 0;
    var b = 2;
    var id = Math.log2(distance / width + 1);
    return a + b * id;
};
/** Get a random point on a box */
var getRandomBoxPoint = function (_a, options) {
    var x = _a.x, y = _a.y, width = _a.width, height = _a.height;
    var paddingWidth = 0;
    var paddingHeight = 0;
    if ((options === null || options === void 0 ? void 0 : options.paddingPercentage) !== undefined &&
        (options === null || options === void 0 ? void 0 : options.paddingPercentage) > 0 &&
        (options === null || options === void 0 ? void 0 : options.paddingPercentage) <= 100) {
        paddingWidth = (width * options.paddingPercentage) / 100;
        paddingHeight = (height * options.paddingPercentage) / 100;
    }
    return {
        x: x + paddingWidth / 2 + Math.random() * (width - paddingWidth),
        y: y + paddingHeight / 2 + Math.random() * (height - paddingHeight)
    };
};
/** The function signature to access the internal CDP client changed in puppeteer 14.4.1 */
var getCDPClient = function (page) { return typeof page._client === 'function' ? page._client() : page._client; };
/** Get a random point on a browser window */
var getRandomPagePoint = function (page) { return __awaiter(void 0, void 0, void 0, function () {
    var targetId, window;
    var _a, _b;
    return __generator(this, function (_c) {
        switch (_c.label) {
            case 0:
                targetId = page.target()._targetId;
                return [4 /*yield*/, getCDPClient(page).send('Browser.getWindowForTarget', { targetId: targetId })];
            case 1:
                window = _c.sent();
                return [2 /*return*/, getRandomBoxPoint({
                        x: math_1.origin.x,
                        y: math_1.origin.y,
                        width: (_a = window.bounds.width) !== null && _a !== void 0 ? _a : 0,
                        height: (_b = window.bounds.height) !== null && _b !== void 0 ? _b : 0
                    })];
        }
    });
}); };
exports.getRandomPagePoint = getRandomPagePoint;
/** Using this method to get correct position of Inline elements (elements like `<a>`) */
var getElementBox = function (page_1, element_1) {
    var args_1 = [];
    for (var _i = 2; _i < arguments.length; _i++) {
        args_1[_i - 2] = arguments[_i];
    }
    return __awaiter(void 0, __spreadArray([page_1, element_1], __read(args_1), false), void 0, function (page, element, relativeToMainFrame) {
        var objectId, quads, elementBox, elementFrame, iframes, _a, frame, iframes_1, iframes_1_1, iframe, e_1_1, boundingBox, _1;
        var e_1, _b;
        var _c;
        if (relativeToMainFrame === void 0) { relativeToMainFrame = true; }
        return __generator(this, function (_d) {
            switch (_d.label) {
                case 0:
                    objectId = element.remoteObject().objectId;
                    if (objectId === undefined) {
                        return [2 /*return*/, null];
                    }
                    _d.label = 1;
                case 1:
                    _d.trys.push([1, 17, , 19]);
                    return [4 /*yield*/, getCDPClient(page).send('DOM.getContentQuads', {
                            objectId: objectId
                        })];
                case 2:
                    quads = _d.sent();
                    elementBox = {
                        x: quads.quads[0][0],
                        y: quads.quads[0][1],
                        width: quads.quads[0][4] - quads.quads[0][0],
                        height: quads.quads[0][5] - quads.quads[0][1]
                    };
                    if (!!relativeToMainFrame) return [3 /*break*/, 16];
                    return [4 /*yield*/, element.contentFrame()];
                case 3:
                    elementFrame = _d.sent();
                    if (!(elementFrame != null)) return [3 /*break*/, 5];
                    return [4 /*yield*/, ((_c = elementFrame.parentFrame()) === null || _c === void 0 ? void 0 : _c.$$('xpath/.//iframe'))];
                case 4:
                    _a = _d.sent();
                    return [3 /*break*/, 6];
                case 5:
                    _a = null;
                    _d.label = 6;
                case 6:
                    iframes = _a;
                    frame = void 0;
                    if (!(iframes != null)) return [3 /*break*/, 14];
                    _d.label = 7;
                case 7:
                    _d.trys.push([7, 12, 13, 14]);
                    iframes_1 = __values(iframes), iframes_1_1 = iframes_1.next();
                    _d.label = 8;
                case 8:
                    if (!!iframes_1_1.done) return [3 /*break*/, 11];
                    iframe = iframes_1_1.value;
                    return [4 /*yield*/, iframe.contentFrame()];
                case 9:
                    if ((_d.sent()) === elementFrame)
                        frame = iframe;
                    _d.label = 10;
                case 10:
                    iframes_1_1 = iframes_1.next();
                    return [3 /*break*/, 8];
                case 11: return [3 /*break*/, 14];
                case 12:
                    e_1_1 = _d.sent();
                    e_1 = { error: e_1_1 };
                    return [3 /*break*/, 14];
                case 13:
                    try {
                        if (iframes_1_1 && !iframes_1_1.done && (_b = iframes_1.return)) _b.call(iframes_1);
                    }
                    finally { if (e_1) throw e_1.error; }
                    return [7 /*endfinally*/];
                case 14:
                    if (!(frame != null)) return [3 /*break*/, 16];
                    return [4 /*yield*/, frame.boundingBox()];
                case 15:
                    boundingBox = _d.sent();
                    elementBox.x =
                        boundingBox !== null ? elementBox.x - boundingBox.x : elementBox.x;
                    elementBox.y =
                        boundingBox !== null ? elementBox.y - boundingBox.y : elementBox.y;
                    _d.label = 16;
                case 16: return [2 /*return*/, elementBox];
                case 17:
                    _1 = _d.sent();
                    log('Quads not found, trying regular boundingBox');
                    return [4 /*yield*/, element.boundingBox()];
                case 18: return [2 /*return*/, _d.sent()];
                case 19: return [2 /*return*/];
            }
        });
    });
};
function path(start, end, options) {
    var optionsResolved = typeof options === 'number'
        ? { spreadOverride: options }
        : __assign({}, options);
    var DEFAULT_WIDTH = 100;
    var MIN_STEPS = 25;
    var width = 'width' in end && end.width !== 0 ? end.width : DEFAULT_WIDTH;
    var curve = (0, math_1.bezierCurve)(start, end, optionsResolved.spreadOverride);
    var length = curve.length() * 0.8;
    var speed = optionsResolved.moveSpeed !== undefined && optionsResolved.moveSpeed > 0
        ? (25 / optionsResolved.moveSpeed)
        : Math.random();
    var baseTime = speed * MIN_STEPS;
    var steps = Math.ceil((Math.log2(fitts(length, width) + 1) + baseTime) * 3);
    var re = curve.getLUT(steps);
    return clampPositive(re, optionsResolved);
}
var clampPositive = function (vectors, options) {
    var clampedVectors = vectors.map(function (vector) { return ({
        x: Math.max(0, vector.x),
        y: Math.max(0, vector.y)
    }); });
    return (options === null || options === void 0 ? void 0 : options.useTimestamps) === true ? generateTimestamps(clampedVectors, options) : clampedVectors;
};
var generateTimestamps = function (vectors, options) {
    var _a;
    var speed = (_a = options === null || options === void 0 ? void 0 : options.moveSpeed) !== null && _a !== void 0 ? _a : (Math.random() * 0.5 + 0.5);
    var timeToMove = function (P0, P1, P2, P3, samples) {
        var total = 0;
        var dt = 1 / samples;
        for (var t = 0; t < 1; t += dt) {
            var v1 = (0, math_1.bezierCurveSpeed)(t * dt, P0, P1, P2, P3);
            var v2 = (0, math_1.bezierCurveSpeed)(t, P0, P1, P2, P3);
            total += (v1 + v2) * dt / 2;
        }
        return Math.round(total / speed);
    };
    var timedVectors = vectors.map(function (vector) { return (__assign(__assign({}, vector), { timestamp: 0 })); });
    for (var i = 0; i < timedVectors.length; i++) {
        var P0 = i === 0 ? timedVectors[i] : timedVectors[i - 1];
        var P1 = timedVectors[i];
        var P2 = i === timedVectors.length - 1 ? timedVectors[i] : timedVectors[i + 1];
        var P3 = i === timedVectors.length - 1 ? timedVectors[i] : timedVectors[i + 1];
        var time = timeToMove(P0, P1, P2, P3, timedVectors.length);
        timedVectors[i] = __assign(__assign({}, timedVectors[i]), { timestamp: i === 0 ? Date.now() : timedVectors[i - 1].timestamp + time });
    }
    return timedVectors;
};
var shouldOvershoot = function (a, b, threshold) {
    return (0, math_1.magnitude)((0, math_1.direction)(a, b)) > threshold;
};
var intersectsElement = function (vec, box) {
    return (vec.x > box.x &&
        vec.x <= box.x + box.width &&
        vec.y > box.y &&
        vec.y <= box.y + box.height);
};
var boundingBoxWithFallback = function (page, elem) { return __awaiter(void 0, void 0, void 0, function () {
    var box;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0: return [4 /*yield*/, getElementBox(page, elem)];
            case 1:
                box = _a.sent();
                if (!(box == null)) return [3 /*break*/, 3];
                return [4 /*yield*/, elem.evaluate(function (el) {
                        return el.getBoundingClientRect();
                    })];
            case 2:
                box = (_a.sent());
                _a.label = 3;
            case 3: return [2 /*return*/, box];
        }
    });
}); };
var createCursor = function (page, 
/**
 * Cursor start position.
 * @default { x: 0, y: 0 }
 */
start, 
/**
 * Initially perform random movements.
 * If `move`,`click`, etc. is performed, these random movements end.
 * @default false
 */
performRandomMoves, defaultOptions) {
    if (start === void 0) { start = math_1.origin; }
    if (performRandomMoves === void 0) { performRandomMoves = false; }
    if (defaultOptions === void 0) { defaultOptions = {}; }
    // this is kind of arbitrary, not a big fan but it seems to work
    var OVERSHOOT_SPREAD = 10;
    var OVERSHOOT_RADIUS = 120;
    var previous = start;
    // Initial state: mouse is not moving
    var moving = false;
    // Move the mouse over a number of vectors
    var tracePath = function (vectors_1) {
        var args_1 = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args_1[_i - 1] = arguments[_i];
        }
        return __awaiter(void 0, __spreadArray([vectors_1], __read(args_1), false), void 0, function (vectors, abortOnMove) {
            var cdpClient, vectors_2, vectors_2_1, v, dispatchParams, error_1, e_2_1;
            var e_2, _a;
            if (abortOnMove === void 0) { abortOnMove = false; }
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        cdpClient = getCDPClient(page);
                        _b.label = 1;
                    case 1:
                        _b.trys.push([1, 8, 9, 10]);
                        vectors_2 = __values(vectors), vectors_2_1 = vectors_2.next();
                        _b.label = 2;
                    case 2:
                        if (!!vectors_2_1.done) return [3 /*break*/, 7];
                        v = vectors_2_1.value;
                        _b.label = 3;
                    case 3:
                        _b.trys.push([3, 5, , 6]);
                        // In case this is called from random mouse movements and the users wants to move the mouse, abort
                        if (abortOnMove && moving) {
                            return [2 /*return*/];
                        }
                        dispatchParams = {
                            type: 'mouseMoved',
                            x: v.x,
                            y: v.y
                        };
                        if ('timestamp' in v)
                            dispatchParams.timestamp = v.timestamp;
                        return [4 /*yield*/, cdpClient.send('Input.dispatchMouseEvent', dispatchParams)];
                    case 4:
                        _b.sent();
                        previous = v;
                        return [3 /*break*/, 6];
                    case 5:
                        error_1 = _b.sent();
                        // Exit function if the browser is no longer connected
                        if (!page.browser().isConnected())
                            return [2 /*return*/];
                        log('Warning: could not move mouse, error message:', error_1);
                        return [3 /*break*/, 6];
                    case 6:
                        vectors_2_1 = vectors_2.next();
                        return [3 /*break*/, 2];
                    case 7: return [3 /*break*/, 10];
                    case 8:
                        e_2_1 = _b.sent();
                        e_2 = { error: e_2_1 };
                        return [3 /*break*/, 10];
                    case 9:
                        try {
                            if (vectors_2_1 && !vectors_2_1.done && (_a = vectors_2.return)) _a.call(vectors_2);
                        }
                        finally { if (e_2) throw e_2.error; }
                        return [7 /*endfinally*/];
                    case 10: return [2 /*return*/];
                }
            });
        });
    };
    // Start random mouse movements. Function recursively calls itself
    var randomMove = function (options) { return __awaiter(void 0, void 0, void 0, function () {
        var optionsResolved, rand, _2;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    optionsResolved = __assign(__assign({ moveDelay: 2000, randomizeMoveDelay: true }, defaultOptions === null || defaultOptions === void 0 ? void 0 : defaultOptions.randomMove), options);
                    _a.label = 1;
                case 1:
                    _a.trys.push([1, 6, , 7]);
                    if (!!moving) return [3 /*break*/, 4];
                    return [4 /*yield*/, (0, exports.getRandomPagePoint)(page)];
                case 2:
                    rand = _a.sent();
                    return [4 /*yield*/, tracePath(path(previous, rand, optionsResolved), true)];
                case 3:
                    _a.sent();
                    previous = rand;
                    _a.label = 4;
                case 4: return [4 /*yield*/, delay(optionsResolved.moveDelay * (optionsResolved.randomizeMoveDelay ? Math.random() : 1))];
                case 5:
                    _a.sent();
                    randomMove(options).then(function (_) { }, function (_) { }); // fire and forget, recursive function
                    return [3 /*break*/, 7];
                case 6:
                    _2 = _a.sent();
                    log('Warning: stopping random mouse movements');
                    return [3 /*break*/, 7];
                case 7: return [2 /*return*/];
            }
        });
    }); };
    var actions = {
        toggleRandomMove: function (random) {
            moving = !random;
        },
        getLocation: function () {
            return previous;
        },
        click: function (selector, options) {
            return __awaiter(this, void 0, void 0, function () {
                var optionsResolved, wasRandom, cdpClient, dispatchParams, error_2;
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            optionsResolved = __assign(__assign({ moveDelay: 2000, hesitate: 0, waitForClick: 0, randomizeMoveDelay: true, button: 'left', clickCount: 1 }, defaultOptions === null || defaultOptions === void 0 ? void 0 : defaultOptions.click), options);
                            wasRandom = !moving;
                            actions.toggleRandomMove(false);
                            if (!(selector !== undefined)) return [3 /*break*/, 2];
                            return [4 /*yield*/, actions.move(selector, __assign(__assign({}, optionsResolved), { 
                                    // apply moveDelay after click, but not after actual move
                                    moveDelay: 0 }))];
                        case 1:
                            _a.sent();
                            _a.label = 2;
                        case 2:
                            _a.trys.push([2, 7, , 8]);
                            return [4 /*yield*/, delay(optionsResolved.hesitate)];
                        case 3:
                            _a.sent();
                            cdpClient = getCDPClient(page);
                            dispatchParams = {
                                x: previous.x,
                                y: previous.y,
                                button: optionsResolved.button,
                                clickCount: optionsResolved.clickCount
                            };
                            return [4 /*yield*/, cdpClient.send('Input.dispatchMouseEvent', __assign(__assign({}, dispatchParams), { type: 'mousePressed' }))];
                        case 4:
                            _a.sent();
                            return [4 /*yield*/, delay(optionsResolved.waitForClick)];
                        case 5:
                            _a.sent();
                            return [4 /*yield*/, cdpClient.send('Input.dispatchMouseEvent', __assign(__assign({}, dispatchParams), { type: 'mouseReleased' }))];
                        case 6:
                            _a.sent();
                            return [3 /*break*/, 8];
                        case 7:
                            error_2 = _a.sent();
                            log('Warning: could not click mouse, error message:', error_2);
                            return [3 /*break*/, 8];
                        case 8: return [4 /*yield*/, delay(optionsResolved.moveDelay * (optionsResolved.randomizeMoveDelay ? Math.random() : 1))];
                        case 9:
                            _a.sent();
                            actions.toggleRandomMove(wasRandom);
                            return [2 /*return*/];
                    }
                });
            });
        },
        move: function (selector, options) {
            return __awaiter(this, void 0, void 0, function () {
                var optionsResolved, wasRandom, go;
                var _this = this;
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            optionsResolved = __assign(__assign({ moveDelay: 0, maxTries: 10, overshootThreshold: 500, randomizeMoveDelay: true }, defaultOptions === null || defaultOptions === void 0 ? void 0 : defaultOptions.move), options);
                            wasRandom = !moving;
                            go = function (iteration) { return __awaiter(_this, void 0, void 0, function () {
                                var elem, box, height, width, destination, dimensions, overshooting, to, correction, newBoundingBox;
                                return __generator(this, function (_a) {
                                    switch (_a.label) {
                                        case 0:
                                            if (iteration > (optionsResolved.maxTries)) {
                                                throw Error('Could not mouse-over element within enough tries');
                                            }
                                            actions.toggleRandomMove(false);
                                            return [4 /*yield*/, this.getElement(selector, optionsResolved)
                                                // Make sure the object is in view
                                            ];
                                        case 1:
                                            elem = _a.sent();
                                            // Make sure the object is in view
                                            return [4 /*yield*/, this.scrollIntoView(elem, optionsResolved)];
                                        case 2:
                                            // Make sure the object is in view
                                            _a.sent();
                                            return [4 /*yield*/, boundingBoxWithFallback(page, elem)];
                                        case 3:
                                            box = _a.sent();
                                            height = box.height, width = box.width;
                                            destination = (optionsResolved.destination !== undefined)
                                                ? (0, math_1.add)(box, optionsResolved.destination)
                                                : getRandomBoxPoint(box, optionsResolved);
                                            dimensions = { height: height, width: width };
                                            overshooting = shouldOvershoot(previous, destination, optionsResolved.overshootThreshold);
                                            to = overshooting
                                                ? (0, math_1.overshoot)(destination, OVERSHOOT_RADIUS)
                                                : destination;
                                            return [4 /*yield*/, tracePath(path(previous, to, optionsResolved))];
                                        case 4:
                                            _a.sent();
                                            if (!overshooting) return [3 /*break*/, 6];
                                            correction = path(to, __assign(__assign({}, dimensions), destination), __assign(__assign({}, optionsResolved), { spreadOverride: OVERSHOOT_SPREAD }));
                                            return [4 /*yield*/, tracePath(correction)];
                                        case 5:
                                            _a.sent();
                                            _a.label = 6;
                                        case 6:
                                            previous = destination;
                                            actions.toggleRandomMove(true);
                                            return [4 /*yield*/, boundingBoxWithFallback(page, elem)
                                                // It's possible that the element that is being moved towards
                                                // has moved to a different location by the time
                                                // the the time the mouseover animation finishes
                                            ];
                                        case 7:
                                            newBoundingBox = _a.sent();
                                            if (!!intersectsElement(to, newBoundingBox)) return [3 /*break*/, 9];
                                            return [4 /*yield*/, go(iteration + 1)];
                                        case 8: return [2 /*return*/, _a.sent()];
                                        case 9: return [2 /*return*/];
                                    }
                                });
                            }); };
                            return [4 /*yield*/, go(0)];
                        case 1:
                            _a.sent();
                            actions.toggleRandomMove(wasRandom);
                            return [4 /*yield*/, delay(optionsResolved.moveDelay * (optionsResolved.randomizeMoveDelay ? Math.random() : 1))];
                        case 2:
                            _a.sent();
                            return [2 /*return*/];
                    }
                });
            });
        },
        moveTo: function (destination, options) {
            return __awaiter(this, void 0, void 0, function () {
                var optionsResolved, wasRandom;
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            optionsResolved = __assign(__assign({ moveDelay: 0, randomizeMoveDelay: true }, defaultOptions === null || defaultOptions === void 0 ? void 0 : defaultOptions.moveTo), options);
                            wasRandom = !moving;
                            actions.toggleRandomMove(false);
                            return [4 /*yield*/, tracePath(path(previous, destination, optionsResolved))];
                        case 1:
                            _a.sent();
                            actions.toggleRandomMove(wasRandom);
                            return [4 /*yield*/, delay(optionsResolved.moveDelay * (optionsResolved.randomizeMoveDelay ? Math.random() : 1))];
                        case 2:
                            _a.sent();
                            return [2 /*return*/];
                    }
                });
            });
        },
        scrollIntoView: function (selector, options) {
            return __awaiter(this, void 0, void 0, function () {
                var optionsResolved, scrollSpeed, elem, _a, viewportWidth, viewportHeight, docHeight, docWidth, scrollPositionTop, scrollPositionLeft, elemBoundingBox, elemBox, marginedBox, marginedBoxRelativeToDoc, targetBox, top, left, bottom, right, isInViewport, manuallyScroll, cdpClient, objectId, _b, e_3;
                var _this = this;
                return __generator(this, function (_c) {
                    switch (_c.label) {
                        case 0:
                            optionsResolved = __assign(__assign({ scrollDelay: 200, scrollSpeed: 100, inViewportMargin: 0 }, defaultOptions === null || defaultOptions === void 0 ? void 0 : defaultOptions.scroll), options);
                            scrollSpeed = (0, math_1.clamp)(optionsResolved.scrollSpeed, 1, 100);
                            return [4 /*yield*/, this.getElement(selector, optionsResolved)];
                        case 1:
                            elem = _c.sent();
                            return [4 /*yield*/, page.evaluate(function () { return ({
                                    viewportWidth: document.body.clientWidth,
                                    viewportHeight: document.body.clientHeight,
                                    docHeight: document.body.scrollHeight,
                                    docWidth: document.body.scrollWidth,
                                    scrollPositionTop: window.scrollY,
                                    scrollPositionLeft: window.scrollX
                                }); })];
                        case 2:
                            _a = _c.sent(), viewportWidth = _a.viewportWidth, viewportHeight = _a.viewportHeight, docHeight = _a.docHeight, docWidth = _a.docWidth, scrollPositionTop = _a.scrollPositionTop, scrollPositionLeft = _a.scrollPositionLeft;
                            return [4 /*yield*/, boundingBoxWithFallback(page, elem)]; // is relative to viewport
                        case 3:
                            elemBoundingBox = _c.sent() // is relative to viewport
                            ;
                            elemBox = {
                                top: elemBoundingBox.y,
                                left: elemBoundingBox.x,
                                bottom: elemBoundingBox.y + elemBoundingBox.height,
                                right: elemBoundingBox.x + elemBoundingBox.width
                            };
                            marginedBox = {
                                top: elemBox.top - optionsResolved.inViewportMargin,
                                left: elemBox.left - optionsResolved.inViewportMargin,
                                bottom: elemBox.bottom + optionsResolved.inViewportMargin,
                                right: elemBox.right + optionsResolved.inViewportMargin
                            };
                            marginedBoxRelativeToDoc = {
                                top: marginedBox.top + scrollPositionTop,
                                left: marginedBox.left + scrollPositionLeft,
                                bottom: marginedBox.bottom + scrollPositionTop,
                                right: marginedBox.right + scrollPositionLeft
                            };
                            targetBox = {
                                top: Math.max(marginedBoxRelativeToDoc.top, 0) - scrollPositionTop,
                                left: Math.max(marginedBoxRelativeToDoc.left, 0) - scrollPositionLeft,
                                bottom: Math.min(marginedBoxRelativeToDoc.bottom, docHeight) - scrollPositionTop,
                                right: Math.min(marginedBoxRelativeToDoc.right, docWidth) - scrollPositionLeft
                            };
                            top = targetBox.top, left = targetBox.left, bottom = targetBox.bottom, right = targetBox.right;
                            isInViewport = top >= 0 &&
                                left >= 0 &&
                                bottom <= viewportHeight &&
                                right <= viewportWidth;
                            if (isInViewport)
                                return [2 /*return*/];
                            manuallyScroll = function () { return __awaiter(_this, void 0, void 0, function () {
                                var deltaY, deltaX;
                                return __generator(this, function (_a) {
                                    switch (_a.label) {
                                        case 0:
                                            deltaY = 0;
                                            deltaX = 0;
                                            if (top < 0) {
                                                deltaY = top; // Scroll up
                                            }
                                            else if (bottom > viewportHeight) {
                                                deltaY = bottom - viewportHeight; // Scroll down
                                            }
                                            if (left < 0) {
                                                deltaX = left; // Scroll left
                                            }
                                            else if (right > viewportWidth) {
                                                deltaX = right - viewportWidth; // Scroll right
                                            }
                                            return [4 /*yield*/, this.scroll({ x: deltaX, y: deltaY }, optionsResolved)];
                                        case 1:
                                            _a.sent();
                                            return [2 /*return*/];
                                    }
                                });
                            }); };
                            _c.label = 4;
                        case 4:
                            _c.trys.push([4, 13, , 15]);
                            cdpClient = getCDPClient(page);
                            if (!(scrollSpeed === 100 && optionsResolved.inViewportMargin <= 0)) return [3 /*break*/, 10];
                            _c.label = 5;
                        case 5:
                            _c.trys.push([5, 7, , 9]);
                            objectId = elem.remoteObject().objectId;
                            if (objectId === undefined)
                                throw new Error();
                            return [4 /*yield*/, cdpClient.send('DOM.scrollIntoViewIfNeeded', { objectId: objectId })];
                        case 6:
                            _c.sent();
                            return [3 /*break*/, 9];
                        case 7:
                            _b = _c.sent();
                            return [4 /*yield*/, manuallyScroll()];
                        case 8:
                            _c.sent();
                            return [3 /*break*/, 9];
                        case 9: return [3 /*break*/, 12];
                        case 10: return [4 /*yield*/, manuallyScroll()];
                        case 11:
                            _c.sent();
                            _c.label = 12;
                        case 12: return [3 /*break*/, 15];
                        case 13:
                            e_3 = _c.sent();
                            // use regular JS scroll method as a fallback
                            log('Falling back to JS scroll method', e_3);
                            return [4 /*yield*/, elem.evaluate(function (e) { return e.scrollIntoView({
                                    block: 'center',
                                    behavior: scrollSpeed < 90 ? 'smooth' : undefined
                                }); })];
                        case 14:
                            _c.sent();
                            return [3 /*break*/, 15];
                        case 15: return [2 /*return*/];
                    }
                });
            });
        },
        scroll: function (delta, options) {
            return __awaiter(this, void 0, void 0, function () {
                var optionsResolved, scrollSpeed, cdpClient, deltaX, deltaY, xDirection, yDirection, largerDistanceDir, _a, largerDistance, shorterDistance, EXP_SCALE_START, largerDistanceScrollStep, numSteps, largerDistanceRemainder, shorterDistanceScrollStep, shorterDistanceRemainder, i, longerDistanceDelta, shorterDistanceDelta, _b, deltaX_1, deltaY_1;
                var _c, _d;
                return __generator(this, function (_e) {
                    switch (_e.label) {
                        case 0:
                            optionsResolved = __assign(__assign({ scrollDelay: 200, scrollSpeed: 100 }, defaultOptions === null || defaultOptions === void 0 ? void 0 : defaultOptions.scroll), options);
                            scrollSpeed = (0, math_1.clamp)(optionsResolved.scrollSpeed, 1, 100);
                            cdpClient = getCDPClient(page);
                            deltaX = (_c = delta.x) !== null && _c !== void 0 ? _c : 0;
                            deltaY = (_d = delta.y) !== null && _d !== void 0 ? _d : 0;
                            xDirection = deltaX < 0 ? -1 : 1;
                            yDirection = deltaY < 0 ? -1 : 1;
                            deltaX = Math.abs(deltaX);
                            deltaY = Math.abs(deltaY);
                            largerDistanceDir = deltaX > deltaY ? 'x' : 'y';
                            _a = __read(largerDistanceDir === 'x' ? [deltaX, deltaY] : [deltaY, deltaX], 2), largerDistance = _a[0], shorterDistance = _a[1];
                            EXP_SCALE_START = 90;
                            largerDistanceScrollStep = scrollSpeed < EXP_SCALE_START
                                ? scrollSpeed
                                : (0, math_1.scale)(scrollSpeed, [EXP_SCALE_START, 100], [EXP_SCALE_START, largerDistance]);
                            numSteps = Math.floor(largerDistance / largerDistanceScrollStep);
                            largerDistanceRemainder = largerDistance % largerDistanceScrollStep;
                            shorterDistanceScrollStep = Math.floor(shorterDistance / numSteps);
                            shorterDistanceRemainder = shorterDistance % numSteps;
                            i = 0;
                            _e.label = 1;
                        case 1:
                            if (!(i < numSteps)) return [3 /*break*/, 4];
                            longerDistanceDelta = largerDistanceScrollStep;
                            shorterDistanceDelta = shorterDistanceScrollStep;
                            if (i === numSteps - 1) {
                                longerDistanceDelta += largerDistanceRemainder;
                                shorterDistanceDelta += shorterDistanceRemainder;
                            }
                            _b = __read(largerDistanceDir === 'x'
                                ? [longerDistanceDelta, shorterDistanceDelta]
                                : [shorterDistanceDelta, longerDistanceDelta], 2), deltaX_1 = _b[0], deltaY_1 = _b[1];
                            deltaX_1 = deltaX_1 * xDirection;
                            deltaY_1 = deltaY_1 * yDirection;
                            return [4 /*yield*/, cdpClient.send('Input.dispatchMouseEvent', {
                                    type: 'mouseWheel',
                                    deltaX: deltaX_1,
                                    deltaY: deltaY_1,
                                    x: previous.x,
                                    y: previous.y
                                })];
                        case 2:
                            _e.sent();
                            _e.label = 3;
                        case 3:
                            i++;
                            return [3 /*break*/, 1];
                        case 4: return [4 /*yield*/, delay(optionsResolved.scrollDelay)];
                        case 5:
                            _e.sent();
                            return [2 /*return*/];
                    }
                });
            });
        },
        scrollTo: function (destination, options) {
            return __awaiter(this, void 0, void 0, function () {
                var optionsResolved, _a, docHeight, docWidth, scrollPositionTop, scrollPositionLeft, to;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0:
                            optionsResolved = __assign(__assign({ scrollDelay: 200, scrollSpeed: 100 }, defaultOptions === null || defaultOptions === void 0 ? void 0 : defaultOptions.scroll), options);
                            return [4 /*yield*/, page.evaluate(function () { return ({
                                    docHeight: document.body.scrollHeight,
                                    docWidth: document.body.scrollWidth,
                                    scrollPositionTop: window.scrollY,
                                    scrollPositionLeft: window.scrollX
                                }); })];
                        case 1:
                            _a = _b.sent(), docHeight = _a.docHeight, docWidth = _a.docWidth, scrollPositionTop = _a.scrollPositionTop, scrollPositionLeft = _a.scrollPositionLeft;
                            to = (function () {
                                switch (destination) {
                                    case 'top':
                                        return { y: 0 };
                                    case 'bottom':
                                        return { y: docHeight };
                                    case 'left':
                                        return { x: 0 };
                                    case 'right':
                                        return { x: docWidth };
                                    default:
                                        return destination;
                                }
                            })();
                            return [4 /*yield*/, this.scroll({
                                    y: to.y !== undefined ? to.y - scrollPositionTop : 0,
                                    x: to.x !== undefined ? to.x - scrollPositionLeft : 0
                                }, optionsResolved)];
                        case 2:
                            _b.sent();
                            return [2 /*return*/];
                    }
                });
            });
        },
        getElement: function (selector, options) {
            return __awaiter(this, void 0, void 0, function () {
                var optionsResolved, elem, _a, handle;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0:
                            optionsResolved = __assign(__assign({}, defaultOptions === null || defaultOptions === void 0 ? void 0 : defaultOptions.getElement), options);
                            elem = null;
                            if (!(typeof selector === 'string')) return [3 /*break*/, 9];
                            if (!(selector.startsWith('//') || selector.startsWith('(//'))) return [3 /*break*/, 4];
                            selector = "xpath/.".concat(selector);
                            if (!(optionsResolved.waitForSelector !== undefined)) return [3 /*break*/, 2];
                            return [4 /*yield*/, page.waitForSelector(selector, { timeout: optionsResolved.waitForSelector })];
                        case 1:
                            _b.sent();
                            _b.label = 2;
                        case 2: return [4 /*yield*/, page.$$(selector)];
                        case 3:
                            _a = __read.apply(void 0, [_b.sent(), 1]), handle = _a[0];
                            elem = handle.asElement();
                            return [3 /*break*/, 8];
                        case 4:
                            if (!(optionsResolved.waitForSelector !== undefined)) return [3 /*break*/, 6];
                            return [4 /*yield*/, page.waitForSelector(selector, { timeout: optionsResolved.waitForSelector })];
                        case 5:
                            _b.sent();
                            _b.label = 6;
                        case 6: return [4 /*yield*/, page.$(selector)];
                        case 7:
                            elem = _b.sent();
                            _b.label = 8;
                        case 8:
                            if (elem === null) {
                                throw new Error("Could not find element with selector \"".concat(selector, "\", make sure you're waiting for the elements by specifying \"waitForSelector\""));
                            }
                            return [3 /*break*/, 10];
                        case 9:
                            // ElementHandle
                            elem = selector;
                            _b.label = 10;
                        case 10: return [2 /*return*/, elem];
                    }
                });
            });
        }
    };
    // Start random mouse movements. Do not await the promise but return immediately
    if (performRandomMoves) {
        randomMove().then(function (_) { }, function (_) { });
    }
    return actions;
};
exports.createCursor = createCursor;
