import { decode } from "./lib/decode.mjs";
import { encode } from "./lib/encode.mjs";
import { Http } from "./lib/http.mjs";

//#region src/client.ts
var MixiClient = class {
	cookie;
	authKey;
	http;
	constructor(cookie, authKey, options) {
		if (!cookie || !authKey) throw new Error("cookie and authKey are required");
		this.cookie = cookie;
		this.authKey = authKey;
		this.http = new Http(cookie, authKey, {
			baseUrl: options?.baseUrl,
			httpAdapter: options?.httpAdapter
		});
	}
	async request(options) {
		let input;
		if (options.payload) input = await encode(options.payload, options.inputMessageName);
		const response = await this.http.request(`/${options.rpcName}`, input).then((res) => res.bytes());
		return await decode(response, options.outputMessageName);
	}
	acceptChatRoom(payload) {
		return this.request({
			rpcName: "AcceptChatRoom",
			inputMessageName: "AcceptChatRoomRequest",
			outputMessageName: "AcceptChatRoomResponse",
			payload
		});
	}
	addMembersToChatRoom(payload) {
		return this.request({
			rpcName: "AddMembersToChatRoom",
			inputMessageName: "AddMembersToChatRoomRequest",
			outputMessageName: "AddMembersToChatRoomResponse",
			payload
		});
	}
	addStampToPost(payload) {
		return this.request({
			rpcName: "AddStampToPost",
			inputMessageName: "AddStampToPostRequest",
			outputMessageName: "AddStampToPostResponse",
			payload
		});
	}
	applyForVerification(payload) {
		return this.request({
			rpcName: "ApplyForVerification",
			inputMessageName: "ApplyForVerificationRequest",
			outputMessageName: "ApplyForVerificationResponse",
			payload
		});
	}
	approveFollowingRequest(payload) {
		return this.request({
			rpcName: "ApproveFollowingRequest",
			inputMessageName: "ApproveFollowingRequestRequest",
			outputMessageName: "ApproveFollowingRequestResponse",
			payload
		});
	}
	approveJoinCommunity(payload) {
		return this.request({
			rpcName: "ApproveJoinCommunity",
			inputMessageName: "ApproveJoinCommunityRequest",
			outputMessageName: "ApproveJoinCommunityResponse",
			payload
		});
	}
	archiveCommunity(payload) {
		return this.request({
			rpcName: "ArchiveCommunity",
			inputMessageName: "ArchiveCommunityRequest",
			outputMessageName: "ArchiveCommunityResponse",
			payload
		});
	}
	bookmarkCommunity(payload) {
		return this.request({
			rpcName: "BookmarkCommunity",
			inputMessageName: "BookmarkCommunityRequest",
			outputMessageName: "BookmarkCommunityResponse",
			payload
		});
	}
	cancelFollowingRequest(payload) {
		return this.request({
			rpcName: "CancelFollowingRequest",
			inputMessageName: "CancelFollowingRequestRequest",
			outputMessageName: "CancelFollowingRequestResponse",
			payload
		});
	}
	cancelJoinCommunityRequest(payload) {
		return this.request({
			rpcName: "CancelJoinCommunityRequest",
			inputMessageName: "CancelJoinCommunityRequestRequest",
			outputMessageName: "CancelJoinCommunityRequestResponse",
			payload
		});
	}
	changeCommunityAdmins(payload) {
		return this.request({
			rpcName: "ChangeCommunityAdmins",
			inputMessageName: "ChangeCommunityAdminsRequest",
			outputMessageName: "ChangeCommunityAdminsResponse",
			payload
		});
	}
	changeCommunityPostSubscriptionType(payload) {
		return this.request({
			rpcName: "ChangeCommunityPostSubscriptionType",
			inputMessageName: "ChangeCommunityPostSubscriptionTypeRequest",
			outputMessageName: "ChangeCommunityPostSubscriptionTypeResponse",
			payload
		});
	}
	changeMyPersonaVisibility(payload) {
		return this.request({
			rpcName: "ChangeMyPersonaVisibility",
			inputMessageName: "ChangeMyPersonaVisibilityRequest",
			outputMessageName: "ChangeMyPersonaVisibilityResponse",
			payload
		});
	}
	checkPendingPost(payload) {
		return this.request({
			rpcName: "CheckPendingPost",
			inputMessageName: "CheckPendingPostRequest",
			outputMessageName: "CheckPendingPostResponse",
			payload
		});
	}
	closeEventCommunity(payload) {
		return this.request({
			rpcName: "CloseEventCommunity",
			inputMessageName: "CloseEventCommunityRequest",
			outputMessageName: "CloseEventCommunityResponse",
			payload
		});
	}
	createBookmark(payload) {
		return this.request({
			rpcName: "CreateBookmark",
			inputMessageName: "CreateBookmarkRequest",
			outputMessageName: "CreateBookmarkResponse",
			payload
		});
	}
	createChatRoom(payload) {
		return this.request({
			rpcName: "CreateChatRoom",
			inputMessageName: "CreateChatRoomRequest",
			outputMessageName: "CreateChatRoomResponse",
			payload
		});
	}
	createCommunity(payload) {
		return this.request({
			rpcName: "CreateCommunity",
			inputMessageName: "CreateCommunityRequest",
			outputMessageName: "CreateCommunityResponse",
			payload
		});
	}
	createEventCommunity(payload) {
		return this.request({
			rpcName: "CreateEventCommunity",
			inputMessageName: "CreateEventCommunityRequest",
			outputMessageName: "CreateEventCommunityResponse",
			payload
		});
	}
	createFollowing(payload) {
		return this.request({
			rpcName: "CreateFollowing",
			inputMessageName: "CreateFollowingRequest",
			outputMessageName: "CreateFollowingResponse",
			payload
		});
	}
	createLike(payload) {
		return this.request({
			rpcName: "CreateLike",
			inputMessageName: "CreateLikeRequest",
			outputMessageName: "CreateLikeResponse",
			payload
		});
	}
	createPersona(payload) {
		return this.request({
			rpcName: "CreatePersona",
			inputMessageName: "CreatePersonaRequest",
			outputMessageName: "NewTokenResponse",
			payload
		});
	}
	createPersonaFromSession(payload) {
		return this.request({
			rpcName: "CreatePersonaFromSession",
			inputMessageName: "CreatePersonaFromSessionRequest",
			outputMessageName: "SessionResponse",
			payload
		});
	}
	createPost(payload) {
		return this.request({
			rpcName: "CreatePost",
			inputMessageName: "CreatePostRequest",
			outputMessageName: "CreatePostResponse",
			payload
		});
	}
	createPostAndEventCommunity(payload) {
		return this.request({
			rpcName: "CreatePostAndEventCommunity",
			inputMessageName: "CreatePostAndEventCommunityRequest",
			outputMessageName: "CreatePostAndEventCommunityResponse",
			payload
		});
	}
	createTopicCommunity(payload) {
		return this.request({
			rpcName: "CreateTopicCommunity",
			inputMessageName: "CreateTopicCommunityRequest",
			outputMessageName: "CreateTopicCommunityResponse",
			payload
		});
	}
	deleteAccount(payload) {
		return this.request({
			rpcName: "DeleteAccount",
			inputMessageName: "DeleteAccountRequest",
			outputMessageName: "DeleteAccountResponse",
			payload
		});
	}
	deleteBookmark(payload) {
		return this.request({
			rpcName: "DeleteBookmark",
			inputMessageName: "DeleteBookmarkRequest",
			outputMessageName: "DeleteBookmarkResponse",
			payload
		});
	}
	deleteCommunityStamp(payload) {
		return this.request({
			rpcName: "DeleteCommunityStamp",
			inputMessageName: "DeleteCommunityStampRequest",
			outputMessageName: "DeleteCommunityStampResponse",
			payload
		});
	}
	deleteExcludedCommunityMember(payload) {
		return this.request({
			rpcName: "DeleteExcludedCommunityMember",
			inputMessageName: "DeleteExcludedCommunityMemberRequest",
			outputMessageName: "DeleteExcludedCommunityMemberResponse",
			payload
		});
	}
	deleteExcludedCommunityMembers(payload) {
		return this.request({
			rpcName: "DeleteExcludedCommunityMembers",
			inputMessageName: "DeleteExcludedCommunityMembersRequest",
			outputMessageName: "DeleteExcludedCommunityMembersResponse",
			payload
		});
	}
	deleteFCMToken(payload) {
		return this.request({
			rpcName: "DeleteFCMToken",
			inputMessageName: "DeleteFCMTokenRequest",
			outputMessageName: "DeleteFCMTokenResponse",
			payload
		});
	}
	deleteFollowing(payload) {
		return this.request({
			rpcName: "DeleteFollowing",
			inputMessageName: "DeleteFollowingRequest",
			outputMessageName: "DeleteFollowingResponse",
			payload
		});
	}
	deleteLike(payload) {
		return this.request({
			rpcName: "DeleteLike",
			inputMessageName: "DeleteLikeRequest",
			outputMessageName: "DeleteLikeResponse",
			payload
		});
	}
	deletePost(payload) {
		return this.request({
			rpcName: "DeletePost",
			inputMessageName: "DeletePostRequest",
			outputMessageName: "DeletePostResponse",
			payload
		});
	}
	deleteRepost(payload) {
		return this.request({
			rpcName: "DeleteRepost",
			inputMessageName: "DeleteRepostRequest",
			outputMessageName: "DeleteRepostResponse",
			payload
		});
	}
	deleteSession(payload) {
		return this.request({
			rpcName: "DeleteSession",
			inputMessageName: "DeleteSessionRequest",
			outputMessageName: "DeleteSessionResponse",
			payload
		});
	}
	denyJoinCommunity(payload) {
		return this.request({
			rpcName: "DenyJoinCommunity",
			inputMessageName: "DenyJoinCommunityRequest",
			outputMessageName: "DenyJoinCommunityResponse",
			payload
		});
	}
	excludeCommunityMember(payload) {
		return this.request({
			rpcName: "ExcludeCommunityMember",
			inputMessageName: "ExcludeCommunityMemberRequest",
			outputMessageName: "ExcludeCommunityMemberResponse",
			payload
		});
	}
	excludeCommunityMembers(payload) {
		return this.request({
			rpcName: "ExcludeCommunityMembers",
			inputMessageName: "ExcludeCommunityMembersRequest",
			outputMessageName: "ExcludeCommunityMembersResponse",
			payload
		});
	}
	exitChatRoom(payload) {
		return this.request({
			rpcName: "ExitChatRoom",
			inputMessageName: "ExitChatRoomRequest",
			outputMessageName: "ExitChatRoomResponse",
			payload
		});
	}
	getAnnouncements(payload) {
		return this.request({
			rpcName: "GetAnnouncements",
			inputMessageName: "GetAnnouncementsRequest",
			outputMessageName: "GetAnnouncementsResponse",
			payload
		});
	}
	getBadgeCount(payload) {
		return this.request({
			rpcName: "GetBadgeCount",
			inputMessageName: "GetBadgeCountRequest",
			outputMessageName: "GetBadgeCountResponse",
			payload
		});
	}
	getBlockingMembersInCommunity(payload) {
		return this.request({
			rpcName: "GetBlockingMembersInCommunity",
			inputMessageName: "GetBlockingMembersInCommunityRequest",
			outputMessageName: "GetBlockingMembersInCommunityResponse",
			payload
		});
	}
	getBlockPersonas(payload) {
		return this.request({
			rpcName: "GetBlockPersonas",
			inputMessageName: "GetBlockPersonasRequest",
			outputMessageName: "GetBlockPersonasResponse",
			payload
		});
	}
	getChatRoom(payload) {
		return this.request({
			rpcName: "GetChatRoom",
			inputMessageName: "GetChatRoomRequest",
			outputMessageName: "GetChatRoomResponse",
			payload
		});
	}
	getChatRoomMessages(payload) {
		return this.request({
			rpcName: "GetChatRoomMessages",
			inputMessageName: "GetChatRoomMessagesRequest",
			outputMessageName: "GetChatRoomMessagesResponse",
			payload
		});
	}
	getChatRooms(payload) {
		return this.request({
			rpcName: "GetChatRooms",
			inputMessageName: "GetChatRoomsRequest",
			outputMessageName: "GetChatRoomsResponse",
			payload
		});
	}
	getCommunities(payload) {
		return this.request({
			rpcName: "GetCommunities",
			inputMessageName: "GetCommunitiesRequest",
			outputMessageName: "GetCommunitiesResponse",
			payload
		});
	}
	getCommunitiesPostNotifications(payload) {
		return this.request({
			rpcName: "GetCommunitiesPostNotifications",
			inputMessageName: "GetCommunitiesPostNotificationsRequest",
			outputMessageName: "GetCommunitiesPostNotificationsResponse",
			payload
		});
	}
	getCommunity(payload) {
		return this.request({
			rpcName: "GetCommunity",
			inputMessageName: "GetCommunityRequest",
			outputMessageName: "GetCommunityResponse",
			payload
		});
	}
	getCommunityBookmarks(payload) {
		return this.request({
			rpcName: "GetCommunityBookmarks",
			inputMessageName: "GetCommunityBookmarksRequest",
			outputMessageName: "GetCommunityBookmarksResponse",
			payload
		});
	}
	getCommunityInvitablePersonas(payload) {
		return this.request({
			rpcName: "GetCommunityInvitablePersonas",
			inputMessageName: "GetCommunityInvitablePersonasRequest",
			outputMessageName: "GetCommunityInvitablePersonasResponse",
			payload
		});
	}
	getCommunityInvitation(payload) {
		return this.request({
			rpcName: "GetCommunityInvitation",
			inputMessageName: "GetCommunityInvitationRequest",
			outputMessageName: "GetCommunityInvitationResponse",
			payload
		});
	}
	getCommunityInvitationCode(payload) {
		return this.request({
			rpcName: "GetCommunityInvitationCode",
			inputMessageName: "GetCommunityInvitationCodeRequest",
			outputMessageName: "GetCommunityInvitationCodeResponse",
			payload
		});
	}
	getCommunityJoinRequests(payload) {
		return this.request({
			rpcName: "GetCommunityJoinRequests",
			inputMessageName: "GetCommunityJoinRequestsRequest",
			outputMessageName: "GetCommunityJoinRequestsResponse",
			payload
		});
	}
	getCommunityPostPin(payload) {
		return this.request({
			rpcName: "GetCommunityPostPin",
			inputMessageName: "GetCommunityPostPinRequest",
			outputMessageName: "GetCommunityPostPinResponse",
			payload
		});
	}
	getCommunityStamps(payload) {
		return this.request({
			rpcName: "GetCommunityStamps",
			inputMessageName: "GetCommunityStampsRequest",
			outputMessageName: "GetCommunityStampsResponse",
			payload
		});
	}
	getCommunityTimeline(payload) {
		return this.request({
			rpcName: "GetCommunityTimeline",
			inputMessageName: "GetCommunityTimelineRequest",
			outputMessageName: "GetTimelineResponse",
			payload
		});
	}
	getCompletedOrClosedEventCommunities(payload) {
		return this.request({
			rpcName: "GetCompletedOrClosedEventCommunities",
			inputMessageName: "GetCompletedOrClosedEventCommunitiesRequest",
			outputMessageName: "GetCompletedOrClosedEventCommunitiesResponse",
			payload
		});
	}
	getEventCommunitiesWithinCommunity(payload) {
		return this.request({
			rpcName: "GetEventCommunitiesWithinCommunity",
			inputMessageName: "GetEventCommunitiesWithinCommunityRequest",
			outputMessageName: "GetEventCommunitiesWithinCommunityResponse",
			payload
		});
	}
	getExclusiveCommunityMembers(payload) {
		return this.request({
			rpcName: "GetExclusiveCommunityMembers",
			inputMessageName: "GetExclusiveCommunityMembersRequest",
			outputMessageName: "GetExclusiveCommunityMembersResponse",
			payload
		});
	}
	getFeatureFlags(payload) {
		return this.request({
			rpcName: "GetFeatureFlags",
			inputMessageName: "GetFeatureFlagsRequest",
			outputMessageName: "GetFeatureFlagsResponse",
			payload
		});
	}
	getFollowers(payload) {
		return this.request({
			rpcName: "GetFollowers",
			inputMessageName: "GetFollowersRequest",
			outputMessageName: "GetFollowersResponse",
			payload
		});
	}
	getFollowingCount(payload) {
		return this.request({
			rpcName: "GetFollowingCount",
			inputMessageName: "GetFollowingCountRequest",
			outputMessageName: "GetFollowingCountResponse",
			payload
		});
	}
	getFollowingRequests(payload) {
		return this.request({
			rpcName: "GetFollowingRequests",
			inputMessageName: "GetFollowingRequestsRequest",
			outputMessageName: "GetFollowingRequestsResponse",
			payload
		});
	}
	getFollowings(payload) {
		return this.request({
			rpcName: "GetFollowings",
			inputMessageName: "GetFollowingsRequest",
			outputMessageName: "GetFollowingsResponse",
			payload
		});
	}
	getFollowingsTimeline(payload) {
		return this.request({
			rpcName: "GetFollowingsTimeline",
			inputMessageName: "GetFollowingsTimelineRequest",
			outputMessageName: "GetTimelineResponse",
			payload
		});
	}
	getGlobalCount(payload) {
		return this.request({
			rpcName: "GetGlobalCount",
			inputMessageName: "GetGlobalCountRequest",
			outputMessageName: "GetGlobalCountResponse",
			payload
		});
	}
	getHashtagTimeline(payload) {
		return this.request({
			rpcName: "GetHashtagTimeline",
			inputMessageName: "GetHashtagTimelineRequest",
			outputMessageName: "GetTimelineResponse",
			payload
		});
	}
	getInAppEventStatus(payload) {
		return this.request({
			rpcName: "GetInAppEventStatus",
			inputMessageName: "GetInAppEventStatusRequest",
			outputMessageName: "GetInAppEventStatusResponse",
			payload
		});
	}
	getInAppEventStatusAll(payload) {
		return this.request({
			rpcName: "GetInAppEventStatusAll",
			inputMessageName: "GetInAppEventStatusAllRequest",
			outputMessageName: "GetInAppEventStatusAllResponse",
			payload
		});
	}
	getInvitation(payload) {
		return this.request({
			rpcName: "GetInvitation",
			inputMessageName: "GetInvitationRequest",
			outputMessageName: "GetInvitationResponse",
			payload
		});
	}
	getInvitationCode(payload) {
		return this.request({
			rpcName: "GetInvitationCode",
			inputMessageName: "GetInvitationCodeRequest",
			outputMessageName: "GetInvitationCodeResponse",
			payload
		});
	}
	getLatestRenameLog(payload) {
		return this.request({
			rpcName: "GetLatestRenameLog",
			inputMessageName: "GetLatestRenameLogRequest",
			outputMessageName: "GetLatestRenameLogResponse",
			payload
		});
	}
	getLikingPersonas(payload) {
		return this.request({
			rpcName: "GetLikingPersonas",
			inputMessageName: "GetLikingPersonasRequest",
			outputMessageName: "GetLikingPersonasResponse",
			payload
		});
	}
	getLimitedTimeCampaign(payload) {
		return this.request({
			rpcName: "GetLimitedTimeCampaign",
			inputMessageName: "GetLimitedTimeCampaignRequest",
			outputMessageName: "GetLimitedTimeCampaignResponse",
			payload
		});
	}
	getMedia(payload) {
		return this.request({
			rpcName: "GetMedia",
			inputMessageName: "GetMediaRequest",
			outputMessageName: "GetMediaResponse",
			payload
		});
	}
	getMuteChatRooms(payload) {
		return this.request({
			rpcName: "GetMuteChatRooms",
			inputMessageName: "GetMuteChatRoomsRequest",
			outputMessageName: "GetMuteChatRoomsResponse",
			payload
		});
	}
	getMutePersonas(payload) {
		return this.request({
			rpcName: "GetMutePersonas",
			inputMessageName: "GetMutePersonasRequest",
			outputMessageName: "GetMutePersonasResponse",
			payload
		});
	}
	getNotifications(payload) {
		return this.request({
			rpcName: "GetNotifications",
			inputMessageName: "GetNotificationsRequest",
			outputMessageName: "GetNotificationsResponse",
			payload
		});
	}
	getOngoingEventCommunities(payload) {
		return this.request({
			rpcName: "GetOngoingEventCommunities",
			inputMessageName: "GetOngoingEventCommunitiesRequest",
			outputMessageName: "GetOngoingEventCommunitiesResponse",
			payload
		});
	}
	getOngoingOrUpcomingEventCommunities(payload) {
		return this.request({
			rpcName: "GetOngoingOrUpcomingEventCommunities",
			inputMessageName: "GetOngoingOrUpcomingEventCommunitiesRequest",
			outputMessageName: "GetOngoingOrUpcomingEventCommunitiesResponse",
			payload
		});
	}
	getParticipatingCommunities(payload) {
		return this.request({
			rpcName: "GetParticipatingCommunities",
			inputMessageName: "GetParticipatingCommunitiesRequest",
			outputMessageName: "GetParticipatingCommunitiesResponse",
			payload
		});
	}
	getParticipatingCommunityMembers(payload) {
		return this.request({
			rpcName: "GetParticipatingCommunityMembers",
			inputMessageName: "GetParticipatingCommunityMembersRequest",
			outputMessageName: "GetParticipatingCommunityMembersResponse",
			payload
		});
	}
	getPastOrClosedEventCommunities(payload) {
		return this.request({
			rpcName: "GetPastOrClosedEventCommunities",
			inputMessageName: "GetPastOrClosedEventCommunitiesRequest",
			outputMessageName: "GetPastOrClosedEventCommunitiesResponse",
			payload
		});
	}
	getPendingFollowingRequests(payload) {
		return this.request({
			rpcName: "GetPendingFollowingRequests",
			inputMessageName: "GetPendingFollowingRequestsRequest",
			outputMessageName: "GetPendingFollowingRequestsResponse",
			payload
		});
	}
	getPendingVerificationSocialMedia(payload) {
		return this.request({
			rpcName: "GetPendingVerificationSocialMedia",
			inputMessageName: "GetPendingVerificationSocialMediaRequest",
			outputMessageName: "GetPendingVerificationSocialMediaResponse",
			payload
		});
	}
	getPersonaByName(payload) {
		return this.request({
			rpcName: "GetPersonaByName",
			inputMessageName: "GetPersonaByNameRequest",
			outputMessageName: "GetPersonaResponse",
			payload
		});
	}
	getPersonalCommunityPosts(payload) {
		return this.request({
			rpcName: "GetPersonalCommunityPosts",
			inputMessageName: "GetPersonalCommunityPostsRequest",
			outputMessageName: "GetTimelineResponse",
			payload
		});
	}
	getPersonalInformation(payload) {
		return this.request({
			rpcName: "GetPersonalInformation",
			inputMessageName: "GetPersonalInformationRequest",
			outputMessageName: "GetPersonalInformationResponse",
			payload
		});
	}
	getPersonalTimeline(payload) {
		return this.request({
			rpcName: "GetPersonalTimeline",
			inputMessageName: "GetPersonalTimelineRequest",
			outputMessageName: "GetTimelineResponse",
			payload
		});
	}
	getPersonas(payload) {
		return this.request({
			rpcName: "GetPersonas",
			inputMessageName: "GetPersonasRequest",
			outputMessageName: "GetPersonasResponse",
			payload
		});
	}
	getPersonasPostNotifications(payload) {
		return this.request({
			rpcName: "GetPersonasPostNotifications",
			inputMessageName: "GetPersonasPostNotificationsRequest",
			outputMessageName: "GetPersonasPostNotificationsResponse",
			payload
		});
	}
	getPost(payload) {
		return this.request({
			rpcName: "GetPost",
			inputMessageName: "GetPostRequest",
			outputMessageName: "GetPostResponse",
			payload
		});
	}
	getPostableCommunities(payload) {
		return this.request({
			rpcName: "GetPostableCommunities",
			inputMessageName: "GetPostableCommunitiesRequest",
			outputMessageName: "GetPostableCommunitiesResponse",
			payload
		});
	}
	getPosts(payload) {
		return this.request({
			rpcName: "GetPosts",
			inputMessageName: "GetPostsRequest",
			outputMessageName: "GetPostsResponse",
			payload
		});
	}
	getPostStampReactions(payload) {
		return this.request({
			rpcName: "GetPostStampReactions",
			inputMessageName: "GetPostStampReactionsRequest",
			outputMessageName: "GetPostStampReactionsResponse",
			payload
		});
	}
	getProfile(payload) {
		return this.request({
			rpcName: "GetProfile",
			inputMessageName: "GetProfileRequest",
			outputMessageName: "GetProfileResponse",
			payload
		});
	}
	getProfileByName(payload) {
		return this.request({
			rpcName: "GetProfileByName",
			inputMessageName: "GetProfileByNameRequest",
			outputMessageName: "GetProfileResponse",
			payload
		});
	}
	getProfilePostPin(payload) {
		return this.request({
			rpcName: "GetProfilePostPin",
			inputMessageName: "GetProfilePostPinRequest",
			outputMessageName: "GetProfilePostPinResponse",
			payload
		});
	}
	getQuotePosts(payload) {
		return this.request({
			rpcName: "GetQuotePosts",
			inputMessageName: "GetQuotePostsRequest",
			outputMessageName: "GetQuotePostsResponse",
			payload
		});
	}
	getReactionPosts(payload) {
		return this.request({
			rpcName: "GetReactionPosts",
			inputMessageName: "GetReactionPostsRequest",
			outputMessageName: "GetReactionPostsResponse",
			payload
		});
	}
	getRecommendations(payload) {
		return this.request({
			rpcName: "GetRecommendations",
			inputMessageName: "GetRecommendationsRequest",
			outputMessageName: "GetRecommendationsResponse",
			payload
		});
	}
	getRecommendedCommunities(payload) {
		return this.request({
			rpcName: "GetRecommendedCommunities",
			inputMessageName: "GetRecommendedCommunitiesRequest",
			outputMessageName: "GetRecommendedCommunitiesResponse",
			payload
		});
	}
	getRecommendedTimeline(payload) {
		return this.request({
			rpcName: "GetRecommendedTimeline",
			inputMessageName: "GetRecommendedTimelineRequest",
			outputMessageName: "GetTimelineResponse",
			payload
		});
	}
	getRemoteConfig(payload) {
		return this.request({
			rpcName: "GetRemoteConfig",
			inputMessageName: "GetRemoteConfigRequest",
			outputMessageName: "GetRemoteConfigResponse",
			payload
		});
	}
	getRemotePushSettings(payload) {
		return this.request({
			rpcName: "GetRemotePushSettings",
			inputMessageName: "GetRemotePushSettingsRequest",
			outputMessageName: "GetRemotePushSettingsResponse",
			payload
		});
	}
	getReplies(payload) {
		return this.request({
			rpcName: "GetReplies",
			inputMessageName: "GetRepliesRequest",
			outputMessageName: "GetRepliesResponse",
			payload
		});
	}
	getReplyAncestors(payload) {
		return this.request({
			rpcName: "GetReplyAncestors",
			inputMessageName: "GetReplyAncestorsRequest",
			outputMessageName: "GetReplyAncestorsResponse",
			payload
		});
	}
	getRepostingPersonas(payload) {
		return this.request({
			rpcName: "GetRepostingPersonas",
			inputMessageName: "GetRepostingPersonasRequest",
			outputMessageName: "GetRepostingPersonasResponse",
			payload
		});
	}
	getRequestedChatRooms(payload) {
		return this.request({
			rpcName: "GetRequestedChatRooms",
			inputMessageName: "GetRequestedChatRoomsRequest",
			outputMessageName: "GetRequestedChatRoomsResponse",
			payload
		});
	}
	getSession(payload) {
		return this.request({
			rpcName: "GetSession",
			inputMessageName: "GetSessionRequest",
			outputMessageName: "SessionResponse",
			payload
		});
	}
	getStamps(payload) {
		return this.request({
			rpcName: "GetStamps",
			inputMessageName: "GetStampsRequest",
			outputMessageName: "GetStampsResponse",
			payload
		});
	}
	getStorageRateLimit(payload) {
		return this.request({
			rpcName: "GetStorageRateLimit",
			inputMessageName: "GetStorageRateLimitRequest",
			outputMessageName: "GetStorageRateLimitResponse",
			payload
		});
	}
	getSubscribingFeeds(payload) {
		return this.request({
			rpcName: "GetSubscribingFeeds",
			inputMessageName: "GetSubscribingFeedsRequest",
			outputMessageName: "GetSubscribingFeedsResponse",
			payload
		});
	}
	getThreadPosts(payload) {
		return this.request({
			rpcName: "GetThreadPosts",
			inputMessageName: "GetThreadPostsRequest",
			outputMessageName: "GetTimelineResponse",
			payload
		});
	}
	getTimelineSetting(payload) {
		return this.request({
			rpcName: "GetTimelineSetting",
			inputMessageName: "GetTimelineSettingRequest",
			outputMessageName: "GetTimelineSettingResponse",
			payload
		});
	}
	getUnreadChatRoomCount(payload) {
		return this.request({
			rpcName: "GetUnreadChatRoomCount",
			inputMessageName: "GetUnreadChatRoomCountRequest",
			outputMessageName: "GetUnreadChatRoomCountResponse",
			payload
		});
	}
	getUpcomingEventCommunities(payload) {
		return this.request({
			rpcName: "GetUpcomingEventCommunities",
			inputMessageName: "GetUpcomingEventCommunitiesRequest",
			outputMessageName: "GetUpcomingEventCommunitiesResponse",
			payload
		});
	}
	getWaitingCommunities(payload) {
		return this.request({
			rpcName: "GetWaitingCommunities",
			inputMessageName: "GetWaitingCommunitiesRequest",
			outputMessageName: "GetWaitingCommunitiesResponse",
			payload
		});
	}
	incrementGlobalCount(payload) {
		return this.request({
			rpcName: "IncrementGlobalCount",
			inputMessageName: "IncrementGlobalCountRequest",
			outputMessageName: "IncrementGlobalCountResponse",
			payload
		});
	}
	joinCommunity(payload) {
		return this.request({
			rpcName: "JoinCommunity",
			inputMessageName: "JoinCommunityRequest",
			outputMessageName: "JoinCommunityResponse",
			payload
		});
	}
	leaveCommunity(payload) {
		return this.request({
			rpcName: "LeaveCommunity",
			inputMessageName: "LeaveCommunityRequest",
			outputMessageName: "LeaveCommunityResponse",
			payload
		});
	}
	makeChatRoomInvisible(payload) {
		return this.request({
			rpcName: "MakeChatRoomInvisible",
			inputMessageName: "MakeChatRoomInvisibleRequest",
			outputMessageName: "MakeChatRoomInvisibleResponse",
			payload
		});
	}
	makeChatRoomMute(payload) {
		return this.request({
			rpcName: "MakeChatRoomMute",
			inputMessageName: "MakeChatRoomMuteRequest",
			outputMessageName: "MakeChatRoomMuteResponse",
			payload
		});
	}
	makeChatRoomUnmute(payload) {
		return this.request({
			rpcName: "MakeChatRoomUnmute",
			inputMessageName: "MakeChatRoomUnmuteRequest",
			outputMessageName: "MakeChatRoomUnmuteResponse",
			payload
		});
	}
	makeCommunityPostNotificationDisabled(payload) {
		return this.request({
			rpcName: "MakeCommunityPostNotificationDisabled",
			inputMessageName: "MakeCommunityPostNotificationDisabledRequest",
			outputMessageName: "MakeCommunityPostNotificationDisabledResponse",
			payload
		});
	}
	makeCommunityPostNotificationEnabled(payload) {
		return this.request({
			rpcName: "MakeCommunityPostNotificationEnabled",
			inputMessageName: "MakeCommunityPostNotificationEnabledRequest",
			outputMessageName: "MakeCommunityPostNotificationEnabledResponse",
			payload
		});
	}
	makeCommunitySubscriptionDisabled(payload) {
		return this.request({
			rpcName: "MakeCommunitySubscriptionDisabled",
			inputMessageName: "MakeCommunitySubscriptionDisabledRequest",
			outputMessageName: "MakeCommunitySubscriptionDisabledResponse",
			payload
		});
	}
	makeCommunitySubscriptionEnabled(payload) {
		return this.request({
			rpcName: "MakeCommunitySubscriptionEnabled",
			inputMessageName: "MakeCommunitySubscriptionEnabledRequest",
			outputMessageName: "MakeCommunitySubscriptionEnabledResponse",
			payload
		});
	}
	makePersonaBlock(payload) {
		return this.request({
			rpcName: "MakePersonaBlock",
			inputMessageName: "MakePersonaBlockRequest",
			outputMessageName: "MakePersonaBlockResponse",
			payload
		});
	}
	makePersonaMute(payload) {
		return this.request({
			rpcName: "MakePersonaMute",
			inputMessageName: "MakePersonaMuteRequest",
			outputMessageName: "MakePersonaMuteResponse",
			payload
		});
	}
	makePersonaPostNotificationDisabled(payload) {
		return this.request({
			rpcName: "MakePersonaPostNotificationDisabled",
			inputMessageName: "MakePersonaPostNotificationDisabledRequest",
			outputMessageName: "MakePersonaPostNotificationDisabledResponse",
			payload
		});
	}
	makePersonaPostNotificationEnabled(payload) {
		return this.request({
			rpcName: "MakePersonaPostNotificationEnabled",
			inputMessageName: "MakePersonaPostNotificationEnabledRequest",
			outputMessageName: "MakePersonaPostNotificationEnabledResponse",
			payload
		});
	}
	makePersonaUnblock(payload) {
		return this.request({
			rpcName: "MakePersonaUnblock",
			inputMessageName: "MakePersonaUnblockRequest",
			outputMessageName: "MakePersonaUnblockResponse",
			payload
		});
	}
	makePersonaUnmute(payload) {
		return this.request({
			rpcName: "MakePersonaUnmute",
			inputMessageName: "MakePersonaUnmuteRequest",
			outputMessageName: "MakePersonaUnmuteResponse",
			payload
		});
	}
	markAnnouncementAsRead(payload) {
		return this.request({
			rpcName: "MarkAnnouncementAsRead",
			inputMessageName: "MarkAnnouncementAsReadRequest",
			outputMessageName: "MarkAnnouncementAsReadResponse",
			payload
		});
	}
	markNotificationAsRead(payload) {
		return this.request({
			rpcName: "MarkNotificationAsRead",
			inputMessageName: "MarkNotificationAsReadRequest",
			outputMessageName: "MarkNotificationAsReadResponse",
			payload
		});
	}
	markNotificationsAsReadBeforeTime(payload) {
		return this.request({
			rpcName: "MarkNotificationsAsReadBeforeTime",
			inputMessageName: "MarkNotificationsAsReadBeforeTimeRequest",
			outputMessageName: "MarkNotificationsAsReadResponse",
			payload
		});
	}
	pinCommunityPost(payload) {
		return this.request({
			rpcName: "PinCommunityPost",
			inputMessageName: "PinCommunityPostRequest",
			outputMessageName: "PinCommunityPostResponse",
			payload
		});
	}
	pinProfilePost(payload) {
		return this.request({
			rpcName: "PinProfilePost",
			inputMessageName: "PinProfilePostRequest",
			outputMessageName: "PinProfilePostResponse",
			payload
		});
	}
	prepareMediaUploading(payload) {
		return this.request({
			rpcName: "PrepareMediaUploading",
			inputMessageName: "PrepareMediaUploadingRequest",
			outputMessageName: "PrepareMediaUploadingResponse",
			payload
		});
	}
	readPersonaWarning(payload) {
		return this.request({
			rpcName: "ReadPersonaWarning",
			inputMessageName: "ReadPersonaWarningRequest",
			outputMessageName: "ReadPersonaWarningResponse",
			payload
		});
	}
	refreshToken(payload) {
		return this.request({
			rpcName: "RefreshToken",
			inputMessageName: "RefreshTokenRequest",
			outputMessageName: "NewTokenResponse",
			payload
		});
	}
	registerFCMToken(payload) {
		return this.request({
			rpcName: "RegisterFCMToken",
			inputMessageName: "RegisterFCMTokenRequest",
			outputMessageName: "RegisterFCMTokenResponse",
			payload
		});
	}
	rejectFollowingRequest(payload) {
		return this.request({
			rpcName: "RejectFollowingRequest",
			inputMessageName: "RejectFollowingRequestRequest",
			outputMessageName: "RejectFollowingRequestResponse",
			payload
		});
	}
	removeCommunityBookmark(payload) {
		return this.request({
			rpcName: "RemoveCommunityBookmark",
			inputMessageName: "RemoveCommunityBookmarkRequest",
			outputMessageName: "RemoveCommunityBookmarkResponse",
			payload
		});
	}
	removeCommunityPostPin(payload) {
		return this.request({
			rpcName: "RemoveCommunityPostPin",
			inputMessageName: "RemoveCommunityPostPinRequest",
			outputMessageName: "RemoveCommunityPostPinResponse",
			payload
		});
	}
	removeProfilePostPin(payload) {
		return this.request({
			rpcName: "RemoveProfilePostPin",
			inputMessageName: "RemoveProfilePostPinRequest",
			outputMessageName: "RemoveProfilePostPinResponse",
			payload
		});
	}
	removeStampFromOwnPost(payload) {
		return this.request({
			rpcName: "RemoveStampFromOwnPost",
			inputMessageName: "RemoveStampFromOwnPostRequest",
			outputMessageName: "RemoveStampFromOwnPostResponse",
			payload
		});
	}
	removeStampFromPost(payload) {
		return this.request({
			rpcName: "RemoveStampFromPost",
			inputMessageName: "RemoveStampFromPostRequest",
			outputMessageName: "RemoveStampFromPostResponse",
			payload
		});
	}
	reportChatRoomMessage(payload) {
		return this.request({
			rpcName: "ReportChatRoomMessage",
			inputMessageName: "ReportChatRoomMessageRequest",
			outputMessageName: "ReportChatRoomMessageResponse",
			payload
		});
	}
	reportCommunity(payload) {
		return this.request({
			rpcName: "ReportCommunity",
			inputMessageName: "ReportCommunityRequest",
			outputMessageName: "ReportCommunityResponse",
			payload
		});
	}
	reportPersona(payload) {
		return this.request({
			rpcName: "ReportPersona",
			inputMessageName: "ReportPersonaRequest",
			outputMessageName: "ReportPersonaResponse",
			payload
		});
	}
	reportPost(payload) {
		return this.request({
			rpcName: "ReportPost",
			inputMessageName: "ReportPostRequest",
			outputMessageName: "ReportPostResponse",
			payload
		});
	}
	requestJoinCommunity(payload) {
		return this.request({
			rpcName: "RequestJoinCommunity",
			inputMessageName: "RequestJoinCommunityRequest",
			outputMessageName: "RequestJoinCommunityResponse",
			payload
		});
	}
	resendEmailPassCode(payload) {
		return this.request({
			rpcName: "ResendEmailPassCode",
			inputMessageName: "ResendEmailPassCodeRequest",
			outputMessageName: "ResendEmailPassCodeResponse",
			payload
		});
	}
	resendSMSPassCode(payload) {
		return this.request({
			rpcName: "ResendSMSPassCode",
			inputMessageName: "ResendSMSPassCodeRequest",
			outputMessageName: "ResendSMSPassCodeResponse",
			payload
		});
	}
	restrictCommunityPost(payload) {
		return this.request({
			rpcName: "RestrictCommunityPost",
			inputMessageName: "RestrictCommunityPostRequest",
			outputMessageName: "RestrictCommunityPostResponse",
			payload
		});
	}
	search(payload) {
		return this.request({
			rpcName: "Search",
			inputMessageName: "SearchRequest",
			outputMessageName: "SearchResponse",
			payload
		});
	}
	searchChatRooms(payload) {
		return this.request({
			rpcName: "SearchChatRooms",
			inputMessageName: "SearchChatRoomsRequest",
			outputMessageName: "SearchChatRoomsResponse",
			payload
		});
	}
	searchTypeahead(payload) {
		return this.request({
			rpcName: "SearchTypeahead",
			inputMessageName: "SearchTypeaheadRequest",
			outputMessageName: "SearchTypeaheadResponse",
			payload
		});
	}
	sendCommunityInvitation(payload) {
		return this.request({
			rpcName: "SendCommunityInvitation",
			inputMessageName: "SendCommunityInvitationRequest",
			outputMessageName: "SendCommunityInvitationResponse",
			payload
		});
	}
	sendDirectMessage(payload) {
		return this.request({
			rpcName: "SendDirectMessage",
			inputMessageName: "SendDirectMessageRequest",
			outputMessageName: "SendDirectMessageResponse",
			payload
		});
	}
	sendFollowingRequest(payload) {
		return this.request({
			rpcName: "SendFollowingRequest",
			inputMessageName: "SendFollowingRequestRequest",
			outputMessageName: "SendFollowingRequestResponse",
			payload
		});
	}
	sendGroupMessage(payload) {
		return this.request({
			rpcName: "SendGroupMessage",
			inputMessageName: "SendGroupMessageRequest",
			outputMessageName: "SendGroupMessageResponse",
			payload
		});
	}
	sendMessageToRoom(payload) {
		return this.request({
			rpcName: "SendMessageToRoom",
			inputMessageName: "SendMessageToRoomRequest",
			outputMessageName: "SendMessageToRoomResponse",
			payload
		});
	}
	setCommunityTags(payload) {
		return this.request({
			rpcName: "SetCommunityTags",
			inputMessageName: "SetCommunityTagsRequest",
			outputMessageName: "SetCommunityTagsResponse",
			payload
		});
	}
	signin(payload) {
		return this.request({
			rpcName: "Signin",
			inputMessageName: "SigninRequest",
			outputMessageName: "NewTokenResponse",
			payload
		});
	}
	signOut(payload) {
		return this.request({
			rpcName: "SignOut",
			inputMessageName: "SignOutRequest",
			outputMessageName: "SignOutResponse",
			payload
		});
	}
	signup(payload) {
		return this.request({
			rpcName: "Signup",
			inputMessageName: "SignupRequest",
			outputMessageName: "NewTokenResponse",
			payload
		});
	}
	startEmailAuthentication(payload) {
		return this.request({
			rpcName: "StartEmailAuthentication",
			inputMessageName: "StartEmailAuthenticationRequest",
			outputMessageName: "StartEmailAuthenticationResponse",
			payload
		});
	}
	startSMSAuthentication(payload) {
		return this.request({
			rpcName: "StartSMSAuthentication",
			inputMessageName: "StartSMSAuthenticationRequest",
			outputMessageName: "StartSMSAuthenticationResponse",
			payload
		});
	}
	switchPersona(payload) {
		return this.request({
			rpcName: "SwitchPersona",
			inputMessageName: "SwitchPersonaRequest",
			outputMessageName: "SwitchPersonaResponse",
			payload
		});
	}
	updateChatRoomTitle(payload) {
		return this.request({
			rpcName: "UpdateChatRoomTitle",
			inputMessageName: "UpdateChatRoomTitleRequest",
			outputMessageName: "UpdateChatRoomTitleResponse",
			payload
		});
	}
	updateCommunity(payload) {
		return this.request({
			rpcName: "UpdateCommunity",
			inputMessageName: "UpdateCommunityRequest",
			outputMessageName: "UpdateCommunityResponse",
			payload
		});
	}
	updateCommunityLastAccessTime(payload) {
		return this.request({
			rpcName: "UpdateCommunityLastAccessTime",
			inputMessageName: "UpdateCommunityLastAccessTimeRequest",
			outputMessageName: "UpdateCommunityLastAccessTimeResponse",
			payload
		});
	}
	updateDisplayName(payload) {
		return this.request({
			rpcName: "UpdateDisplayName",
			inputMessageName: "UpdateDisplayNameRequest",
			outputMessageName: "UpdateDisplayNameResponse",
			payload
		});
	}
	updateEventCommunity(payload) {
		return this.request({
			rpcName: "UpdateEventCommunity",
			inputMessageName: "UpdateEventCommunityRequest",
			outputMessageName: "UpdateEventCommunityResponse",
			payload
		});
	}
	updateInAppEventDone(payload) {
		return this.request({
			rpcName: "UpdateInAppEventDone",
			inputMessageName: "UpdateInAppEventDoneRequest",
			outputMessageName: "UpdateInAppEventDoneResponse",
			payload
		});
	}
	updateName(payload) {
		return this.request({
			rpcName: "UpdateName",
			inputMessageName: "UpdateNameRequest",
			outputMessageName: "UpdateNameResponse",
			payload
		});
	}
	updateProfile(payload) {
		return this.request({
			rpcName: "UpdateProfile",
			inputMessageName: "UpdateProfileRequest",
			outputMessageName: "UpdateProfileResponse",
			payload
		});
	}
	updateProfileSocialMedia(payload) {
		return this.request({
			rpcName: "UpdateProfileSocialMedia",
			inputMessageName: "UpdateProfileSocialMediaRequest",
			outputMessageName: "UpdateProfileSocialMediaResponse",
			payload
		});
	}
	updateRemotePushSettings(payload) {
		return this.request({
			rpcName: "UpdateRemotePushSettings",
			inputMessageName: "UpdateRemotePushSettingsRequest",
			outputMessageName: "UpdateRemotePushSettingsResponse",
			payload
		});
	}
	updateTimelineSetting(payload) {
		return this.request({
			rpcName: "UpdateTimelineSetting",
			inputMessageName: "UpdateTimelineSettingRequest",
			outputMessageName: "UpdateTimelineSettingResponse",
			payload
		});
	}
	updateTopicCommunity(payload) {
		return this.request({
			rpcName: "UpdateTopicCommunity",
			inputMessageName: "UpdateTopicCommunityRequest",
			outputMessageName: "UpdateTopicCommunityResponse",
			payload
		});
	}
	verifyEmailAuthentication(payload) {
		return this.request({
			rpcName: "VerifyEmailAuthentication",
			inputMessageName: "VerifyEmailAuthenticationRequest",
			outputMessageName: "NewTokenResponse",
			payload
		});
	}
	verifyEmailSessionAuthentication(payload) {
		return this.request({
			rpcName: "VerifyEmailSessionAuthentication",
			inputMessageName: "VerifyEmailSessionAuthenticationRequest",
			outputMessageName: "VerifyEmailSessionAuthenticationResponse",
			payload
		});
	}
	verifySMSAuthentication(payload) {
		return this.request({
			rpcName: "VerifySMSAuthentication",
			inputMessageName: "VerifySMSAuthenticationRequest",
			outputMessageName: "NewTokenResponse",
			payload
		});
	}
};

//#endregion
export { MixiClient };