// src/params.ts
var RankingType = {
  Daily: "d",
  Weekly: "w",
  Monthly: "m",
  Quarterly: "q"
};
var BooleanNumber = {
  True: 1,
  False: 0
};
var Fields = {
  /** 小説名 */
  title: "t",
  /** Nコード */
  ncode: "n",
  /** 作者のユーザID(数値) */
  userid: "u",
  /** 作者名 */
  writer: "w",
  /** 小説のあらすじ */
  story: "s",
  /** 大ジャンル */
  biggenre: "bg",
  /** ジャンル */
  genre: "g",
  /** キーワード */
  keyword: "k",
  /** 初回掲載日 */
  general_firstup: "gf",
  /** 最終掲載日 */
  general_lastup: "gl",
  /** 連載の場合は1、短編の場合は2 */
  noveltype: "nt",
  /** 短編小説と完結済小説は0となっています。連載中は1です。 */
  end: "e",
  /** 全掲載部分数 */
  general_all_no: "ga",
  /** 小説文字数 */
  length: "l",
  /** 読了時間(分単位) */
  time: "ti",
  /** 長期連載停止中 */
  isstop: "i",
  /** 登録必須キーワードに「R15」が含まれる場合は1、それ以外は0です。 */
  isr15: "isr",
  /** 登録必須キーワードに「ボーイズラブ」が含まれる場合は1、それ以外は0です。 */
  isbl: "ibl",
  /** 登録必須キーワードに「ガールズラブ」が含まれる場合は1、それ以外は0です。 */
  isgl: "igl",
  /** 登録必須キーワードに「残酷な描写あり」が含まれる場合は1、それ以外は0です。 */
  iszankoku: "izk",
  /** 登録必須キーワードに「異世界転生」が含まれる場合は1、それ以外は0です。 */
  istensei: "its",
  /** 登録必須キーワードに「異世界転移」が含まれる場合は1、それ以外は0です。 */
  istenni: "iti",
  /** 総合評価ポイント */
  global_point: "gp",
  /** 日間ポイント */
  daily_point: "dp",
  /** 週間ポイント */
  weekly_point: "wp",
  /** 月間ポイント */
  monthly_point: "mp",
  /** 四半期ポイント */
  quarter_point: "qp",
  /** 年間ポイント */
  yearly_point: "yp",
  /** ブックマーク数 */
  fav_novel_cnt: "f",
  /** 感想数 */
  impression_cnt: "imp",
  /** レビュー数 */
  review_cnt: "r",
  /** 評価ポイント */
  all_point: "a",
  /** 評価者数 */
  all_hyoka_cnt: "ah",
  /** 挿絵の数 */
  sasie_cnt: "sa",
  /** 会話率 */
  kaiwaritu: "ka",
  /** 小説の更新日時 */
  novelupdated_at: "nu",
  /**
   * 最終更新日時
   * システム用で小説更新時とは関係ありません
   */
  updated_at: "ua"
};
var R18Fields = {
  /** 小説名 */
  title: "t",
  /** Nコード */
  ncode: "n",
  /** 作者のユーザID(数値) */
  userid: "u",
  /** 作者名 */
  writer: "w",
  /** 小説のあらすじ */
  story: "s",
  /** 掲載サイト */
  nocgenre: "ng",
  /** キーワード */
  keyword: "k",
  /** 初回掲載日 */
  general_firstup: "gf",
  /** 最終掲載日 */
  general_lastup: "gl",
  /** 連載の場合は1、短編の場合は2 */
  noveltype: "nt",
  /** 短編小説と完結済小説は0となっています。連載中は1です。 */
  end: "e",
  /** 全掲載部分数 */
  general_all_no: "ga",
  /** 小説文字数 */
  length: "l",
  /** 読了時間(分単位) */
  time: "ti",
  /** 長期連載停止中 */
  isstop: "i",
  /** 登録必須キーワードに「ボーイズラブ」が含まれる場合は1、それ以外は0です。 */
  isbl: "ibl",
  /** 登録必須キーワードに「ガールズラブ」が含まれる場合は1、それ以外は0です。 */
  isgl: "igl",
  /** 登録必須キーワードに「残酷な描写あり」が含まれる場合は1、それ以外は0です。 */
  iszankoku: "izk",
  /** 登録必須キーワードに「異世界転生」が含まれる場合は1、それ以外は0です。 */
  istensei: "its",
  /** 登録必須キーワードに「異世界転移」が含まれる場合は1、それ以外は0です。 */
  istenni: "iti",
  /** 総合評価ポイント */
  global_point: "gp",
  /** 日間ポイント */
  daily_point: "dp",
  /** 週間ポイント */
  weekly_point: "wp",
  /** 月間ポイント */
  monthly_point: "mp",
  /** 四半期ポイント */
  quarter_point: "qp",
  /** 年間ポイント */
  yearly_point: "yp",
  /** R18ブックマーク数 */
  fav_novel_cnt: "f",
  /** 感想数 */
  impression_cnt: "imp",
  /** レビュー数 */
  review_cnt: "r",
  /** 評価ポイント */
  all_point: "a",
  /** 評価者数 */
  all_hyoka_cnt: "ah",
  /** 挿絵の数 */
  sasie_cnt: "sa",
  /** 会話率 */
  kaiwaritu: "ka",
  /** 小説の更新日時 */
  novelupdated_at: "nu",
  /**
   * 最終更新日時
   * システム用で小説更新時とは関係ありません
   */
  updated_at: "ua"
};
var OptionalFields = {
  /**
   * 週間ユニークユーザ[項目名:weekly_unique]が追加されます。
   * 週間ユニークユーザは前週の日曜日から土曜日分のユニークの合計です。
   * 毎週火曜日早朝に更新されます。
   */
  weekly_unique: "weekly"
};
var UserFields = {
  /** ユーザID */
  userid: "u",
  /** ユーザ名 */
  name: "n",
  /** ユーザ名のフリガナ */
  yomikata: "y",
  /** ユーザ名のフリガナの頭文字 */
  name1st: "1",
  /** 小説投稿数 */
  novel_cnt: "nc",
  /** レビュー投稿数 */
  review_cnt: "rc",
  /** 小説累計文字数 */
  novel_length: "nl",
  /** 総合評価ポイントの合計 */
  sum_global_point: "sg"
};
var Order = {
  /** ブックマーク数の多い順 */
  FavoriteNovelCount: "favnovelcnt",
  /** レビュー数の多い順 */
  ReviewCount: "favnovelcnt",
  /** 総合ポイントの高い順 */
  HyokaDesc: "hyoka",
  /** 総合ポイントの低い順 */
  HyokaAsc: "hyokaasc",
  /** 感想の多い順 */
  ImpressionCount: "impressioncnt",
  /** 評価者数の多い順 */
  HyokaCountDesc: "hyokacnt",
  /** 評価者数の少ない順 */
  HyokaCountAsc: "hyokacntasc",
  /** 週間ユニークユーザの多い順 */
  Weekly: "weekly",
  /** 小説本文の文字数が多い順 */
  LengthDesc: "lengthdesc",
  /** 小説本文の文字数が少ない順 */
  LengthAsc: "lengthasc",
  /** Nコードが新しい順 */
  NCodeDesc: "ncodedesc",
  /** 新着更新順 */
  New: "new",
  /** 古い順 */
  Old: "old",
  /** 日間ポイントの高い順 */
  DailyPoint: "dailypoint",
  /** 週間ポイントの高い順 */
  WeeklyPoint: "weeklypoint",
  /** 月間ポイントの高い順 */
  MonthlyPoint: "monthlypoint",
  /** 四半期ポイントの高い順 */
  QuarterPoint: "quarterpoint",
  /** 年間ポイントの高い順 */
  YearlyPoint: "yearlypoint",
  /** 初回掲載順 */
  GeneralFirstUp: "generalfirstup"
};
var R18Site = {
  /** ノクターンノベルズ(男性向け) */
  Nocturne: 1,
  /** ムーンライトノベルズ(女性向け) */
  MoonLight: 2,
  /** ムーンライトノベルズ(BL) */
  MoonLightBL: 3,
  /** ミッドナイトノベルズ(大人向け) */
  Midnight: 4
};
var R18SiteNotation = {
  [R18Site.Nocturne]: "\u30CE\u30AF\u30BF\u30FC\u30F3\u30CE\u30D9\u30EB\u30BA(\u7537\u6027\u5411\u3051)",
  [R18Site.MoonLight]: "\u30E0\u30FC\u30F3\u30E9\u30A4\u30C8\u30CE\u30D9\u30EB\u30BA(\u5973\u6027\u5411\u3051)",
  [R18Site.MoonLightBL]: "\u30E0\u30FC\u30F3\u30E9\u30A4\u30C8\u30CE\u30D9\u30EB\u30BA(BL)",
  [R18Site.Midnight]: "\u30DF\u30C3\u30C9\u30CA\u30A4\u30C8\u30CE\u30D9\u30EB\u30BA(\u5927\u4EBA\u5411\u3051)"
};
var BigGenre = {
  /** 恋愛 */
  Renai: 1,
  /** ファンタジー */
  Fantasy: 2,
  /** 文芸 */
  Bungei: 3,
  /** SF */
  Sf: 4,
  /** その他 */
  Sonota: 99,
  /** ノンジャンル */
  NonGenre: 98
};
var BigGenreNotation = {
  [BigGenre.Renai]: "\u604B\u611B",
  [BigGenre.Fantasy]: "\u30D5\u30A1\u30F3\u30BF\u30B8\u30FC",
  [BigGenre.Bungei]: "\u6587\u82B8",
  [BigGenre.Sf]: "SF",
  [BigGenre.Sonota]: "\u305D\u306E\u4ED6",
  [BigGenre.NonGenre]: "\u30CE\u30F3\u30B8\u30E3\u30F3\u30EB"
};
var Genre = {
  /** 異世界〔恋愛〕*/
  RenaiIsekai: 101,
  /** 現実世界〔恋愛〕*/
  RenaiGenjitsusekai: 102,
  /** ハイファンタジー〔ファンタジー〕*/
  FantasyHigh: 201,
  /** ローファンタジー〔ファンタジー〕*/
  FantasyLow: 202,
  /** 純文学〔文芸〕*/
  BungeiJyunbungei: 301,
  /** ヒューマンドラマ〔文芸〕*/
  BungeiHumanDrama: 302,
  /** 歴史〔文芸〕*/
  BungeiHistory: 303,
  /** 推理〔文芸〕*/
  BungeiSuiri: 304,
  /** ホラー〔文芸〕*/
  BungeiHorror: 305,
  /** アクション〔文芸〕*/
  BungeiAction: 306,
  /** コメディー〔文芸〕*/
  BungeiComedy: 307,
  /** VRゲーム〔SF〕*/
  SfVrgame: 401,
  /** 宇宙〔SF〕*/
  SfSpace: 402,
  /** 空想科学〔SF〕*/
  SfKuusoukagaku: 403,
  /** パニック〔SF〕*/
  SfPanic: 404,
  /** 童話〔その他〕*/
  SonotaDouwa: 9901,
  /** 詩〔その他〕*/
  SonotaShi: 9902,
  /** エッセイ〔その他〕*/
  SonotaEssei: 9903,
  /** リプレイ〔その他〕*/
  SonotaReplay: 9904,
  /** その他〔その他〕 */
  SonotaSonota: 9999,
  /** ノンジャンル〔ノンジャンル〕*/
  NonGenre: 9801
};
var GenreNotation = {
  [Genre.RenaiIsekai]: "\u7570\u4E16\u754C\u3014\u604B\u611B\u3015",
  [Genre.RenaiGenjitsusekai]: "\u73FE\u5B9F\u4E16\u754C\u3014\u604B\u611B\u3015",
  [Genre.FantasyHigh]: "\u30CF\u30A4\u30D5\u30A1\u30F3\u30BF\u30B8\u30FC\u3014\u30D5\u30A1\u30F3\u30BF\u30B8\u30FC\u3015",
  [Genre.FantasyLow]: "\u30ED\u30FC\u30D5\u30A1\u30F3\u30BF\u30B8\u30FC\u3014\u30D5\u30A1\u30F3\u30BF\u30B8\u30FC\u3015",
  [Genre.BungeiJyunbungei]: "\u7D14\u6587\u5B66\u3014\u6587\u82B8\u3015",
  [Genre.BungeiHumanDrama]: "\u30D2\u30E5\u30FC\u30DE\u30F3\u30C9\u30E9\u30DE\u3014\u6587\u82B8\u3015",
  [Genre.BungeiHistory]: "\u6B74\u53F2\u3014\u6587\u82B8\u3015",
  [Genre.BungeiSuiri]: "\u63A8\u7406\u3014\u6587\u82B8\u3015",
  [Genre.BungeiHorror]: "\u30DB\u30E9\u30FC\u3014\u6587\u82B8\u3015",
  [Genre.BungeiAction]: "\u30A2\u30AF\u30B7\u30E7\u30F3\u3014\u6587\u82B8\u3015",
  [Genre.BungeiComedy]: "\u30B3\u30E1\u30C7\u30A3\u30FC\u3014\u6587\u82B8\u3015",
  [Genre.SfVrgame]: "VR\u30B2\u30FC\u30E0\u3014SF\u3015",
  [Genre.SfSpace]: "\u5B87\u5B99\u3014SF\u3015",
  [Genre.SfKuusoukagaku]: "\u7A7A\u60F3\u79D1\u5B66\u3014SF\u3015",
  [Genre.SfPanic]: "\u30D1\u30CB\u30C3\u30AF\u3014SF\u3015",
  [Genre.SonotaDouwa]: "\u7AE5\u8A71\u3014\u305D\u306E\u4ED6\u3015",
  [Genre.SonotaShi]: "\u8A69\u3014\u305D\u306E\u4ED6\u3015",
  [Genre.SonotaEssei]: "\u30A8\u30C3\u30BB\u30A4\u3014\u305D\u306E\u4ED6\u3015",
  [Genre.SonotaReplay]: "\u30EA\u30D7\u30EC\u30A4\u3014\u305D\u306E\u4ED6\u3015",
  [Genre.SonotaSonota]: "\u305D\u306E\u4ED6\u3014\u305D\u306E\u4ED6\u3015",
  [Genre.NonGenre]: "\u30CE\u30F3\u30B8\u30E3\u30F3\u30EB\u3014\u30CE\u30F3\u30B8\u30E3\u30F3\u30EB\u3015"
};
var BuntaiParam = {
  /** 字下げされておらず、連続改行が多い作品 */
  NoJisageKaigyouOoi: 1,
  /** 字下げされていないが、改行数は平均な作品 */
  NoJisageKaigyoHutsuu: 2,
  /** 字下げが適切だが、連続改行が多い作品 */
  JisageKaigyoOoi: 4,
  /** 字下げが適切でかつ改行数も平均な作品 */
  JisageKaigyoHutsuu: 6
};
var StopParam = {
  /** 長期連載停止中を除きます */
  NoStopping: 1,
  /** 長期連載停止中のみ取得します */
  Stopping: 2
};
var NovelTypeParam = {
  /** 短編 */
  Short: "t",
  /** 連載中 */
  RensaiNow: "r",
  /** 完結済連載小説 */
  RensaiEnd: "er",
  /** すべての連載小説(連載中および完結済) */
  Rensai: "re",
  /** 短編と完結済連載小説 */
  ShortAndRensai: "ter"
};
var DateParam = {
  ThisWeek: "thisweek",
  LastWeek: "lastweek",
  SevenDays: "sevenday",
  ThisMonth: "thismonth",
  LastMonth: "lastmonth"
};
var UserOrder = {
  /** ユーザIDの新しい順 */
  New: "new",
  /** 小説投稿数の多い順 */
  NovelCount: "novelcnt",
  /** レビュー投稿数の多い順 */
  ReviewCount: "reviewcnt",
  /** 小説累計文字数の多い順 */
  NovelLength: "novellength",
  /** 総合評価ポイントの合計の多い順 */
  SumGlobalPoint: "sumglobalpoint",
  /** ユーザIDの古い順 */
  Old: "old"
};

export {
  RankingType,
  BooleanNumber,
  Fields,
  R18Fields,
  OptionalFields,
  UserFields,
  Order,
  R18Site,
  R18SiteNotation,
  BigGenre,
  BigGenreNotation,
  Genre,
  GenreNotation,
  BuntaiParam,
  StopParam,
  NovelTypeParam,
  DateParam,
  UserOrder
};
//# sourceMappingURL=chunk-5UDKQCPJ.js.map