// src/util/unzipp.ts
import { gunzip } from "zlib";
import { promisify } from "util";
var gunzipAsync = promisify(gunzip);
var decoder = new TextDecoder();
async function unzipp(data) {
  try {
    const buffer = await gunzipAsync(data);
    try {
      return JSON.parse(decoder.decode(buffer));
    } catch {
      throw decoder.decode(buffer);
    }
  } catch (e) {
    if (typeof e === "string") throw e;
    throw decoder.decode(data);
  }
}

export {
  unzipp
};
//# sourceMappingURL=chunk-VUZIISP2.js.map