declare global {
    interface Window {
        [key: CallbackId]: (data: any) => void;
    }
}
/**
 * JSONP呼び出しのオプション設定
 */
type JsonpOption = {
    /**
     * コールバック関数名のプレフィックス
     * @default "__jp"
     */
    prefix?: string;
    /**
     * コールバック関数名を指定するURLパラメータ名
     * @default "callback"
     */
    param?: string;
    /**
     * タイムアウト時間（ミリ秒）
     * @default 15000
     */
    timeout?: number;
};
/**
 * JSONPリクエストを実行してデータを取得します。
 *
 * @param url - リクエスト先のURL
 * @param options - JSONP呼び出しのオプション設定
 * @returns JSONPリクエストの結果をPromiseで返します
 * @throws {Error} タイムアウトが発生した場合、"Timeout"メッセージのエラーをスローします
 *
 * @example
 * ```typescript
 * // 基本的な使用方法
 * const data = await jsonp<ResponseType>('https://example.com/api');
 *
 * // オプション指定
 * const data = await jsonp<ResponseType>('https://example.com/api', {
 *   prefix: 'customPrefix',
 *   param: 'callbackParam',
 *   timeout: 10000
 * });
 * ```
 */
declare function jsonp<T>(url: string, { prefix, param, timeout }?: JsonpOption): Promise<T>;

export { type JsonpOption, jsonp };
