import { RequestDetail } from '../common';
import { PluginInstance } from './module/common';

export interface RequestCenterInitOptions {
    port: number;
    serverPort: number;
    autoOpenDevtool?: boolean;
    requests?: Record<string, RequestDetail>;
}
/**
 * @param data message data
 * @param id? message id, Only for devtool message
 * @param request? request detail
 */
export interface DevtoolMessageListener<T = any> {
    (props: {
        data: T;
        request?: RequestDetail;
        id?: string;
    }): void;
}
export declare class RequestCenter {
    #private;
    private devtool;
    private server;
    private listeners;
    private options;
    constructor(options: RequestCenterInitOptions);
    loadPlugins(plugins: PluginInstance<any>[]): void;
    usePlugin<T = null>(id: string): T;
    on(method: string, listener: DevtoolMessageListener): () => void;
    close(): void;
    private initServer;
}
//# sourceMappingURL=request-center.d.ts.map