var _curry2 = /*#__PURE__*/require("./internal/_curry2.js");
var _assertPromise = /*#__PURE__*/require("./internal/_assertPromise.js");
/**
 * Returns the result of applying the onSuccess function to the value inside
 * a successfully resolved promise. This is useful for working with promises
 * inside function compositions.
 *
 * @func
 * @memberOf R
 * @since v0.27.1
 * @category Function
 * @sig (a -> b) -> (Promise e a) -> (Promise e b)
 * @sig (a -> (Promise e b)) -> (Promise e a) -> (Promise e b)
 * @param {Function} onSuccess The function to apply. Can return a value or a promise of a value.
 * @param {Promise} p
 * @return {Promise} The result of calling `p.then(onSuccess)`
 * @see R.otherwise, R.pipeWith
 * @example
 *
 *      const makeQuery = email => ({ query: { email }});
 *      const fetchMember = request =>
 *        Promise.resolve({ firstName: 'Bob', lastName: 'Loblaw', id: 42 });
 *      const pickName = R.pick(['firstName', 'lastName'])
 *
 *      //getMemberName :: String -> Promise ({ firstName, lastName })
 *      const getMemberName = R.pipe(
 *        makeQuery,
 *        fetchMember,
 *        R.andThen(pickName),
 *      );
 *
 *      // Alternately
 *      const getMemberName = R.pipe(
 *        makeQuery,
 *        fetchMember,
 *      )
 *
 *      R.pipeWith(R.andThen, [getMemberName, pickName])('bob@gmail.com').then(console.log)
 *      // logs {"firstName":"Bob","lastName":"Loblaw"}
 *
 *      getMemberName('bob@gmail.com').then(console.log);
 */
var andThen = /*#__PURE__*/_curry2(function andThen(f, p) {
  _assertPromise('andThen', p);
  return p.then(f);
});
module.exports = andThen;