#!/usr/bin/env node
"use strict"; function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }var _arg = require('arg'); var _arg2 = _interopRequireDefault(_arg);
var _chalk = require('chalk'); var _chalk2 = _interopRequireDefault(_chalk);
var _clipboardy = require('clipboardy'); var _clipboardy2 = _interopRequireDefault(_clipboardy);
const { red, grey, blue } = _chalk2.default;
var _packagejson = require('../package.json'); var _packagejson2 = _interopRequireDefault(_packagejson);
var _indexjs = require('./index.js'); var _indexjs2 = _interopRequireDefault(_indexjs);
var _helpjs = require('./help.js');
const { _, ...args } = _arg2.default.call(void 0, {
  "--version": Boolean,
  "--help": Boolean,
  "--no-copy": Boolean,
  "--special": [String],
  "-v": "--version",
  "-h": "--help",
  "-n": "--no-copy",
  "-s": "--special"
});
if (args["--version"]) {
  console.log(_packagejson2.default.version);
  process.exit(0);
}
if (args["--help"]) {
  console.log(_helpjs.help);
  process.exit(0);
}
const main = async () => {
  const sub = _.join(" ");
  if (!sub) {
    console.error(`${red("Error!")} Please specify an input: ${grey('title "input"')}`);
    process.exit(1);
  }
  const special = args["--special"];
  const output = _indexjs2.default.call(void 0, sub, { special });
  const copy = !args["--no-copy"];
  if (copy) {
    try {
      await _clipboardy2.default.write(output);
    } catch (err) {
      console.error(`${red("Error!")} Could not write to clipboard`);
      process.exit(1);
    }
  }
  console.log(`${output}${copy ? " " + blue("[copied]") : ""}`);
};
main();
