"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.objectToPascal = exports.toPascal = exports.objectToSnake = exports.toSnake = exports.objectToCamel = exports.toCamel = void 0;
function convertObject(obj, keyConverter) {
    if (obj === null || typeof obj === 'undefined' || typeof obj !== 'object') {
        return obj;
    }
    const out = (Array.isArray(obj) ? [] : {});
    for (const [k, v] of Object.entries(obj)) {
        // eslint-disable-next-line
        // @ts-ignore
        // eslint-disable-next-line @typescript-eslint/no-unsafe-assignment
        out[keyConverter(k)] = Array.isArray(v)
            ? v.map((item) => typeof item === 'object' &&
                !(item instanceof Uint8Array) &&
                !(item instanceof Date)
                ? convertObject(item, keyConverter)
                : item)
            : v instanceof Uint8Array || v instanceof Date
                ? v
                : typeof v === 'object'
                    ? convertObject(v, keyConverter)
                    : v;
    }
    return out;
}
function toCamel(term) {
    return (term.length === 1
        ? term.toLowerCase()
        : term
            .replace(/^([A-Z])/, (m) => m[0].toLowerCase())
            .replace(/[_-]([a-z0-9])/g, (m) => m[1].toUpperCase()));
}
exports.toCamel = toCamel;
function objectToCamel(obj) {
    return convertObject(obj, toCamel);
}
exports.objectToCamel = objectToCamel;
function toSnake(term) {
    var _a, _b;
    let result = term;
    let circuitBreaker = 0;
    while ((((_a = /([a-z])([0-9])/.exec(result)) === null || _a === void 0 ? void 0 : _a.length) || 0) > 2 &&
        circuitBreaker < 10) {
        result = result.replace(/([a-z])([0-9])/, (_all, $1, $2) => `${$1.toLowerCase()}_${$2.toLowerCase()}`);
        circuitBreaker += 1;
    }
    while ((((_b = /(.+?)([A-Z])/.exec(result)) === null || _b === void 0 ? void 0 : _b.length) || 0) > 2 &&
        circuitBreaker < 10) {
        result = result.replace(/(.+?)([A-Z])/, (_all, $1, $2) => `${$1.toLowerCase()}_${$2.toLowerCase()}`);
        circuitBreaker += 1;
    }
    return result.toLowerCase();
}
exports.toSnake = toSnake;
function objectToSnake(obj) {
    return convertObject(obj, toSnake);
}
exports.objectToSnake = objectToSnake;
function toPascal(term) {
    return toCamel(term).replace(/^([a-z])/, (m) => m[0].toUpperCase());
}
exports.toPascal = toPascal;
function objectToPascal(obj) {
    return convertObject(obj, toPascal);
}
exports.objectToPascal = objectToPascal;
//# sourceMappingURL=data:application/json;base64,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