import { Feed } from './index.js';
import { InnertubeError } from '../../utils/Utils.js';
import Tab from '../../parser/classes/Tab.js';
export default class TabbedFeed extends Feed {
    #actions;
    #tabs;
    constructor(actions, data, already_parsed = false) {
        super(actions, data, already_parsed);
        this.#actions = actions;
        this.#tabs = this.page.contents_memo?.getType(Tab);
    }
    get tabs() {
        return this.#tabs?.map((tab) => tab.title.toString()) ?? [];
    }
    async getTabByName(title) {
        const tab = this.#tabs?.find((tab) => tab.title.toLowerCase() === title.toLowerCase());
        if (!tab)
            throw new InnertubeError(`Tab "${title}" not found`);
        if (tab.selected)
            return this;
        const response = await tab.endpoint.call(this.#actions);
        return new TabbedFeed(this.#actions, response, false);
    }
    async getTabByURL(url) {
        const tab = this.#tabs?.find((tab) => tab.endpoint.metadata.url?.split('/').pop() === url);
        if (!tab)
            throw new InnertubeError(`Tab "${url}" not found`);
        if (tab.selected)
            return this;
        const response = await tab.endpoint.call(this.#actions);
        return new TabbedFeed(this.#actions, response, false);
    }
    hasTabWithURL(url) {
        return this.#tabs?.some((tab) => tab.endpoint.metadata.url?.split('/').pop() === url) ?? false;
    }
    get title() {
        return this.page.contents_memo?.getType(Tab)?.find((tab) => tab.selected)?.title.toString();
    }
}
//# sourceMappingURL=TabbedFeed.js.map