import { type ObservedArray, YTNode } from '../helpers.js';
import { type RawNode } from '../index.js';
import Author from './misc/Author.js';
import Text from './misc/Text.js';
import Thumbnail from './misc/Thumbnail.js';
import NavigationEndpoint from './NavigationEndpoint.js';
export default class EndScreenVideo extends YTNode {
    static type: string;
    id: string;
    title: Text;
    thumbnails: Thumbnail[];
    thumbnail_overlays: ObservedArray<YTNode>;
    author: Author;
    endpoint: NavigationEndpoint;
    short_view_count: Text;
    badges: ObservedArray<YTNode>;
    duration: {
        text: string;
        seconds: number;
    };
    constructor(data: RawNode);
}
