import Button from './Button.js';
import MetadataBadge from './MetadataBadge.js';
import SubscribeButton from './SubscribeButton.js';
import Text from './misc/Text.js';
import Thumbnail from './misc/Thumbnail.js';
import { YTNode } from '../helpers.js';
import { Parser } from '../index.js';
export default class InteractiveTabbedHeader extends YTNode {
    static type = 'InteractiveTabbedHeader';
    header_type;
    title;
    description;
    metadata;
    badges;
    box_art;
    banner;
    buttons;
    auto_generated;
    constructor(data) {
        super();
        this.header_type = data.type;
        this.title = new Text(data.title);
        this.description = new Text(data.description);
        this.metadata = new Text(data.metadata);
        this.badges = Parser.parseArray(data.badges, MetadataBadge);
        this.box_art = Thumbnail.fromResponse(data.boxArt);
        this.banner = Thumbnail.fromResponse(data.banner);
        this.buttons = Parser.parseArray(data.buttons, [SubscribeButton, Button]);
        this.auto_generated = new Text(data.autoGenerated);
    }
}
//# sourceMappingURL=InteractiveTabbedHeader.js.map