import { SocialPost, Activity, Action } from '@rss3/api-core';

type Content = {
    authorUrl?: string;
    handle?: string;
    address?: string;
    profileId?: string | number | null;
    title?: string;
    body?: string;
    media?: SocialPost["media"];
};
type PostContent = Content & {
    target?: Content;
};
declare function formatContent(activity: Activity): PostContent | undefined;
declare function extractContent(activity: Activity, action: Action): PostContent | undefined;
/**
 * The special case for lens post, which will use the first sentence of the body as the title
 */
declare function formatTitle(title?: string, body?: string): string | undefined;
declare function checkTargetExist(target?: Pick<Content, "body" | "media" | "title">): boolean;

export { type Content, type PostContent, checkTargetExist, extractContent, formatContent, formatTitle };
