import { createRule, docsUrl } from '../utils/index.js';
import first from './first.js';
export default createRule({
    ...first,
    name: 'imports-first',
    meta: {
        ...first.meta,
        deprecated: {
            message: 'Replaced by `import-x/first`.',
            url: 'https://github.com/import-js/eslint-plugin-import/blob/main/CHANGELOG.md#changed-24',
            deprecatedSince: '2.0.0',
            replacedBy: [
                {
                    message: 'Replaced by `import-x/first`.',
                    rule: { name: 'first', url: docsUrl('first') },
                },
            ],
        },
        docs: {
            category: 'Style guide',
            description: 'Replaced by `import-x/first`.',
        },
    },
});
//# sourceMappingURL=imports-first.js.map