export interface CDPCallFrame {
    columnNumber: number;
    functionName: string;
    lineNumber: number;
    url: string;
    scriptId?: string;
}
export declare class RequestDetail {
    id: string;
    constructor(req?: RequestDetail);
    loadCallFrames(_stack?: string): void;
    isHiden(): boolean;
    isWebSocket(): boolean;
    url?: string;
    method?: string;
    cookies: any;
    requestHeaders: any;
    requestData: any;
    responseData: any;
    responseStatusCode?: number;
    responseHeaders: any;
    responseInfo: Partial<{
        encodedDataLength: number;
        dataLength: number;
    }>;
    requestStartTime?: number;
    requestEndTime?: number;
    initiator?: {
        type: string;
        stack: {
            callFrames: CDPCallFrame[];
        };
    };
}
export declare const PORT: number;
export declare const SERVER_PORT: number;
export declare const REMOTE_DEBUGGER_PORT: number;
export declare const IS_DEV_MODE: boolean;
export declare const READY_MESSAGE = "ready";
export declare const __filename: string;
export declare const __dirname: string;
export interface RegisterOptions {
    /**
     * @description Main Process Port
     * @default 5270
     */
    port?: number;
    /**
     * @description CDP Server Port, used for Devtool
     * @link devtools://devtools/bundled/inspector.html?ws=localhost:${serverPort}
     * @default 5271
     */
    serverPort?: number;
    /**
     * @description Whether to automatically open Devtool
     * @default true
     */
    autoOpenDevtool?: boolean;
    /**
     * @description The option to intercept a certain packet.
     *   If set false, the packet will not be intercepted.
     */
    intercept?: {
        /**
         * @default true
         */
        fetch?: boolean;
        /**
         * @default true
         */
        normal?: boolean;
        /**
         * @default false
         */
        undici?: false | {
            fetch?: false | {};
            normal?: false | {};
        };
    };
}
//# sourceMappingURL=common.d.ts.map