import { default as zlib } from 'node:zlib';

declare const kPerMessageDeflate: unique symbol;
declare const kTotalLength: unique symbol;
declare const kCallback: unique symbol;
declare const kBuffers: unique symbol;
/**
 * Options interface for PerMessageDeflate constructor.
 */
interface PerMessageDeflateOptions {
    clientMaxWindowBits?: boolean | number;
    clientNoContextTakeover?: boolean;
    concurrencyLimit?: number;
    serverMaxWindowBits?: boolean | number;
    serverNoContextTakeover?: boolean;
    threshold?: number;
    zlibDeflateOptions?: zlib.ZlibOptions;
    zlibInflateOptions?: zlib.ZlibOptions;
}
/**
 * permessage-deflate implementation.
 */
export declare class PerMessageDeflate {
    private _maxPayload;
    private _options;
    private _threshold;
    private _isServer;
    private _deflate;
    private _inflate;
    params: Record<string, any> | null;
    [kCallback]?: (err: Error | null, result?: Buffer | null) => void;
    [kPerMessageDeflate]?: PerMessageDeflate;
    [kTotalLength]?: number;
    [kBuffers]?: Buffer[];
    constructor(options?: PerMessageDeflateOptions, isServer?: boolean, maxPayload?: number);
    static get extensionName(): string;
    offer(): Record<string, any>;
    accept(configurations: Record<string, any>[]): Record<string, any>;
    cleanup(): void;
    private acceptAsServer;
    private acceptAsClient;
    private normalizeParams;
    decompress(data: Buffer, fin: boolean, callback: (err: Error | null, result?: Buffer | null) => void): void;
    compress(data: Buffer | string, fin: boolean, callback: (err: Error | null, result?: Buffer | null) => void): void;
    private _decompress;
    private _compress;
}
export default PerMessageDeflate;
//# sourceMappingURL=permessage-deflate.d.ts.map