export default {
  "81": {
    "routes": {
      "/81rc/:category{.+}?": {
        "path": "/81rc/:category{.+}?",
        "name": "中国人民解放军专业技术人才网",
        "url": "81rc.81.cn",
        "maintainers": [
          "nczitzk"
        ],
        "example": "/81/81rc/sy/gzdt_210283",
        "parameters": {
          "category": "分类，默认为 `sy/gzdt_210283`，即工作动态，可在对应分类页 URL 中找到"
        },
        "description": "::: tip\n  若订阅 [工作动态](https://81rc.81.cn/sy/gzdt_210283)，网址为 `https://81rc.81.cn/sy/gzdt_210283`。截取 `https://81rc.81.cn/` 到末尾的部分 `sy/gzdt_210283` 作为参数填入，此时路由为 [`/81/81rc/sy/gzdt_210283`](https://rsshub.app/81/81rc/sy/gzdt_210283)。\n:::\n  ",
        "categories": [
          "government"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "81rc.81.cn/:category"
            ]
          }
        ],
        "location": "81rc/index.ts",
        "module": () => import('@/routes/81/81rc/index.ts')
      }
    },
    "name": "中国军网",
    "apiRoutes": {},
    "url": "81.cn",
    "categories": [
      "government"
    ],
    "description": "",
    "lang": "zh-CN"
  },
  "121": {
    "routes": {
      "/weatherLive": {
        "path": "/weatherLive",
        "name": "深圳天气直播",
        "url": "tf.121.com.cn",
        "maintainers": [
          "nczitzk"
        ],
        "example": "/121/weatherLive",
        "categories": [
          "forecast"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "tf.121.com.cn",
              "tf.121.com.cn/web/weatherLive"
            ],
            "target": "/weatherLive"
          }
        ],
        "view": 5,
        "location": "weather-live.tsx",
        "module": () => import('@/routes/121/weather-live.tsx')
      }
    },
    "name": "深圳台风网",
    "url": "121.com.cn",
    "categories": [
      "forecast"
    ],
    "description": "",
    "lang": "zh-CN"
  },
  "163": {
    "routes": {
      "/ds/:id": {
        "path": "/ds/:id",
        "categories": [
          "game"
        ],
        "example": "/163/ds/63dfbaf4117741daaf73404601165843",
        "parameters": {
          "id": "用户ID"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "ds.163.com/user/:id"
            ]
          }
        ],
        "name": "用户发帖",
        "maintainers": [
          "luyuhuang"
        ],
        "location": "ds.tsx",
        "module": () => import('@/routes/163/ds.tsx')
      },
      "/dy/:id": {
        "path": "/dy/:id",
        "categories": [
          "new-media"
        ],
        "example": "/163/dy/W4983108759592548559",
        "parameters": {
          "id": "网易号 ID"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "更新",
        "maintainers": [
          "HendricksZheng"
        ],
        "description": "1.  在[网易号搜索页面](https://dy.163.com/v2/media/tosearch.html) 搜索想要订阅的网易号。\n  2.  打开网易号的任意文章。\n  3.  查看源代码，搜索 `data-wemediaid`，查看紧随其后的引号内的属性值（类似 `W1966190042455428950`）即为网易号 ID。",
        "location": "dy.ts",
        "module": () => import('@/routes/163/dy.ts')
      },
      "/dy2/:id": {
        "path": "/dy2/:id",
        "categories": [
          "new-media"
        ],
        "example": "/163/dy2/T1555591616739",
        "parameters": {
          "id": "id，该网易号主页网址最后一项 html 的文件名"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "网易号（通用）",
        "maintainers": [
          "mjysci",
          "lyqluis"
        ],
        "description": "优先使用方法一，若是网易号搜索页面搜不到的小众网易号（文章页面不含`data-wemediaid`）则可使用此法。\n触发反爬会只抓取到标题，建议自建。",
        "location": "dy2.ts",
        "module": () => import('@/routes/163/dy2.ts')
      },
      "/exclusive/:id?": {
        "path": "/exclusive/:id?",
        "categories": [
          "new-media"
        ],
        "example": "/163/exclusive/qsyk",
        "parameters": {
          "id": "栏目, 默认为首页"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "3g.163.com/touch/exclusive/sub/:id"
            ]
          }
        ],
        "name": "栏目",
        "maintainers": [
          "nczitzk"
        ],
        "description": "| 分类     | 编号 |\n| -------- | ---- |\n| 首页     |      |\n| 轻松一刻 | qsyk |\n| 槽值     | cz   |\n| 人间     | rj   |\n| 大国小民 | dgxm |\n| 三三有梗 | ssyg |\n| 数读     | sd   |\n| 看客     | kk   |\n| 下划线   | xhx  |\n| 谈心社   | txs  |\n| 哒哒     | dd   |\n| 胖编怪聊 | pbgl |\n| 曲一刀   | qyd  |\n| 今日之声 | jrzs |\n| 浪潮     | lc   |\n| 沸点     | fd   |",
        "location": "exclusive.ts",
        "module": () => import('@/routes/163/exclusive.ts')
      },
      "/music/artist/songs/:id": {
        "path": "/music/artist/songs/:id",
        "categories": [
          "multimedia"
        ],
        "example": "/163/music/artist/songs/2116",
        "parameters": {
          "id": "歌手 id, 可在歌手详情页 URL 中找到"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "歌手歌曲",
        "maintainers": [
          "ZhongMingKun"
        ],
        "location": "music/artist-songs.ts",
        "module": () => import('@/routes/163/music/artist-songs.ts')
      },
      "/music/artist/:id": {
        "path": "/music/artist/:id",
        "categories": [
          "multimedia"
        ],
        "example": "/163/music/artist/2116",
        "parameters": {
          "id": "歌手 id, 可在歌手详情页 URL 中找到"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "歌手专辑",
        "maintainers": [
          "metowolf"
        ],
        "location": "music/artist.ts",
        "module": () => import('@/routes/163/music/artist.ts')
      },
      "/music/djradio/:id/:info?": {
        "path": "/music/djradio/:id/:info?",
        "categories": [
          "multimedia"
        ],
        "example": "/163/music/djradio/347317067",
        "parameters": {
          "id": "节目 id, 可在电台节目页 URL 中找到",
          "info": "默认在正文尾部显示节目相关信息，任意值为不显示"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": true,
          "supportScihub": false
        },
        "name": "电台节目",
        "maintainers": [
          "magic-akari"
        ],
        "location": "music/djradio.tsx",
        "module": () => import('@/routes/163/music/djradio.tsx')
      },
      "/music/playlist/:id": {
        "path": "/music/playlist/:id",
        "categories": [
          "multimedia"
        ],
        "example": "/163/music/playlist/35798529",
        "parameters": {
          "id": "歌单 id, 可在歌单页 URL 中找到"
        },
        "features": {
          "requireConfig": [
            {
              "name": "NCM_COOKIES",
              "optional": true,
              "description": "网易云音乐登陆后的 cookie 值，可在浏览器控制台通过`document.cookie`获取。"
            }
          ],
          "requirePuppeteer": false,
          "antiCrawler": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "歌单歌曲",
        "maintainers": [
          "DIYgod"
        ],
        "location": "music/playlist.ts",
        "module": () => import('@/routes/163/music/playlist.ts')
      },
      "/music/user/events/:id": {
        "path": "/music/user/events/:id",
        "categories": [
          "multimedia"
        ],
        "name": "用户动态",
        "maintainers": [
          "Master-Hash"
        ],
        "location": "music/userevents.tsx",
        "module": () => import('@/routes/163/music/userevents.tsx')
      },
      "/music/user/playlist/:uid": {
        "path": "/music/user/playlist/:uid",
        "categories": [
          "multimedia"
        ],
        "example": "/163/music/user/playlist/45441555",
        "parameters": {
          "uid": "用户 uid, 可在用户主页 URL 中找到"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "用户歌单",
        "maintainers": [
          "DIYgod"
        ],
        "location": "music/userplaylist.tsx",
        "module": () => import('@/routes/163/music/userplaylist.tsx')
      },
      "/music/user/playrecords/:uid/:type?": {
        "path": "/music/user/playrecords/:uid/:type?",
        "categories": [
          "multimedia"
        ],
        "example": "/163/music/user/playrecords/45441555/1",
        "parameters": {
          "uid": "用户 uid, 可在用户主页 URL 中找到",
          "type": "排行榜类型，0所有时间(默认)，1最近一周"
        },
        "features": {
          "requireConfig": [
            {
              "name": "NCM_COOKIES",
              "optional": true,
              "description": "网易云音乐登陆后的 cookie 值，可在浏览器控制台通过`document.cookie`获取。"
            }
          ],
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "用户听歌排行",
        "maintainers": [
          "alfredcai"
        ],
        "location": "music/userplayrecords.tsx",
        "module": () => import('@/routes/163/music/userplayrecords.tsx')
      },
      "/news/rank/:category?/:type?/:time?": {
        "path": "/news/rank/:category?/:type?/:time?",
        "categories": [
          "new-media"
        ],
        "example": "/163/news/rank/whole/click/day",
        "parameters": {
          "category": "新闻分类，参见下表，默认为“全站”",
          "type": "排行榜类型，“点击榜”对应`click`，“跟贴榜”对应`follow`，默认为“点击榜”",
          "time": "统计时间，“1小时”对应`hour`，“24小时”对应`day`，“本周”对应`week`，“本月”对应`month`，默认为“24小时”"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "排行榜",
        "maintainers": [
          "nczitzk"
        ],
        "description": "::: tip\n  全站新闻 **点击榜** 的统计时间仅包含 “24 小时”、“本周”、“本月”，不包含 “1 小时”。即可用的`time`参数为`day`、`week`、`month`。\n\n  其他分类 **点击榜** 的统计时间仅包含 “1 小时”、“24 小时”、“本周”。即可用的`time`参数为`hour`、`day`、`week`。\n\n  而所有分类（包括全站）的 **跟贴榜** 的统计时间皆仅包含 “24 小时”、“本周”、“本月”。即可用的`time`参数为`day`、`week`、`month`。\n:::\n\n  新闻分类：\n\n| 全站  | 新闻 | 娱乐          | 体育   | 财经  | 科技 | 汽车 | 女人 | 房产  | 游戏 | 旅游   | 教育 |\n| ----- | ---- | ------------- | ------ | ----- | ---- | ---- | ---- | ----- | ---- | ------ | ---- |\n| whole | news | entertainment | sports | money | tech | auto | lady | house | game | travel | edu  |",
        "location": "news/rank.ts",
        "module": () => import('@/routes/163/news/rank.ts')
      },
      "/news/special/:type?": {
        "path": "/news/special/:type?",
        "categories": [
          "new-media"
        ],
        "example": "/163/news/special/1",
        "parameters": {
          "type": "栏目"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "专栏",
        "maintainers": [
          "nczitzk"
        ],
        "description": "| 轻松一刻 | 槽值 | 人间 | 大国小民 | 三三有梗 | 数读 | 看客 | 下划线 | 谈心社 | 哒哒 | 胖编怪聊 | 曲一刀 | 今日之声 | 浪潮 | 沸点 |\n| -------- | ---- | ---- | -------- | -------- | ---- | ---- | ------ | ------ | ---- | -------- | ------ | -------- | ---- | ---- |\n| 1        | 2    | 3    | 4        | 5        | 6    | 7    | 8      | 9      | 10   | 11       | 12     | 13       | 14   | 15   |",
        "location": "news/special.ts",
        "module": () => import('@/routes/163/news/special.ts')
      },
      "/open/vip": {
        "path": "/open/vip",
        "categories": [
          "study"
        ],
        "example": "/163/open/vip",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "vip.open.163.com/"
            ]
          }
        ],
        "name": "精品课程",
        "maintainers": [
          "hoilc"
        ],
        "url": "vip.open.163.com/",
        "location": "open/vip.tsx",
        "module": () => import('@/routes/163/open/vip.tsx')
      },
      "/renjian/:category?": {
        "path": "/renjian/:category?",
        "categories": [
          "new-media"
        ],
        "example": "/163/renjian/texie",
        "parameters": {
          "category": "分类，见下表，默认为特写"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "renjian.163.com/:category",
              "renjian.163.com/"
            ]
          }
        ],
        "name": "人间",
        "maintainers": [
          "nczitzk"
        ],
        "description": "| 特写  | 记事  | 大写  | 好读  | 看客  |\n| ----- | ----- | ----- | ----- | ----- |\n| texie | jishi | daxie | haodu | kanke |",
        "location": "renjian.ts",
        "module": () => import('@/routes/163/renjian.ts')
      },
      "/today/:need_content?": {
        "path": "/today/:need_content?",
        "categories": [
          "new-media"
        ],
        "example": "/163/today",
        "parameters": {
          "need_content": "需要获取全文，填写 true/yes 表示需要，默认需要"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "wp.m.163.com/163/html/newsapp/todayFocus/index.html",
              "wp.m.163.com/"
            ],
            "target": "/today"
          }
        ],
        "name": "今日关注",
        "maintainers": [
          "nczitzk"
        ],
        "url": "wp.m.163.com/163/html/newsapp/todayFocus/index.html",
        "description": "::: tip\n  参数 **需要获取全文** 设置为 `true` `yes` `t` `y` 等值后，RSS 会携带该新闻条目的对应全文。\n:::",
        "location": "today.ts",
        "module": () => import('@/routes/163/today.ts')
      }
    },
    "name": "网易公开课",
    "apiRoutes": {},
    "url": "163.com",
    "description": "::: tip\n部分歌单及听歌排行信息为登陆后可见，自建时将环境变量`NCM_COOKIES`设为登陆后的 Cookie 值，即可正常获取。\n:::",
    "lang": "zh-CN"
  },
  "591": {
    "routes": {
      "/:country/rent/:query?": {
        "path": "/:country/rent/:query?",
        "categories": [
          "other"
        ],
        "example": "/591/tw/rent/order=posttime&orderType=desc",
        "parameters": {
          "country": "Country code. Only tw is supported now",
          "query": "Query Parameters"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "Rental house",
        "maintainers": [
          "Yukaii"
        ],
        "description": "::: tip\n  Copy the URL of the 591 filter housing page and remove the front part `https://rent.591.com.tw/?`, you will get the query parameters.\n:::",
        "location": "list.tsx",
        "module": () => import('@/routes/591/list.tsx')
      }
    },
    "name": "591 Rental house",
    "apiRoutes": {},
    "url": "rent.591.com.tw",
    "lang": "zh-TW"
  },
  "2048": {
    "routes": {
      "/:id?": {
        "path": "/:id?",
        "categories": [
          "multimedia"
        ],
        "example": "/2048/2",
        "parameters": {
          "id": "板块 ID, 见下表，默认为最新合集，即 `3`，亦可在 URL 中找到, 例如, `thread.php?fid-3.html`中, 板块 ID 为`3`"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": true,
          "supportPodcast": false,
          "supportScihub": false,
          "nsfw": true
        },
        "name": "论坛",
        "maintainers": [
          "nczitzk"
        ],
        "description": "| 最新合集 | 亞洲無碼 | 日本騎兵 | 歐美新片 | 國內原創 | 中字原創 | 三級寫真 |\n| -------- | -------- | -------- | -------- | -------- | -------- | -------- |\n| 3        | 4        | 5        | 13       | 15       | 16       | 18       |\n\n| 有碼.HD | 亞洲 SM.HD | 日韓 VR/3D | 歐美 VR/3D | S-cute / Mywife / G-area |\n| ------- | ---------- | ---------- | ---------- | ------------------------ |\n| 116     | 114        | 96         | 97         | 119                      |\n\n| 網友自拍 | 亞洲激情 | 歐美激情 | 露出偷窺 | 高跟絲襪 | 卡通漫畫 | 原創达人 |\n| -------- | -------- | -------- | -------- | -------- | -------- | -------- |\n| 23       | 24       | 25       | 26       | 27       | 28       | 135      |\n\n| 唯美清純 | 网络正妹 | 亞洲正妹 | 素人正妹 | COSPLAY | 女优情报 | Gif 动图 |\n| -------- | -------- | -------- | -------- | ------- | -------- | -------- |\n| 21       | 274      | 276      | 277      | 278     | 29       |          |\n\n| 獨家拍攝 | 稀有首發 | 网络见闻 | 主播實錄 | 珍稀套圖 | 名站同步 | 实用漫画 |\n| -------- | -------- | -------- | -------- | -------- | -------- | -------- |\n| 213      | 94       | 283      | 111      | 88       | 131      | 180      |\n\n| 网盘二区 | 网盘三区 | 分享福利 | 国产精选 | 高清福利 | 高清首发 | 多挂原创 |\n| -------- | -------- | -------- | -------- | -------- | -------- | -------- |\n| 72       | 272      | 195      | 280      | 79       | 216      | 76       |\n\n| 磁链迅雷 | 正片大片 | H-GAME | 有声小说 | 在线视频 | 在线快播影院 |\n| -------- | -------- | ------ | -------- | -------- | ------------ |\n| 43       | 67       | 66     | 55       | 78       | 279          |\n\n| 综合小说 | 人妻意淫 | 乱伦迷情 | 长篇连载 | 文学作者 | TXT 小说打包 |\n| -------- | -------- | -------- | -------- | -------- | ------------ |\n| 48       | 103      | 50       | 54       | 100      | 109          |\n\n| 聚友客栈 | 坛友自售 |\n| -------- | -------- |\n| 57       | 136      |",
        "location": "index.tsx",
        "module": () => import('@/routes/2048/index.tsx')
      }
    },
    "name": "2048 核基地",
    "apiRoutes": {},
    "url": "hjd2048.com",
    "lang": "zh-CN"
  },
  "8264": {
    "routes": {
      "/list/:id?": {
        "path": "/list/:id?",
        "categories": [
          "bbs"
        ],
        "example": "/8264/list/751",
        "parameters": {
          "id": "列表 id，见下表，默认为 751，即热门推荐"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "列表",
        "maintainers": [
          "nczitzk"
        ],
        "description": "| 热门推荐 | 户外知识 | 户外装备 |\n| -------- | -------- | -------- |\n| 751      | 238      | 204      |\n\n<details>\n<summary>更多列表</summary>\n\n#### 热门推荐\n\n| 业界 | 国际 | 专访 | 图说 | 户外 | 登山 | 攀岩 |\n| ---- | ---- | ---- | ---- | ---- | ---- | ---- |\n| 489  | 733  | 746  | 902  | 914  | 934  | 935  |\n\n#### 户外知识\n\n| 徒步 | 露营 | 安全急救 | 领队 | 登雪山 |\n| ---- | ---- | -------- | ---- | ------ |\n| 242  | 950  | 931    | 920  | 915  |\n\n| 攀岩 | 骑行 | 跑步 | 滑雪 | 水上运动 |\n| ---- | ---- | ---- | ---- | -------- |\n| 916  | 917  | 918  | 919  | 921    |\n\n| 钓鱼 | 潜水 | 攀冰 | 冲浪 | 网球 |\n| ---- | ---- | ---- | ---- | ---- |\n| 951  | 952  | 953  | 966  | 967  |\n\n| 绳索知识 | 高尔夫 | 马术 | 户外摄影 | 羽毛球 |\n| -------- | ------ | ---- | -------- | ------ |\n| 968    | 969  | 970  | 973    | 971  |\n\n| 游泳 | 溯溪 | 健身 | 瑜伽 |\n| ---- | ---- | ---- | ---- |\n| 974  | 975  | 976  | 977  |\n\n#### 户外装备\n\n| 服装 | 冲锋衣 | 抓绒衣 | 皮肤衣 | 速干衣 |\n| ---- | ------ | ------ | ------ | ------ |\n| 209  | 923  | 924  | 925  | 926  |\n\n| 羽绒服 | 软壳 | 户外鞋 | 登山鞋 | 徒步鞋 |\n| ------ | ---- | ------ | ------ | ------ |\n| 927  | 929  | 211  | 928  | 930  |\n\n| 越野跑鞋 | 溯溪鞋 | 登山杖 | 帐篷 | 睡袋 |\n| -------- | ------ | ------ | ---- | ---- |\n| 933    | 932  | 220  | 208  | 212  |\n\n| 炉具 | 灯具 | 水具 | 面料 | 背包 |\n| ---- | ---- | ---- | ---- | ---- |\n| 792  | 218  | 219  | 222  | 207  |\n\n| 防潮垫 | 电子导航 | 冰岩绳索 | 综合装备 |\n| ------ | -------- | -------- | -------- |\n| 214  | 216    | 215    | 223    |\n</details>",
        "location": "list.tsx",
        "module": () => import('@/routes/8264/list.tsx')
      }
    },
    "name": "8264",
    "apiRoutes": {},
    "url": "8264.com",
    "lang": "zh-CN"
  },
  "12306": {
    "routes": {
      "/:date/:from/:to/:type?": {
        "path": "/:date/:from/:to/:type?",
        "categories": [
          "travel"
        ],
        "example": "/12306/2022-02-19/重庆/永川东",
        "parameters": {
          "date": "时间，格式为（YYYY-MM-DD）",
          "from": "始发站",
          "to": "终点站",
          "type": "售票类型，成人和学生可选，默认为成人"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "售票信息",
        "maintainers": [
          "Fatpandac"
        ],
        "location": "index.tsx",
        "module": () => import('@/routes/12306/index.tsx')
      },
      "/zxdt/:id?": {
        "path": "/zxdt/:id?",
        "categories": [
          "travel"
        ],
        "example": "/12306/zxdt",
        "parameters": {
          "id": "铁路局id，可在 URL 中找到，不填默认显示所有铁路局动态"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.12306.cn/",
              "www.12306.cn/mormhweb/1/:id/index_fl.html"
            ],
            "target": "/zxdt/:id"
          }
        ],
        "name": "最新动态",
        "maintainers": [
          "LogicJake"
        ],
        "url": "www.12306.cn/",
        "location": "zxdt.ts",
        "module": () => import('@/routes/12306/zxdt.ts')
      }
    },
    "name": "12306",
    "apiRoutes": {},
    "url": "kyfw.12306.cn",
    "lang": "zh-CN"
  },
  "12371": {
    "routes": {
      "/:category?": {
        "path": "/:category?",
        "example": "/12371/zxfb",
        "parameters": {
          "category": "新闻分类名，预设 `zxfb`"
        },
        "radar": [
          {
            "source": [
              "www.12371.cn/:category"
            ]
          }
        ],
        "name": "最新发布",
        "maintainers": [
          "zvrr"
        ],
        "url": "www.12371.cn",
        "description": "| 最新发布 |\n| :------: |\n|   zxfb   |",
        "location": "zxfb.ts",
        "module": () => import('@/routes/12371/zxfb.ts')
      }
    },
    "name": "共产党员网",
    "url": "www.12371.cn",
    "categories": [
      "government"
    ],
    "lang": "zh-CN"
  },
  "005": {
    "routes": {
      "/:category?": {
        "path": "/:category?",
        "name": "资讯",
        "url": "005.tv",
        "maintainers": [
          "nczitzk"
        ],
        "example": "/005/zx",
        "parameters": {
          "category": "分类，可在对应分类页 URL 中找到，默认为二次元资讯"
        },
        "description": "\n| 二次元资讯 | 慢慢说 | 道听途说 | 展会资讯 |\n| ---------- | ------ | -------- | -------- |\n| zx         | zwh    | dtts     | zh       |\n    ",
        "categories": [
          "anime"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "005.tv/:category"
            ]
          },
          {
            "title": "二次元资讯",
            "source": [
              "005.tv/zx/"
            ],
            "target": "/005/zx"
          },
          {
            "title": "慢慢说",
            "source": [
              "005.tv/zwh/"
            ],
            "target": "/005/zwh"
          },
          {
            "title": "道听途说",
            "source": [
              "005.tv/dtts/"
            ],
            "target": "/005/dtts"
          },
          {
            "title": "展会资讯",
            "source": [
              "005.tv/zh/"
            ],
            "target": "/005/zh"
          }
        ],
        "location": "index.tsx",
        "module": () => import('@/routes/005/index.tsx')
      }
    },
    "name": "幻之羁绊动漫网",
    "apiRoutes": {},
    "url": "005.tv",
    "categories": [
      "anime"
    ],
    "description": "",
    "lang": "zh-CN"
  },
  "0818tuan": {
    "routes": {
      "/:listId?": {
        "path": "/:listId?",
        "categories": [
          "shopping"
        ],
        "example": "/0818tuan",
        "parameters": {
          "listId": "活动分类，见下表，默认为 `1`"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "分类",
        "maintainers": [
          "TonyRL"
        ],
        "description": "| 最新线报 | 实测活动 | 优惠券 |\n| -------- | -------- | ------ |\n| 1        | 2        | 3      |",
        "location": "index.ts",
        "module": () => import('@/routes/0818tuan/index.ts')
      }
    },
    "name": "0818 团",
    "apiRoutes": {},
    "url": "0818tuan.com",
    "lang": "zh-CN"
  },
  "0x80": {
    "routes": {
      "/blog": {
        "path": "/blog",
        "categories": [
          "blog"
        ],
        "example": "/0x80/blog",
        "url": "0x80.pl/notesen.html",
        "name": "Articles",
        "maintainers": [
          "xnum"
        ],
        "location": "index.ts",
        "module": () => import('@/routes/0x80/index.ts')
      }
    },
    "name": "Wojciech Muła",
    "apiRoutes": {},
    "url": "0x80.pl",
    "description": "",
    "lang": "en"
  },
  "0xxx": {
    "routes": {
      "/:filter?": {
        "path": "/:filter?",
        "name": "Source",
        "url": "0xxx.ws",
        "maintainers": [
          "nczitzk"
        ],
        "example": "/0xxx/category=Movie-HD-1080p",
        "parameters": {
          "filter": {
            "description": "Filter"
          }
        },
        "description": ":::tip\nTo subscribe to [Movie HD 1080p](https://0xxx.ws?category=Movie-HD-1080p), where the source URL is `https://0xxx.ws?category=Movie-HD-1080p`, extract the certain parts from this URL to be used as parameters, resulting in the route as [`/0xxx/category=Movie-HD-1080p`](https://rsshub.app/0xxx/category=Movie-HD-1080p).\n:::\n",
        "categories": [
          "multimedia"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false,
          "nfsw": true
        },
        "radar": [
          {
            "source": [
              "0xxx.ws"
            ]
          }
        ],
        "view": 0,
        "location": "index.ts",
        "module": () => import('@/routes/0xxx/index.ts')
      }
    },
    "name": "0xxx.ws",
    "apiRoutes": {},
    "url": "0xxx.ws",
    "categories": [
      "multimedia"
    ],
    "description": "Best 0day Porn Source",
    "lang": "en"
  },
  "10000link": {
    "routes": {
      "/info/:category?/:id?": {
        "path": "/info/:category?/:id?",
        "name": "新闻",
        "url": "info.10000link.com",
        "maintainers": [
          "nczitzk"
        ],
        "example": "/10000link/info/newslists/My01",
        "parameters": {
          "category": {
            "description": "分类，默认为 `newslists`，可在对应分类页 URL 中找到",
            "options": [
              {
                "label": "新闻",
                "value": "newslists"
              },
              {
                "label": "物流",
                "value": "newslogistics"
              },
              {
                "label": "供应链金融风控",
                "value": "newsRisk"
              },
              {
                "label": "区块链",
                "value": "newsBlockChain"
              },
              {
                "label": "B2B",
                "value": "newsBTwoB"
              },
              {
                "label": "跨境电商",
                "value": "newsCrossborder"
              },
              {
                "label": "投融资",
                "value": "newsInvestment"
              },
              {
                "label": "供应链管理",
                "value": "newsManagement"
              },
              {
                "label": "供应链创新",
                "value": "newsInnovation"
              },
              {
                "label": "数据",
                "value": "newslists/A02"
              },
              {
                "label": "政策",
                "value": "newslists/A03"
              },
              {
                "label": "规划",
                "value": "newslists/A04"
              },
              {
                "label": "案例",
                "value": "newslists/GL03"
              },
              {
                "label": "职场",
                "value": "newslists/ZC"
              },
              {
                "label": "供应链票据",
                "value": "newsBill"
              }
            ]
          },
          "id": {
            "description": "ID，默认为空，可在对应分类页 URL 中找到"
          }
        },
        "description": "::: tip\n若订阅 [天下大势](https://info.10000link.com/newslists.aspx?chid=My01)，网址为 `https://info.10000link.com/newslists.aspx?chid=My01`，请截取 `https://info.10000link.com/` 到末尾 `.aspx` 的部分 `newslists` 作为 `category` 参数填入，而 `My01` 作为 `id` 参数填入，此时目标路由为 [`/10000link/info/newslists/My01`](https://rsshub.app/10000link/info/newslists/My01)。\n:::\n\n| 金融科技      | 物流          | 供应链金融风控 | 区块链         | B2B       |\n| ------------- | ------------- | -------------- | -------------- | --------- |\n| newsFinancial | newslogistics | newsRisk       | newsBlockChain | newsBTwoB |\n\n| 跨境电商        | 投融资         | 供应链管理     | 供应链创新     | 数据          |\n| --------------- | -------------- | -------------- | -------------- | ------------- |\n| newsCrossborder | newsInvestment | newsManagement | newsInnovation | newslists/A02 |\n\n| 政策          | 规划          | 案例           | 职场         | 供应链票据 |\n| ------------- | ------------- | -------------- | ------------ | ---------- |\n| newslists/A03 | newslists/A04 | newslists/GL03 | newslists/ZC | newsBill   |\n",
        "categories": [
          "new-media"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "info.10000link.com/:category"
            ]
          }
        ],
        "view": 0,
        "location": "info.ts",
        "module": () => import('@/routes/10000link/info.ts')
      }
    },
    "name": "10000万联网",
    "apiRoutes": {},
    "url": "10000link.com",
    "categories": [
      "new-media"
    ],
    "description": "",
    "lang": "zh-CN"
  },
  "10jqka": {
    "routes": {
      "/realtimenews/:tag?": {
        "path": "/realtimenews/:tag?",
        "name": "7×24小时要闻直播",
        "url": "news.10jqka.com.cn",
        "maintainers": [
          "nczitzk"
        ],
        "example": "/10jqka/realtimenews",
        "parameters": {
          "tag": "标签，默认为全部"
        },
        "description": "::: tip\n  若订阅 [7×24小时要闻直播](https://news.10jqka.com.cn/realtimenews.html) 的 `公告` 标签。将 `公告` 作为标签参数填入，此时路由为 [`/10jqka/realtimenews/公告`](https://rsshub.app/10jqka/realtimenews/公告)。\n  \n  若订阅 [7×24小时要闻直播](https://news.10jqka.com.cn/realtimenews.html) 的 `公告` 和 `A股` 标签。将 `公告,A股` 作为标签参数填入，此时路由为 [`/10jqka/realtimenews/公告,A股`](https://rsshub.app/10jqka/realtimenews/公告,A股)。\n:::\n\n| 全部 | 重要 | A股 | 港股 | 美股 | 机会 | 异动 | 公告 |\n| ---- | ---- | ---- | ---- | ---- | ---- | ---- | ---- |\n    ",
        "categories": [
          "finance"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "title": "全部",
            "source": [
              "news.10jqka.com.cn/realtimenews.html"
            ],
            "target": "/realtimenews/全部"
          },
          {
            "title": "重要",
            "source": [
              "news.10jqka.com.cn/realtimenews.html"
            ],
            "target": "/realtimenews/重要"
          },
          {
            "title": "A股",
            "source": [
              "news.10jqka.com.cn/realtimenews.html"
            ],
            "target": "/realtimenews/A股"
          },
          {
            "title": "港股",
            "source": [
              "news.10jqka.com.cn/realtimenews.html"
            ],
            "target": "/realtimenews/港股"
          },
          {
            "title": "美股",
            "source": [
              "news.10jqka.com.cn/realtimenews.html"
            ],
            "target": "/realtimenews/美股"
          },
          {
            "title": "机会",
            "source": [
              "news.10jqka.com.cn/realtimenews.html"
            ],
            "target": "/realtimenews/机会"
          },
          {
            "title": "异动",
            "source": [
              "news.10jqka.com.cn/realtimenews.html"
            ],
            "target": "/realtimenews/异动"
          },
          {
            "title": "公告",
            "source": [
              "news.10jqka.com.cn/realtimenews.html"
            ],
            "target": "/realtimenews/公告"
          }
        ],
        "location": "realtimenews.ts",
        "module": () => import('@/routes/10jqka/realtimenews.ts')
      }
    },
    "name": "同花顺财经",
    "url": "10jqka.com.cn",
    "categories": [
      "finance"
    ],
    "description": "",
    "lang": "zh-CN"
  },
  "141jav": {
    "routes": {
      "/:type/:keyword{.*}?": {
        "path": "/:type/:keyword{.*}?",
        "categories": [
          "multimedia"
        ],
        "name": "通用",
        "maintainers": [
          "cgkings",
          "nczitzk"
        ],
        "parameters": {
          "type": "类型，可查看下表的类型说明",
          "keyword": "关键词，可查看下表的关键词说明"
        },
        "description": "**类型**\n\n| 最新 | 热门    | 随机   | 指定演员 | 指定标签 | 日期 |\n| ---- | ------- | ------ | -------- | -------- | ---- |\n| new  | popular | random | actress  | tag      | date |\n\n**关键词**\n\n| 空 | 日期范围    | 演员名       | 标签名         | 年月日     |\n| -- | ----------- | ------------ | -------------- | ---------- |\n|    | 7 / 30 / 60 | Yua%20Mikami | Adult%20Awards | 2020/07/30 |\n\n**示例说明**\n\n-  `/141jav/new`\n\n      仅当类型为 `new` `popular` 或 `random` 时关键词为 **空**\n\n-  `/141jav/popular/30`\n\n      `popular` `random` 类型的关键词可填写 `7` `30` 或 `60` 三个 **日期范围** 之一，分别对应 **7 天**、**30 天** 或 **60 天内**\n\n-  `/141jav/actress/Yua%20Mikami`\n\n      `actress` 类型的关键词必须填写 **演员名** ，可在 [此处](https://141jav.com/actress/) 演员单页链接中获取\n\n-  `/141jav/tag/Adult%20Awards`\n\n      `tag` 类型的关键词必须填写 **标签名** 且标签中的 `/` 必须替换为 `%2F` ，可在 [此处](https://141jav.com/tag/) 标签单页链接中获取\n\n-  `/141jav/date/2020/07/30`\n\n      `date` 类型的关键词必须填写 **日期(年/月/日)**",
        "features": {
          "nsfw": true
        },
        "location": "index.tsx",
        "module": () => import('@/routes/141jav/index.tsx')
      }
    },
    "name": "141JAV",
    "apiRoutes": {},
    "url": "141jav.com",
    "description": "::: tip\n官方提供的订阅源不支持 BT 下载订阅，地址为 [https://141jav.com/feeds/](https://141jav.com/feeds/)\n:::",
    "lang": "en"
  },
  "141ppv": {
    "routes": {
      "/:type/:keyword{.*}?": {
        "path": "/:type/:keyword{.*}?",
        "categories": [
          "multimedia"
        ],
        "name": "通用",
        "maintainers": [
          "cgkings",
          "nczitzk"
        ],
        "parameters": {
          "type": "类型，可查看下表的类型说明",
          "keyword": "关键词，可查看下表的关键词说明"
        },
        "description": "**类型**\n\n| 最新 | 热门    | 随机   | 指定演员 | 指定标签 | 日期 |\n| ---- | ------- | ------ | -------- | -------- | ---- |\n| new  | popular | random | actress  | tag      | date |\n\n**关键词**\n\n| 空 | 日期范围    | 演员名       | 标签名         | 年月日     |\n| -- | ----------- | ------------ | -------------- | ---------- |\n|    | 7 / 30 / 60 | Yua%20Mikami | Adult%20Awards | 2020/07/30 |\n\n**示例说明**\n\n-  `/141ppv/new`\n\n      仅当类型为 `new` `popular` 或 `random` 时关键词为 **空**\n\n-  `/141ppv/popular/30`\n\n      `popular` `random` 类型的关键词可填写 `7` `30` 或 `60` 三个 **日期范围** 之一，分别对应 **7 天**、**30 天** 或 **60 天内**\n\n-  `/141ppv/actress/Yua%20Mikami`\n\n      `actress` 类型的关键词必须填写 **演员名** ，可在 [此处](https://141ppv.com/actress/) 演员单页链接中获取\n\n-  `/141ppv/tag/Adult%20Awards`\n\n      `tag` 类型的关键词必须填写 **标签名** 且标签中的 `/` 必须替换为 `%2F` ，可在 [此处](https://141ppv.com/tag/) 标签单页链接中获取\n\n-  `/141ppv/date/2020/07/30`\n\n      `date` 类型的关键词必须填写 **日期(年/月/日)**",
        "features": {
          "nsfw": true
        },
        "location": "index.tsx",
        "module": () => import('@/routes/141ppv/index.tsx')
      }
    },
    "name": "141PPV",
    "apiRoutes": {},
    "url": "141ppv.com",
    "description": "::: tip\n官方提供的订阅源不支持 BT 下载订阅，地址为 [https://141ppv.com/feeds/](https://141ppv.com/feeds/)\n:::",
    "lang": "en"
  },
  "18comic": {
    "routes": {
      "/album/:id": {
        "path": "/album/:id",
        "categories": [
          "anime"
        ],
        "example": "/18comic/album/292282",
        "parameters": {
          "id": "专辑 id，可在专辑页 URL 中找到"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false,
          "nsfw": true
        },
        "radar": [
          {
            "source": [
              "jmcomic.group/"
            ]
          }
        ],
        "name": "专辑",
        "maintainers": [
          "nczitzk"
        ],
        "url": "jmcomic.group/",
        "description": "::: tip\n  专辑 id 不包括 URL 中标题的部分。\n:::",
        "location": "album.ts",
        "module": () => import('@/routes/18comic/album.ts')
      },
      "/blogs/:category?": {
        "path": "/blogs/:category?",
        "categories": [
          "anime"
        ],
        "example": "/18comic/blogs",
        "parameters": {
          "category": "分类，见下表，默认为空即全部"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false,
          "nsfw": true
        },
        "radar": [
          {
            "source": [
              "jmcomic.group/"
            ]
          }
        ],
        "name": "文庫",
        "maintainers": [
          "nczitzk"
        ],
        "url": "jmcomic.group/",
        "description": "分类\n\n| 全部 | 紳夜食堂 | 遊戲文庫 | JG GAMES | 模型山下 |\n| ---- | -------- | -------- | -------- | -------- |\n|      | dinner   | raiders  | jg       | figure   |",
        "location": "blogs.ts",
        "module": () => import('@/routes/18comic/blogs.ts')
      },
      "/:category?/:time?/:order?/:keyword?": {
        "path": "/:category?/:time?/:order?/:keyword?",
        "categories": [
          "anime"
        ],
        "example": "/18comic",
        "parameters": {
          "category": "分类，见下表，默认为 `all` 即全部",
          "time": "时间范围，见下表，默认为 `a` 即全部",
          "order": "排列顺序，见下表，默认为 `mr` 即最新",
          "keyword": "关键字，见下表，默认为空"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false,
          "nsfw": true
        },
        "radar": [
          {
            "source": [
              "jmcomic.group/"
            ]
          }
        ],
        "name": "成人 A 漫",
        "maintainers": [
          "nczitzk"
        ],
        "url": "jmcomic.group/",
        "description": "分类\n\n| 全部 | 其他漫畫 | 同人   | 韓漫   | 美漫   | 短篇  | 单本   |\n| ---- | -------- | ------ | ------ | ------ | ----- | ------ |\n| all  | another  | doujin | hanman | meiman | short | single |\n\n  时间范围\n\n| 全部 | 今天 | 这周 | 本月 |\n| ---- | ---- | ---- | ---- |\n| a    | t    | w    | m    |\n\n  排列顺序\n\n| 最新 | 最多点阅的 | 最多图片 | 最高评分 | 最多评论 | 最多爱心 |\n| ---- | ---------- | -------- | -------- | -------- | -------- |\n| mr   | mv         | mp       | tr       | md       | tf       |\n\n  关键字（供参考）\n\n| YAOI | 女性向 | NTR | 非 H | 3D | 獵奇 |\n| ---- | ------ | --- | ---- | -- | ---- |",
        "location": "index.ts",
        "module": () => import('@/routes/18comic/index.ts')
      },
      "/search/:option?/:category?/:keyword?/:time?/:order?": {
        "path": "/search/:option?/:category?/:keyword?/:time?/:order?",
        "categories": [
          "anime"
        ],
        "example": "/18comic/search/photos/all/NTR",
        "parameters": {
          "option": "选项，可选 `video` 和 `photos`，默认为 `photos`",
          "category": "分类，同上表，默认为 `all` 即全部",
          "keyword": "关键字，同上表，默认为空",
          "time": "时间范围，同上表，默认为 `a` 即全部",
          "order": "排列顺序，同上表，默认为 `mr` 即最新"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false,
          "nsfw": true
        },
        "radar": [
          {
            "source": [
              "jmcomic.group/"
            ],
            "target": "/:category?/:time?/:order?/:keyword?"
          }
        ],
        "name": "搜索",
        "maintainers": [
          "nczitzk"
        ],
        "url": "jmcomic.group/",
        "description": "::: tip\n  关键字必须超过两个字，这是来自网站的限制。\n:::",
        "location": "search.ts",
        "module": () => import('@/routes/18comic/search.ts')
      }
    },
    "name": "禁漫天堂",
    "apiRoutes": {},
    "url": "18comic.org",
    "description": "::: tip\n禁漫天堂有多个备用域名，本路由默认使用域名 `https://jmcomic.me`，若该域名无法访问，可以通过在路由最后加上 `?domain=<域名>` 指定路由访问的域名。如指定备用域名为 `https://jmcomic1.me`，则在所有禁漫天堂路由最后加上 `?domain=jmcomic1.me` 即可，此时路由为 [`/18comic?domain=jmcomic1.me`](https://rsshub.app/18comic?domain=jmcomic1.me)\n:::",
    "lang": "zh-CN"
  },
  "199it": {
    "name": "199it",
    "routes": {
      "/:category{.+}?": {
        "path": "/:category{.+}?",
        "name": "资讯",
        "url": "199it.com",
        "maintainers": [
          "nczitzk"
        ],
        "example": "/199it/newly",
        "parameters": {
          "category": {
            "description": "分类，默认为 `newly`，即最新，可在对应分类页 URL 中找到",
            "options": [
              {
                "label": "最新",
                "value": "newly"
              },
              {
                "label": "报告",
                "value": "archives/category/report"
              },
              {
                "label": "新兴产业",
                "value": "archives/category/emerging"
              },
              {
                "label": "金融科技",
                "value": "archives/category/fintech"
              },
              {
                "label": "共享经济",
                "value": "archives/category/sharingeconomy"
              },
              {
                "label": "移动互联网",
                "value": "archives/category/mobile-internet"
              },
              {
                "label": "电子商务",
                "value": "archives/category/electronic-commerce"
              },
              {
                "label": "社交网络",
                "value": "archives/category/social-network"
              },
              {
                "label": "网络广告",
                "value": "archives/category/advertising"
              },
              {
                "label": "投资&amp;经济，互联网金融",
                "value": "archives/category/economic-data"
              },
              {
                "label": "服务",
                "value": "archives/category/service"
              },
              {
                "label": "网络服务行业",
                "value": "archives/category/dataindustry"
              },
              {
                "label": "用户研究",
                "value": "archives/category/internet-users"
              }
            ]
          }
        },
        "description": "::: tip\n若订阅 [研究报告](https://www.199it.com/archives/category/report)，网址为 `https://www.199it.com/archives/category/report`，请截取 `https://www.199it.com/archives/category/report` 到末尾的部分 `archives/category/report` 作为 `category` 参数填入，此时目标路由为 [`/199it/archives/category/report`](https://rsshub.app/199it/archives/category/report)。\n:::\n\n<details>\n  <summary>更多分类</summary>\n\n| 分类                                                                              | ID                                                                                                      |\n| --------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------- |\n| [报告](http://www.199it.com/archives/category/report)                             | [archives/category/report](https://rsshub.app/199it/archives/category/report)                           |\n| [新兴产业](http://www.199it.com/archives/category/emerging)                       | [archives/category/emerging](https://rsshub.app/199it/archives/category/emerging)                       |\n| [金融科技](http://www.199it.com/archives/category/fintech)                        | [archives/category/fintech](https://rsshub.app/199it/archives/category/fintech)                         |\n| [共享经济](http://www.199it.com/archives/category/sharingeconomy)                 | [archives/category/sharingeconomy](https://rsshub.app/199it/archives/category/sharingeconomy)           |\n| [移动互联网](http://www.199it.com/archives/category/mobile-internet)              | [archives/category/mobile-internet](https://rsshub.app/199it/archives/category/mobile-internet)         |\n| [电子商务](http://www.199it.com/archives/category/electronic-commerce)            | [archives/category/electronic-commerce](https://rsshub.app/199it/archives/category/electronic-commerce) |\n| [社交网络](http://www.199it.com/archives/category/social-network)                 | [archives/category/social-network](https://rsshub.app/199it/archives/category/social-network)           |\n| [网络广告](http://www.199it.com/archives/category/advertising)                    | [archives/category/advertising](https://rsshub.app/199it/archives/category/advertising)                 |\n| [投资&amp;经济，互联网金融](http://www.199it.com/archives/category/economic-data) | [archives/category/economic-data](https://rsshub.app/199it/archives/category/economic-data)             |\n| [服务](http://www.199it.com/archives/category/service)                            | [archives/category/service](https://rsshub.app/199it/archives/category/service)                         |\n| [网络服务行业](http://www.199it.com/archives/category/dataindustry)               | [archives/category/dataindustry](https://rsshub.app/199it/archives/category/dataindustry)               |\n| [用户研究](http://www.199it.com/archives/category/internet-users)                 | [archives/category/internet-users](https://rsshub.app/199it/archives/category/internet-users)           |\n\n</details>\n",
        "categories": [
          "new-media"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.199it.com/:category"
            ]
          },
          {
            "title": "最新",
            "source": [
              "www.199it.com/newly"
            ],
            "target": "/newly"
          },
          {
            "title": "报告",
            "source": [
              "www.199it.com/archives/category/report"
            ],
            "target": "/archives/category/report"
          },
          {
            "title": "新兴产业",
            "source": [
              "www.199it.com/archives/category/emerging"
            ],
            "target": "/archives/category/emerging"
          },
          {
            "title": "金融科技",
            "source": [
              "www.199it.com/archives/category/fintech"
            ],
            "target": "/archives/category/fintech"
          },
          {
            "title": "共享经济",
            "source": [
              "www.199it.com/archives/category/sharingeconomy"
            ],
            "target": "/archives/category/sharingeconomy"
          },
          {
            "title": "移动互联网",
            "source": [
              "www.199it.com/archives/category/mobile-internet"
            ],
            "target": "/archives/category/mobile-internet"
          },
          {
            "title": "电子商务",
            "source": [
              "www.199it.com/archives/category/electronic-commerce"
            ],
            "target": "/archives/category/electronic-commerce"
          },
          {
            "title": "社交网络",
            "source": [
              "www.199it.com/archives/category/social-network"
            ],
            "target": "/archives/category/social-network"
          },
          {
            "title": "网络广告",
            "source": [
              "www.199it.com/archives/category/advertising"
            ],
            "target": "/archives/category/advertising"
          },
          {
            "title": "投资&amp;经济，互联网金融",
            "source": [
              "www.199it.com/archives/category/economic-data"
            ],
            "target": "/archives/category/economic-data"
          },
          {
            "title": "服务",
            "source": [
              "www.199it.com/archives/category/service"
            ],
            "target": "/archives/category/service"
          },
          {
            "title": "网络服务行业",
            "source": [
              "www.199it.com/archives/category/dataindustry"
            ],
            "target": "/archives/category/dataindustry"
          },
          {
            "title": "用户研究",
            "source": [
              "www.199it.com/archives/category/internet-users"
            ],
            "target": "/archives/category/internet-users"
          }
        ],
        "view": 0,
        "location": "index.tsx",
        "module": () => import('@/routes/199it/index.tsx')
      }
    },
    "apiRoutes": {}
  },
  "19lou": {
    "routes": {
      "/:city?": {
        "path": "/:city?",
        "categories": [
          "bbs"
        ],
        "example": "/19lou/jiaxing",
        "parameters": {
          "city": "分类，见下表，默认为 www，即杭州"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "头条",
        "maintainers": [
          "nczitzk"
        ],
        "description": "| 杭州 | 台州    | 嘉兴    | 宁波   | 湖州   |\n| ---- | ------- | ------- | ------ | ------ |\n| www  | taizhou | jiaxing | ningbo | huzhou |\n\n| 绍兴     | 湖州   | 温州    | 金华   | 舟山     |\n| -------- | ------ | ------- | ------ | -------- |\n| shaoxing | huzhou | wenzhou | jinhua | zhoushan |\n\n| 衢州   | 丽水   | 义乌 | 萧山     | 余杭   |\n| ------ | ------ | ---- | -------- | ------ |\n| quzhou | lishui | yiwu | xiaoshan | yuhang |\n\n| 临安  | 富阳   | 桐庐   | 建德   | 淳安   |\n| ----- | ------ | ------ | ------ | ------ |\n| linan | fuyang | tonglu | jiande | chunan |",
        "location": "index.ts",
        "module": () => import('@/routes/19lou/index.ts')
      }
    },
    "name": "19 楼",
    "apiRoutes": {},
    "url": "19lou.com",
    "lang": "zh-CN"
  },
  "1lou": {
    "routes": {
      "/:params{.+}?": {
        "path": "/:params{.+}?",
        "name": "通用",
        "url": "1lou.me",
        "maintainers": [
          "falling",
          "nczitzk"
        ],
        "example": "/1lou/forum-2-1",
        "parameters": {
          "params": "路径参数，可以在对应页面的 URL 中找到"
        },
        "description": "::: tip\n  `1lou.me/` 后的内容填入 params 参数，以下是几个例子：\n\n  若订阅 [大陆电视剧](https://www.1lou.me/forum-2-1.htm?tagids=0_97_0_0)，网址为 `https://www.1lou.me/forum-2-1.htm?tagids=0_97_0_0`。截取 `https://www.1lou.me/` 到末尾 `.htm` 的部分 `forum-2-1` 作为参数，并补充 `tagids`，此时路由为 [`/1lou/forum-2-1?tagids=0_97_0_0`](https://rsshub.app/1lou/forum-2-1?tagids=0_97_0_0)。\n  \n  若订阅 [最新发帖电视剧](https://www.1lou.me/forum-2-1.htm?orderby=tid&digest=0)，网址为 `https://www.1lou.me/forum-2-1.htm?orderby=tid&digest=0`。截取 `https://www.1lou.me/` 到末尾 `.htm` 的部分 `forum-2-1` 作为参数，并补充 `orderby`，此时路由为 [`/1lou/forum-2-1?orderby=tid`](https://rsshub.app/1lou/forum-2-1?orderby=tid)。\n  \n  若订阅 [搜素繁花主题贴](https://www.1lou.me/search-_E7_B9_81_E8_8A_B1-1.htm)，网址为 `https://www.1lou.me/search-_E7_B9_81_E8_8A_B1-1.htm`。截取 `https://www.1lou.me/` 到末尾 `.htm` 的部分 `search-_E7_B9_81_E8_8A_B1-1` 作为参数，此时路由为 [`/1lou/search-_E7_B9_81_E8_8A_B1-1`](https://rsshub.app/1lou/search-_E7_B9_81_E8_8A_B1-1)。\n:::",
        "categories": [
          "multimedia"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "1lou.me/:params"
            ]
          }
        ],
        "location": "index.ts",
        "module": () => import('@/routes/1lou/index.ts')
      }
    },
    "name": "BT 之家 1LOU 站",
    "apiRoutes": {},
    "url": "1lou.me",
    "categories": [
      "multimedia"
    ],
    "description": "",
    "lang": "zh-CN"
  },
  "1point3acres": {
    "routes": {
      "/blog/:category?": {
        "path": "/blog/:category?",
        "categories": [
          "bbs"
        ],
        "example": "/1point3acres/blog",
        "parameters": {
          "category": "分类，见下表，可在对应分类页 URL 中找到"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "blog.1point3acres.com/:category"
            ]
          }
        ],
        "name": "博客",
        "maintainers": [
          "nczitzk"
        ],
        "description": "| 留学申请   | 找工求职 | 生活攻略  | 投资理财 | 签证移民 | 时政要闻 |\n| ---------- | -------- | --------- | -------- | -------- | -------- |\n| studyinusa | career   | lifestyle | invest   | visa     | news     |",
        "location": "blog.ts",
        "module": () => import('@/routes/1point3acres/blog.ts')
      },
      "/category/:id?/:type?/:order?": {
        "path": "/category/:id?/:type?/:order?",
        "categories": [
          "bbs"
        ],
        "example": "/1point3acres/category/h1b",
        "parameters": {
          "id": "标签 id，默认为全部",
          "type": "帖子分类, 见下表，默认为 hot，即热门帖子",
          "order": "排序方式，见下表，默认为空，即最新回复"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "instant.1point3acres.com/section/:id",
              "instant.1point3acres.com/"
            ]
          }
        ],
        "name": "标签",
        "maintainers": [
          "nczitzk"
        ],
        "description": "::: tip\n  更多标签可以在 [标签列表](https://instant.1point3acres.com/tags) 中找到。\n:::\n\n  分类\n\n| 热门帖子 | 最新帖子 |\n| -------- | -------- |\n| hot      | new      |\n\n  排序方式\n\n| 最新回复 | 最新发布 |\n| -------- | -------- |\n|          | post     |",
        "location": "category.ts",
        "module": () => import('@/routes/1point3acres/category.ts')
      },
      "/offer/:year?/:major?/:school?": {
        "path": "/offer/:year?/:major?/:school?",
        "categories": [
          "bbs"
        ],
        "example": "/1point3acres/offer/12/null/CMU",
        "parameters": {
          "year": "录取年份  id，空为null",
          "major": "录取专业 id，空为null",
          "school": "录取学校 id，空为null"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "offer.1point3acres.com/"
            ],
            "target": "/offer"
          }
        ],
        "name": "录取结果",
        "maintainers": [
          "EthanWng97"
        ],
        "url": "offer.1point3acres.com/",
        "description": "::: tip 三个 id 获取方式\n  1.  打开 [https://offer.1point3acres.com](https://offer.1point3acres.com)\n  2.  打开控制台\n  3.  切换到 Network 面板\n  4.  点击 搜索 按钮\n  5.  点击 results?ps=15&pg=1 POST 请求\n  6.  找到 Request Payload 请求参数，例如 `filters: {planyr: \"13\", planmajor: \"1\", outname_w: \"ACADIAU\"}` ，则三个 id 分别为: 13,1,ACADIAU\n:::",
        "location": "offer.tsx",
        "module": () => import('@/routes/1point3acres/offer.tsx')
      },
      "/section/:id?/:type?/:order?": {
        "path": "/section/:id?/:type?/:order?",
        "categories": [
          "bbs"
        ],
        "example": "/1point3acres/section/345",
        "parameters": {
          "id": "分区 id，见下表，默认为全部",
          "type": "帖子分类, 见下表，默认为 hot，即热门帖子",
          "order": "排序方式，见下表，默认为空，即最新回复"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "instant.1point3acres.com/section/:id",
              "instant.1point3acres.com/"
            ]
          }
        ],
        "name": "分区",
        "maintainers": [
          "nczitzk"
        ],
        "description": "分区\n\n| 分区     | id  |\n| -------- | --- |\n| 留学申请 | 257 |\n| 世界公民 | 379 |\n| 投资理财 | 400 |\n| 生活干货 | 31  |\n| 职场达人 | 345 |\n| 人际关系 | 391 |\n| 海外求职 | 38  |\n| 签证移民 | 265 |\n\n  分类\n\n| 热门帖子 | 最新帖子 |\n| -------- | -------- |\n| hot      | new      |\n\n  排序方式\n\n| 最新回复 | 最新发布 |\n| -------- | -------- |\n|          | post     |",
        "location": "section.ts",
        "module": () => import('@/routes/1point3acres/section.ts')
      },
      "/thread/:type?/:order?": {
        "path": "/thread/:type?/:order?",
        "example": "/1point3acres/thread/hot",
        "parameters": {
          "type": "帖子分类, 见下表，默认为 hot，即热门帖子",
          "order": "排序方式，见下表，默认为空，即最新回复"
        },
        "name": "帖子",
        "categories": [
          "bbs"
        ],
        "maintainers": [
          "EthanWng97",
          "DIYgod",
          "nczitzk"
        ],
        "url": "instant.1point3acres.com/",
        "description": "分类\n\n| 热门帖子 | 最新帖子 |\n| -------- | -------- |\n| hot      | new      |\n\n  排序方式\n\n| 最新回复 | 最新发布 |\n| -------- | -------- |\n|          | post     |",
        "location": "thread.ts",
        "module": () => import('@/routes/1point3acres/thread.ts')
      },
      "/user/:id/posts": {
        "path": "/user/:id/posts",
        "categories": [
          "bbs"
        ],
        "example": "/1point3acres/user/1/posts",
        "parameters": {
          "id": "用户 id，可在 Instant 版网站的个人主页 URL 找到"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "instant.1point3acres.com/profile/:id",
              "instant.1point3acres.com/"
            ]
          }
        ],
        "name": "用户回帖",
        "maintainers": [
          "Maecenas"
        ],
        "location": "user/post.ts",
        "module": () => import('@/routes/1point3acres/user/post.ts')
      },
      "/user/:id/threads": {
        "path": "/user/:id/threads",
        "categories": [
          "bbs"
        ],
        "example": "/1point3acres/user/1/threads",
        "parameters": {
          "id": "用户 id，可在 Instant 版网站的个人主页 URL 找到"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "instant.1point3acres.com/profile/:id",
              "instant.1point3acres.com/"
            ]
          }
        ],
        "name": "用户主题帖",
        "maintainers": [
          "Maecenas"
        ],
        "location": "user/thread.ts",
        "module": () => import('@/routes/1point3acres/user/thread.ts')
      }
    },
    "name": "一亩三分地",
    "apiRoutes": {},
    "url": "blog.1point3acres.com",
    "lang": "zh-CN"
  },
  "1x": {
    "routes": {
      "/:category{.+}?": {
        "path": "/:category{.+}?",
        "name": "Gallery",
        "url": "1x.com",
        "maintainers": [
          "nczitzk"
        ],
        "example": "/1x/latest/awarded",
        "parameters": {
          "category": "Category, Latest Awarded by default"
        },
        "description": "::: tip\nFill in the field in the path with the part of the corresponding page URL after `https://1x.com/gallery/` or `https://1x.com/photo/`. Here are the examples:\n\nIf you subscribe to [Abstract Awarded](https://1x.com/gallery/abstract/awarded), you should fill in the path with the part `abstract/awarded` from the page URL `https://1x.com/gallery/abstract/awarded`. In this case, the route will be [`/1x/abstract/awarded`](https://rsshub.app/1x/abstract/awarded).\n\nIf you subscribe to [Wildlife Published](https://1x.com/gallery/wildlife/published), you should fill in the path with the part `wildlife/published` from the page URL `https://1x.com/gallery/wildlife/published`. In this case, the route will be [`/1x/wildlife/published`](https://rsshub.app/1x/wildlife/published).\n:::",
        "categories": [
          "design",
          "picture"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "/gallery/:category*",
              "/photos/:category*"
            ],
            "target": "/1x/:category"
          }
        ],
        "location": "index.tsx",
        "module": () => import('@/routes/1x/index.tsx')
      }
    },
    "name": "1x.com",
    "apiRoutes": {},
    "url": "1x.com",
    "categories": [
      "design",
      "picture"
    ],
    "description": "1x.com • In Pursuit of the Sublime. Browse 200,000 curated photos from photographers all over the world.",
    "lang": "en"
  },
  "2023game": {
    "routes": {
      "/:category?/:tab?": {
        "path": "/:category?/:tab?",
        "categories": [
          "game"
        ],
        "example": "/2023game/sgame/topicList",
        "parameters": {
          "category": "分类，见下表",
          "tab": "标签, 所有:all;最新:topicList;热门:jhcpb"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "游戏星辰",
        "maintainers": [
          "xzzpig"
        ],
        "url": "www.2023game.com/",
        "description": "分类\n\n| PS4游戏 | switch游戏 | 3DS游戏 | PSV游戏 | Xbox360 | PS3游戏 | 世嘉MD/SS | PSP游戏 | PC周边 | 怀旧掌机 | 怀旧主机 | PS4教程 | PS4金手指 | switch金手指 | switch教程 | switch补丁 | switch主题 | switch存档 |\n| -------- | -------- | -------- | -------- | -------- | -------- | -------- | -------- | -------- | -------- | -------- | -------- | -------- | -------- | -------- | -------- | -------- | -------- |\n| ps4 | sgame | 3ds | psv | jiaocheng | ps3yx | zhuji.md | zhangji.psp | pcgame | zhangji | zhuji | ps4.psjc | ps41.ps4pkg | nsaita.cundang | nsaita.pojie | nsaita.buding | nsaita.zhutie | nsaita.zhuti |",
        "location": "index.ts",
        "module": () => import('@/routes/2023game/index.ts')
      }
    },
    "name": "游戏星辰",
    "apiRoutes": {},
    "url": "www.2023game.com",
    "lang": "zh-CN"
  },
  "21caijing": {
    "routes": {
      "/channel/:name{.+}?": {
        "path": "/channel/:name{.+}?",
        "name": "频道",
        "url": "m.21jingji.com",
        "maintainers": [
          "nczitzk"
        ],
        "example": "/21caijing/channel/热点",
        "parameters": {
          "category": "分类，默认为热点，可在对应分类页 URL 中找到"
        },
        "description": "::: tip\n若订阅 [热点](https://m.21jingji.com/#/)，请将 `热点` 作为 `name` 参数填入，此时目标路由为 [`/21caijing/channel/热点`](https://rsshub.app/21caijing/channel/热点)。\n\n若订阅 [投资通 - 盘前情报](https://m.21jingji.com/#/channel/investment)，请将 `投资通/盘前情报` 作为 `name` 参数填入，此时目标路由为 [`/21caijing/channel/投资通/盘前情报`](https://rsshub.app/21caijing/channel/投资通/盘前情报)。\n:::\n\n<details>\n<summary>更多分类</summary>\n\n#### [热点](https://m.21jingji.com/#/)\n\n#### [投资通](https://m.21jingji.com/#/channel/investment)\n\n| [推荐](https://m.21jingji.com/#/channel/investment)            | [盘前情报](https://m.21jingji.com/#/channel/premkt)                    | [公司洞察](https://m.21jingji.com/#/channel/gsdc)                      | [南财研选](https://m.21jingji.com/#/channel/ncyx)                      | [龙虎榜](https://m.21jingji.com/#/channel/lhb)                     | [公告精选](https://m.21jingji.com/#/channel/notice)                    | [牛熊透视](https://m.21jingji.com/#/channel/bullbear)                  | [一周前瞻](https://m.21jingji.com/#/channel/dailyfx)                   | [财经日历](https://m.21jingji.com/#/)                                   | [风口掘金](https://m.21jingji.com/#/channel/windgap)                   | [实时解盘](https://m.21jingji.com/#/channel/marketanalysis)            | [调研内参](https://m.21jingji.com/#/channel/research)                  | [趋势前瞻](https://m.21jingji.com/#/channel/tendency)                  | [硬核选基](https://m.21jingji.com/#/channel/yhxj)                      | [3 分钟理财](https://m.21jingji.com/#/channel/sfzlc)                      | [AI 智讯](https://m.21jingji.com/#/channel/aizx)                    | [北向资金](https://m.21jingji.com/#/channel/northmoney)                |\n| --------------------------------------------------------------- | ----------------------------------------------------------------------- | ----------------------------------------------------------------------- | ----------------------------------------------------------------------- | ------------------------------------------------------------------- | ----------------------------------------------------------------------- | ----------------------------------------------------------------------- | ----------------------------------------------------------------------- | ----------------------------------------------------------------------- | ----------------------------------------------------------------------- | ----------------------------------------------------------------------- | ----------------------------------------------------------------------- | ----------------------------------------------------------------------- | ----------------------------------------------------------------------- | -------------------------------------------------------------------------- | -------------------------------------------------------------------- | ----------------------------------------------------------------------- |\n| [投资通/推荐](https://rsshub.app/21caijing/channel/投资通/推荐) | [投资通/盘前情报](https://rsshub.app/21caijing/channel/投资通/盘前情报) | [投资通/公司洞察](https://rsshub.app/21caijing/channel/投资通/公司洞察) | [投资通/南财研选](https://rsshub.app/21caijing/channel/投资通/南财研选) | [投资通/龙虎榜](https://rsshub.app/21caijing/channel/投资通/龙虎榜) | [投资通/公告精选](https://rsshub.app/21caijing/channel/投资通/公告精选) | [投资通/牛熊透视](https://rsshub.app/21caijing/channel/投资通/牛熊透视) | [投资通/一周前瞻](https://rsshub.app/21caijing/channel/投资通/一周前瞻) | [投资通/财经日历](https://rsshub.app/21caijing/channel/投资通/财经日历) | [投资通/风口掘金](https://rsshub.app/21caijing/channel/投资通/风口掘金) | [投资通/实时解盘](https://rsshub.app/21caijing/channel/投资通/实时解盘) | [投资通/调研内参](https://rsshub.app/21caijing/channel/投资通/调研内参) | [投资通/趋势前瞻](https://rsshub.app/21caijing/channel/投资通/趋势前瞻) | [投资通/硬核选基](https://rsshub.app/21caijing/channel/投资通/硬核选基) | [投资通/3 分钟理财](https://rsshub.app/21caijing/channel/投资通/3分钟理财) | [投资通/AI 智讯](https://rsshub.app/21caijing/channel/投资通/AI智讯) | [投资通/北向资金](https://rsshub.app/21caijing/channel/投资通/北向资金) |\n\n#### [金融](https://m.21jingji.com/#/channel/finance)\n\n| [动态](https://m.21jingji.com/#/channel/finance)           | [最保险](https://m.21jingji.com/#/channel/Insurance)           | [资管](https://m.21jingji.com/#/channel/21zg)              | [数字金融](https://m.21jingji.com/#/channel/szjr)                  | [私人银行](https://m.21jingji.com/#/channel/sryh)                  | [普惠](https://m.21jingji.com/#/channel/puhui)             | [观债](https://m.21jingji.com/#/channel/21gz)              | [金融研究](https://m.21jingji.com/#/channel/jryj)                  | [投教基地](https://m.21jingji.com/#/channel/tjjd)                  | [银行](https://m.21jingji.com/#/channel/bank)              | [非银金融](https://m.21jingji.com/#/channel/nonbank)               | [金融人事](https://m.21jingji.com/#/channel/jrrs)                  |\n| ----------------------------------------------------------- | --------------------------------------------------------------- | ----------------------------------------------------------- | ------------------------------------------------------------------- | ------------------------------------------------------------------- | ----------------------------------------------------------- | ----------------------------------------------------------- | ------------------------------------------------------------------- | ------------------------------------------------------------------- | ----------------------------------------------------------- | ------------------------------------------------------------------- | ------------------------------------------------------------------- |\n| [金融/动态](https://rsshub.app/21caijing/channel/金融/动态) | [金融/最保险](https://rsshub.app/21caijing/channel/金融/最保险) | [金融/资管](https://rsshub.app/21caijing/channel/金融/资管) | [金融/数字金融](https://rsshub.app/21caijing/channel/金融/数字金融) | [金融/私人银行](https://rsshub.app/21caijing/channel/金融/私人银行) | [金融/普惠](https://rsshub.app/21caijing/channel/金融/普惠) | [金融/观债](https://rsshub.app/21caijing/channel/金融/观债) | [金融/金融研究](https://rsshub.app/21caijing/channel/金融/金融研究) | [金融/投教基地](https://rsshub.app/21caijing/channel/金融/投教基地) | [金融/银行](https://rsshub.app/21caijing/channel/金融/银行) | [金融/非银金融](https://rsshub.app/21caijing/channel/金融/非银金融) | [金融/金融人事](https://rsshub.app/21caijing/channel/金融/金融人事) |\n\n#### [宏观](https://m.21jingji.com/#/channel/politics)\n\n#### [学习经济](https://m.21jingji.com/#/jujiao/xxjjIndexV3)\n\n| [经济思想](https://m.21jingji.com/#/https://m.21jingji.com/news/xxjj)       | [学习经济卡片](https://m.21jingji.com/#/channel/mrjj)                              | [高质量发展](https://m.21jingji.com/#/channel/gzlfz)                           | [经济政策](https://m.21jingji.com/#/channel/jjzc)                          | [广东在行动](https://m.21jingji.com/#/channel/gdzxd)                           | [数说经济](https://m.21jingji.com/#/channel/ssjj)                          | [学习视频](https://m.21jingji.com/#/channel/xxsp)                          | [学习党史](https://m.21jingji.com/#/)                                       |\n| --------------------------------------------------------------------------- | ----------------------------------------------------------------------------------- | ------------------------------------------------------------------------------- | --------------------------------------------------------------------------- | ------------------------------------------------------------------------------- | --------------------------------------------------------------------------- | --------------------------------------------------------------------------- | --------------------------------------------------------------------------- |\n| [学习经济/经济思想](https://rsshub.app/21caijing/channel/学习经济/经济思想) | [学习经济/学习经济卡片](https://rsshub.app/21caijing/channel/学习经济/学习经济卡片) | [学习经济/高质量发展](https://rsshub.app/21caijing/channel/学习经济/高质量发展) | [学习经济/经济政策](https://rsshub.app/21caijing/channel/学习经济/经济政策) | [学习经济/广东在行动](https://rsshub.app/21caijing/channel/学习经济/广东在行动) | [学习经济/数说经济](https://rsshub.app/21caijing/channel/学习经济/数说经济) | [学习经济/学习视频](https://rsshub.app/21caijing/channel/学习经济/学习视频) | [学习经济/学习党史](https://rsshub.app/21caijing/channel/学习经济/学习党史) |\n\n#### [大湾区](https://m.21jingji.com/#/channel/GHM_GreaterBay)\n\n| [动态](https://m.21jingji.com/#/channel/GHM_GreaterBay)        | [湾区金融](https://m.21jingji.com/#/channel/wqjr)                      | [大湾区直播室](https://m.21jingji.com/#/channel/dwqzbs)                        | [高成长企业](https://m.21jingji.com/#/channel/gczqy)                       | [产业地理](https://m.21jingji.com/#/channel/cydl)                      | [数智湾区](https://m.21jingji.com/#/channel/szwq)                      | [湾区金融大咖会](https://m.21jingji.com/#/channel/wqjrdkh)                         | [“港”创科 25 人](https://m.21jingji.com/#/channel/gck)                           | [湾区论坛](https://m.21jingji.com/#/channel/wqlt)                      |\n| --------------------------------------------------------------- | ----------------------------------------------------------------------- | ------------------------------------------------------------------------------- | --------------------------------------------------------------------------- | ----------------------------------------------------------------------- | ----------------------------------------------------------------------- | ----------------------------------------------------------------------------------- | --------------------------------------------------------------------------------- | ----------------------------------------------------------------------- |\n| [大湾区/动态](https://rsshub.app/21caijing/channel/大湾区/动态) | [大湾区/湾区金融](https://rsshub.app/21caijing/channel/大湾区/湾区金融) | [大湾区/大湾区直播室](https://rsshub.app/21caijing/channel/大湾区/大湾区直播室) | [大湾区/高成长企业](https://rsshub.app/21caijing/channel/大湾区/高成长企业) | [大湾区/产业地理](https://rsshub.app/21caijing/channel/大湾区/产业地理) | [大湾区/数智湾区](https://rsshub.app/21caijing/channel/大湾区/数智湾区) | [大湾区/湾区金融大咖会](https://rsshub.app/21caijing/channel/大湾区/湾区金融大咖会) | [大湾区/“港”创科 25 人](https://rsshub.app/21caijing/channel/大湾区/“港”创科25人) | [大湾区/湾区论坛](https://rsshub.app/21caijing/channel/大湾区/湾区论坛) |\n\n#### [证券](https://m.21jingji.com/#/channel/capital)\n\n| [动态](https://m.21jingji.com/#/channel/capital)           | [赢基金](https://m.21jingji.com/#/channel/funds)               | [券业观察](https://m.21jingji.com/#/channel/securities)            | [期市一线](https://m.21jingji.com/#/channel/qsyx)                  | [ETF](https://m.21jingji.com/#/channel/govern)           |\n| ----------------------------------------------------------- | --------------------------------------------------------------- | ------------------------------------------------------------------- | ------------------------------------------------------------------- | --------------------------------------------------------- |\n| [证券/动态](https://rsshub.app/21caijing/channel/证券/动态) | [证券/赢基金](https://rsshub.app/21caijing/channel/证券/赢基金) | [证券/券业观察](https://rsshub.app/21caijing/channel/证券/券业观察) | [证券/期市一线](https://rsshub.app/21caijing/channel/证券/期市一线) | [证券/ETF](https://rsshub.app/21caijing/channel/证券/ETF) |\n\n#### [汽车](https://m.21jingji.com/#/channel/auto)\n\n| [热闻](https://m.21jingji.com/#/channel/autofocus)         | [新汽车](https://m.21jingji.com/#/channel/newauto)             | [车访间](https://m.21jingji.com/#/channel/autointerview)       | [财说车](https://m.21jingji.com/#/channel/autofortune)         | [汽车人](https://m.21jingji.com/#/channel/autopeople)          | [汽车商业地理](https://m.21jingji.com/#/channel/autogeo)                   | [汽车金融](https://m.21jingji.com/#/channel/autofinance)           | [行业报告](https://m.21jingji.com/#/channel/autoreport)            | [聚焦](https://m.21jingji.com/#/channel/autospotlight)     |\n| ----------------------------------------------------------- | --------------------------------------------------------------- | --------------------------------------------------------------- | --------------------------------------------------------------- | --------------------------------------------------------------- | --------------------------------------------------------------------------- | ------------------------------------------------------------------- | ------------------------------------------------------------------- | ----------------------------------------------------------- |\n| [汽车/热闻](https://rsshub.app/21caijing/channel/汽车/热闻) | [汽车/新汽车](https://rsshub.app/21caijing/channel/汽车/新汽车) | [汽车/车访间](https://rsshub.app/21caijing/channel/汽车/车访间) | [汽车/财说车](https://rsshub.app/21caijing/channel/汽车/财说车) | [汽车/汽车人](https://rsshub.app/21caijing/channel/汽车/汽车人) | [汽车/汽车商业地理](https://rsshub.app/21caijing/channel/汽车/汽车商业地理) | [汽车/汽车金融](https://rsshub.app/21caijing/channel/汽车/汽车金融) | [汽车/行业报告](https://rsshub.app/21caijing/channel/汽车/行业报告) | [汽车/聚焦](https://rsshub.app/21caijing/channel/汽车/聚焦) |\n\n#### [观点](https://m.21jingji.com/#/channel/opinion)\n\n#### [新健康](https://m.21jingji.com/#/channel/healthnews)\n\n| [动态](https://m.21jingji.com/#/channel/healthdt)              | [21 健讯 Daily](https://m.21jingji.com/#/channel/healthinfo)                   | [21CC](https://m.21jingji.com/#/channel/21cc)                  | [21 健谈](https://m.21jingji.com/#/channel/healthtalk)              | [名医说](https://m.21jingji.com/#/channel/doctorssay)              | [数字医疗](https://m.21jingji.com/#/channel/digitalhealth)             | [21H 院长对话](https://m.21jingji.com/#/channel/talkwithdean)                 | [医健 IPO 解码](https://m.21jingji.com/#/channel/medicalIPO)                   | [研究报告](https://m.21jingji.com/#/channel/yjbg)                      | [21 科普](https://m.21jingji.com/#/channel/healthkp)                |\n| --------------------------------------------------------------- | ------------------------------------------------------------------------------- | --------------------------------------------------------------- | -------------------------------------------------------------------- | ------------------------------------------------------------------- | ----------------------------------------------------------------------- | ------------------------------------------------------------------------------ | ------------------------------------------------------------------------------- | ----------------------------------------------------------------------- | -------------------------------------------------------------------- |\n| [新健康/动态](https://rsshub.app/21caijing/channel/新健康/动态) | [新健康/21 健讯 Daily](https://rsshub.app/21caijing/channel/新健康/21健讯Daily) | [新健康/21CC](https://rsshub.app/21caijing/channel/新健康/21CC) | [新健康/21 健谈](https://rsshub.app/21caijing/channel/新健康/21健谈) | [新健康/名医说](https://rsshub.app/21caijing/channel/新健康/名医说) | [新健康/数字医疗](https://rsshub.app/21caijing/channel/新健康/数字医疗) | [新健康/21H 院长对话](https://rsshub.app/21caijing/channel/新健康/21H院长对话) | [新健康/医健 IPO 解码](https://rsshub.app/21caijing/channel/新健康/医健IPO解码) | [新健康/研究报告](https://rsshub.app/21caijing/channel/新健康/研究报告) | [新健康/21 科普](https://rsshub.app/21caijing/channel/新健康/21科普) |\n\n#### [ESG](https://m.21jingji.com/#/channel/esg)\n\n| [ESG 发布厅](https://m.21jingji.com/#/channel/esg)                  | [绿色公司](https://m.21jingji.com/#/channel/lsgs)                | [绿色金融](https://m.21jingji.com/#/channel/lsjr)                | [净零碳城市](https://m.21jingji.com/#/channel/jltcs)                 | [碳市场](https://m.21jingji.com/#/channel/)                  | [生物多样性](https://m.21jingji.com/#/channel/swdyx)                 | [行业周报](https://m.21jingji.com/#/channel/hyzb)                | [研究报告](https://m.21jingji.com/#/)                             |\n| -------------------------------------------------------------------- | ----------------------------------------------------------------- | ----------------------------------------------------------------- | --------------------------------------------------------------------- | ------------------------------------------------------------- | --------------------------------------------------------------------- | ----------------------------------------------------------------- | ----------------------------------------------------------------- |\n| [ESG/ESG 发布厅](https://rsshub.app/21caijing/channel/ESG/ESG发布厅) | [ESG/绿色公司](https://rsshub.app/21caijing/channel/ESG/绿色公司) | [ESG/绿色金融](https://rsshub.app/21caijing/channel/ESG/绿色金融) | [ESG/净零碳城市](https://rsshub.app/21caijing/channel/ESG/净零碳城市) | [ESG/碳市场](https://rsshub.app/21caijing/channel/ESG/碳市场) | [ESG/生物多样性](https://rsshub.app/21caijing/channel/ESG/生物多样性) | [ESG/行业周报](https://rsshub.app/21caijing/channel/ESG/行业周报) | [ESG/研究报告](https://rsshub.app/21caijing/channel/ESG/研究报告) |\n\n#### [全球市场](https://m.21jingji.com/#/channel/global)\n\n| [动态](https://m.21jingji.com/#/channel/global)                    | [全球财经连线](https://m.21jingji.com/#/channel/globaleconomics)                   | [直击华尔街](https://m.21jingji.com/#/channel/wallstreet)                      | [百家跨国公司看中国](https://m.21jingji.com/#/channel/mnc)                                     | [全球央行观察](https://m.21jingji.com/#/channel/globalcentralbanks)                | [全球能源观察](https://m.21jingji.com/#/channel/globalenergy)                      | [美股一线](https://m.21jingji.com/#/channel/USstock)                       | [港股一线](https://m.21jingji.com/#/channel/HKstock)                       | [全球金融观察](https://m.21jingji.com/#/channel/globalfinance)                     | [联合国现场](https://m.21jingji.com/#/channel/unitednations)                   | [全球央行月报](https://m.21jingji.com/#/channel/centralbankreport)                 | [全球商品观察](https://m.21jingji.com/#/channel/globalcommodities)                 |\n| ------------------------------------------------------------------- | ----------------------------------------------------------------------------------- | ------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------- | --------------------------------------------------------------------------- | --------------------------------------------------------------------------- | ----------------------------------------------------------------------------------- | ------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------- |\n| [全球市场/动态](https://rsshub.app/21caijing/channel/全球市场/动态) | [全球市场/全球财经连线](https://rsshub.app/21caijing/channel/全球市场/全球财经连线) | [全球市场/直击华尔街](https://rsshub.app/21caijing/channel/全球市场/直击华尔街) | [全球市场/百家跨国公司看中国](https://rsshub.app/21caijing/channel/全球市场/百家跨国公司看中国) | [全球市场/全球央行观察](https://rsshub.app/21caijing/channel/全球市场/全球央行观察) | [全球市场/全球能源观察](https://rsshub.app/21caijing/channel/全球市场/全球能源观察) | [全球市场/美股一线](https://rsshub.app/21caijing/channel/全球市场/美股一线) | [全球市场/港股一线](https://rsshub.app/21caijing/channel/全球市场/港股一线) | [全球市场/全球金融观察](https://rsshub.app/21caijing/channel/全球市场/全球金融观察) | [全球市场/联合国现场](https://rsshub.app/21caijing/channel/全球市场/联合国现场) | [全球市场/全球央行月报](https://rsshub.app/21caijing/channel/全球市场/全球央行月报) | [全球市场/全球商品观察](https://rsshub.app/21caijing/channel/全球市场/全球商品观察) |\n\n#### [一带一路](https://m.21jingji.com/#/channel/BandR)\n\n#### [数读](https://m.21jingji.com/#/channel/readnumber)\n\n#### [理财通](https://m.21jingji.com/#/channel/financing)\n\n| [动态](https://m.21jingji.com/#/channel/licaidongtai)          | [数据库](https://m.21jingji.com/#/channel/sjk)                     | [研报](https://m.21jingji.com/#/channel/yanbao)                | [投教](https://m.21jingji.com/#/channel/tj)                    | [政策](https://m.21jingji.com/#/channel/zhengce)               | [固收+](https://m.21jingji.com/#/channel/gushou)                 | [纯固收](https://m.21jingji.com/#/channel/chungushou)              | [现金](https://m.21jingji.com/#/channel/xianjin)               | [混合](https://m.21jingji.com/#/channel/hunhe)                 | [权益](https://m.21jingji.com/#/channel/quanyi)                |\n| --------------------------------------------------------------- | ------------------------------------------------------------------- | --------------------------------------------------------------- | --------------------------------------------------------------- | --------------------------------------------------------------- | ----------------------------------------------------------------- | ------------------------------------------------------------------- | --------------------------------------------------------------- | --------------------------------------------------------------- | --------------------------------------------------------------- |\n| [理财通/动态](https://rsshub.app/21caijing/channel/理财通/动态) | [理财通/数据库](https://rsshub.app/21caijing/channel/理财通/数据库) | [理财通/研报](https://rsshub.app/21caijing/channel/理财通/研报) | [理财通/投教](https://rsshub.app/21caijing/channel/理财通/投教) | [理财通/政策](https://rsshub.app/21caijing/channel/理财通/政策) | [理财通/固收+](https://rsshub.app/21caijing/channel/理财通/固收+) | [理财通/纯固收](https://rsshub.app/21caijing/channel/理财通/纯固收) | [理财通/现金](https://rsshub.app/21caijing/channel/理财通/现金) | [理财通/混合](https://rsshub.app/21caijing/channel/理财通/混合) | [理财通/权益](https://rsshub.app/21caijing/channel/理财通/权益) |\n\n#### [直播](https://m.21jingji.com/#/channel/live)\n\n#### [长三角](https://m.21jingji.com/#/channel/yangtzeriverdelta)\n\n#### [论坛活动](https://m.21jingji.com/#/channel/market)\n\n#### [创投](https://m.21jingji.com/#/channel/entrepreneur)\n\n#### [投教](https://m.21jingji.com/#/channel/tjzjy)\n\n| [动态](https://m.21jingji.com/#/channel/tjzjy)             | [投教知识](https://m.21jingji.com/#/channel/tjzs)                  | [公益活动](https://m.21jingji.com/#/channel/gyhd)                  |\n| ----------------------------------------------------------- | ------------------------------------------------------------------- | ------------------------------------------------------------------- |\n| [投教/动态](https://rsshub.app/21caijing/channel/投教/动态) | [投教/投教知识](https://rsshub.app/21caijing/channel/投教/投教知识) | [投教/公益活动](https://rsshub.app/21caijing/channel/投教/公益活动) |\n\n#### [海洋经济](https://m.21jingji.com/#/channel/oceaneconomy)\n\n#### [数字合规](https://m.21jingji.com/#/channel/compliance)\n\n#### [公司](https://m.21jingji.com/#/channel/company)\n\n| [动态](https://m.21jingji.com/#/channel/company)           | [电子通信](https://m.21jingji.com/#/channel/electrocommunication)  | [互联网](https://m.21jingji.com/#/channel/internet)            | [高端制造](https://m.21jingji.com/#/channel/highend)               | [新能源](https://m.21jingji.com/#/channel/newenergy)           | [消费](https://m.21jingji.com/#/channel/consumption)       | [地产基建](https://m.21jingji.com/#/channel/infrastructure)        | [IPO](https://m.21jingji.com/#/channel/IPO)              | [文旅](https://m.21jingji.com/#/channel/culturetravel)     |\n| ----------------------------------------------------------- | ------------------------------------------------------------------- | --------------------------------------------------------------- | ------------------------------------------------------------------- | --------------------------------------------------------------- | ----------------------------------------------------------- | ------------------------------------------------------------------- | --------------------------------------------------------- | ----------------------------------------------------------- |\n| [公司/动态](https://rsshub.app/21caijing/channel/公司/动态) | [公司/电子通信](https://rsshub.app/21caijing/channel/公司/电子通信) | [公司/互联网](https://rsshub.app/21caijing/channel/公司/互联网) | [公司/高端制造](https://rsshub.app/21caijing/channel/公司/高端制造) | [公司/新能源](https://rsshub.app/21caijing/channel/公司/新能源) | [公司/消费](https://rsshub.app/21caijing/channel/公司/消费) | [公司/地产基建](https://rsshub.app/21caijing/channel/公司/地产基建) | [公司/IPO](https://rsshub.app/21caijing/channel/公司/IPO) | [公司/文旅](https://rsshub.app/21caijing/channel/公司/文旅) |\n\n#### [人文](https://m.21jingji.com/#/channel/life)\n\n#### [SFC Global](https://m.21jingji.com/#/channel/SFCGlobal)\n\n| [News](https://m.21jingji.com/#/channel/SFCGlobal)                     | [SFC Markets and Finance](https://m.21jingji.com/#/channel/ SFCMarketsandFinance)                            | [SFC Market Talk](https://m.21jingji.com/#/channel/ SFCMarketTalk)                           | [CBN](https://m.21jingji.com/#/channel/CBN)                          | [Multinationals on China](https://m.21jingji.com/#/channel/MultinationalsonChina)                            | [Companies in the GBA](https://m.21jingji.com/#/channel/CompaniesintheGBA)                             |\n| ----------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------- | --------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------- |\n| [SFC Global/News](https://rsshub.app/21caijing/channel/SFC Global/News) | [SFC Global/SFC Markets and Finance](https://rsshub.app/21caijing/channel/SFC Global/SFC Markets and Finance) | [SFC Global/SFC Market Talk](https://rsshub.app/21caijing/channel/SFC Global/SFC Market Talk) | [SFC Global/CBN](https://rsshub.app/21caijing/channel/SFC Global/CBN) | [SFC Global/Multinationals on China](https://rsshub.app/21caijing/channel/SFC Global/Multinationals on China) | [SFC Global/Companies in the GBA](https://rsshub.app/21caijing/channel/SFC Global/Companies in the GBA) |\n\n#### [南方财经报道](https://m.21jingji.com/#/channel/nfcjbd)\n\n#### [链上预制菜](https://m.21jingji.com/#/channel/precookedfood)\n\n| [动态](https://m.21jingji.com/#/channel/precookedfood)                 | [活动](https://m.21jingji.com/#/channel/foodevent)                     | [报道](https://m.21jingji.com/#/channel/foodnews)                      | [智库/课题](https://m.21jingji.com/#/channel/foodtopic)                          | [数据/创新案例](https://m.21jingji.com/#/channel/foodcase)                               | [链接平台](https://m.21jingji.com/#/channel/foodlink)                          |\n| ----------------------------------------------------------------------- | ----------------------------------------------------------------------- | ----------------------------------------------------------------------- | --------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------- |\n| [链上预制菜/动态](https://rsshub.app/21caijing/channel/链上预制菜/动态) | [链上预制菜/活动](https://rsshub.app/21caijing/channel/链上预制菜/活动) | [链上预制菜/报道](https://rsshub.app/21caijing/channel/链上预制菜/报道) | [链上预制菜/智库/课题](https://rsshub.app/21caijing/channel/链上预制菜/智库/课题) | [链上预制菜/数据/创新案例](https://rsshub.app/21caijing/channel/链上预制菜/数据/创新案例) | [链上预制菜/链接平台](https://rsshub.app/21caijing/channel/链上预制菜/链接平台) |\n\n</details>\n",
        "categories": [
          "finance"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "title": "热点",
            "source": [
              "m.21jingji.com/#/"
            ],
            "target": "/channel/热点"
          },
          {
            "title": "投资通",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/投资通"
          },
          {
            "title": "投资通/推荐",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/投资通/推荐"
          },
          {
            "title": "投资通/盘前情报",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/投资通/盘前情报"
          },
          {
            "title": "投资通/公司洞察",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/投资通/公司洞察"
          },
          {
            "title": "投资通/南财研选",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/投资通/南财研选"
          },
          {
            "title": "投资通/龙虎榜",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/投资通/龙虎榜"
          },
          {
            "title": "投资通/公告精选",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/投资通/公告精选"
          },
          {
            "title": "投资通/牛熊透视",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/投资通/牛熊透视"
          },
          {
            "title": "投资通/一周前瞻",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/投资通/一周前瞻"
          },
          {
            "title": "投资通/财经日历",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/投资通/财经日历"
          },
          {
            "title": "投资通/风口掘金",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/投资通/风口掘金"
          },
          {
            "title": "投资通/实时解盘",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/投资通/实时解盘"
          },
          {
            "title": "投资通/调研内参",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/投资通/调研内参"
          },
          {
            "title": "投资通/趋势前瞻",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/投资通/趋势前瞻"
          },
          {
            "title": "投资通/硬核选基",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/投资通/硬核选基"
          },
          {
            "title": "投资通/3分钟理财",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/投资通/3分钟理财"
          },
          {
            "title": "投资通/AI智讯",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/投资通/AI智讯"
          },
          {
            "title": "投资通/北向资金",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/投资通/北向资金"
          },
          {
            "title": "金融",
            "source": [
              "m.21jingji.com/#/channel/finance"
            ],
            "target": "/channel/金融"
          },
          {
            "title": "金融/动态",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/金融/动态"
          },
          {
            "title": "金融/最保险",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/金融/最保险"
          },
          {
            "title": "金融/资管",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/金融/资管"
          },
          {
            "title": "金融/数字金融",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/金融/数字金融"
          },
          {
            "title": "金融/私人银行",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/金融/私人银行"
          },
          {
            "title": "金融/普惠",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/金融/普惠"
          },
          {
            "title": "金融/观债",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/金融/观债"
          },
          {
            "title": "金融/金融研究",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/金融/金融研究"
          },
          {
            "title": "金融/投教基地",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/金融/投教基地"
          },
          {
            "title": "金融/银行",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/金融/银行"
          },
          {
            "title": "金融/非银金融",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/金融/非银金融"
          },
          {
            "title": "金融/金融人事",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/金融/金融人事"
          },
          {
            "title": "宏观",
            "source": [
              "m.21jingji.com/#/channel/politics"
            ],
            "target": "/channel/宏观"
          },
          {
            "title": "学习经济",
            "source": [
              "m.21jingji.com/#/jujiao/xxjjIndexV3"
            ],
            "target": "/channel/学习经济"
          },
          {
            "title": "学习经济/经济思想",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/学习经济/经济思想"
          },
          {
            "title": "学习经济/学习经济卡片",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/学习经济/学习经济卡片"
          },
          {
            "title": "学习经济/高质量发展",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/学习经济/高质量发展"
          },
          {
            "title": "学习经济/经济政策",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/学习经济/经济政策"
          },
          {
            "title": "学习经济/广东在行动",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/学习经济/广东在行动"
          },
          {
            "title": "学习经济/数说经济",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/学习经济/数说经济"
          },
          {
            "title": "学习经济/学习视频",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/学习经济/学习视频"
          },
          {
            "title": "学习经济/学习党史",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/学习经济/学习党史"
          },
          {
            "title": "大湾区",
            "source": [
              "m.21jingji.com/#/channel/GHM_GreaterBay"
            ],
            "target": "/channel/大湾区"
          },
          {
            "title": "大湾区/动态",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/大湾区/动态"
          },
          {
            "title": "大湾区/湾区金融",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/大湾区/湾区金融"
          },
          {
            "title": "大湾区/大湾区直播室",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/大湾区/大湾区直播室"
          },
          {
            "title": "大湾区/高成长企业",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/大湾区/高成长企业"
          },
          {
            "title": "大湾区/产业地理",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/大湾区/产业地理"
          },
          {
            "title": "大湾区/数智湾区",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/大湾区/数智湾区"
          },
          {
            "title": "大湾区/湾区金融大咖会",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/大湾区/湾区金融大咖会"
          },
          {
            "title": "大湾区/“港”创科25人",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/大湾区/“港”创科25人"
          },
          {
            "title": "大湾区/湾区论坛",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/大湾区/湾区论坛"
          },
          {
            "title": "证券",
            "source": [
              "m.21jingji.com/#/channel/capital"
            ],
            "target": "/channel/证券"
          },
          {
            "title": "证券/动态",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/证券/动态"
          },
          {
            "title": "证券/赢基金",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/证券/赢基金"
          },
          {
            "title": "证券/券业观察",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/证券/券业观察"
          },
          {
            "title": "证券/期市一线",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/证券/期市一线"
          },
          {
            "title": "证券/ETF",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/证券/ETF"
          },
          {
            "title": "汽车",
            "source": [
              "m.21jingji.com/#/channel/auto"
            ],
            "target": "/channel/汽车"
          },
          {
            "title": "汽车/热闻",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/汽车/热闻"
          },
          {
            "title": "汽车/新汽车",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/汽车/新汽车"
          },
          {
            "title": "汽车/车访间",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/汽车/车访间"
          },
          {
            "title": "汽车/财说车",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/汽车/财说车"
          },
          {
            "title": "汽车/汽车人",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/汽车/汽车人"
          },
          {
            "title": "汽车/汽车商业地理",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/汽车/汽车商业地理"
          },
          {
            "title": "汽车/汽车金融",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/汽车/汽车金融"
          },
          {
            "title": "汽车/行业报告",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/汽车/行业报告"
          },
          {
            "title": "汽车/聚焦",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/汽车/聚焦"
          },
          {
            "title": "观点",
            "source": [
              "m.21jingji.com/#/channel/opinion"
            ],
            "target": "/channel/观点"
          },
          {
            "title": "新健康",
            "source": [
              "m.21jingji.com/#/channel/healthnews"
            ],
            "target": "/channel/新健康"
          },
          {
            "title": "新健康/动态",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/新健康/动态"
          },
          {
            "title": "新健康/21健讯Daily",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/新健康/21健讯Daily"
          },
          {
            "title": "新健康/21CC",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/新健康/21CC"
          },
          {
            "title": "新健康/21健谈",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/新健康/21健谈"
          },
          {
            "title": "新健康/名医说",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/新健康/名医说"
          },
          {
            "title": "新健康/数字医疗",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/新健康/数字医疗"
          },
          {
            "title": "新健康/21H院长对话",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/新健康/21H院长对话"
          },
          {
            "title": "新健康/医健IPO解码",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/新健康/医健IPO解码"
          },
          {
            "title": "新健康/研究报告",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/新健康/研究报告"
          },
          {
            "title": "新健康/21科普",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/新健康/21科普"
          },
          {
            "title": "ESG",
            "source": [
              "m.21jingji.com/#/channel/esg"
            ],
            "target": "/channel/ESG"
          },
          {
            "title": "ESG/ESG发布厅",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/ESG/ESG发布厅"
          },
          {
            "title": "ESG/绿色公司",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/ESG/绿色公司"
          },
          {
            "title": "ESG/绿色金融",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/ESG/绿色金融"
          },
          {
            "title": "ESG/净零碳城市",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/ESG/净零碳城市"
          },
          {
            "title": "ESG/碳市场",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/ESG/碳市场"
          },
          {
            "title": "ESG/生物多样性",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/ESG/生物多样性"
          },
          {
            "title": "ESG/行业周报",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/ESG/行业周报"
          },
          {
            "title": "ESG/研究报告",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/ESG/研究报告"
          },
          {
            "title": "全球市场",
            "source": [
              "m.21jingji.com/#/channel/global"
            ],
            "target": "/channel/全球市场"
          },
          {
            "title": "全球市场/动态",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/全球市场/动态"
          },
          {
            "title": "全球市场/全球财经连线",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/全球市场/全球财经连线"
          },
          {
            "title": "全球市场/直击华尔街",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/全球市场/直击华尔街"
          },
          {
            "title": "全球市场/百家跨国公司看中国",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/全球市场/百家跨国公司看中国"
          },
          {
            "title": "全球市场/全球央行观察",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/全球市场/全球央行观察"
          },
          {
            "title": "全球市场/全球能源观察",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/全球市场/全球能源观察"
          },
          {
            "title": "全球市场/美股一线",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/全球市场/美股一线"
          },
          {
            "title": "全球市场/港股一线",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/全球市场/港股一线"
          },
          {
            "title": "全球市场/全球金融观察",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/全球市场/全球金融观察"
          },
          {
            "title": "全球市场/联合国现场",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/全球市场/联合国现场"
          },
          {
            "title": "全球市场/全球央行月报",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/全球市场/全球央行月报"
          },
          {
            "title": "全球市场/全球商品观察",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/全球市场/全球商品观察"
          },
          {
            "title": "一带一路",
            "source": [
              "m.21jingji.com/#/channel/BandR"
            ],
            "target": "/channel/一带一路"
          },
          {
            "title": "数读",
            "source": [
              "m.21jingji.com/#/channel/readnumber"
            ],
            "target": "/channel/数读"
          },
          {
            "title": "理财通",
            "source": [
              "m.21jingji.com/#/channel/financing"
            ],
            "target": "/channel/理财通"
          },
          {
            "title": "理财通/动态",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/理财通/动态"
          },
          {
            "title": "理财通/数据库",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/理财通/数据库"
          },
          {
            "title": "理财通/研报",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/理财通/研报"
          },
          {
            "title": "理财通/投教",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/理财通/投教"
          },
          {
            "title": "理财通/政策",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/理财通/政策"
          },
          {
            "title": "理财通/固收+",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/理财通/固收+"
          },
          {
            "title": "理财通/纯固收",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/理财通/纯固收"
          },
          {
            "title": "理财通/现金",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/理财通/现金"
          },
          {
            "title": "理财通/混合",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/理财通/混合"
          },
          {
            "title": "理财通/权益",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/理财通/权益"
          },
          {
            "title": "直播",
            "source": [
              "m.21jingji.com/#/channel/live"
            ],
            "target": "/channel/直播"
          },
          {
            "title": "长三角",
            "source": [
              "m.21jingji.com/#/channel/yangtzeriverdelta"
            ],
            "target": "/channel/长三角"
          },
          {
            "title": "论坛活动",
            "source": [
              "m.21jingji.com/#/channel/market"
            ],
            "target": "/channel/论坛活动"
          },
          {
            "title": "创投",
            "source": [
              "m.21jingji.com/#/channel/entrepreneur"
            ],
            "target": "/channel/创投"
          },
          {
            "title": "投教",
            "source": [
              "m.21jingji.com/#/channel/tjzjy"
            ],
            "target": "/channel/投教"
          },
          {
            "title": "投教/动态",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/投教/动态"
          },
          {
            "title": "投教/投教知识",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/投教/投教知识"
          },
          {
            "title": "投教/公益活动",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/投教/公益活动"
          },
          {
            "title": "海洋经济",
            "source": [
              "m.21jingji.com/#/channel/oceaneconomy"
            ],
            "target": "/channel/海洋经济"
          },
          {
            "title": "数字合规",
            "source": [
              "m.21jingji.com/#/channel/compliance"
            ],
            "target": "/channel/数字合规"
          },
          {
            "title": "公司",
            "source": [
              "m.21jingji.com/#/channel/company"
            ],
            "target": "/channel/公司"
          },
          {
            "title": "公司/动态",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/公司/动态"
          },
          {
            "title": "公司/电子通信",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/公司/电子通信"
          },
          {
            "title": "公司/互联网",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/公司/互联网"
          },
          {
            "title": "公司/高端制造",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/公司/高端制造"
          },
          {
            "title": "公司/新能源",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/公司/新能源"
          },
          {
            "title": "公司/消费",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/公司/消费"
          },
          {
            "title": "公司/地产基建",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/公司/地产基建"
          },
          {
            "title": "公司/IPO",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/公司/IPO"
          },
          {
            "title": "公司/文旅",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/公司/文旅"
          },
          {
            "title": "人文",
            "source": [
              "m.21jingji.com/#/channel/life"
            ],
            "target": "/channel/人文"
          },
          {
            "title": "SFC Global",
            "source": [
              "m.21jingji.com/#/channel/SFCGlobal"
            ],
            "target": "/channel/SFC Global"
          },
          {
            "title": "SFC Global/News",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/SFC Global/News"
          },
          {
            "title": "SFC Global/SFC Markets and Finance",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/SFC Global/SFC Markets and Finance"
          },
          {
            "title": "SFC Global/SFC Market Talk",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/SFC Global/SFC Market Talk"
          },
          {
            "title": "SFC Global/CBN",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/SFC Global/CBN"
          },
          {
            "title": "SFC Global/Multinationals on China",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/SFC Global/Multinationals on China"
          },
          {
            "title": "SFC Global/Companies in the GBA",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/SFC Global/Companies in the GBA"
          },
          {
            "title": "南方财经报道",
            "source": [
              "m.21jingji.com/#/channel/nfcjbd"
            ],
            "target": "/channel/南方财经报道"
          },
          {
            "title": "专题",
            "source": [
              "m.21jingji.com/#/jujiao"
            ],
            "target": "/channel/专题"
          },
          {
            "title": "链上预制菜",
            "source": [
              "m.21jingji.com/#/channel/precookedfood"
            ],
            "target": "/channel/链上预制菜"
          },
          {
            "title": "链上预制菜/动态",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/链上预制菜/动态"
          },
          {
            "title": "链上预制菜/活动",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/链上预制菜/活动"
          },
          {
            "title": "链上预制菜/报道",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/链上预制菜/报道"
          },
          {
            "title": "链上预制菜/智库/课题",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/链上预制菜/智库/课题"
          },
          {
            "title": "链上预制菜/数据/创新案例",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/链上预制菜/数据/创新案例"
          },
          {
            "title": "链上预制菜/链接平台",
            "source": [
              "m.21jingji.com/#/channel/investment"
            ],
            "target": "/channel/链上预制菜/链接平台"
          }
        ],
        "view": 0,
        "location": "channel.ts",
        "module": () => import('@/routes/21caijing/channel.ts')
      }
    },
    "name": "21财经",
    "apiRoutes": {},
    "url": "21caijing.com",
    "categories": [
      "finance"
    ],
    "description": ""
  },
  "2cycd": {
    "routes": {
      "/:fid/:sort?": {
        "path": "/:fid/:sort?",
        "name": "Unknown",
        "maintainers": [
          "shelken"
        ],
        "location": "index.ts",
        "module": () => import('@/routes/2cycd/index.ts')
      }
    },
    "name": "二次元虫洞",
    "apiRoutes": {},
    "url": "2cycd.com",
    "lang": "zh-CN"
  },
  "30secondsofcode": {
    "routes": {
      "/category/:category?/:subCategory?": {
        "path": "/category/:category?/:subCategory?",
        "categories": [
          "programming"
        ],
        "example": "/category/css/interactivity",
        "parameters": {
          "category": {
            "description": "Main Category. For Complete list visit site \"https://www.30secondsofcode.org/collections/p/1/\"",
            "options": [
              {
                "value": "js",
                "label": "Javascript"
              },
              {
                "value": "css",
                "label": "CSS"
              },
              {
                "value": "algorithm",
                "label": "JavaScript Algorithms"
              },
              {
                "value": "react",
                "label": "React"
              }
            ]
          },
          "subCategory": {
            "description": "Filter within Category. Visit Individual Category site for subCategories"
          }
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "30secondsofcode.org/:category/:subCategory/",
              "30secondsofcode.org/:category/"
            ],
            "target": "/category/:category/:subCategory"
          }
        ],
        "name": "Category and Subcategory",
        "maintainers": [
          "Rjnishant530"
        ],
        "location": "category.ts",
        "module": () => import('@/routes/30secondsofcode/category.ts')
      },
      "/latest": {
        "path": "/latest",
        "categories": [
          "programming"
        ],
        "example": "/latest",
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "30secondsofcode.org"
            ],
            "target": "/latest"
          }
        ],
        "name": "New & Popular Snippets",
        "maintainers": [
          "Rjnishant530"
        ],
        "location": "new-and-popular.ts",
        "module": () => import('@/routes/30secondsofcode/new-and-popular.ts')
      }
    },
    "name": "30 Seconds of code",
    "apiRoutes": {},
    "url": "www.30secondsofcode.org",
    "lang": "en"
  },
  "36kr": {
    "routes": {
      "/hot-list/:category?": {
        "path": "/hot-list/:category?",
        "categories": [
          "new-media"
        ],
        "example": "/36kr/hot-list",
        "parameters": {
          "category": "分类，默认为24小时热榜"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "36kr.com/hot-list/:category",
              "36kr.com/"
            ],
            "target": "/hot-list/:category"
          }
        ],
        "name": "资讯热榜",
        "maintainers": [
          "nczitzk"
        ],
        "description": "| 24 小时热榜 | 资讯人气榜 | 资讯综合榜 | 资讯收藏榜 |\n| ----------- | ---------- | ---------- | ---------- |\n| 24          | renqi      | zonghe     | shoucang   |",
        "location": "hot-list.ts",
        "module": () => import('@/routes/36kr/hot-list.ts')
      },
      "/:category/:subCategory?/:keyword?": {
        "path": "/:category/:subCategory?/:keyword?",
        "categories": [
          "new-media"
        ],
        "example": "/36kr/newsflashes",
        "parameters": {
          "category": "分类，必填项",
          "subCategory": "子分类，选填项，目的是为了兼容老逻辑",
          "keyword": "关键词，选填项，仅搜索文章/快讯时有效"
        },
        "name": "资讯, 快讯, 用户文章, 主题文章, 专题文章, 搜索文章, 搜索快讯",
        "maintainers": [
          "nczitzk",
          "fashioncj"
        ],
        "description": "| 最新资讯频道 | 快讯 | 推荐资讯 | 生活 | 房产 | 职场 | 搜索文章 | 搜索快讯 |\n| ------- | -------- | -------- | -------- | -------- | --------| -------- | -------- |\n| news | newsflashes | recommend | life | estate | workplace | search/articles/关键词 | search/articles/关键词 |",
        "location": "index.ts",
        "module": () => import('@/routes/36kr/index.ts')
      }
    },
    "name": "36kr",
    "apiRoutes": {},
    "url": "36kr.com",
    "lang": "zh-CN"
  },
  "3dmgame": {
    "routes": {
      "/games/:name/:type?": {
        "path": "/games/:name/:type?",
        "radar": [
          {
            "source": [
              "3dmgame.com/games/:name/:type"
            ]
          }
        ],
        "name": "游戏资讯",
        "categories": [
          "game"
        ],
        "maintainers": [
          "sinchang",
          "jacky2001114",
          "HenryQW",
          "lyqluis"
        ],
        "location": "game.ts",
        "module": () => import('@/routes/3dmgame/game.ts')
      },
      "/news/:category?": {
        "path": "/news/:category?",
        "categories": [
          "game"
        ],
        "example": "/3dmgame/news",
        "parameters": {
          "category": "分类名或 ID，见下表，默认为新闻推荐，ID 可从分类 URL 中找到，如 Steam 为 `22221`"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "3dmgame.com/news/:category?",
              "3dmgame.com/news"
            ]
          }
        ],
        "name": "新闻中心",
        "maintainers": [
          "zhboner",
          "lyqluis"
        ],
        "description": "| 新闻推荐 | 游戏新闻 | 动漫影视 | 智能数码 | 时事焦点    |\n| -------- | -------- | -------- | -------- | ----------- |\n|          | game     | acg      | next     | news_36_1 |",
        "location": "news-center.ts",
        "module": () => import('@/routes/3dmgame/news-center.ts')
      }
    },
    "name": "3DMGame",
    "apiRoutes": {},
    "url": "3dmgame.com",
    "lang": "zh-CN"
  },
  "3kns": {
    "routes": {
      "/:filters?/:order?": {
        "path": "/:filters?/:order?",
        "categories": [
          "game"
        ],
        "example": "/3kns/category=all&lang=all",
        "parameters": {
          "filters": "过滤器，可用参数见下表",
          "order": "排序，按高分排序:desc;按低分排序:asc"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "3k-Switch游戏库",
        "maintainers": [
          "xzzpig"
        ],
        "url": "www.3kns.com/",
        "description": "游戏类型(category)\n\n| 不限 | 角色扮演 | 动作冒险 | 策略游戏 | 模拟经营 | 即时战略 | 格斗类 | 射击游戏 | 休闲益智 | 体育运动 | 街机格斗 | 无双类 | 其他游戏 | 赛车竞速 |\n| ---- | -------- | -------- | -------- | -------- | -------- | ------ | -------- | -------- | -------- | -------- | ------ | -------- | -------- |\n| all  | 1        | 2        | 3        | 4        | 5        | 6      | 7        | 8        | 9        | 10       | 11     | 12       | 13       |\n\n  游戏语言(language)\n\n| 不限 | 中文 | 英语 | 日语 | 其他 | 中文汉化 | 德语 |\n| ---- | ---- | ---- | ---- | ---- | -------- | ---- |\n| all  | 1    | 2    | 3    | 4    | 5        | 6    |\n\n  游戏标签(tag)\n\n| 不限 | 热门 | 多人聚会 | 僵尸 | 体感 | 大作 | 音乐 | 三国 | RPG | 格斗 | 闯关 | 横版 | 科幻 | 棋牌 | 运输 | 无双 | 卡通动漫 | 日系 | 养成 | 恐怖 | 运动 | 乙女 | 街机 | 飞行模拟 | 解谜 | 海战 | 战争 | 跑酷 | 即时策略 | 射击 | 经营 | 益智 | 沙盒 | 模拟 | 冒险 | 竞速 | 休闲 | 动作 | 生存 | 独立 | 拼图 | 魔改 xci | 卡牌 | 塔防 |\n| ---- | ---- | -------- | ---- | ---- | ---- | ---- | ---- | --- | ---- | ---- | ---- | ---- | ---- | ---- | ---- | -------- | ---- | ---- | ---- | ---- | ---- | ---- | -------- | ---- | ---- | ---- | ---- | -------- | ---- | ---- | ---- | ---- | ---- | ---- | ---- | ---- | ---- | ---- | ---- | ---- | -------- | ---- | ---- |\n| all  | 1    | 2        | 3    | 4    | 5    | 6    | 7    | 8   | 9    | 10   | 11   | 12   | 13   | 14   | 15   | 16       | 17   | 18   | 19   | 20   | 21   | 22   | 23       | 24   | 25   | 26   | 27   | 28       | 29   | 30   | 31   | 32   | 33   | 34   | 35   | 36   | 37   | 38   | 39   | 40   | 41       | 42   | 43   |\n\n  发售时间(pubDate)\n\n| 不限 | 2017 年 | 2018 年 | 2019 年 | 2020 年 | 2021 年 | 2022 年 | 2023 年 | 2024 年 |\n| ---- | ------- | ------- | ------- | ------- | ------- | ------- | ------- | ------- |\n| all  | 1       | 2       | 3       | 4       | 5       | 6       | 7       | 8       |\n\n  游戏集合(collection)\n\n| 不限 | 舞力全开 | 马里奥 | 生化危机 | 炼金工房 | 最终幻想 | 塞尔达 | 宝可梦 | 勇者斗恶龙 | 模拟器 | 秋之回忆 | 第一方 | 体感健身 | 开放世界 | 儿童乐园 |\n| ---- | -------- | ------ | -------- | -------- | -------- | ------ | ------ | ---------- | ------ | -------- | ------ | -------- | -------- | -------- |\n| all  | 1        | 2      | 3        | 4        | 5        | 6      | 7      | 8          | 9      | 10       | 11     | 12       | 13       | 14       |",
        "location": "index.tsx",
        "module": () => import('@/routes/3kns/index.tsx')
      }
    },
    "name": "3k-Switch游戏库",
    "apiRoutes": {},
    "url": "www.3kns.com",
    "lang": "zh-CN"
  },
  "423down": {
    "routes": {
      "/:category{.+}?": {
        "path": "/:category{.+}?",
        "name": "423Down",
        "url": "423down.com",
        "maintainers": [
          "nczitzk"
        ],
        "example": "/423down",
        "parameters": {
          "category": "分类，默认为首页，可在对应分类页 URL 中找到"
        },
        "description": "::: tip\n  若订阅 [Android - 423Down](https://www.423down.com/apk)，网址为 `https://www.423down.com/apk`。截取 `https://www.423down.com/` 到末尾的部分 `apk` 作为参数填入，此时路由为 [`/423down/apk`](https://rsshub.app/423down/apk)。\n:::\n\n#### [安卓软件](https://www.423down.com/apk)\n\n| [安卓软件](https://www.423down.com/apk) |\n| --------------------------------------- |\n| [apk](https://rsshub.app/423down/apk)   |\n\n#### 电脑软件\n\n| [原创软件](https://www.423down.com/zd423) | [媒体播放](https://www.423down.com/multimedia)      | [网页浏览](https://www.423down.com/browser)   | [图形图像](https://www.423down.com/image) | [聊天软件](https://www.423down.com/im) |\n| ----------------------------------------- | --------------------------------------------------- | --------------------------------------------- | ----------------------------------------- | -------------------------------------- |\n| [zd423](https://rsshub.app/423down/zd423) | [multimedia](https://rsshub.app/423down/multimedia) | [browser](https://rsshub.app/423down/browser) | [image](https://rsshub.app/423down/image) | [im](https://rsshub.app/423down/im)    |\n\n| [办公软件](https://www.423down.com/work) | [上传下载](https://www.423down.com/down) | [实用软件](https://www.423down.com/softtool)    | [系统辅助](https://www.423down.com/systemsoft)      | [系统必备](https://www.423down.com/systemplus)      |\n| ---------------------------------------- | ---------------------------------------- | ----------------------------------------------- | --------------------------------------------------- | --------------------------------------------------- |\n| [work](https://rsshub.app/423down/work)  | [down](https://rsshub.app/423down/down)  | [softtool](https://rsshub.app/423down/softtool) | [systemsoft](https://rsshub.app/423down/systemsoft) | [systemplus](https://rsshub.app/423down/systemplus) |\n\n| [安全软件](https://www.423down.com/security)    | [补丁相关](https://www.423down.com/patch) | [硬件相关](https://www.423down.com/hardware)    |\n| ----------------------------------------------- | ----------------------------------------- | ----------------------------------------------- |\n| [security](https://rsshub.app/423down/security) | [patch](https://rsshub.app/423down/patch) | [hardware](https://rsshub.app/423down/hardware) |\n\n#### 操作系统\n\n| [Windows 11](https://www.423down.com/win11) | [Windows 10](https://www.423down.com/win10) | [Windows 7](https://www.423down.com/win7) | [Windows XP](https://www.423down.com/win7/winxp)    | [WinPE](https://www.423down.com/pe-system)        |\n| ------------------------------------------- | ------------------------------------------- | ----------------------------------------- | --------------------------------------------------- | ------------------------------------------------- |\n| [win11](https://rsshub.app/423down/win11)   | [win10](https://rsshub.app/423down/win10)   | [win7](https://rsshub.app/423down/win7)   | [win7/winxp](https://rsshub.app/423down/win7/winxp) | [pe-system](https://rsshub.app/423down/pe-system) |\n  ",
        "categories": [
          "program-update"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "423down.com/:category",
              "423down.com"
            ]
          },
          {
            "title": "首页",
            "source": [
              "www.423down.com"
            ],
            "target": "/"
          },
          {
            "title": "安卓软件",
            "source": [
              "www.423down.com/apk"
            ],
            "target": "/apk"
          },
          {
            "title": "电脑软件 - 原创软件",
            "source": [
              "www.423down.com/zd423"
            ],
            "target": "/zd423"
          },
          {
            "title": "电脑软件 - 媒体播放",
            "source": [
              "www.423down.com/multimedia"
            ],
            "target": "/multimedia"
          },
          {
            "title": "电脑软件 - 网页浏览",
            "source": [
              "www.423down.com/browser"
            ],
            "target": "/browser"
          },
          {
            "title": "电脑软件 - 图形图像",
            "source": [
              "www.423down.com/image"
            ],
            "target": "/image"
          },
          {
            "title": "电脑软件 - 聊天软件",
            "source": [
              "www.423down.com/im"
            ],
            "target": "/im"
          },
          {
            "title": "电脑软件 - 办公软件",
            "source": [
              "www.423down.com/work"
            ],
            "target": "/work"
          },
          {
            "title": "电脑软件 - 上传下载",
            "source": [
              "www.423down.com/down"
            ],
            "target": "/down"
          },
          {
            "title": "电脑软件 - 实用软件",
            "source": [
              "www.423down.com/softtool"
            ],
            "target": "/softtool"
          },
          {
            "title": "电脑软件 - 系统辅助",
            "source": [
              "www.423down.com/systemsoft"
            ],
            "target": "/systemsoft"
          },
          {
            "title": "电脑软件 - 系统必备",
            "source": [
              "www.423down.com/systemplus"
            ],
            "target": "/systemplus"
          },
          {
            "title": "电脑软件 - 安全软件",
            "source": [
              "www.423down.com/security"
            ],
            "target": "/security"
          },
          {
            "title": "电脑软件 - 补丁相关",
            "source": [
              "www.423down.com/patch"
            ],
            "target": "/patch"
          },
          {
            "title": "电脑软件 - 硬件相关",
            "source": [
              "www.423down.com/hardware"
            ],
            "target": "/hardware"
          },
          {
            "title": "操作系统 - Windows 11",
            "source": [
              "www.423down.com/win11"
            ],
            "target": "/win11"
          },
          {
            "title": "操作系统 - Windows 10",
            "source": [
              "www.423down.com/win10"
            ],
            "target": "/win10"
          },
          {
            "title": "操作系统 - Windows 7",
            "source": [
              "www.423down.com/win7"
            ],
            "target": "/win7"
          },
          {
            "title": "操作系统 - Windows XP",
            "source": [
              "www.423down.com/win7/winxp"
            ],
            "target": "/win7/winxp"
          },
          {
            "title": "操作系统 - WinPE",
            "source": [
              "www.423down.com/pe-system"
            ],
            "target": "/pe-system"
          }
        ],
        "location": "index.ts",
        "module": () => import('@/routes/423down/index.ts')
      }
    },
    "name": "423Down",
    "apiRoutes": {},
    "url": "423down.com",
    "categories": [
      "program-update"
    ],
    "description": "",
    "lang": "zh-CN"
  },
  "4gamers": {
    "routes": {
      "/": {
        "path": [
          "/",
          "/category/:category"
        ],
        "radar": [
          {
            "source": [
              "www.4gamers.com.tw/news",
              "www.4gamers.com.tw/"
            ],
            "target": ""
          }
        ],
        "name": "Unknown",
        "maintainers": [
          "TonyRL"
        ],
        "url": "www.4gamers.com.tw/news",
        "location": "category.ts",
        "module": () => import('@/routes/4gamers/category.ts')
      },
      "/category/:category": {
        "path": [
          "/",
          "/category/:category"
        ],
        "radar": [
          {
            "source": [
              "www.4gamers.com.tw/news",
              "www.4gamers.com.tw/"
            ],
            "target": ""
          }
        ],
        "name": "Unknown",
        "maintainers": [
          "TonyRL"
        ],
        "url": "www.4gamers.com.tw/news",
        "location": "category.ts",
        "module": () => import('@/routes/4gamers/category.ts')
      },
      "/tag/:tag": {
        "path": "/tag/:tag",
        "categories": [
          "game"
        ],
        "example": "/4gamers/tag/限時免費",
        "parameters": {
          "tag": "标签名，可在标签 URL 中找到"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.4gamers.com.tw/news/tag/:tag"
            ]
          }
        ],
        "name": "标签",
        "maintainers": [
          "hoilc"
        ],
        "url": "www.4gamers.com.tw/news",
        "location": "tag.ts",
        "module": () => import('@/routes/4gamers/tag.ts')
      },
      "/topic/:topic": {
        "path": "/topic/:topic",
        "categories": [
          "game"
        ],
        "example": "/4gamers/topic/gentlemen-topic",
        "parameters": {
          "topic": "主题，可在首页上方页面内找到"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.4gamers.com.tw/news/option-cfg/:topic"
            ]
          }
        ],
        "name": "主題",
        "maintainers": [
          "bestpika"
        ],
        "url": "www.4gamers.com.tw/news",
        "location": "topic.ts",
        "module": () => import('@/routes/4gamers/topic.ts')
      }
    },
    "name": "4Gamers",
    "apiRoutes": {},
    "url": "www.4gamers.com.tw",
    "lang": "zh-TW"
  },
  "4khd": {
    "routes": {
      "/category/:category": {
        "path": "/category/:category",
        "categories": [
          "picture"
        ],
        "example": "/4khd/category/cosplay",
        "parameters": {
          "category": "Category"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false,
          "nsfw": true
        },
        "radar": [
          {
            "source": [
              "www.4khd.com/pages/:category"
            ],
            "target": "/category/:category"
          }
        ],
        "name": "Category",
        "maintainers": [
          "AiraNadih"
        ],
        "url": "www.4khd.com/",
        "location": "category.ts",
        "module": () => import('@/routes/4khd/category.ts')
      },
      "/": {
        "path": "/",
        "categories": [
          "picture"
        ],
        "example": "/4khd",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false,
          "nsfw": true
        },
        "radar": [
          {
            "source": [
              "www.4khd.com/"
            ],
            "target": ""
          }
        ],
        "name": "Latest",
        "maintainers": [
          "AiraNadih"
        ],
        "url": "www.4khd.com/",
        "location": "latest.ts",
        "module": () => import('@/routes/4khd/latest.ts')
      }
    },
    "name": "4KHD",
    "apiRoutes": {},
    "url": "www.4khd.com",
    "description": "4KHD - HD Beautiful Girls",
    "lang": "en"
  },
  "4ksj": {
    "routes": {
      "/:id?": {
        "path": "/:id?",
        "name": "分类",
        "url": "4ksj.com",
        "maintainers": [
          "nczitzk"
        ],
        "example": "/4ksj/4k-uhd-1",
        "parameters": {
          "id": "分类 id，默认为最新4K电影"
        },
        "description": "::: tip\n  若订阅 [最新 4K 电影](https://www.4ksj.com/4k-uhd-1.html)，网址为 `https://www.4ksj.com/4k-uhd-1.html`。截取 `https://www.4ksj.com/` 到末尾 `.html` 的部分 `4k-uhd-1` 作为参数，此时路由为 [`/4ksj/4k-uhd-1`](https://rsshub.app/4ksj/4k-uhd-1)。\n\n  若订阅子分类 [Dolby Vision 动作 4K 电影](https://www.4ksj.com/4k-uhd-s7-display-3-dytypes-1-1.html)，网址为 `https://www.4ksj.com/4k-uhd-s7-display-3-dytypes-1-1.html`。截取 `https://www.4ksj.com/forum-` 到末尾 `.html` 的部分 `4kdianying-s7-dianyingbiaozhun-3-dytypes-9-1` 作为参数，此时路由为 [`/4ksj/4k-uhd-s7-display-3-dytypes-1-1`](https://rsshub.app/4ksj/4k-uhd-s7-display-3-dytypes-1-1)。\n:::",
        "categories": [
          "multimedia"
        ],
        "location": "forum.tsx",
        "module": () => import('@/routes/4ksj/forum.tsx')
      }
    },
    "name": "4k 世界",
    "apiRoutes": {},
    "url": "4ksj.com",
    "lang": "zh-CN"
  },
  "4kup": {
    "routes": {
      "/category/:category": {
        "path": "/category/:category",
        "categories": [
          "picture"
        ],
        "example": "/4kup/category/coser",
        "parameters": {
          "category": "Category"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false,
          "nsfw": true
        },
        "radar": [
          {
            "source": [
              "4kup.net/category/:category"
            ],
            "target": "/category/:category"
          }
        ],
        "name": "Category",
        "maintainers": [
          "AiraNadih"
        ],
        "url": "4kup.net/",
        "location": "category.ts",
        "module": () => import('@/routes/4kup/category.ts')
      },
      "/": {
        "path": "/",
        "categories": [
          "picture"
        ],
        "example": "/4kup",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false,
          "nsfw": true
        },
        "radar": [
          {
            "source": [
              "4kup.net/"
            ],
            "target": ""
          }
        ],
        "name": "Latest",
        "maintainers": [
          "AiraNadih"
        ],
        "url": "4kup.net/",
        "location": "latest.ts",
        "module": () => import('@/routes/4kup/latest.ts')
      },
      "/popular/:period": {
        "path": "/popular/:period",
        "categories": [
          "picture"
        ],
        "example": "/4kup/popular/7",
        "parameters": {
          "period": "Days"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false,
          "nsfw": true
        },
        "radar": [
          {
            "source": [
              "4kup.net/:period"
            ],
            "target": "/popular/:period"
          }
        ],
        "name": "Popular",
        "maintainers": [
          "AiraNadih"
        ],
        "url": "4kup.net/",
        "location": "popular.ts",
        "module": () => import('@/routes/4kup/popular.ts')
      },
      "/tag/:tag": {
        "path": "/tag/:tag",
        "categories": [
          "picture"
        ],
        "example": "/4kup/tag/asian",
        "parameters": {
          "tag": "Tag"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false,
          "nsfw": true
        },
        "radar": [
          {
            "source": [
              "4kup.net/tag/:tag"
            ],
            "target": "/tag/:tag"
          }
        ],
        "name": "Tag",
        "maintainers": [
          "AiraNadih"
        ],
        "url": "4kup.net/",
        "location": "tag.ts",
        "module": () => import('@/routes/4kup/tag.ts')
      }
    },
    "name": "4KUP",
    "apiRoutes": {},
    "url": "4kup.net",
    "description": "4KUP - Beautiful Girls Collection",
    "lang": "en"
  },
  "500px": {
    "routes": {
      "/tribe/set/:id": {
        "path": "/tribe/set/:id",
        "categories": [
          "picture"
        ],
        "view": 2,
        "example": "/500px/tribe/set/f5de0b8aa6d54ec486f5e79616418001",
        "parameters": {
          "id": "部落 ID"
        },
        "name": "部落影集",
        "maintainers": [
          "TonyRL"
        ],
        "location": "tribe-set.tsx",
        "module": () => import('@/routes/500px/tribe-set.tsx')
      }
    },
    "name": "500px 摄影社区",
    "url": "500px.com.cn",
    "lang": "zh-CN"
  },
  "50forum": {
    "routes": {
      "/": {
        "path": "/",
        "radar": [
          {
            "source": [
              "www.50forum.org.cn/portal/list/index.html?id=6",
              "50forum.org.cn/"
            ],
            "target": ""
          }
        ],
        "name": "Unknown",
        "maintainers": [
          "sddiky"
        ],
        "url": "https://www.50forum.org.cn/portal/list/index.html?id=6",
        "location": "zhuanjia.ts",
        "module": () => import('@/routes/50forum/zhuanjia.ts')
      }
    },
    "name": "经济 50 人论坛",
    "url": "50forum.org.cn",
    "lang": "zh-CN"
  },
  "51cto": {
    "routes": {
      "/index/recommend": {
        "path": "/index/recommend",
        "categories": [
          "programming"
        ],
        "example": "/51cto/index/recommend",
        "radar": [
          {
            "source": [
              "51cto.com/"
            ]
          }
        ],
        "name": "推荐",
        "maintainers": [
          "cnkmmk",
          "ovo-tim"
        ],
        "url": "51cto.com/",
        "location": "recommend.ts",
        "module": () => import('@/routes/51cto/recommend.ts')
      }
    },
    "name": "51CTO",
    "url": "51cto.com",
    "lang": "zh-CN"
  },
  "51read": {
    "routes": {
      "/article/:id": {
        "path": "/article/:id",
        "name": "章节",
        "url": "m.51read.org",
        "maintainers": [
          "lazwa34"
        ],
        "example": "/51read/article/152685",
        "parameters": {
          "id": "小说 id, 可在对应小说页 URL 中找到"
        },
        "categories": [
          "reading"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "m.51read.org/xiaoshuo/:id"
            ],
            "target": "/article/:id"
          },
          {
            "source": [
              "51read.org/xiaoshuo/:id"
            ],
            "target": "/article/:id"
          }
        ],
        "location": "article.ts",
        "module": () => import('@/routes/51read/article.ts')
      }
    },
    "name": "51Read",
    "apiRoutes": {},
    "url": "m.51read.org",
    "lang": "zh-CN"
  },
  "52hrtt": {
    "routes": {
      "/:area?/:type?": {
        "path": "/:area?/:type?",
        "categories": [
          "new-media"
        ],
        "example": "/52hrtt/global",
        "parameters": {
          "area": "地区，默认为全球",
          "type": "分类，默认为新闻"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "新闻",
        "maintainers": [
          "nczitzk"
        ],
        "description": "地区和分类皆可在浏览器地址栏中找到，下面是一个例子。\n\n  访问华人头条全球站的国际分类，会跳转到 `https://www.52hrtt.com/global/n/w?infoTypeId=A1459145516533`。其中 `global` 即为 **全球** 对应的地区代码，`A1459145516533` 即为 **国际** 对应的分类代码。",
        "location": "index.ts",
        "module": () => import('@/routes/52hrtt/index.ts')
      },
      "/symposium/:id?/:classId?": {
        "path": "/symposium/:id?/:classId?",
        "categories": [
          "new-media"
        ],
        "example": "/52hrtt/symposium/F1626082387819",
        "parameters": {
          "id": "专题 id",
          "classId": "子分类 id"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "52hrtt.com/global/n/w/symposium/:id"
            ],
            "target": "/symposium/:id"
          }
        ],
        "name": "专题",
        "maintainers": [
          "nczitzk"
        ],
        "description": "专题 id 和 子分类 id 皆可在浏览器地址栏中找到，下面是一个例子。\n\n  访问 “邱毅看平潭” 专题，会跳转到 `https://www.52hrtt.com/global/n/w/symposium/F1626082387819`。其中 `F1626082387819` 即为 **专题 id** 对应的地区代码。\n\n::: tip\n  更多的专题可以点击 [这里](https://www.52hrtt.com/global/n/w/symposium)\n:::",
        "location": "symposium.ts",
        "module": () => import('@/routes/52hrtt/symposium.ts')
      }
    },
    "name": "52hrtt 华人头条",
    "apiRoutes": {},
    "url": "52hrtt.com",
    "lang": "zh-CN"
  },
  "56kog": {
    "routes": {
      "/class/:category?": {
        "path": "/class/:category?",
        "categories": [
          "reading"
        ],
        "example": "/56kog/class/1_1",
        "parameters": {
          "category": "分类，见下表，默认为玄幻魔法"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "分类",
        "maintainers": [
          "nczitzk"
        ],
        "description": "| [玄幻魔法](https://www.56kog.com/class/1_1.html) | [武侠修真](https://www.56kog.com/class/2_1.html) | [历史军事](https://www.56kog.com/class/4_1.html) | [侦探推理](https://www.56kog.com/class/5_1.html) | [网游动漫](https://www.56kog.com/class/6_1.html) |\n| ------------------------------------------------ | ------------------------------------------------ | ------------------------------------------------ | ------------------------------------------------ | ------------------------------------------------ |\n| 1_1                                             | 2_1                                             | 4_1                                             | 5_1                                             | 6_1                                             |\n\n| [恐怖灵异](https://www.56kog.com/class/8_1.html) | [都市言情](https://www.56kog.com/class/3_1.html) | [科幻](https://www.56kog.com/class/7_1.html) | [女生小说](https://www.56kog.com/class/9_1.html) | [其他](https://www.56kog.com/class/10_1.html) |\n| ------------------------------------------------ | ------------------------------------------------ | -------------------------------------------- | ------------------------------------------------ | --------------------------------------------- |\n| 8_1                                             | 3_1                                             | 7_1                                         | 9_1                                             | 10_1                                         |",
        "location": "class.ts",
        "module": () => import('@/routes/56kog/class.ts')
      },
      "/top/:category?": {
        "path": "/top/:category?",
        "categories": [
          "reading"
        ],
        "example": "/56kog/top/weekvisit",
        "parameters": {
          "category": "分类，见下表，默认为周点击榜"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "榜单",
        "maintainers": [
          "nczitzk"
        ],
        "description": "| [周点击榜](https://www.56kog.com/top/weekvisit.html) | [总收藏榜](https://www.56kog.com/top/goodnum.html) | [最新 入库](https://www.56kog.com/top/postdate.html) |\n| ---------------------------------------------------- | -------------------------------------------------- | ---------------------------------------------------- |\n| weekvisit                                            | goodnum                                            | postdate                                             |",
        "location": "top.ts",
        "module": () => import('@/routes/56kog/top.ts')
      }
    },
    "name": "明月中文网",
    "apiRoutes": {},
    "url": "56kog.com",
    "lang": "zh-CN"
  },
  "5eplay": {
    "routes": {
      "/article": {
        "path": "/article",
        "categories": [
          "game"
        ],
        "example": "/5eplay/article",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "csgo.5eplay.com/",
              "csgo.5eplay.com/article"
            ]
          }
        ],
        "name": "新闻列表",
        "maintainers": [
          "Dlouxgit"
        ],
        "url": "csgo.5eplay.com/",
        "location": "index.ts",
        "module": () => import('@/routes/5eplay/index.ts')
      }
    },
    "name": "5EPLAY",
    "apiRoutes": {},
    "url": "csgo.5eplay.com",
    "lang": "zh-CN"
  },
  "5music": {
    "routes": {
      "/new-releases/:category?": {
        "path": "/new-releases/:category?",
        "categories": [
          "shopping"
        ],
        "example": "/5music/new-releases",
        "parameters": {
          "category": "Category, see below, defaults to all"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.5music.com.tw/New_releases.asp",
              "www.5music.com.tw/"
            ],
            "target": "/new-releases"
          }
        ],
        "name": "新貨上架",
        "maintainers": [
          "gideonsenku"
        ],
        "description": "Categories:\n| 華語 | 西洋 | 東洋 | 韓語 | 古典 |\n| ---- | ---- | ---- | ---- | ---- |\n| A | B | F | M | D |",
        "url": "www.5music.com.tw/New_releases.asp",
        "location": "index.ts",
        "module": () => import('@/routes/5music/index.ts')
      }
    },
    "name": "五大唱片",
    "apiRoutes": {},
    "url": "5music.com.tw",
    "lang": "zh-TW",
    "categories": [
      "shopping"
    ],
    "description": "五大唱片是台湾五大唱片股份有限公司的简称，成立于1990年，是台湾最大的唱片公司之一。"
  },
  "69shu": {
    "routes": {
      "/article/:id": {
        "path": "/article/:id",
        "name": "章节",
        "url": "www.69shuba.cx",
        "maintainers": [
          "eternasuno"
        ],
        "example": "/69shu/article/47117",
        "parameters": {
          "id": "小说 id, 可在对应小说页 URL 中找到"
        },
        "categories": [
          "reading"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.69shuba.cx/book/:id.htm"
            ],
            "target": "/article/:id"
          }
        ],
        "location": "article.ts",
        "module": () => import('@/routes/69shu/article.ts')
      }
    },
    "name": "69书吧",
    "apiRoutes": {},
    "url": "69shuba.cx",
    "lang": "zh-CN"
  },
  "6park": {
    "routes": {
      "/index/:id?/:type?/:keyword?": {
        "path": "/index/:id?/:type?/:keyword?",
        "name": "首页",
        "maintainers": [
          "nczitzk",
          "cscnk52"
        ],
        "example": "/6park/index",
        "parameters": {
          "id": "分站，见下表，默认为史海钩沉",
          "type": "类型，可选值为 gold、type，默认为空",
          "keyword": "关键词，可选，默认为空"
        },
        "radar": [
          {
            "source": [
              "club.6parkbbs.com/:id/index.php",
              "club.6parkbbs.com/"
            ],
            "target": "/:id?"
          }
        ],
        "description": "| 婚姻家庭 | 魅力时尚 | 女性频道 | 生活百态 | 美食厨房 | 非常影音 | 车迷沙龙 | 游戏天地 | 卡通漫画 | 体坛纵横 | 运动健身 | 电脑前线 | 数码家电 | 旅游风向 | 摄影部落 | 奇珍异宝 | 笑口常开 | 娱乐八卦 | 吃喝玩乐 | 文化长廊 | 军事纵横 | 百家论坛 | 科技频道 | 爱子情怀 | 健康人生 | 博论天下 | 史海钩沉 | 网际谈兵 | 经济观察 | 谈股论金 | 杂论闲侃 | 唯美乐园 | 学习园地 | 命理玄机 | 宠物情缘 | 网络歌坛 | 音乐殿堂 | 情感世界 |\n|----------|----------|----------|----------|----------|----------|----------|----------|----------|----------|----------|----------|----------|----------|----------|----------|----------|----------|----------|----------|----------|----------|----------|----------|----------|----------|----------|----------|----------|----------|----------|----------|----------|----------|----------|----------|----------|----------|\n| life9    | life1    | chan10   | life2    | life6    | fr       | enter7   | enter3   | enter6   | enter5   | sport    | know1    | chan6    | life7    | chan8    | page     | enter1   | enter8   | netstar  | life10   | nz       | other    | chan2    | chan5    | life5    | bolun    | chan1    | military | finance  | chan4    | pk       | gz1      | gz2      | gz3      | life8    | chan7    | enter4   | life3    |",
        "location": "index.ts",
        "module": () => import('@/routes/6park/index.ts')
      },
      "/news/:site?/:id?/:keyword?": {
        "path": "/news/:site?/:id?/:keyword?",
        "radar": [
          {
            "source": [
              "club.6parkbbs.com/:id/index.php",
              "club.6parkbbs.com/"
            ],
            "target": "/:id?"
          }
        ],
        "name": "新闻栏目",
        "maintainers": [
          "nczitzk",
          "cscnk52"
        ],
        "parameters": {
          "site": "分站，可选newspark、local，默认为 newspark",
          "id": "栏目 id，可选，默认为空",
          "keyword": "关键词，可选，默认为空"
        },
        "description": "::: tip 提示\n若订阅 [时政](https://www.6parknews.com/newspark/index.php?type=1)，其网址为 <https://www.6parknews.com/newspark/index.php?type=1>，其中 `newspark` 为分站，`1` 为栏目 id。\n若订阅 [美国](https://local.6parknews.com/index.php?type_id=1)，其网址为 <https://local.6parknews.com/index.php?type_id=1>，其中 `local` 为分站，`1` 为栏目 id。\n:::",
        "location": "news.ts",
        "module": () => import('@/routes/6park/news.ts')
      }
    },
    "name": "留园网",
    "apiRoutes": {},
    "url": "club.6parkbbs.com",
    "lang": "zh-CN"
  },
  "6v123": {
    "routes": {
      "/:category{.+}?": {
        "path": "/:category{.+}?",
        "name": "分类",
        "url": "www.hao6v.me",
        "maintainers": [
          "nczitzk"
        ],
        "example": "/6v123/dy",
        "parameters": {
          "category": {
            "description": "分类，默认为 `dy`，即最新电影，可在对应分类页 URL 中找到",
            "options": [
              {
                "label": "最新电影",
                "value": "dy"
              },
              {
                "label": "国语配音电影",
                "value": "gydy"
              },
              {
                "label": "动漫新番",
                "value": "zydy"
              },
              {
                "label": "经典高清",
                "value": "gq"
              },
              {
                "label": "动画电影",
                "value": "jddy"
              },
              {
                "label": "3D 电影",
                "value": "3D"
              },
              {
                "label": "真人秀",
                "value": "shoujidianyingmp4"
              },
              {
                "label": "国剧",
                "value": "dlz"
              },
              {
                "label": "日韩剧",
                "value": "rj"
              },
              {
                "label": "欧美剧",
                "value": "mj"
              },
              {
                "label": "综艺节目",
                "value": "zy"
              },
              {
                "label": "港台电影",
                "value": "s/gangtaidianying"
              },
              {
                "label": "日韩电影",
                "value": "s/jingdiandianying"
              },
              {
                "label": "喜剧",
                "value": "s/xiju"
              },
              {
                "label": "动作",
                "value": "s/dongzuo"
              },
              {
                "label": "爱情",
                "value": "s/aiqing"
              },
              {
                "label": "科幻",
                "value": "s/kehuan"
              },
              {
                "label": "奇幻",
                "value": "s/qihuan"
              },
              {
                "label": "神秘",
                "value": "s/shenmi"
              },
              {
                "label": "幻想",
                "value": "s/huanxiang"
              },
              {
                "label": "恐怖",
                "value": "s/kongbu"
              },
              {
                "label": "战争",
                "value": "s/zhanzheng"
              },
              {
                "label": "冒险",
                "value": "s/maoxian"
              },
              {
                "label": "惊悚",
                "value": "s/jingsong"
              },
              {
                "label": "剧情",
                "value": "s/juqingpian"
              },
              {
                "label": "传记",
                "value": "s/zhuanji"
              },
              {
                "label": "历史",
                "value": "s/lishi"
              },
              {
                "label": "纪录",
                "value": "s/jilu"
              },
              {
                "label": "印度电影",
                "value": "s/yindudianying"
              },
              {
                "label": "国产电影",
                "value": "s/guochandianying"
              },
              {
                "label": "欧洲电影",
                "value": "s/xijudianying"
              }
            ]
          }
        },
        "description": "::: tip\n订阅 [最新电影](https://www.hao6v.me/dy/)，其源网址为 `https://www.hao6v.me/dy/`，请参考该 URL 指定部分构成参数，此时路由为 [`/6v123/dy`](https://rsshub.app/6v123/dy)。\n:::\n\n<details>\n  <summary>更多分类</summary>\n\n| 分类                                                 | ID                                                                |\n| ---------------------------------------------------- | ----------------------------------------------------------------- |\n| [最新电影](https://www.hao6v.me/dy/)                 | [dy](https://rsshub.app/6v123/dy)                                 |\n| [国语配音电影](https://www.hao6v.me/gydy/)           | [gydy](https://rsshub.app/6v123/gydy)                             |\n| [动漫新番](https://www.hao6v.me/zydy/)               | [zydy](https://rsshub.app/6v123/zydy)                             |\n| [经典高清](https://www.hao6v.me/gq/)                 | [gq](https://rsshub.app/6v123/gq)                                 |\n| [动画电影](https://www.hao6v.me/jddy/)               | [jddy](https://rsshub.app/6v123/jddy)                             |\n| [3D 电影](https://www.hao6v.me/3D/)                  | [3D](https://rsshub.app/6v123/3D)                                 |\n| [真人秀](https://www.hao6v.me/shoujidianyingmp4/)    | [shoujidianyingmp4](https://rsshub.app/6v123/shoujidianyingmp4)   |\n| [国剧](https://www.hao6v.me/dlz/)                    | [dlz](https://rsshub.app/6v123/dlz)                               |\n| [日韩剧](https://www.hao6v.me/rj/)                   | [rj](https://rsshub.app/6v123/rj)                                 |\n| [欧美剧](https://www.hao6v.me/mj/)                   | [mj](https://rsshub.app/6v123/mj)                                 |\n| [综艺节目](https://www.hao6v.me/zy/)                 | [zy](https://rsshub.app/6v123/zy)                                 |\n| [港台电影](https://www.hao6v.me/s/gangtaidianying/)  | [s/gangtaidianying](https://rsshub.app/6v123/s/gangtaidianying)   |\n| [日韩电影](https://www.hao6v.me/s/jingdiandianying/) | [s/jingdiandianying](https://rsshub.app/6v123/s/jingdiandianying) |\n| [喜剧](https://www.hao6v.me/s/xiju/)                 | [s/xiju](https://rsshub.app/6v123/s/xiju)                         |\n| [动作](https://www.hao6v.me/s/dongzuo/)              | [s/dongzuo](https://rsshub.app/6v123/s/dongzuo)                   |\n| [爱情](https://www.hao6v.me/s/aiqing/)               | [s/aiqing](https://rsshub.app/6v123/s/aiqing)                     |\n| [科幻](https://www.hao6v.me/s/kehuan/)               | [s/kehuan](https://rsshub.app/6v123/s/kehuan)                     |\n| [奇幻](https://www.hao6v.me/s/qihuan/)               | [s/qihuan](https://rsshub.app/6v123/s/qihuan)                     |\n| [神秘](https://www.hao6v.me/s/shenmi/)               | [s/shenmi](https://rsshub.app/6v123/s/shenmi)                     |\n| [幻想](https://www.hao6v.me/s/huanxiang/)            | [s/huanxiang](https://rsshub.app/6v123/s/huanxiang)               |\n| [恐怖](https://www.hao6v.me/s/kongbu/)               | [s/kongbu](https://rsshub.app/6v123/s/kongbu)                     |\n| [战争](https://www.hao6v.me/s/zhanzheng/)            | [s/zhanzheng](https://rsshub.app/6v123/s/zhanzheng)               |\n| [冒险](https://www.hao6v.me/s/maoxian/)              | [s/maoxian](https://rsshub.app/6v123/s/maoxian)                   |\n| [惊悚](https://www.hao6v.me/s/jingsong/)             | [s/jingsong](https://rsshub.app/6v123/s/jingsong)                 |\n| [剧情](https://www.hao6v.me/s/juqingpian/)           | [s/juqingpian](https://rsshub.app/6v123/s/juqingpian)             |\n| [传记](https://www.hao6v.me/s/zhuanji/)              | [s/zhuanji](https://rsshub.app/6v123/s/zhuanji)                   |\n| [历史](https://www.hao6v.me/s/lishi/)                | [s/lishi](https://rsshub.app/6v123/s/lishi)                       |\n| [纪录](https://www.hao6v.me/s/jilu/)                 | [s/jilu](https://rsshub.app/6v123/s/jilu)                         |\n| [印度电影](https://www.hao6v.me/s/yindudianying/)    | [s/yindudianying](https://rsshub.app/6v123/s/yindudianying)       |\n| [国产电影](https://www.hao6v.me/s/guochandianying/)  | [s/guochandianying](https://rsshub.app/6v123/s/guochandianying)   |\n| [欧洲电影](https://www.hao6v.me/s/xijudianying/)     | [s/xijudianying](https://rsshub.app/6v123/s/xijudianying)         |\n\n</details>\n",
        "categories": [
          "multimedia"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": true,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.hao6v.me/:category"
            ],
            "target": "/:category"
          },
          {
            "title": "最新电影",
            "source": [
              "www.hao6v.me/dy/"
            ],
            "target": "/dy"
          },
          {
            "title": "国语配音电影",
            "source": [
              "www.hao6v.me/gydy/"
            ],
            "target": "/gydy"
          },
          {
            "title": "动漫新番",
            "source": [
              "www.hao6v.me/zydy/"
            ],
            "target": "/zydy"
          },
          {
            "title": "经典高清",
            "source": [
              "www.hao6v.me/gq/"
            ],
            "target": "/gq"
          },
          {
            "title": "动画电影",
            "source": [
              "www.hao6v.me/jddy/"
            ],
            "target": "/jddy"
          },
          {
            "title": "3D电影",
            "source": [
              "www.hao6v.me/3D/"
            ],
            "target": "/3D"
          },
          {
            "title": "真人秀",
            "source": [
              "www.hao6v.me/shoujidianyingmp4/"
            ],
            "target": "/shoujidianyingmp4"
          },
          {
            "title": "国剧",
            "source": [
              "www.hao6v.me/dlz/"
            ],
            "target": "/dlz"
          },
          {
            "title": "日韩剧",
            "source": [
              "www.hao6v.me/rj/"
            ],
            "target": "/rj"
          },
          {
            "title": "欧美剧",
            "source": [
              "www.hao6v.me/mj/"
            ],
            "target": "/mj"
          },
          {
            "title": "综艺节目",
            "source": [
              "www.hao6v.me/zy/"
            ],
            "target": "/zy"
          },
          {
            "title": "港台电影",
            "source": [
              "www.hao6v.me/s/gangtaidianying/"
            ],
            "target": "/s/gangtaidianying"
          },
          {
            "title": "日韩电影",
            "source": [
              "www.hao6v.me/s/jingdiandianying/"
            ],
            "target": "/s/jingdiandianying"
          },
          {
            "title": "喜剧",
            "source": [
              "www.hao6v.me/s/xiju/"
            ],
            "target": "/s/xiju"
          },
          {
            "title": "动作",
            "source": [
              "www.hao6v.me/s/dongzuo/"
            ],
            "target": "/s/dongzuo"
          },
          {
            "title": "爱情",
            "source": [
              "www.hao6v.me/s/aiqing/"
            ],
            "target": "/s/aiqing"
          },
          {
            "title": "科幻",
            "source": [
              "www.hao6v.me/s/kehuan/"
            ],
            "target": "/s/kehuan"
          },
          {
            "title": "奇幻",
            "source": [
              "www.hao6v.me/s/qihuan/"
            ],
            "target": "/s/qihuan"
          },
          {
            "title": "神秘",
            "source": [
              "www.hao6v.me/s/shenmi/"
            ],
            "target": "/s/shenmi"
          },
          {
            "title": "幻想",
            "source": [
              "www.hao6v.me/s/huanxiang/"
            ],
            "target": "/s/huanxiang"
          },
          {
            "title": "恐怖",
            "source": [
              "www.hao6v.me/s/kongbu/"
            ],
            "target": "/s/kongbu"
          },
          {
            "title": "战争",
            "source": [
              "www.hao6v.me/s/zhanzheng/"
            ],
            "target": "/s/zhanzheng"
          },
          {
            "title": "冒险",
            "source": [
              "www.hao6v.me/s/maoxian/"
            ],
            "target": "/s/maoxian"
          },
          {
            "title": "惊悚",
            "source": [
              "www.hao6v.me/s/jingsong/"
            ],
            "target": "/s/jingsong"
          },
          {
            "title": "剧情",
            "source": [
              "www.hao6v.me/s/juqingpian/"
            ],
            "target": "/s/juqingpian"
          },
          {
            "title": "传记",
            "source": [
              "www.hao6v.me/s/zhuanji/"
            ],
            "target": "/s/zhuanji"
          },
          {
            "title": "历史",
            "source": [
              "www.hao6v.me/s/lishi/"
            ],
            "target": "/s/lishi"
          },
          {
            "title": "纪录",
            "source": [
              "www.hao6v.me/s/jilu/"
            ],
            "target": "/s/jilu"
          },
          {
            "title": "印度电影",
            "source": [
              "www.hao6v.me/s/yindudianying/"
            ],
            "target": "/s/yindudianying"
          },
          {
            "title": "国产电影",
            "source": [
              "www.hao6v.me/s/guochandianying/"
            ],
            "target": "/s/guochandianying"
          },
          {
            "title": "欧洲电影",
            "source": [
              "www.hao6v.me/s/xijudianying/"
            ],
            "target": "/s/xijudianying"
          }
        ],
        "view": 0,
        "location": "index.ts",
        "module": () => import('@/routes/6v123/index.ts')
      },
      "/latestMovies": {
        "path": "/latestMovies",
        "categories": [
          "multimedia"
        ],
        "example": "/6v123/latestMovies",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": true,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "hao6v.com/",
              "hao6v.com/gvod/zx.html"
            ]
          }
        ],
        "name": "最新电影",
        "maintainers": [
          "tc9011"
        ],
        "url": "hao6v.com/",
        "location": "latest-movies.ts",
        "module": () => import('@/routes/6v123/latest-movies.ts')
      },
      "/latestTVSeries": {
        "path": "/latestTVSeries",
        "categories": [
          "multimedia"
        ],
        "example": "/6v123/latestTVSeries",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": true,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "hao6v.com/",
              "hao6v.com/gvod/dsj.html"
            ]
          }
        ],
        "name": "最新电视剧",
        "maintainers": [
          "tc9011"
        ],
        "url": "hao6v.com/",
        "location": "latest-tvseries.ts",
        "module": () => import('@/routes/6v123/latest-tvseries.ts')
      }
    },
    "name": "6v 电影",
    "apiRoutes": {},
    "url": "hao6v.cc",
    "categories": [
      "multimedia"
    ],
    "lang": "zh-CN"
  },
  "78dm": {
    "routes": {
      "/:category{.+}?": {
        "path": "/:category{.+}?",
        "name": "分类",
        "url": "78dm.net",
        "maintainers": [
          "nczitzk"
        ],
        "example": "/78dm/news",
        "parameters": {
          "category": "分类，默认为 `news`，即新品速递，可在对应分类页 URL 中找到"
        },
        "description": "::: tip\n  若订阅 [新品速递](https://www.78dm.net/news)，网址为 `https://www.78dm.net/news`。截取 `https://www.78dm.net/` 到末尾的部分 `news` 作为参数填入，此时路由为 [`/78dm/news`](https://rsshub.app/78dm/news)。\n\n  若订阅 [精彩评测 - 变形金刚](https://www.78dm.net/eval_list/109/0/0/1.html)，网址为 `https://www.78dm.net/eval_list/109/0/0/1.html`。截取 `https://www.78dm.net/` 到末尾 `.html` 的部分 `eval_list/109/0/0/1` 作为参数填入，此时路由为 [`/78dm/eval_list/109/0/0/1`](https://rsshub.app/78dm/eval_list/109/0/0/1)。\n:::\n\n<details>\n<summary>更多分类</summary>\n\n#### [新品速递](https://www.78dm.net/news)\n\n| 分类                                                           | ID                                                                     |\n| -------------------------------------------------------------- | ---------------------------------------------------------------------- |\n| [全部](https://www.78dm.net/news/0/0/0/0/0/0/0/1.html)         | [news/0/0/0/0/0/0/0/1](https://rsshub.app/78dm/news/0/0/0/0/0/0/0/1)   |\n| [变形金刚](https://www.78dm.net/news/3/0/0/0/0/0/0/1.html)     | [news/3/0/0/0/0/0/0/1](https://rsshub.app/78dm/news/3/0/0/0/0/0/0/1)   |\n| [高达](https://www.78dm.net/news/4/0/0/0/0/0/0/1.html)         | [news/4/0/0/0/0/0/0/1](https://rsshub.app/78dm/news/4/0/0/0/0/0/0/1)   |\n| [圣斗士](https://www.78dm.net/news/2/0/0/0/0/0/0/1.html)       | [news/2/0/0/0/0/0/0/1](https://rsshub.app/78dm/news/2/0/0/0/0/0/0/1)   |\n| [海贼王](https://www.78dm.net/news/8/0/0/0/0/0/0/1.html)       | [news/8/0/0/0/0/0/0/1](https://rsshub.app/78dm/news/8/0/0/0/0/0/0/1)   |\n| [PVC 手办](https://www.78dm.net/news/0/5/0/0/0/0/0/1.html)     | [news/0/5/0/0/0/0/0/1](https://rsshub.app/78dm/news/0/5/0/0/0/0/0/1)   |\n| [拼装模型](https://www.78dm.net/news/0/1/0/0/0/0/0/1.html)     | [news/0/1/0/0/0/0/0/1](https://rsshub.app/78dm/news/0/1/0/0/0/0/0/1)   |\n| [机甲成品](https://www.78dm.net/news/0/2/0/0/0/0/0/1.html)     | [news/0/2/0/0/0/0/0/1](https://rsshub.app/78dm/news/0/2/0/0/0/0/0/1)   |\n| [特摄](https://www.78dm.net/news/0/3/0/0/0/0/0/1.html)         | [news/0/3/0/0/0/0/0/1](https://rsshub.app/78dm/news/0/3/0/0/0/0/0/1)   |\n| [美系](https://www.78dm.net/news/0/4/0/0/0/0/0/1.html)         | [news/0/4/0/0/0/0/0/1](https://rsshub.app/78dm/news/0/4/0/0/0/0/0/1)   |\n| [GK](https://www.78dm.net/news/0/6/0/0/0/0/0/1.html)           | [news/0/6/0/0/0/0/0/1](https://rsshub.app/78dm/news/0/6/0/0/0/0/0/1)   |\n| [扭蛋盒蛋食玩](https://www.78dm.net/news/0/7/0/0/0/0/0/1.html) | [news/0/7/0/0/0/0/0/1](https://rsshub.app/78dm/news/0/7/0/0/0/0/0/1)   |\n| [其他](https://www.78dm.net/news/0/8/0/0/0/0/0/1.html)         | [news/0/8/0/0/0/0/0/1](https://rsshub.app/78dm/news/0/8/0/0/0/0/0/1)   |\n| [综合](https://www.78dm.net/news/0/9/0/0/0/0/0/1.html)         | [news/0/9/0/0/0/0/0/1](https://rsshub.app/78dm/news/0/9/0/0/0/0/0/1)   |\n| [军模](https://www.78dm.net/news/0/10/0/0/0/0/0/1.html)        | [news/0/10/0/0/0/0/0/1](https://rsshub.app/78dm/news/0/10/0/0/0/0/0/1) |\n| [民用](https://www.78dm.net/news/0/11/0/0/0/0/0/1.html)        | [news/0/11/0/0/0/0/0/1](https://rsshub.app/78dm/news/0/11/0/0/0/0/0/1) |\n| [配件](https://www.78dm.net/news/0/12/0/0/0/0/0/1.html)        | [news/0/12/0/0/0/0/0/1](https://rsshub.app/78dm/news/0/12/0/0/0/0/0/1) |\n| [工具](https://www.78dm.net/news/0/13/0/0/0/0/0/1.html)        | [news/0/13/0/0/0/0/0/1](https://rsshub.app/78dm/news/0/13/0/0/0/0/0/1) |\n\n#### [精彩评测](https://www.78dm.net/eval_list)\n\n| 分类                                                      | ID                                                                 |\n| --------------------------------------------------------- | ------------------------------------------------------------------ |\n| [全部](https://www.78dm.net/eval_list/0/0/0/1.html)       | [eval_list/0/0/0/1](https://rsshub.app/78dm/eval_list/0/0/0/1)     |\n| [变形金刚](https://www.78dm.net/eval_list/109/0/0/1.html) | [eval_list/109/0/0/1](https://rsshub.app/78dm/eval_list/109/0/0/1) |\n| [高达](https://www.78dm.net/eval_list/110/0/0/1.html)     | [eval_list/110/0/0/1](https://rsshub.app/78dm/eval_list/110/0/0/1) |\n| [圣斗士](https://www.78dm.net/eval_list/111/0/0/1.html)   | [eval_list/111/0/0/1](https://rsshub.app/78dm/eval_list/111/0/0/1) |\n| [海贼王](https://www.78dm.net/eval_list/112/0/0/1.html)   | [eval_list/112/0/0/1](https://rsshub.app/78dm/eval_list/112/0/0/1) |\n| [PVC 手办](https://www.78dm.net/eval_list/115/0/0/1.html) | [eval_list/115/0/0/1](https://rsshub.app/78dm/eval_list/115/0/0/1) |\n| [拼装模型](https://www.78dm.net/eval_list/113/0/0/1.html) | [eval_list/113/0/0/1](https://rsshub.app/78dm/eval_list/113/0/0/1) |\n| [机甲成品](https://www.78dm.net/eval_list/114/0/0/1.html) | [eval_list/114/0/0/1](https://rsshub.app/78dm/eval_list/114/0/0/1) |\n| [特摄](https://www.78dm.net/eval_list/116/0/0/1.html)     | [eval_list/116/0/0/1](https://rsshub.app/78dm/eval_list/116/0/0/1) |\n| [美系](https://www.78dm.net/eval_list/117/0/0/1.html)     | [eval_list/117/0/0/1](https://rsshub.app/78dm/eval_list/117/0/0/1) |\n| [GK](https://www.78dm.net/eval_list/118/0/0/1.html)       | [eval_list/118/0/0/1](https://rsshub.app/78dm/eval_list/118/0/0/1) |\n| [综合](https://www.78dm.net/eval_list/120/0/0/1.html)     | [eval_list/120/0/0/1](https://rsshub.app/78dm/eval_list/120/0/0/1) |\n\n#### [好贴推荐](https://www.78dm.net/ht_list)\n\n| 分类                                                    | ID                                                             |\n| ------------------------------------------------------- | -------------------------------------------------------------- |\n| [全部](https://www.78dm.net/ht_list/0/0/0/1.html)       | [ht_list/0/0/0/1](https://rsshub.app/78dm/ht_list/0/0/0/1)     |\n| [变形金刚](https://www.78dm.net/ht_list/95/0/0/1.html)  | [ht_list/95/0/0/1](https://rsshub.app/78dm/ht_list/95/0/0/1)   |\n| [高达](https://www.78dm.net/ht_list/96/0/0/1.html)      | [ht_list/96/0/0/1](https://rsshub.app/78dm/ht_list/96/0/0/1)   |\n| [圣斗士](https://www.78dm.net/ht_list/98/0/0/1.html)    | [ht_list/98/0/0/1](https://rsshub.app/78dm/ht_list/98/0/0/1)   |\n| [海贼王](https://www.78dm.net/ht_list/99/0/0/1.html)    | [ht_list/99/0/0/1](https://rsshub.app/78dm/ht_list/99/0/0/1)   |\n| [PVC 手办](https://www.78dm.net/ht_list/100/0/0/1.html) | [ht_list/100/0/0/1](https://rsshub.app/78dm/ht_list/100/0/0/1) |\n| [拼装模型](https://www.78dm.net/ht_list/101/0/0/1.html) | [ht_list/101/0/0/1](https://rsshub.app/78dm/ht_list/101/0/0/1) |\n| [机甲成品](https://www.78dm.net/ht_list/102/0/0/1.html) | [ht_list/102/0/0/1](https://rsshub.app/78dm/ht_list/102/0/0/1) |\n| [特摄](https://www.78dm.net/ht_list/103/0/0/1.html)     | [ht_list/103/0/0/1](https://rsshub.app/78dm/ht_list/103/0/0/1) |\n| [美系](https://www.78dm.net/ht_list/104/0/0/1.html)     | [ht_list/104/0/0/1](https://rsshub.app/78dm/ht_list/104/0/0/1) |\n| [GK](https://www.78dm.net/ht_list/105/0/0/1.html)       | [ht_list/105/0/0/1](https://rsshub.app/78dm/ht_list/105/0/0/1) |\n| [综合](https://www.78dm.net/ht_list/107/0/0/1.html)     | [ht_list/107/0/0/1](https://rsshub.app/78dm/ht_list/107/0/0/1) |\n| [装甲战车](https://www.78dm.net/ht_list/131/0/0/1.html) | [ht_list/131/0/0/1](https://rsshub.app/78dm/ht_list/131/0/0/1) |\n| [舰船模型](https://www.78dm.net/ht_list/132/0/0/1.html) | [ht_list/132/0/0/1](https://rsshub.app/78dm/ht_list/132/0/0/1) |\n| [飞机模型](https://www.78dm.net/ht_list/133/0/0/1.html) | [ht_list/133/0/0/1](https://rsshub.app/78dm/ht_list/133/0/0/1) |\n| [民用模型](https://www.78dm.net/ht_list/134/0/0/1.html) | [ht_list/134/0/0/1](https://rsshub.app/78dm/ht_list/134/0/0/1) |\n| [兵人模型](https://www.78dm.net/ht_list/135/0/0/1.html) | [ht_list/135/0/0/1](https://rsshub.app/78dm/ht_list/135/0/0/1) |\n</details>\n  ",
        "categories": [
          "new-media"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.78dm.net/:category?"
            ]
          },
          {
            "title": "新品速递 - 全部",
            "source": [
              "www.78dm.net/news/0/0/0/0/0/0/0/1.html"
            ],
            "target": "/news/0/0/0/0/0/0/0/1"
          },
          {
            "title": "新品速递 - 变形金刚",
            "source": [
              "www.78dm.net/news/3/0/0/0/0/0/0/1.html"
            ],
            "target": "/news/3/0/0/0/0/0/0/1"
          },
          {
            "title": "新品速递 - 高达",
            "source": [
              "www.78dm.net/news/4/0/0/0/0/0/0/1.html"
            ],
            "target": "/news/4/0/0/0/0/0/0/1"
          },
          {
            "title": "新品速递 - 圣斗士",
            "source": [
              "www.78dm.net/news/2/0/0/0/0/0/0/1.html"
            ],
            "target": "/news/2/0/0/0/0/0/0/1"
          },
          {
            "title": "新品速递 - 海贼王",
            "source": [
              "www.78dm.net/news/8/0/0/0/0/0/0/1.html"
            ],
            "target": "/news/8/0/0/0/0/0/0/1"
          },
          {
            "title": "新品速递 - PVC手办",
            "source": [
              "www.78dm.net/news/0/5/0/0/0/0/0/1.html"
            ],
            "target": "/news/0/5/0/0/0/0/0/1"
          },
          {
            "title": "新品速递 - 拼装模型",
            "source": [
              "www.78dm.net/news/0/1/0/0/0/0/0/1.html"
            ],
            "target": "/news/0/1/0/0/0/0/0/1"
          },
          {
            "title": "新品速递 - 机甲成品",
            "source": [
              "www.78dm.net/news/0/2/0/0/0/0/0/1.html"
            ],
            "target": "/news/0/2/0/0/0/0/0/1"
          },
          {
            "title": "新品速递 - 特摄",
            "source": [
              "www.78dm.net/news/0/3/0/0/0/0/0/1.html"
            ],
            "target": "/news/0/3/0/0/0/0/0/1"
          },
          {
            "title": "新品速递 - 美系",
            "source": [
              "www.78dm.net/news/0/4/0/0/0/0/0/1.html"
            ],
            "target": "/news/0/4/0/0/0/0/0/1"
          },
          {
            "title": "新品速递 - GK",
            "source": [
              "www.78dm.net/news/0/6/0/0/0/0/0/1.html"
            ],
            "target": "/news/0/6/0/0/0/0/0/1"
          },
          {
            "title": "新品速递 - 扭蛋盒蛋食玩",
            "source": [
              "www.78dm.net/news/0/7/0/0/0/0/0/1.html"
            ],
            "target": "/news/0/7/0/0/0/0/0/1"
          },
          {
            "title": "新品速递 - 其他",
            "source": [
              "www.78dm.net/news/0/8/0/0/0/0/0/1.html"
            ],
            "target": "/news/0/8/0/0/0/0/0/1"
          },
          {
            "title": "新品速递 - 综合",
            "source": [
              "www.78dm.net/news/0/9/0/0/0/0/0/1.html"
            ],
            "target": "/news/0/9/0/0/0/0/0/1"
          },
          {
            "title": "新品速递 - 军模",
            "source": [
              "www.78dm.net/news/0/10/0/0/0/0/0/1.html"
            ],
            "target": "/news/0/10/0/0/0/0/0/1"
          },
          {
            "title": "新品速递 - 民用",
            "source": [
              "www.78dm.net/news/0/11/0/0/0/0/0/1.html"
            ],
            "target": "/news/0/11/0/0/0/0/0/1"
          },
          {
            "title": "新品速递 - 配件",
            "source": [
              "www.78dm.net/news/0/12/0/0/0/0/0/1.html"
            ],
            "target": "/news/0/12/0/0/0/0/0/1"
          },
          {
            "title": "新品速递 - 工具",
            "source": [
              "www.78dm.net/news/0/13/0/0/0/0/0/1.html"
            ],
            "target": "/news/0/13/0/0/0/0/0/1"
          },
          {
            "title": "精彩评测 - 全部",
            "source": [
              "www.78dm.net/eval_list/0/0/0/1.html"
            ],
            "target": "/eval_list/0/0/0/1"
          },
          {
            "title": "精彩评测 - 变形金刚",
            "source": [
              "www.78dm.net/eval_list/109/0/0/1.html"
            ],
            "target": "/eval_list/109/0/0/1"
          },
          {
            "title": "精彩评测 - 高达",
            "source": [
              "www.78dm.net/eval_list/110/0/0/1.html"
            ],
            "target": "/eval_list/110/0/0/1"
          },
          {
            "title": "精彩评测 - 圣斗士",
            "source": [
              "www.78dm.net/eval_list/111/0/0/1.html"
            ],
            "target": "/eval_list/111/0/0/1"
          },
          {
            "title": "精彩评测 - 海贼王",
            "source": [
              "www.78dm.net/eval_list/112/0/0/1.html"
            ],
            "target": "/eval_list/112/0/0/1"
          },
          {
            "title": "精彩评测 - PVC手办",
            "source": [
              "www.78dm.net/eval_list/115/0/0/1.html"
            ],
            "target": "/eval_list/115/0/0/1"
          },
          {
            "title": "精彩评测 - 拼装模型",
            "source": [
              "www.78dm.net/eval_list/113/0/0/1.html"
            ],
            "target": "/eval_list/113/0/0/1"
          },
          {
            "title": "精彩评测 - 机甲成品",
            "source": [
              "www.78dm.net/eval_list/114/0/0/1.html"
            ],
            "target": "/eval_list/114/0/0/1"
          },
          {
            "title": "精彩评测 - 特摄",
            "source": [
              "www.78dm.net/eval_list/116/0/0/1.html"
            ],
            "target": "/eval_list/116/0/0/1"
          },
          {
            "title": "精彩评测 - 美系",
            "source": [
              "www.78dm.net/eval_list/117/0/0/1.html"
            ],
            "target": "/eval_list/117/0/0/1"
          },
          {
            "title": "精彩评测 - GK",
            "source": [
              "www.78dm.net/eval_list/118/0/0/1.html"
            ],
            "target": "/eval_list/118/0/0/1"
          },
          {
            "title": "精彩评测 - 综合",
            "source": [
              "www.78dm.net/eval_list/120/0/0/1.html"
            ],
            "target": "/eval_list/120/0/0/1"
          },
          {
            "title": "好贴推荐 - 全部",
            "source": [
              "www.78dm.net/ht_list/0/0/0/1.html"
            ],
            "target": "/ht_list/0/0/0/1"
          },
          {
            "title": "好贴推荐 - 变形金刚",
            "source": [
              "www.78dm.net/ht_list/95/0/0/1.html"
            ],
            "target": "/ht_list/95/0/0/1"
          },
          {
            "title": "好贴推荐 - 高达",
            "source": [
              "www.78dm.net/ht_list/96/0/0/1.html"
            ],
            "target": "/ht_list/96/0/0/1"
          },
          {
            "title": "好贴推荐 - 圣斗士",
            "source": [
              "www.78dm.net/ht_list/98/0/0/1.html"
            ],
            "target": "/ht_list/98/0/0/1"
          },
          {
            "title": "好贴推荐 - 海贼王",
            "source": [
              "www.78dm.net/ht_list/99/0/0/1.html"
            ],
            "target": "/ht_list/99/0/0/1"
          },
          {
            "title": "好贴推荐 - PVC手办",
            "source": [
              "www.78dm.net/ht_list/100/0/0/1.html"
            ],
            "target": "/ht_list/100/0/0/1"
          },
          {
            "title": "好贴推荐 - 拼装模型",
            "source": [
              "www.78dm.net/ht_list/101/0/0/1.html"
            ],
            "target": "/ht_list/101/0/0/1"
          },
          {
            "title": "好贴推荐 - 机甲成品",
            "source": [
              "www.78dm.net/ht_list/102/0/0/1.html"
            ],
            "target": "/ht_list/102/0/0/1"
          },
          {
            "title": "好贴推荐 - 特摄",
            "source": [
              "www.78dm.net/ht_list/103/0/0/1.html"
            ],
            "target": "/ht_list/103/0/0/1"
          },
          {
            "title": "好贴推荐 - 美系",
            "source": [
              "www.78dm.net/ht_list/104/0/0/1.html"
            ],
            "target": "/ht_list/104/0/0/1"
          },
          {
            "title": "好贴推荐 - GK",
            "source": [
              "www.78dm.net/ht_list/105/0/0/1.html"
            ],
            "target": "/ht_list/105/0/0/1"
          },
          {
            "title": "好贴推荐 - 综合",
            "source": [
              "www.78dm.net/ht_list/107/0/0/1.html"
            ],
            "target": "/ht_list/107/0/0/1"
          },
          {
            "title": "好贴推荐 - 装甲战车",
            "source": [
              "www.78dm.net/ht_list/131/0/0/1.html"
            ],
            "target": "/ht_list/131/0/0/1"
          },
          {
            "title": "好贴推荐 - 舰船模型",
            "source": [
              "www.78dm.net/ht_list/132/0/0/1.html"
            ],
            "target": "/ht_list/132/0/0/1"
          },
          {
            "title": "好贴推荐 - 飞机模型",
            "source": [
              "www.78dm.net/ht_list/133/0/0/1.html"
            ],
            "target": "/ht_list/133/0/0/1"
          },
          {
            "title": "好贴推荐 - 民用模型",
            "source": [
              "www.78dm.net/ht_list/134/0/0/1.html"
            ],
            "target": "/ht_list/134/0/0/1"
          },
          {
            "title": "好贴推荐 - 兵人模型",
            "source": [
              "www.78dm.net/ht_list/135/0/0/1.html"
            ],
            "target": "/ht_list/135/0/0/1"
          }
        ],
        "location": "index.ts",
        "module": () => import('@/routes/78dm/index.ts')
      }
    },
    "name": "78 动漫",
    "apiRoutes": {},
    "url": "78dm.net",
    "categories": [
      "anime"
    ],
    "description": "",
    "lang": "zh-CN"
  },
  "7mmtv": {
    "routes": {
      "/:language?/:category?/:type?": {
        "path": "/:language?/:category?/:type?",
        "categories": [
          "multimedia"
        ],
        "example": "/7mmtv/zh/censored_list/all",
        "parameters": {
          "language": "Language, see below, `en` as English by default",
          "category": "Category, see below, `censored_list` as Censored by default",
          "type": "Server, see below, all server by default"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false,
          "nsfw": true
        },
        "name": "Category",
        "maintainers": [
          "nczitzk"
        ],
        "description": "**Language**\n\n| English | 日本語 | 한국의 | 中文 |\n| ------- | ------ | ------ | ---- |\n| en      | ja     | ko     | zh   |\n\n  **Category**\n\n| Chinese subtitles AV | Censored       | Amateur          | Uncensored       | Asian self-timer | H comics     |\n| -------------------- | -------------- | ---------------- | ---------------- | ---------------- | ------------ |\n| chinese_list        | censored_list | amateurjav_list | uncensored_list | amateur_list    | hcomic_list |\n\n| Chinese subtitles AV random | Censored random  | Amateur random     | Uncensored random  | Asian self-timer random | H comics random |\n| --------------------------- | ---------------- | ------------------ | ------------------ | ----------------------- | --------------- |\n| chinese_random             | censored_random | amateurjav_random | uncensored_random | amateur_random         | hcomic_random  |\n\n  **Server**\n\n| All Server | fembed(Full DL) | streamsb(Full DL) | doodstream | streamtape(Full DL) | avgle | embedgram | videovard(Full DL) |\n| ---------- | --------------- | ----------------- | ---------- | ------------------- | ----- | --------- | ------------------ |\n| all        | 21              | 30                | 28         | 29                  | 17    | 34        | 33                 |",
        "location": "index.tsx",
        "module": () => import('@/routes/7mmtv/index.tsx')
      }
    },
    "name": "7mmtv",
    "apiRoutes": {},
    "url": "7mmtv.tv",
    "lang": "zh-CN"
  },
  "8kcos": {
    "routes": {
      "/cat/:cat{.+}?": {
        "path": "/cat/:cat{.+}?",
        "radar": [
          {
            "source": [
              "8kcosplay.com/"
            ],
            "target": ""
          }
        ],
        "name": "Unknown",
        "maintainers": [],
        "url": "8kcosplay.com/",
        "features": {
          "nsfw": true
        },
        "location": "cat.ts",
        "module": () => import('@/routes/8kcos/cat.ts')
      },
      "/": {
        "path": "/",
        "categories": [
          "picture"
        ],
        "example": "/8kcos/",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false,
          "nsfw": true
        },
        "radar": [
          {
            "source": [
              "8kcosplay.com/"
            ],
            "target": ""
          }
        ],
        "name": "最新",
        "maintainers": [
          "KotoriK"
        ],
        "url": "8kcosplay.com/",
        "location": "latest.ts",
        "module": () => import('@/routes/8kcos/latest.ts')
      },
      "/tag/:tag": {
        "path": "/tag/:tag",
        "categories": [
          "picture"
        ],
        "example": "/8kcos/tag/cosplay",
        "parameters": {
          "tag": "标签名"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false,
          "nsfw": true
        },
        "radar": [
          {
            "source": [
              "8kcosplay.com/tag/:tag"
            ]
          }
        ],
        "name": "标签",
        "maintainers": [
          "KotoriK"
        ],
        "url": "8kcosplay.com/",
        "location": "tag.ts",
        "module": () => import('@/routes/8kcos/tag.ts')
      }
    },
    "name": "8KCosplay",
    "apiRoutes": {},
    "url": "8kcosplay.com",
    "lang": "zh-CN"
  },
  "8world": {
    "routes": {
      "*": {
        "path": "*",
        "name": "Unknown",
        "maintainers": [],
        "location": "index.ts",
        "module": () => import('@/routes/8world/index.ts')
      }
    },
    "name": "8 视界",
    "apiRoutes": {},
    "url": "8world.com",
    "lang": "zh-CN"
  },
  "91porn": {
    "routes": {
      "/author/:uid/:lang?": {
        "path": "/author/:uid/:lang?",
        "categories": [
          "multimedia"
        ],
        "example": "/91porn/author/2d6d2iWm4vVCwqujAZbSrKt2QJCbbaObv9HQ21Zo8wGJWudWBg",
        "parameters": {
          "uid": "Author ID, can be found in URL",
          "lang": "Language, see above, `en_US` by default "
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false,
          "nsfw": true
        },
        "radar": [
          {
            "source": [
              "91porn.com/index.php"
            ],
            "target": ""
          }
        ],
        "name": "Author",
        "maintainers": [
          "TonyRL"
        ],
        "url": "91porn.com/index.php",
        "location": "author.ts",
        "module": () => import('@/routes/91porn/author.ts')
      },
      "/:lang?": {
        "path": "/:lang?",
        "categories": [
          "multimedia"
        ],
        "example": "/91porn",
        "parameters": {
          "lang": "Language, see below, `en_US` by default "
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false,
          "nsfw": true
        },
        "radar": [
          {
            "source": [
              "91porn.com/index.php"
            ],
            "target": ""
          }
        ],
        "name": "Hot Video Today",
        "maintainers": [
          "TonyRL"
        ],
        "url": "91porn.com/index.php",
        "description": "| English | 简体中文 | 繁體中文 |\n| ------- | -------- | -------- |\n| en_US  | cn_CN   | zh_ZH   |",
        "location": "index.ts",
        "module": () => import('@/routes/91porn/index.ts')
      }
    },
    "name": "91porn",
    "apiRoutes": {},
    "url": "91porn.com",
    "description": "::: tip\n91porn has multiple backup domains, routes use the permanent domain `https://91porn.com` by default. If the domain is not accessible, you can add `?domain=<domain>` to specify the domain to be used. If you want to specify the backup domain to `https://0122.91p30.com`, you can add `?domain=0122.91p30.com` to the end of all 91porn routes, then the route will become [`/91porn?domain=0122.91p30.com`](https://rsshub.app/91porn?domain=0122.91p30.com)\n:::",
    "lang": "zh-CN"
  },
  "95mm": {
    "routes": {
      "/category/:category": {
        "path": "/category/:category",
        "categories": [
          "picture"
        ],
        "example": "/95mm/category/1",
        "parameters": {
          "category": "集合，见下表"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false,
          "nsfw": true
        },
        "radar": [
          {
            "source": [
              "95mm.org/"
            ]
          }
        ],
        "name": "集合",
        "maintainers": [
          "nczitzk"
        ],
        "url": "95mm.org/",
        "description": "| 清纯唯美 | 摄影私房 | 明星写真 | 三次元 | 异域美景 | 性感妖姬 | 游戏主题 | 美女壁纸 |\n| -------- | -------- | -------- | ------ | -------- | -------- | -------- | -------- |\n| 1        | 2        | 4        | 5      | 6        | 7        | 9        | 11       |",
        "location": "category.ts",
        "module": () => import('@/routes/95mm/category.ts')
      },
      "/tab/:tab?": {
        "path": "/tab/:tab?",
        "categories": [
          "picture"
        ],
        "example": "/95mm/tab/热门",
        "parameters": {
          "tab": "分类，见下表，默认为最新"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false,
          "nsfw": true
        },
        "radar": [
          {
            "source": [
              "95mm.org/"
            ]
          }
        ],
        "name": "分类",
        "maintainers": [
          "nczitzk"
        ],
        "url": "95mm.org/",
        "description": "| 最新 | 热门 | 校花 | 森系 | 清纯 | 童颜 | 嫩模 | 少女 |\n| ---- | ---- | ---- | ---- | ---- | ---- | ---- | ---- |",
        "location": "tab.ts",
        "module": () => import('@/routes/95mm/tab.ts')
      },
      "/tag/:tag": {
        "path": "/tag/:tag",
        "categories": [
          "picture"
        ],
        "example": "/95mm/tag/黑丝",
        "parameters": {
          "tag": "标签，可在对应标签页中找到"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false,
          "nsfw": true
        },
        "radar": [
          {
            "source": [
              "95mm.org/"
            ]
          }
        ],
        "name": "标签",
        "maintainers": [
          "nczitzk"
        ],
        "url": "95mm.org/",
        "location": "tag.ts",
        "module": () => import('@/routes/95mm/tag.ts')
      }
    },
    "name": "MM 范",
    "apiRoutes": {},
    "url": "95mm.org",
    "lang": "zh-CN"
  },
  "9to5": {
    "routes": {
      "/:subsite/:tag?": {
        "path": "/:subsite/:tag?",
        "name": "Unknown",
        "maintainers": [],
        "location": "subsite.ts",
        "module": () => import('@/routes/9to5/subsite.ts')
      }
    },
    "name": "9To5",
    "url": "9to5toys.com",
    "lang": "en"
  },
  "a9vg": {
    "routes": {
      "/:category{.+}?": {
        "path": "/:category{.+}?",
        "name": "新闻",
        "url": "a9vg.com",
        "maintainers": [
          "monnerHenster",
          "nczitzk"
        ],
        "example": "/a9vg/news",
        "parameters": {
          "category": "分类，默认为 ，可在对应分类页 URL 中找到, Category, by default"
        },
        "description": "::: tip\n  若订阅 [PS4](http://www.a9vg.com/list/news/PS4)，网址为 `http://www.a9vg.com/list/news/PS4`。截取 `http://www.a9vg.com/list` 到末尾的部分 `news/PS4` 作为参数填入，此时路由为 [`/a9vg/news/PS4`](https://rsshub.app/a9vg/news/PS4)。\n:::\n\n| 分类                                               | ID                                                     |\n| -------------------------------------------------- | ------------------------------------------------------ |\n| [All](https://www.a9vg.com/list/news/All)          | [news/All](https://rsshub.app/a9vg/news/All)           |\n| [PS4](https://www.a9vg.com/list/news/PS4)          | [news/PS4](https://rsshub.app/a9vg/news/PS4)           |\n| [PS5](https://www.a9vg.com/list/news/PS5)          | [news/PS5](https://rsshub.app/a9vg/news/PS5)           |\n| [Switch](https://www.a9vg.com/list/news/Switch)    | [news/Switch](https://rsshub.app/a9vg/news/Switch)     |\n| [Xbox One](https://www.a9vg.com/list/news/XboxOne) | [news/XboxOne](https://rsshub.app/a9vg/news/XboxOne)   |\n| [XSX](https://www.a9vg.com/list/news/XSX)          | [news/XSX](https://rsshub.app/a9vg/news/XSX)           |\n| [PC](https://www.a9vg.com/list/news/PC)            | [news/PC](https://rsshub.app/a9vg/news/PC)             |\n| [业界](https://www.a9vg.com/list/news/Industry)    | [news/Industry](https://rsshub.app/a9vg/news/Industry) |\n| [厂商](https://www.a9vg.com/list/news/Factory)     | [news/Factory](https://rsshub.app/a9vg/news/Factory)   |\n  ",
        "categories": [
          "game"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.a9vg.com/list/:category"
            ]
          },
          {
            "title": "All",
            "source": [
              "www.a9vg.com/list/news/All"
            ],
            "target": "/news/All"
          },
          {
            "title": "PS4",
            "source": [
              "www.a9vg.com/list/news/PS4"
            ],
            "target": "/news/PS4"
          },
          {
            "title": "PS5",
            "source": [
              "www.a9vg.com/list/news/PS5"
            ],
            "target": "/news/PS5"
          },
          {
            "title": "Switch",
            "source": [
              "www.a9vg.com/list/news/Switch"
            ],
            "target": "/news/Switch"
          },
          {
            "title": "Xbox One",
            "source": [
              "www.a9vg.com/list/news/XboxOne"
            ],
            "target": "/news/XboxOne"
          },
          {
            "title": "XSX",
            "source": [
              "www.a9vg.com/list/news/XSX"
            ],
            "target": "/news/XSX"
          },
          {
            "title": "PC",
            "source": [
              "www.a9vg.com/list/news/PC"
            ],
            "target": "/news/PC"
          },
          {
            "title": "业界",
            "source": [
              "www.a9vg.com/list/news/Industry"
            ],
            "target": "/news/Industry"
          },
          {
            "title": "厂商",
            "source": [
              "www.a9vg.com/list/news/Factory"
            ],
            "target": "/news/Factory"
          }
        ],
        "location": "index.ts",
        "module": () => import('@/routes/a9vg/index.ts')
      }
    },
    "name": "A9VG 电玩部落",
    "apiRoutes": {},
    "url": "a9vg.com",
    "description": "",
    "lang": "zh-CN"
  },
  "aa1": {
    "routes": {
      "/60s/:category?": {
        "path": "/60s/:category?",
        "name": "每日新闻",
        "url": "60s.aa1.cn",
        "maintainers": [
          "nczitzk"
        ],
        "example": "/aa1/60s/news",
        "parameters": {
          "category": {
            "description": "分类，默认为全部，可在对应分类页 URL 中找到",
            "options": [
              {
                "label": "全部",
                "value": ""
              },
              {
                "label": "新闻词文章数据",
                "value": "freenewsdata"
              },
              {
                "label": "最新",
                "value": "new"
              },
              {
                "label": "本平台同款自动发文章插件",
                "value": "1"
              },
              {
                "label": "每天60秒读懂世界",
                "value": "news"
              }
            ]
          }
        },
        "description": "::: tip\n订阅 [每天60秒读懂世界](https://60s.aa1.cn/category/news)，其源网址为 `https://60s.aa1.cn/category/news`，请参考该 URL 指定部分构成参数，此时路由为 [`/aa1/60s/news`](https://rsshub.app/aa1/60s/news) 或 [`/aa1/60s/每天60秒读懂世界`](https://rsshub.app/aa1/60s/每天60秒读懂世界)。\n:::\n\n| 分类                                                       | ID                                                      |\n| ---------------------------------------------------------- | ------------------------------------------------------- |\n| [全部](https://60s.aa1.cn)                                 | [<空>](https://rsshub.app/aa1/60s)                      |\n| [新闻词文章数据](https://60s.aa1.cn/category/freenewsdata) | [freenewsdata](https://rsshub.app/aa1/60s/freenewsdata) |\n| [最新](https://60s.aa1.cn/category/new)                    | [new](https://rsshub.app/aa1/60s/new)                   |\n| [本平台同款自动发文章插件](https://60s.aa1.cn/category/1)  | [1](https://rsshub.app/aa1/60s/1)                       |\n| [每天 60 秒读懂世界](https://60s.aa1.cn/category/news)     | [news](https://rsshub.app/aa1/60s/news)                 |\n",
        "categories": [
          "new-media"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "60s.aa1.cn",
              "60s.aa1.cn/category/:category"
            ],
            "target": "/60s/:category"
          },
          {
            "title": "全部",
            "source": [
              "60s.aa1.cn"
            ],
            "target": "/60s"
          },
          {
            "title": "新闻词文章数据",
            "source": [
              "60s.aa1.cn/category/freenewsdata"
            ],
            "target": "/60s/freenewsdata"
          },
          {
            "title": "最新",
            "source": [
              "60s.aa1.cn/category/new"
            ],
            "target": "/60s/new"
          },
          {
            "title": "本平台同款自动发文章插件",
            "source": [
              "60s.aa1.cn/category/1"
            ],
            "target": "/60s/1"
          },
          {
            "title": "每天60秒读懂世界",
            "source": [
              "60s.aa1.cn/category/news"
            ],
            "target": "/60s/news"
          }
        ],
        "view": 0,
        "location": "60s.ts",
        "module": () => import('@/routes/aa1/60s.ts')
      }
    },
    "name": "夏柔",
    "apiRoutes": {},
    "url": "aa1.cn",
    "categories": [
      "new-media"
    ],
    "description": "",
    "lang": "zh-CN"
  },
  "aamacau": {
    "routes": {
      "/:category?/:id?": {
        "path": "/:category?/:id?",
        "categories": [
          "new-media"
        ],
        "example": "/aamacau",
        "parameters": {
          "category": "分类，见下表，默认为即時報道",
          "id": "id，可在对应页面 URL 中找到，默认为空"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "aamacau.com/"
            ]
          }
        ],
        "name": "话题",
        "maintainers": [],
        "url": "aamacau.com/",
        "description": "| 即時報道     | 每週專題    | 藝文爛鬼樓 | 論盡紙本 | 新聞事件 | 特別企劃 |\n| ------------ | ----------- | ---------- | -------- | -------- | -------- |\n| breakingnews | weeklytopic | culture    | press    | case     | special  |\n\n::: tip\n  除了直接订阅分类全部文章（如 [每週專題](https://aamacau.com/topics/weeklytopic) 的对应路由为 [/aamacau/weeklytopic](https://rsshub.app/aamacau/weeklytopic)），你也可以订阅特定的专题，如 [【9-12】2021 澳門立法會選舉](https://aamacau.com/topics/【9-12】2021澳門立法會選舉) 的对应路由为 [/【9-12】2021 澳門立法會選舉](https://rsshub.app/aamacau/【9-12】2021澳門立法會選舉)。\n\n  分类中的专题也可以单独订阅，如 [新聞事件](https://aamacau.com/topics/case) 中的 [「武漢肺炎」新聞檔案](https://aamacau.com/topics/case/「武漢肺炎」新聞檔案) 对应路由为 [/case/「武漢肺炎」新聞檔案](https://rsshub.app/aamacau/case/「武漢肺炎」新聞檔案)。\n\n  同理，其他分类同上例子也可以订阅特定的单独专题。\n:::",
        "location": "index.ts",
        "module": () => import('@/routes/aamacau/index.ts')
      }
    },
    "name": "論盡媒體 AllAboutMacau Media",
    "apiRoutes": {},
    "url": "aamacau.com",
    "lang": "zh-HK"
  },
  "abc": {
    "routes": {
      "/:category{.+}?": {
        "path": "/:category{.+}?",
        "example": "/wa",
        "radar": [
          {
            "source": [
              "abc.net.au/:category*"
            ],
            "target": "/:category"
          }
        ],
        "parameters": {
          "category": "Category, can be found in the URL, can also be filled in with the `documentId` in the source code of the page, `news/justin` as **Just In** by default"
        },
        "name": "Channel & Topic",
        "categories": [
          "traditional-media"
        ],
        "description": "\n::: tip\n  All Topics in [Topic Library](https://abc.net.au/news/topics) are supported, you can fill in the field after `topic` in its URL, or fill in the `documentId`.\n\n  For example, the URL for [Computer Science](https://www.abc.net.au/news/topic/computer-science) is `https://www.abc.net.au/news/topic/computer-science`, the `category` is `news/topic/computer-science`, and the `documentId` of the Topic is `2302`, so the route is [/abc/news/topic/computer-science](https://rsshub.app/abc/news/topic/computer-science) and [/abc/2302](https://rsshub.app/abc/2302).\n\n  The supported channels are all listed in the table below. For other channels, please find the `documentId` in the source code of the channel page and fill it in as above.\n:::",
        "maintainers": [
          "nczitzk",
          "pseudoyu"
        ],
        "location": "index.ts",
        "module": () => import('@/routes/abc/index.ts')
      }
    },
    "name": "ABC News (Australian Broadcasting Corporation)",
    "apiRoutes": {},
    "url": "abc.net.au",
    "lang": "en"
  },
  "abmedia": {
    "routes": {
      "/:category?": {
        "path": "/:category?",
        "categories": [
          "new-media"
        ],
        "example": "/abmedia/technology-development",
        "parameters": {
          "category": "类别，默认为产品技术"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.abmedia.io/category/:catehory"
            ],
            "target": "/:category"
          }
        ],
        "name": "类别",
        "maintainers": [],
        "description": "参数可以从链接中拿到，如：\n\n  `https://www.abmedia.io/category/technology-development` 对应 `/abmedia/technology-development`",
        "location": "category.ts",
        "module": () => import('@/routes/abmedia/category.ts')
      },
      "/index": {
        "path": "/index",
        "categories": [
          "new-media"
        ],
        "example": "/abmedia/index",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.abmedia.io/"
            ]
          }
        ],
        "name": "首页最新新闻",
        "maintainers": [],
        "url": "www.abmedia.io/",
        "location": "index.ts",
        "module": () => import('@/routes/abmedia/index.ts')
      }
    },
    "name": "链新闻 ABMedia",
    "apiRoutes": {},
    "url": "www.abmedia.io",
    "lang": "zh-TW"
  },
  "abskoop": {
    "routes": {
      "/": {
        "path": "/",
        "radar": [
          {
            "source": [
              "ahhhhfs.com/"
            ],
            "target": ""
          }
        ],
        "name": "存档列表",
        "maintainers": [
          "zhenhappy"
        ],
        "url": "ahhhhfs.com/",
        "features": {
          "nsfw": true
        },
        "location": "index.ts",
        "module": () => import('@/routes/abskoop/index.ts')
      },
      "/nsfw": {
        "path": "/nsfw",
        "radar": [
          {
            "source": [
              "ahhhhfs.com/"
            ],
            "target": ""
          }
        ],
        "name": "存档列表 - NSFW",
        "maintainers": [
          "zhenhappy"
        ],
        "url": "ahhhhfs.com/",
        "features": {
          "nsfw": true
        },
        "location": "nsfw.ts",
        "module": () => import('@/routes/abskoop/nsfw.ts')
      }
    },
    "name": "A 姐分享",
    "apiRoutes": {},
    "url": "nsfw.abskoop.com",
    "lang": "zh-TW"
  },
  "academia": {
    "routes": {
      "/topic/:interest": {
        "path": "/topic/:interest",
        "example": "/academia/topic/Urban_History",
        "parameters": {
          "interest": "interest"
        },
        "radar": [
          {
            "source": [
              "academia.edu/Documents/in/:interest"
            ],
            "target": "/topic/:interest"
          }
        ],
        "name": "interest",
        "maintainers": [
          "K33k0",
          "cscnk52"
        ],
        "categories": [
          "journal"
        ],
        "url": "academia.edu",
        "location": "topics.ts",
        "module": () => import('@/routes/academia/topics.ts')
      }
    },
    "name": "Academia",
    "url": "www.academia.edu",
    "lang": "en"
  },
  "accessbriefing": {
    "routes": {
      "/:category{.+}?": {
        "path": "/:category{.+}?",
        "name": "Articles",
        "url": "accessbriefing.com",
        "maintainers": [
          "nczitzk"
        ],
        "example": "/accessbriefing/latest/news",
        "parameters": {
          "category": "Category, Latest News by default"
        },
        "description": "::: tip\n  If you subscribe to [Latest News](https://www.accessbriefing.com/latest/news)，where the URL is `https://www.accessbriefing.com/latest/news`, extract the part `https://www.accessbriefing.com/` to the end, and use it as the parameter to fill in. Therefore, the route will be [`/accessbriefing/latest/news`](https://rsshub.app/accessbriefing/latest/news).\n:::\n\n#### Latest\n\n| Category                                                                               | ID                                                                                              |\n| -------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------- |\n| [News](https://www.accessbriefing.com/latest/news)                                     | [latest/news](https://rsshub.app/target/site/latest/news)                                       |\n| [Products & Technology](https://www.accessbriefing.com/latest/products-and-technology) | [latest/products-and-technology](https://rsshub.app/target/site/latest/products-and-technology) |\n| [Rental News](https://www.accessbriefing.com/latest/rental-news)                       | [latest/rental-news](https://rsshub.app/target/site/latest/rental-news)                         |\n| [People](https://www.accessbriefing.com/latest/people)                                 | [latest/people](https://rsshub.app/target/site/latest/people)                                   |\n| [Regualtions & Safety](https://www.accessbriefing.com/latest/regualtions-safety)       | [latest/regualtions-safety](https://rsshub.app/target/site/latest/regualtions-safety)           |\n| [Finance](https://www.accessbriefing.com/latest/finance)                               | [latest/finance](https://rsshub.app/target/site/latest/finance)                                 |\n| [Sustainability](https://www.accessbriefing.com/latest/sustainability)                 | [latest/sustainability](https://rsshub.app/target/site/latest/sustainability)                   |\n\n#### Insight\n\n| Category                                                                          | ID                                                                                        |\n| --------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------- |\n| [Interviews](https://www.accessbriefing.com/insight/interviews)                   | [insight/interviews](https://rsshub.app/target/site/insight/interviews)                   |\n| [Longer reads](https://www.accessbriefing.com/insight/longer-reads)               | [insight/longer-reads](https://rsshub.app/target/site/insight/longer-reads)               |\n| [Videos and podcasts](https://www.accessbriefing.com/insight/videos-and-podcasts) | [insight/videos-and-podcasts](https://rsshub.app/target/site/insight/videos-and-podcasts) |\n  ",
        "categories": [
          "new-media"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "accessbriefing.com/:category*"
            ],
            "target": "/:category"
          },
          {
            "title": "Latest - News",
            "source": [
              "accessbriefing.com/latest/news"
            ],
            "target": "/latest/news"
          },
          {
            "title": "Latest - Products & Technology",
            "source": [
              "accessbriefing.com/latest/products-and-technology"
            ],
            "target": "/latest/products-and-technology"
          },
          {
            "title": "Latest - Rental News",
            "source": [
              "accessbriefing.com/latest/rental-news"
            ],
            "target": "/latest/rental-news"
          },
          {
            "title": "Latest - People",
            "source": [
              "accessbriefing.com/latest/people"
            ],
            "target": "/latest/people"
          },
          {
            "title": "Latest - Regualtions & Safety",
            "source": [
              "accessbriefing.com/latest/regualtions-safety"
            ],
            "target": "/latest/regualtions-safety"
          },
          {
            "title": "Latest - Finance",
            "source": [
              "accessbriefing.com/latest/finance"
            ],
            "target": "/latest/finance"
          },
          {
            "title": "Latest - Sustainability",
            "source": [
              "accessbriefing.com/latest/sustainability"
            ],
            "target": "/latest/sustainability"
          },
          {
            "title": "Insight - Interviews",
            "source": [
              "accessbriefing.com/insight/interviews"
            ],
            "target": "/insight/interviews"
          },
          {
            "title": "Insight - Longer reads",
            "source": [
              "accessbriefing.com/insight/longer-reads"
            ],
            "target": "/insight/longer-reads"
          },
          {
            "title": "Insight - Videos and podcasts",
            "source": [
              "accessbriefing.com/insight/videos-and-podcasts"
            ],
            "target": "/insight/videos-and-podcasts"
          }
        ],
        "location": "index.ts",
        "module": () => import('@/routes/accessbriefing/index.ts')
      }
    },
    "name": "Access Briefing",
    "apiRoutes": {},
    "url": "accessbriefing.com",
    "categories": [
      "new-media"
    ],
    "description": "",
    "lang": "en"
  },
  "acfun": {
    "routes": {
      "/article/:categoryId/:sortType?/:timeRange?": {
        "path": "/article/:categoryId/:sortType?/:timeRange?",
        "categories": [
          "anime"
        ],
        "view": 0,
        "example": "/acfun/article/110",
        "parameters": {
          "categoryId": {
            "description": "分区 ID",
            "options": [
              {
                "value": "73",
                "label": "生活情感"
              },
              {
                "value": "74",
                "label": "动漫文化"
              },
              {
                "value": "75",
                "label": "漫画文学"
              },
              {
                "value": "110",
                "label": "综合"
              },
              {
                "value": "164",
                "label": "游戏"
              },
              {
                "value": "184",
                "label": "二次元画师"
              }
            ]
          },
          "sortType": {
            "description": "排序",
            "options": [
              {
                "value": "createTime",
                "label": "最新发表"
              },
              {
                "value": "lastCommentTime",
                "label": "最新动态"
              },
              {
                "value": "hotScore",
                "label": "最热文章"
              }
            ],
            "default": "createTime"
          },
          "timeRange": {
            "description": "时间范围，仅在排序是 `hotScore` 有效",
            "options": [
              {
                "value": "all",
                "label": "时间不限"
              },
              {
                "value": "oneDay",
                "label": "24 小时"
              },
              {
                "value": "threeDay",
                "label": "三天"
              },
              {
                "value": "oneWeek",
                "label": "一周"
              },
              {
                "value": "oneMonth",
                "label": "一个月"
              }
            ],
            "default": "all"
          }
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "文章",
        "maintainers": [
          "TonyRL"
        ],
        "description": "| 二次元画师 | 综合 | 生活情感 | 游戏 | 动漫文化 | 漫画文学 |\n| ---------- | ---- | -------- | ---- | -------- | -------- |\n| 184        | 110  | 73       | 164  | 74       | 75       |\n\n| 最新发表   | 最新动态        | 最热文章 |\n| ---------- | --------------- | -------- |\n| createTime | lastCommentTime | hotScore |\n\n| 时间不限 | 24 小时 | 三天     | 一周    | 一个月   |\n| -------- | ------- | -------- | ------- | -------- |\n| all      | oneDay  | threeDay | oneWeek | oneMonth |",
        "location": "article.ts",
        "module": () => import('@/routes/acfun/article.ts')
      },
      "/bangumi/:id": {
        "path": "/bangumi/:id",
        "categories": [
          "anime"
        ],
        "view": 3,
        "example": "/acfun/bangumi/5022158",
        "parameters": {
          "id": "番剧 id"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "番剧",
        "maintainers": [
          "xyqfer"
        ],
        "description": "::: tip\n番剧 id 不包含开头的 aa。\n例如：`https://www.acfun.cn/bangumi/aa5022158` 的番剧 id 是 5022158，不包括开头的 aa。\n:::",
        "location": "bangumi.ts",
        "module": () => import('@/routes/acfun/bangumi.ts')
      },
      "/user/video/:uid": {
        "path": "/user/video/:uid",
        "radar": [
          {
            "source": [
              "www.acfun.cn/u/:id"
            ],
            "target": "/user/video/:id"
          }
        ],
        "name": "用户投稿",
        "parameters": {
          "uid": "用户 UID"
        },
        "categories": [
          "anime"
        ],
        "example": "/acfun/user/video/6102",
        "view": 3,
        "maintainers": [
          "wdssmq"
        ],
        "location": "video.ts",
        "module": () => import('@/routes/acfun/video.ts')
      }
    },
    "name": "AcFun",
    "apiRoutes": {},
    "url": "www.acfun.cn",
    "lang": "zh-CN"
  },
  "acg17": {
    "routes": {
      "/post/all": {
        "path": "/post/all",
        "categories": [
          "anime"
        ],
        "example": "/acg17/post/all",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "acg17.com/post"
            ]
          }
        ],
        "name": "全部文章",
        "maintainers": [
          "SunBK201"
        ],
        "url": "acg17.com/post",
        "location": "post.ts",
        "module": () => import('@/routes/acg17/post.ts')
      }
    },
    "name": "ACG17",
    "url": "acg17.com",
    "lang": "zh-CN"
  },
  "acgvinyl": {
    "routes": {
      "/news": {
        "path": "/news",
        "categories": [
          "anime"
        ],
        "example": "/news",
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.acgvinyl.com"
            ],
            "target": "/news"
          }
        ],
        "name": "News",
        "maintainers": [
          "williamgateszhao"
        ],
        "url": "www.acgvinyl.com/col.jsp?id=103",
        "zh": {
          "name": "黑胶新闻"
        },
        "location": "news.ts",
        "module": () => import('@/routes/acgvinyl/news.ts')
      }
    },
    "name": "ACG Vinyl - 黑胶",
    "url": "www.acgvinyl.com"
  },
  "acpaa": {
    "routes": {
      "/:id?/:name?": {
        "path": "/:id?/:name?",
        "categories": [
          "other"
        ],
        "example": "/acpaa",
        "parameters": {
          "id": "标签 id，默认为 1，可在对应标签页 URL 中找到",
          "name": "标签名称，默认为重要通知，可在对应标签页 URL 中找到"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "标签",
        "maintainers": [
          "nczitzk"
        ],
        "location": "index.ts",
        "module": () => import('@/routes/acpaa/index.ts')
      }
    },
    "name": "中华全国专利代理师协会",
    "apiRoutes": {},
    "url": "acpaa.cn",
    "lang": "zh-CN"
  },
  "acs": {
    "routes": {
      "/journal/:id": {
        "path": "/journal/:id",
        "radar": [
          {
            "source": [
              "pubs.acs.org/journal/:id",
              "pubs.acs.org/"
            ]
          }
        ],
        "name": "Unknown",
        "maintainers": [
          "nczitzk"
        ],
        "location": "journal.tsx",
        "module": () => import('@/routes/acs/journal.tsx')
      }
    },
    "name": "ACS Publications",
    "apiRoutes": {},
    "url": "pubs.acs.org",
    "lang": "en"
  },
  "adquan": {
    "routes": {
      "/case_library": {
        "path": "/case_library",
        "name": "案例库",
        "url": "www.adquan.com",
        "maintainers": [
          "nczitzk"
        ],
        "example": "/adquan/case_library",
        "categories": [
          "new-media"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.adquan.com/case_library/index"
            ],
            "target": "/case_library"
          }
        ],
        "view": 0,
        "location": "case-library.ts",
        "module": () => import('@/routes/adquan/case-library.ts')
      },
      "/": {
        "path": "/",
        "name": "最新文章",
        "url": "www.adquan.com",
        "maintainers": [
          "nczitzk"
        ],
        "example": "/adquan",
        "categories": [
          "new-media"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.adquan.com"
            ],
            "target": "/"
          }
        ],
        "view": 0,
        "location": "index.ts",
        "module": () => import('@/routes/adquan/index.ts')
      }
    },
    "name": "广告门",
    "apiRoutes": {},
    "url": "adquan.com",
    "categories": [
      "new-media"
    ],
    "description": "一个行业的跌宕起伏",
    "lang": "zh-CN"
  },
  "aeaweb": {
    "routes": {
      "/:id": {
        "path": "/:id",
        "categories": [
          "journal"
        ],
        "example": "/aeaweb/aer",
        "parameters": {
          "id": "Journal id, can be found in URL"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": true
        },
        "radar": [
          {
            "source": [
              "aeaweb.org/journals/:id",
              "aeaweb.org/"
            ]
          }
        ],
        "name": "Journal",
        "maintainers": [
          "nczitzk"
        ],
        "description": "The URL of the journal [American Economic Review](https://www.aeaweb.org/journals/aer) is `https://www.aeaweb.org/journals/aer`, where `aer` is the id of the journal, so the route for this journal is `/aeaweb/aer`.\n\n::: tip\n  More jounals can be found in [AEA Journals](https://www.aeaweb.org/journals).\n:::",
        "location": "index.tsx",
        "module": () => import('@/routes/aeaweb/index.tsx')
      }
    },
    "name": "American Economic Association",
    "apiRoutes": {},
    "url": "aeaweb.org",
    "lang": "en"
  },
  "aeon": {
    "routes": {
      "/category/:category": {
        "path": "/category/:category",
        "categories": [
          "new-media"
        ],
        "example": "/aeon/category/philosophy",
        "parameters": {
          "category": {
            "description": "Category",
            "options": [
              {
                "value": "philosophy",
                "label": "Philosophy"
              },
              {
                "value": "science",
                "label": "Science"
              },
              {
                "value": "psychology",
                "label": "Psychology"
              },
              {
                "value": "society",
                "label": "Society"
              },
              {
                "value": "culture",
                "label": "Culture"
              }
            ]
          }
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "aeon.co/:category"
            ]
          }
        ],
        "name": "Categories",
        "maintainers": [
          "emdoe"
        ],
        "location": "category.ts",
        "module": () => import('@/routes/aeon/category.ts')
      },
      "/:type": {
        "path": "/:type",
        "categories": [
          "new-media"
        ],
        "example": "/aeon/essays",
        "parameters": {
          "type": {
            "description": "Type",
            "options": [
              {
                "value": "essays",
                "label": "Essays"
              },
              {
                "value": "videos",
                "label": "Videos"
              },
              {
                "value": "audio",
                "label": "Audio"
              }
            ]
          }
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "aeon.co/:type"
            ]
          }
        ],
        "name": "Types",
        "maintainers": [
          "emdoe"
        ],
        "description": "Supported types: Essays, Videos, and Audio.\n\n  Compared to the official one, the RSS feed generated by RSSHub not only has more fine-grained options, but also eliminates pull quotes, which can't be easily distinguished from other paragraphs by any RSS reader, but only disrupt the reading flow. This feed also provides users with a bio of the author at the top.",
        "location": "type.ts",
        "module": () => import('@/routes/aeon/type.ts')
      }
    },
    "name": "AEON",
    "apiRoutes": {},
    "url": "aeon.co",
    "lang": "en"
  },
  "afdian": {
    "routes": {
      "/dynamic/:uid?": {
        "path": "/dynamic/:uid?",
        "categories": [
          "other"
        ],
        "example": "/afdian/dynamic/@afdian",
        "parameters": {
          "uid": "用户id，用户动态页面url里可找到"
        },
        "name": "用户动态",
        "maintainers": [
          "sanmmm"
        ],
        "location": "dynamic.ts",
        "module": () => import('@/routes/afdian/dynamic.ts')
      },
      "/explore/:type/:category?": {
        "path": "/explore/:type/:category?",
        "categories": [
          "other"
        ],
        "example": "/afdian/explore/hot/所有",
        "parameters": {
          "type": "分类",
          "category": "目录类型，默认为 `所有`"
        },
        "name": "发现用户",
        "maintainers": [
          "sanmmm"
        ],
        "description": "分类\n\n| 推荐 | 最热 |\n| ---- | ---- |\n| rec  | hot  |\n\n  目录类型\n\n| 所有 | 绘画 | 视频 | 写作 | 游戏 | 音乐 | 播客 | 摄影 | 技术 | Vtuber | 舞蹈 | 体育 | 旅游 | 美食 | 时尚 | 数码 | 动画 | 其他 |\n| ---- | ---- | ---- | ---- | ---- | ---- | ---- | ---- | ---- | ------ | ---- | ---- | ---- | ---- | ---- | ---- | ---- | ---- |\n| 所有 | 绘画 | 视频 | 写作 | 游戏 | 音乐 | 播客 | 摄影 | 技术 | Vtuber | 舞蹈 | 体育 | 旅游 | 美食 | 时尚 | 数码 | 动画 | 其他 |",
        "location": "explore.ts",
        "module": () => import('@/routes/afdian/explore.ts')
      }
    },
    "name": "爱发电",
    "apiRoutes": {},
    "url": "afdian.net",
    "lang": "zh-CN"
  },
  "aflcio": {
    "routes": {
      "/blog": {
        "path": "/blog",
        "name": "Blog",
        "url": "aflcio.org",
        "maintainers": [
          "nczitzk"
        ],
        "example": "/aflcio/blog",
        "categories": [
          "other"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "aflcio.org/blog"
            ],
            "target": "/blog"
          }
        ],
        "view": 0,
        "location": "blog.ts",
        "module": () => import('@/routes/aflcio/blog.ts')
      }
    },
    "name": "AFL-CIO",
    "apiRoutes": {},
    "url": "aflcio.org",
    "categories": [
      "other"
    ],
    "description": "",
    "lang": "en"
  },
  "afr": {
    "routes": {
      "/latest": {
        "path": "/latest",
        "categories": [
          "traditional-media"
        ],
        "example": "/afr/latest",
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.afr.com/latest",
              "www.afr.com/"
            ]
          }
        ],
        "name": "Latest",
        "maintainers": [
          "TonyRL"
        ],
        "url": "www.afr.com/latest",
        "location": "latest.ts",
        "module": () => import('@/routes/afr/latest.ts')
      },
      "/navigation/:path{.+}": {
        "path": "/navigation/:path{.+}",
        "categories": [
          "traditional-media"
        ],
        "example": "/afr/navigation/markets",
        "parameters": {
          "path": "Navigation path, can be found in the URL of the page"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.afr.com/path*"
            ]
          }
        ],
        "name": "Navigation",
        "maintainers": [
          "TonyRL"
        ],
        "url": "www.afr.com",
        "location": "navigation.ts",
        "module": () => import('@/routes/afr/navigation.ts')
      }
    },
    "name": "The Australian Financial Review",
    "apiRoutes": {},
    "url": "afr.com",
    "lang": "en"
  },
  "agefans": {
    "routes": {
      "/detail/:id": {
        "path": "/detail/:id",
        "categories": [
          "anime"
        ],
        "example": "/agefans/detail/20200035",
        "parameters": {
          "id": "番剧 id，对应详情 URL 中找到"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "agemys.org/detail/:id"
            ]
          }
        ],
        "name": "番剧详情",
        "maintainers": [
          "s2marine"
        ],
        "location": "detail.ts",
        "module": () => import('@/routes/agefans/detail.ts')
      },
      "/update": {
        "path": "/update",
        "categories": [
          "anime"
        ],
        "example": "/agefans/update",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "agemys.org/update",
              "agemys.org/"
            ]
          }
        ],
        "name": "最近更新",
        "maintainers": [
          "nczitzk"
        ],
        "url": "agemys.org/update",
        "location": "update.ts",
        "module": () => import('@/routes/agefans/update.ts')
      }
    },
    "name": "AGE 动漫",
    "apiRoutes": {},
    "url": "agemys.cc",
    "lang": "zh-CN"
  },
  "agirls": {
    "routes": {
      "/topic_list": {
        "path": "/topic_list",
        "categories": [
          "new-media"
        ],
        "example": "/agirls/topic_list",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "agirls.aotter.net/",
              "agirls.aotter.net/topic"
            ]
          }
        ],
        "name": "当前精选主题列表",
        "maintainers": [
          "TonyRL"
        ],
        "url": "agirls.aotter.net/",
        "location": "topic-list.ts",
        "module": () => import('@/routes/agirls/topic-list.ts')
      },
      "/topic/:topic": {
        "path": "/topic/:topic",
        "categories": [
          "new-media"
        ],
        "example": "/agirls/topic/AppleWatch",
        "parameters": {
          "topic": "精选主题，可通过下方精选主题列表获得"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "agirls.aotter.net/topic/:topic"
            ]
          }
        ],
        "name": "精选主题",
        "maintainers": [
          "TonyRL"
        ],
        "location": "topic.ts",
        "module": () => import('@/routes/agirls/topic.ts')
      },
      "/:category?": {
        "path": "/:category?",
        "categories": [
          "new-media"
        ],
        "example": "/agirls/app",
        "parameters": {
          "category": "分类，默认为最新文章，可在对应主题页的 URL 中找到，下表仅列出部分"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "agirls.aotter.net/posts/:category"
            ],
            "target": "/:category"
          }
        ],
        "name": "分类",
        "maintainers": [
          "TonyRL"
        ],
        "description": "| App 评测 | 手机开箱 | 笔电开箱 | 3C 周边     | 教学小技巧 | 科技情报 |\n| -------- | -------- | -------- | ----------- | ---------- | -------- |\n| app      | phone    | computer | accessories | tutorial   | techlife |",
        "location": "z-index.ts",
        "module": () => import('@/routes/agirls/z-index.ts')
      }
    },
    "name": "电獭少女",
    "url": "agirls.aotter.net",
    "lang": "zh-TW"
  },
  "agora0": {
    "routes": {
      "/:category?": {
        "path": "/:category?",
        "categories": [
          "new-media"
        ],
        "example": "/agora0/initium",
        "parameters": {
          "category": "分类，见下表，默认为 initium，即端传媒"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "agora0.gitlab.io/blog/:category",
              "agora0.gitlab.io/"
            ],
            "target": "/:category"
          }
        ],
        "name": "零博客",
        "maintainers": [
          "nczitzk"
        ],
        "description": "| muitinⒾ | aidemnⒾ | srettaⓂ | qⓅ | sucoⓋ |\n| ------- | ------- | -------- | -- | ----- |\n| initium | inmedia | matters  | pq | vocus |",
        "location": "index.ts",
        "module": () => import('@/routes/agora0/index.ts')
      },
      "/pen0": {
        "path": "/pen0",
        "categories": [
          "new-media"
        ],
        "example": "/agora0/pen0",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "agorahub.github.io/pen0"
            ]
          }
        ],
        "name": "共和報",
        "maintainers": [
          "TonyRL"
        ],
        "url": "agorahub.github.io/pen0",
        "location": "pen0.ts",
        "module": () => import('@/routes/agora0/pen0.ts')
      }
    },
    "name": "AG⓪RA",
    "apiRoutes": {},
    "url": "agorahub.github.io",
    "lang": "en"
  },
  "agri": {
    "routes": {
      "/:category{.+}?": {
        "path": "/:category{.+}?",
        "name": "分类",
        "url": "www.agri.cn",
        "maintainers": [
          "nczitzk"
        ],
        "example": "/agri/zx/zxfb",
        "parameters": {
          "category": "分类，默认为 `zx/zxfb`，即最新发布，可在对应分类页 URL 中找到"
        },
        "description": "::: tip\n  若订阅 [最新发布](http://www.agri.cn/zx/zxfb/)，网址为 `http://www.agri.cn/zx/zxfb/`。截取 `https://www.agri.cn/` 到末尾的部分 `zx/zxfb` 作为参数填入，此时路由为 [`/agri/zx/zxfb`](https://rsshub.app/agri/zx/zxfb)。\n:::\n\n#### [机构](http://www.agri.cn/jg/)\n\n| 分类                                    | ID                                         |\n| --------------------------------------- | ------------------------------------------ |\n| [成果展示](http://www.agri.cn/jg/cgzs/) | [jg/cgzs](https://rsshub.app/agri/jg/cgzs) |\n\n#### [资讯](http://www.agri.cn/zx/)\n\n| 分类                                        | ID                                         |\n| ------------------------------------------- | ------------------------------------------ |\n| [最新发布](http://www.agri.cn/zx/zxfb/)     | [zx/zxfb](https://rsshub.app/agri/zx/zxfb) |\n| [农业要闻](http://www.agri.cn/zx/nyyw/)     | [zx/nyyw](https://rsshub.app/agri/zx/nyyw) |\n| [中心动态](http://www.agri.cn/zx/zxdt/)     | [zx/zxdt](https://rsshub.app/agri/zx/zxdt) |\n| [通知公告](http://www.agri.cn/zx/hxgg/)     | [zx/hxgg](https://rsshub.app/agri/zx/hxgg) |\n| [全国信息联播](http://www.agri.cn/zx/xxlb/) | [zx/xxlb](https://rsshub.app/agri/zx/xxlb) |\n\n#### [生产](http://www.agri.cn/sc/)\n\n| 分类                                    | ID                                         |\n| --------------------------------------- | ------------------------------------------ |\n| [生产动态](http://www.agri.cn/sc/scdt/) | [sc/scdt](https://rsshub.app/agri/sc/scdt) |\n| [农业品种](http://www.agri.cn/sc/nypz/) | [sc/nypz](https://rsshub.app/agri/sc/nypz) |\n| [农事指导](http://www.agri.cn/sc/nszd/) | [sc/nszd](https://rsshub.app/agri/sc/nszd) |\n| [农业气象](http://www.agri.cn/sc/nyqx/) | [sc/nyqx](https://rsshub.app/agri/sc/nyqx) |\n| [专项监测](http://www.agri.cn/sc/zxjc/) | [sc/zxjc](https://rsshub.app/agri/sc/zxjc) |\n\n#### [数据](http://www.agri.cn/sj/)\n\n| 分类                                    | ID                                         |\n| --------------------------------------- | ------------------------------------------ |\n| [市场动态](http://www.agri.cn/sj/scdt/) | [sj/scdt](https://rsshub.app/agri/sj/scdt) |\n| [供需形势](http://www.agri.cn/sj/gxxs/) | [sj/gxxs](https://rsshub.app/agri/sj/gxxs) |\n| [监测预警](http://www.agri.cn/sj/jcyj/) | [sj/jcyj](https://rsshub.app/agri/sj/jcyj) |\n\n#### [信息化](http://www.agri.cn/xxh/)\n\n| 分类                                           | ID                                               |\n| ---------------------------------------------- | ------------------------------------------------ |\n| [智慧农业](http://www.agri.cn/xxh/zhny/)       | [xxh/zhny](https://rsshub.app/agri/xxh/zhny)     |\n| [信息化标准](http://www.agri.cn/xxh/xxhbz/)    | [xxh/xxhbz](https://rsshub.app/agri/xxh/xxhbz)   |\n| [中国乡村资讯](http://www.agri.cn/xxh/zgxczx/) | [xxh/zgxczx](https://rsshub.app/agri/xxh/zgxczx) |\n\n#### [视频](http://www.agri.cn/video/)\n\n| 分类                                               | ID                                                               |\n| -------------------------------------------------- | ---------------------------------------------------------------- |\n| [新闻资讯](http://www.agri.cn/video/xwzx/nyxw/)    | [video/xwzx/nyxw](https://rsshub.app/agri/video/xwzx/nyxw)       |\n| [致富天地](http://www.agri.cn/video/zftd/)         | [video/zftd](https://rsshub.app/agri/video/zftd)                 |\n| [地方农业](http://www.agri.cn/video/dfny/beijing/) | [video/dfny/beijing](https://rsshub.app/agri/video/dfny/beijing) |\n| [气象农业](http://www.agri.cn/video/qxny/)         | [video/qxny](https://rsshub.app/agri/video/qxny)                 |\n| [讲座培训](http://www.agri.cn/video/jzpx/)         | [video/jzpx](https://rsshub.app/agri/video/jzpx)                 |\n| [文化生活](http://www.agri.cn/video/whsh/)         | [video/whsh](https://rsshub.app/agri/video/whsh)                 |\n  ",
        "categories": [
          "new-media"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.agri.cn/:category?"
            ]
          },
          {
            "title": "机构 - 成果展示",
            "source": [
              "www.agri.cn/jg/cgzs/"
            ],
            "target": "/jg/cgzs"
          },
          {
            "title": "资讯 - 最新发布",
            "source": [
              "www.agri.cn/zx/zxfb/"
            ],
            "target": "/zx/zxfb"
          },
          {
            "title": "资讯 - 农业要闻",
            "source": [
              "www.agri.cn/zx/nyyw/"
            ],
            "target": "/zx/nyyw"
          },
          {
            "title": "资讯 - 中心动态",
            "source": [
              "www.agri.cn/zx/zxdt/"
            ],
            "target": "/zx/zxdt"
          },
          {
            "title": "资讯 - 通知公告",
            "source": [
              "www.agri.cn/zx/hxgg/"
            ],
            "target": "/zx/hxgg"
          },
          {
            "title": "资讯 - 全国信息联播",
            "source": [
              "www.agri.cn/zx/xxlb/"
            ],
            "target": "/zx/xxlb"
          },
          {
            "title": "生产 - 生产动态",
            "source": [
              "www.agri.cn/sc/scdt/"
            ],
            "target": "/sc/scdt"
          },
          {
            "title": "生产 - 农业品种",
            "source": [
              "www.agri.cn/sc/nypz/"
            ],
            "target": "/sc/nypz"
          },
          {
            "title": "生产 - 农事指导",
            "source": [
              "www.agri.cn/sc/nszd/"
            ],
            "target": "/sc/nszd"
          },
          {
            "title": "生产 - 农业气象",
            "source": [
              "www.agri.cn/sc/nyqx/"
            ],
            "target": "/sc/nyqx"
          },
          {
            "title": "生产 - 专项监测",
            "source": [
              "www.agri.cn/sc/zxjc/"
            ],
            "target": "/sc/zxjc"
          },
          {
            "title": "数据 - 市场动态",
            "source": [
              "www.agri.cn/sj/scdt/"
            ],
            "target": "/sj/scdt"
          },
          {
            "title": "数据 - 供需形势",
            "source": [
              "www.agri.cn/sj/gxxs/"
            ],
            "target": "/sj/gxxs"
          },
          {
            "title": "数据 - 监测预警",
            "source": [
              "www.agri.cn/sj/jcyj/"
            ],
            "target": "/sj/jcyj"
          },
          {
            "title": "信息化 - 智慧农业",
            "source": [
              "www.agri.cn/xxh/zhny/"
            ],
            "target": "/xxh/zhny"
          },
          {
            "title": "信息化 - 信息化标准",
            "source": [
              "www.agri.cn/xxh/xxhbz/"
            ],
            "target": "/xxh/xxhbz"
          },
          {
            "title": "信息化 - 中国乡村资讯",
            "source": [
              "www.agri.cn/xxh/zgxczx/"
            ],
            "target": "/xxh/zgxczx"
          },
          {
            "title": "视频 - 新闻资讯",
            "source": [
              "www.agri.cn/video/xwzx/nyxw/"
            ],
            "target": "/video/xwzx/nyxw"
          },
          {
            "title": "视频 - 致富天地",
            "source": [
              "www.agri.cn/video/zftd/"
            ],
            "target": "/video/zftd"
          },
          {
            "title": "视频 - 地方农业",
            "source": [
              "www.agri.cn/video/dfny/beijing/"
            ],
            "target": "/video/dfny/beijing"
          },
          {
            "title": "视频 - 气象农业",
            "source": [
              "www.agri.cn/video/qxny/"
            ],
            "target": "/video/qxny"
          },
          {
            "title": "视频 - 讲座培训",
            "source": [
              "www.agri.cn/video/jzpx/"
            ],
            "target": "/video/jzpx"
          },
          {
            "title": "视频 - 文化生活",
            "source": [
              "www.agri.cn/video/whsh/"
            ],
            "target": "/video/whsh"
          }
        ],
        "location": "index.ts",
        "module": () => import('@/routes/agri/index.ts')
      }
    },
    "name": "中国农业农村信息网",
    "apiRoutes": {},
    "url": "agri.cn",
    "categories": [
      "new-media"
    ],
    "description": "",
    "lang": "zh-CN"
  },
  "ahjzu": {
    "routes": {
      "/news": {
        "path": "/news",
        "categories": [
          "university"
        ],
        "example": "/ahjzu/news",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "news.ahjzu.edu.cn/20/list.htm"
            ]
          }
        ],
        "name": "通知公告",
        "maintainers": [
          "Yuk-0v0"
        ],
        "url": "news.ahjzu.edu.cn/20/list.htm",
        "location": "news.ts",
        "module": () => import('@/routes/ahjzu/news.ts')
      }
    },
    "name": "安徽建筑大学",
    "url": "news.ahjzu.edu.cn",
    "lang": "zh-CN"
  },
  "ai-bot": {
    "routes": {
      "/daily-ai-news": {
        "path": "/daily-ai-news",
        "categories": [
          "new-media"
        ],
        "example": "/ai-bot/daily-ai-news",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "ai-bot.cn/daily-ai-news",
              "ai-bot.cn/daily-ai-news/"
            ],
            "target": "/daily-ai-news"
          }
        ],
        "name": "每日AI资讯",
        "maintainers": [
          "redwood9"
        ],
        "url": "ai-bot.cn/daily-ai-news",
        "description": "获取 AI 工具集网站的每日 AI 资讯汇总。",
        "location": "daily-ai-news.ts",
        "module": () => import('@/routes/ai-bot/daily-ai-news.ts')
      }
    },
    "name": "AI工具集",
    "apiRoutes": {},
    "url": "ai-bot.cn",
    "lang": "zh-CN"
  },
  "aiaa": {
    "routes": {
      "/journal/:journalID": {
        "name": "ASR Articles",
        "maintainers": [
          "HappyZhu99"
        ],
        "categories": [
          "journal"
        ],
        "path": "/journal/:journalID",
        "parameters": {
          "journalID": "journal ID, can be found in the URL"
        },
        "example": "/aiaa/journal/aiaaj",
        "location": "journal.ts",
        "module": () => import('@/routes/aiaa/journal.ts')
      }
    },
    "name": "AIAA Aerospace Research Central",
    "apiRoutes": {},
    "url": "arc.aiaa.org",
    "lang": "en"
  },
  "aibase": {
    "routes": {
      "/daily": {
        "path": "/daily",
        "name": "AI日报",
        "url": "www.aibase.com",
        "maintainers": [
          "3tuuu"
        ],
        "example": "/aibase/daily",
        "description": "获取 AI 日报",
        "categories": [
          "new-media"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.aibase.com/zh/daily"
            ],
            "target": "/daily"
          }
        ],
        "location": "daily.ts",
        "module": () => import('@/routes/aibase/daily.ts')
      },
      "/discover/:id?": {
        "path": "/discover/:id?",
        "name": "发现",
        "url": "top.aibase.com",
        "maintainers": [
          "nczitzk"
        ],
        "example": "/aibase/discover",
        "parameters": {
          "id": "发现分类，默认为空，即全部产品，可在对应发现分类页 URL 中找到"
        },
        "description": "::: tip\n  若订阅 [图片背景移除](https://top.aibase.com/discover/37-49)，网址为 `https://top.aibase.com/discover/37-49`。截取 `https://top.aibase.com/discover/` 到末尾的部分 `37-49` 作为参数填入，此时路由为 [`/aibase/discover/37-49`](https://rsshub.app/aibase/discover/37-49)。\n:::\n\n<details>\n<summary>更多分类</summary>\n\n#### 图像处理\n\n| 分类                                                  | ID                                                |\n| ----------------------------------------------------- | ------------------------------------------------- |\n| [图片背景移除](https://top.aibase.com/discover/37-49) | [37-49](https://rsshub.app/aibase/discover/37-49) |\n| [图片无损放大](https://top.aibase.com/discover/37-50) | [37-50](https://rsshub.app/aibase/discover/37-50) |\n| [图片AI修复](https://top.aibase.com/discover/37-51)   | [37-51](https://rsshub.app/aibase/discover/37-51) |\n| [图像生成](https://top.aibase.com/discover/37-52)     | [37-52](https://rsshub.app/aibase/discover/37-52) |\n| [Ai图片拓展](https://top.aibase.com/discover/37-53)   | [37-53](https://rsshub.app/aibase/discover/37-53) |\n| [Ai漫画生成](https://top.aibase.com/discover/37-54)   | [37-54](https://rsshub.app/aibase/discover/37-54) |\n| [Ai生成写真](https://top.aibase.com/discover/37-55)   | [37-55](https://rsshub.app/aibase/discover/37-55) |\n| [电商图片制作](https://top.aibase.com/discover/37-83) | [37-83](https://rsshub.app/aibase/discover/37-83) |\n| [Ai图像转视频](https://top.aibase.com/discover/37-86) | [37-86](https://rsshub.app/aibase/discover/37-86) |\n\n#### 视频创作\n\n| 分类                                                | ID                                                |\n| --------------------------------------------------- | ------------------------------------------------- |\n| [视频剪辑](https://top.aibase.com/discover/38-56)   | [38-56](https://rsshub.app/aibase/discover/38-56) |\n| [生成视频](https://top.aibase.com/discover/38-57)   | [38-57](https://rsshub.app/aibase/discover/38-57) |\n| [Ai动画制作](https://top.aibase.com/discover/38-58) | [38-58](https://rsshub.app/aibase/discover/38-58) |\n| [字幕生成](https://top.aibase.com/discover/38-84)   | [38-84](https://rsshub.app/aibase/discover/38-84) |\n\n#### 效率助手\n\n| 分类                                                | ID                                                |\n| --------------------------------------------------- | ------------------------------------------------- |\n| [AI文档工具](https://top.aibase.com/discover/39-59) | [39-59](https://rsshub.app/aibase/discover/39-59) |\n| [PPT](https://top.aibase.com/discover/39-60)        | [39-60](https://rsshub.app/aibase/discover/39-60) |\n| [思维导图](https://top.aibase.com/discover/39-61)   | [39-61](https://rsshub.app/aibase/discover/39-61) |\n| [表格处理](https://top.aibase.com/discover/39-62)   | [39-62](https://rsshub.app/aibase/discover/39-62) |\n| [Ai办公助手](https://top.aibase.com/discover/39-63) | [39-63](https://rsshub.app/aibase/discover/39-63) |\n\n#### 写作灵感\n\n| 分类                                              | ID                                                |\n| ------------------------------------------------- | ------------------------------------------------- |\n| [文案写作](https://top.aibase.com/discover/40-64) | [40-64](https://rsshub.app/aibase/discover/40-64) |\n| [论文写作](https://top.aibase.com/discover/40-88) | [40-88](https://rsshub.app/aibase/discover/40-88) |\n\n#### 艺术灵感\n\n| 分类                                                | ID                                                |\n| --------------------------------------------------- | ------------------------------------------------- |\n| [音乐创作](https://top.aibase.com/discover/41-65)   | [41-65](https://rsshub.app/aibase/discover/41-65) |\n| [设计创作](https://top.aibase.com/discover/41-66)   | [41-66](https://rsshub.app/aibase/discover/41-66) |\n| [Ai图标生成](https://top.aibase.com/discover/41-67) | [41-67](https://rsshub.app/aibase/discover/41-67) |\n\n#### 趣味\n\n| 分类                                                  | ID                                                |\n| ----------------------------------------------------- | ------------------------------------------------- |\n| [Ai名字生成器](https://top.aibase.com/discover/42-68) | [42-68](https://rsshub.app/aibase/discover/42-68) |\n| [游戏娱乐](https://top.aibase.com/discover/42-71)     | [42-71](https://rsshub.app/aibase/discover/42-71) |\n| [其他](https://top.aibase.com/discover/42-72)         | [42-72](https://rsshub.app/aibase/discover/42-72) |\n\n#### 开发编程\n\n| 分类                                                | ID                                                |\n| --------------------------------------------------- | ------------------------------------------------- |\n| [开发编程](https://top.aibase.com/discover/43-73)   | [43-73](https://rsshub.app/aibase/discover/43-73) |\n| [Ai开放平台](https://top.aibase.com/discover/43-74) | [43-74](https://rsshub.app/aibase/discover/43-74) |\n| [Ai算力平台](https://top.aibase.com/discover/43-75) | [43-75](https://rsshub.app/aibase/discover/43-75) |\n\n#### 聊天机器人\n\n| 分类                                              | ID                                                |\n| ------------------------------------------------- | ------------------------------------------------- |\n| [智能聊天](https://top.aibase.com/discover/44-76) | [44-76](https://rsshub.app/aibase/discover/44-76) |\n| [智能客服](https://top.aibase.com/discover/44-77) | [44-77](https://rsshub.app/aibase/discover/44-77) |\n\n#### 翻译\n\n| 分类                                          | ID                                                |\n| --------------------------------------------- | ------------------------------------------------- |\n| [翻译](https://top.aibase.com/discover/46-79) | [46-79](https://rsshub.app/aibase/discover/46-79) |\n\n#### 教育学习\n\n| 分类                                              | ID                                                |\n| ------------------------------------------------- | ------------------------------------------------- |\n| [教育学习](https://top.aibase.com/discover/47-80) | [47-80](https://rsshub.app/aibase/discover/47-80) |\n\n#### 智能营销\n\n| 分类                                              | ID                                                |\n| ------------------------------------------------- | ------------------------------------------------- |\n| [智能营销](https://top.aibase.com/discover/48-81) | [48-81](https://rsshub.app/aibase/discover/48-81) |\n\n#### 法律\n\n| 分类                                            | ID                                                    |\n| ----------------------------------------------- | ----------------------------------------------------- |\n| [法律](https://top.aibase.com/discover/138-139) | [138-139](https://rsshub.app/aibase/discover/138-139) |\n</details>\n    ",
        "categories": [
          "new-media"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "top.aibase.com/discover/:id"
            ]
          },
          {
            "title": "图像处理 - 图片背景移除",
            "source": [
              "top.aibase.com/discover/37-49"
            ],
            "target": "/discover/37-49"
          },
          {
            "title": "图像处理 - 图片无损放大",
            "source": [
              "top.aibase.com/discover/37-50"
            ],
            "target": "/discover/37-50"
          },
          {
            "title": "图像处理 - 图片AI修复",
            "source": [
              "top.aibase.com/discover/37-51"
            ],
            "target": "/discover/37-51"
          },
          {
            "title": "图像处理 - 图像生成",
            "source": [
              "top.aibase.com/discover/37-52"
            ],
            "target": "/discover/37-52"
          },
          {
            "title": "图像处理 - Ai图片拓展",
            "source": [
              "top.aibase.com/discover/37-53"
            ],
            "target": "/discover/37-53"
          },
          {
            "title": "图像处理 - Ai漫画生成",
            "source": [
              "top.aibase.com/discover/37-54"
            ],
            "target": "/discover/37-54"
          },
          {
            "title": "图像处理 - Ai生成写真",
            "source": [
              "top.aibase.com/discover/37-55"
            ],
            "target": "/discover/37-55"
          },
          {
            "title": "图像处理 - 电商图片制作",
            "source": [
              "top.aibase.com/discover/37-83"
            ],
            "target": "/discover/37-83"
          },
          {
            "title": "图像处理 - Ai图像转视频",
            "source": [
              "top.aibase.com/discover/37-86"
            ],
            "target": "/discover/37-86"
          },
          {
            "title": "视频创作 - 视频剪辑",
            "source": [
              "top.aibase.com/discover/38-56"
            ],
            "target": "/discover/38-56"
          },
          {
            "title": "视频创作 - 生成视频",
            "source": [
              "top.aibase.com/discover/38-57"
            ],
            "target": "/discover/38-57"
          },
          {
            "title": "视频创作 - Ai动画制作",
            "source": [
              "top.aibase.com/discover/38-58"
            ],
            "target": "/discover/38-58"
          },
          {
            "title": "视频创作 - 字幕生成",
            "source": [
              "top.aibase.com/discover/38-84"
            ],
            "target": "/discover/38-84"
          },
          {
            "title": "效率助手 - AI文档工具",
            "source": [
              "top.aibase.com/discover/39-59"
            ],
            "target": "/discover/39-59"
          },
          {
            "title": "效率助手 - PPT",
            "source": [
              "top.aibase.com/discover/39-60"
            ],
            "target": "/discover/39-60"
          },
          {
            "title": "效率助手 - 思维导图",
            "source": [
              "top.aibase.com/discover/39-61"
            ],
            "target": "/discover/39-61"
          },
          {
            "title": "效率助手 - 表格处理",
            "source": [
              "top.aibase.com/discover/39-62"
            ],
            "target": "/discover/39-62"
          },
          {
            "title": "效率助手 - Ai办公助手",
            "source": [
              "top.aibase.com/discover/39-63"
            ],
            "target": "/discover/39-63"
          },
          {
            "title": "写作灵感 - 文案写作",
            "source": [
              "top.aibase.com/discover/40-64"
            ],
            "target": "/discover/40-64"
          },
          {
            "title": "写作灵感 - 论文写作",
            "source": [
              "top.aibase.com/discover/40-88"
            ],
            "target": "/discover/40-88"
          },
          {
            "title": "艺术灵感 - 音乐创作",
            "source": [
              "top.aibase.com/discover/41-65"
            ],
            "target": "/discover/41-65"
          },
          {
            "title": "艺术灵感 - 设计创作",
            "source": [
              "top.aibase.com/discover/41-66"
            ],
            "target": "/discover/41-66"
          },
          {
            "title": "艺术灵感 - Ai图标生成",
            "source": [
              "top.aibase.com/discover/41-67"
            ],
            "target": "/discover/41-67"
          },
          {
            "title": "趣味 - Ai名字生成器",
            "source": [
              "top.aibase.com/discover/42-68"
            ],
            "target": "/discover/42-68"
          },
          {
            "title": "趣味 - 游戏娱乐",
            "source": [
              "top.aibase.com/discover/42-71"
            ],
            "target": "/discover/42-71"
          },
          {
            "title": "趣味 - 其他",
            "source": [
              "top.aibase.com/discover/42-72"
            ],
            "target": "/discover/42-72"
          },
          {
            "title": "开发编程 - 开发编程",
            "source": [
              "top.aibase.com/discover/43-73"
            ],
            "target": "/discover/43-73"
          },
          {
            "title": "开发编程 - Ai开放平台",
            "source": [
              "top.aibase.com/discover/43-74"
            ],
            "target": "/discover/43-74"
          },
          {
            "title": "开发编程 - Ai算力平台",
            "source": [
              "top.aibase.com/discover/43-75"
            ],
            "target": "/discover/43-75"
          },
          {
            "title": "聊天机器人 - 智能聊天",
            "source": [
              "top.aibase.com/discover/44-76"
            ],
            "target": "/discover/44-76"
          },
          {
            "title": "聊天机器人 - 智能客服",
            "source": [
              "top.aibase.com/discover/44-77"
            ],
            "target": "/discover/44-77"
          },
          {
            "title": "翻译 - 翻译",
            "source": [
              "top.aibase.com/discover/46-79"
            ],
            "target": "/discover/46-79"
          },
          {
            "title": "教育学习 - 教育学习",
            "source": [
              "top.aibase.com/discover/47-80"
            ],
            "target": "/discover/47-80"
          },
          {
            "title": "智能营销 - 智能营销",
            "source": [
              "top.aibase.com/discover/48-81"
            ],
            "target": "/discover/48-81"
          },
          {
            "title": "法律 - 法律",
            "source": [
              "top.aibase.com/discover/138-139"
            ],
            "target": "/discover/138-139"
          }
        ],
        "location": "discover.ts",
        "module": () => import('@/routes/aibase/discover.ts')
      },
      "/news": {
        "path": "/news",
        "name": "资讯",
        "url": "www.aibase.com",
        "maintainers": [
          "zreo0"
        ],
        "example": "/aibase/news",
        "description": "获取 AI 资讯列表",
        "categories": [
          "new-media"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.aibase.com/zh/news"
            ],
            "target": "/news"
          }
        ],
        "location": "news.ts",
        "module": () => import('@/routes/aibase/news.ts')
      },
      "/topic/:id?/:filter?": {
        "path": "/topic/:id?/:filter?",
        "name": "标签",
        "url": "top.aibase.com",
        "maintainers": [
          "nczitzk"
        ],
        "example": "/aibase/topic",
        "parameters": {
          "id": "标签，默认为空，即全部产品，可在对应标签页 URL 中找到",
          "filter": "过滤器，默认为 `id` 即最新，可选 `pv` 即热门"
        },
        "description": "::: tip\n  若订阅 [AI](https://top.aibase.com/topic/AI)，网址为 `https://top.aibase.com/topic/AI`。截取 `https://top.aibase.com/topic` 到末尾的部分 `AI` 作为参数填入，此时路由为 [`/aibase/topic/AI`](https://rsshub.app/aibase/topic/AI)。\n:::\n\n::: tip\n  此处查看 [全部标签](https://top.aibase.com/topic)\n:::\n\n<details>\n<summary>更多标签</summary>\n\n| [AI](https://top.aibase.com/topic/AI)                                                               | [人工智能](https://top.aibase.com/topic/%E4%BA%BA%E5%B7%A5%E6%99%BA%E8%83%BD)                       | [图像生成](https://top.aibase.com/topic/%E5%9B%BE%E5%83%8F%E7%94%9F%E6%88%90)            | [自动化](https://top.aibase.com/topic/%E8%87%AA%E5%8A%A8%E5%8C%96)                       | [AI 助手](https://top.aibase.com/topic/AI%E5%8A%A9%E6%89%8B)                  |\n| --------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------- |\n| [聊天机器人](https://top.aibase.com/topic/%E8%81%8A%E5%A4%A9%E6%9C%BA%E5%99%A8%E4%BA%BA)            | [个性化](https://top.aibase.com/topic/%E4%B8%AA%E6%80%A7%E5%8C%96)                                  | [社交媒体](https://top.aibase.com/topic/%E7%A4%BE%E4%BA%A4%E5%AA%92%E4%BD%93)            | [图像处理](https://top.aibase.com/topic/%E5%9B%BE%E5%83%8F%E5%A4%84%E7%90%86)            | [数据分析](https://top.aibase.com/topic/%E6%95%B0%E6%8D%AE%E5%88%86%E6%9E%90) |\n| [自然语言处理](https://top.aibase.com/topic/%E8%87%AA%E7%84%B6%E8%AF%AD%E8%A8%80%E5%A4%84%E7%90%86) | [聊天](https://top.aibase.com/topic/%E8%81%8A%E5%A4%A9)                                             | [机器学习](https://top.aibase.com/topic/%E6%9C%BA%E5%99%A8%E5%AD%A6%E4%B9%A0)            | [教育](https://top.aibase.com/topic/%E6%95%99%E8%82%B2)                                  | [内容创作](https://top.aibase.com/topic/%E5%86%85%E5%AE%B9%E5%88%9B%E4%BD%9C) |\n| [生产力](https://top.aibase.com/topic/%E7%94%9F%E4%BA%A7%E5%8A%9B)                                  | [设计](https://top.aibase.com/topic/%E8%AE%BE%E8%AE%A1)                                             | [ChatGPT](https://top.aibase.com/topic/ChatGPT)                                          | [创意](https://top.aibase.com/topic/%E5%88%9B%E6%84%8F)                                  | [开源](https://top.aibase.com/topic/%E5%BC%80%E6%BA%90)                       |\n| [写作](https://top.aibase.com/topic/%E5%86%99%E4%BD%9C)                                             | [效率助手](https://top.aibase.com/topic/%E6%95%88%E7%8E%87%E5%8A%A9%E6%89%8B)                       | [学习](https://top.aibase.com/topic/%E5%AD%A6%E4%B9%A0)                                  | [插件](https://top.aibase.com/topic/%E6%8F%92%E4%BB%B6)                                  | [翻译](https://top.aibase.com/topic/%E7%BF%BB%E8%AF%91)                       |\n| [团队协作](https://top.aibase.com/topic/%E5%9B%A2%E9%98%9F%E5%8D%8F%E4%BD%9C)                       | [SEO](https://top.aibase.com/topic/SEO)                                                             | [营销](https://top.aibase.com/topic/%E8%90%A5%E9%94%80)                                  | [内容生成](https://top.aibase.com/topic/%E5%86%85%E5%AE%B9%E7%94%9F%E6%88%90)            | [AI 技术](https://top.aibase.com/topic/AI%E6%8A%80%E6%9C%AF)                  |\n| [AI 工具](https://top.aibase.com/topic/AI%E5%B7%A5%E5%85%B7)                                        | [智能助手](https://top.aibase.com/topic/%E6%99%BA%E8%83%BD%E5%8A%A9%E6%89%8B)                       | [深度学习](https://top.aibase.com/topic/%E6%B7%B1%E5%BA%A6%E5%AD%A6%E4%B9%A0)            | [多语言支持](https://top.aibase.com/topic/%E5%A4%9A%E8%AF%AD%E8%A8%80%E6%94%AF%E6%8C%81) | [视频](https://top.aibase.com/topic/%E8%A7%86%E9%A2%91)                       |\n| [艺术](https://top.aibase.com/topic/%E8%89%BA%E6%9C%AF)                                             | [文本生成](https://top.aibase.com/topic/%E6%96%87%E6%9C%AC%E7%94%9F%E6%88%90)                       | [开发编程](https://top.aibase.com/topic/%E5%BC%80%E5%8F%91%E7%BC%96%E7%A8%8B)            | [协作](https://top.aibase.com/topic/%E5%8D%8F%E4%BD%9C)                                  | [语言模型](https://top.aibase.com/topic/%E8%AF%AD%E8%A8%80%E6%A8%A1%E5%9E%8B) |\n| [工具](https://top.aibase.com/topic/%E5%B7%A5%E5%85%B7)                                             | [销售](https://top.aibase.com/topic/%E9%94%80%E5%94%AE)                                             | [生产力工具](https://top.aibase.com/topic/%E7%94%9F%E4%BA%A7%E5%8A%9B%E5%B7%A5%E5%85%B7) | [AI 写作](https://top.aibase.com/topic/AI%E5%86%99%E4%BD%9C)                             | [创作](https://top.aibase.com/topic/%E5%88%9B%E4%BD%9C)                       |\n| [工作效率](https://top.aibase.com/topic/%E5%B7%A5%E4%BD%9C%E6%95%88%E7%8E%87)                       | [无代码](https://top.aibase.com/topic/%E6%97%A0%E4%BB%A3%E7%A0%81)                                  | [隐私保护](https://top.aibase.com/topic/%E9%9A%90%E7%A7%81%E4%BF%9D%E6%8A%A4)            | [视频编辑](https://top.aibase.com/topic/%E8%A7%86%E9%A2%91%E7%BC%96%E8%BE%91)            | [摘要](https://top.aibase.com/topic/%E6%91%98%E8%A6%81)                       |\n| [多语言](https://top.aibase.com/topic/%E5%A4%9A%E8%AF%AD%E8%A8%80)                                  | [求职](https://top.aibase.com/topic/%E6%B1%82%E8%81%8C)                                             | [GPT](https://top.aibase.com/topic/GPT)                                                  | [音乐](https://top.aibase.com/topic/%E9%9F%B3%E4%B9%90)                                  | [视频创作](https://top.aibase.com/topic/%E8%A7%86%E9%A2%91%E5%88%9B%E4%BD%9C) |\n| [设计工具](https://top.aibase.com/topic/%E8%AE%BE%E8%AE%A1%E5%B7%A5%E5%85%B7)                       | [搜索](https://top.aibase.com/topic/%E6%90%9C%E7%B4%A2)                                             | [写作工具](https://top.aibase.com/topic/%E5%86%99%E4%BD%9C%E5%B7%A5%E5%85%B7)            | [视频生成](https://top.aibase.com/topic/%E8%A7%86%E9%A2%91%E7%94%9F%E6%88%90)            | [招聘](https://top.aibase.com/topic/%E6%8B%9B%E8%81%98)                       |\n| [代码生成](https://top.aibase.com/topic/%E4%BB%A3%E7%A0%81%E7%94%9F%E6%88%90)                       | [大型语言模型](https://top.aibase.com/topic/%E5%A4%A7%E5%9E%8B%E8%AF%AD%E8%A8%80%E6%A8%A1%E5%9E%8B) | [语音识别](https://top.aibase.com/topic/%E8%AF%AD%E9%9F%B3%E8%AF%86%E5%88%AB)            | [编程](https://top.aibase.com/topic/%E7%BC%96%E7%A8%8B)                                  | [在线工具](https://top.aibase.com/topic/%E5%9C%A8%E7%BA%BF%E5%B7%A5%E5%85%B7) |\n| [API](https://top.aibase.com/topic/API)                                                             | [趣味](https://top.aibase.com/topic/%E8%B6%A3%E5%91%B3)                                             | [客户支持](https://top.aibase.com/topic/%E5%AE%A2%E6%88%B7%E6%94%AF%E6%8C%81)            | [语音合成](https://top.aibase.com/topic/%E8%AF%AD%E9%9F%B3%E5%90%88%E6%88%90)            | [图像](https://top.aibase.com/topic/%E5%9B%BE%E5%83%8F)                       |\n| [电子商务](https://top.aibase.com/topic/%E7%94%B5%E5%AD%90%E5%95%86%E5%8A%A1)                       | [SEO 优化](https://top.aibase.com/topic/SEO%E4%BC%98%E5%8C%96)                                      | [AI 辅助](https://top.aibase.com/topic/AI%E8%BE%85%E5%8A%A9)                             | [AI 生成](https://top.aibase.com/topic/AI%E7%94%9F%E6%88%90)                             | [创作工具](https://top.aibase.com/topic/%E5%88%9B%E4%BD%9C%E5%B7%A5%E5%85%B7) |\n| [免费](https://top.aibase.com/topic/%E5%85%8D%E8%B4%B9)                                             | [LinkedIn](https://top.aibase.com/topic/LinkedIn)                                                   | [博客](https://top.aibase.com/topic/%E5%8D%9A%E5%AE%A2)                                  | [写作助手](https://top.aibase.com/topic/%E5%86%99%E4%BD%9C%E5%8A%A9%E6%89%8B)            | [助手](https://top.aibase.com/topic/%E5%8A%A9%E6%89%8B)                       |\n| [智能](https://top.aibase.com/topic/%E6%99%BA%E8%83%BD)                                             | [健康](https://top.aibase.com/topic/%E5%81%A5%E5%BA%B7)                                             | [多模态](https://top.aibase.com/topic/%E5%A4%9A%E6%A8%A1%E6%80%81)                       | [任务管理](https://top.aibase.com/topic/%E4%BB%BB%E5%8A%A1%E7%AE%A1%E7%90%86)            | [电子邮件](https://top.aibase.com/topic/%E7%94%B5%E5%AD%90%E9%82%AE%E4%BB%B6) |\n| [笔记](https://top.aibase.com/topic/%E7%AC%94%E8%AE%B0)                                             | [搜索引擎](https://top.aibase.com/topic/%E6%90%9C%E7%B4%A2%E5%BC%95%E6%93%8E)                       | [计算机视觉](https://top.aibase.com/topic/%E8%AE%A1%E7%AE%97%E6%9C%BA%E8%A7%86%E8%A7%89) | [社区](https://top.aibase.com/topic/%E7%A4%BE%E5%8C%BA)                                  | [效率](https://top.aibase.com/topic/%E6%95%88%E7%8E%87)                       |\n| [知识管理](https://top.aibase.com/topic/%E7%9F%A5%E8%AF%86%E7%AE%A1%E7%90%86)                       | [LLM](https://top.aibase.com/topic/LLM)                                                             | [智能聊天](https://top.aibase.com/topic/%E6%99%BA%E8%83%BD%E8%81%8A%E5%A4%A9)            | [社交](https://top.aibase.com/topic/%E7%A4%BE%E4%BA%A4)                                  | [语言学习](https://top.aibase.com/topic/%E8%AF%AD%E8%A8%80%E5%AD%A6%E4%B9%A0) |\n| [娱乐](https://top.aibase.com/topic/%E5%A8%B1%E4%B9%90)                                             | [简历](https://top.aibase.com/topic/%E7%AE%80%E5%8E%86)                                             | [OpenAI](https://top.aibase.com/topic/OpenAI)                                            | [客户服务](https://top.aibase.com/topic/%E5%AE%A2%E6%88%B7%E6%9C%8D%E5%8A%A1)            | [室内设计](https://top.aibase.com/topic/%E5%AE%A4%E5%86%85%E8%AE%BE%E8%AE%A1) |\n</details>\n    ",
        "categories": [
          "new-media"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "top.aibase.com/topic/:id"
            ]
          },
          {
            "title": "AI",
            "source": [
              "top.aibase.com/topic/AI"
            ],
            "target": "/topic/AI"
          },
          {
            "title": "人工智能",
            "source": [
              "top.aibase.com/topic/%E4%BA%BA%E5%B7%A5%E6%99%BA%E8%83%BD"
            ],
            "target": "/topic/人工智能"
          },
          {
            "title": "图像生成",
            "source": [
              "top.aibase.com/topic/%E5%9B%BE%E5%83%8F%E7%94%9F%E6%88%90"
            ],
            "target": "/topic/图像生成"
          },
          {
            "title": "自动化",
            "source": [
              "top.aibase.com/topic/%E8%87%AA%E5%8A%A8%E5%8C%96"
            ],
            "target": "/topic/自动化"
          },
          {
            "title": "AI助手",
            "source": [
              "top.aibase.com/topic/AI%E5%8A%A9%E6%89%8B"
            ],
            "target": "/topic/AI助手"
          },
          {
            "title": "聊天机器人",
            "source": [
              "top.aibase.com/topic/%E8%81%8A%E5%A4%A9%E6%9C%BA%E5%99%A8%E4%BA%BA"
            ],
            "target": "/topic/聊天机器人"
          },
          {
            "title": "个性化",
            "source": [
              "top.aibase.com/topic/%E4%B8%AA%E6%80%A7%E5%8C%96"
            ],
            "target": "/topic/个性化"
          },
          {
            "title": "社交媒体",
            "source": [
              "top.aibase.com/topic/%E7%A4%BE%E4%BA%A4%E5%AA%92%E4%BD%93"
            ],
            "target": "/topic/社交媒体"
          },
          {
            "title": "图像处理",
            "source": [
              "top.aibase.com/topic/%E5%9B%BE%E5%83%8F%E5%A4%84%E7%90%86"
            ],
            "target": "/topic/图像处理"
          },
          {
            "title": "数据分析",
            "source": [
              "top.aibase.com/topic/%E6%95%B0%E6%8D%AE%E5%88%86%E6%9E%90"
            ],
            "target": "/topic/数据分析"
          },
          {
            "title": "自然语言处理",
            "source": [
              "top.aibase.com/topic/%E8%87%AA%E7%84%B6%E8%AF%AD%E8%A8%80%E5%A4%84%E7%90%86"
            ],
            "target": "/topic/自然语言处理"
          },
          {
            "title": "聊天",
            "source": [
              "top.aibase.com/topic/%E8%81%8A%E5%A4%A9"
            ],
            "target": "/topic/聊天"
          },
          {
            "title": "机器学习",
            "source": [
              "top.aibase.com/topic/%E6%9C%BA%E5%99%A8%E5%AD%A6%E4%B9%A0"
            ],
            "target": "/topic/机器学习"
          },
          {
            "title": "教育",
            "source": [
              "top.aibase.com/topic/%E6%95%99%E8%82%B2"
            ],
            "target": "/topic/教育"
          },
          {
            "title": "内容创作",
            "source": [
              "top.aibase.com/topic/%E5%86%85%E5%AE%B9%E5%88%9B%E4%BD%9C"
            ],
            "target": "/topic/内容创作"
          },
          {
            "title": "生产力",
            "source": [
              "top.aibase.com/topic/%E7%94%9F%E4%BA%A7%E5%8A%9B"
            ],
            "target": "/topic/生产力"
          },
          {
            "title": "设计",
            "source": [
              "top.aibase.com/topic/%E8%AE%BE%E8%AE%A1"
            ],
            "target": "/topic/设计"
          },
          {
            "title": "ChatGPT",
            "source": [
              "top.aibase.com/topic/ChatGPT"
            ],
            "target": "/topic/ChatGPT"
          },
          {
            "title": "创意",
            "source": [
              "top.aibase.com/topic/%E5%88%9B%E6%84%8F"
            ],
            "target": "/topic/创意"
          },
          {
            "title": "开源",
            "source": [
              "top.aibase.com/topic/%E5%BC%80%E6%BA%90"
            ],
            "target": "/topic/开源"
          },
          {
            "title": "写作",
            "source": [
              "top.aibase.com/topic/%E5%86%99%E4%BD%9C"
            ],
            "target": "/topic/写作"
          },
          {
            "title": "效率助手",
            "source": [
              "top.aibase.com/topic/%E6%95%88%E7%8E%87%E5%8A%A9%E6%89%8B"
            ],
            "target": "/topic/效率助手"
          },
          {
            "title": "学习",
            "source": [
              "top.aibase.com/topic/%E5%AD%A6%E4%B9%A0"
            ],
            "target": "/topic/学习"
          },
          {
            "title": "插件",
            "source": [
              "top.aibase.com/topic/%E6%8F%92%E4%BB%B6"
            ],
            "target": "/topic/插件"
          },
          {
            "title": "翻译",
            "source": [
              "top.aibase.com/topic/%E7%BF%BB%E8%AF%91"
            ],
            "target": "/topic/翻译"
          },
          {
            "title": "团队协作",
            "source": [
              "top.aibase.com/topic/%E5%9B%A2%E9%98%9F%E5%8D%8F%E4%BD%9C"
            ],
            "target": "/topic/团队协作"
          },
          {
            "title": "SEO",
            "source": [
              "top.aibase.com/topic/SEO"
            ],
            "target": "/topic/SEO"
          },
          {
            "title": "营销",
            "source": [
              "top.aibase.com/topic/%E8%90%A5%E9%94%80"
            ],
            "target": "/topic/营销"
          },
          {
            "title": "内容生成",
            "source": [
              "top.aibase.com/topic/%E5%86%85%E5%AE%B9%E7%94%9F%E6%88%90"
            ],
            "target": "/topic/内容生成"
          },
          {
            "title": "AI技术",
            "source": [
              "top.aibase.com/topic/AI%E6%8A%80%E6%9C%AF"
            ],
            "target": "/topic/AI技术"
          },
          {
            "title": "AI工具",
            "source": [
              "top.aibase.com/topic/AI%E5%B7%A5%E5%85%B7"
            ],
            "target": "/topic/AI工具"
          },
          {
            "title": "智能助手",
            "source": [
              "top.aibase.com/topic/%E6%99%BA%E8%83%BD%E5%8A%A9%E6%89%8B"
            ],
            "target": "/topic/智能助手"
          },
          {
            "title": "深度学习",
            "source": [
              "top.aibase.com/topic/%E6%B7%B1%E5%BA%A6%E5%AD%A6%E4%B9%A0"
            ],
            "target": "/topic/深度学习"
          },
          {
            "title": "多语言支持",
            "source": [
              "top.aibase.com/topic/%E5%A4%9A%E8%AF%AD%E8%A8%80%E6%94%AF%E6%8C%81"
            ],
            "target": "/topic/多语言支持"
          },
          {
            "title": "视频",
            "source": [
              "top.aibase.com/topic/%E8%A7%86%E9%A2%91"
            ],
            "target": "/topic/视频"
          },
          {
            "title": "艺术",
            "source": [
              "top.aibase.com/topic/%E8%89%BA%E6%9C%AF"
            ],
            "target": "/topic/艺术"
          },
          {
            "title": "文本生成",
            "source": [
              "top.aibase.com/topic/%E6%96%87%E6%9C%AC%E7%94%9F%E6%88%90"
            ],
            "target": "/topic/文本生成"
          },
          {
            "title": "开发编程",
            "source": [
              "top.aibase.com/topic/%E5%BC%80%E5%8F%91%E7%BC%96%E7%A8%8B"
            ],
            "target": "/topic/开发编程"
          },
          {
            "title": "协作",
            "source": [
              "top.aibase.com/topic/%E5%8D%8F%E4%BD%9C"
            ],
            "target": "/topic/协作"
          },
          {
            "title": "语言模型",
            "source": [
              "top.aibase.com/topic/%E8%AF%AD%E8%A8%80%E6%A8%A1%E5%9E%8B"
            ],
            "target": "/topic/语言模型"
          },
          {
            "title": "工具",
            "source": [
              "top.aibase.com/topic/%E5%B7%A5%E5%85%B7"
            ],
            "target": "/topic/工具"
          },
          {
            "title": "销售",
            "source": [
              "top.aibase.com/topic/%E9%94%80%E5%94%AE"
            ],
            "target": "/topic/销售"
          },
          {
            "title": "生产力工具",
            "source": [
              "top.aibase.com/topic/%E7%94%9F%E4%BA%A7%E5%8A%9B%E5%B7%A5%E5%85%B7"
            ],
            "target": "/topic/生产力工具"
          },
          {
            "title": "AI写作",
            "source": [
              "top.aibase.com/topic/AI%E5%86%99%E4%BD%9C"
            ],
            "target": "/topic/AI写作"
          },
          {
            "title": "创作",
            "source": [
              "top.aibase.com/topic/%E5%88%9B%E4%BD%9C"
            ],
            "target": "/topic/创作"
          },
          {
            "title": "工作效率",
            "source": [
              "top.aibase.com/topic/%E5%B7%A5%E4%BD%9C%E6%95%88%E7%8E%87"
            ],
            "target": "/topic/工作效率"
          },
          {
            "title": "无代码",
            "source": [
              "top.aibase.com/topic/%E6%97%A0%E4%BB%A3%E7%A0%81"
            ],
            "target": "/topic/无代码"
          },
          {
            "title": "隐私保护",
            "source": [
              "top.aibase.com/topic/%E9%9A%90%E7%A7%81%E4%BF%9D%E6%8A%A4"
            ],
            "target": "/topic/隐私保护"
          },
          {
            "title": "视频编辑",
            "source": [
              "top.aibase.com/topic/%E8%A7%86%E9%A2%91%E7%BC%96%E8%BE%91"
            ],
            "target": "/topic/视频编辑"
          },
          {
            "title": "摘要",
            "source": [
              "top.aibase.com/topic/%E6%91%98%E8%A6%81"
            ],
            "target": "/topic/摘要"
          },
          {
            "title": "多语言",
            "source": [
              "top.aibase.com/topic/%E5%A4%9A%E8%AF%AD%E8%A8%80"
            ],
            "target": "/topic/多语言"
          },
          {
            "title": "求职",
            "source": [
              "top.aibase.com/topic/%E6%B1%82%E8%81%8C"
            ],
            "target": "/topic/求职"
          },
          {
            "title": "GPT",
            "source": [
              "top.aibase.com/topic/GPT"
            ],
            "target": "/topic/GPT"
          },
          {
            "title": "音乐",
            "source": [
              "top.aibase.com/topic/%E9%9F%B3%E4%B9%90"
            ],
            "target": "/topic/音乐"
          },
          {
            "title": "视频创作",
            "source": [
              "top.aibase.com/topic/%E8%A7%86%E9%A2%91%E5%88%9B%E4%BD%9C"
            ],
            "target": "/topic/视频创作"
          },
          {
            "title": "设计工具",
            "source": [
              "top.aibase.com/topic/%E8%AE%BE%E8%AE%A1%E5%B7%A5%E5%85%B7"
            ],
            "target": "/topic/设计工具"
          },
          {
            "title": "搜索",
            "source": [
              "top.aibase.com/topic/%E6%90%9C%E7%B4%A2"
            ],
            "target": "/topic/搜索"
          },
          {
            "title": "写作工具",
            "source": [
              "top.aibase.com/topic/%E5%86%99%E4%BD%9C%E5%B7%A5%E5%85%B7"
            ],
            "target": "/topic/写作工具"
          },
          {
            "title": "视频生成",
            "source": [
              "top.aibase.com/topic/%E8%A7%86%E9%A2%91%E7%94%9F%E6%88%90"
            ],
            "target": "/topic/视频生成"
          },
          {
            "title": "招聘",
            "source": [
              "top.aibase.com/topic/%E6%8B%9B%E8%81%98"
            ],
            "target": "/topic/招聘"
          },
          {
            "title": "代码生成",
            "source": [
              "top.aibase.com/topic/%E4%BB%A3%E7%A0%81%E7%94%9F%E6%88%90"
            ],
            "target": "/topic/代码生成"
          },
          {
            "title": "大型语言模型",
            "source": [
              "top.aibase.com/topic/%E5%A4%A7%E5%9E%8B%E8%AF%AD%E8%A8%80%E6%A8%A1%E5%9E%8B"
            ],
            "target": "/topic/大型语言模型"
          },
          {
            "title": "语音识别",
            "source": [
              "top.aibase.com/topic/%E8%AF%AD%E9%9F%B3%E8%AF%86%E5%88%AB"
            ],
            "target": "/topic/语音识别"
          },
          {
            "title": "编程",
            "source": [
              "top.aibase.com/topic/%E7%BC%96%E7%A8%8B"
            ],
            "target": "/topic/编程"
          },
          {
            "title": "在线工具",
            "source": [
              "top.aibase.com/topic/%E5%9C%A8%E7%BA%BF%E5%B7%A5%E5%85%B7"
            ],
            "target": "/topic/在线工具"
          },
          {
            "title": "API",
            "source": [
              "top.aibase.com/topic/API"
            ],
            "target": "/topic/API"
          },
          {
            "title": "趣味",
            "source": [
              "top.aibase.com/topic/%E8%B6%A3%E5%91%B3"
            ],
            "target": "/topic/趣味"
          },
          {
            "title": "客户支持",
            "source": [
              "top.aibase.com/topic/%E5%AE%A2%E6%88%B7%E6%94%AF%E6%8C%81"
            ],
            "target": "/topic/客户支持"
          },
          {
            "title": "语音合成",
            "source": [
              "top.aibase.com/topic/%E8%AF%AD%E9%9F%B3%E5%90%88%E6%88%90"
            ],
            "target": "/topic/语音合成"
          },
          {
            "title": "图像",
            "source": [
              "top.aibase.com/topic/%E5%9B%BE%E5%83%8F"
            ],
            "target": "/topic/图像"
          },
          {
            "title": "电子商务",
            "source": [
              "top.aibase.com/topic/%E7%94%B5%E5%AD%90%E5%95%86%E5%8A%A1"
            ],
            "target": "/topic/电子商务"
          },
          {
            "title": "SEO优化",
            "source": [
              "top.aibase.com/topic/SEO%E4%BC%98%E5%8C%96"
            ],
            "target": "/topic/SEO优化"
          },
          {
            "title": "AI辅助",
            "source": [
              "top.aibase.com/topic/AI%E8%BE%85%E5%8A%A9"
            ],
            "target": "/topic/AI辅助"
          },
          {
            "title": "AI生成",
            "source": [
              "top.aibase.com/topic/AI%E7%94%9F%E6%88%90"
            ],
            "target": "/topic/AI生成"
          },
          {
            "title": "创作工具",
            "source": [
              "top.aibase.com/topic/%E5%88%9B%E4%BD%9C%E5%B7%A5%E5%85%B7"
            ],
            "target": "/topic/创作工具"
          },
          {
            "title": "免费",
            "source": [
              "top.aibase.com/topic/%E5%85%8D%E8%B4%B9"
            ],
            "target": "/topic/免费"
          },
          {
            "title": "LinkedIn",
            "source": [
              "top.aibase.com/topic/LinkedIn"
            ],
            "target": "/topic/LinkedIn"
          },
          {
            "title": "博客",
            "source": [
              "top.aibase.com/topic/%E5%8D%9A%E5%AE%A2"
            ],
            "target": "/topic/博客"
          },
          {
            "title": "写作助手",
            "source": [
              "top.aibase.com/topic/%E5%86%99%E4%BD%9C%E5%8A%A9%E6%89%8B"
            ],
            "target": "/topic/写作助手"
          },
          {
            "title": "助手",
            "source": [
              "top.aibase.com/topic/%E5%8A%A9%E6%89%8B"
            ],
            "target": "/topic/助手"
          },
          {
            "title": "智能",
            "source": [
              "top.aibase.com/topic/%E6%99%BA%E8%83%BD"
            ],
            "target": "/topic/智能"
          },
          {
            "title": "健康",
            "source": [
              "top.aibase.com/topic/%E5%81%A5%E5%BA%B7"
            ],
            "target": "/topic/健康"
          },
          {
            "title": "多模态",
            "source": [
              "top.aibase.com/topic/%E5%A4%9A%E6%A8%A1%E6%80%81"
            ],
            "target": "/topic/多模态"
          },
          {
            "title": "任务管理",
            "source": [
              "top.aibase.com/topic/%E4%BB%BB%E5%8A%A1%E7%AE%A1%E7%90%86"
            ],
            "target": "/topic/任务管理"
          },
          {
            "title": "电子邮件",
            "source": [
              "top.aibase.com/topic/%E7%94%B5%E5%AD%90%E9%82%AE%E4%BB%B6"
            ],
            "target": "/topic/电子邮件"
          },
          {
            "title": "笔记",
            "source": [
              "top.aibase.com/topic/%E7%AC%94%E8%AE%B0"
            ],
            "target": "/topic/笔记"
          },
          {
            "title": "搜索引擎",
            "source": [
              "top.aibase.com/topic/%E6%90%9C%E7%B4%A2%E5%BC%95%E6%93%8E"
            ],
            "target": "/topic/搜索引擎"
          },
          {
            "title": "计算机视觉",
            "source": [
              "top.aibase.com/topic/%E8%AE%A1%E7%AE%97%E6%9C%BA%E8%A7%86%E8%A7%89"
            ],
            "target": "/topic/计算机视觉"
          },
          {
            "title": "社区",
            "source": [
              "top.aibase.com/topic/%E7%A4%BE%E5%8C%BA"
            ],
            "target": "/topic/社区"
          },
          {
            "title": "效率",
            "source": [
              "top.aibase.com/topic/%E6%95%88%E7%8E%87"
            ],
            "target": "/topic/效率"
          },
          {
            "title": "知识管理",
            "source": [
              "top.aibase.com/topic/%E7%9F%A5%E8%AF%86%E7%AE%A1%E7%90%86"
            ],
            "target": "/topic/知识管理"
          },
          {
            "title": "LLM",
            "source": [
              "top.aibase.com/topic/LLM"
            ],
            "target": "/topic/LLM"
          },
          {
            "title": "智能聊天",
            "source": [
              "top.aibase.com/topic/%E6%99%BA%E8%83%BD%E8%81%8A%E5%A4%A9"
            ],
            "target": "/topic/智能聊天"
          },
          {
            "title": "社交",
            "source": [
              "top.aibase.com/topic/%E7%A4%BE%E4%BA%A4"
            ],
            "target": "/topic/社交"
          },
          {
            "title": "语言学习",
            "source": [
              "top.aibase.com/topic/%E8%AF%AD%E8%A8%80%E5%AD%A6%E4%B9%A0"
            ],
            "target": "/topic/语言学习"
          },
          {
            "title": "娱乐",
            "source": [
              "top.aibase.com/topic/%E5%A8%B1%E4%B9%90"
            ],
            "target": "/topic/娱乐"
          },
          {
            "title": "简历",
            "source": [
              "top.aibase.com/topic/%E7%AE%80%E5%8E%86"
            ],
            "target": "/topic/简历"
          },
          {
            "title": "OpenAI",
            "source": [
              "top.aibase.com/topic/OpenAI"
            ],
            "target": "/topic/OpenAI"
          },
          {
            "title": "客户服务",
            "source": [
              "top.aibase.com/topic/%E5%AE%A2%E6%88%B7%E6%9C%8D%E5%8A%A1"
            ],
            "target": "/topic/客户服务"
          },
          {
            "title": "室内设计",
            "source": [
              "top.aibase.com/topic/%E5%AE%A4%E5%86%85%E8%AE%BE%E8%AE%A1"
            ],
            "target": "/topic/室内设计"
          }
        ],
        "location": "topic.ts",
        "module": () => import('@/routes/aibase/topic.ts')
      }
    },
    "name": "AIbase",
    "apiRoutes": {},
    "url": "aibase.com",
    "categories": [
      "new-media"
    ],
    "description": "",
    "lang": "zh-CN"
  },
  "aiblog-2xv": {
    "routes": {
      "/archives": {
        "path": "/archives",
        "categories": [
          "blog"
        ],
        "example": "/aiblog-2xv/archives",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "aiblog-2xv.pages.dev/archives"
            ],
            "target": "/archives"
          }
        ],
        "name": "归档-全部文章",
        "maintainers": [
          "Liao-Ke"
        ],
        "location": "archives.ts",
        "module": () => import('@/routes/aiblog-2xv/archives.ts')
      }
    },
    "name": "AI 博客",
    "apiRoutes": {},
    "url": "aiblog-2xv.pages.dev",
    "lang": "zh-CN"
  },
  "aicaijing": {
    "routes": {
      "/:category?/:id?": {
        "path": "/:category?/:id?",
        "name": "Unknown",
        "maintainers": [],
        "location": "index.tsx",
        "module": () => import('@/routes/aicaijing/index.tsx')
      }
    },
    "name": "AI 财经社",
    "apiRoutes": {},
    "url": "www.aicaijing.com",
    "lang": "zh-CN"
  },
  "aiea": {
    "routes": {
      "/seminars/:period": {
        "path": "/seminars/:period",
        "categories": [
          "study"
        ],
        "example": "/aiea/seminars/upcoming",
        "parameters": {
          "period": "Time frame"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "Seminar Series",
        "maintainers": [
          "zxx-457"
        ],
        "description": "| Time frame |\n| ---------- |\n| upcoming   |\n| past       |\n| both       |",
        "location": "index.ts",
        "module": () => import('@/routes/aiea/index.ts')
      }
    },
    "name": "Asian Innovation and Entrepreneurship Association",
    "apiRoutes": {},
    "url": "www.aiea.org",
    "lang": "en"
  },
  "aijishu": {
    "routes": {
      "/:type/:name?": {
        "path": "/:type/:name?",
        "categories": [
          "programming"
        ],
        "example": "/aijishu/channel/ai",
        "parameters": {
          "type": "文章类型，可以取值如下",
          "name": "名字，取自URL"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "频道、专栏、用户",
        "maintainers": [],
        "description": "| type    | 说明 |\n| ------- | ---- |\n| channel | 频道 |\n| blog    | 专栏 |\n| u       | 用户 |",
        "location": "index.ts",
        "module": () => import('@/routes/aijishu/index.ts')
      }
    },
    "name": "极术社区",
    "apiRoutes": {},
    "url": "www.aijishu",
    "lang": "zh-CN"
  },
  "ainvest": {
    "routes": {
      "/article": {
        "path": "/article",
        "categories": [
          "finance"
        ],
        "example": "/ainvest/article",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "ainvest.com/news"
            ]
          }
        ],
        "name": "Latest Article",
        "maintainers": [
          "TonyRL"
        ],
        "url": "ainvest.com/news",
        "location": "article.ts",
        "module": () => import('@/routes/ainvest/article.ts')
      },
      "/news": {
        "path": "/news",
        "categories": [
          "finance"
        ],
        "example": "/ainvest/news",
        "parameters": {},
        "view": 0,
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "ainvest.com/news"
            ]
          }
        ],
        "name": "Latest News",
        "maintainers": [
          "TonyRL"
        ],
        "url": "ainvest.com/news",
        "location": "news.ts",
        "module": () => import('@/routes/ainvest/news.ts')
      }
    },
    "name": "AInvest",
    "apiRoutes": {},
    "url": "ainvest.com",
    "lang": "en"
  },
  "aip": {
    "routes": {
      "/:pub/:jrn": {
        "path": "/:pub/:jrn",
        "categories": [
          "journal"
        ],
        "example": "/aip/aapt/ajp",
        "parameters": {
          "pub": "Publisher id",
          "jrn": "Journal id"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": true
        },
        "radar": [
          {
            "source": [
              "pubs.aip.org/:pub/:jrn"
            ]
          }
        ],
        "name": "Journal",
        "maintainers": [
          "Derekmini",
          "auto-bot-ty"
        ],
        "description": "Refer to the URL format `pubs.aip.org/:pub/:jrn`\n\n::: tip\n  More jounals can be found in [AIP Publications](https://publishing.aip.org/publications/find-the-right-journal).\n:::",
        "location": "journal.ts",
        "module": () => import('@/routes/aip/journal.ts')
      }
    },
    "name": "American Institute of Physics",
    "apiRoutes": {},
    "url": "pubs.aip.org",
    "lang": "en"
  },
  "air-level": {
    "routes": {
      "/air/:area": {
        "path": "/air/:area",
        "radar": [
          {
            "source": [
              "m.air-level.com/air/:area/"
            ],
            "target": "/air/:area"
          }
        ],
        "parameters": {
          "area": "地区"
        },
        "name": "空气质量",
        "maintainers": [
          "lifetraveler"
        ],
        "example": "/air-level/air/xian",
        "location": "index.ts",
        "module": () => import('@/routes/air-level/index.ts')
      },
      "/rank/:status?": {
        "path": [
          "/rank/:status?"
        ],
        "radar": [
          {
            "source": [
              "m.air-level.com/rank/:status",
              "m.air-level.com/rank"
            ],
            "target": "/rank/:status"
          }
        ],
        "parameters": {
          "status": "地区"
        },
        "name": "空气质量排行",
        "maintainers": [
          "lifetraveler"
        ],
        "example": "/air-level/rank/best,/air-level/rank",
        "location": "levelrank.ts",
        "module": () => import('@/routes/air-level/levelrank.ts')
      }
    },
    "name": "Air-Level",
    "apiRoutes": {},
    "url": "air-level.com",
    "description": "\n  - 可以订阅每个城市的空气质量，按照拼音订阅\n  - 支持订阅每天的实时排名\n    ",
    "categories": [
      "forecast"
    ],
    "lang": "zh-CN"
  },
  "airchina": {
    "routes": {
      "/announcement": {
        "path": "/announcement",
        "categories": [
          "travel"
        ],
        "example": "/airchina/announcement",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.airchina.com.cn/"
            ]
          }
        ],
        "name": "服务公告",
        "maintainers": [
          "LandonLi"
        ],
        "url": "www.airchina.com.cn/",
        "location": "index.ts",
        "module": () => import('@/routes/airchina/index.ts')
      }
    },
    "name": "中国国际航空公司",
    "apiRoutes": {},
    "url": "www.airchina.com.cn",
    "lang": "zh-CN"
  },
  "aisixiang": {
    "routes": {
      "/column/:id": {
        "path": "/column/:id",
        "categories": [
          "reading"
        ],
        "example": "/aisixiang/column/722",
        "parameters": {
          "id": "栏目 ID, 可在对应栏目 URL 中找到"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "栏目",
        "maintainers": [
          "HenryQW",
          "nczitzk"
        ],
        "location": "column.ts",
        "module": () => import('@/routes/aisixiang/column.ts')
      },
      "/thinktank/:id/:type?": {
        "path": "/thinktank/:id/:type?",
        "categories": [
          "reading"
        ],
        "example": "/aisixiang/thinktank/WuQine/论文",
        "parameters": {
          "id": "专栏 ID，一般为作者拼音，可在URL中找到",
          "type": "栏目类型，参考下表，默认为全部"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "思想库（专栏）",
        "maintainers": [
          "hoilc",
          "nczitzk"
        ],
        "description": "| 论文 | 时评 | 随笔 | 演讲 | 访谈 | 著作 | 读书 | 史论 | 译作 | 诗歌 | 书信 | 科学 |\n| ---- | ---- | ---- | ---- | ---- | ---- | ---- | ---- | ---- | ---- | ---- | ---- |",
        "location": "thinktank.ts",
        "module": () => import('@/routes/aisixiang/thinktank.ts')
      },
      "/ranking/:id?/:period?": {
        "path": [
          "/ranking/:id?/:period?",
          "/toplist/:id?/:period?"
        ],
        "name": "Unknown",
        "maintainers": [
          "HenryQW",
          "nczitzk"
        ],
        "description": "| 文章点击排行 | 最近更新文章 | 文章推荐排行 |\n| ------------ | ------------ | ------------ |\n| 1            | 10           | 11           |",
        "location": "toplist.ts",
        "module": () => import('@/routes/aisixiang/toplist.ts')
      },
      "/toplist/:id?/:period?": {
        "path": [
          "/ranking/:id?/:period?",
          "/toplist/:id?/:period?"
        ],
        "name": "Unknown",
        "maintainers": [
          "HenryQW",
          "nczitzk"
        ],
        "description": "| 文章点击排行 | 最近更新文章 | 文章推荐排行 |\n| ------------ | ------------ | ------------ |\n| 1            | 10           | 11           |",
        "location": "toplist.ts",
        "module": () => import('@/routes/aisixiang/toplist.ts')
      },
      "/zhuanti/:id": {
        "path": "/zhuanti/:id",
        "categories": [
          "reading"
        ],
        "example": "/aisixiang/zhuanti/211",
        "parameters": {
          "id": "专题 ID, 可在对应专题 URL 中找到"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "专题",
        "maintainers": [
          "nczitzk"
        ],
        "description": "::: tip\n  更多专题请见 [关键词](http://www.aisixiang.com/zhuanti/)\n:::",
        "location": "zhuanti.ts",
        "module": () => import('@/routes/aisixiang/zhuanti.ts')
      }
    },
    "name": "爱思想",
    "apiRoutes": {},
    "url": "aisixiang.com",
    "lang": "zh-CN"
  },
  "ajcass": {
    "routes": {
      "/shxyj/:year?/:issue?": {
        "path": "/shxyj/:year?/:issue?",
        "categories": [
          "journal"
        ],
        "example": "/ajcass/shxyj/2024/1",
        "parameters": {
          "year": "Year of the issue, `null` for the lastest",
          "issue": "Issue number, `null` for the lastest"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "社会学研究",
        "maintainers": [
          "CNYoki"
        ],
        "location": "shxyj.ts",
        "module": () => import('@/routes/ajcass/shxyj.ts')
      }
    },
    "name": "社科期刊网",
    "url": "ajcass.com",
    "description": "中国社会科学院学术期刊方阵",
    "lang": "zh-CN",
    "zh": {
      "name": "社科期刊网"
    }
  },
  "ajmide": {
    "routes": {
      "/:id": {
        "path": "/:id",
        "categories": [
          "multimedia"
        ],
        "view": 4,
        "example": "/ajmide/10603594",
        "parameters": {
          "id": "播客 id，可以从播客页面 URL 中找到"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "播客",
        "maintainers": [
          "Fatpandac"
        ],
        "location": "index.ts",
        "module": () => import('@/routes/ajmide/index.ts')
      }
    },
    "name": "阿基米德 FM",
    "apiRoutes": {},
    "url": "m.ajmide.com",
    "lang": "zh-CN"
  },
  "ali213": {
    "routes": {
      "/news/:category?": {
        "path": "/news/:category?",
        "name": "资讯",
        "url": "www.ali213.net",
        "maintainers": [
          "nczitzk"
        ],
        "example": "/ali213/news/new",
        "parameters": {
          "category": "分类，默认为 `new`，即最新资讯，可在对应分类页 URL 中找到"
        },
        "description": "::: tip\n若订阅 [游戏资讯](https://www.ali213.net/news/game/)，网址为 `https://www.ali213.net/news/game/`，请截取 `https://www.ali213.net/news/` 到末尾 `/` 的部分 `game` 作为 `category` 参数填入，此时目标路由为 [`/ali213/news/game`](https://rsshub.app/ali213/news/game)。\n:::\n\n| 分类名称 | 分类 ID |\n| -------- | ------- |\n| 最新资讯 | new     |\n| 评测     | pingce  |\n| 游戏     | game    |\n| 动漫     | comic   |\n| 影视     | movie   |\n| 科技     | tech    |\n| 电竞     | esports |\n| 娱乐     | amuse   |\n| 手游     | mobile  |\n",
        "categories": [
          "game"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.ali213.net/news/:category"
            ]
          },
          {
            "title": "最新资讯",
            "source": [
              "www.ali213.net/news/new"
            ],
            "target": "/news/new"
          },
          {
            "title": "评测",
            "source": [
              "www.ali213.net/news/pingce"
            ],
            "target": "/news/pingce"
          },
          {
            "title": "游戏",
            "source": [
              "www.ali213.net/news/game"
            ],
            "target": "/news/game"
          },
          {
            "title": "动漫",
            "source": [
              "www.ali213.net/news/comic"
            ],
            "target": "/news/comic"
          },
          {
            "title": "影视",
            "source": [
              "www.ali213.net/news/movie"
            ],
            "target": "/news/movie"
          },
          {
            "title": "科技",
            "source": [
              "www.ali213.net/news/tech"
            ],
            "target": "/news/tech"
          },
          {
            "title": "电竞",
            "source": [
              "www.ali213.net/news/esports"
            ],
            "target": "/news/esports"
          },
          {
            "title": "娱乐",
            "source": [
              "www.ali213.net/news/amuse"
            ],
            "target": "/news/amuse"
          },
          {
            "title": "手游",
            "source": [
              "www.ali213.net/news/mobile"
            ],
            "target": "/news/mobile"
          }
        ],
        "view": 0,
        "location": "news.ts",
        "module": () => import('@/routes/ali213/news.ts')
      },
      "/zl/:category?": {
        "path": "/zl/:category?",
        "name": "大侠号",
        "url": "www.ali213.net",
        "maintainers": [
          "nczitzk"
        ],
        "example": "/ali213/zl",
        "parameters": {
          "category": "分类，默认为首页，可在对应分类页 URL 中找到"
        },
        "description": "::: tip\n若订阅 [游戏](https://www.ali213.net/news/zl/game/)，网址为 `https://www.ali213.net/news/zl/game/`，请截取 `https://www.ali213.net/news/zl/` 到末尾 `/` 的部分 `game` 作为 `category` 参数填入，此时目标路由为 [`/ali213/zl/game`](https://rsshub.app/ali213/zl/game)。\n:::\n\n| 首页                                     | 游戏                                         | 动漫                                           | 影视                                           | 娱乐                                           |\n| ---------------------------------------- | -------------------------------------------- | ---------------------------------------------- | ---------------------------------------------- | ---------------------------------------------- |\n| [index](https://www.ali213.net/news/zl/) | [game](https://www.ali213.net/news/zl/game/) | [comic](https://www.ali213.net/news/zl/comic/) | [movie](https://www.ali213.net/news/zl/movie/) | [amuse](https://www.ali213.net/news/zl/amuse/) |\n",
        "categories": [
          "game"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.ali213.net/news/zl/:category"
            ]
          },
          {
            "title": "首页",
            "source": [
              "www.ali213.net/news/zl/"
            ],
            "target": "/zl"
          },
          {
            "title": "游戏",
            "source": [
              "www.ali213.net/news/zl/game/"
            ],
            "target": "/zl/game"
          },
          {
            "title": "动漫",
            "source": [
              "www.ali213.net/news/zl/comic/"
            ],
            "target": "/zl/comic"
          },
          {
            "title": "影视",
            "source": [
              "www.ali213.net/news/zl/movie/"
            ],
            "target": "/zl/movie"
          },
          {
            "title": "娱乐",
            "source": [
              "www.ali213.net/news/zl/amuse/"
            ],
            "target": "/zl/amuse"
          }
        ],
        "view": 0,
        "location": "zl.ts",
        "module": () => import('@/routes/ali213/zl.ts')
      }
    },
    "name": "游侠网",
    "url": "ali213.net",
    "categories": [
      "game"
    ],
    "description": "",
    "lang": "zh-CN"
  },
  "alicesoft": {
    "routes": {
      "/information/:category?/:game?": {
        "url": "www.alicesoft.com/information",
        "path": "/information/:category?/:game?",
        "categories": [
          "game"
        ],
        "example": "/alicesoft/information/game/cat377",
        "parameters": {
          "category": "Category in the URL, which can be accessed under カテゴリ一覧 on the website.",
          "game": "Game-specific subcategory in the URL, which can be accessed under カテゴリ一覧 on the website. In this case, the category value should be `game`."
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.alicesoft.com/information",
              "www.alicesoft.com/information/:category",
              "www.alicesoft.com/information/:category/:game"
            ],
            "target": "/information/:category/:game"
          }
        ],
        "name": "ニュース",
        "maintainers": [
          "keocheung"
        ],
        "location": "infomation.ts",
        "module": () => import('@/routes/alicesoft/infomation.ts')
      }
    },
    "name": "ALICESOFT",
    "apiRoutes": {},
    "url": "www.alicesoft.com",
    "lang": "ja"
  },
  "alipan": {
    "routes": {
      "/files/:share_id/:parent_file_id?": {
        "path": "/files/:share_id/:parent_file_id?",
        "example": "/alipan/files/jjtKEgXJAtC/64a957744876479ab17941b29d1289c6ebdd71ef",
        "parameters": {
          "share_id": "分享 id，可以从分享页面 URL 中找到",
          "parent_file_id": "文件夹 id，可以从文件夹页面 URL 中找到"
        },
        "radar": [
          {
            "source": [
              "www.alipan.com/s/:share_id/folder/:parent_file_id",
              "www.alipan.com/s/:share_id"
            ]
          }
        ],
        "name": "文件列表",
        "maintainers": [
          "DIYgod"
        ],
        "url": "www.alipan.com/s",
        "location": "files.ts",
        "module": () => import('@/routes/alipan/files.ts')
      }
    },
    "name": "阿里云盘",
    "apiRoutes": {},
    "url": "www.alipan.com",
    "categories": [
      "multimedia"
    ],
    "lang": "zh-CN"
  },
  "aliresearch": {
    "routes": {
      "/information/:type?": {
        "path": "/information/:type?",
        "categories": [
          "new-media"
        ],
        "example": "/aliresearch/information",
        "parameters": {
          "type": "类型，见下表，默认为新闻"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "aliresearch.com/cn/information",
              "aliresearch.com/"
            ],
            "target": "/information"
          }
        ],
        "name": "资讯",
        "maintainers": [
          "nczitzk"
        ],
        "url": "aliresearch.com/cn/information",
        "description": "| 新闻 | 观点 | 案例 |\n| ---- | ---- | ---- |",
        "location": "information.ts",
        "module": () => import('@/routes/aliresearch/information.ts')
      }
    },
    "name": "阿里研究院",
    "apiRoutes": {},
    "url": "aliresearch.com",
    "lang": "zh-CN"
  },
  "alistapart": {
    "routes": {
      "/": {
        "path": "/",
        "categories": [
          "programming"
        ],
        "radar": [
          {
            "source": [
              "alistapart.com/articles/"
            ],
            "target": "/"
          }
        ],
        "name": "Home Feed",
        "maintainers": [
          "Rjnishant530"
        ],
        "url": "alistapart.com/articles/",
        "example": "/alistapart",
        "location": "index.ts",
        "module": () => import('@/routes/alistapart/index.ts')
      },
      "/:topic": {
        "path": "/:topic",
        "categories": [
          "programming"
        ],
        "example": "/alistapart/application-development",
        "parameters": {
          "topic": "Any Topic or from the table below. Defaults to All Articles"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "alistapart.com/blog/topic/:topic"
            ],
            "target": "/:topic"
          }
        ],
        "name": "Topics",
        "maintainers": [
          "Rjnishant530"
        ],
        "url": "alistapart.com/articles/",
        "description": "You have the option to utilize the main heading or use individual categories as topics for the path.\n\n| **Code**                    | *code*                    |\n| --------------------------- | ------------------------- |\n| **Application Development** | *application-development* |\n| **Browsers**                | *browsers*                |\n| **CSS**                     | *css*                     |\n| **HTML**                    | *html*                    |\n| **JavaScript**              | *javascript*              |\n| **The Server Side**         | *the-server-side*         |\n\n| **Content**          | *content*          |\n| -------------------- | ------------------ |\n| **Community**        | *community*        |\n| **Content Strategy** | *content-strategy* |\n| **Writing**          | *writing*          |\n\n| **Design**                 | *design*               |\n| -------------------------- | ---------------------- |\n| **Brand Identity**         | *brand-identity*       |\n| **Graphic Design**         | *graphic-design*       |\n| **Layout & Grids**         | *layout-grids*         |\n| **Mobile/Multidevice**     | *mobile-multidevice*   |\n| **Responsive Design**      | *responsive-design*    |\n| **Typography & Web Fonts** | *typography-web-fonts* |\n\n| **Industry & Business** | *industry-business* |\n| ----------------------- | ------------------- |\n| **Business**            | *business*          |\n| **Career**              | *career*            |\n| **Industry**            | *industry*          |\n| **State of the Web**    | *state-of-the-web*  |\n\n| **Process**            | *process*            |\n| ---------------------- | -------------------- |\n| **Creativity**         | *creativity*         |\n| **Project Management** | *project-management* |\n| **Web Strategy**       | *web-strategy*       |\n| **Workflow & Tools**   | *workflow-tools*     |\n\n| **User Experience**          | *user-experience*          |\n| ---------------------------- | -------------------------- |\n| **Accessibility**            | *accessibility*            |\n| **Information Architecture** | *information-architecture* |\n| **Interaction Design**       | *interaction-design*       |\n| **Usability**                | *usability*                |\n| **User Research**            | *user-research*            |",
        "location": "topic.ts",
        "module": () => import('@/routes/alistapart/topic.ts')
      }
    },
    "name": "A List Apart",
    "apiRoutes": {},
    "url": "alistapart.com",
    "lang": "en"
  },
  "aliyun": {
    "routes": {
      "/database_month": {
        "path": "/database_month",
        "categories": [
          "programming"
        ],
        "example": "/aliyun/database_month",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "mysql.taobao.org/monthly",
              "mysql.taobao.org/"
            ]
          }
        ],
        "name": "数据库内核月报",
        "maintainers": [
          "junbaor"
        ],
        "url": "mysql.taobao.org/monthly",
        "location": "database-month.ts",
        "module": () => import('@/routes/aliyun/database-month.ts')
      },
      "/developer/group/:type": {
        "path": "/developer/group/:type",
        "categories": [
          "programming"
        ],
        "example": "/aliyun/developer/group/alitech",
        "parameters": {
          "type": "对应技术领域分类"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "developer.aliyun.com/group/:type"
            ]
          }
        ],
        "name": "开发者社区 - 主题",
        "maintainers": [
          "umm233"
        ],
        "location": "developer/group.ts",
        "module": () => import('@/routes/aliyun/developer/group.ts')
      },
      "/notice/:type?": {
        "path": "/notice/:type?",
        "categories": [
          "programming"
        ],
        "example": "/aliyun/notice",
        "parameters": {
          "type": "N"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "公告",
        "maintainers": [
          "muzea"
        ],
        "description": "| 类型     | type |\n| -------- | ---- |\n| 全部     |      |\n| 升级公告 | 1    |\n| 安全公告 | 2    |\n| 备案公告 | 3    |\n| 其他     | 4    |",
        "location": "notice.ts",
        "module": () => import('@/routes/aliyun/notice.ts')
      }
    },
    "name": "阿里云",
    "apiRoutes": {},
    "url": "developer.aliyun.com",
    "lang": "zh-CN"
  },
  "aljazeera": {
    "routes": {
      "*": {
        "path": "*",
        "name": "Unknown",
        "maintainers": [
          "nczitzk"
        ],
        "location": "index.tsx",
        "module": () => import('@/routes/aljazeera/index.tsx')
      }
    },
    "name": "Aljazeera",
    "apiRoutes": {},
    "url": "aljazeera.com",
    "lang": "en"
  },
  "ally": {
    "routes": {
      "/rail/:category?/:topic?": {
        "path": "/rail/:category?/:topic?",
        "categories": [
          "new-media"
        ],
        "example": "/ally/rail/hyzix/chengguijiaotong",
        "parameters": {
          "category": "分类，可在 URL 中找到；略去则抓取首页",
          "topic": "话题，可在 URL 中找到；并非所有页面均有此字段"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "rail.ally.net.cn/",
              "rail.ally.net.cn/html/:category?/:topic?"
            ]
          }
        ],
        "name": "世界轨道交通资讯网",
        "maintainers": [
          "Rongronggg9"
        ],
        "url": "rail.ally.net.cn/",
        "description": "::: tip\n  默认抓取前 20 条，可通过 `?limit=` 改变。\n:::",
        "location": "rail.ts",
        "module": () => import('@/routes/ally/rail.ts')
      }
    },
    "name": "艾莱资讯",
    "url": "rail.ally.net.cn",
    "lang": "zh-CN"
  },
  "alpinelinux": {
    "routes": {
      "/pkgs/:name/:routeParams?": {
        "name": "Packages",
        "categories": [
          "program-update"
        ],
        "maintainers": [
          "CaoMeiYouRen"
        ],
        "path": "/pkgs/:name/:routeParams?",
        "parameters": {
          "name": "Packages name",
          "routeParams": "Filters of packages type. E.g. branch=edge&repo=main&arch=armv7&maintainer=Jakub%20Jirutka"
        },
        "example": "/alpinelinux/pkgs/nodejs",
        "description": "Alpine Linux packages update",
        "radar": [
          {
            "source": [
              "https://pkgs.alpinelinux.org/packages"
            ]
          }
        ],
        "zh": {
          "name": "软件包",
          "description": "Alpine Linux 软件包更新"
        },
        "location": "pkgs.ts",
        "module": () => import('@/routes/alpinelinux/pkgs.ts')
      }
    },
    "name": "Alpine Linux",
    "url": "alpinelinux.org",
    "description": "Alpine Linux is a security-oriented, lightweight Linux distribution based on musl libc and busybox.",
    "zh": {
      "name": "Alpine Linux",
      "description": "Alpine Linux 是一个基于 musl libc 和 busybox 的面向安全的轻量级 Linux 发行版。"
    },
    "lang": "en"
  },
  "alternativeto": {
    "routes": {
      "/platform/:name/:routeParams?": {
        "path": "/platform/:name/:routeParams?",
        "categories": [
          "programming"
        ],
        "example": "/alternativeto/platform/firefox",
        "parameters": {
          "name": "Platform name",
          "routeParams": "Filters of software type"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": true,
          "antiCrawler": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.alternativeto.net/platform/:name"
            ],
            "target": "/platform/:name"
          }
        ],
        "name": "Platform Software",
        "maintainers": [
          "JimenezLi"
        ],
        "description": "> routeParms can be copied from original site URL, example: `/alternativeto/platform/firefox/license=free`",
        "location": "platform.ts",
        "module": () => import('@/routes/alternativeto/platform.ts')
      },
      "/software/:name/:routeParams?": {
        "path": "/software/:name/:routeParams?",
        "categories": [
          "programming"
        ],
        "example": "/alternativeto/software/cpp",
        "parameters": {
          "name": "Software name",
          "routeParams": "Filters of software type"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": true,
          "antiCrawler": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.alternativeto.net/software/:name"
            ],
            "target": "/software/:name"
          }
        ],
        "name": "Software Alternatives",
        "maintainers": [
          "JimenezLi"
        ],
        "description": "> routeParms can be copied from original site URL, example: `/alternativeto/software/cpp/license=opensource&platform=windows`",
        "location": "software.ts",
        "module": () => import('@/routes/alternativeto/software.ts')
      }
    },
    "name": "AlternativeTo",
    "url": "www.alternativeto.net",
    "lang": "en"
  },
  "altotrain": {
    "routes": {
      "/:language?": {
        "path": "/:language?",
        "categories": [
          "travel"
        ],
        "example": "/altotrain/en",
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "altotrain.ca/:language",
              "altotrain.ca/:language/news",
              "altotrain.ca/:language/nouvelles"
            ],
            "target": "/:language"
          }
        ],
        "name": "Alto News",
        "maintainers": [
          "elibroftw"
        ],
        "location": "news.ts",
        "module": () => import('@/routes/altotrain/news.ts')
      }
    },
    "name": "Alto - Toronto-Québec City High-Speed Rail Network",
    "url": "altotrain.ca",
    "lang": "en"
  },
  "alwayscontrol": {
    "routes": {
      "/news": {
        "path": "/news",
        "categories": [
          "other"
        ],
        "example": "/alwayscontrol/news",
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "最新动态",
        "maintainers": [
          "moss-xxh"
        ],
        "url": "alwayscontrol.com.cn",
        "radar": [
          {
            "source": [
              "www.alwayscontrol.com.cn/zh-CN/news/list"
            ],
            "target": "/news"
          }
        ],
        "description": "Always Control（旭衡电子）智能能源管理系统解决方案专家的最新动态",
        "location": "news.ts",
        "module": () => import('@/routes/alwayscontrol/news.ts')
      }
    },
    "name": "Always Control",
    "url": "alwayscontrol.com.cn",
    "lang": "zh-CN"
  },
  "amazfitwatchfaces": {
    "routes": {
      "/:device/:sort/:searchParams?": {
        "path": "/:device/:sort/:searchParams?",
        "name": "Watch Faces",
        "url": "amazfitwatchfaces.com",
        "maintainers": [
          "nczitzk"
        ],
        "example": "/amazfitwatchfaces/amazfit-x/fresh",
        "parameters": {
          "device": {
            "description": "Device Id",
            "options": [
              {
                "label": "Amazfit X",
                "value": "amazfit-x"
              },
              {
                "label": "Amazfit Band",
                "value": "amazfit-band"
              },
              {
                "label": "Amazfit Bip",
                "value": "bip"
              },
              {
                "label": "Amazfit Active",
                "value": "active"
              },
              {
                "label": "Amazfit Balance",
                "value": "balance"
              },
              {
                "label": "Amazfit Cheetah",
                "value": "cheetah"
              },
              {
                "label": "Amazfit Falcon",
                "value": "falcon"
              },
              {
                "label": "Amazfit GTR",
                "value": "gtr"
              },
              {
                "label": "Amazfit GTS",
                "value": "gts"
              },
              {
                "label": "Amazfit T-Rex",
                "value": "t-rex"
              },
              {
                "label": "Amazfit Stratos",
                "value": "pace"
              },
              {
                "label": "Amazfit Verge Lite",
                "value": "verge-lite"
              },
              {
                "label": "Haylou Watches",
                "value": "haylou"
              },
              {
                "label": "Huawei Watches",
                "value": "huawei-watch-gt"
              },
              {
                "label": "Xiaomi Mi Band 4",
                "value": "mi-band-4"
              },
              {
                "label": "Xiaomi Mi Band 5",
                "value": "mi-band-5"
              },
              {
                "label": "Xiaomi Mi Band 6",
                "value": "mi-band-6"
              },
              {
                "label": "Xiaomi Mi Band 7",
                "value": "mi-band-7"
              },
              {
                "label": "Xiaomi Smart Band 8",
                "value": "mi-band"
              },
              {
                "label": "Xiaomi Smart Band 9",
                "value": "mi-band"
              }
            ]
          },
          "sort": {
            "description": "Sort By",
            "options": [
              {
                "label": "Fresh",
                "value": "fresh"
              },
              {
                "label": "Updated",
                "value": "updated"
              },
              {
                "label": "Random",
                "value": "random"
              },
              {
                "label": "Top",
                "value": "top"
              }
            ]
          },
          "searchParams": {
            "description": "Search Params"
          }
        },
        "description": "::: tip\nIf you subscribe to [Updated watch faces for Amazfit X](https://amazfitwatchfaces.com/amazfit-x/updated)，where the URL is `https://amazfitwatchfaces.com/amazfit-x/updated`, extract the part `https://amazfitwatchfaces.com/` to the end, which is `amazfit-x/updated`, and use it as the parameter to fill in. Therefore, the route will be [`/amazfitwatchfaces/amazfit-x/updated`](https://rsshub.app/amazfitwatchfaces/amazfit-x/updated).\n\nIf you subscribe to [TOP for the last 6 months (Only new) - Xiaomi Smart Band 9](https://amazfitwatchfaces.com/mi-band/top?compatible=Smart_Band_9&topof=6months)，where the URL is `https://amazfitwatchfaces.com/mi-band/top?compatible=Smart_Band_9&topof=6months`, extract the part `https://amazfitwatchfaces.com/` to the end, which is `mi-band/top`, and use it as the parameter to fill in. Therefore, the route will be [`/amazfitwatchfaces/mi-band/top/compatible=Smart_Band_9&topof=6months`](https://rsshub.app/amazfitwatchfaces/mi-band/top/compatible=Smart_Band_9&topof=6months).\n:::\n\n<details>\n  <summary>More devices</summary>\n\n| Device Name                                                                                | Device Id       |\n| ------------------------------------------------------------------------------------------ | --------------- |\n| [Amazfit X](https://amazfitwatchfaces.com/amazfit-x/fresh)                                 | [amazfit-x](https://rsshub.app/amazfitwatchfaces/amazfit-x/fresh) |\n| [Amazfit Band](https://amazfitwatchfaces.com/amazfit-band/fresh)                           | [amazfit-band](https://rsshub.app/amazfitwatchfaces/amazfit-band/fresh) |\n| [Amazfit Bip](https://amazfitwatchfaces.com/bip/fresh)                                     | [bip](https://rsshub.app/amazfitwatchfaces/bip/fresh) |\n| [Amazfit Active](https://amazfitwatchfaces.com/active/fresh)                               | [active](https://rsshub.app/amazfitwatchfaces/active/fresh) |\n| [Amazfit Balance](https://amazfitwatchfaces.com/balance/fresh)                             | [balance](https://rsshub.app/amazfitwatchfaces/balance/fresh) |\n| [Amazfit Cheetah](https://amazfitwatchfaces.com/cheetah/fresh)                             | [cheetah](https://rsshub.app/amazfitwatchfaces/cheetah/fresh) |\n| [Amazfit Falcon](https://amazfitwatchfaces.com/falcon/fresh)                               | [falcon](https://rsshub.app/amazfitwatchfaces/falcon/fresh) |\n| [Amazfit GTR](https://amazfitwatchfaces.com/gtr/fresh)                                     | [gtr](https://rsshub.app/amazfitwatchfaces/gtr/fresh) |\n| [Amazfit GTS](https://amazfitwatchfaces.com/gts/fresh)                                     | [gts](https://rsshub.app/amazfitwatchfaces/gts/fresh) |\n| [Amazfit T-Rex](https://amazfitwatchfaces.com/t-rex/fresh)                                 | [t-rex](https://rsshub.app/amazfitwatchfaces/t-rex/fresh) |\n| [Amazfit Stratos](https://amazfitwatchfaces.com/pace/fresh)                                | [pace](https://rsshub.app/amazfitwatchfaces/pace/fresh) |\n| [Amazfit Verge Lite](https://amazfitwatchfaces.com/verge-lite/fresh)                       | [verge-lite](https://rsshub.app/amazfitwatchfaces/verge-lite/fresh) |\n| [Haylou Watches](https://amazfitwatchfaces.com/haylou/fresh)                               | [haylou](https://rsshub.app/amazfitwatchfaces/haylou/fresh) |\n| [Huawei Watches](https://amazfitwatchfaces.com/huawei-watch-gt/fresh)                      | [huawei-watch-gt](https://rsshub.app/amazfitwatchfaces/huawei-watch-gt/fresh) |\n| [Xiaomi Mi Band 4](https://amazfitwatchfaces.com/mi-band-4/fresh)                          | [mi-band-4](https://rsshub.app/amazfitwatchfaces/mi-band-4/fresh) |\n| [Xiaomi Mi Band 5](https://amazfitwatchfaces.com/mi-band-5/fresh)                          | [mi-band-5](https://rsshub.app/amazfitwatchfaces/mi-band-5/fresh) |\n| [Xiaomi Mi Band 6](https://amazfitwatchfaces.com/mi-band-6/fresh)                          | [mi-band-6](https://rsshub.app/amazfitwatchfaces/mi-band-6/fresh) |\n| [Xiaomi Mi Band 7](https://amazfitwatchfaces.com/mi-band-7/fresh)                          | [mi-band-7](https://rsshub.app/amazfitwatchfaces/mi-band-7/fresh) |\n| [Xiaomi Smart Band 8](https://amazfitwatchfaces.com/mi-band/fresh?compatible=Smart_Band_8) | [mi-band](https://rsshub.app/amazfitwatchfaces/mi-band/fresh/compatible=Smart_Band_8) |\n| [Xiaomi Smart Band 9](https://amazfitwatchfaces.com/mi-band/fresh?compatible=Smart_Band_9) | [mi-band](https://rsshub.app/amazfitwatchfaces/mi-band/fresh/compatible=Smart_Band_9) |\n\n</details>\n",
        "categories": [
          "program-update"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "amazfitwatchfaces.com/:device/:sort"
            ]
          },
          {
            "title": "Fresh watch faces for Amazfit X",
            "source": [
              "amazfitwatchfaces.com/amazfit-x/fresh"
            ],
            "target": "/amazfit-x/fresh"
          },
          {
            "title": "Fresh watch faces for Amazfit Band",
            "source": [
              "amazfitwatchfaces.com/amazfit-band/fresh"
            ],
            "target": "/amazfit-band/fresh"
          },
          {
            "title": "Fresh watch faces for Amazfit Bip",
            "source": [
              "amazfitwatchfaces.com/bip/fresh"
            ],
            "target": "/bip/fresh"
          },
          {
            "title": "Fresh watch faces for Amazfit Active",
            "source": [
              "amazfitwatchfaces.com/active/fresh"
            ],
            "target": "/active/fresh"
          },
          {
            "title": "Fresh watch faces for Amazfit Balance",
            "source": [
              "amazfitwatchfaces.com/balance/fresh"
            ],
            "target": "/balance/fresh"
          },
          {
            "title": "Fresh watch faces for Amazfit Cheetah",
            "source": [
              "amazfitwatchfaces.com/cheetah/fresh"
            ],
            "target": "/cheetah/fresh"
          },
          {
            "title": "Fresh watch faces for Amazfit Falcon",
            "source": [
              "amazfitwatchfaces.com/falcon/fresh"
            ],
            "target": "/falcon/fresh"
          },
          {
            "title": "Fresh watch faces for Amazfit GTR",
            "source": [
              "amazfitwatchfaces.com/gtr/fresh"
            ],
            "target": "/gtr/fresh"
          },
          {
            "title": "Fresh watch faces for Amazfit GTS",
            "source": [
              "amazfitwatchfaces.com/gts/fresh"
            ],
            "target": "/gts/fresh"
          },
          {
            "title": "Fresh watch faces for Amazfit T-Rex",
            "source": [
              "amazfitwatchfaces.com/t-rex/fresh"
            ],
            "target": "/t-rex/fresh"
          },
          {
            "title": "Fresh watch faces for Amazfit Stratos",
            "source": [
              "amazfitwatchfaces.com/pace/fresh"
            ],
            "target": "/pace/fresh"
          },
          {
            "title": "Fresh watch faces for Amazfit Verge Lite",
            "source": [
              "amazfitwatchfaces.com/verge-lite/fresh"
            ],
            "target": "/verge-lite/fresh"
          },
          {
            "title": "Fresh watch faces for Haylou Watches",
            "source": [
              "amazfitwatchfaces.com/haylou/fresh"
            ],
            "target": "/haylou/fresh"
          },
          {
            "title": "Fresh watch faces for Huawei Watches",
            "source": [
              "amazfitwatchfaces.com/huawei-watch-gt/fresh"
            ],
            "target": "/huawei-watch-gt/fresh"
          },
          {
            "title": "Fresh watch faces for Xiaomi Mi Band 4",
            "source": [
              "amazfitwatchfaces.com/mi-band-4/fresh"
            ],
            "target": "/mi-band-4/fresh"
          },
          {
            "title": "Fresh watch faces for Xiaomi Mi Band 5",
            "source": [
              "amazfitwatchfaces.com/mi-band-5/fresh"
            ],
            "target": "/mi-band-5/fresh"
          },
          {
            "title": "Fresh watch faces for Xiaomi Mi Band 6",
            "source": [
              "amazfitwatchfaces.com/mi-band-6/fresh"
            ],
            "target": "/mi-band-6/fresh"
          },
          {
            "title": "Fresh watch faces for Xiaomi Mi Band 7",
            "source": [
              "amazfitwatchfaces.com/mi-band-7/fresh"
            ],
            "target": "/mi-band-7/fresh"
          },
          {
            "title": "Fresh watch faces for Xiaomi Smart Band 8",
            "source": [
              "amazfitwatchfaces.com/mi-band/fresh"
            ],
            "target": "/mi-band/fresh/compatible=Smart_Band_8"
          },
          {
            "title": "Fresh watch faces for Xiaomi Smart Band 9",
            "source": [
              "amazfitwatchfaces.com/mi-band/fresh"
            ],
            "target": "/mi-band/fresh/compatible=Smart_Band_9"
          }
        ],
        "view": 0,
        "location": "index.ts",
        "module": () => import('@/routes/amazfitwatchfaces/index.ts')
      }
    },
    "name": "Amazfitwatchfaces",
    "apiRoutes": {},
    "url": "amazfitwatchfaces.com",
    "categories": [
      "program-update"
    ],
    "description": "amazfitwatchfaces.com is the world's largest collection of watch faces for Amazfit, Zepp, Bip, Pace, Stratos, Cor, Verge, Verge Lite, GTR, GTS, T-Rex, watches. Here you can find everything you need to customize & personalize your device! The website also has catalogs of watch faces for Xiaomi, Haylou, Honor and Huawei watches.",
    "lang": "en"
  },
  "amazon": {
    "routes": {
      "/awsblogs/:locale?": {
        "path": "/awsblogs/:locale?",
        "name": "Unknown",
        "maintainers": [
          "HankChow"
        ],
        "location": "awsblogs.ts",
        "module": () => import('@/routes/amazon/awsblogs.ts')
      },
      "/kindle/software-updates": {
        "path": "/kindle/software-updates",
        "categories": [
          "program-update"
        ],
        "example": "/amazon/kindle/software-updates",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "Kindle Software Updates",
        "maintainers": [
          "EthanWng97"
        ],
        "location": "kindle-software-updates.tsx",
        "module": () => import('@/routes/amazon/kindle-software-updates.tsx')
      }
    },
    "name": "Amazon",
    "apiRoutes": {},
    "url": "amazon.com",
    "lang": "en"
  },
  "amz123": {
    "routes": {
      "/kx": {
        "path": "/kx",
        "categories": [
          "new-media"
        ],
        "example": "/amz123/kx",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "amz123.com/kx"
            ],
            "target": "/kx"
          }
        ],
        "name": "AMZ123 快讯",
        "maintainers": [
          "defp"
        ],
        "url": "amz123.com/kx",
        "view": 0,
        "location": "kx.ts",
        "module": () => import('@/routes/amz123/kx.ts')
      }
    },
    "name": "Amz123",
    "apiRoutes": {},
    "url": "www.amz123.com",
    "categories": [
      "new-media"
    ],
    "description": "跨境电商平台",
    "lang": "zh-CN"
  },
  "android": {
    "routes": {
      "/platform-tools-releases": {
        "path": "/platform-tools-releases",
        "categories": [
          "program-update"
        ],
        "example": "/android/platform-tools-releases",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "developer.android.com/studio/releases/platform-tools",
              "developer.android.com/"
            ]
          }
        ],
        "name": "SDK Platform Tools release notes",
        "maintainers": [
          "nczitzk"
        ],
        "url": "developer.android.com/studio/releases/platform-tools",
        "location": "platform-tools-releases.ts",
        "module": () => import('@/routes/android/platform-tools-releases.ts')
      },
      "/security-bulletin": {
        "path": "/security-bulletin",
        "categories": [
          "program-update"
        ],
        "example": "/android/security-bulletin",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "source.android.com/docs/security/bulletin",
              "source.android.com/docs/security/bulletin/asb-overview",
              "source.android.com/"
            ]
          }
        ],
        "name": "Security Bulletins",
        "maintainers": [
          "TonyRL"
        ],
        "url": "source.android.com/docs/security/bulletin/asb-overview",
        "location": "security-bulletin.ts",
        "module": () => import('@/routes/android/security-bulletin.ts')
      }
    },
    "name": "Android",
    "url": "developer.android.com",
    "lang": "en"
  },
  "anime1": {
    "routes": {
      "anime/:category/:name": {
        "path": "anime/:category/:name",
        "name": "Anime",
        "url": "anime1.me",
        "maintainers": [
          "cxheng315"
        ],
        "example": "/anime1/anime/2024年夏季/神之塔-第二季",
        "categories": [
          "anime"
        ],
        "parameters": {
          "category": "Anime1 Category",
          "name": "Anime1 Name"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "anime1.me/category/:category/:name"
            ],
            "target": "/anime/:category/:name"
          }
        ],
        "location": "anime.ts",
        "module": () => import('@/routes/anime1/anime.ts')
      },
      "search/:keyword": {
        "path": "search/:keyword",
        "name": "Search",
        "url": "anime1.me",
        "maintainers": [
          "cxheng315"
        ],
        "example": "/anime1/search/神之塔",
        "categories": [
          "anime"
        ],
        "parameters": {
          "keyword": "Anime1 Search Keyword"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "location": "search.ts",
        "module": () => import('@/routes/anime1/search.ts')
      }
    },
    "name": "Anime1",
    "apiRoutes": {},
    "url": "anime1.me",
    "lang": "zh-TW"
  },
  "annualreviews": {
    "routes": {
      "/:id": {
        "path": "/:id",
        "categories": [
          "journal"
        ],
        "example": "/annualreviews/anchem",
        "parameters": {
          "id": "Journal id, can be found in URL"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": true
        },
        "radar": [
          {
            "source": [
              "annualreviews.org/journal/:id",
              "annualreviews.org/"
            ]
          }
        ],
        "name": "Journal",
        "maintainers": [
          "nczitzk"
        ],
        "description": "The URL of the journal [Annual Review of Analytical Chemistry](https://www.annualreviews.org/journal/anchem) is `https://www.annualreviews.org/journal/anchem`, where `anchem` is the id of the journal, so the route for this journal is `/annualreviews/anchem`.\n\n::: tip\n  More jounals can be found in [Browse Journals](https://www.annualreviews.org/action/showPublications).\n:::",
        "location": "index.ts",
        "module": () => import('@/routes/annualreviews/index.ts')
      }
    },
    "name": "Annual Reviews",
    "apiRoutes": {},
    "url": "annualreviews.org",
    "lang": "en"
  },
  "anquanke": {
    "routes": {
      "/:category/:fulltext?": {
        "path": "/:category/:fulltext?",
        "categories": [
          "programming"
        ],
        "example": "/anquanke/week",
        "parameters": {
          "category": "分类订阅",
          "fulltext": "是否获取全文，如需获取全文参数传入 `quanwen` 或 `fulltext`"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "分类订阅",
        "maintainers": [
          "qwertyuiop6"
        ],
        "description": "| 360 网络安全周报 | 活动     | 知识      | 资讯 | 招聘 | 工具 |\n| ---------------- | -------- | --------- | ---- | ---- | ---- |\n| week             | activity | knowledge | news | job  | tool |",
        "location": "category.ts",
        "module": () => import('@/routes/anquanke/category.ts')
      }
    },
    "name": "安全客",
    "apiRoutes": {},
    "url": "anquanke.com",
    "description": "::: tip\n官方提供了混合的主页资讯 RSS: [https://api.anquanke.com/data/v1/rss](https://api.anquanke.com/data/v1/rss)\n:::",
    "lang": "zh-CN"
  },
  "anthropic": {
    "routes": {
      "/engineering": {
        "path": "/engineering",
        "categories": [
          "programming"
        ],
        "example": "/anthropic/engineering",
        "parameters": {},
        "radar": [
          {
            "source": [
              "www.anthropic.com/engineering",
              "www.anthropic.com"
            ]
          }
        ],
        "name": "Engineering",
        "maintainers": [
          "TonyRL"
        ],
        "url": "www.anthropic.com/engineering",
        "location": "engineering.ts",
        "module": () => import('@/routes/anthropic/engineering.ts')
      },
      "/news": {
        "path": "/news",
        "categories": [
          "programming"
        ],
        "example": "/anthropic/news",
        "parameters": {},
        "radar": [
          {
            "source": [
              "www.anthropic.com/news",
              "www.anthropic.com"
            ]
          }
        ],
        "name": "News",
        "maintainers": [
          "etShaw-zh",
          "goestav"
        ],
        "url": "www.anthropic.com/news",
        "location": "news.ts",
        "module": () => import('@/routes/anthropic/news.ts')
      },
      "/red": {
        "path": "/red",
        "categories": [
          "programming"
        ],
        "example": "/anthropic/red",
        "radar": [
          {
            "source": [
              "red.anthropic.com"
            ]
          }
        ],
        "name": "Frontier Red Team",
        "maintainers": [
          "shoeper"
        ],
        "url": "red.anthropic.com",
        "location": "red.ts",
        "module": () => import('@/routes/anthropic/red.ts')
      },
      "/research": {
        "path": "/research",
        "categories": [
          "programming"
        ],
        "example": "/anthropic/research",
        "parameters": {},
        "radar": [
          {
            "source": [
              "www.anthropic.com/research",
              "www.anthropic.com"
            ]
          }
        ],
        "name": "Research",
        "maintainers": [
          "ttttmr"
        ],
        "url": "www.anthropic.com/research",
        "location": "research.ts",
        "module": () => import('@/routes/anthropic/research.ts')
      }
    },
    "name": "Anthropic",
    "apiRoutes": {},
    "url": "anthropic.com",
    "lang": "en"
  },
  "anytxt": {
    "routes": {
      "/release-notes": {
        "path": "/release-notes",
        "name": "Release Notes",
        "url": "anytxt.net",
        "maintainers": [
          "nczitzk"
        ],
        "example": "/anytxt/release-notes",
        "categories": [
          "program-update"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "anytxt.net"
            ],
            "target": "/anytxt/release-notes"
          }
        ],
        "view": 0,
        "location": "release-notes.ts",
        "module": () => import('@/routes/anytxt/release-notes.ts')
      }
    },
    "name": "Anytxt Searcher",
    "url": "anytxt.net",
    "categories": [
      "program-update"
    ],
    "description": "",
    "lang": "zh-CN"
  },
  "apache": {
    "routes": {
      "/apisix/blog": {
        "path": "/apisix/blog",
        "categories": [
          "blog"
        ],
        "example": "/apache/apisix/blog",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "APISIX 博客",
        "maintainers": [
          "aneasystone"
        ],
        "location": "apisix/blog.ts",
        "module": () => import('@/routes/apache/apisix/blog.ts')
      }
    },
    "name": "Apache",
    "apiRoutes": {},
    "url": "apisix.apache.org",
    "lang": "en"
  },
  "apiseven": {
    "routes": {
      "/blog": {
        "path": "/blog",
        "categories": [
          "blog"
        ],
        "example": "/apiseven/blog",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "博客",
        "maintainers": [
          "aneasystone"
        ],
        "location": "blog.ts",
        "module": () => import('@/routes/apiseven/blog.ts')
      }
    },
    "name": "支流科技",
    "apiRoutes": {},
    "url": "apiseven.com",
    "lang": "zh-CN"
  },
  "apkpure": {
    "routes": {
      "/versions/:pkg/:region?": {
        "path": "/versions/:pkg/:region?",
        "categories": [
          "program-update"
        ],
        "example": "/apkpure/versions/jp.co.craftegg.band/jp",
        "parameters": {
          "pkg": "Package name",
          "region": "Region code, `en` by default"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": true,
          "antiCrawler": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "Versions",
        "maintainers": [
          "maple3142"
        ],
        "location": "versions.ts",
        "module": () => import('@/routes/apkpure/versions.ts')
      }
    },
    "name": "APKPure",
    "url": "apkpure.com",
    "lang": "en"
  },
  "apnews": {
    "routes": {
      "/mobile/:path{.+}?": {
        "path": "/mobile/:path{.+}?",
        "categories": [
          "traditional-media"
        ],
        "example": "/apnews/mobile/ap-top-news",
        "view": 0,
        "parameters": {
          "path": {
            "description": "Corresponding path from AP News website",
            "default": "ap-top-news"
          }
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "apnews.com/"
            ]
          }
        ],
        "name": "News (from mobile client API)",
        "maintainers": [
          "dzx-dzx"
        ],
        "location": "mobile-api.ts",
        "module": () => import('@/routes/apnews/mobile-api.ts')
      },
      "/rss/:category?": {
        "path": "/rss/:category?",
        "categories": [
          "traditional-media"
        ],
        "example": "/apnews/rss/business",
        "view": 0,
        "parameters": {
          "category": {
            "description": "Category from the first segment of the corresponding site, or `index` for the front page.",
            "default": "index"
          }
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "apnews.com/:rss"
            ],
            "target": "/rss/:rss"
          }
        ],
        "name": "News",
        "maintainers": [
          "zoenglinghou",
          "mjysci",
          "TonyRL"
        ],
        "location": "rss.ts",
        "module": () => import('@/routes/apnews/rss.ts')
      },
      "/sitemap/:route": {
        "path": "/sitemap/:route",
        "categories": [
          "traditional-media"
        ],
        "example": "/apnews/sitemap/ap-sitemap-latest",
        "view": 0,
        "parameters": {
          "route": {
            "description": "Route for sitemap, excluding the `.xml` extension"
          }
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "apnews.com/"
            ]
          }
        ],
        "name": "Sitemap",
        "maintainers": [
          "zoenglinghou",
          "mjysci",
          "TonyRL",
          "dzx-dzx"
        ],
        "location": "sitemap.ts",
        "module": () => import('@/routes/apnews/sitemap.ts')
      },
      "/topics/:topic?": {
        "path": [
          "/topics/:topic?",
          "/nav/:nav{.*}?"
        ],
        "categories": [
          "traditional-media"
        ],
        "example": "/apnews/topics/apf-topnews",
        "view": 0,
        "parameters": {
          "topic": {
            "description": "Topic name, can be found in URL. For example: the topic name of AP Top News [https://apnews.com/apf-topnews](https://apnews.com/apf-topnews) is `apf-topnews`",
            "default": "trending-news"
          }
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "apnews.com/hub/:topic"
            ],
            "target": "/topics/:topic"
          }
        ],
        "name": "Topics",
        "maintainers": [
          "zoenglinghou",
          "mjysci",
          "TonyRL"
        ],
        "location": "topics.ts",
        "module": () => import('@/routes/apnews/topics.ts')
      },
      "/nav/:nav{.*}?": {
        "path": [
          "/topics/:topic?",
          "/nav/:nav{.*}?"
        ],
        "categories": [
          "traditional-media"
        ],
        "example": "/apnews/topics/apf-topnews",
        "view": 0,
        "parameters": {
          "topic": {
            "description": "Topic name, can be found in URL. For example: the topic name of AP Top News [https://apnews.com/apf-topnews](https://apnews.com/apf-topnews) is `apf-topnews`",
            "default": "trending-news"
          }
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "apnews.com/hub/:topic"
            ],
            "target": "/topics/:topic"
          }
        ],
        "name": "Topics",
        "maintainers": [
          "zoenglinghou",
          "mjysci",
          "TonyRL"
        ],
        "location": "topics.ts",
        "module": () => import('@/routes/apnews/topics.ts')
      }
    },
    "name": "AP News",
    "apiRoutes": {},
    "url": "apnews.com",
    "lang": "en"
  },
  "apnic": {
    "routes": {
      "/blog": {
        "path": "/blog",
        "categories": [
          "blog"
        ],
        "example": "/apnic/blog",
        "url": "blog.apnic.net",
        "name": "Blog",
        "maintainers": [
          "p3psi-boo"
        ],
        "location": "index.ts",
        "module": () => import('@/routes/apnic/index.ts')
      }
    },
    "name": "APNIC",
    "apiRoutes": {},
    "url": "blog.apnic.net",
    "description": "Asia-Pacific Network Information Centre",
    "lang": "en"
  },
  "app-center": {
    "routes": {
      "/release/:user/:app/:distribution_group": {
        "path": "/release/:user/:app/:distribution_group",
        "categories": [
          "program-update"
        ],
        "example": "/app-center/release/cloudflare/1.1.1.1-windows/beta",
        "parameters": {
          "user": "User",
          "app": "App name",
          "distribution_group": "Distribution group"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "install.appcenter.ms/users/:user/apps/:app/distribution_groups/:distribution_group",
              "install.appcenter.ms/orgs/:user/apps/:app/distribution_groups/:distribution_group"
            ]
          }
        ],
        "name": "Release",
        "maintainers": [
          "Rongronggg9"
        ],
        "description": "::: tip\n  The parameters can be extracted from the Release page URL: `https://install.appcenter.ms/users/:user/apps/:app/distribution_groups/:distribution_group`\n:::",
        "location": "release.tsx",
        "module": () => import('@/routes/app-center/release.tsx')
      }
    },
    "name": "App Center",
    "url": "install.appcenter.ms",
    "lang": "en"
  },
  "app-sales": {
    "routes": {
      "/:category?/:country?": {
        "path": "/:category?/:country?",
        "name": "Category",
        "url": "app-sales.net",
        "maintainers": [
          "nczitzk"
        ],
        "example": "/app-sales/highlights",
        "parameters": {
          "category": {
            "description": "Category, `highlights` as Highlights by default",
            "options": [
              {
                "label": "Highlights",
                "value": "highlights"
              },
              {
                "label": "Active Sales",
                "value": "activesales"
              },
              {
                "label": "Now Free",
                "value": "nowfree"
              }
            ]
          },
          "country": {
            "description": "Country ID, `us` as United States by default",
            "options": [
              {
                "label": "United States",
                "value": "us"
              },
              {
                "label": "Austria",
                "value": "at"
              },
              {
                "label": "Australia",
                "value": "au"
              },
              {
                "label": "Brazil",
                "value": "br"
              },
              {
                "label": "Canada",
                "value": "ca"
              },
              {
                "label": "France",
                "value": "fr"
              },
              {
                "label": "Germany",
                "value": "de"
              },
              {
                "label": "India",
                "value": "in"
              },
              {
                "label": "Italy",
                "value": "it"
              },
              {
                "label": "Netherlands",
                "value": "nl"
              },
              {
                "label": "Poland",
                "value": "pl"
              },
              {
                "label": "Russia",
                "value": "ru"
              },
              {
                "label": "Spain",
                "value": "es"
              },
              {
                "label": "Sweden",
                "value": "se"
              },
              {
                "label": "Great Britain",
                "value": "gb"
              }
            ]
          }
        },
        "description": "::: tip\nTo subscribe to [Highlights](https://www.app-sales.net/highlights/), where the source URL is `https://www.app-sales.net/highlights/`, extract the certain parts from this URL to be used as parameters, resulting in the route as [`/app-sales/highlights`](https://rsshub.app/app-sales/highlights).\n:::\n\n| Highlights | Active Sales | Now Free |\n| ---------- | ------------ | -------- |\n| highlights | activesales  | nowfree  |\n\n<details>\n  <summary>More countries</summary>\n\n| Currency | Country       | ID  |\n| -------- | ------------- | --- |\n| USD      | United States | us  |\n| EUR      | Austria       | at  |\n| AUD      | Australia     | au  |\n| BRL      | Brazil        | br  |\n| CAD      | Canada        | ca  |\n| EUR      | France        | fr  |\n| EUR      | Germany       | de  |\n| INR      | India         | in  |\n| EUR      | Italy         | it  |\n| EUR      | Netherlands   | nl  |\n| PLN      | Poland        | pl  |\n| RUB      | Russia        | ru  |\n| EUR      | Spain         | es  |\n| SEK      | Sweden        | se  |\n| GBP      | Great Britain | gb  |\n\n</details>\n",
        "categories": [
          "program-update"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "app-sales.net/:category"
            ]
          },
          {
            "title": "Highlights",
            "source": [
              "app-sales.net/highlights"
            ],
            "target": "/highlights"
          },
          {
            "title": "Active Sales",
            "source": [
              "app-sales.net/activesales"
            ],
            "target": "/activesales"
          },
          {
            "title": "Now Free",
            "source": [
              "app-sales.net/nowfree"
            ],
            "target": "/nowfree"
          }
        ],
        "view": 0,
        "location": "index.ts",
        "module": () => import('@/routes/app-sales/index.ts')
      },
      "/mostwanted/:time?/:country?": {
        "path": "/mostwanted/:time?/:country?",
        "name": "Watchlist Charts",
        "url": "app-sales.net",
        "maintainers": [
          "nczitzk"
        ],
        "example": "/app-sales/mostwanted",
        "parameters": {
          "time": {
            "description": "Time, `24h` as Last 24h by default",
            "options": [
              {
                "label": "Last 24h",
                "value": "24h"
              },
              {
                "label": "Last Week",
                "value": "week"
              },
              {
                "label": "All Time",
                "value": "alltime"
              }
            ]
          },
          "country": {
            "description": "Country ID, `us` as United States by default",
            "options": [
              {
                "label": "United States",
                "value": "us"
              },
              {
                "label": "Austria",
                "value": "at"
              },
              {
                "label": "Australia",
                "value": "au"
              },
              {
                "label": "Brazil",
                "value": "br"
              },
              {
                "label": "Canada",
                "value": "ca"
              },
              {
                "label": "France",
                "value": "fr"
              },
              {
                "label": "Germany",
                "value": "de"
              },
              {
                "label": "India",
                "value": "in"
              },
              {
                "label": "Italy",
                "value": "it"
              },
              {
                "label": "Netherlands",
                "value": "nl"
              },
              {
                "label": "Poland",
                "value": "pl"
              },
              {
                "label": "Russia",
                "value": "ru"
              },
              {
                "label": "Spain",
                "value": "es"
              },
              {
                "label": "Sweden",
                "value": "se"
              },
              {
                "label": "Great Britain",
                "value": "gb"
              }
            ]
          }
        },
        "description": "\n| Last 24h | Last Week | All Time |\n| -------- | --------- | -------- |\n| 24h      | week      | alltime  |\n\n<details>\n  <summary>More countries</summary>\n\n| Currency | Country       | ID  |\n| -------- | ------------- | --- |\n| USD      | United States | us  |\n| EUR      | Austria       | at  |\n| AUD      | Australia     | au  |\n| BRL      | Brazil        | br  |\n| CAD      | Canada        | ca  |\n| EUR      | France        | fr  |\n| EUR      | Germany       | de  |\n| INR      | India         | in  |\n| EUR      | Italy         | it  |\n| EUR      | Netherlands   | nl  |\n| PLN      | Poland        | pl  |\n| RUB      | Russia        | ru  |\n| EUR      | Spain         | es  |\n| SEK      | Sweden        | se  |\n| GBP      | Great Britain | gb  |\n\n</details>\n",
        "categories": [
          "program-update"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "app-sales.net/mostwanted"
            ],
            "target": "/mostwanted"
          },
          {
            "title": "Watchlist Charts - Last 24h",
            "source": [
              "app-sales.net/mostwanted"
            ],
            "target": "/mostwanted/24h"
          },
          {
            "title": "Watchlist Charts - Last Week",
            "source": [
              "app-sales.net/mostwanted"
            ],
            "target": "/mostwanted/week"
          },
          {
            "title": "Watchlist Charts - All Time",
            "source": [
              "app-sales.net/mostwanted"
            ],
            "target": "/mostwanted/alltime"
          }
        ],
        "view": 0,
        "location": "mostwanted.ts",
        "module": () => import('@/routes/app-sales/mostwanted.ts')
      }
    },
    "name": "AppSales",
    "apiRoutes": {},
    "url": "app-sales.net",
    "categories": [
      "program-update"
    ],
    "description": "Most recent discounted and temporarily free Android apps and games on Google Play",
    "lang": "en"
  },
  "apple": {
    "routes": {
      "/apps/update/:country/:id/:platform?": {
        "path": "/apps/update/:country/:id/:platform?",
        "categories": [
          "program-update"
        ],
        "view": 5,
        "example": "/apple/apps/update/us/id408709785",
        "parameters": {
          "country": "App Store Country, obtain from the app URL, see below",
          "id": "App id, obtain from the app URL",
          "platform": {
            "description": "App Platform, see below, all by default",
            "options": [
              {
                "value": "All",
                "label": "all"
              },
              {
                "value": "iOS",
                "label": "iOS"
              },
              {
                "value": "macOS",
                "label": "macOS"
              },
              {
                "value": "tvOS",
                "label": "tvOS"
              }
            ]
          }
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "apps.apple.com/:country/app/:appSlug/:id",
              "apps.apple.com/:country/app/:id"
            ],
            "target": "/apps/update/:country/:id"
          }
        ],
        "name": "App Update",
        "maintainers": [
          "EkkoG",
          "nczitzk"
        ],
        "description": "\n::: tip\n  For example, the URL of [GarageBand](https://apps.apple.com/us/app/garageband/id408709785) in the App Store is `https://apps.apple.com/us/app/garageband/id408709785`. In this case, the `App Store Country` parameter for the route is `us`, and the `App id` parameter is `id408709785`. So the route should be [`/apple/apps/update/us/id408709785`](https://rsshub.app/apple/apps/update/us/id408709785).\n:::",
        "location": "apps.ts",
        "module": () => import('@/routes/apple/apps.ts')
      },
      "/design": {
        "categories": [
          "design"
        ],
        "example": "/apple/design",
        "maintainers": [
          "jean-jacket"
        ],
        "name": "Design updates",
        "path": "/design",
        "url": "developer.apple.com/design/whats-new/",
        "location": "design.ts",
        "module": () => import('@/routes/apple/design.ts')
      },
      "/exchange_repair/:country?": {
        "path": "/exchange_repair/:country?",
        "categories": [
          "other"
        ],
        "example": "/apple/exchange_repair",
        "parameters": {
          "country": "country code in apple.com URL (exception: for `United States` please use `us`), default to China `cn`"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "support.apple.com/:country/service-programs"
            ],
            "target": "/exchange_repair/:country"
          }
        ],
        "name": "Exchange and Repair Extension Programs",
        "maintainers": [
          "metowolf",
          "HenryQW",
          "kt286"
        ],
        "location": "exchange-repair.ts",
        "module": () => import('@/routes/apple/exchange-repair.ts')
      },
      "/podcast/:id/:region?": {
        "path": "/podcast/:id/:region?",
        "categories": [
          "multimedia"
        ],
        "example": "/apple/podcast/id1559695855/cn",
        "parameters": {
          "id": "播客id，可以在 Apple 播客app 内分享的播客的 URL 中找到",
          "region": "地區代碼，例如 cn、us、jp，預設為 cn"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "podcasts.apple.com/:region/podcast/:showName/:id",
              "podcasts.apple.com/:region/podcast/:id"
            ]
          }
        ],
        "name": "播客",
        "maintainers": [
          "Acring"
        ],
        "url": "www.apple.com/apple-podcasts/",
        "location": "podcast.ts",
        "module": () => import('@/routes/apple/podcast.ts')
      },
      "/security-releases/:language?": {
        "path": "/security-releases/:language?",
        "name": "Security releases",
        "url": "support.apple.com",
        "maintainers": [
          "nczitzk"
        ],
        "example": "/apple/security-releases",
        "parameters": {
          "language": {
            "description": "Language, `en-us` by default"
          }
        },
        "description": "::: tip\nTo subscribe to [Apple security releases](https://support.apple.com/en-us/100100), where the source URL is `https://support.apple.com/en-us/100100`, extract the certain parts from this URL to be used as parameters, resulting in the route as [`/apple/security-releases/en-us`](https://rsshub.app/apple/security-releases/en-us).\n:::\n",
        "categories": [
          "program-update"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "support.apple.com/:language/100100"
            ]
          }
        ],
        "view": 0,
        "zh": {
          "path": "/security-releases/:language?",
          "name": "安全性发布",
          "url": "support.apple.com",
          "maintainers": [
            "nczitzk"
          ],
          "example": "/apple/security-releases",
          "parameters": {
            "language": {
              "description": "语言，默认为 `en-us`，可在对应页 URL 中找到"
            }
          },
          "description": "::: tip\n若订阅 [Apple 安全性发布](https://support.apple.com/zh-cn/100100)，网址为 `https://support.apple.com/zh-cn/100100`，请截取 `https://support.apple.com/` 到末尾 `/100100` 的部分 `zh-cn` 作为 `language` 参数填入，此时目标路由为 [`/apple/security-releases/zh-cn`](https://rsshub.app/apple/security-releases/zh-cn)。\n:::\n"
        },
        "location": "security-releases.ts",
        "module": () => import('@/routes/apple/security-releases.ts')
      }
    },
    "name": "Apple",
    "apiRoutes": {},
    "url": "apple.com",
    "lang": "en"
  },
  "appleinsider": {
    "routes": {
      "/:category?": {
        "path": "/:category?",
        "categories": [
          "new-media"
        ],
        "example": "/appleinsider",
        "parameters": {
          "category": "Category, see below, News by default"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "appleinsider.com/:category",
              "appleinsider.com/"
            ],
            "target": "/:category"
          }
        ],
        "name": "Category",
        "maintainers": [
          "nczitzk"
        ],
        "description": "| News | Reviews | How-tos |\n| ---- | ------- | ------- |\n|      | reviews | how-to  |",
        "location": "index.ts",
        "module": () => import('@/routes/appleinsider/index.ts')
      }
    },
    "name": "AppleInsider",
    "apiRoutes": {},
    "url": "appleinsider.com",
    "lang": "en"
  },
  "appstare": {
    "routes": {
      "/comments/:country/:appid": {
        "path": "/comments/:country/:appid",
        "name": "Comments",
        "url": "appstare.net/",
        "example": "/appstare/comments/cn/989673964",
        "maintainers": [
          "zhixideyu"
        ],
        "parameters": {
          "country": "App Store country code, e.g., US, CN",
          "appid": "Unique App Store application identifier (app id)"
        },
        "categories": [
          "program-update"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "appstare.net/"
            ]
          }
        ],
        "description": "Retrieve only the comments of the app from the past 7 days.",
        "location": "comments.ts",
        "module": () => import('@/routes/appstare/comments.ts')
      }
    },
    "name": "AppStare",
    "apiRoutes": {},
    "url": "appstare.net",
    "lang": "zh-CN"
  },
  "appstore": {
    "routes": {
      "/iap/:country/:id": {
        "path": "/iap/:country/:id",
        "categories": [
          "program-update"
        ],
        "example": "/appstore/iap/us/id953286746",
        "parameters": {
          "country": "App Store Country, obtain from the app URL https://apps.apple.com/us/app/id953286746, in this case, `us`",
          "id": "App Store app id, obtain from the app URL https://apps.apple.com/us/app/id953286746, in this case, `id953286746`"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "In-App-Purchase Price Drop Alert",
        "maintainers": [
          "HenryQW"
        ],
        "location": "in-app-purchase.ts",
        "module": () => import('@/routes/appstore/in-app-purchase.ts')
      },
      "/price/:country/:type/:id": {
        "path": "/price/:country/:type/:id",
        "categories": [
          "program-update"
        ],
        "example": "/appstore/price/us/mac/id1152443474",
        "parameters": {
          "country": "App Store Country, obtain from the app URL https://apps.apple.com/us/app/id1152443474, in this case, `us`",
          "type": "App type，either `iOS` or `mac`",
          "id": "App Store app id, obtain from the app URL https://apps.apple.com/us/app/id1152443474, in this case, `id1152443474`"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "apps.apple.com/"
            ]
          }
        ],
        "name": "Price Drop",
        "maintainers": [
          "HenryQW"
        ],
        "url": "apps.apple.com/",
        "location": "price.ts",
        "module": () => import('@/routes/appstore/price.ts')
      },
      "/xianmian": {
        "path": "/xianmian",
        "categories": [
          "program-update"
        ],
        "example": "/appstore/xianmian",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "app.so/xianmian"
            ]
          }
        ],
        "name": "每日精品限免 / 促销应用（鲜面连线 by AppSo）",
        "maintainers": [
          "Andiedie"
        ],
        "url": "app.so/xianmian",
        "location": "xianmian.ts",
        "module": () => import('@/routes/appstore/xianmian.ts')
      }
    },
    "name": "App Store/Mac App Store",
    "apiRoutes": {},
    "url": "apps.apple.com",
    "lang": "en"
  },
  "appstorrent": {
    "routes": {
      "/programs": {
        "path": "/programs",
        "categories": [
          "program-update"
        ],
        "example": "/appstorrent/programs",
        "name": "Programs",
        "maintainers": [
          "xzzpig"
        ],
        "url": "appstorrent.ru/programs/",
        "location": "programs.tsx",
        "module": () => import('@/routes/appstorrent/programs.tsx')
      }
    },
    "name": "AppsTorrent",
    "url": "appstorrent.ru",
    "lang": "ru"
  },
  "aqara": {
    "routes": {
      "/community/:id?/:keyword?": {
        "path": "/community/:id?/:keyword?",
        "categories": [
          "other"
        ],
        "example": "/aqara/community",
        "parameters": {
          "id": "分类 id，可在对应分类页 URL 中找到，默认为全部",
          "keyword": "关键字，默认为空"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "社区",
        "maintainers": [
          "nczitzk"
        ],
        "location": "community.ts",
        "module": () => import('@/routes/aqara/community.ts')
      },
      "/cn/news": {
        "path": "/cn/news",
        "name": "Unknown",
        "maintainers": [],
        "location": "news.ts",
        "module": () => import('@/routes/aqara/news.ts')
      },
      "*": {
        "path": "*",
        "name": "Unknown",
        "maintainers": [],
        "location": "post.tsx",
        "module": () => import('@/routes/aqara/post.tsx')
      },
      "/:region/:type?": {
        "path": "/:region/:type?",
        "name": "Unknown",
        "maintainers": [],
        "location": "region.ts",
        "module": () => import('@/routes/aqara/region.ts')
      }
    },
    "name": "Aqara",
    "apiRoutes": {},
    "url": "aqara.com",
    "lang": "zh-CN"
  },
  "aqicn": {
    "routes": {
      "/:city/:pollution?": {
        "path": "/:city/:pollution?",
        "categories": [
          "other"
        ],
        "example": "/aqicn/beijing/pm25",
        "parameters": {
          "city": "城市拼音或地区 ID，详见[aqicn.org](http://aqicn.org/city/)",
          "pollution": "可选择显示更详细的空气污染成分"
        },
        "radar": [
          {
            "source": [
              "aqicn.org"
            ]
          }
        ],
        "name": "实时 AQI",
        "maintainers": [
          "ladeng07"
        ],
        "url": "aqicn.org",
        "descriptions": "\n|   参数   | 污染成分 |\n| -------- | -------- |\n|   pm25   |  PM2.5   |\n|   pm10   |  PM10    |\n|   o3     |  O3      |\n|   no2    |  NO2     |\n|   so2    |  SO2     |\n|   co     |  CO      |\n\n举例: [https://rsshub.app/aqicn/beijing/pm25,pm10](https://rsshub.app/aqicn/beijing/pm25,pm10)\n\n1. 显示单个污染成分，例如「pm25」, [https://rsshub.app/aqicn/beijing/pm25](https://rsshub.app/aqicn/beijing/pm25)\n2. 逗号分隔显示多个污染成分，例如「pm25,pm10」，[https://rsshub.app/aqicn/beijing/pm25,pm10](https://rsshub.app/aqicn/beijing/pm25,pm10)\n3. 城市子站 ID 获取方法：右键显示网页源代码，搜索 \"idx\" （带双冒号），后面的 ID 就是子站的 ID，如你给的链接 ID 是 4258，RSS 地址就是 [https://rsshub.app/aqicn/4258](https://rsshub.app/aqicn/4258)\n",
        "location": "aqi.ts",
        "module": () => import('@/routes/aqicn/aqi.ts')
      }
    },
    "name": "空气质量",
    "apiRoutes": {},
    "url": "aqicn.org",
    "lang": "zh-CN"
  },
  "arcteryx": {
    "routes": {
      "/new-arrivals/:country/:gender": {
        "path": "/new-arrivals/:country/:gender",
        "categories": [
          "shopping"
        ],
        "example": "/arcteryx/new-arrivals/us/mens",
        "parameters": {
          "country": "country",
          "gender": "gender"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "arcteryx.com/:country/en/c/:gender/new-arrivals"
            ]
          }
        ],
        "name": "New Arrivals",
        "maintainers": [
          "EthanWng97"
        ],
        "description": "Country\n\n| United States | Canada | United Kingdom |\n| ------------- | ------ | -------------- |\n| us            | ca     | gb             |\n\n  gender\n\n| male | female |\n| ---- | ------ |\n| mens | womens |\n\n::: tip\n  Parameter `country` can be found within the url of `Arcteryx` website.\n:::",
        "location": "new-arrivals.ts",
        "module": () => import('@/routes/arcteryx/new-arrivals.ts')
      },
      "/outlet/:country/:gender": {
        "path": "/outlet/:country/:gender",
        "categories": [
          "shopping"
        ],
        "example": "/arcteryx/outlet/us/mens",
        "parameters": {
          "country": "country",
          "gender": "gender"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "outlet.arcteryx.com/:country/en/c/:gender"
            ]
          }
        ],
        "name": "Outlet",
        "maintainers": [
          "EthanWng97"
        ],
        "description": "Country\n\n| United States | Canada | United Kingdom |\n| ------------- | ------ | -------------- |\n| us            | ca     | gb             |\n\n  gender\n\n| male | female |\n| ---- | ------ |\n| mens | womens |\n\n::: tip\n  Parameter `country` can be found within the url of `Arcteryx` website.\n:::",
        "location": "outlet.ts",
        "module": () => import('@/routes/arcteryx/outlet.ts')
      },
      "/regear/new-arrivals": {
        "path": "/regear/new-arrivals",
        "categories": [
          "shopping"
        ],
        "example": "/arcteryx/regear/new-arrivals",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "regear.arcteryx.com/shop/new-arrivals",
              "regear.arcteryx.com/"
            ]
          }
        ],
        "name": "Regear New Arrivals",
        "maintainers": [
          "EthanWng97"
        ],
        "url": "regear.arcteryx.com/shop/new-arrivals",
        "location": "regear-new-arrivals.tsx",
        "module": () => import('@/routes/arcteryx/regear-new-arrivals.tsx')
      }
    },
    "name": "Arcteryx",
    "url": "arcteryx.com",
    "lang": "zh-CN"
  },
  "artstation": {
    "routes": {
      "/:handle": {
        "path": "/:handle",
        "categories": [
          "picture"
        ],
        "example": "/artstation/wlop",
        "parameters": {
          "handle": "Artist handle, can be found in URL"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.artstation.com/:handle"
            ]
          }
        ],
        "name": "Artist Profolio",
        "maintainers": [
          "TonyRL"
        ],
        "location": "user.ts",
        "module": () => import('@/routes/artstation/user.ts')
      }
    },
    "name": "ArtStation",
    "url": "www.artstation.com",
    "lang": "en"
  },
  "asiafruitchina": {
    "routes": {
      "/categories/:category?": {
        "path": "/categories/:category?",
        "name": "果蔬品项",
        "url": "asiafruitchina.net",
        "maintainers": [
          "nczitzk"
        ],
        "example": "/asiafruitchina/categories/all",
        "parameters": {
          "category": {
            "description": "分类，默认为 `all`，即全部，可在对应分类页 URL 中找到",
            "options": [
              {
                "label": "全部",
                "value": "all"
              },
              {
                "label": "橙",
                "value": "chengzi"
              },
              {
                "label": "百香果",
                "value": "baixiangguo"
              },
              {
                "label": "菠萝/凤梨",
                "value": "boluo"
              },
              {
                "label": "菠萝蜜",
                "value": "boluomi"
              },
              {
                "label": "草莓",
                "value": "caomei"
              },
              {
                "label": "番荔枝/释迦",
                "value": "fanlizhi"
              },
              {
                "label": "番茄",
                "value": "fanqie"
              },
              {
                "label": "柑橘",
                "value": "ganju"
              },
              {
                "label": "哈密瓜",
                "value": "hamigua"
              },
              {
                "label": "核果",
                "value": "heguo"
              },
              {
                "label": "红毛丹",
                "value": "hongmaodan"
              },
              {
                "label": "火龙果",
                "value": "huolongguo"
              },
              {
                "label": "浆果",
                "value": "jiangguo"
              },
              {
                "label": "桔子",
                "value": "juzi"
              },
              {
                "label": "蓝莓",
                "value": "lanmei"
              },
              {
                "label": "梨",
                "value": "li"
              },
              {
                "label": "荔枝",
                "value": "lizhi"
              },
              {
                "label": "李子",
                "value": "lizi"
              },
              {
                "label": "榴莲",
                "value": "liulian"
              },
              {
                "label": "龙眼",
                "value": "lognyan"
              },
              {
                "label": "芦笋",
                "value": "lusun"
              },
              {
                "label": "蔓越莓",
                "value": "manyuemei"
              },
              {
                "label": "芒果",
                "value": "mangguo"
              },
              {
                "label": "猕猴桃/奇异果",
                "value": "mihoutao"
              },
              {
                "label": "柠檬",
                "value": "ningmeng"
              },
              {
                "label": "牛油果",
                "value": "niuyouguo"
              },
              {
                "label": "苹果",
                "value": "pingguo"
              },
              {
                "label": "葡萄/提子",
                "value": "putao"
              },
              {
                "label": "其他",
                "value": "qita"
              },
              {
                "label": "奇异莓",
                "value": "qiyimei"
              },
              {
                "label": "热带水果",
                "value": "redaishuiguo"
              },
              {
                "label": "山竹",
                "value": "shanzhu"
              },
              {
                "label": "石榴",
                "value": "shiliu"
              },
              {
                "label": "蔬菜",
                "value": "shucai"
              },
              {
                "label": "树莓",
                "value": "shumei"
              },
              {
                "label": "桃",
                "value": "tao"
              },
              {
                "label": "甜瓜",
                "value": "tiangua"
              },
              {
                "label": "甜椒",
                "value": "tianjiao"
              },
              {
                "label": "甜柿",
                "value": "tianshi"
              },
              {
                "label": "香蕉",
                "value": "xiangjiao"
              },
              {
                "label": "西瓜",
                "value": "xigua"
              },
              {
                "label": "西梅",
                "value": "ximei"
              },
              {
                "label": "杏",
                "value": "xing"
              },
              {
                "label": "椰子",
                "value": "yezi"
              },
              {
                "label": "杨梅",
                "value": "yangmei"
              },
              {
                "label": "樱桃",
                "value": "yintao"
              },
              {
                "label": "油桃",
                "value": "youtao"
              },
              {
                "label": "柚子",
                "value": "youzi"
              }
            ]
          }
        },
        "description": "::: tip\n若订阅 [橙](https://asiafruitchina.net/categories?gspx=chengzi)，网址为 `https://asiafruitchina.net/categories?gspx=chengzi`，请截取 `https://asiafruitchina.net/categories?gspx=` 到末尾的部分 `chengzi` 作为 `category` 参数填入，此时目标路由为 [`/asiafruitchina/categories/chengzi`](https://rsshub.app/asiafruitchina/categories/chengzi)。\n:::\n\n<details>\n  <summary>更多分类</summary>\n\n  | [全部](https://asiafruitchina.net/categories?gspx=all)  | [橙](https://asiafruitchina.net/categories?gspx=chengzi)        | [百香果](https://asiafruitchina.net/categories?gspx=baixiangguo)        | [菠萝/凤梨](https://asiafruitchina.net/categories?gspx=boluo) | [菠萝蜜](https://asiafruitchina.net/categories?gspx=boluomi)    |\n  | ------------------------------------------------------- | --------------------------------------------------------------- | ----------------------------------------------------------------------- | ------------------------------------------------------------- | --------------------------------------------------------------- |\n  | [all](https://rsshub.app/asiafruitchina/categories/all) | [chengzi](https://rsshub.app/asiafruitchina/categories/chengzi) | [baixiangguo](https://rsshub.app/asiafruitchina/categories/baixiangguo) | [boluo](https://rsshub.app/asiafruitchina/categories/boluo)   | [boluomi](https://rsshub.app/asiafruitchina/categories/boluomi) |\n\n  | [草莓](https://asiafruitchina.net/categories?gspx=caomei)     | [番荔枝/释迦](https://asiafruitchina.net/categories?gspx=fanlizhi) | [番茄](https://asiafruitchina.net/categories?gspx=fanqie)     | [柑橘](https://asiafruitchina.net/categories?gspx=ganju)    | [哈密瓜](https://asiafruitchina.net/categories?gspx=hamigua)    |\n  | ------------------------------------------------------------- | ------------------------------------------------------------------ | ------------------------------------------------------------- | ----------------------------------------------------------- | --------------------------------------------------------------- |\n  | [caomei](https://rsshub.app/asiafruitchina/categories/caomei) | [fanlizhi](https://rsshub.app/asiafruitchina/categories/fanlizhi)  | [fanqie](https://rsshub.app/asiafruitchina/categories/fanqie) | [ganju](https://rsshub.app/asiafruitchina/categories/ganju) | [hamigua](https://rsshub.app/asiafruitchina/categories/hamigua) |\n\n  | [核果](https://asiafruitchina.net/categories?gspx=heguo)    | [红毛丹](https://asiafruitchina.net/categories?gspx=hongmaodan)       | [火龙果](https://asiafruitchina.net/categories?gspx=huolongguo)       | [浆果](https://asiafruitchina.net/categories?gspx=jiangguo)       | [桔子](https://asiafruitchina.net/categories?gspx=juzi)   |\n  | ----------------------------------------------------------- | --------------------------------------------------------------------- | --------------------------------------------------------------------- | ----------------------------------------------------------------- | --------------------------------------------------------- |\n  | [heguo](https://rsshub.app/asiafruitchina/categories/heguo) | [hongmaodan](https://rsshub.app/asiafruitchina/categories/hongmaodan) | [huolongguo](https://rsshub.app/asiafruitchina/categories/huolongguo) | [jiangguo](https://rsshub.app/asiafruitchina/categories/jiangguo) | [juzi](https://rsshub.app/asiafruitchina/categories/juzi) |\n\n  | [蓝莓](https://asiafruitchina.net/categories?gspx=lanmei)     | [梨](https://asiafruitchina.net/categories?gspx=li)   | [荔枝](https://asiafruitchina.net/categories?gspx=lizhi)    | [李子](https://asiafruitchina.net/categories?gspx=lizi)   | [榴莲](https://asiafruitchina.net/categories?gspx=liulian)      |\n  | ------------------------------------------------------------- | ----------------------------------------------------- | ----------------------------------------------------------- | --------------------------------------------------------- | --------------------------------------------------------------- |\n  | [lanmei](https://rsshub.app/asiafruitchina/categories/lanmei) | [li](https://rsshub.app/asiafruitchina/categories/li) | [lizhi](https://rsshub.app/asiafruitchina/categories/lizhi) | [lizi](https://rsshub.app/asiafruitchina/categories/lizi) | [liulian](https://rsshub.app/asiafruitchina/categories/liulian) |\n\n  | [龙眼](https://asiafruitchina.net/categories?gspx=lognyan)      | [芦笋](https://asiafruitchina.net/categories?gspx=lusun)    | [蔓越莓](https://asiafruitchina.net/categories?gspx=manyuemei)      | [芒果](https://asiafruitchina.net/categories?gspx=mangguo)      | [猕猴桃/奇异果](https://asiafruitchina.net/categories?gspx=mihoutao) |\n  | --------------------------------------------------------------- | ----------------------------------------------------------- | ------------------------------------------------------------------- | --------------------------------------------------------------- | -------------------------------------------------------------------- |\n  | [lognyan](https://rsshub.app/asiafruitchina/categories/lognyan) | [lusun](https://rsshub.app/asiafruitchina/categories/lusun) | [manyuemei](https://rsshub.app/asiafruitchina/categories/manyuemei) | [mangguo](https://rsshub.app/asiafruitchina/categories/mangguo) | [mihoutao](https://rsshub.app/asiafruitchina/categories/mihoutao)    |\n\n  | [柠檬](https://asiafruitchina.net/categories?gspx=ningmeng)       | [牛油果](https://asiafruitchina.net/categories?gspx=niuyouguo)      | [苹果](https://asiafruitchina.net/categories?gspx=pingguo)      | [葡萄/提子](https://asiafruitchina.net/categories?gspx=putao) | [其他](https://asiafruitchina.net/categories?gspx=qita)   |\n  | ----------------------------------------------------------------- | ------------------------------------------------------------------- | --------------------------------------------------------------- | ------------------------------------------------------------- | --------------------------------------------------------- |\n  | [ningmeng](https://rsshub.app/asiafruitchina/categories/ningmeng) | [niuyouguo](https://rsshub.app/asiafruitchina/categories/niuyouguo) | [pingguo](https://rsshub.app/asiafruitchina/categories/pingguo) | [putao](https://rsshub.app/asiafruitchina/categories/putao)   | [qita](https://rsshub.app/asiafruitchina/categories/qita) |\n\n  | [奇异莓](https://asiafruitchina.net/categories?gspx=qiyimei)    | [热带水果](https://asiafruitchina.net/categories?gspx=redaishuiguo)       | [山竹](https://asiafruitchina.net/categories?gspx=shanzhu)      | [石榴](https://asiafruitchina.net/categories?gspx=shiliu)     | [蔬菜](https://asiafruitchina.net/categories?gspx=shucai)     |\n  | --------------------------------------------------------------- | ------------------------------------------------------------------------- | --------------------------------------------------------------- | ------------------------------------------------------------- | ------------------------------------------------------------- |\n  | [qiyimei](https://rsshub.app/asiafruitchina/categories/qiyimei) | [redaishuiguo](https://rsshub.app/asiafruitchina/categories/redaishuiguo) | [shanzhu](https://rsshub.app/asiafruitchina/categories/shanzhu) | [shiliu](https://rsshub.app/asiafruitchina/categories/shiliu) | [shucai](https://rsshub.app/asiafruitchina/categories/shucai) |\n\n  | [树莓](https://asiafruitchina.net/categories?gspx=shumei)     | [桃](https://asiafruitchina.net/categories?gspx=tao)    | [甜瓜](https://asiafruitchina.net/categories?gspx=tiangua)      | [甜椒](https://asiafruitchina.net/categories?gspx=tianjiao)       | [甜柿](https://asiafruitchina.net/categories?gspx=tianshi)      |\n  | ------------------------------------------------------------- | ------------------------------------------------------- | --------------------------------------------------------------- | ----------------------------------------------------------------- | --------------------------------------------------------------- |\n  | [shumei](https://rsshub.app/asiafruitchina/categories/shumei) | [tao](https://rsshub.app/asiafruitchina/categories/tao) | [tiangua](https://rsshub.app/asiafruitchina/categories/tiangua) | [tianjiao](https://rsshub.app/asiafruitchina/categories/tianjiao) | [tianshi](https://rsshub.app/asiafruitchina/categories/tianshi) |\n\n  | [香蕉](https://asiafruitchina.net/categories?gspx=xiangjiao)        | [西瓜](https://asiafruitchina.net/categories?gspx=xigua)    | [西梅](https://asiafruitchina.net/categories?gspx=ximei)    | [杏](https://asiafruitchina.net/categories?gspx=xing)     | [椰子](https://asiafruitchina.net/categories?gspx=yezi)   |\n  | ------------------------------------------------------------------- | ----------------------------------------------------------- | ----------------------------------------------------------- | --------------------------------------------------------- | --------------------------------------------------------- |\n  | [xiangjiao](https://rsshub.app/asiafruitchina/categories/xiangjiao) | [xigua](https://rsshub.app/asiafruitchina/categories/xigua) | [ximei](https://rsshub.app/asiafruitchina/categories/ximei) | [xing](https://rsshub.app/asiafruitchina/categories/xing) | [yezi](https://rsshub.app/asiafruitchina/categories/yezi) |\n\n  | [杨梅](https://asiafruitchina.net/categories?gspx=yangmei)      | [樱桃](https://asiafruitchina.net/categories?gspx=yintao)     | [油桃](https://asiafruitchina.net/categories?gspx=youtao)     | [柚子](https://asiafruitchina.net/categories?gspx=youzi)    |\n  | --------------------------------------------------------------- | ------------------------------------------------------------- | ------------------------------------------------------------- | ----------------------------------------------------------- |\n  | [yangmei](https://rsshub.app/asiafruitchina/categories/yangmei) | [yintao](https://rsshub.app/asiafruitchina/categories/yintao) | [youtao](https://rsshub.app/asiafruitchina/categories/youtao) | [youzi](https://rsshub.app/asiafruitchina/categories/youzi) |\n\n</details>\n",
        "categories": [
          "new-media"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "asiafruitchina.net/categories"
            ]
          },
          {
            "title": "全部",
            "source": [
              "asiafruitchina.net/categories"
            ],
            "target": "/categories/all"
          },
          {
            "title": "橙",
            "source": [
              "asiafruitchina.net/categories"
            ],
            "target": "/categories/chengzi"
          },
          {
            "title": "百香果",
            "source": [
              "asiafruitchina.net/categories"
            ],
            "target": "/categories/baixiangguo"
          },
          {
            "title": "菠萝/凤梨",
            "source": [
              "asiafruitchina.net/categories"
            ],
            "target": "/categories/boluo"
          },
          {
            "title": "菠萝蜜",
            "source": [
              "asiafruitchina.net/categories"
            ],
            "target": "/categories/boluomi"
          },
          {
            "title": "草莓",
            "source": [
              "asiafruitchina.net/categories"
            ],
            "target": "/categories/caomei"
          },
          {
            "title": "番荔枝/释迦",
            "source": [
              "asiafruitchina.net/categories"
            ],
            "target": "/categories/fanlizhi"
          },
          {
            "title": "番茄",
            "source": [
              "asiafruitchina.net/categories"
            ],
            "target": "/categories/fanqie"
          },
          {
            "title": "柑橘",
            "source": [
              "asiafruitchina.net/categories"
            ],
            "target": "/categories/ganju"
          },
          {
            "title": "哈密瓜",
            "source": [
              "asiafruitchina.net/categories"
            ],
            "target": "/categories/hamigua"
          },
          {
            "title": "核果",
            "source": [
              "asiafruitchina.net/categories"
            ],
            "target": "/categories/heguo"
          },
          {
            "title": "红毛丹",
            "source": [
              "asiafruitchina.net/categories"
            ],
            "target": "/categories/hongmaodan"
          },
          {
            "title": "火龙果",
            "source": [
              "asiafruitchina.net/categories"
            ],
            "target": "/categories/huolongguo"
          },
          {
            "title": "浆果",
            "source": [
              "asiafruitchina.net/categories"
            ],
            "target": "/categories/jiangguo"
          },
          {
            "title": "桔子",
            "source": [
              "asiafruitchina.net/categories"
            ],
            "target": "/categories/juzi"
          },
          {
            "title": "蓝莓",
            "source": [
              "asiafruitchina.net/categories"
            ],
            "target": "/categories/lanmei"
          },
          {
            "title": "梨",
            "source": [
              "asiafruitchina.net/categories"
            ],
            "target": "/categories/li"
          },
          {
            "title": "荔枝",
            "source": [
              "asiafruitchina.net/categories"
            ],
            "target": "/categories/lizhi"
          },
          {
            "title": "李子",
            "source": [
              "asiafruitchina.net/categories"
            ],
            "target": "/categories/lizi"
          },
          {
            "title": "榴莲",
            "source": [
              "asiafruitchina.net/categories"
            ],
            "target": "/categories/liulian"
          },
          {
            "title": "龙眼",
            "source": [
              "asiafruitchina.net/categories"
            ],
            "target": "/categories/lognyan"
          },
          {
            "title": "芦笋",
            "source": [
              "asiafruitchina.net/categories"
            ],
            "target": "/categories/lusun"
          },
          {
            "title": "蔓越莓",
            "source": [
              "asiafruitchina.net/categories"
            ],
            "target": "/categories/manyuemei"
          },
          {
            "title": "芒果",
            "source": [
              "asiafruitchina.net/categories"
            ],
            "target": "/categories/mangguo"
          },
          {
            "title": "猕猴桃/奇异果",
            "source": [
              "asiafruitchina.net/categories"
            ],
            "target": "/categories/mihoutao"
          },
          {
            "title": "柠檬",
            "source": [
              "asiafruitchina.net/categories"
            ],
            "target": "/categories/ningmeng"
          },
          {
            "title": "牛油果",
            "source": [
              "asiafruitchina.net/categories"
            ],
            "target": "/categories/niuyouguo"
          },
          {
            "title": "苹果",
            "source": [
              "asiafruitchina.net/categories"
            ],
            "target": "/categories/pingguo"
          },
          {
            "title": "葡萄/提子",
            "source": [
              "asiafruitchina.net/categories"
            ],
            "target": "/categories/putao"
          },
          {
            "title": "其他",
            "source": [
              "asiafruitchina.net/categories"
            ],
            "target": "/categories/qita"
          },
          {
            "title": "奇异莓",
            "source": [
              "asiafruitchina.net/categories"
            ],
            "target": "/categories/qiyimei"
          },
          {
            "title": "热带水果",
            "source": [
              "asiafruitchina.net/categories"
            ],
            "target": "/categories/redaishuiguo"
          },
          {
            "title": "山竹",
            "source": [
              "asiafruitchina.net/categories"
            ],
            "target": "/categories/shanzhu"
          },
          {
            "title": "石榴",
            "source": [
              "asiafruitchina.net/categories"
            ],
            "target": "/categories/shiliu"
          },
          {
            "title": "蔬菜",
            "source": [
              "asiafruitchina.net/categories"
            ],
            "target": "/categories/shucai"
          },
          {
            "title": "树莓",
            "source": [
              "asiafruitchina.net/categories"
            ],
            "target": "/categories/shumei"
          },
          {
            "title": "桃",
            "source": [
              "asiafruitchina.net/categories"
            ],
            "target": "/categories/tao"
          },
          {
            "title": "甜瓜",
            "source": [
              "asiafruitchina.net/categories"
            ],
            "target": "/categories/tiangua"
          },
          {
            "title": "甜椒",
            "source": [
              "asiafruitchina.net/categories"
            ],
            "target": "/categories/tianjiao"
          },
          {
            "title": "甜柿",
            "source": [
              "asiafruitchina.net/categories"
            ],
            "target": "/categories/tianshi"
          },
          {
            "title": "香蕉",
            "source": [
              "asiafruitchina.net/categories"
            ],
            "target": "/categories/xiangjiao"
          },
          {
            "title": "西瓜",
            "source": [
              "asiafruitchina.net/categories"
            ],
            "target": "/categories/xigua"
          },
          {
            "title": "西梅",
            "source": [
              "asiafruitchina.net/categories"
            ],
            "target": "/categories/ximei"
          },
          {
            "title": "杏",
            "source": [
              "asiafruitchina.net/categories"
            ],
            "target": "/categories/xing"
          },
          {
            "title": "椰子",
            "source": [
              "asiafruitchina.net/categories"
            ],
            "target": "/categories/yezi"
          },
          {
            "title": "杨梅",
            "source": [
              "asiafruitchina.net/categories"
            ],
            "target": "/categories/yangmei"
          },
          {
            "title": "樱桃",
            "source": [
              "asiafruitchina.net/categories"
            ],
            "target": "/categories/yintao"
          },
          {
            "title": "油桃",
            "source": [
              "asiafruitchina.net/categories"
            ],
            "target": "/categories/youtao"
          },
          {
            "title": "柚子",
            "source": [
              "asiafruitchina.net/categories"
            ],
            "target": "/categories/youzi"
          }
        ],
        "view": 0,
        "location": "categories.ts",
        "module": () => import('@/routes/asiafruitchina/categories.ts')
      },
      "/news": {
        "path": "/news",
        "name": "行业资讯",
        "url": "asiafruitchina.net",
        "maintainers": [
          "nczitzk"
        ],
        "example": "/asiafruitchina/news",
        "categories": [
          "new-media"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "asiafruitchina.net/category/news"
            ],
            "target": "/asiafruitchina/news"
          }
        ],
        "view": 0,
        "location": "news.ts",
        "module": () => import('@/routes/asiafruitchina/news.ts')
      }
    },
    "name": "亚洲水果",
    "apiRoutes": {},
    "url": "asiafruitchina.net",
    "categories": [
      "new-media"
    ],
    "description": "",
    "lang": "zh-CN"
  },
  "asianfanfics": {
    "routes": {
      "/tag/:tag/:type": {
        "path": "/tag/:tag/:type",
        "categories": [
          "reading"
        ],
        "example": "/asianfanfics/tag/milklove/N",
        "parameters": {
          "tag": "标签",
          "type": "排序类型"
        },
        "name": "标签",
        "maintainers": [
          "KazooTTT"
        ],
        "radar": [
          {
            "source": [
              "www.asianfanfics.com/browse/tag/:tag/:type"
            ],
            "target": "/tag/:tag/:type"
          }
        ],
        "description": "匹配asianfanfics标签，支持排序类型：\n- L: Latest 最近更新\n- N: Newest 最近发布\n- O: Oldest 最早发布\n- C: Completed 已完成\n- OS: One Shots 短篇\n",
        "location": "tag.ts",
        "module": () => import('@/routes/asianfanfics/tag.ts')
      },
      "/text-search/:keyword": {
        "path": "/text-search/:keyword",
        "categories": [
          "reading"
        ],
        "example": "/asianfanfics/text-search/milklove",
        "parameters": {
          "keyword": "关键词"
        },
        "name": "关键词",
        "maintainers": [
          "KazooTTT"
        ],
        "radar": [
          {
            "source": [
              "www.asianfanfics.com/browse/text_search?q=:keyword"
            ],
            "target": "/text-search/:keyword"
          }
        ],
        "description": "匹配asianfanfics搜索关键词",
        "location": "text-search.ts",
        "module": () => import('@/routes/asianfanfics/text-search.ts')
      }
    },
    "name": "Asianfanfics",
    "url": "asianfanfics.com",
    "lang": "en"
  },
  "asiantolick": {
    "routes": {
      "/:category{.+}?": {
        "path": "/:category{.+}?",
        "radar": [
          {
            "source": [
              "asiantolick.com/"
            ],
            "target": ""
          }
        ],
        "name": "Unknown",
        "maintainers": [],
        "url": "asiantolick.com/",
        "features": {
          "nsfw": true
        },
        "location": "index.ts",
        "module": () => import('@/routes/asiantolick/index.ts')
      }
    },
    "name": "Asian to lick",
    "apiRoutes": {},
    "url": "asiantolick.com",
    "lang": "zh-CN"
  },
  "asmr-200": {
    "routes": {
      "/works/:order?/:subtitle?/:sort?": {
        "path": "/works/:order?/:subtitle?/:sort?",
        "categories": [
          "multimedia"
        ],
        "example": "/asmr-200/works",
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false,
          "nsfw": true
        },
        "parameters": {
          "order": "排序字段，默认按照资源的收录日期来排序，详见下表",
          "sort": "排序方式，可选 `asc` 和 `desc` ，默认倒序",
          "subtitle": "筛选带字幕音频，可选 `0` 和 `1` ，默认关闭"
        },
        "radar": [
          {
            "source": [
              "asmr-200.com"
            ],
            "target": "asmr-200/works"
          }
        ],
        "name": "最新收录",
        "maintainers": [
          "hualiong"
        ],
        "url": "asmr-200.com",
        "description": "| 发售日期 | 收录日期 | 销量 | 价格 | 评价 | 随机 | RJ号 |\n| ---- | ---- | ---- | ---- | ---- | ---- | ---- |\n| release | create_date | dl_count | price | rate_average_2dp | random | id |",
        "location": "index.tsx",
        "module": () => import('@/routes/asmr-200/index.tsx')
      }
    },
    "name": "ASMR Online",
    "apiRoutes": {},
    "url": "asmr-200.com",
    "lang": "zh-CN"
  },
  "asus": {
    "routes": {
      "/bios/:model/:lang?": {
        "path": "/bios/:model/:lang?",
        "categories": [
          "program-update"
        ],
        "example": "/asus/bios/RT-AX88U/zh",
        "parameters": {
          "model": "Model, can be found in product page",
          "lang": {
            "description": "Language, provide access routes for other parts of the world",
            "options": [
              {
                "label": "Chinese",
                "value": "zh"
              },
              {
                "label": "Global",
                "value": "en"
              }
            ],
            "default": "en"
          }
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.asus.com/displays-desktops/:productLine/:series/:model",
              "www.asus.com/laptops/:productLine/:series/:model",
              "www.asus.com/motherboards-components/:productLine/:series/:model",
              "www.asus.com/networking-iot-servers/:productLine/:series/:model",
              "www.asus.com/:region/displays-desktops/:productLine/:series/:model",
              "www.asus.com/:region/laptops/:productLine/:series/:model",
              "www.asus.com/:region/motherboards-components/:productLine/:series/:model",
              "www.asus.com/:region/networking-iot-servers/:productLine/:series/:model"
            ],
            "target": "/bios/:model"
          }
        ],
        "name": "BIOS",
        "maintainers": [
          "Fatpandac"
        ],
        "url": "www.asus.com",
        "location": "bios.tsx",
        "module": () => import('@/routes/asus/bios.tsx')
      },
      "/gpu-tweak": {
        "path": "/gpu-tweak",
        "categories": [
          "program-update"
        ],
        "example": "/asus/gpu-tweak",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "asus.com/campaign/GPU-Tweak-III/*",
              "asus.com/"
            ]
          }
        ],
        "name": "GPU Tweak",
        "maintainers": [
          "TonyRL"
        ],
        "url": "asus.com/campaign/GPU-Tweak-III/*",
        "location": "gpu-tweak.ts",
        "module": () => import('@/routes/asus/gpu-tweak.ts')
      }
    },
    "name": "ASUS",
    "apiRoutes": {},
    "url": "asus.com.cn",
    "lang": "zh-CN"
  },
  "atcoder": {
    "routes": {
      "/contest/:language?/:rated?/:category?/:keyword?": {
        "path": "/contest/:language?/:rated?/:category?/:keyword?",
        "categories": [
          "programming"
        ],
        "example": "/atcoder/contest",
        "parameters": {
          "language": "Language, `jp` as Japanese or `en` as English, English by default",
          "rated": "Rated Range, see below, all by default",
          "category": "Category, see below, all by default",
          "keyword": "Keyword"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "Contests Archive",
        "maintainers": [
          "nczitzk"
        ],
        "description": "Rated Range\n\n| ABC Class (Rated for ~1999) | ARC Class (Rated for ~2799) | AGC Class (Rated for ~9999) |\n| ---------------------------- | ---------------------------- | ---------------------------- |\n| 1                            | 2                            | 3                            |\n\n  Category\n\n| All | AtCoder Typical Contest | PAST Archive | Unofficial(unrated) |\n| --- | ----------------------- | ------------ | ------------------- |\n| 0   | 6                       | 50           | 101                 |\n\n| JOI Archive | Sponsored Tournament | Sponsored Parallel(rated) |\n| ----------- | -------------------- | ------------------------- |\n| 200         | 1000                 | 1001                      |\n\n| Sponsored Parallel(unrated) | Optimization Contest |\n| --------------------------- | -------------------- |\n| 1002                        | 1200                 |",
        "location": "contest.ts",
        "module": () => import('@/routes/atcoder/contest.ts')
      },
      "/post/:language?/:keyword?": {
        "path": "/post/:language?/:keyword?",
        "categories": [
          "programming"
        ],
        "example": "/atcoder/post",
        "parameters": {
          "language": "Language, `jp` as Japanese or `en` as English, English by default",
          "keyword": "Keyword"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "Posts",
        "maintainers": [
          "nczitzk"
        ],
        "location": "post.ts",
        "module": () => import('@/routes/atcoder/post.ts')
      }
    },
    "name": "AtCoder",
    "apiRoutes": {},
    "url": "atcoder.jp",
    "lang": "en"
  },
  "atptour": {
    "routes": {
      "/news/:lang?": {
        "path": "/news/:lang?",
        "categories": [
          "other"
        ],
        "example": "/atptour/news/en",
        "parameters": {
          "lang": "en or es."
        },
        "radar": [
          {
            "source": [
              "atptour.com"
            ]
          }
        ],
        "name": "News",
        "maintainers": [
          "LM1207"
        ],
        "location": "news.ts",
        "module": () => import('@/routes/atptour/news.ts')
      }
    },
    "name": "ATP Tour",
    "url": "www.atptour.com",
    "description": "News from the official site of men's professional tennis.",
    "lang": "en"
  },
  "augmentcode": {
    "routes": {
      "/blog": {
        "path": "/blog",
        "name": "Blog",
        "url": "augmentcode.com",
        "maintainers": [
          "nczitzk"
        ],
        "example": "/augmentcode/blog",
        "categories": [
          "programming"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "augmentcode.com/blog"
            ],
            "target": "/blog"
          }
        ],
        "view": 0,
        "location": "blog.tsx",
        "module": () => import('@/routes/augmentcode/blog.tsx')
      }
    },
    "name": "Augment Code",
    "apiRoutes": {},
    "url": "augmentcode.com",
    "categories": [
      "programming"
    ],
    "description": "",
    "lang": "en"
  },
  "auto-stats": {
    "routes": {
      "/:category?": {
        "path": "/:category?",
        "categories": [
          "other"
        ],
        "example": "/auto-stats",
        "parameters": {
          "category": "分类，见下表，默认为信息快递"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "分类",
        "maintainers": [
          "nczitzk"
        ],
        "description": "| 信息快递 | 工作动态 | 专题分析 |\n| -------- | -------- | -------- |\n| xxkd     | gzdt     | ztfx     |",
        "location": "index.ts",
        "module": () => import('@/routes/auto-stats/index.ts')
      }
    },
    "name": "中国汽车工业协会统计信息网",
    "apiRoutes": {},
    "url": "auto-stats.org.cn",
    "lang": "zh-CN"
  },
  "autocentre": {
    "routes": {
      "/": {
        "path": "/",
        "name": "Автомобільний сайт N1 в Україні",
        "categories": [
          "new-media"
        ],
        "maintainers": [
          "driversti"
        ],
        "example": "/autocentre",
        "location": "index.ts",
        "module": () => import('@/routes/autocentre/index.ts')
      }
    },
    "name": "Автоцентр.ua",
    "apiRoutes": {},
    "url": "autocentre.ua",
    "description": "Автоцентр.ua: автоновини - Автомобільний сайт N1 в Україні",
    "lang": "ru"
  },
  "azul": {
    "routes": {
      "/downloads": {
        "path": "/downloads",
        "name": "Downloads",
        "url": "www.azul.com",
        "maintainers": [
          "nczitzk"
        ],
        "example": "/azul/downloads",
        "categories": [
          "program-update"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.azul.com/downloads"
            ],
            "target": "/downloads"
          }
        ],
        "view": 5,
        "location": "packages.ts",
        "module": () => import('@/routes/azul/packages.ts')
      }
    },
    "name": "Azul",
    "url": "azul.com",
    "categories": [
      "programming"
    ],
    "description": "",
    "lang": "en"
  },
  "azurlane": {
    "routes": {
      "/news/:server/:type?": {
        "path": "/news/:server/:type?",
        "name": "News",
        "categories": [
          "game"
        ],
        "maintainers": [
          "AnitsuriW"
        ],
        "example": "/azurlane/news/jp/0",
        "parameters": {
          "server": "game server (ISO 3166 two-letter country code, case-insensitive), only `JP` is supported for now",
          "type": "news type, see the table below, `0` by default"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "description": "| すべて | お知らせ | イベント | メインテナンス | 重要 |\n| :--: | :--: | :--: | :--: | :--: |\n| 0 | 1 | 2 | 3 | 4 |",
        "location": "news.ts",
        "module": () => import('@/routes/azurlane/news.ts')
      }
    },
    "name": "Azur Lane",
    "url": "azurlane.jp",
    "categories": [
      "game"
    ],
    "lang": "ja"
  },
  "baai": {
    "routes": {
      "/hub/events": {
        "path": "/hub/events",
        "categories": [
          "programming"
        ],
        "example": "/baai/hub/events",
        "radar": [
          {
            "source": [
              "hub.baai.ac.cn/events",
              "hub.baai.ac.cn/"
            ]
          }
        ],
        "name": "智源社区 - 活动",
        "maintainers": [
          "TonyRL"
        ],
        "url": "hub.baai.ac.cn/events",
        "location": "events.ts",
        "module": () => import('@/routes/baai/events.ts')
      },
      "/hub/:tagId?/:sort?/:range?": {
        "path": [
          "/hub/:tagId?/:sort?/:range?"
        ],
        "categories": [
          "programming"
        ],
        "example": "/baai/hub",
        "parameters": {
          "tagId": "社群 ID，可在 [社群页](https://hub.baai.ac.cn/taglist) 或 URL 中找到",
          "sort": "排序，见下表，默认为 `new`",
          "range": "时间跨度，仅在排序 `readCnt` 时有效"
        },
        "description": "排序\n\n| 最新 | 最热    |\n| ---- | ------- |\n| new  | readCnt |\n\n时间跨度\n\n| 3 天 | 本周 | 本月 |\n| ---- | ---- | ---- |\n| 3    | 7    | 30   |",
        "radar": [
          {
            "source": [
              "baai.ac.cn/"
            ]
          }
        ],
        "name": "智源社区",
        "maintainers": [
          "TonyRL"
        ],
        "location": "hub.ts",
        "module": () => import('@/routes/baai/hub.ts')
      }
    },
    "name": "北京智源人工智能研究院",
    "apiRoutes": {},
    "url": "hub.baai.ac.cn",
    "lang": "zh-CN"
  },
  "backlinko": {
    "routes": {
      "/blog": {
        "path": "/blog",
        "categories": [
          "blog"
        ],
        "example": "/backlinko/blog",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "backlinko.com/blog",
              "backlinko.com/"
            ]
          }
        ],
        "name": "Blog",
        "maintainers": [
          "TonyRL"
        ],
        "url": "backlinko.com/blog",
        "location": "blog.ts",
        "module": () => import('@/routes/backlinko/blog.ts')
      }
    },
    "name": "Backlinko",
    "apiRoutes": {},
    "url": "backlinko.com",
    "lang": "en"
  },
  "bad": {
    "routes": {
      "*": {
        "path": "*",
        "name": "Unknown",
        "maintainers": [],
        "location": "index.ts",
        "module": () => import('@/routes/bad/index.ts')
      }
    },
    "name": "Bad.news",
    "apiRoutes": {},
    "url": "bad.news",
    "lang": "zh-CN"
  },
  "baidu": {
    "routes": {
      "/gushitong/index": {
        "path": "/gushitong/index",
        "categories": [
          "finance"
        ],
        "view": 5,
        "example": "/baidu/gushitong/index",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "gushitong.baidu.com/"
            ]
          }
        ],
        "name": "首页指数",
        "maintainers": [
          "CaoMeiYouRen"
        ],
        "url": "gushitong.baidu.com/",
        "location": "gushitong/index.tsx",
        "module": () => import('@/routes/baidu/gushitong/index.tsx')
      },
      "/search/:keyword": {
        "path": "/search/:keyword",
        "categories": [
          "other"
        ],
        "example": "/baidu/search/rss",
        "parameters": {
          "keyword": "搜索关键词"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "搜索",
        "maintainers": [
          "CaoMeiYouRen"
        ],
        "location": "search.tsx",
        "module": () => import('@/routes/baidu/search.tsx')
      },
      "/tieba/forum/good/:kw/:cid?/:sortBy?": {
        "path": [
          "/tieba/forum/good/:kw/:cid?/:sortBy?",
          "/tieba/forum/:kw/:sortBy?"
        ],
        "categories": [
          "bbs"
        ],
        "example": "/baidu/tieba/forum/good/女图",
        "parameters": {
          "kw": "吧名",
          "cid": "精品分类，默认为 `0`（全部分类），如果不传 `cid` 则获取全部分类",
          "sortBy": "排序方式：`created`, `replied`。默认为 `created`"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "精品帖子",
        "maintainers": [
          "u3u"
        ],
        "location": "tieba/forum.tsx",
        "module": () => import('@/routes/baidu/tieba/forum.tsx')
      },
      "/tieba/forum/:kw/:sortBy?": {
        "path": [
          "/tieba/forum/good/:kw/:cid?/:sortBy?",
          "/tieba/forum/:kw/:sortBy?"
        ],
        "categories": [
          "bbs"
        ],
        "example": "/baidu/tieba/forum/good/女图",
        "parameters": {
          "kw": "吧名",
          "cid": "精品分类，默认为 `0`（全部分类），如果不传 `cid` 则获取全部分类",
          "sortBy": "排序方式：`created`, `replied`。默认为 `created`"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "精品帖子",
        "maintainers": [
          "u3u"
        ],
        "location": "tieba/forum.tsx",
        "module": () => import('@/routes/baidu/tieba/forum.tsx')
      },
      "/tieba/post/:id": {
        "path": [
          "/tieba/post/:id",
          "/tieba/post/lz/:id"
        ],
        "categories": [
          "bbs"
        ],
        "example": "/baidu/tieba/post/686961453",
        "parameters": {
          "id": "帖子 ID"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "tieba.baidu.com/p/:id"
            ]
          }
        ],
        "name": "帖子动态",
        "maintainers": [
          "u3u"
        ],
        "location": "tieba/post.tsx",
        "module": () => import('@/routes/baidu/tieba/post.tsx')
      },
      "/tieba/post/lz/:id": {
        "path": [
          "/tieba/post/:id",
          "/tieba/post/lz/:id"
        ],
        "categories": [
          "bbs"
        ],
        "example": "/baidu/tieba/post/686961453",
        "parameters": {
          "id": "帖子 ID"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "tieba.baidu.com/p/:id"
            ]
          }
        ],
        "name": "帖子动态",
        "maintainers": [
          "u3u"
        ],
        "location": "tieba/post.tsx",
        "module": () => import('@/routes/baidu/tieba/post.tsx')
      },
      "/tieba/search/:qw/:routeParams?": {
        "path": "/tieba/search/:qw/:routeParams?",
        "categories": [
          "bbs"
        ],
        "example": "/baidu/tieba/search/neuro",
        "parameters": {
          "qw": "搜索关键词",
          "routeParams": "额外参数；请参阅以下说明和表格"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "贴吧搜索",
        "maintainers": [
          "JimenezLi"
        ],
        "description": "| 键           | 含义                                                       | 接受的值      | 默认值 |\n| ------------ | ---------------------------------------------------------- | ------------- | ------ |\n| kw           | 在名为 kw 的贴吧中搜索                                     | 任意名称 / 无 | 无     |\n| only_thread  | 只看主题帖，默认为 0 关闭                                  | 0/1           | 0      |\n| rn           | 返回条目的数量                                             | 1-20          | 20     |\n| sm           | 排序方式，0 为按时间顺序，1 为按时间倒序，2 为按相关性顺序 | 0/1/2         | 1      |\n\n  用例：`/baidu/tieba/search/neuro/kw=neurosama&only_thread=1&sm=2`",
        "location": "tieba/search.tsx",
        "module": () => import('@/routes/baidu/tieba/search.tsx')
      },
      "/tieba/user/:uid": {
        "path": "/tieba/user/:uid",
        "categories": [
          "bbs"
        ],
        "example": "/baidu/tieba/user/斗鱼游戏君",
        "parameters": {
          "uid": "用户 ID"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "用户帖子",
        "maintainers": [
          "igxlin",
          "nczitzk"
        ],
        "description": "用户 ID 可以通过打开用户的主页后查看地址栏的 `un` 字段来获取。",
        "location": "tieba/user.ts",
        "module": () => import('@/routes/baidu/tieba/user.ts')
      },
      "/top/:board?": {
        "path": "/top/:board?",
        "categories": [
          "other"
        ],
        "example": "/baidu/top",
        "parameters": {
          "board": "榜单，默认为 `realtime`"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "热搜榜单",
        "maintainers": [
          "xyqfer"
        ],
        "description": "| 热搜榜   | 小说榜 | 电影榜 | 电视剧榜 | 汽车榜 | 游戏榜 |\n| -------- | ------ | ------ | -------- | ------ | ------ |\n| realtime | novel  | movie  | teleplay | car    | game   |",
        "location": "top.tsx",
        "module": () => import('@/routes/baidu/top.tsx')
      }
    },
    "name": "百度",
    "apiRoutes": {},
    "url": "www.baidu.com",
    "lang": "zh-CN"
  },
  "baijing": {
    "routes": {
      "/article": {
        "path": "/article",
        "categories": [
          "new-media"
        ],
        "example": "/baijing/article",
        "url": "www.baijing.cn/article/",
        "name": "资讯",
        "maintainers": [
          "p3psi-boo"
        ],
        "location": "index.ts",
        "module": () => import('@/routes/baijing/index.ts')
      }
    },
    "name": "白鲸出海",
    "apiRoutes": {},
    "url": "baijing.cn",
    "description": "白鲸出海",
    "lang": "zh-CN"
  },
  "bakamh": {
    "routes": {
      "/manga/:name": {
        "path": "/manga/:name",
        "categories": [
          "anime"
        ],
        "example": "/bakamh/manga/最强家丁",
        "parameters": {
          "name": "漫画名称，漫画主页的地址栏中"
        },
        "radar": [
          {
            "source": [
              "bakamh.com/manga/:name/"
            ]
          }
        ],
        "name": "漫画更新",
        "maintainers": [
          "yoyobase"
        ],
        "url": "bakamh.com",
        "location": "manga.ts",
        "module": () => import('@/routes/bakamh/manga.ts')
      }
    },
    "name": "巴卡漫画",
    "apiRoutes": {},
    "url": "bakamh.com",
    "categories": [
      "anime"
    ],
    "lang": "zh-CN"
  },
  "bandcamp": {
    "routes": {
      "/live": {
        "path": "/live",
        "categories": [
          "multimedia"
        ],
        "example": "/bandcamp/live",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "bandcamp.com/live_schedule"
            ]
          }
        ],
        "name": "Upcoming Live Streams",
        "maintainers": [
          "nczitzk"
        ],
        "url": "bandcamp.com/live_schedule",
        "location": "live.ts",
        "module": () => import('@/routes/bandcamp/live.ts')
      },
      "/tag/:tag?": {
        "path": "/tag/:tag?",
        "categories": [
          "multimedia"
        ],
        "example": "/bandcamp/tag/united-kingdom",
        "parameters": {
          "tag": "Tag, can be found in URL"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "bandcamp.com/tag/:tag"
            ],
            "target": "/tag/:tag"
          }
        ],
        "name": "Tag",
        "maintainers": [
          "nczitzk"
        ],
        "location": "tag.ts",
        "module": () => import('@/routes/bandcamp/tag.ts')
      },
      "/weekly": {
        "path": "/weekly",
        "categories": [
          "multimedia"
        ],
        "example": "/bandcamp/weekly",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "bandcamp.com/"
            ]
          }
        ],
        "name": "Weekly",
        "maintainers": [
          "nczitzk"
        ],
        "url": "bandcamp.com/",
        "location": "weekly.tsx",
        "module": () => import('@/routes/bandcamp/weekly.tsx')
      }
    },
    "name": "Bandcamp",
    "apiRoutes": {},
    "url": "bandcamp.com",
    "lang": "en"
  },
  "bandisoft": {
    "routes": {
      "/history/:id?/:language?": {
        "path": "/history/:id?/:language?",
        "name": "History",
        "url": "www.bandisoft.com",
        "maintainers": [
          "nczitzk"
        ],
        "example": "/bandisoft/history/bandizip",
        "parameters": {
          "id": {
            "description": "ID, `bandizip` by default",
            "options": [
              {
                "label": "Bandizip",
                "value": "bandizip"
              },
              {
                "label": "Bandizip for Mac",
                "value": "bandizip.mac"
              },
              {
                "label": "BandiView",
                "value": "bandiview"
              },
              {
                "label": "Honeycam",
                "value": "honeycam"
              }
            ]
          },
          "language": {
            "description": "Language, `en` by default",
            "options": [
              {
                "label": "English",
                "value": "en"
              },
              {
                "label": "中文(简体)",
                "value": "cn"
              },
              {
                "label": "中文(繁體)",
                "value": "tw"
              },
              {
                "label": "日本語",
                "value": "jp"
              },
              {
                "label": "Русский",
                "value": "ru"
              },
              {
                "label": "Español",
                "value": "es"
              },
              {
                "label": "Français",
                "value": "fr"
              },
              {
                "label": "Deutsch",
                "value": "de"
              },
              {
                "label": "Italiano",
                "value": "it"
              },
              {
                "label": "Slovenčina",
                "value": "sk"
              },
              {
                "label": "Українська",
                "value": "uk"
              },
              {
                "label": "Беларуская",
                "value": "be"
              },
              {
                "label": "Dansk",
                "value": "da"
              },
              {
                "label": "Polski",
                "value": "pl"
              },
              {
                "label": "Português Brasileiro",
                "value": "br"
              },
              {
                "label": "Čeština",
                "value": "cs"
              },
              {
                "label": "Nederlands",
                "value": "nl"
              },
              {
                "label": "Slovenščina",
                "value": "sl"
              },
              {
                "label": "Türkçe",
                "value": "tr"
              },
              {
                "label": "ภาษาไทย",
                "value": "th"
              },
              {
                "label": "Ελληνικά",
                "value": "gr"
              },
              {
                "label": "O'zbek",
                "value": "uz"
              },
              {
                "label": "Romanian",
                "value": "ro"
              },
              {
                "label": "한국어",
                "value": "kr"
              }
            ]
          }
        },
        "description": "::: tip\nTo subscribe to [Bandizip Version History](https://www.bandisoft.com/bandizip/history/), where the source URL is `https://www.bandisoft.com/bandizip/history/`, extract the certain parts from this URL to be used as parameters, resulting in the route as [`/bandisoft/history/bandizip`](https://rsshub.app/bandisoft/history/bandizip).\n:::\n\n<details>\n  <summary>More languages</summary>\n\n| Language             | ID  |\n| -------------------- | --- |\n| English              | en  |\n| 中文(简体)           | cn  |\n| 中文(繁體)           | tw  |\n| 日本語               | jp  |\n| Русский              | ru  |\n| Español              | es  |\n| Français             | fr  |\n| Deutsch              | de  |\n| Italiano             | it  |\n| Slovenčina           | sk  |\n| Українська           | uk  |\n| Беларуская           | be  |\n| Dansk                | da  |\n| Polski               | pl  |\n| Português Brasileiro | br  |\n| Čeština              | cs  |\n| Nederlands           | nl  |\n| Slovenščina          | sl  |\n| Türkçe               | tr  |\n| ภาษาไทย              | th  |\n| Ελληνικά             | gr  |\n| Oʻzbek               | uz  |\n| Romanian             | ro  |\n| 한국어               | kr  |\n\n</details>\n",
        "categories": [
          "program-update"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.bandisoft.com/:id/history"
            ]
          }
        ],
        "view": 0,
        "zh": {
          "path": "/history/:id?/:language?",
          "name": "更新记录",
          "url": "www.bandisoft.com",
          "maintainers": [
            "nczitzk"
          ],
          "example": "/bandisoft/history/bandizip",
          "parameters": {
            "id": {
              "description": "ID, 默认为 `bandizip`，可在对应产品页 URL 中找到",
              "options": [
                {
                  "label": "Bandizip",
                  "value": "bandizip"
                },
                {
                  "label": "Bandizip for Mac",
                  "value": "bandizip.mac"
                },
                {
                  "label": "BandiView",
                  "value": "bandiview"
                },
                {
                  "label": "Honeycam",
                  "value": "honeycam"
                }
              ]
            },
            "language": {
              "description": "地区, 默认为 `en`",
              "options": [
                {
                  "label": "English",
                  "value": "en"
                },
                {
                  "label": "中文(简体)",
                  "value": "cn"
                },
                {
                  "label": "中文(繁體)",
                  "value": "tw"
                },
                {
                  "label": "日本語",
                  "value": "jp"
                },
                {
                  "label": "Русский",
                  "value": "ru"
                },
                {
                  "label": "Español",
                  "value": "es"
                },
                {
                  "label": "Français",
                  "value": "fr"
                },
                {
                  "label": "Deutsch",
                  "value": "de"
                },
                {
                  "label": "Italiano",
                  "value": "it"
                },
                {
                  "label": "Slovenčina",
                  "value": "sk"
                },
                {
                  "label": "Українська",
                  "value": "uk"
                },
                {
                  "label": "Беларуская",
                  "value": "be"
                },
                {
                  "label": "Dansk",
                  "value": "da"
                },
                {
                  "label": "Polski",
                  "value": "pl"
                },
                {
                  "label": "Português Brasileiro",
                  "value": "br"
                },
                {
                  "label": "Čeština",
                  "value": "cs"
                },
                {
                  "label": "Nederlands",
                  "value": "nl"
                },
                {
                  "label": "Slovenščina",
                  "value": "sl"
                },
                {
                  "label": "Türkçe",
                  "value": "tr"
                },
                {
                  "label": "ภาษาไทย",
                  "value": "th"
                },
                {
                  "label": "Ελληνικά",
                  "value": "gr"
                },
                {
                  "label": "O'zbek",
                  "value": "uz"
                },
                {
                  "label": "Romanian",
                  "value": "ro"
                },
                {
                  "label": "한국어",
                  "value": "kr"
                }
              ]
            }
          },
          "description": "::: tip\n若订阅 [Bandizip 更新记录](https://cn.bandisoft.com/bandizip/history/)，网址为 `https://cn.bandisoft.com/bandizip/history/`，请截取 `cn` 作为 `category` 参数填入，此时目标路由为 [`/bandisoft/:language?/:id?`](https://rsshub.app/bandisoft/:language?/:id?)。\n:::\n\n<details>\n  <summary>更多语言</summary>\n\n| Language             | ID  |\n| -------------------- | --- |\n| English              | en  |\n| 中文(简体)           | cn  |\n| 中文(繁體)           | tw  |\n| 日本語               | jp  |\n| Русский              | ru  |\n| Español              | es  |\n| Français             | fr  |\n| Deutsch              | de  |\n| Italiano             | it  |\n| Slovenčina           | sk  |\n| Українська           | uk  |\n| Беларуская           | be  |\n| Dansk                | da  |\n| Polski               | pl  |\n| Português Brasileiro | br  |\n| Čeština              | cs  |\n| Nederlands           | nl  |\n| Slovenščina          | sl  |\n| Türkçe               | tr  |\n| ภาษาไทย              | th  |\n| Ελληνικά             | gr  |\n| Oʻzbek               | uz  |\n| Romanian             | ro  |\n| 한국어               | kr  |\n\n</details>\n"
        },
        "location": "history.ts",
        "module": () => import('@/routes/bandisoft/history.ts')
      }
    },
    "name": "Bandisoft",
    "apiRoutes": {},
    "url": "bandisoft.com",
    "categories": [
      "program-update"
    ],
    "description": "",
    "lang": "en"
  },
  "bangumi.moe": {
    "routes": {
      "/*": {
        "path": "/*",
        "categories": [
          "anime"
        ],
        "radar": [
          {
            "source": [
              "bangumi.moe/"
            ]
          }
        ],
        "name": "Latest",
        "example": "/bangumi.moe",
        "maintainers": [
          "nczitzk"
        ],
        "url": "bangumi.moe/",
        "location": "index.ts",
        "module": () => import('@/routes/bangumi.moe/index.ts')
      }
    },
    "name": "萌番组",
    "apiRoutes": {},
    "url": "bangumi.online",
    "lang": "zh-CN"
  },
  "bangumi.online": {
    "routes": {
      "/": {
        "path": "/",
        "categories": [
          "anime"
        ],
        "example": "/bangumi.online",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "bangumi.online/"
            ]
          }
        ],
        "name": "當季新番",
        "maintainers": [
          "devinmugen"
        ],
        "url": "bangumi.online/",
        "location": "online.tsx",
        "module": () => import('@/routes/bangumi.online/online.tsx')
      }
    },
    "name": "アニメ新番組",
    "url": "bangumi.online",
    "lang": "ja"
  },
  "bangumi.tv": {
    "routes": {
      "/calendar/today": {
        "path": "/calendar/today",
        "categories": [
          "anime"
        ],
        "example": "/bangumi.tv/calendar/today",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "bgm.tv/calendar"
            ]
          }
        ],
        "name": "放送列表",
        "maintainers": [
          "magic-akari"
        ],
        "url": "bgm.tv/calendar",
        "location": "calendar/today.tsx",
        "module": () => import('@/routes/bangumi.tv/calendar/today.tsx')
      },
      "/topic/:id": {
        "path": "/topic/:id",
        "categories": [
          "anime"
        ],
        "example": "/bangumi.tv/topic/367032",
        "parameters": {
          "id": "话题 id, 在话题页面地址栏查看"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "bgm.tv/group/topic/:id"
            ]
          }
        ],
        "name": "小组话题的新回复",
        "maintainers": [
          "ylc395"
        ],
        "location": "group/reply.ts",
        "module": () => import('@/routes/bangumi.tv/group/reply.ts')
      },
      "/group/:id": {
        "path": "/group/:id",
        "categories": [
          "anime"
        ],
        "example": "/bangumi.tv/group/boring",
        "parameters": {
          "id": "小组 id, 在小组页面地址栏查看"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "bgm.tv/group/:id"
            ]
          }
        ],
        "name": "小组话题",
        "maintainers": [
          "SettingDust"
        ],
        "location": "group/topic.ts",
        "module": () => import('@/routes/bangumi.tv/group/topic.ts')
      },
      "/:type/followrank": {
        "path": "/:type/followrank",
        "categories": [
          "anime"
        ],
        "example": "/bangumi.tv/anime/followrank",
        "parameters": {
          "type": "类型：anime - 动画，book - 图书，music - 音乐，game - 游戏，real - 三次元"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "bgm.tv/:type"
            ],
            "target": "/:type/followrank"
          }
        ],
        "name": "成员关注榜",
        "maintainers": [
          "honue",
          "zhoukuncheng",
          "NekoAria"
        ],
        "location": "other/followrank.ts",
        "module": () => import('@/routes/bangumi.tv/other/followrank.ts')
      },
      "/person/:id": {
        "path": "/person/:id",
        "categories": [
          "anime"
        ],
        "example": "/bangumi.tv/person/32943",
        "parameters": {
          "id": "人物 id, 在人物页面的地址栏查看"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "bgm.tv/person/:id"
            ]
          }
        ],
        "name": "现实人物的新作品",
        "maintainers": [
          "ylc395"
        ],
        "location": "person/index.ts",
        "module": () => import('@/routes/bangumi.tv/person/index.ts')
      },
      "/subject/:id/:type?/:showOriginalName?": {
        "path": "/subject/:id/:type?/:showOriginalName?",
        "categories": [
          "anime"
        ],
        "example": "/bangumi.tv/subject/328609/ep/true",
        "parameters": {
          "id": "条目 id, 在条目页面的地址栏查看",
          "type": "条目类型，可选值为 `ep`, `comments`, `blogs`, `topics`，默认为 `ep`",
          "showOriginalName": "显示番剧标题原名，可选值 0/1/false/true，默认为 false"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "bgm.tv/subject/:id"
            ],
            "target": "/tv/subject/:id"
          }
        ],
        "name": "条目的通用路由格式",
        "maintainers": [
          "JimenezLi"
        ],
        "description": "::: warning\n  此通用路由仅用于对路由参数的描述，具体信息请查看下方与条目相关的路由\n:::",
        "location": "subject/index.ts",
        "module": () => import('@/routes/bangumi.tv/subject/index.ts')
      },
      "/user/blog/:id": {
        "path": "/user/blog/:id",
        "categories": [
          "anime"
        ],
        "example": "/bangumi.tv/user/blog/sai",
        "parameters": {
          "id": "用户 id, 在用户页面地址栏查看"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "bgm.tv/user/:id"
            ]
          },
          {
            "source": [
              "bangumi.tv/user/:id"
            ]
          }
        ],
        "name": "用户日志",
        "maintainers": [
          "nczitzk"
        ],
        "location": "user/blog.ts",
        "module": () => import('@/routes/bangumi.tv/user/blog.ts')
      },
      "/user/collections/:id/:subjectType/:type": {
        "path": "/user/collections/:id/:subjectType/:type",
        "categories": [
          "anime"
        ],
        "example": "/bangumi.tv/user/collections/sai/1/1",
        "parameters": {
          "id": "用户 id, 在用户页面地址栏查看",
          "subjectType": {
            "description": "全部类别: `空`、book: `1`、anime: `2`、music: `3`、game: `4`、real: `6`",
            "options": [
              {
                "value": "ALL",
                "label": "all"
              },
              {
                "value": "book",
                "label": "1"
              },
              {
                "value": "anime",
                "label": "2"
              },
              {
                "value": "music",
                "label": "3"
              },
              {
                "value": "game",
                "label": "4"
              },
              {
                "value": "real",
                "label": "6"
              }
            ]
          },
          "type": {
            "description": "全部类别: `空`、想看: `1`、看过: `2`、在看: `3`、搁置: `4`、抛弃: `5`",
            "options": [
              {
                "value": "ALL",
                "label": "all"
              },
              {
                "value": "想看",
                "label": "1"
              },
              {
                "value": "看过",
                "label": "2"
              },
              {
                "value": "在看",
                "label": "3"
              },
              {
                "value": "搁置",
                "label": "4"
              },
              {
                "value": "抛弃",
                "label": "5"
              }
            ]
          }
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "bgm.tv/anime/list/:id"
            ],
            "target": "/bangumi.tv/user/collections/:id/all/all"
          },
          {
            "source": [
              "bangumi.tv/anime/list/:id"
            ],
            "target": "/bangumi.tv/user/collections/:id/all/all"
          },
          {
            "source": [
              "bgm.tv/anime/list/:id/wish"
            ],
            "target": "/bangumi.tv/user/collections/:id/2/1"
          },
          {
            "source": [
              "bangumi.tv/anime/list/:id/wish"
            ],
            "target": "/bangumi.tv/user/collections/:id/2/1"
          }
        ],
        "name": "Bangumi 用户收藏列表",
        "maintainers": [
          "youyou-sudo",
          "honue"
        ],
        "location": "user/collections.tsx",
        "module": () => import('@/routes/bangumi.tv/user/collections.tsx')
      }
    },
    "name": "Bangumi 番组计划",
    "apiRoutes": {},
    "url": "bangumi.tv",
    "lang": "zh-CN"
  },
  "banshujiang": {
    "routes": {
      "/:category{.+}?": {
        "path": "/:category{.+}?",
        "name": "分类",
        "url": "banshujiang.cn",
        "maintainers": [
          "nczitzk"
        ],
        "example": "/banshujiang/other/人工智能",
        "parameters": {
          "category": {
            "description": "分类，默认为全部，可在对应分类页 URL 中找到",
            "options": [
              {
                "label": "ActionScript",
                "value": "programming_language/ActionScript"
              },
              {
                "label": "ASP.net",
                "value": "programming_language/ASP.net"
              },
              {
                "label": "C",
                "value": "programming_language/C"
              },
              {
                "label": "C#",
                "value": "programming_language/C%23"
              },
              {
                "label": "C++",
                "value": "programming_language/C++"
              },
              {
                "label": "CoffeeScript",
                "value": "programming_language/CoffeeScript"
              },
              {
                "label": "CSS",
                "value": "programming_language/CSS"
              },
              {
                "label": "Dart",
                "value": "programming_language/Dart"
              },
              {
                "label": "Elixir",
                "value": "programming_language/Elixir"
              },
              {
                "label": "Erlang",
                "value": "programming_language/Erlang"
              },
              {
                "label": "F#",
                "value": "programming_language/F%23"
              },
              {
                "label": "Go",
                "value": "programming_language/Go"
              },
              {
                "label": "Groovy",
                "value": "programming_language/Groovy"
              },
              {
                "label": "Haskell",
                "value": "programming_language/Haskell"
              },
              {
                "label": "HTML5",
                "value": "programming_language/HTML5"
              },
              {
                "label": "Java",
                "value": "programming_language/Java"
              },
              {
                "label": "JavaScript",
                "value": "programming_language/JavaScript"
              },
              {
                "label": "Kotlin",
                "value": "programming_language/Kotlin"
              },
              {
                "label": "Lua",
                "value": "programming_language/Lua"
              },
              {
                "label": "Objective-C",
                "value": "programming_language/Objective-C"
              },
              {
                "label": "Perl",
                "value": "programming_language/Perl"
              },
              {
                "label": "PHP",
                "value": "programming_language/PHP"
              },
              {
                "label": "PowerShell",
                "value": "programming_language/PowerShell"
              },
              {
                "label": "Python",
                "value": "programming_language/Python"
              },
              {
                "label": "R",
                "value": "programming_language/R"
              },
              {
                "label": "Ruby",
                "value": "programming_language/Ruby"
              },
              {
                "label": "Rust",
                "value": "programming_language/Rust"
              },
              {
                "label": "Scala",
                "value": "programming_language/Scala"
              },
              {
                "label": "Shell Script",
                "value": "programming_language/Shell%20Script"
              },
              {
                "label": "SQL",
                "value": "programming_language/SQL"
              },
              {
                "label": "Swift",
                "value": "programming_language/Swift"
              },
              {
                "label": "TypeScript",
                "value": "programming_language/TypeScript"
              },
              {
                "label": "Android",
                "value": "mobile_development/Android"
              },
              {
                "label": "iOS",
                "value": "mobile_development/iOS"
              },
              {
                "label": "Linux",
                "value": "operation_system/Linux"
              },
              {
                "label": "Mac OS X",
                "value": "operation_system/Mac%20OS%20X"
              },
              {
                "label": "Unix",
                "value": "operation_system/Unix"
              },
              {
                "label": "Windows",
                "value": "operation_system/Windows"
              },
              {
                "label": "DB2",
                "value": "database/DB2"
              },
              {
                "label": "MongoDB",
                "value": "database/MongoDB"
              },
              {
                "label": "MySQL",
                "value": "database/MySQL"
              },
              {
                "label": "Oracle",
                "value": "database/Oracle"
              },
              {
                "label": "PostgreSQL",
                "value": "database/PostgreSQL"
              },
              {
                "label": "SQL Server",
                "value": "database/SQL%20Server"
              },
              {
                "label": "SQLite",
                "value": "database/SQLite"
              },
              {
                "label": "Apache 项目",
                "value": "open_source/Apache项目"
              },
              {
                "label": "Web 开发",
                "value": "open_source/Web开发"
              },
              {
                "label": "区块链",
                "value": "open_source/区块链"
              },
              {
                "label": "程序开发",
                "value": "open_source/程序开发"
              },
              {
                "label": "人工智能",
                "value": "other/人工智能"
              },
              {
                "label": "容器技术",
                "value": "other/容器技术"
              },
              {
                "label": "中文",
                "value": "language/中文"
              },
              {
                "label": "英文",
                "value": "language/英文"
              }
            ]
          }
        },
        "description": "::: tip\n订阅 [人工智能](https://banshujiang.cn//category/other/人工智能)，其源网址为 `https://banshujiang.cn//category/other/人工智能`，请参考该 URL 指定部分构成参数，此时路由为 [`/banshujiang/category/other/人工智能`](https://rsshub.app/banshujiang/other/人工智能)。\n:::\n\n<details>\n  <summary>更多分类</summary>\n\n#### 编程语言\n\n| 分类                                                                                          | ID                                                                                                                 |\n| --------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------ |\n| [ActionScript](http://www.banshujiang.cn/category/programming_language/ActionScript/page/1)   | [category/programming_language/ActionScript](https://rsshub.app/banshujiang/programming_language/ActionScript)     |\n| [ASP.net](http://www.banshujiang.cn/category/programming_language/ASP.net/page/1)             | [category/programming_language/ASP.net](https://rsshub.app/banshujiang/programming_language/ASP.net)               |\n| [C](http://www.banshujiang.cn/category/programming_language/C)                                | [category/programming_language/C](https://rsshub.app/banshujiang/programming_language/C)                           |\n| [C#](http://www.banshujiang.cn/category/programming_language/C%23)                            | [category/programming_language/C%23](https://rsshub.app/banshujiang/programming_language/C%23)                     |\n| [C++](http://www.banshujiang.cn/category/programming_language/C++)                            | [category/programming_language/C++](https://rsshub.app/banshujiang/programming_language/C++)                       |\n| [CoffeeScript](http://www.banshujiang.cn/category/programming_language/CoffeeScript)          | [category/programming_language/CoffeeScript](https://rsshub.app/banshujiang/programming_language/CoffeeScript)     |\n| [CSS](http://www.banshujiang.cn/category/programming_language/CSS)                            | [category/programming_language/CSS)                                                                                |\n| [Dart](http://www.banshujiang.cn/category/programming_language/Dart)                          | [category/programming_language/Dart](https://rsshub.app/banshujiang/programming_language/Dart)                     |\n| [Elixir](http://www.banshujiang.cn/category/programming_language/Elixir)                      | [category/programming_language/Elixir](https://rsshub.app/banshujiang/programming_language/Elixir)                 |\n| [Erlang](http://www.banshujiang.cn/category/programming_language/Erlang)                      | [category/programming_language/Erlang](https://rsshub.app/banshujiang/programming_language/Erlang)                 |\n| [F#](http://www.banshujiang.cn/category/programming_language/F%23)                            | [category/programming_language/F%23](https://rsshub.app/banshujiang/programming_language/F%23)                     |\n| [Go](http://www.banshujiang.cn/category/programming_language/Go)                              | [category/programming_language/Go](https://rsshub.app/banshujiang/programming_language/Go)                         |\n| [Groovy](http://www.banshujiang.cn/category/programming_language/Groovy)                      | [category/programming_language/Groovy](https://rsshub.app/banshujiang/programming_language/Groovy)                 |\n| [Haskell](http://www.banshujiang.cn/category/programming_language/Haskell)                    | [category/programming_language/Haskell](https://rsshub.app/banshujiang/programming_language/Haskell)               |\n| [HTML5](http://www.banshujiang.cn/category/programming_language/HTML5)                        | [category/programming_language/HTML5](https://rsshub.app/banshujiang/programming_language/HTML5)                   |\n| [Java](http://www.banshujiang.cn/category/programming_language/Java)                          | [category/programming_language/Java](https://rsshub.app/banshujiang/programming_language/Java)                     |\n| [JavaScript](http://www.banshujiang.cn/category/programming_language/JavaScript)              | [category/programming_language/JavaScript](https://rsshub.app/banshujiang/programming_language/JavaScript)         |\n| [Kotlin](http://www.banshujiang.cn/category/programming_language/Kotlin)                      | [category/programming_language/Kotlin](https://rsshub.app/banshujiang/programming_language/Kotlin)                 |\n| [Lua](http://www.banshujiang.cn/category/programming_language/Lua)                            | [category/programming_language/Lua](https://rsshub.app/banshujiang/programming_language/Lua)                       |\n| [Objective-C](http://www.banshujiang.cn/category/programming_language/Objective-C)            | [category/programming_language/Objective-C](https://rsshub.app/banshujiang/programming_language/Objective-C)       |\n| [Perl](http://www.banshujiang.cn/category/programming_language/Perl)                          | [category/programming_language/Perl](https://rsshub.app/banshujiang/programming_language/Perl)                     |\n| [PHP](http://www.banshujiang.cn/category/programming_language/PHP)                            | [category/programming_language/PHP](https://rsshub.app/banshujiang/programming_language/PHP)                       |\n| [PowerShell](http://www.banshujiang.cn/category/programming_language/PowerShell)              | [category/programming_language/PowerShell](https://rsshub.app/banshujiang/programming_language/PowerShell)         |\n| [Python](http://www.banshujiang.cn/category/programming_language/Python)                      | [category/programming_language/Python](https://rsshub.app/banshujiang/programming_language/Python)                 |\n| [R](http://www.banshujiang.cn/category/programming_language/R/page/1)                         | [category/programming_language/R](https://rsshub.app/banshujiang/programming_language/R)                           |\n| [Ruby](http://www.banshujiang.cn/category/programming_language/Ruby/page/1)                   | [category/programming_language/Ruby](https://rsshub.app/banshujiang/programming_language/Ruby)                     |\n| [Rust](http://www.banshujiang.cn/category/programming_language/Rust/page/1)                   | [category/programming_language/Rust](https://rsshub.app/banshujiang/programming_language/Rust)                     |\n| [Scala](http://www.banshujiang.cn/category/programming_language/Scala/page/1)                 | [category/programming_language/Scala](https://rsshub.app/banshujiang/programming_language/Scala)                   |\n| [Shell Script](http://www.banshujiang.cn/category/programming_language/Shell%20Script/page/1) | [category/programming_language/Shell%20Script](https://rsshub.app/banshujiang/programming_language/Shell%20Script) |\n| [SQL](http://www.banshujiang.cn/category/programming_language/SQL/page/1)                     | [category/programming_language/SQL](https://rsshub.app/banshujiang/programming_language/SQL)                       |\n| [Swift](http://www.banshujiang.cn/category/programming_language/Swift/page/1)                 | [category/programming_language/Swift](https://rsshub.app/banshujiang/programming_language/Swift)                   |\n| [TypeScript](http://www.banshujiang.cn/category/programming_language/TypeScript/page/1)       | [category/programming_language/TypeScript](https://rsshub.app/banshujiang/programming_language/TypeScript)         |\n\n#### 移动开发\n\n| 分类                                                                            | ID                                                                                               |\n| ------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------ |\n| [Android](http://www.banshujiang.cn/category/mobile_development/Android/page/1) | [category/mobile_development/Android](https://rsshub.app/banshujiang/mobile_development/Android) |\n| [iOS](http://www.banshujiang.cn/category/mobile_development/iOS/page/1)         | [category/mobile_development/iOS](https://rsshub.app/banshujiang/mobile_development/iOS)         |\n\n#### 操作系统\n\n| 分类                                                                                | ID                                                                                                     |\n| ----------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------ |\n| [Linux](http://www.banshujiang.cn/category/operation_system/Linux/page/1)           | [category/operation_system/Linux](https://rsshub.app/banshujiang/operation_system/Linux)               |\n| [Mac OS X](http://www.banshujiang.cn/category/operation_system/Mac%20OS%20X/page/1) | [category/operation_system/Mac%20OS%20X](https://rsshub.app/banshujiang/operation_system/Mac%20OS%20X) |\n| [Unix](http://www.banshujiang.cn/category/operation_system/Unix/page/1)             | [category/operation_system/Unix](https://rsshub.app/banshujiang/operation_system/Unix)                 |\n| [Windows](http://www.banshujiang.cn/category/operation_system/Windows/page/1)       | [category/operation_system/Windows](https://rsshub.app/banshujiang/operation_system/Windows)           |\n\n#### 数据库\n\n| 分类                                                                          | ID                                                                                     |\n| ----------------------------------------------------------------------------- | -------------------------------------------------------------------------------------- |\n| [DB2](http://www.banshujiang.cn/category/database/DB2/page/1)                 | [category/database/DB2](https://rsshub.app/banshujiang/database/DB2)                   |\n| [MongoDB](http://www.banshujiang.cn/category/database/MongoDB/page/1)         | [category/database/MongoDB](https://rsshub.app/banshujiang/database/MongoDB)           |\n| [MySQL](http://www.banshujiang.cn/category/database/MySQL/page/1)             | [category/database/MySQL](https://rsshub.app/banshujiang/database/MySQL)               |\n| [Oracle](http://www.banshujiang.cn/category/database/Oracle/page/1)           | [category/database/Oracle](https://rsshub.app/banshujiang/database/Oracle)             |\n| [PostgreSQL](http://www.banshujiang.cn/category/database/PostgreSQL/page/1)   | [category/database/PostgreSQL](https://rsshub.app/banshujiang/database/PostgreSQL)     |\n| [SQL Server](http://www.banshujiang.cn/category/database/SQL%20Server/page/1) | [category/database/SQL%20Server](https://rsshub.app/banshujiang/database/SQL%20Server) |\n| [SQLite](http://www.banshujiang.cn/category/database/SQLite/page/1)           | [category/database/SQLite](https://rsshub.app/banshujiang/database/SQLite)             |\n\n#### 开源软件\n\n| 分类                                                                            | ID                                                                                        |\n| ------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------- |\n| [Apache 项目](http://www.banshujiang.cn/category/open_source/Apache项目/page/1) | [category/open_source/Apache 项目](https://rsshub.app/banshujiang/open_source/Apache项目) |\n| [Web 开发](http://www.banshujiang.cn/category/open_source/Web开发/page/1)       | [category/open_source/Web 开发](https://rsshub.app/banshujiang/open_source/Web开发)       |\n| [区块链](http://www.banshujiang.cn/category/open_source/区块链/page/1)          | [category/open_source/区块链](https://rsshub.app/banshujiang/open_source/区块链)          |\n| [程序开发](http://www.banshujiang.cn/category/open_source/程序开发/page/1)      | [category/open_source/程序开发](https://rsshub.app/banshujiang/open_source/程序开发)      |\n\n#### 其他\n\n| 分类                                                                 | ID                                                                       |\n| -------------------------------------------------------------------- | ------------------------------------------------------------------------ |\n| [人工智能](http://www.banshujiang.cn/category/other/人工智能/page/1) | [category/other/人工智能](https://rsshub.app/banshujiang/other/人工智能) |\n| [容器技术](http://www.banshujiang.cn/category/other/容器技术/page/1) | [category/other/容器技术](https://rsshub.app/banshujiang/other/容器技术) |\n\n#### 语言\n\n| 分类                                                            | ID                                                                     |\n| --------------------------------------------------------------- | ---------------------------------------------------------------------- |\n| [中文](http://www.banshujiang.cn/category/language/中文/page/1) | [category/language/中文](https://rsshub.app/banshujiang/language/中文) |\n| [英文](http://www.banshujiang.cn/category/language/英文/page/1) | [category/language/英文](https://rsshub.app/banshujiang/language/英文) |\n\n</details>\n",
        "categories": [
          "reading"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "banshujiang.cn/:category?"
            ]
          },
          {
            "title": "ActionScript",
            "source": [
              "banshujiang.cn/programming_language/ActionScript/page/1"
            ],
            "target": "/programming_language/ActionScript"
          },
          {
            "title": "ASP.net",
            "source": [
              "banshujiang.cn/programming_language/ASP.net/page/1"
            ],
            "target": "/programming_language/ASP.net"
          },
          {
            "title": "C",
            "source": [
              "banshujiang.cn/programming_language/C"
            ],
            "target": "/programming_language/C"
          },
          {
            "title": "C#",
            "source": [
              "banshujiang.cn/programming_language/C%23"
            ],
            "target": "/programming_language/C%23"
          },
          {
            "title": "C++",
            "source": [
              "banshujiang.cn/programming_language/C++"
            ],
            "target": "/programming_language/C++"
          },
          {
            "title": "CoffeeScript",
            "source": [
              "banshujiang.cn/programming_language/CoffeeScript"
            ],
            "target": "/programming_language/CoffeeScript"
          },
          {
            "title": "CSS",
            "source": [
              "banshujiang.cn/programming_language/CSS"
            ],
            "target": "/programming_language/CSS"
          },
          {
            "title": "Dart",
            "source": [
              "banshujiang.cn/programming_language/Dart"
            ],
            "target": "/programming_language/Dart"
          },
          {
            "title": "Elixir",
            "source": [
              "banshujiang.cn/programming_language/Elixir"
            ],
            "target": "/programming_language/Elixir"
          },
          {
            "title": "Erlang",
            "source": [
              "banshujiang.cn/programming_language/Erlang"
            ],
            "target": "/programming_language/Erlang"
          },
          {
            "title": "F#",
            "source": [
              "banshujiang.cn/programming_language/F%23"
            ],
            "target": "/programming_language/F%23"
          },
          {
            "title": "Go",
            "source": [
              "banshujiang.cn/programming_language/Go"
            ],
            "target": "/programming_language/Go"
          },
          {
            "title": "Groovy",
            "source": [
              "banshujiang.cn/programming_language/Groovy"
            ],
            "target": "/programming_language/Groovy"
          },
          {
            "title": "Haskell",
            "source": [
              "banshujiang.cn/programming_language/Haskell"
            ],
            "target": "/programming_language/Haskell"
          },
          {
            "title": "HTML5",
            "source": [
              "banshujiang.cn/programming_language/HTML5"
            ],
            "target": "/programming_language/HTML5"
          },
          {
            "title": "Java",
            "source": [
              "banshujiang.cn/programming_language/Java"
            ],
            "target": "/programming_language/Java"
          },
          {
            "title": "JavaScript",
            "source": [
              "banshujiang.cn/programming_language/JavaScript"
            ],
            "target": "/programming_language/JavaScript"
          },
          {
            "title": "Kotlin",
            "source": [
              "banshujiang.cn/programming_language/Kotlin"
            ],
            "target": "/programming_language/Kotlin"
          },
          {
            "title": "Lua",
            "source": [
              "banshujiang.cn/programming_language/Lua"
            ],
            "target": "/programming_language/Lua"
          },
          {
            "title": "Objective-C",
            "source": [
              "banshujiang.cn/programming_language/Objective-C"
            ],
            "target": "/programming_language/Objective-C"
          },
          {
            "title": "Perl",
            "source": [
              "banshujiang.cn/programming_language/Perl"
            ],
            "target": "/programming_language/Perl"
          },
          {
            "title": "PHP",
            "source": [
              "banshujiang.cn/programming_language/PHP"
            ],
            "target": "/programming_language/PHP"
          },
          {
            "title": "PowerShell",
            "source": [
              "banshujiang.cn/programming_language/PowerShell"
            ],
            "target": "/programming_language/PowerShell"
          },
          {
            "title": "Python",
            "source": [
              "banshujiang.cn/programming_language/Python"
            ],
            "target": "/programming_language/Python"
          },
          {
            "title": "R",
            "source": [
              "banshujiang.cn/programming_language/R/page/1"
            ],
            "target": "/programming_language/R"
          },
          {
            "title": "Ruby",
            "source": [
              "banshujiang.cn/programming_language/Ruby/page/1"
            ],
            "target": "/programming_language/Ruby"
          },
          {
            "title": "Rust",
            "source": [
              "banshujiang.cn/programming_language/Rust/page/1"
            ],
            "target": "/programming_language/Rust"
          },
          {
            "title": "Scala",
            "source": [
              "banshujiang.cn/programming_language/Scala/page/1"
            ],
            "target": "/programming_language/Scala"
          },
          {
            "title": "Shell Script",
            "source": [
              "banshujiang.cn/programming_language/Shell%20Script/page/1"
            ],
            "target": "/programming_language/Shell%20Script"
          },
          {
            "title": "SQL",
            "source": [
              "banshujiang.cn/programming_language/SQL/page/1"
            ],
            "target": "/programming_language/SQL"
          },
          {
            "title": "Swift",
            "source": [
              "banshujiang.cn/programming_language/Swift/page/1"
            ],
            "target": "/programming_language/Swift"
          },
          {
            "title": "TypeScript",
            "source": [
              "banshujiang.cn/programming_language/TypeScript/page/1"
            ],
            "target": "/programming_language/TypeScript"
          },
          {
            "title": "Android",
            "source": [
              "banshujiang.cn/mobile_development/Android/page/1"
            ],
            "target": "/mobile_development/Android"
          },
          {
            "title": "iOS",
            "source": [
              "banshujiang.cn/mobile_development/iOS/page/1"
            ],
            "target": "/mobile_development/iOS"
          },
          {
            "title": "Linux",
            "source": [
              "banshujiang.cn/operation_system/Linux/page/1"
            ],
            "target": "/operation_system/Linux"
          },
          {
            "title": "Mac OS X",
            "source": [
              "banshujiang.cn/operation_system/Mac%20OS%20X/page/1"
            ],
            "target": "/operation_system/Mac%20OS%20X"
          },
          {
            "title": "Unix",
            "source": [
              "banshujiang.cn/operation_system/Unix/page/1"
            ],
            "target": "/operation_system/Unix"
          },
          {
            "title": "Windows",
            "source": [
              "banshujiang.cn/operation_system/Windows/page/1"
            ],
            "target": "/operation_system/Windows"
          },
          {
            "title": "DB2",
            "source": [
              "banshujiang.cn/database/DB2/page/1"
            ],
            "target": "/database/DB2"
          },
          {
            "title": "MongoDB",
            "source": [
              "banshujiang.cn/database/MongoDB/page/1"
            ],
            "target": "/database/MongoDB"
          },
          {
            "title": "MySQL",
            "source": [
              "banshujiang.cn/database/MySQL/page/1"
            ],
            "target": "/database/MySQL"
          },
          {
            "title": "Oracle",
            "source": [
              "banshujiang.cn/database/Oracle/page/1"
            ],
            "target": "/database/Oracle"
          },
          {
            "title": "PostgreSQL",
            "source": [
              "banshujiang.cn/database/PostgreSQL/page/1"
            ],
            "target": "/database/PostgreSQL"
          },
          {
            "title": "SQL Server",
            "source": [
              "banshujiang.cn/database/SQL%20Server/page/1"
            ],
            "target": "/database/SQL%20Server"
          },
          {
            "title": "SQLite",
            "source": [
              "banshujiang.cn/database/SQLite/page/1"
            ],
            "target": "/database/SQLite"
          },
          {
            "title": "Apache 项目",
            "source": [
              "banshujiang.cn/open_source/Apache项目/page/1"
            ],
            "target": "/open_source/Apache 项目"
          },
          {
            "title": "Web 开发",
            "source": [
              "banshujiang.cn/open_source/Web开发/page/1"
            ],
            "target": "/open_source/Web 开发"
          },
          {
            "title": "区块链",
            "source": [
              "banshujiang.cn/open_source/区块链/page/1"
            ],
            "target": "/open_source/区块链"
          },
          {
            "title": "程序开发",
            "source": [
              "banshujiang.cn/open_source/程序开发/page/1"
            ],
            "target": "/open_source/程序开发"
          },
          {
            "title": "人工智能",
            "source": [
              "banshujiang.cn/other/人工智能/page/1"
            ],
            "target": "/other/人工智能"
          },
          {
            "title": "容器技术",
            "source": [
              "banshujiang.cn/other/容器技术/page/1"
            ],
            "target": "/other/容器技术"
          },
          {
            "title": "中文",
            "source": [
              "banshujiang.cn/language/中文/page/1"
            ],
            "target": "/language/中文"
          },
          {
            "title": "英文",
            "source": [
              "banshujiang.cn/language/英文/page/1"
            ],
            "target": "/language/英文"
          }
        ],
        "view": 0,
        "location": "index.ts",
        "module": () => import('@/routes/banshujiang/index.ts')
      }
    },
    "name": "搬书匠",
    "apiRoutes": {},
    "url": "banshujiang.cn",
    "categories": [
      "reading"
    ],
    "description": "",
    "lang": "zh-CN"
  },
  "banyuetan": {
    "routes": {
      "/:id?": {
        "path": "/:id?",
        "name": "栏目",
        "url": "www.banyuetan.org",
        "maintainers": [
          "nczitzk"
        ],
        "example": "/banyuetan/jinritan",
        "parameters": {
          "id": {
            "description": "栏目 ID，默认为 `jinritan`，即今日谈，可在对应分类页 URL 中找到",
            "options": [
              {
                "label": "今日谈",
                "value": "jinritan"
              },
              {
                "label": "时政讲解",
                "value": "shizhengjiangjie"
              },
              {
                "label": "评论",
                "value": "banyuetanpinglun"
              },
              {
                "label": "基层治理",
                "value": "jicengzhili"
              },
              {
                "label": "文化",
                "value": "wenhua"
              },
              {
                "label": "教育",
                "value": "jiaoyu"
              }
            ]
          }
        },
        "description": "::: tip\n订阅 [今日谈](http://www.banyuetan.org/byt/jinritan/)，其源网址为 `http://www.banyuetan.org/byt/jinritan/`，请参考该 URL 指定部分构成参数，此时路由为 [`/banyuetan/jinritan`](https://rsshub.app/banyuetan/jinritan)。\n:::\n\n| 栏目                                                                 | ID                                                                |\n| -------------------------------------------------------------------- | ----------------------------------------------------------------- |\n| [今日谈](http://www.banyuetan.org/byt/jinritan/index.html)           | [jinritan](https://rsshub.app/banyuetan/jinritan)                 |\n| [时政讲解](http://www.banyuetan.org/byt/shizhengjiangjie/index.html) | [shizhengjiangjie](https://rsshub.app/banyuetan/shizhengjiangjie) |\n| [评论](http://www.banyuetan.org/byt/banyuetanpinglun/index.html)     | [banyuetanpinglun](https://rsshub.app/banyuetan/banyuetanpinglun) |\n| [基层治理](http://www.banyuetan.org/byt/jicengzhili/index.html)      | [jicengzhili](https://rsshub.app/banyuetan/jicengzhili)           |\n| [文化](http://www.banyuetan.org/byt/wenhua/index.html)               | [wenhua](https://rsshub.app/banyuetan/wenhua)                     |\n| [教育](http://www.banyuetan.org/byt/jiaoyu/index.html)               | [jiaoyu](https://rsshub.app/banyuetan/jiaoyu)                     |\n\n",
        "categories": [
          "traditional-media"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.banyuetan.org/byt/:id"
            ],
            "target": "/:id"
          },
          {
            "title": "今日谈",
            "source": [
              "www.banyuetan.org/byt/jinritan/index.html"
            ],
            "target": "/jinritan"
          },
          {
            "title": "时政讲解",
            "source": [
              "www.banyuetan.org/byt/shizhengjiangjie/index.html"
            ],
            "target": "/shizhengjiangjie"
          },
          {
            "title": "评论",
            "source": [
              "www.banyuetan.org/byt/banyuetanpinglun/index.html"
            ],
            "target": "/banyuetanpinglun"
          },
          {
            "title": "基层治理",
            "source": [
              "www.banyuetan.org/byt/jicengzhili/index.html"
            ],
            "target": "/jicengzhili"
          },
          {
            "title": "文化",
            "source": [
              "www.banyuetan.org/byt/wenhua/index.html"
            ],
            "target": "/wenhua"
          },
          {
            "title": "教育",
            "source": [
              "www.banyuetan.org/byt/jiaoyu/index.html"
            ],
            "target": "/jiaoyu"
          }
        ],
        "view": 0,
        "location": "index.ts",
        "module": () => import('@/routes/banyuetan/index.ts')
      }
    },
    "name": "半月谈",
    "apiRoutes": {},
    "url": "banyuetan.org",
    "categories": [
      "traditional-media"
    ],
    "description": "",
    "lang": "zh-CN"
  },
  "baobua": {
    "routes": {
      "/category/:category": {
        "path": "/category/:category",
        "categories": [
          "picture"
        ],
        "example": "/baobua/category/network",
        "parameters": {
          "category": "Category"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "baobua.com/cat/:category"
            ],
            "target": "/category/:category"
          }
        ],
        "name": "Category",
        "maintainers": [
          "AiraNadih"
        ],
        "url": "baobua.com/",
        "location": "category.ts",
        "module": () => import('@/routes/baobua/category.ts')
      },
      "/": {
        "path": "/",
        "categories": [
          "picture"
        ],
        "example": "/baobua",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "baobua.com/"
            ],
            "target": ""
          }
        ],
        "name": "Latest",
        "maintainers": [
          "AiraNadih"
        ],
        "url": "baobua.com/",
        "location": "latest.ts",
        "module": () => import('@/routes/baobua/latest.ts')
      },
      "/search/:keyword": {
        "path": "/search/:keyword",
        "categories": [
          "picture"
        ],
        "example": "/baobua/search/cos",
        "parameters": {
          "keyword": "Keyword"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "baobua.com/search"
            ],
            "target": "/search/:keyword"
          }
        ],
        "name": "Search",
        "maintainers": [
          "AiraNadih"
        ],
        "url": "baobua.com/",
        "location": "search.ts",
        "module": () => import('@/routes/baobua/search.ts')
      }
    },
    "name": "BaoBua",
    "apiRoutes": {},
    "url": "baobua.com",
    "description": "BaoBua.Com - Hot beauty girl pics, girls photos, free watch online hd photo sets",
    "lang": "en"
  },
  "baoyu": {
    "routes": {
      "/blog": {
        "path": "/blog",
        "categories": [
          "blog"
        ],
        "example": "/baoyu/blog",
        "radar": [
          {
            "source": [
              "baoyu.io/"
            ]
          }
        ],
        "url": "baoyu.io/",
        "name": "Blog",
        "maintainers": [
          "liyaozhong",
          "Circloud"
        ],
        "description": "宝玉 - 博客文章",
        "location": "index.ts",
        "module": () => import('@/routes/baoyu/index.ts')
      }
    },
    "name": "宝玉",
    "apiRoutes": {},
    "url": "baoyu.io",
    "description": "宝玉的博客",
    "lang": "zh-CN"
  },
  "baozimh": {
    "routes": {
      "/comic/:name": {
        "path": "/comic/:name",
        "categories": [
          "anime"
        ],
        "example": "/baozimh/comic/guowangpaiming-shiricaofu",
        "parameters": {
          "name": "漫画名称，在漫画链接可以得到(`comic/` 后的那段)"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.baozimh.com/comic/:name"
            ]
          }
        ],
        "name": "订阅漫画",
        "maintainers": [
          "Fatpandac"
        ],
        "location": "index.tsx",
        "module": () => import('@/routes/baozimh/index.tsx')
      }
    },
    "name": "包子漫画",
    "apiRoutes": {},
    "url": "www.baozimh.com",
    "lang": "zh-CN"
  },
  "barronschina": {
    "routes": {
      "/:id?": {
        "path": "/:id?",
        "categories": [
          "finance"
        ],
        "example": "/barronschina",
        "parameters": {
          "id": "栏目 id，默认为快讯"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "barronschina.com.cn/"
            ],
            "target": "/:category?"
          }
        ],
        "name": "栏目",
        "maintainers": [
          "nczitzk"
        ],
        "url": "barronschina.com.cn/",
        "description": "::: tip\n  栏目 id 留空则返回快讯，在对应页地址栏 `columnId=` 后可以看到。\n:::",
        "location": "index.ts",
        "module": () => import('@/routes/barronschina/index.ts')
      }
    },
    "name": "巴伦周刊中文版",
    "apiRoutes": {},
    "url": "barronschina.com.cn",
    "lang": "zh-CN"
  },
  "baselang": {
    "routes": {
      "/blog/:category?": {
        "path": "/blog/:category?",
        "categories": [
          "blog"
        ],
        "example": "/baselang/blog",
        "parameters": {
          "category": {
            "description": "Optional category filter",
            "options": [
              {
                "label": "advanced-grammar",
                "value": "advanced-grammar"
              },
              {
                "label": "basic-grammar",
                "value": "basic-grammar"
              },
              {
                "label": "company",
                "value": "company"
              },
              {
                "label": "confidence",
                "value": "confidence"
              },
              {
                "label": "french",
                "value": "french"
              },
              {
                "label": "humor",
                "value": "humor"
              },
              {
                "label": "medellin",
                "value": "medellin"
              },
              {
                "label": "motivation",
                "value": "motivation"
              },
              {
                "label": "pronunciation",
                "value": "pronunciation"
              },
              {
                "label": "study-tips",
                "value": "study-tips"
              },
              {
                "label": "success-stories",
                "value": "success-stories"
              },
              {
                "label": "travel",
                "value": "travel"
              },
              {
                "label": "uncategorized",
                "value": "uncategorized"
              },
              {
                "label": "vocabulary",
                "value": "vocabulary"
              }
            ]
          }
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "baselang.com/blog",
              "baselang.com/blog/:category"
            ],
            "target": "/blog/:category"
          }
        ],
        "name": "Blog",
        "maintainers": [
          "johan456789"
        ],
        "location": "index.ts",
        "module": () => import('@/routes/baselang/index.ts')
      }
    },
    "name": "BaseLang",
    "apiRoutes": {},
    "lang": "en"
  },
  "bast": {
    "routes": {
      "*": {
        "path": "*",
        "name": "Unknown",
        "maintainers": [],
        "location": "index.ts",
        "module": () => import('@/routes/bast/index.ts')
      }
    },
    "name": "北京市科学技术协会",
    "apiRoutes": {},
    "url": "bast.net.cn",
    "lang": "zh-CN"
  },
  "bbc": {
    "routes": {
      "/:site?/:channel?": {
        "path": "/:site?/:channel?",
        "name": "News",
        "maintainers": [
          "HenryQW",
          "DIYgod",
          "pseudoyu"
        ],
        "example": "/bbc/world-asia",
        "parameters": {
          "site": "语言，简体或繁体中文",
          "channel": "channel, default to `top stories`"
        },
        "categories": [
          "traditional-media"
        ],
        "description": "Provides a better reading experience (full text articles) over the official ones.\n\n    Support major channels, refer to [BBC RSS feeds](https://www.bbc.co.uk/news/10628494). Eg, `business` for `https://feeds.bbci.co.uk/news/business/rss.xml`.\n\n    -   Channel contains sub-directories, such as `https://feeds.bbci.co.uk/news/world/asia/rss.xml`, replace `/` with `-`, `/bbc/world-asia`.",
        "location": "index.ts",
        "module": () => import('@/routes/bbc/index.ts')
      },
      "/learningenglish/:channel?": {
        "name": "Learning English",
        "maintainers": [
          "Blank0120"
        ],
        "categories": [
          "study"
        ],
        "path": "/learningenglish/:channel?",
        "example": "/bbc/learningenglish/take-away-english",
        "parameters": {
          "channel": {
            "description": "英语学习分类栏目",
            "options": [
              {
                "value": "take-away-english",
                "label": "随身英语"
              },
              {
                "value": "authentic-real-english",
                "label": "地道英语"
              },
              {
                "value": "media-english",
                "label": "媒体英语"
              },
              {
                "value": "lingohack",
                "label": "英语大破解"
              },
              {
                "value": "english-in-a-minute",
                "label": "一分钟英语"
              },
              {
                "value": "phrasal-verbs",
                "label": "短语动词"
              },
              {
                "value": "todays-phrase",
                "label": "今日短语"
              },
              {
                "value": "q-and-a",
                "label": "你问我答"
              },
              {
                "value": "english-at-work",
                "label": "白领英语"
              },
              {
                "value": "storytellers",
                "label": "亲子英语故事"
              }
            ],
            "default": "take-away-english"
          }
        },
        "location": "learningenglish.ts",
        "module": () => import('@/routes/bbc/learningenglish.ts')
      }
    },
    "name": "BBC",
    "apiRoutes": {},
    "url": "bbc.com",
    "lang": "en"
  },
  "bbcnewslabs": {
    "routes": {
      "/news": {
        "path": "/news",
        "categories": [
          "programming"
        ],
        "example": "/bbcnewslabs/news",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "bbcnewslabs.co.uk/"
            ]
          }
        ],
        "name": "News",
        "maintainers": [
          "elxy"
        ],
        "url": "bbcnewslabs.co.uk/",
        "location": "news.ts",
        "module": () => import('@/routes/bbcnewslabs/news.ts')
      }
    },
    "name": "BBC News Labs",
    "url": "bbcnewslabs.co.uk",
    "lang": "en"
  },
  "bc3ts": {
    "routes": {
      "/post/list/:sort?": {
        "path": "/post/list/:sort?",
        "example": "/bc3ts/post/list",
        "parameters": {
          "sort": "排序方式，`1` 為最新，`2` 為熱門，默认為 `1`"
        },
        "features": {
          "antiCrawler": true
        },
        "radar": [
          {
            "source": [
              "web.bc3ts.net"
            ]
          }
        ],
        "name": "動態",
        "maintainers": [
          "TonyRL"
        ],
        "location": "list.tsx",
        "module": () => import('@/routes/bc3ts/list.tsx')
      }
    },
    "name": "爆料公社",
    "apiRoutes": {},
    "url": "web.bc3ts.net",
    "categories": [
      "new-media"
    ],
    "lang": "zh-CN"
  },
  "bdys": {
    "routes": {
      "/:caty?/:type?/:area?/:year?/:order?": {
        "path": "/:caty?/:type?/:area?/:year?/:order?",
        "categories": [
          "multimedia"
        ],
        "example": "/bdys",
        "parameters": {
          "caty": "影视类型，见下表，默认为 `all` 即不限",
          "type": "资源分类，见下表，默认为 `all` 即不限",
          "area": "制片地区，见下表，默认为 `all` 即不限",
          "year": "上映时间，此处填写年份不小于2000，默认为 `all` 即不限",
          "order": "影视排序，见下表，默认为更新时间"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "首页",
        "maintainers": [
          "nczitzk"
        ],
        "description": "#### 资源分类\n\n| 不限 | 电影 | 电视剧 |\n| ---- | ---- | ------ |\n| all  | 0    | 1      |\n\n#### 影视类型\n\n| 不限 | 动作    | 爱情   | 喜剧 | 科幻   | 恐怖   |\n| ---- | ------- | ------ | ---- | ------ | ------ |\n| all  | dongzuo | aiqing | xiju | kehuan | kongbu |\n\n| 战争      | 武侠  | 魔幻   | 剧情   | 动画    | 惊悚     |\n| --------- | ----- | ------ | ------ | ------- | -------- |\n| zhanzheng | wuxia | mohuan | juqing | donghua | jingsong |\n\n| 3D | 灾难   | 悬疑   | 警匪    | 文艺  | 青春     |\n| -- | ------ | ------ | ------- | ----- | -------- |\n| 3D | zainan | xuanyi | jingfei | wenyi | qingchun |\n\n| 冒险    | 犯罪   | 纪录 | 古装     | 奇幻   | 国语  |\n| ------- | ------ | ---- | -------- | ------ | ----- |\n| maoxian | fanzui | jilu | guzhuang | qihuan | guoyu |\n\n| 综艺   | 历史  | 运动    | 原创压制   |\n| ------ | ----- | ------- | ---------- |\n| zongyi | lishi | yundong | yuanchuang |\n\n| 美剧  | 韩剧  | 国产电视剧 | 日剧 | 英剧   | 德剧 |\n| ----- | ----- | ---------- | ---- | ------ | ---- |\n| meiju | hanju | guoju      | riju | yingju | deju |\n\n| 俄剧 | 巴剧 | 加剧  | 西剧    | 意大利剧 | 泰剧  |\n| ---- | ---- | ----- | ------- | -------- | ----- |\n| eju  | baju | jiaju | spanish | yidaliju | taiju |\n\n| 港台剧    | 法剧 | 澳剧 |\n| --------- | ---- | ---- |\n| gangtaiju | faju | aoju |\n\n#### 制片地区\n\n| 大陆 | 中国香港 | 中国台湾 |\n| ---- | -------- | -------- |\n\n| 美国 | 英国 | 日本 | 韩国 | 法国 |\n| ---- | ---- | ---- | ---- | ---- |\n\n| 印度 | 德国 | 西班牙 | 意大利 | 澳大利亚 |\n| ---- | ---- | ------ | ------ | -------- |\n\n| 比利时 | 瑞典 | 荷兰 | 丹麦 | 加拿大 | 俄罗斯 |\n| ------ | ---- | ---- | ---- | ------ | ------ |\n\n#### 影视排序\n\n| 更新时间 | 豆瓣评分 |\n| -------- | -------- |\n| 0        | 1        |",
        "location": "index.tsx",
        "module": () => import('@/routes/bdys/index.tsx')
      }
    },
    "name": "哔嘀影视",
    "apiRoutes": {},
    "url": "52bdys.com",
    "description": "::: tip\n哔嘀影视有多个备用域名，路由默认使用域名 `https://bdys01.com`。若该域名无法访问，可以通过在路由最后加上 `?domain=<域名>` 指定路由访问的域名。如指定备用域名为 `https://bde4.icu`，则在所有哔嘀影视路由最后加上 `?domain=bde4.icu` 即可，此时路由为 [`/bdys?domain=bde4.icu`](https://rsshub.app/bdys?domain=bde4.icu)\n:::",
    "lang": "zh-CN"
  },
  "behance": {
    "routes": {
      "/:user/:type?": {
        "path": "/:user/:type?",
        "categories": [
          "design"
        ],
        "view": 2,
        "example": "/behance/mishapetrick",
        "parameters": {
          "user": "username",
          "type": {
            "description": "type",
            "options": [
              {
                "value": "projects",
                "label": "projects"
              },
              {
                "value": "appreciated",
                "label": "appreciated"
              }
            ],
            "default": "projects"
          }
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "User Works",
        "maintainers": [
          "MisteryMonster"
        ],
        "description": "Behance user's profile URL, like [https://www.behance.net/mishapetrick](https://www.behance.net/mishapetrick) the username will be `mishapetrick`。",
        "location": "user.tsx",
        "module": () => import('@/routes/behance/user.tsx')
      }
    },
    "name": "Behance",
    "url": "www.behance.net",
    "lang": "en"
  },
  "beijingprice": {
    "routes": {
      "/:category{.+}?": {
        "path": "/:category{.+}?",
        "name": "资讯",
        "url": "beijingprice.cn",
        "maintainers": [
          "nczitzk"
        ],
        "example": "/beijingprice/jgzx/xwzx",
        "parameters": {
          "category": "分类，默认为 `jgzx/xwzx` 即新闻资讯，可在对应分类页 URL 中找到"
        },
        "description": "::: tip\n  若订阅 [新闻资讯](https://www.beijingprice.cn/jgzx/xwzx/)，网址为 `https://www.beijingprice.cn/jgzx/xwzx/`。截取 `https://beijingprice.cn/` 到末尾 `/` 的部分 `jgzx/xwzx` 作为参数填入，此时路由为 [`/beijingprice/jgzx/xwzx`](https://rsshub.app/beijingprice/jgzx/xwzx)。\n:::\n\n#### [价格资讯](https://www.beijingprice.cn/jgzx/xwzx/)\n\n| [新闻资讯](https://www.beijingprice.cn/jgzx/xwzx/)     | [工作动态](https://www.beijingprice.cn/jgzx/gzdt/)     | [各区动态](https://www.beijingprice.cn/jgzx/gqdt/)     | [通知公告](https://www.beijingprice.cn/jgzx/tzgg/)     | [价格早报](https://www.beijingprice.cn/jgzx/jgzb/)     |\n| ------------------------------------------------------ | ------------------------------------------------------ | ------------------------------------------------------ | ------------------------------------------------------ | ------------------------------------------------------ |\n| [jgzx/xwzx](https://rsshub.app/beijingprice/jgzx/xwzx) | [jgzx/gzdt](https://rsshub.app/beijingprice/jgzx/gzdt) | [jgzx/gqdt](https://rsshub.app/beijingprice/jgzx/gqdt) | [jgzx/tzgg](https://rsshub.app/beijingprice/jgzx/tzgg) | [jgzx/jgzb](https://rsshub.app/beijingprice/jgzx/jgzb) |\n\n#### [综合信息](https://www.beijingprice.cn/zhxx/cbjs/)\n\n| [价格听证](https://www.beijingprice.cn/zhxx/jgtz/)     | [价格监测定点单位名单](https://www.beijingprice.cn/zhxx/jgjcdddwmd/) | [部门预算决算](https://www.beijingprice.cn/bmys/) |\n| ------------------------------------------------------ | -------------------------------------------------------------------- | ------------------------------------------------- |\n| [zhxx/jgtz](https://rsshub.app/beijingprice/zhxx/jgtz) | [zhxx/jgjcdddwmd](https://rsshub.app/beijingprice/zhxx/jgjcdddwmd)   | [bmys](https://rsshub.app/beijingprice/bmys)      |\n    ",
        "categories": [
          "government"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "beijingprice.cn/:category?"
            ]
          },
          {
            "title": "价格资讯 - 新闻资讯",
            "source": [
              "beijingprice.cn/jgzx/xwzx/"
            ],
            "target": "/jgzx/xwzx"
          },
          {
            "title": "价格资讯 - 工作动态",
            "source": [
              "beijingprice.cn/jgzx/gzdt/"
            ],
            "target": "/jgzx/gzdt"
          },
          {
            "title": "价格资讯 - 各区动态",
            "source": [
              "beijingprice.cn/jgzx/gqdt/"
            ],
            "target": "/jgzx/gqdt"
          },
          {
            "title": "价格资讯 - 通知公告",
            "source": [
              "beijingprice.cn/jgzx/tzgg/"
            ],
            "target": "/jgzx/tzgg"
          },
          {
            "title": "价格资讯 - 价格早报",
            "source": [
              "beijingprice.cn/jgzx/jgzb/"
            ],
            "target": "/jgzx/jgzb"
          },
          {
            "title": "综合信息 - 价格听证",
            "source": [
              "beijingprice.cn/zhxx/jgtz/"
            ],
            "target": "/zhxx/jgtz"
          },
          {
            "title": "综合信息 - 价格监测定点单位名单",
            "source": [
              "beijingprice.cn/zhxx/jgjcdddwmd/"
            ],
            "target": "/zhxx/jgjcdddwmd"
          },
          {
            "title": "综合信息 - 部门预算决算",
            "source": [
              "beijingprice.cn/bmys/"
            ],
            "target": "/bmys"
          }
        ],
        "location": "index.ts",
        "module": () => import('@/routes/beijingprice/index.ts')
      }
    },
    "name": "北京价格",
    "apiRoutes": {},
    "url": "beijingprice.cn",
    "categories": [
      "government"
    ],
    "description": "",
    "lang": "zh-CN"
  },
  "bellroy": {
    "routes": {
      "/new-releases": {
        "path": "/new-releases",
        "categories": [
          "shopping"
        ],
        "example": "/bellroy/new-releases",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "bellroy.com/collection/new-releases",
              "bellroy.com/"
            ]
          }
        ],
        "name": "New Releases",
        "maintainers": [
          "EthanWng97"
        ],
        "url": "bellroy.com/collection/new-releases",
        "location": "new-releases.ts",
        "module": () => import('@/routes/bellroy/new-releases.ts')
      }
    },
    "name": "Bellroy",
    "url": "bellroy.com",
    "lang": "zh-CN"
  },
  "bendibao": {
    "routes": {
      "/news/:city": {
        "path": "/news/:city",
        "categories": [
          "new-media"
        ],
        "example": "/bendibao/news/bj",
        "parameters": {
          "city": "城市缩写，可在该城市页面的 URL 中找到"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "bendibao.com/"
            ]
          }
        ],
        "name": "焦点资讯",
        "maintainers": [
          "nczitzk"
        ],
        "url": "bendibao.com/",
        "description": "| 城市名 | 缩写 |\n| ------ | ---- |\n| 北京   | bj   |\n| 上海   | sh   |\n| 广州   | gz   |\n| 深圳   | sz   |\n\n  更多城市请参见 [这里](http://www.bendibao.com/city.htm)\n\n  > **香港特别行政区** 和 **澳门特别行政区** 的本地宝城市页面不更新资讯。",
        "location": "news.ts",
        "module": () => import('@/routes/bendibao/news.ts')
      }
    },
    "name": "本地宝",
    "url": "bendibao.com",
    "lang": "zh-CN"
  },
  "bestblogs": {
    "routes": {
      "/feeds/:category?": {
        "path": "/feeds/:category?",
        "categories": [
          "programming"
        ],
        "example": "/bestblogs/feeds/featured",
        "parameters": {
          "category": "the category of articles. Can be `programming`, `ai`, `product`, `business` or `featured`. Default is `featured`"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "文章列表",
        "maintainers": [
          "zhenlohuang"
        ],
        "location": "feeds.ts",
        "module": () => import('@/routes/bestblogs/feeds.ts')
      }
    },
    "name": "bestblogs.dev",
    "apiRoutes": {},
    "url": "www.bestblogs.dev",
    "lang": "zh-CN"
  },
  "bestofjs": {
    "routes": {
      "/rankings/monthly": {
        "path": "/rankings/monthly",
        "categories": [
          "programming"
        ],
        "example": "/bestofjs/rankings/monthly",
        "view": 5,
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "bestofjs.org/rankings/monthly/:year/:month"
            ],
            "target": "/rankings/monthly"
          }
        ],
        "name": "Monthly Rankings",
        "maintainers": [
          "ztkuaikuai"
        ],
        "url": "bestofjs.org/rankings/monthly",
        "location": "monthly.tsx",
        "module": () => import('@/routes/bestofjs/monthly.tsx')
      }
    },
    "name": "Best of JS",
    "apiRoutes": {},
    "url": "bestofjs.org",
    "lang": "en"
  },
  "bfl": {
    "routes": {
      "/announcements": {
        "path": "/announcements",
        "categories": [
          "multimedia"
        ],
        "example": "/bfl/announcements",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "bfl.ai/announcements"
            ],
            "target": "/announcements",
            "title": "Announcements"
          }
        ],
        "name": "Announcements",
        "maintainers": [
          "thirteenkai"
        ],
        "url": "bfl.ai/announcements",
        "description": "Fetches the latest announcements from Black Forest Labs (bfl.ai). Provides full article content by default with caching.",
        "location": "announcements.ts",
        "module": () => import('@/routes/bfl/announcements.ts')
      }
    },
    "name": "BFL AI",
    "apiRoutes": {},
    "url": "bfl.ai",
    "categories": [
      "multimedia"
    ],
    "description": "来自黑森林实验室（bfl.ai）的公告和更新，这是一个前沿的人工智能实验室。",
    "lang": "en"
  },
  "bgmlist": {
    "routes": {
      "/onair/:lang?": {
        "path": "/onair/:lang?",
        "categories": [
          "anime"
        ],
        "example": "/bgmlist/onair/zh-Hans",
        "parameters": {
          "lang": "语言"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "开播提醒",
        "maintainers": [
          "x2cf"
        ],
        "location": "onair.tsx",
        "module": () => import('@/routes/bgmlist/onair.tsx')
      }
    },
    "name": "番组放送",
    "url": "bgmlist.com",
    "lang": "zh-CN"
  },
  "bigquant": {
    "routes": {
      "/collections": {
        "path": "/collections",
        "categories": [
          "finance"
        ],
        "view": 0,
        "example": "/bigquant/collections",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "bigquant.com/"
            ]
          }
        ],
        "name": "专题报告",
        "maintainers": [
          "nczitzk"
        ],
        "url": "bigquant.com/",
        "location": "collections.ts",
        "module": () => import('@/routes/bigquant/collections.ts')
      }
    },
    "name": "BigQuant",
    "apiRoutes": {},
    "url": "bigquant.com",
    "lang": "zh-CN"
  },
  "bilibili": {
    "routes": {
      "/app/:id?": {
        "path": "/app/:id?",
        "categories": [
          "program-update"
        ],
        "example": "/bilibili/app/android",
        "parameters": {
          "id": "客户端 id，见下表，默认为安卓版"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "更新情报",
        "maintainers": [
          "nczitzk"
        ],
        "description": "| 安卓版  | iPhone 版 | iPad HD 版 | UWP 版 | TV 版            |\n| ------- | --------- | ---------- | ------ | ---------------- |\n| android | iphone    | ipad       | win    | android_tv_yst |",
        "location": "app.ts",
        "module": () => import('@/routes/bilibili/app.ts')
      },
      "/user/article/:uid": {
        "path": "/user/article/:uid",
        "categories": [
          "social-media"
        ],
        "example": "/bilibili/user/article/334958638",
        "parameters": {
          "uid": "用户 id, 可在 UP 主主页中找到"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "space.bilibili.com/:uid"
            ]
          }
        ],
        "name": "UP 主图文",
        "maintainers": [
          "lengthmin",
          "Qixingchen",
          "hyoban"
        ],
        "location": "article.ts",
        "module": () => import('@/routes/bilibili/article.ts')
      },
      "/audio/:id": {
        "path": "/audio/:id",
        "categories": [
          "social-media"
        ],
        "example": "/bilibili/audio/10624",
        "parameters": {
          "id": "歌单 id, 可在歌单页 URL 中找到"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "歌单",
        "maintainers": [
          "LogicJake"
        ],
        "location": "audio.ts",
        "module": () => import('@/routes/bilibili/audio.ts')
      },
      "/bangumi/media/:mediaid/:embed?": {
        "path": "/bangumi/media/:mediaid/:embed?",
        "name": "番剧",
        "parameters": {
          "mediaid": "番剧媒体 id, 番剧主页 URL 中获取",
          "embed": "默认为开启内嵌视频, 任意值为关闭"
        },
        "example": "/bilibili/bangumi/media/9192",
        "categories": [
          "social-media"
        ],
        "view": 3,
        "maintainers": [
          "DIYgod",
          "nuomi1"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": true,
          "supportRadar": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "location": "bangumi.ts",
        "module": () => import('@/routes/bilibili/bangumi.ts')
      },
      "/precious/:embed?": {
        "path": "/precious/:embed?",
        "categories": [
          "social-media"
        ],
        "example": "/bilibili/precious",
        "parameters": {
          "embed": "默认为开启内嵌视频, 任意值为关闭"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "入站必刷",
        "maintainers": [
          "liuyuhe666"
        ],
        "location": "bilibili-recommend.ts",
        "module": () => import('@/routes/bilibili/bilibili-recommend.ts')
      },
      "/user/coin/:uid/:embed?": {
        "path": "/user/coin/:uid/:embed?",
        "categories": [
          "social-media"
        ],
        "example": "/bilibili/user/coin/208259",
        "parameters": {
          "uid": "用户 id, 可在 UP 主主页中找到",
          "embed": "默认为开启内嵌视频, 任意值为关闭"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "space.bilibili.com/:uid"
            ],
            "target": "/user/coin/:uid"
          }
        ],
        "name": "UP 主投币视频",
        "maintainers": [
          "DIYgod"
        ],
        "location": "coin.ts",
        "module": () => import('@/routes/bilibili/coin.ts')
      },
      "/video/danmaku/:bvid/:pid?": {
        "path": "/video/danmaku/:bvid/:pid?",
        "categories": [
          "social-media"
        ],
        "example": "/bilibili/video/danmaku/BV1vA411b7ip/1",
        "parameters": {
          "bvid": "视频AV号,可在视频页 URL 中找到",
          "pid": "分P号,不填默认为1"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "视频弹幕",
        "maintainers": [
          "Qixingchen"
        ],
        "location": "danmaku.ts",
        "module": () => import('@/routes/bilibili/danmaku.ts')
      },
      "/user/dynamic/:uid/:routeParams?": {
        "path": "/user/dynamic/:uid/:routeParams?",
        "categories": [
          "social-media"
        ],
        "view": 1,
        "example": "/bilibili/user/dynamic/2267573",
        "parameters": {
          "uid": "用户 id, 可在 UP 主主页中找到",
          "routeParams": "\n| 键         | 含义                              | 接受的值       | 默认值 |\n| ---------- | --------------------------------- | -------------- | ------ |\n| showEmoji  | 显示或隐藏表情图片                | 0/1/true/false | false  |\n| embed      | 默认开启内嵌视频                  | 0/1/true/false |  true  |\n| useAvid    | 视频链接使用 AV 号 (默认为 BV 号) | 0/1/true/false | false  |\n| directLink | 使用内容直链                      | 0/1/true/false | false  |\n| hideGoods  | 隐藏带货动态                      | 0/1/true/false | false  |\n| offset     | 偏移状态                         | string         | \"\"  |\n\n用例：`/bilibili/user/dynamic/2267573/showEmoji=1&embed=0&useAvid=1`"
        },
        "features": {
          "requireConfig": [
            {
              "name": "BILIBILI_COOKIE_*",
              "optional": true,
              "description": "如果没有此配置，那么必须开启 puppeteer 支持；BILIBILI_COOKIE_{uid}: 用于用户关注动态系列路由，对应 uid 的 b 站用户登录后的 Cookie 值，`{uid}` 替换为 uid，如 `BILIBILI_COOKIE_2267573`，获取方式：\n1.  打开 [https://api.vc.bilibili.com/dynamic_svr/v1/dynamic_svr/dynamic_new?uid=0&type=8](https://api.vc.bilibili.com/dynamic_svr/v1/dynamic_svr/dynamic_new?uid=0&type=8)\n2.  打开控制台，切换到 Network 面板，刷新\n3.  点击 dynamic_new 请求，找到 Cookie\n4.  视频和专栏，UP 主粉丝及关注只要求 `SESSDATA` 字段，动态需复制整段 Cookie"
            }
          ],
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "space.bilibili.com/:uid"
            ],
            "target": "/user/dynamic/:uid"
          }
        ],
        "name": "UP 主动态",
        "maintainers": [
          "DIYgod",
          "zytomorrow",
          "CaoMeiYouRen",
          "JimenezLi"
        ],
        "location": "dynamic.ts",
        "module": () => import('@/routes/bilibili/dynamic.ts')
      },
      "/fav/:uid/:fid/:embed?": {
        "path": "/fav/:uid/:fid/:embed?",
        "categories": [
          "social-media"
        ],
        "example": "/bilibili/fav/756508/50948568",
        "parameters": {
          "uid": "用户 id, 可在 UP 主主页中找到",
          "fid": "收藏夹 ID, 可在收藏夹的 URL 中找到, 默认收藏夹建议使用 UP 主默认收藏夹功能",
          "embed": "默认为开启内嵌视频, 任意值为关闭"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "UP 主非默认收藏夹",
        "maintainers": [
          "Qixingchen"
        ],
        "location": "fav.ts",
        "module": () => import('@/routes/bilibili/fav.ts')
      },
      "/user/followers/:uid/:loginUid": {
        "path": "/user/followers/:uid/:loginUid",
        "categories": [
          "social-media"
        ],
        "example": "/bilibili/user/followers/2267573/3",
        "parameters": {
          "uid": "用户 id, 可在 UP 主主页中找到",
          "loginUid": "用于登入的用户id,需要配置对应的 Cookie 值"
        },
        "features": {
          "requireConfig": [
            {
              "name": "BILIBILI_COOKIE_*",
              "description": "BILIBILI_COOKIE_{uid}: 用于用户关注动态系列路由，对应 uid 的 b 站用户登录后的 Cookie 值，`{uid}` 替换为 uid，如 `BILIBILI_COOKIE_2267573`，获取方式：\n1.  打开 [https://api.vc.bilibili.com/dynamic_svr/v1/dynamic_svr/dynamic_new?uid=0&type=8](https://api.vc.bilibili.com/dynamic_svr/v1/dynamic_svr/dynamic_new?uid=0&type=8)\n2.  打开控制台，切换到 Network 面板，刷新\n3.  点击 dynamic_new 请求，找到 Cookie\n4.  视频和专栏，UP 主粉丝及关注只要求 `SESSDATA` 字段，动态需复制整段 Cookie"
            }
          ],
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "space.bilibili.com/:uid"
            ],
            "target": "/user/followers/:uid"
          }
        ],
        "name": "UP 主粉丝",
        "maintainers": [
          "Qixingchen"
        ],
        "description": "::: warning\n  UP 主粉丝现在需要 b 站登录后的 Cookie 值，所以只能自建，详情见部署页面的配置模块。\n:::",
        "location": "followers.ts",
        "module": () => import('@/routes/bilibili/followers.ts')
      },
      "/followings/article/:uid": {
        "path": "/followings/article/:uid",
        "categories": [
          "social-media"
        ],
        "example": "/bilibili/followings/article/99800931",
        "parameters": {
          "uid": "用户 id"
        },
        "features": {
          "requireConfig": [
            {
              "name": "BILIBILI_COOKIE_*",
              "description": "BILIBILI_COOKIE_{uid}: 用于用户关注动态系列路由，对应 uid 的 b 站用户登录后的 Cookie 值，`{uid}` 替换为 uid，如 `BILIBILI_COOKIE_2267573`，获取方式：\n    1.  打开 [https://api.vc.bilibili.com/dynamic_svr/v1/dynamic_svr/dynamic_new?uid=0&type=8](https://api.vc.bilibili.com/dynamic_svr/v1/dynamic_svr/dynamic_new?uid=0&type=8)\n    2.  打开控制台，切换到 Network 面板，刷新\n    3.  点击 dynamic_new 请求，找到 Cookie\n    4.  视频和专栏，UP 主粉丝及关注只要求 `SESSDATA` 字段，动态需复制整段 Cookie"
            }
          ],
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "用户关注专栏",
        "maintainers": [
          "woshiluo"
        ],
        "description": "::: warning\n  用户动态需要 b 站登录后的 Cookie 值，所以只能自建，详情见部署页面的配置模块。\n:::",
        "location": "followings-article.ts",
        "module": () => import('@/routes/bilibili/followings-article.ts')
      },
      "/followings/dynamic/:uid/:routeParams?": {
        "path": "/followings/dynamic/:uid/:routeParams?",
        "categories": [
          "social-media"
        ],
        "example": "/bilibili/followings/dynamic/109937383",
        "parameters": {
          "uid": "用户 id, 可在 UP 主主页中找到",
          "routeParams": "\n| 键         | 含义                              | 接受的值       | 默认值 |\n| ---------- | --------------------------------- | -------------- | ------ |\n| showEmoji  | 显示或隐藏表情图片                | 0/1/true/false | false  |\n| embed      | 默认开启内嵌视频                  | 0/1/true/false |  true  |\n| useAvid    | 视频链接使用 AV 号 (默认为 BV 号) | 0/1/true/false | false  |\n| directLink | 使用内容直链                      | 0/1/true/false | false  |\n| hideGoods  | 隐藏带货动态                      | 0/1/true/false | false  |\n\n用例：`/bilibili/followings/dynamic/2267573/showEmoji=1&embed=0&useAvid=1`"
        },
        "features": {
          "requireConfig": [
            {
              "name": "BILIBILI_COOKIE_*",
              "description": "BILIBILI_COOKIE_{uid}: 用于用户关注动态系列路由，对应 uid 的 b 站用户登录后的 Cookie 值，`{uid}` 替换为 uid，如 `BILIBILI_COOKIE_2267573`，获取方式：\n    1.  打开 [https://api.vc.bilibili.com/dynamic_svr/v1/dynamic_svr/dynamic_new?uid=0&type=8](https://api.vc.bilibili.com/dynamic_svr/v1/dynamic_svr/dynamic_new?uid=0&type=8)\n    2.  打开控制台，切换到 Network 面板，刷新\n    3.  点击 dynamic_new 请求，找到 Cookie\n    4.  视频和专栏，UP 主粉丝及关注只要求 `SESSDATA` 字段，动态需复制整段 Cookie"
            }
          ],
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "用户关注动态",
        "maintainers": [
          "TigerCubDen",
          "JimenezLi"
        ],
        "description": "::: warning\n  用户动态需要 b 站登录后的 Cookie 值，所以只能自建，详情见部署页面的配置模块。\n:::",
        "location": "followings-dynamic.ts",
        "module": () => import('@/routes/bilibili/followings-dynamic.ts')
      },
      "/followings/video/:uid/:embed?": {
        "path": "/followings/video/:uid/:embed?",
        "categories": [
          "social-media"
        ],
        "example": "/bilibili/followings/video/2267573",
        "parameters": {
          "uid": "用户 id",
          "embed": "默认为开启内嵌视频，任意值为关闭"
        },
        "features": {
          "requireConfig": [
            {
              "name": "BILIBILI_COOKIE_*",
              "description": "BILIBILI_COOKIE_{uid}: 用于用户关注动态系列路由，对应 uid 的 b 站用户登录后的 Cookie 值，`{uid}` 替换为 uid，如 `BILIBILI_COOKIE_2267573`，获取方式：\n    1.  打开 [https://api.vc.bilibili.com/dynamic_svr/v1/dynamic_svr/dynamic_new?uid=0&type=8](https://api.vc.bilibili.com/dynamic_svr/v1/dynamic_svr/dynamic_new?uid=0&type=8)\n    2.  打开控制台，切换到 Network 面板，刷新\n    3.  点击 dynamic_new 请求，找到 Cookie\n    4.  视频和专栏，UP 主粉丝及关注只要求 `SESSDATA` 字段，动态需复制整段 Cookie"
            }
          ],
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "用户关注视频动态",
        "maintainers": [
          "LogicJake"
        ],
        "description": "::: warning\n  用户动态需要 b 站登录后的 Cookie 值，所以只能自建，详情见部署页面的配置模块。\n:::",
        "location": "followings-video.ts",
        "module": () => import('@/routes/bilibili/followings-video.ts')
      },
      "/user/followings/:uid/:loginUid": {
        "path": "/user/followings/:uid/:loginUid",
        "categories": [
          "social-media"
        ],
        "example": "/bilibili/user/followings/2267573/3",
        "parameters": {
          "uid": "用户 id, 可在 UP 主主页中找到",
          "loginUid": "用于登入的用户id,需要配置对应的 Cookie 值"
        },
        "features": {
          "requireConfig": [
            {
              "name": "BILIBILI_COOKIE_*",
              "description": "BILIBILI_COOKIE_{uid}: 用于用户关注动态系列路由，对应 uid 的 b 站用户登录后的 Cookie 值，`{uid}` 替换为 uid，如 `BILIBILI_COOKIE_2267573`，获取方式：\n    1.  打开 [https://api.vc.bilibili.com/dynamic_svr/v1/dynamic_svr/dynamic_new?uid=0&type=8](https://api.vc.bilibili.com/dynamic_svr/v1/dynamic_svr/dynamic_new?uid=0&type=8)\n    2.  打开控制台，切换到 Network 面板，刷新\n    3.  点击 dynamic_new 请求，找到 Cookie\n    4.  视频和专栏，UP 主粉丝及关注只要求 `SESSDATA` 字段，动态需复制整段 Cookie"
            }
          ],
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "space.bilibili.com/:uid"
            ],
            "target": "/user/followings/:uid"
          }
        ],
        "name": "UP 主关注用户",
        "maintainers": [
          "Qixingchen"
        ],
        "description": "::: warning\n  UP 主关注用户现在需要 b 站登录后的 Cookie 值，所以只能自建，详情见部署页面的配置模块。\n:::",
        "location": "followings.ts",
        "module": () => import('@/routes/bilibili/followings.ts')
      },
      "/hot-search": {
        "path": "/hot-search",
        "categories": [
          "social-media"
        ],
        "example": "/bilibili/hot-search",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.bilibili.com/",
              "m.bilibili.com/"
            ]
          }
        ],
        "name": "热搜",
        "maintainers": [
          "CaoMeiYouRen"
        ],
        "url": "www.bilibili.com/",
        "location": "hot-search.ts",
        "module": () => import('@/routes/bilibili/hot-search.ts')
      },
      "/user/like/:uid/:embed?": {
        "path": "/user/like/:uid/:embed?",
        "categories": [
          "social-media"
        ],
        "example": "/bilibili/user/like/208259",
        "parameters": {
          "uid": "用户 id, 可在 UP 主主页中找到",
          "embed": "默认为开启内嵌视频, 任意值为关闭"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "space.bilibili.com/:uid"
            ],
            "target": "/user/like/:uid"
          }
        ],
        "name": "UP 主点赞视频",
        "maintainers": [
          "ygguorun"
        ],
        "location": "like.ts",
        "module": () => import('@/routes/bilibili/like.ts')
      },
      "/link/news/:product": {
        "path": "/link/news/:product",
        "categories": [
          "social-media"
        ],
        "example": "/bilibili/link/news/live",
        "parameters": {
          "product": "公告分类, 包括 直播:live 小视频:vc 相簿:wh"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "link 公告",
        "maintainers": [
          "Qixingchen"
        ],
        "location": "link-news.ts",
        "module": () => import('@/routes/bilibili/link-news.ts')
      },
      "/live/area/:areaID/:order": {
        "path": "/live/area/:areaID/:order",
        "categories": [
          "live"
        ],
        "example": "/bilibili/live/area/207/online",
        "parameters": {
          "areaID": "分区 ID 分区增删较多, 可通过 [分区列表](https://api.live.bilibili.com/room/v1/Area/getList) 查询",
          "order": "排序方式, live_time 开播时间, online 人气"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "直播分区",
        "maintainers": [
          "Qixingchen"
        ],
        "description": "::: warning\n  由于接口未提供开播时间，如果直播间未更换标题与分区，将视为一次。如果直播间更换分区与标题，将视为另一项\n:::",
        "location": "live-area.ts",
        "module": () => import('@/routes/bilibili/live-area.ts')
      },
      "/live/room/:roomID": {
        "path": "/live/room/:roomID",
        "categories": [
          "live"
        ],
        "example": "/bilibili/live/room/3",
        "parameters": {
          "roomID": "房间号, 可在直播间 URL 中找到, 长短号均可"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "live.bilibili.com/:roomID"
            ]
          }
        ],
        "name": "直播开播",
        "maintainers": [
          "Qixingchen"
        ],
        "location": "live-room.ts",
        "module": () => import('@/routes/bilibili/live-room.ts')
      },
      "/live/search/:key/:order": {
        "path": "/live/search/:key/:order",
        "categories": [
          "live"
        ],
        "example": "/bilibili/live/search/dota/online",
        "parameters": {
          "key": "搜索关键字",
          "order": "排序方式, live_time 开播时间, online 人气"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "直播搜索",
        "maintainers": [
          "Qixingchen"
        ],
        "location": "live-search.ts",
        "module": () => import('@/routes/bilibili/live-search.ts')
      },
      "/mall/ip/:id": {
        "path": "/mall/ip/:id",
        "categories": [
          "social-media"
        ],
        "example": "/bilibili/mall/ip/0_3000294",
        "parameters": {
          "id": "作品 id, 可在作品列表页 URL 中找到"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "会员购作品",
        "maintainers": [
          "DIYgod"
        ],
        "location": "mall-ip.ts",
        "module": () => import('@/routes/bilibili/mall-ip.ts')
      },
      "/mall/new/:category?": {
        "path": "/mall/new/:category?",
        "categories": [
          "social-media"
        ],
        "example": "/bilibili/mall/new/1",
        "parameters": {
          "category": "分类，默认全部，见下表"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "会员购新品上架",
        "maintainers": [
          "DIYgod"
        ],
        "description": "| 全部 | 手办 | 魔力赏 | 周边 | 游戏 |\n| ---- | ---- | ------ | ---- | ---- |\n| 0    | 1    | 7      | 3    | 6    |",
        "location": "mall-new.ts",
        "module": () => import('@/routes/bilibili/mall-new.ts')
      },
      "/manga/followings/:uid/:limits?": {
        "path": "/manga/followings/:uid/:limits?",
        "categories": [
          "social-media"
        ],
        "example": "/bilibili/manga/followings/26009",
        "parameters": {
          "uid": "用户 id",
          "limits": "抓取最近更新前多少本漫画，默认为10"
        },
        "features": {
          "requireConfig": [
            {
              "name": "BILIBILI_COOKIE_*",
              "description": "BILIBILI_COOKIE_{uid}: 用于用户关注动态系列路由，对应 uid 的 b 站用户登录后的 Cookie 值，`{uid}` 替换为 uid，如 `BILIBILI_COOKIE_2267573`，获取方式：\n    1.  打开 [https://api.vc.bilibili.com/dynamic_svr/v1/dynamic_svr/dynamic_new?uid=0&type=8](https://api.vc.bilibili.com/dynamic_svr/v1/dynamic_svr/dynamic_new?uid=0&type=8)\n    2.  打开控制台，切换到 Network 面板，刷新\n    3.  点击 dynamic_new 请求，找到 Cookie\n    4.  视频和专栏，UP 主粉丝及关注只要求 `SESSDATA` 字段，动态需复制整段 Cookie"
            }
          ],
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "用户追漫更新",
        "maintainers": [
          "yindaheng98"
        ],
        "description": "::: warning\n  用户追漫需要 b 站登录后的 Cookie 值，所以只能自建，详情见部署页面的配置模块。\n:::",
        "location": "manga-followings.ts",
        "module": () => import('@/routes/bilibili/manga-followings.ts')
      },
      "/manga/update/:comicid": {
        "path": "/manga/update/:comicid",
        "categories": [
          "social-media"
        ],
        "example": "/bilibili/manga/update/26009",
        "parameters": {
          "comicid": "漫画 id, 可在 URL 中找到, 支持带有`mc`前缀"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "manga.bilibili.com/detail/:comicid"
            ]
          }
        ],
        "name": "漫画更新",
        "maintainers": [
          "hoilc"
        ],
        "location": "manga-update.ts",
        "module": () => import('@/routes/bilibili/manga-update.ts')
      },
      "/message/at/:uid": {
        "path": "/message/at/:uid",
        "categories": [
          "social-media"
        ],
        "example": "/bilibili/message/at/2267573",
        "parameters": {
          "uid": "用户 id"
        },
        "features": {
          "requireConfig": [
            {
              "name": "BILIBILI_COOKIE_*",
              "description": "BILIBILI_COOKIE_{uid}: 用于用户关注动态系列路由，对应 uid 的 b 站用户登录后的 Cookie 值，`{uid}` 替换为 uid，如 `BILIBILI_COOKIE_2267573`，获取方式：\n    1.  打开 [https://api.vc.bilibili.com/dynamic_svr/v1/dynamic_svr/dynamic_new?uid=0&type=8](https://api.vc.bilibili.com/dynamic_svr/v1/dynamic_svr/dynamic_new?uid=0&type=8)\n    2.  打开控制台，切换到 Network 面板，刷新\n    3.  点击 dynamic_new 请求，找到 Cookie\n    4.  视频和专栏，UP 主粉丝及关注只要求 `SESSDATA` 字段，动态需复制整段 Cookie"
            }
          ],
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "@我的",
        "maintainers": [
          "pilgrimlyieu"
        ],
        "description": ":::warning\n  用户消息需要 b 站登录后的 Cookie 值，所以只能自建，详情见部署页面的配置模块。\n:::",
        "location": "message-at.ts",
        "module": () => import('@/routes/bilibili/message-at.ts')
      },
      "/message/like/:uid": {
        "path": "/message/like/:uid",
        "categories": [
          "social-media"
        ],
        "example": "/bilibili/message/like/2267573",
        "parameters": {
          "uid": "用户 id"
        },
        "features": {
          "requireConfig": [
            {
              "name": "BILIBILI_COOKIE_*",
              "description": "BILIBILI_COOKIE_{uid}: 用于用户关注动态系列路由，对应 uid 的 b 站用户登录后的 Cookie 值，`{uid}` 替换为 uid，如 `BILIBILI_COOKIE_2267573`，获取方式：\n    1.  打开 [https://api.vc.bilibili.com/dynamic_svr/v1/dynamic_svr/dynamic_new?uid=0&type=8](https://api.vc.bilibili.com/dynamic_svr/v1/dynamic_svr/dynamic_new?uid=0&type=8)\n    2.  打开控制台，切换到 Network 面板，刷新\n    3.  点击 dynamic_new 请求，找到 Cookie\n    4.  视频和专栏，UP 主粉丝及关注只要求 `SESSDATA` 字段，动态需复制整段 Cookie"
            }
          ],
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "收到的赞",
        "maintainers": [
          "pilgrimlyieu"
        ],
        "description": ":::warning\n  用户消息需要 b 站登录后的 Cookie 值，所以只能自建，详情见部署页面的配置模块。\n:::",
        "location": "message-like.ts",
        "module": () => import('@/routes/bilibili/message-like.ts')
      },
      "/message/reply/:uid": {
        "path": "/message/reply/:uid",
        "categories": [
          "social-media"
        ],
        "example": "/bilibili/message/reply/2267573",
        "parameters": {
          "uid": "用户 id"
        },
        "features": {
          "requireConfig": [
            {
              "name": "BILIBILI_COOKIE_*",
              "description": "BILIBILI_COOKIE_{uid}: 用于用户关注动态系列路由，对应 uid 的 b 站用户登录后的 Cookie 值，`{uid}` 替换为 uid，如 `BILIBILI_COOKIE_2267573`，获取方式：\n    1.  打开 [https://api.vc.bilibili.com/dynamic_svr/v1/dynamic_svr/dynamic_new?uid=0&type=8](https://api.vc.bilibili.com/dynamic_svr/v1/dynamic_svr/dynamic_new?uid=0&type=8)\n    2.  打开控制台，切换到 Network 面板，刷新\n    3.  点击 dynamic_new 请求，找到 Cookie\n    4.  视频和专栏，UP 主粉丝及关注只要求 `SESSDATA` 字段，动态需复制整段 Cookie"
            }
          ],
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "回复我的",
        "maintainers": [
          "pilgrimlyieu"
        ],
        "description": ":::warning\n  用户消息需要 b 站登录后的 Cookie 值，所以只能自建，详情见部署页面的配置模块。\n:::",
        "location": "message-reply.ts",
        "module": () => import('@/routes/bilibili/message-reply.ts')
      },
      "/message/sessions/:uid": {
        "path": "/message/sessions/:uid",
        "categories": [
          "social-media"
        ],
        "example": "/bilibili/message/sessions/2267573",
        "parameters": {
          "uid": "用户 id"
        },
        "features": {
          "requireConfig": [
            {
              "name": "BILIBILI_COOKIE_*",
              "description": "BILIBILI_COOKIE_{uid}: 用于用户关注动态系列路由，对应 uid 的 b 站用户登录后的 Cookie 值，`{uid}` 替换为 uid，如 `BILIBILI_COOKIE_2267573`，获取方式：\n    1.  打开 [https://api.vc.bilibili.com/dynamic_svr/v1/dynamic_svr/dynamic_new?uid=0&type=8](https://api.vc.bilibili.com/dynamic_svr/v1/dynamic_svr/dynamic_new?uid=0&type=8)\n    2.  打开控制台，切换到 Network 面板，刷新\n    3.  点击 dynamic_new 请求，找到 Cookie\n    4.  视频和专栏，UP 主粉丝及关注只要求 `SESSDATA` 字段，动态需复制整段 Cookie"
            }
          ],
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "我的消息",
        "maintainers": [
          "pilgrimlyieu"
        ],
        "description": ":::warning\n  用户消息需要 b 站登录后的 Cookie 值，所以只能自建，详情见部署页面的配置模块。\n:::",
        "location": "message-sessions.ts",
        "module": () => import('@/routes/bilibili/message-sessions.ts')
      },
      "/message/system/:uid": {
        "path": "/message/system/:uid",
        "categories": [
          "social-media"
        ],
        "example": "/bilibili/message/system/2267573",
        "parameters": {
          "uid": "用户 id"
        },
        "features": {
          "requireConfig": [
            {
              "name": "BILIBILI_COOKIE_*",
              "description": "BILIBILI_COOKIE_{uid}: 用于用户关注动态系列路由，对应 uid 的 b 站用户登录后的 Cookie 值，`{uid}` 替换为 uid，如 `BILIBILI_COOKIE_2267573`，获取方式：\n    1.  打开 [https://api.vc.bilibili.com/dynamic_svr/v1/dynamic_svr/dynamic_new?uid=0&type=8](https://api.vc.bilibili.com/dynamic_svr/v1/dynamic_svr/dynamic_new?uid=0&type=8)\n    2.  打开控制台，切换到 Network 面板，刷新\n    3.  点击 dynamic_new 请求，找到 Cookie\n    4.  视频和专栏，UP 主粉丝及关注只要求 `SESSDATA` 字段，动态需复制整段 Cookie"
            }
          ],
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "系统通知",
        "maintainers": [
          "pilgrimlyieu"
        ],
        "description": ":::warning\n  用户消息需要 b 站登录后的 Cookie 值，所以只能自建，详情见部署页面的配置模块。\n:::",
        "location": "message-system.ts",
        "module": () => import('@/routes/bilibili/message-system.ts')
      },
      "/message/unread/:uid": {
        "path": "/message/unread/:uid",
        "categories": [
          "social-media"
        ],
        "example": "/bilibili/message/unread/2267573",
        "parameters": {
          "uid": "用户 id"
        },
        "features": {
          "requireConfig": [
            {
              "name": "BILIBILI_COOKIE_*",
              "description": "BILIBILI_COOKIE_{uid}: 用于用户关注动态系列路由，对应 uid 的 b 站用户登录后的 Cookie 值，`{uid}` 替换为 uid，如 `BILIBILI_COOKIE_2267573`，获取方式：\n    1.  打开 [https://api.vc.bilibili.com/dynamic_svr/v1/dynamic_svr/dynamic_new?uid=0&type=8](https://api.vc.bilibili.com/dynamic_svr/v1/dynamic_svr/dynamic_new?uid=0&type=8)\n    2.  打开控制台，切换到 Network 面板，刷新\n    3.  点击 dynamic_new 请求，找到 Cookie\n    4.  视频和专栏，UP 主粉丝及关注只要求 `SESSDATA` 字段，动态需复制整段 Cookie"
            }
          ],
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "未读消息",
        "maintainers": [
          "pilgrimlyieu"
        ],
        "description": ":::warning\n  用户消息需要 b 站登录后的 Cookie 值，所以只能自建，详情见部署页面的配置模块。\n\n  此路由返回所有未读消息类型的汇总状态。\n:::",
        "location": "message-unread.ts",
        "module": () => import('@/routes/bilibili/message-unread.ts')
      },
      "/video/page/:bvid/:embed?": {
        "path": "/video/page/:bvid/:embed?",
        "categories": [
          "social-media"
        ],
        "example": "/bilibili/video/page/BV1i7411M7N9",
        "parameters": {
          "bvid": "可在视频页 URL 中找到",
          "embed": "默认为开启内嵌视频, 任意值为关闭"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "视频选集列表",
        "maintainers": [
          "sxzz"
        ],
        "location": "page.ts",
        "module": () => import('@/routes/bilibili/page.ts')
      },
      "/partion/ranking/:tid/:days?/:embed?": {
        "path": "/partion/ranking/:tid/:days?/:embed?",
        "categories": [
          "social-media"
        ],
        "example": "/bilibili/partion/ranking/171/3",
        "parameters": {
          "tid": "分区 id, 见上方表格",
          "days": "缺省为 7, 指最近多少天内的热度排序",
          "embed": "默认为开启内嵌视频, 任意值为关闭"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "分区视频排行榜",
        "maintainers": [
          "lengthmin"
        ],
        "location": "partion-ranking.ts",
        "module": () => import('@/routes/bilibili/partion-ranking.ts')
      },
      "/partion/:tid/:embed?": {
        "path": "/partion/:tid/:embed?",
        "categories": [
          "social-media"
        ],
        "example": "/bilibili/partion/33",
        "parameters": {
          "tid": "分区 id",
          "embed": "默认为开启内嵌视频, 任意值为关闭"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "分区视频",
        "maintainers": [
          "DIYgod"
        ],
        "description": "动画\n\n| MAD·AMV | MMD·3D | 短片・手书・配音 | 特摄 | 综合 |\n| ------- | ------ | ---------------- | ---- | ---- |\n| 24      | 25     | 47               | 86   | 27   |\n\n  番剧\n\n| 连载动画 | 完结动画 | 资讯 | 官方延伸 |\n| -------- | -------- | ---- | -------- |\n| 33       | 32       | 51   | 152      |\n\n  国创\n\n| 国产动画 | 国产原创相关 | 布袋戏 | 动态漫・广播剧 | 资讯 |\n| -------- | ------------ | ------ | -------------- | ---- |\n| 153      | 168          | 169    | 195            | 170  |\n\n  音乐\n\n| 原创音乐 | 翻唱 | VOCALOID·UTAU | 电音 | 演奏 | MV  | 音乐现场 | 音乐综合 | ~~OP/ED/OST~~ |\n| -------- | ---- | ------------- | ---- | ---- | --- | -------- | -------- | ------------- |\n| 28       | 31   | 30            | 194  | 59   | 193 | 29       | 130      | 54            |\n\n  舞蹈\n\n| 宅舞 | 街舞 | 明星舞蹈 | 中国舞 | 舞蹈综合 | 舞蹈教程 |\n| ---- | ---- | -------- | ------ | -------- | -------- |\n| 20   | 198  | 199      | 200    | 154      | 156      |\n\n  游戏\n\n| 单机游戏 | 电子竞技 | 手机游戏 | 网络游戏 | 桌游棋牌 | GMV | 音游 | Mugen |\n| -------- | -------- | -------- | -------- | -------- | --- | ---- | ----- |\n| 17       | 171      | 172      | 65       | 173      | 121 | 136  | 19    |\n\n  知识\n\n| 科学科普 | 社科人文 | 财经 | 校园学习 | 职业职场 | 野生技术协会 |\n| -------- | -------- | ---- | -------- | -------- | ------------ |\n| 201      | 124      | 207  | 208      | 209      | 122          |\n\n  ~~科技~~\n\n| ~~演讲・公开课~~ | ~~星海~~ | ~~机械~~ | ~~汽车~~ |\n| ---------------- | -------- | -------- | -------- |\n| 39               | 96       | 98       | 176      |\n\n  数码\n\n| 手机平板 | 电脑装机 | 摄影摄像 | 影音智能 |\n| -------- | -------- | -------- | -------- |\n| 95       | 189      | 190      | 191      |\n\n  生活\n\n| 搞笑 | 日常 | 美食圈 | 动物圈 | 手工 | 绘画 | 运动 | 汽车 | 其他 | ~~ASMR~~ |\n| ---- | ---- | ------ | ------ | ---- | ---- | ---- | ---- | ---- | -------- |\n| 138  | 21   | 76     | 75     | 161  | 162  | 163  | 176  | 174  | 175      |\n\n  鬼畜\n\n| 鬼畜调教 | 音 MAD | 人力 VOCALOID | 教程演示 |\n| -------- | ------ | ------------- | -------- |\n| 22       | 26     | 126           | 127      |\n\n  时尚\n\n| 美妆 | 服饰 | 健身 | T 台 | 风向标 |\n| ---- | ---- | ---- | ---- | ------ |\n| 157  | 158  | 164  | 159  | 192    |\n\n  ~~广告~~\n\n| ~~广告~~ |\n| -------- |\n| 166      |\n\n  资讯\n\n| 热点 | 环球 | 社会 | 综合 |\n| ---- | ---- | ---- | ---- |\n| 203  | 204  | 205  | 206  |\n\n  娱乐\n\n| 综艺 | 明星 | Korea 相关 |\n| ---- | ---- | ---------- |\n| 71   | 137  | 131        |\n\n  影视\n\n| 影视杂谈 | 影视剪辑 | 短片 | 预告・资讯 |\n| -------- | -------- | ---- | ---------- |\n| 182      | 183      | 85   | 184        |\n\n  纪录片\n\n| 全部 | 人文・历史 | 科学・探索・自然 | 军事 | 社会・美食・旅行 |\n| ---- | ---------- | ---------------- | ---- | ---------------- |\n| 177  | 37         | 178              | 179  | 180              |\n\n  电影\n\n| 全部 | 华语电影 | 欧美电影 | 日本电影 | 其他国家 |\n| ---- | -------- | -------- | -------- | -------- |\n| 23   | 147      | 145      | 146      | 83       |\n\n  电视剧\n\n| 全部 | 国产剧 | 海外剧 |\n| ---- | ------ | ------ |\n| 11   | 185    | 187    |",
        "location": "partion.ts",
        "module": () => import('@/routes/bilibili/partion.ts')
      },
      "/platform/:area?/:p_type?/:uid?": {
        "path": "/platform/:area?/:p_type?/:uid?",
        "categories": [
          "social-media"
        ],
        "example": "/bilibili/platform/-1",
        "parameters": {
          "area": "省市-国标码,默认为-1即全国",
          "p_type": "类型：见下表，默认为全部类型",
          "uid": "用户id，可以不填，不过不填不设置cookie，搜索结果与登入账号后搜索结果不一样。可以在url中找到，需要配置cookie值，只需要SESSDATA的值即可"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "show.bilibili.com/platform"
            ]
          }
        ],
        "name": "会员购票务",
        "maintainers": [
          "nightmare-mio"
        ],
        "url": "show.bilibili.com/platform",
        "description": "| 类型     |\n| -------- |\n| 演出     |\n| 展览     |\n| 本地生活 |",
        "location": "platform.ts",
        "module": () => import('@/routes/bilibili/platform.ts')
      },
      "/popular/all/:embed?": {
        "path": "/popular/all/:embed?",
        "categories": [
          "social-media"
        ],
        "example": "/bilibili/popular/all",
        "parameters": {
          "embed": "默认为开启内嵌视频, 任意值为关闭"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "综合热门",
        "maintainers": [
          "ziminliu"
        ],
        "location": "popular.ts",
        "module": () => import('@/routes/bilibili/popular.ts')
      },
      "/ranking/:rid?/:embed?/:redirect1?/:redirect2?": {
        "path": "/ranking/:rid?/:embed?/:redirect1?/:redirect2?",
        "name": "排行榜",
        "maintainers": [
          "DIYgod",
          "hyoban"
        ],
        "categories": [
          "social-media"
        ],
        "view": 3,
        "example": "/bilibili/ranking/all",
        "parameters": {
          "rid": {
            "description": "排行榜分区代号或 rid，可在 URL 中找到",
            "default": "all",
            "options": [
              {
                "value": "all",
                "label": "全站"
              },
              {
                "value": "cinephile",
                "label": "影视"
              },
              {
                "value": "ent",
                "label": "娱乐"
              },
              {
                "value": "music",
                "label": "音乐"
              },
              {
                "value": "dance",
                "label": "舞蹈"
              },
              {
                "value": "douga",
                "label": "动画"
              },
              {
                "value": "kichiku",
                "label": "鬼畜"
              },
              {
                "value": "game",
                "label": "游戏"
              },
              {
                "value": "knowledge",
                "label": "知识"
              },
              {
                "value": "tech",
                "label": "科技数码"
              },
              {
                "value": "car",
                "label": "汽车"
              },
              {
                "value": "fashion",
                "label": "时尚美妆"
              },
              {
                "value": "sports",
                "label": "体育运动"
              },
              {
                "value": "food",
                "label": "美食"
              },
              {
                "value": "animal",
                "label": "动物"
              }
            ]
          },
          "embed": "默认为开启内嵌视频，任意值为关闭",
          "redirect1": "留空，用于兼容之前的路由",
          "redirect2": "留空，用于兼容之前的路由"
        },
        "radar": [
          {
            "source": [
              "www.bilibili.com/v/popular/rank/:rid"
            ],
            "target": "/ranking/:rid"
          }
        ],
        "location": "ranking.ts",
        "module": () => import('@/routes/bilibili/ranking.ts')
      },
      "/readlist/:listid": {
        "path": "/readlist/:listid",
        "categories": [
          "social-media"
        ],
        "view": 0,
        "example": "/bilibili/readlist/25611",
        "parameters": {
          "listid": "文集 id, 可在专栏文集 URL 中找到"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "专栏文集",
        "maintainers": [
          "hoilc"
        ],
        "location": "readlist.ts",
        "module": () => import('@/routes/bilibili/readlist.ts')
      },
      "/video/reply/:bvid": {
        "path": "/video/reply/:bvid",
        "categories": [
          "social-media"
        ],
        "example": "/bilibili/video/reply/BV1vA411b7ip",
        "parameters": {
          "bvid": "可在视频页 URL 中找到"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "视频评论",
        "maintainers": [
          "Qixingchen"
        ],
        "location": "reply.ts",
        "module": () => import('@/routes/bilibili/reply.ts')
      },
      "/user/bangumi/:uid/:type?": {
        "path": "/user/bangumi/:uid/:type?",
        "categories": [
          "social-media"
        ],
        "example": "/bilibili/user/bangumi/208259",
        "parameters": {
          "uid": "用户 id",
          "type": "1为番，2为剧，留空为1"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "space.bilibili.com/:uid"
            ],
            "target": "/user/bangumi/:uid"
          }
        ],
        "name": "用户追番列表",
        "maintainers": [
          "wdssmq"
        ],
        "location": "user-bangumi.ts",
        "module": () => import('@/routes/bilibili/user-bangumi.ts')
      },
      "/user/channel/:uid/:sid/:embed?": {
        "path": "/user/channel/:uid/:sid/:embed?",
        "categories": [
          "social-media"
        ],
        "example": "/bilibili/user/channel/2267573/396050",
        "parameters": {
          "uid": "用户 id, 可在 UP 主主页中找到",
          "sid": "频道 id, 可在频道的 URL 中找到",
          "embed": "默认为开启内嵌视频, 任意值为关闭"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "UP 主频道的视频列表",
        "maintainers": [
          "weirongxu"
        ],
        "location": "user-channel.ts",
        "module": () => import('@/routes/bilibili/user-channel.ts')
      },
      "/user/collection/:uid/:sid/:embed?/:sortReverse?/:page?": {
        "path": "/user/collection/:uid/:sid/:embed?/:sortReverse?/:page?",
        "categories": [
          "social-media"
        ],
        "example": "/bilibili/user/collection/245645656/529166",
        "parameters": {
          "uid": "用户 id, 可在 UP 主主页中找到",
          "sid": "合集 id, 可在合集页面的 URL 中找到",
          "embed": "默认为开启内嵌视频, 任意值为关闭",
          "sortReverse": "默认:默认排序 1:升序排序",
          "page": "页码, 默认1"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "UP 主频道的合集",
        "maintainers": [
          "shininome",
          "cscnk52"
        ],
        "location": "user-collection.ts",
        "module": () => import('@/routes/bilibili/user-collection.ts')
      },
      "/user/fav/:uid/:embed?": {
        "path": "/user/fav/:uid/:embed?",
        "categories": [
          "social-media"
        ],
        "example": "/bilibili/user/fav/2267573",
        "parameters": {
          "uid": "用户 id, 可在 UP 主主页中找到",
          "embed": "默认为开启内嵌视频, 任意值为关闭"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "space.bilibili.com/:uid",
              "space.bilibili.com/:uid/favlist"
            ],
            "target": "/user/fav/:uid"
          }
        ],
        "name": "UP 主默认收藏夹",
        "maintainers": [
          "DIYgod"
        ],
        "location": "user-fav.ts",
        "module": () => import('@/routes/bilibili/user-fav.ts')
      },
      "/user/video-all/:uid/:embed?": {
        "path": "/user/video-all/:uid/:embed?",
        "name": "用户所有视频",
        "maintainers": [],
        "example": "/bilibili/user/video-all/2267573",
        "parameters": {
          "uid": "用户 id, 可在 UP 主主页中找到",
          "embed": "默认为开启内嵌视频, 任意值为关闭"
        },
        "categories": [
          "social-media"
        ],
        "location": "video-all.ts",
        "module": () => import('@/routes/bilibili/video-all.ts')
      },
      "/user/video/:uid/:embed?": {
        "path": "/user/video/:uid/:embed?",
        "categories": [
          "social-media"
        ],
        "view": 3,
        "example": "/bilibili/user/video/2267573",
        "parameters": {
          "uid": "用户 id, 可在 UP 主主页中找到",
          "embed": "默认为开启内嵌视频, 任意值为关闭"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "space.bilibili.com/:uid"
            ],
            "target": "/user/video/:uid"
          }
        ],
        "name": "UP 主投稿",
        "maintainers": [
          "DIYgod",
          "Konano",
          "pseudoyu"
        ],
        "location": "video.ts",
        "module": () => import('@/routes/bilibili/video.ts')
      },
      "/vsearch/:kw/:order?/:embed?/:tid?": {
        "path": "/vsearch/:kw/:order?/:embed?/:tid?",
        "categories": [
          "social-media"
        ],
        "example": "/bilibili/vsearch/RSSHub",
        "parameters": {
          "kw": "检索关键字",
          "order": "排序方式, 综合:totalrank 最多点击:click 最新发布:pubdate(缺省) 最多弹幕:dm 最多收藏:stow",
          "embed": "默认为开启内嵌视频, 任意值为关闭",
          "tid": "分区 id"
        },
        "features": {
          "requireConfig": [
            {
              "name": "BILIBILI_COOKIE_*",
              "optional": true,
              "description": "如果没有此配置，那么必须开启 puppeteer 支持；BILIBILI_COOKIE_{uid}: 用于用户关注动态系列路由，对应 uid 的 b 站用户登录后的 Cookie 值，`{uid}` 替换为 uid，如 `BILIBILI_COOKIE_2267573`，获取方式：\n1.  打开 [https://api.vc.bilibili.com/dynamic_svr/v1/dynamic_svr/dynamic_new?uid=0&type=8](https://api.vc.bilibili.com/dynamic_svr/v1/dynamic_svr/dynamic_new?uid=0&type=8)\n2.  打开控制台，切换到 Network 面板，刷新\n3.  点击 dynamic_new 请求，找到 Cookie\n4.  视频和专栏，UP 主粉丝及关注只要求 `SESSDATA` 字段，动态需复制整段 Cookie"
            }
          ],
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "视频搜索",
        "maintainers": [
          "pcrtool",
          "DIYgod"
        ],
        "description": "分区 id 的取值请参考下表：\n\n| 全部分区 | 动画 | 番剧 | 国创 | 音乐 | 舞蹈 | 游戏 | 知识 | 科技 | 运动 | 汽车 | 生活 | 美食 | 动物圈 | 鬼畜 | 时尚 | 资讯 | 娱乐 | 影视 | 纪录片 | 电影 | 电视剧 |\n| -------- | ---- | ---- | ---- | ---- | ---- | ---- | ---- | ---- | ---- | ---- | ---- | ---- | ------ | ---- | ---- | ---- | ---- | ---- | ------ | ---- | ------ |\n| 0        | 1    | 13   | 167  | 3    | 129  | 4    | 36   | 188  | 234  | 223  | 160  | 211  | 217    | 119  | 155  | 202  | 5    | 181  | 177    | 23   | 11     |",
        "location": "vsearch.ts",
        "module": () => import('@/routes/bilibili/vsearch.ts')
      },
      "/watchlater/:uid/:embed?": {
        "path": "/watchlater/:uid/:embed?",
        "categories": [
          "social-media"
        ],
        "example": "/bilibili/watchlater/2267573",
        "parameters": {
          "uid": "用户 id",
          "embed": "默认为开启内嵌视频, 任意值为关闭"
        },
        "features": {
          "requireConfig": [
            {
              "name": "BILIBILI_COOKIE_*",
              "description": "BILIBILI_COOKIE_{uid}: 用于用户关注动态系列路由，对应 uid 的 b 站用户登录后的 Cookie 值，`{uid}` 替换为 uid，如 `BILIBILI_COOKIE_2267573`，获取方式：\n    1.  打开 [https://api.vc.bilibili.com/dynamic_svr/v1/dynamic_svr/dynamic_new?uid=0&type=8](https://api.vc.bilibili.com/dynamic_svr/v1/dynamic_svr/dynamic_new?uid=0&type=8)\n    2.  打开控制台，切换到 Network 面板，刷新\n    3.  点击 dynamic_new 请求，找到 Cookie\n    4.  视频和专栏，UP 主粉丝及关注只要求 `SESSDATA` 字段，动态需复制整段 Cookie"
            }
          ],
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "用户稍后再看",
        "maintainers": [
          "JimenezLi"
        ],
        "description": "::: warning\n  用户稍后再看需要 b 站登录后的 Cookie 值，所以只能自建，详情见部署页面的配置模块。\n:::",
        "location": "watchlater.ts",
        "module": () => import('@/routes/bilibili/watchlater.ts')
      },
      "/weekly/:embed?": {
        "path": "/weekly/:embed?",
        "categories": [
          "social-media"
        ],
        "example": "/bilibili/weekly",
        "parameters": {
          "embed": "默认为开启内嵌视频, 任意值为关闭"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "B 站每周必看",
        "maintainers": [
          "ttttmr"
        ],
        "location": "weekly-recommend.ts",
        "module": () => import('@/routes/bilibili/weekly-recommend.ts')
      }
    },
    "name": "哔哩哔哩 bilibili",
    "apiRoutes": {
      "/check-cookie": {
        "path": "/check-cookie",
        "description": "检查 bilibili cookie 是否有效",
        "maintainers": [
          "DIYgod"
        ],
        "location": "check-cookie.ts",
        "module": () => import('@/routes/bilibili/check-cookie.ts')
      }
    },
    "url": "www.bilibili.com",
    "lang": "zh-CN"
  },
  "binance": {
    "routes": {
      "/announcement/:type?/:lang?": {
        "path": "/announcement/:type?/:lang?",
        "categories": [
          "finance"
        ],
        "view": 0,
        "example": "/binance/announcement/new-cryptocurrency-listing",
        "radar": [
          {
            "source": [
              "www.binance.com/:lang/messages/v2/group/announcement"
            ],
            "target": "/binance/announcement/all/:lang"
          }
        ],
        "parameters": {
          "type": {
            "description": "Announcement type. Omit for all categories.",
            "default": "all",
            "options": [
              {
                "value": "all",
                "label": "All"
              },
              {
                "value": "new-cryptocurrency-listing",
                "label": "New Cryptocurrency Listing"
              },
              {
                "value": "latest-binance-news",
                "label": "Latest Binance News"
              },
              {
                "value": "latest-activities",
                "label": "Latest Activities"
              },
              {
                "value": "new-fiat-listings",
                "label": "New Fiat Listings"
              },
              {
                "value": "api-updates",
                "label": "API Updates"
              },
              {
                "value": "crypto-airdrop",
                "label": "Crypto Airdrop"
              },
              {
                "value": "wallet-maintenance-updates",
                "label": "Wallet Maintenance Updates"
              },
              {
                "value": "delisting",
                "label": "Delisting"
              }
            ]
          },
          "lang": {
            "description": "Language code for the messages page.",
            "default": "zh-CN",
            "options": [
              {
                "value": "zh-CN",
                "label": "Simplified Chinese"
              },
              {
                "value": "en",
                "label": "English"
              }
            ]
          }
        },
        "name": "Announcement",
        "description": "Announcement list from Binance message center with language and type selection.",
        "maintainers": [
          "enpitsulin",
          "DIYgod"
        ],
        "location": "announcement.ts",
        "module": () => import('@/routes/binance/announcement.ts')
      },
      "/launchpool": {
        "path": "/launchpool",
        "categories": [
          "finance"
        ],
        "example": "/binance/launchpool",
        "radar": [
          {
            "source": [
              "binance.com/:lang/support/announcement"
            ]
          }
        ],
        "name": "Binance数字货币及交易对上新",
        "maintainers": [
          "zhenlohuang"
        ],
        "location": "launchpool.ts",
        "module": () => import('@/routes/binance/launchpool.ts')
      }
    },
    "name": "Binance",
    "apiRoutes": {},
    "url": "binance.com",
    "lang": "en"
  },
  "bing": {
    "routes": {
      "/:routeParams?": {
        "path": "/:routeParams?",
        "parameters": {
          "routeParams": "额外参数type,story和lang:请参阅以下说明和表格"
        },
        "radar": [
          {
            "source": [
              "www.bing.com/"
            ],
            "target": ""
          },
          {
            "source": [
              "cn.bing.com/"
            ],
            "target": ""
          }
        ],
        "name": "每日壁纸",
        "maintainers": [
          "FHYunCai",
          "LLLLLFish"
        ],
        "url": "www.bing.com/",
        "example": "/bing/type=UHD&story=1&lang=zh-CN",
        "description": "| 参数    | 含义                 | 接受的值                                                      | 默认值       | 备注                                                     |\n|-------|--------------------|-----------------------------------------------------------|-----------|--------------------------------------------------------|\n| type  | 输出壁纸的像素类型          | UHD/1920x1080/1920x1200/768x1366/1080x1920/1080x1920_logo | 1920x1080 | 1920x1200与1080x1920_logo带有水印,输入的值不在接受范围内都会输出成1920x1080 |\n| story | 是否输出壁纸的故事          | 1/0                                                       | 0         | 输入的值不为1都不会输出故事                                         |\n| lang  | 输出壁纸图文的地区(中文或者是英文) | zh/en                                               | zh     | zh/en输出的壁纸图文不一定是一样的;如果en不生效,试着部署到其他地方               |\n",
        "location": "daily-wallpaper.ts",
        "module": () => import('@/routes/bing/daily-wallpaper.ts')
      },
      "/search/:keyword": {
        "path": "/search/:keyword",
        "categories": [
          "other"
        ],
        "example": "/bing/search/rss",
        "parameters": {
          "keyword": "搜索关键词"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "cn.bing.com/"
            ],
            "target": ""
          }
        ],
        "name": "搜索",
        "maintainers": [
          "CaoMeiYouRen"
        ],
        "url": "cn.bing.com/",
        "location": "search.ts",
        "module": () => import('@/routes/bing/search.ts')
      }
    },
    "name": "Bing",
    "apiRoutes": {},
    "url": "cn.bing.com",
    "lang": "zh-CN"
  },
  "biodiscover": {
    "routes": {
      "/:channel?": {
        "path": "/:channel?",
        "radar": [
          {
            "source": [
              "www.biodiscover.com/:channel"
            ],
            "target": "/:channel"
          }
        ],
        "name": "Unknown",
        "maintainers": [
          "aidistan"
        ],
        "location": "index.ts",
        "module": () => import('@/routes/biodiscover/index.ts')
      }
    },
    "name": "biodiscover.com 生物探索",
    "apiRoutes": {},
    "url": "www.biodiscover.com",
    "lang": "zh-CN"
  },
  "bioone": {
    "routes": {
      "/featured": {
        "path": "/featured",
        "categories": [
          "journal"
        ],
        "example": "/bioone/featured",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "bioone.org/"
            ]
          }
        ],
        "name": "Featured articles",
        "maintainers": [
          "nczitzk"
        ],
        "url": "bioone.org/",
        "location": "featured.ts",
        "module": () => import('@/routes/bioone/featured.ts')
      },
      "/journals/:journal?": {
        "path": "/journals/:journal?",
        "categories": [
          "journal"
        ],
        "example": "/bioone/journals/acta-chiropterologica",
        "parameters": {
          "journal": "Journals, can be found in URL"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "bioone.org/journals/:journal",
              "bioone.org/"
            ],
            "target": "/journals/:journal"
          }
        ],
        "name": "Journals",
        "maintainers": [
          "nczitzk"
        ],
        "location": "journal.ts",
        "module": () => import('@/routes/bioone/journal.ts')
      }
    },
    "name": "BioOne",
    "apiRoutes": {},
    "url": "bioone.org",
    "lang": "en"
  },
  "biquge": {
    "routes": {
      "*": {
        "path": "*",
        "name": "Unknown",
        "maintainers": [],
        "location": "index.ts",
        "module": () => import('@/routes/biquge/index.ts')
      }
    },
    "name": "笔趣阁",
    "apiRoutes": {},
    "url": "xbiquwx.la",
    "description": "::: tip\n此处的 **笔趣阁** 指网络上使用和 **笔趣阁** 样式相似模板的小说阅读网站，包括但不限于下方列举的网址。\n:::\n\n| 网址                                                 | 名称       |\n| ---------------------------------------------------- | ---------- |\n| [https://www.xbiquwx.la](https://www.xbiquwx.la)     | 笔尖中文   |\n| [http://www.biqu5200.net](http://www.biqu5200.net)   | 笔趣阁     |\n| [https://www.xbiquge.so](https://www.xbiquge.so)     | 笔趣阁     |\n| [https://www.biqugeu.net](https://www.biqugeu.net)   | 顶点小说网 |\n| [http://www.b520.cc](http://www.b520.cc)             | 笔趣阁     |\n| [https://www.ahfgb.com](https://www.ahfgb.com)       | 笔趣鸽     |\n| [https://www.ibiquge.la](https://www.ibiquge.la)     | 香书小说   |\n| [https://www.biquge.tv](https://www.biquge.tv)       | 笔趣阁     |\n| [https://www.bswtan.com](https://www.bswtan.com)     | 笔书网     |\n| [https://www.biquge.co](https://www.biquge.co)       | 笔趣阁     |\n| [https://www.bqzhh.com](https://www.bqzhh.com)       | 笔趣阁     |\n| [http://www.biqugse.com](http://www.biqugse.com)     | 笔趣阁     |\n| [https://www.ibiquge.info](https://www.ibiquge.info) | 爱笔楼     |\n| [https://www.ishuquge.com](https://www.ishuquge.com) | 书趣阁     |\n| [https://www.mayiwxw.com](https://www.mayiwxw.com)   | 蚂蚁文学   |",
    "lang": "zh-CN"
  },
  "bit": {
    "routes": {
      "/cs": {
        "path": "/cs",
        "categories": [
          "university"
        ],
        "example": "/bit/cs",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "cs.bit.edu.cn/tzgg",
              "cs.bit.edu.cn/"
            ]
          }
        ],
        "name": "计院通知",
        "maintainers": [
          "sinofp"
        ],
        "url": "cs.bit.edu.cn/tzgg",
        "location": "cs/cs.ts",
        "module": () => import('@/routes/bit/cs/cs.ts')
      },
      "/jwc": {
        "path": "/jwc",
        "categories": [
          "university"
        ],
        "example": "/bit/jwc",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "jwc.bit.edu.cn/tzgg",
              "jwc.bit.edu.cn/"
            ]
          }
        ],
        "name": "教务处通知",
        "maintainers": [
          "sinofp"
        ],
        "url": "jwc.bit.edu.cn/tzgg",
        "location": "jwc/jwc.ts",
        "module": () => import('@/routes/bit/jwc/jwc.ts')
      },
      "/rszhaopin": {
        "path": "/rszhaopin",
        "categories": [
          "university"
        ],
        "example": "/bit/rszhaopin",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "rszhaopin.bit.edu.cn/"
            ]
          }
        ],
        "name": "人才招聘",
        "maintainers": [
          "nczitzk"
        ],
        "url": "rszhaopin.bit.edu.cn/",
        "location": "rszhaopin.ts",
        "module": () => import('@/routes/bit/rszhaopin.ts')
      },
      "/yjs": {
        "path": "/yjs",
        "categories": [
          "university"
        ],
        "example": "/bit/yjs",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "grd.bit.edu.cn/zsgz/zsxx/index.htm",
              "grd.bit.edu.cn/"
            ]
          }
        ],
        "name": "研究生院招生信息",
        "maintainers": [
          "shengmaosu"
        ],
        "url": "grd.bit.edu.cn/zsgz/zsxx/index.htm",
        "location": "yjs.ts",
        "module": () => import('@/routes/bit/yjs.ts')
      }
    },
    "name": "北京理工大学",
    "apiRoutes": {},
    "url": "cs.bit.edu.cn",
    "lang": "zh-CN"
  },
  "bitbucket": {
    "routes": {
      "/commits/:workspace/:repo_slug": {
        "path": "/commits/:workspace/:repo_slug",
        "categories": [
          "programming"
        ],
        "example": "/bitbucket/commits/blaze-lib/blaze",
        "parameters": {
          "workspace": "Workspace",
          "repo_slug": "Repository"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "bitbucket.com/commits/:workspace/:repo_slug"
            ]
          }
        ],
        "name": "Commits",
        "maintainers": [
          "AuroraDysis"
        ],
        "location": "commits.ts",
        "module": () => import('@/routes/bitbucket/commits.ts')
      },
      "/tags/:workspace/:repo_slug": {
        "path": "/tags/:workspace/:repo_slug",
        "categories": [
          "programming"
        ],
        "example": "/bitbucket/tags/blaze-lib/blaze",
        "parameters": {
          "workspace": "Workspace",
          "repo_slug": "Repository"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "Tags",
        "maintainers": [
          "AuroraDysis"
        ],
        "location": "tags.ts",
        "module": () => import('@/routes/bitbucket/tags.ts')
      }
    },
    "name": "Bitbucket",
    "apiRoutes": {},
    "url": "bitbucket.com",
    "lang": "en"
  },
  "bitget": {
    "routes": {
      "/announcement/:type/:lang?": {
        "path": "/announcement/:type/:lang?",
        "categories": [
          "finance"
        ],
        "view": 0,
        "example": "/bitget/announcement/all/zh-CN",
        "parameters": {
          "type": {
            "description": "Bitget 通知类型",
            "default": "all",
            "options": [
              {
                "value": "all",
                "label": "全部通知"
              },
              {
                "value": "new-listing",
                "label": "新币上线"
              },
              {
                "value": "latest-activities",
                "label": "最新活动"
              },
              {
                "value": "new-announcement",
                "label": "最新公告"
              }
            ]
          },
          "lang": {
            "description": "语言",
            "default": "zh-CN",
            "options": [
              {
                "value": "zh-CN",
                "label": "中文"
              },
              {
                "value": "en-US",
                "label": "English"
              },
              {
                "value": "es-ES",
                "label": "Español"
              },
              {
                "value": "fr-FR",
                "label": "Français"
              },
              {
                "value": "de-DE",
                "label": "Deutsch"
              },
              {
                "value": "ja-JP",
                "label": "日本語"
              },
              {
                "value": "ru-RU",
                "label": "Русский"
              },
              {
                "value": "ar-SA",
                "label": "العربية"
              }
            ]
          }
        },
        "radar": [
          {
            "source": [
              "www.bitget.com/:lang/inmail"
            ],
            "target": "/announcement/all/:lang"
          }
        ],
        "name": "Announcement",
        "description": "\ntype:\n| Type | Description |\n| --- | --- |\n| all | 全部通知 |\n| new-listing | 新币上线 |\n| latest-activities | 最新活动 |\n| new-announcement | 最新公告 |\n\nlang:\n| Lang | Description |\n| ---   | ---   |\n| zh-CN | 中文 |\n| en-US | English |\n| es-ES | Español |\n| fr-FR | Français |\n| de-DE | Deutsch |\n| ja-JP | 日本語 |\n| ru-RU | Русский |\n| ar-SA | العربية |\n",
        "maintainers": [
          "YukiCoco"
        ],
        "location": "announcement.ts",
        "module": () => import('@/routes/bitget/announcement.ts')
      }
    },
    "name": "Bitget",
    "apiRoutes": {},
    "url": "bitget.com",
    "lang": "zh-CN"
  },
  "bitmovin": {
    "routes": {
      "/blog": {
        "path": "/blog",
        "categories": [
          "programming"
        ],
        "example": "/bitmovin/blog",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "bitmovin.com/blog",
              "bitmovin.com/"
            ]
          }
        ],
        "name": "Blog",
        "maintainers": [
          "elxy"
        ],
        "url": "bitmovin.com/blog",
        "location": "blog.ts",
        "module": () => import('@/routes/bitmovin/blog.ts')
      }
    },
    "name": "Bitmovin",
    "apiRoutes": {},
    "url": "bitmovin.com",
    "lang": "en"
  },
  "bjfu": {
    "routes": {
      "/grs": {
        "path": "/grs",
        "categories": [
          "university"
        ],
        "example": "/bjfu/grs",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "graduate.bjfu.edu.cn/"
            ]
          }
        ],
        "name": "研究生院培养动态",
        "maintainers": [
          "markmingjie"
        ],
        "url": "graduate.bjfu.edu.cn/",
        "location": "grs.ts",
        "module": () => import('@/routes/bjfu/grs.ts')
      },
      "/it/:type": {
        "path": "/it/:type",
        "categories": [
          "university"
        ],
        "example": "/bjfu/it/xyxw",
        "parameters": {
          "type": "通知类别"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "it.bjfu.edu.cn/:type/index.html"
            ]
          }
        ],
        "name": "信息学院通知",
        "maintainers": [
          "wzc-blog"
        ],
        "description": "| 学院新闻 | 科研动态 | 本科生培养 | 研究生培养 |\n| -------- | -------- | ---------- | ---------- |\n| xyxw     | kydt     | pydt       | pydt2      |",
        "location": "it/index.ts",
        "module": () => import('@/routes/bjfu/it/index.ts')
      },
      "/jwc/:type": {
        "path": "/jwc/:type",
        "categories": [
          "university"
        ],
        "example": "/bjfu/jwc/jwkx",
        "parameters": {
          "type": "通知类别"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "jwc.bjfu.edu.cn/:type/index.html"
            ]
          }
        ],
        "name": "教务处通知公告",
        "maintainers": [
          "markmingjie"
        ],
        "description": "| 教务快讯 | 考试信息 | 课程信息 | 教改动态 | 图片新闻 |\n| -------- | -------- | -------- | -------- | -------- |\n| jwkx     | ksxx     | kcxx     | jgdt     | tpxw     |",
        "location": "jwc/index.ts",
        "module": () => import('@/routes/bjfu/jwc/index.ts')
      },
      "/kjc": {
        "path": "/kjc",
        "categories": [
          "university"
        ],
        "example": "/bjfu/kjc",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "kyc.bjfu.edu.cn/"
            ]
          }
        ],
        "name": "科技处通知公告",
        "maintainers": [
          "markmingjie"
        ],
        "url": "kyc.bjfu.edu.cn/",
        "location": "kjc.ts",
        "module": () => import('@/routes/bjfu/kjc.ts')
      },
      "/news/:type": {
        "path": "/news/:type",
        "categories": [
          "university"
        ],
        "example": "/bjfu/news/lsyw",
        "parameters": {
          "type": "新闻栏目"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "news.bjfu.edu.cn/:type/index.html"
            ]
          }
        ],
        "name": "绿色新闻网",
        "maintainers": [
          "markmingjie"
        ],
        "description": "| 绿色要闻 | 校园动态 | 教学科研 | 党建思政 | 一周排行 |\n| -------- | -------- | -------- | -------- | -------- |\n| lsyw     | xydt     | jxky     | djsz     | yzph     |",
        "location": "news/index.ts",
        "module": () => import('@/routes/bjfu/news/index.ts')
      }
    },
    "name": "北京林业大学",
    "apiRoutes": {},
    "url": "graduate.bjfu.edu.cn",
    "lang": "zh-CN"
  },
  "bjnews": {
    "routes": {
      "/cat/:cat": {
        "path": "/cat/:cat",
        "categories": [
          "traditional-media"
        ],
        "example": "/bjnews/cat/depth",
        "parameters": {
          "cat": "分类, 可从URL中找到"
        },
        "features": {},
        "radar": [
          {
            "source": [
              "www.bjnews.com.cn/:cat"
            ]
          }
        ],
        "name": "分类",
        "maintainers": [
          "dzx-dzx"
        ],
        "url": "www.bjnews.com.cn",
        "location": "cat.ts",
        "module": () => import('@/routes/bjnews/cat.ts')
      },
      "/column/:column": {
        "path": "/column/:column",
        "categories": [
          "traditional-media"
        ],
        "example": "/bjnews/column/204",
        "parameters": {
          "column": "栏目ID, 可从手机版网页URL中找到"
        },
        "features": {},
        "radar": [
          {
            "source": [
              "m.bjnews.com.cn/column/:column.htm"
            ]
          }
        ],
        "name": "分类",
        "maintainers": [
          "dzx-dzx"
        ],
        "url": "www.bjnews.com.cn",
        "location": "column.ts",
        "module": () => import('@/routes/bjnews/column.ts')
      }
    },
    "name": "新京报",
    "apiRoutes": {},
    "url": "www.bjnews.com.cn",
    "lang": "zh-CN"
  },
  "bjp": {
    "routes": {
      "/apod": {
        "path": "/apod",
        "categories": [
          "picture"
        ],
        "view": 2,
        "example": "/bjp/apod",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "bjp.org.cn/APOD/today.shtml",
              "bjp.org.cn/APOD/list.shtml",
              "bjp.org.cn/"
            ]
          }
        ],
        "name": "每日一图",
        "maintainers": [
          "HenryQW"
        ],
        "url": "bjp.org.cn/APOD/today.shtml",
        "location": "apod.ts",
        "module": () => import('@/routes/bjp/apod.ts')
      }
    },
    "name": "北京天文馆",
    "apiRoutes": {},
    "url": "www.bjp.org.cn",
    "lang": "zh-CN"
  },
  "bjsk": {
    "routes": {
      "/:path?": {
        "path": "/:path?",
        "categories": [
          "government"
        ],
        "example": "/bjsk/newslist-1394-1474-0",
        "parameters": {
          "path": "路径，默认为 `newslist-1486-0-0`"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "通用",
        "maintainers": [
          "TonyRL"
        ],
        "description": "::: tip\n  路径处填写对应页面 URL 中 `https://www.bjsk.org.cn/` 和 `.html` 之间的字段。下面是一个例子。\n\n  若订阅 [社科资讯 > 社科要闻](https://www.bjsk.org.cn/newslist-1394-1474-0.html) 则将对应页面 URL `https://www.bjsk.org.cn/newslist-1394-1474-0.html` 中 `https://www.bjsk.org.cn/` 和 `.html` 之间的字段 `newslist-1394-1474-0` 作为路径填入。此时路由为 [`/bjsk/newslist-1394-1474-0`](https://rsshub.app/bjsk/newslist-1394-1474-0)\n:::",
        "location": "index.ts",
        "module": () => import('@/routes/bjsk/index.ts')
      },
      "/keti/:id?": {
        "path": "/keti/:id?",
        "categories": [
          "government"
        ],
        "example": "/bjsk/keti",
        "parameters": {
          "id": "分类 id，见下表，默认为通知公告"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "keti.bjsk.org.cn/indexAction!to_index.action",
              "keti.bjsk.org.cn/"
            ],
            "target": "/keti/:id"
          }
        ],
        "name": "基金项目管理平台",
        "maintainers": [
          "nczitzk"
        ],
        "url": "keti.bjsk.org.cn/indexAction!to_index.action",
        "description": "| 通知公告                         | 资料下载                         |\n| -------------------------------- | -------------------------------- |\n| 402881027cbb8c6f017cbb8e17710002 | 2c908aee818e04f401818e08645c0002 |",
        "location": "keti.ts",
        "module": () => import('@/routes/bjsk/keti.ts')
      }
    },
    "name": "北京社科网",
    "apiRoutes": {},
    "url": "bjsk.org.cn",
    "lang": "zh-CN"
  },
  "bjtu": {
    "routes": {
      "/gs/:type?": {
        "path": "/gs/:type?",
        "categories": [
          "university"
        ],
        "example": "/bjtu/gs/noti",
        "parameters": {
          "type": "Article type"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "gs.bjtu.edu.cn"
            ]
          }
        ],
        "name": "研究生院",
        "maintainers": [
          "E1nzbern"
        ],
        "description": "\n| 文章来源           | 参数         |\n| ----------------- | ------------ |\n| 通知公告_招生      | noti_zs      |\n| 通知公告           | noti         |\n| 新闻动态           | news         |\n| 招生宣传           | zsxc         |\n| 培养               | py           |\n| 招生               | zs           |\n| 学位               | xw           |\n| 研工部             | ygb          |\n| 通知公告 - 研工部   | ygbtzgg      |\n| 新闻动态 - 研工部   | ygbnews      |\n| 新闻封面 - 研工部   | ygbnewscover |\n| 文章列表           | all          |\n| 博士招生 - 招生专题 | bszs_zszt    |\n| 硕士招生 - 招生专题 | sszs_zszt    |\n| 招生简章 - 招生专题 | zsjz_zszt    |\n| 政策法规 - 招生专题 | zcfg_zszt    |\n\n::: tip\n  文章来源的命名均来自研究生院网站标题。\n  最常用的几项有“通知公告_招生”、“通知公告”、“博士招生 - 招生专题”、“硕士招生 - 招生专题”。\n:::",
        "location": "gs.ts",
        "module": () => import('@/routes/bjtu/gs.ts')
      }
    },
    "name": "Beijing Jiaotong University",
    "apiRoutes": {},
    "url": "bjtu.edu.cn",
    "zh": {
      "name": "北京交通大学"
    },
    "lang": "zh-CN"
  },
  "bjwxdxh": {
    "routes": {
      "/:type?": {
        "path": "/:type?",
        "categories": [
          "government"
        ],
        "example": "/bjwxdxh/114",
        "parameters": {
          "type": "类型，见下表，默认为全部"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "最新资讯",
        "maintainers": [
          "Misaka13514"
        ],
        "description": "| 协会活动 | 公告通知 | 会议情况 | 简报 | 政策法规 | 学习园地 | 业余无线电服务中心 | 经验交流 | 新技术推介 | 活动通知 | 爱好者园地 | 结果查询 | 资料下载 | 会员之家 | 会员简介 | 会员风采 | 活动报道 |\n| -------- | -------- | -------- | ---- | -------- | -------- | ------------------ | -------- | ---------- | -------- | ---------- | -------- | -------- | -------- | -------- | -------- | -------- |\n| 86       | 99       | 102      | 103  | 106      | 107      | 108                | 111      | 112        | 114      | 115        | 116      | 118      | 119      | 120      | 121      | 122      |",
        "location": "index.ts",
        "module": () => import('@/routes/bjwxdxh/index.ts')
      }
    },
    "name": "北京无线电协会",
    "apiRoutes": {},
    "url": "www.bjwxdxh.org.cn",
    "lang": "zh-CN"
  },
  "bjx": {
    "routes": {
      "/fd/:type": {
        "path": "/fd/:type",
        "categories": [
          "traditional-media"
        ],
        "example": "/bjx/fd/yw",
        "parameters": {
          "type": "文章分类，详见下表"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "风电",
        "maintainers": [
          "hualiong"
        ],
        "description": "`:type` 类型可选如下\n\n| 要闻 | 政策 | 数据 | 市场 | 企业 | 招标 | 技术 | 报道 |\n| ---- | ---- | ---- | ---- | ---- | ---- | ---- | ---- |\n| yw   | zc   | sj   | sc   | mq   | zb   | js   | bd   |",
        "location": "fd.ts",
        "module": () => import('@/routes/bjx/fd.ts')
      },
      "/huanbao": {
        "path": "/huanbao",
        "categories": [
          "traditional-media"
        ],
        "example": "/bjx/huanbao",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "huanbao.bjx.com.cn/yw",
              "huanbao.bjx.com.cn/"
            ]
          }
        ],
        "name": "环保要闻",
        "maintainers": [
          "zsimple"
        ],
        "url": "huanbao.bjx.com.cn/yw",
        "location": "huanbao.ts",
        "module": () => import('@/routes/bjx/huanbao.ts')
      },
      "/gf/:type": {
        "path": "/gf/:type",
        "categories": [
          "traditional-media"
        ],
        "example": "/bjx/gf/sc",
        "parameters": {
          "type": "分类，北极星光伏最后的`type`字段"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "光伏",
        "maintainers": [
          "Sxuet"
        ],
        "description": "`:type` 类型可选如下\n\n| 要闻 | 政策 | 市场行情 | 企业动态 | 独家观点 | 项目工程 | 招标采购 | 财经 | 国际行情 | 价格趋势 | 技术跟踪 |\n| ---- | ---- | -------- | -------- | -------- | -------- | -------- | ---- | -------- | -------- | -------- |\n| yw   | zc   | sc       | mq       | dj       | xm       | zb       | cj   | gj       | sj       | js       |",
        "location": "types.ts",
        "module": () => import('@/routes/bjx/types.ts')
      }
    },
    "name": "北极星电力网",
    "apiRoutes": {},
    "url": "www.bjx.com.cn",
    "lang": "zh-CN"
  },
  "blizzard": {
    "routes": {
      "/news-cn/:category?": {
        "path": "/news-cn/:category?",
        "categories": [
          "game"
        ],
        "example": "/blizzard/news-cn/ow",
        "parameters": {
          "category": "游戏类别, 默认为 ow"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "ow.blizzard.cn",
              "wow.blizzard.cn",
              "hs.blizzard.cn"
            ],
            "target": "/news-cn/"
          }
        ],
        "name": "暴雪游戏国服新闻",
        "maintainers": [
          "zhangpeng2k"
        ],
        "description": "\n| 守望先锋 | 炉石传说 | 魔兽世界 |\n|----------|----------|---------|\n| ow       | hs       | wow     |\n",
        "location": "news-cn.ts",
        "module": () => import('@/routes/blizzard/news-cn.ts')
      },
      "/news/:language?/:category?": {
        "path": "/news/:language?/:category?",
        "categories": [
          "game"
        ],
        "example": "/blizzard/news",
        "parameters": {
          "language": "Language code, see below, en-US by default",
          "category": "Category, see below, All News by default"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "News",
        "maintainers": [
          "nczitzk"
        ],
        "description": "Categories\n\n| Category               | Slug                |\n| ---------------------- | ------------------- |\n| All News               |                     |\n| Diablo II: Resurrected | diablo2             |\n| Diablo III             | diablo3             |\n| Diablo IV              | diablo4             |\n| Diablo Immortal        | diablo-immortal     |\n| Hearthstone            | hearthstone         |\n| Heroes of the Storm    | heroes-of-the-storm |\n| Overwatch 2            | overwatch           |\n| StarCraft: Remastered  | starcraft           |\n| StarCraft II           | starcraft2          |\n| World of Warcraft      | world-of-warcraft   |\n| Warcraft 3: Reforged   | warcraft3           |\n| Warcraft Rumble        | warcraft-rumble     |\n| Battle.net             | battlenet           |\n| BlizzCon               | blizzcon            |\n| Inside Blizzard        | blizzard            |\n\n  Language codes\n\n| Language           | Code  |\n| ------------------ | ----- |\n| Deutsch            | de-de |\n| English (US)       | en-us |\n| English (EU)       | en-gb |\n| Español (EU)       | es-es |\n| Español (Latino)   | es-mx |\n| Français           | fr-fr |\n| Italiano           | it-it |\n| Português (Brasil) | pt-br |\n| Polski             | pl-pl |\n| Русский            | ru-ru |\n| 한국어             | ko-kr |\n| ภาษาไทย            | th-th |\n| 日本語             | ja-jp |\n| 繁體中文           | zh-tw |",
        "location": "news.ts",
        "module": () => import('@/routes/blizzard/news.ts')
      }
    },
    "name": "Blizzard",
    "url": "news.blizzard.com",
    "lang": "en"
  },
  "blockworks": {
    "routes": {
      "/": {
        "path": "/",
        "categories": [
          "finance"
        ],
        "example": "/blockworks",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "blockworks.co/"
            ],
            "target": "/"
          }
        ],
        "name": "News",
        "maintainers": [
          "pseudoyu"
        ],
        "description": "Blockworks news with full text support.",
        "location": "index.ts",
        "module": () => import('@/routes/blockworks/index.ts')
      }
    },
    "name": "Blockworks",
    "apiRoutes": {},
    "url": "blockworks.co",
    "lang": "en"
  },
  "blogread": {
    "routes": {
      "/newest": {
        "path": "/newest",
        "categories": [
          "programming"
        ],
        "example": "/blogread/newest",
        "radar": [
          {
            "source": [
              "blogread.cn/news/newest.php"
            ]
          }
        ],
        "name": "最新文章",
        "maintainers": [
          "fashioncj"
        ],
        "location": "index.ts",
        "module": () => import('@/routes/blogread/index.ts')
      }
    },
    "name": "技术头条",
    "apiRoutes": {},
    "url": "blogread.cn",
    "lang": "zh-CN"
  },
  "bloomberg": {
    "routes": {
      "/authors/:id/:slug/:source?": {
        "path": "/authors/:id/:slug/:source?",
        "categories": [
          "finance"
        ],
        "view": 0,
        "example": "/bloomberg/authors/ARbTQlRLRjE/matthew-s-levine",
        "parameters": {
          "id": "Author ID, can be found in URL",
          "slug": "Author Slug, can be found in URL",
          "source": "Data source, either `api` or `rss`,`api` by default"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.bloomberg.com/*/authors/:id/:slug",
              "www.bloomberg.com/authors/:id/:slug"
            ],
            "target": "/authors/:id/:slug"
          }
        ],
        "name": "Authors",
        "maintainers": [
          "josh",
          "pseudoyu"
        ],
        "location": "authors.ts",
        "module": () => import('@/routes/bloomberg/authors.ts')
      },
      "/:site?": {
        "path": "/:site?",
        "categories": [
          "finance"
        ],
        "view": 0,
        "example": "/bloomberg/bbiz",
        "parameters": {
          "site": {
            "description": "Site ID, can be found below",
            "options": [
              {
                "value": "/",
                "label": "News"
              },
              {
                "value": "bpol",
                "label": "Politics"
              },
              {
                "value": "bbiz",
                "label": "Business"
              },
              {
                "value": "markets",
                "label": "Markets"
              },
              {
                "value": "technology",
                "label": "Technology"
              },
              {
                "value": "green",
                "label": "Green"
              },
              {
                "value": "wealth",
                "label": "Wealth"
              },
              {
                "value": "pursuits",
                "label": "Pursuits"
              },
              {
                "value": "bview",
                "label": "Opinion"
              },
              {
                "value": "equality",
                "label": "Equality"
              },
              {
                "value": "businessweek",
                "label": "Businessweek"
              },
              {
                "value": "citylab",
                "label": "CityLab"
              }
            ]
          }
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "Bloomberg Site",
        "maintainers": [
          "bigfei"
        ],
        "description": "\n| Site ID      | Title        |\n| ------------ | ------------ |\n| /            | News         |\n| bpol         | Politics     |\n| bbiz         | Business     |\n| markets      | Markets      |\n| technology   | Technology   |\n| green        | Green        |\n| wealth       | Wealth       |\n| pursuits     | Pursuits     |\n| bview        | Opinion      |\n| equality     | Equality     |\n| businessweek | Businessweek |\n| citylab      | CityLab      |\n  ",
        "location": "index.ts",
        "module": () => import('@/routes/bloomberg/index.ts')
      }
    },
    "name": "Bloomberg",
    "apiRoutes": {},
    "url": "www.bloomberg.com",
    "lang": "en"
  },
  "bluearchive": {
    "routes": {
      "/news/:server/:type?": {
        "path": "/news/:server/:type?",
        "name": "News",
        "categories": [
          "game"
        ],
        "maintainers": [
          "equt"
        ],
        "example": "/bluearchive/news/jp",
        "parameters": {
          "server": "game server (ISO 3166 two-letter country code, case-insensitive), only `JP` is supported for now",
          "type": "news type, checkout the table below for details"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "description": "| 全て | イベント | お知らせ | メンテナンス |\n| :--: | :--: | :--: | :--: |\n| 0 | 1 | 2 | 3 |",
        "location": "news.ts",
        "module": () => import('@/routes/bluearchive/news.ts')
      }
    },
    "name": "Blue Archive",
    "url": "bluearchive.jp",
    "categories": [
      "game"
    ],
    "lang": "ja"
  },
  "bluestacks": {
    "routes": {
      "/release/5": {
        "path": "/release/5",
        "categories": [
          "program-update"
        ],
        "example": "/bluestacks/release/5",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": true,
          "antiCrawler": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "bluestacks.com/hc/en-us/articles/360056960211-Release-Notes-BlueStacks-5",
              "bluestacks.com/"
            ]
          }
        ],
        "name": "BlueStacks 5 Release Notes",
        "maintainers": [
          "TonyRL"
        ],
        "url": "bluestacks.com/hc/en-us/articles/360056960211-Release-Notes-BlueStacks-5",
        "location": "release.ts",
        "module": () => import('@/routes/bluestacks/release.ts')
      }
    },
    "name": "BlueStacks",
    "url": "bluestacks.com",
    "lang": "en"
  },
  "bmkg": {
    "routes": {
      "/earthquake": {
        "path": "/earthquake",
        "categories": [
          "forecast"
        ],
        "example": "/bmkg/earthquake",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "bmkg.go.id/",
              "bmkg.go.id/gempabumi-terkini.html"
            ]
          }
        ],
        "name": "Recent Earthquakes",
        "maintainers": [
          "Shinanory"
        ],
        "url": "bmkg.go.id/",
        "location": "earthquake.ts",
        "module": () => import('@/routes/bmkg/earthquake.ts')
      },
      "/news": {
        "path": "/news",
        "categories": [
          "forecast"
        ],
        "example": "/bmkg/news",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "bmkg.go.id/",
              "bmkg.go.id/berita"
            ]
          }
        ],
        "name": "News",
        "maintainers": [
          "Shinanory"
        ],
        "url": "bmkg.go.id/",
        "location": "news.ts",
        "module": () => import('@/routes/bmkg/news.ts')
      }
    },
    "name": "BADAN METEOROLOGI, KLIMATOLOGI, DAN GEOFISIKA(Indonesian)",
    "apiRoutes": {},
    "url": "bmkg.go.id",
    "lang": "en"
  },
  "bnext": {
    "routes": {
      "/": {
        "path": "/",
        "categories": [
          "traditional-media"
        ],
        "example": "/bnext",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.bnext.com.tw"
            ],
            "target": "/bnext"
          }
        ],
        "name": "最新文章",
        "maintainers": [
          "johan456789"
        ],
        "url": "www.bnext.com.tw",
        "location": "index.ts",
        "module": () => import('@/routes/bnext/index.ts')
      }
    },
    "name": "數位時代 BusinessNext",
    "apiRoutes": {},
    "url": "bnext.com.tw",
    "lang": "zh-TW"
  },
  "bntnews": {
    "routes": {
      "/:category?": {
        "path": "/:category?",
        "categories": [
          "new-media"
        ],
        "example": "/bntnews/bnt003000000",
        "parameters": {
          "category": "Category ID, see table below, default to Now (bnt008000000)"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "Category",
        "maintainers": [
          "iamsnn"
        ],
        "description": "| Beauty | Fashion | Star | Style+ | Photo | Life | Now |\n| ---- | ---- | ---- | ---- | ---- | ---- | ---- |\n| bnt003000000 | bnt002000000 | bnt004000000 | bnt007000000 | bnt009000000 | bnt005000000 | bnt008000000 |",
        "location": "index.ts",
        "module": () => import('@/routes/bntnews/index.ts')
      }
    },
    "name": "bntnews",
    "apiRoutes": {},
    "url": "bntnews.co.kr",
    "lang": "ko"
  },
  "bnu": {
    "routes": {
      "/bs/:category?": {
        "path": "/bs/:category?",
        "categories": [
          "university"
        ],
        "example": "/bnu/bs",
        "parameters": {
          "category": "分类，见下表，默认为学院新闻"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "bs.bnu.edu.cn/:category/index.html"
            ],
            "target": "/bs/:category"
          }
        ],
        "name": "经济与工商管理学院",
        "maintainers": [
          "nczitzk"
        ],
        "description": "| 学院新闻 | 通知公告 | 学术成果 | 学术讲座 | 教师观点 | 人才招聘 |\n| -------- | -------- | -------- | -------- | -------- | -------- |\n| xw       | zytzyyg  | xzcg     | xzjz     | xz       | bshzs    |",
        "location": "bs.ts",
        "module": () => import('@/routes/bnu/bs.ts')
      },
      "/dwxgb/:category/:type": {
        "path": "/dwxgb/:category/:type",
        "categories": [
          "university"
        ],
        "example": "/bnu/dwxgb/xwzx/tzgg",
        "parameters": {
          "category": "大分类",
          "type": "子分类，例子如下"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "dwxgb.bnu.edu.cn/:category/:type/index.html"
            ]
          }
        ],
        "name": "党委学生工作部",
        "maintainers": [
          "Fatpandac"
        ],
        "description": "`https://dwxgb.bnu.edu.cn/xwzx/tzgg/index.html` 则对应为 `/bnu/dwxgb/xwzx/tzgg",
        "location": "dwxgb.ts",
        "module": () => import('@/routes/bnu/dwxgb.ts')
      },
      "/fdy/:path{.+}?": {
        "path": "/fdy/:path{.+}?",
        "name": "Unknown",
        "maintainers": [],
        "location": "fdy.ts",
        "module": () => import('@/routes/bnu/fdy.ts')
      },
      "/fe/:category": {
        "path": "/fe/:category",
        "categories": [
          "university"
        ],
        "example": "/bnu/fe/18",
        "parameters": {},
        "radar": [
          {
            "source": [
              "fe.bnu.edu.cn/pc/cms1info/list/1/:category"
            ]
          }
        ],
        "name": "教育学部-培养动态",
        "maintainers": [
          "etShaw-zh"
        ],
        "description": "`https://fe.bnu.edu.cn/pc/cms1info/list/1/18` 则对应为 `/bnu/fe/18",
        "location": "fe.ts",
        "module": () => import('@/routes/bnu/fe.ts')
      },
      "/jwb": {
        "path": "/jwb",
        "categories": [
          "university"
        ],
        "example": "/bnu/jwb",
        "parameters": {},
        "radar": [
          {
            "source": [
              "jwb.bnu.edu.cn"
            ]
          }
        ],
        "name": "教务部（研究生院）",
        "maintainers": [
          "ladeng07"
        ],
        "url": "jwb.bnu.edu.cn/tzgg/index.htm",
        "location": "jwb.ts",
        "module": () => import('@/routes/bnu/jwb.ts')
      },
      "/lib/:category?": {
        "path": "/lib/:category?",
        "radar": [
          {
            "source": [
              "www.lib.bnu.edu.cn/:category/index.htm"
            ],
            "target": "/lib/:category"
          }
        ],
        "name": "Unknown",
        "maintainers": [
          "TonyRL"
        ],
        "location": "lib.ts",
        "module": () => import('@/routes/bnu/lib.ts')
      },
      "/mba/:category{.+}?": {
        "path": "/mba/:category{.+}?",
        "name": "经济与工商管理学院MBA",
        "url": "mba.bnu.edu.cn",
        "maintainers": [
          "nczitzk"
        ],
        "example": "/bnu/mba/xwdt",
        "parameters": {
          "category": "分类，默认为 xwdt，即新闻聚焦"
        },
        "description": "::: tip\n  若订阅 [新闻聚焦](https://mba.bnu.edu.cn/xwdt/index.html)，网址为 `https://mba.bnu.edu.cn/xwdt/index.html`。截取 `https://mba.bnu.edu.cn/` 到末尾 `/index.html` 的部分 `xwdt` 作为参数填入，此时路由为 [`/bnu/mba/xwdt`](https://rsshub.app/bnu/mba/xwdt)。\n:::\n\n#### [主页](https://mba.bnu.edu.cn)\n\n| [新闻聚焦](https://mba.bnu.edu.cn/xwdt/index.html) | [通知公告](https://mba.bnu.edu.cn/tzgg/index.html) | [MBA 系列讲座](https://mba.bnu.edu.cn/mbaxljz/index.html) |\n| -------------------------------------------------- | -------------------------------------------------- | --------------------------------------------------------- |\n| [xwdt](https://rsshub.app/bnu/mba/xwdt)            | [tzgg](https://rsshub.app/bnu/mba/tzgg)            | [mbaxljz](https://rsshub.app/bnu/mba/mbaxljz)             |\n\n#### [招生动态](https://mba.bnu.edu.cn/zsdt/zsjz/index.html)\n\n| [下载专区](https://mba.bnu.edu.cn/zsdt/cjwt/index.html) |\n| ------------------------------------------------------- |\n| [zsdt/cjwt](https://rsshub.app/bnu/mba/zsdt/cjwt)       |\n\n#### [国际视野](https://mba.bnu.edu.cn/gjhz/hwjd/index.html)\n\n| [海外基地](https://mba.bnu.edu.cn/gjhz/hwjd/index.html) | [学位合作](https://mba.bnu.edu.cn/gjhz/xwhz/index.html) | [长期交换](https://mba.bnu.edu.cn/gjhz/zqjh/index.html) | [短期项目](https://mba.bnu.edu.cn/gjhz/dqxm/index.html) |\n| ------------------------------------------------------- | ------------------------------------------------------- | ------------------------------------------------------- | ------------------------------------------------------- |\n| [gjhz/hwjd](https://rsshub.app/bnu/mba/gjhz/hwjd)       | [gjhz/xwhz](https://rsshub.app/bnu/mba/gjhz/xwhz)       | [gjhz/zqjh](https://rsshub.app/bnu/mba/gjhz/zqjh)       | [gjhz/dqxm](https://rsshub.app/bnu/mba/gjhz/dqxm)       |\n\n#### [校园生活](https://mba.bnu.edu.cn/xysh/xszz/index.html)\n\n| [学生组织](https://mba.bnu.edu.cn/xysh/xszz/index.html) |\n| ------------------------------------------------------- |\n| [xysh/xszz](https://rsshub.app/bnu/mba/xysh/xszz)       |\n\n#### [职业发展](https://mba.bnu.edu.cn/zyfz/xwds/index.html)\n\n| [校外导师](https://mba.bnu.edu.cn/zyfz/xwds/index.html) | [企业实践](https://mba.bnu.edu.cn/zyfz/zycp/index.html) | [就业创业](https://mba.bnu.edu.cn/zyfz/jycy/index.html) |\n| ------------------------------------------------------- | ------------------------------------------------------- | ------------------------------------------------------- |\n| [zyfz/xwds](https://rsshub.app/bnu/mba/zyfz/xwds)       | [zyfz/zycp](https://rsshub.app/bnu/mba/zyfz/zycp)       | [zyfz/jycy](https://rsshub.app/bnu/mba/zyfz/jycy)       |\n  ",
        "categories": [
          "university"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "mba.bnu.edu.cn/:category?"
            ]
          },
          {
            "title": "新闻聚焦",
            "source": [
              "mba.bnu.edu.cn/xwdt/index.html"
            ],
            "target": "/mba/xwdt"
          },
          {
            "title": "通知公告",
            "source": [
              "mba.bnu.edu.cn/tzgg/index.html"
            ],
            "target": "/mba/tzgg"
          },
          {
            "title": "MBA系列讲座",
            "source": [
              "mba.bnu.edu.cn/mbaxljz/index.html"
            ],
            "target": "/mba/mbaxljz"
          },
          {
            "title": "招生动态 - 下载专区",
            "source": [
              "mba.bnu.edu.cn/zsdt/cjwt/index.html"
            ],
            "target": "/mba/zsdt/cjwt"
          },
          {
            "title": "国际视野 - 海外基地",
            "source": [
              "mba.bnu.edu.cn/gjhz/hwjd/index.html"
            ],
            "target": "/mba/gjhz/hwjd"
          },
          {
            "title": "国际视野 - 学位合作",
            "source": [
              "mba.bnu.edu.cn/gjhz/xwhz/index.html"
            ],
            "target": "/mba/gjhz/xwhz"
          },
          {
            "title": "国际视野 - 长期交换",
            "source": [
              "mba.bnu.edu.cn/gjhz/zqjh/index.html"
            ],
            "target": "/mba/gjhz/zqjh"
          },
          {
            "title": "国际视野 - 短期项目",
            "source": [
              "mba.bnu.edu.cn/gjhz/dqxm/index.html"
            ],
            "target": "/mba/gjhz/dqxm"
          },
          {
            "title": "校园生活 - 学生组织",
            "source": [
              "mba.bnu.edu.cn/xysh/xszz/index.html"
            ],
            "target": "/mba/xysh/xszz"
          },
          {
            "title": "职业发展 - 校外导师",
            "source": [
              "mba.bnu.edu.cn/zyfz/xwds/index.html"
            ],
            "target": "/mba/zyfz/xwds"
          },
          {
            "title": "职业发展 - 企业实践",
            "source": [
              "mba.bnu.edu.cn/zyfz/zycp/index.html"
            ],
            "target": "/mba/zyfz/zycp"
          },
          {
            "title": "职业发展 - 就业创业",
            "source": [
              "mba.bnu.edu.cn/zyfz/jycy/index.html"
            ],
            "target": "/mba/zyfz/jycy"
          }
        ],
        "location": "mba.ts",
        "module": () => import('@/routes/bnu/mba.ts')
      }
    },
    "name": "北京师范大学",
    "apiRoutes": {},
    "url": "bs.bnu.edu.cn",
    "lang": "zh-CN"
  },
  "boc": {
    "routes": {
      "/whpj/:format?": {
        "path": "/whpj/:format?",
        "categories": [
          "other"
        ],
        "example": "/boc/whpj/zs?filter_title=%E8%8B%B1%E9%95%91",
        "parameters": {
          "format": "输出的标题格式，默认为标题 + 所有价格。短格式仅包含货币名称。"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "boc.cn/sourcedb/whpj",
              "boc.cn/"
            ],
            "target": "/whpj"
          }
        ],
        "name": "外汇牌价",
        "maintainers": [
          "LogicJake",
          "HenryQW"
        ],
        "url": "boc.cn/sourcedb/whpj",
        "description": "| 短格式 | 中行折算价 | 现汇买卖 | 现钞买卖 | 现汇买入 | 现汇卖出 | 现钞买入 | 现钞卖出 |\n| ------ | ---------- | -------- | -------- | -------- | -------- | -------- | -------- |\n| short  | zs         | xh       | xc       | xhmr     | xhmc     | xcmr     | xcmc     |",
        "location": "whpj.ts",
        "module": () => import('@/routes/boc/whpj.ts')
      }
    },
    "name": "中国银行",
    "url": "boc.cn",
    "lang": "zh-CN"
  },
  "bookfere": {
    "routes": {
      "/:category": {
        "path": "/:category",
        "categories": [
          "reading"
        ],
        "view": 0,
        "example": "/bookfere/skills",
        "parameters": {
          "category": {
            "description": "分类名",
            "options": [
              {
                "value": "weekly",
                "label": "每周一书"
              },
              {
                "value": "skills",
                "label": "使用技巧"
              },
              {
                "value": "books",
                "label": "图书推荐"
              },
              {
                "value": "news",
                "label": "新闻速递"
              },
              {
                "value": "essay",
                "label": "精选短文"
              }
            ]
          }
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "分类",
        "maintainers": [
          "OdinZhang"
        ],
        "description": "| 每周一书 | 使用技巧 | 图书推荐 | 新闻速递 | 精选短文 |\n| -------- | -------- | -------- | -------- | -------- |\n| weekly   | skills   | books    | news     | essay    |",
        "location": "category.ts",
        "module": () => import('@/routes/bookfere/category.ts')
      }
    },
    "name": "书伴",
    "apiRoutes": {},
    "url": "bookfere.com",
    "lang": "zh-CN"
  },
  "bookwalker": {
    "routes": {
      "/search/:filter?": {
        "path": "/search/:filter?",
        "name": "搜尋",
        "url": "www.bookwalker.com.tw",
        "maintainers": [
          "nczitzk"
        ],
        "example": "/bookwalker/search/order=sell_desc&s=34",
        "parameters": {
          "filter": {
            "description": "过滤器，默认为 `order=sell_desc`，即依發售日新至舊排序"
          }
        },
        "description": "::: tip\n订阅 [依發售日新至舊排序的文學小說](https://www.bookwalker.com.tw/search?order=sell_desc&s=34)，其源网址为 `https://www.bookwalker.com.tw/search?order=sell_desc&s=34`，请参考该 URL 指定部分构成参数，此时路由为 [`/bookwalker/search/order=sell_desc&s=34`](https://rsshub.app/bookwalker/search/order=sell_desc&s=34)。\n:::",
        "categories": [
          "shopping"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.bookwalker.com.tw/search"
            ],
            "target": "/bookwalker/search"
          }
        ],
        "view": 0,
        "location": "search.tsx",
        "module": () => import('@/routes/bookwalker/search.tsx')
      }
    },
    "name": "BOOKWALKER電子書",
    "url": "bookwalker.com.tw",
    "categories": [
      "shopping"
    ],
    "description": "",
    "lang": "zh-TW"
  },
  "booru": {
    "routes": {
      "/mmda/tags/:tags?": {
        "path": "/mmda/tags/:tags?",
        "categories": [
          "picture"
        ],
        "example": "/booru/mmda/tags/full_body%20blue_eyes",
        "parameters": {
          "tags": "标签，多个标签使用 `%20` 连接，如需根据作者查询则在 `user:` 后接上作者名，如：`user:xxxx`"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false,
          "nsfw": true
        },
        "radar": [
          {
            "source": [
              "mmda.booru.org/index.php"
            ]
          }
        ],
        "name": "MMDArchive 标签查询",
        "maintainers": [
          "N78Wy"
        ],
        "description": "For example:\n\n  -   默认查询 (什么 tag 都不加)：`/booru/mmda/tags`\n  -   默认查询单个 tag：`/booru/mmda/tags/full_body`\n  -   默认查询多个 tag：`/booru/mmda/tags/full_body%20blue_eyes`\n  -   默认查询根据作者查询：`/booru/mmda/tags/user:xxxx`",
        "location": "mmda.ts",
        "module": () => import('@/routes/booru/mmda.ts')
      }
    },
    "name": "Booru",
    "apiRoutes": {},
    "url": "mmda.booru.org",
    "lang": "en"
  },
  "bossdesign": {
    "routes": {
      "/:category?": {
        "path": "/:category?",
        "categories": [
          "design"
        ],
        "example": "/bossdesign",
        "parameters": {
          "category": "分类，可在对应分类页 URL 中找到，留空为全部"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "分类",
        "maintainers": [
          "TonyRL"
        ],
        "description": "| Boss 笔记 | 电脑日志        | 素材资源         | 设计师神器      | 设计教程        | 设计资讯            |\n| --------- | --------------- | ---------------- | --------------- | --------------- | ------------------- |\n| note      | computer-skills | design-resources | design-software | design-tutorial | design_information |",
        "location": "index.ts",
        "module": () => import('@/routes/bossdesign/index.ts')
      }
    },
    "name": "Boss 设计",
    "apiRoutes": {},
    "url": "bossdesign.cn",
    "lang": "zh-CN"
  },
  "brave": {
    "routes": {
      "/latest": {
        "path": "/latest",
        "categories": [
          "program-update"
        ],
        "example": "/brave/latest",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "brave.com/latest",
              "brave.com/"
            ]
          }
        ],
        "name": "Release Notes",
        "maintainers": [
          "nczitzk"
        ],
        "url": "brave.com/latest",
        "location": "latest.ts",
        "module": () => import('@/routes/brave/latest.ts')
      }
    },
    "name": "Brave",
    "apiRoutes": {},
    "url": "brave.com",
    "lang": "en"
  },
  "brooklynmuseum": {
    "routes": {
      "/exhibitions/:state?": {
        "path": "/exhibitions/:state?",
        "categories": [
          "travel"
        ],
        "example": "/brooklynmuseum/exhibitions",
        "parameters": {
          "state": "展览进行的状态：`current` 对应展览当前正在进行，`past` 对应过去的展览，`upcoming` 对应即将举办的展览，默认为 `current`"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "Exhibitions",
        "maintainers": [],
        "location": "exhibitions.ts",
        "module": () => import('@/routes/brooklynmuseum/exhibitions.ts')
      }
    },
    "name": "Brooklyn Museum",
    "apiRoutes": {},
    "url": "www.brooklynmuseum.org",
    "lang": "en"
  },
  "bse": {
    "routes": {
      "/:category?/:keyword?": {
        "path": "/:category?/:keyword?",
        "categories": [
          "finance"
        ],
        "example": "/bse",
        "parameters": {
          "category": "分类，见下表，默认为本所要闻",
          "keyword": "关键字，默认为空"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "bse.cn/"
            ]
          }
        ],
        "name": "栏目",
        "maintainers": [
          "nczitzk"
        ],
        "url": "bse.cn/",
        "description": "| 本所要闻        | 人才招聘 | 采购信息 | 业务通知   |\n| --------------- | -------- | -------- | ---------- |\n| important_news | recruit  | purchase | news_list |\n\n| 法律法规  | 公开征求意见    | 部门规章         | 发行融资   |\n| --------- | --------------- | ---------------- | ---------- |\n| law_list | public_opinion | regulation_list | fxrz_list |\n\n| 持续监管   | 交易管理   | 市场管理   | 上市委会议公告  |\n| ---------- | ---------- | ---------- | --------------- |\n| cxjg_list | jygl_list | scgl_list | meeting_notice |\n\n| 上市委会议结果公告 | 上市委会议变更公告 | 并购重组委会议公告 |\n| ------------------ | ------------------ | ------------------ |\n| meeting_result    | meeting_change    | bgcz_notice       |\n\n| 并购重组委会议结果公告 | 并购重组委会议变更公告 | 终止审核           | 注册结果      |\n| ---------------------- | ---------------------- | ------------------ | ------------- |\n| bgcz_result           | bgcz_change           | termination_audit | audit_result |",
        "location": "index.ts",
        "module": () => import('@/routes/bse/index.ts')
      }
    },
    "name": "北京证券交易所",
    "apiRoutes": {},
    "url": "bse.cn",
    "lang": "zh-CN"
  },
  "bsky": {
    "routes": {
      "/profile/:handle/feed/:space/:routeParams?": {
        "path": "/profile/:handle/feed/:space/:routeParams?",
        "categories": [
          "social-media"
        ],
        "view": 1,
        "example": "/bsky.app/profile/jaz.bsky.social/feed/cv:cat",
        "parameters": {
          "handle": "User handle, can be found in URL",
          "space": "Space ID, can be found in URL"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "Feeds",
        "maintainers": [
          "FerrisChi"
        ],
        "location": "feeds.ts",
        "module": () => import('@/routes/bsky/feeds.ts')
      },
      "/keyword/:keyword": {
        "path": "/keyword/:keyword",
        "categories": [
          "social-media"
        ],
        "example": "/bsky/keyword/hello",
        "parameters": {
          "keyword": "N"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "Keywords",
        "maintainers": [
          "untitaker",
          "DIYgod"
        ],
        "location": "keyword.ts",
        "module": () => import('@/routes/bsky/keyword.ts')
      },
      "/profile/:handle/:routeParams?": {
        "path": "/profile/:handle/:routeParams?",
        "categories": [
          "social-media"
        ],
        "view": 1,
        "example": "/bsky/profile/bsky.app",
        "parameters": {
          "handle": "User handle, can be found in URL",
          "routeParams": "Filter parameter, Use filter to customize content types"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "bsky.app/profile/:handle"
            ]
          }
        ],
        "name": "Post",
        "maintainers": [
          "TonyRL"
        ],
        "description": "\n| Filter Value | Description |\n|--------------|-------------|\n| posts_with_replies | Includes Posts, Replies, and Reposts |\n| posts_no_replies | Includes Posts and Reposts, without Replies |\n| posts_with_media | Shows only Posts containing media |\n| posts_and_author_threads | Shows Posts and Threads, without Replies and Reposts |\n\nDefault value for filter is `posts_and_author_threads` if not specified.\n\nExample:\n- `/bsky/profile/bsky.app/filter=posts_with_replies`",
        "location": "posts.ts",
        "module": () => import('@/routes/bsky/posts.ts')
      }
    },
    "name": "Bluesky (bsky)",
    "apiRoutes": {},
    "url": "bsky.app",
    "lang": "en"
  },
  "bt0": {
    "routes": {
      "/mv/:number/:domain?": {
        "path": "/mv/:number/:domain?",
        "categories": [
          "multimedia"
        ],
        "example": "/bt0/mv/35575567/2",
        "parameters": {
          "number": "影视详情id, 网页路径为`/mv/{id}.html`其中的id部分, 一般为8位纯数字",
          "domain": "数字1-9, 比如1表示请求域名为 1bt0.com, 默认为 2"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": true,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "2bt0.com/mv/"
            ]
          }
        ],
        "name": "影视资源下载列表",
        "maintainers": [
          "miemieYaho"
        ],
        "location": "mv.ts",
        "module": () => import('@/routes/bt0/mv.ts')
      },
      "/tlist/:sc/:domain?": {
        "path": "/tlist/:sc/:domain?",
        "categories": [
          "multimedia"
        ],
        "example": "/bt0/tlist/1",
        "parameters": {
          "sc": "分类(1-5), 1:电影, 2:电视剧, 3:近日热门, 4:本周热门, 5:本月热门",
          "domain": "数字1-9, 比如1表示请求域名为 1bt0.com, 默认为 2"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": true,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "2bt0.com/tlist/"
            ]
          }
        ],
        "name": "最新资源列表",
        "maintainers": [
          "miemieYaho"
        ],
        "location": "tlist.ts",
        "module": () => import('@/routes/bt0/tlist.ts')
      }
    },
    "name": "不太灵影视",
    "apiRoutes": {},
    "url": "2bt0.com",
    "description": "::: tip\n  (1-9)bt0.com 都指向同一个\n:::",
    "lang": "zh-CN"
  },
  "btbtla": {
    "routes": {
      "/detail/:name": {
        "path": "/detail/:name",
        "categories": [
          "multimedia"
        ],
        "example": "/btbtla/detail/雍正王朝",
        "parameters": {
          "name": "电影 | 电视剧名称"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": true,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "BTBTLA | 指定剧名",
        "maintainers": [
          "Hermes1030"
        ],
        "location": "detail.ts",
        "module": () => import('@/routes/btbtla/detail.ts')
      },
      "/gxlist": {
        "categories": [
          "multimedia"
        ],
        "example": "/btbtla/gxlist",
        "maintainers": [
          "Hermes1030"
        ],
        "name": "BTBTLA | 最近更新",
        "path": "/gxlist",
        "url": "btbtla.com/tt/gxlist.html",
        "location": "gxlist.ts",
        "module": () => import('@/routes/btbtla/gxlist.ts')
      }
    },
    "name": "BT影视",
    "apiRoutes": {},
    "url": "www.btbtla.com",
    "description": "BT影视的页面内容，最近更新列表，视频种子列表。"
  },
  "btzj": {
    "routes": {
      "/:category?": {
        "path": "/:category?",
        "categories": [
          "multimedia"
        ],
        "example": "/btzj",
        "parameters": {
          "category": "分类，可在对应分类页 URL 中找到，默认为首页"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "btbtt20.com/"
            ]
          }
        ],
        "name": "分类",
        "maintainers": [
          "nczitzk"
        ],
        "url": "btbtt20.com/",
        "description": "::: tip\n  分类页中域名末尾到 `.htm` 前的字段即为对应分类，如 [电影](https://www.btbtt20.com/forum-index-fid-951.htm) `https://www.btbtt20.com/forum-index-fid-951.htm` 中域名末尾到 `.htm` 前的字段为 `forum-index-fid-951`，所以路由应为 [`/btzj/forum-index-fid-951`](https://rsshub.app/btzj/forum-index-fid-951)\n\n  部分分类页，如 [电影](https://www.btbtt20.com/forum-index-fid-951.htm)、[剧集](https://www.btbtt20.com/forum-index-fid-950.htm) 等，提供了更复杂的分类筛选。你可以将选项选中后，获得结果分类页 URL 中分类参数，构成路由。如选中分类 [高清电影 - 年份：2021 - 地区：欧美](https://www.btbtt20.com/forum-index-fid-1183-typeid1-0-typeid2-738-typeid3-10086-typeid4-0.htm) `https://www.btbtt20.com/forum-index-fid-1183-typeid1-0-typeid2-738-typeid3-10086-typeid4-0.htm` 中域名末尾到 `.htm` 前的字段为 `forum-index-fid-1183-typeid1-0-typeid2-738-typeid3-10086-typeid4-0`，所以路由应为 [`/btzj/forum-index-fid-1183-typeid1-0-typeid2-738-typeid3-10086-typeid4-0`](https://rsshub.app/btzj/forum-index-fid-1183-typeid1-0-typeid2-738-typeid3-10086-typeid4-0)\n:::\n\n  基础分类如下：\n\n| 交流                | 电影                | 剧集                | 高清电影             |\n| ------------------- | ------------------- | ------------------- | -------------------- |\n| forum-index-fid-975 | forum-index-fid-951 | forum-index-fid-950 | forum-index-fid-1183 |\n\n| 音乐                | 动漫                | 游戏                | 综艺                 |\n| ------------------- | ------------------- | ------------------- | -------------------- |\n| forum-index-fid-953 | forum-index-fid-981 | forum-index-fid-955 | forum-index-fid-1106 |\n\n| 图书                 | 美图                | 站务              | 科技                |\n| -------------------- | ------------------- | ----------------- | ------------------- |\n| forum-index-fid-1151 | forum-index-fid-957 | forum-index-fid-2 | forum-index-fid-952 |\n\n| 求助                 | 音轨字幕             |\n| -------------------- | -------------------- |\n| forum-index-fid-1187 | forum-index-fid-1191 |\n\n::: tip\n  BT 之家的域名会变更，本路由以 `https://www.btbtt20.com` 为默认域名，若该域名无法访问，可以通过在路由后方加上 `?domain=<域名>` 指定路由访问的域名。如指定域名为 `https://www.btbtt15.com`，则在 `/btzj` 后加上 `?domain=btbtt15.com` 即可，此时路由为 [`/btzj?domain=btbtt15.com`](https://rsshub.app/btzj?domain=btbtt15.com)\n\n  如果加入了分类参数，直接在分类参数后加入 `?domain=<域名>` 即可。如指定分类 [剧集](https://www.btbtt20.com/forum-index-fid-950.htm) `https://www.btbtt20.com/forum-index-fid-950.htm` 并指定域名为 `https://www.btbtt15.com`，即在 `/btzj/forum-index-fid-950` 后加上 `?domain=btbtt15.com`，此时路由为 [`/btzj/forum-index-fid-950?domain=btbtt15.com`](https://rsshub.app/btzj/forum-index-fid-950?domain=btbtt15.com)\n\n  目前，你可以选择的域名有 `btbtt10-20.com` 共 10 个，或 `88btbbt.com`，该站也提供了专用网址查询工具。详见 [此贴](https://www.btbtt20.com/thread-index-fid-2-tid-4550191.htm)\n:::",
        "location": "index.tsx",
        "module": () => import('@/routes/btzj/index.tsx')
      }
    },
    "name": "BT 之家",
    "apiRoutes": {},
    "url": "btbtt20.com",
    "lang": "zh-CN"
  },
  "buaa": {
    "routes": {
      "/jiaowu/:cddm?": {
        "path": "/jiaowu/:cddm?",
        "name": "教务部",
        "url": "jiaowu.buaa.edu.cn",
        "maintainers": [
          "OverflowCat"
        ],
        "example": "/buaa/jiaowu/02",
        "parameters": {
          "cddm": "菜单代码，可以是 2 位或者 4 位，默认为 `02`（通知公告）"
        },
        "description": "::: tip\n\n菜单代码（`cddm`）应填写链接中调用的 newsList 接口的参数，可以是 2 位或者 4 位数字。若为 2 位，则为 `fcd`（父菜单）；若为 4 位，则为 `cddm`（菜单代码），其中前 2 位为 `fcd`。\n示例：\n\n1. 新闻快讯页面的链接中 `onclick=\"javascript:onNewsList('03');return false;\"`，对应的路径参数为 `03`，完整路由为 `/buaa/jiaowu/03`；\n2. 通知公告 > 公示专区页面的链接中 `onclick=\"javascript:onNewsList2('0203','2');return false;\"`，对应的路径参数为 `0203`，完整路由为 `/buaa/jiaowu/0203`。\n:::",
        "categories": [
          "university"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "location": "jiaowu.ts",
        "module": () => import('@/routes/buaa/jiaowu.ts')
      },
      "/lib/space/:path{newbook.*}": {
        "path": "/lib/space/:path{newbook.*}",
        "name": "图书馆 - 新书速递",
        "url": "space.lib.buaa.edu.cn/mspace/newBook",
        "maintainers": [
          "OverflowCat"
        ],
        "example": "/buaa/lib/space/newbook/",
        "description": "可通过参数进行筛选：`/buaa/lib/space/newbook/key1=value1&key2=value2...`\n- `dcpCode`：学科分类代码\n  - 例：\n    - 工学：`08`\n    - 工学 > 计算机 > 计算机科学与技术：`080901`\n  - 默认值：`nolimit`\n  - 注意事项：不可与 `clsNo` 同时使用。\n- `clsNo`：中图分类号\n  - 例：\n    - 计算机科学：`TP3`\n  - 默认值：无\n  - 注意事项\n    - 不可与 `dcpCode` 同时使用。\n    - 此模式下获取不到上架日期。\n- `libCode`：图书馆代码\n  - 例：\n    - 本馆：`00000`\n  - 默认值：无\n  - 注意事项：只有本馆一个可选值。\n- `locaCode`：馆藏地代码\n  - 例：\n    - 五层西-中文新书借阅室(A-Z类)：`02503`\n  - 默认值：无\n  - 注意事项：必须与 `libCode` 同时使用。\n\n示例：\n- `buaa/lib/space/newbook` 为所有新书\n- `buaa/lib/space/newbook/clsNo=U&libCode=00000&locaCode=60001` 为沙河教2图书馆所有中图分类号为 U（交通运输）的书籍\n",
        "categories": [
          "university"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "location": "lib/space/newbook.tsx",
        "module": () => import('@/routes/buaa/lib/space/newbook.tsx')
      },
      "/news/:type": {
        "path": "/news/:type",
        "categories": [
          "university"
        ],
        "example": "/buaa/news/zhxw",
        "parameters": {
          "type": "新闻版块"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "新闻网",
        "maintainers": [
          "AlanDecode"
        ],
        "description": "| 综合新闻 | 信息公告 | 学术文化    | 校园风采 | 科教在线 | 媒体北航 | 专题新闻 | 北航人物 |\n| -------- | -------- | ----------- | -------- | -------- | -------- | -------- | -------- |\n| zhxw     | xxgg_new | xsjwhhd_new | xyfc_new | kjzx_new | mtbh_new | ztxw     | bhrw     |",
        "location": "news/index.ts",
        "module": () => import('@/routes/buaa/news/index.ts')
      },
      "/sme/:path{.+}?": {
        "path": "/sme/:path{.+}?",
        "name": "集成电路科学与工程学院",
        "url": "www.sme.buaa.edu.cn",
        "maintainers": [
          "MeanZhang"
        ],
        "example": "/buaa/sme/tzgg",
        "parameters": {
          "path": "版块路径，默认为 `tzgg`（通知公告）"
        },
        "description": "::: tip\n\n版块路径（`path`）应填写板块 URL 中 `http://www.sme.buaa.edu.cn/` 和 `.htm` 之间的字段。\n\n示例：\n\n1. [通知公告](http://www.sme.buaa.edu.cn/tzgg.htm) 页面的 URL 为 `http://www.sme.buaa.edu.cn/tzgg.htm`，对应的路径参数为 `tzgg`，完整路由为 `/buaa/sme/tzgg`；\n2. [就业信息](http://www.sme.buaa.edu.cn/zsjy/jyxx.htm) 页面的 URL 为 `http://www.sme.buaa.edu.cn/zsjy/jyxx.htm`，对应的路径参数为 `zsjy/jyxx`，完整路由为 `/buaa/sme/zsjy/jyxx`。\n\n:::\n\n::: warning\n\n部分页面（如[学院介绍](http://www.sme.buaa.edu.cn/xygk/xyjs.htm)、[微纳中心](http://www.sme.buaa.edu.cn/wnzx.htm)、[院学生会](http://www.sme.buaa.edu.cn/xsgz/yxsh.htm)）存在无内容、内容跳转至外站等情况，因此可能出现解析失败的现象。\n\n:::",
        "categories": [
          "university"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "location": "sme.ts",
        "module": () => import('@/routes/buaa/sme.ts')
      }
    },
    "name": "北京航空航天大学",
    "apiRoutes": {},
    "url": "news.buaa.edu.cn",
    "lang": "zh-CN"
  },
  "buct": {
    "routes": {
      "/cist": {
        "path": "/cist",
        "categories": [
          "university"
        ],
        "example": "/buct/cist",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "cist.buct.edu.cn/xygg/list.htm",
              "cist.buct.edu.cn/xygg/main.htm"
            ],
            "target": "/cist"
          }
        ],
        "name": "信息学院",
        "maintainers": [
          "Epic-Creeper"
        ],
        "url": "buct.edu.cn/",
        "location": "cist.ts",
        "module": () => import('@/routes/buct/cist.ts')
      },
      "/gr/:type": {
        "path": "/gr/:type",
        "categories": [
          "university"
        ],
        "example": "/buct/gr/jzml",
        "parameters": {
          "type": {
            "description": "信息类型，可选值：tzgg（通知公告），jzml（简章目录），xgzc（相关政策）",
            "options": [
              {
                "value": "tzgg",
                "label": "通知公告"
              },
              {
                "value": "jzml",
                "label": "简章目录"
              },
              {
                "value": "xgzc",
                "label": "相关政策"
              }
            ]
          }
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "graduate.buct.edu.cn/1392/list.htm"
            ],
            "target": "/gr/tzgg"
          },
          {
            "source": [
              "graduate.buct.edu.cn/jzml/list.htm"
            ],
            "target": "/gr/jzml"
          },
          {
            "source": [
              "graduate.buct.edu.cn/1393/list.htm"
            ],
            "target": "/gr/xgzc"
          }
        ],
        "name": "研究生院",
        "maintainers": [
          "Epic-Creeper"
        ],
        "url": "buct.edu.cn/",
        "location": "gr.ts",
        "module": () => import('@/routes/buct/gr.ts')
      },
      "/jwc": {
        "path": "/jwc",
        "categories": [
          "university"
        ],
        "example": "/buct/jwc",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "jiaowuchu.buct.edu.cn/610/list.htm",
              "jiaowuchu.buct.edu.cn/611/main.htm"
            ],
            "target": "/jwc"
          }
        ],
        "name": "教务处",
        "maintainers": [
          "Epic-Creeper"
        ],
        "url": "buct.edu.cn/",
        "location": "jwc.ts",
        "module": () => import('@/routes/buct/jwc.ts')
      }
    },
    "name": "北京化工大学",
    "apiRoutes": {},
    "url": "buct.edu.cn",
    "lang": "zh-CN"
  },
  "bugzilla": {
    "routes": {
      "/bug/:site/:bugId": {
        "path": "/bug/:site/:bugId",
        "name": "bugs",
        "maintainers": [
          "FranklinYu"
        ],
        "example": "/bugzilla/bug/webkit/251528",
        "parameters": {
          "site": "site identifier",
          "bugId": "numeric identifier of the bug in the site"
        },
        "description": "Supported site identifiers: [`apache`](https://bz.apache.org/bugzilla), [`apache.ooo`](https://bz.apache.org/ooo), [`apache.SpamAssassin`](https://bz.apache.org/SpamAssassin), [`kernel`](https://bugzilla.kernel.org), [`mozilla`](https://bugzilla.mozilla.org), [`webkit`](https://bugs.webkit.org).",
        "categories": [
          "programming"
        ],
        "zh": {
          "name": "bugs",
          "description": "支持的站点标识符：[`apache`](https://bz.apache.org/bugzilla)、[`apache.ooo`](https://bz.apache.org/ooo)、[`apache.SpamAssassin`](https://bz.apache.org/SpamAssassin)、[`kernel`](https://bugzilla.kernel.org)、[`mozilla`](https://bugzilla.mozilla.org)、[`webkit`](https://bugs.webkit.org)。"
        },
        "location": "bug.ts",
        "module": () => import('@/routes/bugzilla/bug.ts')
      }
    },
    "name": "Bugzilla",
    "apiRoutes": {},
    "url": "bugzilla.org",
    "description": "Bugzilla instances hosted by organizations.",
    "zh": {
      "name": "Bugzilla",
      "description": "各组织自建的Bugzilla实例。"
    },
    "lang": "en"
  },
  "bulianglin": {
    "routes": {
      "/": {
        "path": "/",
        "categories": [
          "blog"
        ],
        "example": "/bulianglin",
        "radar": [
          {
            "source": [
              "bulianglin.com/"
            ]
          }
        ],
        "name": "全部文章",
        "maintainers": [
          "cnkmmk"
        ],
        "url": "bulianglin.com/",
        "location": "rss.ts",
        "module": () => import('@/routes/bulianglin/rss.ts')
      }
    },
    "name": "不良林",
    "url": "bulianglin.com",
    "lang": "zh-CN"
  },
  "bullionvault": {
    "routes": {
      "/gold-news/:category?": {
        "path": "/gold-news/:category?",
        "name": "Gold News",
        "url": "bullionvault.com",
        "maintainers": [
          "nczitzk"
        ],
        "example": "/bullionvault/gold-news",
        "parameters": {
          "category": {
            "description": "Category",
            "options": [
              {
                "label": "Gold market analysis & gold investment research",
                "value": ""
              },
              {
                "label": "Opinion & Analysis",
                "value": "opinion-analysis"
              },
              {
                "label": "Gold Price News",
                "value": "gold-price-news"
              },
              {
                "label": "Investment News",
                "value": "news"
              },
              {
                "label": "Gold Investor Index",
                "value": "gold-investor-index"
              },
              {
                "label": "Gold Infographics",
                "value": "infographics"
              },
              {
                "label": "Market Fundamentals",
                "value": "market-fundamentals"
              }
            ]
          }
        },
        "description": "::: tip\nIf you subscribe to [Gold Price News](https://www.bullionvault.com/gold-news/gold-price-news)，where the URL is `https://www.bullionvault.com/gold-news/gold-price-news`, extract the part `https://www.bullionvault.com/gold-news/` to the end, and use it as the parameter to fill in. Therefore, the route will be [`/bullionvault/gold-news/gold-price-news`](https://rsshub.app/bullionvault/gold-news/gold-price-news).\n:::\n\n| Category                                                                          | ID                                                                                   |\n| --------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------ |\n| [Opinion & Analysis](https://www.bullionvault.com/gold-news/opinion-analysis)     | [opinion-analysis](https://rsshub.app/bullionvault/gold-news/opinion-analysis)       |\n| [Gold Price News](https://www.bullionvault.com/gold-news/gold-price-news)         | [gold-price-news](https://rsshub.app/bullionvault/gold-news/gold-price-news)         |\n| [Investment News](https://www.bullionvault.com/gold-news/news)                    | [news](https://rsshub.app/bullionvault/gold-news/news)                               |\n| [Gold Investor Index](https://www.bullionvault.com/gold-news/gold-investor-index) | [gold-investor-index](https://rsshub.app/bullionvault/gold-news/gold-investor-index) |\n| [Gold Infographics](https://www.bullionvault.com/gold-news/infographics)          | [infographics](https://rsshub.app/bullionvault/gold-news/infographics)               |\n| [Market Fundamentals](https://www.bullionvault.com/gold-news/market-fundamentals) | [market-fundamentals](https://rsshub.app/bullionvault/gold-news/market-fundamentals) |\n",
        "categories": [
          "finance"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "bullionvault.com/gold-news/:category"
            ]
          },
          {
            "title": "Gold market analysis & gold investment research",
            "source": [
              "bullionvault.com/gold-news"
            ],
            "target": "/gold-news"
          },
          {
            "title": "Opinion & Analysis",
            "source": [
              "bullionvault.com/gold-news/opinion-analysis"
            ],
            "target": "/gold-news/opinion-analysis"
          },
          {
            "title": "Gold Price News",
            "source": [
              "bullionvault.com/gold-news/gold-price-news"
            ],
            "target": "/gold-news/gold-price-news"
          },
          {
            "title": "Investment News",
            "source": [
              "bullionvault.com/gold-news/news"
            ],
            "target": "/gold-news/news"
          },
          {
            "title": "Gold Investor Index",
            "source": [
              "bullionvault.com/gold-news/gold-investor-index"
            ],
            "target": "/gold-news/gold-investor-index"
          },
          {
            "title": "Gold Infographics",
            "source": [
              "bullionvault.com/gold-news/infographics"
            ],
            "target": "/gold-news/infographics"
          },
          {
            "title": "Market Fundamentals",
            "source": [
              "bullionvault.com/gold-news/market-fundamentals"
            ],
            "target": "/gold-news/market-fundamentals"
          }
        ],
        "view": 0,
        "location": "gold-news.ts",
        "module": () => import('@/routes/bullionvault/gold-news.ts')
      }
    },
    "name": "BullionVault",
    "apiRoutes": {},
    "url": "bullionvault.com",
    "categories": [
      "finance"
    ],
    "description": "",
    "lang": "en"
  },
  "bupt": {
    "routes": {
      "/jwc/:type": {
        "path": "/jwc/:type",
        "categories": [
          "university"
        ],
        "example": "/bupt/jwc/tzgg",
        "parameters": {
          "type": {
            "type": "string",
            "optional": false,
            "description": "信息类型，可选值：tzgg（通知公告），xwzx（新闻资讯）"
          }
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "jwc.bupt.edu.cn/tzgg1.htm"
            ],
            "target": "/jwc/tzgg"
          },
          {
            "source": [
              "jwc.bupt.edu.cn/xwzx2.htm"
            ],
            "target": "/jwc/xwzx"
          }
        ],
        "name": "教务处",
        "maintainers": [
          "Yoruet"
        ],
        "url": "jwc.bupt.edu.cn",
        "location": "jwc.ts",
        "module": () => import('@/routes/bupt/jwc.ts')
      },
      "/rczp": {
        "path": "/rczp",
        "categories": [
          "university"
        ],
        "example": "/bupt/rczp",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "bupt.edu.cn/"
            ]
          }
        ],
        "name": "人才招聘",
        "maintainers": [
          "nczitzk"
        ],
        "url": "bupt.edu.cn/",
        "location": "rczp.ts",
        "module": () => import('@/routes/bupt/rczp.ts')
      },
      "/scss/tzgg": {
        "path": "/scss/tzgg",
        "categories": [
          "university"
        ],
        "example": "/bupt/scss/tzgg",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "scss.bupt.edu.cn/index/tzgg1.htm"
            ],
            "target": "/scss/tzgg"
          }
        ],
        "name": "网络空间安全学院 - 通知公告",
        "maintainers": [
          "ziri2004"
        ],
        "url": "scss.bupt.edu.cn",
        "location": "scss.ts",
        "module": () => import('@/routes/bupt/scss.ts')
      }
    },
    "name": "北京邮电大学",
    "apiRoutes": {},
    "url": "bupt.edu.cn",
    "lang": "zh-CN"
  },
  "bvisness": {
    "routes": {
      "/blog": {
        "name": "Blog",
        "categories": [
          "blog"
        ],
        "maintainers": [
          "raxod502"
        ],
        "path": "/blog",
        "example": "/bvisness/blog",
        "radar": [
          {
            "source": [
              "bvisness.me"
            ],
            "target": "/blog"
          }
        ],
        "location": "blog.ts",
        "module": () => import('@/routes/bvisness/blog.ts')
      }
    },
    "name": "Ben Visness",
    "apiRoutes": {},
    "url": "bvisness.me"
  },
  "bwsg": {
    "routes": {
      "*": {
        "name": "Angebote",
        "example": "/bwsg/_vermarktungsart=miete&_objektart=wohnung&_zimmer=2,3&_wohnflaeche=45,70&_plz=1210,1220",
        "path": "*",
        "maintainers": [
          "sk22"
        ],
        "categories": [
          "other"
        ],
        "description": "\nCopy the query parameters for your https://www.bwsg.at/immobilien/immobilie-suchen\nsearch, omitting the leading `?`\n\n::: tip\nSince there's no parameter available that sorts by \"last added\" (and there's no\nobvious pattern to the default ordering), and since this RSS feed only fetches\nthe first page of results, you probably want to specify enough search\nparameters to make sure you only get one page of results – because else, your\nRSS feed might not get all items.\n:::",
        "location": "index.ts",
        "module": () => import('@/routes/bwsg/index.ts')
      }
    },
    "name": "BWSG",
    "apiRoutes": {},
    "url": "bwsg.at",
    "description": "BWS Gemeinnützige allgemeine Bau-, Wohn- und Siedlungsgenossenschaft, registrierte Genossenschaft mit beschränkter Haftung"
  },
  "byau": {
    "routes": {
      "/news/:type_id": {
        "path": "/news/:type_id",
        "categories": [
          "university"
        ],
        "example": "/byau/news/3674",
        "parameters": {
          "type_id": "栏目类型(从菜单栏获取对应 ID)"
        },
        "radar": [
          {
            "source": [
              "xinwen.byau.edu.cn/:type_id/list.htm"
            ],
            "target": "/news/:type_id"
          }
        ],
        "name": "新闻网",
        "maintainers": [
          "ueiu"
        ],
        "url": "xinwen.byau.edu.cn",
        "description": "| 学校要闻 | 校园动态 |\n| ---- | ----------- |\n| 3674 | 3676 |",
        "location": "xinwen/index.ts",
        "module": () => import('@/routes/byau/xinwen/index.ts')
      }
    },
    "name": "黑龙江八一农垦大学",
    "url": "byau.edu.cn",
    "lang": "zh-CN"
  },
  "byteclicks": {
    "routes": {
      "/": {
        "path": "/",
        "radar": [
          {
            "source": [
              "byteclicks.com/"
            ],
            "target": ""
          }
        ],
        "name": "Unknown",
        "maintainers": [
          "TonyRL"
        ],
        "url": "byteclicks.com/",
        "location": "index.ts",
        "module": () => import('@/routes/byteclicks/index.ts')
      },
      "/tag/:tag": {
        "path": "/tag/:tag",
        "categories": [
          "new-media"
        ],
        "example": "/byteclicks/tag/人工智能",
        "parameters": {
          "tag": "标签，可在URL中找到"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "byteclicks.com/tag/:tag"
            ]
          }
        ],
        "name": "标签",
        "maintainers": [
          "TonyRL"
        ],
        "url": "byteclicks.com/",
        "location": "tag.ts",
        "module": () => import('@/routes/byteclicks/tag.ts')
      }
    },
    "name": "字节点击",
    "apiRoutes": {},
    "url": "byteclicks.com",
    "lang": "zh-CN"
  },
  "bytes": {
    "routes": {
      "/": {
        "path": "/",
        "radar": [
          {
            "source": [
              "bytes.dev/archives",
              "bytes.dev/"
            ],
            "target": ""
          }
        ],
        "name": "Unknown",
        "maintainers": [
          "meixger"
        ],
        "url": "bytes.dev/archives",
        "location": "bytes.ts",
        "module": () => import('@/routes/bytes/bytes.ts')
      }
    },
    "name": "ui.dev",
    "apiRoutes": {},
    "url": "bytes.dev",
    "lang": "en"
  },
  "c114": {
    "routes": {
      "/roll/:original?": {
        "path": "/roll/:original?",
        "name": "滚动资讯",
        "url": "c114.com.cn",
        "maintainers": [
          "nczitzk"
        ],
        "example": "/c114/roll",
        "parameters": {
          "original": "只看原创，可选 true 和 false，默认为 false"
        },
        "description": "",
        "categories": [
          "new-media"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "c114.com.cn/news/roll.asp"
            ]
          }
        ],
        "location": "roll.ts",
        "module": () => import('@/routes/c114/roll.ts')
      }
    },
    "name": "C114 通信网",
    "url": "c114.com.cn",
    "categories": [
      "new-media"
    ],
    "description": "",
    "lang": "zh-CN"
  },
  "caai": {
    "routes": {
      "/:caty": {
        "path": "/:caty",
        "categories": [
          "study"
        ],
        "example": "/caai/45",
        "parameters": {
          "caty": "分类 ID，可在 URL 找到"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "学会动态",
        "maintainers": [
          "tudou027"
        ],
        "location": "index.ts",
        "module": () => import('@/routes/caai/index.ts')
      }
    },
    "name": "中国人工智能学会",
    "apiRoutes": {},
    "url": "caai.cn",
    "lang": "zh-CN"
  },
  "caam": {
    "routes": {
      "/:category?": {
        "path": "/:category?",
        "name": "Unknown",
        "maintainers": [
          "nczitzk"
        ],
        "location": "index.ts",
        "module": () => import('@/routes/caam/index.ts')
      }
    },
    "name": "中国汽车工业协会",
    "apiRoutes": {},
    "url": "caam.org.cn",
    "lang": "zh-CN"
  },
  "caareviews": {
    "routes": {
      "/book": {
        "path": "/book",
        "categories": [
          "journal"
        ],
        "example": "/caareviews/book",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "caareviews.org/reviews/book"
            ]
          }
        ],
        "name": "Book Reviews",
        "maintainers": [
          "Fatpandac"
        ],
        "url": "caareviews.org/reviews/book",
        "location": "book.ts",
        "module": () => import('@/routes/caareviews/book.ts')
      },
      "/essay": {
        "path": "/essay",
        "categories": [
          "journal"
        ],
        "example": "/caareviews/essay",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "caareviews.org/reviews/essay"
            ]
          }
        ],
        "name": "Essays",
        "maintainers": [
          "Fatpandac"
        ],
        "url": "caareviews.org/reviews/essay",
        "location": "essay.ts",
        "module": () => import('@/routes/caareviews/essay.ts')
      },
      "/exhibition": {
        "path": "/exhibition",
        "categories": [
          "journal"
        ],
        "example": "/caareviews/exhibition",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "caareviews.org/reviews/exhibition"
            ]
          }
        ],
        "name": "Exhibition Reviews",
        "maintainers": [
          "Fatpandac"
        ],
        "url": "caareviews.org/reviews/exhibition",
        "location": "exhibition.ts",
        "module": () => import('@/routes/caareviews/exhibition.ts')
      }
    },
    "name": "caa.reviews",
    "apiRoutes": {},
    "url": "caareviews.org",
    "lang": "en"
  },
  "cags": {
    "routes": {
      "/edu/:category": {
        "path": "/edu/:category",
        "categories": [
          "university"
        ],
        "example": "/cags/edu/tzgg",
        "parameters": {
          "category": "通知频道，可选 tzgg/ywjx/zs_bss/zs_sss/zs_dxsxly"
        },
        "features": {
          "antiCrawler": false,
          "requireConfig": false,
          "requirePuppeteer": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "研究生院",
        "maintainers": [
          "Chikit-L"
        ],
        "radar": [
          {
            "source": [
              "edu.cags.ac.cn/"
            ]
          }
        ],
        "description": "\n| 通知公告 | 要闻简讯 | 博士生招生 | 硕士生招生 | 大学生夏令营 |\n| -------- | -------- | ---------- | ---------- | ------------ |\n| tzgg     | ywjx     | zs_bss     | zs_sss     | zs_dxsxly    |\n",
        "location": "edu/index.ts",
        "module": () => import('@/routes/cags/edu/index.ts')
      }
    },
    "name": "Chinese Academy of Geological Sciences",
    "apiRoutes": {},
    "url": "cags.cgs.gov.cn",
    "zh": {
      "name": "中国地质科学院"
    }
  },
  "cahkms": {
    "routes": {
      "/:category?": {
        "path": "/:category?",
        "categories": [
          "new-media"
        ],
        "example": "/cahkms",
        "parameters": {
          "category": "分类，见下表，默认为重要新闻"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "cahkms.org/"
            ]
          }
        ],
        "name": "分类",
        "maintainers": [
          "nczitzk"
        ],
        "url": "cahkms.org/",
        "description": "| 关于我们 | 港澳新闻 | 重要新闻 | 顾问点评、会员观点 | 专题汇总 |\n| -------- | -------- | -------- | ------------------ | -------- |\n| 01       | 02       | 03       | 04                 | 05       |\n\n| 港澳时评 | 图片新闻 | 视频中心 | 港澳研究 | 最新书讯 | 研究资讯 |\n| -------- | -------- | -------- | -------- | -------- | -------- |\n| 06       | 07       | 08       | 09       | 10       | 11       |",
        "location": "index.tsx",
        "module": () => import('@/routes/cahkms/index.tsx')
      }
    },
    "name": "全国港澳研究会",
    "apiRoutes": {},
    "url": "cahkms.org",
    "lang": "zh-CN"
  },
  "caijing": {
    "routes": {
      "/roll": {
        "path": "/roll",
        "categories": [
          "finance"
        ],
        "example": "/caijing/roll",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "roll.caijing.com.cn/index1.html",
              "roll.caijing.com.cn/"
            ]
          }
        ],
        "name": "滚动新闻",
        "maintainers": [
          "TonyRL"
        ],
        "url": "roll.caijing.com.cn/index1.html",
        "location": "roll.ts",
        "module": () => import('@/routes/caijing/roll.ts')
      }
    },
    "name": "财经网",
    "url": "roll.caijing.com.cn",
    "lang": "zh-CN"
  },
  "caixin": {
    "routes": {
      "/article": {
        "path": "/article",
        "categories": [
          "traditional-media"
        ],
        "example": "/caixin/article",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": true,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "caixin.com/"
            ]
          }
        ],
        "name": "首页新闻",
        "maintainers": [
          "EsuRt"
        ],
        "url": "caixin.com/",
        "location": "article.ts",
        "module": () => import('@/routes/caixin/article.ts')
      },
      "/blog/:column?": {
        "path": "/blog/:column?",
        "categories": [
          "blog"
        ],
        "example": "/caixin/blog/zhangwuchang",
        "parameters": {
          "column": "博客名称，可在博客主页的 URL 找到"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "用户博客",
        "maintainers": [],
        "description": "通过提取文章全文，以提供比官方源更佳的阅读体验.",
        "location": "blog.ts",
        "module": () => import('@/routes/caixin/blog.ts')
      },
      "/:column/:category": {
        "path": "/:column/:category",
        "categories": [
          "traditional-media"
        ],
        "example": "/caixin/finance/regulation",
        "parameters": {
          "column": "栏目名",
          "category": "栏目下的子分类名"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": true,
          "supportScihub": false
        },
        "name": "新闻分类",
        "maintainers": [
          "idealclover"
        ],
        "description": "Column 列表：\n\n| 经济    | 金融    | 政经  | 环科    | 世界          | 观点网  | 文化    | 周刊   |\n| ------- | ------- | ----- | ------- | ------------- | ------- | ------- | ------ |\n| economy | finance | china | science | international | opinion | culture | weekly |\n\n  以金融板块为例的 category 列表：（其余 column 以类似方式寻找）\n\n| 监管       | 银行 | 证券基金 | 信托保险         | 投资       | 创新       | 市场   |\n| ---------- | ---- | -------- | ---------------- | ---------- | ---------- | ------ |\n| regulation | bank | stock    | insurance_trust | investment | innovation | market |\n\n  Category 列表：\n\n| 封面报道   | 开卷  | 社论      | 时事             | 编辑寄语     | 经济    | 金融    | 商业     | 环境与科技              | 民生    | 副刊   |\n| ---------- | ----- | --------- | ---------------- | ------------ | ------- | ------- | -------- | ----------------------- | ------- | ------ |\n| coverstory | first | editorial | current_affairs | editor_desk | economy | finance | business | environment_technology | cwcivil | column |",
        "location": "category.ts",
        "module": () => import('@/routes/caixin/category.ts')
      },
      "/database": {
        "path": "/database",
        "categories": [
          "traditional-media"
        ],
        "example": "/caixin/database",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "k.caixin.com/web",
              "k.caixin.com/"
            ]
          }
        ],
        "name": "财新数据通",
        "maintainers": [
          "nczitzk"
        ],
        "url": "k.caixin.com/web",
        "location": "database.ts",
        "module": () => import('@/routes/caixin/database.ts')
      },
      "/k": {
        "path": "/k",
        "categories": [
          "traditional-media"
        ],
        "example": "/caixin/k",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": true,
          "supportScihub": false
        },
        "name": "财新一线",
        "maintainers": [
          "boypt"
        ],
        "location": "k.ts",
        "module": () => import('@/routes/caixin/k.ts')
      },
      "/latest": {
        "path": "/latest",
        "categories": [
          "traditional-media"
        ],
        "view": 0,
        "example": "/caixin/latest",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "caixin.com/"
            ]
          }
        ],
        "name": "最新文章",
        "maintainers": [
          "tpnonthealps"
        ],
        "url": "caixin.com/",
        "description": "说明：此 RSS feed 会自动抓取财新网的最新文章，但不包含 FM 及视频内容。订阅用户可根据文档设置环境变量后，在url传入`fulltext=`以解锁全文。",
        "location": "latest.ts",
        "module": () => import('@/routes/caixin/latest.ts')
      },
      "/weekly": {
        "path": "/weekly",
        "categories": [
          "traditional-media"
        ],
        "example": "/caixin/weekly",
        "radar": [
          {
            "source": [
              "weekly.caixin.com/",
              "weekly.caixin.com/*"
            ]
          }
        ],
        "name": "财新周刊",
        "maintainers": [
          "TonyRL"
        ],
        "url": "weekly.caixin.com/",
        "location": "weekly.ts",
        "module": () => import('@/routes/caixin/weekly.ts')
      }
    },
    "name": "财新博客",
    "apiRoutes": {},
    "url": "caixin.com",
    "description": "> 网站部分内容需要付费订阅，RSS 仅做更新提醒，不含付费内容。若需要得到付费内容全文，请使用订阅账户在手机网页版登录，然后设置`CAIXIN_COOKIE`为至少包含cookie中的以下字段: `SA_USER_UID`, `SA_USER_UNIT`, `SA_USER_DEVICE_TYPE`, `USER_LOGIN_CODE`",
    "lang": "zh-CN"
  },
  "caixinglobal": {
    "routes": {
      "/latest": {
        "path": "/latest",
        "categories": [
          "traditional-media"
        ],
        "example": "/caixinglobal/latest",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "caixinglobal.com/news",
              "caixinglobal.com/"
            ]
          }
        ],
        "name": "Latest News",
        "maintainers": [
          "TonyRL"
        ],
        "url": "caixinglobal.com/news",
        "location": "latest.ts",
        "module": () => import('@/routes/caixinglobal/latest.ts')
      }
    },
    "name": "Caixin Global",
    "apiRoutes": {},
    "url": "caixinglobal.com",
    "lang": "en"
  },
  "camchina": {
    "routes": {
      "/:id?": {
        "path": "/:id?",
        "categories": [
          "study"
        ],
        "example": "/camchina",
        "parameters": {
          "id": "分类，见下表，默认为 1，即新闻"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "cste.org.cn/categories/:id",
              "cste.org.cn/"
            ]
          }
        ],
        "name": "栏目",
        "maintainers": [
          "nczitzk"
        ],
        "description": "| 新闻 | 通告栏 |\n| ---- | ------ |\n| 1    | 2      |",
        "location": "index.ts",
        "module": () => import('@/routes/camchina/index.ts')
      }
    },
    "name": "中国管理现代化研究会",
    "apiRoutes": {},
    "url": "cste.org.cn",
    "lang": "zh-CN"
  },
  "canada.ca": {
    "routes": {
      "/news/:lang/:department?": {
        "path": "/news/:lang/:department?",
        "categories": [
          "government"
        ],
        "example": "/canada.ca/news/en/departmentfinance",
        "parameters": {
          "lang": "Language, en or fr",
          "department": "dprtmnt query value"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.canada.ca/:lang/department-finance.html",
              "www.canada.ca/:lang/ministere-finances.html",
              "www.canada.ca/:lang/department-finance/news/*",
              "www.canada.ca/:lang/ministere-finances/nouvelles/*"
            ],
            "target": "/news/:lang/departmentfinance"
          },
          {
            "source": [
              "ised-isde.canada.ca/site/ised/:lang",
              "ised-isde.canada.ca/site/isde/:lang",
              "www.canada.ca/:lang/innovation-science-economic-development/news/*",
              "www.canada.ca/:lang/innovation-sciences-developpement-economique/nouvelles/*"
            ],
            "target": "/news/:lang/departmentofindustry"
          },
          {
            "source": [
              "www.canada.ca/:lang/news/advanced-news-search/news-results.html",
              "www.canada.ca/:lang/nouvelles/recherche-avancee-de-nouvelles/resultats-de-nouvelles.html"
            ],
            "target": "/news/:lang"
          }
        ],
        "name": "News by Department",
        "maintainers": [
          "elibroftw"
        ],
        "description": "News from specific Canadian government departments",
        "location": "news.ts",
        "module": () => import('@/routes/canada.ca/news.ts')
      }
    },
    "name": "Canada.ca",
    "url": "www.canada.ca",
    "description": "Government of Canada news by department",
    "lang": "en"
  },
  "cankaoxiaoxi": {
    "routes": {
      "/column/:id?": {
        "path": [
          "/column/:id?",
          "/:id?"
        ],
        "categories": [
          "traditional-media"
        ],
        "example": "/cankaoxiaoxi/column/diyi",
        "parameters": {
          "id": "栏目 id，默认为 `diyi`，即第一关注"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "栏目",
        "maintainers": [
          "yuxinliu-alex",
          "nczitzk"
        ],
        "description": "| 栏目           | id       |\n| -------------- | -------- |\n| 第一关注       | diyi     |\n| 中国           | zhongguo |\n| 国际           | gj       |\n| 观点           | guandian |\n| 锐参考         | ruick    |\n| 体育健康       | tiyujk   |\n| 科技应用       | kejiyy   |\n| 文化旅游       | wenhualy |\n| 参考漫谈       | cankaomt |\n| 研究动态       | yjdt     |\n| 海外智库       | hwzk     |\n| 业界信息・观点 | yjxx     |\n| 海外看中国城市 | hwkzgcs  |\n| 译名趣谈       | ymymqt   |\n| 译名发布       | ymymfb   |\n| 双语汇         | ymsyh    |\n| 参考视频       | video    |\n| 军事           | junshi   |\n| 参考人物       | cankaorw |",
        "location": "index.tsx",
        "module": () => import('@/routes/cankaoxiaoxi/index.tsx')
      },
      "/:id?": {
        "path": [
          "/column/:id?",
          "/:id?"
        ],
        "categories": [
          "traditional-media"
        ],
        "example": "/cankaoxiaoxi/column/diyi",
        "parameters": {
          "id": "栏目 id，默认为 `diyi`，即第一关注"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "栏目",
        "maintainers": [
          "yuxinliu-alex",
          "nczitzk"
        ],
        "description": "| 栏目           | id       |\n| -------------- | -------- |\n| 第一关注       | diyi     |\n| 中国           | zhongguo |\n| 国际           | gj       |\n| 观点           | guandian |\n| 锐参考         | ruick    |\n| 体育健康       | tiyujk   |\n| 科技应用       | kejiyy   |\n| 文化旅游       | wenhualy |\n| 参考漫谈       | cankaomt |\n| 研究动态       | yjdt     |\n| 海外智库       | hwzk     |\n| 业界信息・观点 | yjxx     |\n| 海外看中国城市 | hwkzgcs  |\n| 译名趣谈       | ymymqt   |\n| 译名发布       | ymymfb   |\n| 双语汇         | ymsyh    |\n| 参考视频       | video    |\n| 军事           | junshi   |\n| 参考人物       | cankaorw |",
        "location": "index.tsx",
        "module": () => import('@/routes/cankaoxiaoxi/index.tsx')
      }
    },
    "name": "参考消息",
    "apiRoutes": {},
    "url": "cankaoxiaoxi.com",
    "lang": "zh-CN"
  },
  "capitalmind": {
    "routes": {
      "/insights": {
        "path": "/insights",
        "example": "/capitalmind/insights",
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "capitalmind.in/insights"
            ],
            "target": "/insights"
          }
        ],
        "name": "Insights",
        "maintainers": [
          "Rjnishant530"
        ],
        "location": "insights.ts",
        "module": () => import('@/routes/capitalmind/insights.ts')
      },
      "/podcasts": {
        "path": "/podcasts",
        "example": "/capitalmind/podcasts",
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": true,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "capitalmind.in/podcasts"
            ],
            "target": "/podcasts"
          }
        ],
        "name": "Podcasts",
        "maintainers": [
          "Rjnishant530"
        ],
        "location": "podcasts.ts",
        "module": () => import('@/routes/capitalmind/podcasts.ts')
      }
    },
    "name": "Capitalmind",
    "apiRoutes": {},
    "url": "capitalmind.in",
    "lang": "en",
    "categories": [
      "finance"
    ]
  },
  "cara": {
    "routes": {
      "/likes/:user": {
        "path": [
          "/likes/:user"
        ],
        "categories": [
          "social-media"
        ],
        "example": "/cara/likes/fengz",
        "parameters": {
          "user": "username"
        },
        "name": "Likes",
        "maintainers": [
          "KarasuShin"
        ],
        "radar": [
          {
            "source": [
              "cara.app/:user",
              "cara.app/:user/*"
            ],
            "target": "/likes/:user"
          }
        ],
        "location": "likes.ts",
        "module": () => import('@/routes/cara/likes.ts')
      },
      "/portfolio/:user": {
        "path": [
          "/portfolio/:user"
        ],
        "categories": [
          "social-media"
        ],
        "example": "/cara/portfolio/fengz",
        "parameters": {
          "user": "username"
        },
        "name": "Portfolio",
        "maintainers": [
          "KarasuShin"
        ],
        "radar": [
          {
            "source": [
              "cara.app/:user",
              "cara.app/:user/*"
            ],
            "target": "/portfolio/:user"
          }
        ],
        "location": "portfolio.ts",
        "module": () => import('@/routes/cara/portfolio.ts')
      },
      "/timeline/:user": {
        "path": [
          "/timeline/:user"
        ],
        "categories": [
          "social-media"
        ],
        "example": "/cara/timeline/fengz",
        "parameters": {
          "user": "username"
        },
        "name": "Timeline",
        "maintainers": [
          "KarasuShin"
        ],
        "radar": [
          {
            "source": [
              "cara.app/:user",
              "cara.app/:user/*"
            ],
            "target": "/timeline/:user"
          }
        ],
        "location": "timeline.ts",
        "module": () => import('@/routes/cara/timeline.ts')
      }
    },
    "name": "Cara",
    "apiRoutes": {},
    "url": "cara.app",
    "lang": "en"
  },
  "carousell": {
    "routes": {
      "/:region/:keyword": {
        "path": "/:region/:keyword",
        "categories": [
          "shopping"
        ],
        "example": "/carousell/sg/iphone",
        "parameters": {
          "region": {
            "description": "Region code",
            "options": [
              {
                "value": "au",
                "label": "Australia"
              },
              {
                "value": "ca",
                "label": "Canada"
              },
              {
                "value": "hk",
                "label": "Hong Kong"
              },
              {
                "value": "id",
                "label": "Indonesia"
              },
              {
                "value": "my",
                "label": "Malaysia"
              },
              {
                "value": "nz",
                "label": "New Zealand"
              },
              {
                "value": "ph",
                "label": "Philippines"
              },
              {
                "value": "sg",
                "label": "Singapore"
              },
              {
                "value": "tw",
                "label": "Taiwan"
              }
            ]
          },
          "keyword": {
            "description": "Search keyword"
          }
        },
        "name": "Keyword Search",
        "maintainers": [
          "TonyRL"
        ],
        "radar": [
          {
            "source": [
              "au.carousell.com/search/:keyword"
            ],
            "target": "/au/:keyword"
          },
          {
            "source": [
              "ca.carousell.com/search/:keyword"
            ],
            "target": "/ca/:keyword"
          },
          {
            "source": [
              "www.carousell.com.hk/search/:keyword"
            ],
            "target": "/hk/:keyword"
          },
          {
            "source": [
              "id.carousell.com/search/:keyword"
            ],
            "target": "/id/:keyword"
          },
          {
            "source": [
              "www.carousell.com.my/search/:keyword"
            ],
            "target": "/my/:keyword"
          },
          {
            "source": [
              "nz.carousell.com/search/:keyword"
            ],
            "target": "/nz/:keyword"
          },
          {
            "source": [
              "www.carousell.ph/search/:keyword"
            ],
            "target": "/ph/:keyword"
          },
          {
            "source": [
              "www.carousell.sg/search/:keyword"
            ],
            "target": "/sg/:keyword"
          },
          {
            "source": [
              "tw.carousell.com/search/:keyword"
            ],
            "target": "/tw/:keyword"
          }
        ],
        "location": "index.ts",
        "module": () => import('@/routes/carousell/index.ts')
      }
    },
    "name": "Carousell",
    "apiRoutes": {},
    "url": "carousell.com",
    "lang": "en"
  },
  "cartoonmad": {
    "routes": {
      "/comic/:id": {
        "path": "/comic/:id",
        "categories": [
          "anime"
        ],
        "example": "/cartoonmad/comic/5827",
        "parameters": {
          "id": "漫画ID"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "cartoonmad.com/comic/:id"
            ]
          }
        ],
        "name": "漫画更新",
        "maintainers": [
          "KellyHwong"
        ],
        "location": "comic.tsx",
        "module": () => import('@/routes/cartoonmad/comic.tsx')
      }
    },
    "name": "動漫狂",
    "apiRoutes": {},
    "url": "cartoonmad.com",
    "lang": "zh-TW"
  },
  "cas": {
    "routes": {
      "/cg/:caty?": {
        "path": "/cg/:caty?",
        "categories": [
          "university"
        ],
        "example": "/cas/cg/cgzhld",
        "parameters": {
          "caty": "分类，见下表，默认为工作动态"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.cas.cn/cg/:caty?"
            ]
          }
        ],
        "name": "成果转化",
        "maintainers": [
          "nczitzk"
        ],
        "description": "| 工作动态 | 科技成果转移转化亮点工作 |\n| -------- | ------------------------ |\n| zh       | cgzhld                   |",
        "location": "cg/index.ts",
        "module": () => import('@/routes/cas/cg/index.ts')
      },
      "/genetics/:path{.+}": {
        "path": "/genetics/:path{.+}",
        "name": "Unknown",
        "maintainers": [],
        "location": "genetics/index.ts",
        "module": () => import('@/routes/cas/genetics/index.ts')
      },
      "/ia/yjs": {
        "path": "/ia/yjs",
        "categories": [
          "university"
        ],
        "example": "/cas/ia/yjs",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.ia.cas.cn/yjsjy/zs/sszs",
              "www.ia.cas.cn/"
            ]
          }
        ],
        "name": "自动化所",
        "maintainers": [
          "shengmaosu"
        ],
        "url": "www.ia.cas.cn/yjsjy/zs/sszs",
        "location": "ia/yjs.ts",
        "module": () => import('@/routes/cas/ia/yjs.ts')
      },
      "/iee/kydt": {
        "path": "/iee/kydt",
        "categories": [
          "university"
        ],
        "example": "/cas/iee/kydt",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.iee.cas.cn/xwzx/kydt",
              "www.iee.cas.cn/"
            ]
          }
        ],
        "name": "电工研究所 科研动态",
        "maintainers": [
          "nczitzk"
        ],
        "url": "www.iee.cas.cn/xwzx/kydt",
        "location": "iee/kydt.ts",
        "module": () => import('@/routes/cas/iee/kydt.ts')
      },
      "/is/:path{.+}": {
        "path": "/is/:path{.+}",
        "name": "Unknown",
        "maintainers": [],
        "location": "is/index.ts",
        "module": () => import('@/routes/cas/is/index.ts')
      },
      "/mesalab/kb": {
        "path": "/mesalab/kb",
        "categories": [
          "university"
        ],
        "example": "/cas/mesalab/kb",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.mesalab.cn/f/article/articleList",
              "www.mesalab.cn/"
            ]
          }
        ],
        "name": "信息工程研究所 第二研究室 处理架构组 知识库",
        "maintainers": [
          "renzhexigua"
        ],
        "url": "www.mesalab.cn/f/article/articleList",
        "location": "mesalab/kb.ts",
        "module": () => import('@/routes/cas/mesalab/kb.ts')
      },
      "/sim/kyjz": {
        "path": "/sim/kyjz",
        "categories": [
          "university"
        ],
        "example": "/cas/sim/kyjz",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.sim.cas.cn/xwzx2016/kyjz",
              "www.sim.cas.cn/"
            ]
          }
        ],
        "name": "上海微系统与信息技术研究所 科技进展",
        "maintainers": [
          "HenryQW"
        ],
        "url": "www.sim.cas.cn/xwzx2016/kyjz",
        "location": "sim/kyjz.ts",
        "module": () => import('@/routes/cas/sim/kyjz.ts')
      }
    },
    "name": "中国科学院",
    "apiRoutes": {},
    "url": "www.cas.cn",
    "lang": "zh-CN"
  },
  "casssp": {
    "routes": {
      "/news/:category?": {
        "path": "/news/:category?",
        "categories": [
          "government"
        ],
        "example": "/casssp/news/3",
        "parameters": {
          "category": "分类，见下表，默认为通知公告"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "研究会动态",
        "maintainers": [
          "nczitzk"
        ],
        "description": "| 通知公告 | 新闻动态 | 信息公开 | 时政要闻 |\n| -------- | -------- | -------- | -------- |\n| 3        | 2        | 92       | 93       |",
        "location": "news.ts",
        "module": () => import('@/routes/casssp/news.ts')
      }
    },
    "name": "中国科学学与科技政策研究会",
    "url": "casssp.org.cn",
    "lang": "zh-CN"
  },
  "cast": {
    "routes": {
      "/:column/:subColumn/:category?": {
        "path": "/:column/:subColumn/:category?",
        "categories": [
          "government"
        ],
        "example": "/cast/xw/tzgg/ZH",
        "parameters": {
          "column": "栏目编号，见下表",
          "subColumn": "二级栏目编号",
          "category": "分类"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "cast.org.cn/:column/:subColumn/:category/index.html",
              "cast.org.cn/:column/:subColumn/index.html"
            ],
            "target": "/:column/:subColumn/:category?"
          }
        ],
        "name": "通用",
        "maintainers": [
          "KarasuShin",
          "TonyRL"
        ],
        "description": "::: tip\n  在路由末尾处加上 `?limit=限制获取数目` 来限制获取条目数量，默认值为`10`\n:::\n\n| 分类     | 编码 |\n| -------- | ---- |\n| 全景科协 | qjkx |\n| 智库     | zk   |\n| 学术     | xs   |\n| 科普     | kp   |\n| 党建     | dj   |\n| 数据     | sj   |\n| 新闻     | xw   |",
        "location": "index.ts",
        "module": () => import('@/routes/cast/index.ts')
      }
    },
    "name": "中国科学技术协会",
    "apiRoutes": {},
    "url": "cast.org.cn",
    "lang": "zh-CN"
  },
  "catti": {
    "routes": {
      "/news/:category": {
        "path": "/news/:category",
        "name": "CATTI 考试消息",
        "maintainers": [
          "PrinOrange"
        ],
        "description": "\n| Category  | 标题       | 描述                |\n|-----------|------------|--------------------|\n| ggl       | 通知公告   | CATTI 考试通知和公告 |\n| ywdt      | 要闻动态   | CATTI 考试要闻动态   |\n| zxzc      | 最新政策   | CATTI 考试最新政策   |\n",
        "categories": [
          "study"
        ],
        "parameters": {
          "category": "消息分类名，可在下面的描述中找到。"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false,
          "supportRadar": true
        },
        "example": "/catti/news/zxzc",
        "radar": [
          {
            "source": [
              "www.catticenter.com/:category"
            ]
          }
        ],
        "location": "news.ts",
        "module": () => import('@/routes/catti/news.ts')
      }
    },
    "name": "全国翻译专业资格水平考试 (CATTI)",
    "url": "www.catticenter.com"
  },
  "cau": {
    "routes": {
      "/ele": {
        "path": "/ele",
        "categories": [
          "university"
        ],
        "example": "/cau/ele",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "ciee.cau.edu.cn/col/col26712/index.html",
              "ciee.cau.edu.cn/"
            ]
          }
        ],
        "name": "研招网通知公告",
        "maintainers": [
          "shengmaosu"
        ],
        "url": "ciee.cau.edu.cn/col/col26712/index.html",
        "description": "#### 信电学院 {#zhong-guo-nong-ye-da-xue-yan-zhao-wang-tong-zhi-gong-gao-xin-dian-xue-yuan}",
        "location": "ele.ts",
        "module": () => import('@/routes/cau/ele.ts')
      },
      "/yjs": {
        "path": "/yjs",
        "categories": [
          "university"
        ],
        "example": "/cau/yjs",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "yz.cau.edu.cn/col/col41740/index.html",
              "yz.cau.edu.cn/"
            ]
          }
        ],
        "name": "研招网通知公告",
        "maintainers": [
          "shengmaosu"
        ],
        "url": "yz.cau.edu.cn/col/col41740/index.html",
        "location": "yjs.ts",
        "module": () => import('@/routes/cau/yjs.ts')
      }
    },
    "name": "中国农业大学",
    "apiRoutes": {},
    "url": "ciee.cau.edu.cn",
    "lang": "zh-CN"
  },
  "caus": {
    "routes": {
      "/:category?": {
        "path": "/:category?",
        "categories": [
          "new-media"
        ],
        "example": "/caus",
        "parameters": {
          "category": "分类，见下表，默认为全部"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "分类",
        "maintainers": [
          "nczitzk"
        ],
        "description": "| 全部 | 要闻 | 商业 | 快讯 | 财富 | 生活 |\n| ---- | ---- | ---- | ---- | ---- | ---- |\n| 0    | 1    | 2    | 3    | 8    | 6    |",
        "location": "index.ts",
        "module": () => import('@/routes/caus/index.ts')
      }
    },
    "name": "加美财经",
    "apiRoutes": {},
    "url": "caus.com",
    "lang": "zh-CN"
  },
  "cbaigui": {
    "routes": {
      "*": {
        "path": "*",
        "name": "Unknown",
        "maintainers": [],
        "location": "index.ts",
        "module": () => import('@/routes/cbaigui/index.ts')
      }
    },
    "name": "纪妖",
    "apiRoutes": {},
    "url": "cbaigui.com",
    "lang": "zh-CN"
  },
  "cbc": {
    "routes": {
      "/topics/:topic?": {
        "path": "/topics/:topic?",
        "categories": [
          "traditional-media"
        ],
        "example": "/cbc/topics",
        "parameters": {
          "topic": "Channel,`Top Stories` by default. For secondary channel like `canada/toronto`, use `-` to replace `/`"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "cbc.ca/news"
            ],
            "target": "/topics"
          }
        ],
        "name": "News",
        "maintainers": [
          "wb14123"
        ],
        "url": "cbc.ca/news",
        "location": "topics.ts",
        "module": () => import('@/routes/cbc/topics.ts')
      }
    },
    "name": "Canadian Broadcasting Corporation",
    "url": "cbc.ca",
    "lang": "en"
  },
  "cbirc": {
    "routes": {
      "/:category?": {
        "path": "/:category?",
        "radar": [
          {
            "source": [
              "cbirc.gov.cn/:category",
              "cbirc.gov.cn/"
            ]
          }
        ],
        "name": "Unknown",
        "maintainers": [
          "JkCheung"
        ],
        "location": "index.ts",
        "module": () => import('@/routes/cbirc/index.ts')
      }
    },
    "name": "中国银行保险监督管理委员会",
    "apiRoutes": {},
    "url": "cbirc.gov.cn",
    "lang": "zh-CN"
  },
  "cbndata": {
    "routes": {
      "/information/:id?": {
        "path": "/information/:id?",
        "name": "看点",
        "url": "www.cbndata.com",
        "maintainers": [
          "nczitzk"
        ],
        "example": "/cbndata/information/all",
        "parameters": {
          "id": {
            "description": "分类，默认为 `all`，即全部，可在对应分类页 URL 中找到",
            "options": [
              {
                "label": "全部",
                "value": "all"
              },
              {
                "label": "美妆个护",
                "value": "1"
              },
              {
                "label": "服饰鞋包",
                "value": "2559"
              },
              {
                "label": "宠物",
                "value": "2419"
              },
              {
                "label": "营销",
                "value": "2484"
              }
            ]
          }
        },
        "description": "::: tip\n订阅 [美妆个护](https://www.cbndata.com/information?tag_id=1)，其源网址为 `https://www.cbndata.com/information?tag_id=1`，请参考该 URL 指定部分构成参数，此时路由为 [`/cbndata/information/1`](https://rsshub.app/cbndata/information/1)。\n:::\n\n| 分类                                                        | ID                                                  |\n| ----------------------------------------------------------- | --------------------------------------------------- |\n| [全部](https://www.cbndata.com/information?tag_id=all)      | [all](https://rsshub.app/cbndata/information/all)   |\n| [美妆个护](https://www.cbndata.com/information?tag_id=1)    | [1](https://rsshub.app/cbndata/information/1)       |\n| [服饰鞋包](https://www.cbndata.com/information?tag_id=2559) | [2559](https://rsshub.app/cbndata/information/2559) |\n| [宠物](https://www.cbndata.com/information?tag_id=2419)     | [2419](https://rsshub.app/cbndata/information/2419) |\n| [营销](https://www.cbndata.com/information?tag_id=2484)     | [2484](https://rsshub.app/cbndata/information/2484) |\n",
        "categories": [
          "new-media"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.cbndata.com/information"
            ]
          },
          {
            "title": "全部",
            "source": [
              "www.cbndata.com/information"
            ],
            "target": "/information/all"
          },
          {
            "title": "美妆个护",
            "source": [
              "www.cbndata.com/information"
            ],
            "target": "/information/1"
          },
          {
            "title": "服饰鞋包",
            "source": [
              "www.cbndata.com/information"
            ],
            "target": "/information/2559"
          },
          {
            "title": "宠物",
            "source": [
              "www.cbndata.com/information"
            ],
            "target": "/information/2419"
          },
          {
            "title": "营销",
            "source": [
              "www.cbndata.com/information"
            ],
            "target": "/information/2484"
          }
        ],
        "view": 0,
        "location": "information.ts",
        "module": () => import('@/routes/cbndata/information.ts')
      }
    },
    "name": "CBNData",
    "apiRoutes": {},
    "url": "cbndata.com",
    "categories": [
      "new-media"
    ],
    "description": "第一财经商业数据中心（CBNData）",
    "lang": "zh-CN"
  },
  "cbnweek": {
    "routes": {
      "/": {
        "path": "/",
        "radar": [
          {
            "source": [
              "cbnweek.com/"
            ],
            "target": ""
          }
        ],
        "name": "Unknown",
        "maintainers": [
          "nczitzk"
        ],
        "url": "cbnweek.com/",
        "location": "index.ts",
        "module": () => import('@/routes/cbnweek/index.ts')
      }
    },
    "name": "第一财经杂志",
    "apiRoutes": {},
    "url": "cbnweek.com",
    "lang": "zh-CN"
  },
  "cbpanet": {
    "routes": {
      "/dzp_news/:bigId?/:smallId?": {
        "path": "/dzp_news/:bigId?/:smallId?",
        "name": "资讯",
        "url": "cbpanet.com",
        "maintainers": [
          "nczitzk"
        ],
        "example": "/cbpanet/dzp_news/2/11",
        "parameters": {
          "bigId": "分类 id，默认为 `2`，即行业资讯，可在对应分类页 URL 中找到",
          "smallId": "子分类 id，默认为 `11`，即行业资讯，可在对应分类页 URL 中找到"
        },
        "description": "::: tip\n  若订阅 [行业资讯](https://www.cbpanet.com/dzp_news.aspx?bigid=2&smallid=11)，网址为 `https://www.cbpanet.com/dzp_news.aspx?bigid=2&smallid=11`。截取 `https://www.cbpanet.com/` 的 `bigid` 和 `smallid` 的部分作为参数填入，此时路由为 [`/cbpanet/dzp_news/4/15`](https://rsshub.app/cbpanet/dzp_news/4/15)。\n:::\n\n<details>\n<summary>更多分类</summary>\n\n#### [协会](https://www.cbpanet.com/dzp_xiehui.aspx)\n\n| [协会介绍](https://www.cbpanet.com/dzp_news.aspx?bigid=1&smallid=1) | [协会章程](https://www.cbpanet.com/dzp_news.aspx?bigid=1&smallid=2) | [理事会](https://www.cbpanet.com/dzp_news.aspx?bigid=1&smallid=3) | [内设机构](https://www.cbpanet.com/dzp_news.aspx?bigid=1&smallid=4) | [协会通知](https://www.cbpanet.com/dzp_news.aspx?bigid=1&smallid=5) | [协会活动](https://www.cbpanet.com/dzp_news.aspx?bigid=1&smallid=6) |\n| ------------------------------------------------------------------ | ------------------------------------------------------------------ | ---------------------------------------------------------------- | ------------------------------------------------------------------ | ------------------------------------------------------------------ | ------------------------------------------------------------------ |\n| [1/1](https://rsshub.app/cbpanet/dzp_news/1/1)                     | [1/2](https://rsshub.app/cbpanet/dzp_news/1/2)                     | [1/3](https://rsshub.app/cbpanet/dzp_news/1/3)                   | [1/4](https://rsshub.app/cbpanet/dzp_news/1/4)                     | [1/5](https://rsshub.app/cbpanet/dzp_news/1/5)                     | [1/6](https://rsshub.app/cbpanet/dzp_news/1/6)                     |\n\n| [出版物](https://www.cbpanet.com/dzp_news.aspx?bigid=1&smallid=7) | [会员权利与义务](https://www.cbpanet.com/dzp_news.aspx?bigid=1&smallid=30) |\n| ---------------------------------------------------------------- | ------------------------------------------------------------------------- |\n| [1/7](https://rsshub.app/cbpanet/dzp_news/1/7)                   | [1/30](https://rsshub.app/cbpanet/dzp_news/1/30)                          |\n\n#### [行业资讯](https://www.cbpanet.com/dzp_news_list.aspx)\n\n| [国内资讯](https://www.cbpanet.com/dzp_news.aspx?bigid=2&smallid=8) | [海外资讯](https://www.cbpanet.com/dzp_news.aspx?bigid=2&smallid=9) | [企业新闻](https://www.cbpanet.com/dzp_news.aspx?bigid=2&smallid=10) | [行业资讯](https://www.cbpanet.com/dzp_news.aspx?bigid=2&smallid=11) | [热点聚焦](https://www.cbpanet.com/dzp_news.aspx?bigid=2&smallid=43) | [今日推荐](https://www.cbpanet.com/dzp_news.aspx?bigid=2&smallid=44) |\n| ------------------------------------------------------------------ | ------------------------------------------------------------------ | ------------------------------------------------------------------- | ------------------------------------------------------------------- | ------------------------------------------------------------------- | ------------------------------------------------------------------- |\n| [2/8](https://rsshub.app/cbpanet/dzp_news/2/8)                     | [2/9](https://rsshub.app/cbpanet/dzp_news/2/9)                     | [2/10](https://rsshub.app/cbpanet/dzp_news/2/10)                    | [2/11](https://rsshub.app/cbpanet/dzp_news/2/11)                    | [2/43](https://rsshub.app/cbpanet/dzp_news/2/43)                    | [2/44](https://rsshub.app/cbpanet/dzp_news/2/44)                    |\n\n#### [原料信息](https://www.cbpanet.com/dzp_yuanliao.aspx)\n\n| [价格行情](https://www.cbpanet.com/dzp_news.aspx?bigid=3&smallid=12) | [分析预测](https://www.cbpanet.com/dzp_news.aspx?bigid=3&smallid=13) | [原料信息](https://www.cbpanet.com/dzp_news.aspx?bigid=3&smallid=40) | [热点聚焦](https://www.cbpanet.com/dzp_news.aspx?bigid=3&smallid=45) |\n| ------------------------------------------------------------------- | ------------------------------------------------------------------- | ------------------------------------------------------------------- | ------------------------------------------------------------------- |\n| [3/12](https://rsshub.app/cbpanet/dzp_news/3/12)                    | [3/13](https://rsshub.app/cbpanet/dzp_news/3/13)                    | [3/40](https://rsshub.app/cbpanet/dzp_news/3/40)                    | [3/45](https://rsshub.app/cbpanet/dzp_news/3/45)                    |\n\n#### [法规标准](https://www.cbpanet.com/dzp_fagui.aspx)\n\n| [法规资讯](https://www.cbpanet.com/dzp_news.aspx?bigid=4&smallid=15) | [法律法规](https://www.cbpanet.com/dzp_news.aspx?bigid=4&smallid=16) | [国内标准](https://www.cbpanet.com/dzp_news.aspx?bigid=4&smallid=14) | [国外标准](https://www.cbpanet.com/dzp_news.aspx?bigid=4&smallid=17) | [法规聚焦](https://www.cbpanet.com/dzp_news.aspx?bigid=4&smallid=46) | [今日推荐](https://www.cbpanet.com/dzp_news.aspx?bigid=4&smallid=47) |\n| ------------------------------------------------------------------- | ------------------------------------------------------------------- | ------------------------------------------------------------------- | ------------------------------------------------------------------- | ------------------------------------------------------------------- | ------------------------------------------------------------------- |\n| [4/15](https://rsshub.app/cbpanet/dzp_news/4/15)                    | [4/16](https://rsshub.app/cbpanet/dzp_news/4/16)                    | [4/14](https://rsshub.app/cbpanet/dzp_news/4/14)                    | [4/17](https://rsshub.app/cbpanet/dzp_news/4/17)                    | [4/46](https://rsshub.app/cbpanet/dzp_news/4/46)                    | [4/47](https://rsshub.app/cbpanet/dzp_news/4/47)                    |\n\n#### [技术专区](https://www.cbpanet.com/dzp_jishu.aspx)\n\n| [产品介绍](https://www.cbpanet.com/dzp_news.aspx?bigid=5&smallid=18) | [科技成果](https://www.cbpanet.com/dzp_news.aspx?bigid=5&smallid=19) | [学术论文](https://www.cbpanet.com/dzp_news.aspx?bigid=5&smallid=20) | [资料下载](https://www.cbpanet.com/dzp_news.aspx?bigid=5&smallid=21) | [专家](https://www.cbpanet.com/dzp_news.aspx?bigid=5&smallid=50) | [民间智库](https://www.cbpanet.com/dzp_news.aspx?bigid=5&smallid=57) |\n| ------------------------------------------------------------------- | ------------------------------------------------------------------- | ------------------------------------------------------------------- | ------------------------------------------------------------------- | --------------------------------------------------------------- | ------------------------------------------------------------------- |\n| [5/18](https://rsshub.app/cbpanet/dzp_news/5/18)                    | [5/19](https://rsshub.app/cbpanet/dzp_news/5/19)                    | [5/20](https://rsshub.app/cbpanet/dzp_news/5/20)                    | [5/21](https://rsshub.app/cbpanet/dzp_news/5/21)                    | [5/50](https://rsshub.app/cbpanet/dzp_news/5/50)                | [5/57](https://rsshub.app/cbpanet/dzp_news/5/57)                    |\n\n#### [豆制品消费指南](https://www.cbpanet.com/dzp_zhinan.aspx)\n\n| [膳食指南](https://www.cbpanet.com/dzp_news.aspx?bigid=6&smallid=22) | [营养成分](https://www.cbpanet.com/dzp_news.aspx?bigid=6&smallid=23) | [豆食菜谱](https://www.cbpanet.com/dzp_news.aspx?bigid=6&smallid=24) | [问与答](https://www.cbpanet.com/dzp_news.aspx?bigid=6&smallid=31) | [今日推荐](https://www.cbpanet.com/dzp_news.aspx?bigid=6&smallid=48) | [消费热点](https://www.cbpanet.com/dzp_news.aspx?bigid=6&smallid=53) |\n| ------------------------------------------------------------------- | ------------------------------------------------------------------- | ------------------------------------------------------------------- | ----------------------------------------------------------------- | ------------------------------------------------------------------- | ------------------------------------------------------------------- |\n| [6/22](https://rsshub.app/cbpanet/dzp_news/6/22)                    | [6/23](https://rsshub.app/cbpanet/dzp_news/6/23)                    | [6/24](https://rsshub.app/cbpanet/dzp_news/6/24)                    | [6/31](https://rsshub.app/cbpanet/dzp_news/6/31)                  | [6/48](https://rsshub.app/cbpanet/dzp_news/6/48)                    | [6/53](https://rsshub.app/cbpanet/dzp_news/6/53)                    |\n\n#### [营养与健康](https://www.cbpanet.com/dzp_yingyang.aspx)\n\n| [大豆营养概况](https://www.cbpanet.com/dzp_news.aspx?bigid=7&smallid=25) | [大豆食品和人类健康](https://www.cbpanet.com/dzp_news.aspx?bigid=7&smallid=26) | [世界豆类日，爱豆大行动](https://www.cbpanet.com/dzp_news.aspx?bigid=7&smallid=27) | [谣言粉碎机](https://www.cbpanet.com/dzp_news.aspx?bigid=7&smallid=29) | [最新资讯](https://www.cbpanet.com/dzp_news.aspx?bigid=7&smallid=41) | [专家视点](https://www.cbpanet.com/dzp_news.aspx?bigid=7&smallid=49) |\n| ----------------------------------------------------------------------- | ----------------------------------------------------------------------------- | --------------------------------------------------------------------------------- | --------------------------------------------------------------------- | ------------------------------------------------------------------- | ------------------------------------------------------------------- |\n| [7/25](https://rsshub.app/cbpanet/dzp_news/7/25)                        | [7/26](https://rsshub.app/cbpanet/dzp_news/7/26)                              | [7/27](https://rsshub.app/cbpanet/dzp_news/7/27)                                  | [7/29](https://rsshub.app/cbpanet/dzp_news/7/29)                      | [7/41](https://rsshub.app/cbpanet/dzp_news/7/41)                    | [7/49](https://rsshub.app/cbpanet/dzp_news/7/49)                    |\n\n</details>\n    ",
        "categories": [
          "new-media"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.cbpanet.com/dzp_news.aspx"
            ]
          },
          {
            "title": "协会 - 协会介绍",
            "source": [
              "www.cbpanet.com/dzp_news.aspx"
            ],
            "target": "/dzp_news/1/1"
          },
          {
            "title": "协会 - 协会章程",
            "source": [
              "www.cbpanet.com/dzp_news.aspx"
            ],
            "target": "/dzp_news/1/2"
          },
          {
            "title": "协会 - 理事会",
            "source": [
              "www.cbpanet.com/dzp_news.aspx"
            ],
            "target": "/dzp_news/1/3"
          },
          {
            "title": "协会 - 内设机构",
            "source": [
              "www.cbpanet.com/dzp_news.aspx"
            ],
            "target": "/dzp_news/1/4"
          },
          {
            "title": "协会 - 协会通知",
            "source": [
              "www.cbpanet.com/dzp_news.aspx"
            ],
            "target": "/dzp_news/1/5"
          },
          {
            "title": "协会 - 协会活动",
            "source": [
              "www.cbpanet.com/dzp_news.aspx"
            ],
            "target": "/dzp_news/1/6"
          },
          {
            "title": "协会 - 出版物",
            "source": [
              "www.cbpanet.com/dzp_news.aspx"
            ],
            "target": "/dzp_news/1/7"
          },
          {
            "title": "协会 - 会员权利与义务",
            "source": [
              "www.cbpanet.com/dzp_news.aspx"
            ],
            "target": "/dzp_news/1/30"
          },
          {
            "title": "行业资讯 - 国内资讯",
            "source": [
              "www.cbpanet.com/dzp_news.aspx"
            ],
            "target": "/dzp_news/2/8"
          },
          {
            "title": "行业资讯 - 海外资讯",
            "source": [
              "www.cbpanet.com/dzp_news.aspx"
            ],
            "target": "/dzp_news/2/9"
          },
          {
            "title": "行业资讯 - 企业新闻",
            "source": [
              "www.cbpanet.com/dzp_news.aspx"
            ],
            "target": "/dzp_news/2/10"
          },
          {
            "title": "行业资讯 - 行业资讯",
            "source": [
              "www.cbpanet.com/dzp_news.aspx"
            ],
            "target": "/dzp_news/2/11"
          },
          {
            "title": "行业资讯 - 热点聚焦",
            "source": [
              "www.cbpanet.com/dzp_news.aspx"
            ],
            "target": "/dzp_news/2/43"
          },
          {
            "title": "行业资讯 - 今日推荐",
            "source": [
              "www.cbpanet.com/dzp_news.aspx"
            ],
            "target": "/dzp_news/2/44"
          },
          {
            "title": "原料信息 - 价格行情",
            "source": [
              "www.cbpanet.com/dzp_news.aspx"
            ],
            "target": "/dzp_news/3/12"
          },
          {
            "title": "原料信息 - 分析预测",
            "source": [
              "www.cbpanet.com/dzp_news.aspx"
            ],
            "target": "/dzp_news/3/13"
          },
          {
            "title": "原料信息 - 原料信息",
            "source": [
              "www.cbpanet.com/dzp_news.aspx"
            ],
            "target": "/dzp_news/3/40"
          },
          {
            "title": "原料信息 - 热点聚焦",
            "source": [
              "www.cbpanet.com/dzp_news.aspx"
            ],
            "target": "/dzp_news/3/45"
          },
          {
            "title": "法规标准 - 法规资讯",
            "source": [
              "www.cbpanet.com/dzp_news.aspx"
            ],
            "target": "/dzp_news/4/15"
          },
          {
            "title": "法规标准 - 法律法规",
            "source": [
              "www.cbpanet.com/dzp_news.aspx"
            ],
            "target": "/dzp_news/4/16"
          },
          {
            "title": "法规标准 - 国内标准",
            "source": [
              "www.cbpanet.com/dzp_news.aspx"
            ],
            "target": "/dzp_news/4/14"
          },
          {
            "title": "法规标准 - 国外标准",
            "source": [
              "www.cbpanet.com/dzp_news.aspx"
            ],
            "target": "/dzp_news/4/17"
          },
          {
            "title": "法规标准 - 法规聚焦",
            "source": [
              "www.cbpanet.com/dzp_news.aspx"
            ],
            "target": "/dzp_news/4/46"
          },
          {
            "title": "法规标准 - 今日推荐",
            "source": [
              "www.cbpanet.com/dzp_news.aspx"
            ],
            "target": "/dzp_news/4/47"
          },
          {
            "title": "技术专区 - 产品介绍",
            "source": [
              "www.cbpanet.com/dzp_news.aspx"
            ],
            "target": "/dzp_news/5/18"
          },
          {
            "title": "技术专区 - 科技成果",
            "source": [
              "www.cbpanet.com/dzp_news.aspx"
            ],
            "target": "/dzp_news/5/19"
          },
          {
            "title": "技术专区 - 学术论文",
            "source": [
              "www.cbpanet.com/dzp_news.aspx"
            ],
            "target": "/dzp_news/5/20"
          },
          {
            "title": "技术专区 - 资料下载",
            "source": [
              "www.cbpanet.com/dzp_news.aspx"
            ],
            "target": "/dzp_news/5/21"
          },
          {
            "title": "技术专区 - 专家",
            "source": [
              "www.cbpanet.com/dzp_news.aspx"
            ],
            "target": "/dzp_news/5/50"
          },
          {
            "title": "技术专区 - 民间智库",
            "source": [
              "www.cbpanet.com/dzp_news.aspx"
            ],
            "target": "/dzp_news/5/57"
          },
          {
            "title": "豆制品消费指南 - 膳食指南",
            "source": [
              "www.cbpanet.com/dzp_news.aspx"
            ],
            "target": "/dzp_news/6/22"
          },
          {
            "title": "豆制品消费指南 - 营养成分",
            "source": [
              "www.cbpanet.com/dzp_news.aspx"
            ],
            "target": "/dzp_news/6/23"
          },
          {
            "title": "豆制品消费指南 - 豆食菜谱",
            "source": [
              "www.cbpanet.com/dzp_news.aspx"
            ],
            "target": "/dzp_news/6/24"
          },
          {
            "title": "豆制品消费指南 - 问与答",
            "source": [
              "www.cbpanet.com/dzp_news.aspx"
            ],
            "target": "/dzp_news/6/31"
          },
          {
            "title": "豆制品消费指南 - 今日推荐",
            "source": [
              "www.cbpanet.com/dzp_news.aspx"
            ],
            "target": "/dzp_news/6/48"
          },
          {
            "title": "豆制品消费指南 - 消费热点",
            "source": [
              "www.cbpanet.com/dzp_news.aspx"
            ],
            "target": "/dzp_news/6/53"
          },
          {
            "title": "营养与健康 - 大豆营养概况",
            "source": [
              "www.cbpanet.com/dzp_news.aspx"
            ],
            "target": "/dzp_news/7/25"
          },
          {
            "title": "营养与健康 - 大豆食品和人类健康",
            "source": [
              "www.cbpanet.com/dzp_news.aspx"
            ],
            "target": "/dzp_news/7/26"
          },
          {
            "title": "营养与健康 - 世界豆类日，爱豆大行动",
            "source": [
              "www.cbpanet.com/dzp_news.aspx"
            ],
            "target": "/dzp_news/7/27"
          },
          {
            "title": "营养与健康 - 谣言粉碎机",
            "source": [
              "www.cbpanet.com/dzp_news.aspx"
            ],
            "target": "/dzp_news/7/29"
          },
          {
            "title": "营养与健康 - 最新资讯",
            "source": [
              "www.cbpanet.com/dzp_news.aspx"
            ],
            "target": "/dzp_news/7/41"
          },
          {
            "title": "营养与健康 - 专家视点",
            "source": [
              "www.cbpanet.com/dzp_news.aspx"
            ],
            "target": "/dzp_news/7/49"
          }
        ],
        "location": "index.ts",
        "module": () => import('@/routes/cbpanet/index.ts')
      }
    },
    "name": "中国豆制品网",
    "apiRoutes": {},
    "url": "cbpanet.com",
    "categories": [
      "new-media"
    ],
    "description": "",
    "lang": "zh-CN"
  },
  "ccac": {
    "routes": {
      "/news/:type/:lang?": {
        "path": "/news/:type/:lang?",
        "categories": [
          "government"
        ],
        "example": "/ccac/news/all",
        "parameters": {
          "type": "Category",
          "lang": "Language, default to `sc`. Supprot `en`(English), `sc`(Simplified Chinese), `tc`(Traditional Chinese) and `pt`(Portuguese)"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": true,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "Latest News",
        "maintainers": [
          "linbuxiao"
        ],
        "description": "Category\n\n| All | Detected Cases | Investigation Reports or Recommendations | Annual Reports | CCAC's Updates |\n| --- | -------------- | ---------------------------------------- | -------------- | -------------- |\n| all | case           | Persuasion                               | AnnualReport   | PCANews        |",
        "location": "news.ts",
        "module": () => import('@/routes/ccac/news.ts')
      }
    },
    "name": "Macau Independent Commission Against Corruption 澳门廉政公署",
    "url": "ccac.org.mo",
    "lang": "zh-HK"
  },
  "ccagm": {
    "routes": {
      "/:category{.+}?": {
        "path": "/:category{.+}?",
        "name": "栏目",
        "url": "www.ccagm.org.cn",
        "maintainers": [
          "nczitzk"
        ],
        "example": "/ccagm/association-news",
        "parameters": {
          "category": {
            "description": "分类，默认为 `association-news`，即协会动态，可在对应分类页 URL 中找到",
            "options": [
              {
                "label": "协会动态",
                "value": "association-news"
              },
              {
                "label": "会议活动",
                "value": "xh-activity/activities-huiyi"
              },
              {
                "label": "调研与报告",
                "value": "xh-activity/bg-yj"
              },
              {
                "label": "协会党建",
                "value": "xie-hui-dang-jian"
              },
              {
                "label": "行业新闻",
                "value": "members-info"
              },
              {
                "label": "行业研究",
                "value": "bg-yj"
              },
              {
                "label": "行业标准",
                "value": "industry-policy/industry-standard"
              },
              {
                "label": "法律法规",
                "value": "industry-policy/policies-regulations"
              },
              {
                "label": "资料下载",
                "value": "download"
              },
              {
                "label": "工作总结与计划",
                "value": "about-association/gong-zuo-zong-jie-yu-ji-hua"
              }
            ]
          }
        },
        "description": ":::tip\n订阅 [协会动态](http://www.ccagm.org.cn/association-news)，其源网址为 `http://www.ccagm.org.cn/association-news`，请参考该 URL 指定部分构成参数，此时路由为 [`/ccagm/association-news`](https://rsshub.app/ccagm/association-news)。\n:::\n\n<details>\n  <summary>更多分类</summary>\n\n  | 栏目                                                                                         | ID                                                                                                                      |\n  | -------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------- |\n  | [协会动态](http://www.ccagm.org.cn/association-news.html)                                    | [association-news](https://rsshub.app/ccagm/association-news)                                                           |\n  | [会议活动](http://www.ccagm.org.cn/xh-activity/activities-huiyi.html)                        | [xh-activity/activities-huiyi](https://rsshub.app/ccagm/xh-activity/activities-huiyi)                                   |\n  | [调研与报告](http://www.ccagm.org.cn/xh-activity/bg-yj.html)                                 | [xh-activity/bg-yj](https://rsshub.app/ccagm/xh-activity/bg-yj)                                                         |\n  | [协会党建](http://www.ccagm.org.cn/xie-hui-dang-jian.html)                                   | [xie-hui-dang-jian](https://rsshub.app/ccagm/xie-hui-dang-jian)                                                         |\n  | [行业新闻](http://www.ccagm.org.cn/members-info.html)                                        | [members-info](https://rsshub.app/ccagm/members-info)                                                                   |\n  | [行业研究](http://www.ccagm.org.cn/bg-yj.html)                                               | [bg-yj](https://rsshub.app/ccagm/bg-yj)                                                                                 |\n  | [行业标准](http://www.ccagm.org.cn/industry-policy/industry-standard.html)                   | [industry-policy/industry-standard](https://rsshub.app/ccagm/industry-policy/industry-standard)                         |\n  | [法律法规](http://www.ccagm.org.cn/industry-policy/policies-regulations.html)                | [industry-policy/policies-regulations](https://rsshub.app/ccagm/industry-policy/policies-regulations)                   |\n  | [资料下载](http://www.ccagm.org.cn/download.html)                                            | [download](https://rsshub.app/ccagm/download)                                                                           |\n  | [工作总结与计划](http://www.ccagm.org.cn/about-association/gong-zuo-zong-jie-yu-ji-hua.html) | [about-association/gong-zuo-zong-jie-yu-ji-hua](https://rsshub.app/ccagm/about-association/gong-zuo-zong-jie-yu-ji-hua) |\n\n</details>\n",
        "categories": [
          "new-media"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.ccagm.org.cn/category?"
            ],
            "target": "/:category"
          },
          {
            "title": "协会动态",
            "source": [
              "www.ccagm.org.cn/association-news.html"
            ],
            "target": "/association-news"
          },
          {
            "title": "会议活动",
            "source": [
              "www.ccagm.org.cn/xh-activity/activities-huiyi.html"
            ],
            "target": "/xh-activity/activities-huiyi"
          },
          {
            "title": "调研与报告",
            "source": [
              "www.ccagm.org.cn/xh-activity/bg-yj.html"
            ],
            "target": "/xh-activity/bg-yj"
          },
          {
            "title": "协会党建",
            "source": [
              "www.ccagm.org.cn/xie-hui-dang-jian.html"
            ],
            "target": "/xie-hui-dang-jian"
          },
          {
            "title": "行业新闻",
            "source": [
              "www.ccagm.org.cn/members-info.html"
            ],
            "target": "/members-info"
          },
          {
            "title": "行业研究",
            "source": [
              "www.ccagm.org.cn/bg-yj.html"
            ],
            "target": "/bg-yj"
          },
          {
            "title": "行业标准",
            "source": [
              "www.ccagm.org.cn/industry-policy/industry-standard.html"
            ],
            "target": "/industry-policy/industry-standard"
          },
          {
            "title": "法律法规",
            "source": [
              "www.ccagm.org.cn/industry-policy/policies-regulations.html"
            ],
            "target": "/industry-policy/policies-regulations"
          },
          {
            "title": "资料下载",
            "source": [
              "www.ccagm.org.cn/download.html"
            ],
            "target": "/download"
          },
          {
            "title": "工作总结与计划",
            "source": [
              "www.ccagm.org.cn/about-association/gong-zuo-zong-jie-yu-ji-hua.html"
            ],
            "target": "/about-association/gong-zuo-zong-jie-yu-ji-hua"
          }
        ],
        "view": 0,
        "location": "index.ts",
        "module": () => import('@/routes/ccagm/index.ts')
      }
    },
    "name": "中国百货商业协会",
    "apiRoutes": {},
    "url": "ccagm.org.cn",
    "categories": [
      "new-media"
    ],
    "description": "",
    "lang": "zh-CN"
  },
  "cccfna": {
    "routes": {
      "/:category/:type?": {
        "path": "/:category/:type?",
        "categories": [
          "government"
        ],
        "example": "/cccfna/meirigengxin",
        "parameters": {
          "category": "文章种类，即一级分类，详情见下表",
          "type": "文章类型，即二级分类，详情见下表"
        },
        "radar": [
          {
            "source": [
              "www.cccfna.org.cn/:category/:type?"
            ]
          }
        ],
        "description": "\n::: tip\n存在**二级分类**的**一级分类**不能单独当作参数，如：`/cccfna/hangyezixun`\n:::\n\n文章的目录分级如下:\n\n- shanghuidongtai（商会通知）\n- meirigengxin（每日更新）\n- tongzhigonggao（通知公告）\n- hangyezixun（行业资讯）\n  - zhengcedaohang（政策导航）\n  - yujinxinxi（预警信息）\n  - shichangdongtai（市场动态）\n  - gongxuxinxi（供需信息）\n- maoyitongji（贸易统计）\n  - tongjikuaibao（统计快报）\n  - hangyetongji（行业统计）\n  - guobiemaoyi（国别贸易）\n  - maoyizhinan（贸易指南）\n- nongchanpinbaogao（农产品报告）\n  - nongchanpinyuebao（农产品月报）\n  - zhongdianchanpinyuebao（重点产品月报）\n  - zhongdianchanpinzoushi（重点产品走势）",
        "name": "资讯信息",
        "maintainers": [
          "hualiong"
        ],
        "location": "index.ts",
        "module": () => import('@/routes/cccfna/index.ts')
      }
    },
    "name": "中国食品土畜进出口商会",
    "apiRoutes": {},
    "url": "www.cccfna.org.cn",
    "lang": "zh-CN"
  },
  "cccmc": {
    "routes": {
      "/:category{.+}?": {
        "path": "/:category{.+}?",
        "name": "通用",
        "url": "www.cccmc.org.cn",
        "maintainers": [
          "nczitzk"
        ],
        "example": "/cccmc/ywgg/tzgg",
        "parameters": {
          "category": "分类，默认为 `ywgg/tzgg`，即通知公告，可在对应分类页 URL 中找到, Category, `ywgg/tzgg`，即通知公告  by default"
        },
        "description": "::: tip\n若订阅 [综合政策](https://www.cccmc.org.cn/zcfg/zhzc/)，网址为 `https://www.cccmc.org.cn/zcfg/zhzc/`，请截取 `https://www.cccmc.org.cn/` 到末尾的部分 `zcfg/zhzc` 作为 `category` 参数填入，此时目标路由为 [`/cccmc/zcfg/zhzc`](https://rsshub.app/cccmc/zcfg/zhzc)。\n:::\n\n<details>\n<summary>更多分类</summary>\n\n#### [会员之家](https://www.cccmc.org.cn/hyzj)\n\n| [会员之声](https://www.cccmc.org.cn/hyzj/hyzs/) | [会员动态](https://www.cccmc.org.cn/hyzj/hydt/) | [会员推介](https://www.cccmc.org.cn/hyzj/hytj/) |\n| ----------------------------------------------- | ----------------------------------------------- | ----------------------------------------------- |\n| [hyzj/hyzs](https://rsshub.app/cccmc/hyzj/hyzs) | [hyzj/hydt](https://rsshub.app/cccmc/hyzj/hydt) | [hyzj/hytj](https://rsshub.app/cccmc/hyzj/hytj) |\n\n#### [政策法规](https://www.cccmc.org.cn/zcfg)\n\n| [综合政策](https://www.cccmc.org.cn/zcfg/zhzc/) | [国内贸易](https://www.cccmc.org.cn/zcfg/gnmy/) | [对外贸易](https://www.cccmc.org.cn/zcfg/dwmy/) | [投资合作](https://www.cccmc.org.cn/zcfg/tzhz/) |\n| ----------------------------------------------- | ----------------------------------------------- | ----------------------------------------------- | ----------------------------------------------- |\n| [zcfg/zhzc](https://rsshub.app/cccmc/zcfg/zhzc) | [zcfg/gnmy](https://rsshub.app/cccmc/zcfg/gnmy) | [zcfg/dwmy](https://rsshub.app/cccmc/zcfg/dwmy) | [zcfg/tzhz](https://rsshub.app/cccmc/zcfg/tzhz) |\n\n#### [行业资讯](https://www.cccmc.org.cn/hyzx)\n\n| [统计分析](https://www.cccmc.org.cn/hyzx/tjfx/) | [石油化工](https://www.cccmc.org.cn/hyzx/syhg/) | [金属矿产](https://www.cccmc.org.cn/hyzx/jskc/) | [五金建材](https://www.cccmc.org.cn/hyzx/wjjc/) |\n| ----------------------------------------------- | ----------------------------------------------- | ----------------------------------------------- | ----------------------------------------------- |\n| [hyzx/tjfx](https://rsshub.app/cccmc/hyzx/tjfx) | [hyzx/syhg](https://rsshub.app/cccmc/hyzx/syhg) | [hyzx/jskc](https://rsshub.app/cccmc/hyzx/jskc) | [hyzx/wjjc](https://rsshub.app/cccmc/hyzx/wjjc) |\n\n#### [商业机会](https://www.cccmc.org.cn/syjh/)+\n\n| [供应信息](https://www.cccmc.org.cn/syjh/gyxx/) | [需求信息](https://www.cccmc.org.cn/syjh/xqxx/) | [合作信息](https://www.cccmc.org.cn/syjh/hzxx/) |\n| ----------------------------------------------- | ----------------------------------------------- | ----------------------------------------------- |\n| [syjh/gyxx](https://rsshub.app/cccmc/syjh/gyxx) | [syjh/xqxx](https://rsshub.app/cccmc/syjh/xqxx) | [syjh/hzxx](https://rsshub.app/cccmc/syjh/hzxx) |\n\n#### [商会党建](https://www.cccmc.org.cn/shdj)\n\n| [党群动态](https://www.cccmc.org.cn/shdj/dqdt/) | [党内法规](https://www.cccmc.org.cn/shdj/dnfg/) | [青年工作](https://www.cccmc.org.cn/shdj/qngz/) |\n| ----------------------------------------------- | ----------------------------------------------- | ----------------------------------------------- |\n| [shdj/dqdt](https://rsshub.app/cccmc/shdj/dqdt) | [shdj/dnfg](https://rsshub.app/cccmc/shdj/dnfg) | [shdj/qngz](https://rsshub.app/cccmc/shdj/qngz) |\n</details>\n",
        "categories": [
          "new-media"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.cccmc.org.cn/:category"
            ]
          },
          {
            "title": "商业机会 - 供应信息",
            "source": [
              "www.cccmc.org.cn/syjh/gyxx/"
            ],
            "target": "/syjh/gyxx"
          },
          {
            "title": "商业机会 - 需求信息",
            "source": [
              "www.cccmc.org.cn/syjh/xqxx/"
            ],
            "target": "/syjh/xqxx"
          },
          {
            "title": "商业机会 - 合作信息",
            "source": [
              "www.cccmc.org.cn/syjh/hzxx/"
            ],
            "target": "/syjh/hzxx"
          },
          {
            "title": "商会党建 - 党群动态",
            "source": [
              "www.cccmc.org.cn/shdj/dqdt/"
            ],
            "target": "/shdj/dqdt"
          },
          {
            "title": "商会党建 - 党内法规",
            "source": [
              "www.cccmc.org.cn/shdj/dnfg/"
            ],
            "target": "/shdj/dnfg"
          },
          {
            "title": "商会党建 - 青年工作",
            "source": [
              "www.cccmc.org.cn/shdj/qngz/"
            ],
            "target": "/shdj/qngz"
          },
          {
            "title": "行业资讯 - 统计分析",
            "source": [
              "www.cccmc.org.cn/hyzx/tjfx/"
            ],
            "target": "/hyzx/tjfx"
          },
          {
            "title": "行业资讯 - 石油化工",
            "source": [
              "www.cccmc.org.cn/hyzx/syhg/"
            ],
            "target": "/hyzx/syhg"
          },
          {
            "title": "行业资讯 - 金属矿产",
            "source": [
              "www.cccmc.org.cn/hyzx/jskc/"
            ],
            "target": "/hyzx/jskc"
          },
          {
            "title": "行业资讯 - 五金建材",
            "source": [
              "www.cccmc.org.cn/hyzx/wjjc/"
            ],
            "target": "/hyzx/wjjc"
          },
          {
            "title": "会员之家 - 会员之声",
            "source": [
              "www.cccmc.org.cn/hyzj/hyzs/"
            ],
            "target": "/hyzj/hyzs"
          },
          {
            "title": "会员之家 - 会员动态",
            "source": [
              "www.cccmc.org.cn/hyzj/hydt/"
            ],
            "target": "/hyzj/hydt"
          },
          {
            "title": "会员之家 - 会员推介",
            "source": [
              "www.cccmc.org.cn/hyzj/hytj/"
            ],
            "target": "/hyzj/hytj"
          },
          {
            "title": "政策法规 - 综合政策",
            "source": [
              "www.cccmc.org.cn/zcfg/zhzc/"
            ],
            "target": "/zcfg/zhzc"
          },
          {
            "title": "政策法规 - 国内贸易",
            "source": [
              "www.cccmc.org.cn/zcfg/gnmy/"
            ],
            "target": "/zcfg/gnmy"
          },
          {
            "title": "政策法规 - 对外贸易",
            "source": [
              "www.cccmc.org.cn/zcfg/dwmy/"
            ],
            "target": "/zcfg/dwmy"
          },
          {
            "title": "政策法规 - 投资合作",
            "source": [
              "www.cccmc.org.cn/zcfg/tzhz/"
            ],
            "target": "/zcfg/tzhz"
          }
        ],
        "view": 0,
        "location": "index.ts",
        "module": () => import('@/routes/cccmc/index.ts')
      }
    },
    "name": "中国五矿化工进出口商会",
    "apiRoutes": {},
    "url": "www.cccmc.org.cn",
    "categories": [
      "new-media"
    ],
    "description": "",
    "lang": "zh-CN"
  },
  "ccf": {
    "routes": {
      "/ccfcv/:channel/:category": {
        "path": "/ccfcv/:channel/:category",
        "categories": [
          "study"
        ],
        "example": "/ccf/ccfcv/xsdt/xsqy",
        "parameters": {
          "channel": "频道，仅支持 `xsdt`",
          "category": "分类，见下表，亦可在网站 url 里找到"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "计算机视觉专委会 - 学术动态 - 分类",
        "maintainers": [
          "elxy"
        ],
        "description": "| 学术前沿 | 热点征文 | 学术会议 |\n| -------- | -------- | -------- |\n| xsqy     | rdzw     | xshy     |",
        "location": "ccfcv/index.tsx",
        "module": () => import('@/routes/ccf/ccfcv/index.tsx')
      },
      "/news/:category?": {
        "path": "/news/:category?",
        "categories": [
          "study"
        ],
        "example": "/ccf/news",
        "parameters": {
          "category": "分类，见下表，默认为 CCF 新闻"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "ccf.org.cn/:category",
              "ccf.org.cn/"
            ],
            "target": "/news/:category"
          }
        ],
        "name": "新闻",
        "maintainers": [
          "nczitzk"
        ],
        "description": "| CCF 新闻    | CCF 聚焦 | ACM 信息  |\n| ----------- | -------- | --------- |\n| Media_list | Focus    | ACM_News |",
        "location": "news.ts",
        "module": () => import('@/routes/ccf/news.ts')
      },
      "/tfbd/:caty/:id": {
        "path": "/tfbd/:caty/:id",
        "categories": [
          "study"
        ],
        "example": "/ccf/tfbd/xwdt/tzgg",
        "parameters": {
          "caty": "主分类，可在 URL 找到",
          "id": "子分类，可在 URL 找到"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "tfbd.ccf.org.cn/tfbd/:caty/:id",
              "tfbd.ccf.org.cn/"
            ]
          }
        ],
        "name": "大数据专家委员会",
        "maintainers": [
          "tudou027"
        ],
        "location": "tfbd/index.ts",
        "module": () => import('@/routes/ccf/tfbd/index.ts')
      }
    },
    "name": "中国计算机学会",
    "apiRoutes": {},
    "url": "ccf.org.cn",
    "lang": "zh-CN"
  },
  "ccfa": {
    "routes": {
      "/:type?": {
        "path": "/:type?",
        "name": "分类",
        "url": "www.ccfa.org.cn",
        "maintainers": [
          "nczitzk"
        ],
        "example": "/ccfa/1",
        "parameters": {
          "category": "分类，默认为 `1`，即协会动态，可在对应分类页 URL 中找到"
        },
        "description": "::: tip\n  若订阅 [协会动态](https://www.ccfa.org.cn/portal/cn/xiehui_list.jsp?type=1)，网址为 `https://www.ccfa.org.cn/portal/cn/xiehui_list.jsp?type=1`。截取 `https://www.ccfa.org.cn/portal/cn/xiehui_list.jsp?type=` 到末尾的部分 `1` 作为参数填入，此时路由为 [`/ccfa/1`](https://rsshub.app/ccfa/1)。\n:::\n\n| 分类                                                                      | ID                                     |\n| ------------------------------------------------------------------------- | -------------------------------------- |\n| [协会动态](http://www.ccfa.org.cn/portal/cn/xiehui_list.jsp?type=1)       | [1](https://rsshub.app/ccfa/1)         |\n| [行业动态](http://www.ccfa.org.cn/portal/cn/xiehui_list.jsp?type=2)       | [2](https://rsshub.app/ccfa/2)         |\n| [政策/报告/标准](http://www.ccfa.org.cn/portal/cn/hybz_list.jsp?type=33)  | [33](https://rsshub.app/ccfa/33)       |\n| [行业统计](http://www.ccfa.org.cn/portal/cn/lsbq.jsp?type=10003)          | [10003](https://rsshub.app/ccfa/10003) |\n| [创新案例](http://www.ccfa.org.cn/portal/cn/hybzs_list.jsp?type=10004)    | [10004](https://rsshub.app/ccfa/10004) |\n| [党建工作](http://www.ccfa.org.cn/portal/cn/xiehui_list.jsp?type=7)       | [7](https://rsshub.app/ccfa/7)         |\n| [新消费论坛](http://www.ccfa.org.cn/portal/cn/xiehui_list.jsp?type=10005) | [10005](https://rsshub.app/ccfa/10005) |\n\n#### [政策/报告/标准](http://www.ccfa.org.cn/portal/cn/hybz_list.jsp?type=33)\n\n| 分类                                                                            | ID                               |\n| ------------------------------------------------------------------------------- | -------------------------------- |\n| [行业报告](http://www.ccfa.org.cn/portal/cn/hybz_list.jsp?type=33)              | [33](https://rsshub.app/ccfa/33) |\n| [行业标准](http://www.ccfa.org.cn/portal/cn/hybz_list.jsp?type=34)              | [34](https://rsshub.app/ccfa/34) |\n| [行业政策](http://www.ccfa.org.cn/portal/cn/fangyizhuanqu_list.jsp?type=39)     | [39](https://rsshub.app/ccfa/39) |\n| [政策权威解读](http://www.ccfa.org.cn/portal/cn/fangyizhuanqu_list.jsp?type=40) | [40](https://rsshub.app/ccfa/40) |\n    ",
        "categories": [
          "new-media"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.ccfa.org.cn/portal/cn/xiehui_list.jsp",
              "www.ccfa.org.cn/portal/cn/hybz_list.jsp",
              "www.ccfa.org.cn/portal/cn/lsbq.jsp",
              "www.ccfa.org.cn/portal/cn/hybzs_list.jsp",
              "www.ccfa.org.cn/portal/cn/fangyizhuanqu_list.jsp"
            ]
          },
          {
            "title": "协会动态",
            "source": [
              "www.ccfa.org.cn/portal/cn/xiehui_list.jsp"
            ],
            "target": "/1"
          },
          {
            "title": "行业动态",
            "source": [
              "www.ccfa.org.cn/portal/cn/xiehui_list.jsp"
            ],
            "target": "/2"
          },
          {
            "title": "政策/报告/标准",
            "source": [
              "www.ccfa.org.cn/portal/cn/hybz_list.jsp"
            ],
            "target": "/33"
          },
          {
            "title": "行业统计",
            "source": [
              "www.ccfa.org.cn/portal/cn/lsbq.jsp"
            ],
            "target": "/10003"
          },
          {
            "title": "创新案例",
            "source": [
              "www.ccfa.org.cn/portal/cn/hybzs_list.jsp"
            ],
            "target": "/10004"
          },
          {
            "title": "党建工作",
            "source": [
              "www.ccfa.org.cn/portal/cn/xiehui_list.jsp"
            ],
            "target": "/7"
          },
          {
            "title": "新消费论坛",
            "source": [
              "www.ccfa.org.cn/portal/cn/xiehui_list.jsp"
            ],
            "target": "/10005"
          },
          {
            "title": "政策/报告/标准 - 行业报告",
            "source": [
              "www.ccfa.org.cn/portal/cn/hybz_list.jsp"
            ],
            "target": "/33"
          },
          {
            "title": "政策/报告/标准 - 行业标准",
            "source": [
              "www.ccfa.org.cn/portal/cn/hybz_list.jsp"
            ],
            "target": "/34"
          },
          {
            "title": "政策/报告/标准 - 行业政策",
            "source": [
              "www.ccfa.org.cn/portal/cn/fangyizhuanqu_list.jsp"
            ],
            "target": "/39"
          },
          {
            "title": "政策/报告/标准 - 政策权威解读",
            "source": [
              "www.ccfa.org.cn/portal/cn/fangyizhuanqu_list.jsp"
            ],
            "target": "/40"
          }
        ],
        "location": "index.tsx",
        "module": () => import('@/routes/ccfa/index.tsx')
      }
    },
    "name": "中国连锁经营协会",
    "apiRoutes": {},
    "url": "ccfa.org.cn",
    "categories": [
      "new-media"
    ],
    "description": "",
    "lang": "zh-CN"
  },
  "ccg": {
    "routes": {
      "/:category?": {
        "path": "/:category?",
        "name": "动态",
        "url": "www.ccg.org.cn",
        "maintainers": [
          "nczitzk"
        ],
        "example": "/ccg/news",
        "parameters": {
          "category": {
            "description": "分类，默认为 `news`，即新闻动态，可在对应分类页 URL 中找到",
            "options": [
              {
                "label": "新闻动态",
                "value": "news"
              },
              {
                "label": "媒体报道",
                "value": "mtbd"
              }
            ]
          }
        },
        "description": "::: tip\n订阅 [新闻动态](http://www.ccg.org.cn/news)，其源网址为 `http://www.ccg.org.cn/news`，请参考该 URL 指定部分构成参数，此时路由为 [`/ccg/news`](https://rsshub.app/ccg/news)。\n:::\n\n| 分类                                   | ID                                  |\n| -------------------------------------- | ----------------------------------- |\n| [新闻动态](http://www.ccg.org.cn/news) | [news](https://rsshub.app/ccg/news) |\n| [媒体报道](http://www.ccg.org.cn/mtbd) | [mtbd](https://rsshub.app/ccg/mtbd) |\n",
        "categories": [
          "new-media"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.ccg.org.cn/category"
            ],
            "target": "/:category"
          },
          {
            "title": "新闻动态",
            "source": [
              "www.ccg.org.cn/news"
            ],
            "target": "/news"
          },
          {
            "title": "媒体报道",
            "source": [
              "www.ccg.org.cn/mtbd"
            ],
            "target": "/mtbd"
          }
        ],
        "view": 0,
        "location": "index.ts",
        "module": () => import('@/routes/ccg/index.ts')
      }
    },
    "name": "全球化智库",
    "apiRoutes": {},
    "url": "ccg.org.cn",
    "categories": [
      "new-media"
    ],
    "description": "",
    "lang": "zh-CN"
  },
  "ccnu": {
    "routes": {
      "/career": {
        "path": "/career",
        "categories": [
          "university"
        ],
        "example": "/ccnu/career",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "ccnu.91wllm.com/news/index/tag/tzgg",
              "ccnu.91wllm.com/"
            ]
          }
        ],
        "name": "就业信息",
        "maintainers": [
          "jackyu1996"
        ],
        "url": "ccnu.91wllm.com/news/index/tag/tzgg",
        "location": "career.ts",
        "module": () => import('@/routes/ccnu/career.ts')
      },
      "/cs": {
        "path": "/cs",
        "categories": [
          "university"
        ],
        "example": "/ccnu/cs",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "cs.ccnu.edu.cn/xwzx/tzgg.htm",
              "cs.ccnu.edu.cn/"
            ]
          }
        ],
        "name": "计算机学院",
        "maintainers": [
          "shengmaosu"
        ],
        "url": "cs.ccnu.edu.cn/xwzx/tzgg.htm",
        "location": "cs.ts",
        "module": () => import('@/routes/ccnu/cs.ts')
      },
      "/wu": {
        "path": "/wu",
        "categories": [
          "university"
        ],
        "example": "/ccnu/wu",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "uowji.ccnu.edu.cn/xwzx/tzgg.htm",
              "uowji.ccnu.edu.cn/"
            ]
          }
        ],
        "name": "伍论贡学院",
        "maintainers": [
          "shengmaosu"
        ],
        "url": "uowji.ccnu.edu.cn/xwzx/tzgg.htm",
        "location": "wu.ts",
        "module": () => import('@/routes/ccnu/wu.ts')
      },
      "/yjs": {
        "path": "/yjs",
        "categories": [
          "university"
        ],
        "example": "/ccnu/yjs",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "gs.ccnu.edu.cn/zsgz/ssyjs.htm",
              "gs.ccnu.edu.cn/"
            ]
          }
        ],
        "name": "研究生通知公告",
        "maintainers": [
          "shengmaosu"
        ],
        "url": "gs.ccnu.edu.cn/zsgz/ssyjs.htm",
        "location": "yjs.ts",
        "module": () => import('@/routes/ccnu/yjs.ts')
      }
    },
    "name": "华中师范大学",
    "apiRoutes": {},
    "url": "ccnu.91wllm.com",
    "lang": "zh-CN"
  },
  "ccreports": {
    "routes": {
      "/article": {
        "path": "/article",
        "categories": [
          "shopping"
        ],
        "example": "/ccreports/article",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.ccreports.com.cn/"
            ]
          }
        ],
        "name": "要闻",
        "maintainers": [
          "EsuRt",
          "Fatpandac"
        ],
        "url": "www.ccreports.com.cn/",
        "location": "index.ts",
        "module": () => import('@/routes/ccreports/index.ts')
      }
    },
    "name": "消费者报道",
    "apiRoutes": {},
    "url": "www.ccreports.com.cn",
    "lang": "zh-CN"
  },
  "cctv": {
    "routes": {
      "/:category": {
        "path": "/:category",
        "categories": [
          "traditional-media"
        ],
        "example": "/cctv/world",
        "parameters": {
          "category": "分类名"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "news.cctv.com/:category"
            ]
          }
        ],
        "name": "专题",
        "maintainers": [
          "idealclover",
          "xyqfer"
        ],
        "description": "| 新闻 | 国内  | 国际  | 社会    | 法治 | 文娱 | 科技 | 生活 | 教育 | 每周质量报告 | 新闻 1+1  |\n| ---- | ----- | ----- | ------- | ---- | ---- | ---- | ---- | ---- | ------------ | --------- |\n| news | china | world | society | law  | ent  | tech | life | edu  | mzzlbg       | xinwen1j1 |",
        "location": "category.ts",
        "module": () => import('@/routes/cctv/category.ts')
      },
      "/photo/jx": {
        "path": "/photo/jx",
        "categories": [
          "traditional-media"
        ],
        "example": "/cctv/photo/jx",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "photo.cctv.com/jx",
              "photo.cctv.com/"
            ]
          }
        ],
        "name": "央视网图片《镜象》",
        "maintainers": [
          "nczitzk"
        ],
        "url": "photo.cctv.com/jx",
        "location": "jx.ts",
        "module": () => import('@/routes/cctv/jx.ts')
      },
      "/lm/:id?": {
        "path": "/lm/:id?",
        "categories": [
          "traditional-media"
        ],
        "example": "/cctv/lm/xwzk",
        "parameters": {
          "id": "栏目 id，可在对应栏目页 URL 中找到，默认为 `xwzk` 即 新闻周刊"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "news.cctv.com/:category"
            ],
            "target": "/:category"
          }
        ],
        "name": "栏目",
        "maintainers": [
          "nczitzk"
        ],
        "description": "| 焦点访谈 | 等着我 | 今日说法 | 开讲啦 |\n| -------- | ------ | -------- | ------ |\n| jdft     | dzw    | jrsf     | kjl    |\n\n| 正大综艺 | 经济半小时 | 第一动画乐园 |\n| -------- | ---------- | ------------ |\n| zdzy     | jjbxs      | dydhly       |\n\n::: tip\n  更多栏目请看 [这里](https://tv.cctv.com/lm)\n:::",
        "location": "lm.ts",
        "module": () => import('@/routes/cctv/lm.ts')
      },
      "/:site/:category/:name": {
        "path": "/:site/:category/:name",
        "categories": [
          "traditional-media"
        ],
        "example": "/cctv/tv/lm/xwlb",
        "parameters": {
          "site": "站点, 可选值如'tv', 既'央视节目'",
          "category": "分类名, 官网对应分类, 当前可选值'lm', 既'栏目大全'",
          "name": {
            "description": "栏目名称, 可在对应栏目页面 URL 中找到, 可选值如'xwlb',既'新闻联播'",
            "options": [
              {
                "value": "xwlb",
                "label": "新闻联播"
              }
            ]
          }
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "tv.cctv.com/lm/xwlb",
              "tv.cctv.com/"
            ]
          }
        ],
        "name": "新闻联播",
        "maintainers": [
          "zengxs"
        ],
        "url": "tv.cctv.com/lm/xwlb",
        "description": "新闻联播内容摘要。",
        "location": "xwlb.ts",
        "module": () => import('@/routes/cctv/xwlb.ts')
      }
    },
    "name": "央视新闻",
    "apiRoutes": {},
    "url": "news.cctv.com",
    "lang": "zh-CN"
  },
  "cde": {
    "routes": {
      "/:channel/:category": {
        "path": "/:channel/:category",
        "categories": [
          "government"
        ],
        "example": "/cde/news/gzdt",
        "parameters": {
          "channel": "频道",
          "category": "类别"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "首页",
        "maintainers": [
          "Fatpandac"
        ],
        "description": "-   频道\n\n| 新闻中心 | 政策法规 |\n| :------: | :------: |\n|   news   |  policy  |\n\n  -   类别\n\n| 新闻中心 | 政务新闻 | 要闻导读 | 图片新闻 | 工作动态 |\n| :------: | :------: | :------: | :------: | :------: |\n|          |   zwxw   |   ywdd   |   tpxw   |   gzdt   |\n\n| 政策法规 | 法律法规 | 中心规章 |\n| :------: | :------: | :------: |\n|          |   flfg   |   zxgz   |",
        "location": "index.ts",
        "module": () => import('@/routes/cde/index.ts')
      },
      "/xxgk/:category": {
        "path": "/xxgk/:category",
        "categories": [
          "government"
        ],
        "example": "/cde/xxgk/priorityApproval",
        "parameters": {
          "category": "类别，见下表"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "信息公开",
        "maintainers": [
          "TonyRL"
        ],
        "description": "|   优先审评公示   |  突破性治疗公示  | 临床试验默示许可 |\n| :--------------: | :--------------: | :--------------: |\n| priorityApproval | breakthroughCure |     cliniCal     |",
        "location": "xxgk.tsx",
        "module": () => import('@/routes/cde/xxgk.tsx')
      },
      "/zdyz/:category": {
        "path": "/zdyz/:category",
        "categories": [
          "government"
        ],
        "example": "/cde/zdyz/domesticGuide",
        "parameters": {
          "category": "类别，见下表"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "指导原则专栏",
        "maintainers": [
          "TonyRL"
        ],
        "description": "|    发布通告   |   征求意见  |\n| :-----------: | :---------: |\n| domesticGuide | opinionList |",
        "location": "zdyz.ts",
        "module": () => import('@/routes/cde/zdyz.ts')
      }
    },
    "name": "国家药品审评网站",
    "apiRoutes": {},
    "url": "www.cde.org.cn",
    "lang": "zh-CN"
  },
  "cdi": {
    "routes": {
      "/:id?": {
        "path": "/:id?",
        "categories": [
          "new-media"
        ],
        "example": "/cdi",
        "parameters": {
          "id": "分类，见下表，默认为综研国策"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "栏目",
        "maintainers": [
          "nczitzk"
        ],
        "description": "| 樊纲观点 | 综研国策 | 综研观察 | 综研专访 | 综研视点 | 银湖新能源 |\n| -------- | -------- | -------- | -------- | -------- | ---------- |\n| 102      | 152      | 150      | 153      | 154      | 151        |",
        "location": "index.ts",
        "module": () => import('@/routes/cdi/index.ts')
      }
    },
    "name": "国家高端智库 / 综合开发研究院",
    "apiRoutes": {},
    "url": "cdi.com.cn",
    "lang": "zh-CN"
  },
  "cdu": {
    "routes": {
      "/cdrw": {
        "path": "/cdrw",
        "categories": [
          "university"
        ],
        "example": "/cdu/cdrw",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "news.cdu.edu.cn/"
            ]
          }
        ],
        "name": "成大人物",
        "maintainers": [
          "uuwor"
        ],
        "url": "news.cdu.edu.cn/",
        "location": "cdrw.ts",
        "module": () => import('@/routes/cdu/cdrw.ts')
      },
      "/jwgg": {
        "path": "/jwgg",
        "categories": [
          "university"
        ],
        "example": "/cdu/jwgg",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "jw.cdu.edu.cn/"
            ]
          }
        ],
        "name": "教务处通知公告",
        "maintainers": [
          "uuwor"
        ],
        "url": "jw.cdu.edu.cn/",
        "location": "jwgg.ts",
        "module": () => import('@/routes/cdu/jwgg.ts')
      },
      "/tzggcdunews": {
        "path": "/tzggcdunews",
        "categories": [
          "university"
        ],
        "example": "/cdu/tzggcdunews",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "news.cdu.edu.cn/"
            ]
          }
        ],
        "name": "通知公告",
        "maintainers": [
          "uuwor"
        ],
        "url": "news.cdu.edu.cn/",
        "location": "tzggcdunews.ts",
        "module": () => import('@/routes/cdu/tzggcdunews.ts')
      }
    },
    "name": "成都大学",
    "apiRoutes": {},
    "url": "www.cdu.edu.cn",
    "lang": "zh-CN"
  },
  "cdzjryb": {
    "routes": {
      "/zw/projectList": {
        "path": "/zw/projectList",
        "categories": [
          "other"
        ],
        "example": "/cdzjryb/zw/projectList",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "zw.cdzjryb.com/lottery/accept/projectList",
              "zw.cdzjryb.com/"
            ]
          }
        ],
        "name": "商品住房购房登记",
        "maintainers": [
          "TonyRL"
        ],
        "url": "zw.cdzjryb.com/lottery/accept/projectList",
        "location": "project-list.tsx",
        "module": () => import('@/routes/cdzjryb/project-list.tsx')
      }
    },
    "name": "成都住建蓉 e 办",
    "url": "zw.cdzjryb.com",
    "lang": "zh-CN"
  },
  "ce": {
    "routes": {
      "/district/:category?": {
        "path": "/district/:category?",
        "name": "地方经济",
        "url": "district.ce.cn",
        "maintainers": [
          "cscnk52"
        ],
        "example": "/ce/district",
        "parameters": {
          "category": "栏目标识，默认为 roll（即时新闻）"
        },
        "description": "| 即时新闻 | 经济动态 | 独家视角 | 专题 | 数说地方 | 地方播报 | 专稿 | 港澳台 |\n|----------|----------|----------|------|----------|----------|------|--------|\n| roll     | jjdt     | poll     | ch   | ssdf     | dfbb     | zg   | gat    |",
        "categories": [
          "traditional-media"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false,
          "supportRadar": true
        },
        "radar": [
          {
            "source": [
              "district.ce.cn/newarea/:category/index.shtml"
            ],
            "target": "/district/:category?"
          },
          {
            "source": [
              "district.ce.cn/newarea/:category"
            ],
            "target": "/district/:category?"
          },
          {
            "source": [
              "district.ce.cn"
            ],
            "target": "/district"
          }
        ],
        "view": 0,
        "location": "district.ts",
        "module": () => import('@/routes/ce/district.ts')
      }
    },
    "name": "中国经济网",
    "apiRoutes": {},
    "url": "www.ce.cn",
    "categories": [
      "traditional-media"
    ],
    "lang": "zh-CN"
  },
  "cebbank": {
    "routes": {
      "/quotation/all": {
        "path": "/quotation/all",
        "categories": [
          "other"
        ],
        "example": "/cebbank/quotation/all",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "cebbank.com/site/ygzx/whpj/index.html",
              "cebbank.com/eportal/ui",
              "cebbank.com/"
            ]
          }
        ],
        "name": "Unknown",
        "maintainers": [
          "linbuxiao"
        ],
        "url": "cebbank.com/site/ygzx/whpj/index.html",
        "location": "all.tsx",
        "module": () => import('@/routes/cebbank/all.tsx')
      },
      "/quotation/history/:type": {
        "path": "/quotation/history/:type",
        "categories": [
          "other"
        ],
        "example": "/cebbank/quotation/history/usd",
        "parameters": {
          "type": "货币的缩写，见下表"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "外汇牌价",
        "maintainers": [
          "linbuxiao"
        ],
        "description": "#### 总览 {#zhong-guo-guang-da-yin-hang-wai-hui-pai-jia-zong-lan}\n\n\n#### 历史牌价 {#zhong-guo-guang-da-yin-hang-wai-hui-pai-jia-li-shi-pai-jia}\n\n| 美元 | 英镑 | 港币 | 瑞士法郎 | 瑞典克郎 | 丹麦克郎 | 挪威克郎 | 日元 | 加拿大元 | 澳大利亚元 | 新加坡元 | 欧元 | 澳门元 | 泰国铢 | 新西兰元 | 韩圆 |\n| ---- | ---- | ---- | -------- | -------- | -------- | -------- | ---- | -------- | ---------- | -------- | ---- | ------ | ------ | -------- | ---- |\n| usd  | gbp  | hkd  | chf      | sek      | dkk      | nok      | jpy  | cad      | aud        | sgd      | eur  | mop    | thb    | nzd      | krw  |",
        "location": "history.tsx",
        "module": () => import('@/routes/cebbank/history.tsx')
      }
    },
    "name": "中国光大银行",
    "apiRoutes": {},
    "url": "cebbank.com",
    "lang": "zh-CN"
  },
  "ceph": {
    "routes": {
      "/blog/:topic?": {
        "path": "/blog/:topic?",
        "categories": [
          "blog"
        ],
        "example": "/ceph/blog/a11y",
        "parameters": {
          "category": "filter blog post by category, return all posts if not specified"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "ceph.io/"
            ]
          }
        ],
        "name": "Blog",
        "maintainers": [
          "pandada8"
        ],
        "url": "ceph.io",
        "location": "blog.ts",
        "module": () => import('@/routes/ceph/blog.ts')
      }
    },
    "name": "Ceph",
    "apiRoutes": {},
    "url": "ceph.io",
    "description": "Ceph is an open source distributed storage system designed to evolve with data.",
    "lang": "en"
  },
  "cfachina": {
    "routes": {
      "/servicesupport/analygarden/:program?": {
        "path": "/servicesupport/analygarden/:program?",
        "categories": [
          "other"
        ],
        "example": "/cfachina/servicesupport/analygarden",
        "parameters": {
          "program": "分类，见下表，留空为全部"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "cfachina.org/servicesupport/analygarden/:program?",
              "cfachina.org/"
            ]
          }
        ],
        "name": "分析师园地",
        "maintainers": [
          "TonyRL"
        ],
        "description": "| 有色金属类 | 黑色金属类 | 能源化工类 | 贵金属类 | 农产品类 | 金融类 | 指数类 |\n| ---------- | ---------- | ---------- | -------- | -------- | ------ | ------ |\n| ysjsl      | hsjsl      | nyhgl      | gjsl     | ncpl     | jrl    | zsl    |",
        "location": "analygarden.ts",
        "module": () => import('@/routes/cfachina/analygarden.ts')
      }
    },
    "name": "中国期货业协会",
    "apiRoutes": {},
    "url": "cfachina.org",
    "lang": "zh-CN"
  },
  "cffex": {
    "routes": {
      "/announcement": {
        "path": "/announcement",
        "name": "交易所公告",
        "url": "www.cffex.com.cn",
        "maintainers": [
          "ChenXiangcheng1"
        ],
        "example": "/cffex/announcement",
        "parameters": {},
        "description": "",
        "categories": [
          "government"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "cffex.com.cn"
            ],
            "target": "/announcement"
          }
        ],
        "location": "announcement.ts",
        "module": () => import('@/routes/cffex/announcement.ts')
      }
    },
    "name": "中国金融期货交易所",
    "apiRoutes": {},
    "url": "cffex.com.cn",
    "lang": "zh-CN"
  },
  "cfmmc": {
    "routes": {
      "/:id{.+}?": {
        "path": "/:id{.+}?",
        "name": "Unknown",
        "maintainers": [],
        "location": "index.ts",
        "module": () => import('@/routes/cfmmc/index.ts')
      }
    },
    "name": "中国期货市场监控中心",
    "apiRoutes": {},
    "url": "cfmmc.com",
    "lang": "zh-CN"
  },
  "cfr": {
    "routes": {
      "/:category/:subCategory?": {
        "path": "/:category/:subCategory?",
        "categories": [
          "traditional-media"
        ],
        "parameters": {
          "category": "category, find it in the URL",
          "subCategory": "sub-category, find it in the URL"
        },
        "example": "/cfr/asia",
        "name": "News",
        "maintainers": [
          "KarasuShin"
        ],
        "radar": [
          {
            "source": [
              "www.cfr.org/:category",
              "www.cfr.org/:category/:subCategory"
            ],
            "target": "/:category/:subCategory?"
          }
        ],
        "features": {
          "antiCrawler": true
        },
        "location": "index.ts",
        "module": () => import('@/routes/cfr/index.ts')
      }
    },
    "name": "Council on Foreign Relations",
    "apiRoutes": {},
    "url": "www.cfr.org",
    "lang": "en"
  },
  "cgtn": {
    "routes": {
      "/podcast/:category/:id": {
        "path": "/podcast/:category/:id",
        "categories": [
          "traditional-media"
        ],
        "example": "/cgtn/podcast/ezfm/4",
        "parameters": {
          "category": "类型名",
          "id": "播客 id"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "cgtn.com/podcast/column/:category/*/:id"
            ]
          }
        ],
        "name": "播客",
        "maintainers": [
          "5upernova-heng"
        ],
        "description": "> 类型名与播客 id 可以在播客对应的 URL 中找到\n  > 如 URL `https://radio.cgtn.com/podcast/column/ezfm/More-to-Read/4` ，其 `category` 为 `ezfm` ，`id` 为 `4`，对应的订阅路由为 [`/podcast/ezfm/4`](https://rsshub.app/podcast/ezfm/4)",
        "location": "podcast.ts",
        "module": () => import('@/routes/cgtn/podcast.ts')
      }
    },
    "name": "中国环球电视网",
    "url": "cgtn.com",
    "lang": "zh-CN"
  },
  "chaincatcher": {
    "routes": {
      "/": {
        "path": "/",
        "radar": [
          {
            "source": [
              "chaincatcher.com/"
            ],
            "target": ""
          }
        ],
        "name": "Unknown",
        "maintainers": [
          "TonyRL"
        ],
        "url": "chaincatcher.com/",
        "location": "home.tsx",
        "module": () => import('@/routes/chaincatcher/home.tsx')
      },
      "/news": {
        "path": "/news",
        "categories": [
          "new-media"
        ],
        "example": "/chaincatcher/news",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "chaincatcher.com/news",
              "chaincatcher.com/"
            ]
          }
        ],
        "name": "快讯",
        "maintainers": [
          "TonyRL"
        ],
        "url": "chaincatcher.com/news",
        "location": "news.ts",
        "module": () => import('@/routes/chaincatcher/news.ts')
      }
    },
    "name": "链捕手 ChainCatcher",
    "apiRoutes": {},
    "url": "chaincatcher.com",
    "lang": "zh-CN"
  },
  "changba": {
    "routes": {
      "/:userid": {
        "path": "/:userid",
        "categories": [
          "social-media"
        ],
        "view": 4,
        "example": "/changba/skp6hhF59n48R-UpqO3izw",
        "parameters": {
          "userid": "用户ID, 可在对应分享页面的 URL 中找到"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": true,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "changba.com/s/:userid"
            ]
          }
        ],
        "name": "用户",
        "maintainers": [
          "kt286",
          "xizeyoupan",
          "pseudoyu"
        ],
        "location": "user.tsx",
        "module": () => import('@/routes/changba/user.tsx')
      }
    },
    "name": "唱吧",
    "url": "changba.com",
    "lang": "zh-CN"
  },
  "chaoxing": {
    "routes": {
      "/qk/:id/:needContent?": {
        "path": "/qk/:id/:needContent?",
        "categories": [
          "reading"
        ],
        "example": "/chaoxing/qk/6b5c39b3dd84352be512e29df0297437",
        "parameters": {
          "id": "期刊 id，可在期刊页 URL 中找到",
          "needContent": "需要获取文章全文，填写 true/yes 表示需要，默认需要"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "期刊",
        "maintainers": [
          "nczitzk"
        ],
        "description": "::: tip\n  全部期刊可以在 [这里](http://qk.chaoxing.com/space/index) 找到，你也可以从 [学科分类](https://qikan.chaoxing.com/jourclassify) 和 [期刊导航](https://qikan.chaoxing.com/search/openmag) 中发现更多期刊。\n\n  如订阅 [**上海文艺**](http://m.chaoxing.com/mqk/list?sw=&mags=6b5c39b3dd84352be512e29df0297437&isort=20&from=space)，其 URL 为 `http://m.chaoxing.com/mqk/list?mags=6b5c39b3dd84352be512e29df0297437`。`6b5c39b3dd84352be512e29df0297437` 即为期刊 id，所得路由为 [`/chaoxing/qk/6b5c39b3dd84352be512e29df0297437`](https://rsshub.app/chaoxing/qk/6b5c39b3dd84352be512e29df0297437)\n:::\n\n::: warning\n  你可以设置参数 **需要获取文章全文** 为 `true` `yes` `t` `y` 等值（或者忽略这个参数），RSS 的条目会携带期刊中的 **文章全文**，而不仅仅是 **文章概要**。但因为发起访问请求过多会被该网站屏蔽，你可以将其关闭（设置该参数为 `false` `no` `f` `n` 等值），这将会大大减少请求次数从而更难触发网站的反爬机制。\n\n  路由默认会获取 **30** 个条目。在路由后指定 `?limit=<条目数量>` 减少或增加单次获取条目数量，同样可以减少请求次数，如设置为一次获取 **10** 个条目，路由可以更改为 [`/chaoxing/qk/6b5c39b3dd84352be512e29df0297437?limit=10`](https://rsshub.app/chaoxing/qk/6b5c39b3dd84352be512e29df0297437?limit=10)\n\n  在根据上文设置 **需要获取文章全文** 为不需要时，你可以将 `limit` 值增大，从而获取更多的条目，此时因为不获取全文也不会触发反爬机制，如 [`/chaoxing/qk/6b5c39b3dd84352be512e29df0297437/false?limit=100`](https://rsshub.app/chaoxing/qk/6b5c39b3dd84352be512e29df0297437/false?limit=100)\n:::",
        "location": "qk.tsx",
        "module": () => import('@/routes/chaoxing/qk.tsx')
      }
    },
    "name": "超星",
    "url": "chaoxing.com",
    "lang": "zh-CN"
  },
  "chaping": {
    "routes": {
      "/banner": {
        "path": "/banner",
        "categories": [
          "new-media"
        ],
        "example": "/chaping/banner",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "chaping.cn/"
            ]
          }
        ],
        "name": "图片墙",
        "maintainers": [
          "nczitzk"
        ],
        "url": "chaping.cn/",
        "location": "banner.ts",
        "module": () => import('@/routes/chaping/banner.ts')
      },
      "/news/:caty?": {
        "path": "/news/:caty?",
        "categories": [
          "new-media"
        ],
        "example": "/chaping/news/15",
        "parameters": {
          "caty": "分类，默认为全部资讯"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "资讯",
        "maintainers": [
          "nczitzk"
        ],
        "description": "| 编号 | 分类       |\n| ---- | ---------- |\n| 15   | 直播       |\n| 3    | 科技新鲜事 |\n| 7    | 互联网槽点 |\n| 5    | 趣味科技   |\n| 6    | DEBUG TIME |\n| 1    | 游戏       |\n| 8    | 视频       |\n| 9    | 公里每小时 |",
        "location": "news.ts",
        "module": () => import('@/routes/chaping/news.ts')
      },
      "/newsflash": {
        "path": "/newsflash",
        "categories": [
          "new-media"
        ],
        "example": "/chaping/newsflash",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "chaping.cn/newsflash"
            ]
          }
        ],
        "name": "快讯",
        "maintainers": [
          "Fatpandac"
        ],
        "url": "chaping.cn/newsflash",
        "location": "newsflash.ts",
        "module": () => import('@/routes/chaping/newsflash.ts')
      }
    },
    "name": "差评",
    "apiRoutes": {},
    "url": "chaping.cn",
    "lang": "zh-CN"
  },
  "cherrytimes": {
    "routes": {
      "/market": {
        "path": "/market",
        "categories": [
          "new-media"
        ],
        "example": "/cherrytimes/market",
        "name": "Market",
        "maintainers": [
          "canonnizq"
        ],
        "location": "market.ts",
        "module": () => import('@/routes/cherrytimes/market.ts')
      }
    },
    "name": "Cherry Times",
    "apiRoutes": {},
    "url": "cherrytimes.it"
  },
  "chiculture": {
    "routes": {
      "/topic/:category?": {
        "path": "/topic/:category?",
        "categories": [
          "new-media"
        ],
        "example": "/chiculture/topic",
        "parameters": {
          "category": "分类，见下表，默认为全部"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "議題熱話",
        "maintainers": [
          "nczitzk"
        ],
        "description": "| 全部 | 現代中國 | 今日香港 | 全球化 | 一周時事通識 |\n| ---- | -------- | -------- | ------ | ------------ |\n|      | 76       | 479      | 480    | 379          |",
        "location": "topic.ts",
        "module": () => import('@/routes/chiculture/topic.ts')
      }
    },
    "name": "通識・現代中國",
    "url": "chiculture.org.hk",
    "lang": "zh-HK"
  },
  "chikubi": {
    "routes": {
      "/category/:keyword": {
        "path": "/category/:keyword",
        "categories": [
          "multimedia"
        ],
        "example": "/chikubi/category/nipple-lesbian",
        "parameters": {
          "keyword": "Keyword"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false,
          "nsfw": true
        },
        "name": "Category",
        "maintainers": [
          "SnowAgar25"
        ],
        "radar": [
          {
            "title": "Category",
            "source": [
              "chikubi.jp/category/:keyword"
            ],
            "target": "/category/:keyword"
          }
        ],
        "location": "category.ts",
        "module": () => import('@/routes/chikubi/category.ts')
      },
      "/": {
        "path": "/",
        "categories": [
          "multimedia"
        ],
        "example": "/chikubi",
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false,
          "nsfw": true
        },
        "name": "最新記事",
        "maintainers": [
          "SnowAgar25"
        ],
        "radar": [
          {
            "title": "最新記事",
            "source": [
              "chikubi.jp/"
            ],
            "target": "/"
          },
          {
            "title": "殿堂",
            "source": [
              "chikubi.jp/best-nipple-article"
            ],
            "target": "/best"
          },
          {
            "title": "動畫",
            "source": [
              "chikubi.jp/nipple-video"
            ],
            "target": "/video"
          },
          {
            "title": "VR",
            "source": [
              "chikubi.jp/nipple-video-category/cat-nipple-video-vr"
            ],
            "target": "/vr"
          },
          {
            "title": "漫畫",
            "source": [
              "chikubi.jp/comic"
            ],
            "target": "/comic"
          },
          {
            "title": "音聲",
            "source": [
              "chikubi.jp/voice"
            ],
            "target": "/voice"
          },
          {
            "title": "CG・イラスト",
            "source": [
              "chikubi.jp/cg"
            ],
            "target": "/cg"
          }
        ],
        "location": "index.ts",
        "module": () => import('@/routes/chikubi/index.ts')
      },
      "/:keyword": {
        "path": "/:keyword",
        "categories": [
          "multimedia"
        ],
        "example": "/chikubi",
        "parameters": {
          "keyword": "導覽列，見下表，默認爲最新"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false,
          "nsfw": true
        },
        "name": "Navigation",
        "maintainers": [
          "SnowAgar25"
        ],
        "description": "| 殿堂 | 動畫 | VR | 漫畫 | 音聲 | CG・イラスト |\n| ---- | ----- | -- | ----- | ----- | -- |\n| best | video | vr | comic | voice | cg |",
        "location": "navigation.ts",
        "module": () => import('@/routes/chikubi/navigation.ts')
      },
      "/nipple-video-category/:keyword": {
        "path": "/nipple-video-category/:keyword",
        "categories": [
          "multimedia"
        ],
        "example": "/chikubi/nipple-video-category/cat-nipple-video-god",
        "parameters": {
          "keyword": "Keyword"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false,
          "nsfw": true
        },
        "name": "動画カテゴリー",
        "maintainers": [
          "SnowAgar25"
        ],
        "radar": [
          {
            "title": "動画カテゴリー",
            "source": [
              "chikubi.jp/nipple-video-category/:keyword"
            ],
            "target": "/nipple-video-category/:keyword"
          }
        ],
        "location": "nipple-video-category.ts",
        "module": () => import('@/routes/chikubi/nipple-video-category.ts')
      },
      "/nipple-video-maker/:keyword": {
        "path": "/nipple-video-maker/:keyword",
        "categories": [
          "multimedia"
        ],
        "example": "/chikubi/nipple-video-maker/nipple-video-maker-nh",
        "parameters": {
          "keyword": "Keyword"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false,
          "nsfw": true
        },
        "name": "AVメーカー",
        "maintainers": [
          "SnowAgar25"
        ],
        "radar": [
          {
            "title": "AVメーカー",
            "source": [
              "chikubi.jp/nipple-video-maker/:keyword"
            ],
            "target": "/nipple-video-maker/:keyword"
          }
        ],
        "location": "nipple-video-maker.ts",
        "module": () => import('@/routes/chikubi/nipple-video-maker.ts')
      },
      "/search/:keyword": {
        "path": "/search/:keyword",
        "categories": [
          "multimedia"
        ],
        "example": "/chikubi/search/ギャップ",
        "parameters": {
          "keyword": "Keyword"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false,
          "nsfw": true
        },
        "name": "Search",
        "maintainers": [
          "SnowAgar25"
        ],
        "location": "search.ts",
        "module": () => import('@/routes/chikubi/search.ts')
      },
      "/tag/:keyword": {
        "path": "/tag/:keyword",
        "categories": [
          "multimedia"
        ],
        "example": "/chikubi/tag/ドリームチケット",
        "parameters": {
          "keyword": "Keyword"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false,
          "nsfw": true
        },
        "name": "Tag",
        "maintainers": [
          "SnowAgar25"
        ],
        "radar": [
          {
            "title": "Tag",
            "source": [
              "chikubi.jp/tag/:keyword"
            ],
            "target": "/tag/:keyword"
          }
        ],
        "location": "tag.ts",
        "module": () => import('@/routes/chikubi/tag.ts')
      }
    },
    "name": "乳首ふぇち",
    "apiRoutes": {},
    "url": "chikubi.jp",
    "description": "::: tip\nThe content of 乳首ふぇち is divided into two parts:\n\nWorks: Only reposts official product descriptions.\nPosts: Contains the website author's thoughts and additional information.\n\nSometimes a product may exist in both posts and works.\nSometimes there might be only a single post without any reposted work, and vice versa.\n:::",
    "lang": "ja"
  },
  "china": {
    "routes": {
      "/finance/:category?": {
        "path": "/finance/:category?",
        "categories": [
          "new-media"
        ],
        "example": "/china/finance",
        "parameters": {
          "category": "Category of news. See the form below for details, default is suggest news."
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "finance.china.com/:category"
            ]
          }
        ],
        "name": "Finance News 财经 - 财经新闻",
        "maintainers": [
          "KingJem"
        ],
        "description": "| 推荐    | TMT | 金融    | 地产   | 消费    | 医药  | 酒业 | IPO 观察 |\n| ------- | --- | ------- | ------ | ------- | ----- | ---- | -------- |\n| tuijian | TMT | jinrong | dichan | xiaofei | yiyao | wine | IPO      |\n\n  > Note: The default news num is `30`.\n\n  > 注意：默认新闻条数是 `30`。",
        "location": "finance/finance.ts",
        "module": () => import('@/routes/china/finance/finance.ts')
      },
      "/news/:category?": {
        "path": "/news/:category?",
        "categories": [
          "new-media"
        ],
        "example": "/china/news",
        "parameters": {
          "category": "Category of news. See the form below for details, default is china news."
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "news.china.com/:category"
            ]
          }
        ],
        "name": "News and current affairs 时事新闻",
        "maintainers": [
          "jiaaoMario"
        ],
        "description": "Category of news\n\n| China News | International News | Social News | Breaking News |\n| ---------- | ------------------ | ----------- | ------------- |\n| domestic   | international      | social      | news100       |",
        "location": "news/highlights/news.ts",
        "module": () => import('@/routes/china/news/highlights/news.ts')
      },
      "/news/military": {
        "path": "/news/military",
        "categories": [
          "new-media"
        ],
        "example": "/china/news/military",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "military.china.com/news"
            ]
          }
        ],
        "name": "Military - Military News 军事 - 军事新闻",
        "maintainers": [
          "jiaaoMario"
        ],
        "url": "military.china.com/news",
        "location": "news/military/news.ts",
        "module": () => import('@/routes/china/news/military/news.ts')
      }
    },
    "name": "China.com 中华网",
    "apiRoutes": {},
    "url": "finance.china.com",
    "lang": "zh-CN"
  },
  "chinacdc": {
    "routes": {
      "/:category{.+}?": {
        "path": "/:category{.+}?",
        "name": "通用",
        "url": "www.chinacdc.cn",
        "maintainers": [
          "nczitzk"
        ],
        "example": "/chinacdc/zxyw",
        "parameters": {
          "category": "分类，默认为 `zxyw`，即中心要闻，可在对应分类页 URL 中找到，Category, `zxyw`，即中心要闻 by default"
        },
        "description": "::: tip\n若订阅 [中心要闻](https://www.chinacdc.cn/zxyw/)，网址为 `https://www.chinacdc.cn/zxyw/`，请截取 `https://www.chinacdc.cn/` 到末尾 `/` 的部分 `zxyw` 作为 `category` 参数填入，此时目标路由为 [`/chinacdc/zxyw`](https://rsshub.app/chinacdc/zxyw)。\n:::\n\n| [中心要闻](https://www.chinacdc.cn/zxyw/) | [通知公告](https://www.chinacdc.cn/tzgg/) |\n| ----------------------------------------- | ----------------------------------------- |\n| [zxyw](https://rsshub.app/chinacdc/zxyw)  | [tzgg](https://rsshub.app/chinacdc/tzgg)  |\n\n<details>\n<summary>更多分类</summary>\n\n#### [党建园地](https://www.chinacdc.cn/dqgz/djgz/)\n\n| [党建工作](https://www.chinacdc.cn/dqgz/djgz/)     | [廉政文化](https://www.chinacdc.cn/djgz_13611/)                | [工会工作](https://www.chinacdc.cn/ghgz/)          | [团青工作](https://www.chinacdc.cn/tqgz/)          | [理论学习](https://www.chinacdc.cn/tqgz_13618/)                |\n| -------------------------------------------------- | -------------------------------------------------------------- | -------------------------------------------------- | -------------------------------------------------- | -------------------------------------------------------------- |\n| [dqgz/djgz](https://rsshub.app/chinacdc/dqgz/djgz) | [dqgz/djgz_13611](https://rsshub.app/chinacdc/dqgz/djgz_13611) | [dqgz/ghgz](https://rsshub.app/chinacdc/dqgz/ghgz) | [dqgz/tqgz](https://rsshub.app/chinacdc/dqgz/tqgz) | [dqgz/tqgz_13618](https://rsshub.app/chinacdc/dqgz/tqgz_13618) |\n\n#### [疾控应急](https://www.chinacdc.cn/jkyj/)\n\n| [传染病](https://www.chinacdc.cn/jkyj/crb2/)       | [突发公共卫生事件](https://www.chinacdc.cn/jkyj/tfggws/) | [慢性病与伤害防控](https://www.chinacdc.cn/jkyj/mxfcrxjb2/)  | [烟草控制](https://www.chinacdc.cn/jkyj/yckz/)     | [营养与健康](https://www.chinacdc.cn/jkyj/yyyjk2/)     |\n| -------------------------------------------------- | -------------------------------------------------------- | ------------------------------------------------------------ | -------------------------------------------------- | ------------------------------------------------------ |\n| [jkyj/crb2](https://rsshub.app/chinacdc/jkyj/crb2) | [jkyj/tfggws](https://rsshub.app/chinacdc/jkyj/tfggws)   | [jkyj/mxfcrxjb2](https://rsshub.app/chinacdc/jkyj/mxfcrxjb2) | [jkyj/yckz](https://rsshub.app/chinacdc/jkyj/yckz) | [jkyj/yyyjk2](https://rsshub.app/chinacdc/jkyj/yyyjk2) |\n\n| [环境与健康](https://www.chinacdc.cn/jkyj/hjyjk/)    | [职业卫生与中毒控制](https://www.chinacdc.cn/jkyj/hjwsyzdkz/) | [放射卫生](https://www.chinacdc.cn/jkyj/fsws/)     | [免疫规划](https://www.chinacdc.cn/jkyj/mygh02/)       | [结核病防控](https://www.chinacdc.cn/jkyj/jhbfk/)    |\n| ---------------------------------------------------- | ------------------------------------------------------------- | -------------------------------------------------- | ------------------------------------------------------ | ---------------------------------------------------- |\n| [jkyj/hjyjk](https://rsshub.app/chinacdc/jkyj/hjyjk) | [jkyj/hjwsyzdkz](https://rsshub.app/chinacdc/jkyj/hjwsyzdkz)  | [jkyj/fsws](https://rsshub.app/chinacdc/jkyj/fsws) | [jkyj/mygh02](https://rsshub.app/chinacdc/jkyj/mygh02) | [jkyj/jhbfk](https://rsshub.app/chinacdc/jkyj/jhbfk) |\n\n| [寄生虫病](https://www.chinacdc.cn/jkyj/jscb/)     |\n| -------------------------------------------------- |\n| [jkyj/jscb](https://rsshub.app/chinacdc/jkyj/jscb) |\n\n#### [科学研究](https://www.chinacdc.cn/kxyj/)\n\n| [科技进展](https://www.chinacdc.cn/kxyj/kjjz/)     | [学术动态](https://www.chinacdc.cn/kxyj/xsdt/)     | [科研平台](https://www.chinacdc.cn/kxyj/xsjl/)     | [科研亮点](https://www.chinacdc.cn/kxyj/kyld/)     | [科技政策](https://www.chinacdc.cn/kxyj/kjzc/)     |\n| -------------------------------------------------- | -------------------------------------------------- | -------------------------------------------------- | -------------------------------------------------- | -------------------------------------------------- |\n| [kxyj/kjjz](https://rsshub.app/chinacdc/kxyj/kjjz) | [kxyj/xsdt](https://rsshub.app/chinacdc/kxyj/xsdt) | [kxyj/xsjl](https://rsshub.app/chinacdc/kxyj/xsjl) | [kxyj/kyld](https://rsshub.app/chinacdc/kxyj/kyld) | [kxyj/kjzc](https://rsshub.app/chinacdc/kxyj/kjzc) |\n\n#### [教育培训](https://www.chinacdc.cn/jypx/)\n\n| [研究生院](https://www.chinacdc.cn/jypx/yjsy/)     | [继续教育](https://www.chinacdc.cn/jypx/jxjy/)     | [博士后](https://www.chinacdc.cn/jypx/bsh/)      | [中国现场流行病学培训项目（CFETP）](https://www.chinacdc.cn/jypx/CFETP/) |\n| -------------------------------------------------- | -------------------------------------------------- | ------------------------------------------------ | ------------------------------------------------------------------------ |\n| [jypx/yjsy](https://rsshub.app/chinacdc/jypx/yjsy) | [jypx/jxjy](https://rsshub.app/chinacdc/jypx/jxjy) | [jypx/bsh](https://rsshub.app/chinacdc/jypx/bsh) | [jypx/CFETP](https://rsshub.app/chinacdc/jypx/CFETP)                     |\n\n#### [全球公卫](https://www.chinacdc.cn/qqgw/)\n\n| [合作伙伴](https://www.chinacdc.cn/qqgw/hzhb/)     | [世界卫生组织合作中心和参比实验室](https://www.chinacdc.cn/qqgw/wszz/) | [国际交流 (港澳台交流)](https://www.chinacdc.cn/qqgw/gjjl/) | [公共卫生援外与合作](https://www.chinacdc.cn/qqgw/ggws/) |\n| -------------------------------------------------- | ---------------------------------------------------------------------- | ---------------------------------------------------------- | -------------------------------------------------------- |\n| [qqgw/hzhb](https://rsshub.app/chinacdc/qqgw/hzhb) | [qqgw/wszz](https://rsshub.app/chinacdc/qqgw/wszz)                     | [qqgw/gjjl](https://rsshub.app/chinacdc/qqgw/gjjl)         | [qqgw/ggws](https://rsshub.app/chinacdc/qqgw/ggws)       |\n\n#### [人才建设](https://www.chinacdc.cn/rcjs/)\n\n| [院士风采](https://www.chinacdc.cn/rcjs/ysfc/)     | [首席专家](https://www.chinacdc.cn/rcjs/sxzj/)     | [人才队伍](https://www.chinacdc.cn/rcjs/rcdw/)     | [人才招聘](https://www.chinacdc.cn/rcjs/rczp/)     |\n| -------------------------------------------------- | -------------------------------------------------- | -------------------------------------------------- | -------------------------------------------------- |\n| [rcjs/ysfc](https://rsshub.app/chinacdc/rcjs/ysfc) | [rcjs/sxzj](https://rsshub.app/chinacdc/rcjs/sxzj) | [rcjs/rcdw](https://rsshub.app/chinacdc/rcjs/rcdw) | [rcjs/rczp](https://rsshub.app/chinacdc/rcjs/rczp) |\n\n#### [健康数据](https://www.chinacdc.cn/jksj/)\n\n| [全国法定传染病疫情情况](https://www.chinacdc.cn/jksj/jksj01/) | [全国新型冠状病毒感染疫情情况](https://www.chinacdc.cn/jksj/xgbdyq/) | [重点传染病和突发公共卫生事件风险评估报告](https://www.chinacdc.cn/jksj/jksj02/) | [全球传染病事件风险评估报告](https://www.chinacdc.cn/jksj/jksj03/) | [全国预防接种异常反应监测信息概况](https://www.chinacdc.cn/jksj/jksj04_14209/) |\n| -------------------------------------------------------------- | -------------------------------------------------------------------- | -------------------------------------------------------------------------------- | ------------------------------------------------------------------ | ------------------------------------------------------------------------------ |\n| [jksj/jksj01](https://rsshub.app/chinacdc/jksj/jksj01)         | [jksj/xgbdyq](https://rsshub.app/chinacdc/jksj/xgbdyq)               | [jksj/jksj02](https://rsshub.app/chinacdc/jksj/jksj02)                           | [jksj/jksj03](https://rsshub.app/chinacdc/jksj/jksj03)             | [jksj/jksj04_14209](https://rsshub.app/chinacdc/jksj/jksj04_14209)             |\n\n| [流感监测周报](https://www.chinacdc.cn/jksj/jksj04_14249/)         | [全国急性呼吸道传染病哨点监测情况](https://www.chinacdc.cn/jksj/jksj04_14275/) | [健康报告](https://www.chinacdc.cn/jksj/jksj04/)       |\n| ------------------------------------------------------------------ | ------------------------------------------------------------------------------ | ------------------------------------------------------ |\n| [jksj/jksj04_14249](https://rsshub.app/chinacdc/jksj/jksj04_14249) | [jksj/jksj04_14275](https://rsshub.app/chinacdc/jksj/jksj04_14275)             | [jksj/jksj04](https://rsshub.app/chinacdc/jksj/jksj04) |\n\n#### [健康科普](https://www.chinacdc.cn/jkkp/)\n\n| [传染病](https://www.chinacdc.cn/jkkp/crb/)      | [慢性非传染性疾病](https://www.chinacdc.cn/jkkp/mxfcrb/) | [免疫规划](https://www.chinacdc.cn/jkkp/mygh/)     | [公共卫生事件](https://www.chinacdc.cn/jkkp/ggws/) | [烟草控制](https://www.chinacdc.cn/jkkp/yckz/)     |\n| ------------------------------------------------ | -------------------------------------------------------- | -------------------------------------------------- | -------------------------------------------------- | -------------------------------------------------- |\n| [jkkp/crb](https://rsshub.app/chinacdc/jkkp/crb) | [jkkp/mxfcrb](https://rsshub.app/chinacdc/jkkp/mxfcrb)   | [jkkp/mygh](https://rsshub.app/chinacdc/jkkp/mygh) | [jkkp/ggws](https://rsshub.app/chinacdc/jkkp/ggws) | [jkkp/yckz](https://rsshub.app/chinacdc/jkkp/yckz) |\n\n| [营养与健康](https://www.chinacdc.cn/jkkp/yyjk/)   | [环境健康](https://www.chinacdc.cn/jkkp/hjjk/)     | [职业健康与中毒控制](https://www.chinacdc.cn/jkkp/zyjk/) | [放射卫生](https://www.chinacdc.cn/jkkp/fsws/)     |\n| -------------------------------------------------- | -------------------------------------------------- | -------------------------------------------------------- | -------------------------------------------------- |\n| [jkkp/yyjk](https://rsshub.app/chinacdc/jkkp/yyjk) | [jkkp/hjjk](https://rsshub.app/chinacdc/jkkp/hjjk) | [jkkp/zyjk](https://rsshub.app/chinacdc/jkkp/zyjk)       | [jkkp/fsws](https://rsshub.app/chinacdc/jkkp/fsws) |\n\n</details>\n",
        "categories": [
          "government"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.chinacdc.cn/:category"
            ]
          },
          {
            "title": "中心要闻",
            "source": [
              "www.chinacdc.cn/zxyw/"
            ],
            "target": "/zxyw"
          },
          {
            "title": "通知公告",
            "source": [
              "www.chinacdc.cn/tzgg/"
            ],
            "target": "/tzgg"
          },
          {
            "title": "党建园地 - 廉政文化",
            "source": [
              "www.chinacdc.cn/djgz_13611/"
            ],
            "target": "/dqgz/djgz_13611"
          },
          {
            "title": "党建园地 - 党建工作",
            "source": [
              "www.chinacdc.cn/dqgz/"
            ],
            "target": "/dqgz/djgz"
          },
          {
            "title": "党建园地 - 廉政文化",
            "source": [
              "www.chinacdc.cn/djgz_13611/"
            ],
            "target": "/dqgz/djgz_13611"
          },
          {
            "title": "党建园地 - 工会工作",
            "source": [
              "www.chinacdc.cn/ghgz/"
            ],
            "target": "/dqgz/ghgz"
          },
          {
            "title": "党建园地 - 团青工作",
            "source": [
              "www.chinacdc.cn/tqgz/"
            ],
            "target": "/dqgz/tqgz"
          },
          {
            "title": "党建园地 - 理论学习",
            "source": [
              "www.chinacdc.cn/tqgz_13618/"
            ],
            "target": "/dqgz/tqgz_13618"
          },
          {
            "title": "疾控应急 - 传染病",
            "source": [
              "www.chinacdc.cn/jkyj/crb2/"
            ],
            "target": "/jkyj/crb2"
          },
          {
            "title": "疾控应急 - 突发公共卫生事件",
            "source": [
              "www.chinacdc.cn/jkyj/tfggws/"
            ],
            "target": "/jkyj/tfggws"
          },
          {
            "title": "疾控应急 - 慢性病与伤害防控",
            "source": [
              "www.chinacdc.cn/jkyj/mxfcrxjb2/"
            ],
            "target": "/jkyj/mxfcrxjb2"
          },
          {
            "title": "疾控应急 - 烟草控制",
            "source": [
              "www.chinacdc.cn/jkyj/yckz/"
            ],
            "target": "/jkyj/yckz"
          },
          {
            "title": "疾控应急 - 营养与健康",
            "source": [
              "www.chinacdc.cn/jkyj/yyyjk2/"
            ],
            "target": "/jkyj/yyyjk2"
          },
          {
            "title": "疾控应急 - 环境与健康",
            "source": [
              "www.chinacdc.cn/jkyj/hjyjk/"
            ],
            "target": "/jkyj/hjyjk"
          },
          {
            "title": "疾控应急 - 职业卫生与中毒控制",
            "source": [
              "www.chinacdc.cn/jkyj/hjwsyzdkz/"
            ],
            "target": "/jkyj/hjwsyzdkz"
          },
          {
            "title": "疾控应急 - 放射卫生",
            "source": [
              "www.chinacdc.cn/jkyj/fsws/"
            ],
            "target": "/jkyj/fsws"
          },
          {
            "title": "疾控应急 - 免疫规划",
            "source": [
              "www.chinacdc.cn/jkyj/mygh02/"
            ],
            "target": "/jkyj/mygh02"
          },
          {
            "title": "疾控应急 - 结核病防控",
            "source": [
              "www.chinacdc.cn/jkyj/jhbfk/"
            ],
            "target": "/jkyj/jhbfk"
          },
          {
            "title": "疾控应急 - 寄生虫病",
            "source": [
              "www.chinacdc.cn/jkyj/jscb/"
            ],
            "target": "/jkyj/jscb"
          },
          {
            "title": "科学研究 - 科技进展",
            "source": [
              "www.chinacdc.cn/kxyj/kjjz/"
            ],
            "target": "/kxyj/kjjz"
          },
          {
            "title": "科学研究 - 学术动态",
            "source": [
              "www.chinacdc.cn/kxyj/xsdt/"
            ],
            "target": "/kxyj/xsdt"
          },
          {
            "title": "科学研究 - 科研平台",
            "source": [
              "www.chinacdc.cn/kxyj/xsjl/"
            ],
            "target": "/kxyj/xsjl"
          },
          {
            "title": "科学研究 - 科研亮点",
            "source": [
              "www.chinacdc.cn/kxyj/kyld/"
            ],
            "target": "/kxyj/kyld"
          },
          {
            "title": "科学研究 - 科技政策",
            "source": [
              "www.chinacdc.cn/kxyj/kjzc/"
            ],
            "target": "/kxyj/kjzc"
          },
          {
            "title": "教育培训 - 研究生院",
            "source": [
              "www.chinacdc.cn/jypx/yjsy/"
            ],
            "target": "/jypx/yjsy"
          },
          {
            "title": "教育培训 - 继续教育",
            "source": [
              "www.chinacdc.cn/jypx/jxjy/"
            ],
            "target": "/jypx/jxjy"
          },
          {
            "title": "教育培训 - 博士后",
            "source": [
              "www.chinacdc.cn/jypx/bsh/"
            ],
            "target": "/jypx/bsh"
          },
          {
            "title": "教育培训 - 中国现场流行病学培训项目（CFETP）",
            "source": [
              "www.chinacdc.cn/jypx/CFETP/"
            ],
            "target": "/jypx/CFETP"
          },
          {
            "title": "全球公卫 - 合作伙伴",
            "source": [
              "www.chinacdc.cn/qqgw/hzhb/"
            ],
            "target": "/qqgw/hzhb"
          },
          {
            "title": "全球公卫 - 世界卫生组织合作中心和参比实验室",
            "source": [
              "www.chinacdc.cn/qqgw/wszz/"
            ],
            "target": "/qqgw/wszz"
          },
          {
            "title": "全球公卫 - 国际交流 (港澳台交流)",
            "source": [
              "www.chinacdc.cn/qqgw/gjjl/"
            ],
            "target": "/qqgw/gjjl"
          },
          {
            "title": "全球公卫 - 公共卫生援外与合作",
            "source": [
              "www.chinacdc.cn/qqgw/ggws/"
            ],
            "target": "/qqgw/ggws"
          },
          {
            "title": "人才建设 - 院士风采",
            "source": [
              "www.chinacdc.cn/rcjs/ysfc/"
            ],
            "target": "/rcjs/ysfc"
          },
          {
            "title": "人才建设 - 首席专家",
            "source": [
              "www.chinacdc.cn/rcjs/sxzj/"
            ],
            "target": "/rcjs/sxzj"
          },
          {
            "title": "人才建设 - 人才队伍",
            "source": [
              "www.chinacdc.cn/rcjs/rcdw/"
            ],
            "target": "/rcjs/rcdw"
          },
          {
            "title": "人才建设 - 人才招聘",
            "source": [
              "www.chinacdc.cn/rcjs/rczp/"
            ],
            "target": "/rcjs/rczp"
          },
          {
            "title": "健康数据 - 全国法定传染病疫情情况",
            "source": [
              "www.chinacdc.cn/jksj/jksj01/"
            ],
            "target": "/jksj/jksj01"
          },
          {
            "title": "健康数据 - 全国新型冠状病毒感染疫情情况",
            "source": [
              "www.chinacdc.cn/jksj/xgbdyq/"
            ],
            "target": "/jksj/xgbdyq"
          },
          {
            "title": "健康数据 - 重点传染病和突发公共卫生事件风险评估报告",
            "source": [
              "www.chinacdc.cn/jksj/jksj02/"
            ],
            "target": "/jksj/jksj02"
          },
          {
            "title": "健康数据 - 全球传染病事件风险评估报告",
            "source": [
              "www.chinacdc.cn/jksj/jksj03/"
            ],
            "target": "/jksj/jksj03"
          },
          {
            "title": "健康数据 - 全国预防接种异常反应监测信息概况",
            "source": [
              "www.chinacdc.cn/jksj/jksj04_14209/"
            ],
            "target": "/jksj/jksj04_14209"
          },
          {
            "title": "健康数据 - 流感监测周报",
            "source": [
              "www.chinacdc.cn/jksj/jksj04_14249/"
            ],
            "target": "/jksj/jksj04_14249"
          },
          {
            "title": "健康数据 - 全国急性呼吸道传染病哨点监测情况",
            "source": [
              "www.chinacdc.cn/jksj/jksj04_14275/"
            ],
            "target": "/jksj/jksj04_14275"
          },
          {
            "title": "健康数据 - 健康报告",
            "source": [
              "www.chinacdc.cn/jksj/jksj04/"
            ],
            "target": "/jksj/jksj04"
          },
          {
            "title": "健康科普 - 传染病",
            "source": [
              "www.chinacdc.cn/jkkp/crb/"
            ],
            "target": "/jkkp/crb"
          },
          {
            "title": "健康科普 - 慢性非传染性疾病",
            "source": [
              "www.chinacdc.cn/jkkp/mxfcrb/"
            ],
            "target": "/jkkp/mxfcrb"
          },
          {
            "title": "健康科普 - 免疫规划",
            "source": [
              "www.chinacdc.cn/jkkp/mygh/"
            ],
            "target": "/jkkp/mygh"
          },
          {
            "title": "健康科普 - 公共卫生事件",
            "source": [
              "www.chinacdc.cn/jkkp/ggws/"
            ],
            "target": "/jkkp/ggws"
          },
          {
            "title": "健康科普 - 烟草控制",
            "source": [
              "www.chinacdc.cn/jkkp/yckz/"
            ],
            "target": "/jkkp/yckz"
          },
          {
            "title": "健康科普 - 营养与健康",
            "source": [
              "www.chinacdc.cn/jkkp/yyjk/"
            ],
            "target": "/jkkp/yyjk"
          },
          {
            "title": "健康科普 - 环境健康",
            "source": [
              "www.chinacdc.cn/jkkp/hjjk/"
            ],
            "target": "/jkkp/hjjk"
          },
          {
            "title": "健康科普 - 职业健康与中毒控制",
            "source": [
              "www.chinacdc.cn/jkkp/zyjk/"
            ],
            "target": "/jkkp/zyjk"
          },
          {
            "title": "健康科普 - 放射卫生",
            "source": [
              "www.chinacdc.cn/jkkp/fsws/"
            ],
            "target": "/jkkp/fsws"
          }
        ],
        "view": 0,
        "location": "index.ts",
        "module": () => import('@/routes/chinacdc/index.ts')
      }
    },
    "name": "中国疾病预防控制中心",
    "apiRoutes": {},
    "url": "www.chinacdc.cn",
    "categories": [
      "government"
    ],
    "description": "",
    "lang": "zh-CN"
  },
  "chinadaily": {
    "routes": {
      "/language/:category{.+}?": {
        "path": "/language/:category{.+}?",
        "name": "英语点津",
        "url": "language.chinadaily.com.cn",
        "maintainers": [
          "nczitzk"
        ],
        "example": "/chinadaily/language/thelatest",
        "parameters": {
          "category": {
            "description": "分类，默认为 `thelatest`，即精彩推荐，可在对应分类页 URL 中找到, Category, `thelatest`，即精彩推荐  by default",
            "options": [
              {
                "label": "精彩推荐",
                "value": "thelatest"
              },
              {
                "label": "每日一词",
                "value": "news_hotwords/word_of_the_day"
              },
              {
                "label": "双语新闻",
                "value": "news_bilingual"
              },
              {
                "label": "新闻热词",
                "value": "news_hotwords"
              },
              {
                "label": "实用口语",
                "value": "practice_tongue"
              },
              {
                "label": "译词课堂",
                "value": "trans_collect"
              },
              {
                "label": "图片新闻",
                "value": "news_photo"
              },
              {
                "label": "视频精选",
                "value": "video_links"
              },
              {
                "label": "新闻播报",
                "value": "audio_cd"
              },
              {
                "label": "专栏作家",
                "value": "columnist"
              },
              {
                "label": "权威发布",
                "value": "5af95d44a3103f6866ee845c"
              }
            ]
          }
        },
        "description": "::: tip\n若订阅 [精彩推荐](https://language.chinadaily.com.cn/thelatest)，网址为 `https://language.chinadaily.com.cn/thelatest`，请截取 `https://language.chinadaily.com.cn/` 到末尾的部分 `thelatest` 作为 `category` 参数填入，此时目标路由为 [`/chinadaily/language/thelatest`](https://rsshub.app/chinadaily/language/thelatest)。\n:::\n\n<details>\n  <summary>更多分类</summary>\n\n| 分类                                                                         | ID                                                                                                    |\n| ---------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------- |\n| [精彩推荐](https://language.chinadaily.com.cn/thelatest)                     | [thelatest](https://rsshub.app/chinadaily/language/thelatest)                                         |\n| [每日一词](https://language.chinadaily.com.cn/news_hotwords/word_of_the_day) | [news_hotwords/word_of_the_day](https://rsshub.app/chinadaily/language/news_hotwords/word_of_the_day) |\n| [双语新闻](https://language.chinadaily.com.cn/news_bilingual)                | [news_bilingual](https://rsshub.app/chinadaily/language/news_bilingual)                               |\n| [新闻热词](https://language.chinadaily.com.cn/news_hotwords)                 | [news_hotwords](https://rsshub.app/chinadaily/language/news_hotwords)                                 |\n| [实用口语](https://language.chinadaily.com.cn/practice_tongue)               | [practice_tongue](https://rsshub.app/chinadaily/language/practice_tongue)                             |\n| [译词课堂](https://language.chinadaily.com.cn/trans_collect)                 | [trans_collect](https://rsshub.app/chinadaily/language/trans_collect)                                 |\n| [图片新闻](https://language.chinadaily.com.cn/news_photo)                    | [news_photo](https://rsshub.app/chinadaily/language/news_photo)                                       |\n| [视频精选](https://language.chinadaily.com.cn/video_links)                   | [video_links](https://rsshub.app/chinadaily/language/video_links)                                     |\n| [新闻播报](https://language.chinadaily.com.cn/audio_cd)                      | [audio_cd](https://rsshub.app/chinadaily/language/audio_cd)                                           |\n| [专栏作家](https://language.chinadaily.com.cn/columnist)                     | [audio_cd](https://rsshub.app/chinadaily/language/columnist)                                          |\n| [权威发布](https://language.chinadaily.com.cn/5af95d44a3103f6866ee845c)      | [5af95d44a3103f6866ee845c](https://rsshub.app/chinadaily/language/5af95d44a3103f6866ee845c)           |\n\n</details>\n",
        "categories": [
          "traditional-media"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": true,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "language.chinadaily.com.cn/:category"
            ]
          },
          {
            "title": "精彩推荐",
            "source": [
              "language.chinadaily.com.cn/thelatest"
            ],
            "target": "/language/thelatest"
          },
          {
            "title": "每日一词",
            "source": [
              "language.chinadaily.com.cn/news_hotwords/word_of_the_day"
            ],
            "target": "/language/news_hotwords/word_of_the_day"
          },
          {
            "title": "双语新闻",
            "source": [
              "language.chinadaily.com.cn/news_bilingual"
            ],
            "target": "/language/news_bilingual"
          },
          {
            "title": "新闻热词",
            "source": [
              "language.chinadaily.com.cn/news_hotwords"
            ],
            "target": "/language/news_hotwords"
          },
          {
            "title": "实用口语",
            "source": [
              "language.chinadaily.com.cn/practice_tongue"
            ],
            "target": "/language/practice_tongue"
          },
          {
            "title": "译词课堂",
            "source": [
              "language.chinadaily.com.cn/trans_collect"
            ],
            "target": "/language/trans_collect"
          },
          {
            "title": "图片新闻",
            "source": [
              "language.chinadaily.com.cn/news_photo"
            ],
            "target": "/language/news_photo"
          },
          {
            "title": "视频精选",
            "source": [
              "language.chinadaily.com.cn/video_links"
            ],
            "target": "/language/video_links"
          },
          {
            "title": "新闻播报",
            "source": [
              "language.chinadaily.com.cn/audio_cd"
            ],
            "target": "/language/audio_cd"
          },
          {
            "title": "专栏作家",
            "source": [
              "language.chinadaily.com.cn/columnist"
            ],
            "target": "/language/columnist"
          },
          {
            "title": "权威发布",
            "source": [
              "language.chinadaily.com.cn/5af95d44a3103f6866ee845c"
            ],
            "target": "/language/5af95d44a3103f6866ee845c"
          }
        ],
        "view": 0,
        "location": "language.ts",
        "module": () => import('@/routes/chinadaily/language.ts')
      }
    },
    "name": "中国日报网",
    "apiRoutes": {},
    "url": "chinadaily.com.cn",
    "categories": [
      "traditional-media"
    ],
    "description": "",
    "lang": "zh-CN"
  },
  "chinadegrees": {
    "routes": {
      "/:province?": {
        "path": "/:province?",
        "categories": [
          "study"
        ],
        "example": "/chinadegrees/11",
        "parameters": {
          "province": "省市代号，见下表，亦可在 [这里](http://www.chinadegrees.com.cn/help/provinceSwqk.html) 找到，默认为 `11`"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": true,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "各学位授予单位学位证书上网进度",
        "description": "| 省市             | 代号 |\n| ---------------- | ---- |\n| 北京市           | 11   |\n| 天津市           | 12   |\n| 河北省           | 13   |\n| 山西省           | 14   |\n| 内蒙古自治区     | 15   |\n| 辽宁省           | 21   |\n| 吉林省           | 22   |\n| 黑龙江省         | 23   |\n| 上海市           | 31   |\n| 江苏省           | 32   |\n| 浙江省           | 33   |\n| 安徽省           | 34   |\n| 福建省           | 35   |\n| 江西省           | 36   |\n| 山东省           | 37   |\n| 河南省           | 41   |\n| 湖北省           | 42   |\n| 湖南省           | 43   |\n| 广东省           | 44   |\n| 广西壮族自治区   | 45   |\n| 海南省           | 46   |\n| 重庆市           | 50   |\n| 四川省           | 51   |\n| 贵州省           | 52   |\n| 云南省           | 53   |\n| 西藏自治区       | 54   |\n| 陕西省           | 61   |\n| 甘肃省           | 62   |\n| 青海省           | 63   |\n| 宁夏回族自治区   | 64   |\n| 新疆维吾尔自治区 | 65   |\n| 台湾             | 71   |",
        "maintainers": [
          "TonyRL"
        ],
        "location": "province.tsx",
        "module": () => import('@/routes/chinadegrees/province.tsx')
      }
    },
    "name": "中华人民共和国学位证书查询",
    "url": "chinadegrees.com.cn",
    "lang": "zh-CN"
  },
  "chinafactcheck": {
    "routes": {
      "/": {
        "path": "/",
        "radar": [
          {
            "source": [
              "chinafactcheck.com/"
            ],
            "target": ""
          }
        ],
        "name": "Unknown",
        "maintainers": [
          "kdanfly"
        ],
        "url": "chinafactcheck.com/",
        "location": "index.ts",
        "module": () => import('@/routes/chinafactcheck/index.ts')
      }
    },
    "name": "有据",
    "apiRoutes": {},
    "url": "chinafactcheck.com",
    "lang": "zh-CN"
  },
  "chinaisa": {
    "routes": {
      "/:id?": {
        "path": "/:id?",
        "categories": [
          "new-media"
        ],
        "example": "/chinaisa",
        "parameters": {
          "id": "栏目，见下表，默认为钢协动态"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "栏目",
        "maintainers": [
          "nczitzk"
        ],
        "description": "| 栏目     | id                                               |\n| -------- | --------------------------------------------------------------- |\n| 钢协动态 | 58af05dfb6b4300151760176d2aad0a04c275aaadbb1315039263f021f920dcd |\n| 钢协要闻 | 67ea4f106bd8f0843c0538d43833c463a0cd411fc35642cbd555a5f39fcf352b |\n| 会议报道 | e5070694f299a43b20d990e53b6a69dc02e755fef644ae667cf75deaff80407a |\n| 领导讲话 | a873c2e67b26b4a2d8313da769f6e106abc9a1ff04b7f1a50674dfa47cf91a7b |\n| 图片新闻 | 806254321b2459bddb3c2cb5590fef6332bd849079d3082daf6153d7f8d62e1e |\n\n<details>\n<summary>更多栏目</summary>\n\n#### 党建工作\n\n| 栏目                                                 | id                                                               |\n| ---------------------------------------------------- | ---------------------------------------------------------------- |\n| 党建工作                                             | 10e8911e0c852d91f08e173c768700da608abfb4e7b0540cb49fa5498f33522b |\n| 学习贯彻习近平新时代中国特色社会主义思想主题教育专栏 | b7a7ad4b5d8ffaca4b29f3538fd289da9d07f827f89e6ea57ef07257498aacf9 |\n| 党史学习教育专栏                                     | 4d8e7dec1b672704916331431156ea7628a598c191d751e4fc28408ccbd4e0c4 |\n| 不忘初心、牢记使命                                   | 427f7c28c90ec9db1aab78db8156a63ff2e23f6a0cea693e3847fe6d595753db |\n| 两学一做                                             | 5b0609fedc9052bb44f1cfe9acf5ec8c9fe960f22a07be69636f2cf1cacaa8f7 |\n| 钢协党代会                                           | beaaa0314f0f532d4b18244cd70df614a4af97465d974401b1f5b3349d78144b |\n| 创先争优                                             | e7ea82c886ba18691210aaf48b3582a92dca9c4f2aab912757cedafb066ff8a6 |\n| 青年工作                                             | 2706ee3a4a4c3c23e90e13c8fdc3002855d1dba394b61626562a97b33af3dbd0 |\n| 日常动态                                             | e21157a082fc0ab0d7062c8755e91472ee0d23de6ccc5c2a44b62e54062cf1e4 |\n\n#### 要闻\n\n| 栏目         | id                                                               |\n| ------------ | ---------------------------------------------------------------- |\n| 要闻         | c42511ce3f868a515b49668dd250290c80d4dc8930c7e455d0e6e14b8033eae2 |\n| 会员动态     | 268f86fdf61ac8614f09db38a2d0295253043b03e092c7ff48ab94290296125c |\n| 疫情应对专栏 | a83c48faeb34065fd9b33d3c84957a152675141458aedc0ec454b760c9fcad65 |\n\n#### 统计发布\n\n| 栏目     | id                                                               |\n| -------- | ---------------------------------------------------------------- |\n| 统计发布 | 2e3c87064bdfc0e43d542d87fce8bcbc8fe0463d5a3da04d7e11b4c7d692194b |\n| 生产经营 | 3238889ba0fa3aabcf28f40e537d440916a361c9170a4054f9fc43517cb58c1e |\n| 进出口   | 95ef75c752af3b6c8be479479d8b931de7418c00150720280d78c8f0da0a438c |\n| 环保统计 | 619ce7b53a4291d47c19d0ee0765098ca435e252576fbe921280a63fba4bc712 |\n\n#### 行业分析\n\n| 栏目     | id                                                               |\n| -------- | ---------------------------------------------------------------- |\n| 行业分析 | 1b4316d9238e09c735365896c8e4f677a3234e8363e5622ae6e79a5900a76f56 |\n| 市场分析 | a44207e193a5caa5e64102604b6933896a0025eb85c57c583b39626f33d4dafd |\n| 板带材   | 05d0e136828584d2cd6e45bdc3270372764781b98546cce122d9974489b1e2f2 |\n| 社会库存 | 197422a82d9a09b9cc86188444574816e93186f2fde87474f8b028fc61472d35 |\n\n#### 钢材价格指数\n\n| 栏目         | id                                                               |\n| ------------ | ---------------------------------------------------------------- |\n| 钢材价格指数 | 17b6a9a214c94ccc28e56d4d1a2dbb5acef3e73da431ddc0a849a4dcfc487d04 |\n| 综合价格指数 | 63913b906a7a663f7f71961952b1ddfa845714b5982655b773a62b85dd3b064e |\n| 地区价格     | fc816c75aed82b9bc25563edc9cf0a0488a2012da38cbef5258da614d6e51ba9 |\n\n#### 宏观经济信息\n\n| 栏目         | id                                                               |\n| ------------ | ---------------------------------------------------------------- |\n| 宏观经济信息 | 5d77b433182404193834120ceed16fe0625860fafd5fd9e71d0800c4df227060 |\n| 相关行业信息 | ae2a3c0fd4936acf75f4aab6fadd08bc6371aa65bdd50419e74b70d6f043c473 |\n| 国际动态     | 1bad7c56af746a666e4a4e56e54a9508d344d7bc1498360580613590c16b6c41 |\n\n#### 专题报道\n\n| 栏目                 | id                                                               |\n| -------------------- | ---------------------------------------------------------------- |\n| 专题报道             | 50e7242bfd78b4395f3338df7699a0ff8847b886c4c3a55bd7c102a2cfe32fe9 |\n| 钢协理事会           | 40c6404418699f0f8cb4e513013bb110ef250c782f0959852601e7c75e1afcd8 |\n| 钢协新闻发布会       | 11ea370f565c6c141b1a4dac60aa00c4331bd442382a5dd476a5e73e001b773c |\n| 劳模表彰             | 907e4ae217bf9c981a132051572103f9c87cccb7f00caf5a1770078829e6bcb3 |\n| 钢铁行业职业技能竞赛 | 563c15270a691e3c7cb9cd9ba457c5af392eb4630fa833fc1a55c8e2afbc28a9 |\n\n#### 成果奖励\n\n| 栏目                   | id                                                               |\n| ---------------------- | ---------------------------------------------------------------- |\n| 成果奖励               | a6c30053b66356b4d77fbf6668bda69f7e782b2ae08a21d5db171d50a504bd40 |\n| 冶金科学技术奖         | 50fe0c63f657ee48e49cb13fe7f7c5502046acdb05e2ee8a317f907af4191683 |\n| 企业管理现代化创新成果 | b5607d3b73c2c3a3b069a97b9dbfd59af64aea27bafd5eb87ba44d1b07a33b66 |\n| 清洁生产环境友好企业   | 4475c8e21374d063a22f95939a2909837e78fab1832dc97bf64f09fa01c0c5f7 |\n| 产品开发市场开拓奖     | 169e34d7b29e3deaf4d4496da594d3bbde2eb0a40f7244b54dbfb9cc89a37296 |\n| 质量金杯奖             | 68029784be6d9a7bf9cb8cace5b8a5ce5d2d871e9a0cbcbf84eeae0ea2746311 |\n\n#### 节能减排\n\n| 栏目                                       | id                                                               |\n| ------------------------------------------ | ---------------------------------------------------------------- |\n| 节能减排                                   | 08895f1681c198fdf297ab38e33e1f428f6ccf2add382f3844a52e410f10e5a0 |\n| 先进节能环保技术                           | 6e639343a517fd08e5860fba581d41940da523753956ada973b6952fc05ef94f |\n| 钢铁企业超低排放改造和评估监测进展情况公示 | 50d99531d5dee68346653ca9548f308764ad38410a091e662834a5ed66770174 |\n\n#### 国际交流\n\n| 栏目     | id                                                               |\n| -------- | ---------------------------------------------------------------- |\n| 国际交流 | 4753eef81b4019369d4751413d852ab9027944b84c612b5a08614e046d169e81 |\n| 外事动态 | aa590ec6f835136a9ce8c9f3d0c3b194beb6b78037466ab40bb4aacc32adfcc9 |\n| 国际会展 | 05ac1f2971bc375d25c9112e399f9c3cbb237809684ebc5b0ca4a68a1fcb971c |\n\n#### 政策法规\n\n| 栏目     | id                                                               |\n| -------- | ---------------------------------------------------------------- |\n| 政策法规 | 63a69eb0087f1984c0b269a1541905f19a56e117d56b3f51dfae0e6c1d436533 |\n| 政策法规 | a214b2e71c3c79fa4a36ff382ee5f822b9603634626f7e320f91ed696b3666f2 |\n| 贸易规则 | 5988b2380d04d3efde8cc247377d19530c17904ec0b5decdd00f9b3e026e3715 |\n\n#### 分会园地\n\n| 栏目         | id                                                               |\n| ------------ | ---------------------------------------------------------------- |\n| 分会园地     | d059d6751dcaae94e31a795072267f7959c35d012eebb9858b3ede2990e82ea9 |\n| 法律分会     | 96000647f18ea78fa134a3932563e7d27c68d0482de498f179b44846234567a9 |\n| 设备分会     | c8e1e3f52406115c2c03928271bbe883c0875b7c9f2f67492395685a62a1a2d8 |\n| 国际产能合作 | 4fb8cc4b0d6f905a969ac3375f6d17b34df4dcae69d798d2a4616daa80af020c |\n| 绿化分会     | ad55a0fbc1a44e94fb60e21b98cf967aca17ecf1450bdfb3699468fe8235103b |\n\n#### 钢铁知识\n\n| 栏目         | id                                                               |\n| ------------ | ---------------------------------------------------------------- |\n| 钢铁知识     | 7f7509ff045023015e0d6c1ba22c32734b673be2ec14eae730a99c08e3badb3f |\n| 钢铁材料使用 | 7e319d71258ed6bb663cf59b4cf67fe97894e60aa5520f3d2cf966f82f9b89ac |\n| 钢铁标准     | fae0c4dd27f8fe4759941e78c9dc1dfe0088ce30d1b684d12be4c8172d2c08e1 |\n\n#### 钢协刊物\n\n| 栏目       | id                                                               |\n| ---------- | ---------------------------------------------------------------- |\n| 钢协刊物   | ed51af486f6d4b313b3aaf8fea0b32a4a2d4a89714c61992caf01942eb61831b |\n| 中国钢铁业 | 6440bdfccadf87908b13d8bbd9a66bb89bbd60cc5e175c018ca1c62c7d55e61f |\n| 钢铁信息   | 2b66af0b2cda9b420739e55e255a6f72f277557670ef861c9956da8fde25da05 |\n</details>",
        "location": "index.ts",
        "module": () => import('@/routes/chinaisa/index.ts')
      }
    },
    "name": "中国钢铁工业协会",
    "apiRoutes": {},
    "url": "chinaisa.org.cn",
    "lang": "zh-CN"
  },
  "chinamoney": {
    "routes": {
      "/:channelId?": {
        "path": "/:channelId?",
        "categories": [
          "finance"
        ],
        "example": "/chinamoney",
        "parameters": {
          "channelId": "分类，见下表，默认为 `2834`"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "公告",
        "maintainers": [
          "TonyRL"
        ],
        "description": "<details>\n<summary>市场公告</summary>\n\n    外汇市场公告\n\n| 最新 | 市场公告通知 | 中心会员公告 | 会员信息公告 |\n| ---- | ------------ | ------------ | ------------ |\n| 2834 | 2835         | 2836         | 2837         |\n\n    本币市场公告\n\n| 最新           | 市场公告通知 | 中心会员公告 | 会员信息公告 |\n| -------------- | ------------ | ------------ | ------------ |\n| 2839,2840,2841 | 2839         | 2840         | 2841         |\n\n    央行业务公告\n\n| 最新      | 公开市场操作 | 中央国库现金管理 |\n| --------- | ------------ | ---------------- |\n| 2845,2846 | 2845         | 2846             |\n</details>\n\n<details>\n<summary>本币市场</summary>\n\n    贷款市场报价利率\n\n| LPR 市场公告 |\n| ------------ |\n| 3686         |\n</details>",
        "location": "notice.ts",
        "module": () => import('@/routes/chinamoney/notice.ts')
      }
    },
    "name": "中国货币网",
    "url": "chinamoney.com.cn",
    "lang": "zh-CN"
  },
  "chinanews": {
    "routes": {
      "/": {
        "path": "/",
        "radar": [
          {
            "source": [
              "chinanews.com.cn/"
            ],
            "target": ""
          }
        ],
        "name": "Unknown",
        "maintainers": [
          "yuxinliu-alex"
        ],
        "url": "chinanews.com.cn/",
        "location": "index.ts",
        "module": () => import('@/routes/chinanews/index.ts')
      }
    },
    "name": "中国新闻网",
    "apiRoutes": {},
    "url": "chinanews.com.cn",
    "lang": "zh-CN"
  },
  "chinania": {
    "routes": {
      "/:category{.+}?": {
        "path": "/:category{.+}?",
        "name": "分类",
        "url": "www.chinania.org.cn",
        "maintainers": [
          "nczitzk"
        ],
        "example": "/chinania/xiehuidongtai/xiehuitongzhi",
        "parameters": {
          "category": "分类，默认为 `xiehuidongtai/xiehuitongzhi`，即协会通知，可在对应分类页 URL 中找到"
        },
        "description": "::: tip\n  若订阅 [协会通知](https://www.chinania.org.cn/html/xiehuidongtai/xiehuitongzhi/)，网址为 `https://www.chinania.org.cn/html/xiehuidongtai/xiehuitongzhi/`。截取 `https://www.chinania.org.cn/html` 到末尾 `/` 的部分 `xiehuidongtai/xiehuitongzhi` 作为参数填入，此时路由为 [`/chinania/xiehuidongtai/xiehuitongzhi`](https://rsshub.app/chinania/xiehuidongtai/xiehuitongzhi)。\n:::\n\n<details>\n<summary>更多分类</summary>\n\n#### [协会动态](https://www.chinania.org.cn/html/xiehuidongtai/)\n\n| [协会动态](https://www.chinania.org.cn/html/xiehuidongtai/xiehuidongtai/)              | [协会通知](https://www.chinania.org.cn/html/xiehuidongtai/xiehuitongzhi/)              | [有色企业50强](https://www.chinania.org.cn/html/xiehuidongtai/youseqiye50qiang/)             |\n| -------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------- |\n| [xiehuidongtai/xiehuidongtai](https://rsshub.app/chinania/xiehuidongtai/xiehuidongtai) | [xiehuidongtai/xiehuitongzhi](https://rsshub.app/chinania/xiehuidongtai/xiehuitongzhi) | [xiehuidongtai/youseqiye50qiang](https://rsshub.app/chinania/xiehuidongtai/youseqiye50qiang) |\n\n#### [党建工作](https://www.chinania.org.cn/html/djgz/)\n\n| [协会党建](https://www.chinania.org.cn/html/djgz/xiehuidangjian/)      | [行业党建](https://www.chinania.org.cn/html/djgz/hangyedangjian/)      |\n| ---------------------------------------------------------------------- | ---------------------------------------------------------------------- |\n| [djgz/xiehuidangjian](https://rsshub.app/chinania/djgz/xiehuidangjian) | [djgz/hangyedangjian](https://rsshub.app/chinania/djgz/hangyedangjian) |\n\n#### [行业新闻](https://www.chinania.org.cn/html/hangyexinwen/)\n\n| [时政要闻](https://www.chinania.org.cn/html/hangyexinwen/shizhengyaowen/)              | [要闻](https://www.chinania.org.cn/html/hangyexinwen/yaowen/)          | [行业新闻](https://www.chinania.org.cn/html/hangyexinwen/guoneixinwen/)            | [资讯](https://www.chinania.org.cn/html/hangyexinwen/zixun/)         |\n| -------------------------------------------------------------------------------------- | ---------------------------------------------------------------------- | ---------------------------------------------------------------------------------- | -------------------------------------------------------------------- |\n| [hangyexinwen/shizhengyaowen](https://rsshub.app/chinania/hangyexinwen/shizhengyaowen) | [hangyexinwen/yaowen](https://rsshub.app/chinania/hangyexinwen/yaowen) | [hangyexinwen/guoneixinwen](https://rsshub.app/chinania/hangyexinwen/guoneixinwen) | [hangyexinwen/zixun](https://rsshub.app/chinania/hangyexinwen/zixun) |\n\n#### [人力资源](https://www.chinania.org.cn/html/renliziyuan/)\n\n| [相关通知](https://www.chinania.org.cn/html/renliziyuan/xiangguantongzhi/)               | [人事招聘](https://www.chinania.org.cn/html/renliziyuan/renshizhaopin/)            |\n| ---------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------- |\n| [renliziyuan/xiangguantongzhi](https://rsshub.app/chinania/renliziyuan/xiangguantongzhi) | [renliziyuan/renshizhaopin](https://rsshub.app/chinania/renliziyuan/renshizhaopin) |\n\n#### [行业统计](https://www.chinania.org.cn/html/hangyetongji/jqzs/)\n\n| [行业分析](https://www.chinania.org.cn/html/hangyetongji/tongji/)      | [数据统计](https://www.chinania.org.cn/html/hangyetongji/chanyeshuju/)           | [景气指数](https://www.chinania.org.cn/html/hangyetongji/jqzs/)    |\n| ---------------------------------------------------------------------- | -------------------------------------------------------------------------------- | ------------------------------------------------------------------ |\n| [hangyetongji/tongji](https://rsshub.app/chinania/hangyetongji/tongji) | [hangyetongji/chanyeshuju](https://rsshub.app/chinania/hangyetongji/chanyeshuju) | [hangyetongji/jqzs](https://rsshub.app/chinania/hangyetongji/jqzs) |\n\n#### [政策法规](https://www.chinania.org.cn/html/zcfg/zhengcefagui/)\n\n| [政策法规](https://www.chinania.org.cn/html/zcfg/zhengcefagui/)    |\n| ------------------------------------------------------------------ |\n| [zcfg/zhengcefagui](https://rsshub.app/chinania/zcfg/zhengcefagui) |\n\n#### [会议展览](https://www.chinania.org.cn/html/hyzl/huiyizhanlan/)\n\n| [会展通知](https://www.chinania.org.cn/html/hyzl/huiyizhanlan/)    | [会展报道](https://www.chinania.org.cn/html/hyzl/huizhanbaodao/)     |\n| ------------------------------------------------------------------ | -------------------------------------------------------------------- |\n| [hyzl/huiyizhanlan](https://rsshub.app/chinania/hyzl/huiyizhanlan) | [hyzl/huizhanbaodao](https://rsshub.app/chinania/hyzl/huizhanbaodao) |\n\n</details>\n    ",
        "categories": [
          "new-media"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.chinania.org.cn/html/:category"
            ]
          },
          {
            "title": "协会动态 - 协会动态",
            "source": [
              "www.chinania.org.cn/html/xiehuidongtai/xiehuidongtai/"
            ],
            "target": "/xiehuidongtai/xiehuidongtai"
          },
          {
            "title": "协会动态 - 协会通知",
            "source": [
              "www.chinania.org.cn/html/xiehuidongtai/xiehuitongzhi/"
            ],
            "target": "/xiehuidongtai/xiehuitongzhi"
          },
          {
            "title": "协会动态 - 有色企业50强",
            "source": [
              "www.chinania.org.cn/html/xiehuidongtai/youseqiye50qiang/"
            ],
            "target": "/xiehuidongtai/youseqiye50qiang"
          },
          {
            "title": "党建工作 - 协会党建",
            "source": [
              "www.chinania.org.cn/html/djgz/xiehuidangjian/"
            ],
            "target": "/djgz/xiehuidangjian"
          },
          {
            "title": "党建工作 - 行业党建",
            "source": [
              "www.chinania.org.cn/html/djgz/hangyedangjian/"
            ],
            "target": "/djgz/hangyedangjian"
          },
          {
            "title": "会议展览 - 会展通知",
            "source": [
              "www.chinania.org.cn/html/hyzl/huiyizhanlan/"
            ],
            "target": "/hyzl/huiyizhanlan"
          },
          {
            "title": "会议展览 - 会展报道",
            "source": [
              "www.chinania.org.cn/html/hyzl/huizhanbaodao/"
            ],
            "target": "/hyzl/huizhanbaodao"
          },
          {
            "title": "行业新闻 - 时政要闻",
            "source": [
              "www.chinania.org.cn/html/hangyexinwen/shizhengyaowen/"
            ],
            "target": "/hangyexinwen/shizhengyaowen"
          },
          {
            "title": "行业新闻 - 要闻",
            "source": [
              "www.chinania.org.cn/html/hangyexinwen/yaowen/"
            ],
            "target": "/hangyexinwen/yaowen"
          },
          {
            "title": "行业新闻 - 行业新闻",
            "source": [
              "www.chinania.org.cn/html/hangyexinwen/guoneixinwen/"
            ],
            "target": "/hangyexinwen/guoneixinwen"
          },
          {
            "title": "行业新闻 - 资讯",
            "source": [
              "www.chinania.org.cn/html/hangyexinwen/zixun/"
            ],
            "target": "/hangyexinwen/zixun"
          },
          {
            "title": "行业统计 - 行业分析",
            "source": [
              "www.chinania.org.cn/html/hangyetongji/tongji/"
            ],
            "target": "/hangyetongji/tongji"
          },
          {
            "title": "行业统计 - 数据统计",
            "source": [
              "www.chinania.org.cn/html/hangyetongji/chanyeshuju/"
            ],
            "target": "/hangyetongji/chanyeshuju"
          },
          {
            "title": "行业统计 - 景气指数",
            "source": [
              "www.chinania.org.cn/html/hangyetongji/jqzs/"
            ],
            "target": "/hangyetongji/jqzs"
          },
          {
            "title": "人力资源 - 相关通知",
            "source": [
              "www.chinania.org.cn/html/renliziyuan/xiangguantongzhi/"
            ],
            "target": "/renliziyuan/xiangguantongzhi"
          },
          {
            "title": "人力资源 - 人事招聘",
            "source": [
              "www.chinania.org.cn/html/renliziyuan/renshizhaopin/"
            ],
            "target": "/renliziyuan/renshizhaopin"
          },
          {
            "title": "政策法规 - 政策法规",
            "source": [
              "www.chinania.org.cn/html/zcfg/zhengcefagui/"
            ],
            "target": "/zcfg/zhengcefagui"
          }
        ],
        "location": "index.ts",
        "module": () => import('@/routes/chinania/index.ts')
      }
    },
    "name": "中国有色金属工业网",
    "apiRoutes": {},
    "url": "chinania.org.cn",
    "categories": [
      "new-media"
    ],
    "description": "",
    "lang": "zh-CN"
  },
  "chinaratings": {
    "routes": {
      "/CreditResearch/:category{.+}?": {
        "path": "/CreditResearch/:category{.+}?",
        "name": "中债研究",
        "url": "www.chinaratings.com.cn",
        "maintainers": [
          "nczitzk"
        ],
        "example": "/chinaratings/CreditResearch",
        "parameters": {
          "category": "分类，默认为 `Industry/Comment`，即行业评论，可在对应分类页 URL 中找到"
        },
        "description": "::: tip\n若订阅 [行业评论](https://www.chinaratings.com.cn/CreditResearch/Industry/Comment/)，网址为 `https://www.chinaratings.com.cn/CreditResearch/Industry/Comment/`，请截取 `https://www.chinaratings.com.cn/CreditResearch/` 到末尾 `/` 的部分 `Industry/Comment` 作为 `category` 参数填入，此时目标路由为 [`/chinaratings/CreditResearch/Industry/Comment`](https://rsshub.app/chinaratings/CreditResearch/Industry/Comment)。\n:::\n",
        "categories": [
          "finance"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.chinaratings.com.cn/CreditResearch/:category"
            ]
          }
        ],
        "view": 0,
        "location": "credit-research.ts",
        "module": () => import('@/routes/chinaratings/credit-research.ts')
      }
    },
    "name": "中债资信评估有限责任公司",
    "apiRoutes": {},
    "url": "chinaratings.com.cn",
    "categories": [
      "finance"
    ],
    "description": ""
  },
  "chinathinktanks": {
    "routes": {
      "/:id": {
        "path": "/:id",
        "categories": [
          "study"
        ],
        "example": "/chinathinktanks/57",
        "parameters": {
          "id": "见下表，亦可在网站 url 里找到"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "观点与实践",
        "maintainers": [
          "Aeliu"
        ],
        "description": "| `:id` | 专题名称 |\n| ----- | -------- |\n| 2     | 党的建设 |\n| 3     | 社会     |\n| 4     | 生态     |\n| 5     | 政治     |\n| 6     | 经济     |\n| 7     | 文化     |\n| 9     | 热点专题 |\n| 10    | 国际关系 |\n| 13    | 国外智库 |\n| 46    | 智库报告 |\n| 57    | 智库要闻 |\n| 126   | 世界经济 |\n| 127   | 宏观经济 |\n| 128   | 区域经济 |\n| 129   | 产业企业 |\n| 130   | 三农问题 |\n| 131   | 财政金融 |\n| 132   | 科技创新 |\n| 133   | 民主     |\n| 134   | 法治     |\n| 135   | 行政     |\n| 136   | 国家治理 |\n| 137   | 社会事业 |\n| 138   | 社会保障 |\n| 139   | 民族宗教 |\n| 140   | 人口就业 |\n| 141   | 社会治理 |\n| 142   | 文化产业 |\n| 143   | 公共文化 |\n| 144   | 文化体制 |\n| 145   | 文化思想 |\n| 146   | 资源     |\n| 147   | 能源     |\n| 148   | 环境     |\n| 149   | 生态文明 |\n| 150   | 思想建设 |\n| 151   | 作风建设 |\n| 152   | 组织建设 |\n| 153   | 制度建设 |\n| 154   | 反腐倡廉 |\n| 155   | 中国外交 |\n| 156   | 全球治理 |\n| 157   | 大国关系 |\n| 158   | 地区政治 |\n| 181   | 执政能力 |",
        "location": "viewpoint.ts",
        "module": () => import('@/routes/chinathinktanks/viewpoint.ts')
      }
    },
    "name": "中国智库网",
    "url": "www.chinathinktanks.org.cn",
    "lang": "zh-CN"
  },
  "chinatimes": {
    "routes": {
      "/:category?": {
        "path": "/:category?",
        "categories": [
          "traditional-media"
        ],
        "example": "/chinatimes/realtimenews",
        "parameters": {
          "category": "分類，見下表，留空為 `realtimenews`"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.chinatimes.com/:category/",
              "www.chinatimes.com/"
            ]
          }
        ],
        "name": "分類",
        "maintainers": [
          "KingJem"
        ],
        "url": "www.chinatimes.com/",
        "description": "|     即時     |   熱門  |   政治  | 生活 | 娛樂 |  財經 |  國際 |   言論  |   兩岸  |   軍事   |   社會  |  健康  |  體育  |      科技      |   運勢  | 有影 |  寶島  |\n| :----------: | :-----: | :-----: | :--: | :--: | :---: | :---: | :-----: | :-----: | :------: | :-----: | :----: | :----: | :------------: | :-----: | :--: | :----: |\n| realtimenews | hotnews | politic | life | star | money | world | opinion | chinese | armament | society | health | sports | technologynews | fortune | tube | taiwan |",
        "location": "index.ts",
        "module": () => import('@/routes/chinatimes/index.ts')
      }
    },
    "name": "中時新聞網",
    "apiRoutes": {},
    "url": "www.chinatimes.com",
    "lang": "zh-TW"
  },
  "chinaventure": {
    "routes": {
      "/news/:id?": {
        "path": "/news/:id?",
        "categories": [
          "new-media"
        ],
        "example": "/chinaventure/news/78",
        "parameters": {
          "id": "分类，见下表，默认为推荐"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "chinaventure.com.cn/"
            ],
            "target": ""
          }
        ],
        "name": "分类",
        "maintainers": [
          "yuxinliu-alex"
        ],
        "url": "chinaventure.com.cn/",
        "description": "| 推荐 | 商业深度 | 资本市场 | 5G | 健康 | 教育 | 地产 | 金融 | 硬科技 | 新消费 |\n| ---- | -------- | -------- | -- | ---- | ---- | ---- | ---- | ------ | ------ |\n|      | 78       | 80       | 83 | 111  | 110  | 112  | 113  | 114    | 116    |",
        "location": "index.ts",
        "module": () => import('@/routes/chinaventure/index.ts')
      }
    },
    "name": "投中网",
    "apiRoutes": {},
    "url": "chinaventure.com.cn",
    "lang": "zh-CN"
  },
  "chinawriter": {
    "routes": {
      "/:id{.+}?": {
        "path": "/:id{.+}?",
        "name": "Unknown",
        "maintainers": [],
        "location": "index.ts",
        "module": () => import('@/routes/chinawriter/index.ts')
      }
    },
    "name": "中国作家网",
    "apiRoutes": {},
    "url": "chinawriter.com.cn",
    "lang": "zh-CN"
  },
  "chiphell": {
    "routes": {
      "/portal/:catId?": {
        "path": "/portal/:catId?",
        "name": "分类",
        "categories": [
          "bbs"
        ],
        "example": "/chiphell/portal/1",
        "parameters": {
          "catId": "分类 ID，可在 URL 中找到，默认为 1"
        },
        "maintainers": [
          "tylinux"
        ],
        "location": "portal.ts",
        "module": () => import('@/routes/chiphell/portal.ts')
      }
    },
    "name": "Chiphell",
    "url": "www.chiphell.com",
    "lang": "zh-CN"
  },
  "chlinlearn": {
    "routes": {
      "/daily-blog": {
        "path": "/daily-blog",
        "name": "值得一读技术博客",
        "maintainers": [
          "huyyi"
        ],
        "categories": [
          "programming"
        ],
        "example": "/chlinlearn/daily-blog",
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "daily-blog.chlinlearn.top/blogs/*"
            ],
            "target": "/chlinlearn/daily-blog"
          }
        ],
        "location": "daily-blog.ts",
        "module": () => import('@/routes/chlinlearn/daily-blog.ts')
      }
    },
    "name": "chlinlearn 的技术博客",
    "apiRoutes": {},
    "url": "daily-blog.chlinlearn.top",
    "lang": "zh-CN"
  },
  "chnmuseum": {
    "routes": {
      "/zx/xingnew": {
        "path": "/zx/xingnew",
        "categories": [
          "travel"
        ],
        "example": "/zx/xingnew",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "chnmuseum.cn/zx/xingnew"
            ],
            "target": "/zx/xingnew"
          }
        ],
        "name": "资讯要闻",
        "maintainers": [
          "ShabbyWhineYear"
        ],
        "location": "xingnew.ts",
        "module": () => import('@/routes/chnmuseum/xingnew.ts')
      },
      "/zx/xwzt": {
        "path": "/zx/xwzt",
        "categories": [
          "travel"
        ],
        "example": "/zx/xwzt",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "chnmuseum.cn/zx/xwzt"
            ],
            "target": "/zx/xwzt"
          }
        ],
        "name": "资讯专题",
        "maintainers": [
          "ShabbyWhineYear"
        ],
        "location": "xwzt.ts",
        "module": () => import('@/routes/chnmuseum/xwzt.ts')
      }
    },
    "name": "National Museum Of China",
    "url": "www.chnmuseum.cn",
    "description": "中国国家博物馆（National Museum of China）位于北京市中心天安门广场东侧，东长安街南侧，与人民大会堂东西相对称，是一座系统展示中华民族文化历史的综合性博物馆，也是世界上最大的博物馆之一。",
    "zh": {
      "name": "中国国家博物馆"
    }
  },
  "chocolatey": {
    "routes": {
      "/packages/:id": {
        "path": "/packages/:id",
        "name": "Package",
        "url": "community.chocolatey.org",
        "maintainers": [
          "nczitzk"
        ],
        "example": "/chocolatey/packages/microsoft-edge",
        "parameters": {
          "id": {
            "description": "Package ID"
          }
        },
        "categories": [
          "program-update"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "community.chocolatey.org/packages"
            ]
          }
        ],
        "view": 5,
        "zh": {
          "path": "/packages/:id",
          "name": "程序包",
          "url": "community.chocolatey.org",
          "maintainers": [
            "nczitzk"
          ],
          "example": "/chocolatey/package/microsoft-edge",
          "parameters": {
            "id": {
              "description": "程序包 ID"
            }
          }
        },
        "location": "packages.ts",
        "module": () => import('@/routes/chocolatey/packages.ts')
      }
    },
    "name": "Chocolatey",
    "url": "chocolatey.org",
    "categories": [
      "program-update"
    ],
    "description": "",
    "lang": "en"
  },
  "chongbuluo": {
    "routes": {
      "/newthread": {
        "path": "/newthread",
        "categories": [
          "bbs"
        ],
        "example": "/chongbuluo/newthread",
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.chongbuluo.com/"
            ]
          }
        ],
        "name": "最新发表",
        "maintainers": [
          "qiye45"
        ],
        "location": "index.ts",
        "module": () => import('@/routes/chongbuluo/index.ts')
      }
    },
    "name": "虫部落",
    "apiRoutes": {},
    "url": "www.chongbuluo.com",
    "lang": "zh-CN"
  },
  "chongdiantou": {
    "routes": {
      "/": {
        "path": "/",
        "categories": [
          "new-media"
        ],
        "example": "/chongdiantou",
        "radar": [
          {
            "source": [
              "www.chongdiantou.com"
            ]
          }
        ],
        "name": "最新资讯",
        "maintainers": [
          "Geraldxm"
        ],
        "url": "www.chongdiantou.com",
        "location": "index.ts",
        "module": () => import('@/routes/chongdiantou/index.ts')
      }
    },
    "name": "充电头网",
    "apiRoutes": {},
    "url": "www.chongdiantou.com",
    "categories": [
      "new-media"
    ],
    "lang": "zh-CN",
    "description": "充电头网是国内最早进行消费类电源技术及其周边配件（快充、充电头、充电器、无线充、车充、车载充电器、数据线、充电线材、移动电源及电芯、USB插排）评测、拆解的专业机构。"
  },
  "chsi": {
    "routes": {
      "/hotnews": {
        "path": "/hotnews",
        "categories": [
          "study"
        ],
        "example": "/chsi/hotnews",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "yz.chsi.com.cn/"
            ]
          }
        ],
        "name": "考研热点新闻",
        "maintainers": [
          "yanbot-team"
        ],
        "url": "yz.chsi.com.cn/",
        "location": "hotnews.ts",
        "module": () => import('@/routes/chsi/hotnews.ts')
      },
      "/kydt": {
        "path": "/kydt",
        "categories": [
          "study"
        ],
        "example": "/chsi/kydt",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "yz.chsi.com.cn/kyzx/kydt"
            ]
          }
        ],
        "name": "考研动态",
        "maintainers": [
          "SunBK201"
        ],
        "url": "yz.chsi.com.cn/kyzx/kydt",
        "location": "kydt.ts",
        "module": () => import('@/routes/chsi/kydt.ts')
      },
      "/kyzx/:type": {
        "path": "/kyzx/:type",
        "categories": [
          "study"
        ],
        "example": "/chsi/kyzx/fstj",
        "parameters": {
          "type": " type 见下表，亦可在网站 URL 找到"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "yz.chsi.com.cn/kyzx/:type"
            ]
          }
        ],
        "name": "考研资讯",
        "maintainers": [
          "yanbot-team"
        ],
        "description": "| `:type` | 专题名称 |\n| ------- | -------- |\n| fstj    | 复试调剂 |\n| kydt    | 考研动态 |\n| zcdh    | 政策导航 |\n| kyrw    | 考研人物 |\n| jyxd    | 经验心得 |",
        "location": "kyzx.ts",
        "module": () => import('@/routes/chsi/kyzx.ts')
      }
    },
    "name": "中国研究生招生信息网",
    "apiRoutes": {},
    "url": "yz.chsi.com.cn",
    "lang": "zh-CN"
  },
  "chuanliu": {
    "routes": {
      "/nice": {
        "path": "/nice",
        "categories": [
          "blog"
        ],
        "example": "/chuanliu/nice",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "chuanliu.org/nice"
            ]
          }
        ],
        "name": "严选",
        "maintainers": [
          "nczitzk"
        ],
        "url": "chuanliu.org/nice",
        "location": "nice.tsx",
        "module": () => import('@/routes/chuanliu/nice.tsx')
      }
    },
    "name": "川流",
    "url": "chuanliu.org",
    "lang": "zh-CN"
  },
  "chuapp": {
    "routes": {
      "/:category?": {
        "path": "/:category?",
        "categories": [
          "game"
        ],
        "example": "/chuapp/daily",
        "parameters": {
          "category": "栏目分类，见下表"
        },
        "description": "\n  | `category` | 栏目分类 |\n  | ------------ | ------- |\n  | `daily`    | 每日聚焦 |\n  | `pcz`      | 最好玩   |\n  | `night`    | 触乐夜话 |\n  | `news`     | 动态资讯 |\n    ",
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "分类",
        "maintainers": [
          "dousha"
        ],
        "radar": [
          {
            "source": [
              "chuapp.com/category/:category"
            ],
            "target": "/:category"
          },
          {
            "source": [
              "chuapp.com/tag/index/id/20369.html"
            ],
            "target": "/night"
          }
        ],
        "location": "chuapp.ts",
        "module": () => import('@/routes/chuapp/chuapp.ts')
      }
    },
    "name": "触乐",
    "apiRoutes": {},
    "url": "chuapp.com",
    "lang": "zh-CN"
  },
  "chub": {
    "routes": {
      "/characters": {
        "path": "/characters",
        "categories": [
          "new-media"
        ],
        "example": "/chub/characters",
        "name": "Characters",
        "maintainers": [
          "flameleaf"
        ],
        "features": {
          "nsfw": true
        },
        "location": "characters.ts",
        "module": () => import('@/routes/chub/characters.ts')
      }
    },
    "name": "Chub",
    "apiRoutes": {},
    "url": "chub.ai",
    "lang": "en"
  },
  "cib": {
    "routes": {
      "/whpj/:format?": {
        "path": "/whpj/:format?",
        "categories": [
          "other"
        ],
        "example": "/cib/whpj/xh?filter_title=USD",
        "parameters": {
          "format": "输出的标题格式，默认为标题 + 所有价格。短格式仅包含货币名称。"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "cib.com.cn/"
            ],
            "target": "/whpj"
          }
        ],
        "name": "外汇牌价",
        "maintainers": [
          "Qixingchen"
        ],
        "url": "cib.com.cn/",
        "description": "| 短格式 | 现汇买卖 | 现钞买卖 | 现汇买入 | 现汇卖出 | 现钞买入 | 现钞卖出 |\n| ------ | -------- | -------- | -------- | -------- | -------- | -------- |\n| short  | xh       | xc       | xhmr     | xhmc     | xcmr     | xcmc     |",
        "location": "whpj.ts",
        "module": () => import('@/routes/cib/whpj.ts')
      }
    },
    "name": "中国兴业银行",
    "url": "cib.com.cn",
    "lang": "zh-CN"
  },
  "cih-index": {
    "routes": {
      "/report/list/:report?": {
        "path": "/report/list/:report?",
        "categories": [
          "finance"
        ],
        "example": "/cih-index/report/list/p1-oaddtime-ddesc",
        "parameters": {
          "report": "报告 id，可在 URL 中找到，留空为 `p1-oaddtime-ddesc`"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "报告",
        "maintainers": [
          "TonyRL"
        ],
        "url": "www.cih-index.com/report/list/p1-oaddtime-ddesc",
        "radar": [
          {
            "source": [
              "www.cih-index.com/report/list/:report"
            ]
          }
        ],
        "location": "report.ts",
        "module": () => import('@/routes/cih-index/report.ts')
      }
    },
    "name": "中指研究院",
    "url": "www.cih-index.com",
    "lang": "zh-CN"
  },
  "ciidbnu": {
    "routes": {
      "/:id?": {
        "path": "/:id?",
        "categories": [
          "new-media"
        ],
        "example": "/ciidbnu",
        "parameters": {
          "id": "分类 id，可在分类页地址栏 URL 中找到"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "分类",
        "maintainers": [
          "nczitzk"
        ],
        "description": "| 社会动态 | 院内新闻 | 学术观点 | 文献书籍 | 工作论文 | 专题讨论 |\n| -------- | -------- | -------- | -------- | -------- | -------- |\n| 1        | 5        | 3        | 4        | 6        | 8        |",
        "location": "index.ts",
        "module": () => import('@/routes/ciidbnu/index.ts')
      }
    },
    "name": "中国收入分配研究院",
    "apiRoutes": {},
    "url": "ciidbnu.org",
    "lang": "zh-CN"
  },
  "cisia": {
    "routes": {
      "/:id?": {
        "path": "/:id?",
        "name": "栏目",
        "url": "www.cisia.org",
        "maintainers": [
          "nczitzk"
        ],
        "example": "/cisia/9",
        "parameters": {
          "id": "栏目 id，默认为 `9`，即协会动态，可在对应分类页 URL 中找到"
        },
        "description": "::: tip\n  若订阅 [市场信息](http://www.cisia.org/site/term/12.html)，网址为 `http://www.cisia.org/site/term/12.html`。截取 `https://www.cisia.org/site/term/` 到末尾 `.html` 的部分 `12` 作为参数填入，此时路由为 [`/cisia/12`](https://rsshub.app/cisia/12)。\n:::\n\n<details>\n<summary>更多分类</summary>\n\n#### [分支机构信息](http://www.cisia.org/site/term/14.html)\n\n| [企业动态](http://www.cisia.org/site/term/17.html) | [产品展示](http://www.cisia.org/site/term/18.html) |\n| -------------------------------------------------- | -------------------------------------------------- |\n| [17](https://rsshub.app/cisia/17)                  | [18](https://rsshub.app/cisia/18)                  |\n\n#### [新闻中心](http://www.cisia.org/site/term/8.html)\n\n| [协会动态](http://www.cisia.org/site/term/9.html) | [行业新闻](http://www.cisia.org/site/term/10.html) | [通知公告](http://www.cisia.org/site/term/11.html) | [市场信息](http://www.cisia.org/site/term/12.html) |\n| ------------------------------------------------- | -------------------------------------------------- | -------------------------------------------------- | -------------------------------------------------- |\n| [9](https://rsshub.app/cisia/9)                   | [10](https://rsshub.app/cisia/10)                  | [11](https://rsshub.app/cisia/11)                  | [12](https://rsshub.app/cisia/12)                  |\n\n#### [政策法规](http://www.cisia.org/site/term/19.html)\n\n| [宏观聚焦](http://www.cisia.org/site/term/20.html) | [技术园区](http://www.cisia.org/site/term/396.html) |\n| -------------------------------------------------- | --------------------------------------------------- |\n| [20](https://rsshub.app/cisia/20)                  | [396](https://rsshub.app/cisia/396)                 |\n\n#### [合作交流](http://www.cisia.org/site/term/22.html)\n\n| [国际交流](http://www.cisia.org/site/term/23.html) | [行业交流](http://www.cisia.org/site/term/24.html) | [企业调研](http://www.cisia.org/site/term/25.html) | [会展信息](http://www.cisia.org/site/term/84.html) | [宣传专题](http://www.cisia.org/site/term/430.html) |\n| -------------------------------------------------- | -------------------------------------------------- | -------------------------------------------------- | -------------------------------------------------- | --------------------------------------------------- |\n| [23](https://rsshub.app/cisia/23)                  | [24](https://rsshub.app/cisia/24)                  | [25](https://rsshub.app/cisia/25)                  | [84](https://rsshub.app/cisia/84)                  | [430](https://rsshub.app/cisia/430)                 |\n\n#### [党建工作](http://www.cisia.org/site/term/26.html)\n\n| [党委文件](http://www.cisia.org/site/term/27.html) | [学习园地](http://www.cisia.org/site/term/28.html) | [两会专题](http://www.cisia.org/site/term/443.html) |\n| -------------------------------------------------- | -------------------------------------------------- | --------------------------------------------------- |\n| [27](https://rsshub.app/cisia/27)                  | [28](https://rsshub.app/cisia/28)                  | [443](https://rsshub.app/cisia/443)                 |\n\n#### [网上服务平台](http://www.cisia.org/site/term/29.html)\n\n| [前沿科技](http://www.cisia.org/site/term/31.html) | [新材料新技术](http://www.cisia.org/site/term/133.html) | [文件共享](http://www.cisia.org/site/term/30.html) |\n| -------------------------------------------------- | ------------------------------------------------------- | -------------------------------------------------- |\n| [31](https://rsshub.app/cisia/31)                  | [133](https://rsshub.app/cisia/133)                     | [30](https://rsshub.app/cisia/30)                  |\n\n#### [会员社区](http://www.cisia.org/site/term/34.html)\n\n| [会员分布](http://www.cisia.org/site/term/35.html) | [会员风采](http://www.cisia.org/site/term/68.html) |\n| -------------------------------------------------- | -------------------------------------------------- |\n| [35](https://rsshub.app/cisia/35)                  | [68](https://rsshub.app/cisia/68)                  |\n\n</details>\n    ",
        "categories": [
          "government"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.cisia.org/site/term/:id"
            ]
          },
          {
            "title": "分支机构信息 - 企业动态",
            "source": [
              "www.cisia.org/site/term/17.html"
            ],
            "target": "/17"
          },
          {
            "title": "分支机构信息 - 产品展示",
            "source": [
              "www.cisia.org/site/term/18.html"
            ],
            "target": "/18"
          },
          {
            "title": "新闻中心 - 协会动态",
            "source": [
              "www.cisia.org/site/term/9.html"
            ],
            "target": "/9"
          },
          {
            "title": "新闻中心 - 行业新闻",
            "source": [
              "www.cisia.org/site/term/10.html"
            ],
            "target": "/10"
          },
          {
            "title": "新闻中心 - 通知公告",
            "source": [
              "www.cisia.org/site/term/11.html"
            ],
            "target": "/11"
          },
          {
            "title": "新闻中心 - 市场信息",
            "source": [
              "www.cisia.org/site/term/12.html"
            ],
            "target": "/12"
          },
          {
            "title": "政策法规 - 宏观聚焦",
            "source": [
              "www.cisia.org/site/term/20.html"
            ],
            "target": "/20"
          },
          {
            "title": "政策法规 - 技术园区",
            "source": [
              "www.cisia.org/site/term/396.html"
            ],
            "target": "/396"
          },
          {
            "title": "合作交流 - 国际交流",
            "source": [
              "www.cisia.org/site/term/23.html"
            ],
            "target": "/23"
          },
          {
            "title": "合作交流 - 行业交流",
            "source": [
              "www.cisia.org/site/term/24.html"
            ],
            "target": "/24"
          },
          {
            "title": "合作交流 - 企业调研",
            "source": [
              "www.cisia.org/site/term/25.html"
            ],
            "target": "/25"
          },
          {
            "title": "合作交流 - 会展信息",
            "source": [
              "www.cisia.org/site/term/84.html"
            ],
            "target": "/84"
          },
          {
            "title": "合作交流 - 宣传专题",
            "source": [
              "www.cisia.org/site/term/430.html"
            ],
            "target": "/430"
          },
          {
            "title": "党建工作 - 党委文件",
            "source": [
              "www.cisia.org/site/term/27.html"
            ],
            "target": "/27"
          },
          {
            "title": "党建工作 - 学习园地",
            "source": [
              "www.cisia.org/site/term/28.html"
            ],
            "target": "/28"
          },
          {
            "title": "党建工作 - 两会专题",
            "source": [
              "www.cisia.org/site/term/443.html"
            ],
            "target": "/443"
          },
          {
            "title": "网上服务平台 - 前沿科技",
            "source": [
              "www.cisia.org/site/term/31.html"
            ],
            "target": "/31"
          },
          {
            "title": "网上服务平台 - 新材料新技术",
            "source": [
              "www.cisia.org/site/term/133.html"
            ],
            "target": "/133"
          },
          {
            "title": "网上服务平台 - 文件共享",
            "source": [
              "www.cisia.org/site/term/30.html"
            ],
            "target": "/30"
          },
          {
            "title": "会员社区 - 会员分布",
            "source": [
              "www.cisia.org/site/term/35.html"
            ],
            "target": "/35"
          },
          {
            "title": "会员社区 - 会员风采",
            "source": [
              "www.cisia.org/site/term/68.html"
            ],
            "target": "/68"
          }
        ],
        "location": "index.ts",
        "module": () => import('@/routes/cisia/index.ts')
      }
    },
    "name": "中国无机盐工业协会",
    "apiRoutes": {},
    "url": "www.cisia.org",
    "categories": [
      "government"
    ],
    "description": "",
    "lang": "zh-CN"
  },
  "civitai": {
    "routes": {
      "/discussions/:modelId": {
        "path": "/discussions/:modelId",
        "categories": [
          "program-update"
        ],
        "example": "/civitai/discussions/4384",
        "parameters": {
          "modelId": "N"
        },
        "features": {
          "requireConfig": [
            {
              "name": "CIVITAI_COOKIE",
              "description": ""
            }
          ],
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false,
          "nsfw": true
        },
        "radar": [
          {
            "source": [
              "civitai.com/models/:modelId"
            ]
          }
        ],
        "name": "Model discussions",
        "maintainers": [
          "DIYgod"
        ],
        "description": "::: warning\nNeed to configure `CIVITAI_COOKIE` to obtain image information of NSFW models.\n:::",
        "location": "discussions.ts",
        "module": () => import('@/routes/civitai/discussions.ts')
      },
      "/models": {
        "path": "/models",
        "categories": [
          "program-update"
        ],
        "example": "/civitai/models",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false,
          "nsfw": true
        },
        "radar": [
          {
            "source": [
              "civitai.com/"
            ]
          }
        ],
        "name": "Latest models",
        "maintainers": [
          "DIYgod"
        ],
        "url": "civitai.com/",
        "location": "models.ts",
        "module": () => import('@/routes/civitai/models.ts')
      },
      "/user/:username/articles": {
        "path": "/user/:username/articles",
        "categories": [
          "program-update"
        ],
        "example": "/civitai/user/Chenkin/articles",
        "parameters": {
          "username": "Username"
        },
        "radar": [
          {
            "source": [
              "civitai.com/user/:username",
              "civitai.com/user/:username/articles"
            ]
          }
        ],
        "name": "User Article",
        "maintainers": [
          "TonyRL"
        ],
        "features": {
          "nsfw": true
        },
        "location": "user.ts",
        "module": () => import('@/routes/civitai/user.ts')
      }
    },
    "name": "Civitai",
    "apiRoutes": {},
    "url": "civitai.com",
    "lang": "en"
  },
  "ciweimao": {
    "routes": {
      "/chapter/:id": {
        "path": "/chapter/:id",
        "categories": [
          "reading"
        ],
        "example": "/ciweimao/chapter/100043404",
        "parameters": {
          "id": "小说 id, 可在对应小说页 URL 中找到"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "wap.ciweimao.com/book/:id"
            ]
          }
        ],
        "name": "章节",
        "maintainers": [
          "keocheung"
        ],
        "location": "chapter.ts",
        "module": () => import('@/routes/ciweimao/chapter.ts')
      }
    },
    "name": "刺猬猫",
    "apiRoutes": {},
    "url": "wap.ciweimao.com",
    "lang": "zh-CN"
  },
  "cjlu": {
    "routes": {
      "/yjsy/:cate": {
        "path": "/yjsy/:cate",
        "categories": [
          "university"
        ],
        "example": "/cjlu/yjsy/yjstz",
        "parameters": {
          "cate": {
            "description": "订阅的类型，支持 yjstz（研究生通知）和 jstz（教师通知）",
            "default": "yjstz",
            "options": [
              {
                "label": "教师通知",
                "value": "jstz"
              },
              {
                "label": "研究生通知",
                "value": "yjstz"
              }
            ]
          }
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": true,
          "antiCrawler": true,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "title": "研究生通知",
            "source": [
              "yjsy.cjlu.edu.cn/index/yjstz/:suffix",
              "yjsy.cjlu.edu.cn/index/yjstz.htm"
            ],
            "target": "/yjsy/yjstz"
          },
          {
            "title": "教师通知",
            "source": [
              "yjsy.cjlu.edu.cn/index/jstz/:suffix",
              "yjsy.cjlu.edu.cn/index/jstz.htm"
            ],
            "target": "/yjsy/jstz"
          }
        ],
        "name": "研究生院",
        "maintainers": [
          "chrisis58"
        ],
        "description": "| 研究生通知 | 教师通知 |\n| -------- | -------- |\n| yjstz    | jstz     |",
        "location": "yjsy/index.ts",
        "module": () => import('@/routes/cjlu/yjsy/index.ts')
      }
    },
    "name": "China Jiliang University",
    "url": "www.cjlu.edu.cn",
    "zh": {
      "name": "中国计量大学"
    },
    "lang": "zh-CN"
  },
  "clickme": {
    "routes": {
      "/:site/:grouping/:name": {
        "path": "/:site/:grouping/:name",
        "categories": [
          "other"
        ],
        "example": "/clickme/default/category/beauty",
        "parameters": {
          "site": "站点，`default`为普通站，`r18`为成人站，其它值默认为普通站",
          "grouping": "分组方式，`category`为分类，`tag`为标签，其他值默认为分类",
          "name": "分类名或标签名，分类名为英文，可以在分类 URL 中找到"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "文章",
        "maintainers": [
          "hoilc"
        ],
        "location": "index.ts",
        "module": () => import('@/routes/clickme/index.ts')
      }
    },
    "name": "ClickMe",
    "apiRoutes": {},
    "url": "clickme.net",
    "lang": "en"
  },
  "cline": {
    "name": "cline",
    "routes": {
      "/blog": {
        "path": "/blog",
        "categories": [
          "blog"
        ],
        "example": "/cline/blog",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "cline.bot/blog/archive",
              "cline.bot/blog"
            ],
            "target": "/blog"
          }
        ],
        "name": "Blog",
        "maintainers": [
          "yeshan333"
        ],
        "description": "Cline Official Blog articles",
        "url": "cline.bot/blog",
        "location": "blog.ts",
        "module": () => import('@/routes/cline/blog.ts')
      }
    },
    "apiRoutes": {}
  },
  "cloudflarestatus": {
    "routes": {
      "/": {
        "path": "/",
        "name": "Status",
        "url": "www.cloudflarestatus.com",
        "maintainers": [
          "nczitzk"
        ],
        "example": "/cloudflarestatus",
        "categories": [
          "programming"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.cloudflarestatus.com"
            ],
            "target": "/"
          }
        ],
        "view": 5,
        "location": "index.tsx",
        "module": () => import('@/routes/cloudflarestatus/index.tsx')
      }
    },
    "name": "Cloudflare Status",
    "apiRoutes": {},
    "url": "cloudflarestatus.com",
    "categories": [
      "programming"
    ],
    "description": "",
    "lang": "en"
  },
  "cloudnative": {
    "routes": {
      "/blog": {
        "path": "/blog",
        "categories": [
          "blog"
        ],
        "example": "/cloudnative/blog",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "博客",
        "maintainers": [
          "aneasystone"
        ],
        "location": "blog.ts",
        "module": () => import('@/routes/cloudnative/blog.ts')
      }
    },
    "name": "云原生社区",
    "apiRoutes": {},
    "url": "cloudnative.to",
    "lang": "zh-CN"
  },
  "cls": {
    "routes": {
      "/depth/:category?": {
        "path": "/depth/:category?",
        "categories": [
          "finance"
        ],
        "example": "/cls/depth/1000",
        "parameters": {
          "category": "分类代码，可在首页导航栏的目标网址 URL 中找到"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "深度",
        "maintainers": [
          "nczitzk"
        ],
        "description": "| 头条 | 股市 | 港股 | 环球 | 公司 | 券商 | 基金 | 地产 | 金融 | 汽车 | 科创 | 创业版 | 品见 | 期货 | 投教 |\n| ---- | ---- | ---- | ---- | ---- | ---- | ---- | ---- | ---- | ---- | ---- | ------ | ---- | ---- | ---- |\n| 1000 | 1003 | 1135 | 1007 | 1005 | 1118 | 1110 | 1006 | 1032 | 1119 | 1111 | 1127   | 1160 | 1124 | 1176 |",
        "location": "depth.ts",
        "module": () => import('@/routes/cls/depth.ts')
      },
      "/hot": {
        "path": "/hot",
        "categories": [
          "finance"
        ],
        "example": "/cls/hot",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "cls.cn/"
            ]
          }
        ],
        "name": "热门文章排行榜",
        "maintainers": [
          "5upernova-heng",
          "nczitzk"
        ],
        "url": "cls.cn/",
        "location": "hot.ts",
        "module": () => import('@/routes/cls/hot.ts')
      },
      "/subject/:id?": {
        "path": "/subject/:id?",
        "name": "话题",
        "url": "www.cls.cn",
        "maintainers": [
          "nczitzk"
        ],
        "example": "/cls/subject/1103",
        "parameters": {
          "category": "分类，默认为 1103，即A股盘面直播，可在对应话题页 URL 中找到"
        },
        "description": "::: tip\n  若订阅 [有声早报](https://www.cls.cn/subject/1151)，网址为 `https://www.cls.cn/subject/1151`。截取 `https://www.cls.cn/subject/` 到末尾的部分 `1151` 作为参数填入，此时路由为 [`/cls/subject/1151`](https://rsshub.app/cls/subject/1151)。\n:::\n    ",
        "categories": [
          "finance"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.cls.cn/subject/:id"
            ]
          }
        ],
        "location": "subject.ts",
        "module": () => import('@/routes/cls/subject.ts')
      },
      "/telegraph/:category?": {
        "path": "/telegraph/:category?",
        "categories": [
          "finance"
        ],
        "example": "/cls/telegraph",
        "parameters": {
          "category": "分类，见下表，默认为全部"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "cls.cn/telegraph",
              "cls.cn/"
            ],
            "target": "/telegraph"
          }
        ],
        "name": "电报",
        "maintainers": [
          "nczitzk"
        ],
        "url": "cls.cn/telegraph",
        "description": "| 看盘  | 公司         | 解读    | 加红 | 推送  | 提醒   | 基金 | 港股 |\n| ----- | ------------ | ------- | ---- | ----- | ------ | ---- | ---- |\n| watch | announcement | explain | red  | jpush | remind | fund | hk   |",
        "location": "telegraph.tsx",
        "module": () => import('@/routes/cls/telegraph.tsx')
      }
    },
    "name": "财联社",
    "apiRoutes": {},
    "url": "cls.cn",
    "lang": "zh-CN"
  },
  "cma": {
    "routes": {
      "/channel/:id?": {
        "path": "/channel/:id?",
        "categories": [
          "forecast"
        ],
        "example": "/cma/channel/380",
        "parameters": {
          "id": "分类，见下表，可在对应频道页 URL 中找到，默认为 380，即每日天气提示"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "天气预报频道",
        "maintainers": [
          "nczitzk"
        ],
        "description": "#### 天气实况\n\n| 频道名称 | 频道 id                          |\n| -------- | -------------------------------- |\n| 卫星云图 | d3236549863e453aab0ccc4027105bad |\n| 单站雷达 | 103                              |\n| 降水量   | 18                               |\n| 气温     | 32                               |\n| 土壤水分 | 45                               |\n\n#### 气象公报\n\n| 频道名称       | 频道 id                          |\n| -------------- | -------------------------------- |\n| 每日天气提示   | 380                              |\n| 重要天气提示   | da5d55817ad5430fb9796a0780178533 |\n| 天气公报       | 3780                             |\n| 强对流天气预报 | 383                              |\n| 交通气象预报   | 423                              |\n| 森林火险预报   | 424                              |\n| 海洋天气公报   | 452                              |\n| 环境气象公报   | 467                              |\n\n::: tip\n  订阅更多细分频道，请前往对应上级频道页，使用下拉菜单选择项目后跳转到目标频道页，查看其 URL 找到对应频道 id\n:::",
        "location": "channel.tsx",
        "module": () => import('@/routes/cma/channel.tsx')
      }
    },
    "name": "中国气象局",
    "apiRoutes": {},
    "url": "weather.cma.cn",
    "lang": "zh-CN"
  },
  "cmde": {
    "routes": {
      "/:cate{.+}?": {
        "path": "/:cate{.+}?",
        "name": "Unknown",
        "maintainers": [],
        "location": "index.ts",
        "module": () => import('@/routes/cmde/index.ts')
      }
    },
    "name": "国家药品监督管理局医疗器械技术审评中心",
    "apiRoutes": {},
    "url": "www.cmde.org.cn",
    "lang": "zh-CN"
  },
  "cmpxchg8b": {
    "routes": {
      "/articles": {
        "path": "/articles",
        "categories": [
          "blog"
        ],
        "example": "/cmpxchg8b/articles",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "lock.cmpxchg8b.com/articles"
            ]
          }
        ],
        "name": "Articles",
        "maintainers": [
          "yuguorui"
        ],
        "url": "lock.cmpxchg8b.com/articles",
        "location": "articles.ts",
        "module": () => import('@/routes/cmpxchg8b/articles.ts')
      }
    },
    "name": "cmpxchg8b",
    "apiRoutes": {},
    "url": "lock.cmpxchg8b.com",
    "lang": "en"
  },
  "cmu": {
    "routes": {
      "/andypavlo/blog": {
        "path": "/andypavlo/blog",
        "categories": [
          "blog"
        ],
        "example": "/cmu/andypavlo/blog",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "Andy Pavlo Blog",
        "maintainers": [
          "mocusez"
        ],
        "location": "andypavlo/blog.ts",
        "module": () => import('@/routes/cmu/andypavlo/blog.ts')
      }
    },
    "name": "Carnegie Mellon University",
    "apiRoutes": {},
    "url": "www.cmu.edu",
    "lang": "en"
  },
  "cn-healthcare": {
    "routes": {
      "/index": {
        "path": "/index",
        "categories": [
          "new-media"
        ],
        "example": "/cn-healthcare/index",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "cn-healthcare.com/"
            ]
          }
        ],
        "name": "首页",
        "maintainers": [
          "qnloft"
        ],
        "url": "cn-healthcare.com/",
        "location": "index.ts",
        "module": () => import('@/routes/cn-healthcare/index.ts')
      }
    },
    "name": "健康界",
    "apiRoutes": {},
    "url": "cn-healthcare.com",
    "lang": "zh-CN"
  },
  "cna": {
    "routes": {
      "/:id?": {
        "path": "/:id?",
        "categories": [
          "traditional-media"
        ],
        "example": "/cna/aall",
        "parameters": {
          "id": "分类 id 或新闻专题 id。分类 id 见下表，新闻专题 id 為 https://www.cna.com.tw/list/newstopic.aspx 中，連結的數字部份。此參數默认为 aall"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "分类",
        "maintainers": [
          "nczitzk"
        ],
        "description": "| 聚焦      | 即時 | 政治 | 國際 | 兩岸 | 產經 | 證券 | 科技 | 生活 | 社會 | 地方 | 文化 | 運動 | 娛樂 |\n| --------- | ---- | ---- | ---- | ---- | ---- | ---- | ---- | ---- | ---- | ---- | ---- | ---- | ---- |\n| headlines | aall | aipl | aopl | acn  | aie  | asc  | ait  | ahel | asoc | aloc | acul | aspt | amov |",
        "location": "index.ts",
        "module": () => import('@/routes/cna/index.ts')
      },
      "/web/:id?": {
        "path": "/web/:id?",
        "categories": [
          "traditional-media"
        ],
        "example": "/cna/web/aall",
        "parameters": {
          "id": "分类 id，见上表。此參數默认为 aall"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "分类 (网页爬虫方法)",
        "maintainers": [
          "dzx-dzx"
        ],
        "location": "web/index.ts",
        "module": () => import('@/routes/cna/web/index.ts')
      }
    },
    "name": "中央通讯社",
    "apiRoutes": {},
    "url": "cna.com.tw",
    "lang": "zh-TW"
  },
  "cnbc": {
    "routes": {
      "/rss/:id?": {
        "path": "/rss/:id?",
        "categories": [
          "traditional-media"
        ],
        "example": "/cnbc/rss",
        "parameters": {
          "id": "Channel ID, can be found in Official RSS URL, `100003114` (Top News) by default"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.cnbc.com/id/:id/device/rss/rss.html"
            ],
            "target": "/rss/:id"
          }
        ],
        "name": "Full article RSS",
        "maintainers": [
          "TonyRL"
        ],
        "description": "Provides a better reading experience (full articles) over the official ones.\n\n  Support all channels, refer to [CNBC RSS feeds](https://www.cnbc.com/rss-feeds/).",
        "location": "rss.ts",
        "module": () => import('@/routes/cnbc/rss.ts')
      }
    },
    "name": "CNBC",
    "url": "search.cnbc.com",
    "lang": "en"
  },
  "cnbeta": {
    "routes": {
      "/category/:id": {
        "name": "分类",
        "path": [
          "/category/:id"
        ],
        "example": "/cnbeta/category/movie",
        "maintainers": [
          "nczitzk"
        ],
        "parameters": {
          "id": "分类 id，可在对应分类页的 URL 中找到"
        },
        "radar": [
          {
            "source": [
              "cnbeta.com.tw/category/:id"
            ]
          }
        ],
        "url": "cnbeta.com.tw",
        "description": "| 影视  | 音乐  | 游戏 | 动漫  | 趣闻  | 科学    | 软件 |\n| ----- | ----- | ---- | ----- | ----- | ------- | ---- |\n| movie | music | game | comic | funny | science | soft |",
        "location": "category.ts",
        "module": () => import('@/routes/cnbeta/category.ts')
      },
      "/": {
        "name": "头条资讯",
        "path": [
          "/"
        ],
        "example": "/cnbeta",
        "radar": [
          {
            "source": [
              "cnbeta.com.tw/"
            ]
          }
        ],
        "maintainers": [
          "kt286",
          "HaitianLiu",
          "nczitzk"
        ],
        "url": "cnbeta.com.tw",
        "location": "index.ts",
        "module": () => import('@/routes/cnbeta/index.ts')
      },
      "/topics/:id": {
        "name": "主题",
        "path": [
          "/topics/:id"
        ],
        "example": "/cnbeta/topics/453",
        "maintainers": [
          "cczhong11",
          "nczitzk"
        ],
        "parameters": {
          "id": "主题 id，可在对应主题页的 URL 中找到"
        },
        "radar": [
          {
            "source": [
              "cnbeta.com.tw/topics/:id"
            ]
          }
        ],
        "url": "cnbeta.com.tw",
        "description": "::: tip\n完整的主题列表参见 [主题列表](https://www.cnbeta.com.tw/topics.htm)\n:::",
        "location": "topics.ts",
        "module": () => import('@/routes/cnbeta/topics.ts')
      }
    },
    "name": "cnBeta.COM",
    "apiRoutes": {},
    "url": "cnbeta.com.tw",
    "categories": [
      "new-media"
    ],
    "lang": "zh-TW"
  },
  "cnblogs": {
    "routes": {
      "/aggsite/topdiggs": {
        "path": [
          "/aggsite/topdiggs",
          "/aggsite/topviews",
          "/aggsite/headline",
          "/cate/:type",
          "/pick"
        ],
        "categories": [
          "blog"
        ],
        "example": "/cnblogs/aggsite/topdiggs",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.cnblogs.com/aggsite/topdiggs"
            ]
          }
        ],
        "name": "10 天推荐排行榜",
        "maintainers": [
          "hujingnb"
        ],
        "url": "www.cnblogs.com/pick",
        "description": "在博客园主页的分类出可查看所有类型。例如，go 的分类地址为: `https://www.cnblogs.com/cate/go/`, 则: [`/cnblogs/cate/go`](https://rsshub.app/cnblogs/cate/go)",
        "location": "common.ts",
        "module": () => import('@/routes/cnblogs/common.ts')
      },
      "/aggsite/topviews": {
        "path": [
          "/aggsite/topdiggs",
          "/aggsite/topviews",
          "/aggsite/headline",
          "/cate/:type",
          "/pick"
        ],
        "categories": [
          "blog"
        ],
        "example": "/cnblogs/aggsite/topdiggs",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.cnblogs.com/aggsite/topdiggs"
            ]
          }
        ],
        "name": "10 天推荐排行榜",
        "maintainers": [
          "hujingnb"
        ],
        "url": "www.cnblogs.com/pick",
        "description": "在博客园主页的分类出可查看所有类型。例如，go 的分类地址为: `https://www.cnblogs.com/cate/go/`, 则: [`/cnblogs/cate/go`](https://rsshub.app/cnblogs/cate/go)",
        "location": "common.ts",
        "module": () => import('@/routes/cnblogs/common.ts')
      },
      "/aggsite/headline": {
        "path": [
          "/aggsite/topdiggs",
          "/aggsite/topviews",
          "/aggsite/headline",
          "/cate/:type",
          "/pick"
        ],
        "categories": [
          "blog"
        ],
        "example": "/cnblogs/aggsite/topdiggs",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.cnblogs.com/aggsite/topdiggs"
            ]
          }
        ],
        "name": "10 天推荐排行榜",
        "maintainers": [
          "hujingnb"
        ],
        "url": "www.cnblogs.com/pick",
        "description": "在博客园主页的分类出可查看所有类型。例如，go 的分类地址为: `https://www.cnblogs.com/cate/go/`, 则: [`/cnblogs/cate/go`](https://rsshub.app/cnblogs/cate/go)",
        "location": "common.ts",
        "module": () => import('@/routes/cnblogs/common.ts')
      },
      "/cate/:type": {
        "path": [
          "/aggsite/topdiggs",
          "/aggsite/topviews",
          "/aggsite/headline",
          "/cate/:type",
          "/pick"
        ],
        "categories": [
          "blog"
        ],
        "example": "/cnblogs/aggsite/topdiggs",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.cnblogs.com/aggsite/topdiggs"
            ]
          }
        ],
        "name": "10 天推荐排行榜",
        "maintainers": [
          "hujingnb"
        ],
        "url": "www.cnblogs.com/pick",
        "description": "在博客园主页的分类出可查看所有类型。例如，go 的分类地址为: `https://www.cnblogs.com/cate/go/`, 则: [`/cnblogs/cate/go`](https://rsshub.app/cnblogs/cate/go)",
        "location": "common.ts",
        "module": () => import('@/routes/cnblogs/common.ts')
      },
      "/pick": {
        "path": [
          "/aggsite/topdiggs",
          "/aggsite/topviews",
          "/aggsite/headline",
          "/cate/:type",
          "/pick"
        ],
        "categories": [
          "blog"
        ],
        "example": "/cnblogs/aggsite/topdiggs",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.cnblogs.com/aggsite/topdiggs"
            ]
          }
        ],
        "name": "10 天推荐排行榜",
        "maintainers": [
          "hujingnb"
        ],
        "url": "www.cnblogs.com/pick",
        "description": "在博客园主页的分类出可查看所有类型。例如，go 的分类地址为: `https://www.cnblogs.com/cate/go/`, 则: [`/cnblogs/cate/go`](https://rsshub.app/cnblogs/cate/go)",
        "location": "common.ts",
        "module": () => import('@/routes/cnblogs/common.ts')
      }
    },
    "name": "博客园",
    "apiRoutes": {},
    "url": "www.cnblogs.com",
    "lang": "zh-CN"
  },
  "cncf": {
    "routes": {
      "/:cate?": {
        "path": "/:cate?",
        "categories": [
          "programming"
        ],
        "example": "/cncf",
        "parameters": {
          "cate": "blog by default"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "Category",
        "maintainers": [
          "Fatpandac"
        ],
        "description": "| Blog | News | Announcements | Reports |\n| ---- | ---- | ------------- | ------- |\n| blog | news | announcements | reports |",
        "location": "index.ts",
        "module": () => import('@/routes/cncf/index.ts')
      },
      "/reports": {
        "path": "/reports",
        "radar": [
          {
            "source": [
              "cncf.io/reports"
            ]
          }
        ],
        "name": "Unknown",
        "maintainers": [],
        "url": "cncf.io/reports",
        "location": "reports.ts",
        "module": () => import('@/routes/cncf/reports.ts')
      }
    },
    "name": "CNCF",
    "apiRoutes": {},
    "url": "cncf.io",
    "lang": "en"
  },
  "cneb": {
    "routes": {
      "/yjxw/:category?": {
        "path": "/yjxw/:category?",
        "categories": [
          "forecast"
        ],
        "example": "/cneb/yjxw",
        "parameters": {
          "category": "分类，见下表，默认为全部"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "cneb.gov.cn/yjxw/:category?",
              "cneb.gov.cn/"
            ]
          }
        ],
        "name": "应急新闻",
        "maintainers": [
          "nczitzk"
        ],
        "description": "| 全部 | 国内新闻 | 国际新闻 |\n| ---- | -------- | -------- |\n|      | gnxw     | gjxw     |",
        "location": "yjxw.ts",
        "module": () => import('@/routes/cneb/yjxw.ts')
      },
      "/yjxx/*": {
        "path": "/yjxx/*",
        "radar": [
          {
            "source": [
              "cneb.gov.cn/yjxx",
              "cneb.gov.cn/"
            ],
            "target": "/yjxx"
          }
        ],
        "name": "Unknown",
        "maintainers": [],
        "url": "cneb.gov.cn/yjxx",
        "location": "yjxx.ts",
        "module": () => import('@/routes/cneb/yjxx.ts')
      }
    },
    "name": "中国国家应急广播",
    "url": "cneb.gov.cn",
    "lang": "zh-CN"
  },
  "cngal": {
    "routes": {
      "/entry/:id": {
        "path": "/entry/:id",
        "categories": [
          "anime"
        ],
        "example": "/cngal/entry/2693",
        "parameters": {
          "id": "词条ID，游戏或制作者页面URL的最后一串数字"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.cngal.org/entries/index/:id"
            ]
          }
        ],
        "name": "制作者 / 游戏新闻",
        "maintainers": [
          "kmod-midori"
        ],
        "location": "entry.tsx",
        "module": () => import('@/routes/cngal/entry.tsx')
      },
      "/weekly": {
        "path": "/weekly",
        "categories": [
          "anime"
        ],
        "view": 0,
        "example": "/cngal/weekly",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.cngal.org/",
              "www.cngal.org/weeklynews"
            ]
          }
        ],
        "name": "每周速报",
        "maintainers": [
          "kmod-midori"
        ],
        "url": "www.cngal.org/",
        "location": "weekly.tsx",
        "module": () => import('@/routes/cngal/weekly.tsx')
      }
    },
    "name": "CnGal",
    "apiRoutes": {},
    "url": "www.cngal.org",
    "lang": "zh-CN"
  },
  "cngold": {
    "routes": {
      "/:category?": {
        "path": "/:category?",
        "name": "分类",
        "url": "www.cngold.org.cn",
        "maintainers": [
          "nczitzk"
        ],
        "example": "/cngold/news-325",
        "parameters": {
          "category": "分类，默认为 `news-325`，即行业资讯，可在对应分类页 URL 中找到, Category, `news-325`，即行业资讯by default"
        },
        "description": "::: tip\n  若订阅 [行业资讯](https://www.cngold.org.cn/news-325.html)，网址为 `https://www.cngold.org.cn/news-325.html`。截取 `https://www.cngold.org.cn/` 到末尾 `.html` 的部分 `news-325` 作为参数填入，此时路由为 [`/cngold/news-325`](https://rsshub.app/cngold/news-325)。\n:::\n\n#### 资讯中心\n\n| [图片新闻](https://www.cngold.org.cn/news-323.html) | [通知公告](https://www.cngold.org.cn/news-324.html) | [党建工作](https://www.cngold.org.cn/news-326.html) | [行业资讯](https://www.cngold.org.cn/news-325.html) | [黄金矿业](https://www.cngold.org.cn/news-327.html) | [黄金消费](https://www.cngold.org.cn/news-328.html) |\n| --------------------------------------------------- | --------------------------------------------------- | --------------------------------------------------- | --------------------------------------------------- | --------------------------------------------------- | --------------------------------------------------- |\n| [news-323](https://rsshub.app/cngold/news-323)      | [news-324](https://rsshub.app/cngold/news-324)      | [news-326](https://rsshub.app/cngold/news-326)      | [news-325](https://rsshub.app/cngold/news-325)      | [news-327](https://rsshub.app/cngold/news-327)      | [news-328](https://rsshub.app/cngold/news-328)      |\n\n| [黄金市场](https://www.cngold.org.cn/news-329.html) | [社会责任](https://www.cngold.org.cn/news-330.html) | [黄金书屋](https://www.cngold.org.cn/news-331.html) | [工作交流](https://www.cngold.org.cn/news-332.html) | [黄金统计](https://www.cngold.org.cn/news-333.html) | [协会动态](https://www.cngold.org.cn/news-334.html) |\n| --------------------------------------------------- | --------------------------------------------------- | --------------------------------------------------- | --------------------------------------------------- | --------------------------------------------------- | --------------------------------------------------- |\n| [news-329](https://rsshub.app/cngold/news-329)      | [news-330](https://rsshub.app/cngold/news-330)      | [news-331](https://rsshub.app/cngold/news-331)      | [news-332](https://rsshub.app/cngold/news-332)      | [news-333](https://rsshub.app/cngold/news-333)      | [news-334](https://rsshub.app/cngold/news-334)      |\n\n<details>\n<summary>更多分类</summary>\n\n#### [政策法规](https://www.cngold.org.cn/policies.html)\n\n| [法律法规](https://www.cngold.org.cn/policies-245.html) | [产业政策](https://www.cngold.org.cn/policies-262.html) | [黄金标准](https://www.cngold.org.cn/policies-281.html) |\n| ------------------------------------------------------- | ------------------------------------------------------- | ------------------------------------------------------- |\n| [policies-245](https://rsshub.app/cngold/policies-245)  | [policies-262](https://rsshub.app/cngold/policies-262)  | [policies-281](https://rsshub.app/cngold/policies-281)  |\n\n#### [行业培训](https://www.cngold.org.cn/training.html)\n\n| [黄金投资分析师](https://www.cngold.org.cn/training-242.html) | [教育部1+X](https://www.cngold.org.cn/training-246.html) | [矿业权评估师](https://www.cngold.org.cn/training-338.html) | [其他培训](https://www.cngold.org.cn/training-247.html) |\n| ------------------------------------------------------------- | -------------------------------------------------------- | ----------------------------------------------------------- | ------------------------------------------------------- |\n| [training-242](https://rsshub.app/cngold/training-242)        | [training-246](https://rsshub.app/cngold/training-246)   | [training-338](https://rsshub.app/cngold/training-338)      | [training-247](https://rsshub.app/cngold/training-247)  |\n\n#### [黄金科技](https://www.cngold.org.cn/technology.html)\n\n| [黄金协会科学技术奖](https://www.cngold.org.cn/technology-318.html) | [科学成果评价](https://www.cngold.org.cn/technology-319.html) | [新技术推广](https://www.cngold.org.cn/technology-320.html) | [黄金技术大会](https://www.cngold.org.cn/technology-350.html) |\n| ------------------------------------------------------------------- | ------------------------------------------------------------- | ----------------------------------------------------------- | ------------------------------------------------------------- |\n| [technology-318](https://rsshub.app/cngold/technology-318)          | [technology-319](https://rsshub.app/cngold/technology-319)    | [technology-320](https://rsshub.app/cngold/technology-320)  | [technology-350](https://rsshub.app/cngold/technology-350)    |\n\n</details>\n    ",
        "categories": [
          "new-media"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.cngold.org.cn/:category?"
            ]
          },
          {
            "title": "政策法规 - 法律法规",
            "source": [
              "www.cngold.org.cn/policies-245.html"
            ],
            "target": "/policies-245"
          },
          {
            "title": "政策法规 - 产业政策",
            "source": [
              "www.cngold.org.cn/policies-262.html"
            ],
            "target": "/policies-262"
          },
          {
            "title": "政策法规 - 黄金标准",
            "source": [
              "www.cngold.org.cn/policies-281.html"
            ],
            "target": "/policies-281"
          },
          {
            "title": "行业培训 - 黄金投资分析师",
            "source": [
              "www.cngold.org.cn/training-242.html"
            ],
            "target": "/training-242"
          },
          {
            "title": "行业培训 - 教育部1+X",
            "source": [
              "www.cngold.org.cn/training-246.html"
            ],
            "target": "/training-246"
          },
          {
            "title": "行业培训 - 矿业权评估师",
            "source": [
              "www.cngold.org.cn/training-338.html"
            ],
            "target": "/training-338"
          },
          {
            "title": "行业培训 - 其他培训",
            "source": [
              "www.cngold.org.cn/training-247.html"
            ],
            "target": "/training-247"
          },
          {
            "title": "黄金科技 - 黄金协会科学技术奖",
            "source": [
              "www.cngold.org.cn/technology-318.html"
            ],
            "target": "/technology-318"
          },
          {
            "title": "黄金科技 - 科学成果评价",
            "source": [
              "www.cngold.org.cn/technology-319.html"
            ],
            "target": "/technology-319"
          },
          {
            "title": "黄金科技 - 新技术推广",
            "source": [
              "www.cngold.org.cn/technology-320.html"
            ],
            "target": "/technology-320"
          },
          {
            "title": "黄金科技 - 黄金技术大会",
            "source": [
              "www.cngold.org.cn/technology-350.html"
            ],
            "target": "/technology-350"
          }
        ],
        "location": "index.ts",
        "module": () => import('@/routes/cngold/index.ts')
      }
    },
    "name": "中国黄金协会",
    "apiRoutes": {},
    "url": "cngold.org.cn",
    "categories": [
      "new-media"
    ],
    "description": "",
    "lang": "zh-CN"
  },
  "cnjxol": {
    "routes": {
      "/:category?/:id?": {
        "path": "/:category?/:id?",
        "name": "Unknown",
        "maintainers": [],
        "location": "index.tsx",
        "module": () => import('@/routes/cnjxol/index.tsx')
      }
    },
    "name": "南湖清风",
    "apiRoutes": {},
    "url": "cnjxol.com",
    "lang": "zh-CN"
  },
  "cnki": {
    "routes": {
      "/author/:name/:company": {
        "name": "作者",
        "maintainers": [
          "Derekmini",
          "harveyqiu"
        ],
        "categories": [
          "journal"
        ],
        "path": "/author/:name/:company",
        "parameters": {
          "name": "作者姓名",
          "company": "作者单位"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "example": "/cnki/author/丁晓东/中国人民大学",
        "description": "::: tip\n    可能仅限中国大陆服务器访问，以实际情况为准。\n:::",
        "location": "author.ts",
        "module": () => import('@/routes/cnki/author.ts')
      },
      "/journals/debut/:name": {
        "path": "/journals/debut/:name",
        "categories": [
          "journal"
        ],
        "example": "/cnki/journals/debut/LKGP",
        "parameters": {
          "name": "期刊缩写，可以在网址中得到"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "navi.cnki.net/knavi/journals/:name/detail"
            ]
          }
        ],
        "name": "网络首发",
        "maintainers": [
          "Fatpandac"
        ],
        "location": "debut.ts",
        "module": () => import('@/routes/cnki/debut.ts')
      },
      "/journals/:name": {
        "path": "/journals/:name",
        "categories": [
          "journal"
        ],
        "example": "/cnki/journals/LKGP",
        "parameters": {
          "name": "期刊缩写，可以在网址中得到"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "navi.cnki.net/knavi/journals/:name/detail"
            ]
          }
        ],
        "name": "期刊",
        "maintainers": [
          "Fatpandac",
          "Derekmini",
          "pseudoyu"
        ],
        "location": "journals.ts",
        "module": () => import('@/routes/cnki/journals.ts')
      }
    },
    "name": "中国知网",
    "apiRoutes": {},
    "url": "navi.cnki.net",
    "lang": "zh-CN"
  },
  "cnljxh": {
    "routes": {
      "/:category?/:id?": {
        "path": "/:category?/:id?",
        "name": "栏目",
        "url": "www.cnljxh.org.cn",
        "maintainers": [
          "nczitzk"
        ],
        "example": "/cnljxh/news/10",
        "parameters": {
          "category": {
            "description": "分类，默认为 `news`，即行业新闻，可在对应分类页 URL 中找到",
            "options": [
              {
                "label": "行业新闻",
                "value": "news"
              },
              {
                "label": "市场价格",
                "value": "price"
              },
              {
                "label": "分析数据",
                "value": "info"
              },
              {
                "label": "价格指数",
                "value": "date"
              }
            ]
          },
          "id": {
            "description": "分类，默认为 `10`，即协会公告，可在对应分类页 URL 中找到",
            "options": [
              {
                "label": "协会专区 - 协会简介",
                "value": "24"
              },
              {
                "label": "协会专区 - 协会章程",
                "value": "25"
              },
              {
                "label": "协会专区 - 协会领导",
                "value": "26"
              },
              {
                "label": "协会专区 - 入会程序",
                "value": "27"
              },
              {
                "label": "协会专区 - 组织机构",
                "value": "28"
              },
              {
                "label": "协会专区 - 理事会员",
                "value": "29"
              },
              {
                "label": "协会专区 - 监事会",
                "value": "32"
              },
              {
                "label": "协会专区 - 专家委员会",
                "value": "30"
              },
              {
                "label": "协会公告",
                "value": "10"
              },
              {
                "label": "行业新闻 - 协会动态",
                "value": "8"
              },
              {
                "label": "行业新闻 - 企业动态",
                "value": "9"
              },
              {
                "label": "行业新闻 - 行业动态",
                "value": "11"
              },
              {
                "label": "政策法规 - 政策法规",
                "value": "12"
              },
              {
                "label": "行业标准 - 国家标准",
                "value": "13"
              },
              {
                "label": "行业标准 - 行业标准",
                "value": "14"
              },
              {
                "label": "行业标准 - 团体标准",
                "value": "15"
              },
              {
                "label": "减污降碳 - 超低排放",
                "value": "33"
              },
              {
                "label": "减污降碳 - 技术广角",
                "value": "16"
              },
              {
                "label": "市场价格 - 价格行情",
                "value": "299"
              },
              {
                "label": "市场价格 - 双焦运费",
                "value": "2143"
              },
              {
                "label": "市场价格 - 价格汇总",
                "value": "10039"
              },
              {
                "label": "分析数据 - 市场分析",
                "value": "575"
              },
              {
                "label": "分析数据 - 一周评述",
                "value": "5573"
              },
              {
                "label": "分析数据 - 核心数据",
                "value": "5417"
              },
              {
                "label": "价格指数 - 焦炭指数(MyCpic)",
                "value": "5575"
              },
              {
                "label": "价格指数 - 炼焦煤指数(MyCpic)",
                "value": "5907"
              },
              {
                "label": "价格指数 - 山西焦炭价格指数（SCSPI）",
                "value": "34"
              },
              {
                "label": "价格指数 - 中价·新华焦煤价格指数（CCP）",
                "value": "35"
              },
              {
                "label": "市场信息 - 汾渭",
                "value": "19"
              },
              {
                "label": "市场信息 - 化工宝",
                "value": "20"
              },
              {
                "label": "市场信息 - 百川",
                "value": "21"
              },
              {
                "label": "市场信息 - 焦化市场信息",
                "value": "22"
              },
              {
                "label": "市场信息 - 中国焦化信息",
                "value": "31"
              }
            ]
          }
        },
        "description": ":::tip\n订阅 [协会公告](https://www.cnljxh.org.cn/news/?classid=10)，其源网址为 `https://www.cnljxh.org.cn/news/?classid=10`，请参考该 URL 指定部分构成参数，此时路由为 [`/cnljxh/news/10`](https://rsshub.app/cnljxh/news/10)。\n\n订阅 [价格行情](https://www.cnljxh.org.cn/price/?classid=299)，其源网址为 `https://www.cnljxh.org.cn/price/?classid=299`，请参考该 URL 指定部分构成参数，此时路由为 [`/cnljxh/price/299`](https://rsshub.app/cnljxh/price/299)。\n:::\n\n<details>\n  <summary>更多分类</summary>\n\n#### 协会专区\n\n| [协会简介](https://www.cnljxh.org.cn/news/?classid=24) | [协会章程](https://www.cnljxh.org.cn/news/?classid=25) | [协会领导](https://www.cnljxh.org.cn/news/?classid=26) | [入会程序](https://www.cnljxh.org.cn/news/?classid=27) | [组织机构](https://www.cnljxh.org.cn/news/?classid=28) |\n| ------------------------------------------------------ | ------------------------------------------------------ | ------------------------------------------------------ | ------------------------------------------------------ | ------------------------------------------------------ |\n| [24](https://rsshub.app/cnljxh/news/24)                | [25](https://rsshub.app/cnljxh/news/25)                | [26](https://rsshub.app/cnljxh/news/26)                | [27](https://rsshub.app/cnljxh/news/27)                | [28](https://rsshub.app/cnljxh/news/28)                |\n\n| [理事会员](https://www.cnljxh.org.cn/news/?classid=29) | [监事会](https://www.cnljxh.org.cn/news/?classid=32) | [专家委员会](https://www.cnljxh.org.cn/news/?classid=30) |\n| ------------------------------------------------------ | ---------------------------------------------------- | -------------------------------------------------------- |\n| [29](https://rsshub.app/cnljxh/news/29)                | [32](https://rsshub.app/cnljxh/news/32)              | [30](https://rsshub.app/cnljxh/news/30)                  |\n\n#### 协会公告\n\n| [协会公告](https://www.cnljxh.org.cn/news/?classid=10) |\n| ------------------------------------------------------ |\n| [10](https://rsshub.app/cnljxh/news/10)                |\n\n#### 行业新闻\n\n| [协会动态](https://www.cnljxh.org.cn/news/?classid=8) | [企业动态](https://www.cnljxh.org.cn/news/?classid=9) | [行业动态](https://www.cnljxh.org.cn/news/?classid=11) |\n| ----------------------------------------------------- | ----------------------------------------------------- | ------------------------------------------------------ |\n| [8](https://rsshub.app/cnljxh/news/8)                 | [9](https://rsshub.app/cnljxh/news/9)                 | [11](https://rsshub.app/cnljxh/news/11)                |\n\n#### 政策法规\n\n| [政策法规](https://www.cnljxh.org.cn/news/?classid=12) |\n| ------------------------------------------------------ |\n| [12](https://rsshub.app/cnljxh/news/12)                |\n\n#### 行业标准\n\n| [国家标准](https://www.cnljxh.org.cn/news/?classid=13) | [行业标准](https://www.cnljxh.org.cn/news/?classid=14) | [团体标准](https://www.cnljxh.org.cn/news/?classid=15) |\n| ------------------------------------------------------ | ------------------------------------------------------ | ------------------------------------------------------ |\n| [13](https://rsshub.app/cnljxh/news/13)                | [14](https://rsshub.app/cnljxh/news/14)                | [15](https://rsshub.app/cnljxh/news/15)                |\n\n#### 减污降碳\n\n| [超低排放](https://www.cnljxh.org.cn/news/indexdp.php?classid=33) | [技术广角](https://www.cnljxh.org.cn/news/?classid=16) |\n| ----------------------------------------------------------------- | ------------------------------------------------------ |\n| [33](https://rsshub.app/cnljxh/news/33)                           | [16](https://rsshub.app/cnljxh/news/16)                |\n\n#### 市场价格\n\n| [价格行情](https://www.cnljxh.org.cn/price/?classid=299) | [双焦运费](https://www.cnljxh.org.cn/price/?classid=2143) | [价格汇总](https://www.cnljxh.org.cn/collect/?classid=10039) |\n| -------------------------------------------------------- | --------------------------------------------------------- | ------------------------------------------------------------ |\n| [299](https://rsshub.app/cnljxh/price/299)               | [2143](https://rsshub.app/cnljxh/price/2143)              | [10039](https://rsshub.app/cnljxh/price/10039)               |\n\n#### 分析数据\n\n| [市场分析](https://www.cnljxh.org.cn/info/?classid=575) | [一周评述](https://www.cnljxh.org.cn/info/?classid=5573) | [核心数据](https://www.cnljxh.org.cn/info/?classid=5417) |\n| ------------------------------------------------------- | -------------------------------------------------------- | -------------------------------------------------------- |\n| [575](https://rsshub.app/cnljxh/info/575)               | [5573](https://rsshub.app/cnljxh/info/5573)              | [5417](https://rsshub.app/cnljxh/info/5417)              |\n\n#### 价格指数\n\n| [焦炭指数(MyCpic)](https://www.cnljxh.org.cn/date/?classid=5575) | [炼焦煤指数(MyCpic)](https://www.cnljxh.org.cn/date/?classid=5907) | [山西焦炭价格指数（SCSPI）](https://www.cnljxh.org.cn/news/index.php?classid=34) | [中价·新华焦煤价格指数（CCP）](https://www.cnljxh.org.cn/news/index.php?classid=35) |\n| ---------------------------------------------------------------- | ------------------------------------------------------------------ | -------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------- |\n| [5575](https://rsshub.app/cnljxh/date/5575)                      | [5907](https://rsshub.app/cnljxh/date/5907)                        | [34](https://rsshub.app/cnljxh/news/34)                                          | [35](https://rsshub.app/cnljxh/news/35)                                             |\n\n#### 市场信息\n\n| [汾渭](https://www.cnljxh.org.cn/news/?classid=19) | [化工宝](https://www.cnljxh.org.cn/news/?classid=20) | [百川](https://www.cnljxh.org.cn/news/?classid=21) | [焦化市场信息](https://www.cnljxh.org.cn/news/?classid=22) | [中国焦化信息](https://www.cnljxh.org.cn/news/?classid=31) |\n| -------------------------------------------------- | ---------------------------------------------------- | -------------------------------------------------- | ---------------------------------------------------------- | ---------------------------------------------------------- |\n| [19](https://rsshub.app/cnljxh/news/19)            | [20](https://rsshub.app/cnljxh/news/20)              | [21](https://rsshub.app/cnljxh/news/21)            | [22](https://rsshub.app/cnljxh/news/22)                    | [31](https://rsshub.app/cnljxh/news/31)                    |\n\n</details>\n",
        "categories": [
          "new-media"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.cnljxh.org.cn/:category"
            ]
          },
          {
            "title": "协会专区 - 协会简介",
            "source": [
              "www.cnljxh.org.cn/news/?classid=24"
            ],
            "target": "/news/24"
          },
          {
            "title": "协会专区 - 协会章程",
            "source": [
              "www.cnljxh.org.cn/news/?classid=25"
            ],
            "target": "/news/25"
          },
          {
            "title": "协会专区 - 协会领导",
            "source": [
              "www.cnljxh.org.cn/news/?classid=26"
            ],
            "target": "/news/26"
          },
          {
            "title": "协会专区 - 入会程序",
            "source": [
              "www.cnljxh.org.cn/news/?classid=27"
            ],
            "target": "/news/27"
          },
          {
            "title": "协会专区 - 组织机构",
            "source": [
              "www.cnljxh.org.cn/news/?classid=28"
            ],
            "target": "/news/28"
          },
          {
            "title": "协会专区 - 理事会员",
            "source": [
              "www.cnljxh.org.cn/news/?classid=29"
            ],
            "target": "/news/29"
          },
          {
            "title": "协会专区 - 监事会",
            "source": [
              "www.cnljxh.org.cn/news/?classid=32"
            ],
            "target": "/news/32"
          },
          {
            "title": "协会专区 - 专家委员会",
            "source": [
              "www.cnljxh.org.cn/news/?classid=30"
            ],
            "target": "/news/30"
          },
          {
            "title": "协会公告",
            "source": [
              "www.cnljxh.org.cn/news/?classid=10"
            ],
            "target": "/news/10"
          },
          {
            "title": "行业新闻 - 协会动态",
            "source": [
              "www.cnljxh.org.cn/news/?classid=8"
            ],
            "target": "/news/8"
          },
          {
            "title": "行业新闻 - 企业动态",
            "source": [
              "www.cnljxh.org.cn/news/?classid=9"
            ],
            "target": "/news/9"
          },
          {
            "title": "行业新闻 - 行业动态",
            "source": [
              "www.cnljxh.org.cn/news/?classid=11"
            ],
            "target": "/news/11"
          },
          {
            "title": "政策法规",
            "source": [
              "www.cnljxh.org.cn/news/?classid=12"
            ],
            "target": "/news/12"
          },
          {
            "title": "行业标准 - 国家标准",
            "source": [
              "www.cnljxh.org.cn/news/?classid=13"
            ],
            "target": "/news/13"
          },
          {
            "title": "行业标准 - 行业标准",
            "source": [
              "www.cnljxh.org.cn/news/?classid=14"
            ],
            "target": "/news/14"
          },
          {
            "title": "行业标准 - 团体标准",
            "source": [
              "www.cnljxh.org.cn/news/?classid=15"
            ],
            "target": "/news/15"
          },
          {
            "title": "减污降碳 - 超低排放",
            "source": [
              "www.cnljxh.org.cn/news/indexdp.php?classid=33"
            ],
            "target": "/news/33"
          },
          {
            "title": "减污降碳 - 技术广角",
            "source": [
              "www.cnljxh.org.cn/news/?classid=16"
            ],
            "target": "/news/16"
          },
          {
            "title": "市场价格 - 价格行情",
            "source": [
              "www.cnljxh.org.cn/price/?classid=299"
            ],
            "target": "/price/299"
          },
          {
            "title": "市场价格 - 双焦运费",
            "source": [
              "www.cnljxh.org.cn/price/?classid=2143"
            ],
            "target": "/price/2143"
          },
          {
            "title": "市场价格 - 价格汇总",
            "source": [
              "www.cnljxh.org.cn/collect/?classid=10039"
            ],
            "target": "/price/10039"
          },
          {
            "title": "分析数据 - 市场分析",
            "source": [
              "www.cnljxh.org.cn/info/?classid=575"
            ],
            "target": "/info/575"
          },
          {
            "title": "分析数据 - 一周评述",
            "source": [
              "www.cnljxh.org.cn/info/?classid=5573"
            ],
            "target": "/info/5573"
          },
          {
            "title": "分析数据 - 核心数据",
            "source": [
              "www.cnljxh.org.cn/info/?classid=5417"
            ],
            "target": "/info/5417"
          },
          {
            "title": "价格指数 - 焦炭指数(MyCpic)",
            "source": [
              "www.cnljxh.org.cn/date/?classid=5575"
            ],
            "target": "/date/5575"
          },
          {
            "title": "价格指数 - 炼焦煤指数(MyCpic)",
            "source": [
              "www.cnljxh.org.cn/date/?classid=5907"
            ],
            "target": "/date/5907"
          },
          {
            "title": "价格指数 - 山西焦炭价格指数（SCSPI）",
            "source": [
              "www.cnljxh.org.cn/news/index.php?classid=34"
            ],
            "target": "/news/34"
          },
          {
            "title": "价格指数 - 中价·新华焦煤价格指数（CCP）",
            "source": [
              "www.cnljxh.org.cn/news/index.php?classid=35"
            ],
            "target": "/news/35"
          },
          {
            "title": "市场信息 - 汾渭",
            "source": [
              "www.cnljxh.org.cn/news/?classid=19"
            ],
            "target": "/news/19"
          },
          {
            "title": "市场信息 - 化工宝",
            "source": [
              "www.cnljxh.org.cn/news/?classid=20"
            ],
            "target": "/news/20"
          },
          {
            "title": "市场信息 - 百川",
            "source": [
              "www.cnljxh.org.cn/news/?classid=21"
            ],
            "target": "/news/21"
          },
          {
            "title": "市场信息 - 焦化市场信息",
            "source": [
              "www.cnljxh.org.cn/news/?classid=22"
            ],
            "target": "/news/22"
          },
          {
            "title": "市场信息 - 中国焦化信息",
            "source": [
              "www.cnljxh.org.cn/news/?classid=31"
            ],
            "target": "/news/31"
          }
        ],
        "view": 0,
        "location": "index.ts",
        "module": () => import('@/routes/cnljxh/index.ts')
      }
    },
    "name": "中国炼焦行业协会",
    "apiRoutes": {},
    "url": "cnljxh.com",
    "lang": "zh-CN"
  },
  "cntheory": {
    "routes": {
      "/paper/:id?": {
        "path": "/paper/:id?",
        "categories": [
          "traditional-media"
        ],
        "example": "/cntheory/paper",
        "parameters": {
          "id": "板块，默认为全部"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "学习时报",
        "maintainers": [
          "nczitzk"
        ],
        "description": "如订阅 **第 A1 版：国内大局**，路由为 [`/cntheory/paper/国内大局`](https://rsshub.app/cntheory/paper/国内大局)。",
        "location": "paper.tsx",
        "module": () => import('@/routes/cntheory/paper.tsx')
      }
    },
    "name": "理论网",
    "url": "paper.cntheory.com",
    "lang": "zh-CN"
  },
  "cntv": {
    "routes": {
      "/:column": {
        "path": "/:column",
        "categories": [
          "multimedia"
        ],
        "example": "/cntv/TOPC1451528971114112",
        "parameters": {
          "column": "栏目ID, 可在对应CNTV栏目页面找到"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "navi.cctv.com/"
            ]
          }
        ],
        "name": "栏目",
        "maintainers": [
          "WhoIsSure",
          "Fatpandac"
        ],
        "url": "navi.cctv.com/",
        "description": "::: tip\n栏目 ID 查找示例:\n打开栏目具体某一期页面，F12 控制台输入`column_id`得到栏目 ID。\n:::\n\n  栏目\n\n| 新闻联播             | 新闻周刊             | 天下足球             |\n| -------------------- | -------------------- | -------------------- |\n| TOPC1451528971114112 | TOPC1451559180488841 | TOPC1451551777876756 |",
        "location": "column.tsx",
        "module": () => import('@/routes/cntv/column.tsx')
      }
    },
    "name": "CNTV",
    "apiRoutes": {},
    "url": "navi.cctv.com",
    "lang": "zh-CN"
  },
  "cnu": {
    "routes": {
      "/iec": {
        "path": "/iec",
        "categories": [
          "university"
        ],
        "example": "/cnu/iec",
        "parameters": {},
        "radar": [
          {
            "source": [
              "iec.cnu.edu.cn/ggml/tzgg1/index.htm"
            ],
            "target": "/cnu/iec"
          }
        ],
        "name": "信息工程学院通知公告",
        "maintainers": [
          "liueic"
        ],
        "url": "iec.cnu.edu.cn/ggml/tzgg1/index.htm",
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "location": "iec.ts",
        "module": () => import('@/routes/cnu/iec.ts')
      },
      "/jdxw": {
        "path": "/jdxw",
        "categories": [
          "university"
        ],
        "example": "/cnu/jdxw",
        "parameters": {},
        "radar": [
          {
            "source": [
              "news.cnu.edu.cn/xysx/jdxw/index.htm"
            ],
            "target": "/cnu/jdxw"
          }
        ],
        "name": "焦点关注",
        "maintainers": [
          "liueic"
        ],
        "url": "news.cnu.edu.cn/xysx/jdxw/index.htm",
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "location": "jdxw.ts",
        "module": () => import('@/routes/cnu/jdxw.ts')
      },
      "/jwc": {
        "path": "/jwc",
        "categories": [
          "university"
        ],
        "example": "/cnu/jwc",
        "parameters": {},
        "radar": [
          {
            "source": [
              "jwc.cnu.edu.cn/tzgg/index.htm"
            ],
            "target": "/cnu/jwc"
          }
        ],
        "name": "教务处通知公示",
        "maintainers": [
          "liueic"
        ],
        "url": "jwc.cnu.edu.cn/tzgg/index.htm",
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "location": "jwc.ts",
        "module": () => import('@/routes/cnu/jwc.ts')
      },
      "/physics": {
        "path": "/physics",
        "categories": [
          "university"
        ],
        "example": "/cnu/physics",
        "parameters": {},
        "radar": [
          {
            "source": [
              "physics.cnu.edu.cn/news/index.htm"
            ],
            "target": "/cnu/physics"
          }
        ],
        "name": "物理系院系新闻",
        "maintainers": [
          "liueic"
        ],
        "url": "physics.cnu.edu.cn/news/index.htm",
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "location": "physics.ts",
        "module": () => import('@/routes/cnu/physics.ts')
      },
      "/smkxxy": {
        "path": "/smkxxy",
        "categories": [
          "university"
        ],
        "example": "/cnu/smkxxy",
        "parameters": {},
        "radar": [
          {
            "source": [
              "smkxxy.cnu.edu.cn/tzgg3/index.htm"
            ],
            "target": "/cnu/smkxxy"
          }
        ],
        "name": "生命科学学院通知公告",
        "maintainers": [
          "liueic"
        ],
        "url": "smkxxy.cnu.edu.cn/tzgg3/index.htm",
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "location": "smkxxy.ts",
        "module": () => import('@/routes/cnu/smkxxy.ts')
      }
    },
    "name": "首都师范大学",
    "apiRoutes": {},
    "url": "cnu.edu.cn",
    "lang": "zh-CN"
  },
  "cockroachlabs": {
    "routes": {
      "/blog/:category?": {
        "name": "Blogs",
        "maintainers": [
          "CookiePieWw"
        ],
        "categories": [
          "programming"
        ],
        "path": "/blog/:category?",
        "example": "/cockroachlabs/blog/engineering",
        "parameters": {
          "category": "Blog category, e.g., engineering. Subscribe all recent articles if empty."
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "cockroachlabs.com/blog/:category",
              "cockroachlabs.com/blog"
            ],
            "target": "/blog"
          }
        ],
        "location": "blog.ts",
        "module": () => import('@/routes/cockroachlabs/blog.ts')
      }
    },
    "name": "Cockroach Labs",
    "apiRoutes": {},
    "url": "cockroachlabs.com",
    "lang": "en"
  },
  "codefather": {
    "routes": {
      "/posts/:category?/:sort?": {
        "path": "/posts/:category?/:sort?",
        "categories": [
          "programming"
        ],
        "example": "/codefather/posts",
        "parameters": {
          "category": "分类，可选 `交流`、`学习`、`项目`、`资源`、`经验`，默认为全部",
          "sort": "排序方式，可选 `new`（最新）、`hot`（热门）、`recommend`（推荐），默认为 `new`"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.codefather.cn/",
              "www.codefather.cn"
            ],
            "target": "/posts"
          }
        ],
        "name": "帖子",
        "maintainers": [
          "JackyST0"
        ],
        "description": "获取编程导航社区的帖子，支持按热门、最新、推荐排序，支持按分类筛选。",
        "location": "posts.ts",
        "module": () => import('@/routes/codefather/posts.ts')
      },
      "/questions/:sort?": {
        "path": "/questions/:sort?",
        "categories": [
          "programming"
        ],
        "example": "/codefather/questions",
        "parameters": {
          "sort": "排序方式，可选 `new`（最新）、`hot`（热门），默认为 `new`"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.codefather.cn/qa",
              "www.codefather.cn"
            ],
            "target": "/questions"
          }
        ],
        "name": "问答",
        "maintainers": [
          "JackyST0"
        ],
        "description": "获取编程导航社区的问答内容，支持按最新、热门排序。",
        "location": "questions.ts",
        "module": () => import('@/routes/codefather/questions.ts')
      }
    },
    "name": "编程导航",
    "url": "www.codefather.cn",
    "description": "编程导航是一个编程学习交流社区，由程序员鱼皮创建，提供学习路线、项目教程、求职攻略、技术交流等内容。"
  },
  "codeforces": {
    "routes": {
      "/contests": {
        "path": "/contests",
        "categories": [
          "programming"
        ],
        "example": "/codeforces/contests",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "www.codeforces.com/contests"
            ]
          }
        ],
        "name": "Latest contests",
        "maintainers": [
          "Fatpandac"
        ],
        "url": "www.codeforces.com/contests",
        "location": "contests.tsx",
        "module": () => import('@/routes/codeforces/contests.tsx')
      },
      "/recent-actions/:minrating?": {
        "path": "/recent-actions/:minrating?",
        "categories": [
          "programming"
        ],
        "example": "/codeforces/recent-actions",
        "parameters": {
          "minrating": "The minimum blog/comment rating required. Default: 1"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "codeforces.com/recent-actions"
            ],
            "target": "/recent-actions"
          }
        ],
        "name": "Recent actions",
        "maintainers": [],
        "url": "codeforces.com/recent-actions",
        "location": "recent-actions.ts",
        "module": () => import('@/routes/codeforces/recent-actions.ts')
      }
    },
    "name": "Codeforces",
    "apiRoutes": {},
    "url": "codeforces.com",
    "lang": "en"
  },
  "cognition": {
    "name": "cognition",
    "routes": {
      "/blog": {
        "path": "/blog",
        "name": "Blog",
        "url": "cognition.ai/blog",
        "maintainers": [
          "Loongphy"
        ],
        "example": "/cognition/blog",
        "categories": [
          "programming"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "cognition.ai/blog/1"
            ],
            "target": "/blog"
          }
        ],
        "view": 0,
        "location": "blog.ts",
        "module": () => import('@/routes/cognition/blog.ts')
      }
    },
    "apiRoutes": {}
  },
  "cohere": {
    "routes": {
      "/blog": {
        "path": [
          "/blog"
        ],
        "name": "Blog",
        "url": "cohere.com/blog",
        "maintainers": [
          "Loongphy"
        ],
        "example": "/cohere/blog",
        "description": "Cohere is a platform for building AI applications.",
        "categories": [
          "blog"
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportRadar": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "cohere.com"
            ]
          }
        ],
        "location": "index.ts",
        "module": () => import('@/routes/cohere/index.ts')
      }
    },
    "name": "Cohere",
    "apiRoutes": {},
    "url": "cohere.com",
    "lang": "en"
  },
  "coindesk": {
    "routes": {
      "/consensus-magazine": {
        "path": "/consensus-magazine",
        "categories": [
          "new-media"
        ],
        "example": "/coindesk/consensus-magazine",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "radar": [
          {
            "source": [
              "coindesk.com/"
            ]
          }
        ],
        "name": "新闻周刊",
        "maintainers": [
          "jameshih"
        ],
        "url": "coindesk.com/",
        "location": "consensus-magazine.ts",
        "module": () => import('@/routes/coindesk/consensus-magazine.ts')
      },
      "/news": {
        "path": "/news",
        "categories": [
          "finance"
        ],
        "example": "/coindesk/news",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "News",
        "maintainers": [
          "pseudoyu"
        ],
        "radar": [
          {
            "source": [
              "coindesk.com/"
            ],
            "target": "/news"
          }
        ],
        "description": "Get latest news from CoinDesk with full text.",
        "location": "news.ts",
        "module": () => import('@/routes/coindesk/news.ts')
      }
    },
    "name": "CoinDesk",
    "apiRoutes": {},
    "url": "coindesk.com",
    "lang": "en",
    "description": "CoinDesk is a news site specializing in bitcoin and digital currencies, delivering news, analysis, and information about the blockchain ecosystem."
  },
  "cointelegraph": {
    "routes": {
      "/": {
        "path": "/",
        "categories": [
          "finance"
        ],
        "example": "/cointelegraph",
        "parameters": {},
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "News",
        "maintainers": [
          "pseudoyu"
        ],
        "radar": [
          {
            "source": [
              "cointelegraph.com/"
            ],
            "target": "/"
          }
        ],
        "description": "Get latest news from Cointelegraph with full text.",
        "location": "index.ts",
        "module": () => import('@/routes/cointelegraph/index.ts')
      }
    },
    "name": "Cointelegraph",
    "apiRoutes": {},
    "url": "cointelegraph.com",
    "lang": "en"
  },
  "colamanga": {
    "routes": {
      "/:id": {
        "path": "/:id",
        "parameters": {
          "id": "漫画id"
        },
        "name": "Manga",
        "maintainers": [
          "machsix"
        ],
        "example": "/colamanga/manga-qq978758",
        "categories": [
          "anime"
        ],
        "radar": [
          {
            "source": [
              "www.colamanga.com/:id/"
            ],
            "target": "/:id"
          }
        ],
        "features": {
          "requireConfig": false,
          "requirePuppeteer": true,
          "antiCrawler": true,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "location": "manga.ts",
        "module": () => import('@/routes/colamanga/manga.ts')
      }
    },
    "name": "COLAMANGA",
    "apiRoutes": {},
    "url": "www.colamanga.com",
    "zh": {
      "name": "可乐漫画"
    },
    "lang": "zh-CN"
  },
  "collabo-cafe": {
    "routes": {
      "/category/:category": {
        "path": "/category/:category",
        "categories": [
          "anime"
        ],
        "example": "/collabo-cafe/category/cafe",
        "parameters": {
          "category": "Category, refer to the original website (ジャンル別)"
        },
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          "supportBT": false,
          "supportPodcast": false,
          "supportScihub": false
        },
        "name": "分类",
        "maintainers": [
          "cokemine"
        ],
        "location": "category.ts",
        "module": () => import('@/routes/collabo-cafe/category.ts')
      },
      "/": {
        "path": "/",
        "categories": [
          "anime"
        ],
        "example": "/collabo-cafe/",
        "features": {
          "requireConfig": false,
          "requirePuppeteer": false,
          "antiCrawler": false,
          