import { CLOSE_BRAKET, OPEN_BRAKET, SLASH } from './char.mjs';
import { appendToNode, attrsToString, attrValue, getNodeLength, getUniqAttr, isTagNode } from './helpers.mjs';
const getTagAttrs = (tag, params)=>{
    const uniqAttr = getUniqAttr(params);
    if (uniqAttr) {
        const tagAttr = attrValue(tag, uniqAttr);
        const attrs = {
            ...params
        };
        delete attrs[String(uniqAttr)];
        const attrsStr = attrsToString(attrs);
        return `${tagAttr}${attrsStr}`;
    }
    return `${tag}${attrsToString(params)}`;
};
const toString = (node, openTag, closeTag)=>{
    if (isTagNode(node)) {
        return node.toString({
            openTag,
            closeTag
        });
    }
    return String(node);
};
const nodeTreeToString = (content, openTag, closeTag)=>{
    if (Array.isArray(content)) {
        return content.reduce((r, node)=>{
            if (node !== null) {
                return r + toString(node, openTag, closeTag);
            }
            return r;
        }, '');
    }
    if (content) {
        return toString(content, openTag, closeTag);
    }
    return null;
};
export class TagNode {
    get length() {
        return getNodeLength(this);
    }
    attr(name, value) {
        if (typeof value !== 'undefined') {
            this.attrs[name] = value;
        }
        return this.attrs[name];
    }
    append(value) {
        return appendToNode(this, value);
    }
    setStart(value) {
        this.start = value;
    }
    setEnd(value) {
        this.end = value;
    }
    toTagStart({ openTag = OPEN_BRAKET, closeTag = CLOSE_BRAKET } = {}) {
        const tagAttrs = getTagAttrs(String(this.tag), this.attrs);
        return `${openTag}${tagAttrs}${closeTag}`;
    }
    toTagEnd({ openTag = OPEN_BRAKET, closeTag = CLOSE_BRAKET } = {}) {
        return `${openTag}${SLASH}${this.tag}${closeTag}`;
    }
    toTagNode() {
        return new TagNode(this.tag, this.attrs, this.content, this.start, this.end);
    }
    toString({ openTag = OPEN_BRAKET, closeTag = CLOSE_BRAKET } = {}) {
        const content = this.content ? nodeTreeToString(this.content, openTag, closeTag) : '';
        const tagStart = this.toTagStart({
            openTag,
            closeTag
        });
        if (this.content === null || Array.isArray(this.content) && this.content.length === 0) {
            return tagStart;
        }
        return `${tagStart}${content}${this.toTagEnd({
            openTag,
            closeTag
        })}`;
    }
    toJSON() {
        return {
            tag: this.tag,
            attrs: this.attrs,
            content: this.content,
            start: this.start,
            end: this.end
        };
    }
    static create(tag, attrs = {}, content = null, start) {
        return new TagNode(tag, attrs, content, start);
    }
    static isOf(node, type) {
        return node.tag === type;
    }
    constructor(tag, attrs, content, start, end){
        this.tag = tag;
        this.attrs = attrs;
        this.content = content;
        this.start = start;
        this.end = end;
    }
}
