"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "TagNode", {
    enumerable: true,
    get: function() {
        return TagNode;
    }
});
var _char = require("./char.js");
var _helpers = require("./helpers.js");
function _defineProperties(target, props) {
    for(var i = 0; i < props.length; i++){
        var descriptor = props[i];
        descriptor.enumerable = descriptor.enumerable || false;
        descriptor.configurable = true;
        if ("value" in descriptor) descriptor.writable = true;
        Object.defineProperty(target, descriptor.key, descriptor);
    }
}
function _create_class(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties(Constructor, staticProps);
    return Constructor;
}
function _extends() {
    _extends = Object.assign || function(target) {
        for(var i = 1; i < arguments.length; i++){
            var source = arguments[i];
            for(var key in source){
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }
        return target;
    };
    return _extends.apply(this, arguments);
}
var getTagAttrs = function(tag, params) {
    var uniqAttr = (0, _helpers.getUniqAttr)(params);
    if (uniqAttr) {
        var tagAttr = (0, _helpers.attrValue)(tag, uniqAttr);
        var attrs = _extends({}, params);
        delete attrs[String(uniqAttr)];
        var attrsStr = (0, _helpers.attrsToString)(attrs);
        return "" + tagAttr + attrsStr;
    }
    return "" + tag + (0, _helpers.attrsToString)(params);
};
var toString = function(node, openTag, closeTag) {
    if ((0, _helpers.isTagNode)(node)) {
        return node.toString({
            openTag: openTag,
            closeTag: closeTag
        });
    }
    return String(node);
};
var nodeTreeToString = function(content, openTag, closeTag) {
    if (Array.isArray(content)) {
        return content.reduce(function(r, node) {
            if (node !== null) {
                return r + toString(node, openTag, closeTag);
            }
            return r;
        }, "");
    }
    if (content) {
        return toString(content, openTag, closeTag);
    }
    return null;
};
var TagNode = /*#__PURE__*/ function() {
    "use strict";
    function TagNode(tag, attrs, content, start, end) {
        this.tag = tag;
        this.attrs = attrs;
        this.content = content;
        this.start = start;
        this.end = end;
    }
    var _proto = TagNode.prototype;
    _proto.attr = function attr(name, value) {
        if (typeof value !== "undefined") {
            this.attrs[name] = value;
        }
        return this.attrs[name];
    };
    _proto.append = function append(value) {
        return (0, _helpers.appendToNode)(this, value);
    };
    _proto.setStart = function setStart(value) {
        this.start = value;
    };
    _proto.setEnd = function setEnd(value) {
        this.end = value;
    };
    _proto.toTagStart = function toTagStart(param) {
        var _ref = param === void 0 ? {} : param, _ref_openTag = _ref.openTag, openTag = _ref_openTag === void 0 ? _char.OPEN_BRAKET : _ref_openTag, _ref_closeTag = _ref.closeTag, closeTag = _ref_closeTag === void 0 ? _char.CLOSE_BRAKET : _ref_closeTag;
        var tagAttrs = getTagAttrs(String(this.tag), this.attrs);
        return "" + openTag + tagAttrs + closeTag;
    };
    _proto.toTagEnd = function toTagEnd(param) {
        var _ref = param === void 0 ? {} : param, _ref_openTag = _ref.openTag, openTag = _ref_openTag === void 0 ? _char.OPEN_BRAKET : _ref_openTag, _ref_closeTag = _ref.closeTag, closeTag = _ref_closeTag === void 0 ? _char.CLOSE_BRAKET : _ref_closeTag;
        return "" + openTag + _char.SLASH + this.tag + closeTag;
    };
    _proto.toTagNode = function toTagNode() {
        return new TagNode(this.tag, this.attrs, this.content, this.start, this.end);
    };
    _proto.toString = function toString(param) {
        var _ref = param === void 0 ? {} : param, _ref_openTag = _ref.openTag, openTag = _ref_openTag === void 0 ? _char.OPEN_BRAKET : _ref_openTag, _ref_closeTag = _ref.closeTag, closeTag = _ref_closeTag === void 0 ? _char.CLOSE_BRAKET : _ref_closeTag;
        var content = this.content ? nodeTreeToString(this.content, openTag, closeTag) : "";
        var tagStart = this.toTagStart({
            openTag: openTag,
            closeTag: closeTag
        });
        if (this.content === null || Array.isArray(this.content) && this.content.length === 0) {
            return tagStart;
        }
        return "" + tagStart + content + this.toTagEnd({
            openTag: openTag,
            closeTag: closeTag
        });
    };
    _proto.toJSON = function toJSON() {
        return {
            tag: this.tag,
            attrs: this.attrs,
            content: this.content,
            start: this.start,
            end: this.end
        };
    };
    TagNode.create = function create(tag, attrs, content, start) {
        if (attrs === void 0) attrs = {};
        if (content === void 0) content = null;
        return new TagNode(tag, attrs, content, start);
    };
    TagNode.isOf = function isOf(node, type) {
        return node.tag === type;
    };
    _create_class(TagNode, [
        {
            key: "length",
            get: function get() {
                return (0, _helpers.getNodeLength)(this);
            }
        }
    ]);
    return TagNode;
}();
