"use strict";
/**
 * index.ts
 *
 * This file is the entry point for the Notion SDK.
 * It exports the Client class and all the API endpoints.
 *
 * @packageDocumentation
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractBlockId = exports.extractPageId = exports.extractDatabaseId = exports.extractNotionId = exports.isFullPageOrDataSource = exports.isFullComment = exports.isFullUser = exports.isFullPage = exports.isFullDatabase = exports.isFullDataSource = exports.isFullBlock = exports.iterateDataSourceTemplates = exports.collectDataSourceTemplates = exports.iteratePaginatedAPI = exports.collectPaginatedAPI = exports.isNotionClientError = exports.InvalidPathParameterError = exports.RequestTimeoutError = exports.UnknownHTTPResponseError = exports.APIResponseError = exports.ClientErrorCode = exports.APIErrorCode = exports.LogLevel = exports.Client = void 0;
var Client_1 = require("./Client");
Object.defineProperty(exports, "Client", { enumerable: true, get: function () { return Client_1.default; } });
var logging_1 = require("./logging");
Object.defineProperty(exports, "LogLevel", { enumerable: true, get: function () { return logging_1.LogLevel; } });
var errors_1 = require("./errors");
Object.defineProperty(exports, "APIErrorCode", { enumerable: true, get: function () { return errors_1.APIErrorCode; } });
Object.defineProperty(exports, "ClientErrorCode", { enumerable: true, get: function () { return errors_1.ClientErrorCode; } });
Object.defineProperty(exports, "APIResponseError", { enumerable: true, get: function () { return errors_1.APIResponseError; } });
Object.defineProperty(exports, "UnknownHTTPResponseError", { enumerable: true, get: function () { return errors_1.UnknownHTTPResponseError; } });
Object.defineProperty(exports, "RequestTimeoutError", { enumerable: true, get: function () { return errors_1.RequestTimeoutError; } });
Object.defineProperty(exports, "InvalidPathParameterError", { enumerable: true, get: function () { return errors_1.InvalidPathParameterError; } });
// Error helpers
Object.defineProperty(exports, "isNotionClientError", { enumerable: true, get: function () { return errors_1.isNotionClientError; } });
var helpers_1 = require("./helpers");
Object.defineProperty(exports, "collectPaginatedAPI", { enumerable: true, get: function () { return helpers_1.collectPaginatedAPI; } });
Object.defineProperty(exports, "iteratePaginatedAPI", { enumerable: true, get: function () { return helpers_1.iteratePaginatedAPI; } });
Object.defineProperty(exports, "collectDataSourceTemplates", { enumerable: true, get: function () { return helpers_1.collectDataSourceTemplates; } });
Object.defineProperty(exports, "iterateDataSourceTemplates", { enumerable: true, get: function () { return helpers_1.iterateDataSourceTemplates; } });
Object.defineProperty(exports, "isFullBlock", { enumerable: true, get: function () { return helpers_1.isFullBlock; } });
Object.defineProperty(exports, "isFullDataSource", { enumerable: true, get: function () { return helpers_1.isFullDataSource; } });
Object.defineProperty(exports, "isFullDatabase", { enumerable: true, get: function () { return helpers_1.isFullDatabase; } });
Object.defineProperty(exports, "isFullPage", { enumerable: true, get: function () { return helpers_1.isFullPage; } });
Object.defineProperty(exports, "isFullUser", { enumerable: true, get: function () { return helpers_1.isFullUser; } });
Object.defineProperty(exports, "isFullComment", { enumerable: true, get: function () { return helpers_1.isFullComment; } });
Object.defineProperty(exports, "isFullPageOrDataSource", { enumerable: true, get: function () { return helpers_1.isFullPageOrDataSource; } });
Object.defineProperty(exports, "extractNotionId", { enumerable: true, get: function () { return helpers_1.extractNotionId; } });
Object.defineProperty(exports, "extractDatabaseId", { enumerable: true, get: function () { return helpers_1.extractDatabaseId; } });
Object.defineProperty(exports, "extractPageId", { enumerable: true, get: function () { return helpers_1.extractPageId; } });
Object.defineProperty(exports, "extractBlockId", { enumerable: true, get: function () { return helpers_1.extractBlockId; } });
//# sourceMappingURL=index.js.map