'use strict';

const themePlain = {
  html: (c) => JSON.stringify(ellipsis(stripHTMLTags(c))),
  name: (c) => JSON.stringify(c),
  platform: (c) => c,
  address: (c) => c,
  network: (c) => JSON.stringify(c),
  number: (c) => c,
  image: () => "",
  symbolImage: () => "",
  assetImage: () => "",
  symbol: (c) => c,
  text: (c) => c,
  time: (c) => `[${c}]`,
  separator: (c) => c,
  unknown: (c) => c
};
function ellipsis(content, max = 50) {
  let result = content;
  if (/\n/.test(content)) {
    result = result.replace(/\n[\s\S]+/g, " ").trim();
  }
  return result.length > max ? `${result.slice(0, max)}...` : result;
}
function stripHTMLTags(s) {
  return s.replace(/<[^>]*>?/gm, "");
}

exports.themePlain = themePlain;
//# sourceMappingURL=theme.cjs.map
//# sourceMappingURL=theme.cjs.map