/**
 * Default maximum size in bytes for GenAI messages.
 * Messages exceeding this limit will be truncated.
 */
export declare const DEFAULT_GEN_AI_MESSAGES_BYTE_LIMIT = 20000;
/**
 * Truncate GenAI messages using the default byte limit.
 *
 * Convenience wrapper around `truncateMessagesByBytes` with the default limit.
 *
 * @param messages - Array of messages to truncate
 * @returns Truncated array of messages
 */
export declare function truncateGenAiMessages(messages: unknown[]): unknown[];
/**
 * Truncate GenAI string input using the default byte limit.
 *
 * @param input - The string to truncate
 * @returns Truncated string
 */
export declare function truncateGenAiStringInput(input: string): string;
//# sourceMappingURL=messageTruncation.d.ts.map