/**
 * Replaces constructor functions in module exports, handling read-only properties,
 * and both default and named exports by wrapping them with the constructor.
 *
 * @param exports The module exports object to modify
 * @param exportName The name of the export to replace (e.g., 'GoogleGenAI', 'Anthropic', 'OpenAI')
 * @param wrappedConstructor The wrapped constructor function to replace the original with
 * @returns void
 */
export declare function replaceExports(exports: {
    [key: string]: unknown;
}, exportName: string, wrappedConstructor: unknown): void;
//# sourceMappingURL=exports.d.ts.map