/**
 * Determines if the current platform is Windows
 * @returns true if running on Windows, false otherwise
 */
export function isWindows() {
    return (process.platform === 'win32' ||
        /^(msys|cygwin)$/.test(process.env.OSTYPE || ''));
}
