import { AST } from "yaml-eslint-parser";
import { IDirective, TextSourceCodeBase, TraversalStep } from "@eslint/plugin-kit";
import * as _eslint_core0 from "@eslint/core";
import { File, FileProblem, Language, OkParseResult, RuleDefinition, RulesConfig } from "@eslint/core";
import { Linter, Scope } from "eslint";

//#region src/meta.d.ts
declare namespace meta_d_exports {
  export { name, version };
}
declare const name: string;
declare const version: string;
//#endregion
//#region src/language/token-store.d.ts
type FilterPredicate = (tokenOrComment: YAMLToken) => boolean;
type CursorWithSkipOptions = number | FilterPredicate | {
  includeComments?: boolean;
  filter?: FilterPredicate;
  skip?: number;
};
type CursorWithCountOptions = number | FilterPredicate | {
  includeComments?: boolean;
  filter?: FilterPredicate;
  count?: number;
};
//#endregion
//#region src/language/yaml-source-code.d.ts
/**
 * YAML-specific syntax element type
 */
type YAMLSyntaxElement = AST.YAMLNode | AST.Token | AST.Comment;
type YAMLToken = AST.Token | AST.Comment;
/**
 * YAML Source Code Object
 */
declare class YAMLSourceCode extends TextSourceCodeBase<{
  LangOptions: Record<never, never>;
  RootNode: AST.YAMLProgram;
  SyntaxElementWithLoc: YAMLSyntaxElement;
  ConfigNode: AST.Comment;
}> {
  #private;
  readonly hasBOM: boolean;
  readonly parserServices: {
    isYAML?: boolean;
    parseError?: unknown;
  };
  readonly visitorKeys: Record<string, string[]>;
  private readonly tokenStore;
  /**
       * Creates a new instance.
       */
  constructor(config: {
    text: string;
    ast: AST.YAMLProgram;
    hasBOM: boolean;
    parserServices: {
      isYAML: boolean;
      parseError?: unknown;
    };
    visitorKeys?: Record<string, string[]> | null | undefined;
  });
  traverse(): Iterable<TraversalStep>;
  /**
       * Gets all tokens and comments.
       */
  get tokensAndComments(): YAMLToken[];
  getLines(): string[];
  getAllComments(): AST.Comment[];
  /**
       * Returns an array of all inline configuration nodes found in the source code.
       * This includes eslint-disable, eslint-enable, eslint-disable-line,
       * eslint-disable-next-line, and eslint (for inline config) comments.
       */
  getInlineConfigNodes(): AST.Comment[];
  /**
       * Returns directives that enable or disable rules along with any problems
       * encountered while parsing the directives.
       */
  getDisableDirectives(): {
    directives: IDirective[];
    problems: FileProblem[];
  };
  /**
       * Returns inline rule configurations along with any problems
       * encountered while parsing the configurations.
       */
  applyInlineConfig(): {
    configs: {
      config: {
        rules: RulesConfig;
      };
      loc: AST.SourceLocation;
    }[];
    problems: FileProblem[];
  };
  getNodeByRangeIndex(index: number): AST.YAMLNode | null;
  getFirstToken(node: YAMLSyntaxElement): AST.Token;
  getFirstToken(node: YAMLSyntaxElement, options?: CursorWithSkipOptions): YAMLToken | null;
  getLastToken(node: YAMLSyntaxElement): AST.Token;
  getLastToken(node: YAMLSyntaxElement, options?: CursorWithSkipOptions): YAMLToken | null;
  getTokenBefore(node: YAMLSyntaxElement): AST.Token | null;
  getTokenBefore(node: YAMLSyntaxElement, options?: CursorWithSkipOptions): YAMLToken | null;
  getTokensBefore(node: YAMLSyntaxElement, options?: CursorWithCountOptions): YAMLToken[];
  getTokenAfter(node: YAMLSyntaxElement): AST.Token | null;
  getTokenAfter(node: YAMLSyntaxElement, options?: CursorWithSkipOptions): YAMLToken | null;
  getFirstTokenBetween(left: YAMLSyntaxElement, right: YAMLSyntaxElement, options?: CursorWithSkipOptions): YAMLToken | null;
  getTokensBetween(left: YAMLSyntaxElement, right: YAMLSyntaxElement, paddingOrOptions?: number | FilterPredicate | CursorWithCountOptions): YAMLToken[];
  getTokens(node: AST.YAMLNode, options?: FilterPredicate | CursorWithCountOptions): YAMLToken[];
  getCommentsBefore(nodeOrToken: YAMLSyntaxElement): AST.Comment[];
  getCommentsAfter(nodeOrToken: YAMLSyntaxElement): AST.Comment[];
  isSpaceBetween(first: YAMLToken, second: YAMLToken): boolean;
  /**
       * Compatibility for ESLint's SourceCode API
       * @deprecated YAML does not have scopes
       */
  getScope(node?: AST.YAMLNode): Scope.Scope | null;
  /**
       * Compatibility for ESLint's SourceCode API
       * @deprecated YAML does not have scopes
       */
  get scopeManager(): Scope.ScopeManager | null;
  /**
       * Compatibility for ESLint's SourceCode API
       * @deprecated
       */
  isSpaceBetweenTokens(first: YAMLToken, second: YAMLToken): boolean;
  private _getChildren;
}
//#endregion
//#region src/language/yaml-language.d.ts
/**
 * Parse result
 */
interface YAMLParseResult {
  ok: true;
  ast: AST.YAMLProgram;
}
/**
 * Language options for YAML
 */
type YAMLLanguageOptions = {
  parserOptions?: {
    defaultYAMLVersion?: "1.1" | "1.2";
  };
};
/**
 * The YAML language implementation for ESLint.
 */
declare class YAMLLanguage implements Language<{
  LangOptions: YAMLLanguageOptions;
  Code: YAMLSourceCode;
  RootNode: AST.YAMLProgram;
  Node: AST.YAMLNode;
}> {
  /**
       * The type of file to read.
       */
  fileType: "text";
  /**
       * The line number at which the parser starts counting.
       */
  lineStart: 1;
  /**
       * The column number at which the parser starts counting.
       */
  columnStart: 0;
  /**
       * The name of the key that holds the type of the node.
       */
  nodeTypeKey: "type";
  /**
       * Validates the language options.
       */
  validateLanguageOptions(_languageOptions: YAMLLanguageOptions): void;
  normalizeLanguageOptions(languageOptions: YAMLLanguageOptions): YAMLLanguageOptions;
  /**
       * Parses the given file into an AST.
       */
  parse(file: File, context: {
    languageOptions?: YAMLLanguageOptions;
  }): OkParseResult<AST.YAMLProgram> | YAMLParseResult;
  /**
       * Creates a new SourceCode object for the given file and parse result.
       */
  createSourceCode(file: File, parseResult: OkParseResult<AST.YAMLProgram> | YAMLParseResult): YAMLSourceCode;
}
//#endregion
//#region src/index.d.ts
declare const configs: {
  base: Linter.Config[];
  recommended: Linter.Config[];
  standard: Linter.Config[];
  prettier: Linter.Config[];
  "flat/base": Linter.Config[];
  "flat/recommended": Linter.Config[];
  "flat/standard": Linter.Config[];
  "flat/prettier": Linter.Config[];
};
declare const rules: Record<string, RuleDefinition>;
declare const languages: {
  yaml: YAMLLanguage;
};
declare const _default: {
  meta: typeof meta_d_exports;
  configs: {
    base: Linter.Config[];
    recommended: Linter.Config[];
    standard: Linter.Config[];
    prettier: Linter.Config[];
    "flat/base": Linter.Config[];
    "flat/recommended": Linter.Config[];
    "flat/standard": Linter.Config[];
    "flat/prettier": Linter.Config[];
  };
  rules: Record<string, RuleDefinition<_eslint_core0.RuleDefinitionTypeOptions>>;
  languages: {
    yaml: YAMLLanguage;
  };
};
//#endregion
export { type YAMLLanguageOptions, type YAMLSourceCode, configs, _default as default, languages, meta_d_exports as meta, rules };