import { OAuth2Client, JWT, Compute, UserRefreshClient, BaseExternalAccountClient, GaxiosResponseWithHTTP2, GoogleConfigurable, MethodOptions, StreamMethodOptions, GlobalOptions, GoogleAuth, BodyResponseCallback, APIRequestContext } from 'googleapis-common';
import { Readable } from 'stream';
export declare namespace contactcenterinsights_v1 {
    export interface Options extends GlobalOptions {
        version: 'v1';
    }
    interface StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient | BaseExternalAccountClient | GoogleAuth;
        /**
         * V1 error format.
         */
        '$.xgafv'?: string;
        /**
         * OAuth access token.
         */
        access_token?: string;
        /**
         * Data format for response.
         */
        alt?: string;
        /**
         * JSONP
         */
        callback?: string;
        /**
         * Selector specifying which fields to include in a partial response.
         */
        fields?: string;
        /**
         * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
         */
        key?: string;
        /**
         * OAuth 2.0 token for the current user.
         */
        oauth_token?: string;
        /**
         * Returns response with indentations and line breaks.
         */
        prettyPrint?: boolean;
        /**
         * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
         */
        quotaUser?: string;
        /**
         * Legacy upload protocol for media (e.g. "media", "multipart").
         */
        uploadType?: string;
        /**
         * Upload protocol for media (e.g. "raw", "multipart").
         */
        upload_protocol?: string;
    }
    /**
     * Contact Center AI Insights API
     *
     *
     *
     * @example
     * ```js
     * const {google} = require('googleapis');
     * const contactcenterinsights = google.contactcenterinsights('v1');
     * ```
     */
    export class Contactcenterinsights {
        context: APIRequestContext;
        projects: Resource$Projects;
        constructor(options: GlobalOptions, google?: GoogleConfigurable);
    }
    /**
     * The analysis resource.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1Analysis {
        /**
         * Output only. The result of the analysis, which is populated when the analysis finishes.
         */
        analysisResult?: Schema$GoogleCloudContactcenterinsightsV1alpha1AnalysisResult;
        /**
         * To select the annotators to run and the phrase matchers to use (if any). If not specified, all annotators will be run.
         */
        annotatorSelector?: Schema$GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelector;
        /**
         * Output only. The time at which the analysis was created, which occurs when the long-running operation completes.
         */
        createTime?: string | null;
        /**
         * Immutable. The resource name of the analysis. Format: projects/{project\}/locations/{location\}/conversations/{conversation\}/analyses/{analysis\}
         */
        name?: string | null;
        /**
         * Output only. The time at which the analysis was requested.
         */
        requestTime?: string | null;
    }
    /**
     * The result of an analysis.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1AnalysisResult {
        /**
         * Call-specific metadata created by the analysis.
         */
        callAnalysisMetadata?: Schema$GoogleCloudContactcenterinsightsV1alpha1AnalysisResultCallAnalysisMetadata;
        /**
         * The time at which the analysis ended.
         */
        endTime?: string | null;
    }
    /**
     * Call-specific metadata created during analysis.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1AnalysisResultCallAnalysisMetadata {
        /**
         * A list of call annotations that apply to this call.
         */
        annotations?: Schema$GoogleCloudContactcenterinsightsV1alpha1CallAnnotation[];
        /**
         * All the entities in the call.
         */
        entities?: {
            [key: string]: Schema$GoogleCloudContactcenterinsightsV1alpha1Entity;
        } | null;
        /**
         * All the matched intents in the call.
         */
        intents?: {
            [key: string]: Schema$GoogleCloudContactcenterinsightsV1alpha1Intent;
        } | null;
        /**
         * Overall conversation-level issue modeling result.
         */
        issueModelResult?: Schema$GoogleCloudContactcenterinsightsV1alpha1IssueModelResult;
        /**
         * All the matched phrase matchers in the call.
         */
        phraseMatchers?: {
            [key: string]: Schema$GoogleCloudContactcenterinsightsV1alpha1PhraseMatchData;
        } | null;
        /**
         * Results of scoring QaScorecards.
         */
        qaScorecardResults?: Schema$GoogleCloudContactcenterinsightsV1alpha1QaScorecardResult[];
        /**
         * Overall conversation-level sentiment for each channel of the call.
         */
        sentiments?: Schema$GoogleCloudContactcenterinsightsV1alpha1ConversationLevelSentiment[];
        /**
         * Overall conversation-level silence during the call.
         */
        silence?: Schema$GoogleCloudContactcenterinsightsV1alpha1ConversationLevelSilence;
    }
    /**
     * A point in a conversation that marks the start or the end of an annotation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1AnnotationBoundary {
        /**
         * The index in the sequence of transcribed pieces of the conversation where the boundary is located. This index starts at zero.
         */
        transcriptIndex?: number | null;
        /**
         * The word index of this boundary with respect to the first word in the transcript piece. This index starts at zero.
         */
        wordIndex?: number | null;
    }
    /**
     * Selector of all available annotators and phrase matchers to run.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelector {
        /**
         * The issue model to run. If not provided, the most recently deployed topic model will be used. The provided issue model will only be used for inference if the issue model is deployed and if run_issue_model_annotator is set to true. If more than one issue model is provided, only the first provided issue model will be used for inference.
         */
        issueModels?: string[] | null;
        /**
         * The list of phrase matchers to run. If not provided, all active phrase matchers will be used. If inactive phrase matchers are provided, they will not be used. Phrase matchers will be run only if run_phrase_matcher_annotator is set to true. Format: projects/{project\}/locations/{location\}/phraseMatchers/{phrase_matcher\}
         */
        phraseMatchers?: string[] | null;
        /**
         * Configuration for the QA annotator.
         */
        qaConfig?: Schema$GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelectorQaConfig;
        /**
         * Whether to run the entity annotator.
         */
        runEntityAnnotator?: boolean | null;
        /**
         * Whether to run the intent annotator.
         */
        runIntentAnnotator?: boolean | null;
        /**
         * Whether to run the interruption annotator.
         */
        runInterruptionAnnotator?: boolean | null;
        /**
         * Whether to run the issue model annotator. A model should have already been deployed for this to take effect.
         */
        runIssueModelAnnotator?: boolean | null;
        /**
         * Whether to run the active phrase matcher annotator(s).
         */
        runPhraseMatcherAnnotator?: boolean | null;
        /**
         * Whether to run the QA annotator.
         */
        runQaAnnotator?: boolean | null;
        /**
         * Whether to run the sentiment annotator.
         */
        runSentimentAnnotator?: boolean | null;
        /**
         * Whether to run the silence annotator.
         */
        runSilenceAnnotator?: boolean | null;
        /**
         * Whether to run the summarization annotator.
         */
        runSummarizationAnnotator?: boolean | null;
        /**
         * Configuration for the summarization annotator.
         */
        summarizationConfig?: Schema$GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelectorSummarizationConfig;
    }
    /**
     * Configuration for the QA feature.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelectorQaConfig {
        /**
         * A manual list of scorecards to score.
         */
        scorecardList?: Schema$GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelectorQaConfigScorecardList;
    }
    /**
     * Container for a list of scorecards.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelectorQaConfigScorecardList {
        /**
         * List of QaScorecardRevisions.
         */
        qaScorecardRevisions?: string[] | null;
    }
    /**
     * Configuration for summarization.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelectorSummarizationConfig {
        /**
         * Resource name of the Dialogflow conversation profile. Format: projects/{project\}/locations/{location\}/conversationProfiles/{conversation_profile\}
         */
        conversationProfile?: string | null;
        /**
         * The resource name of the existing created generator. Format: projects//locations//generators/
         */
        generator?: string | null;
        /**
         * Default summarization model to be used.
         */
        summarizationModel?: string | null;
    }
    /**
     * The feedback that the customer has about a certain answer in the conversation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1AnswerFeedback {
        /**
         * Indicates whether an answer or item was clicked by the human agent.
         */
        clicked?: boolean | null;
        /**
         * The correctness level of an answer.
         */
        correctnessLevel?: string | null;
        /**
         * Indicates whether an answer or item was displayed to the human agent in the agent desktop UI.
         */
        displayed?: boolean | null;
    }
    /**
     * Agent Assist Article Suggestion data.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1ArticleSuggestionData {
        /**
         * The system's confidence score that this article is a good match for this conversation, ranging from 0.0 (completely uncertain) to 1.0 (completely certain).
         */
        confidenceScore?: number | null;
        /**
         * Map that contains metadata about the Article Suggestion and the document that it originates from.
         */
        metadata?: {
            [key: string]: string;
        } | null;
        /**
         * The name of the answer record. Format: projects/{project\}/locations/{location\}/answerRecords/{answer_record\}
         */
        queryRecord?: string | null;
        /**
         * The knowledge document that this answer was extracted from. Format: projects/{project\}/knowledgeBases/{knowledge_base\}/documents/{document\}
         */
        source?: string | null;
        /**
         * Article title.
         */
        title?: string | null;
        /**
         * Article URI.
         */
        uri?: string | null;
    }
    /**
     * The metadata for a bulk analyze conversations operation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1BulkAnalyzeConversationsMetadata {
        /**
         * The number of requested analyses that have completed successfully so far.
         */
        completedAnalysesCount?: number | null;
        /**
         * The time the operation was created.
         */
        createTime?: string | null;
        /**
         * The time the operation finished running.
         */
        endTime?: string | null;
        /**
         * The number of requested analyses that have failed so far.
         */
        failedAnalysesCount?: number | null;
        /**
         * Output only. Partial errors during bulk analyze operation that might cause the operation output to be incomplete.
         */
        partialErrors?: Schema$GoogleRpcStatus[];
        /**
         * The original request for bulk analyze.
         */
        request?: Schema$GoogleCloudContactcenterinsightsV1alpha1BulkAnalyzeConversationsRequest;
        /**
         * Total number of analyses requested. Computed by the number of conversations returned by `filter` multiplied by `analysis_percentage` in the request.
         */
        totalRequestedAnalysesCount?: number | null;
    }
    /**
     * The request to analyze conversations in bulk.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1BulkAnalyzeConversationsRequest {
        /**
         * Required. Percentage of selected conversation to analyze, between [0, 100].
         */
        analysisPercentage?: number | null;
        /**
         * To select the annotators to run and the phrase matchers to use (if any). If not specified, all annotators will be run.
         */
        annotatorSelector?: Schema$GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelector;
        /**
         * Required. Filter used to select the subset of conversations to analyze.
         */
        filter?: string | null;
        /**
         * Required. The parent resource to create analyses in.
         */
        parent?: string | null;
    }
    /**
     * The response for a bulk analyze conversations operation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1BulkAnalyzeConversationsResponse {
        /**
         * Count of failed analyses.
         */
        failedAnalysisCount?: number | null;
        /**
         * Count of successful analyses.
         */
        successfulAnalysisCount?: number | null;
    }
    /**
     * The metadata for a bulk delete conversations operation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1BulkDeleteConversationsMetadata {
        /**
         * The time the operation was created.
         */
        createTime?: string | null;
        /**
         * The time the operation finished running.
         */
        endTime?: string | null;
        /**
         * Partial errors during bulk delete conversations operation that might cause the operation output to be incomplete.
         */
        partialErrors?: Schema$GoogleRpcStatus[];
        /**
         * The original request for bulk delete.
         */
        request?: Schema$GoogleCloudContactcenterinsightsV1alpha1BulkDeleteConversationsRequest;
    }
    /**
     * The request to delete conversations in bulk.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1BulkDeleteConversationsRequest {
        /**
         * Filter used to select the subset of conversations to delete.
         */
        filter?: string | null;
        /**
         * If set to true, all of this conversation's analyses will also be deleted. Otherwise, the request will only succeed if the conversation has no analyses.
         */
        force?: boolean | null;
        /**
         * Maximum number of conversations to delete.
         */
        maxDeleteCount?: number | null;
        /**
         * Required. The parent resource to delete conversations from. Format: projects/{project\}/locations/{location\}
         */
        parent?: string | null;
    }
    /**
     * The response for a bulk delete conversations operation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1BulkDeleteConversationsResponse {
    }
    /**
     * Metadata for the BulkDeleteFeedbackLabels endpoint.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1BulkDeleteFeedbackLabelsMetadata {
        /**
         * Partial errors during deletion operation that might cause the operation output to be incomplete.
         */
        partialErrors?: Schema$GoogleRpcStatus[];
        /**
         * Output only. The original request for delete.
         */
        request?: Schema$GoogleCloudContactcenterinsightsV1alpha1BulkDeleteFeedbackLabelsRequest;
    }
    /**
     * Request for the BulkDeleteFeedbackLabels endpoint.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1BulkDeleteFeedbackLabelsRequest {
        /**
         * Optional. A filter to reduce results to a specific subset. Supports disjunctions (OR) and conjunctions (AND). Supported fields: * `issue_model_id` * `qa_question_id` * `qa_scorecard_id` * `min_create_time` * `max_create_time` * `min_update_time` * `max_update_time` * `feedback_label_type`: QUALITY_AI, TOPIC_MODELING
         */
        filter?: string | null;
        /**
         * Required. The parent resource for new feedback labels.
         */
        parent?: string | null;
    }
    /**
     * Response for the BulkDeleteFeedbackLabels endpoint.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1BulkDeleteFeedbackLabelsResponse {
    }
    /**
     * A piece of metadata that applies to a window of a call.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1CallAnnotation {
        /**
         * The boundary in the conversation where the annotation ends, inclusive.
         */
        annotationEndBoundary?: Schema$GoogleCloudContactcenterinsightsV1alpha1AnnotationBoundary;
        /**
         * The boundary in the conversation where the annotation starts, inclusive.
         */
        annotationStartBoundary?: Schema$GoogleCloudContactcenterinsightsV1alpha1AnnotationBoundary;
        /**
         * The channel of the audio where the annotation occurs. For single-channel audio, this field is not populated.
         */
        channelTag?: number | null;
        /**
         * Data specifying an entity mention.
         */
        entityMentionData?: Schema$GoogleCloudContactcenterinsightsV1alpha1EntityMentionData;
        /**
         * Data specifying a hold.
         */
        holdData?: Schema$GoogleCloudContactcenterinsightsV1alpha1HoldData;
        /**
         * Data specifying an intent match.
         */
        intentMatchData?: Schema$GoogleCloudContactcenterinsightsV1alpha1IntentMatchData;
        /**
         * Data specifying an interruption.
         */
        interruptionData?: Schema$GoogleCloudContactcenterinsightsV1alpha1InterruptionData;
        /**
         * Data specifying an issue match.
         */
        issueMatchData?: Schema$GoogleCloudContactcenterinsightsV1alpha1IssueMatchData;
        /**
         * Data specifying a phrase match.
         */
        phraseMatchData?: Schema$GoogleCloudContactcenterinsightsV1alpha1PhraseMatchData;
        /**
         * Data specifying sentiment.
         */
        sentimentData?: Schema$GoogleCloudContactcenterinsightsV1alpha1SentimentData;
        /**
         * Data specifying silence.
         */
        silenceData?: Schema$GoogleCloudContactcenterinsightsV1alpha1SilenceData;
    }
    /**
     * The result of testing a constraint expression on a pair of conversations.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1ConstraintEvaluationResult {
        /**
         * The first conversation resource name.
         */
        conversationA?: string | null;
        /**
         * The second conversation resource name.
         */
        conversationB?: string | null;
        /**
         * The results for each applicable constraint rule.
         */
        ruleConstraintResults?: Schema$GoogleCloudContactcenterinsightsV1alpha1ConstraintEvaluationResultRuleConstraintResult[];
    }
    /**
     * The result of a single constraint rule on the pair of conversations.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1ConstraintEvaluationResultRuleConstraintResult {
        /**
         * Whether the constraint expression evaluated to true for (A, B) or (B, A).
         */
        constraintMet?: boolean | null;
        /**
         * The error status if the constraint expression failed to evaluate.
         */
        error?: Schema$GoogleRpcStatus;
        /**
         * The rule ID.
         */
        ruleId?: string | null;
    }
    /**
     * The conversation resource.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1Conversation {
        /**
         * An opaque, user-specified string representing the human agent who handled the conversation.
         */
        agentId?: string | null;
        /**
         * Call-specific metadata.
         */
        callMetadata?: Schema$GoogleCloudContactcenterinsightsV1alpha1ConversationCallMetadata;
        /**
         * Output only. Info for correlating across conversations.
         */
        correlationInfo?: Schema$GoogleCloudContactcenterinsightsV1alpha1ConversationCorrelationInfo;
        /**
         * Output only. The time at which the conversation was created.
         */
        createTime?: string | null;
        /**
         * The source of the audio and transcription for the conversation.
         */
        dataSource?: Schema$GoogleCloudContactcenterinsightsV1alpha1ConversationDataSource;
        /**
         * Output only. All the matched Dialogflow intents in the call. The key corresponds to a Dialogflow intent, format: projects/{project\}/agent/{agent\}/intents/{intent\}
         */
        dialogflowIntents?: {
            [key: string]: Schema$GoogleCloudContactcenterinsightsV1alpha1DialogflowIntent;
        } | null;
        /**
         * Output only. The duration of the conversation.
         */
        duration?: string | null;
        /**
         * The time at which this conversation should expire. After this time, the conversation data and any associated analyses will be deleted.
         */
        expireTime?: string | null;
        /**
         * A map for the user to specify any custom fields. A maximum of 100 labels per conversation is allowed, with a maximum of 256 characters per entry.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * A user-specified language code for the conversation.
         */
        languageCode?: string | null;
        /**
         * Output only. The conversation's latest analysis, if one exists.
         */
        latestAnalysis?: Schema$GoogleCloudContactcenterinsightsV1alpha1Analysis;
        /**
         * Output only. Latest summary of the conversation.
         */
        latestSummary?: Schema$GoogleCloudContactcenterinsightsV1alpha1ConversationSummarizationSuggestionData;
        /**
         * Immutable. The conversation medium.
         */
        medium?: string | null;
        /**
         * Input only. JSON metadata encoded as a string. This field is primarily used by Insights integrations with various telephony systems and must be in one of Insight's supported formats.
         */
        metadataJson?: string | null;
        /**
         * Immutable. The resource name of the conversation. Format: projects/{project\}/locations/{location\}/conversations/{conversation\}
         */
        name?: string | null;
        /**
         * Obfuscated user ID which the customer sent to us.
         */
        obfuscatedUserId?: string | null;
        /**
         * Conversation metadata related to quality management.
         */
        qualityMetadata?: Schema$GoogleCloudContactcenterinsightsV1alpha1ConversationQualityMetadata;
        /**
         * Output only. The annotations that were generated during the customer and agent interaction.
         */
        runtimeAnnotations?: Schema$GoogleCloudContactcenterinsightsV1alpha1RuntimeAnnotation[];
        /**
         * The time at which the conversation started.
         */
        startTime?: string | null;
        /**
         * Output only. The conversation transcript.
         */
        transcript?: Schema$GoogleCloudContactcenterinsightsV1alpha1ConversationTranscript;
        /**
         * Input only. The TTL for this resource. If specified, then this TTL will be used to calculate the expire time.
         */
        ttl?: string | null;
        /**
         * Output only. The number of turns in the conversation.
         */
        turnCount?: number | null;
        /**
         * Output only. The most recent time at which the conversation was updated.
         */
        updateTime?: string | null;
    }
    /**
     * Call-specific metadata.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1ConversationCallMetadata {
        /**
         * The audio channel that contains the agent.
         */
        agentChannel?: number | null;
        /**
         * The audio channel that contains the customer.
         */
        customerChannel?: number | null;
    }
    /**
     * Info for correlating across conversations.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1ConversationCorrelationInfo {
        /**
         * Output only. The correlation types of this conversation. A single conversation can have multiple correlation types. For example a conversation that only has a single segment is both a SEGMENT and a FULL_CONVERSATION.
         */
        correlationTypes?: string[] | null;
        /**
         * Output only. The full conversation correlation id this conversation is a segment of.
         */
        fullConversationCorrelationId?: string | null;
        /**
         * Output only. The full conversation correlation id this conversation is a merged conversation of.
         */
        mergedFullConversationCorrelationId?: string | null;
    }
    /**
     * The result of testing correlation config on a single conversation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1ConversationCorrelationResult {
        /**
         * The conversation resource name.
         */
        conversation?: string | null;
        /**
         * The results for each correlation rule.
         */
        ruleResults?: Schema$GoogleCloudContactcenterinsightsV1alpha1ConversationCorrelationResultRuleCorrelationResult[];
    }
    /**
     * The result of a single correlation rule.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1ConversationCorrelationResultRuleCorrelationResult {
        /**
         * The correlation ID generated by the join key expression.
         */
        correlationId?: string | null;
        /**
         * The error status if the join key expression failed to evaluate.
         */
        error?: Schema$GoogleRpcStatus;
        /**
         * The rule ID.
         */
        ruleId?: string | null;
    }
    /**
     * The conversation source, which is a combination of transcript and audio.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1ConversationDataSource {
        /**
         * The source when the conversation comes from Dialogflow.
         */
        dialogflowSource?: Schema$GoogleCloudContactcenterinsightsV1alpha1DialogflowSource;
        /**
         * A Cloud Storage location specification for the audio and transcript.
         */
        gcsSource?: Schema$GoogleCloudContactcenterinsightsV1alpha1GcsSource;
        /**
         * Cloud Storage URI that points to a file that contains the conversation metadata.
         */
        metadataUri?: string | null;
    }
    /**
     * One channel of conversation-level sentiment data.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1ConversationLevelSentiment {
        /**
         * The channel of the audio that the data applies to.
         */
        channelTag?: number | null;
        /**
         * Data specifying sentiment.
         */
        sentimentData?: Schema$GoogleCloudContactcenterinsightsV1alpha1SentimentData;
    }
    /**
     * Conversation-level silence data.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1ConversationLevelSilence {
        /**
         * Amount of time calculated to be in silence.
         */
        silenceDuration?: string | null;
        /**
         * Percentage of the total conversation spent in silence.
         */
        silencePercentage?: number | null;
    }
    /**
     * The call participant speaking for a given utterance.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1ConversationParticipant {
        /**
         * Deprecated. Use `dialogflow_participant_name` instead. The name of the Dialogflow participant. Format: projects/{project\}/locations/{location\}/conversations/{conversation\}/participants/{participant\}
         */
        dialogflowParticipant?: string | null;
        /**
         * The name of the participant provided by Dialogflow. Format: projects/{project\}/locations/{location\}/conversations/{conversation\}/participants/{participant\}
         */
        dialogflowParticipantName?: string | null;
        /**
         * Obfuscated user ID from Dialogflow.
         */
        obfuscatedExternalUserId?: string | null;
        /**
         * The role of the participant.
         */
        role?: string | null;
        /**
         * A user-specified ID representing the participant.
         */
        userId?: string | null;
    }
    /**
     * Conversation metadata related to quality management.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1ConversationQualityMetadata {
        /**
         * Information about agents involved in the call.
         */
        agentInfo?: Schema$GoogleCloudContactcenterinsightsV1alpha1ConversationQualityMetadataAgentInfo[];
        /**
         * An arbitrary integer value indicating the customer's satisfaction rating.
         */
        customerSatisfactionRating?: number | null;
        /**
         * Input only. The feedback labels associated with the conversation.
         */
        feedbackLabels?: Schema$GoogleCloudContactcenterinsightsV1alpha1FeedbackLabel[];
        /**
         * An arbitrary string value specifying the menu path the customer took.
         */
        menuPath?: string | null;
        /**
         * The amount of time the customer waited to connect with an agent.
         */
        waitDuration?: string | null;
    }
    /**
     * Information about an agent involved in the conversation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1ConversationQualityMetadataAgentInfo {
        /**
         * A user-specified string representing the agent.
         */
        agentId?: string | null;
        /**
         * The agent type, e.g. HUMAN_AGENT.
         */
        agentType?: string | null;
        /**
         * The agent's deployment display name. Only applicable to automated agents.
         */
        deploymentDisplayName?: string | null;
        /**
         * The agent's deployment ID. Only applicable to automated agents.
         */
        deploymentId?: string | null;
        /**
         * The agent's name.
         */
        displayName?: string | null;
        /**
         * A user-provided string indicating the outcome of the agent's segment of the call.
         */
        dispositionCode?: string | null;
        /**
         * The agent's location.
         */
        location?: string | null;
        /**
         * A user-specified string representing the agent's team. Deprecated in favor of the `teams` field.
         */
        team?: string | null;
        /**
         * User-specified strings representing the agent's teams.
         */
        teams?: string[] | null;
        /**
         * The agent's version display name. Only applicable to automated agents.
         */
        versionDisplayName?: string | null;
        /**
         * The agent's version ID. Only applicable to automated agents.
         */
        versionId?: string | null;
    }
    /**
     * Conversation summarization suggestion data.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1ConversationSummarizationSuggestionData {
        /**
         * The name of the answer record. Format: projects/{project\}/locations/{location\}/answerRecords/{answer_record\}
         */
        answerRecord?: string | null;
        /**
         * The confidence score of the summarization.
         */
        confidence?: number | null;
        /**
         * The name of the model that generates this summary. Format: projects/{project\}/locations/{location\}/conversationModels/{conversation_model\}
         */
        conversationModel?: string | null;
        /**
         * Agent Assist generator ID.
         */
        generatorId?: string | null;
        /**
         * A map that contains metadata about the summarization and the document from which it originates.
         */
        metadata?: {
            [key: string]: string;
        } | null;
        /**
         * The summarization content that is concatenated into one string.
         */
        text?: string | null;
        /**
         * The summarization content that is divided into sections. The key is the section's name and the value is the section's content. There is no specific format for the key or value.
         */
        textSections?: {
            [key: string]: string;
        } | null;
    }
    /**
     * A message representing the transcript of a conversation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1ConversationTranscript {
        /**
         * A list of sequential transcript segments that comprise the conversation.
         */
        transcriptSegments?: Schema$GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegment[];
    }
    /**
     * A segment of a full transcript.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegment {
        /**
         * For conversations derived from multi-channel audio, this is the channel number corresponding to the audio from that channel. For audioChannelCount = N, its output values can range from '1' to 'N'. A channel tag of 0 indicates that the audio is mono.
         */
        channelTag?: number | null;
        /**
         * A confidence estimate between 0.0 and 1.0 of the fidelity of this segment. A default value of 0.0 indicates that the value is unset.
         */
        confidence?: number | null;
        /**
         * CCAI metadata relating to the current transcript segment.
         */
        dialogflowSegmentMetadata?: Schema$GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegmentDialogflowSegmentMetadata;
        /**
         * The language code of this segment as a [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag. Example: "en-US".
         */
        languageCode?: string | null;
        /**
         * The time that the message occurred, if provided.
         */
        messageTime?: string | null;
        /**
         * The participant of this segment.
         */
        segmentParticipant?: Schema$GoogleCloudContactcenterinsightsV1alpha1ConversationParticipant;
        /**
         * The sentiment for this transcript segment.
         */
        sentiment?: Schema$GoogleCloudContactcenterinsightsV1alpha1SentimentData;
        /**
         * The text of this segment.
         */
        text?: string | null;
        /**
         * A list of the word-specific information for each word in the segment.
         */
        words?: Schema$GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegmentWordInfo[];
    }
    /**
     * Metadata from Dialogflow relating to the current transcript segment.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegmentDialogflowSegmentMetadata {
        /**
         * Whether the transcript segment was covered under the configured smart reply allowlist in Agent Assist.
         */
        smartReplyAllowlistCovered?: boolean | null;
    }
    /**
     * Word-level info for words in a transcript.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1ConversationTranscriptTranscriptSegmentWordInfo {
        /**
         * A confidence estimate between 0.0 and 1.0 of the fidelity of this word. A default value of 0.0 indicates that the value is unset.
         */
        confidence?: number | null;
        /**
         * Time offset of the end of this word relative to the beginning of the total conversation.
         */
        endOffset?: string | null;
        /**
         * Time offset of the start of this word relative to the beginning of the total conversation.
         */
        startOffset?: string | null;
        /**
         * The word itself. Includes punctuation marks that surround the word.
         */
        word?: string | null;
    }
    /**
     * Metadata for a create analysis operation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1CreateAnalysisOperationMetadata {
        /**
         * Output only. The annotator selector used for the analysis (if any).
         */
        annotatorSelector?: Schema$GoogleCloudContactcenterinsightsV1alpha1AnnotatorSelector;
        /**
         * Output only. The Conversation that this Analysis Operation belongs to.
         */
        conversation?: string | null;
        /**
         * Output only. The time the operation was created.
         */
        createTime?: string | null;
        /**
         * Output only. The time the operation finished running.
         */
        endTime?: string | null;
    }
    /**
     * Metadata for creating an issue.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1CreateIssueMetadata {
        /**
         * Output only. The time the operation was created.
         */
        createTime?: string | null;
        /**
         * Output only. The time the operation finished running.
         */
        endTime?: string | null;
        /**
         * The original request for creation.
         */
        request?: Schema$GoogleCloudContactcenterinsightsV1alpha1CreateIssueRequest;
    }
    /**
     * Metadata for creating an issue model.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1CreateIssueModelMetadata {
        /**
         * Output only. The time the operation was created.
         */
        createTime?: string | null;
        /**
         * Output only. The time the operation finished running.
         */
        endTime?: string | null;
        /**
         * The original request for creation.
         */
        request?: Schema$GoogleCloudContactcenterinsightsV1alpha1CreateIssueModelRequest;
    }
    /**
     * The request to create an issue model.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1CreateIssueModelRequest {
        /**
         * Required. The issue model to create.
         */
        issueModel?: Schema$GoogleCloudContactcenterinsightsV1alpha1IssueModel;
        /**
         * Required. The parent resource of the issue model.
         */
        parent?: string | null;
    }
    /**
     * The request to create an issue.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1CreateIssueRequest {
        /**
         * Required. The values for the new issue.
         */
        issue?: Schema$GoogleCloudContactcenterinsightsV1alpha1Issue;
        /**
         * Required. The parent resource of the issue.
         */
        parent?: string | null;
    }
    /**
     * Dataset resource represents a collection of conversations that may be bounded (Static Dataset, e.g. golden dataset for training), or unbounded (Dynamic Dataset, e.g. live traffic, or agent training traffic)
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1Dataset {
        /**
         * Output only. Dataset create time.
         */
        createTime?: string | null;
        /**
         * Dataset description.
         */
        description?: string | null;
        /**
         * Display name for the dataaset
         */
        displayName?: string | null;
        /**
         * Immutable. Identifier. Resource name of the dataset. Format: projects/{project\}/locations/{location\}/datasets/{dataset\}
         */
        name?: string | null;
        /**
         * Optional. Option TTL for the dataset.
         */
        ttl?: string | null;
        /**
         * Dataset usage type.
         */
        type?: string | null;
        /**
         * Output only. Dataset update time.
         */
        updateTime?: string | null;
    }
    /**
     * Metadata for deleting an issue model.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1DeleteIssueModelMetadata {
        /**
         * Output only. The time the operation was created.
         */
        createTime?: string | null;
        /**
         * Output only. The time the operation finished running.
         */
        endTime?: string | null;
        /**
         * The original request for deletion.
         */
        request?: Schema$GoogleCloudContactcenterinsightsV1alpha1DeleteIssueModelRequest;
    }
    /**
     * The request to delete an issue model.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1DeleteIssueModelRequest {
        /**
         * Required. The name of the issue model to delete.
         */
        name?: string | null;
    }
    /**
     * The metadata for deleting a QaQuestionTag Resource.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1DeleteQaQuestionTagMetadata {
        /**
         * Output only. The time the operation was created.
         */
        createTime?: string | null;
        /**
         * Output only. The time the operation finished running.
         */
        endTime?: string | null;
        /**
         * Output only. The original request.
         */
        request?: Schema$GoogleCloudContactcenterinsightsV1alpha1DeleteQaQuestionTagRequest;
    }
    /**
     * The request for deleting a QaQuestionTag.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1DeleteQaQuestionTagRequest {
        /**
         * Required. The name of the QaQuestionTag to delete.
         */
        name?: string | null;
    }
    /**
     * Metadata for deploying an issue model.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1DeployIssueModelMetadata {
        /**
         * Output only. The time the operation was created.
         */
        createTime?: string | null;
        /**
         * Output only. The time the operation finished running.
         */
        endTime?: string | null;
        /**
         * The original request for deployment.
         */
        request?: Schema$GoogleCloudContactcenterinsightsV1alpha1DeployIssueModelRequest;
    }
    /**
     * The request to deploy an issue model.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1DeployIssueModelRequest {
        /**
         * Required. The issue model to deploy.
         */
        name?: string | null;
    }
    /**
     * The response to deploy an issue model.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1DeployIssueModelResponse {
    }
    /**
     * The data for a Dialogflow intent. Represents a detected intent in the conversation, e.g. MAKES_PROMISE.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1DialogflowIntent {
        /**
         * The human-readable name of the intent.
         */
        displayName?: string | null;
    }
    /**
     * Dialogflow interaction data.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1DialogflowInteractionData {
        /**
         * The confidence of the match ranging from 0.0 (completely uncertain) to 1.0 (completely certain).
         */
        confidence?: number | null;
        /**
         * The Dialogflow intent resource path. Format: projects/{project\}/agent/{agent\}/intents/{intent\}
         */
        dialogflowIntentId?: string | null;
    }
    /**
     * A Dialogflow source of conversation data.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1DialogflowSource {
        /**
         * Cloud Storage URI that points to a file that contains the conversation audio.
         */
        audioUri?: string | null;
        /**
         * Output only. The name of the Dialogflow conversation that this conversation resource is derived from. Format: projects/{project\}/locations/{location\}/conversations/{conversation\}
         */
        dialogflowConversation?: string | null;
    }
    /**
     * A dimension determines the grouping key for the query. In SQL terms, these would be part of both the "SELECT" and "GROUP BY" clauses.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1Dimension {
        /**
         * Output only. Metadata about the agent dimension.
         */
        agentDimensionMetadata?: Schema$GoogleCloudContactcenterinsightsV1alpha1DimensionAgentDimensionMetadata;
        /**
         * Output only. Metadata about the client sentiment category dimension.
         */
        clientSentimentCategoryDimensionMetadata?: Schema$GoogleCloudContactcenterinsightsV1alpha1DimensionClientSentimentCategoryDimensionMetadata;
        /**
         * Output only. Metadata about the Conversational Agents playbook dimension.
         */
        conversationalAgentsPlaybookDimensionMetadata?: Schema$GoogleCloudContactcenterinsightsV1alpha1DimensionConversationalAgentsPlaybookDimensionMetadata;
        /**
         * Output only. Metadata about the Conversational Agents tool dimension.
         */
        conversationalAgentsToolDimensionMetadata?: Schema$GoogleCloudContactcenterinsightsV1alpha1DimensionConversationalAgentsToolDimensionMetadata;
        /**
         * Output only. Metadata about the conversation profile dimension.
         */
        conversationProfileDimensionMetadata?: Schema$GoogleCloudContactcenterinsightsV1alpha1DimensionConversationProfileDimensionMetadata;
        /**
         * The key of the dimension.
         */
        dimensionKey?: string | null;
        /**
         * Output only. Metadata about the issue dimension.
         */
        issueDimensionMetadata?: Schema$GoogleCloudContactcenterinsightsV1alpha1DimensionIssueDimensionMetadata;
        /**
         * Output only. Metadata about conversation labels.
         */
        labelDimensionMetadata?: Schema$GoogleCloudContactcenterinsightsV1alpha1DimensionLabelDimensionMetadata;
        /**
         * Output only. Metadata about the conversation medium dimension.
         */
        mediumDimensionMetadata?: Schema$GoogleCloudContactcenterinsightsV1alpha1DimensionMediumDimensionMetadata;
        /**
         * Output only. Metadata about the QA question-answer dimension.
         */
        qaQuestionAnswerDimensionMetadata?: Schema$GoogleCloudContactcenterinsightsV1alpha1DimensionQaQuestionAnswerDimensionMetadata;
        /**
         * Output only. Metadata about the QA question dimension.
         */
        qaQuestionDimensionMetadata?: Schema$GoogleCloudContactcenterinsightsV1alpha1DimensionQaQuestionDimensionMetadata;
        /**
         * Output only. Metadata about the QA scorecard dimension.
         */
        qaScorecardDimensionMetadata?: Schema$GoogleCloudContactcenterinsightsV1alpha1DimensionQaScorecardDimensionMetadata;
    }
    /**
     * Metadata about the agent dimension.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1DimensionAgentDimensionMetadata {
        /**
         * Optional. The agent's deployment display name. Only applicable to automated agents. This will be populated for AGENT_DEPLOYMENT_ID dimensions.
         */
        agentDeploymentDisplayName?: string | null;
        /**
         * Optional. The agent's deployment ID. Only applicable to automated agents. This will be populated for AGENT and AGENT_DEPLOYMENT_ID dimensions.
         */
        agentDeploymentId?: string | null;
        /**
         * Optional. The agent's name This will be populated for AGENT, AGENT_TEAM, AGENT_VERSION_ID, and AGENT_DEPLOYMENT_ID dimensions.
         */
        agentDisplayName?: string | null;
        /**
         * Optional. A user-specified string representing the agent. This will be populated for AGENT, AGENT_TEAM, AGENT_VERSION_ID, and AGENT_DEPLOYMENT_ID dimensions.
         */
        agentId?: string | null;
        /**
         * Optional. A user-specified string representing the agent's team.
         */
        agentTeam?: string | null;
        /**
         * Optional. The agent's version display name. Only applicable to automated agents. This will be populated for AGENT_VERSION_ID, and AGENT_DEPLOYMENT_ID dimensions.
         */
        agentVersionDisplayName?: string | null;
        /**
         * Optional. The agent's version ID. Only applicable to automated agents. This will be populated for AGENT_VERSION_ID, and AGENT_DEPLOYMENT_ID dimensions.
         */
        agentVersionId?: string | null;
    }
    /**
     * Metadata about the client sentiment category dimension.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1DimensionClientSentimentCategoryDimensionMetadata {
        /**
         * Optional. The client sentiment category.
         */
        sentimentCategory?: string | null;
    }
    /**
     * Metadata about the Conversational Agents playbook dimension.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1DimensionConversationalAgentsPlaybookDimensionMetadata {
        /**
         * Optional. The dialogflow playbook display name.
         */
        playbookDisplayName?: string | null;
        /**
         * Optional. The dialogflow playbook ID.
         */
        playbookId?: string | null;
    }
    /**
     * Metadata about the Conversational Agents tool dimension.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1DimensionConversationalAgentsToolDimensionMetadata {
        /**
         * Optional. The dialogflow tool display name.
         */
        toolDisplayName?: string | null;
        /**
         * Optional. The dialogflow tool ID.
         */
        toolId?: string | null;
    }
    /**
     * Metadata about the conversation profile dimension.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1DimensionConversationProfileDimensionMetadata {
        /**
         * Optional. The conversation profile ID.
         */
        conversationProfileId?: string | null;
    }
    /**
     * Metadata about the issue dimension.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1DimensionIssueDimensionMetadata {
        /**
         * The issue display name.
         */
        issueDisplayName?: string | null;
        /**
         * The issue ID.
         */
        issueId?: string | null;
        /**
         * The parent issue model ID.
         */
        issueModelId?: string | null;
    }
    /**
     * Metadata about conversation labels.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1DimensionLabelDimensionMetadata {
        /**
         * Optional. The label key.
         */
        labelKey?: string | null;
        /**
         * Optional. The label value.
         */
        labelValue?: string | null;
    }
    /**
     * Metadata about the conversation medium dimension.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1DimensionMediumDimensionMetadata {
        /**
         * Optional. The conversation medium. Currently supports : PHONE_CALL, CHAT.
         */
        medium?: string | null;
    }
    /**
     * Metadata about the QA question-answer dimension. This is useful for showing the answer distribution for questions for a given scorecard.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1DimensionQaQuestionAnswerDimensionMetadata {
        /**
         * Optional. The full body of the question.
         */
        answerValue?: string | null;
        /**
         * Optional. The QA question ID.
         */
        qaQuestionId?: string | null;
        /**
         * Optional. The QA scorecard ID.
         */
        qaScorecardId?: string | null;
        /**
         * Optional. The full body of the question.
         */
        questionBody?: string | null;
    }
    /**
     * Metadata about the QA question dimension.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1DimensionQaQuestionDimensionMetadata {
        /**
         * Optional. The QA question ID.
         */
        qaQuestionId?: string | null;
        /**
         * Optional. The QA scorecard ID.
         */
        qaScorecardId?: string | null;
        /**
         * Optional. The full body of the question.
         */
        questionBody?: string | null;
    }
    /**
     * Metadata about the QA scorecard dimension.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1DimensionQaScorecardDimensionMetadata {
        /**
         * Optional. The QA scorecard ID.
         */
        qaScorecardId?: string | null;
    }
    /**
     * A customer-managed encryption key specification that can be applied to all created resources (e.g. `Conversation`).
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1EncryptionSpec {
        /**
         * Required. The name of customer-managed encryption key that is used to secure a resource and its sub-resources. If empty, the resource is secured by our default encryption key. Only the key in the same location as this resource is allowed to be used for encryption. Format: `projects/{project\}/locations/{location\}/keyRings/{keyRing\}/cryptoKeys/{key\}`
         */
        kmsKey?: string | null;
        /**
         * Immutable. The resource name of the encryption key specification resource. Format: projects/{project\}/locations/{location\}/encryptionSpec
         */
        name?: string | null;
    }
    /**
     * The data for an entity annotation. Represents a phrase in the conversation that is a known entity, such as a person, an organization, or location.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1Entity {
        /**
         * The representative name for the entity.
         */
        displayName?: string | null;
        /**
         * Metadata associated with the entity. For most entity types, the metadata is a Wikipedia URL (`wikipedia_url`) and Knowledge Graph MID (`mid`), if they are available. For the metadata associated with other entity types, see the Type table below.
         */
        metadata?: {
            [key: string]: string;
        } | null;
        /**
         * The salience score associated with the entity in the [0, 1.0] range. The salience score for an entity provides information about the importance or centrality of that entity to the entire document text. Scores closer to 0 are less salient, while scores closer to 1.0 are highly salient.
         */
        salience?: number | null;
        /**
         * The aggregate sentiment expressed for this entity in the conversation.
         */
        sentiment?: Schema$GoogleCloudContactcenterinsightsV1alpha1SentimentData;
        /**
         * The entity type.
         */
        type?: string | null;
    }
    /**
     * The data for an entity mention annotation. This represents a mention of an `Entity` in the conversation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1EntityMentionData {
        /**
         * The key of this entity in conversation entities. Can be used to retrieve the exact `Entity` this mention is attached to.
         */
        entityUniqueId?: string | null;
        /**
         * Sentiment expressed for this mention of the entity.
         */
        sentiment?: Schema$GoogleCloudContactcenterinsightsV1alpha1SentimentData;
        /**
         * The type of the entity mention.
         */
        type?: string | null;
    }
    /**
     * Metadata for an export insights operation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataMetadata {
        /**
         * The number of conversations that were exported successfully.
         */
        completedExportCount?: number | null;
        /**
         * Output only. The time the operation was created.
         */
        createTime?: string | null;
        /**
         * Output only. The time the operation finished running.
         */
        endTime?: string | null;
        /**
         * The number of conversations that failed to be exported.
         */
        failedExportCount?: number | null;
        /**
         * Partial errors during export operation that might cause the operation output to be incomplete.
         */
        partialErrors?: Schema$GoogleRpcStatus[];
        /**
         * The original request for export.
         */
        request?: Schema$GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataRequest;
    }
    /**
     * The request to export insights.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataRequest {
        /**
         * Specified if sink is a BigQuery table.
         */
        bigQueryDestination?: Schema$GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataRequestBigQueryDestination;
        /**
         * Optional. Version of the export schema.
         */
        exportSchemaVersion?: string | null;
        /**
         * A filter to reduce results to a specific subset. Useful for exporting conversations with specific properties.
         */
        filter?: string | null;
        /**
         * A fully qualified KMS key name for BigQuery tables protected by CMEK. Format: projects/{project\}/locations/{location\}/keyRings/{keyring\}/cryptoKeys/{key\}/cryptoKeyVersions/{version\}
         */
        kmsKey?: string | null;
        /**
         * Required. The parent resource to export data from.
         */
        parent?: string | null;
        /**
         * Options for what to do if the destination table already exists.
         */
        writeDisposition?: string | null;
    }
    /**
     * A BigQuery Table Reference.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataRequestBigQueryDestination {
        /**
         * Required. The name of the BigQuery dataset that the snapshot result should be exported to. If this dataset does not exist, the export call returns an INVALID_ARGUMENT error.
         */
        dataset?: string | null;
        /**
         * A project ID or number. If specified, then export will attempt to write data to this project instead of the resource project. Otherwise, the resource project will be used.
         */
        projectId?: string | null;
        /**
         * The BigQuery table name to which the insights data should be written. If this table does not exist, the export call returns an INVALID_ARGUMENT error.
         */
        table?: string | null;
    }
    /**
     * Response for an export insights operation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1ExportInsightsDataResponse {
    }
    /**
     * Metadata used for export issue model.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1ExportIssueModelMetadata {
        /**
         * The time the operation was created.
         */
        createTime?: string | null;
        /**
         * The time the operation finished running.
         */
        endTime?: string | null;
        /**
         * The original export request.
         */
        request?: Schema$GoogleCloudContactcenterinsightsV1alpha1ExportIssueModelRequest;
    }
    /**
     * Request to export an issue model.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1ExportIssueModelRequest {
        /**
         * Google Cloud Storage URI to export the issue model to.
         */
        gcsDestination?: Schema$GoogleCloudContactcenterinsightsV1alpha1ExportIssueModelRequestGcsDestination;
        /**
         * Required. The issue model to export.
         */
        name?: string | null;
    }
    /**
     * Google Cloud Storage Object URI to save the issue model to.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1ExportIssueModelRequestGcsDestination {
        /**
         * Required. Format: `gs:///`
         */
        objectUri?: string | null;
    }
    /**
     * Response from export issue model
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1ExportIssueModelResponse {
    }
    /**
     * Agent Assist frequently-asked-question answer data.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1FaqAnswerData {
        /**
         * The piece of text from the `source` knowledge base document.
         */
        answer?: string | null;
        /**
         * The system's confidence score that this answer is a good match for this conversation, ranging from 0.0 (completely uncertain) to 1.0 (completely certain).
         */
        confidenceScore?: number | null;
        /**
         * Map that contains metadata about the FAQ answer and the document that it originates from.
         */
        metadata?: {
            [key: string]: string;
        } | null;
        /**
         * The name of the answer record. Format: projects/{project\}/locations/{location\}/answerRecords/{answer_record\}
         */
        queryRecord?: string | null;
        /**
         * The corresponding FAQ question.
         */
        question?: string | null;
        /**
         * The knowledge document that this answer was extracted from. Format: projects/{project\}/knowledgeBases/{knowledge_base\}/documents/{document\}.
         */
        source?: string | null;
    }
    /**
     * Represents a conversation, resource, and label provided by the user. Can take the form of a string label or a QaAnswer label. QaAnswer labels are used for Quality AI example conversations. String labels are used for Topic Modeling. AgentAssistSummary labels are used for Agent Assist Summarization.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1FeedbackLabel {
        /**
         * Output only. Create time of the label.
         */
        createTime?: string | null;
        /**
         * String label used for Topic Modeling.
         */
        label?: string | null;
        /**
         * Name of the resource to be labeled. Supported resources are: * `projects/{project\}/locations/{location\}/qaScorecards/{scorecard\}/revisions/{revision\}/qaQuestions/{question\}` * `projects/{project\}/locations/{location\}/issueModels/{issue_model\}` * `projects/{project\}/locations/{location\}/generators/{generator_id\}`
         */
        labeledResource?: string | null;
        /**
         * Immutable. Resource name of the FeedbackLabel. Format: projects/{project\}/locations/{location\}/conversations/{conversation\}/feedbackLabels/{feedback_label\}
         */
        name?: string | null;
        /**
         * QaAnswer label used for Quality AI example conversations.
         */
        qaAnswerLabel?: Schema$GoogleCloudContactcenterinsightsV1alpha1QaAnswerAnswerValue;
        /**
         * Output only. Update time of the label.
         */
        updateTime?: string | null;
    }
    /**
     * A Cloud Storage source of conversation data.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1GcsSource {
        /**
         * Cloud Storage URI that points to a file that contains the conversation audio.
         */
        audioUri?: string | null;
        /**
         * Immutable. Cloud Storage URI that points to a file that contains the conversation transcript.
         */
        transcriptUri?: string | null;
    }
    /**
     * The data for a hold annotation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1HoldData {
    }
    /**
     * Metadata used for import issue model.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelMetadata {
        /**
         * The time the operation was created.
         */
        createTime?: string | null;
        /**
         * The time the operation finished running.
         */
        endTime?: string | null;
        /**
         * The original import request.
         */
        request?: Schema$GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelRequest;
    }
    /**
     * Request to import an issue model.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelRequest {
        /**
         * Optional. If set to true, will create an issue model from the imported file with randomly generated IDs for the issue model and corresponding issues. Otherwise, replaces an existing model with the same ID as the file.
         */
        createNewModel?: boolean | null;
        /**
         * Google Cloud Storage source message.
         */
        gcsSource?: Schema$GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelRequestGcsSource;
        /**
         * Required. The parent resource of the issue model.
         */
        parent?: string | null;
    }
    /**
     * Google Cloud Storage Object URI to get the issue model file from.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelRequestGcsSource {
        /**
         * Required. Format: `gs:///`
         */
        objectUri?: string | null;
    }
    /**
     * Response from import issue model
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1ImportIssueModelResponse {
        /**
         * The issue model that was imported.
         */
        issueModel?: Schema$GoogleCloudContactcenterinsightsV1alpha1IssueModel;
    }
    /**
     * The metadata for an IngestConversations operation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1IngestConversationsMetadata {
        /**
         * Output only. The time the operation was created.
         */
        createTime?: string | null;
        /**
         * Output only. The time the operation finished running.
         */
        endTime?: string | null;
        /**
         * Output only. Statistics for IngestConversations operation.
         */
        ingestConversationsStats?: Schema$GoogleCloudContactcenterinsightsV1alpha1IngestConversationsMetadataIngestConversationsStats;
        /**
         * Output only. Partial errors during ingest operation that might cause the operation output to be incomplete.
         */
        partialErrors?: Schema$GoogleRpcStatus[];
        /**
         * Output only. The original request for ingest.
         */
        request?: Schema$GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequest;
        /**
         * Output only. Stores the conversation resources produced by ingest sampling operations.
         */
        sampledConversations?: string[] | null;
    }
    /**
     * Statistics for IngestConversations operation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1IngestConversationsMetadataIngestConversationsStats {
        /**
         * Output only. The number of objects skipped because another conversation with the same transcript uri had already been ingested.
         */
        duplicatesSkippedCount?: number | null;
        /**
         * Output only. The number of objects which were unable to be ingested due to errors. The errors are populated in the partial_errors field.
         */
        failedIngestCount?: number | null;
        /**
         * Output only. The number of objects processed during the ingest operation.
         */
        processedObjectCount?: number | null;
        /**
         * Output only. The number of new conversations added during this ingest operation.
         */
        successfulIngestCount?: number | null;
    }
    /**
     * The request to ingest conversations.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequest {
        /**
         * Configuration that applies to all conversations.
         */
        conversationConfig?: Schema$GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequestConversationConfig;
        /**
         * A cloud storage bucket source. Note that any previously ingested objects from the source will be skipped to avoid duplication.
         */
        gcsSource?: Schema$GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequestGcsSource;
        /**
         * Required. The parent resource for new conversations.
         */
        parent?: string | null;
        /**
         * Optional. DLP settings for transcript redaction. Optional, will default to the config specified in Settings.
         */
        redactionConfig?: Schema$GoogleCloudContactcenterinsightsV1alpha1RedactionConfig;
        /**
         * Optional. If set, this fields indicates the number of objects to ingest from the Cloud Storage bucket. If empty, the entire bucket will be ingested. Unless they are first deleted, conversations produced through sampling won't be ingested by subsequent ingest requests.
         */
        sampleSize?: number | null;
        /**
         * Optional. Default Speech-to-Text configuration. Optional, will default to the config specified in Settings.
         */
        speechConfig?: Schema$GoogleCloudContactcenterinsightsV1alpha1SpeechConfig;
        /**
         * Configuration for when `source` contains conversation transcripts.
         */
        transcriptObjectConfig?: Schema$GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequestTranscriptObjectConfig;
    }
    /**
     * Configuration that applies to all conversations.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequestConversationConfig {
        /**
         * Optional. Indicates which of the channels, 1 or 2, contains the agent. Note that this must be set for conversations to be properly displayed and analyzed.
         */
        agentChannel?: number | null;
        /**
         * Optional. An opaque, user-specified string representing a human agent who handled all conversations in the import. Note that this will be overridden if per-conversation metadata is provided through the `metadata_bucket_uri`.
         */
        agentId?: string | null;
        /**
         * Optional. Indicates which of the channels, 1 or 2, contains the agent. Note that this must be set for conversations to be properly displayed and analyzed.
         */
        customerChannel?: number | null;
    }
    /**
     * Configuration for Cloud Storage bucket sources.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequestGcsSource {
        /**
         * Optional. The Cloud Storage path to the conversation audio file. Note that: [1] Audio files will be transcribed if not already. [2] Audio files and transcript files must be in separate buckets / folders. [3] A source file and its corresponding audio file must share the same name to be properly ingested, E.g. `gs://bucket/transcript/conversation1.json` and `gs://bucket/audio/conversation1.mp3`.
         */
        audioBucketUri?: string | null;
        /**
         * Optional. Specifies the type of the objects in `bucket_uri`. Avoid passing this. This is inferred from the `transcript_bucket_uri`, `audio_bucket_uri`.
         */
        bucketObjectType?: string | null;
        /**
         * Optional. The Cloud Storage bucket containing source objects. Avoid passing this. Pass this through one of `transcript_bucket_uri` or `audio_bucket_uri`.
         */
        bucketUri?: string | null;
        /**
         * Optional. Custom keys to extract as conversation labels from metadata files in `metadata_bucket_uri`. Keys not included in this field will be ignored. Note that there is a limit of 100 labels per conversation.
         */
        customMetadataKeys?: string[] | null;
        /**
         * Optional. The Cloud Storage path to the conversation metadata. Note that: [1] Metadata files are expected to be in JSON format. [2] Metadata and source files (transcripts or audio) must be in separate buckets / folders. [3] A source file and its corresponding metadata file must share the same name to be properly ingested, E.g. `gs://bucket/audio/conversation1.mp3` and `gs://bucket/metadata/conversation1.json`.
         */
        metadataBucketUri?: string | null;
        /**
         * Optional. The Cloud Storage path to the conversation transcripts. Note that: [1] Transcript files are expected to be in JSON format. [2] Transcript, audio, metadata files must be in separate buckets / folders. [3] A source file and its corresponding metadata file must share the same name to be properly ingested, E.g. `gs://bucket/audio/conversation1.mp3` and `gs://bucket/metadata/conversation1.json`.
         */
        transcriptBucketUri?: string | null;
    }
    /**
     * Configuration for processing transcript objects.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1IngestConversationsRequestTranscriptObjectConfig {
        /**
         * Required. The medium transcript objects represent.
         */
        medium?: string | null;
    }
    /**
     * The response to an IngestConversations operation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1IngestConversationsResponse {
    }
    /**
     * Metadata for initializing a location-level encryption specification.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1InitializeEncryptionSpecMetadata {
        /**
         * Output only. The time the operation was created.
         */
        createTime?: string | null;
        /**
         * Output only. The time the operation finished running.
         */
        endTime?: string | null;
        /**
         * Partial errors during initializing operation that might cause the operation output to be incomplete.
         */
        partialErrors?: Schema$GoogleRpcStatus[];
        /**
         * Output only. The original request for initialization.
         */
        request?: Schema$GoogleCloudContactcenterinsightsV1alpha1InitializeEncryptionSpecRequest;
    }
    /**
     * The request to initialize a location-level encryption specification.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1InitializeEncryptionSpecRequest {
        /**
         * Required. The encryption spec used for CMEK encryption. It is required that the kms key is in the same region as the endpoint. The same key will be used for all provisioned resources, if encryption is available. If the `kms_key_name` field is left empty, no encryption will be enforced.
         */
        encryptionSpec?: Schema$GoogleCloudContactcenterinsightsV1alpha1EncryptionSpec;
    }
    /**
     * The response to initialize a location-level encryption specification.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1InitializeEncryptionSpecResponse {
    }
    /**
     * The data for an intent. Represents a detected intent in the conversation, for example MAKES_PROMISE.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1Intent {
        /**
         * The human-readable name of the intent.
         */
        displayName?: string | null;
        /**
         * The unique identifier of the intent.
         */
        id?: string | null;
    }
    /**
     * The data for an intent match. Represents an intent match for a text segment in the conversation. A text segment can be part of a sentence, a complete sentence, or an utterance with multiple sentences.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1IntentMatchData {
        /**
         * The id of the matched intent. Can be used to retrieve the corresponding intent information.
         */
        intentUniqueId?: string | null;
    }
    /**
     * The data for an interruption annotation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1InterruptionData {
    }
    /**
     * The issue resource.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1Issue {
        /**
         * Output only. The time at which this issue was created.
         */
        createTime?: string | null;
        /**
         * Representative description of the issue.
         */
        displayDescription?: string | null;
        /**
         * The representative name for the issue.
         */
        displayName?: string | null;
        /**
         * Immutable. The resource name of the issue. Format: projects/{project\}/locations/{location\}/issueModels/{issue_model\}/issues/{issue\}
         */
        name?: string | null;
        /**
         * Output only. Resource names of the sample representative utterances that match to this issue.
         */
        sampleUtterances?: string[] | null;
        /**
         * Output only. The most recent time that this issue was updated.
         */
        updateTime?: string | null;
    }
    /**
     * Information about the issue.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1IssueAssignment {
        /**
         * Immutable. Display name of the assigned issue. This field is set at time of analysis and immutable since then.
         */
        displayName?: string | null;
        /**
         * Resource name of the assigned issue.
         */
        issue?: string | null;
        /**
         * Score indicating the likelihood of the issue assignment. currently bounded on [0,1].
         */
        score?: number | null;
    }
    /**
     * The data for an issue match annotation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1IssueMatchData {
        /**
         * Information about the issue's assignment.
         */
        issueAssignment?: Schema$GoogleCloudContactcenterinsightsV1alpha1IssueAssignment;
    }
    /**
     * The issue model resource.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1IssueModel {
        /**
         * Output only. The time at which this issue model was created.
         */
        createTime?: string | null;
        /**
         * The representative name for the issue model.
         */
        displayName?: string | null;
        /**
         * Configs for the input data that used to create the issue model.
         */
        inputDataConfig?: Schema$GoogleCloudContactcenterinsightsV1alpha1IssueModelInputDataConfig;
        /**
         * Output only. Number of issues in this issue model.
         */
        issueCount?: string | null;
        /**
         * Language of the model.
         */
        languageCode?: string | null;
        /**
         * Type of the model.
         */
        modelType?: string | null;
        /**
         * Immutable. The resource name of the issue model. Format: projects/{project\}/locations/{location\}/issueModels/{issue_model\}
         */
        name?: string | null;
        /**
         * Output only. State of the model.
         */
        state?: string | null;
        /**
         * Output only. Immutable. The issue model's label statistics on its training data.
         */
        trainingStats?: Schema$GoogleCloudContactcenterinsightsV1alpha1IssueModelLabelStats;
        /**
         * Output only. The most recent time at which the issue model was updated.
         */
        updateTime?: string | null;
    }
    /**
     * Configs for the input data used to create the issue model.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1IssueModelInputDataConfig {
        /**
         * A filter to reduce the conversations used for training the model to a specific subset. Refer to https://cloud.google.com/contact-center/insights/docs/filtering for details.
         */
        filter?: string | null;
        /**
         * Medium of conversations used in training data. This field is being deprecated. To specify the medium to be used in training a new issue model, set the `medium` field on `filter`.
         */
        medium?: string | null;
        /**
         * Output only. Number of conversations used in training. Output only.
         */
        trainingConversationsCount?: string | null;
    }
    /**
     * Aggregated statistics about an issue model.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1IssueModelLabelStats {
        /**
         * Number of conversations the issue model has analyzed at this point in time.
         */
        analyzedConversationsCount?: string | null;
        /**
         * Statistics on each issue. Key is the issue's resource name.
         */
        issueStats?: {
            [key: string]: Schema$GoogleCloudContactcenterinsightsV1alpha1IssueModelLabelStatsIssueStats;
        } | null;
        /**
         * Number of analyzed conversations for which no issue was applicable at this point in time.
         */
        unclassifiedConversationsCount?: string | null;
    }
    /**
     * Aggregated statistics about an issue.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1IssueModelLabelStatsIssueStats {
        /**
         * Display name of the issue.
         */
        displayName?: string | null;
        /**
         * Issue resource. Format: projects/{project\}/locations/{location\}/issueModels/{issue_model\}/issues/{issue\}
         */
        issue?: string | null;
        /**
         * Number of conversations attached to the issue at this point in time.
         */
        labeledConversationsCount?: string | null;
    }
    /**
     * Issue Modeling result on a conversation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1IssueModelResult {
        /**
         * Issue model that generates the result. Format: projects/{project\}/locations/{location\}/issueModels/{issue_model\}
         */
        issueModel?: string | null;
        /**
         * All the matched issues.
         */
        issues?: Schema$GoogleCloudContactcenterinsightsV1alpha1IssueAssignment[];
    }
    /**
     * The response for listing all feedback labels.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1ListAllFeedbackLabelsResponse {
        /**
         * The feedback labels that match the request.
         */
        feedbackLabels?: Schema$GoogleCloudContactcenterinsightsV1alpha1FeedbackLabel[];
        /**
         * A token, which can be sent as `page_token` to retrieve the next page. If this field is omitted, there are no subsequent pages.
         */
        nextPageToken?: string | null;
    }
    /**
     * The response for listing feedback labels.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1ListFeedbackLabelsResponse {
        /**
         * The feedback labels that match the request.
         */
        feedbackLabels?: Schema$GoogleCloudContactcenterinsightsV1alpha1FeedbackLabel[];
        /**
         * The next page token.
         */
        nextPageToken?: string | null;
    }
    /**
     * The data for a matched phrase matcher. Represents information identifying a phrase matcher for a given match.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1PhraseMatchData {
        /**
         * The human-readable name of the phrase matcher.
         */
        displayName?: string | null;
        /**
         * The unique identifier (the resource name) of the phrase matcher.
         */
        phraseMatcher?: string | null;
    }
    /**
     * An answer to a QaQuestion.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1QaAnswer {
        /**
         * Lists all answer sources containing one or more answer values of a specific source type, e.g., all system-generated answer sources, or all manual edit answer sources.
         */
        answerSources?: Schema$GoogleCloudContactcenterinsightsV1alpha1QaAnswerAnswerSource[];
        /**
         * The answer value from this source. This field is populated by default, unless the question has a selection strategy configured to return multiple answer values, in which case `answer_values` will be populated instead.
         */
        answerValue?: Schema$GoogleCloudContactcenterinsightsV1alpha1QaAnswerAnswerValue;
        /**
         * The conversation the answer applies to.
         */
        conversation?: string | null;
        /**
         * The QaQuestion answered by this answer.
         */
        qaQuestion?: string | null;
        /**
         * Question text. E.g., "Did the agent greet the customer?"
         */
        questionBody?: string | null;
        /**
         * User-defined list of arbitrary tags. Matches the value from QaScorecard.ScorecardQuestion.tags. Used for grouping/organization and for weighting the score of each answer.
         */
        tags?: string[] | null;
    }
    /**
     * A question may have multiple answers from varying sources, one of which becomes the "main" answer above. AnswerSource represents each individual answer.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1QaAnswerAnswerSource {
        /**
         * The answer value from this source. This field is populated by default, unless the question has a selection strategy configured to return multiple answer values, in which case `answer_values` will be populated instead.
         */
        answerValue?: Schema$GoogleCloudContactcenterinsightsV1alpha1QaAnswerAnswerValue;
        /**
         * What created the answer.
         */
        sourceType?: string | null;
    }
    /**
     * Message for holding the value of a QaAnswer. QaQuestion.AnswerChoice defines the possible answer values for a question.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1QaAnswerAnswerValue {
        /**
         * Boolean value.
         */
        boolValue?: boolean | null;
        /**
         * A short string used as an identifier. Matches the value used in QaQuestion.AnswerChoice.key.
         */
        key?: string | null;
        /**
         * A value of "Not Applicable (N/A)". Should only ever be `true`.
         */
        naValue?: boolean | null;
        /**
         * Output only. Normalized score of the questions. Calculated as score / potential_score.
         */
        normalizedScore?: number | null;
        /**
         * Numerical value.
         */
        numValue?: number | null;
        /**
         * Output only. The maximum potential score of the question.
         */
        potentialScore?: number | null;
        /**
         * Output only. Numerical score of the answer.
         */
        score?: number | null;
        /**
         * Output only. A value of "Skip". If provided, this field may only be set to `true`. If a question receives this answer, it will be excluded from any score calculations. This would mean that the question was not evaluated.
         */
        skipValue?: boolean | null;
        /**
         * String value.
         */
        strValue?: string | null;
    }
    /**
     * A tag is a resource which aims to categorize a set of questions across multiple scorecards, e.g., "Customer Satisfaction","Billing", etc.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1QaQuestionTag {
        /**
         * Output only. The time at which the question tag was created.
         */
        createTime?: string | null;
        /**
         * Required. A user-specified display name for the tag.
         */
        displayName?: string | null;
        /**
         * Identifier. Resource name for the QaQuestionTag Format projects/{project\}/locations/{location\}/qaQuestionTags/{qa_question_tag\} In the above format, the last segment, i.e., qa_question_tag, is a server-generated ID corresponding to the tag resource.
         */
        name?: string | null;
        /**
         * Optional. The list of Scorecard Question IDs that the tag applies to. Each QaQuestionId is represented as a full resource name containing the Question ID. Lastly, Since a tag may not necessarily be referenced by any Scorecard Questions, we treat this field as optional.
         */
        qaQuestionIds?: string[] | null;
        /**
         * Output only. The most recent time at which the question tag was updated.
         */
        updateTime?: string | null;
    }
    /**
     * The results of scoring a single conversation against a QaScorecard. Contains a collection of QaAnswers and aggregate score.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1QaScorecardResult {
        /**
         * ID of the agent that handled the conversation.
         */
        agentId?: string | null;
        /**
         * The conversation scored by this result.
         */
        conversation?: string | null;
        /**
         * Output only. The timestamp that the revision was created.
         */
        createTime?: string | null;
        /**
         * Identifier. The name of the scorecard result. Format: projects/{project\}/locations/{location\}/qaScorecardResults/{qa_scorecard_result\}
         */
        name?: string | null;
        /**
         * The normalized score, which is the score divided by the potential score. Any manual edits are included if they exist.
         */
        normalizedScore?: number | null;
        /**
         * The maximum potential overall score of the scorecard. Any questions answered using `na_value` are excluded from this calculation.
         */
        potentialScore?: number | null;
        /**
         * Set of QaAnswers represented in the result.
         */
        qaAnswers?: Schema$GoogleCloudContactcenterinsightsV1alpha1QaAnswer[];
        /**
         * The QaScorecardRevision scored by this result.
         */
        qaScorecardRevision?: string | null;
        /**
         * Collection of tags and their scores.
         */
        qaTagResults?: Schema$GoogleCloudContactcenterinsightsV1alpha1QaScorecardResultQaTagResult[];
        /**
         * The overall numerical score of the result, incorporating any manual edits if they exist.
         */
        score?: number | null;
        /**
         * List of all individual score sets.
         */
        scoreSources?: Schema$GoogleCloudContactcenterinsightsV1alpha1QaScorecardResultScoreSource[];
    }
    /**
     * Tags and their corresponding results.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1QaScorecardResultQaTagResult {
        /**
         * The normalized score the tag applies to.
         */
        normalizedScore?: number | null;
        /**
         * The potential score the tag applies to.
         */
        potentialScore?: number | null;
        /**
         * The score the tag applies to.
         */
        score?: number | null;
        /**
         * The tag the score applies to.
         */
        tag?: string | null;
    }
    /**
     * A scorecard result may have multiple sets of scores from varying sources, one of which becomes the "main" answer above. A ScoreSource represents each individual set of scores.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1QaScorecardResultScoreSource {
        /**
         * The normalized score, which is the score divided by the potential score.
         */
        normalizedScore?: number | null;
        /**
         * The maximum potential overall score of the scorecard. Any questions answered using `na_value` are excluded from this calculation.
         */
        potentialScore?: number | null;
        /**
         * Collection of tags and their scores.
         */
        qaTagResults?: Schema$GoogleCloudContactcenterinsightsV1alpha1QaScorecardResultQaTagResult[];
        /**
         * The overall numerical score of the result.
         */
        score?: number | null;
        /**
         * What created the score.
         */
        sourceType?: string | null;
    }
    /**
     * The metadata from querying metrics.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1QueryMetricsMetadata {
        /**
         * Whether the result rows were truncated because the result row size is too large to materialize.
         */
        resultIsTruncated?: boolean | null;
    }
    /**
     * The response for querying metrics.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponse {
        /**
         * Required. The location of the data. "projects/{project\}/locations/{location\}"
         */
        location?: string | null;
        /**
         * The macro average slice contains aggregated averages across all selected dimensions. i.e. if group_by agent and scorecard_id is specified, this field will contain the average across all agents and all scorecards. This field is only populated if the request specifies a Dimension.
         */
        macroAverageSlice?: Schema$GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSlice;
        /**
         * A slice contains a total and (if the request specified a time granularity) a time series of metric values. Each slice contains a unique combination of the cardinality of dimensions from the request.
         */
        slices?: Schema$GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSlice[];
        /**
         * The metrics last update time.
         */
        updateTime?: string | null;
    }
    /**
     * A slice contains a total and (if the request specified a time granularity) a time series of metric values. Each slice contains a unique combination of the cardinality of dimensions from the request. For example, if the request specifies a single ISSUE dimension and it has a cardinality of 2 (i.e. the data used to compute the metrics has 2 issues in total), the response will have 2 slices: * Slice 1 -\> dimensions=[Issue 1] * Slice 2 -\> dimensions=[Issue 2]
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSlice {
        /**
         * A unique combination of dimensions that this slice represents.
         */
        dimensions?: Schema$GoogleCloudContactcenterinsightsV1alpha1Dimension[];
        /**
         * A time series of metric values. This is only populated if the request specifies a time granularity other than NONE.
         */
        timeSeries?: Schema$GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceTimeSeries;
        /**
         * The total metric value. The interval of this data point is [starting create time, ending create time) from the request.
         */
        total?: Schema$GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPoint;
    }
    /**
     * A data point contains the metric values mapped to an interval.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPoint {
        /**
         * The measure related to conversations.
         */
        conversationMeasure?: Schema$GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointConversationMeasure;
        /**
         * The measure related to dialogflow interactions.
         */
        dialogflowInteractionMeasure?: Schema$GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointDialogflowInteractionMeasure;
        /**
         * The interval that this data point represents. * If this is the total data point, the interval is [starting create time, ending create time) from the request. * If this a data point from the time series, the interval is [time, time + time granularity from the request).
         */
        interval?: Schema$GoogleTypeInterval;
    }
    /**
     * The measure related to conversations.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointConversationMeasure {
        /**
         * The number of conversations that were assigned to an AA human supervisor.
         */
        aaSupervisorAssignedConversationsCount?: number | null;
        /**
         * The number of conversations that were dropped, i.e. escalated but not assigned to an AA human supervisor.
         */
        aaSupervisorDroppedConversationsCount?: number | null;
        /**
         * The number of conversations that were escalated to an AA human supervisor for intervention.
         */
        aaSupervisorEscalatedConversationsCount?: number | null;
        /**
         * The number of conversations scanned by the AA human supervisor.
         */
        aaSupervisorMonitoredConversationsCount?: number | null;
        /**
         * The number of conversations transferred to a human agent.
         */
        aaSupervisorTransferredToHumanAgentConvCount?: number | null;
        /**
         * Count of agent messages that triggered an Ai Coach Suggestion.
         */
        aiCoachSuggestionAgentMessageTriggerCount?: number | null;
        /**
         * Count of Ai Coach Suggestion that has been used by agents.
         */
        aiCoachSuggestionAgentUsageCount?: number | null;
        /**
         * Proportion of Ai Coach Suggestion that has been used by agents.
         */
        aiCoachSuggestionAgentUsageRatio?: number | null;
        /**
         * Count of customer messages that triggered an Ai Coach Suggestion.
         */
        aiCoachSuggestionCustomerMessageTriggerCount?: number | null;
        /**
         * Proportion of customer messages that triggered an Ai Coach Suggestion.
         */
        aiCoachSuggestionCustomerMessageTriggerRatio?: number | null;
        /**
         * Count of end_of_utterance trigger event messages that triggered an Ai Coach Suggestion.
         */
        aiCoachSuggestionMessageTriggerCount?: number | null;
        /**
         * Proportion of end_of_utterance trigger event messages that triggered an Ai Coach Suggestion.
         */
        aiCoachSuggestionMessageTriggerRatio?: number | null;
        /**
         * The average agent's sentiment score.
         */
        averageAgentSentimentScore?: number | null;
        /**
         * The average client's sentiment score.
         */
        averageClientSentimentScore?: number | null;
        /**
         * The average customer satisfaction rating.
         */
        averageCustomerSatisfactionRating?: number | null;
        /**
         * The average duration.
         */
        averageDuration?: string | null;
        /**
         * The average normalized QA score for a scorecard. When computing the average across a set of conversations, if a conversation has been evaluated with multiple revisions of a scorecard, only the latest revision results will be used. Will exclude 0's in average calculation. Will be only populated if the request specifies a dimension of QA_SCORECARD_ID.
         */
        averageQaNormalizedScore?: number | null;
        /**
         * Average QA normalized score averaged for questions averaged across all revisions of the parent scorecard. Will be only populated if the request specifies a dimension of QA_QUESTION_ID.
         */
        averageQaQuestionNormalizedScore?: number | null;
        /**
         * The average silence percentage.
         */
        averageSilencePercentage?: number | null;
        /**
         * Average edit distance of the summarization suggestions. Edit distance (also called as levenshtein distance) is calculated by summing up number of insertions, deletions and substitutions required to transform the summization feedback to the original summary suggestion.
         */
        averageSummarizationSuggestionEditDistance?: number | null;
        /**
         * Normalized Average edit distance of the summarization suggestions. Edit distance (also called as levenshtein distance) is calculated by summing up number of insertions, deletions and substitutions required to transform the summization feedback to the original summary suggestion. Normalized edit distance is the average of (edit distance / summary length).
         */
        averageSummarizationSuggestionNormalizedEditDistance?: number | null;
        /**
         * The average turn count.
         */
        averageTurnCount?: number | null;
        /**
         * The exponential moving average of the sentiment score of client turns in the conversation.
         */
        avgConversationClientTurnSentimentEma?: number | null;
        /**
         * The number of conversations that were contained.
         */
        containedConversationCount?: number | null;
        /**
         * The percentage of conversations that were contained.
         */
        containedConversationRatio?: number | null;
        /**
         * Count of conversations that has Ai Coach Suggestions.
         */
        conversationAiCoachSuggestionCount?: number | null;
        /**
         * Proportion of conversations that has Ai Coach Suggestions.
         */
        conversationAiCoachSuggestionRatio?: number | null;
        /**
         * The average latency of conversational agents' audio in audio out latency per interaction. This is computed as the average of the all the interactions' audio in audio out latencies in a conversation and averaged across conversations.
         */
        conversationalAgentsAverageAudioInAudioOutLatency?: number | null;
        /**
         * The average latency of conversational agents' latency per interaction. This is computed as the average of the all the iteractions' end to end latencies in a conversation and averaged across conversations. The e2e latency is the time between the end of the user utterance and the start of the agent utterance on the interaction level.
         */
        conversationalAgentsAverageEndToEndLatency?: number | null;
        /**
         * The average latency of conversational agents' LLM call latency per interaction. This is computed as the average of the all the interactions LLM call latencies in a conversation and averaged across conversations.
         */
        conversationalAgentsAverageLlmCallLatency?: number | null;
        /**
         * The macro average latency of conversational agents' TTS latency per interaction. This is computed as the average of the all the interactions' TTS latencies in a conversation and averaged across conversations.
         */
        conversationalAgentsAverageTtsLatency?: number | null;
        /**
         * The conversation count.
         */
        conversationCount?: number | null;
        /**
         * Proportion of conversations that had a suggested summary.
         */
        conversationSuggestedSummaryRatio?: number | null;
        /**
         * The agent message count.
         */
        conversationTotalAgentMessageCount?: number | null;
        /**
         * The customer message count.
         */
        conversationTotalCustomerMessageCount?: number | null;
        /**
         * Average latency of dialogflow webhook calls.
         */
        dialogflowAverageWebhookLatency?: number | null;
        /**
         * count of conversations that was handed off from virtual agent to human agent.
         */
        dialogflowConversationsEscalationCount?: number | null;
        /**
         * Proportion of conversations that was handed off from virtual agent to human agent.
         */
        dialogflowConversationsEscalationRatio?: number | null;
        /**
         * Proportion of dialogflow interactions that has empty input.
         */
        dialogflowInteractionsNoInputRatio?: number | null;
        /**
         * Proportion of dialogflow interactions that has no intent match for the input.
         */
        dialogflowInteractionsNoMatchRatio?: number | null;
        /**
         * Proportion of dialogflow webhook calls that failed.
         */
        dialogflowWebhookFailureRatio?: number | null;
        /**
         * Proportion of dialogflow webhook calls that timed out.
         */
        dialogflowWebhookTimeoutRatio?: number | null;
        /**
         * Proportion of knowledge assist (Proactive Generative Knowledge Assist) queries that had negative feedback.
         */
        knowledgeAssistNegativeFeedbackRatio?: number | null;
        /**
         * Proportion of knowledge assist (Proactive Generative Knowledge Assist) queries that had positive feedback.
         */
        knowledgeAssistPositiveFeedbackRatio?: number | null;
        /**
         * Count of knowledge assist results (Proactive Generative Knowledge Assist) shown to the user.
         */
        knowledgeAssistResultCount?: number | null;
        /**
         * Proportion of knowledge assist (Proactive Generative Knowledge Assist) queries that had a URL clicked.
         */
        knowledgeAssistUriClickRatio?: number | null;
        /**
         * Proportion of knowledge search (Generative Knowledge Assist) queries made by the agent compared to the total number of knowledge search queries made.
         */
        knowledgeSearchAgentQuerySourceRatio?: number | null;
        /**
         * Proportion of knowledge search (Generative Knowledge Assist) queries that had negative feedback.
         */
        knowledgeSearchNegativeFeedbackRatio?: number | null;
        /**
         * Proportion of knowledge search (Generative Knowledge Assist) queries that had positive feedback.
         */
        knowledgeSearchPositiveFeedbackRatio?: number | null;
        /**
         * Count of knowledge search results (Generative Knowledge Assist) shown to the user.
         */
        knowledgeSearchResultCount?: number | null;
        /**
         * Proportion of knowledge search (Generative Knowledge Assist) queries suggested compared to the total number of knowledge search queries made.
         */
        knowledgeSearchSuggestedQuerySourceRatio?: number | null;
        /**
         * Proportion of knowledge search (Generative Knowledge Assist) queries that had a URL clicked.
         */
        knowledgeSearchUriClickRatio?: number | null;
        /**
         * Average QA normalized score for all the tags.
         */
        qaTagScores?: Schema$GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointConversationMeasureQaTagScore[];
        /**
         * Proportion of summarization suggestions that were manually edited.
         */
        summarizationSuggestionEditRatio?: number | null;
        /**
         * Count of summarization suggestions results.
         */
        summarizationSuggestionResultCount?: number | null;
    }
    /**
     * Average QA normalized score for the tag.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointConversationMeasureQaTagScore {
        /**
         * Average tag normalized score per tag.
         */
        averageTagNormalizedScore?: number | null;
        /**
         * Tag name.
         */
        tag?: string | null;
    }
    /**
     * The measure related to dialogflow interactions.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointDialogflowInteractionMeasure {
        /**
         * The percentile result for audio in audio out latency in milliseconds per dialogflow interaction level.
         */
        percentileAudioInAudioOutLatency?: Schema$GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointPercentileResult;
        /**
         * The percentile result for end to end chat latency in milliseconds per dialogflow interaction level.
         */
        percentileEndToEndLatency?: Schema$GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointPercentileResult;
        /**
         * The percentile result for LLM latency in milliseconds per dialogflow interaction level.
         */
        percentileLlmCallLatency?: Schema$GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointPercentileResult;
        /**
         * The percentile result for tool use latency in milliseconds per dialogflow interaction level.
         */
        percentileToolUseLatency?: Schema$GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointPercentileResult;
        /**
         * The percentile result for TTS latency in milliseconds per dialogflow interaction level.
         */
        percentileTtsLatency?: Schema$GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointPercentileResult;
    }
    /**
     * The percentile result. Currently supported percentiles are 50th, 90th, and 99th.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPointPercentileResult {
        /**
         * The 50th percentile value.
         */
        p50?: number | null;
        /**
         * The 90th percentile value.
         */
        p90?: number | null;
        /**
         * The 99th percentile value.
         */
        p99?: number | null;
    }
    /**
     * A time series of metric values.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceTimeSeries {
        /**
         * The data points that make up the time series .
         */
        dataPoints?: Schema$GoogleCloudContactcenterinsightsV1alpha1QueryMetricsResponseSliceDataPoint[];
    }
    /**
     * The metadata for querying performance overview.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1QueryPerformanceOverviewMetadata {
    }
    /**
     * The response for querying performance overview.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1QueryPerformanceOverviewResponse {
        /**
         * The summary text of the performance.
         */
        summaryText?: string | null;
    }
    /**
     * DLP resources used for redaction while ingesting conversations. DLP settings are applied to conversations ingested from the `UploadConversation` and `IngestConversations` endpoints, including conversation coming from CCAI Platform. They are not applied to conversations ingested from the `CreateConversation` endpoint or the Dialogflow / Agent Assist runtime integrations. When using Dialogflow / Agent Assist runtime integrations, redaction should be performed in Dialogflow / Agent Assist.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1RedactionConfig {
        /**
         * The fully-qualified DLP deidentify template resource name. Format: `projects/{project\}/deidentifyTemplates/{template\}`
         */
        deidentifyTemplate?: string | null;
        /**
         * The fully-qualified DLP inspect template resource name. Format: `projects/{project\}/locations/{location\}/inspectTemplates/{template\}`
         */
        inspectTemplate?: string | null;
    }
    /**
     * An annotation that was generated during the customer and agent interaction.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1RuntimeAnnotation {
        /**
         * The unique identifier of the annotation. Format: projects/{project\}/locations/{location\}/conversationDatasets/{dataset\}/conversationDataItems/{data_item\}/conversationAnnotations/{annotation\}
         */
        annotationId?: string | null;
        /**
         * The feedback that the customer has about the answer in `data`.
         */
        answerFeedback?: Schema$GoogleCloudContactcenterinsightsV1alpha1AnswerFeedback;
        /**
         * Agent Assist Article Suggestion data.
         */
        articleSuggestion?: Schema$GoogleCloudContactcenterinsightsV1alpha1ArticleSuggestionData;
        /**
         * Conversation summarization suggestion data.
         */
        conversationSummarizationSuggestion?: Schema$GoogleCloudContactcenterinsightsV1alpha1ConversationSummarizationSuggestionData;
        /**
         * The time at which this annotation was created.
         */
        createTime?: string | null;
        /**
         * Dialogflow interaction data.
         */
        dialogflowInteraction?: Schema$GoogleCloudContactcenterinsightsV1alpha1DialogflowInteractionData;
        /**
         * The boundary in the conversation where the annotation ends, inclusive.
         */
        endBoundary?: Schema$GoogleCloudContactcenterinsightsV1alpha1AnnotationBoundary;
        /**
         * Agent Assist FAQ answer data.
         */
        faqAnswer?: Schema$GoogleCloudContactcenterinsightsV1alpha1FaqAnswerData;
        /**
         * Agent Assist Smart Compose suggestion data.
         */
        smartComposeSuggestion?: Schema$GoogleCloudContactcenterinsightsV1alpha1SmartComposeSuggestionData;
        /**
         * Agent Assist Smart Reply data.
         */
        smartReply?: Schema$GoogleCloudContactcenterinsightsV1alpha1SmartReplyData;
        /**
         * The boundary in the conversation where the annotation starts, inclusive.
         */
        startBoundary?: Schema$GoogleCloudContactcenterinsightsV1alpha1AnnotationBoundary;
        /**
         * Explicit input used for generating the answer
         */
        userInput?: Schema$GoogleCloudContactcenterinsightsV1alpha1RuntimeAnnotationUserInput;
    }
    /**
     * Explicit input used for generating the answer
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1RuntimeAnnotationUserInput {
        /**
         * The resource name of associated generator. Format: `projects//locations//generators/`
         */
        generatorName?: string | null;
        /**
         * Query text. Article Search uses this to store the input query used to generate the search results.
         */
        query?: string | null;
        /**
         * Query source for the answer.
         */
        querySource?: string | null;
    }
    /**
     * The metadata for an SampleConversations operation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1SampleConversationsMetadata {
        /**
         * Output only. The time the operation was created.
         */
        createTime?: string | null;
        /**
         * Output only. The time the operation finished running.
         */
        endTime?: string | null;
        /**
         * Output only. Partial errors during sample conversations operation that might cause the operation output to be incomplete.
         */
        partialErrors?: Schema$GoogleRpcStatus[];
        /**
         * Output only. The original request for sample conversations to dataset.
         */
        request?: Schema$GoogleCloudContactcenterinsightsV1alpha1SampleConversationsRequest;
        /**
         * Output only. Statistics for SampleConversations operation.
         */
        sampleConversationsStats?: Schema$GoogleCloudContactcenterinsightsV1alpha1SampleConversationsMetadataSampleConversationsStats;
    }
    /**
     * Statistics for SampleConversations operation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1SampleConversationsMetadataSampleConversationsStats {
        /**
         * Output only. The number of objects which were unable to be sampled due to errors. The errors are populated in the partial_errors field.
         */
        failedSampleCount?: number | null;
        /**
         * Output only. The number of new conversations added during this sample operation.
         */
        successfulSampleCount?: number | null;
    }
    /**
     * The request to sample conversations to a dataset.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1SampleConversationsRequest {
        /**
         * The dataset resource to copy the sampled conversations to.
         */
        destinationDataset?: Schema$GoogleCloudContactcenterinsightsV1alpha1Dataset;
        /**
         * Required. The parent resource of the dataset.
         */
        parent?: string | null;
        /**
         * Optional. The sample rule used for sampling conversations.
         */
        sampleRule?: Schema$GoogleCloudContactcenterinsightsV1alpha1SampleRule;
    }
    /**
     * The response to an SampleConversations operation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1SampleConversationsResponse {
    }
    /**
     * Message for sampling conversations.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1SampleRule {
        /**
         * To specify the filter for the conversions that should apply this sample rule. An empty filter means this sample rule applies to all conversations.
         */
        conversationFilter?: string | null;
        /**
         * Optional. Group by dimension to sample the conversation. If no dimension is provided, the sampling will be applied to the project level. Current supported dimensions is 'quality_metadata.agent_info.agent_id'.
         */
        dimension?: string | null;
        /**
         * Percentage of conversations that we should sample based on the dimension between [0, 100].
         */
        samplePercentage?: number | null;
        /**
         * Number of the conversations that we should sample based on the dimension.
         */
        sampleRow?: string | null;
    }
    /**
     * The data for a sentiment annotation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1SentimentData {
        /**
         * A non-negative number from 0 to infinity which represents the absolute magnitude of sentiment regardless of score.
         */
        magnitude?: number | null;
        /**
         * The sentiment score between -1.0 (negative) and 1.0 (positive).
         */
        score?: number | null;
    }
    /**
     * The data for a silence annotation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1SilenceData {
    }
    /**
     * Agent Assist Smart Compose suggestion data.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1SmartComposeSuggestionData {
        /**
         * The system's confidence score that this suggestion is a good match for this conversation, ranging from 0.0 (completely uncertain) to 1.0 (completely certain).
         */
        confidenceScore?: number | null;
        /**
         * Map that contains metadata about the Smart Compose suggestion and the document from which it originates.
         */
        metadata?: {
            [key: string]: string;
        } | null;
        /**
         * The name of the answer record. Format: projects/{project\}/locations/{location\}/answerRecords/{answer_record\}
         */
        queryRecord?: string | null;
        /**
         * The content of the suggestion.
         */
        suggestion?: string | null;
    }
    /**
     * Agent Assist Smart Reply data.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1SmartReplyData {
        /**
         * The system's confidence score that this reply is a good match for this conversation, ranging from 0.0 (completely uncertain) to 1.0 (completely certain).
         */
        confidenceScore?: number | null;
        /**
         * Map that contains metadata about the Smart Reply and the document from which it originates.
         */
        metadata?: {
            [key: string]: string;
        } | null;
        /**
         * The name of the answer record. Format: projects/{project\}/locations/{location\}/answerRecords/{answer_record\}
         */
        queryRecord?: string | null;
        /**
         * The content of the reply.
         */
        reply?: string | null;
    }
    /**
     * Speech-to-Text configuration. Speech-to-Text settings are applied to conversations ingested from the `UploadConversation` and `IngestConversations` endpoints, including conversation coming from CCAI Platform. They are not applied to conversations ingested from the `CreateConversation` endpoint.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1SpeechConfig {
        /**
         * Whether to disable word time offsets. If true, the `enable_word_time_offsets` field in the recognition config will be set to false.
         */
        disableWordTimeOffsets?: boolean | null;
        /**
         * The fully-qualified Speech Recognizer resource name. Format: `projects/{project_id\}/locations/{location\}/recognizer/{recognizer\}`
         */
        speechRecognizer?: string | null;
    }
    /**
     * Metadata for testing correlation config.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1TestCorrelationConfigMetadata {
        /**
         * Output only. The time the operation was created.
         */
        createTime?: string | null;
        /**
         * The dataset used for sampling conversations.
         */
        dataset?: string | null;
        /**
         * The statistics for the operation.
         */
        stats?: Schema$GoogleCloudContactcenterinsightsV1alpha1TestCorrelationConfigMetadataFullConversationCorrelationStats;
    }
    /**
     * Statistics for TestCorrelationConfig operation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1TestCorrelationConfigMetadataFullConversationCorrelationStats {
        /**
         * A list of errors that occurred during correlation, one for each conversation that failed.
         */
        conversationCorrelationErrors?: Schema$GoogleCloudContactcenterinsightsV1alpha1TestCorrelationConfigMetadataFullConversationCorrelationStatsConversationCorrelationError[];
        /**
         * The number of conversations correlated.
         */
        correlatedConversationsCount?: number | null;
        /**
         * The number of conversations that failed correlation.
         */
        failedConversationsCount?: number | null;
        /**
         * Partial errors during test correlation config operation that might cause the operation output to be incomplete.
         */
        partialErrors?: Schema$GoogleRpcStatus[];
        /**
         * The number of conversations sampled.
         */
        sampledConversationsCount?: number | null;
    }
    /**
     * An error that occurred during correlation for a specific conversation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1TestCorrelationConfigMetadataFullConversationCorrelationStatsConversationCorrelationError {
        /**
         * The conversation resource name that had an error during correlation.
         */
        conversation?: string | null;
        /**
         * The error status.
         */
        status?: Schema$GoogleRpcStatus;
    }
    /**
     * The response of testing correlation config.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1TestCorrelationConfigResponse {
        /**
         * Results for the DETAILED_SYNC execution mode.
         */
        detailedResults?: Schema$GoogleCloudContactcenterinsightsV1alpha1TestCorrelationConfigResponseDetailedCorrelationResults;
        /**
         * Partial errors during test correlation config operation that might cause the operation output to be incomplete.
         */
        partialErrors?: Schema$GoogleRpcStatus[];
    }
    /**
     * Wrapper for detailed, step-by-step results.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1TestCorrelationConfigResponseDetailedCorrelationResults {
        /**
         * A list of constraint evaluation results for each pair of conversations.
         */
        constraintResults?: Schema$GoogleCloudContactcenterinsightsV1alpha1ConstraintEvaluationResult[];
        /**
         * A list of join key correlation results for each conversation tested.
         */
        joinKeyResults?: Schema$GoogleCloudContactcenterinsightsV1alpha1ConversationCorrelationResult[];
    }
    /**
     * Metadata for undeploying an issue model.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1UndeployIssueModelMetadata {
        /**
         * Output only. The time the operation was created.
         */
        createTime?: string | null;
        /**
         * Output only. The time the operation finished running.
         */
        endTime?: string | null;
        /**
         * The original request for undeployment.
         */
        request?: Schema$GoogleCloudContactcenterinsightsV1alpha1UndeployIssueModelRequest;
    }
    /**
     * The request to undeploy an issue model.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1UndeployIssueModelRequest {
        /**
         * Required. The issue model to undeploy.
         */
        name?: string | null;
    }
    /**
     * The response to undeploy an issue model.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1UndeployIssueModelResponse {
    }
    /**
     * The metadata for updating a QaQuestionTag Resource.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1UpdateQaQuestionTagMetadata {
        /**
         * Output only. The time the operation was created.
         */
        createTime?: string | null;
        /**
         * Output only. The time the operation finished running.
         */
        endTime?: string | null;
        /**
         * Output only. The original request.
         */
        request?: Schema$GoogleCloudContactcenterinsightsV1alpha1UpdateQaQuestionTagRequest;
    }
    /**
     * The request for updating a QaQuestionTag.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1UpdateQaQuestionTagRequest {
        /**
         * Required. The QaQuestionTag to update.
         */
        qaQuestionTag?: Schema$GoogleCloudContactcenterinsightsV1alpha1QaQuestionTag;
        /**
         * Optional. The list of fields to be updated. All possible fields can be updated by passing `*`, or a subset of the following updateable fields can be provided: * `qa_question_tag_name` - the name of the tag * `qa_question_ids` - the list of questions the tag applies to
         */
        updateMask?: string | null;
    }
    /**
     * The metadata for an `UploadConversation` operation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1UploadConversationMetadata {
        /**
         * Output only. The operation name for a successfully created analysis operation, if any.
         */
        analysisOperation?: string | null;
        /**
         * Output only. The redaction config applied to the uploaded conversation.
         */
        appliedRedactionConfig?: Schema$GoogleCloudContactcenterinsightsV1alpha1RedactionConfig;
        /**
         * Output only. The time the operation was created.
         */
        createTime?: string | null;
        /**
         * Output only. The time the operation finished running.
         */
        endTime?: string | null;
        /**
         * Output only. The original request.
         */
        request?: Schema$GoogleCloudContactcenterinsightsV1alpha1UploadConversationRequest;
    }
    /**
     * Request to upload a conversation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1alpha1UploadConversationRequest {
        /**
         * Required. The conversation resource to create.
         */
        conversation?: Schema$GoogleCloudContactcenterinsightsV1alpha1Conversation;
        /**
         * Optional. A unique ID for the new conversation. This ID will become the final component of the conversation's resource name. If no ID is specified, a server-generated ID will be used. This value should be 4-64 characters and must match the regular expression `^[a-z0-9-]{4,64\}$`. Valid characters are `a-z-`
         */
        conversationId?: string | null;
        /**
         * Required. The parent resource of the conversation.
         */
        parent?: string | null;
        /**
         * Optional. DLP settings for transcript redaction. Will default to the config specified in Settings.
         */
        redactionConfig?: Schema$GoogleCloudContactcenterinsightsV1alpha1RedactionConfig;
        /**
         * Optional. Speech-to-Text configuration. Will default to the config specified in Settings.
         */
        speechConfig?: Schema$GoogleCloudContactcenterinsightsV1alpha1SpeechConfig;
    }
    /**
     * The analysis resource.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1Analysis {
        /**
         * Output only. The result of the analysis, which is populated when the analysis finishes.
         */
        analysisResult?: Schema$GoogleCloudContactcenterinsightsV1AnalysisResult;
        /**
         * To select the annotators to run and the phrase matchers to use (if any). If not specified, all annotators will be run.
         */
        annotatorSelector?: Schema$GoogleCloudContactcenterinsightsV1AnnotatorSelector;
        /**
         * Output only. The time at which the analysis was created, which occurs when the long-running operation completes.
         */
        createTime?: string | null;
        /**
         * Immutable. The resource name of the analysis. Format: projects/{project\}/locations/{location\}/conversations/{conversation\}/analyses/{analysis\}
         */
        name?: string | null;
        /**
         * Output only. The time at which the analysis was requested.
         */
        requestTime?: string | null;
    }
    /**
     * The result of an analysis.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1AnalysisResult {
        /**
         * Call-specific metadata created by the analysis.
         */
        callAnalysisMetadata?: Schema$GoogleCloudContactcenterinsightsV1AnalysisResultCallAnalysisMetadata;
        /**
         * The time at which the analysis ended.
         */
        endTime?: string | null;
    }
    /**
     * Call-specific metadata created during analysis.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1AnalysisResultCallAnalysisMetadata {
        /**
         * A list of call annotations that apply to this call.
         */
        annotations?: Schema$GoogleCloudContactcenterinsightsV1CallAnnotation[];
        /**
         * All the entities in the call.
         */
        entities?: {
            [key: string]: Schema$GoogleCloudContactcenterinsightsV1Entity;
        } | null;
        /**
         * All the matched intents in the call.
         */
        intents?: {
            [key: string]: Schema$GoogleCloudContactcenterinsightsV1Intent;
        } | null;
        /**
         * Overall conversation-level issue modeling result.
         */
        issueModelResult?: Schema$GoogleCloudContactcenterinsightsV1IssueModelResult;
        /**
         * All the matched phrase matchers in the call.
         */
        phraseMatchers?: {
            [key: string]: Schema$GoogleCloudContactcenterinsightsV1PhraseMatchData;
        } | null;
        /**
         * Results of scoring QaScorecards.
         */
        qaScorecardResults?: Schema$GoogleCloudContactcenterinsightsV1QaScorecardResult[];
        /**
         * Overall conversation-level sentiment for each channel of the call.
         */
        sentiments?: Schema$GoogleCloudContactcenterinsightsV1ConversationLevelSentiment[];
        /**
         * Overall conversation-level silence during the call.
         */
        silence?: Schema$GoogleCloudContactcenterinsightsV1ConversationLevelSilence;
    }
    /**
     * The CCAI Insights project wide analysis rule. This rule will be applied to all conversations that match the filter defined in the rule. For a conversation matches the filter, the annotators specified in the rule will be run. If a conversation matches multiple rules, a union of all the annotators will be run. One project can have multiple analysis rules.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1AnalysisRule {
        /**
         * If true, apply this rule to conversations. Otherwise, this rule is inactive and saved as a draft.
         */
        active?: boolean | null;
        /**
         * Percentage of conversations that we should apply this analysis setting automatically, between [0, 1]. For example, 0.1 means 10%. Conversations are sampled in a determenestic way. The original runtime_percentage & upload percentage will be replaced by defining filters on the conversation.
         */
        analysisPercentage?: number | null;
        /**
         * Selector of annotators to run and the phrase matchers to use for conversations that matches the conversation_filter. If not specified, NO annotators will be run.
         */
        annotatorSelector?: Schema$GoogleCloudContactcenterinsightsV1AnnotatorSelector;
        /**
         * Filter for the conversations that should apply this analysis rule. An empty filter means this analysis rule applies to all conversations. Refer to https://cloud.google.com/contact-center/insights/docs/filtering for details.
         */
        conversationFilter?: string | null;
        /**
         * Output only. The time at which this analysis rule was created.
         */
        createTime?: string | null;
        /**
         * Display Name of the analysis rule.
         */
        displayName?: string | null;
        /**
         * Identifier. The resource name of the analysis rule. Format: projects/{project\}/locations/{location\}/analysisRules/{analysis_rule\}
         */
        name?: string | null;
        /**
         * Output only. The most recent time at which this analysis rule was updated.
         */
        updateTime?: string | null;
    }
    /**
     * A point in a conversation that marks the start or the end of an annotation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1AnnotationBoundary {
        /**
         * The index in the sequence of transcribed pieces of the conversation where the boundary is located. This index starts at zero.
         */
        transcriptIndex?: number | null;
        /**
         * The word index of this boundary with respect to the first word in the transcript piece. This index starts at zero.
         */
        wordIndex?: number | null;
    }
    /**
     * Selector of all available annotators and phrase matchers to run.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1AnnotatorSelector {
        /**
         * The issue model to run. If not provided, the most recently deployed topic model will be used. The provided issue model will only be used for inference if the issue model is deployed and if run_issue_model_annotator is set to true. If more than one issue model is provided, only the first provided issue model will be used for inference.
         */
        issueModels?: string[] | null;
        /**
         * The list of phrase matchers to run. If not provided, all active phrase matchers will be used. If inactive phrase matchers are provided, they will not be used. Phrase matchers will be run only if run_phrase_matcher_annotator is set to true. Format: projects/{project\}/locations/{location\}/phraseMatchers/{phrase_matcher\}
         */
        phraseMatchers?: string[] | null;
        /**
         * Configuration for the QA annotator.
         */
        qaConfig?: Schema$GoogleCloudContactcenterinsightsV1AnnotatorSelectorQaConfig;
        /**
         * Whether to run the entity annotator.
         */
        runEntityAnnotator?: boolean | null;
        /**
         * Whether to run the intent annotator.
         */
        runIntentAnnotator?: boolean | null;
        /**
         * Whether to run the interruption annotator.
         */
        runInterruptionAnnotator?: boolean | null;
        /**
         * Whether to run the issue model annotator. A model should have already been deployed for this to take effect.
         */
        runIssueModelAnnotator?: boolean | null;
        /**
         * Whether to run the active phrase matcher annotator(s).
         */
        runPhraseMatcherAnnotator?: boolean | null;
        /**
         * Whether to run the QA annotator.
         */
        runQaAnnotator?: boolean | null;
        /**
         * Whether to run the sentiment annotator.
         */
        runSentimentAnnotator?: boolean | null;
        /**
         * Whether to run the silence annotator.
         */
        runSilenceAnnotator?: boolean | null;
        /**
         * Whether to run the summarization annotator.
         */
        runSummarizationAnnotator?: boolean | null;
        /**
         * Configuration for the summarization annotator.
         */
        summarizationConfig?: Schema$GoogleCloudContactcenterinsightsV1AnnotatorSelectorSummarizationConfig;
    }
    /**
     * Configuration for the QA feature.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1AnnotatorSelectorQaConfig {
        /**
         * A manual list of scorecards to score.
         */
        scorecardList?: Schema$GoogleCloudContactcenterinsightsV1AnnotatorSelectorQaConfigScorecardList;
    }
    /**
     * Container for a list of scorecards.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1AnnotatorSelectorQaConfigScorecardList {
        /**
         * List of QaScorecardRevisions.
         */
        qaScorecardRevisions?: string[] | null;
    }
    /**
     * Configuration for summarization.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1AnnotatorSelectorSummarizationConfig {
        /**
         * Resource name of the Dialogflow conversation profile. Format: projects/{project\}/locations/{location\}/conversationProfiles/{conversation_profile\}
         */
        conversationProfile?: string | null;
        /**
         * The resource name of the existing created generator. Format: projects//locations//generators/
         */
        generator?: string | null;
        /**
         * Default summarization model to be used.
         */
        summarizationModel?: string | null;
    }
    /**
     * The feedback that the customer has about a certain answer in the conversation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1AnswerFeedback {
        /**
         * Indicates whether an answer or item was clicked by the human agent.
         */
        clicked?: boolean | null;
        /**
         * The correctness level of an answer.
         */
        correctnessLevel?: string | null;
        /**
         * Indicates whether an answer or item was displayed to the human agent in the agent desktop UI.
         */
        displayed?: boolean | null;
    }
    /**
     * The message to appeal an assessment.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1AppealAssessmentRequest {
    }
    /**
     * Agent Assist Article Suggestion data.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1ArticleSuggestionData {
        /**
         * The system's confidence score that this article is a good match for this conversation, ranging from 0.0 (completely uncertain) to 1.0 (completely certain).
         */
        confidenceScore?: number | null;
        /**
         * Map that contains metadata about the Article Suggestion and the document that it originates from.
         */
        metadata?: {
            [key: string]: string;
        } | null;
        /**
         * The name of the answer record. Format: projects/{project\}/locations/{location\}/answerRecords/{answer_record\}
         */
        queryRecord?: string | null;
        /**
         * The knowledge document that this answer was extracted from. Format: projects/{project\}/knowledgeBases/{knowledge_base\}/documents/{document\}
         */
        source?: string | null;
        /**
         * Article title.
         */
        title?: string | null;
        /**
         * Article URI.
         */
        uri?: string | null;
    }
    /**
     * The assessment resource.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1Assessment {
        /**
         * Information about the agent the assessment is for.
         */
        agentInfo?: Schema$GoogleCloudContactcenterinsightsV1ConversationQualityMetadataAgentInfo;
        /**
         * Output only. The time at which the assessment was created.
         */
        createTime?: string | null;
        /**
         * Identifier. The resource name of the assessment. Format: projects/{project\}/locations/{location\}/conversations/{conversation\}/assessments/{assessment\}
         */
        name?: string | null;
        /**
         * Output only. The state of the assessment.
         */
        state?: string | null;
        /**
         * Output only. The time at which the assessment was last updated.
         */
        updateTime?: string | null;
    }
    /**
     * The CCAI Insights project wide assessment rule. This assessment rule will be applied to all conversations from the previous sampling cycle that match the sample rule defined in the assessment rule. One project can have multiple assessment rules.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1AssessmentRule {
        /**
         * If true, apply this rule to conversations. Otherwise, this rule is inactive.
         */
        active?: boolean | null;
        /**
         * Output only. The time at which this assessment rule was created.
         */
        createTime?: string | null;
        /**
         * Display Name of the assessment rule.
         */
        displayName?: string | null;
        /**
         * Identifier. The resource name of the assessment rule. Format: projects/{project\}/locations/{location\}/assessmentRules/{assessment_rule\}
         */
        name?: string | null;
        /**
         * The sample rule for the assessment rule.
         */
        sampleRule?: Schema$GoogleCloudContactcenterinsightsV1SampleRule;
        /**
         * Schedule info for the assessment rule.
         */
        scheduleInfo?: Schema$GoogleCloudContactcenterinsightsV1ScheduleInfo;
        /**
         * Output only. The most recent time at which this assessment rule was updated.
         */
        updateTime?: string | null;
    }
    /**
     * An AuthorizedView represents a view of accessible Insights resources (for example, Conversation and Scorecard). Who have read access to the AuthorizedView resource will have access to these Insight resources as well.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1AuthorizedView {
        /**
         * A filter to reduce conversation results to a specific subset. The AuthorizedView's assigned permission (read/write) could be applied to the subset of conversations. If conversation_filter is empty, there is no restriction on the conversations that the AuthorizedView can access. Having *authorizedViews.get* access to the AuthorizedView means having the same read/write access to the Conversations (as well as metadata/annotations linked to the conversation) that this AuthorizedView has.
         */
        conversationFilter?: string | null;
        /**
         * Output only. The time at which the authorized view was created.
         */
        createTime?: string | null;
        /**
         * Display Name. Limit 64 characters.
         */
        displayName?: string | null;
        /**
         * Identifier. The resource name of the AuthorizedView. Format: projects/{project\}/locations/{location\}/authorizedViewSets/{authorized_view_set\}/authorizedViews/{authorized_view\}
         */
        name?: string | null;
        /**
         * Output only. The most recent time at which the authorized view was updated.
         */
        updateTime?: string | null;
    }
    /**
     * An AuthorizedViewSet contains a set of AuthorizedView resources.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1AuthorizedViewSet {
        /**
         * Output only. Create time.
         */
        createTime?: string | null;
        /**
         * Display Name. Limit 64 characters.
         */
        displayName?: string | null;
        /**
         * Identifier. The resource name of the AuthorizedViewSet. Format: projects/{project\}/locations/{location\}/authorizedViewSets/{authorized_view_set\}
         */
        name?: string | null;
        /**
         * Output only. Update time.
         */
        updateTime?: string | null;
    }
    /**
     * Rule for auto-labeling conversations.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1AutoLabelingRule {
        /**
         * Whether the rule is active.
         */
        active?: boolean | null;
        /**
         * Conditions to apply for auto-labeling the label_key. Representing sequential block of if .. else if .. else statements. The value of the first matching condition will be used.
         */
        conditions?: Schema$GoogleCloudContactcenterinsightsV1AutoLabelingRuleLabelingCondition[];
        /**
         * Output only. The time at which this rule was created.
         */
        createTime?: string | null;
        /**
         * The description of the rule.
         */
        description?: string | null;
        /**
         * The user-provided display name of the rule.
         */
        displayName?: string | null;
        /**
         * The label key. This is also the {auto_labeling_rule\} in the resource name. Only settable if label_key_type is LABEL_KEY_TYPE_CUSTOM.
         */
        labelKey?: string | null;
        /**
         * The type of the label key.
         */
        labelKeyType?: string | null;
        /**
         * Identifier. The resource name of the auto-labeling rule. Format: projects/{project\}/locations/{location\}/autoLabelingRules/{auto_labeling_rule\}
         */
        name?: string | null;
        /**
         * Output only. The most recent time at which the rule was updated.
         */
        updateTime?: string | null;
    }
    /**
     * Condition for auto-labeling conversations.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1AutoLabelingRuleLabelingCondition {
        /**
         * A optional CEL expression to be evaluated as a boolean value. Once evaluated as true, then we will proceed with the value evaluation. An empty condition will be auto evaluated as true.
         */
        condition?: string | null;
        /**
         * CEL expression to be evaluated as the value.
         */
        value?: string | null;
    }
    /**
     * The metadata for a bulk analyze conversations operation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1BulkAnalyzeConversationsMetadata {
        /**
         * The number of requested analyses that have completed successfully so far.
         */
        completedAnalysesCount?: number | null;
        /**
         * The time the operation was created.
         */
        createTime?: string | null;
        /**
         * The time the operation finished running.
         */
        endTime?: string | null;
        /**
         * The number of requested analyses that have failed so far.
         */
        failedAnalysesCount?: number | null;
        /**
         * Output only. Partial errors during bulk analyze operation that might cause the operation output to be incomplete.
         */
        partialErrors?: Schema$GoogleRpcStatus[];
        /**
         * The original request for bulk analyze.
         */
        request?: Schema$GoogleCloudContactcenterinsightsV1BulkAnalyzeConversationsRequest;
        /**
         * Total number of analyses requested. Computed by the number of conversations returned by `filter` multiplied by `analysis_percentage` in the request.
         */
        totalRequestedAnalysesCount?: number | null;
    }
    /**
     * The request to analyze conversations in bulk.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1BulkAnalyzeConversationsRequest {
        /**
         * Required. Percentage of selected conversation to analyze, between [0, 100].
         */
        analysisPercentage?: number | null;
        /**
         * To select the annotators to run and the phrase matchers to use (if any). If not specified, all annotators will be run.
         */
        annotatorSelector?: Schema$GoogleCloudContactcenterinsightsV1AnnotatorSelector;
        /**
         * Required. Filter used to select the subset of conversations to analyze.
         */
        filter?: string | null;
        /**
         * Required. The parent resource to create analyses in.
         */
        parent?: string | null;
    }
    /**
     * The response for a bulk analyze conversations operation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1BulkAnalyzeConversationsResponse {
        /**
         * Count of failed analyses.
         */
        failedAnalysisCount?: number | null;
        /**
         * Count of successful analyses.
         */
        successfulAnalysisCount?: number | null;
    }
    /**
     * The metadata for a bulk delete conversations operation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1BulkDeleteConversationsMetadata {
        /**
         * The time the operation was created.
         */
        createTime?: string | null;
        /**
         * The time the operation finished running.
         */
        endTime?: string | null;
        /**
         * Partial errors during bulk delete conversations operation that might cause the operation output to be incomplete.
         */
        partialErrors?: Schema$GoogleRpcStatus[];
        /**
         * The original request for bulk delete.
         */
        request?: Schema$GoogleCloudContactcenterinsightsV1BulkDeleteConversationsRequest;
    }
    /**
     * The request to delete conversations in bulk.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1BulkDeleteConversationsRequest {
        /**
         * Filter used to select the subset of conversations to delete.
         */
        filter?: string | null;
        /**
         * If set to true, all of this conversation's analyses will also be deleted. Otherwise, the request will only succeed if the conversation has no analyses.
         */
        force?: boolean | null;
        /**
         * Maximum number of conversations to delete.
         */
        maxDeleteCount?: number | null;
        /**
         * Required. The parent resource to delete conversations from. Format: projects/{project\}/locations/{location\}
         */
        parent?: string | null;
    }
    /**
     * The response for a bulk delete conversations operation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1BulkDeleteConversationsResponse {
    }
    /**
     * Metadata for the BulkDeleteFeedbackLabels endpoint.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1BulkDeleteFeedbackLabelsMetadata {
        /**
         * Partial errors during deletion operation that might cause the operation output to be incomplete.
         */
        partialErrors?: Schema$GoogleRpcStatus[];
        /**
         * Output only. The original request for delete.
         */
        request?: Schema$GoogleCloudContactcenterinsightsV1BulkDeleteFeedbackLabelsRequest;
    }
    /**
     * Request for the BulkDeleteFeedbackLabels endpoint.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1BulkDeleteFeedbackLabelsRequest {
        /**
         * Optional. A filter to reduce results to a specific subset. Supports disjunctions (OR) and conjunctions (AND). Supported fields: * `issue_model_id` * `qa_question_id` * `qa_scorecard_id` * `min_create_time` * `max_create_time` * `min_update_time` * `max_update_time` * `feedback_label_type`: QUALITY_AI, TOPIC_MODELING
         */
        filter?: string | null;
        /**
         * Required. The parent resource for new feedback labels.
         */
        parent?: string | null;
    }
    /**
     * Response for the BulkDeleteFeedbackLabels endpoint.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1BulkDeleteFeedbackLabelsResponse {
    }
    /**
     * Metadata for the BulkDownloadFeedbackLabel endpoint.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsMetadata {
        /**
         * Output only. The time the operation was created.
         */
        createTime?: string | null;
        /**
         * Output only. Statistics for BulkDownloadFeedbackLabels operation.
         */
        downloadStats?: Schema$GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsMetadataDownloadStats;
        /**
         * Output only. The time the operation finished running.
         */
        endTime?: string | null;
        /**
         * Partial errors during ingest operation that might cause the operation output to be incomplete.
         */
        partialErrors?: Schema$GoogleRpcStatus[];
        /**
         * Output only. The original request for download.
         */
        request?: Schema$GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsRequest;
    }
    /**
     * Statistics for BulkDownloadFeedbackLabels operation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsMetadataDownloadStats {
        /**
         * Output only. Full name of the files written to Cloud storage.
         */
        fileNames?: string[] | null;
        /**
         * The number of objects processed during the download operation.
         */
        processedObjectCount?: number | null;
        /**
         * The number of new feedback labels downloaded during this operation. Different from "processed" because some labels might not be downloaded because an error.
         */
        successfulDownloadCount?: number | null;
        /**
         * Total number of files written to the provided Cloud Storage bucket.
         */
        totalFilesWritten?: number | null;
    }
    /**
     * Request for the BulkDownloadFeedbackLabel endpoint.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsRequest {
        /**
         * Optional. Filter parent conversations to download feedback labels for. When specified, the feedback labels will be downloaded for the conversations that match the filter. If `template_qa_scorecard_id` is set, all the conversations that match the filter will be paired with the questions under the scorecard for labeling.
         */
        conversationFilter?: string | null;
        /**
         * Optional. The type of feedback labels that will be downloaded.
         */
        feedbackLabelType?: string | null;
        /**
         * Optional. A filter to reduce results to a specific subset. Supports disjunctions (OR) and conjunctions (AND). Supported fields: * `issue_model_id` * `qa_question_id` * `qa_scorecard_id` * `min_create_time` * `max_create_time` * `min_update_time` * `max_update_time` * `feedback_label_type`: QUALITY_AI, TOPIC_MODELING
         */
        filter?: string | null;
        /**
         * A cloud storage bucket destination.
         */
        gcsDestination?: Schema$GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsRequestGcsDestination;
        /**
         * Optional. Limits the maximum number of feedback labels that will be downloaded. The first `N` feedback labels will be downloaded.
         */
        maxDownloadCount?: number | null;
        /**
         * Required. The parent resource for new feedback labels.
         */
        parent?: string | null;
        /**
         * A sheets document destination.
         */
        sheetsDestination?: Schema$GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsRequestSheetsDestination;
        /**
         * Optional. If set, a template for labeling conversations and scorecard questions will be created from the conversation_filter and the questions under the scorecard(s). The feedback label `filter` will be ignored.
         */
        templateQaScorecardId?: string[] | null;
    }
    /**
     * Google Cloud Storage Object details to write the feedback labels to.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsRequestGcsDestination {
        /**
         * Optional. Add whitespace to the JSON file. Makes easier to read, but increases file size. Only applicable for JSON format.
         */
        addWhitespace?: boolean | null;
        /**
         * Optional. Always print fields with no presence. This is useful for printing fields that are not set, like implicit 0 value or empty lists/maps. Only applicable for JSON format.
         */
        alwaysPrintEmptyFields?: boolean | null;
        /**
         * Required. File format in which the labels will be exported.
         */
        format?: string | null;
        /**
         * Required. The Google Cloud Storage URI to write the feedback labels to. The file name will be used as a prefix for the files written to the bucket if the output needs to be split across multiple files, otherwise it will be used as is. The file extension will be appended to the file name based on the format selected. E.g. `gs://bucket_name/object_uri_prefix`
         */
        objectUri?: string | null;
        /**
         * Optional. The number of records per file. Applicable for either format.
         */
        recordsPerFileCount?: string | null;
    }
    /**
     * Google Sheets document details to write the feedback labels to.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsRequestSheetsDestination {
        /**
         * Optional. The title of the new sheet to write the feedback labels to.
         */
        sheetTitle?: string | null;
        /**
         * Required. The Google Sheets document to write the feedback labels to. Retrieved from Google Sheets URI. E.g. `https://docs.google.com/spreadsheets/d/1234567890` The spreadsheet must be shared with the Insights P4SA. The spreadsheet ID written to will be returned as `file_names` in the BulkDownloadFeedbackLabelsMetadata.
         */
        spreadsheetUri?: string | null;
    }
    /**
     * Response for the BulkDownloadFeedbackLabel endpoint.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsResponse {
    }
    /**
     * The request for bulk uploading feedback labels.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1BulkUploadFeedbackLabelsRequest {
        /**
         * A cloud storage bucket source.
         */
        gcsSource?: Schema$GoogleCloudContactcenterinsightsV1BulkUploadFeedbackLabelsRequestGcsSource;
        /**
         * A sheets document source.
         */
        sheetsSource?: Schema$GoogleCloudContactcenterinsightsV1BulkUploadFeedbackLabelsRequestSheetsSource;
        /**
         * Optional. If set, upload will not happen and the labels will be validated. If not set, then default behavior will be to upload the labels after validation is complete.
         */
        validateOnly?: boolean | null;
    }
    /**
     * Google Cloud Storage Object details to get the feedback label file from.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1BulkUploadFeedbackLabelsRequestGcsSource {
        /**
         * Required. File format which will be ingested.
         */
        format?: string | null;
        /**
         * Required. The Google Cloud Storage URI of the file to import. Format: `gs://bucket_name/object_name`
         */
        objectUri?: string | null;
    }
    /**
     * Google Sheets document details to get the feedback label file from.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1BulkUploadFeedbackLabelsRequestSheetsSource {
        /**
         * Required. The Google Sheets document to write the feedback labels to. Retrieved from Google Sheets URI. E.g. `https://docs.google.com/spreadsheets/d/1234567890` The spreadsheet must be shared with the Insights P4SA.
         */
        spreadsheetUri?: string | null;
    }
    /**
     * Response of querying an issue model's statistics.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1CalculateIssueModelStatsResponse {
        /**
         * The latest label statistics for the queried issue model. Includes results on both training data and data labeled after deployment.
         */
        currentStats?: Schema$GoogleCloudContactcenterinsightsV1IssueModelLabelStats;
    }
    /**
     * The request for calculating conversation statistics.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1CalculateStatsRequest {
        /**
         * A filter to reduce results to a specific subset. This field is useful for getting statistics about conversations with specific properties.
         */
        filter?: string | null;
    }
    /**
     * The response for calculating conversation statistics.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1CalculateStatsResponse {
        /**
         * The average duration of all conversations. The average is calculated using only conversations that have a time duration.
         */
        averageDuration?: string | null;
        /**
         * The average number of turns per conversation.
         */
        averageTurnCount?: number | null;
        /**
         * The total number of conversations.
         */
        conversationCount?: number | null;
        /**
         * A time series representing the count of conversations created over time that match that requested filter criteria.
         */
        conversationCountTimeSeries?: Schema$GoogleCloudContactcenterinsightsV1CalculateStatsResponseTimeSeries;
        /**
         * A map associating each custom highlighter resource name with its respective number of matches in the set of conversations.
         */
        customHighlighterMatches?: {
            [key: string]: number;
        } | null;
        /**
         * A map associating each issue resource name with its respective number of matches in the set of conversations. Key has the format: `projects//locations//issueModels//issues/` Deprecated, use `issue_matches_stats` field instead.
         */
        issueMatches?: {
            [key: string]: number;
        } | null;
        /**
         * A map associating each issue resource name with its respective number of matches in the set of conversations. Key has the format: `projects//locations//issueModels//issues/`
         */
        issueMatchesStats?: {
            [key: string]: Schema$GoogleCloudContactcenterinsightsV1IssueModelLabelStatsIssueStats;
        } | null;
        /**
         * A map associating each smart highlighter display name with its respective number of matches in the set of conversations.
         */
        smartHighlighterMatches?: {
            [key: string]: number;
        } | null;
    }
    /**
     * A time series representing conversations over time.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1CalculateStatsResponseTimeSeries {
        /**
         * The duration of each interval.
         */
        intervalDuration?: string | null;
        /**
         * An ordered list of intervals from earliest to latest, where each interval represents the number of conversations that transpired during the time window.
         */
        points?: Schema$GoogleCloudContactcenterinsightsV1CalculateStatsResponseTimeSeriesInterval[];
    }
    /**
     * A single interval in a time series.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1CalculateStatsResponseTimeSeriesInterval {
        /**
         * The number of conversations created in this interval.
         */
        conversationCount?: number | null;
        /**
         * The start time of this interval.
         */
        startTime?: string | null;
    }
    /**
     * A piece of metadata that applies to a window of a call.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1CallAnnotation {
        /**
         * The boundary in the conversation where the annotation ends, inclusive.
         */
        annotationEndBoundary?: Schema$GoogleCloudContactcenterinsightsV1AnnotationBoundary;
        /**
         * The boundary in the conversation where the annotation starts, inclusive.
         */
        annotationStartBoundary?: Schema$GoogleCloudContactcenterinsightsV1AnnotationBoundary;
        /**
         * The channel of the audio where the annotation occurs. For single-channel audio, this field is not populated.
         */
        channelTag?: number | null;
        /**
         * Data specifying an entity mention.
         */
        entityMentionData?: Schema$GoogleCloudContactcenterinsightsV1EntityMentionData;
        /**
         * Data specifying a hold.
         */
        holdData?: Schema$GoogleCloudContactcenterinsightsV1HoldData;
        /**
         * Data specifying an intent match.
         */
        intentMatchData?: Schema$GoogleCloudContactcenterinsightsV1IntentMatchData;
        /**
         * Data specifying an interruption.
         */
        interruptionData?: Schema$GoogleCloudContactcenterinsightsV1InterruptionData;
        /**
         * Data specifying an issue match.
         */
        issueMatchData?: Schema$GoogleCloudContactcenterinsightsV1IssueMatchData;
        /**
         * Data specifying a phrase match.
         */
        phraseMatchData?: Schema$GoogleCloudContactcenterinsightsV1PhraseMatchData;
        /**
         * Data specifying sentiment.
         */
        sentimentData?: Schema$GoogleCloudContactcenterinsightsV1SentimentData;
        /**
         * Data specifying silence.
         */
        silenceData?: Schema$GoogleCloudContactcenterinsightsV1SilenceData;
    }
    /**
     * The result of testing a constraint expression on a pair of conversations.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1ConstraintEvaluationResult {
        /**
         * The first conversation resource name.
         */
        conversationA?: string | null;
        /**
         * The second conversation resource name.
         */
        conversationB?: string | null;
        /**
         * The results for each applicable constraint rule.
         */
        ruleConstraintResults?: Schema$GoogleCloudContactcenterinsightsV1ConstraintEvaluationResultRuleConstraintResult[];
    }
    /**
     * The result of a single constraint rule on the pair of conversations.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1ConstraintEvaluationResultRuleConstraintResult {
        /**
         * Whether the constraint expression evaluated to true for (A, B) or (B, A).
         */
        constraintMet?: boolean | null;
        /**
         * The error status if the constraint expression failed to evaluate.
         */
        error?: Schema$GoogleRpcStatus;
        /**
         * The rule ID.
         */
        ruleId?: string | null;
    }
    /**
     * The conversation resource.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1Conversation {
        /**
         * An opaque, user-specified string representing the human agent who handled the conversation.
         */
        agentId?: string | null;
        /**
         * Call-specific metadata.
         */
        callMetadata?: Schema$GoogleCloudContactcenterinsightsV1ConversationCallMetadata;
        /**
         * Output only. Info for correlating across conversations.
         */
        correlationInfo?: Schema$GoogleCloudContactcenterinsightsV1ConversationCorrelationInfo;
        /**
         * Output only. The time at which the conversation was created.
         */
        createTime?: string | null;
        /**
         * The source of the audio and transcription for the conversation.
         */
        dataSource?: Schema$GoogleCloudContactcenterinsightsV1ConversationDataSource;
        /**
         * Output only. All the matched Dialogflow intents in the call. The key corresponds to a Dialogflow intent, format: projects/{project\}/agent/{agent\}/intents/{intent\}
         */
        dialogflowIntents?: {
            [key: string]: Schema$GoogleCloudContactcenterinsightsV1DialogflowIntent;
        } | null;
        /**
         * Output only. The duration of the conversation.
         */
        duration?: string | null;
        /**
         * The time at which this conversation should expire. After this time, the conversation data and any associated analyses will be deleted.
         */
        expireTime?: string | null;
        /**
         * A map for the user to specify any custom fields. A maximum of 100 labels per conversation is allowed, with a maximum of 256 characters per entry.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * A user-specified language code for the conversation.
         */
        languageCode?: string | null;
        /**
         * Output only. The conversation's latest analysis, if one exists.
         */
        latestAnalysis?: Schema$GoogleCloudContactcenterinsightsV1Analysis;
        /**
         * Output only. Latest summary of the conversation.
         */
        latestSummary?: Schema$GoogleCloudContactcenterinsightsV1ConversationSummarizationSuggestionData;
        /**
         * Immutable. The conversation medium.
         */
        medium?: string | null;
        /**
         * Input only. JSON metadata encoded as a string. This field is primarily used by Insights integrations with various telephony systems and must be in one of Insight's supported formats.
         */
        metadataJson?: string | null;
        /**
         * Immutable. The resource name of the conversation. Format: projects/{project\}/locations/{location\}/conversations/{conversation\}
         */
        name?: string | null;
        /**
         * Obfuscated user ID which the customer sent to us.
         */
        obfuscatedUserId?: string | null;
        /**
         * Conversation metadata related to quality management.
         */
        qualityMetadata?: Schema$GoogleCloudContactcenterinsightsV1ConversationQualityMetadata;
        /**
         * Output only. The annotations that were generated during the customer and agent interaction.
         */
        runtimeAnnotations?: Schema$GoogleCloudContactcenterinsightsV1RuntimeAnnotation[];
        /**
         * The time at which the conversation started.
         */
        startTime?: string | null;
        /**
         * Output only. The conversation transcript.
         */
        transcript?: Schema$GoogleCloudContactcenterinsightsV1ConversationTranscript;
        /**
         * Input only. The TTL for this resource. If specified, then this TTL will be used to calculate the expire time.
         */
        ttl?: string | null;
        /**
         * Output only. The number of turns in the conversation.
         */
        turnCount?: number | null;
        /**
         * Output only. The most recent time at which the conversation was updated.
         */
        updateTime?: string | null;
    }
    /**
     * Call-specific metadata.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1ConversationCallMetadata {
        /**
         * The audio channel that contains the agent.
         */
        agentChannel?: number | null;
        /**
         * The audio channel that contains the customer.
         */
        customerChannel?: number | null;
    }
    /**
     * Info for correlating across conversations.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1ConversationCorrelationInfo {
        /**
         * Output only. The correlation types of this conversation. A single conversation can have multiple correlation types. For example a conversation that only has a single segment is both a SEGMENT and a FULL_CONVERSATION.
         */
        correlationTypes?: string[] | null;
        /**
         * Output only. The full conversation correlation id this conversation is a segment of.
         */
        fullConversationCorrelationId?: string | null;
        /**
         * Output only. The full conversation correlation id this conversation is a merged conversation of.
         */
        mergedFullConversationCorrelationId?: string | null;
    }
    /**
     * The result of testing correlation config on a single conversation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1ConversationCorrelationResult {
        /**
         * The conversation resource name.
         */
        conversation?: string | null;
        /**
         * The results for each correlation rule.
         */
        ruleResults?: Schema$GoogleCloudContactcenterinsightsV1ConversationCorrelationResultRuleCorrelationResult[];
    }
    /**
     * The result of a single correlation rule.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1ConversationCorrelationResultRuleCorrelationResult {
        /**
         * The correlation ID generated by the join key expression.
         */
        correlationId?: string | null;
        /**
         * The error status if the join key expression failed to evaluate.
         */
        error?: Schema$GoogleRpcStatus;
        /**
         * The rule ID.
         */
        ruleId?: string | null;
    }
    /**
     * Options for configuring what metadata is included in the conversation data used in QAI and Discovery Engine.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1ConversationDataOptions {
        /**
         * Whether to include the per turn Dialogflow interaction data in conversation transcript.
         */
        includeDialogflowInteractionData?: boolean | null;
    }
    /**
     * The conversation source, which is a combination of transcript and audio.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1ConversationDataSource {
        /**
         * The source when the conversation comes from Dialogflow.
         */
        dialogflowSource?: Schema$GoogleCloudContactcenterinsightsV1DialogflowSource;
        /**
         * A Cloud Storage location specification for the audio and transcript.
         */
        gcsSource?: Schema$GoogleCloudContactcenterinsightsV1GcsSource;
        /**
         * Cloud Storage URI that points to a file that contains the conversation metadata.
         */
        metadataUri?: string | null;
    }
    /**
     * A wrapper for holding the audio for any given turn.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1ConversationDataSourceTurnLevelAudio {
        /**
         * The duration of the audio.
         */
        audioDuration?: string | null;
        /**
         * The Cloud Storage URI of the audio for any given turn.
         */
        audioGcsUri?: string | null;
    }
    /**
     * One channel of conversation-level sentiment data.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1ConversationLevelSentiment {
        /**
         * The channel of the audio that the data applies to.
         */
        channelTag?: number | null;
        /**
         * Data specifying sentiment.
         */
        sentimentData?: Schema$GoogleCloudContactcenterinsightsV1SentimentData;
    }
    /**
     * Conversation-level silence data.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1ConversationLevelSilence {
        /**
         * Amount of time calculated to be in silence.
         */
        silenceDuration?: string | null;
        /**
         * Percentage of the total conversation spent in silence.
         */
        silencePercentage?: number | null;
    }
    /**
     * The call participant speaking for a given utterance.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1ConversationParticipant {
        /**
         * Deprecated. Use `dialogflow_participant_name` instead. The name of the Dialogflow participant. Format: projects/{project\}/locations/{location\}/conversations/{conversation\}/participants/{participant\}
         */
        dialogflowParticipant?: string | null;
        /**
         * The name of the participant provided by Dialogflow. Format: projects/{project\}/locations/{location\}/conversations/{conversation\}/participants/{participant\}
         */
        dialogflowParticipantName?: string | null;
        /**
         * Obfuscated user ID from Dialogflow.
         */
        obfuscatedExternalUserId?: string | null;
        /**
         * The role of the participant.
         */
        role?: string | null;
        /**
         * A user-specified ID representing the participant.
         */
        userId?: string | null;
    }
    /**
     * Conversation metadata related to quality management.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1ConversationQualityMetadata {
        /**
         * Information about agents involved in the call.
         */
        agentInfo?: Schema$GoogleCloudContactcenterinsightsV1ConversationQualityMetadataAgentInfo[];
        /**
         * An arbitrary integer value indicating the customer's satisfaction rating.
         */
        customerSatisfactionRating?: number | null;
        /**
         * Input only. The feedback labels associated with the conversation.
         */
        feedbackLabels?: Schema$GoogleCloudContactcenterinsightsV1FeedbackLabel[];
        /**
         * An arbitrary string value specifying the menu path the customer took.
         */
        menuPath?: string | null;
        /**
         * The amount of time the customer waited to connect with an agent.
         */
        waitDuration?: string | null;
    }
    /**
     * Information about an agent involved in the conversation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1ConversationQualityMetadataAgentInfo {
        /**
         * A user-specified string representing the agent.
         */
        agentId?: string | null;
        /**
         * The agent type, e.g. HUMAN_AGENT.
         */
        agentType?: string | null;
        /**
         * The agent's deployment display name. Only applicable to automated agents.
         */
        deploymentDisplayName?: string | null;
        /**
         * The agent's deployment ID. Only applicable to automated agents.
         */
        deploymentId?: string | null;
        /**
         * The agent's name.
         */
        displayName?: string | null;
        /**
         * A user-provided string indicating the outcome of the agent's segment of the call.
         */
        dispositionCode?: string | null;
        /**
         * The agent's location.
         */
        location?: string | null;
        /**
         * A user-specified string representing the agent's team. Deprecated in favor of the `teams` field.
         */
        team?: string | null;
        /**
         * User-specified strings representing the agent's teams.
         */
        teams?: string[] | null;
        /**
         * The agent's version display name. Only applicable to automated agents.
         */
        versionDisplayName?: string | null;
        /**
         * The agent's version ID. Only applicable to automated agents.
         */
        versionId?: string | null;
    }
    /**
     * Conversation summarization suggestion data.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1ConversationSummarizationSuggestionData {
        /**
         * The name of the answer record. Format: projects/{project\}/locations/{location\}/answerRecords/{answer_record\}
         */
        answerRecord?: string | null;
        /**
         * The confidence score of the summarization.
         */
        confidence?: number | null;
        /**
         * The name of the model that generates this summary. Format: projects/{project\}/locations/{location\}/conversationModels/{conversation_model\}
         */
        conversationModel?: string | null;
        /**
         * Agent Assist generator ID.
         */
        generatorId?: string | null;
        /**
         * A map that contains metadata about the summarization and the document from which it originates.
         */
        metadata?: {
            [key: string]: string;
        } | null;
        /**
         * The summarization content that is concatenated into one string.
         */
        text?: string | null;
        /**
         * The summarization content that is divided into sections. The key is the section's name and the value is the section's content. There is no specific format for the key or value.
         */
        textSections?: {
            [key: string]: string;
        } | null;
    }
    /**
     * A message representing the transcript of a conversation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1ConversationTranscript {
        /**
         * A list of sequential transcript segments that comprise the conversation.
         */
        transcriptSegments?: Schema$GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegment[];
    }
    /**
     * A segment of a full transcript.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegment {
        /**
         * For conversations derived from multi-channel audio, this is the channel number corresponding to the audio from that channel. For audioChannelCount = N, its output values can range from '1' to 'N'. A channel tag of 0 indicates that the audio is mono.
         */
        channelTag?: number | null;
        /**
         * A confidence estimate between 0.0 and 1.0 of the fidelity of this segment. A default value of 0.0 indicates that the value is unset.
         */
        confidence?: number | null;
        /**
         * CCAI metadata relating to the current transcript segment.
         */
        dialogflowSegmentMetadata?: Schema$GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentDialogflowSegmentMetadata;
        /**
         * The language code of this segment as a [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag. Example: "en-US".
         */
        languageCode?: string | null;
        /**
         * The time that the message occurred, if provided.
         */
        messageTime?: string | null;
        /**
         * The participant of this segment.
         */
        segmentParticipant?: Schema$GoogleCloudContactcenterinsightsV1ConversationParticipant;
        /**
         * The sentiment for this transcript segment.
         */
        sentiment?: Schema$GoogleCloudContactcenterinsightsV1SentimentData;
        /**
         * The text of this segment.
         */
        text?: string | null;
        /**
         * A list of the word-specific information for each word in the segment.
         */
        words?: Schema$GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentWordInfo[];
    }
    /**
     * Metadata from Dialogflow relating to the current transcript segment.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentDialogflowSegmentMetadata {
        /**
         * Whether the transcript segment was covered under the configured smart reply allowlist in Agent Assist.
         */
        smartReplyAllowlistCovered?: boolean | null;
    }
    /**
     * Word-level info for words in a transcript.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1ConversationTranscriptTranscriptSegmentWordInfo {
        /**
         * A confidence estimate between 0.0 and 1.0 of the fidelity of this word. A default value of 0.0 indicates that the value is unset.
         */
        confidence?: number | null;
        /**
         * Time offset of the end of this word relative to the beginning of the total conversation.
         */
        endOffset?: string | null;
        /**
         * Time offset of the start of this word relative to the beginning of the total conversation.
         */
        startOffset?: string | null;
        /**
         * The word itself. Includes punctuation marks that surround the word.
         */
        word?: string | null;
    }
    /**
     * A configuration that defines how to correlate conversations for a given a given project.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1CorrelationConfig {
        /**
         * Output only. The time at which the correlation config was created.
         */
        createTime?: string | null;
        /**
         * The correlation type config for full conversations.
         */
        fullConversationConfig?: Schema$GoogleCloudContactcenterinsightsV1CorrelationTypeConfig;
        /**
         * Immutable. Identifier. The resource name of the correlation config. Format: projects/{project\}/locations/{location\}/correlationConfig
         */
        name?: string | null;
        /**
         * Output only. The time at which the correlation config was last updated.
         */
        updateTime?: string | null;
    }
    /**
     * A correlation rule that defines how to join conversations for a given correlation type.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1CorrelationRule {
        /**
         * Optional. Whether the config is active to be evaluated.
         */
        active?: boolean | null;
        /**
         * Optional. A cel expression (go/cel) to be evaluated as a boolean value. Two variables conversation_a and conversation_b will be available for evaluation. This expression should evaluate to true if conversation_a and conversation_b should be joined. This is used as an extra constraint on top of the join_key_expression to further refine the group of conversations that are joined together and will be evaluated in both directions. for two conversations c1 and c2 and the result will be OR'd. We will evaluate: f(c1, c2) OR f(c2, c1)
         */
        constraintExpression?: string | null;
        /**
         * Optional. A cel expression (go/cel) to be evaluated as a string value. This string value will be used as the join key for the correlation.
         */
        joinKeyExpression?: string | null;
        /**
         * Required. The unique identifier of the rule.
         */
        ruleId?: string | null;
    }
    /**
     * A list of correlation rules for a given correlation type.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1CorrelationTypeConfig {
        /**
         * A list of correlation rules to be evaluated for correlation.
         */
        correlationRules?: Schema$GoogleCloudContactcenterinsightsV1CorrelationRule[];
    }
    /**
     * Metadata for a create analysis operation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1CreateAnalysisOperationMetadata {
        /**
         * Output only. The annotator selector used for the analysis (if any).
         */
        annotatorSelector?: Schema$GoogleCloudContactcenterinsightsV1AnnotatorSelector;
        /**
         * Output only. The Conversation that this Analysis Operation belongs to.
         */
        conversation?: string | null;
        /**
         * Output only. The time the operation was created.
         */
        createTime?: string | null;
        /**
         * Output only. The time the operation finished running.
         */
        endTime?: string | null;
    }
    /**
     * Metadata for creating an issue.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1CreateIssueMetadata {
        /**
         * Output only. The time the operation was created.
         */
        createTime?: string | null;
        /**
         * Output only. The time the operation finished running.
         */
        endTime?: string | null;
        /**
         * The original request for creation.
         */
        request?: Schema$GoogleCloudContactcenterinsightsV1CreateIssueRequest;
    }
    /**
     * Metadata for creating an issue model.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1CreateIssueModelMetadata {
        /**
         * Output only. The time the operation was created.
         */
        createTime?: string | null;
        /**
         * Output only. The time the operation finished running.
         */
        endTime?: string | null;
        /**
         * The original request for creation.
         */
        request?: Schema$GoogleCloudContactcenterinsightsV1CreateIssueModelRequest;
    }
    /**
     * The request to create an issue model.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1CreateIssueModelRequest {
        /**
         * Required. The issue model to create.
         */
        issueModel?: Schema$GoogleCloudContactcenterinsightsV1IssueModel;
        /**
         * Required. The parent resource of the issue model.
         */
        parent?: string | null;
    }
    /**
     * The request to create an issue.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1CreateIssueRequest {
        /**
         * Required. The values for the new issue.
         */
        issue?: Schema$GoogleCloudContactcenterinsightsV1Issue;
        /**
         * Required. The parent resource of the issue.
         */
        parent?: string | null;
    }
    /**
     * Dataset resource represents a collection of conversations that may be bounded (Static Dataset, e.g. golden dataset for training), or unbounded (Dynamic Dataset, e.g. live traffic, or agent training traffic)
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1Dataset {
        /**
         * Output only. Dataset create time.
         */
        createTime?: string | null;
        /**
         * Dataset description.
         */
        description?: string | null;
        /**
         * Display name for the dataaset
         */
        displayName?: string | null;
        /**
         * Immutable. Identifier. Resource name of the dataset. Format: projects/{project\}/locations/{location\}/datasets/{dataset\}
         */
        name?: string | null;
        /**
         * Optional. Option TTL for the dataset.
         */
        ttl?: string | null;
        /**
         * Dataset usage type.
         */
        type?: string | null;
        /**
         * Output only. Dataset update time.
         */
        updateTime?: string | null;
    }
    /**
     * Metadata for deleting an issue model.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1DeleteIssueModelMetadata {
        /**
         * Output only. The time the operation was created.
         */
        createTime?: string | null;
        /**
         * Output only. The time the operation finished running.
         */
        endTime?: string | null;
        /**
         * The original request for deletion.
         */
        request?: Schema$GoogleCloudContactcenterinsightsV1DeleteIssueModelRequest;
    }
    /**
     * The request to delete an issue model.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1DeleteIssueModelRequest {
        /**
         * Required. The name of the issue model to delete.
         */
        name?: string | null;
    }
    /**
     * The metadata for deleting a QaQuestionTag Resource.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1DeleteQaQuestionTagMetadata {
        /**
         * Output only. The time the operation was created.
         */
        createTime?: string | null;
        /**
         * Output only. The time the operation finished running.
         */
        endTime?: string | null;
        /**
         * Output only. The original request.
         */
        request?: Schema$GoogleCloudContactcenterinsightsV1DeleteQaQuestionTagRequest;
    }
    /**
     * The request for deleting a QaQuestionTag.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1DeleteQaQuestionTagRequest {
        /**
         * Required. The name of the QaQuestionTag to delete.
         */
        name?: string | null;
    }
    /**
     * Metadata for deploying an issue model.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1DeployIssueModelMetadata {
        /**
         * Output only. The time the operation was created.
         */
        createTime?: string | null;
        /**
         * Output only. The time the operation finished running.
         */
        endTime?: string | null;
        /**
         * The original request for deployment.
         */
        request?: Schema$GoogleCloudContactcenterinsightsV1DeployIssueModelRequest;
    }
    /**
     * The request to deploy an issue model.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1DeployIssueModelRequest {
        /**
         * Required. The issue model to deploy.
         */
        name?: string | null;
    }
    /**
     * The response to deploy an issue model.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1DeployIssueModelResponse {
    }
    /**
     * The request to deploy a QaScorecardRevision
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1DeployQaScorecardRevisionRequest {
    }
    /**
     * The data for a Dialogflow intent. Represents a detected intent in the conversation, e.g. MAKES_PROMISE.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1DialogflowIntent {
        /**
         * The human-readable name of the intent.
         */
        displayName?: string | null;
    }
    /**
     * Dialogflow interaction data.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1DialogflowInteractionData {
        /**
         * The confidence of the match ranging from 0.0 (completely uncertain) to 1.0 (completely certain).
         */
        confidence?: number | null;
        /**
         * The Dialogflow intent resource path. Format: projects/{project\}/agent/{agent\}/intents/{intent\}
         */
        dialogflowIntentId?: string | null;
    }
    /**
     * A Dialogflow source of conversation data.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1DialogflowSource {
        /**
         * Cloud Storage URI that points to a file that contains the conversation audio.
         */
        audioUri?: string | null;
        /**
         * Output only. The name of the Dialogflow conversation that this conversation resource is derived from. Format: projects/{project\}/locations/{location\}/conversations/{conversation\}
         */
        dialogflowConversation?: string | null;
    }
    /**
     * A dimension determines the grouping key for the query. In SQL terms, these would be part of both the "SELECT" and "GROUP BY" clauses.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1Dimension {
        /**
         * Output only. Metadata about the agent dimension.
         */
        agentDimensionMetadata?: Schema$GoogleCloudContactcenterinsightsV1DimensionAgentDimensionMetadata;
        /**
         * Output only. Metadata about the client sentiment category dimension.
         */
        clientSentimentCategoryDimensionMetadata?: Schema$GoogleCloudContactcenterinsightsV1DimensionClientSentimentCategoryDimensionMetadata;
        /**
         * Output only. Metadata about the Conversational Agents playbook dimension.
         */
        conversationalAgentsPlaybookDimensionMetadata?: Schema$GoogleCloudContactcenterinsightsV1DimensionConversationalAgentsPlaybookDimensionMetadata;
        /**
         * Output only. Metadata about the Conversational Agents tool dimension.
         */
        conversationalAgentsToolDimensionMetadata?: Schema$GoogleCloudContactcenterinsightsV1DimensionConversationalAgentsToolDimensionMetadata;
        /**
         * Output only. Metadata about the conversation profile dimension.
         */
        conversationProfileDimensionMetadata?: Schema$GoogleCloudContactcenterinsightsV1DimensionConversationProfileDimensionMetadata;
        /**
         * The key of the dimension.
         */
        dimensionKey?: string | null;
        /**
         * Output only. Metadata about the issue dimension.
         */
        issueDimensionMetadata?: Schema$GoogleCloudContactcenterinsightsV1DimensionIssueDimensionMetadata;
        /**
         * Output only. Metadata about conversation labels.
         */
        labelDimensionMetadata?: Schema$GoogleCloudContactcenterinsightsV1DimensionLabelDimensionMetadata;
        /**
         * Output only. Metadata about the conversation medium dimension.
         */
        mediumDimensionMetadata?: Schema$GoogleCloudContactcenterinsightsV1DimensionMediumDimensionMetadata;
        /**
         * Output only. Metadata about the QA question-answer dimension.
         */
        qaQuestionAnswerDimensionMetadata?: Schema$GoogleCloudContactcenterinsightsV1DimensionQaQuestionAnswerDimensionMetadata;
        /**
         * Output only. Metadata about the QA question dimension.
         */
        qaQuestionDimensionMetadata?: Schema$GoogleCloudContactcenterinsightsV1DimensionQaQuestionDimensionMetadata;
        /**
         * Output only. Metadata about the QA scorecard dimension.
         */
        qaScorecardDimensionMetadata?: Schema$GoogleCloudContactcenterinsightsV1DimensionQaScorecardDimensionMetadata;
    }
    /**
     * Metadata about the agent dimension.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1DimensionAgentDimensionMetadata {
        /**
         * Optional. The agent's deployment display name. Only applicable to automated agents. This will be populated for AGENT_DEPLOYMENT_ID dimensions.
         */
        agentDeploymentDisplayName?: string | null;
        /**
         * Optional. The agent's deployment ID. Only applicable to automated agents. This will be populated for AGENT and AGENT_DEPLOYMENT_ID dimensions.
         */
        agentDeploymentId?: string | null;
        /**
         * Optional. The agent's name This will be populated for AGENT, AGENT_TEAM, AGENT_VERSION_ID, and AGENT_DEPLOYMENT_ID dimensions.
         */
        agentDisplayName?: string | null;
        /**
         * Optional. A user-specified string representing the agent. This will be populated for AGENT, AGENT_TEAM, AGENT_VERSION_ID, and AGENT_DEPLOYMENT_ID dimensions.
         */
        agentId?: string | null;
        /**
         * Optional. A user-specified string representing the agent's team.
         */
        agentTeam?: string | null;
        /**
         * Optional. The agent's version display name. Only applicable to automated agents. This will be populated for AGENT_VERSION_ID, and AGENT_DEPLOYMENT_ID dimensions.
         */
        agentVersionDisplayName?: string | null;
        /**
         * Optional. The agent's version ID. Only applicable to automated agents. This will be populated for AGENT_VERSION_ID, and AGENT_DEPLOYMENT_ID dimensions.
         */
        agentVersionId?: string | null;
    }
    /**
     * Metadata about the client sentiment category dimension.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1DimensionClientSentimentCategoryDimensionMetadata {
        /**
         * Optional. The client sentiment category.
         */
        sentimentCategory?: string | null;
    }
    /**
     * Metadata about the Conversational Agents playbook dimension.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1DimensionConversationalAgentsPlaybookDimensionMetadata {
        /**
         * Optional. The dialogflow playbook display name.
         */
        playbookDisplayName?: string | null;
        /**
         * Optional. The dialogflow playbook ID.
         */
        playbookId?: string | null;
    }
    /**
     * Metadata about the Conversational Agents tool dimension.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1DimensionConversationalAgentsToolDimensionMetadata {
        /**
         * Optional. The dialogflow tool display name.
         */
        toolDisplayName?: string | null;
        /**
         * Optional. The dialogflow tool ID.
         */
        toolId?: string | null;
    }
    /**
     * Metadata about the conversation profile dimension.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1DimensionConversationProfileDimensionMetadata {
        /**
         * Optional. The conversation profile ID.
         */
        conversationProfileId?: string | null;
    }
    /**
     * Metadata about the issue dimension.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1DimensionIssueDimensionMetadata {
        /**
         * The issue display name.
         */
        issueDisplayName?: string | null;
        /**
         * The issue ID.
         */
        issueId?: string | null;
        /**
         * The parent issue model ID.
         */
        issueModelId?: string | null;
    }
    /**
     * Metadata about conversation labels.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1DimensionLabelDimensionMetadata {
        /**
         * Optional. The label key.
         */
        labelKey?: string | null;
        /**
         * Optional. The label value.
         */
        labelValue?: string | null;
    }
    /**
     * Metadata about the conversation medium dimension.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1DimensionMediumDimensionMetadata {
        /**
         * Optional. The conversation medium. Currently supports : PHONE_CALL, CHAT.
         */
        medium?: string | null;
    }
    /**
     * Metadata about the QA question-answer dimension. This is useful for showing the answer distribution for questions for a given scorecard.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1DimensionQaQuestionAnswerDimensionMetadata {
        /**
         * Optional. The full body of the question.
         */
        answerValue?: string | null;
        /**
         * Optional. The QA question ID.
         */
        qaQuestionId?: string | null;
        /**
         * Optional. The QA scorecard ID.
         */
        qaScorecardId?: string | null;
        /**
         * Optional. The full body of the question.
         */
        questionBody?: string | null;
    }
    /**
     * Metadata about the QA question dimension.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1DimensionQaQuestionDimensionMetadata {
        /**
         * Optional. The QA question ID.
         */
        qaQuestionId?: string | null;
        /**
         * Optional. The QA scorecard ID.
         */
        qaScorecardId?: string | null;
        /**
         * Optional. The full body of the question.
         */
        questionBody?: string | null;
    }
    /**
     * Metadata about the QA scorecard dimension.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1DimensionQaScorecardDimensionMetadata {
        /**
         * Optional. The QA scorecard ID.
         */
        qaScorecardId?: string | null;
    }
    /**
     * A customer-managed encryption key specification that can be applied to all created resources (e.g. `Conversation`).
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1EncryptionSpec {
        /**
         * Required. The name of customer-managed encryption key that is used to secure a resource and its sub-resources. If empty, the resource is secured by our default encryption key. Only the key in the same location as this resource is allowed to be used for encryption. Format: `projects/{project\}/locations/{location\}/keyRings/{keyRing\}/cryptoKeys/{key\}`
         */
        kmsKey?: string | null;
        /**
         * Immutable. The resource name of the encryption key specification resource. Format: projects/{project\}/locations/{location\}/encryptionSpec
         */
        name?: string | null;
    }
    /**
     * The data for an entity annotation. Represents a phrase in the conversation that is a known entity, such as a person, an organization, or location.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1Entity {
        /**
         * The representative name for the entity.
         */
        displayName?: string | null;
        /**
         * Metadata associated with the entity. For most entity types, the metadata is a Wikipedia URL (`wikipedia_url`) and Knowledge Graph MID (`mid`), if they are available. For the metadata associated with other entity types, see the Type table below.
         */
        metadata?: {
            [key: string]: string;
        } | null;
        /**
         * The salience score associated with the entity in the [0, 1.0] range. The salience score for an entity provides information about the importance or centrality of that entity to the entire document text. Scores closer to 0 are less salient, while scores closer to 1.0 are highly salient.
         */
        salience?: number | null;
        /**
         * The aggregate sentiment expressed for this entity in the conversation.
         */
        sentiment?: Schema$GoogleCloudContactcenterinsightsV1SentimentData;
        /**
         * The entity type.
         */
        type?: string | null;
    }
    /**
     * The data for an entity mention annotation. This represents a mention of an `Entity` in the conversation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1EntityMentionData {
        /**
         * The key of this entity in conversation entities. Can be used to retrieve the exact `Entity` this mention is attached to.
         */
        entityUniqueId?: string | null;
        /**
         * Sentiment expressed for this mention of the entity.
         */
        sentiment?: Schema$GoogleCloudContactcenterinsightsV1SentimentData;
        /**
         * The type of the entity mention.
         */
        type?: string | null;
    }
    /**
     * Exact match configuration.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1ExactMatchConfig {
        /**
         * Whether to consider case sensitivity when performing an exact match.
         */
        caseSensitive?: boolean | null;
    }
    /**
     * Metadata for an export insights operation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1ExportInsightsDataMetadata {
        /**
         * The number of conversations that were exported successfully.
         */
        completedExportCount?: number | null;
        /**
         * Output only. The time the operation was created.
         */
        createTime?: string | null;
        /**
         * Output only. The time the operation finished running.
         */
        endTime?: string | null;
        /**
         * The number of conversations that failed to be exported.
         */
        failedExportCount?: number | null;
        /**
         * Partial errors during export operation that might cause the operation output to be incomplete.
         */
        partialErrors?: Schema$GoogleRpcStatus[];
        /**
         * The original request for export.
         */
        request?: Schema$GoogleCloudContactcenterinsightsV1ExportInsightsDataRequest;
    }
    /**
     * The request to export insights.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1ExportInsightsDataRequest {
        /**
         * Specified if sink is a BigQuery table.
         */
        bigQueryDestination?: Schema$GoogleCloudContactcenterinsightsV1ExportInsightsDataRequestBigQueryDestination;
        /**
         * Optional. Version of the export schema.
         */
        exportSchemaVersion?: string | null;
        /**
         * A filter to reduce results to a specific subset. Useful for exporting conversations with specific properties.
         */
        filter?: string | null;
        /**
         * A fully qualified KMS key name for BigQuery tables protected by CMEK. Format: projects/{project\}/locations/{location\}/keyRings/{keyring\}/cryptoKeys/{key\}/cryptoKeyVersions/{version\}
         */
        kmsKey?: string | null;
        /**
         * Required. The parent resource to export data from.
         */
        parent?: string | null;
        /**
         * Options for what to do if the destination table already exists.
         */
        writeDisposition?: string | null;
    }
    /**
     * A BigQuery Table Reference.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1ExportInsightsDataRequestBigQueryDestination {
        /**
         * Required. The name of the BigQuery dataset that the snapshot result should be exported to. If this dataset does not exist, the export call returns an INVALID_ARGUMENT error.
         */
        dataset?: string | null;
        /**
         * A project ID or number. If specified, then export will attempt to write data to this project instead of the resource project. Otherwise, the resource project will be used.
         */
        projectId?: string | null;
        /**
         * The BigQuery table name to which the insights data should be written. If this table does not exist, the export call returns an INVALID_ARGUMENT error.
         */
        table?: string | null;
    }
    /**
     * Response for an export insights operation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1ExportInsightsDataResponse {
    }
    /**
     * Metadata used for export issue model.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1ExportIssueModelMetadata {
        /**
         * The time the operation was created.
         */
        createTime?: string | null;
        /**
         * The time the operation finished running.
         */
        endTime?: string | null;
        /**
         * The original export request.
         */
        request?: Schema$GoogleCloudContactcenterinsightsV1ExportIssueModelRequest;
    }
    /**
     * Request to export an issue model.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1ExportIssueModelRequest {
        /**
         * Google Cloud Storage URI to export the issue model to.
         */
        gcsDestination?: Schema$GoogleCloudContactcenterinsightsV1ExportIssueModelRequestGcsDestination;
        /**
         * Required. The issue model to export.
         */
        name?: string | null;
    }
    /**
     * Google Cloud Storage Object URI to save the issue model to.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1ExportIssueModelRequestGcsDestination {
        /**
         * Required. Format: `gs:///`
         */
        objectUri?: string | null;
    }
    /**
     * Response from export issue model
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1ExportIssueModelResponse {
    }
    /**
     * Agent Assist frequently-asked-question answer data.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1FaqAnswerData {
        /**
         * The piece of text from the `source` knowledge base document.
         */
        answer?: string | null;
        /**
         * The system's confidence score that this answer is a good match for this conversation, ranging from 0.0 (completely uncertain) to 1.0 (completely certain).
         */
        confidenceScore?: number | null;
        /**
         * Map that contains metadata about the FAQ answer and the document that it originates from.
         */
        metadata?: {
            [key: string]: string;
        } | null;
        /**
         * The name of the answer record. Format: projects/{project\}/locations/{location\}/answerRecords/{answer_record\}
         */
        queryRecord?: string | null;
        /**
         * The corresponding FAQ question.
         */
        question?: string | null;
        /**
         * The knowledge document that this answer was extracted from. Format: projects/{project\}/knowledgeBases/{knowledge_base\}/documents/{document\}.
         */
        source?: string | null;
    }
    /**
     * Represents a conversation, resource, and label provided by the user. Can take the form of a string label or a QaAnswer label. QaAnswer labels are used for Quality AI example conversations. String labels are used for Topic Modeling. AgentAssistSummary labels are used for Agent Assist Summarization.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1FeedbackLabel {
        /**
         * Output only. Create time of the label.
         */
        createTime?: string | null;
        /**
         * String label used for Topic Modeling.
         */
        label?: string | null;
        /**
         * Name of the resource to be labeled. Supported resources are: * `projects/{project\}/locations/{location\}/qaScorecards/{scorecard\}/revisions/{revision\}/qaQuestions/{question\}` * `projects/{project\}/locations/{location\}/issueModels/{issue_model\}` * `projects/{project\}/locations/{location\}/generators/{generator_id\}`
         */
        labeledResource?: string | null;
        /**
         * Immutable. Resource name of the FeedbackLabel. Format: projects/{project\}/locations/{location\}/conversations/{conversation\}/feedbackLabels/{feedback_label\}
         */
        name?: string | null;
        /**
         * QaAnswer label used for Quality AI example conversations.
         */
        qaAnswerLabel?: Schema$GoogleCloudContactcenterinsightsV1QaAnswerAnswerValue;
        /**
         * Output only. Update time of the label.
         */
        updateTime?: string | null;
    }
    /**
     * The message to finalize an assessment. Finalizing makes an assessment and its notes immutable.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1FinalizeAssessmentRequest {
    }
    /**
     * A Cloud Storage source of conversation data.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1GcsSource {
        /**
         * Cloud Storage URI that points to a file that contains the conversation audio.
         */
        audioUri?: string | null;
        /**
         * Immutable. Cloud Storage URI that points to a file that contains the conversation transcript.
         */
        transcriptUri?: string | null;
    }
    /**
     * The response from a GenerateConversationSignedAudio request.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1GenerateConversationSignedAudioResponse {
        /**
         * The signed uris for the audio.
         */
        signedAudioUris?: Schema$GoogleCloudContactcenterinsightsV1SignedAudioUris;
    }
    /**
     * The data for a hold annotation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1HoldData {
    }
    /**
     * Metadata used for import issue model.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1ImportIssueModelMetadata {
        /**
         * The time the operation was created.
         */
        createTime?: string | null;
        /**
         * The time the operation finished running.
         */
        endTime?: string | null;
        /**
         * The original import request.
         */
        request?: Schema$GoogleCloudContactcenterinsightsV1ImportIssueModelRequest;
    }
    /**
     * Request to import an issue model.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1ImportIssueModelRequest {
        /**
         * Optional. If set to true, will create an issue model from the imported file with randomly generated IDs for the issue model and corresponding issues. Otherwise, replaces an existing model with the same ID as the file.
         */
        createNewModel?: boolean | null;
        /**
         * Google Cloud Storage source message.
         */
        gcsSource?: Schema$GoogleCloudContactcenterinsightsV1ImportIssueModelRequestGcsSource;
        /**
         * Required. The parent resource of the issue model.
         */
        parent?: string | null;
    }
    /**
     * Google Cloud Storage Object URI to get the issue model file from.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1ImportIssueModelRequestGcsSource {
        /**
         * Required. Format: `gs:///`
         */
        objectUri?: string | null;
    }
    /**
     * Response from import issue model
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1ImportIssueModelResponse {
        /**
         * The issue model that was imported.
         */
        issueModel?: Schema$GoogleCloudContactcenterinsightsV1IssueModel;
    }
    /**
     * The metadata for an IngestConversations operation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1IngestConversationsMetadata {
        /**
         * Output only. The time the operation was created.
         */
        createTime?: string | null;
        /**
         * Output only. The time the operation finished running.
         */
        endTime?: string | null;
        /**
         * Output only. Statistics for IngestConversations operation.
         */
        ingestConversationsStats?: Schema$GoogleCloudContactcenterinsightsV1IngestConversationsMetadataIngestConversationsStats;
        /**
         * Output only. Partial errors during ingest operation that might cause the operation output to be incomplete.
         */
        partialErrors?: Schema$GoogleRpcStatus[];
        /**
         * Output only. The original request for ingest.
         */
        request?: Schema$GoogleCloudContactcenterinsightsV1IngestConversationsRequest;
        /**
         * Output only. Stores the conversation resources produced by ingest sampling operations.
         */
        sampledConversations?: string[] | null;
    }
    /**
     * Statistics for IngestConversations operation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1IngestConversationsMetadataIngestConversationsStats {
        /**
         * Output only. The number of objects skipped because another conversation with the same transcript uri had already been ingested.
         */
        duplicatesSkippedCount?: number | null;
        /**
         * Output only. The number of objects which were unable to be ingested due to errors. The errors are populated in the partial_errors field.
         */
        failedIngestCount?: number | null;
        /**
         * Output only. The number of objects processed during the ingest operation.
         */
        processedObjectCount?: number | null;
        /**
         * Output only. The number of new conversations added during this ingest operation.
         */
        successfulIngestCount?: number | null;
    }
    /**
     * The request to ingest conversations.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1IngestConversationsRequest {
        /**
         * Configuration that applies to all conversations.
         */
        conversationConfig?: Schema$GoogleCloudContactcenterinsightsV1IngestConversationsRequestConversationConfig;
        /**
         * A cloud storage bucket source. Note that any previously ingested objects from the source will be skipped to avoid duplication.
         */
        gcsSource?: Schema$GoogleCloudContactcenterinsightsV1IngestConversationsRequestGcsSource;
        /**
         * Required. The parent resource for new conversations.
         */
        parent?: string | null;
        /**
         * Optional. DLP settings for transcript redaction. Optional, will default to the config specified in Settings.
         */
        redactionConfig?: Schema$GoogleCloudContactcenterinsightsV1RedactionConfig;
        /**
         * Optional. If set, this fields indicates the number of objects to ingest from the Cloud Storage bucket. If empty, the entire bucket will be ingested. Unless they are first deleted, conversations produced through sampling won't be ingested by subsequent ingest requests.
         */
        sampleSize?: number | null;
        /**
         * Optional. Default Speech-to-Text configuration. Optional, will default to the config specified in Settings.
         */
        speechConfig?: Schema$GoogleCloudContactcenterinsightsV1SpeechConfig;
        /**
         * Configuration for when `source` contains conversation transcripts.
         */
        transcriptObjectConfig?: Schema$GoogleCloudContactcenterinsightsV1IngestConversationsRequestTranscriptObjectConfig;
    }
    /**
     * Configuration that applies to all conversations.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1IngestConversationsRequestConversationConfig {
        /**
         * Optional. Indicates which of the channels, 1 or 2, contains the agent. Note that this must be set for conversations to be properly displayed and analyzed.
         */
        agentChannel?: number | null;
        /**
         * Optional. An opaque, user-specified string representing a human agent who handled all conversations in the import. Note that this will be overridden if per-conversation metadata is provided through the `metadata_bucket_uri`.
         */
        agentId?: string | null;
        /**
         * Optional. Indicates which of the channels, 1 or 2, contains the agent. Note that this must be set for conversations to be properly displayed and analyzed.
         */
        customerChannel?: number | null;
    }
    /**
     * Configuration for Cloud Storage bucket sources.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1IngestConversationsRequestGcsSource {
        /**
         * Optional. The Cloud Storage path to the conversation audio file. Note that: [1] Audio files will be transcribed if not already. [2] Audio files and transcript files must be in separate buckets / folders. [3] A source file and its corresponding audio file must share the same name to be properly ingested, E.g. `gs://bucket/transcript/conversation1.json` and `gs://bucket/audio/conversation1.mp3`.
         */
        audioBucketUri?: string | null;
        /**
         * Optional. Specifies the type of the objects in `bucket_uri`. Avoid passing this. This is inferred from the `transcript_bucket_uri`, `audio_bucket_uri`.
         */
        bucketObjectType?: string | null;
        /**
         * Optional. The Cloud Storage bucket containing source objects. Avoid passing this. Pass this through one of `transcript_bucket_uri` or `audio_bucket_uri`.
         */
        bucketUri?: string | null;
        /**
         * Optional. Custom keys to extract as conversation labels from metadata files in `metadata_bucket_uri`. Keys not included in this field will be ignored. Note that there is a limit of 100 labels per conversation.
         */
        customMetadataKeys?: string[] | null;
        /**
         * Optional. The Cloud Storage path to the conversation metadata. Note that: [1] Metadata files are expected to be in JSON format. [2] Metadata and source files (transcripts or audio) must be in separate buckets / folders. [3] A source file and its corresponding metadata file must share the same name to be properly ingested, E.g. `gs://bucket/audio/conversation1.mp3` and `gs://bucket/metadata/conversation1.json`.
         */
        metadataBucketUri?: string | null;
        /**
         * Optional. The Cloud Storage path to the conversation transcripts. Note that: [1] Transcript files are expected to be in JSON format. [2] Transcript, audio, metadata files must be in separate buckets / folders. [3] A source file and its corresponding metadata file must share the same name to be properly ingested, E.g. `gs://bucket/audio/conversation1.mp3` and `gs://bucket/metadata/conversation1.json`.
         */
        transcriptBucketUri?: string | null;
    }
    /**
     * Configuration for processing transcript objects.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1IngestConversationsRequestTranscriptObjectConfig {
        /**
         * Required. The medium transcript objects represent.
         */
        medium?: string | null;
    }
    /**
     * The response to an IngestConversations operation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1IngestConversationsResponse {
    }
    /**
     * Metadata for initializing a location-level encryption specification.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1InitializeEncryptionSpecMetadata {
        /**
         * Output only. The time the operation was created.
         */
        createTime?: string | null;
        /**
         * Output only. The time the operation finished running.
         */
        endTime?: string | null;
        /**
         * Partial errors during initializing operation that might cause the operation output to be incomplete.
         */
        partialErrors?: Schema$GoogleRpcStatus[];
        /**
         * Output only. The original request for initialization.
         */
        request?: Schema$GoogleCloudContactcenterinsightsV1InitializeEncryptionSpecRequest;
    }
    /**
     * The request to initialize a location-level encryption specification.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1InitializeEncryptionSpecRequest {
        /**
         * Required. The encryption spec used for CMEK encryption. It is required that the kms key is in the same region as the endpoint. The same key will be used for all provisioned resources, if encryption is available. If the `kms_key_name` field is left empty, no encryption will be enforced.
         */
        encryptionSpec?: Schema$GoogleCloudContactcenterinsightsV1EncryptionSpec;
    }
    /**
     * The response to initialize a location-level encryption specification.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1InitializeEncryptionSpecResponse {
    }
    /**
     * The data for an intent. Represents a detected intent in the conversation, for example MAKES_PROMISE.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1Intent {
        /**
         * The human-readable name of the intent.
         */
        displayName?: string | null;
        /**
         * The unique identifier of the intent.
         */
        id?: string | null;
    }
    /**
     * The data for an intent match. Represents an intent match for a text segment in the conversation. A text segment can be part of a sentence, a complete sentence, or an utterance with multiple sentences.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1IntentMatchData {
        /**
         * The id of the matched intent. Can be used to retrieve the corresponding intent information.
         */
        intentUniqueId?: string | null;
    }
    /**
     * The data for an interruption annotation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1InterruptionData {
    }
    /**
     * The issue resource.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1Issue {
        /**
         * Output only. The time at which this issue was created.
         */
        createTime?: string | null;
        /**
         * Representative description of the issue.
         */
        displayDescription?: string | null;
        /**
         * The representative name for the issue.
         */
        displayName?: string | null;
        /**
         * Immutable. The resource name of the issue. Format: projects/{project\}/locations/{location\}/issueModels/{issue_model\}/issues/{issue\}
         */
        name?: string | null;
        /**
         * Output only. Resource names of the sample representative utterances that match to this issue.
         */
        sampleUtterances?: string[] | null;
        /**
         * Output only. The most recent time that this issue was updated.
         */
        updateTime?: string | null;
    }
    /**
     * Information about the issue.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1IssueAssignment {
        /**
         * Immutable. Display name of the assigned issue. This field is set at time of analysis and immutable since then.
         */
        displayName?: string | null;
        /**
         * Resource name of the assigned issue.
         */
        issue?: string | null;
        /**
         * Score indicating the likelihood of the issue assignment. currently bounded on [0,1].
         */
        score?: number | null;
    }
    /**
     * The data for an issue match annotation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1IssueMatchData {
        /**
         * Information about the issue's assignment.
         */
        issueAssignment?: Schema$GoogleCloudContactcenterinsightsV1IssueAssignment;
    }
    /**
     * The issue model resource.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1IssueModel {
        /**
         * Output only. The time at which this issue model was created.
         */
        createTime?: string | null;
        /**
         * The representative name for the issue model.
         */
        displayName?: string | null;
        /**
         * Configs for the input data that used to create the issue model.
         */
        inputDataConfig?: Schema$GoogleCloudContactcenterinsightsV1IssueModelInputDataConfig;
        /**
         * Output only. Number of issues in this issue model.
         */
        issueCount?: string | null;
        /**
         * Language of the model.
         */
        languageCode?: string | null;
        /**
         * Type of the model.
         */
        modelType?: string | null;
        /**
         * Immutable. The resource name of the issue model. Format: projects/{project\}/locations/{location\}/issueModels/{issue_model\}
         */
        name?: string | null;
        /**
         * Output only. State of the model.
         */
        state?: string | null;
        /**
         * Output only. Immutable. The issue model's label statistics on its training data.
         */
        trainingStats?: Schema$GoogleCloudContactcenterinsightsV1IssueModelLabelStats;
        /**
         * Output only. The most recent time at which the issue model was updated.
         */
        updateTime?: string | null;
    }
    /**
     * Configs for the input data used to create the issue model.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1IssueModelInputDataConfig {
        /**
         * A filter to reduce the conversations used for training the model to a specific subset. Refer to https://cloud.google.com/contact-center/insights/docs/filtering for details.
         */
        filter?: string | null;
        /**
         * Medium of conversations used in training data. This field is being deprecated. To specify the medium to be used in training a new issue model, set the `medium` field on `filter`.
         */
        medium?: string | null;
        /**
         * Output only. Number of conversations used in training. Output only.
         */
        trainingConversationsCount?: string | null;
    }
    /**
     * Aggregated statistics about an issue model.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1IssueModelLabelStats {
        /**
         * Number of conversations the issue model has analyzed at this point in time.
         */
        analyzedConversationsCount?: string | null;
        /**
         * Statistics on each issue. Key is the issue's resource name.
         */
        issueStats?: {
            [key: string]: Schema$GoogleCloudContactcenterinsightsV1IssueModelLabelStatsIssueStats;
        } | null;
        /**
         * Number of analyzed conversations for which no issue was applicable at this point in time.
         */
        unclassifiedConversationsCount?: string | null;
    }
    /**
     * Aggregated statistics about an issue.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1IssueModelLabelStatsIssueStats {
        /**
         * Display name of the issue.
         */
        displayName?: string | null;
        /**
         * Issue resource. Format: projects/{project\}/locations/{location\}/issueModels/{issue_model\}/issues/{issue\}
         */
        issue?: string | null;
        /**
         * Number of conversations attached to the issue at this point in time.
         */
        labeledConversationsCount?: string | null;
    }
    /**
     * Issue Modeling result on a conversation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1IssueModelResult {
        /**
         * Issue model that generates the result. Format: projects/{project\}/locations/{location\}/issueModels/{issue_model\}
         */
        issueModel?: string | null;
        /**
         * All the matched issues.
         */
        issues?: Schema$GoogleCloudContactcenterinsightsV1IssueAssignment[];
    }
    /**
     * The response for listing all feedback labels.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1ListAllFeedbackLabelsResponse {
        /**
         * The feedback labels that match the request.
         */
        feedbackLabels?: Schema$GoogleCloudContactcenterinsightsV1FeedbackLabel[];
        /**
         * A token, which can be sent as `page_token` to retrieve the next page. If this field is omitted, there are no subsequent pages.
         */
        nextPageToken?: string | null;
    }
    /**
     * The response to list analyses.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1ListAnalysesResponse {
        /**
         * The analyses that match the request.
         */
        analyses?: Schema$GoogleCloudContactcenterinsightsV1Analysis[];
        /**
         * A token, which can be sent as `page_token` to retrieve the next page. If this field is omitted, there are no subsequent pages.
         */
        nextPageToken?: string | null;
    }
    /**
     * The response of listing views.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1ListAnalysisRulesResponse {
        /**
         * The analysis_rule that match the request.
         */
        analysisRules?: Schema$GoogleCloudContactcenterinsightsV1AnalysisRule[];
        /**
         * A token, which can be sent as `page_token` to retrieve the next page. If this field is omitted, there are no subsequent pages.
         */
        nextPageToken?: string | null;
    }
    /**
     * The response of listing assessment rules.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1ListAssessmentRulesResponse {
        /**
         * The assessment rules that match the request.
         */
        assessmentRules?: Schema$GoogleCloudContactcenterinsightsV1AssessmentRule[];
        /**
         * A token, which can be sent as `page_token` to retrieve the next page. If this field is omitted, there are no subsequent pages.
         */
        nextPageToken?: string | null;
    }
    /**
     * The response of listing assessments.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1ListAssessmentsResponse {
        /**
         * The assessments that match the request.
         */
        assessments?: Schema$GoogleCloudContactcenterinsightsV1Assessment[];
        /**
         * A token, which can be sent as `page_token` to retrieve the next page. If this field is omitted, there are no subsequent pages.
         */
        nextPageToken?: string | null;
    }
    /**
     * The response from a ListAuthorizedViewSet request.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1ListAuthorizedViewSetsResponse {
        /**
         * The AuthorizedViewSets under the parent.
         */
        authorizedViewSets?: Schema$GoogleCloudContactcenterinsightsV1AuthorizedViewSet[];
        /**
         * A token, which can be sent as `page_token` to retrieve the next page. If this field is omitted, there are no subsequent pages.
         */
        nextPageToken?: string | null;
    }
    /**
     * The response from a ListAuthorizedViews request.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1ListAuthorizedViewsResponse {
        /**
         * The AuthorizedViews under the parent.
         */
        authorizedViews?: Schema$GoogleCloudContactcenterinsightsV1AuthorizedView[];
        /**
         * A token, which can be sent as `page_token` to retrieve the next page. If this field is omitted, there are no subsequent pages.
         */
        nextPageToken?: string | null;
    }
    /**
     * The response message for listing auto labeling rules.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1ListAutoLabelingRulesResponse {
        /**
         * The auto labeling rules.
         */
        autoLabelingRules?: Schema$GoogleCloudContactcenterinsightsV1AutoLabelingRule[];
        /**
         * A token, which can be sent as `page_token` to retrieve the next page. If this field is omitted, there are no subsequent pages.
         */
        nextPageToken?: string | null;
    }
    /**
     * The response of listing conversations.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1ListConversationsResponse {
        /**
         * The conversations that match the request.
         */
        conversations?: Schema$GoogleCloudContactcenterinsightsV1Conversation[];
        /**
         * A token which can be sent as `page_token` to retrieve the next page. If this field is set, it means there is another page available. If it is not set, it means no other pages are available.
         */
        nextPageToken?: string | null;
    }
    /**
     * The response to list datasets.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1ListDatasetsResponse {
        /**
         * The datasets that match the request.
         */
        datasets?: Schema$GoogleCloudContactcenterinsightsV1Dataset[];
        /**
         * A token, which can be sent as `page_token` to retrieve the next page. If this field is omitted, there are no subsequent pages.
         */
        nextPageToken?: string | null;
    }
    /**
     * The response for listing feedback labels.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1ListFeedbackLabelsResponse {
        /**
         * The feedback labels that match the request.
         */
        feedbackLabels?: Schema$GoogleCloudContactcenterinsightsV1FeedbackLabel[];
        /**
         * The next page token.
         */
        nextPageToken?: string | null;
    }
    /**
     * The response of listing issue models.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1ListIssueModelsResponse {
        /**
         * The issue models that match the request.
         */
        issueModels?: Schema$GoogleCloudContactcenterinsightsV1IssueModel[];
    }
    /**
     * The response of listing issues.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1ListIssuesResponse {
        /**
         * The issues that match the request.
         */
        issues?: Schema$GoogleCloudContactcenterinsightsV1Issue[];
    }
    /**
     * The response of listing notes.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1ListNotesResponse {
        /**
         * A token, which can be sent as `page_token` to retrieve the next page. If this field is omitted, there are no subsequent pages.
         */
        nextPageToken?: string | null;
        /**
         * The notes that match the request.
         */
        notes?: Schema$GoogleCloudContactcenterinsightsV1Note[];
    }
    /**
     * The response of listing phrase matchers.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1ListPhraseMatchersResponse {
        /**
         * A token, which can be sent as `page_token` to retrieve the next page. If this field is omitted, there are no subsequent pages.
         */
        nextPageToken?: string | null;
        /**
         * The phrase matchers that match the request.
         */
        phraseMatchers?: Schema$GoogleCloudContactcenterinsightsV1PhraseMatcher[];
    }
    /**
     * The response from a ListQaQuestions request.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1ListQaQuestionsResponse {
        /**
         * A token, which can be sent as `page_token` to retrieve the next page. If this field is omitted, there are no subsequent pages.
         */
        nextPageToken?: string | null;
        /**
         * The QaQuestions under the parent.
         */
        qaQuestions?: Schema$GoogleCloudContactcenterinsightsV1QaQuestion[];
    }
    /**
     * The response from a ListQaQuestionTags request.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1ListQaQuestionTagsResponse {
        /**
         * A token, which can be sent as `page_token` to retrieve the next page. If this field is omitted, there are no subsequent pages.
         */
        nextPageToken?: string | null;
        /**
         * The parent resource of the questions.
         */
        qaQuestionTags?: Schema$GoogleCloudContactcenterinsightsV1QaQuestionTag[];
    }
    /**
     * The response from a ListQaScorecardRevisions request.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1ListQaScorecardRevisionsResponse {
        /**
         * A token, which can be sent as `page_token` to retrieve the next page. If this field is omitted, there are no subsequent pages.
         */
        nextPageToken?: string | null;
        /**
         * The QaScorecards under the parent.
         */
        qaScorecardRevisions?: Schema$GoogleCloudContactcenterinsightsV1QaScorecardRevision[];
    }
    /**
     * The response from a ListQaScorecards request.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1ListQaScorecardsResponse {
        /**
         * A token, which can be sent as `page_token` to retrieve the next page. If this field is omitted, there are no subsequent pages.
         */
        nextPageToken?: string | null;
        /**
         * The QaScorecards under the parent.
         */
        qaScorecards?: Schema$GoogleCloudContactcenterinsightsV1QaScorecard[];
    }
    /**
     * The response of listing views.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1ListViewsResponse {
        /**
         * A token, which can be sent as `page_token` to retrieve the next page. If this field is omitted, there are no subsequent pages.
         */
        nextPageToken?: string | null;
        /**
         * The views that match the request.
         */
        views?: Schema$GoogleCloudContactcenterinsightsV1View[];
    }
    /**
     * The analysis resource.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainAnalysis {
        /**
         * Output only. The result of the analysis, which is populated when the analysis finishes.
         */
        analysisResult?: Schema$GoogleCloudContactcenterinsightsV1mainAnalysisResult;
        /**
         * To select the annotators to run and the phrase matchers to use (if any). If not specified, all annotators will be run.
         */
        annotatorSelector?: Schema$GoogleCloudContactcenterinsightsV1mainAnnotatorSelector;
        /**
         * Output only. The time at which the analysis was created, which occurs when the long-running operation completes.
         */
        createTime?: string | null;
        /**
         * Immutable. The resource name of the analysis. Format: projects/{project\}/locations/{location\}/conversations/{conversation\}/analyses/{analysis\}
         */
        name?: string | null;
        /**
         * Output only. The time at which the analysis was requested.
         */
        requestTime?: string | null;
    }
    /**
     * The result of an analysis.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainAnalysisResult {
        /**
         * Call-specific metadata created by the analysis.
         */
        callAnalysisMetadata?: Schema$GoogleCloudContactcenterinsightsV1mainAnalysisResultCallAnalysisMetadata;
        /**
         * The time at which the analysis ended.
         */
        endTime?: string | null;
    }
    /**
     * Call-specific metadata created during analysis.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainAnalysisResultCallAnalysisMetadata {
        /**
         * A list of call annotations that apply to this call.
         */
        annotations?: Schema$GoogleCloudContactcenterinsightsV1mainCallAnnotation[];
        /**
         * All the entities in the call.
         */
        entities?: {
            [key: string]: Schema$GoogleCloudContactcenterinsightsV1mainEntity;
        } | null;
        /**
         * All the matched intents in the call.
         */
        intents?: {
            [key: string]: Schema$GoogleCloudContactcenterinsightsV1mainIntent;
        } | null;
        /**
         * Overall conversation-level issue modeling result.
         */
        issueModelResult?: Schema$GoogleCloudContactcenterinsightsV1mainIssueModelResult;
        /**
         * All the matched phrase matchers in the call.
         */
        phraseMatchers?: {
            [key: string]: Schema$GoogleCloudContactcenterinsightsV1mainPhraseMatchData;
        } | null;
        /**
         * Results of scoring QaScorecards.
         */
        qaScorecardResults?: Schema$GoogleCloudContactcenterinsightsV1mainQaScorecardResult[];
        /**
         * Overall conversation-level sentiment for each channel of the call.
         */
        sentiments?: Schema$GoogleCloudContactcenterinsightsV1mainConversationLevelSentiment[];
        /**
         * Overall conversation-level silence during the call.
         */
        silence?: Schema$GoogleCloudContactcenterinsightsV1mainConversationLevelSilence;
    }
    /**
     * A point in a conversation that marks the start or the end of an annotation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainAnnotationBoundary {
        /**
         * The index in the sequence of transcribed pieces of the conversation where the boundary is located. This index starts at zero.
         */
        transcriptIndex?: number | null;
        /**
         * The word index of this boundary with respect to the first word in the transcript piece. This index starts at zero.
         */
        wordIndex?: number | null;
    }
    /**
     * Selector of all available annotators and phrase matchers to run.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainAnnotatorSelector {
        /**
         * The issue model to run. If not provided, the most recently deployed topic model will be used. The provided issue model will only be used for inference if the issue model is deployed and if run_issue_model_annotator is set to true. If more than one issue model is provided, only the first provided issue model will be used for inference.
         */
        issueModels?: string[] | null;
        /**
         * The list of phrase matchers to run. If not provided, all active phrase matchers will be used. If inactive phrase matchers are provided, they will not be used. Phrase matchers will be run only if run_phrase_matcher_annotator is set to true. Format: projects/{project\}/locations/{location\}/phraseMatchers/{phrase_matcher\}
         */
        phraseMatchers?: string[] | null;
        /**
         * Configuration for the QA annotator.
         */
        qaConfig?: Schema$GoogleCloudContactcenterinsightsV1mainAnnotatorSelectorQaConfig;
        /**
         * Whether to run the entity annotator.
         */
        runEntityAnnotator?: boolean | null;
        /**
         * Whether to run the intent annotator.
         */
        runIntentAnnotator?: boolean | null;
        /**
         * Whether to run the interruption annotator.
         */
        runInterruptionAnnotator?: boolean | null;
        /**
         * Whether to run the issue model annotator. A model should have already been deployed for this to take effect.
         */
        runIssueModelAnnotator?: boolean | null;
        /**
         * Whether to run the active phrase matcher annotator(s).
         */
        runPhraseMatcherAnnotator?: boolean | null;
        /**
         * Whether to run the QA annotator.
         */
        runQaAnnotator?: boolean | null;
        /**
         * Whether to run the sentiment annotator.
         */
        runSentimentAnnotator?: boolean | null;
        /**
         * Whether to run the silence annotator.
         */
        runSilenceAnnotator?: boolean | null;
        /**
         * Whether to run the summarization annotator.
         */
        runSummarizationAnnotator?: boolean | null;
        /**
         * Configuration for the summarization annotator.
         */
        summarizationConfig?: Schema$GoogleCloudContactcenterinsightsV1mainAnnotatorSelectorSummarizationConfig;
    }
    /**
     * Configuration for the QA feature.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainAnnotatorSelectorQaConfig {
        /**
         * A manual list of scorecards to score.
         */
        scorecardList?: Schema$GoogleCloudContactcenterinsightsV1mainAnnotatorSelectorQaConfigScorecardList;
    }
    /**
     * Container for a list of scorecards.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainAnnotatorSelectorQaConfigScorecardList {
        /**
         * List of QaScorecardRevisions.
         */
        qaScorecardRevisions?: string[] | null;
    }
    /**
     * Configuration for summarization.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainAnnotatorSelectorSummarizationConfig {
        /**
         * Resource name of the Dialogflow conversation profile. Format: projects/{project\}/locations/{location\}/conversationProfiles/{conversation_profile\}
         */
        conversationProfile?: string | null;
        /**
         * The resource name of the existing created generator. Format: projects//locations//generators/
         */
        generator?: string | null;
        /**
         * Default summarization model to be used.
         */
        summarizationModel?: string | null;
    }
    /**
     * The feedback that the customer has about a certain answer in the conversation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainAnswerFeedback {
        /**
         * Indicates whether an answer or item was clicked by the human agent.
         */
        clicked?: boolean | null;
        /**
         * The correctness level of an answer.
         */
        correctnessLevel?: string | null;
        /**
         * Indicates whether an answer or item was displayed to the human agent in the agent desktop UI.
         */
        displayed?: boolean | null;
    }
    /**
     * Agent Assist Article Suggestion data.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainArticleSuggestionData {
        /**
         * The system's confidence score that this article is a good match for this conversation, ranging from 0.0 (completely uncertain) to 1.0 (completely certain).
         */
        confidenceScore?: number | null;
        /**
         * Map that contains metadata about the Article Suggestion and the document that it originates from.
         */
        metadata?: {
            [key: string]: string;
        } | null;
        /**
         * The name of the answer record. Format: projects/{project\}/locations/{location\}/answerRecords/{answer_record\}
         */
        queryRecord?: string | null;
        /**
         * The knowledge document that this answer was extracted from. Format: projects/{project\}/knowledgeBases/{knowledge_base\}/documents/{document\}
         */
        source?: string | null;
        /**
         * Article title.
         */
        title?: string | null;
        /**
         * Article URI.
         */
        uri?: string | null;
    }
    /**
     * The metadata for a bulk analyze conversations operation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainBulkAnalyzeConversationsMetadata {
        /**
         * The number of requested analyses that have completed successfully so far.
         */
        completedAnalysesCount?: number | null;
        /**
         * The time the operation was created.
         */
        createTime?: string | null;
        /**
         * The time the operation finished running.
         */
        endTime?: string | null;
        /**
         * The number of requested analyses that have failed so far.
         */
        failedAnalysesCount?: number | null;
        /**
         * Output only. Partial errors during bulk analyze operation that might cause the operation output to be incomplete.
         */
        partialErrors?: Schema$GoogleRpcStatus[];
        /**
         * The original request for bulk analyze.
         */
        request?: Schema$GoogleCloudContactcenterinsightsV1mainBulkAnalyzeConversationsRequest;
        /**
         * Total number of analyses requested. Computed by the number of conversations returned by `filter` multiplied by `analysis_percentage` in the request.
         */
        totalRequestedAnalysesCount?: number | null;
    }
    /**
     * The request to analyze conversations in bulk.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainBulkAnalyzeConversationsRequest {
        /**
         * Required. Percentage of selected conversation to analyze, between [0, 100].
         */
        analysisPercentage?: number | null;
        /**
         * To select the annotators to run and the phrase matchers to use (if any). If not specified, all annotators will be run.
         */
        annotatorSelector?: Schema$GoogleCloudContactcenterinsightsV1mainAnnotatorSelector;
        /**
         * Required. Filter used to select the subset of conversations to analyze.
         */
        filter?: string | null;
        /**
         * Required. The parent resource to create analyses in.
         */
        parent?: string | null;
    }
    /**
     * The response for a bulk analyze conversations operation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainBulkAnalyzeConversationsResponse {
        /**
         * Count of failed analyses.
         */
        failedAnalysisCount?: number | null;
        /**
         * Count of successful analyses.
         */
        successfulAnalysisCount?: number | null;
    }
    /**
     * The metadata for a bulk delete conversations operation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainBulkDeleteConversationsMetadata {
        /**
         * The time the operation was created.
         */
        createTime?: string | null;
        /**
         * The time the operation finished running.
         */
        endTime?: string | null;
        /**
         * Partial errors during bulk delete conversations operation that might cause the operation output to be incomplete.
         */
        partialErrors?: Schema$GoogleRpcStatus[];
        /**
         * The original request for bulk delete.
         */
        request?: Schema$GoogleCloudContactcenterinsightsV1mainBulkDeleteConversationsRequest;
    }
    /**
     * The request to delete conversations in bulk.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainBulkDeleteConversationsRequest {
        /**
         * Filter used to select the subset of conversations to delete.
         */
        filter?: string | null;
        /**
         * If set to true, all of this conversation's analyses will also be deleted. Otherwise, the request will only succeed if the conversation has no analyses.
         */
        force?: boolean | null;
        /**
         * Maximum number of conversations to delete.
         */
        maxDeleteCount?: number | null;
        /**
         * Required. The parent resource to delete conversations from. Format: projects/{project\}/locations/{location\}
         */
        parent?: string | null;
    }
    /**
     * The response for a bulk delete conversations operation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainBulkDeleteConversationsResponse {
    }
    /**
     * Metadata for the BulkDeleteFeedbackLabels endpoint.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainBulkDeleteFeedbackLabelsMetadata {
        /**
         * Partial errors during deletion operation that might cause the operation output to be incomplete.
         */
        partialErrors?: Schema$GoogleRpcStatus[];
        /**
         * Output only. The original request for delete.
         */
        request?: Schema$GoogleCloudContactcenterinsightsV1mainBulkDeleteFeedbackLabelsRequest;
    }
    /**
     * Request for the BulkDeleteFeedbackLabels endpoint.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainBulkDeleteFeedbackLabelsRequest {
        /**
         * Optional. A filter to reduce results to a specific subset. Supports disjunctions (OR) and conjunctions (AND). Supported fields: * `issue_model_id` * `qa_question_id` * `qa_scorecard_id` * `min_create_time` * `max_create_time` * `min_update_time` * `max_update_time` * `feedback_label_type`: QUALITY_AI, TOPIC_MODELING
         */
        filter?: string | null;
        /**
         * Required. The parent resource for new feedback labels.
         */
        parent?: string | null;
    }
    /**
     * Response for the BulkDeleteFeedbackLabels endpoint.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainBulkDeleteFeedbackLabelsResponse {
    }
    /**
     * Metadata for the BulkDownloadFeedbackLabel endpoint.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainBulkDownloadFeedbackLabelsMetadata {
        /**
         * Output only. The time the operation was created.
         */
        createTime?: string | null;
        /**
         * Output only. Statistics for BulkDownloadFeedbackLabels operation.
         */
        downloadStats?: Schema$GoogleCloudContactcenterinsightsV1mainBulkDownloadFeedbackLabelsMetadataDownloadStats;
        /**
         * Output only. The time the operation finished running.
         */
        endTime?: string | null;
        /**
         * Partial errors during ingest operation that might cause the operation output to be incomplete.
         */
        partialErrors?: Schema$GoogleRpcStatus[];
        /**
         * Output only. The original request for download.
         */
        request?: Schema$GoogleCloudContactcenterinsightsV1mainBulkDownloadFeedbackLabelsRequest;
    }
    /**
     * Statistics for BulkDownloadFeedbackLabels operation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainBulkDownloadFeedbackLabelsMetadataDownloadStats {
        /**
         * Output only. Full name of the files written to Cloud storage.
         */
        fileNames?: string[] | null;
        /**
         * The number of objects processed during the download operation.
         */
        processedObjectCount?: number | null;
        /**
         * The number of new feedback labels downloaded during this operation. Different from "processed" because some labels might not be downloaded because an error.
         */
        successfulDownloadCount?: number | null;
        /**
         * Total number of files written to the provided Cloud Storage bucket.
         */
        totalFilesWritten?: number | null;
    }
    /**
     * Request for the BulkDownloadFeedbackLabel endpoint.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainBulkDownloadFeedbackLabelsRequest {
        /**
         * Optional. Filter parent conversations to download feedback labels for. When specified, the feedback labels will be downloaded for the conversations that match the filter. If `template_qa_scorecard_id` is set, all the conversations that match the filter will be paired with the questions under the scorecard for labeling.
         */
        conversationFilter?: string | null;
        /**
         * Optional. The type of feedback labels that will be downloaded.
         */
        feedbackLabelType?: string | null;
        /**
         * Optional. A filter to reduce results to a specific subset. Supports disjunctions (OR) and conjunctions (AND). Supported fields: * `issue_model_id` * `qa_question_id` * `qa_scorecard_id` * `min_create_time` * `max_create_time` * `min_update_time` * `max_update_time` * `feedback_label_type`: QUALITY_AI, TOPIC_MODELING
         */
        filter?: string | null;
        /**
         * A cloud storage bucket destination.
         */
        gcsDestination?: Schema$GoogleCloudContactcenterinsightsV1mainBulkDownloadFeedbackLabelsRequestGcsDestination;
        /**
         * Optional. Limits the maximum number of feedback labels that will be downloaded. The first `N` feedback labels will be downloaded.
         */
        maxDownloadCount?: number | null;
        /**
         * Required. The parent resource for new feedback labels.
         */
        parent?: string | null;
        /**
         * A sheets document destination.
         */
        sheetsDestination?: Schema$GoogleCloudContactcenterinsightsV1mainBulkDownloadFeedbackLabelsRequestSheetsDestination;
        /**
         * Optional. If set, a template for labeling conversations and scorecard questions will be created from the conversation_filter and the questions under the scorecard(s). The feedback label `filter` will be ignored.
         */
        templateQaScorecardId?: string[] | null;
    }
    /**
     * Google Cloud Storage Object details to write the feedback labels to.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainBulkDownloadFeedbackLabelsRequestGcsDestination {
        /**
         * Optional. Add whitespace to the JSON file. Makes easier to read, but increases file size. Only applicable for JSON format.
         */
        addWhitespace?: boolean | null;
        /**
         * Optional. Always print fields with no presence. This is useful for printing fields that are not set, like implicit 0 value or empty lists/maps. Only applicable for JSON format.
         */
        alwaysPrintEmptyFields?: boolean | null;
        /**
         * Required. File format in which the labels will be exported.
         */
        format?: string | null;
        /**
         * Required. The Google Cloud Storage URI to write the feedback labels to. The file name will be used as a prefix for the files written to the bucket if the output needs to be split across multiple files, otherwise it will be used as is. The file extension will be appended to the file name based on the format selected. E.g. `gs://bucket_name/object_uri_prefix`
         */
        objectUri?: string | null;
        /**
         * Optional. The number of records per file. Applicable for either format.
         */
        recordsPerFileCount?: string | null;
    }
    /**
     * Google Sheets document details to write the feedback labels to.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainBulkDownloadFeedbackLabelsRequestSheetsDestination {
        /**
         * Optional. The title of the new sheet to write the feedback labels to.
         */
        sheetTitle?: string | null;
        /**
         * Required. The Google Sheets document to write the feedback labels to. Retrieved from Google Sheets URI. E.g. `https://docs.google.com/spreadsheets/d/1234567890` The spreadsheet must be shared with the Insights P4SA. The spreadsheet ID written to will be returned as `file_names` in the BulkDownloadFeedbackLabelsMetadata.
         */
        spreadsheetUri?: string | null;
    }
    /**
     * Response for the BulkDownloadFeedbackLabel endpoint.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainBulkDownloadFeedbackLabelsResponse {
    }
    /**
     * A piece of metadata that applies to a window of a call.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainCallAnnotation {
        /**
         * The boundary in the conversation where the annotation ends, inclusive.
         */
        annotationEndBoundary?: Schema$GoogleCloudContactcenterinsightsV1mainAnnotationBoundary;
        /**
         * The boundary in the conversation where the annotation starts, inclusive.
         */
        annotationStartBoundary?: Schema$GoogleCloudContactcenterinsightsV1mainAnnotationBoundary;
        /**
         * The channel of the audio where the annotation occurs. For single-channel audio, this field is not populated.
         */
        channelTag?: number | null;
        /**
         * Data specifying an entity mention.
         */
        entityMentionData?: Schema$GoogleCloudContactcenterinsightsV1mainEntityMentionData;
        /**
         * Data specifying a hold.
         */
        holdData?: Schema$GoogleCloudContactcenterinsightsV1mainHoldData;
        /**
         * Data specifying an intent match.
         */
        intentMatchData?: Schema$GoogleCloudContactcenterinsightsV1mainIntentMatchData;
        /**
         * Data specifying an interruption.
         */
        interruptionData?: Schema$GoogleCloudContactcenterinsightsV1mainInterruptionData;
        /**
         * Data specifying an issue match.
         */
        issueMatchData?: Schema$GoogleCloudContactcenterinsightsV1mainIssueMatchData;
        /**
         * Data specifying a phrase match.
         */
        phraseMatchData?: Schema$GoogleCloudContactcenterinsightsV1mainPhraseMatchData;
        /**
         * Data specifying sentiment.
         */
        sentimentData?: Schema$GoogleCloudContactcenterinsightsV1mainSentimentData;
        /**
         * Data specifying silence.
         */
        silenceData?: Schema$GoogleCloudContactcenterinsightsV1mainSilenceData;
    }
    /**
     * The result of testing a constraint expression on a pair of conversations.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainConstraintEvaluationResult {
        /**
         * The first conversation resource name.
         */
        conversationA?: string | null;
        /**
         * The second conversation resource name.
         */
        conversationB?: string | null;
        /**
         * The results for each applicable constraint rule.
         */
        ruleConstraintResults?: Schema$GoogleCloudContactcenterinsightsV1mainConstraintEvaluationResultRuleConstraintResult[];
    }
    /**
     * The result of a single constraint rule on the pair of conversations.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainConstraintEvaluationResultRuleConstraintResult {
        /**
         * Whether the constraint expression evaluated to true for (A, B) or (B, A).
         */
        constraintMet?: boolean | null;
        /**
         * The error status if the constraint expression failed to evaluate.
         */
        error?: Schema$GoogleRpcStatus;
        /**
         * The rule ID.
         */
        ruleId?: string | null;
    }
    /**
     * The conversation resource.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainConversation {
        /**
         * An opaque, user-specified string representing the human agent who handled the conversation.
         */
        agentId?: string | null;
        /**
         * Call-specific metadata.
         */
        callMetadata?: Schema$GoogleCloudContactcenterinsightsV1mainConversationCallMetadata;
        /**
         * Output only. Info for correlating across conversations.
         */
        correlationInfo?: Schema$GoogleCloudContactcenterinsightsV1mainConversationCorrelationInfo;
        /**
         * Output only. The time at which the conversation was created.
         */
        createTime?: string | null;
        /**
         * The source of the audio and transcription for the conversation.
         */
        dataSource?: Schema$GoogleCloudContactcenterinsightsV1mainConversationDataSource;
        /**
         * Output only. All the matched Dialogflow intents in the call. The key corresponds to a Dialogflow intent, format: projects/{project\}/agent/{agent\}/intents/{intent\}
         */
        dialogflowIntents?: {
            [key: string]: Schema$GoogleCloudContactcenterinsightsV1mainDialogflowIntent;
        } | null;
        /**
         * Output only. The duration of the conversation.
         */
        duration?: string | null;
        /**
         * The time at which this conversation should expire. After this time, the conversation data and any associated analyses will be deleted.
         */
        expireTime?: string | null;
        /**
         * A map for the user to specify any custom fields. A maximum of 100 labels per conversation is allowed, with a maximum of 256 characters per entry.
         */
        labels?: {
            [key: string]: string;
        } | null;
        /**
         * A user-specified language code for the conversation.
         */
        languageCode?: string | null;
        /**
         * Output only. The conversation's latest analysis, if one exists.
         */
        latestAnalysis?: Schema$GoogleCloudContactcenterinsightsV1mainAnalysis;
        /**
         * Output only. Latest summary of the conversation.
         */
        latestSummary?: Schema$GoogleCloudContactcenterinsightsV1mainConversationSummarizationSuggestionData;
        /**
         * Immutable. The conversation medium.
         */
        medium?: string | null;
        /**
         * Input only. JSON metadata encoded as a string. This field is primarily used by Insights integrations with various telephony systems and must be in one of Insight's supported formats.
         */
        metadataJson?: string | null;
        /**
         * Immutable. The resource name of the conversation. Format: projects/{project\}/locations/{location\}/conversations/{conversation\}
         */
        name?: string | null;
        /**
         * Obfuscated user ID which the customer sent to us.
         */
        obfuscatedUserId?: string | null;
        /**
         * Conversation metadata related to quality management.
         */
        qualityMetadata?: Schema$GoogleCloudContactcenterinsightsV1mainConversationQualityMetadata;
        /**
         * Output only. The annotations that were generated during the customer and agent interaction.
         */
        runtimeAnnotations?: Schema$GoogleCloudContactcenterinsightsV1mainRuntimeAnnotation[];
        /**
         * The time at which the conversation started.
         */
        startTime?: string | null;
        /**
         * Output only. The conversation transcript.
         */
        transcript?: Schema$GoogleCloudContactcenterinsightsV1mainConversationTranscript;
        /**
         * Input only. The TTL for this resource. If specified, then this TTL will be used to calculate the expire time.
         */
        ttl?: string | null;
        /**
         * Output only. The number of turns in the conversation.
         */
        turnCount?: number | null;
        /**
         * Output only. The most recent time at which the conversation was updated.
         */
        updateTime?: string | null;
    }
    /**
     * Call-specific metadata.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainConversationCallMetadata {
        /**
         * The audio channel that contains the agent.
         */
        agentChannel?: number | null;
        /**
         * The audio channel that contains the customer.
         */
        customerChannel?: number | null;
    }
    /**
     * Info for correlating across conversations.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainConversationCorrelationInfo {
        /**
         * Output only. The correlation types of this conversation. A single conversation can have multiple correlation types. For example a conversation that only has a single segment is both a SEGMENT and a FULL_CONVERSATION.
         */
        correlationTypes?: string[] | null;
        /**
         * Output only. The full conversation correlation id this conversation is a segment of.
         */
        fullConversationCorrelationId?: string | null;
        /**
         * Output only. The full conversation correlation id this conversation is a merged conversation of.
         */
        mergedFullConversationCorrelationId?: string | null;
    }
    /**
     * The result of testing correlation config on a single conversation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainConversationCorrelationResult {
        /**
         * The conversation resource name.
         */
        conversation?: string | null;
        /**
         * The results for each correlation rule.
         */
        ruleResults?: Schema$GoogleCloudContactcenterinsightsV1mainConversationCorrelationResultRuleCorrelationResult[];
    }
    /**
     * The result of a single correlation rule.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainConversationCorrelationResultRuleCorrelationResult {
        /**
         * The correlation ID generated by the join key expression.
         */
        correlationId?: string | null;
        /**
         * The error status if the join key expression failed to evaluate.
         */
        error?: Schema$GoogleRpcStatus;
        /**
         * The rule ID.
         */
        ruleId?: string | null;
    }
    /**
     * The conversation source, which is a combination of transcript and audio.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainConversationDataSource {
        /**
         * The source when the conversation comes from Dialogflow.
         */
        dialogflowSource?: Schema$GoogleCloudContactcenterinsightsV1mainDialogflowSource;
        /**
         * A Cloud Storage location specification for the audio and transcript.
         */
        gcsSource?: Schema$GoogleCloudContactcenterinsightsV1mainGcsSource;
        /**
         * Cloud Storage URI that points to a file that contains the conversation metadata.
         */
        metadataUri?: string | null;
    }
    /**
     * One channel of conversation-level sentiment data.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainConversationLevelSentiment {
        /**
         * The channel of the audio that the data applies to.
         */
        channelTag?: number | null;
        /**
         * Data specifying sentiment.
         */
        sentimentData?: Schema$GoogleCloudContactcenterinsightsV1mainSentimentData;
    }
    /**
     * Conversation-level silence data.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainConversationLevelSilence {
        /**
         * Amount of time calculated to be in silence.
         */
        silenceDuration?: string | null;
        /**
         * Percentage of the total conversation spent in silence.
         */
        silencePercentage?: number | null;
    }
    /**
     * The call participant speaking for a given utterance.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainConversationParticipant {
        /**
         * Deprecated. Use `dialogflow_participant_name` instead. The name of the Dialogflow participant. Format: projects/{project\}/locations/{location\}/conversations/{conversation\}/participants/{participant\}
         */
        dialogflowParticipant?: string | null;
        /**
         * The name of the participant provided by Dialogflow. Format: projects/{project\}/locations/{location\}/conversations/{conversation\}/participants/{participant\}
         */
        dialogflowParticipantName?: string | null;
        /**
         * Obfuscated user ID from Dialogflow.
         */
        obfuscatedExternalUserId?: string | null;
        /**
         * The role of the participant.
         */
        role?: string | null;
        /**
         * A user-specified ID representing the participant.
         */
        userId?: string | null;
    }
    /**
     * Conversation metadata related to quality management.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainConversationQualityMetadata {
        /**
         * Information about agents involved in the call.
         */
        agentInfo?: Schema$GoogleCloudContactcenterinsightsV1mainConversationQualityMetadataAgentInfo[];
        /**
         * An arbitrary integer value indicating the customer's satisfaction rating.
         */
        customerSatisfactionRating?: number | null;
        /**
         * Input only. The feedback labels associated with the conversation.
         */
        feedbackLabels?: Schema$GoogleCloudContactcenterinsightsV1mainFeedbackLabel[];
        /**
         * An arbitrary string value specifying the menu path the customer took.
         */
        menuPath?: string | null;
        /**
         * The amount of time the customer waited to connect with an agent.
         */
        waitDuration?: string | null;
    }
    /**
     * Information about an agent involved in the conversation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainConversationQualityMetadataAgentInfo {
        /**
         * A user-specified string representing the agent.
         */
        agentId?: string | null;
        /**
         * The agent type, e.g. HUMAN_AGENT.
         */
        agentType?: string | null;
        /**
         * The agent's deployment display name. Only applicable to automated agents.
         */
        deploymentDisplayName?: string | null;
        /**
         * The agent's deployment ID. Only applicable to automated agents.
         */
        deploymentId?: string | null;
        /**
         * The agent's name.
         */
        displayName?: string | null;
        /**
         * A user-provided string indicating the outcome of the agent's segment of the call.
         */
        dispositionCode?: string | null;
        /**
         * The agent's location.
         */
        location?: string | null;
        /**
         * A user-specified string representing the agent's team. Deprecated in favor of the `teams` field.
         */
        team?: string | null;
        /**
         * User-specified strings representing the agent's teams.
         */
        teams?: string[] | null;
        /**
         * The agent's version display name. Only applicable to automated agents.
         */
        versionDisplayName?: string | null;
        /**
         * The agent's version ID. Only applicable to automated agents.
         */
        versionId?: string | null;
    }
    /**
     * Conversation summarization suggestion data.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainConversationSummarizationSuggestionData {
        /**
         * The name of the answer record. Format: projects/{project\}/locations/{location\}/answerRecords/{answer_record\}
         */
        answerRecord?: string | null;
        /**
         * The confidence score of the summarization.
         */
        confidence?: number | null;
        /**
         * The name of the model that generates this summary. Format: projects/{project\}/locations/{location\}/conversationModels/{conversation_model\}
         */
        conversationModel?: string | null;
        /**
         * Agent Assist generator ID.
         */
        generatorId?: string | null;
        /**
         * A map that contains metadata about the summarization and the document from which it originates.
         */
        metadata?: {
            [key: string]: string;
        } | null;
        /**
         * The summarization content that is concatenated into one string.
         */
        text?: string | null;
        /**
         * The summarization content that is divided into sections. The key is the section's name and the value is the section's content. There is no specific format for the key or value.
         */
        textSections?: {
            [key: string]: string;
        } | null;
    }
    /**
     * A message representing the transcript of a conversation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainConversationTranscript {
        /**
         * A list of sequential transcript segments that comprise the conversation.
         */
        transcriptSegments?: Schema$GoogleCloudContactcenterinsightsV1mainConversationTranscriptTranscriptSegment[];
    }
    /**
     * A segment of a full transcript.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainConversationTranscriptTranscriptSegment {
        /**
         * For conversations derived from multi-channel audio, this is the channel number corresponding to the audio from that channel. For audioChannelCount = N, its output values can range from '1' to 'N'. A channel tag of 0 indicates that the audio is mono.
         */
        channelTag?: number | null;
        /**
         * A confidence estimate between 0.0 and 1.0 of the fidelity of this segment. A default value of 0.0 indicates that the value is unset.
         */
        confidence?: number | null;
        /**
         * CCAI metadata relating to the current transcript segment.
         */
        dialogflowSegmentMetadata?: Schema$GoogleCloudContactcenterinsightsV1mainConversationTranscriptTranscriptSegmentDialogflowSegmentMetadata;
        /**
         * The language code of this segment as a [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag. Example: "en-US".
         */
        languageCode?: string | null;
        /**
         * The time that the message occurred, if provided.
         */
        messageTime?: string | null;
        /**
         * The participant of this segment.
         */
        segmentParticipant?: Schema$GoogleCloudContactcenterinsightsV1mainConversationParticipant;
        /**
         * The sentiment for this transcript segment.
         */
        sentiment?: Schema$GoogleCloudContactcenterinsightsV1mainSentimentData;
        /**
         * The text of this segment.
         */
        text?: string | null;
        /**
         * A list of the word-specific information for each word in the segment.
         */
        words?: Schema$GoogleCloudContactcenterinsightsV1mainConversationTranscriptTranscriptSegmentWordInfo[];
    }
    /**
     * Metadata from Dialogflow relating to the current transcript segment.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainConversationTranscriptTranscriptSegmentDialogflowSegmentMetadata {
        /**
         * Whether the transcript segment was covered under the configured smart reply allowlist in Agent Assist.
         */
        smartReplyAllowlistCovered?: boolean | null;
    }
    /**
     * Word-level info for words in a transcript.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainConversationTranscriptTranscriptSegmentWordInfo {
        /**
         * A confidence estimate between 0.0 and 1.0 of the fidelity of this word. A default value of 0.0 indicates that the value is unset.
         */
        confidence?: number | null;
        /**
         * Time offset of the end of this word relative to the beginning of the total conversation.
         */
        endOffset?: string | null;
        /**
         * Time offset of the start of this word relative to the beginning of the total conversation.
         */
        startOffset?: string | null;
        /**
         * The word itself. Includes punctuation marks that surround the word.
         */
        word?: string | null;
    }
    /**
     * Metadata for a create analysis operation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainCreateAnalysisOperationMetadata {
        /**
         * Output only. The annotator selector used for the analysis (if any).
         */
        annotatorSelector?: Schema$GoogleCloudContactcenterinsightsV1mainAnnotatorSelector;
        /**
         * Output only. The Conversation that this Analysis Operation belongs to.
         */
        conversation?: string | null;
        /**
         * Output only. The time the operation was created.
         */
        createTime?: string | null;
        /**
         * Output only. The time the operation finished running.
         */
        endTime?: string | null;
    }
    /**
     * Metadata for creating an issue.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainCreateIssueMetadata {
        /**
         * Output only. The time the operation was created.
         */
        createTime?: string | null;
        /**
         * Output only. The time the operation finished running.
         */
        endTime?: string | null;
        /**
         * The original request for creation.
         */
        request?: Schema$GoogleCloudContactcenterinsightsV1mainCreateIssueRequest;
    }
    /**
     * Metadata for creating an issue model.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainCreateIssueModelMetadata {
        /**
         * Output only. The time the operation was created.
         */
        createTime?: string | null;
        /**
         * Output only. The time the operation finished running.
         */
        endTime?: string | null;
        /**
         * The original request for creation.
         */
        request?: Schema$GoogleCloudContactcenterinsightsV1mainCreateIssueModelRequest;
    }
    /**
     * The request to create an issue model.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainCreateIssueModelRequest {
        /**
         * Required. The issue model to create.
         */
        issueModel?: Schema$GoogleCloudContactcenterinsightsV1mainIssueModel;
        /**
         * Required. The parent resource of the issue model.
         */
        parent?: string | null;
    }
    /**
     * The request to create an issue.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainCreateIssueRequest {
        /**
         * Required. The values for the new issue.
         */
        issue?: Schema$GoogleCloudContactcenterinsightsV1mainIssue;
        /**
         * Required. The parent resource of the issue.
         */
        parent?: string | null;
    }
    /**
     * Dataset resource represents a collection of conversations that may be bounded (Static Dataset, e.g. golden dataset for training), or unbounded (Dynamic Dataset, e.g. live traffic, or agent training traffic)
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainDataset {
        /**
         * Output only. Dataset create time.
         */
        createTime?: string | null;
        /**
         * Dataset description.
         */
        description?: string | null;
        /**
         * Display name for the dataaset
         */
        displayName?: string | null;
        /**
         * Immutable. Identifier. Resource name of the dataset. Format: projects/{project\}/locations/{location\}/datasets/{dataset\}
         */
        name?: string | null;
        /**
         * Optional. Option TTL for the dataset.
         */
        ttl?: string | null;
        /**
         * Dataset usage type.
         */
        type?: string | null;
        /**
         * Output only. Dataset update time.
         */
        updateTime?: string | null;
    }
    /**
     * Metadata for deleting an issue model.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainDeleteIssueModelMetadata {
        /**
         * Output only. The time the operation was created.
         */
        createTime?: string | null;
        /**
         * Output only. The time the operation finished running.
         */
        endTime?: string | null;
        /**
         * The original request for deletion.
         */
        request?: Schema$GoogleCloudContactcenterinsightsV1mainDeleteIssueModelRequest;
    }
    /**
     * The request to delete an issue model.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainDeleteIssueModelRequest {
        /**
         * Required. The name of the issue model to delete.
         */
        name?: string | null;
    }
    /**
     * The metadata for deleting a QaQuestionTag Resource.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainDeleteQaQuestionTagMetadata {
        /**
         * Output only. The time the operation was created.
         */
        createTime?: string | null;
        /**
         * Output only. The time the operation finished running.
         */
        endTime?: string | null;
        /**
         * Output only. The original request.
         */
        request?: Schema$GoogleCloudContactcenterinsightsV1mainDeleteQaQuestionTagRequest;
    }
    /**
     * The request for deleting a QaQuestionTag.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainDeleteQaQuestionTagRequest {
        /**
         * Required. The name of the QaQuestionTag to delete.
         */
        name?: string | null;
    }
    /**
     * Metadata for deploying an issue model.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainDeployIssueModelMetadata {
        /**
         * Output only. The time the operation was created.
         */
        createTime?: string | null;
        /**
         * Output only. The time the operation finished running.
         */
        endTime?: string | null;
        /**
         * The original request for deployment.
         */
        request?: Schema$GoogleCloudContactcenterinsightsV1mainDeployIssueModelRequest;
    }
    /**
     * The request to deploy an issue model.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainDeployIssueModelRequest {
        /**
         * Required. The issue model to deploy.
         */
        name?: string | null;
    }
    /**
     * The response to deploy an issue model.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainDeployIssueModelResponse {
    }
    /**
     * The data for a Dialogflow intent. Represents a detected intent in the conversation, e.g. MAKES_PROMISE.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainDialogflowIntent {
        /**
         * The human-readable name of the intent.
         */
        displayName?: string | null;
    }
    /**
     * Dialogflow interaction data.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainDialogflowInteractionData {
        /**
         * The confidence of the match ranging from 0.0 (completely uncertain) to 1.0 (completely certain).
         */
        confidence?: number | null;
        /**
         * The Dialogflow intent resource path. Format: projects/{project\}/agent/{agent\}/intents/{intent\}
         */
        dialogflowIntentId?: string | null;
    }
    /**
     * A Dialogflow source of conversation data.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainDialogflowSource {
        /**
         * Cloud Storage URI that points to a file that contains the conversation audio.
         */
        audioUri?: string | null;
        /**
         * Output only. The name of the Dialogflow conversation that this conversation resource is derived from. Format: projects/{project\}/locations/{location\}/conversations/{conversation\}
         */
        dialogflowConversation?: string | null;
    }
    /**
     * A dimension determines the grouping key for the query. In SQL terms, these would be part of both the "SELECT" and "GROUP BY" clauses.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainDimension {
        /**
         * Output only. Metadata about the agent dimension.
         */
        agentDimensionMetadata?: Schema$GoogleCloudContactcenterinsightsV1mainDimensionAgentDimensionMetadata;
        /**
         * Output only. Metadata about the client sentiment category dimension.
         */
        clientSentimentCategoryDimensionMetadata?: Schema$GoogleCloudContactcenterinsightsV1mainDimensionClientSentimentCategoryDimensionMetadata;
        /**
         * Output only. Metadata about the Conversational Agents playbook dimension.
         */
        conversationalAgentsPlaybookDimensionMetadata?: Schema$GoogleCloudContactcenterinsightsV1mainDimensionConversationalAgentsPlaybookDimensionMetadata;
        /**
         * Output only. Metadata about the Conversational Agents tool dimension.
         */
        conversationalAgentsToolDimensionMetadata?: Schema$GoogleCloudContactcenterinsightsV1mainDimensionConversationalAgentsToolDimensionMetadata;
        /**
         * Output only. Metadata about the conversation profile dimension.
         */
        conversationProfileDimensionMetadata?: Schema$GoogleCloudContactcenterinsightsV1mainDimensionConversationProfileDimensionMetadata;
        /**
         * The key of the dimension.
         */
        dimensionKey?: string | null;
        /**
         * Output only. Metadata about the issue dimension.
         */
        issueDimensionMetadata?: Schema$GoogleCloudContactcenterinsightsV1mainDimensionIssueDimensionMetadata;
        /**
         * Output only. Metadata about conversation labels.
         */
        labelDimensionMetadata?: Schema$GoogleCloudContactcenterinsightsV1mainDimensionLabelDimensionMetadata;
        /**
         * Output only. Metadata about the conversation medium dimension.
         */
        mediumDimensionMetadata?: Schema$GoogleCloudContactcenterinsightsV1mainDimensionMediumDimensionMetadata;
        /**
         * Output only. Metadata about the QA question-answer dimension.
         */
        qaQuestionAnswerDimensionMetadata?: Schema$GoogleCloudContactcenterinsightsV1mainDimensionQaQuestionAnswerDimensionMetadata;
        /**
         * Output only. Metadata about the QA question dimension.
         */
        qaQuestionDimensionMetadata?: Schema$GoogleCloudContactcenterinsightsV1mainDimensionQaQuestionDimensionMetadata;
        /**
         * Output only. Metadata about the QA scorecard dimension.
         */
        qaScorecardDimensionMetadata?: Schema$GoogleCloudContactcenterinsightsV1mainDimensionQaScorecardDimensionMetadata;
    }
    /**
     * Metadata about the agent dimension.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainDimensionAgentDimensionMetadata {
        /**
         * Optional. The agent's deployment display name. Only applicable to automated agents. This will be populated for AGENT_DEPLOYMENT_ID dimensions.
         */
        agentDeploymentDisplayName?: string | null;
        /**
         * Optional. The agent's deployment ID. Only applicable to automated agents. This will be populated for AGENT and AGENT_DEPLOYMENT_ID dimensions.
         */
        agentDeploymentId?: string | null;
        /**
         * Optional. The agent's name This will be populated for AGENT, AGENT_TEAM, AGENT_VERSION_ID, and AGENT_DEPLOYMENT_ID dimensions.
         */
        agentDisplayName?: string | null;
        /**
         * Optional. A user-specified string representing the agent. This will be populated for AGENT, AGENT_TEAM, AGENT_VERSION_ID, and AGENT_DEPLOYMENT_ID dimensions.
         */
        agentId?: string | null;
        /**
         * Optional. A user-specified string representing the agent's team.
         */
        agentTeam?: string | null;
        /**
         * Optional. The agent's version display name. Only applicable to automated agents. This will be populated for AGENT_VERSION_ID, and AGENT_DEPLOYMENT_ID dimensions.
         */
        agentVersionDisplayName?: string | null;
        /**
         * Optional. The agent's version ID. Only applicable to automated agents. This will be populated for AGENT_VERSION_ID, and AGENT_DEPLOYMENT_ID dimensions.
         */
        agentVersionId?: string | null;
    }
    /**
     * Metadata about the client sentiment category dimension.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainDimensionClientSentimentCategoryDimensionMetadata {
        /**
         * Optional. The client sentiment category.
         */
        sentimentCategory?: string | null;
    }
    /**
     * Metadata about the Conversational Agents playbook dimension.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainDimensionConversationalAgentsPlaybookDimensionMetadata {
        /**
         * Optional. The dialogflow playbook display name.
         */
        playbookDisplayName?: string | null;
        /**
         * Optional. The dialogflow playbook ID.
         */
        playbookId?: string | null;
    }
    /**
     * Metadata about the Conversational Agents tool dimension.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainDimensionConversationalAgentsToolDimensionMetadata {
        /**
         * Optional. The dialogflow tool display name.
         */
        toolDisplayName?: string | null;
        /**
         * Optional. The dialogflow tool ID.
         */
        toolId?: string | null;
    }
    /**
     * Metadata about the conversation profile dimension.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainDimensionConversationProfileDimensionMetadata {
        /**
         * Optional. The conversation profile ID.
         */
        conversationProfileId?: string | null;
    }
    /**
     * Metadata about the issue dimension.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainDimensionIssueDimensionMetadata {
        /**
         * The issue display name.
         */
        issueDisplayName?: string | null;
        /**
         * The issue ID.
         */
        issueId?: string | null;
        /**
         * The parent issue model ID.
         */
        issueModelId?: string | null;
    }
    /**
     * Metadata about conversation labels.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainDimensionLabelDimensionMetadata {
        /**
         * Optional. The label key.
         */
        labelKey?: string | null;
        /**
         * Optional. The label value.
         */
        labelValue?: string | null;
    }
    /**
     * Metadata about the conversation medium dimension.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainDimensionMediumDimensionMetadata {
        /**
         * Optional. The conversation medium. Currently supports : PHONE_CALL, CHAT.
         */
        medium?: string | null;
    }
    /**
     * Metadata about the QA question-answer dimension. This is useful for showing the answer distribution for questions for a given scorecard.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainDimensionQaQuestionAnswerDimensionMetadata {
        /**
         * Optional. The full body of the question.
         */
        answerValue?: string | null;
        /**
         * Optional. The QA question ID.
         */
        qaQuestionId?: string | null;
        /**
         * Optional. The QA scorecard ID.
         */
        qaScorecardId?: string | null;
        /**
         * Optional. The full body of the question.
         */
        questionBody?: string | null;
    }
    /**
     * Metadata about the QA question dimension.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainDimensionQaQuestionDimensionMetadata {
        /**
         * Optional. The QA question ID.
         */
        qaQuestionId?: string | null;
        /**
         * Optional. The QA scorecard ID.
         */
        qaScorecardId?: string | null;
        /**
         * Optional. The full body of the question.
         */
        questionBody?: string | null;
    }
    /**
     * Metadata about the QA scorecard dimension.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainDimensionQaScorecardDimensionMetadata {
        /**
         * Optional. The QA scorecard ID.
         */
        qaScorecardId?: string | null;
    }
    /**
     * A customer-managed encryption key specification that can be applied to all created resources (e.g. `Conversation`).
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainEncryptionSpec {
        /**
         * Required. The name of customer-managed encryption key that is used to secure a resource and its sub-resources. If empty, the resource is secured by our default encryption key. Only the key in the same location as this resource is allowed to be used for encryption. Format: `projects/{project\}/locations/{location\}/keyRings/{keyRing\}/cryptoKeys/{key\}`
         */
        kmsKey?: string | null;
        /**
         * Immutable. The resource name of the encryption key specification resource. Format: projects/{project\}/locations/{location\}/encryptionSpec
         */
        name?: string | null;
    }
    /**
     * The data for an entity annotation. Represents a phrase in the conversation that is a known entity, such as a person, an organization, or location.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainEntity {
        /**
         * The representative name for the entity.
         */
        displayName?: string | null;
        /**
         * Metadata associated with the entity. For most entity types, the metadata is a Wikipedia URL (`wikipedia_url`) and Knowledge Graph MID (`mid`), if they are available. For the metadata associated with other entity types, see the Type table below.
         */
        metadata?: {
            [key: string]: string;
        } | null;
        /**
         * The salience score associated with the entity in the [0, 1.0] range. The salience score for an entity provides information about the importance or centrality of that entity to the entire document text. Scores closer to 0 are less salient, while scores closer to 1.0 are highly salient.
         */
        salience?: number | null;
        /**
         * The aggregate sentiment expressed for this entity in the conversation.
         */
        sentiment?: Schema$GoogleCloudContactcenterinsightsV1mainSentimentData;
        /**
         * The entity type.
         */
        type?: string | null;
    }
    /**
     * The data for an entity mention annotation. This represents a mention of an `Entity` in the conversation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainEntityMentionData {
        /**
         * The key of this entity in conversation entities. Can be used to retrieve the exact `Entity` this mention is attached to.
         */
        entityUniqueId?: string | null;
        /**
         * Sentiment expressed for this mention of the entity.
         */
        sentiment?: Schema$GoogleCloudContactcenterinsightsV1mainSentimentData;
        /**
         * The type of the entity mention.
         */
        type?: string | null;
    }
    /**
     * Metadata for an export insights operation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainExportInsightsDataMetadata {
        /**
         * The number of conversations that were exported successfully.
         */
        completedExportCount?: number | null;
        /**
         * Output only. The time the operation was created.
         */
        createTime?: string | null;
        /**
         * Output only. The time the operation finished running.
         */
        endTime?: string | null;
        /**
         * The number of conversations that failed to be exported.
         */
        failedExportCount?: number | null;
        /**
         * Partial errors during export operation that might cause the operation output to be incomplete.
         */
        partialErrors?: Schema$GoogleRpcStatus[];
        /**
         * The original request for export.
         */
        request?: Schema$GoogleCloudContactcenterinsightsV1mainExportInsightsDataRequest;
    }
    /**
     * The request to export insights.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainExportInsightsDataRequest {
        /**
         * Specified if sink is a BigQuery table.
         */
        bigQueryDestination?: Schema$GoogleCloudContactcenterinsightsV1mainExportInsightsDataRequestBigQueryDestination;
        /**
         * Optional. Version of the export schema.
         */
        exportSchemaVersion?: string | null;
        /**
         * A filter to reduce results to a specific subset. Useful for exporting conversations with specific properties.
         */
        filter?: string | null;
        /**
         * A fully qualified KMS key name for BigQuery tables protected by CMEK. Format: projects/{project\}/locations/{location\}/keyRings/{keyring\}/cryptoKeys/{key\}/cryptoKeyVersions/{version\}
         */
        kmsKey?: string | null;
        /**
         * Required. The parent resource to export data from.
         */
        parent?: string | null;
        /**
         * Options for what to do if the destination table already exists.
         */
        writeDisposition?: string | null;
    }
    /**
     * A BigQuery Table Reference.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainExportInsightsDataRequestBigQueryDestination {
        /**
         * Required. The name of the BigQuery dataset that the snapshot result should be exported to. If this dataset does not exist, the export call returns an INVALID_ARGUMENT error.
         */
        dataset?: string | null;
        /**
         * A project ID or number. If specified, then export will attempt to write data to this project instead of the resource project. Otherwise, the resource project will be used.
         */
        projectId?: string | null;
        /**
         * The BigQuery table name to which the insights data should be written. If this table does not exist, the export call returns an INVALID_ARGUMENT error.
         */
        table?: string | null;
    }
    /**
     * Response for an export insights operation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainExportInsightsDataResponse {
    }
    /**
     * Metadata used for export issue model.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainExportIssueModelMetadata {
        /**
         * The time the operation was created.
         */
        createTime?: string | null;
        /**
         * The time the operation finished running.
         */
        endTime?: string | null;
        /**
         * The original export request.
         */
        request?: Schema$GoogleCloudContactcenterinsightsV1mainExportIssueModelRequest;
    }
    /**
     * Request to export an issue model.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainExportIssueModelRequest {
        /**
         * Google Cloud Storage URI to export the issue model to.
         */
        gcsDestination?: Schema$GoogleCloudContactcenterinsightsV1mainExportIssueModelRequestGcsDestination;
        /**
         * Required. The issue model to export.
         */
        name?: string | null;
    }
    /**
     * Google Cloud Storage Object URI to save the issue model to.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainExportIssueModelRequestGcsDestination {
        /**
         * Required. Format: `gs:///`
         */
        objectUri?: string | null;
    }
    /**
     * Response from export issue model
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainExportIssueModelResponse {
    }
    /**
     * Agent Assist frequently-asked-question answer data.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainFaqAnswerData {
        /**
         * The piece of text from the `source` knowledge base document.
         */
        answer?: string | null;
        /**
         * The system's confidence score that this answer is a good match for this conversation, ranging from 0.0 (completely uncertain) to 1.0 (completely certain).
         */
        confidenceScore?: number | null;
        /**
         * Map that contains metadata about the FAQ answer and the document that it originates from.
         */
        metadata?: {
            [key: string]: string;
        } | null;
        /**
         * The name of the answer record. Format: projects/{project\}/locations/{location\}/answerRecords/{answer_record\}
         */
        queryRecord?: string | null;
        /**
         * The corresponding FAQ question.
         */
        question?: string | null;
        /**
         * The knowledge document that this answer was extracted from. Format: projects/{project\}/knowledgeBases/{knowledge_base\}/documents/{document\}.
         */
        source?: string | null;
    }
    /**
     * Represents a conversation, resource, and label provided by the user. Can take the form of a string label or a QaAnswer label. QaAnswer labels are used for Quality AI example conversations. String labels are used for Topic Modeling. AgentAssistSummary labels are used for Agent Assist Summarization.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainFeedbackLabel {
        /**
         * Output only. Create time of the label.
         */
        createTime?: string | null;
        /**
         * String label used for Topic Modeling.
         */
        label?: string | null;
        /**
         * Name of the resource to be labeled. Supported resources are: * `projects/{project\}/locations/{location\}/qaScorecards/{scorecard\}/revisions/{revision\}/qaQuestions/{question\}` * `projects/{project\}/locations/{location\}/issueModels/{issue_model\}` * `projects/{project\}/locations/{location\}/generators/{generator_id\}`
         */
        labeledResource?: string | null;
        /**
         * Immutable. Resource name of the FeedbackLabel. Format: projects/{project\}/locations/{location\}/conversations/{conversation\}/feedbackLabels/{feedback_label\}
         */
        name?: string | null;
        /**
         * QaAnswer label used for Quality AI example conversations.
         */
        qaAnswerLabel?: Schema$GoogleCloudContactcenterinsightsV1mainQaAnswerAnswerValue;
        /**
         * Output only. Update time of the label.
         */
        updateTime?: string | null;
    }
    /**
     * A Cloud Storage source of conversation data.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainGcsSource {
        /**
         * Cloud Storage URI that points to a file that contains the conversation audio.
         */
        audioUri?: string | null;
        /**
         * Immutable. Cloud Storage URI that points to a file that contains the conversation transcript.
         */
        transcriptUri?: string | null;
    }
    /**
     * The data for a hold annotation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainHoldData {
    }
    /**
     * Metadata used for import issue model.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainImportIssueModelMetadata {
        /**
         * The time the operation was created.
         */
        createTime?: string | null;
        /**
         * The time the operation finished running.
         */
        endTime?: string | null;
        /**
         * The original import request.
         */
        request?: Schema$GoogleCloudContactcenterinsightsV1mainImportIssueModelRequest;
    }
    /**
     * Request to import an issue model.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainImportIssueModelRequest {
        /**
         * Optional. If set to true, will create an issue model from the imported file with randomly generated IDs for the issue model and corresponding issues. Otherwise, replaces an existing model with the same ID as the file.
         */
        createNewModel?: boolean | null;
        /**
         * Google Cloud Storage source message.
         */
        gcsSource?: Schema$GoogleCloudContactcenterinsightsV1mainImportIssueModelRequestGcsSource;
        /**
         * Required. The parent resource of the issue model.
         */
        parent?: string | null;
    }
    /**
     * Google Cloud Storage Object URI to get the issue model file from.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainImportIssueModelRequestGcsSource {
        /**
         * Required. Format: `gs:///`
         */
        objectUri?: string | null;
    }
    /**
     * Response from import issue model
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainImportIssueModelResponse {
        /**
         * The issue model that was imported.
         */
        issueModel?: Schema$GoogleCloudContactcenterinsightsV1mainIssueModel;
    }
    /**
     * The metadata for an IngestConversations operation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainIngestConversationsMetadata {
        /**
         * Output only. The time the operation was created.
         */
        createTime?: string | null;
        /**
         * Output only. The time the operation finished running.
         */
        endTime?: string | null;
        /**
         * Output only. Statistics for IngestConversations operation.
         */
        ingestConversationsStats?: Schema$GoogleCloudContactcenterinsightsV1mainIngestConversationsMetadataIngestConversationsStats;
        /**
         * Output only. Partial errors during ingest operation that might cause the operation output to be incomplete.
         */
        partialErrors?: Schema$GoogleRpcStatus[];
        /**
         * Output only. The original request for ingest.
         */
        request?: Schema$GoogleCloudContactcenterinsightsV1mainIngestConversationsRequest;
        /**
         * Output only. Stores the conversation resources produced by ingest sampling operations.
         */
        sampledConversations?: string[] | null;
    }
    /**
     * Statistics for IngestConversations operation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainIngestConversationsMetadataIngestConversationsStats {
        /**
         * Output only. The number of objects skipped because another conversation with the same transcript uri had already been ingested.
         */
        duplicatesSkippedCount?: number | null;
        /**
         * Output only. The number of objects which were unable to be ingested due to errors. The errors are populated in the partial_errors field.
         */
        failedIngestCount?: number | null;
        /**
         * Output only. The number of objects processed during the ingest operation.
         */
        processedObjectCount?: number | null;
        /**
         * Output only. The number of new conversations added during this ingest operation.
         */
        successfulIngestCount?: number | null;
    }
    /**
     * The request to ingest conversations.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainIngestConversationsRequest {
        /**
         * Configuration that applies to all conversations.
         */
        conversationConfig?: Schema$GoogleCloudContactcenterinsightsV1mainIngestConversationsRequestConversationConfig;
        /**
         * A cloud storage bucket source. Note that any previously ingested objects from the source will be skipped to avoid duplication.
         */
        gcsSource?: Schema$GoogleCloudContactcenterinsightsV1mainIngestConversationsRequestGcsSource;
        /**
         * Required. The parent resource for new conversations.
         */
        parent?: string | null;
        /**
         * Optional. DLP settings for transcript redaction. Optional, will default to the config specified in Settings.
         */
        redactionConfig?: Schema$GoogleCloudContactcenterinsightsV1mainRedactionConfig;
        /**
         * Optional. If set, this fields indicates the number of objects to ingest from the Cloud Storage bucket. If empty, the entire bucket will be ingested. Unless they are first deleted, conversations produced through sampling won't be ingested by subsequent ingest requests.
         */
        sampleSize?: number | null;
        /**
         * Optional. Default Speech-to-Text configuration. Optional, will default to the config specified in Settings.
         */
        speechConfig?: Schema$GoogleCloudContactcenterinsightsV1mainSpeechConfig;
        /**
         * Configuration for when `source` contains conversation transcripts.
         */
        transcriptObjectConfig?: Schema$GoogleCloudContactcenterinsightsV1mainIngestConversationsRequestTranscriptObjectConfig;
    }
    /**
     * Configuration that applies to all conversations.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainIngestConversationsRequestConversationConfig {
        /**
         * Optional. Indicates which of the channels, 1 or 2, contains the agent. Note that this must be set for conversations to be properly displayed and analyzed.
         */
        agentChannel?: number | null;
        /**
         * Optional. An opaque, user-specified string representing a human agent who handled all conversations in the import. Note that this will be overridden if per-conversation metadata is provided through the `metadata_bucket_uri`.
         */
        agentId?: string | null;
        /**
         * Optional. Indicates which of the channels, 1 or 2, contains the agent. Note that this must be set for conversations to be properly displayed and analyzed.
         */
        customerChannel?: number | null;
    }
    /**
     * Configuration for Cloud Storage bucket sources.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainIngestConversationsRequestGcsSource {
        /**
         * Optional. The Cloud Storage path to the conversation audio file. Note that: [1] Audio files will be transcribed if not already. [2] Audio files and transcript files must be in separate buckets / folders. [3] A source file and its corresponding audio file must share the same name to be properly ingested, E.g. `gs://bucket/transcript/conversation1.json` and `gs://bucket/audio/conversation1.mp3`.
         */
        audioBucketUri?: string | null;
        /**
         * Optional. Specifies the type of the objects in `bucket_uri`. Avoid passing this. This is inferred from the `transcript_bucket_uri`, `audio_bucket_uri`.
         */
        bucketObjectType?: string | null;
        /**
         * Optional. The Cloud Storage bucket containing source objects. Avoid passing this. Pass this through one of `transcript_bucket_uri` or `audio_bucket_uri`.
         */
        bucketUri?: string | null;
        /**
         * Optional. Custom keys to extract as conversation labels from metadata files in `metadata_bucket_uri`. Keys not included in this field will be ignored. Note that there is a limit of 100 labels per conversation.
         */
        customMetadataKeys?: string[] | null;
        /**
         * Optional. The Cloud Storage path to the conversation metadata. Note that: [1] Metadata files are expected to be in JSON format. [2] Metadata and source files (transcripts or audio) must be in separate buckets / folders. [3] A source file and its corresponding metadata file must share the same name to be properly ingested, E.g. `gs://bucket/audio/conversation1.mp3` and `gs://bucket/metadata/conversation1.json`.
         */
        metadataBucketUri?: string | null;
        /**
         * Optional. The Cloud Storage path to the conversation transcripts. Note that: [1] Transcript files are expected to be in JSON format. [2] Transcript, audio, metadata files must be in separate buckets / folders. [3] A source file and its corresponding metadata file must share the same name to be properly ingested, E.g. `gs://bucket/audio/conversation1.mp3` and `gs://bucket/metadata/conversation1.json`.
         */
        transcriptBucketUri?: string | null;
    }
    /**
     * Configuration for processing transcript objects.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainIngestConversationsRequestTranscriptObjectConfig {
        /**
         * Required. The medium transcript objects represent.
         */
        medium?: string | null;
    }
    /**
     * The response to an IngestConversations operation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainIngestConversationsResponse {
    }
    /**
     * Metadata for initializing a location-level encryption specification.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainInitializeEncryptionSpecMetadata {
        /**
         * Output only. The time the operation was created.
         */
        createTime?: string | null;
        /**
         * Output only. The time the operation finished running.
         */
        endTime?: string | null;
        /**
         * Partial errors during initializing operation that might cause the operation output to be incomplete.
         */
        partialErrors?: Schema$GoogleRpcStatus[];
        /**
         * Output only. The original request for initialization.
         */
        request?: Schema$GoogleCloudContactcenterinsightsV1mainInitializeEncryptionSpecRequest;
    }
    /**
     * The request to initialize a location-level encryption specification.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainInitializeEncryptionSpecRequest {
        /**
         * Required. The encryption spec used for CMEK encryption. It is required that the kms key is in the same region as the endpoint. The same key will be used for all provisioned resources, if encryption is available. If the `kms_key_name` field is left empty, no encryption will be enforced.
         */
        encryptionSpec?: Schema$GoogleCloudContactcenterinsightsV1mainEncryptionSpec;
    }
    /**
     * The response to initialize a location-level encryption specification.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainInitializeEncryptionSpecResponse {
    }
    /**
     * The data for an intent. Represents a detected intent in the conversation, for example MAKES_PROMISE.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainIntent {
        /**
         * The human-readable name of the intent.
         */
        displayName?: string | null;
        /**
         * The unique identifier of the intent.
         */
        id?: string | null;
    }
    /**
     * The data for an intent match. Represents an intent match for a text segment in the conversation. A text segment can be part of a sentence, a complete sentence, or an utterance with multiple sentences.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainIntentMatchData {
        /**
         * The id of the matched intent. Can be used to retrieve the corresponding intent information.
         */
        intentUniqueId?: string | null;
    }
    /**
     * The data for an interruption annotation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainInterruptionData {
    }
    /**
     * The issue resource.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainIssue {
        /**
         * Output only. The time at which this issue was created.
         */
        createTime?: string | null;
        /**
         * Representative description of the issue.
         */
        displayDescription?: string | null;
        /**
         * The representative name for the issue.
         */
        displayName?: string | null;
        /**
         * Immutable. The resource name of the issue. Format: projects/{project\}/locations/{location\}/issueModels/{issue_model\}/issues/{issue\}
         */
        name?: string | null;
        /**
         * Output only. Resource names of the sample representative utterances that match to this issue.
         */
        sampleUtterances?: string[] | null;
        /**
         * Output only. The most recent time that this issue was updated.
         */
        updateTime?: string | null;
    }
    /**
     * Information about the issue.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainIssueAssignment {
        /**
         * Immutable. Display name of the assigned issue. This field is set at time of analysis and immutable since then.
         */
        displayName?: string | null;
        /**
         * Resource name of the assigned issue.
         */
        issue?: string | null;
        /**
         * Score indicating the likelihood of the issue assignment. currently bounded on [0,1].
         */
        score?: number | null;
    }
    /**
     * The data for an issue match annotation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainIssueMatchData {
        /**
         * Information about the issue's assignment.
         */
        issueAssignment?: Schema$GoogleCloudContactcenterinsightsV1mainIssueAssignment;
    }
    /**
     * The issue model resource.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainIssueModel {
        /**
         * Output only. The time at which this issue model was created.
         */
        createTime?: string | null;
        /**
         * The representative name for the issue model.
         */
        displayName?: string | null;
        /**
         * Configs for the input data that used to create the issue model.
         */
        inputDataConfig?: Schema$GoogleCloudContactcenterinsightsV1mainIssueModelInputDataConfig;
        /**
         * Output only. Number of issues in this issue model.
         */
        issueCount?: string | null;
        /**
         * Language of the model.
         */
        languageCode?: string | null;
        /**
         * Type of the model.
         */
        modelType?: string | null;
        /**
         * Immutable. The resource name of the issue model. Format: projects/{project\}/locations/{location\}/issueModels/{issue_model\}
         */
        name?: string | null;
        /**
         * Output only. State of the model.
         */
        state?: string | null;
        /**
         * Output only. Immutable. The issue model's label statistics on its training data.
         */
        trainingStats?: Schema$GoogleCloudContactcenterinsightsV1mainIssueModelLabelStats;
        /**
         * Output only. The most recent time at which the issue model was updated.
         */
        updateTime?: string | null;
    }
    /**
     * Configs for the input data used to create the issue model.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainIssueModelInputDataConfig {
        /**
         * A filter to reduce the conversations used for training the model to a specific subset. Refer to https://cloud.google.com/contact-center/insights/docs/filtering for details.
         */
        filter?: string | null;
        /**
         * Medium of conversations used in training data. This field is being deprecated. To specify the medium to be used in training a new issue model, set the `medium` field on `filter`.
         */
        medium?: string | null;
        /**
         * Output only. Number of conversations used in training. Output only.
         */
        trainingConversationsCount?: string | null;
    }
    /**
     * Aggregated statistics about an issue model.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainIssueModelLabelStats {
        /**
         * Number of conversations the issue model has analyzed at this point in time.
         */
        analyzedConversationsCount?: string | null;
        /**
         * Statistics on each issue. Key is the issue's resource name.
         */
        issueStats?: {
            [key: string]: Schema$GoogleCloudContactcenterinsightsV1mainIssueModelLabelStatsIssueStats;
        } | null;
        /**
         * Number of analyzed conversations for which no issue was applicable at this point in time.
         */
        unclassifiedConversationsCount?: string | null;
    }
    /**
     * Aggregated statistics about an issue.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainIssueModelLabelStatsIssueStats {
        /**
         * Display name of the issue.
         */
        displayName?: string | null;
        /**
         * Issue resource. Format: projects/{project\}/locations/{location\}/issueModels/{issue_model\}/issues/{issue\}
         */
        issue?: string | null;
        /**
         * Number of conversations attached to the issue at this point in time.
         */
        labeledConversationsCount?: string | null;
    }
    /**
     * Issue Modeling result on a conversation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainIssueModelResult {
        /**
         * Issue model that generates the result. Format: projects/{project\}/locations/{location\}/issueModels/{issue_model\}
         */
        issueModel?: string | null;
        /**
         * All the matched issues.
         */
        issues?: Schema$GoogleCloudContactcenterinsightsV1mainIssueAssignment[];
    }
    /**
     * The response for listing all feedback labels.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainListAllFeedbackLabelsResponse {
        /**
         * The feedback labels that match the request.
         */
        feedbackLabels?: Schema$GoogleCloudContactcenterinsightsV1mainFeedbackLabel[];
        /**
         * A token, which can be sent as `page_token` to retrieve the next page. If this field is omitted, there are no subsequent pages.
         */
        nextPageToken?: string | null;
    }
    /**
     * The response for listing feedback labels.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainListFeedbackLabelsResponse {
        /**
         * The feedback labels that match the request.
         */
        feedbackLabels?: Schema$GoogleCloudContactcenterinsightsV1mainFeedbackLabel[];
        /**
         * The next page token.
         */
        nextPageToken?: string | null;
    }
    /**
     * The data for a matched phrase matcher. Represents information identifying a phrase matcher for a given match.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainPhraseMatchData {
        /**
         * The human-readable name of the phrase matcher.
         */
        displayName?: string | null;
        /**
         * The unique identifier (the resource name) of the phrase matcher.
         */
        phraseMatcher?: string | null;
    }
    /**
     * An answer to a QaQuestion.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainQaAnswer {
        /**
         * Lists all answer sources containing one or more answer values of a specific source type, e.g., all system-generated answer sources, or all manual edit answer sources.
         */
        answerSources?: Schema$GoogleCloudContactcenterinsightsV1mainQaAnswerAnswerSource[];
        /**
         * The answer value from this source. This field is populated by default, unless the question has a selection strategy configured to return multiple answer values, in which case `answer_values` will be populated instead.
         */
        answerValue?: Schema$GoogleCloudContactcenterinsightsV1mainQaAnswerAnswerValue;
        /**
         * The conversation the answer applies to.
         */
        conversation?: string | null;
        /**
         * The QaQuestion answered by this answer.
         */
        qaQuestion?: string | null;
        /**
         * Question text. E.g., "Did the agent greet the customer?"
         */
        questionBody?: string | null;
        /**
         * User-defined list of arbitrary tags. Matches the value from QaScorecard.ScorecardQuestion.tags. Used for grouping/organization and for weighting the score of each answer.
         */
        tags?: string[] | null;
    }
    /**
     * A question may have multiple answers from varying sources, one of which becomes the "main" answer above. AnswerSource represents each individual answer.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainQaAnswerAnswerSource {
        /**
         * The answer value from this source. This field is populated by default, unless the question has a selection strategy configured to return multiple answer values, in which case `answer_values` will be populated instead.
         */
        answerValue?: Schema$GoogleCloudContactcenterinsightsV1mainQaAnswerAnswerValue;
        /**
         * What created the answer.
         */
        sourceType?: string | null;
    }
    /**
     * Message for holding the value of a QaAnswer. QaQuestion.AnswerChoice defines the possible answer values for a question.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainQaAnswerAnswerValue {
        /**
         * Boolean value.
         */
        boolValue?: boolean | null;
        /**
         * A short string used as an identifier. Matches the value used in QaQuestion.AnswerChoice.key.
         */
        key?: string | null;
        /**
         * A value of "Not Applicable (N/A)". Should only ever be `true`.
         */
        naValue?: boolean | null;
        /**
         * Output only. Normalized score of the questions. Calculated as score / potential_score.
         */
        normalizedScore?: number | null;
        /**
         * Numerical value.
         */
        numValue?: number | null;
        /**
         * Output only. The maximum potential score of the question.
         */
        potentialScore?: number | null;
        /**
         * Output only. Numerical score of the answer.
         */
        score?: number | null;
        /**
         * Output only. A value of "Skip". If provided, this field may only be set to `true`. If a question receives this answer, it will be excluded from any score calculations. This would mean that the question was not evaluated.
         */
        skipValue?: boolean | null;
        /**
         * String value.
         */
        strValue?: string | null;
    }
    /**
     * A tag is a resource which aims to categorize a set of questions across multiple scorecards, e.g., "Customer Satisfaction","Billing", etc.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainQaQuestionTag {
        /**
         * Output only. The time at which the question tag was created.
         */
        createTime?: string | null;
        /**
         * Required. A user-specified display name for the tag.
         */
        displayName?: string | null;
        /**
         * Identifier. Resource name for the QaQuestionTag Format projects/{project\}/locations/{location\}/qaQuestionTags/{qa_question_tag\} In the above format, the last segment, i.e., qa_question_tag, is a server-generated ID corresponding to the tag resource.
         */
        name?: string | null;
        /**
         * Optional. The list of Scorecard Question IDs that the tag applies to. Each QaQuestionId is represented as a full resource name containing the Question ID. Lastly, Since a tag may not necessarily be referenced by any Scorecard Questions, we treat this field as optional.
         */
        qaQuestionIds?: string[] | null;
        /**
         * Output only. The most recent time at which the question tag was updated.
         */
        updateTime?: string | null;
    }
    /**
     * The results of scoring a single conversation against a QaScorecard. Contains a collection of QaAnswers and aggregate score.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainQaScorecardResult {
        /**
         * ID of the agent that handled the conversation.
         */
        agentId?: string | null;
        /**
         * The conversation scored by this result.
         */
        conversation?: string | null;
        /**
         * Output only. The timestamp that the revision was created.
         */
        createTime?: string | null;
        /**
         * Identifier. The name of the scorecard result. Format: projects/{project\}/locations/{location\}/qaScorecardResults/{qa_scorecard_result\}
         */
        name?: string | null;
        /**
         * The normalized score, which is the score divided by the potential score. Any manual edits are included if they exist.
         */
        normalizedScore?: number | null;
        /**
         * The maximum potential overall score of the scorecard. Any questions answered using `na_value` are excluded from this calculation.
         */
        potentialScore?: number | null;
        /**
         * Set of QaAnswers represented in the result.
         */
        qaAnswers?: Schema$GoogleCloudContactcenterinsightsV1mainQaAnswer[];
        /**
         * The QaScorecardRevision scored by this result.
         */
        qaScorecardRevision?: string | null;
        /**
         * Collection of tags and their scores.
         */
        qaTagResults?: Schema$GoogleCloudContactcenterinsightsV1mainQaScorecardResultQaTagResult[];
        /**
         * The overall numerical score of the result, incorporating any manual edits if they exist.
         */
        score?: number | null;
        /**
         * List of all individual score sets.
         */
        scoreSources?: Schema$GoogleCloudContactcenterinsightsV1mainQaScorecardResultScoreSource[];
    }
    /**
     * Tags and their corresponding results.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainQaScorecardResultQaTagResult {
        /**
         * The normalized score the tag applies to.
         */
        normalizedScore?: number | null;
        /**
         * The potential score the tag applies to.
         */
        potentialScore?: number | null;
        /**
         * The score the tag applies to.
         */
        score?: number | null;
        /**
         * The tag the score applies to.
         */
        tag?: string | null;
    }
    /**
     * A scorecard result may have multiple sets of scores from varying sources, one of which becomes the "main" answer above. A ScoreSource represents each individual set of scores.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainQaScorecardResultScoreSource {
        /**
         * The normalized score, which is the score divided by the potential score.
         */
        normalizedScore?: number | null;
        /**
         * The maximum potential overall score of the scorecard. Any questions answered using `na_value` are excluded from this calculation.
         */
        potentialScore?: number | null;
        /**
         * Collection of tags and their scores.
         */
        qaTagResults?: Schema$GoogleCloudContactcenterinsightsV1mainQaScorecardResultQaTagResult[];
        /**
         * The overall numerical score of the result.
         */
        score?: number | null;
        /**
         * What created the score.
         */
        sourceType?: string | null;
    }
    /**
     * The metadata from querying metrics.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainQueryMetricsMetadata {
        /**
         * Whether the result rows were truncated because the result row size is too large to materialize.
         */
        resultIsTruncated?: boolean | null;
    }
    /**
     * The response for querying metrics.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainQueryMetricsResponse {
        /**
         * Required. The location of the data. "projects/{project\}/locations/{location\}"
         */
        location?: string | null;
        /**
         * The macro average slice contains aggregated averages across all selected dimensions. i.e. if group_by agent and scorecard_id is specified, this field will contain the average across all agents and all scorecards. This field is only populated if the request specifies a Dimension.
         */
        macroAverageSlice?: Schema$GoogleCloudContactcenterinsightsV1mainQueryMetricsResponseSlice;
        /**
         * A slice contains a total and (if the request specified a time granularity) a time series of metric values. Each slice contains a unique combination of the cardinality of dimensions from the request.
         */
        slices?: Schema$GoogleCloudContactcenterinsightsV1mainQueryMetricsResponseSlice[];
        /**
         * The metrics last update time.
         */
        updateTime?: string | null;
    }
    /**
     * A slice contains a total and (if the request specified a time granularity) a time series of metric values. Each slice contains a unique combination of the cardinality of dimensions from the request. For example, if the request specifies a single ISSUE dimension and it has a cardinality of 2 (i.e. the data used to compute the metrics has 2 issues in total), the response will have 2 slices: * Slice 1 -\> dimensions=[Issue 1] * Slice 2 -\> dimensions=[Issue 2]
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainQueryMetricsResponseSlice {
        /**
         * A unique combination of dimensions that this slice represents.
         */
        dimensions?: Schema$GoogleCloudContactcenterinsightsV1mainDimension[];
        /**
         * A time series of metric values. This is only populated if the request specifies a time granularity other than NONE.
         */
        timeSeries?: Schema$GoogleCloudContactcenterinsightsV1mainQueryMetricsResponseSliceTimeSeries;
        /**
         * The total metric value. The interval of this data point is [starting create time, ending create time) from the request.
         */
        total?: Schema$GoogleCloudContactcenterinsightsV1mainQueryMetricsResponseSliceDataPoint;
    }
    /**
     * A data point contains the metric values mapped to an interval.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainQueryMetricsResponseSliceDataPoint {
        /**
         * The measure related to conversations.
         */
        conversationMeasure?: Schema$GoogleCloudContactcenterinsightsV1mainQueryMetricsResponseSliceDataPointConversationMeasure;
        /**
         * The measure related to dialogflow interactions.
         */
        dialogflowInteractionMeasure?: Schema$GoogleCloudContactcenterinsightsV1mainQueryMetricsResponseSliceDataPointDialogflowInteractionMeasure;
        /**
         * The interval that this data point represents. * If this is the total data point, the interval is [starting create time, ending create time) from the request. * If this a data point from the time series, the interval is [time, time + time granularity from the request).
         */
        interval?: Schema$GoogleTypeInterval;
    }
    /**
     * The measure related to conversations.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainQueryMetricsResponseSliceDataPointConversationMeasure {
        /**
         * The number of conversations that were assigned to an AA human supervisor.
         */
        aaSupervisorAssignedConversationsCount?: number | null;
        /**
         * The number of conversations that were dropped, i.e. escalated but not assigned to an AA human supervisor.
         */
        aaSupervisorDroppedConversationsCount?: number | null;
        /**
         * The number of conversations that were escalated to an AA human supervisor for intervention.
         */
        aaSupervisorEscalatedConversationsCount?: number | null;
        /**
         * The number of conversations scanned by the AA human supervisor.
         */
        aaSupervisorMonitoredConversationsCount?: number | null;
        /**
         * The number of conversations transferred to a human agent.
         */
        aaSupervisorTransferredToHumanAgentConvCount?: number | null;
        /**
         * Count of agent messages that triggered an Ai Coach Suggestion.
         */
        aiCoachSuggestionAgentMessageTriggerCount?: number | null;
        /**
         * Count of Ai Coach Suggestion that has been used by agents.
         */
        aiCoachSuggestionAgentUsageCount?: number | null;
        /**
         * Proportion of Ai Coach Suggestion that has been used by agents.
         */
        aiCoachSuggestionAgentUsageRatio?: number | null;
        /**
         * Count of customer messages that triggered an Ai Coach Suggestion.
         */
        aiCoachSuggestionCustomerMessageTriggerCount?: number | null;
        /**
         * Proportion of customer messages that triggered an Ai Coach Suggestion.
         */
        aiCoachSuggestionCustomerMessageTriggerRatio?: number | null;
        /**
         * Count of end_of_utterance trigger event messages that triggered an Ai Coach Suggestion.
         */
        aiCoachSuggestionMessageTriggerCount?: number | null;
        /**
         * Proportion of end_of_utterance trigger event messages that triggered an Ai Coach Suggestion.
         */
        aiCoachSuggestionMessageTriggerRatio?: number | null;
        /**
         * The average agent's sentiment score.
         */
        averageAgentSentimentScore?: number | null;
        /**
         * The average client's sentiment score.
         */
        averageClientSentimentScore?: number | null;
        /**
         * The average customer satisfaction rating.
         */
        averageCustomerSatisfactionRating?: number | null;
        /**
         * The average duration.
         */
        averageDuration?: string | null;
        /**
         * The average normalized QA score for a scorecard. When computing the average across a set of conversations, if a conversation has been evaluated with multiple revisions of a scorecard, only the latest revision results will be used. Will exclude 0's in average calculation. Will be only populated if the request specifies a dimension of QA_SCORECARD_ID.
         */
        averageQaNormalizedScore?: number | null;
        /**
         * Average QA normalized score averaged for questions averaged across all revisions of the parent scorecard. Will be only populated if the request specifies a dimension of QA_QUESTION_ID.
         */
        averageQaQuestionNormalizedScore?: number | null;
        /**
         * The average silence percentage.
         */
        averageSilencePercentage?: number | null;
        /**
         * Average edit distance of the summarization suggestions. Edit distance (also called as levenshtein distance) is calculated by summing up number of insertions, deletions and substitutions required to transform the summization feedback to the original summary suggestion.
         */
        averageSummarizationSuggestionEditDistance?: number | null;
        /**
         * Normalized Average edit distance of the summarization suggestions. Edit distance (also called as levenshtein distance) is calculated by summing up number of insertions, deletions and substitutions required to transform the summization feedback to the original summary suggestion. Normalized edit distance is the average of (edit distance / summary length).
         */
        averageSummarizationSuggestionNormalizedEditDistance?: number | null;
        /**
         * The average turn count.
         */
        averageTurnCount?: number | null;
        /**
         * The exponential moving average of the sentiment score of client turns in the conversation.
         */
        avgConversationClientTurnSentimentEma?: number | null;
        /**
         * The number of conversations that were contained.
         */
        containedConversationCount?: number | null;
        /**
         * The percentage of conversations that were contained.
         */
        containedConversationRatio?: number | null;
        /**
         * Count of conversations that has Ai Coach Suggestions.
         */
        conversationAiCoachSuggestionCount?: number | null;
        /**
         * Proportion of conversations that has Ai Coach Suggestions.
         */
        conversationAiCoachSuggestionRatio?: number | null;
        /**
         * The average latency of conversational agents' audio in audio out latency per interaction. This is computed as the average of the all the interactions' audio in audio out latencies in a conversation and averaged across conversations.
         */
        conversationalAgentsAverageAudioInAudioOutLatency?: number | null;
        /**
         * The average latency of conversational agents' latency per interaction. This is computed as the average of the all the iteractions' end to end latencies in a conversation and averaged across conversations. The e2e latency is the time between the end of the user utterance and the start of the agent utterance on the interaction level.
         */
        conversationalAgentsAverageEndToEndLatency?: number | null;
        /**
         * The average latency of conversational agents' LLM call latency per interaction. This is computed as the average of the all the interactions LLM call latencies in a conversation and averaged across conversations.
         */
        conversationalAgentsAverageLlmCallLatency?: number | null;
        /**
         * The macro average latency of conversational agents' TTS latency per interaction. This is computed as the average of the all the interactions' TTS latencies in a conversation and averaged across conversations.
         */
        conversationalAgentsAverageTtsLatency?: number | null;
        /**
         * The conversation count.
         */
        conversationCount?: number | null;
        /**
         * Proportion of conversations that had a suggested summary.
         */
        conversationSuggestedSummaryRatio?: number | null;
        /**
         * The agent message count.
         */
        conversationTotalAgentMessageCount?: number | null;
        /**
         * The customer message count.
         */
        conversationTotalCustomerMessageCount?: number | null;
        /**
         * Average latency of dialogflow webhook calls.
         */
        dialogflowAverageWebhookLatency?: number | null;
        /**
         * count of conversations that was handed off from virtual agent to human agent.
         */
        dialogflowConversationsEscalationCount?: number | null;
        /**
         * Proportion of conversations that was handed off from virtual agent to human agent.
         */
        dialogflowConversationsEscalationRatio?: number | null;
        /**
         * Proportion of dialogflow interactions that has empty input.
         */
        dialogflowInteractionsNoInputRatio?: number | null;
        /**
         * Proportion of dialogflow interactions that has no intent match for the input.
         */
        dialogflowInteractionsNoMatchRatio?: number | null;
        /**
         * Proportion of dialogflow webhook calls that failed.
         */
        dialogflowWebhookFailureRatio?: number | null;
        /**
         * Proportion of dialogflow webhook calls that timed out.
         */
        dialogflowWebhookTimeoutRatio?: number | null;
        /**
         * Proportion of knowledge assist (Proactive Generative Knowledge Assist) queries that had negative feedback.
         */
        knowledgeAssistNegativeFeedbackRatio?: number | null;
        /**
         * Proportion of knowledge assist (Proactive Generative Knowledge Assist) queries that had positive feedback.
         */
        knowledgeAssistPositiveFeedbackRatio?: number | null;
        /**
         * Count of knowledge assist results (Proactive Generative Knowledge Assist) shown to the user.
         */
        knowledgeAssistResultCount?: number | null;
        /**
         * Proportion of knowledge assist (Proactive Generative Knowledge Assist) queries that had a URL clicked.
         */
        knowledgeAssistUriClickRatio?: number | null;
        /**
         * Proportion of knowledge search (Generative Knowledge Assist) queries made by the agent compared to the total number of knowledge search queries made.
         */
        knowledgeSearchAgentQuerySourceRatio?: number | null;
        /**
         * Proportion of knowledge search (Generative Knowledge Assist) queries that had negative feedback.
         */
        knowledgeSearchNegativeFeedbackRatio?: number | null;
        /**
         * Proportion of knowledge search (Generative Knowledge Assist) queries that had positive feedback.
         */
        knowledgeSearchPositiveFeedbackRatio?: number | null;
        /**
         * Count of knowledge search results (Generative Knowledge Assist) shown to the user.
         */
        knowledgeSearchResultCount?: number | null;
        /**
         * Proportion of knowledge search (Generative Knowledge Assist) queries suggested compared to the total number of knowledge search queries made.
         */
        knowledgeSearchSuggestedQuerySourceRatio?: number | null;
        /**
         * Proportion of knowledge search (Generative Knowledge Assist) queries that had a URL clicked.
         */
        knowledgeSearchUriClickRatio?: number | null;
        /**
         * Average QA normalized score for all the tags.
         */
        qaTagScores?: Schema$GoogleCloudContactcenterinsightsV1mainQueryMetricsResponseSliceDataPointConversationMeasureQaTagScore[];
        /**
         * Proportion of summarization suggestions that were manually edited.
         */
        summarizationSuggestionEditRatio?: number | null;
        /**
         * Count of summarization suggestions results.
         */
        summarizationSuggestionResultCount?: number | null;
    }
    /**
     * Average QA normalized score for the tag.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainQueryMetricsResponseSliceDataPointConversationMeasureQaTagScore {
        /**
         * Average tag normalized score per tag.
         */
        averageTagNormalizedScore?: number | null;
        /**
         * Tag name.
         */
        tag?: string | null;
    }
    /**
     * The measure related to dialogflow interactions.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainQueryMetricsResponseSliceDataPointDialogflowInteractionMeasure {
        /**
         * The percentile result for audio in audio out latency in milliseconds per dialogflow interaction level.
         */
        percentileAudioInAudioOutLatency?: Schema$GoogleCloudContactcenterinsightsV1mainQueryMetricsResponseSliceDataPointPercentileResult;
        /**
         * The percentile result for end to end chat latency in milliseconds per dialogflow interaction level.
         */
        percentileEndToEndLatency?: Schema$GoogleCloudContactcenterinsightsV1mainQueryMetricsResponseSliceDataPointPercentileResult;
        /**
         * The percentile result for LLM latency in milliseconds per dialogflow interaction level.
         */
        percentileLlmCallLatency?: Schema$GoogleCloudContactcenterinsightsV1mainQueryMetricsResponseSliceDataPointPercentileResult;
        /**
         * The percentile result for tool use latency in milliseconds per dialogflow interaction level.
         */
        percentileToolUseLatency?: Schema$GoogleCloudContactcenterinsightsV1mainQueryMetricsResponseSliceDataPointPercentileResult;
        /**
         * The percentile result for TTS latency in milliseconds per dialogflow interaction level.
         */
        percentileTtsLatency?: Schema$GoogleCloudContactcenterinsightsV1mainQueryMetricsResponseSliceDataPointPercentileResult;
    }
    /**
     * The percentile result. Currently supported percentiles are 50th, 90th, and 99th.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainQueryMetricsResponseSliceDataPointPercentileResult {
        /**
         * The 50th percentile value.
         */
        p50?: number | null;
        /**
         * The 90th percentile value.
         */
        p90?: number | null;
        /**
         * The 99th percentile value.
         */
        p99?: number | null;
    }
    /**
     * A time series of metric values.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainQueryMetricsResponseSliceTimeSeries {
        /**
         * The data points that make up the time series .
         */
        dataPoints?: Schema$GoogleCloudContactcenterinsightsV1mainQueryMetricsResponseSliceDataPoint[];
    }
    /**
     * The metadata for querying performance overview.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainQueryPerformanceOverviewMetadata {
    }
    /**
     * The response for querying performance overview.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainQueryPerformanceOverviewResponse {
        /**
         * The summary text of the performance.
         */
        summaryText?: string | null;
    }
    /**
     * DLP resources used for redaction while ingesting conversations. DLP settings are applied to conversations ingested from the `UploadConversation` and `IngestConversations` endpoints, including conversation coming from CCAI Platform. They are not applied to conversations ingested from the `CreateConversation` endpoint or the Dialogflow / Agent Assist runtime integrations. When using Dialogflow / Agent Assist runtime integrations, redaction should be performed in Dialogflow / Agent Assist.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainRedactionConfig {
        /**
         * The fully-qualified DLP deidentify template resource name. Format: `projects/{project\}/deidentifyTemplates/{template\}`
         */
        deidentifyTemplate?: string | null;
        /**
         * The fully-qualified DLP inspect template resource name. Format: `projects/{project\}/locations/{location\}/inspectTemplates/{template\}`
         */
        inspectTemplate?: string | null;
    }
    /**
     * An annotation that was generated during the customer and agent interaction.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainRuntimeAnnotation {
        /**
         * The unique identifier of the annotation. Format: projects/{project\}/locations/{location\}/conversationDatasets/{dataset\}/conversationDataItems/{data_item\}/conversationAnnotations/{annotation\}
         */
        annotationId?: string | null;
        /**
         * The feedback that the customer has about the answer in `data`.
         */
        answerFeedback?: Schema$GoogleCloudContactcenterinsightsV1mainAnswerFeedback;
        /**
         * Agent Assist Article Suggestion data.
         */
        articleSuggestion?: Schema$GoogleCloudContactcenterinsightsV1mainArticleSuggestionData;
        /**
         * Conversation summarization suggestion data.
         */
        conversationSummarizationSuggestion?: Schema$GoogleCloudContactcenterinsightsV1mainConversationSummarizationSuggestionData;
        /**
         * The time at which this annotation was created.
         */
        createTime?: string | null;
        /**
         * Dialogflow interaction data.
         */
        dialogflowInteraction?: Schema$GoogleCloudContactcenterinsightsV1mainDialogflowInteractionData;
        /**
         * The boundary in the conversation where the annotation ends, inclusive.
         */
        endBoundary?: Schema$GoogleCloudContactcenterinsightsV1mainAnnotationBoundary;
        /**
         * Agent Assist FAQ answer data.
         */
        faqAnswer?: Schema$GoogleCloudContactcenterinsightsV1mainFaqAnswerData;
        /**
         * Agent Assist Smart Compose suggestion data.
         */
        smartComposeSuggestion?: Schema$GoogleCloudContactcenterinsightsV1mainSmartComposeSuggestionData;
        /**
         * Agent Assist Smart Reply data.
         */
        smartReply?: Schema$GoogleCloudContactcenterinsightsV1mainSmartReplyData;
        /**
         * The boundary in the conversation where the annotation starts, inclusive.
         */
        startBoundary?: Schema$GoogleCloudContactcenterinsightsV1mainAnnotationBoundary;
        /**
         * Explicit input used for generating the answer
         */
        userInput?: Schema$GoogleCloudContactcenterinsightsV1mainRuntimeAnnotationUserInput;
    }
    /**
     * Explicit input used for generating the answer
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainRuntimeAnnotationUserInput {
        /**
         * The resource name of associated generator. Format: `projects//locations//generators/`
         */
        generatorName?: string | null;
        /**
         * Query text. Article Search uses this to store the input query used to generate the search results.
         */
        query?: string | null;
        /**
         * Query source for the answer.
         */
        querySource?: string | null;
    }
    /**
     * The metadata for an SampleConversations operation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainSampleConversationsMetadata {
        /**
         * Output only. The time the operation was created.
         */
        createTime?: string | null;
        /**
         * Output only. The time the operation finished running.
         */
        endTime?: string | null;
        /**
         * Output only. Partial errors during sample conversations operation that might cause the operation output to be incomplete.
         */
        partialErrors?: Schema$GoogleRpcStatus[];
        /**
         * Output only. The original request for sample conversations to dataset.
         */
        request?: Schema$GoogleCloudContactcenterinsightsV1mainSampleConversationsRequest;
        /**
         * Output only. Statistics for SampleConversations operation.
         */
        sampleConversationsStats?: Schema$GoogleCloudContactcenterinsightsV1mainSampleConversationsMetadataSampleConversationsStats;
    }
    /**
     * Statistics for SampleConversations operation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainSampleConversationsMetadataSampleConversationsStats {
        /**
         * Output only. The number of objects which were unable to be sampled due to errors. The errors are populated in the partial_errors field.
         */
        failedSampleCount?: number | null;
        /**
         * Output only. The number of new conversations added during this sample operation.
         */
        successfulSampleCount?: number | null;
    }
    /**
     * The request to sample conversations to a dataset.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainSampleConversationsRequest {
        /**
         * The dataset resource to copy the sampled conversations to.
         */
        destinationDataset?: Schema$GoogleCloudContactcenterinsightsV1mainDataset;
        /**
         * Required. The parent resource of the dataset.
         */
        parent?: string | null;
        /**
         * Optional. The sample rule used for sampling conversations.
         */
        sampleRule?: Schema$GoogleCloudContactcenterinsightsV1mainSampleRule;
    }
    /**
     * The response to an SampleConversations operation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainSampleConversationsResponse {
    }
    /**
     * Message for sampling conversations.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainSampleRule {
        /**
         * To specify the filter for the conversions that should apply this sample rule. An empty filter means this sample rule applies to all conversations.
         */
        conversationFilter?: string | null;
        /**
         * Optional. Group by dimension to sample the conversation. If no dimension is provided, the sampling will be applied to the project level. Current supported dimensions is 'quality_metadata.agent_info.agent_id'.
         */
        dimension?: string | null;
        /**
         * Percentage of conversations that we should sample based on the dimension between [0, 100].
         */
        samplePercentage?: number | null;
        /**
         * Number of the conversations that we should sample based on the dimension.
         */
        sampleRow?: string | null;
    }
    /**
     * The data for a sentiment annotation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainSentimentData {
        /**
         * A non-negative number from 0 to infinity which represents the absolute magnitude of sentiment regardless of score.
         */
        magnitude?: number | null;
        /**
         * The sentiment score between -1.0 (negative) and 1.0 (positive).
         */
        score?: number | null;
    }
    /**
     * The data for a silence annotation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainSilenceData {
    }
    /**
     * Agent Assist Smart Compose suggestion data.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainSmartComposeSuggestionData {
        /**
         * The system's confidence score that this suggestion is a good match for this conversation, ranging from 0.0 (completely uncertain) to 1.0 (completely certain).
         */
        confidenceScore?: number | null;
        /**
         * Map that contains metadata about the Smart Compose suggestion and the document from which it originates.
         */
        metadata?: {
            [key: string]: string;
        } | null;
        /**
         * The name of the answer record. Format: projects/{project\}/locations/{location\}/answerRecords/{answer_record\}
         */
        queryRecord?: string | null;
        /**
         * The content of the suggestion.
         */
        suggestion?: string | null;
    }
    /**
     * Agent Assist Smart Reply data.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainSmartReplyData {
        /**
         * The system's confidence score that this reply is a good match for this conversation, ranging from 0.0 (completely uncertain) to 1.0 (completely certain).
         */
        confidenceScore?: number | null;
        /**
         * Map that contains metadata about the Smart Reply and the document from which it originates.
         */
        metadata?: {
            [key: string]: string;
        } | null;
        /**
         * The name of the answer record. Format: projects/{project\}/locations/{location\}/answerRecords/{answer_record\}
         */
        queryRecord?: string | null;
        /**
         * The content of the reply.
         */
        reply?: string | null;
    }
    /**
     * Speech-to-Text configuration. Speech-to-Text settings are applied to conversations ingested from the `UploadConversation` and `IngestConversations` endpoints, including conversation coming from CCAI Platform. They are not applied to conversations ingested from the `CreateConversation` endpoint.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainSpeechConfig {
        /**
         * Whether to disable word time offsets. If true, the `enable_word_time_offsets` field in the recognition config will be set to false.
         */
        disableWordTimeOffsets?: boolean | null;
        /**
         * The fully-qualified Speech Recognizer resource name. Format: `projects/{project_id\}/locations/{location\}/recognizer/{recognizer\}`
         */
        speechRecognizer?: string | null;
    }
    /**
     * Metadata for testing correlation config.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainTestCorrelationConfigMetadata {
        /**
         * Output only. The time the operation was created.
         */
        createTime?: string | null;
        /**
         * The dataset used for sampling conversations.
         */
        dataset?: string | null;
        /**
         * The statistics for the operation.
         */
        stats?: Schema$GoogleCloudContactcenterinsightsV1mainTestCorrelationConfigMetadataFullConversationCorrelationStats;
    }
    /**
     * Statistics for TestCorrelationConfig operation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainTestCorrelationConfigMetadataFullConversationCorrelationStats {
        /**
         * A list of errors that occurred during correlation, one for each conversation that failed.
         */
        conversationCorrelationErrors?: Schema$GoogleCloudContactcenterinsightsV1mainTestCorrelationConfigMetadataFullConversationCorrelationStatsConversationCorrelationError[];
        /**
         * The number of conversations correlated.
         */
        correlatedConversationsCount?: number | null;
        /**
         * The number of conversations that failed correlation.
         */
        failedConversationsCount?: number | null;
        /**
         * Partial errors during test correlation config operation that might cause the operation output to be incomplete.
         */
        partialErrors?: Schema$GoogleRpcStatus[];
        /**
         * The number of conversations sampled.
         */
        sampledConversationsCount?: number | null;
    }
    /**
     * An error that occurred during correlation for a specific conversation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainTestCorrelationConfigMetadataFullConversationCorrelationStatsConversationCorrelationError {
        /**
         * The conversation resource name that had an error during correlation.
         */
        conversation?: string | null;
        /**
         * The error status.
         */
        status?: Schema$GoogleRpcStatus;
    }
    /**
     * The response of testing correlation config.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainTestCorrelationConfigResponse {
        /**
         * Results for the DETAILED_SYNC execution mode.
         */
        detailedResults?: Schema$GoogleCloudContactcenterinsightsV1mainTestCorrelationConfigResponseDetailedCorrelationResults;
        /**
         * Partial errors during test correlation config operation that might cause the operation output to be incomplete.
         */
        partialErrors?: Schema$GoogleRpcStatus[];
    }
    /**
     * Wrapper for detailed, step-by-step results.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainTestCorrelationConfigResponseDetailedCorrelationResults {
        /**
         * A list of constraint evaluation results for each pair of conversations.
         */
        constraintResults?: Schema$GoogleCloudContactcenterinsightsV1mainConstraintEvaluationResult[];
        /**
         * A list of join key correlation results for each conversation tested.
         */
        joinKeyResults?: Schema$GoogleCloudContactcenterinsightsV1mainConversationCorrelationResult[];
    }
    /**
     * Metadata for undeploying an issue model.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainUndeployIssueModelMetadata {
        /**
         * Output only. The time the operation was created.
         */
        createTime?: string | null;
        /**
         * Output only. The time the operation finished running.
         */
        endTime?: string | null;
        /**
         * The original request for undeployment.
         */
        request?: Schema$GoogleCloudContactcenterinsightsV1mainUndeployIssueModelRequest;
    }
    /**
     * The request to undeploy an issue model.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainUndeployIssueModelRequest {
        /**
         * Required. The issue model to undeploy.
         */
        name?: string | null;
    }
    /**
     * The response to undeploy an issue model.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainUndeployIssueModelResponse {
    }
    /**
     * The metadata for updating a QaQuestionTag Resource.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainUpdateQaQuestionTagMetadata {
        /**
         * Output only. The time the operation was created.
         */
        createTime?: string | null;
        /**
         * Output only. The time the operation finished running.
         */
        endTime?: string | null;
        /**
         * Output only. The original request.
         */
        request?: Schema$GoogleCloudContactcenterinsightsV1mainUpdateQaQuestionTagRequest;
    }
    /**
     * The request for updating a QaQuestionTag.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainUpdateQaQuestionTagRequest {
        /**
         * Required. The QaQuestionTag to update.
         */
        qaQuestionTag?: Schema$GoogleCloudContactcenterinsightsV1mainQaQuestionTag;
        /**
         * Optional. The list of fields to be updated. All possible fields can be updated by passing `*`, or a subset of the following updateable fields can be provided: * `qa_question_tag_name` - the name of the tag * `qa_question_ids` - the list of questions the tag applies to
         */
        updateMask?: string | null;
    }
    /**
     * The metadata for an `UploadConversation` operation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainUploadConversationMetadata {
        /**
         * Output only. The operation name for a successfully created analysis operation, if any.
         */
        analysisOperation?: string | null;
        /**
         * Output only. The redaction config applied to the uploaded conversation.
         */
        appliedRedactionConfig?: Schema$GoogleCloudContactcenterinsightsV1mainRedactionConfig;
        /**
         * Output only. The time the operation was created.
         */
        createTime?: string | null;
        /**
         * Output only. The time the operation finished running.
         */
        endTime?: string | null;
        /**
         * Output only. The original request.
         */
        request?: Schema$GoogleCloudContactcenterinsightsV1mainUploadConversationRequest;
    }
    /**
     * Request to upload a conversation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1mainUploadConversationRequest {
        /**
         * Required. The conversation resource to create.
         */
        conversation?: Schema$GoogleCloudContactcenterinsightsV1mainConversation;
        /**
         * Optional. A unique ID for the new conversation. This ID will become the final component of the conversation's resource name. If no ID is specified, a server-generated ID will be used. This value should be 4-64 characters and must match the regular expression `^[a-z0-9-]{4,64\}$`. Valid characters are `a-z-`
         */
        conversationId?: string | null;
        /**
         * Required. The parent resource of the conversation.
         */
        parent?: string | null;
        /**
         * Optional. DLP settings for transcript redaction. Will default to the config specified in Settings.
         */
        redactionConfig?: Schema$GoogleCloudContactcenterinsightsV1mainRedactionConfig;
        /**
         * Optional. Speech-to-Text configuration. Will default to the config specified in Settings.
         */
        speechConfig?: Schema$GoogleCloudContactcenterinsightsV1mainSpeechConfig;
    }
    /**
     * The conversation assessment note resource.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1Note {
        /**
         * The note is associated to the entire parent assessment.
         */
        assessmentNote?: Schema$GoogleCloudContactcenterinsightsV1NoteAssessmentNote;
        /**
         * The note content.
         */
        content?: string | null;
        /**
         * The note is associated with a conversation turn.
         */
        conversationTurnNote?: Schema$GoogleCloudContactcenterinsightsV1NoteConversationTurnNote;
        /**
         * Output only. The time at which the note was created.
         */
        createTime?: string | null;
        /**
         * Identifier. The resource name of the note. Format: projects/{project\}/locations/{location\}/conversations/{conversation\}/assessments/{assessment\}/notes/{note\}
         */
        name?: string | null;
        /**
         * Output only. The user that created the note.
         */
        noteCreator?: Schema$GoogleCloudContactcenterinsightsV1UserInfo;
        /**
         * The note is associated with a QA question in one of the conversation's scorecard results.
         */
        qaQuestionNote?: Schema$GoogleCloudContactcenterinsightsV1NoteQaQuestionNote;
        /**
         * Output only. The time at which the note was last updated.
         */
        updateTime?: string | null;
    }
    /**
     * A note about the entire parent assessment.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1NoteAssessmentNote {
    }
    /**
     * A note about a conversation turn.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1NoteConversationTurnNote {
        /**
         * The conversation turn index that the note is associated with.
         */
        turnIndex?: number | null;
    }
    /**
     * A note about a QA question.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1NoteQaQuestionNote {
        /**
         * The question resource that the note is associated with.
         */
        qaQuestion?: string | null;
    }
    /**
     * The data for a matched phrase matcher. Represents information identifying a phrase matcher for a given match.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1PhraseMatchData {
        /**
         * The human-readable name of the phrase matcher.
         */
        displayName?: string | null;
        /**
         * The unique identifier (the resource name) of the phrase matcher.
         */
        phraseMatcher?: string | null;
    }
    /**
     * The phrase matcher resource.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1PhraseMatcher {
        /**
         * Output only. The most recent time at which the activation status was updated.
         */
        activationUpdateTime?: string | null;
        /**
         * Applies the phrase matcher only when it is active.
         */
        active?: boolean | null;
        /**
         * The human-readable name of the phrase matcher.
         */
        displayName?: string | null;
        /**
         * The resource name of the phrase matcher. Format: projects/{project\}/locations/{location\}/phraseMatchers/{phrase_matcher\}
         */
        name?: string | null;
        /**
         * A list of phase match rule groups that are included in this matcher.
         */
        phraseMatchRuleGroups?: Schema$GoogleCloudContactcenterinsightsV1PhraseMatchRuleGroup[];
        /**
         * Output only. The timestamp of when the revision was created. It is also the create time when a new matcher is added.
         */
        revisionCreateTime?: string | null;
        /**
         * Output only. Immutable. The revision ID of the phrase matcher. A new revision is committed whenever the matcher is changed, except when it is activated or deactivated. A server generated random ID will be used. Example: locations/global/phraseMatchers/my-first-matcher@1234567
         */
        revisionId?: string | null;
        /**
         * The role whose utterances the phrase matcher should be matched against. If the role is ROLE_UNSPECIFIED it will be matched against any utterances in the transcript.
         */
        roleMatch?: string | null;
        /**
         * Required. The type of this phrase matcher.
         */
        type?: string | null;
        /**
         * Output only. The most recent time at which the phrase matcher was updated.
         */
        updateTime?: string | null;
        /**
         * The customized version tag to use for the phrase matcher. If not specified, it will default to `revision_id`.
         */
        versionTag?: string | null;
    }
    /**
     * The data for a phrase match rule.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1PhraseMatchRule {
        /**
         * Provides additional information about the rule that specifies how to apply the rule.
         */
        config?: Schema$GoogleCloudContactcenterinsightsV1PhraseMatchRuleConfig;
        /**
         * Specifies whether the phrase must be missing from the transcript segment or present in the transcript segment.
         */
        negated?: boolean | null;
        /**
         * Required. The phrase to be matched.
         */
        query?: string | null;
    }
    /**
     * Configuration information of a phrase match rule.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1PhraseMatchRuleConfig {
        /**
         * The configuration for the exact match rule.
         */
        exactMatchConfig?: Schema$GoogleCloudContactcenterinsightsV1ExactMatchConfig;
        /**
         * The configuration for the regex match rule.
         */
        regexMatchConfig?: Schema$GoogleCloudContactcenterinsightsV1RegexMatchConfig;
    }
    /**
     * A message representing a rule in the phrase matcher.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1PhraseMatchRuleGroup {
        /**
         * A list of phrase match rules that are included in this group.
         */
        phraseMatchRules?: Schema$GoogleCloudContactcenterinsightsV1PhraseMatchRule[];
        /**
         * Required. The type of this phrase match rule group.
         */
        type?: string | null;
    }
    /**
     * The message to publish an assessment. Draft and appealed assessments can be published. Publishing simply changes the state of the assessment to published, allowing the console and authorized views to filter on the state.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1PublishAssessmentRequest {
    }
    /**
     * An answer to a QaQuestion.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1QaAnswer {
        /**
         * Lists all answer sources containing one or more answer values of a specific source type, e.g., all system-generated answer sources, or all manual edit answer sources.
         */
        answerSources?: Schema$GoogleCloudContactcenterinsightsV1QaAnswerAnswerSource[];
        /**
         * The answer value from this source. This field is populated by default, unless the question has a selection strategy configured to return multiple answer values, in which case `answer_values` will be populated instead.
         */
        answerValue?: Schema$GoogleCloudContactcenterinsightsV1QaAnswerAnswerValue;
        /**
         * The conversation the answer applies to.
         */
        conversation?: string | null;
        /**
         * The QaQuestion answered by this answer.
         */
        qaQuestion?: string | null;
        /**
         * Question text. E.g., "Did the agent greet the customer?"
         */
        questionBody?: string | null;
        /**
         * User-defined list of arbitrary tags. Matches the value from QaScorecard.ScorecardQuestion.tags. Used for grouping/organization and for weighting the score of each answer.
         */
        tags?: string[] | null;
    }
    /**
     * A question may have multiple answers from varying sources, one of which becomes the "main" answer above. AnswerSource represents each individual answer.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1QaAnswerAnswerSource {
        /**
         * The answer value from this source. This field is populated by default, unless the question has a selection strategy configured to return multiple answer values, in which case `answer_values` will be populated instead.
         */
        answerValue?: Schema$GoogleCloudContactcenterinsightsV1QaAnswerAnswerValue;
        /**
         * What created the answer.
         */
        sourceType?: string | null;
    }
    /**
     * Message for holding the value of a QaAnswer. QaQuestion.AnswerChoice defines the possible answer values for a question.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1QaAnswerAnswerValue {
        /**
         * Boolean value.
         */
        boolValue?: boolean | null;
        /**
         * A short string used as an identifier. Matches the value used in QaQuestion.AnswerChoice.key.
         */
        key?: string | null;
        /**
         * A value of "Not Applicable (N/A)". Should only ever be `true`.
         */
        naValue?: boolean | null;
        /**
         * Output only. Normalized score of the questions. Calculated as score / potential_score.
         */
        normalizedScore?: number | null;
        /**
         * Numerical value.
         */
        numValue?: number | null;
        /**
         * Output only. The maximum potential score of the question.
         */
        potentialScore?: number | null;
        /**
         * Output only. Numerical score of the answer.
         */
        score?: number | null;
        /**
         * Output only. A value of "Skip". If provided, this field may only be set to `true`. If a question receives this answer, it will be excluded from any score calculations. This would mean that the question was not evaluated.
         */
        skipValue?: boolean | null;
        /**
         * String value.
         */
        strValue?: string | null;
    }
    /**
     * A single question to be scored by the Insights QA feature.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1QaQuestion {
        /**
         * Short, descriptive string, used in the UI where it's not practical to display the full question body. E.g., "Greeting".
         */
        abbreviation?: string | null;
        /**
         * A list of valid answers to the question, which the LLM must choose from.
         */
        answerChoices?: Schema$GoogleCloudContactcenterinsightsV1QaQuestionAnswerChoice[];
        /**
         * Instructions describing how to determine the answer.
         */
        answerInstructions?: string | null;
        /**
         * Output only. The time at which this question was created.
         */
        createTime?: string | null;
        /**
         * Metrics of the underlying tuned LLM over a holdout/test set while fine tuning the underlying LLM for the given question. This field will only be populated if and only if the question is part of a scorecard revision that has been tuned.
         */
        metrics?: Schema$GoogleCloudContactcenterinsightsV1QaQuestionMetrics;
        /**
         * Identifier. The resource name of the question. Format: projects/{project\}/locations/{location\}/qaScorecards/{qa_scorecard\}/revisions/{revision\}/qaQuestions/{qa_question\}
         */
        name?: string | null;
        /**
         * Defines the order of the question within its parent scorecard revision.
         */
        order?: number | null;
        /**
         * The configuration of the predefined question. This field will only be set if the Question Type is predefined.
         */
        predefinedQuestionConfig?: Schema$GoogleCloudContactcenterinsightsV1QaQuestionPredefinedQuestionConfig;
        /**
         * Options for configuring the data used to generate the QA question.
         */
        qaQuestionDataOptions?: Schema$GoogleCloudContactcenterinsightsV1QaQuestionQaQuestionDataOptions;
        /**
         * Question text. E.g., "Did the agent greet the customer?"
         */
        questionBody?: string | null;
        /**
         * The type of question.
         */
        questionType?: string | null;
        /**
         * Questions are tagged for categorization and scoring. Tags can either be: - Default Tags: These are predefined categories. They are identified by their string value (e.g., "BUSINESS", "COMPLIANCE", and "CUSTOMER"). - Custom Tags: These are user-defined categories. They are identified by their full resource name (e.g., projects/{project\}/locations/{location\}/qaQuestionTags/{qa_question_tag\}). Both default and custom tags are used to group questions and to influence the scoring of each question.
         */
        tags?: string[] | null;
        /**
         * Metadata about the tuning operation for the question.This field will only be populated if and only if the question is part of a scorecard revision that has been tuned.
         */
        tuningMetadata?: Schema$GoogleCloudContactcenterinsightsV1QaQuestionTuningMetadata;
        /**
         * Output only. The most recent time at which the question was updated.
         */
        updateTime?: string | null;
    }
    /**
     * Message representing a possible answer to the question.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1QaQuestionAnswerChoice {
        /**
         * Boolean value.
         */
        boolValue?: boolean | null;
        /**
         * A short string used as an identifier.
         */
        key?: string | null;
        /**
         * A value of "Not Applicable (N/A)". If provided, this field may only be set to `true`. If a question receives this answer, it will be excluded from any score calculations.
         */
        naValue?: boolean | null;
        /**
         * Numerical value.
         */
        numValue?: number | null;
        /**
         * Numerical score of the answer, used for generating the overall score of a QaScorecardResult. If the answer uses na_value, this field is unused.
         */
        score?: number | null;
        /**
         * String value.
         */
        strValue?: string | null;
    }
    /**
     * A wrapper representing metrics calculated against a test-set on a LLM that was fine tuned for this question.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1QaQuestionMetrics {
        /**
         * Output only. Accuracy of the model. Measures the percentage of correct answers the model gave on the test set.
         */
        accuracy?: number | null;
    }
    /**
     * Configuration for a predefined question. This field will only be set if the Question Type is predefined.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1QaQuestionPredefinedQuestionConfig {
        /**
         * The type of the predefined question.
         */
        type?: string | null;
    }
    /**
     * Options for configuring the data used to generate the QA question.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1QaQuestionQaQuestionDataOptions {
        /**
         * Options for configuring the conversation data used to generate the QA question.
         */
        conversationDataOptions?: Schema$GoogleCloudContactcenterinsightsV1ConversationDataOptions;
    }
    /**
     * A tag is a resource which aims to categorize a set of questions across multiple scorecards, e.g., "Customer Satisfaction","Billing", etc.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1QaQuestionTag {
        /**
         * Output only. The time at which the question tag was created.
         */
        createTime?: string | null;
        /**
         * Required. A user-specified display name for the tag.
         */
        displayName?: string | null;
        /**
         * Identifier. Resource name for the QaQuestionTag Format projects/{project\}/locations/{location\}/qaQuestionTags/{qa_question_tag\} In the above format, the last segment, i.e., qa_question_tag, is a server-generated ID corresponding to the tag resource.
         */
        name?: string | null;
        /**
         * Optional. The list of Scorecard Question IDs that the tag applies to. Each QaQuestionId is represented as a full resource name containing the Question ID. Lastly, Since a tag may not necessarily be referenced by any Scorecard Questions, we treat this field as optional.
         */
        qaQuestionIds?: string[] | null;
        /**
         * Output only. The most recent time at which the question tag was updated.
         */
        updateTime?: string | null;
    }
    /**
     * Metadata about the tuning operation for the question. Will only be set if a scorecard containing this question has been tuned.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1QaQuestionTuningMetadata {
        /**
         * A list of any applicable data validation warnings about the question's feedback labels.
         */
        datasetValidationWarnings?: string[] | null;
        /**
         * Total number of valid labels provided for the question at the time of tuining.
         */
        totalValidLabelCount?: string | null;
        /**
         * Error status of the tuning operation for the question. Will only be set if the tuning operation failed.
         */
        tuningError?: string | null;
    }
    /**
     * A QaScorecard represents a collection of questions to be scored during analysis.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1QaScorecard {
        /**
         * Output only. The time at which this scorecard was created.
         */
        createTime?: string | null;
        /**
         * A text description explaining the intent of the scorecard.
         */
        description?: string | null;
        /**
         * The user-specified display name of the scorecard.
         */
        displayName?: string | null;
        /**
         * Whether the scorecard is the default one for the project. A default scorecard cannot be deleted and will always appear first in scorecard selector.
         */
        isDefault?: boolean | null;
        /**
         * Identifier. The scorecard name. Format: projects/{project\}/locations/{location\}/qaScorecards/{qa_scorecard\}
         */
        name?: string | null;
        /**
         * Output only. The source of the scorecard.
         */
        source?: string | null;
        /**
         * Output only. The most recent time at which the scorecard was updated.
         */
        updateTime?: string | null;
    }
    /**
     * The results of scoring a single conversation against a QaScorecard. Contains a collection of QaAnswers and aggregate score.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1QaScorecardResult {
        /**
         * ID of the agent that handled the conversation.
         */
        agentId?: string | null;
        /**
         * The conversation scored by this result.
         */
        conversation?: string | null;
        /**
         * Output only. The timestamp that the revision was created.
         */
        createTime?: string | null;
        /**
         * Identifier. The name of the scorecard result. Format: projects/{project\}/locations/{location\}/qaScorecardResults/{qa_scorecard_result\}
         */
        name?: string | null;
        /**
         * The normalized score, which is the score divided by the potential score. Any manual edits are included if they exist.
         */
        normalizedScore?: number | null;
        /**
         * The maximum potential overall score of the scorecard. Any questions answered using `na_value` are excluded from this calculation.
         */
        potentialScore?: number | null;
        /**
         * Set of QaAnswers represented in the result.
         */
        qaAnswers?: Schema$GoogleCloudContactcenterinsightsV1QaAnswer[];
        /**
         * The QaScorecardRevision scored by this result.
         */
        qaScorecardRevision?: string | null;
        /**
         * Collection of tags and their scores.
         */
        qaTagResults?: Schema$GoogleCloudContactcenterinsightsV1QaScorecardResultQaTagResult[];
        /**
         * The overall numerical score of the result, incorporating any manual edits if they exist.
         */
        score?: number | null;
        /**
         * List of all individual score sets.
         */
        scoreSources?: Schema$GoogleCloudContactcenterinsightsV1QaScorecardResultScoreSource[];
    }
    /**
     * Tags and their corresponding results.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1QaScorecardResultQaTagResult {
        /**
         * The normalized score the tag applies to.
         */
        normalizedScore?: number | null;
        /**
         * The potential score the tag applies to.
         */
        potentialScore?: number | null;
        /**
         * The score the tag applies to.
         */
        score?: number | null;
        /**
         * The tag the score applies to.
         */
        tag?: string | null;
    }
    /**
     * A scorecard result may have multiple sets of scores from varying sources, one of which becomes the "main" answer above. A ScoreSource represents each individual set of scores.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1QaScorecardResultScoreSource {
        /**
         * The normalized score, which is the score divided by the potential score.
         */
        normalizedScore?: number | null;
        /**
         * The maximum potential overall score of the scorecard. Any questions answered using `na_value` are excluded from this calculation.
         */
        potentialScore?: number | null;
        /**
         * Collection of tags and their scores.
         */
        qaTagResults?: Schema$GoogleCloudContactcenterinsightsV1QaScorecardResultQaTagResult[];
        /**
         * The overall numerical score of the result.
         */
        score?: number | null;
        /**
         * What created the score.
         */
        sourceType?: string | null;
    }
    /**
     * A revision of a QaScorecard. Modifying published scorecard fields would invalidate existing scorecard results — the questions may have changed, or the score weighting will make existing scores impossible to understand. So changes must create a new revision, rather than modifying the existing resource.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1QaScorecardRevision {
        /**
         * Output only. Alternative IDs for this revision of the scorecard, e.g., `latest`.
         */
        alternateIds?: string[] | null;
        /**
         * Output only. The timestamp that the revision was created.
         */
        createTime?: string | null;
        /**
         * Identifier. The name of the scorecard revision. Format: projects/{project\}/locations/{location\}/qaScorecards/{qa_scorecard\}/revisions/{revision\}
         */
        name?: string | null;
        /**
         * The snapshot of the scorecard at the time of this revision's creation.
         */
        snapshot?: Schema$GoogleCloudContactcenterinsightsV1QaScorecard;
        /**
         * Output only. State of the scorecard revision, indicating whether it's ready to be used in analysis.
         */
        state?: string | null;
    }
    /**
     * A time window for querying conversations.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1QueryInterval {
        /**
         * Required. The end time of the time window.
         */
        endTime?: string | null;
        /**
         * Required. The start time of the time window.
         */
        startTime?: string | null;
    }
    /**
     * The metadata from querying metrics.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1QueryMetricsMetadata {
        /**
         * Whether the result rows were truncated because the result row size is too large to materialize.
         */
        resultIsTruncated?: boolean | null;
    }
    /**
     * The request for querying metrics.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1QueryMetricsRequest {
        /**
         * The dimensions that determine the grouping key for the query. Defaults to no dimension if this field is unspecified. If a dimension is specified, its key must also be specified. Each dimension's key must be unique. If a time granularity is also specified, metric values in the dimension will be bucketed by this granularity. Up to one dimension is supported for now.
         */
        dimensions?: Schema$GoogleCloudContactcenterinsightsV1Dimension[];
        /**
         * Required. Filter to select a subset of conversations to compute the metrics. Must specify a window of the conversation create time to compute the metrics. The returned metrics will be from the range [DATE(starting create time), DATE(ending create time)).
         */
        filter?: string | null;
        /**
         * Measures to return. Defaults to all measures if this field is unspecified. A valid mask should traverse from the `measure` field from the response. For example, a path from a measure mask to get the conversation count is "conversation_measure.count".
         */
        measureMask?: string | null;
        /**
         * The time granularity of each data point in the time series. Defaults to NONE if this field is unspecified.
         */
        timeGranularity?: string | null;
    }
    /**
     * The response for querying metrics.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1QueryMetricsResponse {
        /**
         * Required. The location of the data. "projects/{project\}/locations/{location\}"
         */
        location?: string | null;
        /**
         * The macro average slice contains aggregated averages across all selected dimensions. i.e. if group_by agent and scorecard_id is specified, this field will contain the average across all agents and all scorecards. This field is only populated if the request specifies a Dimension.
         */
        macroAverageSlice?: Schema$GoogleCloudContactcenterinsightsV1QueryMetricsResponseSlice;
        /**
         * A slice contains a total and (if the request specified a time granularity) a time series of metric values. Each slice contains a unique combination of the cardinality of dimensions from the request.
         */
        slices?: Schema$GoogleCloudContactcenterinsightsV1QueryMetricsResponseSlice[];
        /**
         * The metrics last update time.
         */
        updateTime?: string | null;
    }
    /**
     * A slice contains a total and (if the request specified a time granularity) a time series of metric values. Each slice contains a unique combination of the cardinality of dimensions from the request. For example, if the request specifies a single ISSUE dimension and it has a cardinality of 2 (i.e. the data used to compute the metrics has 2 issues in total), the response will have 2 slices: * Slice 1 -\> dimensions=[Issue 1] * Slice 2 -\> dimensions=[Issue 2]
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1QueryMetricsResponseSlice {
        /**
         * A unique combination of dimensions that this slice represents.
         */
        dimensions?: Schema$GoogleCloudContactcenterinsightsV1Dimension[];
        /**
         * A time series of metric values. This is only populated if the request specifies a time granularity other than NONE.
         */
        timeSeries?: Schema$GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceTimeSeries;
        /**
         * The total metric value. The interval of this data point is [starting create time, ending create time) from the request.
         */
        total?: Schema$GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPoint;
    }
    /**
     * A data point contains the metric values mapped to an interval.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPoint {
        /**
         * The measure related to conversations.
         */
        conversationMeasure?: Schema$GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointConversationMeasure;
        /**
         * The measure related to dialogflow interactions.
         */
        dialogflowInteractionMeasure?: Schema$GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointDialogflowInteractionMeasure;
        /**
         * The interval that this data point represents. * If this is the total data point, the interval is [starting create time, ending create time) from the request. * If this a data point from the time series, the interval is [time, time + time granularity from the request).
         */
        interval?: Schema$GoogleTypeInterval;
    }
    /**
     * The measure related to conversations.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointConversationMeasure {
        /**
         * The number of conversations that were assigned to an AA human supervisor.
         */
        aaSupervisorAssignedConversationsCount?: number | null;
        /**
         * The number of conversations that were dropped, i.e. escalated but not assigned to an AA human supervisor.
         */
        aaSupervisorDroppedConversationsCount?: number | null;
        /**
         * The number of conversations that were escalated to an AA human supervisor for intervention.
         */
        aaSupervisorEscalatedConversationsCount?: number | null;
        /**
         * The number of conversations scanned by the AA human supervisor.
         */
        aaSupervisorMonitoredConversationsCount?: number | null;
        /**
         * The number of conversations transferred to a human agent.
         */
        aaSupervisorTransferredToHumanAgentConvCount?: number | null;
        /**
         * Count of agent messages that triggered an Ai Coach Suggestion.
         */
        aiCoachSuggestionAgentMessageTriggerCount?: number | null;
        /**
         * Count of Ai Coach Suggestion that has been used by agents.
         */
        aiCoachSuggestionAgentUsageCount?: number | null;
        /**
         * Proportion of Ai Coach Suggestion that has been used by agents.
         */
        aiCoachSuggestionAgentUsageRatio?: number | null;
        /**
         * Count of customer messages that triggered an Ai Coach Suggestion.
         */
        aiCoachSuggestionCustomerMessageTriggerCount?: number | null;
        /**
         * Proportion of customer messages that triggered an Ai Coach Suggestion.
         */
        aiCoachSuggestionCustomerMessageTriggerRatio?: number | null;
        /**
         * Count of end_of_utterance trigger event messages that triggered an Ai Coach Suggestion.
         */
        aiCoachSuggestionMessageTriggerCount?: number | null;
        /**
         * Proportion of end_of_utterance trigger event messages that triggered an Ai Coach Suggestion.
         */
        aiCoachSuggestionMessageTriggerRatio?: number | null;
        /**
         * The average agent's sentiment score.
         */
        averageAgentSentimentScore?: number | null;
        /**
         * The average client's sentiment score.
         */
        averageClientSentimentScore?: number | null;
        /**
         * The average customer satisfaction rating.
         */
        averageCustomerSatisfactionRating?: number | null;
        /**
         * The average duration.
         */
        averageDuration?: string | null;
        /**
         * The average normalized QA score for a scorecard. When computing the average across a set of conversations, if a conversation has been evaluated with multiple revisions of a scorecard, only the latest revision results will be used. Will exclude 0's in average calculation. Will be only populated if the request specifies a dimension of QA_SCORECARD_ID.
         */
        averageQaNormalizedScore?: number | null;
        /**
         * Average QA normalized score averaged for questions averaged across all revisions of the parent scorecard. Will be only populated if the request specifies a dimension of QA_QUESTION_ID.
         */
        averageQaQuestionNormalizedScore?: number | null;
        /**
         * The average silence percentage.
         */
        averageSilencePercentage?: number | null;
        /**
         * Average edit distance of the summarization suggestions. Edit distance (also called as levenshtein distance) is calculated by summing up number of insertions, deletions and substitutions required to transform the summization feedback to the original summary suggestion.
         */
        averageSummarizationSuggestionEditDistance?: number | null;
        /**
         * Normalized Average edit distance of the summarization suggestions. Edit distance (also called as levenshtein distance) is calculated by summing up number of insertions, deletions and substitutions required to transform the summization feedback to the original summary suggestion. Normalized edit distance is the average of (edit distance / summary length).
         */
        averageSummarizationSuggestionNormalizedEditDistance?: number | null;
        /**
         * The average turn count.
         */
        averageTurnCount?: number | null;
        /**
         * The exponential moving average of the sentiment score of client turns in the conversation.
         */
        avgConversationClientTurnSentimentEma?: number | null;
        /**
         * The number of conversations that were contained.
         */
        containedConversationCount?: number | null;
        /**
         * The percentage of conversations that were contained.
         */
        containedConversationRatio?: number | null;
        /**
         * Count of conversations that has Ai Coach Suggestions.
         */
        conversationAiCoachSuggestionCount?: number | null;
        /**
         * Proportion of conversations that has Ai Coach Suggestions.
         */
        conversationAiCoachSuggestionRatio?: number | null;
        /**
         * The average latency of conversational agents' audio in audio out latency per interaction. This is computed as the average of the all the interactions' audio in audio out latencies in a conversation and averaged across conversations.
         */
        conversationalAgentsAverageAudioInAudioOutLatency?: number | null;
        /**
         * The average latency of conversational agents' latency per interaction. This is computed as the average of the all the iteractions' end to end latencies in a conversation and averaged across conversations. The e2e latency is the time between the end of the user utterance and the start of the agent utterance on the interaction level.
         */
        conversationalAgentsAverageEndToEndLatency?: number | null;
        /**
         * The average latency of conversational agents' LLM call latency per interaction. This is computed as the average of the all the interactions LLM call latencies in a conversation and averaged across conversations.
         */
        conversationalAgentsAverageLlmCallLatency?: number | null;
        /**
         * The macro average latency of conversational agents' TTS latency per interaction. This is computed as the average of the all the interactions' TTS latencies in a conversation and averaged across conversations.
         */
        conversationalAgentsAverageTtsLatency?: number | null;
        /**
         * The conversation count.
         */
        conversationCount?: number | null;
        /**
         * Proportion of conversations that had a suggested summary.
         */
        conversationSuggestedSummaryRatio?: number | null;
        /**
         * The agent message count.
         */
        conversationTotalAgentMessageCount?: number | null;
        /**
         * The customer message count.
         */
        conversationTotalCustomerMessageCount?: number | null;
        /**
         * Average latency of dialogflow webhook calls.
         */
        dialogflowAverageWebhookLatency?: number | null;
        /**
         * count of conversations that was handed off from virtual agent to human agent.
         */
        dialogflowConversationsEscalationCount?: number | null;
        /**
         * Proportion of conversations that was handed off from virtual agent to human agent.
         */
        dialogflowConversationsEscalationRatio?: number | null;
        /**
         * Proportion of dialogflow interactions that has empty input.
         */
        dialogflowInteractionsNoInputRatio?: number | null;
        /**
         * Proportion of dialogflow interactions that has no intent match for the input.
         */
        dialogflowInteractionsNoMatchRatio?: number | null;
        /**
         * Proportion of dialogflow webhook calls that failed.
         */
        dialogflowWebhookFailureRatio?: number | null;
        /**
         * Proportion of dialogflow webhook calls that timed out.
         */
        dialogflowWebhookTimeoutRatio?: number | null;
        /**
         * Proportion of knowledge assist (Proactive Generative Knowledge Assist) queries that had negative feedback.
         */
        knowledgeAssistNegativeFeedbackRatio?: number | null;
        /**
         * Proportion of knowledge assist (Proactive Generative Knowledge Assist) queries that had positive feedback.
         */
        knowledgeAssistPositiveFeedbackRatio?: number | null;
        /**
         * Count of knowledge assist results (Proactive Generative Knowledge Assist) shown to the user.
         */
        knowledgeAssistResultCount?: number | null;
        /**
         * Proportion of knowledge assist (Proactive Generative Knowledge Assist) queries that had a URL clicked.
         */
        knowledgeAssistUriClickRatio?: number | null;
        /**
         * Proportion of knowledge search (Generative Knowledge Assist) queries made by the agent compared to the total number of knowledge search queries made.
         */
        knowledgeSearchAgentQuerySourceRatio?: number | null;
        /**
         * Proportion of knowledge search (Generative Knowledge Assist) queries that had negative feedback.
         */
        knowledgeSearchNegativeFeedbackRatio?: number | null;
        /**
         * Proportion of knowledge search (Generative Knowledge Assist) queries that had positive feedback.
         */
        knowledgeSearchPositiveFeedbackRatio?: number | null;
        /**
         * Count of knowledge search results (Generative Knowledge Assist) shown to the user.
         */
        knowledgeSearchResultCount?: number | null;
        /**
         * Proportion of knowledge search (Generative Knowledge Assist) queries suggested compared to the total number of knowledge search queries made.
         */
        knowledgeSearchSuggestedQuerySourceRatio?: number | null;
        /**
         * Proportion of knowledge search (Generative Knowledge Assist) queries that had a URL clicked.
         */
        knowledgeSearchUriClickRatio?: number | null;
        /**
         * Average QA normalized score for all the tags.
         */
        qaTagScores?: Schema$GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointConversationMeasureQaTagScore[];
        /**
         * Proportion of summarization suggestions that were manually edited.
         */
        summarizationSuggestionEditRatio?: number | null;
        /**
         * Count of summarization suggestions results.
         */
        summarizationSuggestionResultCount?: number | null;
    }
    /**
     * Average QA normalized score for the tag.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointConversationMeasureQaTagScore {
        /**
         * Average tag normalized score per tag.
         */
        averageTagNormalizedScore?: number | null;
        /**
         * Tag name.
         */
        tag?: string | null;
    }
    /**
     * The measure related to dialogflow interactions.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointDialogflowInteractionMeasure {
        /**
         * The percentile result for audio in audio out latency in milliseconds per dialogflow interaction level.
         */
        percentileAudioInAudioOutLatency?: Schema$GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointPercentileResult;
        /**
         * The percentile result for end to end chat latency in milliseconds per dialogflow interaction level.
         */
        percentileEndToEndLatency?: Schema$GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointPercentileResult;
        /**
         * The percentile result for LLM latency in milliseconds per dialogflow interaction level.
         */
        percentileLlmCallLatency?: Schema$GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointPercentileResult;
        /**
         * The percentile result for tool use latency in milliseconds per dialogflow interaction level.
         */
        percentileToolUseLatency?: Schema$GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointPercentileResult;
        /**
         * The percentile result for TTS latency in milliseconds per dialogflow interaction level.
         */
        percentileTtsLatency?: Schema$GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointPercentileResult;
    }
    /**
     * The percentile result. Currently supported percentiles are 50th, 90th, and 99th.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPointPercentileResult {
        /**
         * The 50th percentile value.
         */
        p50?: number | null;
        /**
         * The 90th percentile value.
         */
        p90?: number | null;
        /**
         * The 99th percentile value.
         */
        p99?: number | null;
    }
    /**
     * A time series of metric values.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceTimeSeries {
        /**
         * The data points that make up the time series .
         */
        dataPoints?: Schema$GoogleCloudContactcenterinsightsV1QueryMetricsResponseSliceDataPoint[];
    }
    /**
     * The metadata for querying performance overview.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1QueryPerformanceOverviewMetadata {
    }
    /**
     * The request for summarizing performance according to different metrics for conversations over a specified time window.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1QueryPerformanceOverviewRequest {
        /**
         * Conversations are from a single agent.
         */
        agentPerformanceSource?: Schema$GoogleCloudContactcenterinsightsV1QueryPerformanceOverviewRequestAgentSource;
        /**
         * The time window of the conversations to compare the performance to.
         */
        comparisonQueryInterval?: Schema$GoogleCloudContactcenterinsightsV1QueryInterval;
        /**
         * Optional. Filter to select a subset of conversations to compute the performance overview. Supports the same filters as the filter field in QueryMetricsRequest. The source and query interval/comparison query interval should not be included here.
         */
        filter?: string | null;
        /**
         * Required. The time window of the conversations to derive performance stats from.
         */
        queryInterval?: Schema$GoogleCloudContactcenterinsightsV1QueryInterval;
    }
    /**
     * The entity whose performance is being queried is a single agent.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1QueryPerformanceOverviewRequestAgentSource {
        /**
         * Required. Agent id to query performance overview for.
         */
        agentId?: string | null;
    }
    /**
     * The response for querying performance overview.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1QueryPerformanceOverviewResponse {
        /**
         * The summary text of the performance.
         */
        summaryText?: string | null;
    }
    /**
     * DLP resources used for redaction while ingesting conversations. DLP settings are applied to conversations ingested from the `UploadConversation` and `IngestConversations` endpoints, including conversation coming from CCAI Platform. They are not applied to conversations ingested from the `CreateConversation` endpoint or the Dialogflow / Agent Assist runtime integrations. When using Dialogflow / Agent Assist runtime integrations, redaction should be performed in Dialogflow / Agent Assist.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1RedactionConfig {
        /**
         * The fully-qualified DLP deidentify template resource name. Format: `projects/{project\}/deidentifyTemplates/{template\}`
         */
        deidentifyTemplate?: string | null;
        /**
         * The fully-qualified DLP inspect template resource name. Format: `projects/{project\}/locations/{location\}/inspectTemplates/{template\}`
         */
        inspectTemplate?: string | null;
    }
    /**
     * Regex match configuration.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1RegexMatchConfig {
    }
    /**
     * An annotation that was generated during the customer and agent interaction.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1RuntimeAnnotation {
        /**
         * The unique identifier of the annotation. Format: projects/{project\}/locations/{location\}/conversationDatasets/{dataset\}/conversationDataItems/{data_item\}/conversationAnnotations/{annotation\}
         */
        annotationId?: string | null;
        /**
         * The feedback that the customer has about the answer in `data`.
         */
        answerFeedback?: Schema$GoogleCloudContactcenterinsightsV1AnswerFeedback;
        /**
         * Agent Assist Article Suggestion data.
         */
        articleSuggestion?: Schema$GoogleCloudContactcenterinsightsV1ArticleSuggestionData;
        /**
         * Conversation summarization suggestion data.
         */
        conversationSummarizationSuggestion?: Schema$GoogleCloudContactcenterinsightsV1ConversationSummarizationSuggestionData;
        /**
         * The time at which this annotation was created.
         */
        createTime?: string | null;
        /**
         * Dialogflow interaction data.
         */
        dialogflowInteraction?: Schema$GoogleCloudContactcenterinsightsV1DialogflowInteractionData;
        /**
         * The boundary in the conversation where the annotation ends, inclusive.
         */
        endBoundary?: Schema$GoogleCloudContactcenterinsightsV1AnnotationBoundary;
        /**
         * Agent Assist FAQ answer data.
         */
        faqAnswer?: Schema$GoogleCloudContactcenterinsightsV1FaqAnswerData;
        /**
         * Agent Assist Smart Compose suggestion data.
         */
        smartComposeSuggestion?: Schema$GoogleCloudContactcenterinsightsV1SmartComposeSuggestionData;
        /**
         * Agent Assist Smart Reply data.
         */
        smartReply?: Schema$GoogleCloudContactcenterinsightsV1SmartReplyData;
        /**
         * The boundary in the conversation where the annotation starts, inclusive.
         */
        startBoundary?: Schema$GoogleCloudContactcenterinsightsV1AnnotationBoundary;
        /**
         * Explicit input used for generating the answer
         */
        userInput?: Schema$GoogleCloudContactcenterinsightsV1RuntimeAnnotationUserInput;
    }
    /**
     * Explicit input used for generating the answer
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1RuntimeAnnotationUserInput {
        /**
         * The resource name of associated generator. Format: `projects//locations//generators/`
         */
        generatorName?: string | null;
        /**
         * Query text. Article Search uses this to store the input query used to generate the search results.
         */
        query?: string | null;
        /**
         * Query source for the answer.
         */
        querySource?: string | null;
    }
    /**
     * The metadata for an SampleConversations operation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1SampleConversationsMetadata {
        /**
         * Output only. The time the operation was created.
         */
        createTime?: string | null;
        /**
         * Output only. The time the operation finished running.
         */
        endTime?: string | null;
        /**
         * Output only. Partial errors during sample conversations operation that might cause the operation output to be incomplete.
         */
        partialErrors?: Schema$GoogleRpcStatus[];
        /**
         * Output only. The original request for sample conversations to dataset.
         */
        request?: Schema$GoogleCloudContactcenterinsightsV1SampleConversationsRequest;
        /**
         * Output only. Statistics for SampleConversations operation.
         */
        sampleConversationsStats?: Schema$GoogleCloudContactcenterinsightsV1SampleConversationsMetadataSampleConversationsStats;
    }
    /**
     * Statistics for SampleConversations operation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1SampleConversationsMetadataSampleConversationsStats {
        /**
         * Output only. The number of objects which were unable to be sampled due to errors. The errors are populated in the partial_errors field.
         */
        failedSampleCount?: number | null;
        /**
         * Output only. The number of new conversations added during this sample operation.
         */
        successfulSampleCount?: number | null;
    }
    /**
     * The request to sample conversations to a dataset.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1SampleConversationsRequest {
        /**
         * The dataset resource to copy the sampled conversations to.
         */
        destinationDataset?: Schema$GoogleCloudContactcenterinsightsV1Dataset;
        /**
         * Required. The parent resource of the dataset.
         */
        parent?: string | null;
        /**
         * Optional. The sample rule used for sampling conversations.
         */
        sampleRule?: Schema$GoogleCloudContactcenterinsightsV1SampleRule;
    }
    /**
     * The response to an SampleConversations operation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1SampleConversationsResponse {
    }
    /**
     * Message for sampling conversations.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1SampleRule {
        /**
         * To specify the filter for the conversions that should apply this sample rule. An empty filter means this sample rule applies to all conversations.
         */
        conversationFilter?: string | null;
        /**
         * Optional. Group by dimension to sample the conversation. If no dimension is provided, the sampling will be applied to the project level. Current supported dimensions is 'quality_metadata.agent_info.agent_id'.
         */
        dimension?: string | null;
        /**
         * Percentage of conversations that we should sample based on the dimension between [0, 100].
         */
        samplePercentage?: number | null;
        /**
         * Number of the conversations that we should sample based on the dimension.
         */
        sampleRow?: string | null;
    }
    /**
     * Message for schedule info.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1ScheduleInfo {
        /**
         * End time of the schedule. If not specified, will keep scheduling new pipelines for execution util the schedule is no longer active or deleted.
         */
        endTime?: string | null;
        /**
         * The groc expression. Format: `every number [synchronized]` Time units can be: minutes, hours Synchronized is optional and indicates that the schedule should be synchronized to the start of the interval: every 5 minutes synchronized means 00:00, 00:05 ... Otherwise the start time is random within the interval. Example: `every 5 minutes` could be 00:02, 00:07, 00:12, ...
         */
        schedule?: string | null;
        /**
         * Start time of the schedule. If not specified, will start as soon as the schedule is created.
         */
        startTime?: string | null;
        /**
         * The timezone to use for the groc expression. If not specified, defaults to UTC.
         */
        timeZone?: string | null;
    }
    /**
     * The response from a ListAuthorizedViews request.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1SearchAuthorizedViewsResponse {
        /**
         * The AuthorizedViews under the parent.
         */
        authorizedViews?: Schema$GoogleCloudContactcenterinsightsV1AuthorizedView[];
        /**
         * A token, which can be sent as `page_token` to retrieve the next page. If this field is omitted, there are no subsequent pages.
         */
        nextPageToken?: string | null;
    }
    /**
     * The data for a sentiment annotation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1SentimentData {
        /**
         * A non-negative number from 0 to infinity which represents the absolute magnitude of sentiment regardless of score.
         */
        magnitude?: number | null;
        /**
         * The sentiment score between -1.0 (negative) and 1.0 (positive).
         */
        score?: number | null;
    }
    /**
     * The CCAI Insights project wide settings. Use these settings to configure the behavior of Insights. View these settings with [`getsettings`](https://cloud.google.com/contact-center/insights/docs/reference/rest/v1/projects.locations/getSettings) and change the settings with [`updateSettings`](https://cloud.google.com/contact-center/insights/docs/reference/rest/v1/projects.locations/updateSettings).
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1Settings {
        /**
         * Default analysis settings.
         */
        analysisConfig?: Schema$GoogleCloudContactcenterinsightsV1SettingsAnalysisConfig;
        /**
         * The default TTL for newly-created conversations. If a conversation has a specified expiration, that value will be used instead. Changing this value will not change the expiration of existing conversations. Conversations with no expire time persist until they are deleted.
         */
        conversationTtl?: string | null;
        /**
         * Output only. The time at which the settings was created.
         */
        createTime?: string | null;
        /**
         * A language code to be applied to each transcript segment unless the segment already specifies a language code. Language code defaults to "en-US" if it is neither specified on the segment nor here.
         */
        languageCode?: string | null;
        /**
         * Immutable. The resource name of the settings resource. Format: projects/{project\}/locations/{location\}/settings
         */
        name?: string | null;
        /**
         * A map that maps a notification trigger to a Pub/Sub topic. Each time a specified trigger occurs, Insights will notify the corresponding Pub/Sub topic. Keys are notification triggers. Supported keys are: * "all-triggers": Notify each time any of the supported triggers occurs. * "create-analysis": Notify each time an analysis is created. * "create-conversation": Notify each time a conversation is created. * "export-insights-data": Notify each time an export is complete. * "ingest-conversations": Notify each time an IngestConversations LRO is complete. * "update-conversation": Notify each time a conversation is updated via UpdateConversation. * "upload-conversation": Notify when an UploadConversation LRO is complete. * "update-or-analyze-conversation": Notify when an analysis for a conversation is completed or when the conversation is updated. The message will contain the conversation with transcript, analysis and other metadata. Values are Pub/Sub topics. The format of each Pub/Sub topic is: projects/{project\}/topics/{topic\}
         */
        pubsubNotificationSettings?: {
            [key: string]: string;
        } | null;
        /**
         * Default DLP redaction resources to be applied while ingesting conversations. This applies to conversations ingested from the `UploadConversation` and `IngestConversations` endpoints, including conversations coming from CCAI Platform.
         */
        redactionConfig?: Schema$GoogleCloudContactcenterinsightsV1RedactionConfig;
        /**
         * Optional. The path to a Cloud Storage bucket containing conversation screen recordings. If provided, Insights will search in the bucket for a screen recording file matching the conversation data source object name prefix. If matches are found, these file URIs will be stored in the conversation screen recordings field.
         */
        screenRecordingBucketUri?: string | null;
        /**
         * Optional. Default Speech-to-Text resources to use while ingesting audio files. Optional, CCAI Insights will create a default if not provided. This applies to conversations ingested from the `UploadConversation` and `IngestConversations` endpoints, including conversations coming from CCAI Platform.
         */
        speechConfig?: Schema$GoogleCloudContactcenterinsightsV1SpeechConfig;
        /**
         * Output only. The time at which the settings were last updated.
         */
        updateTime?: string | null;
    }
    /**
     * Default configuration when creating Analyses in Insights.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1SettingsAnalysisConfig {
        /**
         * To select the annotators to run and the phrase matchers to use (if any). If not specified, all annotators will be run.
         */
        annotatorSelector?: Schema$GoogleCloudContactcenterinsightsV1AnnotatorSelector;
        /**
         * Percentage of conversations created using Dialogflow runtime integration to analyze automatically, between [0, 100].
         */
        runtimeIntegrationAnalysisPercentage?: number | null;
        /**
         * Percentage of conversations created using the UploadConversation endpoint to analyze automatically, between [0, 100].
         */
        uploadConversationAnalysisPercentage?: number | null;
    }
    /**
     * Signed audio URIs for a conversation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1SignedAudioUris {
        /**
         * The signed URI for the audio from the Dialogflow conversation source.
         */
        signedDialogflowAudioUri?: string | null;
        /**
         * The signed URI for the audio from the Cloud Storage conversation source.
         */
        signedGcsAudioUri?: string | null;
        /**
         * The signed URI for the audio corresponding to each turn in the conversation.
         */
        signedTurnLevelAudios?: Schema$GoogleCloudContactcenterinsightsV1ConversationDataSourceTurnLevelAudio[];
    }
    /**
     * The data for a silence annotation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1SilenceData {
    }
    /**
     * Agent Assist Smart Compose suggestion data.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1SmartComposeSuggestionData {
        /**
         * The system's confidence score that this suggestion is a good match for this conversation, ranging from 0.0 (completely uncertain) to 1.0 (completely certain).
         */
        confidenceScore?: number | null;
        /**
         * Map that contains metadata about the Smart Compose suggestion and the document from which it originates.
         */
        metadata?: {
            [key: string]: string;
        } | null;
        /**
         * The name of the answer record. Format: projects/{project\}/locations/{location\}/answerRecords/{answer_record\}
         */
        queryRecord?: string | null;
        /**
         * The content of the suggestion.
         */
        suggestion?: string | null;
    }
    /**
     * Agent Assist Smart Reply data.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1SmartReplyData {
        /**
         * The system's confidence score that this reply is a good match for this conversation, ranging from 0.0 (completely uncertain) to 1.0 (completely certain).
         */
        confidenceScore?: number | null;
        /**
         * Map that contains metadata about the Smart Reply and the document from which it originates.
         */
        metadata?: {
            [key: string]: string;
        } | null;
        /**
         * The name of the answer record. Format: projects/{project\}/locations/{location\}/answerRecords/{answer_record\}
         */
        queryRecord?: string | null;
        /**
         * The content of the reply.
         */
        reply?: string | null;
    }
    /**
     * Speech-to-Text configuration. Speech-to-Text settings are applied to conversations ingested from the `UploadConversation` and `IngestConversations` endpoints, including conversation coming from CCAI Platform. They are not applied to conversations ingested from the `CreateConversation` endpoint.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1SpeechConfig {
        /**
         * Whether to disable word time offsets. If true, the `enable_word_time_offsets` field in the recognition config will be set to false.
         */
        disableWordTimeOffsets?: boolean | null;
        /**
         * The fully-qualified Speech Recognizer resource name. Format: `projects/{project_id\}/locations/{location\}/recognizer/{recognizer\}`
         */
        speechRecognizer?: string | null;
    }
    /**
     * The request message for testing auto labeling rules.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1TestAutoLabelingRuleRequest {
        /**
         * Required. The auto labeling rule to test.
         */
        autoLabelingRule?: Schema$GoogleCloudContactcenterinsightsV1AutoLabelingRule;
        /**
         * Required. Conversation data to test rules against.
         */
        conversation?: Schema$GoogleCloudContactcenterinsightsV1Conversation;
    }
    /**
     * The response message for testing auto labeling rules.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1TestAutoLabelingRuleResponse {
        /**
         * The result of the test auto labeling rule.
         */
        labelResult?: string | null;
    }
    /**
     * Metadata for testing correlation config.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1TestCorrelationConfigMetadata {
        /**
         * Output only. The time the operation was created.
         */
        createTime?: string | null;
        /**
         * The dataset used for sampling conversations.
         */
        dataset?: string | null;
        /**
         * The statistics for the operation.
         */
        stats?: Schema$GoogleCloudContactcenterinsightsV1TestCorrelationConfigMetadataFullConversationCorrelationStats;
    }
    /**
     * Statistics for TestCorrelationConfig operation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1TestCorrelationConfigMetadataFullConversationCorrelationStats {
        /**
         * A list of errors that occurred during correlation, one for each conversation that failed.
         */
        conversationCorrelationErrors?: Schema$GoogleCloudContactcenterinsightsV1TestCorrelationConfigMetadataFullConversationCorrelationStatsConversationCorrelationError[];
        /**
         * The number of conversations correlated.
         */
        correlatedConversationsCount?: number | null;
        /**
         * The number of conversations that failed correlation.
         */
        failedConversationsCount?: number | null;
        /**
         * Partial errors during test correlation config operation that might cause the operation output to be incomplete.
         */
        partialErrors?: Schema$GoogleRpcStatus[];
        /**
         * The number of conversations sampled.
         */
        sampledConversationsCount?: number | null;
    }
    /**
     * An error that occurred during correlation for a specific conversation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1TestCorrelationConfigMetadataFullConversationCorrelationStatsConversationCorrelationError {
        /**
         * The conversation resource name that had an error during correlation.
         */
        conversation?: string | null;
        /**
         * The error status.
         */
        status?: Schema$GoogleRpcStatus;
    }
    /**
     * The request to test correlation config.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1TestCorrelationConfigRequest {
        /**
         * Optional. A list of conversations to test against.
         */
        conversations?: Schema$GoogleCloudContactcenterinsightsV1TestCorrelationConfigRequestConversations;
        /**
         * Required. The correlation config to test.
         */
        correlationConfig?: Schema$GoogleCloudContactcenterinsightsV1CorrelationConfig;
        /**
         * Optional. Filter to select conversations to test correlation against. Conversations matching this filter will be sampled based on start time. The most recent `max_sample_count` conversations will be selected. If no conversations match the filter, the request will fail with an `INVALID_ARGUMENT` error.
         */
        filter?: string | null;
        /**
         * Optional. The maximum number of conversations to sample when using the `filter`. If not set, defaults to 1000. Values greater than 1000 are coerced to 1000. This field is ignored if `conversations` is provided.
         */
        maxSampleCount?: number | null;
    }
    /**
     * Wrapper for a list of conversations.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1TestCorrelationConfigRequestConversations {
        /**
         * Optional. The conversations.
         */
        conversations?: Schema$GoogleCloudContactcenterinsightsV1Conversation[];
    }
    /**
     * The response of testing correlation config.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1TestCorrelationConfigResponse {
        /**
         * Results for the DETAILED_SYNC execution mode.
         */
        detailedResults?: Schema$GoogleCloudContactcenterinsightsV1TestCorrelationConfigResponseDetailedCorrelationResults;
        /**
         * Partial errors during test correlation config operation that might cause the operation output to be incomplete.
         */
        partialErrors?: Schema$GoogleRpcStatus[];
    }
    /**
     * Wrapper for detailed, step-by-step results.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1TestCorrelationConfigResponseDetailedCorrelationResults {
        /**
         * A list of constraint evaluation results for each pair of conversations.
         */
        constraintResults?: Schema$GoogleCloudContactcenterinsightsV1ConstraintEvaluationResult[];
        /**
         * A list of join key correlation results for each conversation tested.
         */
        joinKeyResults?: Schema$GoogleCloudContactcenterinsightsV1ConversationCorrelationResult[];
    }
    /**
     * Request for TuneQaScorecardRevision endpoint.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1TuneQaScorecardRevisionRequest {
        /**
         * Required. Filter for selecting the feedback labels that needs to be used for training. This filter can be used to limit the feedback labels used for tuning to a feedback labels created or updated for a specific time-window etc.
         */
        filter?: string | null;
        /**
         * Optional. Run in validate only mode, no fine tuning will actually run. Data quality validations like training data distributions will run. Even when set to false, the data quality validations will still run but once the validations complete we will proceed with the fine tune, if applicable.
         */
        validateOnly?: boolean | null;
    }
    /**
     * Metadata for undeploying an issue model.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1UndeployIssueModelMetadata {
        /**
         * Output only. The time the operation was created.
         */
        createTime?: string | null;
        /**
         * Output only. The time the operation finished running.
         */
        endTime?: string | null;
        /**
         * The original request for undeployment.
         */
        request?: Schema$GoogleCloudContactcenterinsightsV1UndeployIssueModelRequest;
    }
    /**
     * The request to undeploy an issue model.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1UndeployIssueModelRequest {
        /**
         * Required. The issue model to undeploy.
         */
        name?: string | null;
    }
    /**
     * The response to undeploy an issue model.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1UndeployIssueModelResponse {
    }
    /**
     * The request to undeploy a QaScorecardRevision
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1UndeployQaScorecardRevisionRequest {
    }
    /**
     * The metadata for updating a QaQuestionTag Resource.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1UpdateQaQuestionTagMetadata {
        /**
         * Output only. The time the operation was created.
         */
        createTime?: string | null;
        /**
         * Output only. The time the operation finished running.
         */
        endTime?: string | null;
        /**
         * Output only. The original request.
         */
        request?: Schema$GoogleCloudContactcenterinsightsV1UpdateQaQuestionTagRequest;
    }
    /**
     * The request for updating a QaQuestionTag.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1UpdateQaQuestionTagRequest {
        /**
         * Required. The QaQuestionTag to update.
         */
        qaQuestionTag?: Schema$GoogleCloudContactcenterinsightsV1QaQuestionTag;
        /**
         * Optional. The list of fields to be updated. All possible fields can be updated by passing `*`, or a subset of the following updateable fields can be provided: * `qa_question_tag_name` - the name of the tag * `qa_question_ids` - the list of questions the tag applies to
         */
        updateMask?: string | null;
    }
    /**
     * The metadata for an `UploadConversation` operation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1UploadConversationMetadata {
        /**
         * Output only. The operation name for a successfully created analysis operation, if any.
         */
        analysisOperation?: string | null;
        /**
         * Output only. The redaction config applied to the uploaded conversation.
         */
        appliedRedactionConfig?: Schema$GoogleCloudContactcenterinsightsV1RedactionConfig;
        /**
         * Output only. The time the operation was created.
         */
        createTime?: string | null;
        /**
         * Output only. The time the operation finished running.
         */
        endTime?: string | null;
        /**
         * Output only. The original request.
         */
        request?: Schema$GoogleCloudContactcenterinsightsV1UploadConversationRequest;
    }
    /**
     * Request to upload a conversation.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1UploadConversationRequest {
        /**
         * Required. The conversation resource to create.
         */
        conversation?: Schema$GoogleCloudContactcenterinsightsV1Conversation;
        /**
         * Optional. A unique ID for the new conversation. This ID will become the final component of the conversation's resource name. If no ID is specified, a server-generated ID will be used. This value should be 4-64 characters and must match the regular expression `^[a-z0-9-]{4,64\}$`. Valid characters are `a-z-`
         */
        conversationId?: string | null;
        /**
         * Required. The parent resource of the conversation.
         */
        parent?: string | null;
        /**
         * Optional. DLP settings for transcript redaction. Will default to the config specified in Settings.
         */
        redactionConfig?: Schema$GoogleCloudContactcenterinsightsV1RedactionConfig;
        /**
         * Optional. Speech-to-Text configuration. Will default to the config specified in Settings.
         */
        speechConfig?: Schema$GoogleCloudContactcenterinsightsV1SpeechConfig;
    }
    /**
     * Information about a user.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1UserInfo {
        /**
         * The user's username.
         */
        username?: string | null;
    }
    /**
     * The View resource.
     */
    export interface Schema$GoogleCloudContactcenterinsightsV1View {
        /**
         * Output only. The time at which this view was created.
         */
        createTime?: string | null;
        /**
         * The human-readable display name of the view.
         */
        displayName?: string | null;
        /**
         * Immutable. The resource name of the view. Format: projects/{project\}/locations/{location\}/views/{view\}
         */
        name?: string | null;
        /**
         * Output only. The most recent time at which the view was updated.
         */
        updateTime?: string | null;
        /**
         * A filter to reduce conversation results to a specific subset. Refer to https://cloud.google.com/contact-center/insights/docs/filtering for details.
         */
        value?: string | null;
    }
    /**
     * Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] \}, { "log_type": "DATA_WRITE" \}, { "log_type": "ADMIN_READ" \} ] \}, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" \}, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] \} ] \} ] \} For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts `jose@example.com` from DATA_READ logging, and `aliya@example.com` from DATA_WRITE logging.
     */
    export interface Schema$GoogleIamV1AuditConfig {
        /**
         * The configuration for logging of each type of permission.
         */
        auditLogConfigs?: Schema$GoogleIamV1AuditLogConfig[];
        /**
         * Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
         */
        service?: string | null;
    }
    /**
     * Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] \}, { "log_type": "DATA_WRITE" \} ] \} This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
     */
    export interface Schema$GoogleIamV1AuditLogConfig {
        /**
         * Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
         */
        exemptedMembers?: string[] | null;
        /**
         * The log type that this config enables.
         */
        logType?: string | null;
    }
    /**
     * Associates `members`, or principals, with a `role`.
     */
    export interface Schema$GoogleIamV1Binding {
        /**
         * The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
         */
        condition?: Schema$GoogleTypeExpr;
        /**
         * Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. Does not include identities that come from external identity providers (IdPs) through identity federation. * `user:{emailid\}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid\}`: An email address that represents a Google service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `serviceAccount:{projectid\}.svc.id.goog[{namespace\}/{kubernetes-sa\}]`: An identifier for a [Kubernetes service account](https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts). For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. * `group:{emailid\}`: An email address that represents a Google group. For example, `admins@example.com`. * `domain:{domain\}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. * `principal://iam.googleapis.com/locations/global/workforcePools/{pool_id\}/subject/{subject_attribute_value\}`: A single identity in a workforce identity pool. * `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id\}/group/{group_id\}`: All workforce identities in a group. * `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id\}/attribute.{attribute_name\}/{attribute_value\}`: All workforce identities with a specific attribute value. * `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id\}/x`: All identities in a workforce identity pool. * `principal://iam.googleapis.com/projects/{project_number\}/locations/global/workloadIdentityPools/{pool_id\}/subject/{subject_attribute_value\}`: A single identity in a workload identity pool. * `principalSet://iam.googleapis.com/projects/{project_number\}/locations/global/workloadIdentityPools/{pool_id\}/group/{group_id\}`: A workload identity pool group. * `principalSet://iam.googleapis.com/projects/{project_number\}/locations/global/workloadIdentityPools/{pool_id\}/attribute.{attribute_name\}/{attribute_value\}`: All identities in a workload identity pool with a certain attribute. * `principalSet://iam.googleapis.com/projects/{project_number\}/locations/global/workloadIdentityPools/{pool_id\}/x`: All identities in a workload identity pool. * `deleted:user:{emailid\}?uid={uniqueid\}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid\}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid\}?uid={uniqueid\}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid\}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid\}?uid={uniqueid\}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid\}` and the recovered group retains the role in the binding. * `deleted:principal://iam.googleapis.com/locations/global/workforcePools/{pool_id\}/subject/{subject_attribute_value\}`: Deleted single identity in a workforce identity pool. For example, `deleted:principal://iam.googleapis.com/locations/global/workforcePools/my-pool-id/subject/my-subject-attribute-value`.
         */
        members?: string[] | null;
        /**
         * Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`. For an overview of the IAM roles and permissions, see the [IAM documentation](https://cloud.google.com/iam/docs/roles-overview). For a list of the available pre-defined roles, see [here](https://cloud.google.com/iam/docs/understanding-roles).
         */
        role?: string | null;
    }
    /**
     * An Identity and Access Management (IAM) policy, which specifies access controls for Google Cloud resources. A `Policy` is a collection of `bindings`. A `binding` binds one or more `members`, or principals, to a single `role`. Principals can be user accounts, service accounts, Google groups, and domains (such as G Suite). A `role` is a named list of permissions; each `role` can be an IAM predefined role or a user-created custom role. For some types of Google Cloud resources, a `binding` can also specify a `condition`, which is a logical expression that allows access to a resource only if the expression evaluates to `true`. A condition can add constraints based on attributes of the request, the resource, or both. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies). **JSON example:** ``` { "bindings": [ { "role": "roles/resourcemanager.organizationAdmin", "members": [ "user:mike@example.com", "group:admins@example.com", "domain:google.com", "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] \}, { "role": "roles/resourcemanager.organizationViewer", "members": [ "user:eve@example.com" ], "condition": { "title": "expirable access", "description": "Does not grant access after Sep 2020", "expression": "request.time < timestamp('2020-10-01T00:00:00.000Z')", \} \} ], "etag": "BwWWja0YfJA=", "version": 3 \} ``` **YAML example:** ``` bindings: - members: - user:mike@example.com - group:admins@example.com - domain:google.com - serviceAccount:my-project-id@appspot.gserviceaccount.com role: roles/resourcemanager.organizationAdmin - members: - user:eve@example.com role: roles/resourcemanager.organizationViewer condition: title: expirable access description: Does not grant access after Sep 2020 expression: request.time < timestamp('2020-10-01T00:00:00.000Z') etag: BwWWja0YfJA= version: 3 ``` For a description of IAM and its features, see the [IAM documentation](https://cloud.google.com/iam/docs/).
     */
    export interface Schema$GoogleIamV1Policy {
        /**
         * Specifies cloud audit logging configuration for this policy.
         */
        auditConfigs?: Schema$GoogleIamV1AuditConfig[];
        /**
         * Associates a list of `members`, or principals, with a `role`. Optionally, may specify a `condition` that determines how and when the `bindings` are applied. Each of the `bindings` must contain at least one principal. The `bindings` in a `Policy` can refer to up to 1,500 principals; up to 250 of these principals can be Google groups. Each occurrence of a principal counts towards these limits. For example, if the `bindings` grant 50 different roles to `user:alice@example.com`, and not to any other principal, then you can add another 1,450 principals to the `bindings` in the `Policy`.
         */
        bindings?: Schema$GoogleIamV1Binding[];
        /**
         * `etag` is used for optimistic concurrency control as a way to help prevent simultaneous updates of a policy from overwriting each other. It is strongly suggested that systems make use of the `etag` in the read-modify-write cycle to perform policy updates in order to avoid race conditions: An `etag` is returned in the response to `getIamPolicy`, and systems are expected to put that etag in the request to `setIamPolicy` to ensure that their change will be applied to the same version of the policy. **Important:** If you use IAM Conditions, you must include the `etag` field whenever you call `setIamPolicy`. If you omit this field, then IAM allows you to overwrite a version `3` policy with a version `1` policy, and all of the conditions in the version `3` policy are lost.
         */
        etag?: string | null;
        /**
         * Specifies the format of the policy. Valid values are `0`, `1`, and `3`. Requests that specify an invalid value are rejected. Any operation that affects conditional role bindings must specify version `3`. This requirement applies to the following operations: * Getting a policy that includes a conditional role binding * Adding a conditional role binding to a policy * Changing a conditional role binding in a policy * Removing any role binding, with or without a condition, from a policy that includes conditions **Important:** If you use IAM Conditions, you must include the `etag` field whenever you call `setIamPolicy`. If you omit this field, then IAM allows you to overwrite a version `3` policy with a version `1` policy, and all of the conditions in the version `3` policy are lost. If a policy does not include any conditions, operations on that policy may specify any valid version or leave the field unset. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
         */
        version?: number | null;
    }
    /**
     * Request message for `SetIamPolicy` method.
     */
    export interface Schema$GoogleIamV1SetIamPolicyRequest {
        /**
         * REQUIRED: The complete policy to be applied to the `resource`. The size of the policy is limited to a few 10s of KB. An empty policy is a valid policy but certain Google Cloud services (such as Projects) might reject them.
         */
        policy?: Schema$GoogleIamV1Policy;
        /**
         * OPTIONAL: A FieldMask specifying which fields of the policy to modify. Only the fields in the mask will be modified. If no mask is provided, the following default mask is used: `paths: "bindings, etag"`
         */
        updateMask?: string | null;
    }
    /**
     * Request message for `TestIamPermissions` method.
     */
    export interface Schema$GoogleIamV1TestIamPermissionsRequest {
        /**
         * The set of permissions to check for the `resource`. Permissions with wildcards (such as `*` or `storage.*`) are not allowed. For more information see [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
         */
        permissions?: string[] | null;
    }
    /**
     * Response message for `TestIamPermissions` method.
     */
    export interface Schema$GoogleIamV1TestIamPermissionsResponse {
        /**
         * A subset of `TestPermissionsRequest.permissions` that the caller is allowed.
         */
        permissions?: string[] | null;
    }
    /**
     * The response message for Operations.ListOperations.
     */
    export interface Schema$GoogleLongrunningListOperationsResponse {
        /**
         * The standard List next-page token.
         */
        nextPageToken?: string | null;
        /**
         * A list of operations that matches the specified filter in the request.
         */
        operations?: Schema$GoogleLongrunningOperation[];
        /**
         * Unordered list. Unreachable resources. Populated when the request sets `ListOperationsRequest.return_partial_success` and reads across collections. For example, when attempting to list all resources across all supported locations.
         */
        unreachable?: string[] | null;
    }
    /**
     * This resource represents a long-running operation that is the result of a network API call.
     */
    export interface Schema$GoogleLongrunningOperation {
        /**
         * If the value is `false`, it means the operation is still in progress. If `true`, the operation is completed, and either `error` or `response` is available.
         */
        done?: boolean | null;
        /**
         * The error result of the operation in case of failure or cancellation.
         */
        error?: Schema$GoogleRpcStatus;
        /**
         * Service-specific metadata associated with the operation. It typically contains progress information and common metadata such as create time. Some services might not provide such metadata. Any method that returns a long-running operation should document the metadata type, if any.
         */
        metadata?: {
            [key: string]: any;
        } | null;
        /**
         * The server-assigned name, which is only unique within the same service that originally returns it. If you use the default HTTP mapping, the `name` should be a resource name ending with `operations/{unique_id\}`.
         */
        name?: string | null;
        /**
         * The normal, successful response of the operation. If the original method returns no data on success, such as `Delete`, the response is `google.protobuf.Empty`. If the original method is standard `Get`/`Create`/`Update`, the response should be the resource. For other methods, the response should have the type `XxxResponse`, where `Xxx` is the original method name. For example, if the original method name is `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
         */
        response?: {
            [key: string]: any;
        } | null;
    }
    /**
     * A generic empty message that you can re-use to avoid defining duplicated empty messages in your APIs. A typical example is to use it as the request or the response type of an API method. For instance: service Foo { rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty); \}
     */
    export interface Schema$GoogleProtobufEmpty {
    }
    /**
     * The `Status` type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by [gRPC](https://github.com/grpc). Each `Status` message contains three pieces of data: error code, error message, and error details. You can find out more about this error model and how to work with it in the [API Design Guide](https://cloud.google.com/apis/design/errors).
     */
    export interface Schema$GoogleRpcStatus {
        /**
         * The status code, which should be an enum value of google.rpc.Code.
         */
        code?: number | null;
        /**
         * A list of messages that carry the error details. There is a common set of message types for APIs to use.
         */
        details?: Array<{
            [key: string]: any;
        }> | null;
        /**
         * A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
         */
        message?: string | null;
    }
    /**
     * Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
     */
    export interface Schema$GoogleTypeExpr {
        /**
         * Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
         */
        description?: string | null;
        /**
         * Textual representation of an expression in Common Expression Language syntax.
         */
        expression?: string | null;
        /**
         * Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
         */
        location?: string | null;
        /**
         * Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
         */
        title?: string | null;
    }
    /**
     * Represents a time interval, encoded as a Timestamp start (inclusive) and a Timestamp end (exclusive). The start must be less than or equal to the end. When the start equals the end, the interval is empty (matches no time). When both start and end are unspecified, the interval matches any time.
     */
    export interface Schema$GoogleTypeInterval {
        /**
         * Optional. Exclusive end of the interval. If specified, a Timestamp matching this interval will have to be before the end.
         */
        endTime?: string | null;
        /**
         * Optional. Inclusive start of the interval. If specified, a Timestamp matching this interval will have to be the same or after the start.
         */
        startTime?: string | null;
    }
    export class Resource$Projects {
        context: APIRequestContext;
        locations: Resource$Projects$Locations;
        constructor(context: APIRequestContext);
    }
    export class Resource$Projects$Locations {
        context: APIRequestContext;
        analysisRules: Resource$Projects$Locations$Analysisrules;
        assessmentRules: Resource$Projects$Locations$Assessmentrules;
        authorizedViewSets: Resource$Projects$Locations$Authorizedviewsets;
        autoLabelingRules: Resource$Projects$Locations$Autolabelingrules;
        conversations: Resource$Projects$Locations$Conversations;
        datasets: Resource$Projects$Locations$Datasets;
        encryptionSpec: Resource$Projects$Locations$Encryptionspec;
        insightsdata: Resource$Projects$Locations$Insightsdata;
        issueModels: Resource$Projects$Locations$Issuemodels;
        operations: Resource$Projects$Locations$Operations;
        phraseMatchers: Resource$Projects$Locations$Phrasematchers;
        qaQuestionTags: Resource$Projects$Locations$Qaquestiontags;
        qaScorecards: Resource$Projects$Locations$Qascorecards;
        views: Resource$Projects$Locations$Views;
        constructor(context: APIRequestContext);
        /**
         * Delete feedback labels in bulk using a filter.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.bulkDeleteFeedbackLabels({
         *       // Required. The parent resource for new feedback labels.
         *       parent: 'projects/my-project/locations/my-location',
         *
         *       // Request body metadata
         *       requestBody: {
         *         // request body parameters
         *         // {
         *         //   "filter": "my_filter",
         *         //   "parent": "my_parent"
         *         // }
         *       },
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        bulkDeleteFeedbackLabels(params: Params$Resource$Projects$Locations$Bulkdeletefeedbacklabels, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        bulkDeleteFeedbackLabels(params?: Params$Resource$Projects$Locations$Bulkdeletefeedbacklabels, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        bulkDeleteFeedbackLabels(params: Params$Resource$Projects$Locations$Bulkdeletefeedbacklabels, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        bulkDeleteFeedbackLabels(params: Params$Resource$Projects$Locations$Bulkdeletefeedbacklabels, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        bulkDeleteFeedbackLabels(params: Params$Resource$Projects$Locations$Bulkdeletefeedbacklabels, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        bulkDeleteFeedbackLabels(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * Download feedback labels in bulk from an external source. Currently supports exporting Quality AI example conversations with transcripts and question bodies.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.bulkDownloadFeedbackLabels({
         *       // Required. The parent resource for new feedback labels.
         *       parent: 'projects/my-project/locations/my-location',
         *
         *       // Request body metadata
         *       requestBody: {
         *         // request body parameters
         *         // {
         *         //   "conversationFilter": "my_conversationFilter",
         *         //   "feedbackLabelType": "my_feedbackLabelType",
         *         //   "filter": "my_filter",
         *         //   "gcsDestination": {},
         *         //   "maxDownloadCount": 0,
         *         //   "parent": "my_parent",
         *         //   "sheetsDestination": {},
         *         //   "templateQaScorecardId": []
         *         // }
         *       },
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        bulkDownloadFeedbackLabels(params: Params$Resource$Projects$Locations$Bulkdownloadfeedbacklabels, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        bulkDownloadFeedbackLabels(params?: Params$Resource$Projects$Locations$Bulkdownloadfeedbacklabels, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        bulkDownloadFeedbackLabels(params: Params$Resource$Projects$Locations$Bulkdownloadfeedbacklabels, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        bulkDownloadFeedbackLabels(params: Params$Resource$Projects$Locations$Bulkdownloadfeedbacklabels, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        bulkDownloadFeedbackLabels(params: Params$Resource$Projects$Locations$Bulkdownloadfeedbacklabels, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        bulkDownloadFeedbackLabels(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * Upload feedback labels from an external source in bulk. Currently supports labeling Quality AI example conversations.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.bulkUploadFeedbackLabels({
         *       // Required. The parent resource for new feedback labels.
         *       parent: 'projects/my-project/locations/my-location',
         *
         *       // Request body metadata
         *       requestBody: {
         *         // request body parameters
         *         // {
         *         //   "gcsSource": {},
         *         //   "sheetsSource": {},
         *         //   "validateOnly": false
         *         // }
         *       },
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        bulkUploadFeedbackLabels(params: Params$Resource$Projects$Locations$Bulkuploadfeedbacklabels, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        bulkUploadFeedbackLabels(params?: Params$Resource$Projects$Locations$Bulkuploadfeedbacklabels, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        bulkUploadFeedbackLabels(params: Params$Resource$Projects$Locations$Bulkuploadfeedbacklabels, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        bulkUploadFeedbackLabels(params: Params$Resource$Projects$Locations$Bulkuploadfeedbacklabels, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        bulkUploadFeedbackLabels(params: Params$Resource$Projects$Locations$Bulkuploadfeedbacklabels, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        bulkUploadFeedbackLabels(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * Gets correlation config.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.getCorrelationConfig({
         *       // Required. The name of the correlation config resource to get. Format: projects/{project\}/locations/{location\}/correlationConfig
         *       name: 'projects/my-project/locations/my-location/correlationConfig',
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "createTime": "my_createTime",
         *   //   "fullConversationConfig": {},
         *   //   "name": "my_name",
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        getCorrelationConfig(params: Params$Resource$Projects$Locations$Getcorrelationconfig, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        getCorrelationConfig(params?: Params$Resource$Projects$Locations$Getcorrelationconfig, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1CorrelationConfig>>;
        getCorrelationConfig(params: Params$Resource$Projects$Locations$Getcorrelationconfig, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        getCorrelationConfig(params: Params$Resource$Projects$Locations$Getcorrelationconfig, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1CorrelationConfig>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1CorrelationConfig>): void;
        getCorrelationConfig(params: Params$Resource$Projects$Locations$Getcorrelationconfig, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1CorrelationConfig>): void;
        getCorrelationConfig(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1CorrelationConfig>): void;
        /**
         * Gets location-level encryption key specification.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await contactcenterinsights.projects.locations.getEncryptionSpec({
         *     // Required. The name of the encryption spec resource to get.
         *     name: 'projects/my-project/locations/my-location/encryptionSpec',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "kmsKey": "my_kmsKey",
         *   //   "name": "my_name"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        getEncryptionSpec(params: Params$Resource$Projects$Locations$Getencryptionspec, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        getEncryptionSpec(params?: Params$Resource$Projects$Locations$Getencryptionspec, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1EncryptionSpec>>;
        getEncryptionSpec(params: Params$Resource$Projects$Locations$Getencryptionspec, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        getEncryptionSpec(params: Params$Resource$Projects$Locations$Getencryptionspec, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1EncryptionSpec>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1EncryptionSpec>): void;
        getEncryptionSpec(params: Params$Resource$Projects$Locations$Getencryptionspec, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1EncryptionSpec>): void;
        getEncryptionSpec(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1EncryptionSpec>): void;
        /**
         * Gets project-level settings.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await contactcenterinsights.projects.locations.getSettings({
         *     // Required. The name of the settings resource to get.
         *     name: 'projects/my-project/locations/my-location/settings',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "analysisConfig": {},
         *   //   "conversationTtl": "my_conversationTtl",
         *   //   "createTime": "my_createTime",
         *   //   "languageCode": "my_languageCode",
         *   //   "name": "my_name",
         *   //   "pubsubNotificationSettings": {},
         *   //   "redactionConfig": {},
         *   //   "screenRecordingBucketUri": "my_screenRecordingBucketUri",
         *   //   "speechConfig": {},
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        getSettings(params: Params$Resource$Projects$Locations$Getsettings, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        getSettings(params?: Params$Resource$Projects$Locations$Getsettings, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1Settings>>;
        getSettings(params: Params$Resource$Projects$Locations$Getsettings, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        getSettings(params: Params$Resource$Projects$Locations$Getsettings, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Settings>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Settings>): void;
        getSettings(params: Params$Resource$Projects$Locations$Getsettings, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Settings>): void;
        getSettings(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Settings>): void;
        /**
         * List all feedback labels by project number.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.listAllFeedbackLabels({
         *       // Optional. A filter to reduce results to a specific subset in the entire project. Supports disjunctions (OR) and conjunctions (AND). Supported fields: * `issue_model_id` * `qa_question_id` * `min_create_time` * `max_create_time` * `min_update_time` * `max_update_time` * `feedback_label_type`: QUALITY_AI, TOPIC_MODELING
         *       filter: 'placeholder-value',
         *       // Optional. The maximum number of feedback labels to return in the response. A valid page size ranges from 0 to 100,000 inclusive. If the page size is zero or unspecified, a default page size of 100 will be chosen. Note that a call might return fewer results than the requested page size.
         *       pageSize: 'placeholder-value',
         *       // Optional. The value returned by the last `ListAllFeedbackLabelsResponse`. This value indicates that this is a continuation of a prior `ListAllFeedbackLabels` call and that the system should return the next page of data.
         *       pageToken: 'placeholder-value',
         *       // Required. The parent resource of all feedback labels per project.
         *       parent: 'projects/my-project/locations/my-location',
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "feedbackLabels": [],
         *   //   "nextPageToken": "my_nextPageToken"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        listAllFeedbackLabels(params: Params$Resource$Projects$Locations$Listallfeedbacklabels, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        listAllFeedbackLabels(params?: Params$Resource$Projects$Locations$Listallfeedbacklabels, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1ListAllFeedbackLabelsResponse>>;
        listAllFeedbackLabels(params: Params$Resource$Projects$Locations$Listallfeedbacklabels, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        listAllFeedbackLabels(params: Params$Resource$Projects$Locations$Listallfeedbacklabels, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListAllFeedbackLabelsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListAllFeedbackLabelsResponse>): void;
        listAllFeedbackLabels(params: Params$Resource$Projects$Locations$Listallfeedbacklabels, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListAllFeedbackLabelsResponse>): void;
        listAllFeedbackLabels(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListAllFeedbackLabelsResponse>): void;
        /**
         * Query metrics.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await contactcenterinsights.projects.locations.queryMetrics({
         *     // Required. The location of the data. "projects/{project\}/locations/{location\}"
         *     location: 'projects/my-project/locations/my-location',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "dimensions": [],
         *       //   "filter": "my_filter",
         *       //   "measureMask": "my_measureMask",
         *       //   "timeGranularity": "my_timeGranularity"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        queryMetrics(params: Params$Resource$Projects$Locations$Querymetrics, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        queryMetrics(params?: Params$Resource$Projects$Locations$Querymetrics, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        queryMetrics(params: Params$Resource$Projects$Locations$Querymetrics, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        queryMetrics(params: Params$Resource$Projects$Locations$Querymetrics, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        queryMetrics(params: Params$Resource$Projects$Locations$Querymetrics, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        queryMetrics(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * Generates a summary of predefined performance metrics for a set of conversations. Conversations can be specified by specifying a time window and an agent id, for now. The summary includes a comparison of metrics computed for conversations in the previous time period, and also a comparison with peers in the same time period.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.queryPerformanceOverview({
         *       // Required. The parent resource of the conversations to derive performance stats from. "projects/{project\}/locations/{location\}"
         *       parent: 'projects/my-project/locations/my-location',
         *
         *       // Request body metadata
         *       requestBody: {
         *         // request body parameters
         *         // {
         *         //   "agentPerformanceSource": {},
         *         //   "comparisonQueryInterval": {},
         *         //   "filter": "my_filter",
         *         //   "queryInterval": {}
         *         // }
         *       },
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        queryPerformanceOverview(params: Params$Resource$Projects$Locations$Queryperformanceoverview, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        queryPerformanceOverview(params?: Params$Resource$Projects$Locations$Queryperformanceoverview, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        queryPerformanceOverview(params: Params$Resource$Projects$Locations$Queryperformanceoverview, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        queryPerformanceOverview(params: Params$Resource$Projects$Locations$Queryperformanceoverview, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        queryPerformanceOverview(params: Params$Resource$Projects$Locations$Queryperformanceoverview, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        queryPerformanceOverview(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * Tests correlation config on a conversation.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.testCorrelationConfig({
         *       // Required. The location to test correlation config. Format: projects/{project\}/locations/{location\}
         *       location: 'projects/my-project/locations/my-location',
         *
         *       // Request body metadata
         *       requestBody: {
         *         // request body parameters
         *         // {
         *         //   "conversations": {},
         *         //   "correlationConfig": {},
         *         //   "filter": "my_filter",
         *         //   "maxSampleCount": 0
         *         // }
         *       },
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        testCorrelationConfig(params: Params$Resource$Projects$Locations$Testcorrelationconfig, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        testCorrelationConfig(params?: Params$Resource$Projects$Locations$Testcorrelationconfig, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        testCorrelationConfig(params: Params$Resource$Projects$Locations$Testcorrelationconfig, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        testCorrelationConfig(params: Params$Resource$Projects$Locations$Testcorrelationconfig, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        testCorrelationConfig(params: Params$Resource$Projects$Locations$Testcorrelationconfig, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        testCorrelationConfig(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * Updates correlation config.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.updateCorrelationConfig({
         *       // Immutable. Identifier. The resource name of the correlation config. Format: projects/{project\}/locations/{location\}/correlationConfig
         *       name: 'projects/my-project/locations/my-location/correlationConfig',
         *       // Optional. The list of fields to be updated.
         *       updateMask: 'placeholder-value',
         *
         *       // Request body metadata
         *       requestBody: {
         *         // request body parameters
         *         // {
         *         //   "createTime": "my_createTime",
         *         //   "fullConversationConfig": {},
         *         //   "name": "my_name",
         *         //   "updateTime": "my_updateTime"
         *         // }
         *       },
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "createTime": "my_createTime",
         *   //   "fullConversationConfig": {},
         *   //   "name": "my_name",
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        updateCorrelationConfig(params: Params$Resource$Projects$Locations$Updatecorrelationconfig, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        updateCorrelationConfig(params?: Params$Resource$Projects$Locations$Updatecorrelationconfig, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1CorrelationConfig>>;
        updateCorrelationConfig(params: Params$Resource$Projects$Locations$Updatecorrelationconfig, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        updateCorrelationConfig(params: Params$Resource$Projects$Locations$Updatecorrelationconfig, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1CorrelationConfig>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1CorrelationConfig>): void;
        updateCorrelationConfig(params: Params$Resource$Projects$Locations$Updatecorrelationconfig, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1CorrelationConfig>): void;
        updateCorrelationConfig(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1CorrelationConfig>): void;
        /**
         * Updates project-level settings.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await contactcenterinsights.projects.locations.updateSettings({
         *     // Immutable. The resource name of the settings resource. Format: projects/{project\}/locations/{location\}/settings
         *     name: 'projects/my-project/locations/my-location/settings',
         *     // Required. The list of fields to be updated.
         *     updateMask: 'placeholder-value',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "analysisConfig": {},
         *       //   "conversationTtl": "my_conversationTtl",
         *       //   "createTime": "my_createTime",
         *       //   "languageCode": "my_languageCode",
         *       //   "name": "my_name",
         *       //   "pubsubNotificationSettings": {},
         *       //   "redactionConfig": {},
         *       //   "screenRecordingBucketUri": "my_screenRecordingBucketUri",
         *       //   "speechConfig": {},
         *       //   "updateTime": "my_updateTime"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "analysisConfig": {},
         *   //   "conversationTtl": "my_conversationTtl",
         *   //   "createTime": "my_createTime",
         *   //   "languageCode": "my_languageCode",
         *   //   "name": "my_name",
         *   //   "pubsubNotificationSettings": {},
         *   //   "redactionConfig": {},
         *   //   "screenRecordingBucketUri": "my_screenRecordingBucketUri",
         *   //   "speechConfig": {},
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        updateSettings(params: Params$Resource$Projects$Locations$Updatesettings, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        updateSettings(params?: Params$Resource$Projects$Locations$Updatesettings, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1Settings>>;
        updateSettings(params: Params$Resource$Projects$Locations$Updatesettings, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        updateSettings(params: Params$Resource$Projects$Locations$Updatesettings, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Settings>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Settings>): void;
        updateSettings(params: Params$Resource$Projects$Locations$Updatesettings, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Settings>): void;
        updateSettings(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Settings>): void;
    }
    export interface Params$Resource$Projects$Locations$Bulkdeletefeedbacklabels extends StandardParameters {
        /**
         * Required. The parent resource for new feedback labels.
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudContactcenterinsightsV1BulkDeleteFeedbackLabelsRequest;
    }
    export interface Params$Resource$Projects$Locations$Bulkdownloadfeedbacklabels extends StandardParameters {
        /**
         * Required. The parent resource for new feedback labels.
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsRequest;
    }
    export interface Params$Resource$Projects$Locations$Bulkuploadfeedbacklabels extends StandardParameters {
        /**
         * Required. The parent resource for new feedback labels.
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudContactcenterinsightsV1BulkUploadFeedbackLabelsRequest;
    }
    export interface Params$Resource$Projects$Locations$Getcorrelationconfig extends StandardParameters {
        /**
         * Required. The name of the correlation config resource to get. Format: projects/{project\}/locations/{location\}/correlationConfig
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Getencryptionspec extends StandardParameters {
        /**
         * Required. The name of the encryption spec resource to get.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Getsettings extends StandardParameters {
        /**
         * Required. The name of the settings resource to get.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Listallfeedbacklabels extends StandardParameters {
        /**
         * Optional. A filter to reduce results to a specific subset in the entire project. Supports disjunctions (OR) and conjunctions (AND). Supported fields: * `issue_model_id` * `qa_question_id` * `min_create_time` * `max_create_time` * `min_update_time` * `max_update_time` * `feedback_label_type`: QUALITY_AI, TOPIC_MODELING
         */
        filter?: string;
        /**
         * Optional. The maximum number of feedback labels to return in the response. A valid page size ranges from 0 to 100,000 inclusive. If the page size is zero or unspecified, a default page size of 100 will be chosen. Note that a call might return fewer results than the requested page size.
         */
        pageSize?: number;
        /**
         * Optional. The value returned by the last `ListAllFeedbackLabelsResponse`. This value indicates that this is a continuation of a prior `ListAllFeedbackLabels` call and that the system should return the next page of data.
         */
        pageToken?: string;
        /**
         * Required. The parent resource of all feedback labels per project.
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Locations$Querymetrics extends StandardParameters {
        /**
         * Required. The location of the data. "projects/{project\}/locations/{location\}"
         */
        location?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudContactcenterinsightsV1QueryMetricsRequest;
    }
    export interface Params$Resource$Projects$Locations$Queryperformanceoverview extends StandardParameters {
        /**
         * Required. The parent resource of the conversations to derive performance stats from. "projects/{project\}/locations/{location\}"
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudContactcenterinsightsV1QueryPerformanceOverviewRequest;
    }
    export interface Params$Resource$Projects$Locations$Testcorrelationconfig extends StandardParameters {
        /**
         * Required. The location to test correlation config. Format: projects/{project\}/locations/{location\}
         */
        location?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudContactcenterinsightsV1TestCorrelationConfigRequest;
    }
    export interface Params$Resource$Projects$Locations$Updatecorrelationconfig extends StandardParameters {
        /**
         * Immutable. Identifier. The resource name of the correlation config. Format: projects/{project\}/locations/{location\}/correlationConfig
         */
        name?: string;
        /**
         * Optional. The list of fields to be updated.
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudContactcenterinsightsV1CorrelationConfig;
    }
    export interface Params$Resource$Projects$Locations$Updatesettings extends StandardParameters {
        /**
         * Immutable. The resource name of the settings resource. Format: projects/{project\}/locations/{location\}/settings
         */
        name?: string;
        /**
         * Required. The list of fields to be updated.
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudContactcenterinsightsV1Settings;
    }
    export class Resource$Projects$Locations$Analysisrules {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * Creates a analysis rule.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.analysisRules.create({
         *       // Required. The parent resource of the analysis rule. Required. The location to create a analysis rule for. Format: `projects//locations/` or `projects//locations/`
         *       parent: 'projects/my-project/locations/my-location',
         *
         *       // Request body metadata
         *       requestBody: {
         *         // request body parameters
         *         // {
         *         //   "active": false,
         *         //   "analysisPercentage": {},
         *         //   "annotatorSelector": {},
         *         //   "conversationFilter": "my_conversationFilter",
         *         //   "createTime": "my_createTime",
         *         //   "displayName": "my_displayName",
         *         //   "name": "my_name",
         *         //   "updateTime": "my_updateTime"
         *         // }
         *       },
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "active": false,
         *   //   "analysisPercentage": {},
         *   //   "annotatorSelector": {},
         *   //   "conversationFilter": "my_conversationFilter",
         *   //   "createTime": "my_createTime",
         *   //   "displayName": "my_displayName",
         *   //   "name": "my_name",
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Projects$Locations$Analysisrules$Create, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        create(params?: Params$Resource$Projects$Locations$Analysisrules$Create, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1AnalysisRule>>;
        create(params: Params$Resource$Projects$Locations$Analysisrules$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Projects$Locations$Analysisrules$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AnalysisRule>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AnalysisRule>): void;
        create(params: Params$Resource$Projects$Locations$Analysisrules$Create, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AnalysisRule>): void;
        create(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AnalysisRule>): void;
        /**
         * Deletes a analysis rule.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.analysisRules.delete({
         *       // Required. The name of the analysis rule to delete.
         *       name: 'projects/my-project/locations/my-location/analysisRules/my-analysisRule',
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {}
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Projects$Locations$Analysisrules$Delete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        delete(params?: Params$Resource$Projects$Locations$Analysisrules$Delete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleProtobufEmpty>>;
        delete(params: Params$Resource$Projects$Locations$Analysisrules$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Projects$Locations$Analysisrules$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleProtobufEmpty>, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(params: Params$Resource$Projects$Locations$Analysisrules$Delete, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        /**
         * Get a analysis rule.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await contactcenterinsights.projects.locations.analysisRules.get({
         *     // Required. The name of the AnalysisRule to get.
         *     name: 'projects/my-project/locations/my-location/analysisRules/my-analysisRule',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "active": false,
         *   //   "analysisPercentage": {},
         *   //   "annotatorSelector": {},
         *   //   "conversationFilter": "my_conversationFilter",
         *   //   "createTime": "my_createTime",
         *   //   "displayName": "my_displayName",
         *   //   "name": "my_name",
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Locations$Analysisrules$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Locations$Analysisrules$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1AnalysisRule>>;
        get(params: Params$Resource$Projects$Locations$Analysisrules$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Locations$Analysisrules$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AnalysisRule>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AnalysisRule>): void;
        get(params: Params$Resource$Projects$Locations$Analysisrules$Get, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AnalysisRule>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AnalysisRule>): void;
        /**
         * Lists analysis rules.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await contactcenterinsights.projects.locations.analysisRules.list(
         *     {
         *       // Optional. The maximum number of analysis rule to return in the response. If this value is zero, the service will select a default size. A call may return fewer objects than requested. A non-empty `next_page_token` in the response indicates that more data is available.
         *       pageSize: 'placeholder-value',
         *       // Optional. The value returned by the last `ListAnalysisRulesResponse`; indicates that this is a continuation of a prior `ListAnalysisRules` call and the system should return the next page of data.
         *       pageToken: 'placeholder-value',
         *       // Required. The parent resource of the analysis rules.
         *       parent: 'projects/my-project/locations/my-location',
         *     },
         *   );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "analysisRules": [],
         *   //   "nextPageToken": "my_nextPageToken"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Locations$Analysisrules$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Locations$Analysisrules$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1ListAnalysisRulesResponse>>;
        list(params: Params$Resource$Projects$Locations$Analysisrules$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Locations$Analysisrules$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListAnalysisRulesResponse>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListAnalysisRulesResponse>): void;
        list(params: Params$Resource$Projects$Locations$Analysisrules$List, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListAnalysisRulesResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListAnalysisRulesResponse>): void;
        /**
         * Updates a analysis rule.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.analysisRules.patch({
         *       // Identifier. The resource name of the analysis rule. Format: projects/{project\}/locations/{location\}/analysisRules/{analysis_rule\}
         *       name: 'projects/my-project/locations/my-location/analysisRules/my-analysisRule',
         *       // Optional. The list of fields to be updated. If the update_mask is not provided, the update will be applied to all fields.
         *       updateMask: 'placeholder-value',
         *
         *       // Request body metadata
         *       requestBody: {
         *         // request body parameters
         *         // {
         *         //   "active": false,
         *         //   "analysisPercentage": {},
         *         //   "annotatorSelector": {},
         *         //   "conversationFilter": "my_conversationFilter",
         *         //   "createTime": "my_createTime",
         *         //   "displayName": "my_displayName",
         *         //   "name": "my_name",
         *         //   "updateTime": "my_updateTime"
         *         // }
         *       },
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "active": false,
         *   //   "analysisPercentage": {},
         *   //   "annotatorSelector": {},
         *   //   "conversationFilter": "my_conversationFilter",
         *   //   "createTime": "my_createTime",
         *   //   "displayName": "my_displayName",
         *   //   "name": "my_name",
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        patch(params: Params$Resource$Projects$Locations$Analysisrules$Patch, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        patch(params?: Params$Resource$Projects$Locations$Analysisrules$Patch, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1AnalysisRule>>;
        patch(params: Params$Resource$Projects$Locations$Analysisrules$Patch, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        patch(params: Params$Resource$Projects$Locations$Analysisrules$Patch, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AnalysisRule>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AnalysisRule>): void;
        patch(params: Params$Resource$Projects$Locations$Analysisrules$Patch, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AnalysisRule>): void;
        patch(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AnalysisRule>): void;
    }
    export interface Params$Resource$Projects$Locations$Analysisrules$Create extends StandardParameters {
        /**
         * Required. The parent resource of the analysis rule. Required. The location to create a analysis rule for. Format: `projects//locations/` or `projects//locations/`
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudContactcenterinsightsV1AnalysisRule;
    }
    export interface Params$Resource$Projects$Locations$Analysisrules$Delete extends StandardParameters {
        /**
         * Required. The name of the analysis rule to delete.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Analysisrules$Get extends StandardParameters {
        /**
         * Required. The name of the AnalysisRule to get.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Analysisrules$List extends StandardParameters {
        /**
         * Optional. The maximum number of analysis rule to return in the response. If this value is zero, the service will select a default size. A call may return fewer objects than requested. A non-empty `next_page_token` in the response indicates that more data is available.
         */
        pageSize?: number;
        /**
         * Optional. The value returned by the last `ListAnalysisRulesResponse`; indicates that this is a continuation of a prior `ListAnalysisRules` call and the system should return the next page of data.
         */
        pageToken?: string;
        /**
         * Required. The parent resource of the analysis rules.
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Locations$Analysisrules$Patch extends StandardParameters {
        /**
         * Identifier. The resource name of the analysis rule. Format: projects/{project\}/locations/{location\}/analysisRules/{analysis_rule\}
         */
        name?: string;
        /**
         * Optional. The list of fields to be updated. If the update_mask is not provided, the update will be applied to all fields.
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudContactcenterinsightsV1AnalysisRule;
    }
    export class Resource$Projects$Locations$Assessmentrules {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * Creates an assessment rule.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.assessmentRules.create({
         *       // Optional. A unique ID for the new AssessmentRule. This ID will become the final component of the AssessmentRule's resource name. If no ID is specified, a server-generated ID will be used. This value should be 4-64 characters and must match the regular expression `^[a-z]([a-z0-9-]{0,61\}[a-z0-9])?$`.
         *       assessmentRuleId: 'placeholder-value',
         *       // Required. The parent resource of the assessment rule. Required. The location to create a assessment rule for. Format: `projects//locations/` or `projects//locations/`
         *       parent: 'projects/my-project/locations/my-location',
         *
         *       // Request body metadata
         *       requestBody: {
         *         // request body parameters
         *         // {
         *         //   "active": false,
         *         //   "createTime": "my_createTime",
         *         //   "displayName": "my_displayName",
         *         //   "name": "my_name",
         *         //   "sampleRule": {},
         *         //   "scheduleInfo": {},
         *         //   "updateTime": "my_updateTime"
         *         // }
         *       },
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "active": false,
         *   //   "createTime": "my_createTime",
         *   //   "displayName": "my_displayName",
         *   //   "name": "my_name",
         *   //   "sampleRule": {},
         *   //   "scheduleInfo": {},
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Projects$Locations$Assessmentrules$Create, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        create(params?: Params$Resource$Projects$Locations$Assessmentrules$Create, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1AssessmentRule>>;
        create(params: Params$Resource$Projects$Locations$Assessmentrules$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Projects$Locations$Assessmentrules$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AssessmentRule>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AssessmentRule>): void;
        create(params: Params$Resource$Projects$Locations$Assessmentrules$Create, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AssessmentRule>): void;
        create(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AssessmentRule>): void;
        /**
         * Deletes an assessment rule.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.assessmentRules.delete({
         *       // Required. The name of the assessment rule to delete.
         *       name: 'projects/my-project/locations/my-location/assessmentRules/my-assessmentRule',
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {}
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Projects$Locations$Assessmentrules$Delete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        delete(params?: Params$Resource$Projects$Locations$Assessmentrules$Delete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleProtobufEmpty>>;
        delete(params: Params$Resource$Projects$Locations$Assessmentrules$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Projects$Locations$Assessmentrules$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleProtobufEmpty>, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(params: Params$Resource$Projects$Locations$Assessmentrules$Delete, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        /**
         * Get an assessment rule.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.assessmentRules.get({
         *       // Required. The name of the assessment rule to get.
         *       name: 'projects/my-project/locations/my-location/assessmentRules/my-assessmentRule',
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "active": false,
         *   //   "createTime": "my_createTime",
         *   //   "displayName": "my_displayName",
         *   //   "name": "my_name",
         *   //   "sampleRule": {},
         *   //   "scheduleInfo": {},
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Locations$Assessmentrules$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Locations$Assessmentrules$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1AssessmentRule>>;
        get(params: Params$Resource$Projects$Locations$Assessmentrules$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Locations$Assessmentrules$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AssessmentRule>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AssessmentRule>): void;
        get(params: Params$Resource$Projects$Locations$Assessmentrules$Get, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AssessmentRule>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AssessmentRule>): void;
        /**
         * Lists assessment rules.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.assessmentRules.list({
         *       // Optional. The maximum number of assessment rule to return in the response. If this value is zero, the service will select a default size. A call may return fewer objects than requested. A non-empty `next_page_token` in the response indicates that more data is available.
         *       pageSize: 'placeholder-value',
         *       // Optional. The value returned by the last `ListAssessmentRulesResponse`; indicates that this is a continuation of a prior `ListAssessmentRules` call and the system should return the next page of data.
         *       pageToken: 'placeholder-value',
         *       // Required. The parent resource of the assessment rules.
         *       parent: 'projects/my-project/locations/my-location',
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "assessmentRules": [],
         *   //   "nextPageToken": "my_nextPageToken"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Locations$Assessmentrules$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Locations$Assessmentrules$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1ListAssessmentRulesResponse>>;
        list(params: Params$Resource$Projects$Locations$Assessmentrules$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Locations$Assessmentrules$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListAssessmentRulesResponse>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListAssessmentRulesResponse>): void;
        list(params: Params$Resource$Projects$Locations$Assessmentrules$List, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListAssessmentRulesResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListAssessmentRulesResponse>): void;
        /**
         * Updates an assessment rule.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.assessmentRules.patch({
         *       // Identifier. The resource name of the assessment rule. Format: projects/{project\}/locations/{location\}/assessmentRules/{assessment_rule\}
         *       name: 'projects/my-project/locations/my-location/assessmentRules/my-assessmentRule',
         *       // Optional. The list of fields to be updated. If the update_mask is not provided, the update will be applied to all fields.
         *       updateMask: 'placeholder-value',
         *
         *       // Request body metadata
         *       requestBody: {
         *         // request body parameters
         *         // {
         *         //   "active": false,
         *         //   "createTime": "my_createTime",
         *         //   "displayName": "my_displayName",
         *         //   "name": "my_name",
         *         //   "sampleRule": {},
         *         //   "scheduleInfo": {},
         *         //   "updateTime": "my_updateTime"
         *         // }
         *       },
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "active": false,
         *   //   "createTime": "my_createTime",
         *   //   "displayName": "my_displayName",
         *   //   "name": "my_name",
         *   //   "sampleRule": {},
         *   //   "scheduleInfo": {},
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        patch(params: Params$Resource$Projects$Locations$Assessmentrules$Patch, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        patch(params?: Params$Resource$Projects$Locations$Assessmentrules$Patch, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1AssessmentRule>>;
        patch(params: Params$Resource$Projects$Locations$Assessmentrules$Patch, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        patch(params: Params$Resource$Projects$Locations$Assessmentrules$Patch, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AssessmentRule>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AssessmentRule>): void;
        patch(params: Params$Resource$Projects$Locations$Assessmentrules$Patch, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AssessmentRule>): void;
        patch(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AssessmentRule>): void;
    }
    export interface Params$Resource$Projects$Locations$Assessmentrules$Create extends StandardParameters {
        /**
         * Optional. A unique ID for the new AssessmentRule. This ID will become the final component of the AssessmentRule's resource name. If no ID is specified, a server-generated ID will be used. This value should be 4-64 characters and must match the regular expression `^[a-z]([a-z0-9-]{0,61\}[a-z0-9])?$`.
         */
        assessmentRuleId?: string;
        /**
         * Required. The parent resource of the assessment rule. Required. The location to create a assessment rule for. Format: `projects//locations/` or `projects//locations/`
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudContactcenterinsightsV1AssessmentRule;
    }
    export interface Params$Resource$Projects$Locations$Assessmentrules$Delete extends StandardParameters {
        /**
         * Required. The name of the assessment rule to delete.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Assessmentrules$Get extends StandardParameters {
        /**
         * Required. The name of the assessment rule to get.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Assessmentrules$List extends StandardParameters {
        /**
         * Optional. The maximum number of assessment rule to return in the response. If this value is zero, the service will select a default size. A call may return fewer objects than requested. A non-empty `next_page_token` in the response indicates that more data is available.
         */
        pageSize?: number;
        /**
         * Optional. The value returned by the last `ListAssessmentRulesResponse`; indicates that this is a continuation of a prior `ListAssessmentRules` call and the system should return the next page of data.
         */
        pageToken?: string;
        /**
         * Required. The parent resource of the assessment rules.
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Locations$Assessmentrules$Patch extends StandardParameters {
        /**
         * Identifier. The resource name of the assessment rule. Format: projects/{project\}/locations/{location\}/assessmentRules/{assessment_rule\}
         */
        name?: string;
        /**
         * Optional. The list of fields to be updated. If the update_mask is not provided, the update will be applied to all fields.
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudContactcenterinsightsV1AssessmentRule;
    }
    export class Resource$Projects$Locations$Authorizedviewsets {
        context: APIRequestContext;
        authorizedViews: Resource$Projects$Locations$Authorizedviewsets$Authorizedviews;
        constructor(context: APIRequestContext);
        /**
         * Create AuthorizedViewSet
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.authorizedViewSets.create({
         *       // Optional. A unique ID for the new AuthorizedViewSet. This ID will become the final component of the AuthorizedViewSet's resource name. If no ID is specified, a server-generated ID will be used. This value should be 4-64 characters and must match the regular expression `^[a-z]([a-z0-9-]{0,61\}[a-z0-9])?$`. See https://google.aip.dev/122#resource-id-segments
         *       authorizedViewSetId: 'placeholder-value',
         *       // Required. The parent resource of the AuthorizedViewSet.
         *       parent: 'projects/my-project/locations/my-location',
         *
         *       // Request body metadata
         *       requestBody: {
         *         // request body parameters
         *         // {
         *         //   "createTime": "my_createTime",
         *         //   "displayName": "my_displayName",
         *         //   "name": "my_name",
         *         //   "updateTime": "my_updateTime"
         *         // }
         *       },
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "createTime": "my_createTime",
         *   //   "displayName": "my_displayName",
         *   //   "name": "my_name",
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Projects$Locations$Authorizedviewsets$Create, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        create(params?: Params$Resource$Projects$Locations$Authorizedviewsets$Create, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1AuthorizedViewSet>>;
        create(params: Params$Resource$Projects$Locations$Authorizedviewsets$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Projects$Locations$Authorizedviewsets$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AuthorizedViewSet>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AuthorizedViewSet>): void;
        create(params: Params$Resource$Projects$Locations$Authorizedviewsets$Create, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AuthorizedViewSet>): void;
        create(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AuthorizedViewSet>): void;
        /**
         * Deletes an AuthorizedViewSet.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.authorizedViewSets.delete({
         *       // Optional. If set to true, all of this AuthorizedViewSet's child resources will also be deleted. Otherwise, the request will only succeed if it has none.
         *       force: 'placeholder-value',
         *       // Required. The name of the AuthorizedViewSet to delete.
         *       name: 'projects/my-project/locations/my-location/authorizedViewSets/my-authorizedViewSet',
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {}
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Projects$Locations$Authorizedviewsets$Delete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        delete(params?: Params$Resource$Projects$Locations$Authorizedviewsets$Delete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleProtobufEmpty>>;
        delete(params: Params$Resource$Projects$Locations$Authorizedviewsets$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Projects$Locations$Authorizedviewsets$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleProtobufEmpty>, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(params: Params$Resource$Projects$Locations$Authorizedviewsets$Delete, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        /**
         * Get AuthorizedViewSet
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.authorizedViewSets.get({
         *       // Required. The name of the AuthorizedViewSet to get.
         *       name: 'projects/my-project/locations/my-location/authorizedViewSets/my-authorizedViewSet',
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "createTime": "my_createTime",
         *   //   "displayName": "my_displayName",
         *   //   "name": "my_name",
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Locations$Authorizedviewsets$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Locations$Authorizedviewsets$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1AuthorizedViewSet>>;
        get(params: Params$Resource$Projects$Locations$Authorizedviewsets$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Locations$Authorizedviewsets$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AuthorizedViewSet>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AuthorizedViewSet>): void;
        get(params: Params$Resource$Projects$Locations$Authorizedviewsets$Get, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AuthorizedViewSet>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AuthorizedViewSet>): void;
        /**
         * List AuthorizedViewSets
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.authorizedViewSets.list({
         *       // Optional. The filter expression to filter authorized view sets listed in the response.
         *       filter: 'placeholder-value',
         *       // Optional. The order by expression to order authorized view sets listed in the response.
         *       orderBy: 'placeholder-value',
         *       // Optional. The maximum number of view sets to return in the response. If the value is zero, the service will select a default size. A call might return fewer objects than requested. A non-empty `next_page_token` in the response indicates that more data is available.
         *       pageSize: 'placeholder-value',
         *       // Optional. The value returned by the last `ListAuthorizedViewSetsResponse`. This value indicates that this is a continuation of a prior `ListAuthorizedViewSets` call and that the system should return the next page of data.
         *       pageToken: 'placeholder-value',
         *       // Required. The parent resource of the AuthorizedViewSets.
         *       parent: 'projects/my-project/locations/my-location',
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "authorizedViewSets": [],
         *   //   "nextPageToken": "my_nextPageToken"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Locations$Authorizedviewsets$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Locations$Authorizedviewsets$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1ListAuthorizedViewSetsResponse>>;
        list(params: Params$Resource$Projects$Locations$Authorizedviewsets$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Locations$Authorizedviewsets$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListAuthorizedViewSetsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListAuthorizedViewSetsResponse>): void;
        list(params: Params$Resource$Projects$Locations$Authorizedviewsets$List, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListAuthorizedViewSetsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListAuthorizedViewSetsResponse>): void;
        /**
         * Updates an AuthorizedViewSet.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.authorizedViewSets.patch({
         *       // Identifier. The resource name of the AuthorizedViewSet. Format: projects/{project\}/locations/{location\}/authorizedViewSets/{authorized_view_set\}
         *       name: 'projects/my-project/locations/my-location/authorizedViewSets/my-authorizedViewSet',
         *       // Optional. The list of fields to be updated. All possible fields can be updated by passing `*`, or a subset of the following updateable fields can be provided: * `display_name`
         *       updateMask: 'placeholder-value',
         *
         *       // Request body metadata
         *       requestBody: {
         *         // request body parameters
         *         // {
         *         //   "createTime": "my_createTime",
         *         //   "displayName": "my_displayName",
         *         //   "name": "my_name",
         *         //   "updateTime": "my_updateTime"
         *         // }
         *       },
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "createTime": "my_createTime",
         *   //   "displayName": "my_displayName",
         *   //   "name": "my_name",
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        patch(params: Params$Resource$Projects$Locations$Authorizedviewsets$Patch, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        patch(params?: Params$Resource$Projects$Locations$Authorizedviewsets$Patch, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1AuthorizedViewSet>>;
        patch(params: Params$Resource$Projects$Locations$Authorizedviewsets$Patch, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        patch(params: Params$Resource$Projects$Locations$Authorizedviewsets$Patch, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AuthorizedViewSet>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AuthorizedViewSet>): void;
        patch(params: Params$Resource$Projects$Locations$Authorizedviewsets$Patch, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AuthorizedViewSet>): void;
        patch(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AuthorizedViewSet>): void;
    }
    export interface Params$Resource$Projects$Locations$Authorizedviewsets$Create extends StandardParameters {
        /**
         * Optional. A unique ID for the new AuthorizedViewSet. This ID will become the final component of the AuthorizedViewSet's resource name. If no ID is specified, a server-generated ID will be used. This value should be 4-64 characters and must match the regular expression `^[a-z]([a-z0-9-]{0,61\}[a-z0-9])?$`. See https://google.aip.dev/122#resource-id-segments
         */
        authorizedViewSetId?: string;
        /**
         * Required. The parent resource of the AuthorizedViewSet.
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudContactcenterinsightsV1AuthorizedViewSet;
    }
    export interface Params$Resource$Projects$Locations$Authorizedviewsets$Delete extends StandardParameters {
        /**
         * Optional. If set to true, all of this AuthorizedViewSet's child resources will also be deleted. Otherwise, the request will only succeed if it has none.
         */
        force?: boolean;
        /**
         * Required. The name of the AuthorizedViewSet to delete.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Authorizedviewsets$Get extends StandardParameters {
        /**
         * Required. The name of the AuthorizedViewSet to get.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Authorizedviewsets$List extends StandardParameters {
        /**
         * Optional. The filter expression to filter authorized view sets listed in the response.
         */
        filter?: string;
        /**
         * Optional. The order by expression to order authorized view sets listed in the response.
         */
        orderBy?: string;
        /**
         * Optional. The maximum number of view sets to return in the response. If the value is zero, the service will select a default size. A call might return fewer objects than requested. A non-empty `next_page_token` in the response indicates that more data is available.
         */
        pageSize?: number;
        /**
         * Optional. The value returned by the last `ListAuthorizedViewSetsResponse`. This value indicates that this is a continuation of a prior `ListAuthorizedViewSets` call and that the system should return the next page of data.
         */
        pageToken?: string;
        /**
         * Required. The parent resource of the AuthorizedViewSets.
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Locations$Authorizedviewsets$Patch extends StandardParameters {
        /**
         * Identifier. The resource name of the AuthorizedViewSet. Format: projects/{project\}/locations/{location\}/authorizedViewSets/{authorized_view_set\}
         */
        name?: string;
        /**
         * Optional. The list of fields to be updated. All possible fields can be updated by passing `*`, or a subset of the following updateable fields can be provided: * `display_name`
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudContactcenterinsightsV1AuthorizedViewSet;
    }
    export class Resource$Projects$Locations$Authorizedviewsets$Authorizedviews {
        context: APIRequestContext;
        conversations: Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations;
        operations: Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Operations;
        constructor(context: APIRequestContext);
        /**
         * Create AuthorizedView
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.create(
         *       {
         *         // Optional. A unique ID for the new AuthorizedView. This ID will become the final component of the AuthorizedView's resource name. If no ID is specified, a server-generated ID will be used. This value should be 4-64 characters and must match the regular expression `^[a-z]([a-z0-9-]{0,61\}[a-z0-9])?$`. See https://google.aip.dev/122#resource-id-segments
         *         authorizedViewId: 'placeholder-value',
         *         // Required. The parent resource of the AuthorizedView.
         *         parent:
         *           'projects/my-project/locations/my-location/authorizedViewSets/my-authorizedViewSet',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "conversationFilter": "my_conversationFilter",
         *           //   "createTime": "my_createTime",
         *           //   "displayName": "my_displayName",
         *           //   "name": "my_name",
         *           //   "updateTime": "my_updateTime"
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "conversationFilter": "my_conversationFilter",
         *   //   "createTime": "my_createTime",
         *   //   "displayName": "my_displayName",
         *   //   "name": "my_name",
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Create, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        create(params?: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Create, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1AuthorizedView>>;
        create(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AuthorizedView>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AuthorizedView>): void;
        create(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Create, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AuthorizedView>): void;
        create(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AuthorizedView>): void;
        /**
         * Deletes an AuthorizedView.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.delete(
         *       {
         *         // Required. The name of the AuthorizedView to delete.
         *         name: 'projects/my-project/locations/my-location/authorizedViewSets/my-authorizedViewSet/authorizedViews/my-authorizedView',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {}
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Delete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        delete(params?: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Delete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleProtobufEmpty>>;
        delete(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleProtobufEmpty>, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Delete, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        /**
         * Get AuthorizedView
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.get(
         *       {
         *         // Required. The name of the AuthorizedView to get.
         *         name: 'projects/my-project/locations/my-location/authorizedViewSets/my-authorizedViewSet/authorizedViews/my-authorizedView',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "conversationFilter": "my_conversationFilter",
         *   //   "createTime": "my_createTime",
         *   //   "displayName": "my_displayName",
         *   //   "name": "my_name",
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1AuthorizedView>>;
        get(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AuthorizedView>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AuthorizedView>): void;
        get(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Get, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AuthorizedView>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AuthorizedView>): void;
        /**
         * Gets the access control policy for a resource. Returns an empty policy if the resource exists and does not have a policy set.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.getIamPolicy(
         *       {
         *         // Optional. The maximum policy version that will be used to format the policy. Valid values are 0, 1, and 3. Requests specifying an invalid value will be rejected. Requests for policies with any conditional role bindings must specify version 3. Policies with no conditional role bindings may specify any valid value or leave the field unset. The policy in the response might use the policy version that you specified, or it might use a lower policy version. For example, if you specify version 3, but the policy has no conditional role bindings, the response uses version 1. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
         *         'options.requestedPolicyVersion': 'placeholder-value',
         *         // REQUIRED: The resource for which the policy is being requested. See [Resource names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.
         *         resource:
         *           'projects/my-project/locations/my-location/authorizedViewSets/my-authorizedViewSet/authorizedViews/my-authorizedView',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "auditConfigs": [],
         *   //   "bindings": [],
         *   //   "etag": "my_etag",
         *   //   "version": 0
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        getIamPolicy(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Getiampolicy, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        getIamPolicy(params?: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Getiampolicy, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleIamV1Policy>>;
        getIamPolicy(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Getiampolicy, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        getIamPolicy(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Getiampolicy, options: MethodOptions | BodyResponseCallback<Schema$GoogleIamV1Policy>, callback: BodyResponseCallback<Schema$GoogleIamV1Policy>): void;
        getIamPolicy(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Getiampolicy, callback: BodyResponseCallback<Schema$GoogleIamV1Policy>): void;
        getIamPolicy(callback: BodyResponseCallback<Schema$GoogleIamV1Policy>): void;
        /**
         * List AuthorizedViewSets
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.list(
         *       {
         *         // Optional. The filter expression to filter authorized views listed in the response.
         *         filter: 'placeholder-value',
         *         // Optional. The order by expression to order authorized views listed in the response.
         *         orderBy: 'placeholder-value',
         *         // Optional. The maximum number of view to return in the response. If the value is zero, the service will select a default size. A call might return fewer objects than requested. A non-empty `next_page_token` in the response indicates that more data is available.
         *         pageSize: 'placeholder-value',
         *         // Optional. The value returned by the last `ListAuthorizedViewsResponse`. This value indicates that this is a continuation of a prior `ListAuthorizedViews` call and that the system should return the next page of data.
         *         pageToken: 'placeholder-value',
         *         // Required. The parent resource of the AuthorizedViews. If the parent is set to `-`, all AuthorizedViews under the location will be returned.
         *         parent:
         *           'projects/my-project/locations/my-location/authorizedViewSets/my-authorizedViewSet',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "authorizedViews": [],
         *   //   "nextPageToken": "my_nextPageToken"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1ListAuthorizedViewsResponse>>;
        list(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListAuthorizedViewsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListAuthorizedViewsResponse>): void;
        list(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$List, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListAuthorizedViewsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListAuthorizedViewsResponse>): void;
        /**
         * Updates an AuthorizedView.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.patch(
         *       {
         *         // Identifier. The resource name of the AuthorizedView. Format: projects/{project\}/locations/{location\}/authorizedViewSets/{authorized_view_set\}/authorizedViews/{authorized_view\}
         *         name: 'projects/my-project/locations/my-location/authorizedViewSets/my-authorizedViewSet/authorizedViews/my-authorizedView',
         *         // Optional. The list of fields to be updated. All possible fields can be updated by passing `*`, or a subset of the following updateable fields can be provided: * `conversation_filter` * `display_name`
         *         updateMask: 'placeholder-value',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "conversationFilter": "my_conversationFilter",
         *           //   "createTime": "my_createTime",
         *           //   "displayName": "my_displayName",
         *           //   "name": "my_name",
         *           //   "updateTime": "my_updateTime"
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "conversationFilter": "my_conversationFilter",
         *   //   "createTime": "my_createTime",
         *   //   "displayName": "my_displayName",
         *   //   "name": "my_name",
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        patch(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Patch, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        patch(params?: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Patch, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1AuthorizedView>>;
        patch(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Patch, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        patch(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Patch, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AuthorizedView>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AuthorizedView>): void;
        patch(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Patch, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AuthorizedView>): void;
        patch(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AuthorizedView>): void;
        /**
         * Query metrics.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.queryMetrics(
         *       {
         *         // Required. The location of the data. "projects/{project\}/locations/{location\}"
         *         location:
         *           'projects/my-project/locations/my-location/authorizedViewSets/my-authorizedViewSet/authorizedViews/my-authorizedView',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "dimensions": [],
         *           //   "filter": "my_filter",
         *           //   "measureMask": "my_measureMask",
         *           //   "timeGranularity": "my_timeGranularity"
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        queryMetrics(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Querymetrics, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        queryMetrics(params?: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Querymetrics, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        queryMetrics(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Querymetrics, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        queryMetrics(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Querymetrics, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        queryMetrics(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Querymetrics, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        queryMetrics(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * Generates a summary of predefined performance metrics for a set of conversations. Conversations can be specified by specifying a time window and an agent id, for now. The summary includes a comparison of metrics computed for conversations in the previous time period, and also a comparison with peers in the same time period.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.queryPerformanceOverview(
         *       {
         *         // Required. The parent resource of the conversations to derive performance stats from. "projects/{project\}/locations/{location\}"
         *         parent:
         *           'projects/my-project/locations/my-location/authorizedViewSets/my-authorizedViewSet/authorizedViews/my-authorizedView',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "agentPerformanceSource": {},
         *           //   "comparisonQueryInterval": {},
         *           //   "filter": "my_filter",
         *           //   "queryInterval": {}
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        queryPerformanceOverview(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Queryperformanceoverview, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        queryPerformanceOverview(params?: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Queryperformanceoverview, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        queryPerformanceOverview(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Queryperformanceoverview, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        queryPerformanceOverview(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Queryperformanceoverview, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        queryPerformanceOverview(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Queryperformanceoverview, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        queryPerformanceOverview(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * SearchAuthorizedViewSets
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.search(
         *       {
         *         // Optional. The order by expression to order authorized views listed in the response.
         *         orderBy: 'placeholder-value',
         *         // Optional. The maximum number of view to return in the response. If the value is zero, the service will select a default size. A call might return fewer objects than requested. A non-empty `next_page_token` in the response indicates that more data is available.
         *         pageSize: 'placeholder-value',
         *         // Optional. The value returned by the last `ListAuthorizedViewsResponse`. This value indicates that this is a continuation of a prior `ListAuthorizedViews` call and that the system should return the next page of data.
         *         pageToken: 'placeholder-value',
         *         // Required. The parent resource of the AuthorizedViews. If the parent is set to `-`, all AuthorizedViews under the location will be returned.
         *         parent:
         *           'projects/my-project/locations/my-location/authorizedViewSets/my-authorizedViewSet',
         *         // Optional. The query expression to search authorized views.
         *         query: 'placeholder-value',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "authorizedViews": [],
         *   //   "nextPageToken": "my_nextPageToken"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        search(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Search, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        search(params?: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Search, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1SearchAuthorizedViewsResponse>>;
        search(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Search, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        search(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Search, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1SearchAuthorizedViewsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1SearchAuthorizedViewsResponse>): void;
        search(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Search, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1SearchAuthorizedViewsResponse>): void;
        search(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1SearchAuthorizedViewsResponse>): void;
        /**
         * Sets the access control policy on the specified resource. Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.setIamPolicy(
         *       {
         *         // REQUIRED: The resource for which the policy is being specified. See [Resource names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.
         *         resource:
         *           'projects/my-project/locations/my-location/authorizedViewSets/my-authorizedViewSet/authorizedViews/my-authorizedView',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "policy": {},
         *           //   "updateMask": "my_updateMask"
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "auditConfigs": [],
         *   //   "bindings": [],
         *   //   "etag": "my_etag",
         *   //   "version": 0
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        setIamPolicy(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Setiampolicy, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        setIamPolicy(params?: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Setiampolicy, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleIamV1Policy>>;
        setIamPolicy(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Setiampolicy, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        setIamPolicy(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Setiampolicy, options: MethodOptions | BodyResponseCallback<Schema$GoogleIamV1Policy>, callback: BodyResponseCallback<Schema$GoogleIamV1Policy>): void;
        setIamPolicy(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Setiampolicy, callback: BodyResponseCallback<Schema$GoogleIamV1Policy>): void;
        setIamPolicy(callback: BodyResponseCallback<Schema$GoogleIamV1Policy>): void;
        /**
         * Returns permissions that a caller has on the specified resource. If the resource does not exist, this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This operation is designed to be used for building permission-aware UIs and command-line tools, not for authorization checking. This operation may "fail open" without warning.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.testIamPermissions(
         *       {
         *         // REQUIRED: The resource for which the policy detail is being requested. See [Resource names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.
         *         resource:
         *           'projects/my-project/locations/my-location/authorizedViewSets/my-authorizedViewSet/authorizedViews/my-authorizedView',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "permissions": []
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "permissions": []
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        testIamPermissions(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Testiampermissions, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        testIamPermissions(params?: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Testiampermissions, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleIamV1TestIamPermissionsResponse>>;
        testIamPermissions(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Testiampermissions, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        testIamPermissions(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Testiampermissions, options: MethodOptions | BodyResponseCallback<Schema$GoogleIamV1TestIamPermissionsResponse>, callback: BodyResponseCallback<Schema$GoogleIamV1TestIamPermissionsResponse>): void;
        testIamPermissions(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Testiampermissions, callback: BodyResponseCallback<Schema$GoogleIamV1TestIamPermissionsResponse>): void;
        testIamPermissions(callback: BodyResponseCallback<Schema$GoogleIamV1TestIamPermissionsResponse>): void;
    }
    export interface Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Create extends StandardParameters {
        /**
         * Optional. A unique ID for the new AuthorizedView. This ID will become the final component of the AuthorizedView's resource name. If no ID is specified, a server-generated ID will be used. This value should be 4-64 characters and must match the regular expression `^[a-z]([a-z0-9-]{0,61\}[a-z0-9])?$`. See https://google.aip.dev/122#resource-id-segments
         */
        authorizedViewId?: string;
        /**
         * Required. The parent resource of the AuthorizedView.
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudContactcenterinsightsV1AuthorizedView;
    }
    export interface Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Delete extends StandardParameters {
        /**
         * Required. The name of the AuthorizedView to delete.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Get extends StandardParameters {
        /**
         * Required. The name of the AuthorizedView to get.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Getiampolicy extends StandardParameters {
        /**
         * Optional. The maximum policy version that will be used to format the policy. Valid values are 0, 1, and 3. Requests specifying an invalid value will be rejected. Requests for policies with any conditional role bindings must specify version 3. Policies with no conditional role bindings may specify any valid value or leave the field unset. The policy in the response might use the policy version that you specified, or it might use a lower policy version. For example, if you specify version 3, but the policy has no conditional role bindings, the response uses version 1. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
         */
        'options.requestedPolicyVersion'?: number;
        /**
         * REQUIRED: The resource for which the policy is being requested. See [Resource names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.
         */
        resource?: string;
    }
    export interface Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$List extends StandardParameters {
        /**
         * Optional. The filter expression to filter authorized views listed in the response.
         */
        filter?: string;
        /**
         * Optional. The order by expression to order authorized views listed in the response.
         */
        orderBy?: string;
        /**
         * Optional. The maximum number of view to return in the response. If the value is zero, the service will select a default size. A call might return fewer objects than requested. A non-empty `next_page_token` in the response indicates that more data is available.
         */
        pageSize?: number;
        /**
         * Optional. The value returned by the last `ListAuthorizedViewsResponse`. This value indicates that this is a continuation of a prior `ListAuthorizedViews` call and that the system should return the next page of data.
         */
        pageToken?: string;
        /**
         * Required. The parent resource of the AuthorizedViews. If the parent is set to `-`, all AuthorizedViews under the location will be returned.
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Patch extends StandardParameters {
        /**
         * Identifier. The resource name of the AuthorizedView. Format: projects/{project\}/locations/{location\}/authorizedViewSets/{authorized_view_set\}/authorizedViews/{authorized_view\}
         */
        name?: string;
        /**
         * Optional. The list of fields to be updated. All possible fields can be updated by passing `*`, or a subset of the following updateable fields can be provided: * `conversation_filter` * `display_name`
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudContactcenterinsightsV1AuthorizedView;
    }
    export interface Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Querymetrics extends StandardParameters {
        /**
         * Required. The location of the data. "projects/{project\}/locations/{location\}"
         */
        location?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudContactcenterinsightsV1QueryMetricsRequest;
    }
    export interface Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Queryperformanceoverview extends StandardParameters {
        /**
         * Required. The parent resource of the conversations to derive performance stats from. "projects/{project\}/locations/{location\}"
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudContactcenterinsightsV1QueryPerformanceOverviewRequest;
    }
    export interface Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Search extends StandardParameters {
        /**
         * Optional. The order by expression to order authorized views listed in the response.
         */
        orderBy?: string;
        /**
         * Optional. The maximum number of view to return in the response. If the value is zero, the service will select a default size. A call might return fewer objects than requested. A non-empty `next_page_token` in the response indicates that more data is available.
         */
        pageSize?: number;
        /**
         * Optional. The value returned by the last `ListAuthorizedViewsResponse`. This value indicates that this is a continuation of a prior `ListAuthorizedViews` call and that the system should return the next page of data.
         */
        pageToken?: string;
        /**
         * Required. The parent resource of the AuthorizedViews. If the parent is set to `-`, all AuthorizedViews under the location will be returned.
         */
        parent?: string;
        /**
         * Optional. The query expression to search authorized views.
         */
        query?: string;
    }
    export interface Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Setiampolicy extends StandardParameters {
        /**
         * REQUIRED: The resource for which the policy is being specified. See [Resource names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.
         */
        resource?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleIamV1SetIamPolicyRequest;
    }
    export interface Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Testiampermissions extends StandardParameters {
        /**
         * REQUIRED: The resource for which the policy detail is being requested. See [Resource names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.
         */
        resource?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleIamV1TestIamPermissionsRequest;
    }
    export class Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations {
        context: APIRequestContext;
        assessments: Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments;
        feedbackLabels: Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Feedbacklabels;
        constructor(context: APIRequestContext);
        /**
         * Gets conversation statistics.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.calculateStats(
         *       {
         *         // A filter to reduce results to a specific subset. This field is useful for getting statistics about conversations with specific properties.
         *         filter: 'placeholder-value',
         *         // Required. The location of the conversations.
         *         location:
         *           'projects/my-project/locations/my-location/authorizedViewSets/my-authorizedViewSet/authorizedViews/my-authorizedView',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "averageDuration": "my_averageDuration",
         *   //   "averageTurnCount": 0,
         *   //   "conversationCount": 0,
         *   //   "conversationCountTimeSeries": {},
         *   //   "customHighlighterMatches": {},
         *   //   "issueMatches": {},
         *   //   "issueMatchesStats": {},
         *   //   "smartHighlighterMatches": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        calculateStats(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Calculatestats, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        calculateStats(params?: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Calculatestats, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1CalculateStatsResponse>>;
        calculateStats(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Calculatestats, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        calculateStats(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Calculatestats, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1CalculateStatsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1CalculateStatsResponse>): void;
        calculateStats(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Calculatestats, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1CalculateStatsResponse>): void;
        calculateStats(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1CalculateStatsResponse>): void;
        /**
         * Deletes a conversation.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.delete(
         *       {
         *         // If set to true, all of this conversation's analyses will also be deleted. Otherwise, the request will only succeed if the conversation has no analyses.
         *         force: 'placeholder-value',
         *         // Required. The name of the conversation to delete.
         *         name: 'projects/my-project/locations/my-location/authorizedViewSets/my-authorizedViewSet/authorizedViews/my-authorizedView/conversations/my-conversation',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {}
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Delete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        delete(params?: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Delete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleProtobufEmpty>>;
        delete(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleProtobufEmpty>, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Delete, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        /**
         * Gets the signed URI for the audio for the given conversation.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.generateSignedAudio(
         *       {
         *         // Required. The name of the conversation to sign.
         *         name: 'projects/my-project/locations/my-location/authorizedViewSets/my-authorizedViewSet/authorizedViews/my-authorizedView/conversations/my-conversation',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "signedAudioUris": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        generateSignedAudio(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Generatesignedaudio, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        generateSignedAudio(params?: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Generatesignedaudio, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1GenerateConversationSignedAudioResponse>>;
        generateSignedAudio(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Generatesignedaudio, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        generateSignedAudio(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Generatesignedaudio, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1GenerateConversationSignedAudioResponse>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1GenerateConversationSignedAudioResponse>): void;
        generateSignedAudio(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Generatesignedaudio, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1GenerateConversationSignedAudioResponse>): void;
        generateSignedAudio(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1GenerateConversationSignedAudioResponse>): void;
        /**
         * Gets a conversation.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.get(
         *       {
         *         // Required. The name of the conversation to get.
         *         name: 'projects/my-project/locations/my-location/authorizedViewSets/my-authorizedViewSet/authorizedViews/my-authorizedView/conversations/my-conversation',
         *         // The level of details of the conversation. Default is `FULL`.
         *         view: 'placeholder-value',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "agentId": "my_agentId",
         *   //   "callMetadata": {},
         *   //   "correlationInfo": {},
         *   //   "createTime": "my_createTime",
         *   //   "dataSource": {},
         *   //   "dialogflowIntents": {},
         *   //   "duration": "my_duration",
         *   //   "expireTime": "my_expireTime",
         *   //   "labels": {},
         *   //   "languageCode": "my_languageCode",
         *   //   "latestAnalysis": {},
         *   //   "latestSummary": {},
         *   //   "medium": "my_medium",
         *   //   "metadataJson": "my_metadataJson",
         *   //   "name": "my_name",
         *   //   "obfuscatedUserId": "my_obfuscatedUserId",
         *   //   "qualityMetadata": {},
         *   //   "runtimeAnnotations": [],
         *   //   "startTime": "my_startTime",
         *   //   "transcript": {},
         *   //   "ttl": "my_ttl",
         *   //   "turnCount": 0,
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1Conversation>>;
        get(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Conversation>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Conversation>): void;
        get(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Get, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Conversation>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Conversation>): void;
        /**
         * Lists conversations.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.list(
         *       {
         *         // A filter to reduce results to a specific subset. Useful for querying conversations with specific properties.
         *         filter: 'placeholder-value',
         *         // Optional. The attribute by which to order conversations in the response. If empty, conversations will be ordered by descending creation time. Supported values are one of the following: * create_time * customer_satisfaction_rating * duration * latest_analysis * start_time * turn_count The default sort order is ascending. To specify order, append `asc` or `desc` (`create_time desc`). For more details, see [Google AIPs Ordering](https://google.aip.dev/132#ordering).
         *         orderBy: 'placeholder-value',
         *         // The maximum number of conversations to return in the response. A valid page size ranges from 0 to 100,000 inclusive. If the page size is zero or unspecified, a default page size of 100 will be chosen. Note that a call might return fewer results than the requested page size.
         *         pageSize: 'placeholder-value',
         *         // The value returned by the last `ListConversationsResponse`. This value indicates that this is a continuation of a prior `ListConversations` call and that the system should return the next page of data.
         *         pageToken: 'placeholder-value',
         *         // Required. The parent resource of the conversation.
         *         parent:
         *           'projects/my-project/locations/my-location/authorizedViewSets/my-authorizedViewSet/authorizedViews/my-authorizedView',
         *         // The level of details of the conversation. Default is `BASIC`.
         *         view: 'placeholder-value',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "conversations": [],
         *   //   "nextPageToken": "my_nextPageToken"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1ListConversationsResponse>>;
        list(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListConversationsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListConversationsResponse>): void;
        list(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$List, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListConversationsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListConversationsResponse>): void;
    }
    export interface Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Calculatestats extends StandardParameters {
        /**
         * A filter to reduce results to a specific subset. This field is useful for getting statistics about conversations with specific properties.
         */
        filter?: string;
        /**
         * Required. The location of the conversations.
         */
        location?: string;
    }
    export interface Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Delete extends StandardParameters {
        /**
         * If set to true, all of this conversation's analyses will also be deleted. Otherwise, the request will only succeed if the conversation has no analyses.
         */
        force?: boolean;
        /**
         * Required. The name of the conversation to delete.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Generatesignedaudio extends StandardParameters {
        /**
         * Required. The name of the conversation to sign.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Get extends StandardParameters {
        /**
         * Required. The name of the conversation to get.
         */
        name?: string;
        /**
         * The level of details of the conversation. Default is `FULL`.
         */
        view?: string;
    }
    export interface Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$List extends StandardParameters {
        /**
         * A filter to reduce results to a specific subset. Useful for querying conversations with specific properties.
         */
        filter?: string;
        /**
         * Optional. The attribute by which to order conversations in the response. If empty, conversations will be ordered by descending creation time. Supported values are one of the following: * create_time * customer_satisfaction_rating * duration * latest_analysis * start_time * turn_count The default sort order is ascending. To specify order, append `asc` or `desc` (`create_time desc`). For more details, see [Google AIPs Ordering](https://google.aip.dev/132#ordering).
         */
        orderBy?: string;
        /**
         * The maximum number of conversations to return in the response. A valid page size ranges from 0 to 100,000 inclusive. If the page size is zero or unspecified, a default page size of 100 will be chosen. Note that a call might return fewer results than the requested page size.
         */
        pageSize?: number;
        /**
         * The value returned by the last `ListConversationsResponse`. This value indicates that this is a continuation of a prior `ListConversations` call and that the system should return the next page of data.
         */
        pageToken?: string;
        /**
         * Required. The parent resource of the conversation.
         */
        parent?: string;
        /**
         * The level of details of the conversation. Default is `BASIC`.
         */
        view?: string;
    }
    export class Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments {
        context: APIRequestContext;
        notes: Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Notes;
        constructor(context: APIRequestContext);
        /**
         * Appeal an Assessment.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.assessments.appeal(
         *       {
         *         // Required. The name of the assessment to appeal.
         *         name: 'projects/my-project/locations/my-location/authorizedViewSets/my-authorizedViewSet/authorizedViews/my-authorizedView/conversations/my-conversation/assessments/my-assessment',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {}
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "agentInfo": {},
         *   //   "createTime": "my_createTime",
         *   //   "name": "my_name",
         *   //   "state": "my_state",
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        appeal(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Appeal, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        appeal(params?: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Appeal, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1Assessment>>;
        appeal(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Appeal, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        appeal(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Appeal, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Assessment>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Assessment>): void;
        appeal(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Appeal, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Assessment>): void;
        appeal(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Assessment>): void;
        /**
         * Create Assessment.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.assessments.create(
         *       {
         *         // Required. The parent resource of the assessment.
         *         parent:
         *           'projects/my-project/locations/my-location/authorizedViewSets/my-authorizedViewSet/authorizedViews/my-authorizedView/conversations/my-conversation',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "agentInfo": {},
         *           //   "createTime": "my_createTime",
         *           //   "name": "my_name",
         *           //   "state": "my_state",
         *           //   "updateTime": "my_updateTime"
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "agentInfo": {},
         *   //   "createTime": "my_createTime",
         *   //   "name": "my_name",
         *   //   "state": "my_state",
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Create, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        create(params?: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Create, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1Assessment>>;
        create(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Assessment>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Assessment>): void;
        create(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Create, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Assessment>): void;
        create(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Assessment>): void;
        /**
         * Delete an Assessment.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.assessments.delete(
         *       {
         *         // Optional. If set to true, all of this assessment's notes will also be deleted. Otherwise, the request will only succeed if it has no notes.
         *         force: 'placeholder-value',
         *         // Required. The name of the assessment to delete.
         *         name: 'projects/my-project/locations/my-location/authorizedViewSets/my-authorizedViewSet/authorizedViews/my-authorizedView/conversations/my-conversation/assessments/my-assessment',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {}
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Delete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        delete(params?: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Delete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleProtobufEmpty>>;
        delete(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleProtobufEmpty>, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Delete, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        /**
         * Finalize an Assessment.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.assessments.finalize(
         *       {
         *         // Required. The name of the assessment to finalize.
         *         name: 'projects/my-project/locations/my-location/authorizedViewSets/my-authorizedViewSet/authorizedViews/my-authorizedView/conversations/my-conversation/assessments/my-assessment',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {}
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "agentInfo": {},
         *   //   "createTime": "my_createTime",
         *   //   "name": "my_name",
         *   //   "state": "my_state",
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        finalize(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Finalize, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        finalize(params?: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Finalize, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1Assessment>>;
        finalize(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Finalize, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        finalize(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Finalize, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Assessment>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Assessment>): void;
        finalize(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Finalize, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Assessment>): void;
        finalize(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Assessment>): void;
        /**
         * Get Assessment.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.assessments.get(
         *       {
         *         // Required. The name of the assessment to get.
         *         name: 'projects/my-project/locations/my-location/authorizedViewSets/my-authorizedViewSet/authorizedViews/my-authorizedView/conversations/my-conversation/assessments/my-assessment',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "agentInfo": {},
         *   //   "createTime": "my_createTime",
         *   //   "name": "my_name",
         *   //   "state": "my_state",
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1Assessment>>;
        get(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Assessment>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Assessment>): void;
        get(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Get, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Assessment>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Assessment>): void;
        /**
         * List Assessments.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.assessments.list(
         *       {
         *         // Optional. A filter to reduce results to a specific subset. Supported filters include: * `state` - The state of the assessment * `agent_info.agent_id` - The ID of the agent the assessment is for
         *         filter: 'placeholder-value',
         *         // The maximum number of assessments to list. If zero, the service will select a default size. A call may return fewer objects than requested. A non-empty `next_page_token` in the response indicates that more data is available.
         *         pageSize: 'placeholder-value',
         *         // Optional. The value returned by the last `ListAssessmentRulesResponse`; indicates that this is a continuation of a prior `ListAssessmentRules` call and the system should return the next page of data.
         *         pageToken: 'placeholder-value',
         *         // Required. The parent resource of the assessments. To list all assessments in a location, substitute the conversation ID with a '-' character.
         *         parent:
         *           'projects/my-project/locations/my-location/authorizedViewSets/my-authorizedViewSet/authorizedViews/my-authorizedView/conversations/my-conversation',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "assessments": [],
         *   //   "nextPageToken": "my_nextPageToken"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1ListAssessmentsResponse>>;
        list(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListAssessmentsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListAssessmentsResponse>): void;
        list(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$List, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListAssessmentsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListAssessmentsResponse>): void;
        /**
         * Publish an Assessment.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.assessments.publish(
         *       {
         *         // Required. The name of the assessment to publish.
         *         name: 'projects/my-project/locations/my-location/authorizedViewSets/my-authorizedViewSet/authorizedViews/my-authorizedView/conversations/my-conversation/assessments/my-assessment',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {}
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "agentInfo": {},
         *   //   "createTime": "my_createTime",
         *   //   "name": "my_name",
         *   //   "state": "my_state",
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        publish(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Publish, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        publish(params?: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Publish, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1Assessment>>;
        publish(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Publish, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        publish(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Publish, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Assessment>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Assessment>): void;
        publish(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Publish, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Assessment>): void;
        publish(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Assessment>): void;
    }
    export interface Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Appeal extends StandardParameters {
        /**
         * Required. The name of the assessment to appeal.
         */
        name?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudContactcenterinsightsV1AppealAssessmentRequest;
    }
    export interface Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Create extends StandardParameters {
        /**
         * Required. The parent resource of the assessment.
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudContactcenterinsightsV1Assessment;
    }
    export interface Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Delete extends StandardParameters {
        /**
         * Optional. If set to true, all of this assessment's notes will also be deleted. Otherwise, the request will only succeed if it has no notes.
         */
        force?: boolean;
        /**
         * Required. The name of the assessment to delete.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Finalize extends StandardParameters {
        /**
         * Required. The name of the assessment to finalize.
         */
        name?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudContactcenterinsightsV1FinalizeAssessmentRequest;
    }
    export interface Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Get extends StandardParameters {
        /**
         * Required. The name of the assessment to get.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$List extends StandardParameters {
        /**
         * Optional. A filter to reduce results to a specific subset. Supported filters include: * `state` - The state of the assessment * `agent_info.agent_id` - The ID of the agent the assessment is for
         */
        filter?: string;
        /**
         * The maximum number of assessments to list. If zero, the service will select a default size. A call may return fewer objects than requested. A non-empty `next_page_token` in the response indicates that more data is available.
         */
        pageSize?: number;
        /**
         * Optional. The value returned by the last `ListAssessmentRulesResponse`; indicates that this is a continuation of a prior `ListAssessmentRules` call and the system should return the next page of data.
         */
        pageToken?: string;
        /**
         * Required. The parent resource of the assessments. To list all assessments in a location, substitute the conversation ID with a '-' character.
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Publish extends StandardParameters {
        /**
         * Required. The name of the assessment to publish.
         */
        name?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudContactcenterinsightsV1PublishAssessmentRequest;
    }
    export class Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Notes {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * Create Note.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.assessments.notes.create(
         *       {
         *         // Required. The parent resource of the note.
         *         parent:
         *           'projects/my-project/locations/my-location/authorizedViewSets/my-authorizedViewSet/authorizedViews/my-authorizedView/conversations/my-conversation/assessments/my-assessment',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "assessmentNote": {},
         *           //   "content": "my_content",
         *           //   "conversationTurnNote": {},
         *           //   "createTime": "my_createTime",
         *           //   "name": "my_name",
         *           //   "noteCreator": {},
         *           //   "qaQuestionNote": {},
         *           //   "updateTime": "my_updateTime"
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "assessmentNote": {},
         *   //   "content": "my_content",
         *   //   "conversationTurnNote": {},
         *   //   "createTime": "my_createTime",
         *   //   "name": "my_name",
         *   //   "noteCreator": {},
         *   //   "qaQuestionNote": {},
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Notes$Create, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        create(params?: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Notes$Create, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1Note>>;
        create(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Notes$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Notes$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Note>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Note>): void;
        create(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Notes$Create, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Note>): void;
        create(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Note>): void;
        /**
         * Deletes a Note.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.assessments.notes.delete(
         *       {
         *         // Required. The name of the note to delete.
         *         name: 'projects/my-project/locations/my-location/authorizedViewSets/my-authorizedViewSet/authorizedViews/my-authorizedView/conversations/my-conversation/assessments/my-assessment/notes/my-note',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {}
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Notes$Delete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        delete(params?: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Notes$Delete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleProtobufEmpty>>;
        delete(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Notes$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Notes$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleProtobufEmpty>, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Notes$Delete, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        /**
         * List Notes.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.assessments.notes.list(
         *       {
         *         // Optional. The maximum number of notes to return in the response. If zero the service will select a default size. A call might return fewer objects than requested. A non-empty `next_page_token` in the response indicates that more data is available.
         *         pageSize: 'placeholder-value',
         *         // Optional. The value returned by the last `ListNotesResponse`. This value indicates that this is a continuation of a prior `ListNotes` call and that the system should return the next page of data.
         *         pageToken: 'placeholder-value',
         *         // Required. The parent resource of the notes.
         *         parent:
         *           'projects/my-project/locations/my-location/authorizedViewSets/my-authorizedViewSet/authorizedViews/my-authorizedView/conversations/my-conversation/assessments/my-assessment',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "nextPageToken": "my_nextPageToken",
         *   //   "notes": []
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Notes$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Notes$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1ListNotesResponse>>;
        list(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Notes$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Notes$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListNotesResponse>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListNotesResponse>): void;
        list(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Notes$List, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListNotesResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListNotesResponse>): void;
        /**
         * Update Note.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.assessments.notes.patch(
         *       {
         *         // Identifier. The resource name of the note. Format: projects/{project\}/locations/{location\}/conversations/{conversation\}/assessments/{assessment\}/notes/{note\}
         *         name: 'projects/my-project/locations/my-location/authorizedViewSets/my-authorizedViewSet/authorizedViews/my-authorizedView/conversations/my-conversation/assessments/my-assessment/notes/my-note',
         *         // Optional. The list of fields to be updated. If the update_mask is empty, all updateable fields will be updated. Acceptable fields include: * `content`
         *         updateMask: 'placeholder-value',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "assessmentNote": {},
         *           //   "content": "my_content",
         *           //   "conversationTurnNote": {},
         *           //   "createTime": "my_createTime",
         *           //   "name": "my_name",
         *           //   "noteCreator": {},
         *           //   "qaQuestionNote": {},
         *           //   "updateTime": "my_updateTime"
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "assessmentNote": {},
         *   //   "content": "my_content",
         *   //   "conversationTurnNote": {},
         *   //   "createTime": "my_createTime",
         *   //   "name": "my_name",
         *   //   "noteCreator": {},
         *   //   "qaQuestionNote": {},
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        patch(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Notes$Patch, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        patch(params?: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Notes$Patch, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1Note>>;
        patch(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Notes$Patch, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        patch(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Notes$Patch, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Note>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Note>): void;
        patch(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Notes$Patch, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Note>): void;
        patch(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Note>): void;
    }
    export interface Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Notes$Create extends StandardParameters {
        /**
         * Required. The parent resource of the note.
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudContactcenterinsightsV1Note;
    }
    export interface Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Notes$Delete extends StandardParameters {
        /**
         * Required. The name of the note to delete.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Notes$List extends StandardParameters {
        /**
         * Optional. The maximum number of notes to return in the response. If zero the service will select a default size. A call might return fewer objects than requested. A non-empty `next_page_token` in the response indicates that more data is available.
         */
        pageSize?: number;
        /**
         * Optional. The value returned by the last `ListNotesResponse`. This value indicates that this is a continuation of a prior `ListNotes` call and that the system should return the next page of data.
         */
        pageToken?: string;
        /**
         * Required. The parent resource of the notes.
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Assessments$Notes$Patch extends StandardParameters {
        /**
         * Identifier. The resource name of the note. Format: projects/{project\}/locations/{location\}/conversations/{conversation\}/assessments/{assessment\}/notes/{note\}
         */
        name?: string;
        /**
         * Optional. The list of fields to be updated. If the update_mask is empty, all updateable fields will be updated. Acceptable fields include: * `content`
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudContactcenterinsightsV1Note;
    }
    export class Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Feedbacklabels {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * Create feedback label.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.feedbackLabels.create(
         *       {
         *         // Optional. The ID of the feedback label to create. If one is not specified it will be generated by the server.
         *         feedbackLabelId: 'placeholder-value',
         *         // Required. The parent resource of the feedback label.
         *         parent:
         *           'projects/my-project/locations/my-location/authorizedViewSets/my-authorizedViewSet/authorizedViews/my-authorizedView/conversations/my-conversation',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "createTime": "my_createTime",
         *           //   "label": "my_label",
         *           //   "labeledResource": "my_labeledResource",
         *           //   "name": "my_name",
         *           //   "qaAnswerLabel": {},
         *           //   "updateTime": "my_updateTime"
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "createTime": "my_createTime",
         *   //   "label": "my_label",
         *   //   "labeledResource": "my_labeledResource",
         *   //   "name": "my_name",
         *   //   "qaAnswerLabel": {},
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Feedbacklabels$Create, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        create(params?: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Feedbacklabels$Create, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1FeedbackLabel>>;
        create(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Feedbacklabels$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Feedbacklabels$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1FeedbackLabel>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1FeedbackLabel>): void;
        create(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Feedbacklabels$Create, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1FeedbackLabel>): void;
        create(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1FeedbackLabel>): void;
        /**
         * Delete feedback label.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.feedbackLabels.delete(
         *       {
         *         // Required. The name of the feedback label to delete.
         *         name: 'projects/my-project/locations/my-location/authorizedViewSets/my-authorizedViewSet/authorizedViews/my-authorizedView/conversations/my-conversation/feedbackLabels/my-feedbackLabel',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {}
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Feedbacklabels$Delete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        delete(params?: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Feedbacklabels$Delete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleProtobufEmpty>>;
        delete(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Feedbacklabels$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Feedbacklabels$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleProtobufEmpty>, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Feedbacklabels$Delete, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        /**
         * Get feedback label.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.feedbackLabels.get(
         *       {
         *         // Required. The name of the feedback label to get.
         *         name: 'projects/my-project/locations/my-location/authorizedViewSets/my-authorizedViewSet/authorizedViews/my-authorizedView/conversations/my-conversation/feedbackLabels/my-feedbackLabel',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "createTime": "my_createTime",
         *   //   "label": "my_label",
         *   //   "labeledResource": "my_labeledResource",
         *   //   "name": "my_name",
         *   //   "qaAnswerLabel": {},
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Feedbacklabels$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Feedbacklabels$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1FeedbackLabel>>;
        get(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Feedbacklabels$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Feedbacklabels$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1FeedbackLabel>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1FeedbackLabel>): void;
        get(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Feedbacklabels$Get, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1FeedbackLabel>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1FeedbackLabel>): void;
        /**
         * List feedback labels.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.feedbackLabels.list(
         *       {
         *         // Optional. A filter to reduce results to a specific subset. Supports disjunctions (OR) and conjunctions (AND). Automatically sorts by conversation ID. To sort by all feedback labels in a project see ListAllFeedbackLabels. Supported fields: * `issue_model_id` * `qa_question_id` * `qa_scorecard_id` * `min_create_time` * `max_create_time` * `min_update_time` * `max_update_time` * `feedback_label_type`: QUALITY_AI, TOPIC_MODELING
         *         filter: 'placeholder-value',
         *         // Optional. The maximum number of feedback labels to return in the response. A valid page size ranges from 0 to 100,000 inclusive. If the page size is zero or unspecified, a default page size of 100 will be chosen. Note that a call might return fewer results than the requested page size.
         *         pageSize: 'placeholder-value',
         *         // Optional. The value returned by the last `ListFeedbackLabelsResponse`. This value indicates that this is a continuation of a prior `ListFeedbackLabels` call and that the system should return the next page of data.
         *         pageToken: 'placeholder-value',
         *         // Required. The parent resource of the feedback labels.
         *         parent:
         *           'projects/my-project/locations/my-location/authorizedViewSets/my-authorizedViewSet/authorizedViews/my-authorizedView/conversations/my-conversation',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "feedbackLabels": [],
         *   //   "nextPageToken": "my_nextPageToken"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Feedbacklabels$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Feedbacklabels$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1ListFeedbackLabelsResponse>>;
        list(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Feedbacklabels$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Feedbacklabels$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListFeedbackLabelsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListFeedbackLabelsResponse>): void;
        list(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Feedbacklabels$List, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListFeedbackLabelsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListFeedbackLabelsResponse>): void;
        /**
         * Update feedback label.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.conversations.feedbackLabels.patch(
         *       {
         *         // Immutable. Resource name of the FeedbackLabel. Format: projects/{project\}/locations/{location\}/conversations/{conversation\}/feedbackLabels/{feedback_label\}
         *         name: 'projects/my-project/locations/my-location/authorizedViewSets/my-authorizedViewSet/authorizedViews/my-authorizedView/conversations/my-conversation/feedbackLabels/my-feedbackLabel',
         *         // Required. The list of fields to be updated.
         *         updateMask: 'placeholder-value',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "createTime": "my_createTime",
         *           //   "label": "my_label",
         *           //   "labeledResource": "my_labeledResource",
         *           //   "name": "my_name",
         *           //   "qaAnswerLabel": {},
         *           //   "updateTime": "my_updateTime"
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "createTime": "my_createTime",
         *   //   "label": "my_label",
         *   //   "labeledResource": "my_labeledResource",
         *   //   "name": "my_name",
         *   //   "qaAnswerLabel": {},
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        patch(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Feedbacklabels$Patch, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        patch(params?: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Feedbacklabels$Patch, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1FeedbackLabel>>;
        patch(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Feedbacklabels$Patch, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        patch(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Feedbacklabels$Patch, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1FeedbackLabel>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1FeedbackLabel>): void;
        patch(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Feedbacklabels$Patch, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1FeedbackLabel>): void;
        patch(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1FeedbackLabel>): void;
    }
    export interface Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Feedbacklabels$Create extends StandardParameters {
        /**
         * Optional. The ID of the feedback label to create. If one is not specified it will be generated by the server.
         */
        feedbackLabelId?: string;
        /**
         * Required. The parent resource of the feedback label.
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudContactcenterinsightsV1FeedbackLabel;
    }
    export interface Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Feedbacklabels$Delete extends StandardParameters {
        /**
         * Required. The name of the feedback label to delete.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Feedbacklabels$Get extends StandardParameters {
        /**
         * Required. The name of the feedback label to get.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Feedbacklabels$List extends StandardParameters {
        /**
         * Optional. A filter to reduce results to a specific subset. Supports disjunctions (OR) and conjunctions (AND). Automatically sorts by conversation ID. To sort by all feedback labels in a project see ListAllFeedbackLabels. Supported fields: * `issue_model_id` * `qa_question_id` * `qa_scorecard_id` * `min_create_time` * `max_create_time` * `min_update_time` * `max_update_time` * `feedback_label_type`: QUALITY_AI, TOPIC_MODELING
         */
        filter?: string;
        /**
         * Optional. The maximum number of feedback labels to return in the response. A valid page size ranges from 0 to 100,000 inclusive. If the page size is zero or unspecified, a default page size of 100 will be chosen. Note that a call might return fewer results than the requested page size.
         */
        pageSize?: number;
        /**
         * Optional. The value returned by the last `ListFeedbackLabelsResponse`. This value indicates that this is a continuation of a prior `ListFeedbackLabels` call and that the system should return the next page of data.
         */
        pageToken?: string;
        /**
         * Required. The parent resource of the feedback labels.
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Conversations$Feedbacklabels$Patch extends StandardParameters {
        /**
         * Immutable. Resource name of the FeedbackLabel. Format: projects/{project\}/locations/{location\}/conversations/{conversation\}/feedbackLabels/{feedback_label\}
         */
        name?: string;
        /**
         * Required. The list of fields to be updated.
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudContactcenterinsightsV1FeedbackLabel;
    }
    export class Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Operations {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * Starts asynchronous cancellation on a long-running operation. The server makes a best effort to cancel the operation, but success is not guaranteed. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or other methods to check whether the cancellation succeeded or whether the operation completed despite cancellation. On successful cancellation, the operation is not deleted; instead, it becomes an operation with an Operation.error value with a google.rpc.Status.code of `1`, corresponding to `Code.CANCELLED`.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.operations.cancel(
         *       {
         *         // The name of the operation resource to be cancelled.
         *         name: 'projects/my-project/locations/my-location/authorizedViewSets/my-authorizedViewSet/authorizedViews/my-authorizedView/operations/my-operation',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {}
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        cancel(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Operations$Cancel, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        cancel(params?: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Operations$Cancel, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleProtobufEmpty>>;
        cancel(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Operations$Cancel, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        cancel(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Operations$Cancel, options: MethodOptions | BodyResponseCallback<Schema$GoogleProtobufEmpty>, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        cancel(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Operations$Cancel, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        cancel(callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        /**
         * Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.operations.get(
         *       {
         *         // The name of the operation resource.
         *         name: 'projects/my-project/locations/my-location/authorizedViewSets/my-authorizedViewSet/authorizedViews/my-authorizedView/operations/my-operation',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Operations$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Operations$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        get(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Operations$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Operations$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        get(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Operations$Get, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        get(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.authorizedViewSets.authorizedViews.operations.list(
         *       {
         *         // The standard list filter.
         *         filter: 'placeholder-value',
         *         // The name of the operation's parent resource.
         *         name: 'projects/my-project/locations/my-location/authorizedViewSets/my-authorizedViewSet/authorizedViews/my-authorizedView',
         *         // The standard list page size.
         *         pageSize: 'placeholder-value',
         *         // The standard list page token.
         *         pageToken: 'placeholder-value',
         *         // When set to `true`, operations that are reachable are returned as normal, and those that are unreachable are returned in the ListOperationsResponse.unreachable field. This can only be `true` when reading across collections. For example, when `parent` is set to `"projects/example/locations/-"`. This field is not supported by default and will result in an `UNIMPLEMENTED` error if set unless explicitly documented otherwise in service or product specific documentation.
         *         returnPartialSuccess: 'placeholder-value',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "nextPageToken": "my_nextPageToken",
         *   //   "operations": [],
         *   //   "unreachable": []
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Operations$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Operations$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningListOperationsResponse>>;
        list(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Operations$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Operations$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningListOperationsResponse>, callback: BodyResponseCallback<Schema$GoogleLongrunningListOperationsResponse>): void;
        list(params: Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Operations$List, callback: BodyResponseCallback<Schema$GoogleLongrunningListOperationsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleLongrunningListOperationsResponse>): void;
    }
    export interface Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Operations$Cancel extends StandardParameters {
        /**
         * The name of the operation resource to be cancelled.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Operations$Get extends StandardParameters {
        /**
         * The name of the operation resource.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Authorizedviewsets$Authorizedviews$Operations$List extends StandardParameters {
        /**
         * The standard list filter.
         */
        filter?: string;
        /**
         * The name of the operation's parent resource.
         */
        name?: string;
        /**
         * The standard list page size.
         */
        pageSize?: number;
        /**
         * The standard list page token.
         */
        pageToken?: string;
        /**
         * When set to `true`, operations that are reachable are returned as normal, and those that are unreachable are returned in the ListOperationsResponse.unreachable field. This can only be `true` when reading across collections. For example, when `parent` is set to `"projects/example/locations/-"`. This field is not supported by default and will result in an `UNIMPLEMENTED` error if set unless explicitly documented otherwise in service or product specific documentation.
         */
        returnPartialSuccess?: boolean;
    }
    export class Resource$Projects$Locations$Autolabelingrules {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * Creates an auto labeling rule.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.autoLabelingRules.create({
         *       // Required. The ID to use for the auto labeling rule, which will become the final component of the auto labeling rule's resource name.
         *       autoLabelingRuleId: 'placeholder-value',
         *       // Required. The project and location to create the auto labeling rule in. Format: projects/{project\}/locations/{location\}
         *       parent: 'projects/my-project/locations/my-location',
         *
         *       // Request body metadata
         *       requestBody: {
         *         // request body parameters
         *         // {
         *         //   "active": false,
         *         //   "conditions": [],
         *         //   "createTime": "my_createTime",
         *         //   "description": "my_description",
         *         //   "displayName": "my_displayName",
         *         //   "labelKey": "my_labelKey",
         *         //   "labelKeyType": "my_labelKeyType",
         *         //   "name": "my_name",
         *         //   "updateTime": "my_updateTime"
         *         // }
         *       },
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "active": false,
         *   //   "conditions": [],
         *   //   "createTime": "my_createTime",
         *   //   "description": "my_description",
         *   //   "displayName": "my_displayName",
         *   //   "labelKey": "my_labelKey",
         *   //   "labelKeyType": "my_labelKeyType",
         *   //   "name": "my_name",
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Projects$Locations$Autolabelingrules$Create, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        create(params?: Params$Resource$Projects$Locations$Autolabelingrules$Create, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1AutoLabelingRule>>;
        create(params: Params$Resource$Projects$Locations$Autolabelingrules$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Projects$Locations$Autolabelingrules$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AutoLabelingRule>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AutoLabelingRule>): void;
        create(params: Params$Resource$Projects$Locations$Autolabelingrules$Create, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AutoLabelingRule>): void;
        create(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AutoLabelingRule>): void;
        /**
         * Deletes an auto labeling rule.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.autoLabelingRules.delete({
         *       // Required. The name of the auto labeling rule to delete. Format: projects/{project\}/locations/{location\}/autoLabelingRules/{auto_labeling_rule\}
         *       name: 'projects/my-project/locations/my-location/autoLabelingRules/my-autoLabelingRule',
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {}
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Projects$Locations$Autolabelingrules$Delete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        delete(params?: Params$Resource$Projects$Locations$Autolabelingrules$Delete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleProtobufEmpty>>;
        delete(params: Params$Resource$Projects$Locations$Autolabelingrules$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Projects$Locations$Autolabelingrules$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleProtobufEmpty>, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(params: Params$Resource$Projects$Locations$Autolabelingrules$Delete, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        /**
         * Gets an auto labeling rule.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.autoLabelingRules.get({
         *       // Required. The name of the auto labeling rule to get. Format: projects/{project\}/locations/{location\}/autoLabelingRules/{auto_labeling_rule\}
         *       name: 'projects/my-project/locations/my-location/autoLabelingRules/my-autoLabelingRule',
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "active": false,
         *   //   "conditions": [],
         *   //   "createTime": "my_createTime",
         *   //   "description": "my_description",
         *   //   "displayName": "my_displayName",
         *   //   "labelKey": "my_labelKey",
         *   //   "labelKeyType": "my_labelKeyType",
         *   //   "name": "my_name",
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Locations$Autolabelingrules$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Locations$Autolabelingrules$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1AutoLabelingRule>>;
        get(params: Params$Resource$Projects$Locations$Autolabelingrules$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Locations$Autolabelingrules$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AutoLabelingRule>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AutoLabelingRule>): void;
        get(params: Params$Resource$Projects$Locations$Autolabelingrules$Get, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AutoLabelingRule>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AutoLabelingRule>): void;
        /**
         * Lists auto labeling rules.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.autoLabelingRules.list({
         *       // Optional. The maximum number of auto labeling rules to return in a single response. If unspecified, at most 100 rules will be returned. The maximum value is 1000; values above 1000 will be coerced to 1000.
         *       pageSize: 'placeholder-value',
         *       // Optional. The next_page_token value returned from a previous List request, if any.
         *       pageToken: 'placeholder-value',
         *       // Required. The project and location to list auto labeling rules from. Format: projects/{project\}/locations/{location\}
         *       parent: 'projects/my-project/locations/my-location',
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "autoLabelingRules": [],
         *   //   "nextPageToken": "my_nextPageToken"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Locations$Autolabelingrules$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Locations$Autolabelingrules$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1ListAutoLabelingRulesResponse>>;
        list(params: Params$Resource$Projects$Locations$Autolabelingrules$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Locations$Autolabelingrules$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListAutoLabelingRulesResponse>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListAutoLabelingRulesResponse>): void;
        list(params: Params$Resource$Projects$Locations$Autolabelingrules$List, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListAutoLabelingRulesResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListAutoLabelingRulesResponse>): void;
        /**
         * Updates an auto labeling rule.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.autoLabelingRules.patch({
         *       // Identifier. The resource name of the auto-labeling rule. Format: projects/{project\}/locations/{location\}/autoLabelingRules/{auto_labeling_rule\}
         *       name: 'projects/my-project/locations/my-location/autoLabelingRules/my-autoLabelingRule',
         *       // Optional. The list of fields to be updated.
         *       updateMask: 'placeholder-value',
         *
         *       // Request body metadata
         *       requestBody: {
         *         // request body parameters
         *         // {
         *         //   "active": false,
         *         //   "conditions": [],
         *         //   "createTime": "my_createTime",
         *         //   "description": "my_description",
         *         //   "displayName": "my_displayName",
         *         //   "labelKey": "my_labelKey",
         *         //   "labelKeyType": "my_labelKeyType",
         *         //   "name": "my_name",
         *         //   "updateTime": "my_updateTime"
         *         // }
         *       },
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "active": false,
         *   //   "conditions": [],
         *   //   "createTime": "my_createTime",
         *   //   "description": "my_description",
         *   //   "displayName": "my_displayName",
         *   //   "labelKey": "my_labelKey",
         *   //   "labelKeyType": "my_labelKeyType",
         *   //   "name": "my_name",
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        patch(params: Params$Resource$Projects$Locations$Autolabelingrules$Patch, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        patch(params?: Params$Resource$Projects$Locations$Autolabelingrules$Patch, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1AutoLabelingRule>>;
        patch(params: Params$Resource$Projects$Locations$Autolabelingrules$Patch, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        patch(params: Params$Resource$Projects$Locations$Autolabelingrules$Patch, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AutoLabelingRule>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AutoLabelingRule>): void;
        patch(params: Params$Resource$Projects$Locations$Autolabelingrules$Patch, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AutoLabelingRule>): void;
        patch(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1AutoLabelingRule>): void;
        /**
         * Tests auto labeling rules against a conversation.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.autoLabelingRules.test({
         *       // Required. The parent project and location. Format: projects/{project\}/locations/{location\}
         *       parent: 'projects/my-project/locations/my-location',
         *
         *       // Request body metadata
         *       requestBody: {
         *         // request body parameters
         *         // {
         *         //   "autoLabelingRule": {},
         *         //   "conversation": {}
         *         // }
         *       },
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "labelResult": "my_labelResult"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        test(params: Params$Resource$Projects$Locations$Autolabelingrules$Test, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        test(params?: Params$Resource$Projects$Locations$Autolabelingrules$Test, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1TestAutoLabelingRuleResponse>>;
        test(params: Params$Resource$Projects$Locations$Autolabelingrules$Test, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        test(params: Params$Resource$Projects$Locations$Autolabelingrules$Test, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1TestAutoLabelingRuleResponse>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1TestAutoLabelingRuleResponse>): void;
        test(params: Params$Resource$Projects$Locations$Autolabelingrules$Test, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1TestAutoLabelingRuleResponse>): void;
        test(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1TestAutoLabelingRuleResponse>): void;
    }
    export interface Params$Resource$Projects$Locations$Autolabelingrules$Create extends StandardParameters {
        /**
         * Required. The ID to use for the auto labeling rule, which will become the final component of the auto labeling rule's resource name.
         */
        autoLabelingRuleId?: string;
        /**
         * Required. The project and location to create the auto labeling rule in. Format: projects/{project\}/locations/{location\}
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudContactcenterinsightsV1AutoLabelingRule;
    }
    export interface Params$Resource$Projects$Locations$Autolabelingrules$Delete extends StandardParameters {
        /**
         * Required. The name of the auto labeling rule to delete. Format: projects/{project\}/locations/{location\}/autoLabelingRules/{auto_labeling_rule\}
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Autolabelingrules$Get extends StandardParameters {
        /**
         * Required. The name of the auto labeling rule to get. Format: projects/{project\}/locations/{location\}/autoLabelingRules/{auto_labeling_rule\}
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Autolabelingrules$List extends StandardParameters {
        /**
         * Optional. The maximum number of auto labeling rules to return in a single response. If unspecified, at most 100 rules will be returned. The maximum value is 1000; values above 1000 will be coerced to 1000.
         */
        pageSize?: number;
        /**
         * Optional. The next_page_token value returned from a previous List request, if any.
         */
        pageToken?: string;
        /**
         * Required. The project and location to list auto labeling rules from. Format: projects/{project\}/locations/{location\}
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Locations$Autolabelingrules$Patch extends StandardParameters {
        /**
         * Identifier. The resource name of the auto-labeling rule. Format: projects/{project\}/locations/{location\}/autoLabelingRules/{auto_labeling_rule\}
         */
        name?: string;
        /**
         * Optional. The list of fields to be updated.
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudContactcenterinsightsV1AutoLabelingRule;
    }
    export interface Params$Resource$Projects$Locations$Autolabelingrules$Test extends StandardParameters {
        /**
         * Required. The parent project and location. Format: projects/{project\}/locations/{location\}
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudContactcenterinsightsV1TestAutoLabelingRuleRequest;
    }
    export class Resource$Projects$Locations$Conversations {
        context: APIRequestContext;
        analyses: Resource$Projects$Locations$Conversations$Analyses;
        assessments: Resource$Projects$Locations$Conversations$Assessments;
        feedbackLabels: Resource$Projects$Locations$Conversations$Feedbacklabels;
        segments: Resource$Projects$Locations$Conversations$Segments;
        constructor(context: APIRequestContext);
        /**
         * Analyzes multiple conversations in a single request.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.conversations.bulkAnalyze({
         *       // Required. The parent resource to create analyses in.
         *       parent: 'projects/my-project/locations/my-location',
         *
         *       // Request body metadata
         *       requestBody: {
         *         // request body parameters
         *         // {
         *         //   "analysisPercentage": {},
         *         //   "annotatorSelector": {},
         *         //   "filter": "my_filter",
         *         //   "parent": "my_parent"
         *         // }
         *       },
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        bulkAnalyze(params: Params$Resource$Projects$Locations$Conversations$Bulkanalyze, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        bulkAnalyze(params?: Params$Resource$Projects$Locations$Conversations$Bulkanalyze, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        bulkAnalyze(params: Params$Resource$Projects$Locations$Conversations$Bulkanalyze, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        bulkAnalyze(params: Params$Resource$Projects$Locations$Conversations$Bulkanalyze, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        bulkAnalyze(params: Params$Resource$Projects$Locations$Conversations$Bulkanalyze, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        bulkAnalyze(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * Deletes multiple conversations in a single request.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.conversations.bulkDelete({
         *       // Required. The parent resource to delete conversations from. Format: projects/{project\}/locations/{location\}
         *       parent: 'projects/my-project/locations/my-location',
         *
         *       // Request body metadata
         *       requestBody: {
         *         // request body parameters
         *         // {
         *         //   "filter": "my_filter",
         *         //   "force": false,
         *         //   "maxDeleteCount": 0,
         *         //   "parent": "my_parent"
         *         // }
         *       },
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        bulkDelete(params: Params$Resource$Projects$Locations$Conversations$Bulkdelete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        bulkDelete(params?: Params$Resource$Projects$Locations$Conversations$Bulkdelete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        bulkDelete(params: Params$Resource$Projects$Locations$Conversations$Bulkdelete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        bulkDelete(params: Params$Resource$Projects$Locations$Conversations$Bulkdelete, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        bulkDelete(params: Params$Resource$Projects$Locations$Conversations$Bulkdelete, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        bulkDelete(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * Gets conversation statistics.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.conversations.calculateStats(
         *       {
         *         // A filter to reduce results to a specific subset. This field is useful for getting statistics about conversations with specific properties.
         *         filter: 'placeholder-value',
         *         // Required. The location of the conversations.
         *         location: 'projects/my-project/locations/my-location',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "averageDuration": "my_averageDuration",
         *   //   "averageTurnCount": 0,
         *   //   "conversationCount": 0,
         *   //   "conversationCountTimeSeries": {},
         *   //   "customHighlighterMatches": {},
         *   //   "issueMatches": {},
         *   //   "issueMatchesStats": {},
         *   //   "smartHighlighterMatches": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        calculateStats(params: Params$Resource$Projects$Locations$Conversations$Calculatestats, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        calculateStats(params?: Params$Resource$Projects$Locations$Conversations$Calculatestats, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1CalculateStatsResponse>>;
        calculateStats(params: Params$Resource$Projects$Locations$Conversations$Calculatestats, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        calculateStats(params: Params$Resource$Projects$Locations$Conversations$Calculatestats, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1CalculateStatsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1CalculateStatsResponse>): void;
        calculateStats(params: Params$Resource$Projects$Locations$Conversations$Calculatestats, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1CalculateStatsResponse>): void;
        calculateStats(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1CalculateStatsResponse>): void;
        /**
         * Creates a conversation. Note that this method does not support audio transcription or redaction. Use `conversations.upload` instead.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.conversations.create({
         *       // A unique ID for the new conversation. This ID will become the final component of the conversation's resource name. If no ID is specified, a server-generated ID will be used. This value should be 4-64 characters and must match the regular expression `^[a-z0-9-]{4,64\}$`. Valid characters are `a-z-`
         *       conversationId: 'placeholder-value',
         *       // Required. The parent resource of the conversation.
         *       parent: 'projects/my-project/locations/my-location',
         *
         *       // Request body metadata
         *       requestBody: {
         *         // request body parameters
         *         // {
         *         //   "agentId": "my_agentId",
         *         //   "callMetadata": {},
         *         //   "correlationInfo": {},
         *         //   "createTime": "my_createTime",
         *         //   "dataSource": {},
         *         //   "dialogflowIntents": {},
         *         //   "duration": "my_duration",
         *         //   "expireTime": "my_expireTime",
         *         //   "labels": {},
         *         //   "languageCode": "my_languageCode",
         *         //   "latestAnalysis": {},
         *         //   "latestSummary": {},
         *         //   "medium": "my_medium",
         *         //   "metadataJson": "my_metadataJson",
         *         //   "name": "my_name",
         *         //   "obfuscatedUserId": "my_obfuscatedUserId",
         *         //   "qualityMetadata": {},
         *         //   "runtimeAnnotations": [],
         *         //   "startTime": "my_startTime",
         *         //   "transcript": {},
         *         //   "ttl": "my_ttl",
         *         //   "turnCount": 0,
         *         //   "updateTime": "my_updateTime"
         *         // }
         *       },
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "agentId": "my_agentId",
         *   //   "callMetadata": {},
         *   //   "correlationInfo": {},
         *   //   "createTime": "my_createTime",
         *   //   "dataSource": {},
         *   //   "dialogflowIntents": {},
         *   //   "duration": "my_duration",
         *   //   "expireTime": "my_expireTime",
         *   //   "labels": {},
         *   //   "languageCode": "my_languageCode",
         *   //   "latestAnalysis": {},
         *   //   "latestSummary": {},
         *   //   "medium": "my_medium",
         *   //   "metadataJson": "my_metadataJson",
         *   //   "name": "my_name",
         *   //   "obfuscatedUserId": "my_obfuscatedUserId",
         *   //   "qualityMetadata": {},
         *   //   "runtimeAnnotations": [],
         *   //   "startTime": "my_startTime",
         *   //   "transcript": {},
         *   //   "ttl": "my_ttl",
         *   //   "turnCount": 0,
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Projects$Locations$Conversations$Create, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        create(params?: Params$Resource$Projects$Locations$Conversations$Create, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1Conversation>>;
        create(params: Params$Resource$Projects$Locations$Conversations$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Projects$Locations$Conversations$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Conversation>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Conversation>): void;
        create(params: Params$Resource$Projects$Locations$Conversations$Create, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Conversation>): void;
        create(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Conversation>): void;
        /**
         * Deletes a conversation.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.conversations.delete({
         *       // If set to true, all of this conversation's analyses will also be deleted. Otherwise, the request will only succeed if the conversation has no analyses.
         *       force: 'placeholder-value',
         *       // Required. The name of the conversation to delete.
         *       name: 'projects/my-project/locations/my-location/conversations/my-conversation',
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {}
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Projects$Locations$Conversations$Delete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        delete(params?: Params$Resource$Projects$Locations$Conversations$Delete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleProtobufEmpty>>;
        delete(params: Params$Resource$Projects$Locations$Conversations$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Projects$Locations$Conversations$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleProtobufEmpty>, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(params: Params$Resource$Projects$Locations$Conversations$Delete, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        /**
         * Gets the signed URI for the audio for the given conversation.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.conversations.generateSignedAudio(
         *       {
         *         // Required. The name of the conversation to sign.
         *         name: 'projects/my-project/locations/my-location/conversations/my-conversation',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "signedAudioUris": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        generateSignedAudio(params: Params$Resource$Projects$Locations$Conversations$Generatesignedaudio, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        generateSignedAudio(params?: Params$Resource$Projects$Locations$Conversations$Generatesignedaudio, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1GenerateConversationSignedAudioResponse>>;
        generateSignedAudio(params: Params$Resource$Projects$Locations$Conversations$Generatesignedaudio, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        generateSignedAudio(params: Params$Resource$Projects$Locations$Conversations$Generatesignedaudio, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1GenerateConversationSignedAudioResponse>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1GenerateConversationSignedAudioResponse>): void;
        generateSignedAudio(params: Params$Resource$Projects$Locations$Conversations$Generatesignedaudio, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1GenerateConversationSignedAudioResponse>): void;
        generateSignedAudio(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1GenerateConversationSignedAudioResponse>): void;
        /**
         * Gets a conversation.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await contactcenterinsights.projects.locations.conversations.get({
         *     // Required. The name of the conversation to get.
         *     name: 'projects/my-project/locations/my-location/conversations/my-conversation',
         *     // The level of details of the conversation. Default is `FULL`.
         *     view: 'placeholder-value',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "agentId": "my_agentId",
         *   //   "callMetadata": {},
         *   //   "correlationInfo": {},
         *   //   "createTime": "my_createTime",
         *   //   "dataSource": {},
         *   //   "dialogflowIntents": {},
         *   //   "duration": "my_duration",
         *   //   "expireTime": "my_expireTime",
         *   //   "labels": {},
         *   //   "languageCode": "my_languageCode",
         *   //   "latestAnalysis": {},
         *   //   "latestSummary": {},
         *   //   "medium": "my_medium",
         *   //   "metadataJson": "my_metadataJson",
         *   //   "name": "my_name",
         *   //   "obfuscatedUserId": "my_obfuscatedUserId",
         *   //   "qualityMetadata": {},
         *   //   "runtimeAnnotations": [],
         *   //   "startTime": "my_startTime",
         *   //   "transcript": {},
         *   //   "ttl": "my_ttl",
         *   //   "turnCount": 0,
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Locations$Conversations$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Locations$Conversations$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1Conversation>>;
        get(params: Params$Resource$Projects$Locations$Conversations$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Locations$Conversations$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Conversation>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Conversation>): void;
        get(params: Params$Resource$Projects$Locations$Conversations$Get, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Conversation>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Conversation>): void;
        /**
         * Imports conversations and processes them according to the user's configuration.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.conversations.ingest({
         *       // Required. The parent resource for new conversations.
         *       parent: 'projects/my-project/locations/my-location',
         *
         *       // Request body metadata
         *       requestBody: {
         *         // request body parameters
         *         // {
         *         //   "conversationConfig": {},
         *         //   "gcsSource": {},
         *         //   "parent": "my_parent",
         *         //   "redactionConfig": {},
         *         //   "sampleSize": 0,
         *         //   "speechConfig": {},
         *         //   "transcriptObjectConfig": {}
         *         // }
         *       },
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        ingest(params: Params$Resource$Projects$Locations$Conversations$Ingest, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        ingest(params?: Params$Resource$Projects$Locations$Conversations$Ingest, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        ingest(params: Params$Resource$Projects$Locations$Conversations$Ingest, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        ingest(params: Params$Resource$Projects$Locations$Conversations$Ingest, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        ingest(params: Params$Resource$Projects$Locations$Conversations$Ingest, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        ingest(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * Lists conversations.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await contactcenterinsights.projects.locations.conversations.list(
         *     {
         *       // A filter to reduce results to a specific subset. Useful for querying conversations with specific properties.
         *       filter: 'placeholder-value',
         *       // Optional. The attribute by which to order conversations in the response. If empty, conversations will be ordered by descending creation time. Supported values are one of the following: * create_time * customer_satisfaction_rating * duration * latest_analysis * start_time * turn_count The default sort order is ascending. To specify order, append `asc` or `desc` (`create_time desc`). For more details, see [Google AIPs Ordering](https://google.aip.dev/132#ordering).
         *       orderBy: 'placeholder-value',
         *       // The maximum number of conversations to return in the response. A valid page size ranges from 0 to 100,000 inclusive. If the page size is zero or unspecified, a default page size of 100 will be chosen. Note that a call might return fewer results than the requested page size.
         *       pageSize: 'placeholder-value',
         *       // The value returned by the last `ListConversationsResponse`. This value indicates that this is a continuation of a prior `ListConversations` call and that the system should return the next page of data.
         *       pageToken: 'placeholder-value',
         *       // Required. The parent resource of the conversation.
         *       parent: 'projects/my-project/locations/my-location',
         *       // The level of details of the conversation. Default is `BASIC`.
         *       view: 'placeholder-value',
         *     },
         *   );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "conversations": [],
         *   //   "nextPageToken": "my_nextPageToken"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Locations$Conversations$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Locations$Conversations$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1ListConversationsResponse>>;
        list(params: Params$Resource$Projects$Locations$Conversations$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Locations$Conversations$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListConversationsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListConversationsResponse>): void;
        list(params: Params$Resource$Projects$Locations$Conversations$List, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListConversationsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListConversationsResponse>): void;
        /**
         * Updates a conversation.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.conversations.patch({
         *       // Optional. Defaults to false. If set to true, and the conversation is not found, a new conversation will be created. In this situation, `update_mask` is ignored.
         *       allowMissing: 'placeholder-value',
         *       // Optional. If set to true, the conversation will be updated with auto labeling results.
         *       'conversationAutoLabelingUpdateConfig.allowAutoLabelingUpdate':
         *         'placeholder-value',
         *       // Immutable. The resource name of the conversation. Format: projects/{project\}/locations/{location\}/conversations/{conversation\}
         *       name: 'projects/my-project/locations/my-location/conversations/my-conversation',
         *       // The list of fields to be updated. All possible fields can be updated by passing `*`, or a subset of the following updateable fields can be provided: * `agent_id` * `language_code` * `labels` * `metadata` * `quality_metadata` * `call_metadata` * `start_time` * `expire_time` or `ttl` * `data_source.gcs_source.audio_uri` or * `data_source.dialogflow_source.audio_uri` * `data_source.screen_recordings`
         *       updateMask: 'placeholder-value',
         *
         *       // Request body metadata
         *       requestBody: {
         *         // request body parameters
         *         // {
         *         //   "agentId": "my_agentId",
         *         //   "callMetadata": {},
         *         //   "correlationInfo": {},
         *         //   "createTime": "my_createTime",
         *         //   "dataSource": {},
         *         //   "dialogflowIntents": {},
         *         //   "duration": "my_duration",
         *         //   "expireTime": "my_expireTime",
         *         //   "labels": {},
         *         //   "languageCode": "my_languageCode",
         *         //   "latestAnalysis": {},
         *         //   "latestSummary": {},
         *         //   "medium": "my_medium",
         *         //   "metadataJson": "my_metadataJson",
         *         //   "name": "my_name",
         *         //   "obfuscatedUserId": "my_obfuscatedUserId",
         *         //   "qualityMetadata": {},
         *         //   "runtimeAnnotations": [],
         *         //   "startTime": "my_startTime",
         *         //   "transcript": {},
         *         //   "ttl": "my_ttl",
         *         //   "turnCount": 0,
         *         //   "updateTime": "my_updateTime"
         *         // }
         *       },
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "agentId": "my_agentId",
         *   //   "callMetadata": {},
         *   //   "correlationInfo": {},
         *   //   "createTime": "my_createTime",
         *   //   "dataSource": {},
         *   //   "dialogflowIntents": {},
         *   //   "duration": "my_duration",
         *   //   "expireTime": "my_expireTime",
         *   //   "labels": {},
         *   //   "languageCode": "my_languageCode",
         *   //   "latestAnalysis": {},
         *   //   "latestSummary": {},
         *   //   "medium": "my_medium",
         *   //   "metadataJson": "my_metadataJson",
         *   //   "name": "my_name",
         *   //   "obfuscatedUserId": "my_obfuscatedUserId",
         *   //   "qualityMetadata": {},
         *   //   "runtimeAnnotations": [],
         *   //   "startTime": "my_startTime",
         *   //   "transcript": {},
         *   //   "ttl": "my_ttl",
         *   //   "turnCount": 0,
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        patch(params: Params$Resource$Projects$Locations$Conversations$Patch, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        patch(params?: Params$Resource$Projects$Locations$Conversations$Patch, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1Conversation>>;
        patch(params: Params$Resource$Projects$Locations$Conversations$Patch, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        patch(params: Params$Resource$Projects$Locations$Conversations$Patch, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Conversation>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Conversation>): void;
        patch(params: Params$Resource$Projects$Locations$Conversations$Patch, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Conversation>): void;
        patch(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Conversation>): void;
        /**
         * Samples conversations based on user configuration and handles the sampled conversations for different use cases.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.conversations.sample({
         *       // Required. The parent resource of the dataset.
         *       parent: 'projects/my-project/locations/my-location',
         *
         *       // Request body metadata
         *       requestBody: {
         *         // request body parameters
         *         // {
         *         //   "destinationDataset": {},
         *         //   "parent": "my_parent",
         *         //   "sampleRule": {}
         *         // }
         *       },
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        sample(params: Params$Resource$Projects$Locations$Conversations$Sample, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        sample(params?: Params$Resource$Projects$Locations$Conversations$Sample, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        sample(params: Params$Resource$Projects$Locations$Conversations$Sample, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        sample(params: Params$Resource$Projects$Locations$Conversations$Sample, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        sample(params: Params$Resource$Projects$Locations$Conversations$Sample, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        sample(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * Create a long-running conversation upload operation. This method differs from `CreateConversation` by allowing audio transcription and optional DLP redaction.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.conversations.upload({
         *       // Required. The parent resource of the conversation.
         *       parent: 'projects/my-project/locations/my-location',
         *
         *       // Request body metadata
         *       requestBody: {
         *         // request body parameters
         *         // {
         *         //   "conversation": {},
         *         //   "conversationId": "my_conversationId",
         *         //   "parent": "my_parent",
         *         //   "redactionConfig": {},
         *         //   "speechConfig": {}
         *         // }
         *       },
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        upload(params: Params$Resource$Projects$Locations$Conversations$Upload, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        upload(params?: Params$Resource$Projects$Locations$Conversations$Upload, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        upload(params: Params$Resource$Projects$Locations$Conversations$Upload, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        upload(params: Params$Resource$Projects$Locations$Conversations$Upload, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        upload(params: Params$Resource$Projects$Locations$Conversations$Upload, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        upload(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
    }
    export interface Params$Resource$Projects$Locations$Conversations$Bulkanalyze extends StandardParameters {
        /**
         * Required. The parent resource to create analyses in.
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudContactcenterinsightsV1BulkAnalyzeConversationsRequest;
    }
    export interface Params$Resource$Projects$Locations$Conversations$Bulkdelete extends StandardParameters {
        /**
         * Required. The parent resource to delete conversations from. Format: projects/{project\}/locations/{location\}
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudContactcenterinsightsV1BulkDeleteConversationsRequest;
    }
    export interface Params$Resource$Projects$Locations$Conversations$Calculatestats extends StandardParameters {
        /**
         * A filter to reduce results to a specific subset. This field is useful for getting statistics about conversations with specific properties.
         */
        filter?: string;
        /**
         * Required. The location of the conversations.
         */
        location?: string;
    }
    export interface Params$Resource$Projects$Locations$Conversations$Create extends StandardParameters {
        /**
         * A unique ID for the new conversation. This ID will become the final component of the conversation's resource name. If no ID is specified, a server-generated ID will be used. This value should be 4-64 characters and must match the regular expression `^[a-z0-9-]{4,64\}$`. Valid characters are `a-z-`
         */
        conversationId?: string;
        /**
         * Required. The parent resource of the conversation.
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudContactcenterinsightsV1Conversation;
    }
    export interface Params$Resource$Projects$Locations$Conversations$Delete extends StandardParameters {
        /**
         * If set to true, all of this conversation's analyses will also be deleted. Otherwise, the request will only succeed if the conversation has no analyses.
         */
        force?: boolean;
        /**
         * Required. The name of the conversation to delete.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Conversations$Generatesignedaudio extends StandardParameters {
        /**
         * Required. The name of the conversation to sign.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Conversations$Get extends StandardParameters {
        /**
         * Required. The name of the conversation to get.
         */
        name?: string;
        /**
         * The level of details of the conversation. Default is `FULL`.
         */
        view?: string;
    }
    export interface Params$Resource$Projects$Locations$Conversations$Ingest extends StandardParameters {
        /**
         * Required. The parent resource for new conversations.
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudContactcenterinsightsV1IngestConversationsRequest;
    }
    export interface Params$Resource$Projects$Locations$Conversations$List extends StandardParameters {
        /**
         * A filter to reduce results to a specific subset. Useful for querying conversations with specific properties.
         */
        filter?: string;
        /**
         * Optional. The attribute by which to order conversations in the response. If empty, conversations will be ordered by descending creation time. Supported values are one of the following: * create_time * customer_satisfaction_rating * duration * latest_analysis * start_time * turn_count The default sort order is ascending. To specify order, append `asc` or `desc` (`create_time desc`). For more details, see [Google AIPs Ordering](https://google.aip.dev/132#ordering).
         */
        orderBy?: string;
        /**
         * The maximum number of conversations to return in the response. A valid page size ranges from 0 to 100,000 inclusive. If the page size is zero or unspecified, a default page size of 100 will be chosen. Note that a call might return fewer results than the requested page size.
         */
        pageSize?: number;
        /**
         * The value returned by the last `ListConversationsResponse`. This value indicates that this is a continuation of a prior `ListConversations` call and that the system should return the next page of data.
         */
        pageToken?: string;
        /**
         * Required. The parent resource of the conversation.
         */
        parent?: string;
        /**
         * The level of details of the conversation. Default is `BASIC`.
         */
        view?: string;
    }
    export interface Params$Resource$Projects$Locations$Conversations$Patch extends StandardParameters {
        /**
         * Optional. Defaults to false. If set to true, and the conversation is not found, a new conversation will be created. In this situation, `update_mask` is ignored.
         */
        allowMissing?: boolean;
        /**
         * Optional. If set to true, the conversation will be updated with auto labeling results.
         */
        'conversationAutoLabelingUpdateConfig.allowAutoLabelingUpdate'?: boolean;
        /**
         * Immutable. The resource name of the conversation. Format: projects/{project\}/locations/{location\}/conversations/{conversation\}
         */
        name?: string;
        /**
         * The list of fields to be updated. All possible fields can be updated by passing `*`, or a subset of the following updateable fields can be provided: * `agent_id` * `language_code` * `labels` * `metadata` * `quality_metadata` * `call_metadata` * `start_time` * `expire_time` or `ttl` * `data_source.gcs_source.audio_uri` or * `data_source.dialogflow_source.audio_uri` * `data_source.screen_recordings`
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudContactcenterinsightsV1Conversation;
    }
    export interface Params$Resource$Projects$Locations$Conversations$Sample extends StandardParameters {
        /**
         * Required. The parent resource of the dataset.
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudContactcenterinsightsV1SampleConversationsRequest;
    }
    export interface Params$Resource$Projects$Locations$Conversations$Upload extends StandardParameters {
        /**
         * Required. The parent resource of the conversation.
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudContactcenterinsightsV1UploadConversationRequest;
    }
    export class Resource$Projects$Locations$Conversations$Analyses {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * Creates an analysis. The long running operation is done when the analysis has completed.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.conversations.analyses.create(
         *       {
         *         // Required. The parent resource of the analysis.
         *         parent:
         *           'projects/my-project/locations/my-location/conversations/my-conversation',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "analysisResult": {},
         *           //   "annotatorSelector": {},
         *           //   "createTime": "my_createTime",
         *           //   "name": "my_name",
         *           //   "requestTime": "my_requestTime"
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Projects$Locations$Conversations$Analyses$Create, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        create(params?: Params$Resource$Projects$Locations$Conversations$Analyses$Create, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        create(params: Params$Resource$Projects$Locations$Conversations$Analyses$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Projects$Locations$Conversations$Analyses$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        create(params: Params$Resource$Projects$Locations$Conversations$Analyses$Create, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        create(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * Deletes an analysis.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.conversations.analyses.delete(
         *       {
         *         // Required. The name of the analysis to delete.
         *         name: 'projects/my-project/locations/my-location/conversations/my-conversation/analyses/my-analyse',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {}
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Projects$Locations$Conversations$Analyses$Delete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        delete(params?: Params$Resource$Projects$Locations$Conversations$Analyses$Delete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleProtobufEmpty>>;
        delete(params: Params$Resource$Projects$Locations$Conversations$Analyses$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Projects$Locations$Conversations$Analyses$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleProtobufEmpty>, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(params: Params$Resource$Projects$Locations$Conversations$Analyses$Delete, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        /**
         * Gets an analysis.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.conversations.analyses.get({
         *       // Required. The name of the analysis to get.
         *       name: 'projects/my-project/locations/my-location/conversations/my-conversation/analyses/my-analyse',
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "analysisResult": {},
         *   //   "annotatorSelector": {},
         *   //   "createTime": "my_createTime",
         *   //   "name": "my_name",
         *   //   "requestTime": "my_requestTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Locations$Conversations$Analyses$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Locations$Conversations$Analyses$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1Analysis>>;
        get(params: Params$Resource$Projects$Locations$Conversations$Analyses$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Locations$Conversations$Analyses$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Analysis>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Analysis>): void;
        get(params: Params$Resource$Projects$Locations$Conversations$Analyses$Get, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Analysis>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Analysis>): void;
        /**
         * Lists analyses.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.conversations.analyses.list({
         *       // A filter to reduce results to a specific subset. Useful for querying conversations with specific properties.
         *       filter: 'placeholder-value',
         *       // The maximum number of analyses to return in the response. If this value is zero, the service will select a default size. A call might return fewer objects than requested. A non-empty `next_page_token` in the response indicates that more data is available.
         *       pageSize: 'placeholder-value',
         *       // The value returned by the last `ListAnalysesResponse`; indicates that this is a continuation of a prior `ListAnalyses` call and the system should return the next page of data.
         *       pageToken: 'placeholder-value',
         *       // Required. The parent resource of the analyses.
         *       parent:
         *         'projects/my-project/locations/my-location/conversations/my-conversation',
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "analyses": [],
         *   //   "nextPageToken": "my_nextPageToken"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Locations$Conversations$Analyses$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Locations$Conversations$Analyses$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1ListAnalysesResponse>>;
        list(params: Params$Resource$Projects$Locations$Conversations$Analyses$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Locations$Conversations$Analyses$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListAnalysesResponse>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListAnalysesResponse>): void;
        list(params: Params$Resource$Projects$Locations$Conversations$Analyses$List, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListAnalysesResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListAnalysesResponse>): void;
    }
    export interface Params$Resource$Projects$Locations$Conversations$Analyses$Create extends StandardParameters {
        /**
         * Required. The parent resource of the analysis.
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudContactcenterinsightsV1Analysis;
    }
    export interface Params$Resource$Projects$Locations$Conversations$Analyses$Delete extends StandardParameters {
        /**
         * Required. The name of the analysis to delete.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Conversations$Analyses$Get extends StandardParameters {
        /**
         * Required. The name of the analysis to get.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Conversations$Analyses$List extends StandardParameters {
        /**
         * A filter to reduce results to a specific subset. Useful for querying conversations with specific properties.
         */
        filter?: string;
        /**
         * The maximum number of analyses to return in the response. If this value is zero, the service will select a default size. A call might return fewer objects than requested. A non-empty `next_page_token` in the response indicates that more data is available.
         */
        pageSize?: number;
        /**
         * The value returned by the last `ListAnalysesResponse`; indicates that this is a continuation of a prior `ListAnalyses` call and the system should return the next page of data.
         */
        pageToken?: string;
        /**
         * Required. The parent resource of the analyses.
         */
        parent?: string;
    }
    export class Resource$Projects$Locations$Conversations$Assessments {
        context: APIRequestContext;
        notes: Resource$Projects$Locations$Conversations$Assessments$Notes;
        constructor(context: APIRequestContext);
        /**
         * Appeal an Assessment.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.conversations.assessments.appeal(
         *       {
         *         // Required. The name of the assessment to appeal.
         *         name: 'projects/my-project/locations/my-location/conversations/my-conversation/assessments/my-assessment',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {}
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "agentInfo": {},
         *   //   "createTime": "my_createTime",
         *   //   "name": "my_name",
         *   //   "state": "my_state",
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        appeal(params: Params$Resource$Projects$Locations$Conversations$Assessments$Appeal, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        appeal(params?: Params$Resource$Projects$Locations$Conversations$Assessments$Appeal, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1Assessment>>;
        appeal(params: Params$Resource$Projects$Locations$Conversations$Assessments$Appeal, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        appeal(params: Params$Resource$Projects$Locations$Conversations$Assessments$Appeal, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Assessment>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Assessment>): void;
        appeal(params: Params$Resource$Projects$Locations$Conversations$Assessments$Appeal, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Assessment>): void;
        appeal(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Assessment>): void;
        /**
         * Create Assessment.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.conversations.assessments.create(
         *       {
         *         // Required. The parent resource of the assessment.
         *         parent:
         *           'projects/my-project/locations/my-location/conversations/my-conversation',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "agentInfo": {},
         *           //   "createTime": "my_createTime",
         *           //   "name": "my_name",
         *           //   "state": "my_state",
         *           //   "updateTime": "my_updateTime"
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "agentInfo": {},
         *   //   "createTime": "my_createTime",
         *   //   "name": "my_name",
         *   //   "state": "my_state",
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Projects$Locations$Conversations$Assessments$Create, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        create(params?: Params$Resource$Projects$Locations$Conversations$Assessments$Create, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1Assessment>>;
        create(params: Params$Resource$Projects$Locations$Conversations$Assessments$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Projects$Locations$Conversations$Assessments$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Assessment>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Assessment>): void;
        create(params: Params$Resource$Projects$Locations$Conversations$Assessments$Create, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Assessment>): void;
        create(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Assessment>): void;
        /**
         * Delete an Assessment.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.conversations.assessments.delete(
         *       {
         *         // Optional. If set to true, all of this assessment's notes will also be deleted. Otherwise, the request will only succeed if it has no notes.
         *         force: 'placeholder-value',
         *         // Required. The name of the assessment to delete.
         *         name: 'projects/my-project/locations/my-location/conversations/my-conversation/assessments/my-assessment',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {}
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Projects$Locations$Conversations$Assessments$Delete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        delete(params?: Params$Resource$Projects$Locations$Conversations$Assessments$Delete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleProtobufEmpty>>;
        delete(params: Params$Resource$Projects$Locations$Conversations$Assessments$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Projects$Locations$Conversations$Assessments$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleProtobufEmpty>, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(params: Params$Resource$Projects$Locations$Conversations$Assessments$Delete, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        /**
         * Finalize an Assessment.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.conversations.assessments.finalize(
         *       {
         *         // Required. The name of the assessment to finalize.
         *         name: 'projects/my-project/locations/my-location/conversations/my-conversation/assessments/my-assessment',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {}
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "agentInfo": {},
         *   //   "createTime": "my_createTime",
         *   //   "name": "my_name",
         *   //   "state": "my_state",
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        finalize(params: Params$Resource$Projects$Locations$Conversations$Assessments$Finalize, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        finalize(params?: Params$Resource$Projects$Locations$Conversations$Assessments$Finalize, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1Assessment>>;
        finalize(params: Params$Resource$Projects$Locations$Conversations$Assessments$Finalize, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        finalize(params: Params$Resource$Projects$Locations$Conversations$Assessments$Finalize, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Assessment>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Assessment>): void;
        finalize(params: Params$Resource$Projects$Locations$Conversations$Assessments$Finalize, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Assessment>): void;
        finalize(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Assessment>): void;
        /**
         * Get Assessment.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.conversations.assessments.get(
         *       {
         *         // Required. The name of the assessment to get.
         *         name: 'projects/my-project/locations/my-location/conversations/my-conversation/assessments/my-assessment',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "agentInfo": {},
         *   //   "createTime": "my_createTime",
         *   //   "name": "my_name",
         *   //   "state": "my_state",
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Locations$Conversations$Assessments$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Locations$Conversations$Assessments$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1Assessment>>;
        get(params: Params$Resource$Projects$Locations$Conversations$Assessments$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Locations$Conversations$Assessments$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Assessment>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Assessment>): void;
        get(params: Params$Resource$Projects$Locations$Conversations$Assessments$Get, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Assessment>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Assessment>): void;
        /**
         * List Assessments.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.conversations.assessments.list(
         *       {
         *         // Optional. A filter to reduce results to a specific subset. Supported filters include: * `state` - The state of the assessment * `agent_info.agent_id` - The ID of the agent the assessment is for
         *         filter: 'placeholder-value',
         *         // The maximum number of assessments to list. If zero, the service will select a default size. A call may return fewer objects than requested. A non-empty `next_page_token` in the response indicates that more data is available.
         *         pageSize: 'placeholder-value',
         *         // Optional. The value returned by the last `ListAssessmentRulesResponse`; indicates that this is a continuation of a prior `ListAssessmentRules` call and the system should return the next page of data.
         *         pageToken: 'placeholder-value',
         *         // Required. The parent resource of the assessments. To list all assessments in a location, substitute the conversation ID with a '-' character.
         *         parent:
         *           'projects/my-project/locations/my-location/conversations/my-conversation',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "assessments": [],
         *   //   "nextPageToken": "my_nextPageToken"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Locations$Conversations$Assessments$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Locations$Conversations$Assessments$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1ListAssessmentsResponse>>;
        list(params: Params$Resource$Projects$Locations$Conversations$Assessments$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Locations$Conversations$Assessments$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListAssessmentsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListAssessmentsResponse>): void;
        list(params: Params$Resource$Projects$Locations$Conversations$Assessments$List, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListAssessmentsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListAssessmentsResponse>): void;
        /**
         * Publish an Assessment.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.conversations.assessments.publish(
         *       {
         *         // Required. The name of the assessment to publish.
         *         name: 'projects/my-project/locations/my-location/conversations/my-conversation/assessments/my-assessment',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {}
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "agentInfo": {},
         *   //   "createTime": "my_createTime",
         *   //   "name": "my_name",
         *   //   "state": "my_state",
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        publish(params: Params$Resource$Projects$Locations$Conversations$Assessments$Publish, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        publish(params?: Params$Resource$Projects$Locations$Conversations$Assessments$Publish, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1Assessment>>;
        publish(params: Params$Resource$Projects$Locations$Conversations$Assessments$Publish, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        publish(params: Params$Resource$Projects$Locations$Conversations$Assessments$Publish, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Assessment>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Assessment>): void;
        publish(params: Params$Resource$Projects$Locations$Conversations$Assessments$Publish, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Assessment>): void;
        publish(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Assessment>): void;
    }
    export interface Params$Resource$Projects$Locations$Conversations$Assessments$Appeal extends StandardParameters {
        /**
         * Required. The name of the assessment to appeal.
         */
        name?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudContactcenterinsightsV1AppealAssessmentRequest;
    }
    export interface Params$Resource$Projects$Locations$Conversations$Assessments$Create extends StandardParameters {
        /**
         * Required. The parent resource of the assessment.
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudContactcenterinsightsV1Assessment;
    }
    export interface Params$Resource$Projects$Locations$Conversations$Assessments$Delete extends StandardParameters {
        /**
         * Optional. If set to true, all of this assessment's notes will also be deleted. Otherwise, the request will only succeed if it has no notes.
         */
        force?: boolean;
        /**
         * Required. The name of the assessment to delete.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Conversations$Assessments$Finalize extends StandardParameters {
        /**
         * Required. The name of the assessment to finalize.
         */
        name?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudContactcenterinsightsV1FinalizeAssessmentRequest;
    }
    export interface Params$Resource$Projects$Locations$Conversations$Assessments$Get extends StandardParameters {
        /**
         * Required. The name of the assessment to get.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Conversations$Assessments$List extends StandardParameters {
        /**
         * Optional. A filter to reduce results to a specific subset. Supported filters include: * `state` - The state of the assessment * `agent_info.agent_id` - The ID of the agent the assessment is for
         */
        filter?: string;
        /**
         * The maximum number of assessments to list. If zero, the service will select a default size. A call may return fewer objects than requested. A non-empty `next_page_token` in the response indicates that more data is available.
         */
        pageSize?: number;
        /**
         * Optional. The value returned by the last `ListAssessmentRulesResponse`; indicates that this is a continuation of a prior `ListAssessmentRules` call and the system should return the next page of data.
         */
        pageToken?: string;
        /**
         * Required. The parent resource of the assessments. To list all assessments in a location, substitute the conversation ID with a '-' character.
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Locations$Conversations$Assessments$Publish extends StandardParameters {
        /**
         * Required. The name of the assessment to publish.
         */
        name?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudContactcenterinsightsV1PublishAssessmentRequest;
    }
    export class Resource$Projects$Locations$Conversations$Assessments$Notes {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * Create Note.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.conversations.assessments.notes.create(
         *       {
         *         // Required. The parent resource of the note.
         *         parent:
         *           'projects/my-project/locations/my-location/conversations/my-conversation/assessments/my-assessment',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "assessmentNote": {},
         *           //   "content": "my_content",
         *           //   "conversationTurnNote": {},
         *           //   "createTime": "my_createTime",
         *           //   "name": "my_name",
         *           //   "noteCreator": {},
         *           //   "qaQuestionNote": {},
         *           //   "updateTime": "my_updateTime"
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "assessmentNote": {},
         *   //   "content": "my_content",
         *   //   "conversationTurnNote": {},
         *   //   "createTime": "my_createTime",
         *   //   "name": "my_name",
         *   //   "noteCreator": {},
         *   //   "qaQuestionNote": {},
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Projects$Locations$Conversations$Assessments$Notes$Create, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        create(params?: Params$Resource$Projects$Locations$Conversations$Assessments$Notes$Create, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1Note>>;
        create(params: Params$Resource$Projects$Locations$Conversations$Assessments$Notes$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Projects$Locations$Conversations$Assessments$Notes$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Note>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Note>): void;
        create(params: Params$Resource$Projects$Locations$Conversations$Assessments$Notes$Create, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Note>): void;
        create(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Note>): void;
        /**
         * Deletes a Note.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.conversations.assessments.notes.delete(
         *       {
         *         // Required. The name of the note to delete.
         *         name: 'projects/my-project/locations/my-location/conversations/my-conversation/assessments/my-assessment/notes/my-note',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {}
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Projects$Locations$Conversations$Assessments$Notes$Delete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        delete(params?: Params$Resource$Projects$Locations$Conversations$Assessments$Notes$Delete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleProtobufEmpty>>;
        delete(params: Params$Resource$Projects$Locations$Conversations$Assessments$Notes$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Projects$Locations$Conversations$Assessments$Notes$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleProtobufEmpty>, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(params: Params$Resource$Projects$Locations$Conversations$Assessments$Notes$Delete, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        /**
         * List Notes.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.conversations.assessments.notes.list(
         *       {
         *         // Optional. The maximum number of notes to return in the response. If zero the service will select a default size. A call might return fewer objects than requested. A non-empty `next_page_token` in the response indicates that more data is available.
         *         pageSize: 'placeholder-value',
         *         // Optional. The value returned by the last `ListNotesResponse`. This value indicates that this is a continuation of a prior `ListNotes` call and that the system should return the next page of data.
         *         pageToken: 'placeholder-value',
         *         // Required. The parent resource of the notes.
         *         parent:
         *           'projects/my-project/locations/my-location/conversations/my-conversation/assessments/my-assessment',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "nextPageToken": "my_nextPageToken",
         *   //   "notes": []
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Locations$Conversations$Assessments$Notes$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Locations$Conversations$Assessments$Notes$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1ListNotesResponse>>;
        list(params: Params$Resource$Projects$Locations$Conversations$Assessments$Notes$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Locations$Conversations$Assessments$Notes$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListNotesResponse>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListNotesResponse>): void;
        list(params: Params$Resource$Projects$Locations$Conversations$Assessments$Notes$List, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListNotesResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListNotesResponse>): void;
        /**
         * Update Note.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.conversations.assessments.notes.patch(
         *       {
         *         // Identifier. The resource name of the note. Format: projects/{project\}/locations/{location\}/conversations/{conversation\}/assessments/{assessment\}/notes/{note\}
         *         name: 'projects/my-project/locations/my-location/conversations/my-conversation/assessments/my-assessment/notes/my-note',
         *         // Optional. The list of fields to be updated. If the update_mask is empty, all updateable fields will be updated. Acceptable fields include: * `content`
         *         updateMask: 'placeholder-value',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "assessmentNote": {},
         *           //   "content": "my_content",
         *           //   "conversationTurnNote": {},
         *           //   "createTime": "my_createTime",
         *           //   "name": "my_name",
         *           //   "noteCreator": {},
         *           //   "qaQuestionNote": {},
         *           //   "updateTime": "my_updateTime"
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "assessmentNote": {},
         *   //   "content": "my_content",
         *   //   "conversationTurnNote": {},
         *   //   "createTime": "my_createTime",
         *   //   "name": "my_name",
         *   //   "noteCreator": {},
         *   //   "qaQuestionNote": {},
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        patch(params: Params$Resource$Projects$Locations$Conversations$Assessments$Notes$Patch, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        patch(params?: Params$Resource$Projects$Locations$Conversations$Assessments$Notes$Patch, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1Note>>;
        patch(params: Params$Resource$Projects$Locations$Conversations$Assessments$Notes$Patch, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        patch(params: Params$Resource$Projects$Locations$Conversations$Assessments$Notes$Patch, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Note>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Note>): void;
        patch(params: Params$Resource$Projects$Locations$Conversations$Assessments$Notes$Patch, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Note>): void;
        patch(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Note>): void;
    }
    export interface Params$Resource$Projects$Locations$Conversations$Assessments$Notes$Create extends StandardParameters {
        /**
         * Required. The parent resource of the note.
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudContactcenterinsightsV1Note;
    }
    export interface Params$Resource$Projects$Locations$Conversations$Assessments$Notes$Delete extends StandardParameters {
        /**
         * Required. The name of the note to delete.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Conversations$Assessments$Notes$List extends StandardParameters {
        /**
         * Optional. The maximum number of notes to return in the response. If zero the service will select a default size. A call might return fewer objects than requested. A non-empty `next_page_token` in the response indicates that more data is available.
         */
        pageSize?: number;
        /**
         * Optional. The value returned by the last `ListNotesResponse`. This value indicates that this is a continuation of a prior `ListNotes` call and that the system should return the next page of data.
         */
        pageToken?: string;
        /**
         * Required. The parent resource of the notes.
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Locations$Conversations$Assessments$Notes$Patch extends StandardParameters {
        /**
         * Identifier. The resource name of the note. Format: projects/{project\}/locations/{location\}/conversations/{conversation\}/assessments/{assessment\}/notes/{note\}
         */
        name?: string;
        /**
         * Optional. The list of fields to be updated. If the update_mask is empty, all updateable fields will be updated. Acceptable fields include: * `content`
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudContactcenterinsightsV1Note;
    }
    export class Resource$Projects$Locations$Conversations$Feedbacklabels {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * Create feedback label.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.conversations.feedbackLabels.create(
         *       {
         *         // Optional. The ID of the feedback label to create. If one is not specified it will be generated by the server.
         *         feedbackLabelId: 'placeholder-value',
         *         // Required. The parent resource of the feedback label.
         *         parent:
         *           'projects/my-project/locations/my-location/conversations/my-conversation',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "createTime": "my_createTime",
         *           //   "label": "my_label",
         *           //   "labeledResource": "my_labeledResource",
         *           //   "name": "my_name",
         *           //   "qaAnswerLabel": {},
         *           //   "updateTime": "my_updateTime"
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "createTime": "my_createTime",
         *   //   "label": "my_label",
         *   //   "labeledResource": "my_labeledResource",
         *   //   "name": "my_name",
         *   //   "qaAnswerLabel": {},
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Projects$Locations$Conversations$Feedbacklabels$Create, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        create(params?: Params$Resource$Projects$Locations$Conversations$Feedbacklabels$Create, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1FeedbackLabel>>;
        create(params: Params$Resource$Projects$Locations$Conversations$Feedbacklabels$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Projects$Locations$Conversations$Feedbacklabels$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1FeedbackLabel>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1FeedbackLabel>): void;
        create(params: Params$Resource$Projects$Locations$Conversations$Feedbacklabels$Create, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1FeedbackLabel>): void;
        create(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1FeedbackLabel>): void;
        /**
         * Delete feedback label.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.conversations.feedbackLabels.delete(
         *       {
         *         // Required. The name of the feedback label to delete.
         *         name: 'projects/my-project/locations/my-location/conversations/my-conversation/feedbackLabels/my-feedbackLabel',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {}
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Projects$Locations$Conversations$Feedbacklabels$Delete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        delete(params?: Params$Resource$Projects$Locations$Conversations$Feedbacklabels$Delete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleProtobufEmpty>>;
        delete(params: Params$Resource$Projects$Locations$Conversations$Feedbacklabels$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Projects$Locations$Conversations$Feedbacklabels$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleProtobufEmpty>, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(params: Params$Resource$Projects$Locations$Conversations$Feedbacklabels$Delete, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        /**
         * Get feedback label.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.conversations.feedbackLabels.get(
         *       {
         *         // Required. The name of the feedback label to get.
         *         name: 'projects/my-project/locations/my-location/conversations/my-conversation/feedbackLabels/my-feedbackLabel',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "createTime": "my_createTime",
         *   //   "label": "my_label",
         *   //   "labeledResource": "my_labeledResource",
         *   //   "name": "my_name",
         *   //   "qaAnswerLabel": {},
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Locations$Conversations$Feedbacklabels$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Locations$Conversations$Feedbacklabels$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1FeedbackLabel>>;
        get(params: Params$Resource$Projects$Locations$Conversations$Feedbacklabels$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Locations$Conversations$Feedbacklabels$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1FeedbackLabel>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1FeedbackLabel>): void;
        get(params: Params$Resource$Projects$Locations$Conversations$Feedbacklabels$Get, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1FeedbackLabel>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1FeedbackLabel>): void;
        /**
         * List feedback labels.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.conversations.feedbackLabels.list(
         *       {
         *         // Optional. A filter to reduce results to a specific subset. Supports disjunctions (OR) and conjunctions (AND). Automatically sorts by conversation ID. To sort by all feedback labels in a project see ListAllFeedbackLabels. Supported fields: * `issue_model_id` * `qa_question_id` * `qa_scorecard_id` * `min_create_time` * `max_create_time` * `min_update_time` * `max_update_time` * `feedback_label_type`: QUALITY_AI, TOPIC_MODELING
         *         filter: 'placeholder-value',
         *         // Optional. The maximum number of feedback labels to return in the response. A valid page size ranges from 0 to 100,000 inclusive. If the page size is zero or unspecified, a default page size of 100 will be chosen. Note that a call might return fewer results than the requested page size.
         *         pageSize: 'placeholder-value',
         *         // Optional. The value returned by the last `ListFeedbackLabelsResponse`. This value indicates that this is a continuation of a prior `ListFeedbackLabels` call and that the system should return the next page of data.
         *         pageToken: 'placeholder-value',
         *         // Required. The parent resource of the feedback labels.
         *         parent:
         *           'projects/my-project/locations/my-location/conversations/my-conversation',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "feedbackLabels": [],
         *   //   "nextPageToken": "my_nextPageToken"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Locations$Conversations$Feedbacklabels$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Locations$Conversations$Feedbacklabels$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1ListFeedbackLabelsResponse>>;
        list(params: Params$Resource$Projects$Locations$Conversations$Feedbacklabels$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Locations$Conversations$Feedbacklabels$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListFeedbackLabelsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListFeedbackLabelsResponse>): void;
        list(params: Params$Resource$Projects$Locations$Conversations$Feedbacklabels$List, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListFeedbackLabelsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListFeedbackLabelsResponse>): void;
        /**
         * Update feedback label.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.conversations.feedbackLabels.patch(
         *       {
         *         // Immutable. Resource name of the FeedbackLabel. Format: projects/{project\}/locations/{location\}/conversations/{conversation\}/feedbackLabels/{feedback_label\}
         *         name: 'projects/my-project/locations/my-location/conversations/my-conversation/feedbackLabels/my-feedbackLabel',
         *         // Required. The list of fields to be updated.
         *         updateMask: 'placeholder-value',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "createTime": "my_createTime",
         *           //   "label": "my_label",
         *           //   "labeledResource": "my_labeledResource",
         *           //   "name": "my_name",
         *           //   "qaAnswerLabel": {},
         *           //   "updateTime": "my_updateTime"
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "createTime": "my_createTime",
         *   //   "label": "my_label",
         *   //   "labeledResource": "my_labeledResource",
         *   //   "name": "my_name",
         *   //   "qaAnswerLabel": {},
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        patch(params: Params$Resource$Projects$Locations$Conversations$Feedbacklabels$Patch, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        patch(params?: Params$Resource$Projects$Locations$Conversations$Feedbacklabels$Patch, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1FeedbackLabel>>;
        patch(params: Params$Resource$Projects$Locations$Conversations$Feedbacklabels$Patch, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        patch(params: Params$Resource$Projects$Locations$Conversations$Feedbacklabels$Patch, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1FeedbackLabel>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1FeedbackLabel>): void;
        patch(params: Params$Resource$Projects$Locations$Conversations$Feedbacklabels$Patch, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1FeedbackLabel>): void;
        patch(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1FeedbackLabel>): void;
    }
    export interface Params$Resource$Projects$Locations$Conversations$Feedbacklabels$Create extends StandardParameters {
        /**
         * Optional. The ID of the feedback label to create. If one is not specified it will be generated by the server.
         */
        feedbackLabelId?: string;
        /**
         * Required. The parent resource of the feedback label.
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudContactcenterinsightsV1FeedbackLabel;
    }
    export interface Params$Resource$Projects$Locations$Conversations$Feedbacklabels$Delete extends StandardParameters {
        /**
         * Required. The name of the feedback label to delete.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Conversations$Feedbacklabels$Get extends StandardParameters {
        /**
         * Required. The name of the feedback label to get.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Conversations$Feedbacklabels$List extends StandardParameters {
        /**
         * Optional. A filter to reduce results to a specific subset. Supports disjunctions (OR) and conjunctions (AND). Automatically sorts by conversation ID. To sort by all feedback labels in a project see ListAllFeedbackLabels. Supported fields: * `issue_model_id` * `qa_question_id` * `qa_scorecard_id` * `min_create_time` * `max_create_time` * `min_update_time` * `max_update_time` * `feedback_label_type`: QUALITY_AI, TOPIC_MODELING
         */
        filter?: string;
        /**
         * Optional. The maximum number of feedback labels to return in the response. A valid page size ranges from 0 to 100,000 inclusive. If the page size is zero or unspecified, a default page size of 100 will be chosen. Note that a call might return fewer results than the requested page size.
         */
        pageSize?: number;
        /**
         * Optional. The value returned by the last `ListFeedbackLabelsResponse`. This value indicates that this is a continuation of a prior `ListFeedbackLabels` call and that the system should return the next page of data.
         */
        pageToken?: string;
        /**
         * Required. The parent resource of the feedback labels.
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Locations$Conversations$Feedbacklabels$Patch extends StandardParameters {
        /**
         * Immutable. Resource name of the FeedbackLabel. Format: projects/{project\}/locations/{location\}/conversations/{conversation\}/feedbackLabels/{feedback_label\}
         */
        name?: string;
        /**
         * Required. The list of fields to be updated.
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudContactcenterinsightsV1FeedbackLabel;
    }
    export class Resource$Projects$Locations$Conversations$Segments {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * Analyzes multiple conversations in a single request.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.conversations.segments.bulkAnalyze(
         *       {
         *         // Required. The parent resource to create analyses in.
         *         parent:
         *           'projects/my-project/locations/my-location/conversations/my-conversation',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "analysisPercentage": {},
         *           //   "annotatorSelector": {},
         *           //   "filter": "my_filter",
         *           //   "parent": "my_parent"
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        bulkAnalyze(params: Params$Resource$Projects$Locations$Conversations$Segments$Bulkanalyze, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        bulkAnalyze(params?: Params$Resource$Projects$Locations$Conversations$Segments$Bulkanalyze, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        bulkAnalyze(params: Params$Resource$Projects$Locations$Conversations$Segments$Bulkanalyze, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        bulkAnalyze(params: Params$Resource$Projects$Locations$Conversations$Segments$Bulkanalyze, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        bulkAnalyze(params: Params$Resource$Projects$Locations$Conversations$Segments$Bulkanalyze, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        bulkAnalyze(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
    }
    export interface Params$Resource$Projects$Locations$Conversations$Segments$Bulkanalyze extends StandardParameters {
        /**
         * Required. The parent resource to create analyses in.
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudContactcenterinsightsV1BulkAnalyzeConversationsRequest;
    }
    export class Resource$Projects$Locations$Datasets {
        context: APIRequestContext;
        conversations: Resource$Projects$Locations$Datasets$Conversations;
        insightsdata: Resource$Projects$Locations$Datasets$Insightsdata;
        constructor(context: APIRequestContext);
        /**
         * Delete feedback labels in bulk using a filter.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.datasets.bulkDeleteFeedbackLabels(
         *       {
         *         // Required. The parent resource for new feedback labels.
         *         parent: 'projects/my-project/locations/my-location/datasets/my-dataset',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "filter": "my_filter",
         *           //   "parent": "my_parent"
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        bulkDeleteFeedbackLabels(params: Params$Resource$Projects$Locations$Datasets$Bulkdeletefeedbacklabels, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        bulkDeleteFeedbackLabels(params?: Params$Resource$Projects$Locations$Datasets$Bulkdeletefeedbacklabels, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        bulkDeleteFeedbackLabels(params: Params$Resource$Projects$Locations$Datasets$Bulkdeletefeedbacklabels, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        bulkDeleteFeedbackLabels(params: Params$Resource$Projects$Locations$Datasets$Bulkdeletefeedbacklabels, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        bulkDeleteFeedbackLabels(params: Params$Resource$Projects$Locations$Datasets$Bulkdeletefeedbacklabels, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        bulkDeleteFeedbackLabels(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * Download feedback labels in bulk from an external source. Currently supports exporting Quality AI example conversations with transcripts and question bodies.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.datasets.bulkDownloadFeedbackLabels(
         *       {
         *         // Required. The parent resource for new feedback labels.
         *         parent: 'projects/my-project/locations/my-location/datasets/my-dataset',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "conversationFilter": "my_conversationFilter",
         *           //   "feedbackLabelType": "my_feedbackLabelType",
         *           //   "filter": "my_filter",
         *           //   "gcsDestination": {},
         *           //   "maxDownloadCount": 0,
         *           //   "parent": "my_parent",
         *           //   "sheetsDestination": {},
         *           //   "templateQaScorecardId": []
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        bulkDownloadFeedbackLabels(params: Params$Resource$Projects$Locations$Datasets$Bulkdownloadfeedbacklabels, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        bulkDownloadFeedbackLabels(params?: Params$Resource$Projects$Locations$Datasets$Bulkdownloadfeedbacklabels, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        bulkDownloadFeedbackLabels(params: Params$Resource$Projects$Locations$Datasets$Bulkdownloadfeedbacklabels, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        bulkDownloadFeedbackLabels(params: Params$Resource$Projects$Locations$Datasets$Bulkdownloadfeedbacklabels, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        bulkDownloadFeedbackLabels(params: Params$Resource$Projects$Locations$Datasets$Bulkdownloadfeedbacklabels, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        bulkDownloadFeedbackLabels(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * Upload feedback labels from an external source in bulk. Currently supports labeling Quality AI example conversations.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.datasets.bulkUploadFeedbackLabels(
         *       {
         *         // Required. The parent resource for new feedback labels.
         *         parent: 'projects/my-project/locations/my-location/datasets/my-dataset',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "gcsSource": {},
         *           //   "sheetsSource": {},
         *           //   "validateOnly": false
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        bulkUploadFeedbackLabels(params: Params$Resource$Projects$Locations$Datasets$Bulkuploadfeedbacklabels, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        bulkUploadFeedbackLabels(params?: Params$Resource$Projects$Locations$Datasets$Bulkuploadfeedbacklabels, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        bulkUploadFeedbackLabels(params: Params$Resource$Projects$Locations$Datasets$Bulkuploadfeedbacklabels, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        bulkUploadFeedbackLabels(params: Params$Resource$Projects$Locations$Datasets$Bulkuploadfeedbacklabels, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        bulkUploadFeedbackLabels(params: Params$Resource$Projects$Locations$Datasets$Bulkuploadfeedbacklabels, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        bulkUploadFeedbackLabels(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * Creates a dataset.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await contactcenterinsights.projects.locations.datasets.create({
         *     // Optional. The ID to use for the dataset.
         *     datasetId: 'placeholder-value',
         *     // Required. The parent resource of the dataset.
         *     parent: 'projects/my-project/locations/my-location',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "createTime": "my_createTime",
         *       //   "description": "my_description",
         *       //   "displayName": "my_displayName",
         *       //   "name": "my_name",
         *       //   "ttl": "my_ttl",
         *       //   "type": "my_type",
         *       //   "updateTime": "my_updateTime"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "createTime": "my_createTime",
         *   //   "description": "my_description",
         *   //   "displayName": "my_displayName",
         *   //   "name": "my_name",
         *   //   "ttl": "my_ttl",
         *   //   "type": "my_type",
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Projects$Locations$Datasets$Create, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        create(params?: Params$Resource$Projects$Locations$Datasets$Create, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1Dataset>>;
        create(params: Params$Resource$Projects$Locations$Datasets$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Projects$Locations$Datasets$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Dataset>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Dataset>): void;
        create(params: Params$Resource$Projects$Locations$Datasets$Create, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Dataset>): void;
        create(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Dataset>): void;
        /**
         * Delete a dataset.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await contactcenterinsights.projects.locations.datasets.delete({
         *     // Required. The name of the dataset to delete.
         *     name: 'projects/my-project/locations/my-location/datasets/my-dataset',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Projects$Locations$Datasets$Delete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        delete(params?: Params$Resource$Projects$Locations$Datasets$Delete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        delete(params: Params$Resource$Projects$Locations$Datasets$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Projects$Locations$Datasets$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        delete(params: Params$Resource$Projects$Locations$Datasets$Delete, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * Gets a dataset.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await contactcenterinsights.projects.locations.datasets.get({
         *     // Required. The name of the dataset to get.
         *     name: 'projects/my-project/locations/my-location/datasets/my-dataset',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "createTime": "my_createTime",
         *   //   "description": "my_description",
         *   //   "displayName": "my_displayName",
         *   //   "name": "my_name",
         *   //   "ttl": "my_ttl",
         *   //   "type": "my_type",
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Locations$Datasets$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Locations$Datasets$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1Dataset>>;
        get(params: Params$Resource$Projects$Locations$Datasets$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Locations$Datasets$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Dataset>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Dataset>): void;
        get(params: Params$Resource$Projects$Locations$Datasets$Get, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Dataset>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Dataset>): void;
        /**
         * List datasets matching the input.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await contactcenterinsights.projects.locations.datasets.list({
         *     // Optional. A filter to reduce results to a specific subset. Useful for querying datasets with specific properties. Supported fields include, for Q2 though we only support list by project: - `type` - `description` - `project_number`
         *     filter: 'placeholder-value',
         *     // Optional. The maximum number of datasets to return in the response. If this value is zero, the service will select a default size. A call might return fewer objects than requested. A non-empty `next_page_token` in the response indicates that more data is available.
         *     pageSize: 'placeholder-value',
         *     // Optional. The value returned by the last `ListDatasetsResponse`; indicates that this is a continuation of a prior `ListDatasets` call and the system should return the next page of data.
         *     pageToken: 'placeholder-value',
         *     // Required. The parent resource of the dataset.
         *     parent: 'projects/my-project/locations/my-location',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "datasets": [],
         *   //   "nextPageToken": "my_nextPageToken"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Locations$Datasets$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Locations$Datasets$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1ListDatasetsResponse>>;
        list(params: Params$Resource$Projects$Locations$Datasets$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Locations$Datasets$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListDatasetsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListDatasetsResponse>): void;
        list(params: Params$Resource$Projects$Locations$Datasets$List, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListDatasetsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListDatasetsResponse>): void;
        /**
         * List all feedback labels by project number.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.datasets.listAllFeedbackLabels(
         *       {
         *         // Optional. A filter to reduce results to a specific subset in the entire project. Supports disjunctions (OR) and conjunctions (AND). Supported fields: * `issue_model_id` * `qa_question_id` * `min_create_time` * `max_create_time` * `min_update_time` * `max_update_time` * `feedback_label_type`: QUALITY_AI, TOPIC_MODELING
         *         filter: 'placeholder-value',
         *         // Optional. The maximum number of feedback labels to return in the response. A valid page size ranges from 0 to 100,000 inclusive. If the page size is zero or unspecified, a default page size of 100 will be chosen. Note that a call might return fewer results than the requested page size.
         *         pageSize: 'placeholder-value',
         *         // Optional. The value returned by the last `ListAllFeedbackLabelsResponse`. This value indicates that this is a continuation of a prior `ListAllFeedbackLabels` call and that the system should return the next page of data.
         *         pageToken: 'placeholder-value',
         *         // Required. The parent resource of all feedback labels per project.
         *         parent: 'projects/my-project/locations/my-location/datasets/my-dataset',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "feedbackLabels": [],
         *   //   "nextPageToken": "my_nextPageToken"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        listAllFeedbackLabels(params: Params$Resource$Projects$Locations$Datasets$Listallfeedbacklabels, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        listAllFeedbackLabels(params?: Params$Resource$Projects$Locations$Datasets$Listallfeedbacklabels, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1ListAllFeedbackLabelsResponse>>;
        listAllFeedbackLabels(params: Params$Resource$Projects$Locations$Datasets$Listallfeedbacklabels, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        listAllFeedbackLabels(params: Params$Resource$Projects$Locations$Datasets$Listallfeedbacklabels, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListAllFeedbackLabelsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListAllFeedbackLabelsResponse>): void;
        listAllFeedbackLabels(params: Params$Resource$Projects$Locations$Datasets$Listallfeedbacklabels, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListAllFeedbackLabelsResponse>): void;
        listAllFeedbackLabels(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1ListAllFeedbackLabelsResponse>): void;
        /**
         * Updates a dataset.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await contactcenterinsights.projects.locations.datasets.patch({
         *     // Immutable. Identifier. Resource name of the dataset. Format: projects/{project\}/locations/{location\}/datasets/{dataset\}
         *     name: 'projects/my-project/locations/my-location/datasets/my-dataset',
         *     // Optional. The list of fields to update.
         *     updateMask: 'placeholder-value',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "createTime": "my_createTime",
         *       //   "description": "my_description",
         *       //   "displayName": "my_displayName",
         *       //   "name": "my_name",
         *       //   "ttl": "my_ttl",
         *       //   "type": "my_type",
         *       //   "updateTime": "my_updateTime"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "createTime": "my_createTime",
         *   //   "description": "my_description",
         *   //   "displayName": "my_displayName",
         *   //   "name": "my_name",
         *   //   "ttl": "my_ttl",
         *   //   "type": "my_type",
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        patch(params: Params$Resource$Projects$Locations$Datasets$Patch, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        patch(params?: Params$Resource$Projects$Locations$Datasets$Patch, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1Dataset>>;
        patch(params: Params$Resource$Projects$Locations$Datasets$Patch, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        patch(params: Params$Resource$Projects$Locations$Datasets$Patch, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Dataset>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Dataset>): void;
        patch(params: Params$Resource$Projects$Locations$Datasets$Patch, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Dataset>): void;
        patch(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1Dataset>): void;
    }
    export interface Params$Resource$Projects$Locations$Datasets$Bulkdeletefeedbacklabels extends StandardParameters {
        /**
         * Required. The parent resource for new feedback labels.
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudContactcenterinsightsV1BulkDeleteFeedbackLabelsRequest;
    }
    export interface Params$Resource$Projects$Locations$Datasets$Bulkdownloadfeedbacklabels extends StandardParameters {
        /**
         * Required. The parent resource for new feedback labels.
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudContactcenterinsightsV1BulkDownloadFeedbackLabelsRequest;
    }
    export interface Params$Resource$Projects$Locations$Datasets$Bulkuploadfeedbacklabels extends StandardParameters {
        /**
         * Required. The parent resource for new feedback labels.
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudContactcenterinsightsV1BulkUploadFeedbackLabelsRequest;
    }
    export interface Params$Resource$Projects$Locations$Datasets$Create extends StandardParameters {
        /**
         * Optional. The ID to use for the dataset.
         */
        datasetId?: string;
        /**
         * Required. The parent resource of the dataset.
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudContactcenterinsightsV1Dataset;
    }
    export interface Params$Resource$Projects$Locations$Datasets$Delete extends StandardParameters {
        /**
         * Required. The name of the dataset to delete.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Datasets$Get extends StandardParameters {
        /**
         * Required. The name of the dataset to get.
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Datasets$List extends StandardParameters {
        /**
         * Optional. A filter to reduce results to a specific subset. Useful for querying datasets with specific properties. Supported fields include, for Q2 though we only support list by project: - `type` - `description` - `project_number`
         */
        filter?: string;
        /**
         * Optional. The maximum number of datasets to return in the response. If this value is zero, the service will select a default size. A call might return fewer objects than requested. A non-empty `next_page_token` in the response indicates that more data is available.
         */
        pageSize?: number;
        /**
         * Optional. The value returned by the last `ListDatasetsResponse`; indicates that this is a continuation of a prior `ListDatasets` call and the system should return the next page of data.
         */
        pageToken?: string;
        /**
         * Required. The parent resource of the dataset.
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Locations$Datasets$Listallfeedbacklabels extends StandardParameters {
        /**
         * Optional. A filter to reduce results to a specific subset in the entire project. Supports disjunctions (OR) and conjunctions (AND). Supported fields: * `issue_model_id` * `qa_question_id` * `min_create_time` * `max_create_time` * `min_update_time` * `max_update_time` * `feedback_label_type`: QUALITY_AI, TOPIC_MODELING
         */
        filter?: string;
        /**
         * Optional. The maximum number of feedback labels to return in the response. A valid page size ranges from 0 to 100,000 inclusive. If the page size is zero or unspecified, a default page size of 100 will be chosen. Note that a call might return fewer results than the requested page size.
         */
        pageSize?: number;
        /**
         * Optional. The value returned by the last `ListAllFeedbackLabelsResponse`. This value indicates that this is a continuation of a prior `ListAllFeedbackLabels` call and that the system should return the next page of data.
         */
        pageToken?: string;
        /**
         * Required. The parent resource of all feedback labels per project.
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Locations$Datasets$Patch extends StandardParameters {
        /**
         * Immutable. Identifier. Resource name of the dataset. Format: projects/{project\}/locations/{location\}/datasets/{dataset\}
         */
        name?: string;
        /**
         * Optional. The list of fields to update.
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudContactcenterinsightsV1Dataset;
    }
    export class Resource$Projects$Locations$Datasets$Conversations {
        context: APIRequestContext;
        feedbackLabels: Resource$Projects$Locations$Datasets$Conversations$Feedbacklabels;
        constructor(context: APIRequestContext);
        /**
         * Deletes multiple conversations in a single request.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.datasets.conversations.bulkDelete(
         *       {
         *         // Required. The parent resource to delete conversations from. Format: projects/{project\}/locations/{location\}
         *         parent: 'projects/my-project/locations/my-location/datasets/my-dataset',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "filter": "my_filter",
         *           //   "force": false,
         *           //   "maxDeleteCount": 0,
         *           //   "parent": "my_parent"
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        bulkDelete(params: Params$Resource$Projects$Locations$Datasets$Conversations$Bulkdelete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        bulkDelete(params?: Params$Resource$Projects$Locations$Datasets$Conversations$Bulkdelete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        bulkDelete(params: Params$Resource$Projects$Locations$Datasets$Conversations$Bulkdelete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        bulkDelete(params: Params$Resource$Projects$Locations$Datasets$Conversations$Bulkdelete, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        bulkDelete(params: Params$Resource$Projects$Locations$Datasets$Conversations$Bulkdelete, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        bulkDelete(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * Gets conversation statistics.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.datasets.conversations.calculateStats(
         *       {
         *         // Required. The location of the conversations.
         *         location:
         *           'projects/my-project/locations/my-location/datasets/my-dataset',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "filter": "my_filter"
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "averageDuration": "my_averageDuration",
         *   //   "averageTurnCount": 0,
         *   //   "conversationCount": 0,
         *   //   "conversationCountTimeSeries": {},
         *   //   "customHighlighterMatches": {},
         *   //   "issueMatches": {},
         *   //   "issueMatchesStats": {},
         *   //   "smartHighlighterMatches": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        calculateStats(params: Params$Resource$Projects$Locations$Datasets$Conversations$Calculatestats, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        calculateStats(params?: Params$Resource$Projects$Locations$Datasets$Conversations$Calculatestats, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1CalculateStatsResponse>>;
        calculateStats(params: Params$Resource$Projects$Locations$Datasets$Conversations$Calculatestats, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        calculateStats(params: Params$Resource$Projects$Locations$Datasets$Conversations$Calculatestats, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1CalculateStatsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1CalculateStatsResponse>): void;
        calculateStats(params: Params$Resource$Projects$Locations$Datasets$Conversations$Calculatestats, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1CalculateStatsResponse>): void;
        calculateStats(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1CalculateStatsResponse>): void;
        /**
         * Deletes a conversation.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.datasets.conversations.delete(
         *       {
         *         // If set to true, all of this conversation's analyses will also be deleted. Otherwise, the request will only succeed if the conversation has no analyses.
         *         force: 'placeholder-value',
         *         // Required. The name of the conversation to delete.
         *         name: 'projects/my-project/locations/my-location/datasets/my-dataset/conversations/my-conversation',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {}
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Projects$Locations$Datasets$Conversations$Delete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        delete(params?: Params$Resource$Projects$Locations$Datasets$Conversations$Delete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleProtobufEmpty>>;
        delete(params: Params$Resource$Projects$Locations$Datasets$Conversations$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Projects$Locations$Datasets$Conversations$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleProtobufEmpty>, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(params: Params$Resource$Projects$Locations$Datasets$Conversations$Delete, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        /**
         * Gets the signed URI for the audio for the given conversation.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.datasets.conversations.generateSignedAudio(
         *       {
         *         // Required. The name of the conversation to sign.
         *         name: 'projects/my-project/locations/my-location/datasets/my-dataset/conversations/my-conversation',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "signedAudioUris": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        generateSignedAudio(params: Params$Resource$Projects$Locations$Datasets$Conversations$Generatesignedaudio, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        generateSignedAudio(params?: Params$Resource$Projects$Locations$Datasets$Conversations$Generatesignedaudio, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudContactcenterinsightsV1GenerateConversationSignedAudioResponse>>;
        generateSignedAudio(params: Params$Resource$Projects$Locations$Datasets$Conversations$Generatesignedaudio, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        generateSignedAudio(params: Params$Resource$Projects$Locations$Datasets$Conversations$Generatesignedaudio, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1GenerateConversationSignedAudioResponse>, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1GenerateConversationSignedAudioResponse>): void;
        generateSignedAudio(params: Params$Resource$Projects$Locations$Datasets$Conversations$Generatesignedaudio, callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1GenerateConversationSignedAudioResponse>): void;
        generateSignedAudio(callback: BodyResponseCallback<Schema$GoogleCloudContactcenterinsightsV1GenerateConversationSignedAudioResponse>): void;
        /**
         * Gets a conversation.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/contactcenterinsights.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const contactcenterinsights = google.contactcenterinsights('v1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/cloud-platform'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await contactcenterinsights.projects.locations.datasets.conversations.get({
         *       // Required. The name of the conversation to get.
         *       name: 'projects/my-project/locations/my-location/datasets/my-dataset/conversations/my-conversation',
         *       // The level of details of the conversation. Default is `FULL`.
         *       view: 'placeholder-value',
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "agentId": "my_agentId",
         *   //   "callMetadata": {},
         *   //   "correlationInfo": {},
         *   //   "createTime": "my_createTime",
         *   //   "dataSource": {},
         *   //   "dialogflowIntents": {},
         *   //   "duration": "my_duration",
         *   //   "expireTime": "my_expireTime",
         *   //   "labels": {},
         *   //   "languageCode": "my_languageCode",
         *   //   "latestAnalysis"