import { OAuth2Client, JWT, Compute, UserRefreshClient, BaseExternalAccountClient, GaxiosResponseWithHTTP2, GoogleConfigurable, MethodOptions, StreamMethodOptions, GlobalOptions, GoogleAuth, BodyResponseCallback, APIRequestContext } from 'googleapis-common';
import { Readable } from 'stream';
export declare namespace dialogflow_v2beta1 {
    export interface Options extends GlobalOptions {
        version: 'v2beta1';
    }
    interface StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient | BaseExternalAccountClient | GoogleAuth;
        /**
         * V1 error format.
         */
        '$.xgafv'?: string;
        /**
         * OAuth access token.
         */
        access_token?: string;
        /**
         * Data format for response.
         */
        alt?: string;
        /**
         * JSONP
         */
        callback?: string;
        /**
         * Selector specifying which fields to include in a partial response.
         */
        fields?: string;
        /**
         * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
         */
        key?: string;
        /**
         * OAuth 2.0 token for the current user.
         */
        oauth_token?: string;
        /**
         * Returns response with indentations and line breaks.
         */
        prettyPrint?: boolean;
        /**
         * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
         */
        quotaUser?: string;
        /**
         * Legacy upload protocol for media (e.g. "media", "multipart").
         */
        uploadType?: string;
        /**
         * Upload protocol for media (e.g. "raw", "multipart").
         */
        upload_protocol?: string;
    }
    /**
     * Dialogflow API
     *
     * Builds conversational interfaces (for example, chatbots, and voice-powered apps and devices).
     *
     * @example
     * ```js
     * const {google} = require('googleapis');
     * const dialogflow = google.dialogflow('v2beta1');
     * ```
     */
    export class Dialogflow {
        context: APIRequestContext;
        projects: Resource$Projects;
        constructor(options: GlobalOptions, google?: GoogleConfigurable);
    }
    export interface Schema$GoogleCloudDialogflowCxV3AdvancedSettings {
        audioExportGcsDestination?: Schema$GoogleCloudDialogflowCxV3GcsDestination;
        dtmfSettings?: Schema$GoogleCloudDialogflowCxV3AdvancedSettingsDtmfSettings;
        loggingSettings?: Schema$GoogleCloudDialogflowCxV3AdvancedSettingsLoggingSettings;
        speechSettings?: Schema$GoogleCloudDialogflowCxV3AdvancedSettingsSpeechSettings;
    }
    export interface Schema$GoogleCloudDialogflowCxV3AdvancedSettingsDtmfSettings {
        enabled?: boolean | null;
        endpointingTimeoutDuration?: string | null;
        finishDigit?: string | null;
        interdigitTimeoutDuration?: string | null;
        maxDigits?: number | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3AdvancedSettingsLoggingSettings {
        enableConsentBasedRedaction?: boolean | null;
        enableInteractionLogging?: boolean | null;
        enableStackdriverLogging?: boolean | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3AdvancedSettingsSpeechSettings {
        endpointerSensitivity?: number | null;
        models?: {
            [key: string]: string;
        } | null;
        noSpeechTimeout?: string | null;
        useTimeoutBasedEndpointing?: boolean | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3AudioInput {
        audio?: string | null;
        config?: Schema$GoogleCloudDialogflowCxV3InputAudioConfig;
    }
    export interface Schema$GoogleCloudDialogflowCxV3BargeInConfig {
        noBargeInDuration?: string | null;
        totalDuration?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3BatchRunTestCasesMetadata {
        errors?: Schema$GoogleCloudDialogflowCxV3TestError[];
    }
    export interface Schema$GoogleCloudDialogflowCxV3BatchRunTestCasesResponse {
        results?: Schema$GoogleCloudDialogflowCxV3TestCaseResult[];
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1AdvancedSettings {
        audioExportGcsDestination?: Schema$GoogleCloudDialogflowCxV3beta1GcsDestination;
        dtmfSettings?: Schema$GoogleCloudDialogflowCxV3beta1AdvancedSettingsDtmfSettings;
        loggingSettings?: Schema$GoogleCloudDialogflowCxV3beta1AdvancedSettingsLoggingSettings;
        speechSettings?: Schema$GoogleCloudDialogflowCxV3beta1AdvancedSettingsSpeechSettings;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1AdvancedSettingsDtmfSettings {
        enabled?: boolean | null;
        endpointingTimeoutDuration?: string | null;
        finishDigit?: string | null;
        interdigitTimeoutDuration?: string | null;
        maxDigits?: number | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1AdvancedSettingsLoggingSettings {
        enableConsentBasedRedaction?: boolean | null;
        enableInteractionLogging?: boolean | null;
        enableStackdriverLogging?: boolean | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1AdvancedSettingsSpeechSettings {
        endpointerSensitivity?: number | null;
        models?: {
            [key: string]: string;
        } | null;
        noSpeechTimeout?: string | null;
        useTimeoutBasedEndpointing?: boolean | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1AudioInput {
        audio?: string | null;
        config?: Schema$GoogleCloudDialogflowCxV3beta1InputAudioConfig;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1BargeInConfig {
        noBargeInDuration?: string | null;
        totalDuration?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1BatchRunTestCasesMetadata {
        errors?: Schema$GoogleCloudDialogflowCxV3beta1TestError[];
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1BatchRunTestCasesResponse {
        results?: Schema$GoogleCloudDialogflowCxV3beta1TestCaseResult[];
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1ContinuousTestResult {
        name?: string | null;
        result?: string | null;
        runTime?: string | null;
        testCaseResults?: string[] | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1ConversationSignals {
        turnSignals?: Schema$GoogleCloudDialogflowCxV3beta1TurnSignals;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1ConversationTurn {
        userInput?: Schema$GoogleCloudDialogflowCxV3beta1ConversationTurnUserInput;
        virtualAgentOutput?: Schema$GoogleCloudDialogflowCxV3beta1ConversationTurnVirtualAgentOutput;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1ConversationTurnUserInput {
        enableSentimentAnalysis?: boolean | null;
        injectedParameters?: {
            [key: string]: any;
        } | null;
        input?: Schema$GoogleCloudDialogflowCxV3beta1QueryInput;
        isWebhookEnabled?: boolean | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1ConversationTurnVirtualAgentOutput {
        currentPage?: Schema$GoogleCloudDialogflowCxV3beta1Page;
        diagnosticInfo?: {
            [key: string]: any;
        } | null;
        differences?: Schema$GoogleCloudDialogflowCxV3beta1TestRunDifference[];
        sessionParameters?: {
            [key: string]: any;
        } | null;
        status?: Schema$GoogleRpcStatus;
        textResponses?: Schema$GoogleCloudDialogflowCxV3beta1ResponseMessageText[];
        triggeredIntent?: Schema$GoogleCloudDialogflowCxV3beta1Intent;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1CreateVersionOperationMetadata {
        version?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1DataStoreConnection {
        dataStore?: string | null;
        dataStoreType?: string | null;
        documentProcessingMode?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1DeployFlowMetadata {
        testErrors?: Schema$GoogleCloudDialogflowCxV3beta1TestError[];
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1DeployFlowResponse {
        deployment?: string | null;
        environment?: Schema$GoogleCloudDialogflowCxV3beta1Environment;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1DtmfInput {
        digits?: string | null;
        finishDigit?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1Environment {
        description?: string | null;
        displayName?: string | null;
        name?: string | null;
        testCasesConfig?: Schema$GoogleCloudDialogflowCxV3beta1EnvironmentTestCasesConfig;
        updateTime?: string | null;
        versionConfigs?: Schema$GoogleCloudDialogflowCxV3beta1EnvironmentVersionConfig[];
        webhookConfig?: Schema$GoogleCloudDialogflowCxV3beta1EnvironmentWebhookConfig;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1EnvironmentTestCasesConfig {
        enableContinuousRun?: boolean | null;
        enablePredeploymentRun?: boolean | null;
        testCases?: string[] | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1EnvironmentVersionConfig {
        version?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1EnvironmentWebhookConfig {
        webhookOverrides?: Schema$GoogleCloudDialogflowCxV3beta1Webhook[];
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1EventHandler {
        event?: string | null;
        name?: string | null;
        targetFlow?: string | null;
        targetPage?: string | null;
        targetPlaybook?: string | null;
        triggerFulfillment?: Schema$GoogleCloudDialogflowCxV3beta1Fulfillment;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1EventInput {
        event?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1ExportAgentResponse {
        agentContent?: string | null;
        agentUri?: string | null;
        commitSha?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1ExportEntityTypesMetadata {
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1ExportEntityTypesResponse {
        entityTypesContent?: Schema$GoogleCloudDialogflowCxV3beta1InlineDestination;
        entityTypesUri?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1ExportFlowResponse {
        flowContent?: string | null;
        flowUri?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1ExportIntentsMetadata {
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1ExportIntentsResponse {
        intentsContent?: Schema$GoogleCloudDialogflowCxV3beta1InlineDestination;
        intentsUri?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1ExportTestCasesMetadata {
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1ExportTestCasesResponse {
        content?: string | null;
        gcsUri?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1Form {
        parameters?: Schema$GoogleCloudDialogflowCxV3beta1FormParameter[];
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1FormParameter {
        advancedSettings?: Schema$GoogleCloudDialogflowCxV3beta1AdvancedSettings;
        defaultValue?: any | null;
        displayName?: string | null;
        entityType?: string | null;
        fillBehavior?: Schema$GoogleCloudDialogflowCxV3beta1FormParameterFillBehavior;
        isList?: boolean | null;
        redact?: boolean | null;
        required?: boolean | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1FormParameterFillBehavior {
        initialPromptFulfillment?: Schema$GoogleCloudDialogflowCxV3beta1Fulfillment;
        repromptEventHandlers?: Schema$GoogleCloudDialogflowCxV3beta1EventHandler[];
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1Fulfillment {
        advancedSettings?: Schema$GoogleCloudDialogflowCxV3beta1AdvancedSettings;
        conditionalCases?: Schema$GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCases[];
        enableGenerativeFallback?: boolean | null;
        generators?: Schema$GoogleCloudDialogflowCxV3beta1FulfillmentGeneratorSettings[];
        messages?: Schema$GoogleCloudDialogflowCxV3beta1ResponseMessage[];
        returnPartialResponses?: boolean | null;
        setParameterActions?: Schema$GoogleCloudDialogflowCxV3beta1FulfillmentSetParameterAction[];
        tag?: string | null;
        webhook?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCases {
        cases?: Schema$GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCase[];
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCase {
        caseContent?: Schema$GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCaseCaseContent[];
        condition?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCaseCaseContent {
        additionalCases?: Schema$GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCases;
        message?: Schema$GoogleCloudDialogflowCxV3beta1ResponseMessage;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1FulfillmentGeneratorSettings {
        generator?: string | null;
        inputParameters?: {
            [key: string]: string;
        } | null;
        outputParameter?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1FulfillmentSetParameterAction {
        parameter?: string | null;
        value?: any | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1GcsDestination {
        uri?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1ImportEntityTypesMetadata {
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1ImportEntityTypesResponse {
        conflictingResources?: Schema$GoogleCloudDialogflowCxV3beta1ImportEntityTypesResponseConflictingResources;
        entityTypes?: string[] | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1ImportEntityTypesResponseConflictingResources {
        entityDisplayNames?: string[] | null;
        entityTypeDisplayNames?: string[] | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1ImportFlowResponse {
        flow?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1ImportIntentsMetadata {
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1ImportIntentsResponse {
        conflictingResources?: Schema$GoogleCloudDialogflowCxV3beta1ImportIntentsResponseConflictingResources;
        intents?: string[] | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1ImportIntentsResponseConflictingResources {
        entityDisplayNames?: string[] | null;
        intentDisplayNames?: string[] | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1ImportTestCasesMetadata {
        errors?: Schema$GoogleCloudDialogflowCxV3beta1TestCaseError[];
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1ImportTestCasesResponse {
        names?: string[] | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1InlineDestination {
        content?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1InputAudioConfig {
        audioEncoding?: string | null;
        bargeInConfig?: Schema$GoogleCloudDialogflowCxV3beta1BargeInConfig;
        enableWordInfo?: boolean | null;
        model?: string | null;
        modelVariant?: string | null;
        optOutConformerModelMigration?: boolean | null;
        phraseHints?: string[] | null;
        sampleRateHertz?: number | null;
        singleUtterance?: boolean | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1Intent {
        description?: string | null;
        displayName?: string | null;
        isFallback?: boolean | null;
        labels?: {
            [key: string]: string;
        } | null;
        name?: string | null;
        parameters?: Schema$GoogleCloudDialogflowCxV3beta1IntentParameter[];
        priority?: number | null;
        trainingPhrases?: Schema$GoogleCloudDialogflowCxV3beta1IntentTrainingPhrase[];
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1IntentInput {
        intent?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1IntentParameter {
        entityType?: string | null;
        id?: string | null;
        isList?: boolean | null;
        redact?: boolean | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1IntentTrainingPhrase {
        id?: string | null;
        parts?: Schema$GoogleCloudDialogflowCxV3beta1IntentTrainingPhrasePart[];
        repeatCount?: number | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1IntentTrainingPhrasePart {
        parameterId?: string | null;
        text?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1KnowledgeConnectorSettings {
        dataStoreConnections?: Schema$GoogleCloudDialogflowCxV3beta1DataStoreConnection[];
        enabled?: boolean | null;
        targetFlow?: string | null;
        targetPage?: string | null;
        triggerFulfillment?: Schema$GoogleCloudDialogflowCxV3beta1Fulfillment;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1LanguageInfo {
        confidenceScore?: number | null;
        inputLanguageCode?: string | null;
        resolvedLanguageCode?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1Page {
        advancedSettings?: Schema$GoogleCloudDialogflowCxV3beta1AdvancedSettings;
        description?: string | null;
        displayName?: string | null;
        entryFulfillment?: Schema$GoogleCloudDialogflowCxV3beta1Fulfillment;
        eventHandlers?: Schema$GoogleCloudDialogflowCxV3beta1EventHandler[];
        form?: Schema$GoogleCloudDialogflowCxV3beta1Form;
        knowledgeConnectorSettings?: Schema$GoogleCloudDialogflowCxV3beta1KnowledgeConnectorSettings;
        name?: string | null;
        transitionRouteGroups?: string[] | null;
        transitionRoutes?: Schema$GoogleCloudDialogflowCxV3beta1TransitionRoute[];
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1PageInfo {
        currentPage?: string | null;
        displayName?: string | null;
        formInfo?: Schema$GoogleCloudDialogflowCxV3beta1PageInfoFormInfo;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1PageInfoFormInfo {
        parameterInfo?: Schema$GoogleCloudDialogflowCxV3beta1PageInfoFormInfoParameterInfo[];
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1PageInfoFormInfoParameterInfo {
        displayName?: string | null;
        justCollected?: boolean | null;
        required?: boolean | null;
        state?: string | null;
        value?: any | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1QueryInput {
        audio?: Schema$GoogleCloudDialogflowCxV3beta1AudioInput;
        dtmf?: Schema$GoogleCloudDialogflowCxV3beta1DtmfInput;
        event?: Schema$GoogleCloudDialogflowCxV3beta1EventInput;
        intent?: Schema$GoogleCloudDialogflowCxV3beta1IntentInput;
        languageCode?: string | null;
        text?: Schema$GoogleCloudDialogflowCxV3beta1TextInput;
        toolCallResult?: Schema$GoogleCloudDialogflowCxV3beta1ToolCallResult;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1ResponseMessage {
        channel?: string | null;
        conversationSuccess?: Schema$GoogleCloudDialogflowCxV3beta1ResponseMessageConversationSuccess;
        endInteraction?: Schema$GoogleCloudDialogflowCxV3beta1ResponseMessageEndInteraction;
        knowledgeInfoCard?: Schema$GoogleCloudDialogflowCxV3beta1ResponseMessageKnowledgeInfoCard;
        liveAgentHandoff?: Schema$GoogleCloudDialogflowCxV3beta1ResponseMessageLiveAgentHandoff;
        mixedAudio?: Schema$GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudio;
        outputAudioText?: Schema$GoogleCloudDialogflowCxV3beta1ResponseMessageOutputAudioText;
        payload?: {
            [key: string]: any;
        } | null;
        playAudio?: Schema$GoogleCloudDialogflowCxV3beta1ResponseMessagePlayAudio;
        telephonyTransferCall?: Schema$GoogleCloudDialogflowCxV3beta1ResponseMessageTelephonyTransferCall;
        text?: Schema$GoogleCloudDialogflowCxV3beta1ResponseMessageText;
        toolCall?: Schema$GoogleCloudDialogflowCxV3beta1ToolCall;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1ResponseMessageConversationSuccess {
        metadata?: {
            [key: string]: any;
        } | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1ResponseMessageEndInteraction {
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1ResponseMessageKnowledgeInfoCard {
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1ResponseMessageLiveAgentHandoff {
        metadata?: {
            [key: string]: any;
        } | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudio {
        segments?: Schema$GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudioSegment[];
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudioSegment {
        allowPlaybackInterruption?: boolean | null;
        audio?: string | null;
        uri?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1ResponseMessageOutputAudioText {
        allowPlaybackInterruption?: boolean | null;
        ssml?: string | null;
        text?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1ResponseMessagePlayAudio {
        allowPlaybackInterruption?: boolean | null;
        audioUri?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1ResponseMessageTelephonyTransferCall {
        phoneNumber?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1ResponseMessageText {
        allowPlaybackInterruption?: boolean | null;
        text?: string[] | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1RunContinuousTestMetadata {
        errors?: Schema$GoogleCloudDialogflowCxV3beta1TestError[];
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1RunContinuousTestResponse {
        continuousTestResult?: Schema$GoogleCloudDialogflowCxV3beta1ContinuousTestResult;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1RunTestCaseMetadata {
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1RunTestCaseResponse {
        result?: Schema$GoogleCloudDialogflowCxV3beta1TestCaseResult;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1SessionInfo {
        parameters?: {
            [key: string]: any;
        } | null;
        session?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1TestCase {
        creationTime?: string | null;
        displayName?: string | null;
        lastTestResult?: Schema$GoogleCloudDialogflowCxV3beta1TestCaseResult;
        name?: string | null;
        notes?: string | null;
        tags?: string[] | null;
        testCaseConversationTurns?: Schema$GoogleCloudDialogflowCxV3beta1ConversationTurn[];
        testConfig?: Schema$GoogleCloudDialogflowCxV3beta1TestConfig;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1TestCaseError {
        status?: Schema$GoogleRpcStatus;
        testCase?: Schema$GoogleCloudDialogflowCxV3beta1TestCase;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1TestCaseResult {
        conversationTurns?: Schema$GoogleCloudDialogflowCxV3beta1ConversationTurn[];
        environment?: string | null;
        name?: string | null;
        testResult?: string | null;
        testTime?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1TestConfig {
        flow?: string | null;
        page?: string | null;
        trackingParameters?: string[] | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1TestError {
        status?: Schema$GoogleRpcStatus;
        testCase?: string | null;
        testTime?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1TestRunDifference {
        description?: string | null;
        type?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1TextInput {
        text?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1ToolCall {
        action?: string | null;
        inputParameters?: {
            [key: string]: any;
        } | null;
        tool?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1ToolCallResult {
        action?: string | null;
        error?: Schema$GoogleCloudDialogflowCxV3beta1ToolCallResultError;
        outputParameters?: {
            [key: string]: any;
        } | null;
        tool?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1ToolCallResultError {
        message?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1TransitionRoute {
        condition?: string | null;
        description?: string | null;
        intent?: string | null;
        name?: string | null;
        targetFlow?: string | null;
        targetPage?: string | null;
        triggerFulfillment?: Schema$GoogleCloudDialogflowCxV3beta1Fulfillment;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1TurnSignals {
        agentEscalated?: boolean | null;
        dtmfUsed?: boolean | null;
        failureReasons?: string[] | null;
        noMatch?: boolean | null;
        noUserInput?: boolean | null;
        reachedEndPage?: boolean | null;
        sentimentMagnitude?: number | null;
        sentimentScore?: number | null;
        userEscalated?: boolean | null;
        webhookStatuses?: string[] | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1Webhook {
        disabled?: boolean | null;
        displayName?: string | null;
        genericWebService?: Schema$GoogleCloudDialogflowCxV3beta1WebhookGenericWebService;
        name?: string | null;
        serviceDirectory?: Schema$GoogleCloudDialogflowCxV3beta1WebhookServiceDirectoryConfig;
        timeout?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1WebhookGenericWebService {
        allowedCaCerts?: string[] | null;
        httpMethod?: string | null;
        oauthConfig?: Schema$GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceOAuthConfig;
        parameterMapping?: {
            [key: string]: string;
        } | null;
        password?: string | null;
        requestBody?: string | null;
        requestHeaders?: {
            [key: string]: string;
        } | null;
        secretVersionForUsernamePassword?: string | null;
        secretVersionsForRequestHeaders?: {
            [key: string]: Schema$GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceSecretVersionHeaderValue;
        } | null;
        serviceAccountAuthConfig?: Schema$GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceServiceAccountAuthConfig;
        serviceAgentAuth?: string | null;
        uri?: string | null;
        username?: string | null;
        webhookType?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceOAuthConfig {
        clientId?: string | null;
        clientSecret?: string | null;
        scopes?: string[] | null;
        secretVersionForClientSecret?: string | null;
        tokenEndpoint?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceSecretVersionHeaderValue {
        secretVersion?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceServiceAccountAuthConfig {
        serviceAccount?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1WebhookRequest {
        detectIntentResponseId?: string | null;
        dtmfDigits?: string | null;
        fulfillmentInfo?: Schema$GoogleCloudDialogflowCxV3beta1WebhookRequestFulfillmentInfo;
        intentInfo?: Schema$GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfo;
        languageCode?: string | null;
        languageInfo?: Schema$GoogleCloudDialogflowCxV3beta1LanguageInfo;
        messages?: Schema$GoogleCloudDialogflowCxV3beta1ResponseMessage[];
        pageInfo?: Schema$GoogleCloudDialogflowCxV3beta1PageInfo;
        payload?: {
            [key: string]: any;
        } | null;
        sentimentAnalysisResult?: Schema$GoogleCloudDialogflowCxV3beta1WebhookRequestSentimentAnalysisResult;
        sessionInfo?: Schema$GoogleCloudDialogflowCxV3beta1SessionInfo;
        text?: string | null;
        transcript?: string | null;
        triggerEvent?: string | null;
        triggerIntent?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1WebhookRequestFulfillmentInfo {
        tag?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfo {
        confidence?: number | null;
        displayName?: string | null;
        lastMatchedIntent?: string | null;
        parameters?: {
            [key: string]: Schema$GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfoIntentParameterValue;
        } | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1WebhookRequestIntentInfoIntentParameterValue {
        originalValue?: string | null;
        resolvedValue?: any | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1WebhookRequestSentimentAnalysisResult {
        magnitude?: number | null;
        score?: number | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1WebhookResponse {
        fulfillmentResponse?: Schema$GoogleCloudDialogflowCxV3beta1WebhookResponseFulfillmentResponse;
        pageInfo?: Schema$GoogleCloudDialogflowCxV3beta1PageInfo;
        payload?: {
            [key: string]: any;
        } | null;
        sessionInfo?: Schema$GoogleCloudDialogflowCxV3beta1SessionInfo;
        targetFlow?: string | null;
        targetPage?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1WebhookResponseFulfillmentResponse {
        mergeBehavior?: string | null;
        messages?: Schema$GoogleCloudDialogflowCxV3beta1ResponseMessage[];
    }
    export interface Schema$GoogleCloudDialogflowCxV3beta1WebhookServiceDirectoryConfig {
        genericWebService?: Schema$GoogleCloudDialogflowCxV3beta1WebhookGenericWebService;
        service?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3ContinuousTestResult {
        name?: string | null;
        result?: string | null;
        runTime?: string | null;
        testCaseResults?: string[] | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3ConversationSignals {
        turnSignals?: Schema$GoogleCloudDialogflowCxV3TurnSignals;
    }
    export interface Schema$GoogleCloudDialogflowCxV3ConversationTurn {
        userInput?: Schema$GoogleCloudDialogflowCxV3ConversationTurnUserInput;
        virtualAgentOutput?: Schema$GoogleCloudDialogflowCxV3ConversationTurnVirtualAgentOutput;
    }
    export interface Schema$GoogleCloudDialogflowCxV3ConversationTurnUserInput {
        enableSentimentAnalysis?: boolean | null;
        injectedParameters?: {
            [key: string]: any;
        } | null;
        input?: Schema$GoogleCloudDialogflowCxV3QueryInput;
        isWebhookEnabled?: boolean | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3ConversationTurnVirtualAgentOutput {
        currentPage?: Schema$GoogleCloudDialogflowCxV3Page;
        diagnosticInfo?: {
            [key: string]: any;
        } | null;
        differences?: Schema$GoogleCloudDialogflowCxV3TestRunDifference[];
        sessionParameters?: {
            [key: string]: any;
        } | null;
        status?: Schema$GoogleRpcStatus;
        textResponses?: Schema$GoogleCloudDialogflowCxV3ResponseMessageText[];
        triggeredIntent?: Schema$GoogleCloudDialogflowCxV3Intent;
    }
    export interface Schema$GoogleCloudDialogflowCxV3CreateVersionOperationMetadata {
        version?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3DataStoreConnection {
        dataStore?: string | null;
        dataStoreType?: string | null;
        documentProcessingMode?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3DeployFlowMetadata {
        testErrors?: Schema$GoogleCloudDialogflowCxV3TestError[];
    }
    export interface Schema$GoogleCloudDialogflowCxV3DeployFlowResponse {
        deployment?: string | null;
        environment?: Schema$GoogleCloudDialogflowCxV3Environment;
    }
    export interface Schema$GoogleCloudDialogflowCxV3DtmfInput {
        digits?: string | null;
        finishDigit?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3Environment {
        description?: string | null;
        displayName?: string | null;
        name?: string | null;
        testCasesConfig?: Schema$GoogleCloudDialogflowCxV3EnvironmentTestCasesConfig;
        updateTime?: string | null;
        versionConfigs?: Schema$GoogleCloudDialogflowCxV3EnvironmentVersionConfig[];
        webhookConfig?: Schema$GoogleCloudDialogflowCxV3EnvironmentWebhookConfig;
    }
    export interface Schema$GoogleCloudDialogflowCxV3EnvironmentTestCasesConfig {
        enableContinuousRun?: boolean | null;
        enablePredeploymentRun?: boolean | null;
        testCases?: string[] | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3EnvironmentVersionConfig {
        version?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3EnvironmentWebhookConfig {
        webhookOverrides?: Schema$GoogleCloudDialogflowCxV3Webhook[];
    }
    export interface Schema$GoogleCloudDialogflowCxV3EventHandler {
        event?: string | null;
        name?: string | null;
        targetFlow?: string | null;
        targetPage?: string | null;
        targetPlaybook?: string | null;
        triggerFulfillment?: Schema$GoogleCloudDialogflowCxV3Fulfillment;
    }
    export interface Schema$GoogleCloudDialogflowCxV3EventInput {
        event?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3ExportAgentResponse {
        agentContent?: string | null;
        agentUri?: string | null;
        commitSha?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3ExportEntityTypesMetadata {
    }
    export interface Schema$GoogleCloudDialogflowCxV3ExportEntityTypesResponse {
        entityTypesContent?: Schema$GoogleCloudDialogflowCxV3InlineDestination;
        entityTypesUri?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3ExportFlowResponse {
        flowContent?: string | null;
        flowUri?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3ExportIntentsMetadata {
    }
    export interface Schema$GoogleCloudDialogflowCxV3ExportIntentsResponse {
        intentsContent?: Schema$GoogleCloudDialogflowCxV3InlineDestination;
        intentsUri?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3ExportTestCasesMetadata {
    }
    export interface Schema$GoogleCloudDialogflowCxV3ExportTestCasesResponse {
        content?: string | null;
        gcsUri?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3Form {
        parameters?: Schema$GoogleCloudDialogflowCxV3FormParameter[];
    }
    export interface Schema$GoogleCloudDialogflowCxV3FormParameter {
        advancedSettings?: Schema$GoogleCloudDialogflowCxV3AdvancedSettings;
        defaultValue?: any | null;
        displayName?: string | null;
        entityType?: string | null;
        fillBehavior?: Schema$GoogleCloudDialogflowCxV3FormParameterFillBehavior;
        isList?: boolean | null;
        redact?: boolean | null;
        required?: boolean | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3FormParameterFillBehavior {
        initialPromptFulfillment?: Schema$GoogleCloudDialogflowCxV3Fulfillment;
        repromptEventHandlers?: Schema$GoogleCloudDialogflowCxV3EventHandler[];
    }
    export interface Schema$GoogleCloudDialogflowCxV3Fulfillment {
        advancedSettings?: Schema$GoogleCloudDialogflowCxV3AdvancedSettings;
        conditionalCases?: Schema$GoogleCloudDialogflowCxV3FulfillmentConditionalCases[];
        enableGenerativeFallback?: boolean | null;
        generators?: Schema$GoogleCloudDialogflowCxV3FulfillmentGeneratorSettings[];
        messages?: Schema$GoogleCloudDialogflowCxV3ResponseMessage[];
        returnPartialResponses?: boolean | null;
        setParameterActions?: Schema$GoogleCloudDialogflowCxV3FulfillmentSetParameterAction[];
        tag?: string | null;
        webhook?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3FulfillmentConditionalCases {
        cases?: Schema$GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCase[];
    }
    export interface Schema$GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCase {
        caseContent?: Schema$GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCaseCaseContent[];
        condition?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3FulfillmentConditionalCasesCaseCaseContent {
        additionalCases?: Schema$GoogleCloudDialogflowCxV3FulfillmentConditionalCases;
        message?: Schema$GoogleCloudDialogflowCxV3ResponseMessage;
    }
    export interface Schema$GoogleCloudDialogflowCxV3FulfillmentGeneratorSettings {
        generator?: string | null;
        inputParameters?: {
            [key: string]: string;
        } | null;
        outputParameter?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3FulfillmentSetParameterAction {
        parameter?: string | null;
        value?: any | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3GcsDestination {
        uri?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3ImportEntityTypesMetadata {
    }
    export interface Schema$GoogleCloudDialogflowCxV3ImportEntityTypesResponse {
        conflictingResources?: Schema$GoogleCloudDialogflowCxV3ImportEntityTypesResponseConflictingResources;
        entityTypes?: string[] | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3ImportEntityTypesResponseConflictingResources {
        entityDisplayNames?: string[] | null;
        entityTypeDisplayNames?: string[] | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3ImportFlowResponse {
        flow?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3ImportIntentsMetadata {
    }
    export interface Schema$GoogleCloudDialogflowCxV3ImportIntentsResponse {
        conflictingResources?: Schema$GoogleCloudDialogflowCxV3ImportIntentsResponseConflictingResources;
        intents?: string[] | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3ImportIntentsResponseConflictingResources {
        entityDisplayNames?: string[] | null;
        intentDisplayNames?: string[] | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3ImportTestCasesMetadata {
        errors?: Schema$GoogleCloudDialogflowCxV3TestCaseError[];
    }
    export interface Schema$GoogleCloudDialogflowCxV3ImportTestCasesResponse {
        names?: string[] | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3InlineDestination {
        content?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3InputAudioConfig {
        audioEncoding?: string | null;
        bargeInConfig?: Schema$GoogleCloudDialogflowCxV3BargeInConfig;
        enableWordInfo?: boolean | null;
        model?: string | null;
        modelVariant?: string | null;
        optOutConformerModelMigration?: boolean | null;
        phraseHints?: string[] | null;
        sampleRateHertz?: number | null;
        singleUtterance?: boolean | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3Intent {
        description?: string | null;
        displayName?: string | null;
        isFallback?: boolean | null;
        labels?: {
            [key: string]: string;
        } | null;
        name?: string | null;
        parameters?: Schema$GoogleCloudDialogflowCxV3IntentParameter[];
        priority?: number | null;
        trainingPhrases?: Schema$GoogleCloudDialogflowCxV3IntentTrainingPhrase[];
    }
    export interface Schema$GoogleCloudDialogflowCxV3IntentInput {
        intent?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3IntentParameter {
        entityType?: string | null;
        id?: string | null;
        isList?: boolean | null;
        redact?: boolean | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3IntentTrainingPhrase {
        id?: string | null;
        parts?: Schema$GoogleCloudDialogflowCxV3IntentTrainingPhrasePart[];
        repeatCount?: number | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3IntentTrainingPhrasePart {
        parameterId?: string | null;
        text?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3KnowledgeConnectorSettings {
        dataStoreConnections?: Schema$GoogleCloudDialogflowCxV3DataStoreConnection[];
        enabled?: boolean | null;
        targetFlow?: string | null;
        targetPage?: string | null;
        triggerFulfillment?: Schema$GoogleCloudDialogflowCxV3Fulfillment;
    }
    export interface Schema$GoogleCloudDialogflowCxV3LanguageInfo {
        confidenceScore?: number | null;
        inputLanguageCode?: string | null;
        resolvedLanguageCode?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3Page {
        advancedSettings?: Schema$GoogleCloudDialogflowCxV3AdvancedSettings;
        description?: string | null;
        displayName?: string | null;
        entryFulfillment?: Schema$GoogleCloudDialogflowCxV3Fulfillment;
        eventHandlers?: Schema$GoogleCloudDialogflowCxV3EventHandler[];
        form?: Schema$GoogleCloudDialogflowCxV3Form;
        knowledgeConnectorSettings?: Schema$GoogleCloudDialogflowCxV3KnowledgeConnectorSettings;
        name?: string | null;
        transitionRouteGroups?: string[] | null;
        transitionRoutes?: Schema$GoogleCloudDialogflowCxV3TransitionRoute[];
    }
    export interface Schema$GoogleCloudDialogflowCxV3PageInfo {
        currentPage?: string | null;
        displayName?: string | null;
        formInfo?: Schema$GoogleCloudDialogflowCxV3PageInfoFormInfo;
    }
    export interface Schema$GoogleCloudDialogflowCxV3PageInfoFormInfo {
        parameterInfo?: Schema$GoogleCloudDialogflowCxV3PageInfoFormInfoParameterInfo[];
    }
    export interface Schema$GoogleCloudDialogflowCxV3PageInfoFormInfoParameterInfo {
        displayName?: string | null;
        justCollected?: boolean | null;
        required?: boolean | null;
        state?: string | null;
        value?: any | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3QueryInput {
        audio?: Schema$GoogleCloudDialogflowCxV3AudioInput;
        dtmf?: Schema$GoogleCloudDialogflowCxV3DtmfInput;
        event?: Schema$GoogleCloudDialogflowCxV3EventInput;
        intent?: Schema$GoogleCloudDialogflowCxV3IntentInput;
        languageCode?: string | null;
        text?: Schema$GoogleCloudDialogflowCxV3TextInput;
        toolCallResult?: Schema$GoogleCloudDialogflowCxV3ToolCallResult;
    }
    export interface Schema$GoogleCloudDialogflowCxV3ResponseMessage {
        channel?: string | null;
        conversationSuccess?: Schema$GoogleCloudDialogflowCxV3ResponseMessageConversationSuccess;
        endInteraction?: Schema$GoogleCloudDialogflowCxV3ResponseMessageEndInteraction;
        knowledgeInfoCard?: Schema$GoogleCloudDialogflowCxV3ResponseMessageKnowledgeInfoCard;
        liveAgentHandoff?: Schema$GoogleCloudDialogflowCxV3ResponseMessageLiveAgentHandoff;
        mixedAudio?: Schema$GoogleCloudDialogflowCxV3ResponseMessageMixedAudio;
        outputAudioText?: Schema$GoogleCloudDialogflowCxV3ResponseMessageOutputAudioText;
        payload?: {
            [key: string]: any;
        } | null;
        playAudio?: Schema$GoogleCloudDialogflowCxV3ResponseMessagePlayAudio;
        responseType?: string | null;
        telephonyTransferCall?: Schema$GoogleCloudDialogflowCxV3ResponseMessageTelephonyTransferCall;
        text?: Schema$GoogleCloudDialogflowCxV3ResponseMessageText;
        toolCall?: Schema$GoogleCloudDialogflowCxV3ToolCall;
    }
    export interface Schema$GoogleCloudDialogflowCxV3ResponseMessageConversationSuccess {
        metadata?: {
            [key: string]: any;
        } | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3ResponseMessageEndInteraction {
    }
    export interface Schema$GoogleCloudDialogflowCxV3ResponseMessageKnowledgeInfoCard {
    }
    export interface Schema$GoogleCloudDialogflowCxV3ResponseMessageLiveAgentHandoff {
        metadata?: {
            [key: string]: any;
        } | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3ResponseMessageMixedAudio {
        segments?: Schema$GoogleCloudDialogflowCxV3ResponseMessageMixedAudioSegment[];
    }
    export interface Schema$GoogleCloudDialogflowCxV3ResponseMessageMixedAudioSegment {
        allowPlaybackInterruption?: boolean | null;
        audio?: string | null;
        uri?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3ResponseMessageOutputAudioText {
        allowPlaybackInterruption?: boolean | null;
        ssml?: string | null;
        text?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3ResponseMessagePlayAudio {
        allowPlaybackInterruption?: boolean | null;
        audioUri?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3ResponseMessageTelephonyTransferCall {
        phoneNumber?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3ResponseMessageText {
        allowPlaybackInterruption?: boolean | null;
        text?: string[] | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3RunContinuousTestMetadata {
        errors?: Schema$GoogleCloudDialogflowCxV3TestError[];
    }
    export interface Schema$GoogleCloudDialogflowCxV3RunContinuousTestResponse {
        continuousTestResult?: Schema$GoogleCloudDialogflowCxV3ContinuousTestResult;
    }
    export interface Schema$GoogleCloudDialogflowCxV3RunTestCaseMetadata {
    }
    export interface Schema$GoogleCloudDialogflowCxV3RunTestCaseResponse {
        result?: Schema$GoogleCloudDialogflowCxV3TestCaseResult;
    }
    export interface Schema$GoogleCloudDialogflowCxV3SessionInfo {
        parameters?: {
            [key: string]: any;
        } | null;
        session?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3TestCase {
        creationTime?: string | null;
        displayName?: string | null;
        lastTestResult?: Schema$GoogleCloudDialogflowCxV3TestCaseResult;
        name?: string | null;
        notes?: string | null;
        tags?: string[] | null;
        testCaseConversationTurns?: Schema$GoogleCloudDialogflowCxV3ConversationTurn[];
        testConfig?: Schema$GoogleCloudDialogflowCxV3TestConfig;
    }
    export interface Schema$GoogleCloudDialogflowCxV3TestCaseError {
        status?: Schema$GoogleRpcStatus;
        testCase?: Schema$GoogleCloudDialogflowCxV3TestCase;
    }
    export interface Schema$GoogleCloudDialogflowCxV3TestCaseResult {
        conversationTurns?: Schema$GoogleCloudDialogflowCxV3ConversationTurn[];
        environment?: string | null;
        name?: string | null;
        testResult?: string | null;
        testTime?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3TestConfig {
        flow?: string | null;
        page?: string | null;
        trackingParameters?: string[] | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3TestError {
        status?: Schema$GoogleRpcStatus;
        testCase?: string | null;
        testTime?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3TestRunDifference {
        description?: string | null;
        type?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3TextInput {
        text?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3ToolCall {
        action?: string | null;
        inputParameters?: {
            [key: string]: any;
        } | null;
        tool?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3ToolCallResult {
        action?: string | null;
        error?: Schema$GoogleCloudDialogflowCxV3ToolCallResultError;
        outputParameters?: {
            [key: string]: any;
        } | null;
        tool?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3ToolCallResultError {
        message?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3TransitionRoute {
        condition?: string | null;
        description?: string | null;
        intent?: string | null;
        name?: string | null;
        targetFlow?: string | null;
        targetPage?: string | null;
        triggerFulfillment?: Schema$GoogleCloudDialogflowCxV3Fulfillment;
    }
    export interface Schema$GoogleCloudDialogflowCxV3TurnSignals {
        agentEscalated?: boolean | null;
        dtmfUsed?: boolean | null;
        failureReasons?: string[] | null;
        noMatch?: boolean | null;
        noUserInput?: boolean | null;
        reachedEndPage?: boolean | null;
        sentimentMagnitude?: number | null;
        sentimentScore?: number | null;
        userEscalated?: boolean | null;
        webhookStatuses?: string[] | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3Webhook {
        disabled?: boolean | null;
        displayName?: string | null;
        genericWebService?: Schema$GoogleCloudDialogflowCxV3WebhookGenericWebService;
        name?: string | null;
        serviceDirectory?: Schema$GoogleCloudDialogflowCxV3WebhookServiceDirectoryConfig;
        timeout?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3WebhookGenericWebService {
        allowedCaCerts?: string[] | null;
        httpMethod?: string | null;
        oauthConfig?: Schema$GoogleCloudDialogflowCxV3WebhookGenericWebServiceOAuthConfig;
        parameterMapping?: {
            [key: string]: string;
        } | null;
        password?: string | null;
        requestBody?: string | null;
        requestHeaders?: {
            [key: string]: string;
        } | null;
        secretVersionForUsernamePassword?: string | null;
        secretVersionsForRequestHeaders?: {
            [key: string]: Schema$GoogleCloudDialogflowCxV3WebhookGenericWebServiceSecretVersionHeaderValue;
        } | null;
        serviceAccountAuthConfig?: Schema$GoogleCloudDialogflowCxV3WebhookGenericWebServiceServiceAccountAuthConfig;
        serviceAgentAuth?: string | null;
        uri?: string | null;
        username?: string | null;
        webhookType?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3WebhookGenericWebServiceOAuthConfig {
        clientId?: string | null;
        clientSecret?: string | null;
        scopes?: string[] | null;
        secretVersionForClientSecret?: string | null;
        tokenEndpoint?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3WebhookGenericWebServiceSecretVersionHeaderValue {
        secretVersion?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3WebhookGenericWebServiceServiceAccountAuthConfig {
        serviceAccount?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3WebhookRequest {
        detectIntentResponseId?: string | null;
        dtmfDigits?: string | null;
        fulfillmentInfo?: Schema$GoogleCloudDialogflowCxV3WebhookRequestFulfillmentInfo;
        intentInfo?: Schema$GoogleCloudDialogflowCxV3WebhookRequestIntentInfo;
        languageCode?: string | null;
        languageInfo?: Schema$GoogleCloudDialogflowCxV3LanguageInfo;
        messages?: Schema$GoogleCloudDialogflowCxV3ResponseMessage[];
        pageInfo?: Schema$GoogleCloudDialogflowCxV3PageInfo;
        payload?: {
            [key: string]: any;
        } | null;
        sentimentAnalysisResult?: Schema$GoogleCloudDialogflowCxV3WebhookRequestSentimentAnalysisResult;
        sessionInfo?: Schema$GoogleCloudDialogflowCxV3SessionInfo;
        text?: string | null;
        transcript?: string | null;
        triggerEvent?: string | null;
        triggerIntent?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3WebhookRequestFulfillmentInfo {
        tag?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3WebhookRequestIntentInfo {
        confidence?: number | null;
        displayName?: string | null;
        lastMatchedIntent?: string | null;
        parameters?: {
            [key: string]: Schema$GoogleCloudDialogflowCxV3WebhookRequestIntentInfoIntentParameterValue;
        } | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3WebhookRequestIntentInfoIntentParameterValue {
        originalValue?: string | null;
        resolvedValue?: any | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3WebhookRequestSentimentAnalysisResult {
        magnitude?: number | null;
        score?: number | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3WebhookResponse {
        fulfillmentResponse?: Schema$GoogleCloudDialogflowCxV3WebhookResponseFulfillmentResponse;
        pageInfo?: Schema$GoogleCloudDialogflowCxV3PageInfo;
        payload?: {
            [key: string]: any;
        } | null;
        sessionInfo?: Schema$GoogleCloudDialogflowCxV3SessionInfo;
        targetFlow?: string | null;
        targetPage?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowCxV3WebhookResponseFulfillmentResponse {
        mergeBehavior?: string | null;
        messages?: Schema$GoogleCloudDialogflowCxV3ResponseMessage[];
    }
    export interface Schema$GoogleCloudDialogflowCxV3WebhookServiceDirectoryConfig {
        genericWebService?: Schema$GoogleCloudDialogflowCxV3WebhookGenericWebService;
        service?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2AgentCoachingInstruction {
        agentAction?: string | null;
        condition?: string | null;
        displayDetails?: string | null;
        displayName?: string | null;
        duplicateCheckResult?: Schema$GoogleCloudDialogflowV2AgentCoachingInstructionDuplicateCheckResult;
        systemAction?: string | null;
        triggeringEvent?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2AgentCoachingInstructionDuplicateCheckResult {
        duplicateSuggestions?: Schema$GoogleCloudDialogflowV2AgentCoachingInstructionDuplicateCheckResultDuplicateSuggestion[];
    }
    export interface Schema$GoogleCloudDialogflowV2AgentCoachingInstructionDuplicateCheckResultDuplicateSuggestion {
        answerRecord?: string | null;
        similarityScore?: number | null;
        suggestionIndex?: number | null;
    }
    export interface Schema$GoogleCloudDialogflowV2AgentCoachingSuggestion {
        agentActionSuggestions?: Schema$GoogleCloudDialogflowV2AgentCoachingSuggestionAgentActionSuggestion[];
        applicableInstructions?: Schema$GoogleCloudDialogflowV2AgentCoachingInstruction[];
        sampleResponses?: Schema$GoogleCloudDialogflowV2AgentCoachingSuggestionSampleResponse[];
    }
    export interface Schema$GoogleCloudDialogflowV2AgentCoachingSuggestionAgentActionSuggestion {
        agentAction?: string | null;
        duplicateCheckResult?: Schema$GoogleCloudDialogflowV2AgentCoachingSuggestionDuplicateCheckResult;
        sources?: Schema$GoogleCloudDialogflowV2AgentCoachingSuggestionSources;
    }
    export interface Schema$GoogleCloudDialogflowV2AgentCoachingSuggestionDuplicateCheckResult {
        duplicateSuggestions?: Schema$GoogleCloudDialogflowV2AgentCoachingSuggestionDuplicateCheckResultDuplicateSuggestion[];
    }
    export interface Schema$GoogleCloudDialogflowV2AgentCoachingSuggestionDuplicateCheckResultDuplicateSuggestion {
        answerRecord?: string | null;
        similarityScore?: number | null;
        sources?: Schema$GoogleCloudDialogflowV2AgentCoachingSuggestionSources;
        suggestionIndex?: number | null;
    }
    export interface Schema$GoogleCloudDialogflowV2AgentCoachingSuggestionSampleResponse {
        duplicateCheckResult?: Schema$GoogleCloudDialogflowV2AgentCoachingSuggestionDuplicateCheckResult;
        responseText?: string | null;
        sources?: Schema$GoogleCloudDialogflowV2AgentCoachingSuggestionSources;
    }
    export interface Schema$GoogleCloudDialogflowV2AgentCoachingSuggestionSources {
        instructionIndexes?: number[] | null;
    }
    export interface Schema$GoogleCloudDialogflowV2AnnotatedMessagePart {
        entityType?: string | null;
        formattedValue?: any | null;
        text?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2ArticleAnswer {
        answerRecord?: string | null;
        confidence?: number | null;
        metadata?: {
            [key: string]: string;
        } | null;
        snippets?: string[] | null;
        title?: string | null;
        uri?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2ArticleSuggestionModelMetadata {
        trainingModelType?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2BatchUpdateEntityTypesResponse {
        entityTypes?: Schema$GoogleCloudDialogflowV2EntityType[];
    }
    export interface Schema$GoogleCloudDialogflowV2BatchUpdateIntentsResponse {
        intents?: Schema$GoogleCloudDialogflowV2Intent[];
    }
    export interface Schema$GoogleCloudDialogflowV2beta1Agent {
        apiVersion?: string | null;
        avatarUri?: string | null;
        classificationThreshold?: number | null;
        defaultLanguageCode?: string | null;
        description?: string | null;
        displayName?: string | null;
        enableLogging?: boolean | null;
        matchMode?: string | null;
        parent?: string | null;
        supportedLanguageCodes?: string[] | null;
        tier?: string | null;
        timeZone?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1AgentAssistantFeedback {
        answerRelevance?: string | null;
        documentCorrectness?: string | null;
        documentEfficiency?: string | null;
        knowledgeAssistFeedback?: Schema$GoogleCloudDialogflowV2beta1AgentAssistantFeedbackKnowledgeAssistFeedback;
        knowledgeSearchFeedback?: Schema$GoogleCloudDialogflowV2beta1AgentAssistantFeedbackKnowledgeSearchFeedback;
        summarizationFeedback?: Schema$GoogleCloudDialogflowV2beta1AgentAssistantFeedbackSummarizationFeedback;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1AgentAssistantFeedbackKnowledgeAssistFeedback {
        answerCopied?: boolean | null;
        clickedUris?: string[] | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1AgentAssistantFeedbackKnowledgeSearchFeedback {
        answerCopied?: boolean | null;
        clickedUris?: string[] | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1AgentAssistantFeedbackSummarizationFeedback {
        startTimestamp?: string | null;
        submitTimestamp?: string | null;
        summaryText?: string | null;
        textSections?: {
            [key: string]: string;
        } | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1AgentAssistantRecord {
        articleSuggestionAnswer?: Schema$GoogleCloudDialogflowV2beta1ArticleAnswer;
        dialogflowAssistAnswer?: Schema$GoogleCloudDialogflowV2beta1DialogflowAssistAnswer;
        faqAnswer?: Schema$GoogleCloudDialogflowV2beta1FaqAnswer;
        generatorSuggestion?: Schema$GoogleCloudDialogflowV2beta1GeneratorSuggestion;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1AgentCoachingContext {
        instructions?: Schema$GoogleCloudDialogflowV2beta1AgentCoachingInstruction[];
        outputLanguageCode?: string | null;
        overarchingGuidance?: string | null;
        version?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1AgentCoachingInstruction {
        agentAction?: string | null;
        condition?: string | null;
        displayDetails?: string | null;
        displayName?: string | null;
        duplicateCheckResult?: Schema$GoogleCloudDialogflowV2beta1AgentCoachingInstructionDuplicateCheckResult;
        systemAction?: string | null;
        triggeringEvent?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1AgentCoachingInstructionDuplicateCheckResult {
        duplicateSuggestions?: Schema$GoogleCloudDialogflowV2beta1AgentCoachingInstructionDuplicateCheckResultDuplicateSuggestion[];
    }
    export interface Schema$GoogleCloudDialogflowV2beta1AgentCoachingInstructionDuplicateCheckResultDuplicateSuggestion {
        answerRecord?: string | null;
        similarityScore?: number | null;
        suggestionIndex?: number | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1AgentCoachingSuggestion {
        agentActionSuggestions?: Schema$GoogleCloudDialogflowV2beta1AgentCoachingSuggestionAgentActionSuggestion[];
        applicableInstructions?: Schema$GoogleCloudDialogflowV2beta1AgentCoachingInstruction[];
        sampleResponses?: Schema$GoogleCloudDialogflowV2beta1AgentCoachingSuggestionSampleResponse[];
    }
    export interface Schema$GoogleCloudDialogflowV2beta1AgentCoachingSuggestionAgentActionSuggestion {
        agentAction?: string | null;
        duplicateCheckResult?: Schema$GoogleCloudDialogflowV2beta1AgentCoachingSuggestionDuplicateCheckResult;
        sources?: Schema$GoogleCloudDialogflowV2beta1AgentCoachingSuggestionSources;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1AgentCoachingSuggestionDuplicateCheckResult {
        duplicateSuggestions?: Schema$GoogleCloudDialogflowV2beta1AgentCoachingSuggestionDuplicateCheckResultDuplicateSuggestion[];
    }
    export interface Schema$GoogleCloudDialogflowV2beta1AgentCoachingSuggestionDuplicateCheckResultDuplicateSuggestion {
        answerRecord?: string | null;
        similarityScore?: number | null;
        sources?: Schema$GoogleCloudDialogflowV2beta1AgentCoachingSuggestionSources;
        suggestionIndex?: number | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1AgentCoachingSuggestionSampleResponse {
        duplicateCheckResult?: Schema$GoogleCloudDialogflowV2beta1AgentCoachingSuggestionDuplicateCheckResult;
        responseText?: string | null;
        sources?: Schema$GoogleCloudDialogflowV2beta1AgentCoachingSuggestionSources;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1AgentCoachingSuggestionSources {
        instructionIndexes?: number[] | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1AnalyzeContentRequest {
        assistQueryParams?: Schema$GoogleCloudDialogflowV2beta1AssistQueryParameters;
        audioInput?: Schema$GoogleCloudDialogflowV2beta1AudioInput;
        cxCurrentPage?: string | null;
        cxParameters?: {
            [key: string]: any;
        } | null;
        eventInput?: Schema$GoogleCloudDialogflowV2beta1EventInput;
        intentInput?: Schema$GoogleCloudDialogflowV2beta1IntentInput;
        messageSendTime?: string | null;
        queryParams?: Schema$GoogleCloudDialogflowV2beta1QueryParameters;
        replyAudioConfig?: Schema$GoogleCloudDialogflowV2beta1OutputAudioConfig;
        requestId?: string | null;
        suggestionInput?: Schema$GoogleCloudDialogflowV2beta1SuggestionInput;
        textInput?: Schema$GoogleCloudDialogflowV2beta1TextInput;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1AnalyzeContentResponse {
        automatedAgentReply?: Schema$GoogleCloudDialogflowV2beta1AutomatedAgentReply;
        dtmfParameters?: Schema$GoogleCloudDialogflowV2beta1DtmfParameters;
        endUserSuggestionResults?: Schema$GoogleCloudDialogflowV2beta1SuggestionResult[];
        humanAgentSuggestionResults?: Schema$GoogleCloudDialogflowV2beta1SuggestionResult[];
        message?: Schema$GoogleCloudDialogflowV2beta1Message;
        replyAudio?: Schema$GoogleCloudDialogflowV2beta1OutputAudio;
        replyText?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1AnnotatedMessagePart {
        entityType?: string | null;
        formattedValue?: any | null;
        text?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1AnswerFeedback {
        agentAssistantDetailFeedback?: Schema$GoogleCloudDialogflowV2beta1AgentAssistantFeedback;
        clicked?: boolean | null;
        clickTime?: string | null;
        correctnessLevel?: string | null;
        displayed?: boolean | null;
        displayTime?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1AnswerRecord {
        agentAssistantRecord?: Schema$GoogleCloudDialogflowV2beta1AgentAssistantRecord;
        answerFeedback?: Schema$GoogleCloudDialogflowV2beta1AnswerFeedback;
        name?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ArticleAnswer {
        answerRecord?: string | null;
        metadata?: {
            [key: string]: string;
        } | null;
        snippets?: string[] | null;
        title?: string | null;
        uri?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1AssistQueryParameters {
        documentsMetadataFilters?: {
            [key: string]: string;
        } | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1AudioInput {
        audio?: string | null;
        config?: Schema$GoogleCloudDialogflowV2beta1InputAudioConfig;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1AutomatedAgentConfig {
        agent?: string | null;
        sessionTtl?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1AutomatedAgentReply {
        allowCancellation?: boolean | null;
        automatedAgentReplyType?: string | null;
        callCompanionAuthCode?: string | null;
        cxCurrentPage?: string | null;
        cxSessionParameters?: {
            [key: string]: any;
        } | null;
        detectIntentResponse?: Schema$GoogleCloudDialogflowV2beta1DetectIntentResponse;
        event?: string | null;
        intent?: string | null;
        matchConfidence?: number | null;
        parameters?: {
            [key: string]: any;
        } | null;
        responseMessages?: Schema$GoogleCloudDialogflowV2beta1ResponseMessage[];
    }
    export interface Schema$GoogleCloudDialogflowV2beta1BargeInConfig {
        noBargeInDuration?: string | null;
        totalDuration?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1BatchCreateEntitiesRequest {
        entities?: Schema$GoogleCloudDialogflowV2beta1EntityTypeEntity[];
        languageCode?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1BatchCreateMessagesRequest {
        requests?: Schema$GoogleCloudDialogflowV2beta1CreateMessageRequest[];
    }
    export interface Schema$GoogleCloudDialogflowV2beta1BatchCreateMessagesResponse {
        messages?: Schema$GoogleCloudDialogflowV2beta1Message[];
    }
    export interface Schema$GoogleCloudDialogflowV2beta1BatchDeleteEntitiesRequest {
        entityValues?: string[] | null;
        languageCode?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1BatchDeleteEntityTypesRequest {
        entityTypeNames?: string[] | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1BatchDeleteIntentsRequest {
        intents?: Schema$GoogleCloudDialogflowV2beta1Intent[];
    }
    export interface Schema$GoogleCloudDialogflowV2beta1BatchUpdateEntitiesRequest {
        entities?: Schema$GoogleCloudDialogflowV2beta1EntityTypeEntity[];
        languageCode?: string | null;
        updateMask?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1BatchUpdateEntityTypesRequest {
        entityTypeBatchInline?: Schema$GoogleCloudDialogflowV2beta1EntityTypeBatch;
        entityTypeBatchUri?: string | null;
        languageCode?: string | null;
        updateMask?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1BatchUpdateEntityTypesResponse {
        entityTypes?: Schema$GoogleCloudDialogflowV2beta1EntityType[];
    }
    export interface Schema$GoogleCloudDialogflowV2beta1BatchUpdateIntentsRequest {
        intentBatchInline?: Schema$GoogleCloudDialogflowV2beta1IntentBatch;
        intentBatchUri?: string | null;
        intentView?: string | null;
        languageCode?: string | null;
        updateMask?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1BatchUpdateIntentsResponse {
        intents?: Schema$GoogleCloudDialogflowV2beta1Intent[];
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ClearSuggestionFeatureConfigOperationMetadata {
        conversationProfile?: string | null;
        createTime?: string | null;
        participantRole?: string | null;
        suggestionFeatureType?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ClearSuggestionFeatureConfigRequest {
        participantRole?: string | null;
        suggestionFeatureType?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1CompileSuggestionRequest {
        contextSize?: number | null;
        latestMessage?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1CompileSuggestionResponse {
        contextSize?: number | null;
        latestMessage?: string | null;
        suggestion?: Schema$GoogleCloudDialogflowV2beta1Suggestion;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1CompleteConversationRequest {
    }
    export interface Schema$GoogleCloudDialogflowV2beta1Connection {
        connectionId?: string | null;
        errorDetails?: Schema$GoogleCloudDialogflowV2beta1ConnectionErrorDetails;
        state?: string | null;
        updateTime?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ConnectionErrorDetails {
        certificateState?: string | null;
        errorMessage?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1Context {
        lifespanCount?: number | null;
        name?: string | null;
        parameters?: {
            [key: string]: any;
        } | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1Conversation {
        conversationProfile?: string | null;
        conversationStage?: string | null;
        endTime?: string | null;
        ingestedContextReferences?: {
            [key: string]: Schema$GoogleCloudDialogflowV2beta1ConversationContextReference;
        } | null;
        lifecycleState?: string | null;
        name?: string | null;
        phoneNumber?: Schema$GoogleCloudDialogflowV2beta1ConversationPhoneNumber;
        startTime?: string | null;
        telephonyConnectionInfo?: Schema$GoogleCloudDialogflowV2beta1ConversationTelephonyConnectionInfo;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ConversationContext {
        messageEntries?: Schema$GoogleCloudDialogflowV2beta1MessageEntry[];
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ConversationContextReference {
        contextContents?: Schema$GoogleCloudDialogflowV2beta1ConversationContextReferenceContextContent[];
        createTime?: string | null;
        languageCode?: string | null;
        updateMode?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ConversationContextReferenceContextContent {
        answerRecord?: string | null;
        content?: string | null;
        contentFormat?: string | null;
        ingestionTime?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ConversationEvent {
        conversation?: string | null;
        errorStatus?: Schema$GoogleRpcStatus;
        newMessagePayload?: Schema$GoogleCloudDialogflowV2beta1Message;
        newRecognitionResultPayload?: Schema$GoogleCloudDialogflowV2beta1StreamingRecognitionResult;
        type?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ConversationPhoneNumber {
        countryCode?: number | null;
        phoneNumber?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ConversationProfile {
        automatedAgentConfig?: Schema$GoogleCloudDialogflowV2beta1AutomatedAgentConfig;
        createTime?: string | null;
        displayName?: string | null;
        humanAgentAssistantConfig?: Schema$GoogleCloudDialogflowV2beta1HumanAgentAssistantConfig;
        humanAgentHandoffConfig?: Schema$GoogleCloudDialogflowV2beta1HumanAgentHandoffConfig;
        languageCode?: string | null;
        loggingConfig?: Schema$GoogleCloudDialogflowV2beta1LoggingConfig;
        name?: string | null;
        newMessageEventNotificationConfig?: Schema$GoogleCloudDialogflowV2beta1NotificationConfig;
        newRecognitionResultNotificationConfig?: Schema$GoogleCloudDialogflowV2beta1NotificationConfig;
        notificationConfig?: Schema$GoogleCloudDialogflowV2beta1NotificationConfig;
        securitySettings?: string | null;
        sttConfig?: Schema$GoogleCloudDialogflowV2beta1SpeechToTextConfig;
        timeZone?: string | null;
        ttsConfig?: Schema$GoogleCloudDialogflowV2beta1SynthesizeSpeechConfig;
        updateTime?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ConversationTelephonyConnectionInfo {
        dialedNumber?: string | null;
        extraMimeContents?: Schema$GoogleCloudDialogflowV2beta1ConversationTelephonyConnectionInfoMimeContent[];
        sdp?: string | null;
        sipHeaders?: Schema$GoogleCloudDialogflowV2beta1ConversationTelephonyConnectionInfoSipHeader[];
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ConversationTelephonyConnectionInfoMimeContent {
        content?: string | null;
        mimeType?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ConversationTelephonyConnectionInfoSipHeader {
        name?: string | null;
        value?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1CreateMessageRequest {
        message?: Schema$GoogleCloudDialogflowV2beta1Message;
        parent?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1CustomPronunciationParams {
        phoneticEncoding?: string | null;
        phrase?: string | null;
        pronunciation?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1DetectIntentRequest {
        inputAudio?: string | null;
        outputAudioConfig?: Schema$GoogleCloudDialogflowV2beta1OutputAudioConfig;
        outputAudioConfigMask?: string | null;
        queryInput?: Schema$GoogleCloudDialogflowV2beta1QueryInput;
        queryParams?: Schema$GoogleCloudDialogflowV2beta1QueryParameters;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1DetectIntentResponse {
        alternativeQueryResults?: Schema$GoogleCloudDialogflowV2beta1QueryResult[];
        outputAudio?: string | null;
        outputAudioConfig?: Schema$GoogleCloudDialogflowV2beta1OutputAudioConfig;
        queryResult?: Schema$GoogleCloudDialogflowV2beta1QueryResult;
        responseId?: string | null;
        webhookStatus?: Schema$GoogleRpcStatus;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1DialogflowAssistAnswer {
        answerRecord?: string | null;
        intentSuggestion?: Schema$GoogleCloudDialogflowV2beta1IntentSuggestion;
        queryResult?: Schema$GoogleCloudDialogflowV2beta1QueryResult;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1Document {
        content?: string | null;
        contentUri?: string | null;
        displayName?: string | null;
        enableAutoReload?: boolean | null;
        knowledgeTypes?: string[] | null;
        latestReloadStatus?: Schema$GoogleCloudDialogflowV2beta1DocumentReloadStatus;
        metadata?: {
            [key: string]: string;
        } | null;
        mimeType?: string | null;
        name?: string | null;
        rawContent?: string | null;
        state?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1DocumentReloadStatus {
        status?: Schema$GoogleRpcStatus;
        time?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1DtmfParameters {
        acceptsDtmfInput?: boolean | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1EncryptionSpec {
        kmsKey?: string | null;
        name?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1EntityType {
        autoExpansionMode?: string | null;
        displayName?: string | null;
        enableFuzzyExtraction?: boolean | null;
        entities?: Schema$GoogleCloudDialogflowV2beta1EntityTypeEntity[];
        kind?: string | null;
        name?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1EntityTypeBatch {
        entityTypes?: Schema$GoogleCloudDialogflowV2beta1EntityType[];
    }
    export interface Schema$GoogleCloudDialogflowV2beta1EntityTypeEntity {
        synonyms?: string[] | null;
        value?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1Environment {
        agentVersion?: string | null;
        description?: string | null;
        fulfillment?: Schema$GoogleCloudDialogflowV2beta1Fulfillment;
        name?: string | null;
        state?: string | null;
        textToSpeechSettings?: Schema$GoogleCloudDialogflowV2beta1TextToSpeechSettings;
        updateTime?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1EnvironmentHistory {
        entries?: Schema$GoogleCloudDialogflowV2beta1EnvironmentHistoryEntry[];
        nextPageToken?: string | null;
        parent?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1EnvironmentHistoryEntry {
        agentVersion?: string | null;
        createTime?: string | null;
        description?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1EvaluationStatus {
        done?: boolean | null;
        pipelineStatus?: Schema$GoogleRpcStatus;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1EventInput {
        languageCode?: string | null;
        name?: string | null;
        parameters?: {
            [key: string]: any;
        } | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ExportAgentRequest {
        agentUri?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ExportAgentResponse {
        agentContent?: string | null;
        agentUri?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ExportOperationMetadata {
        exportedGcsDestination?: Schema$GoogleCloudDialogflowV2beta1GcsDestination;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1FaqAnswer {
        answer?: string | null;
        answerRecord?: string | null;
        confidence?: number | null;
        metadata?: {
            [key: string]: string;
        } | null;
        question?: string | null;
        source?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1FewShotExample {
        conversationContext?: Schema$GoogleCloudDialogflowV2beta1ConversationContext;
        extraInfo?: {
            [key: string]: string;
        } | null;
        output?: Schema$GoogleCloudDialogflowV2beta1GeneratorSuggestion;
        summarizationSectionList?: Schema$GoogleCloudDialogflowV2beta1SummarizationSectionList;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1FreeFormContext {
        text?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1FreeFormSuggestion {
        response?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1Fulfillment {
        displayName?: string | null;
        enabled?: boolean | null;
        features?: Schema$GoogleCloudDialogflowV2beta1FulfillmentFeature[];
        genericWebService?: Schema$GoogleCloudDialogflowV2beta1FulfillmentGenericWebService;
        name?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1FulfillmentFeature {
        type?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1FulfillmentGenericWebService {
        isCloudFunction?: boolean | null;
        password?: string | null;
        requestHeaders?: {
            [key: string]: string;
        } | null;
        uri?: string | null;
        username?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1GcsDestination {
        uri?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1GcsSource {
        uri?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1GcsSources {
        uris?: string[] | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1GenerateStatelessSuggestionRequest {
        contextReferences?: {
            [key: string]: Schema$GoogleCloudDialogflowV2beta1ConversationContextReference;
        } | null;
        conversationContext?: Schema$GoogleCloudDialogflowV2beta1ConversationContext;
        generator?: Schema$GoogleCloudDialogflowV2beta1Generator;
        generatorName?: string | null;
        securitySettings?: string | null;
        triggerEvents?: string[] | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1GenerateStatelessSuggestionResponse {
        generatorSuggestion?: Schema$GoogleCloudDialogflowV2beta1GeneratorSuggestion;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1GenerateStatelessSummaryRequest {
        conversationProfile?: Schema$GoogleCloudDialogflowV2beta1ConversationProfile;
        latestMessage?: string | null;
        maxContextSize?: number | null;
        statelessConversation?: Schema$GoogleCloudDialogflowV2beta1GenerateStatelessSummaryRequestMinimalConversation;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1GenerateStatelessSummaryRequestMinimalConversation {
        messages?: Schema$GoogleCloudDialogflowV2beta1Message[];
    }
    export interface Schema$GoogleCloudDialogflowV2beta1GenerateStatelessSummaryResponse {
        contextSize?: number | null;
        latestMessage?: string | null;
        summary?: Schema$GoogleCloudDialogflowV2beta1GenerateStatelessSummaryResponseSummary;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1GenerateStatelessSummaryResponseSummary {
        baselineModelVersion?: string | null;
        text?: string | null;
        textSections?: {
            [key: string]: string;
        } | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1GenerateSuggestionsRequest {
        latestMessage?: string | null;
        triggerEvents?: string[] | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1GenerateSuggestionsResponse {
        generatorSuggestionAnswers?: Schema$GoogleCloudDialogflowV2beta1GenerateSuggestionsResponseGeneratorSuggestionAnswer[];
        latestMessage?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1GenerateSuggestionsResponseGeneratorSuggestionAnswer {
        answerRecord?: string | null;
        generatorSuggestion?: Schema$GoogleCloudDialogflowV2beta1GeneratorSuggestion;
        sourceGenerator?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1Generator {
        agentCoachingContext?: Schema$GoogleCloudDialogflowV2beta1AgentCoachingContext;
        createTime?: string | null;
        description?: string | null;
        freeFormContext?: Schema$GoogleCloudDialogflowV2beta1FreeFormContext;
        inferenceParameter?: Schema$GoogleCloudDialogflowV2beta1InferenceParameter;
        name?: string | null;
        publishedModel?: string | null;
        suggestionDedupingConfig?: Schema$GoogleCloudDialogflowV2beta1SuggestionDedupingConfig;
        summarizationContext?: Schema$GoogleCloudDialogflowV2beta1SummarizationContext;
        tools?: string[] | null;
        triggerEvent?: string | null;
        updateTime?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1GeneratorEvaluation {
        completeTime?: string | null;
        createTime?: string | null;
        displayName?: string | null;
        evaluationStatus?: Schema$GoogleCloudDialogflowV2beta1EvaluationStatus;
        generatorEvaluationConfig?: Schema$GoogleCloudDialogflowV2beta1GeneratorEvaluationConfig;
        initialGenerator?: Schema$GoogleCloudDialogflowV2beta1Generator;
        name?: string | null;
        satisfiesPzi?: boolean | null;
        satisfiesPzs?: boolean | null;
        summarizationMetrics?: Schema$GoogleCloudDialogflowV2beta1SummarizationEvaluationMetrics;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1GeneratorEvaluationConfig {
        inputDataConfig?: Schema$GoogleCloudDialogflowV2beta1GeneratorEvaluationConfigInputDataConfig;
        outputGcsBucketPath?: string | null;
        summarizationConfig?: Schema$GoogleCloudDialogflowV2beta1GeneratorEvaluationConfigSummarizationConfig;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1GeneratorEvaluationConfigAgentAssistInputDataConfig {
        endTime?: string | null;
        startTime?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1GeneratorEvaluationConfigDatasetInputDataConfig {
        dataset?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1GeneratorEvaluationConfigInputDataConfig {
        agentAssistInputDataConfig?: Schema$GoogleCloudDialogflowV2beta1GeneratorEvaluationConfigAgentAssistInputDataConfig;
        datasetInputDataConfig?: Schema$GoogleCloudDialogflowV2beta1GeneratorEvaluationConfigDatasetInputDataConfig;
        endTime?: string | null;
        inputDataSourceType?: string | null;
        isSummaryGenerationAllowed?: boolean | null;
        sampleSize?: number | null;
        startTime?: string | null;
        summaryGenerationOption?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1GeneratorEvaluationConfigSummarizationConfig {
        accuracyEvaluationVersion?: string | null;
        completenessEvaluationVersion?: string | null;
        enableAccuracyEvaluation?: boolean | null;
        enableCompletenessEvaluation?: boolean | null;
        evaluatorVersion?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1GeneratorSuggestion {
        agentCoachingSuggestion?: Schema$GoogleCloudDialogflowV2beta1AgentCoachingSuggestion;
        freeFormSuggestion?: Schema$GoogleCloudDialogflowV2beta1FreeFormSuggestion;
        summarySuggestion?: Schema$GoogleCloudDialogflowV2beta1SummarySuggestion;
        toolCallInfo?: Schema$GoogleCloudDialogflowV2beta1GeneratorSuggestionToolCallInfo[];
    }
    export interface Schema$GoogleCloudDialogflowV2beta1GeneratorSuggestionToolCallInfo {
        toolCall?: Schema$GoogleCloudDialogflowV2beta1ToolCall;
        toolCallResult?: Schema$GoogleCloudDialogflowV2beta1ToolCallResult;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1HumanAgentAssistantConfig {
        endUserSuggestionConfig?: Schema$GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionConfig;
        humanAgentSuggestionConfig?: Schema$GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionConfig;
        messageAnalysisConfig?: Schema$GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigMessageAnalysisConfig;
        notificationConfig?: Schema$GoogleCloudDialogflowV2beta1NotificationConfig;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigConversationModelConfig {
        baselineModelVersion?: string | null;
        model?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigConversationProcessConfig {
        recentSentencesCount?: number | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigMessageAnalysisConfig {
        enableEntityExtraction?: boolean | null;
        enableSentimentAnalysis?: boolean | null;
        enableSentimentAnalysisV3?: boolean | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionConfig {
        disableHighLatencyFeaturesSyncDelivery?: boolean | null;
        enableAsyncToolCall?: boolean | null;
        featureConfigs?: Schema$GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionFeatureConfig[];
        generators?: string[] | null;
        groupSuggestionResponses?: boolean | null;
        skipEmptyEventBasedSuggestion?: boolean | null;
        useUnredactedConversationData?: boolean | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionFeatureConfig {
        conversationModelConfig?: Schema$GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigConversationModelConfig;
        conversationProcessConfig?: Schema$GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigConversationProcessConfig;
        disableAgentQueryLogging?: boolean | null;
        enableConversationAugmentedQuery?: boolean | null;
        enableEventBasedSuggestion?: boolean | null;
        enableQuerySuggestionOnly?: boolean | null;
        enableQuerySuggestionWhenNoAnswer?: boolean | null;
        enableResponseDebugInfo?: boolean | null;
        queryConfig?: Schema$GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfig;
        raiSettings?: Schema$GoogleCloudDialogflowV2beta1RaiSettings;
        suggestionFeature?: Schema$GoogleCloudDialogflowV2beta1SuggestionFeature;
        suggestionTriggerSettings?: Schema$GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionTriggerSettings;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfig {
        confidenceThreshold?: number | null;
        contextFilterSettings?: Schema$GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigContextFilterSettings;
        contextSize?: number | null;
        dialogflowQuerySource?: Schema$GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigDialogflowQuerySource;
        documentQuerySource?: Schema$GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigDocumentQuerySource;
        knowledgeBaseQuerySource?: Schema$GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigKnowledgeBaseQuerySource;
        maxResults?: number | null;
        sections?: Schema$GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigSections;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigContextFilterSettings {
        dropHandoffMessages?: boolean | null;
        dropIvrMessages?: boolean | null;
        dropVirtualAgentMessages?: boolean | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigDialogflowQuerySource {
        agent?: string | null;
        humanAgentSideConfig?: Schema$GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigDialogflowQuerySourceHumanAgentSideConfig;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigDialogflowQuerySourceHumanAgentSideConfig {
        agent?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigDocumentQuerySource {
        documents?: string[] | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigKnowledgeBaseQuerySource {
        knowledgeBases?: string[] | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionQueryConfigSections {
        sectionTypes?: string[] | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionTriggerSettings {
        noSmallTalk?: boolean | null;
        onlyEndUser?: boolean | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1HumanAgentAssistantEvent {
        conversation?: string | null;
        participant?: string | null;
        suggestionResults?: Schema$GoogleCloudDialogflowV2beta1SuggestionResult[];
    }
    export interface Schema$GoogleCloudDialogflowV2beta1HumanAgentHandoffConfig {
        livePersonConfig?: Schema$GoogleCloudDialogflowV2beta1HumanAgentHandoffConfigLivePersonConfig;
        salesforceLiveAgentConfig?: Schema$GoogleCloudDialogflowV2beta1HumanAgentHandoffConfigSalesforceLiveAgentConfig;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1HumanAgentHandoffConfigLivePersonConfig {
        accountNumber?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1HumanAgentHandoffConfigSalesforceLiveAgentConfig {
        buttonId?: string | null;
        deploymentId?: string | null;
        endpointDomain?: string | null;
        organizationId?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ImportAgentRequest {
        agentContent?: string | null;
        agentUri?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ImportDocumentsRequest {
        documentTemplate?: Schema$GoogleCloudDialogflowV2beta1ImportDocumentTemplate;
        gcsSource?: Schema$GoogleCloudDialogflowV2beta1GcsSources;
        importGcsCustomMetadata?: boolean | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ImportDocumentsResponse {
        warnings?: Schema$GoogleRpcStatus[];
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ImportDocumentTemplate {
        knowledgeTypes?: string[] | null;
        metadata?: {
            [key: string]: string;
        } | null;
        mimeType?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1InferenceParameter {
        maxOutputTokens?: number | null;
        temperature?: number | null;
        topK?: number | null;
        topP?: number | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1IngestContextReferencesRequest {
        contextReferences?: {
            [key: string]: Schema$GoogleCloudDialogflowV2beta1ConversationContextReference;
        } | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1IngestContextReferencesResponse {
        ingestedContextReferences?: {
            [key: string]: Schema$GoogleCloudDialogflowV2beta1ConversationContextReference;
        } | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1IngestedContextReferenceDebugInfo {
        contextReferenceRetrieved?: boolean | null;
        ingestedParametersDebugInfo?: Schema$GoogleCloudDialogflowV2beta1IngestedContextReferenceDebugInfoIngestedParameterDebugInfo[];
        projectNotAllowlisted?: boolean | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1IngestedContextReferenceDebugInfoIngestedParameterDebugInfo {
        ingestionStatus?: string | null;
        parameter?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1InitializeEncryptionSpecMetadata {
        request?: Schema$GoogleCloudDialogflowV2beta1InitializeEncryptionSpecRequest;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1InitializeEncryptionSpecRequest {
        encryptionSpec?: Schema$GoogleCloudDialogflowV2beta1EncryptionSpec;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1InputAudioConfig {
        audioEncoding?: string | null;
        bargeInConfig?: Schema$GoogleCloudDialogflowV2beta1BargeInConfig;
        defaultNoSpeechTimeout?: string | null;
        disableNoSpeechRecognizedEvent?: boolean | null;
        enableAutomaticPunctuation?: boolean | null;
        enableWordInfo?: boolean | null;
        languageCode?: string | null;
        model?: string | null;
        modelVariant?: string | null;
        optOutConformerModelMigration?: boolean | null;
        phraseHints?: string[] | null;
        phraseSets?: string[] | null;
        sampleRateHertz?: number | null;
        singleUtterance?: boolean | null;
        speechContexts?: Schema$GoogleCloudDialogflowV2beta1SpeechContext[];
    }
    export interface Schema$GoogleCloudDialogflowV2beta1Intent {
        action?: string | null;
        defaultResponsePlatforms?: string[] | null;
        displayName?: string | null;
        endInteraction?: boolean | null;
        events?: string[] | null;
        followupIntentInfo?: Schema$GoogleCloudDialogflowV2beta1IntentFollowupIntentInfo[];
        inputContextNames?: string[] | null;
        isFallback?: boolean | null;
        liveAgentHandoff?: boolean | null;
        messages?: Schema$GoogleCloudDialogflowV2beta1IntentMessage[];
        mlDisabled?: boolean | null;
        mlEnabled?: boolean | null;
        name?: string | null;
        outputContexts?: Schema$GoogleCloudDialogflowV2beta1Context[];
        parameters?: Schema$GoogleCloudDialogflowV2beta1IntentParameter[];
        parentFollowupIntentName?: string | null;
        priority?: number | null;
        resetContexts?: boolean | null;
        rootFollowupIntentName?: string | null;
        trainingPhrases?: Schema$GoogleCloudDialogflowV2beta1IntentTrainingPhrase[];
        webhookState?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1IntentBatch {
        intents?: Schema$GoogleCloudDialogflowV2beta1Intent[];
    }
    export interface Schema$GoogleCloudDialogflowV2beta1IntentFollowupIntentInfo {
        followupIntentName?: string | null;
        parentFollowupIntentName?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1IntentInput {
        intent?: string | null;
        languageCode?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1IntentMessage {
        basicCard?: Schema$GoogleCloudDialogflowV2beta1IntentMessageBasicCard;
        browseCarouselCard?: Schema$GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCard;
        card?: Schema$GoogleCloudDialogflowV2beta1IntentMessageCard;
        carouselSelect?: Schema$GoogleCloudDialogflowV2beta1IntentMessageCarouselSelect;
        image?: Schema$GoogleCloudDialogflowV2beta1IntentMessageImage;
        linkOutSuggestion?: Schema$GoogleCloudDialogflowV2beta1IntentMessageLinkOutSuggestion;
        listSelect?: Schema$GoogleCloudDialogflowV2beta1IntentMessageListSelect;
        mediaContent?: Schema$GoogleCloudDialogflowV2beta1IntentMessageMediaContent;
        payload?: {
            [key: string]: any;
        } | null;
        platform?: string | null;
        quickReplies?: Schema$GoogleCloudDialogflowV2beta1IntentMessageQuickReplies;
        rbmCarouselRichCard?: Schema$GoogleCloudDialogflowV2beta1IntentMessageRbmCarouselCard;
        rbmStandaloneRichCard?: Schema$GoogleCloudDialogflowV2beta1IntentMessageRbmStandaloneCard;
        rbmText?: Schema$GoogleCloudDialogflowV2beta1IntentMessageRbmText;
        simpleResponses?: Schema$GoogleCloudDialogflowV2beta1IntentMessageSimpleResponses;
        suggestions?: Schema$GoogleCloudDialogflowV2beta1IntentMessageSuggestions;
        tableCard?: Schema$GoogleCloudDialogflowV2beta1IntentMessageTableCard;
        telephonyPlayAudio?: Schema$GoogleCloudDialogflowV2beta1IntentMessageTelephonyPlayAudio;
        telephonySynthesizeSpeech?: Schema$GoogleCloudDialogflowV2beta1IntentMessageTelephonySynthesizeSpeech;
        telephonyTransferCall?: Schema$GoogleCloudDialogflowV2beta1IntentMessageTelephonyTransferCall;
        text?: Schema$GoogleCloudDialogflowV2beta1IntentMessageText;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1IntentMessageBasicCard {
        buttons?: Schema$GoogleCloudDialogflowV2beta1IntentMessageBasicCardButton[];
        formattedText?: string | null;
        image?: Schema$GoogleCloudDialogflowV2beta1IntentMessageImage;
        subtitle?: string | null;
        title?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1IntentMessageBasicCardButton {
        openUriAction?: Schema$GoogleCloudDialogflowV2beta1IntentMessageBasicCardButtonOpenUriAction;
        title?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1IntentMessageBasicCardButtonOpenUriAction {
        uri?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCard {
        imageDisplayOptions?: string | null;
        items?: Schema$GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItem[];
    }
    export interface Schema$GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItem {
        description?: string | null;
        footer?: string | null;
        image?: Schema$GoogleCloudDialogflowV2beta1IntentMessageImage;
        openUriAction?: Schema$GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlAction;
        title?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlAction {
        url?: string | null;
        urlTypeHint?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1IntentMessageCard {
        buttons?: Schema$GoogleCloudDialogflowV2beta1IntentMessageCardButton[];
        imageUri?: string | null;
        subtitle?: string | null;
        title?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1IntentMessageCardButton {
        postback?: string | null;
        text?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1IntentMessageCarouselSelect {
        items?: Schema$GoogleCloudDialogflowV2beta1IntentMessageCarouselSelectItem[];
    }
    export interface Schema$GoogleCloudDialogflowV2beta1IntentMessageCarouselSelectItem {
        description?: string | null;
        image?: Schema$GoogleCloudDialogflowV2beta1IntentMessageImage;
        info?: Schema$GoogleCloudDialogflowV2beta1IntentMessageSelectItemInfo;
        title?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1IntentMessageColumnProperties {
        header?: string | null;
        horizontalAlignment?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1IntentMessageImage {
        accessibilityText?: string | null;
        imageUri?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1IntentMessageLinkOutSuggestion {
        destinationName?: string | null;
        uri?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1IntentMessageListSelect {
        items?: Schema$GoogleCloudDialogflowV2beta1IntentMessageListSelectItem[];
        subtitle?: string | null;
        title?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1IntentMessageListSelectItem {
        description?: string | null;
        image?: Schema$GoogleCloudDialogflowV2beta1IntentMessageImage;
        info?: Schema$GoogleCloudDialogflowV2beta1IntentMessageSelectItemInfo;
        title?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1IntentMessageMediaContent {
        mediaObjects?: Schema$GoogleCloudDialogflowV2beta1IntentMessageMediaContentResponseMediaObject[];
        mediaType?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1IntentMessageMediaContentResponseMediaObject {
        contentUrl?: string | null;
        description?: string | null;
        icon?: Schema$GoogleCloudDialogflowV2beta1IntentMessageImage;
        largeImage?: Schema$GoogleCloudDialogflowV2beta1IntentMessageImage;
        name?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1IntentMessageQuickReplies {
        quickReplies?: string[] | null;
        title?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1IntentMessageRbmCardContent {
        description?: string | null;
        media?: Schema$GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentRbmMedia;
        suggestions?: Schema$GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestion[];
        title?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1IntentMessageRbmCardContentRbmMedia {
        fileUri?: string | null;
        height?: string | null;
        thumbnailUri?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1IntentMessageRbmCarouselCard {
        cardContents?: Schema$GoogleCloudDialogflowV2beta1IntentMessageRbmCardContent[];
        cardWidth?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1IntentMessageRbmStandaloneCard {
        cardContent?: Schema$GoogleCloudDialogflowV2beta1IntentMessageRbmCardContent;
        cardOrientation?: string | null;
        thumbnailImageAlignment?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedAction {
        dial?: Schema$GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionDial;
        openUrl?: Schema$GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionOpenUri;
        postbackData?: string | null;
        shareLocation?: Schema$GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionShareLocation;
        text?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionDial {
        phoneNumber?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionOpenUri {
        uri?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedActionRbmSuggestedActionShareLocation {
    }
    export interface Schema$GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedReply {
        postbackData?: string | null;
        text?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestion {
        action?: Schema$GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedAction;
        reply?: Schema$GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestedReply;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1IntentMessageRbmText {
        rbmSuggestion?: Schema$GoogleCloudDialogflowV2beta1IntentMessageRbmSuggestion[];
        text?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1IntentMessageSelectItemInfo {
        key?: string | null;
        synonyms?: string[] | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1IntentMessageSimpleResponse {
        displayText?: string | null;
        ssml?: string | null;
        textToSpeech?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1IntentMessageSimpleResponses {
        simpleResponses?: Schema$GoogleCloudDialogflowV2beta1IntentMessageSimpleResponse[];
    }
    export interface Schema$GoogleCloudDialogflowV2beta1IntentMessageSuggestion {
        title?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1IntentMessageSuggestions {
        suggestions?: Schema$GoogleCloudDialogflowV2beta1IntentMessageSuggestion[];
    }
    export interface Schema$GoogleCloudDialogflowV2beta1IntentMessageTableCard {
        buttons?: Schema$GoogleCloudDialogflowV2beta1IntentMessageBasicCardButton[];
        columnProperties?: Schema$GoogleCloudDialogflowV2beta1IntentMessageColumnProperties[];
        image?: Schema$GoogleCloudDialogflowV2beta1IntentMessageImage;
        rows?: Schema$GoogleCloudDialogflowV2beta1IntentMessageTableCardRow[];
        subtitle?: string | null;
        title?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1IntentMessageTableCardCell {
        text?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1IntentMessageTableCardRow {
        cells?: Schema$GoogleCloudDialogflowV2beta1IntentMessageTableCardCell[];
        dividerAfter?: boolean | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1IntentMessageTelephonyPlayAudio {
        audioUri?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1IntentMessageTelephonySynthesizeSpeech {
        ssml?: string | null;
        text?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1IntentMessageTelephonyTransferCall {
        phoneNumber?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1IntentMessageText {
        text?: string[] | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1IntentParameter {
        defaultValue?: string | null;
        displayName?: string | null;
        entityTypeDisplayName?: string | null;
        isList?: boolean | null;
        mandatory?: boolean | null;
        name?: string | null;
        prompts?: string[] | null;
        value?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1IntentSuggestion {
        description?: string | null;
        displayName?: string | null;
        intentV2?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1IntentTrainingPhrase {
        name?: string | null;
        parts?: Schema$GoogleCloudDialogflowV2beta1IntentTrainingPhrasePart[];
        timesAddedCount?: number | null;
        type?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1IntentTrainingPhrasePart {
        alias?: string | null;
        entityType?: string | null;
        text?: string | null;
        userDefined?: boolean | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1KnowledgeAnswers {
        answers?: Schema$GoogleCloudDialogflowV2beta1KnowledgeAnswersAnswer[];
    }
    export interface Schema$GoogleCloudDialogflowV2beta1KnowledgeAnswersAnswer {
        answer?: string | null;
        faqQuestion?: string | null;
        matchConfidence?: number | null;
        matchConfidenceLevel?: string | null;
        source?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1KnowledgeAssistAnswer {
        answerRecord?: string | null;
        knowledgeAssistDebugInfo?: Schema$GoogleCloudDialogflowV2beta1KnowledgeAssistDebugInfo;
        suggestedQuery?: Schema$GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerSuggestedQuery;
        suggestedQueryAnswer?: Schema$GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswer;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswer {
        answerText?: string | null;
        faqSource?: Schema$GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswerFaqSource;
        generativeSource?: Schema$GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswerGenerativeSource;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswerFaqSource {
        question?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswerGenerativeSource {
        snippets?: Schema$GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswerGenerativeSourceSnippet[];
    }
    export interface Schema$GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerKnowledgeAnswerGenerativeSourceSnippet {
        metadata?: {
            [key: string]: any;
        } | null;
        text?: string | null;
        title?: string | null;
        uri?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1KnowledgeAssistAnswerSuggestedQuery {
        queryText?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1KnowledgeAssistDebugInfo {
        datastoreResponseReason?: string | null;
        ingestedContextReferenceDebugInfo?: Schema$GoogleCloudDialogflowV2beta1IngestedContextReferenceDebugInfo;
        knowledgeAssistBehavior?: Schema$GoogleCloudDialogflowV2beta1KnowledgeAssistDebugInfoKnowledgeAssistBehavior;
        queryCategorizationFailureReason?: string | null;
        queryGenerationFailureReason?: string | null;
        serviceLatency?: Schema$GoogleCloudDialogflowV2beta1ServiceLatency;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1KnowledgeAssistDebugInfoKnowledgeAssistBehavior {
        answerGenerationRewriterOn?: boolean | null;
        appendedSearchContextCount?: number | null;
        conversationTranscriptHasMixedLanguages?: boolean | null;
        disableSyncDelivery?: boolean | null;
        endUserMetadataIncluded?: boolean | null;
        invalidItemsQuerySuggestionSkipped?: boolean | null;
        multipleQueriesGenerated?: boolean | null;
        previousQueriesIncluded?: boolean | null;
        primaryQueryRedactedAndReplaced?: boolean | null;
        queryContainedSearchContext?: boolean | null;
        queryGenerationAgentLanguageMismatch?: boolean | null;
        queryGenerationEndUserLanguageMismatch?: boolean | null;
        returnQueryOnly?: boolean | null;
        thirdPartyConnectorAllowed?: boolean | null;
        useCustomSafetyFilterLevel?: boolean | null;
        usePubsubDelivery?: boolean | null;
        useTranslatedMessage?: boolean | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1KnowledgeBase {
        displayName?: string | null;
        languageCode?: string | null;
        name?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1KnowledgeOperationMetadata {
        doneTime?: string | null;
        exportOperationMetadata?: Schema$GoogleCloudDialogflowV2beta1ExportOperationMetadata;
        knowledgeBase?: string | null;
        state?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ListAnswerRecordsResponse {
        answerRecords?: Schema$GoogleCloudDialogflowV2beta1AnswerRecord[];
        nextPageToken?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ListContextsResponse {
        contexts?: Schema$GoogleCloudDialogflowV2beta1Context[];
        nextPageToken?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ListConversationProfilesResponse {
        conversationProfiles?: Schema$GoogleCloudDialogflowV2beta1ConversationProfile[];
        nextPageToken?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ListConversationsResponse {
        conversations?: Schema$GoogleCloudDialogflowV2beta1Conversation[];
        nextPageToken?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ListDocumentsResponse {
        documents?: Schema$GoogleCloudDialogflowV2beta1Document[];
        nextPageToken?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ListEntityTypesResponse {
        entityTypes?: Schema$GoogleCloudDialogflowV2beta1EntityType[];
        nextPageToken?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ListEnvironmentsResponse {
        environments?: Schema$GoogleCloudDialogflowV2beta1Environment[];
        nextPageToken?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ListGeneratorEvaluationsResponse {
        generatorEvaluations?: Schema$GoogleCloudDialogflowV2beta1GeneratorEvaluation[];
        nextPageToken?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ListGeneratorsResponse {
        generators?: Schema$GoogleCloudDialogflowV2beta1Generator[];
        nextPageToken?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ListIntentsResponse {
        intents?: Schema$GoogleCloudDialogflowV2beta1Intent[];
        nextPageToken?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ListKnowledgeBasesResponse {
        knowledgeBases?: Schema$GoogleCloudDialogflowV2beta1KnowledgeBase[];
        nextPageToken?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ListMessagesResponse {
        messages?: Schema$GoogleCloudDialogflowV2beta1Message[];
        nextPageToken?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ListParticipantsResponse {
        nextPageToken?: string | null;
        participants?: Schema$GoogleCloudDialogflowV2beta1Participant[];
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ListPhoneNumbersResponse {
        nextPageToken?: string | null;
        phoneNumbers?: Schema$GoogleCloudDialogflowV2beta1PhoneNumber[];
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ListSessionEntityTypesResponse {
        nextPageToken?: string | null;
        sessionEntityTypes?: Schema$GoogleCloudDialogflowV2beta1SessionEntityType[];
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ListSipTrunksResponse {
        nextPageToken?: string | null;
        sipTrunks?: Schema$GoogleCloudDialogflowV2beta1SipTrunk[];
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ListSuggestionsResponse {
        nextPageToken?: string | null;
        suggestions?: Schema$GoogleCloudDialogflowV2beta1Suggestion[];
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ListToolsResponse {
        nextPageToken?: string | null;
        tools?: Schema$GoogleCloudDialogflowV2beta1Tool[];
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ListVersionsResponse {
        nextPageToken?: string | null;
        versions?: Schema$GoogleCloudDialogflowV2beta1Version[];
    }
    export interface Schema$GoogleCloudDialogflowV2beta1LoggingConfig {
        enableStackdriverLogging?: boolean | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1Message {
        content?: string | null;
        createTime?: string | null;
        languageCode?: string | null;
        messageAnnotation?: Schema$GoogleCloudDialogflowV2beta1MessageAnnotation;
        name?: string | null;
        participant?: string | null;
        participantRole?: string | null;
        responseMessages?: Schema$GoogleCloudDialogflowV2beta1ResponseMessage[];
        sendTime?: string | null;
        sentimentAnalysis?: Schema$GoogleCloudDialogflowV2beta1SentimentAnalysisResult;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1MessageAnnotation {
        containEntities?: boolean | null;
        parts?: Schema$GoogleCloudDialogflowV2beta1AnnotatedMessagePart[];
    }
    export interface Schema$GoogleCloudDialogflowV2beta1MessageEntry {
        createTime?: string | null;
        languageCode?: string | null;
        role?: string | null;
        text?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1NotificationConfig {
        messageFormat?: string | null;
        topic?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1OriginalDetectIntentRequest {
        payload?: {
            [key: string]: any;
        } | null;
        source?: string | null;
        version?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1OutputAudio {
        audio?: string | null;
        config?: Schema$GoogleCloudDialogflowV2beta1OutputAudioConfig;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1OutputAudioConfig {
        audioEncoding?: string | null;
        sampleRateHertz?: number | null;
        synthesizeSpeechConfig?: Schema$GoogleCloudDialogflowV2beta1SynthesizeSpeechConfig;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1Participant {
        agentDesktopSource?: string | null;
        documentsMetadataFilters?: {
            [key: string]: string;
        } | null;
        name?: string | null;
        obfuscatedExternalUserId?: string | null;
        role?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1PhoneNumber {
        conversationProfile?: string | null;
        lifecycleState?: string | null;
        name?: string | null;
        phoneNumber?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1QueryInput {
        audioConfig?: Schema$GoogleCloudDialogflowV2beta1InputAudioConfig;
        dtmf?: Schema$GoogleCloudDialogflowV2beta1TelephonyDtmfEvents;
        event?: Schema$GoogleCloudDialogflowV2beta1EventInput;
        text?: Schema$GoogleCloudDialogflowV2beta1TextInput;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1QueryParameters {
        contexts?: Schema$GoogleCloudDialogflowV2beta1Context[];
        geoLocation?: Schema$GoogleTypeLatLng;
        knowledgeBaseNames?: string[] | null;
        payload?: {
            [key: string]: any;
        } | null;
        platform?: string | null;
        resetContexts?: boolean | null;
        sentimentAnalysisRequestConfig?: Schema$GoogleCloudDialogflowV2beta1SentimentAnalysisRequestConfig;
        sessionEntityTypes?: Schema$GoogleCloudDialogflowV2beta1SessionEntityType[];
        subAgents?: Schema$GoogleCloudDialogflowV2beta1SubAgent[];
        timeZone?: string | null;
        webhookHeaders?: {
            [key: string]: string;
        } | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1QueryResult {
        action?: string | null;
        allRequiredParamsPresent?: boolean | null;
        cancelsSlotFilling?: boolean | null;
        diagnosticInfo?: {
            [key: string]: any;
        } | null;
        fulfillmentMessages?: Schema$GoogleCloudDialogflowV2beta1IntentMessage[];
        fulfillmentText?: string | null;
        intent?: Schema$GoogleCloudDialogflowV2beta1Intent;
        intentDetectionConfidence?: number | null;
        knowledgeAnswers?: Schema$GoogleCloudDialogflowV2beta1KnowledgeAnswers;
        languageCode?: string | null;
        outputContexts?: Schema$GoogleCloudDialogflowV2beta1Context[];
        parameters?: {
            [key: string]: any;
        } | null;
        queryText?: string | null;
        sentimentAnalysisResult?: Schema$GoogleCloudDialogflowV2beta1SentimentAnalysisResult;
        speechRecognitionConfidence?: number | null;
        webhookPayload?: {
            [key: string]: any;
        } | null;
        webhookSource?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1RaiSettings {
        raiCategoryConfigs?: Schema$GoogleCloudDialogflowV2beta1RaiSettingsRaiCategoryConfig[];
    }
    export interface Schema$GoogleCloudDialogflowV2beta1RaiSettingsRaiCategoryConfig {
        category?: string | null;
        sensitivityLevel?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ReloadDocumentRequest {
        gcsSource?: Schema$GoogleCloudDialogflowV2beta1GcsSource;
        importGcsCustomMetadata?: boolean | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ResponseMessage {
        endInteraction?: Schema$GoogleCloudDialogflowV2beta1ResponseMessageEndInteraction;
        liveAgentHandoff?: Schema$GoogleCloudDialogflowV2beta1ResponseMessageLiveAgentHandoff;
        mixedAudio?: Schema$GoogleCloudDialogflowV2beta1ResponseMessageMixedAudio;
        payload?: {
            [key: string]: any;
        } | null;
        telephonyTransferCall?: Schema$GoogleCloudDialogflowV2beta1ResponseMessageTelephonyTransferCall;
        text?: Schema$GoogleCloudDialogflowV2beta1ResponseMessageText;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ResponseMessageEndInteraction {
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ResponseMessageLiveAgentHandoff {
        metadata?: {
            [key: string]: any;
        } | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ResponseMessageMixedAudio {
        segments?: Schema$GoogleCloudDialogflowV2beta1ResponseMessageMixedAudioSegment[];
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ResponseMessageMixedAudioSegment {
        allowPlaybackInterruption?: boolean | null;
        audio?: string | null;
        uri?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ResponseMessageTelephonyTransferCall {
        phoneNumber?: string | null;
        sipUri?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ResponseMessageText {
        text?: string[] | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1RestoreAgentRequest {
        agentContent?: string | null;
        agentUri?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SearchAgentsResponse {
        agents?: Schema$GoogleCloudDialogflowV2beta1Agent[];
        nextPageToken?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SearchKnowledgeAnswer {
        answer?: string | null;
        answerRecord?: string | null;
        answerSources?: Schema$GoogleCloudDialogflowV2beta1SearchKnowledgeAnswerAnswerSource[];
        answerType?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SearchKnowledgeAnswerAnswerSource {
        metadata?: {
            [key: string]: any;
        } | null;
        snippet?: string | null;
        title?: string | null;
        uri?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SearchKnowledgeDebugInfo {
        datastoreResponseReason?: string | null;
        ingestedContextReferenceDebugInfo?: Schema$GoogleCloudDialogflowV2beta1IngestedContextReferenceDebugInfo;
        searchKnowledgeBehavior?: Schema$GoogleCloudDialogflowV2beta1SearchKnowledgeDebugInfoSearchKnowledgeBehavior;
        serviceLatency?: Schema$GoogleCloudDialogflowV2beta1ServiceLatency;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SearchKnowledgeDebugInfoSearchKnowledgeBehavior {
        answerGenerationRewriterOn?: boolean | null;
        endUserMetadataIncluded?: boolean | null;
        thirdPartyConnectorAllowed?: boolean | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SearchKnowledgeRequest {
        conversation?: string | null;
        conversationProfile?: string | null;
        endUserMetadata?: {
            [key: string]: any;
        } | null;
        exactSearch?: boolean | null;
        latestMessage?: string | null;
        parent?: string | null;
        query?: Schema$GoogleCloudDialogflowV2beta1TextInput;
        querySource?: string | null;
        searchConfig?: Schema$GoogleCloudDialogflowV2beta1SearchKnowledgeRequestSearchConfig;
        sessionId?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SearchKnowledgeRequestSearchConfig {
        boostSpecs?: Schema$GoogleCloudDialogflowV2beta1SearchKnowledgeRequestSearchConfigBoostSpecs[];
        filterSpecs?: Schema$GoogleCloudDialogflowV2beta1SearchKnowledgeRequestSearchConfigFilterSpecs[];
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SearchKnowledgeRequestSearchConfigBoostSpecs {
        dataStores?: string[] | null;
        spec?: Schema$GoogleCloudDialogflowV2beta1SearchKnowledgeRequestSearchConfigBoostSpecsBoostSpec[];
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SearchKnowledgeRequestSearchConfigBoostSpecsBoostSpec {
        conditionBoostSpecs?: Schema$GoogleCloudDialogflowV2beta1SearchKnowledgeRequestSearchConfigBoostSpecsBoostSpecConditionBoostSpec[];
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SearchKnowledgeRequestSearchConfigBoostSpecsBoostSpecConditionBoostSpec {
        boost?: number | null;
        boostControlSpec?: Schema$GoogleCloudDialogflowV2beta1SearchKnowledgeRequestSearchConfigBoostSpecsBoostSpecConditionBoostSpecBoostControlSpec;
        condition?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SearchKnowledgeRequestSearchConfigBoostSpecsBoostSpecConditionBoostSpecBoostControlSpec {
        attributeType?: string | null;
        controlPoints?: Schema$GoogleCloudDialogflowV2beta1SearchKnowledgeRequestSearchConfigBoostSpecsBoostSpecConditionBoostSpecBoostControlSpecControlPoint[];
        fieldName?: string | null;
        interpolationType?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SearchKnowledgeRequestSearchConfigBoostSpecsBoostSpecConditionBoostSpecBoostControlSpecControlPoint {
        attributeValue?: string | null;
        boostAmount?: number | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SearchKnowledgeRequestSearchConfigFilterSpecs {
        dataStores?: string[] | null;
        filter?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SearchKnowledgeResponse {
        answers?: Schema$GoogleCloudDialogflowV2beta1SearchKnowledgeAnswer[];
        rewrittenQuery?: string | null;
        searchKnowledgeDebugInfo?: Schema$GoogleCloudDialogflowV2beta1SearchKnowledgeDebugInfo;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1Sentiment {
        magnitude?: number | null;
        score?: number | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SentimentAnalysisRequestConfig {
        analyzeQueryTextSentiment?: boolean | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SentimentAnalysisResult {
        queryTextSentiment?: Schema$GoogleCloudDialogflowV2beta1Sentiment;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ServiceLatency {
        internalServiceLatencies?: Schema$GoogleCloudDialogflowV2beta1ServiceLatencyInternalServiceLatency[];
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ServiceLatencyInternalServiceLatency {
        completeTime?: string | null;
        latencyMs?: number | null;
        startTime?: string | null;
        step?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SessionEntityType {
        entities?: Schema$GoogleCloudDialogflowV2beta1EntityTypeEntity[];
        entityOverrideMode?: string | null;
        name?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SetSuggestionFeatureConfigOperationMetadata {
        conversationProfile?: string | null;
        createTime?: string | null;
        participantRole?: string | null;
        suggestionFeatureType?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SetSuggestionFeatureConfigRequest {
        participantRole?: string | null;
        suggestionFeatureConfig?: Schema$GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigSuggestionFeatureConfig;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SipTrunk {
        connections?: Schema$GoogleCloudDialogflowV2beta1Connection[];
        displayName?: string | null;
        expectedHostname?: string[] | null;
        name?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SmartReplyAnswer {
        answerRecord?: string | null;
        confidence?: number | null;
        reply?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SpeechContext {
        boost?: number | null;
        phrases?: string[] | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SpeechToTextConfig {
        audioEncoding?: string | null;
        enableWordInfo?: boolean | null;
        languageCode?: string | null;
        model?: string | null;
        phraseSets?: string[] | null;
        sampleRateHertz?: number | null;
        speechModelVariant?: string | null;
        useTimeoutBasedEndpointing?: boolean | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SpeechWordInfo {
        confidence?: number | null;
        endOffset?: string | null;
        startOffset?: string | null;
        word?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1StreamingRecognitionResult {
        confidence?: number | null;
        dtmfDigits?: Schema$GoogleCloudDialogflowV2beta1TelephonyDtmfEvents;
        isFinal?: boolean | null;
        languageCode?: string | null;
        messageType?: string | null;
        speechEndOffset?: string | null;
        speechWordInfo?: Schema$GoogleCloudDialogflowV2beta1SpeechWordInfo[];
        stability?: number | null;
        transcript?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SubAgent {
        environment?: string | null;
        project?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SuggestArticlesRequest {
        assistQueryParams?: Schema$GoogleCloudDialogflowV2beta1AssistQueryParameters;
        contextSize?: number | null;
        latestMessage?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SuggestArticlesResponse {
        articleAnswers?: Schema$GoogleCloudDialogflowV2beta1ArticleAnswer[];
        contextSize?: number | null;
        latestMessage?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SuggestConversationSummaryRequest {
        assistQueryParams?: Schema$GoogleCloudDialogflowV2beta1AssistQueryParameters;
        contextSize?: number | null;
        latestMessage?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SuggestConversationSummaryResponse {
        contextSize?: number | null;
        latestMessage?: string | null;
        summary?: Schema$GoogleCloudDialogflowV2beta1SuggestConversationSummaryResponseSummary;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SuggestConversationSummaryResponseSummary {
        answerRecord?: string | null;
        baselineModelVersion?: string | null;
        sortedTextSections?: Schema$GoogleCloudDialogflowV2beta1SuggestConversationSummaryResponseSummarySummarySection[];
        text?: string | null;
        textSections?: {
            [key: string]: string;
        } | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SuggestConversationSummaryResponseSummarySummarySection {
        section?: string | null;
        summary?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SuggestDialogflowAssistsResponse {
        contextSize?: number | null;
        dialogflowAssistAnswers?: Schema$GoogleCloudDialogflowV2beta1DialogflowAssistAnswer[];
        latestMessage?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SuggestFaqAnswersRequest {
        assistQueryParams?: Schema$GoogleCloudDialogflowV2beta1AssistQueryParameters;
        contextSize?: number | null;
        latestMessage?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SuggestFaqAnswersResponse {
        contextSize?: number | null;
        faqAnswers?: Schema$GoogleCloudDialogflowV2beta1FaqAnswer[];
        latestMessage?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1Suggestion {
        articles?: Schema$GoogleCloudDialogflowV2beta1SuggestionArticle[];
        createTime?: string | null;
        faqAnswers?: Schema$GoogleCloudDialogflowV2beta1SuggestionFaqAnswer[];
        latestMessage?: string | null;
        name?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SuggestionArticle {
        answerRecord?: string | null;
        metadata?: {
            [key: string]: string;
        } | null;
        snippets?: string[] | null;
        title?: string | null;
        uri?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SuggestionDedupingConfig {
        enableDeduping?: boolean | null;
        similarityThreshold?: number | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SuggestionFaqAnswer {
        answer?: string | null;
        answerRecord?: string | null;
        confidence?: number | null;
        metadata?: {
            [key: string]: string;
        } | null;
        question?: string | null;
        source?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SuggestionFeature {
        type?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SuggestionInput {
        action?: string | null;
        answerRecord?: string | null;
        intentInput?: Schema$GoogleCloudDialogflowV2beta1IntentInput;
        parameters?: {
            [key: string]: any;
        } | null;
        sendTime?: string | null;
        textOverride?: Schema$GoogleCloudDialogflowV2beta1TextInput;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SuggestionResult {
        error?: Schema$GoogleRpcStatus;
        generateSuggestionsResponse?: Schema$GoogleCloudDialogflowV2beta1GenerateSuggestionsResponse;
        suggestArticlesResponse?: Schema$GoogleCloudDialogflowV2beta1SuggestArticlesResponse;
        suggestDialogflowAssistsResponse?: Schema$GoogleCloudDialogflowV2beta1SuggestDialogflowAssistsResponse;
        suggestEntityExtractionResponse?: Schema$GoogleCloudDialogflowV2beta1SuggestDialogflowAssistsResponse;
        suggestFaqAnswersResponse?: Schema$GoogleCloudDialogflowV2beta1SuggestFaqAnswersResponse;
        suggestKnowledgeAssistResponse?: Schema$GoogleCloudDialogflowV2beta1SuggestKnowledgeAssistResponse;
        suggestSmartRepliesResponse?: Schema$GoogleCloudDialogflowV2beta1SuggestSmartRepliesResponse;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SuggestKnowledgeAssistRequest {
        contextSize?: number | null;
        latestMessage?: string | null;
        previousSuggestedQuery?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SuggestKnowledgeAssistResponse {
        contextSize?: number | null;
        knowledgeAssistAnswer?: Schema$GoogleCloudDialogflowV2beta1KnowledgeAssistAnswer;
        latestMessage?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SuggestSmartRepliesRequest {
        contextSize?: number | null;
        currentTextInput?: Schema$GoogleCloudDialogflowV2beta1TextInput;
        latestMessage?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SuggestSmartRepliesResponse {
        contextSize?: number | null;
        latestMessage?: string | null;
        smartReplyAnswers?: Schema$GoogleCloudDialogflowV2beta1SmartReplyAnswer[];
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SummarizationContext {
        fewShotExamples?: Schema$GoogleCloudDialogflowV2beta1FewShotExample[];
        outputLanguageCode?: string | null;
        summarizationSections?: Schema$GoogleCloudDialogflowV2beta1SummarizationSection[];
        version?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SummarizationEvaluationMetrics {
        conversationDetails?: Schema$GoogleCloudDialogflowV2beta1SummarizationEvaluationMetricsConversationDetail[];
        overallMetrics?: Schema$GoogleCloudDialogflowV2beta1SummarizationEvaluationMetricsOverallScoresByMetric[];
        overallSectionTokens?: Schema$GoogleCloudDialogflowV2beta1SummarizationEvaluationMetricsSectionToken[];
        summarizationEvaluationMergedResultsUri?: string | null;
        summarizationEvaluationResults?: Schema$GoogleCloudDialogflowV2beta1SummarizationEvaluationMetricsSummarizationEvaluationResult[];
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SummarizationEvaluationMetricsAccuracyDecomposition {
        accuracyReasoning?: string | null;
        isAccurate?: boolean | null;
        point?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SummarizationEvaluationMetricsAdherenceDecomposition {
        adherenceReasoning?: string | null;
        isAdherent?: boolean | null;
        point?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SummarizationEvaluationMetricsAdherenceRubric {
        isAddressed?: boolean | null;
        question?: string | null;
        reasoning?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SummarizationEvaluationMetricsCompletenessRubric {
        isAddressed?: boolean | null;
        question?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SummarizationEvaluationMetricsConversationDetail {
        messageEntries?: Schema$GoogleCloudDialogflowV2beta1MessageEntry[];
        metricDetails?: Schema$GoogleCloudDialogflowV2beta1SummarizationEvaluationMetricsConversationDetailMetricDetail[];
        sectionTokens?: Schema$GoogleCloudDialogflowV2beta1SummarizationEvaluationMetricsSectionToken[];
        summarySections?: Schema$GoogleCloudDialogflowV2beta1SummarySuggestionSummarySection[];
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SummarizationEvaluationMetricsConversationDetailMetricDetail {
        metric?: string | null;
        score?: number | null;
        sectionDetails?: Schema$GoogleCloudDialogflowV2beta1SummarizationEvaluationMetricsConversationDetailMetricDetailSectionDetail[];
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SummarizationEvaluationMetricsConversationDetailMetricDetailSectionDetail {
        evaluationResults?: Schema$GoogleCloudDialogflowV2beta1SummarizationEvaluationMetricsEvaluationResult[];
        score?: number | null;
        section?: string | null;
        sectionSummary?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SummarizationEvaluationMetricsDecomposition {
        accuracyDecomposition?: Schema$GoogleCloudDialogflowV2beta1SummarizationEvaluationMetricsAccuracyDecomposition;
        adherenceDecomposition?: Schema$GoogleCloudDialogflowV2beta1SummarizationEvaluationMetricsAdherenceDecomposition;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SummarizationEvaluationMetricsEvaluationResult {
        accuracyDecomposition?: Schema$GoogleCloudDialogflowV2beta1SummarizationEvaluationMetricsAccuracyDecomposition;
        adherenceRubric?: Schema$GoogleCloudDialogflowV2beta1SummarizationEvaluationMetricsAdherenceRubric;
        completenessRubric?: Schema$GoogleCloudDialogflowV2beta1SummarizationEvaluationMetricsCompletenessRubric;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SummarizationEvaluationMetricsOverallScoresByMetric {
        metric?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SummarizationEvaluationMetricsSectionToken {
        section?: string | null;
        tokenCount?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SummarizationEvaluationMetricsSummarizationEvaluationResult {
        decompositions?: Schema$GoogleCloudDialogflowV2beta1SummarizationEvaluationMetricsDecomposition[];
        evaluationResults?: Schema$GoogleCloudDialogflowV2beta1SummarizationEvaluationMetricsEvaluationResult[];
        metric?: string | null;
        score?: number | null;
        section?: string | null;
        sectionSummary?: string | null;
        sessionId?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SummarizationSection {
        definition?: string | null;
        key?: string | null;
        type?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SummarizationSectionList {
        summarizationSections?: Schema$GoogleCloudDialogflowV2beta1SummarizationSection[];
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SummarySuggestion {
        summarySections?: Schema$GoogleCloudDialogflowV2beta1SummarySuggestionSummarySection[];
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SummarySuggestionSummarySection {
        section?: string | null;
        summary?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1SynthesizeSpeechConfig {
        effectsProfileId?: string[] | null;
        pitch?: number | null;
        pronunciations?: Schema$GoogleCloudDialogflowV2beta1CustomPronunciationParams[];
        speakingRate?: number | null;
        voice?: Schema$GoogleCloudDialogflowV2beta1VoiceSelectionParams;
        volumeGainDb?: number | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1TelephonyDtmfEvents {
        dtmfEvents?: string[] | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1TextInput {
        languageCode?: string | null;
        text?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1TextToSpeechSettings {
        enableTextToSpeech?: boolean | null;
        outputAudioEncoding?: string | null;
        sampleRateHertz?: number | null;
        synthesizeSpeechConfigs?: {
            [key: string]: Schema$GoogleCloudDialogflowV2beta1SynthesizeSpeechConfig;
        } | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1Tool {
        actionConfirmationRequirement?: {
            [key: string]: string;
        } | null;
        connectorSpec?: Schema$GoogleCloudDialogflowV2beta1ToolConnectorTool;
        createTime?: string | null;
        description?: string | null;
        displayName?: string | null;
        extensionSpec?: Schema$GoogleCloudDialogflowV2beta1ToolExtensionTool;
        functionSpec?: Schema$GoogleCloudDialogflowV2beta1ToolFunctionTool;
        name?: string | null;
        openApiSpec?: Schema$GoogleCloudDialogflowV2beta1ToolOpenApiTool;
        satisfiesPzi?: boolean | null;
        satisfiesPzs?: boolean | null;
        toolKey?: string | null;
        updateTime?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ToolAuthentication {
        apiKeyConfig?: Schema$GoogleCloudDialogflowV2beta1ToolAuthenticationApiKeyConfig;
        bearerTokenConfig?: Schema$GoogleCloudDialogflowV2beta1ToolAuthenticationBearerTokenConfig;
        oauthConfig?: Schema$GoogleCloudDialogflowV2beta1ToolAuthenticationOAuthConfig;
        serviceAgentAuthConfig?: Schema$GoogleCloudDialogflowV2beta1ToolAuthenticationServiceAgentAuthConfig;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ToolAuthenticationApiKeyConfig {
        apiKey?: string | null;
        keyName?: string | null;
        requestLocation?: string | null;
        secretVersionForApiKey?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ToolAuthenticationBearerTokenConfig {
        secretVersionForToken?: string | null;
        token?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ToolAuthenticationOAuthConfig {
        clientId?: string | null;
        clientSecret?: string | null;
        oauthGrantType?: string | null;
        scopes?: string[] | null;
        secretVersionForClientSecret?: string | null;
        tokenEndpoint?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ToolAuthenticationServiceAgentAuthConfig {
        serviceAgentAuth?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ToolCall {
        action?: string | null;
        answerRecord?: string | null;
        createTime?: string | null;
        inputParameters?: {
            [key: string]: any;
        } | null;
        state?: string | null;
        tool?: string | null;
        toolDisplayDetails?: string | null;
        toolDisplayName?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ToolCallResult {
        action?: string | null;
        answerRecord?: string | null;
        content?: string | null;
        createTime?: string | null;
        error?: Schema$GoogleCloudDialogflowV2beta1ToolCallResultError;
        rawContent?: string | null;
        tool?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ToolCallResultError {
        message?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ToolConnectorTool {
        actions?: Schema$GoogleCloudDialogflowV2beta1ToolConnectorToolAction[];
        name?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ToolConnectorToolAction {
        connectionActionId?: string | null;
        entityOperation?: Schema$GoogleCloudDialogflowV2beta1ToolConnectorToolActionEntityOperation;
        inputFields?: string[] | null;
        outputFields?: string[] | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ToolConnectorToolActionEntityOperation {
        entityId?: string | null;
        operation?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ToolExtensionTool {
        name?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ToolFunctionTool {
        inputSchema?: {
            [key: string]: any;
        } | null;
        methodType?: string | null;
        outputSchema?: {
            [key: string]: any;
        } | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ToolOpenApiTool {
        authentication?: Schema$GoogleCloudDialogflowV2beta1ToolAuthentication;
        serviceDirectoryConfig?: Schema$GoogleCloudDialogflowV2beta1ToolServiceDirectoryConfig;
        textSchema?: string | null;
        tlsConfig?: Schema$GoogleCloudDialogflowV2beta1ToolTLSConfig;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ToolServiceDirectoryConfig {
        service?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ToolTLSConfig {
        caCerts?: Schema$GoogleCloudDialogflowV2beta1ToolTLSConfigCACert[];
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ToolTLSConfigCACert {
        cert?: string | null;
        displayName?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1TrainAgentRequest {
    }
    export interface Schema$GoogleCloudDialogflowV2beta1UndeletePhoneNumberRequest {
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ValidationError {
        entries?: string[] | null;
        errorMessage?: string | null;
        severity?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1ValidationResult {
        validationErrors?: Schema$GoogleCloudDialogflowV2beta1ValidationError[];
    }
    export interface Schema$GoogleCloudDialogflowV2beta1Version {
        createTime?: string | null;
        description?: string | null;
        name?: string | null;
        status?: string | null;
        versionNumber?: number | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1VoiceSelectionParams {
        name?: string | null;
        ssmlGender?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1WebhookRequest {
        alternativeQueryResults?: Schema$GoogleCloudDialogflowV2beta1QueryResult[];
        originalDetectIntentRequest?: Schema$GoogleCloudDialogflowV2beta1OriginalDetectIntentRequest;
        queryResult?: Schema$GoogleCloudDialogflowV2beta1QueryResult;
        responseId?: string | null;
        session?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2beta1WebhookResponse {
        endInteraction?: boolean | null;
        followupEventInput?: Schema$GoogleCloudDialogflowV2beta1EventInput;
        fulfillmentMessages?: Schema$GoogleCloudDialogflowV2beta1IntentMessage[];
        fulfillmentText?: string | null;
        liveAgentHandoff?: boolean | null;
        outputContexts?: Schema$GoogleCloudDialogflowV2beta1Context[];
        payload?: {
            [key: string]: any;
        } | null;
        sessionEntityTypes?: Schema$GoogleCloudDialogflowV2beta1SessionEntityType[];
        source?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2ClearSuggestionFeatureConfigOperationMetadata {
        conversationProfile?: string | null;
        createTime?: string | null;
        participantRole?: string | null;
        suggestionFeatureType?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2Context {
        lifespanCount?: number | null;
        name?: string | null;
        parameters?: {
            [key: string]: any;
        } | null;
    }
    export interface Schema$GoogleCloudDialogflowV2ConversationEvent {
        conversation?: string | null;
        errorStatus?: Schema$GoogleRpcStatus;
        newMessagePayload?: Schema$GoogleCloudDialogflowV2Message;
        newRecognitionResultPayload?: Schema$GoogleCloudDialogflowV2StreamingRecognitionResult;
        type?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2ConversationModel {
        articleSuggestionModelMetadata?: Schema$GoogleCloudDialogflowV2ArticleSuggestionModelMetadata;
        createTime?: string | null;
        datasets?: Schema$GoogleCloudDialogflowV2InputDataset[];
        displayName?: string | null;
        languageCode?: string | null;
        name?: string | null;
        satisfiesPzi?: boolean | null;
        satisfiesPzs?: boolean | null;
        smartReplyModelMetadata?: Schema$GoogleCloudDialogflowV2SmartReplyModelMetadata;
        state?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2CreateConversationDatasetOperationMetadata {
        conversationDataset?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2CreateConversationModelEvaluationOperationMetadata {
        conversationModel?: string | null;
        conversationModelEvaluation?: string | null;
        createTime?: string | null;
        state?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2CreateConversationModelOperationMetadata {
        conversationModel?: string | null;
        createTime?: string | null;
        doneTime?: string | null;
        state?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2DeleteConversationDatasetOperationMetadata {
    }
    export interface Schema$GoogleCloudDialogflowV2DeleteConversationModelOperationMetadata {
        conversationModel?: string | null;
        createTime?: string | null;
        doneTime?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2DeployConversationModelOperationMetadata {
        conversationModel?: string | null;
        createTime?: string | null;
        doneTime?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2EncryptionSpec {
        kmsKey?: string | null;
        name?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2EntityType {
        autoExpansionMode?: string | null;
        displayName?: string | null;
        enableFuzzyExtraction?: boolean | null;
        entities?: Schema$GoogleCloudDialogflowV2EntityTypeEntity[];
        kind?: string | null;
        name?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2EntityTypeEntity {
        synonyms?: string[] | null;
        value?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2EventInput {
        languageCode?: string | null;
        name?: string | null;
        parameters?: {
            [key: string]: any;
        } | null;
    }
    export interface Schema$GoogleCloudDialogflowV2ExportAgentResponse {
        agentContent?: string | null;
        agentUri?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2ExportOperationMetadata {
        exportedGcsDestination?: Schema$GoogleCloudDialogflowV2GcsDestination;
    }
    export interface Schema$GoogleCloudDialogflowV2FaqAnswer {
        answer?: string | null;
        answerRecord?: string | null;
        confidence?: number | null;
        metadata?: {
            [key: string]: string;
        } | null;
        question?: string | null;
        source?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2FreeFormSuggestion {
        response?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2GcsDestination {
        uri?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2GenerateSuggestionsResponse {
        generatorSuggestionAnswers?: Schema$GoogleCloudDialogflowV2GenerateSuggestionsResponseGeneratorSuggestionAnswer[];
        latestMessage?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2GenerateSuggestionsResponseGeneratorSuggestionAnswer {
        answerRecord?: string | null;
        generatorSuggestion?: Schema$GoogleCloudDialogflowV2GeneratorSuggestion;
        sourceGenerator?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2GeneratorSuggestion {
        agentCoachingSuggestion?: Schema$GoogleCloudDialogflowV2AgentCoachingSuggestion;
        freeFormSuggestion?: Schema$GoogleCloudDialogflowV2FreeFormSuggestion;
        summarySuggestion?: Schema$GoogleCloudDialogflowV2SummarySuggestion;
        toolCallInfo?: Schema$GoogleCloudDialogflowV2GeneratorSuggestionToolCallInfo[];
    }
    export interface Schema$GoogleCloudDialogflowV2GeneratorSuggestionToolCallInfo {
        toolCall?: Schema$GoogleCloudDialogflowV2ToolCall;
        toolCallResult?: Schema$GoogleCloudDialogflowV2ToolCallResult;
    }
    export interface Schema$GoogleCloudDialogflowV2HumanAgentAssistantEvent {
        conversation?: string | null;
        participant?: string | null;
        suggestionResults?: Schema$GoogleCloudDialogflowV2SuggestionResult[];
    }
    export interface Schema$GoogleCloudDialogflowV2ImportConversationDataOperationMetadata {
        conversationDataset?: string | null;
        createTime?: string | null;
        partialFailures?: Schema$GoogleRpcStatus[];
    }
    export interface Schema$GoogleCloudDialogflowV2ImportConversationDataOperationResponse {
        conversationDataset?: string | null;
        importCount?: number | null;
    }
    export interface Schema$GoogleCloudDialogflowV2ImportDocumentsResponse {
        warnings?: Schema$GoogleRpcStatus[];
    }
    export interface Schema$GoogleCloudDialogflowV2IngestedContextReferenceDebugInfo {
        contextReferenceRetrieved?: boolean | null;
        ingestedParametersDebugInfo?: Schema$GoogleCloudDialogflowV2IngestedContextReferenceDebugInfoIngestedParameterDebugInfo[];
        projectNotAllowlisted?: boolean | null;
    }
    export interface Schema$GoogleCloudDialogflowV2IngestedContextReferenceDebugInfoIngestedParameterDebugInfo {
        ingestionStatus?: string | null;
        parameter?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2InitializeEncryptionSpecMetadata {
        request?: Schema$GoogleCloudDialogflowV2InitializeEncryptionSpecRequest;
    }
    export interface Schema$GoogleCloudDialogflowV2InitializeEncryptionSpecRequest {
        encryptionSpec?: Schema$GoogleCloudDialogflowV2EncryptionSpec;
    }
    export interface Schema$GoogleCloudDialogflowV2InputDataset {
        dataset?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2Intent {
        action?: string | null;
        defaultResponsePlatforms?: string[] | null;
        displayName?: string | null;
        endInteraction?: boolean | null;
        events?: string[] | null;
        followupIntentInfo?: Schema$GoogleCloudDialogflowV2IntentFollowupIntentInfo[];
        inputContextNames?: string[] | null;
        isFallback?: boolean | null;
        liveAgentHandoff?: boolean | null;
        messages?: Schema$GoogleCloudDialogflowV2IntentMessage[];
        mlDisabled?: boolean | null;
        name?: string | null;
        outputContexts?: Schema$GoogleCloudDialogflowV2Context[];
        parameters?: Schema$GoogleCloudDialogflowV2IntentParameter[];
        parentFollowupIntentName?: string | null;
        priority?: number | null;
        resetContexts?: boolean | null;
        rootFollowupIntentName?: string | null;
        trainingPhrases?: Schema$GoogleCloudDialogflowV2IntentTrainingPhrase[];
        webhookState?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2IntentFollowupIntentInfo {
        followupIntentName?: string | null;
        parentFollowupIntentName?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2IntentMessage {
        basicCard?: Schema$GoogleCloudDialogflowV2IntentMessageBasicCard;
        browseCarouselCard?: Schema$GoogleCloudDialogflowV2IntentMessageBrowseCarouselCard;
        card?: Schema$GoogleCloudDialogflowV2IntentMessageCard;
        carouselSelect?: Schema$GoogleCloudDialogflowV2IntentMessageCarouselSelect;
        image?: Schema$GoogleCloudDialogflowV2IntentMessageImage;
        linkOutSuggestion?: Schema$GoogleCloudDialogflowV2IntentMessageLinkOutSuggestion;
        listSelect?: Schema$GoogleCloudDialogflowV2IntentMessageListSelect;
        mediaContent?: Schema$GoogleCloudDialogflowV2IntentMessageMediaContent;
        payload?: {
            [key: string]: any;
        } | null;
        platform?: string | null;
        quickReplies?: Schema$GoogleCloudDialogflowV2IntentMessageQuickReplies;
        simpleResponses?: Schema$GoogleCloudDialogflowV2IntentMessageSimpleResponses;
        suggestions?: Schema$GoogleCloudDialogflowV2IntentMessageSuggestions;
        tableCard?: Schema$GoogleCloudDialogflowV2IntentMessageTableCard;
        text?: Schema$GoogleCloudDialogflowV2IntentMessageText;
    }
    export interface Schema$GoogleCloudDialogflowV2IntentMessageBasicCard {
        buttons?: Schema$GoogleCloudDialogflowV2IntentMessageBasicCardButton[];
        formattedText?: string | null;
        image?: Schema$GoogleCloudDialogflowV2IntentMessageImage;
        subtitle?: string | null;
        title?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2IntentMessageBasicCardButton {
        openUriAction?: Schema$GoogleCloudDialogflowV2IntentMessageBasicCardButtonOpenUriAction;
        title?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2IntentMessageBasicCardButtonOpenUriAction {
        uri?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2IntentMessageBrowseCarouselCard {
        imageDisplayOptions?: string | null;
        items?: Schema$GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItem[];
    }
    export interface Schema$GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItem {
        description?: string | null;
        footer?: string | null;
        image?: Schema$GoogleCloudDialogflowV2IntentMessageImage;
        openUriAction?: Schema$GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlAction;
        title?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlAction {
        url?: string | null;
        urlTypeHint?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2IntentMessageCard {
        buttons?: Schema$GoogleCloudDialogflowV2IntentMessageCardButton[];
        imageUri?: string | null;
        subtitle?: string | null;
        title?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2IntentMessageCardButton {
        postback?: string | null;
        text?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2IntentMessageCarouselSelect {
        items?: Schema$GoogleCloudDialogflowV2IntentMessageCarouselSelectItem[];
    }
    export interface Schema$GoogleCloudDialogflowV2IntentMessageCarouselSelectItem {
        description?: string | null;
        image?: Schema$GoogleCloudDialogflowV2IntentMessageImage;
        info?: Schema$GoogleCloudDialogflowV2IntentMessageSelectItemInfo;
        title?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2IntentMessageColumnProperties {
        header?: string | null;
        horizontalAlignment?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2IntentMessageImage {
        accessibilityText?: string | null;
        imageUri?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2IntentMessageLinkOutSuggestion {
        destinationName?: string | null;
        uri?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2IntentMessageListSelect {
        items?: Schema$GoogleCloudDialogflowV2IntentMessageListSelectItem[];
        subtitle?: string | null;
        title?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2IntentMessageListSelectItem {
        description?: string | null;
        image?: Schema$GoogleCloudDialogflowV2IntentMessageImage;
        info?: Schema$GoogleCloudDialogflowV2IntentMessageSelectItemInfo;
        title?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2IntentMessageMediaContent {
        mediaObjects?: Schema$GoogleCloudDialogflowV2IntentMessageMediaContentResponseMediaObject[];
        mediaType?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2IntentMessageMediaContentResponseMediaObject {
        contentUrl?: string | null;
        description?: string | null;
        icon?: Schema$GoogleCloudDialogflowV2IntentMessageImage;
        largeImage?: Schema$GoogleCloudDialogflowV2IntentMessageImage;
        name?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2IntentMessageQuickReplies {
        quickReplies?: string[] | null;
        title?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2IntentMessageSelectItemInfo {
        key?: string | null;
        synonyms?: string[] | null;
    }
    export interface Schema$GoogleCloudDialogflowV2IntentMessageSimpleResponse {
        displayText?: string | null;
        ssml?: string | null;
        textToSpeech?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2IntentMessageSimpleResponses {
        simpleResponses?: Schema$GoogleCloudDialogflowV2IntentMessageSimpleResponse[];
    }
    export interface Schema$GoogleCloudDialogflowV2IntentMessageSuggestion {
        title?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2IntentMessageSuggestions {
        suggestions?: Schema$GoogleCloudDialogflowV2IntentMessageSuggestion[];
    }
    export interface Schema$GoogleCloudDialogflowV2IntentMessageTableCard {
        buttons?: Schema$GoogleCloudDialogflowV2IntentMessageBasicCardButton[];
        columnProperties?: Schema$GoogleCloudDialogflowV2IntentMessageColumnProperties[];
        image?: Schema$GoogleCloudDialogflowV2IntentMessageImage;
        rows?: Schema$GoogleCloudDialogflowV2IntentMessageTableCardRow[];
        subtitle?: string | null;
        title?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2IntentMessageTableCardCell {
        text?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2IntentMessageTableCardRow {
        cells?: Schema$GoogleCloudDialogflowV2IntentMessageTableCardCell[];
        dividerAfter?: boolean | null;
    }
    export interface Schema$GoogleCloudDialogflowV2IntentMessageText {
        text?: string[] | null;
    }
    export interface Schema$GoogleCloudDialogflowV2IntentParameter {
        defaultValue?: string | null;
        displayName?: string | null;
        entityTypeDisplayName?: string | null;
        isList?: boolean | null;
        mandatory?: boolean | null;
        name?: string | null;
        prompts?: string[] | null;
        value?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2IntentTrainingPhrase {
        name?: string | null;
        parts?: Schema$GoogleCloudDialogflowV2IntentTrainingPhrasePart[];
        timesAddedCount?: number | null;
        type?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2IntentTrainingPhrasePart {
        alias?: string | null;
        entityType?: string | null;
        text?: string | null;
        userDefined?: boolean | null;
    }
    export interface Schema$GoogleCloudDialogflowV2KnowledgeAssistAnswer {
        answerRecord?: string | null;
        knowledgeAssistDebugInfo?: Schema$GoogleCloudDialogflowV2KnowledgeAssistDebugInfo;
        suggestedQuery?: Schema$GoogleCloudDialogflowV2KnowledgeAssistAnswerSuggestedQuery;
        suggestedQueryAnswer?: Schema$GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswer;
    }
    export interface Schema$GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswer {
        answerText?: string | null;
        faqSource?: Schema$GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerFaqSource;
        generativeSource?: Schema$GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerGenerativeSource;
    }
    export interface Schema$GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerFaqSource {
        question?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerGenerativeSource {
        snippets?: Schema$GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerGenerativeSourceSnippet[];
    }
    export interface Schema$GoogleCloudDialogflowV2KnowledgeAssistAnswerKnowledgeAnswerGenerativeSourceSnippet {
        metadata?: {
            [key: string]: any;
        } | null;
        text?: string | null;
        title?: string | null;
        uri?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2KnowledgeAssistAnswerSuggestedQuery {
        queryText?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2KnowledgeAssistDebugInfo {
        datastoreResponseReason?: string | null;
        ingestedContextReferenceDebugInfo?: Schema$GoogleCloudDialogflowV2IngestedContextReferenceDebugInfo;
        knowledgeAssistBehavior?: Schema$GoogleCloudDialogflowV2KnowledgeAssistDebugInfoKnowledgeAssistBehavior;
        queryCategorizationFailureReason?: string | null;
        queryGenerationFailureReason?: string | null;
        serviceLatency?: Schema$GoogleCloudDialogflowV2ServiceLatency;
    }
    export interface Schema$GoogleCloudDialogflowV2KnowledgeAssistDebugInfoKnowledgeAssistBehavior {
        answerGenerationRewriterOn?: boolean | null;
        appendedSearchContextCount?: number | null;
        conversationTranscriptHasMixedLanguages?: boolean | null;
        disableSyncDelivery?: boolean | null;
        endUserMetadataIncluded?: boolean | null;
        invalidItemsQuerySuggestionSkipped?: boolean | null;
        multipleQueriesGenerated?: boolean | null;
        previousQueriesIncluded?: boolean | null;
        primaryQueryRedactedAndReplaced?: boolean | null;
        queryContainedSearchContext?: boolean | null;
        queryGenerationAgentLanguageMismatch?: boolean | null;
        queryGenerationEndUserLanguageMismatch?: boolean | null;
        returnQueryOnly?: boolean | null;
        thirdPartyConnectorAllowed?: boolean | null;
        useCustomSafetyFilterLevel?: boolean | null;
        usePubsubDelivery?: boolean | null;
        useTranslatedMessage?: boolean | null;
    }
    export interface Schema$GoogleCloudDialogflowV2KnowledgeOperationMetadata {
        doneTime?: string | null;
        exportOperationMetadata?: Schema$GoogleCloudDialogflowV2ExportOperationMetadata;
        knowledgeBase?: string | null;
        state?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2Message {
        content?: string | null;
        createTime?: string | null;
        languageCode?: string | null;
        messageAnnotation?: Schema$GoogleCloudDialogflowV2MessageAnnotation;
        name?: string | null;
        participant?: string | null;
        participantRole?: string | null;
        sendTime?: string | null;
        sentimentAnalysis?: Schema$GoogleCloudDialogflowV2SentimentAnalysisResult;
    }
    export interface Schema$GoogleCloudDialogflowV2MessageAnnotation {
        containEntities?: boolean | null;
        parts?: Schema$GoogleCloudDialogflowV2AnnotatedMessagePart[];
    }
    export interface Schema$GoogleCloudDialogflowV2OriginalDetectIntentRequest {
        payload?: {
            [key: string]: any;
        } | null;
        source?: string | null;
        version?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2QueryResult {
        action?: string | null;
        allRequiredParamsPresent?: boolean | null;
        cancelsSlotFilling?: boolean | null;
        diagnosticInfo?: {
            [key: string]: any;
        } | null;
        fulfillmentMessages?: Schema$GoogleCloudDialogflowV2IntentMessage[];
        fulfillmentText?: string | null;
        intent?: Schema$GoogleCloudDialogflowV2Intent;
        intentDetectionConfidence?: number | null;
        languageCode?: string | null;
        outputContexts?: Schema$GoogleCloudDialogflowV2Context[];
        parameters?: {
            [key: string]: any;
        } | null;
        queryText?: string | null;
        sentimentAnalysisResult?: Schema$GoogleCloudDialogflowV2SentimentAnalysisResult;
        speechRecognitionConfidence?: number | null;
        webhookPayload?: {
            [key: string]: any;
        } | null;
        webhookSource?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2Sentiment {
        magnitude?: number | null;
        score?: number | null;
    }
    export interface Schema$GoogleCloudDialogflowV2SentimentAnalysisResult {
        queryTextSentiment?: Schema$GoogleCloudDialogflowV2Sentiment;
    }
    export interface Schema$GoogleCloudDialogflowV2ServiceLatency {
        internalServiceLatencies?: Schema$GoogleCloudDialogflowV2ServiceLatencyInternalServiceLatency[];
    }
    export interface Schema$GoogleCloudDialogflowV2ServiceLatencyInternalServiceLatency {
        completeTime?: string | null;
        latencyMs?: number | null;
        startTime?: string | null;
        step?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2SessionEntityType {
        entities?: Schema$GoogleCloudDialogflowV2EntityTypeEntity[];
        entityOverrideMode?: string | null;
        name?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2SetSuggestionFeatureConfigOperationMetadata {
        conversationProfile?: string | null;
        createTime?: string | null;
        participantRole?: string | null;
        suggestionFeatureType?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2SmartReplyAnswer {
        answerRecord?: string | null;
        confidence?: number | null;
        reply?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2SmartReplyModelMetadata {
        trainingModelType?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2SpeechWordInfo {
        confidence?: number | null;
        endOffset?: string | null;
        startOffset?: string | null;
        word?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2StreamingRecognitionResult {
        confidence?: number | null;
        isFinal?: boolean | null;
        languageCode?: string | null;
        messageType?: string | null;
        speechEndOffset?: string | null;
        speechWordInfo?: Schema$GoogleCloudDialogflowV2SpeechWordInfo[];
        transcript?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2SuggestArticlesResponse {
        articleAnswers?: Schema$GoogleCloudDialogflowV2ArticleAnswer[];
        contextSize?: number | null;
        latestMessage?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2SuggestFaqAnswersResponse {
        contextSize?: number | null;
        faqAnswers?: Schema$GoogleCloudDialogflowV2FaqAnswer[];
        latestMessage?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2SuggestionResult {
        error?: Schema$GoogleRpcStatus;
        generateSuggestionsResponse?: Schema$GoogleCloudDialogflowV2GenerateSuggestionsResponse;
        suggestArticlesResponse?: Schema$GoogleCloudDialogflowV2SuggestArticlesResponse;
        suggestFaqAnswersResponse?: Schema$GoogleCloudDialogflowV2SuggestFaqAnswersResponse;
        suggestKnowledgeAssistResponse?: Schema$GoogleCloudDialogflowV2SuggestKnowledgeAssistResponse;
        suggestSmartRepliesResponse?: Schema$GoogleCloudDialogflowV2SuggestSmartRepliesResponse;
    }
    export interface Schema$GoogleCloudDialogflowV2SuggestKnowledgeAssistResponse {
        contextSize?: number | null;
        knowledgeAssistAnswer?: Schema$GoogleCloudDialogflowV2KnowledgeAssistAnswer;
        latestMessage?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2SuggestSmartRepliesResponse {
        contextSize?: number | null;
        latestMessage?: string | null;
        smartReplyAnswers?: Schema$GoogleCloudDialogflowV2SmartReplyAnswer[];
    }
    export interface Schema$GoogleCloudDialogflowV2SummarySuggestion {
        summarySections?: Schema$GoogleCloudDialogflowV2SummarySuggestionSummarySection[];
    }
    export interface Schema$GoogleCloudDialogflowV2SummarySuggestionSummarySection {
        section?: string | null;
        summary?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2ToolCall {
        action?: string | null;
        answerRecord?: string | null;
        createTime?: string | null;
        inputParameters?: {
            [key: string]: any;
        } | null;
        state?: string | null;
        tool?: string | null;
        toolDisplayDetails?: string | null;
        toolDisplayName?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2ToolCallResult {
        action?: string | null;
        answerRecord?: string | null;
        content?: string | null;
        createTime?: string | null;
        error?: Schema$GoogleCloudDialogflowV2ToolCallResultError;
        rawContent?: string | null;
        tool?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2ToolCallResultError {
        message?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2UndeployConversationModelOperationMetadata {
        conversationModel?: string | null;
        createTime?: string | null;
        doneTime?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2WebhookRequest {
        originalDetectIntentRequest?: Schema$GoogleCloudDialogflowV2OriginalDetectIntentRequest;
        queryResult?: Schema$GoogleCloudDialogflowV2QueryResult;
        responseId?: string | null;
        session?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV2WebhookResponse {
        followupEventInput?: Schema$GoogleCloudDialogflowV2EventInput;
        fulfillmentMessages?: Schema$GoogleCloudDialogflowV2IntentMessage[];
        fulfillmentText?: string | null;
        outputContexts?: Schema$GoogleCloudDialogflowV2Context[];
        payload?: {
            [key: string]: any;
        } | null;
        sessionEntityTypes?: Schema$GoogleCloudDialogflowV2SessionEntityType[];
        source?: string | null;
    }
    export interface Schema$GoogleCloudDialogflowV3alpha1ConversationSignals {
        turnSignals?: Schema$GoogleCloudDialogflowV3alpha1TurnSignals;
    }
    export interface Schema$GoogleCloudDialogflowV3alpha1TurnSignals {
        agentEscalated?: boolean | null;
        dtmfUsed?: boolean | null;
        failureReasons?: string[] | null;
        noMatch?: boolean | null;
        noUserInput?: boolean | null;
        reachedEndPage?: boolean | null;
        sentimentMagnitude?: number | null;
        sentimentScore?: number | null;
        triggeredAbandonmentEvent?: boolean | null;
        userEscalated?: boolean | null;
        webhookStatuses?: string[] | null;
    }
    export interface Schema$GoogleCloudLocationListLocationsResponse {
        locations?: Schema$GoogleCloudLocationLocation[];
        nextPageToken?: string | null;
    }
    export interface Schema$GoogleCloudLocationLocation {
        displayName?: string | null;
        labels?: {
            [key: string]: string;
        } | null;
        locationId?: string | null;
        metadata?: {
            [key: string]: any;
        } | null;
        name?: string | null;
    }
    export interface Schema$GoogleLongrunningListOperationsResponse {
        nextPageToken?: string | null;
        operations?: Schema$GoogleLongrunningOperation[];
        unreachable?: string[] | null;
    }
    export interface Schema$GoogleLongrunningOperation {
        done?: boolean | null;
        error?: Schema$GoogleRpcStatus;
        metadata?: {
            [key: string]: any;
        } | null;
        name?: string | null;
        response?: {
            [key: string]: any;
        } | null;
    }
    export interface Schema$GoogleProtobufEmpty {
    }
    export interface Schema$GoogleRpcStatus {
        code?: number | null;
        details?: Array<{
            [key: string]: any;
        }> | null;
        message?: string | null;
    }
    export interface Schema$GoogleTypeLatLng {
        latitude?: number | null;
        longitude?: number | null;
    }
    export class Resource$Projects {
        context: APIRequestContext;
        agent: Resource$Projects$Agent;
        answerRecords: Resource$Projects$Answerrecords;
        conversationProfiles: Resource$Projects$Conversationprofiles;
        conversations: Resource$Projects$Conversations;
        generators: Resource$Projects$Generators;
        knowledgeBases: Resource$Projects$Knowledgebases;
        locations: Resource$Projects$Locations;
        operations: Resource$Projects$Operations;
        phoneNumbers: Resource$Projects$Phonenumbers;
        suggestions: Resource$Projects$Suggestions;
        constructor(context: APIRequestContext);
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.deleteAgent({
         *     parent: 'projects/my-project',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {}
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        deleteAgent(params: Params$Resource$Projects$Deleteagent, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        deleteAgent(params?: Params$Resource$Projects$Deleteagent, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleProtobufEmpty>>;
        deleteAgent(params: Params$Resource$Projects$Deleteagent, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        deleteAgent(params: Params$Resource$Projects$Deleteagent, options: MethodOptions | BodyResponseCallback<Schema$GoogleProtobufEmpty>, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        deleteAgent(params: Params$Resource$Projects$Deleteagent, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        deleteAgent(callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.getAgent({
         *     parent: 'projects/my-project',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "apiVersion": "my_apiVersion",
         *   //   "avatarUri": "my_avatarUri",
         *   //   "classificationThreshold": {},
         *   //   "defaultLanguageCode": "my_defaultLanguageCode",
         *   //   "description": "my_description",
         *   //   "displayName": "my_displayName",
         *   //   "enableLogging": false,
         *   //   "matchMode": "my_matchMode",
         *   //   "parent": "my_parent",
         *   //   "supportedLanguageCodes": [],
         *   //   "tier": "my_tier",
         *   //   "timeZone": "my_timeZone"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        getAgent(params: Params$Resource$Projects$Getagent, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        getAgent(params?: Params$Resource$Projects$Getagent, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1Agent>>;
        getAgent(params: Params$Resource$Projects$Getagent, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        getAgent(params: Params$Resource$Projects$Getagent, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Agent>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Agent>): void;
        getAgent(params: Params$Resource$Projects$Getagent, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Agent>): void;
        getAgent(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Agent>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.setAgent({
         *     parent: 'projects/my-project',
         *
         *     updateMask: 'placeholder-value',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "apiVersion": "my_apiVersion",
         *       //   "avatarUri": "my_avatarUri",
         *       //   "classificationThreshold": {},
         *       //   "defaultLanguageCode": "my_defaultLanguageCode",
         *       //   "description": "my_description",
         *       //   "displayName": "my_displayName",
         *       //   "enableLogging": false,
         *       //   "matchMode": "my_matchMode",
         *       //   "parent": "my_parent",
         *       //   "supportedLanguageCodes": [],
         *       //   "tier": "my_tier",
         *       //   "timeZone": "my_timeZone"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "apiVersion": "my_apiVersion",
         *   //   "avatarUri": "my_avatarUri",
         *   //   "classificationThreshold": {},
         *   //   "defaultLanguageCode": "my_defaultLanguageCode",
         *   //   "description": "my_description",
         *   //   "displayName": "my_displayName",
         *   //   "enableLogging": false,
         *   //   "matchMode": "my_matchMode",
         *   //   "parent": "my_parent",
         *   //   "supportedLanguageCodes": [],
         *   //   "tier": "my_tier",
         *   //   "timeZone": "my_timeZone"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        setAgent(params: Params$Resource$Projects$Setagent, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        setAgent(params?: Params$Resource$Projects$Setagent, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1Agent>>;
        setAgent(params: Params$Resource$Projects$Setagent, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        setAgent(params: Params$Resource$Projects$Setagent, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Agent>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Agent>): void;
        setAgent(params: Params$Resource$Projects$Setagent, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Agent>): void;
        setAgent(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Agent>): void;
    }
    export interface Params$Resource$Projects$Deleteagent extends StandardParameters {
        /**
         *
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Getagent extends StandardParameters {
        /**
         *
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Setagent extends StandardParameters {
        /**
         *
         */
        parent?: string;
        /**
         *
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1Agent;
    }
    export class Resource$Projects$Agent {
        context: APIRequestContext;
        entityTypes: Resource$Projects$Agent$Entitytypes;
        environments: Resource$Projects$Agent$Environments;
        intents: Resource$Projects$Agent$Intents;
        knowledgeBases: Resource$Projects$Agent$Knowledgebases;
        sessions: Resource$Projects$Agent$Sessions;
        versions: Resource$Projects$Agent$Versions;
        constructor(context: APIRequestContext);
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.export({
         *     parent: 'projects/my-project',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "agentUri": "my_agentUri"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        export(params: Params$Resource$Projects$Agent$Export, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        export(params?: Params$Resource$Projects$Agent$Export, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        export(params: Params$Resource$Projects$Agent$Export, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        export(params: Params$Resource$Projects$Agent$Export, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        export(params: Params$Resource$Projects$Agent$Export, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        export(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.getFulfillment({
         *     name: 'projects/my-project/agent/fulfillment',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "displayName": "my_displayName",
         *   //   "enabled": false,
         *   //   "features": [],
         *   //   "genericWebService": {},
         *   //   "name": "my_name"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        getFulfillment(params: Params$Resource$Projects$Agent$Getfulfillment, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        getFulfillment(params?: Params$Resource$Projects$Agent$Getfulfillment, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1Fulfillment>>;
        getFulfillment(params: Params$Resource$Projects$Agent$Getfulfillment, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        getFulfillment(params: Params$Resource$Projects$Agent$Getfulfillment, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Fulfillment>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Fulfillment>): void;
        getFulfillment(params: Params$Resource$Projects$Agent$Getfulfillment, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Fulfillment>): void;
        getFulfillment(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Fulfillment>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.getValidationResult({
         *     languageCode: 'placeholder-value',
         *
         *     parent: 'projects/my-project',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "validationErrors": []
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        getValidationResult(params: Params$Resource$Projects$Agent$Getvalidationresult, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        getValidationResult(params?: Params$Resource$Projects$Agent$Getvalidationresult, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1ValidationResult>>;
        getValidationResult(params: Params$Resource$Projects$Agent$Getvalidationresult, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        getValidationResult(params: Params$Resource$Projects$Agent$Getvalidationresult, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ValidationResult>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ValidationResult>): void;
        getValidationResult(params: Params$Resource$Projects$Agent$Getvalidationresult, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ValidationResult>): void;
        getValidationResult(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ValidationResult>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.import({
         *     parent: 'projects/my-project',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "agentContent": "my_agentContent",
         *       //   "agentUri": "my_agentUri"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        import(params: Params$Resource$Projects$Agent$Import, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        import(params?: Params$Resource$Projects$Agent$Import, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        import(params: Params$Resource$Projects$Agent$Import, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        import(params: Params$Resource$Projects$Agent$Import, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        import(params: Params$Resource$Projects$Agent$Import, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        import(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.restore({
         *     parent: 'projects/my-project',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "agentContent": "my_agentContent",
         *       //   "agentUri": "my_agentUri"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        restore(params: Params$Resource$Projects$Agent$Restore, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        restore(params?: Params$Resource$Projects$Agent$Restore, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        restore(params: Params$Resource$Projects$Agent$Restore, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        restore(params: Params$Resource$Projects$Agent$Restore, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        restore(params: Params$Resource$Projects$Agent$Restore, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        restore(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.search({
         *     pageSize: 'placeholder-value',
         *
         *     pageToken: 'placeholder-value',
         *
         *     parent: 'projects/my-project',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "agents": [],
         *   //   "nextPageToken": "my_nextPageToken"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        search(params: Params$Resource$Projects$Agent$Search, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        search(params?: Params$Resource$Projects$Agent$Search, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1SearchAgentsResponse>>;
        search(params: Params$Resource$Projects$Agent$Search, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        search(params: Params$Resource$Projects$Agent$Search, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SearchAgentsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SearchAgentsResponse>): void;
        search(params: Params$Resource$Projects$Agent$Search, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SearchAgentsResponse>): void;
        search(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SearchAgentsResponse>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.train({
         *     parent: 'projects/my-project',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {}
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        train(params: Params$Resource$Projects$Agent$Train, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        train(params?: Params$Resource$Projects$Agent$Train, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        train(params: Params$Resource$Projects$Agent$Train, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        train(params: Params$Resource$Projects$Agent$Train, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        train(params: Params$Resource$Projects$Agent$Train, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        train(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.updateFulfillment({
         *     name: 'projects/my-project/agent/fulfillment',
         *
         *     updateMask: 'placeholder-value',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "displayName": "my_displayName",
         *       //   "enabled": false,
         *       //   "features": [],
         *       //   "genericWebService": {},
         *       //   "name": "my_name"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "displayName": "my_displayName",
         *   //   "enabled": false,
         *   //   "features": [],
         *   //   "genericWebService": {},
         *   //   "name": "my_name"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        updateFulfillment(params: Params$Resource$Projects$Agent$Updatefulfillment, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        updateFulfillment(params?: Params$Resource$Projects$Agent$Updatefulfillment, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1Fulfillment>>;
        updateFulfillment(params: Params$Resource$Projects$Agent$Updatefulfillment, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        updateFulfillment(params: Params$Resource$Projects$Agent$Updatefulfillment, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Fulfillment>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Fulfillment>): void;
        updateFulfillment(params: Params$Resource$Projects$Agent$Updatefulfillment, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Fulfillment>): void;
        updateFulfillment(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Fulfillment>): void;
    }
    export interface Params$Resource$Projects$Agent$Export extends StandardParameters {
        /**
         *
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1ExportAgentRequest;
    }
    export interface Params$Resource$Projects$Agent$Getfulfillment extends StandardParameters {
        /**
         *
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Agent$Getvalidationresult extends StandardParameters {
        /**
         *
         */
        languageCode?: string;
        /**
         *
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Agent$Import extends StandardParameters {
        /**
         *
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1ImportAgentRequest;
    }
    export interface Params$Resource$Projects$Agent$Restore extends StandardParameters {
        /**
         *
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1RestoreAgentRequest;
    }
    export interface Params$Resource$Projects$Agent$Search extends StandardParameters {
        /**
         *
         */
        pageSize?: number;
        /**
         *
         */
        pageToken?: string;
        /**
         *
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Agent$Train extends StandardParameters {
        /**
         *
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1TrainAgentRequest;
    }
    export interface Params$Resource$Projects$Agent$Updatefulfillment extends StandardParameters {
        /**
         *
         */
        name?: string;
        /**
         *
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1Fulfillment;
    }
    export class Resource$Projects$Agent$Entitytypes {
        context: APIRequestContext;
        entities: Resource$Projects$Agent$Entitytypes$Entities;
        constructor(context: APIRequestContext);
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.entityTypes.batchDelete({
         *     parent: 'projects/my-project/agent',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "entityTypeNames": []
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        batchDelete(params: Params$Resource$Projects$Agent$Entitytypes$Batchdelete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        batchDelete(params?: Params$Resource$Projects$Agent$Entitytypes$Batchdelete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        batchDelete(params: Params$Resource$Projects$Agent$Entitytypes$Batchdelete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        batchDelete(params: Params$Resource$Projects$Agent$Entitytypes$Batchdelete, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        batchDelete(params: Params$Resource$Projects$Agent$Entitytypes$Batchdelete, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        batchDelete(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.entityTypes.batchUpdate({
         *     parent: 'projects/my-project/agent',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "entityTypeBatchInline": {},
         *       //   "entityTypeBatchUri": "my_entityTypeBatchUri",
         *       //   "languageCode": "my_languageCode",
         *       //   "updateMask": "my_updateMask"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        batchUpdate(params: Params$Resource$Projects$Agent$Entitytypes$Batchupdate, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        batchUpdate(params?: Params$Resource$Projects$Agent$Entitytypes$Batchupdate, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        batchUpdate(params: Params$Resource$Projects$Agent$Entitytypes$Batchupdate, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        batchUpdate(params: Params$Resource$Projects$Agent$Entitytypes$Batchupdate, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        batchUpdate(params: Params$Resource$Projects$Agent$Entitytypes$Batchupdate, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        batchUpdate(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.entityTypes.create({
         *     languageCode: 'placeholder-value',
         *
         *     parent: 'projects/my-project/agent',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "autoExpansionMode": "my_autoExpansionMode",
         *       //   "displayName": "my_displayName",
         *       //   "enableFuzzyExtraction": false,
         *       //   "entities": [],
         *       //   "kind": "my_kind",
         *       //   "name": "my_name"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "autoExpansionMode": "my_autoExpansionMode",
         *   //   "displayName": "my_displayName",
         *   //   "enableFuzzyExtraction": false,
         *   //   "entities": [],
         *   //   "kind": "my_kind",
         *   //   "name": "my_name"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Projects$Agent$Entitytypes$Create, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        create(params?: Params$Resource$Projects$Agent$Entitytypes$Create, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1EntityType>>;
        create(params: Params$Resource$Projects$Agent$Entitytypes$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Projects$Agent$Entitytypes$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1EntityType>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1EntityType>): void;
        create(params: Params$Resource$Projects$Agent$Entitytypes$Create, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1EntityType>): void;
        create(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1EntityType>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.entityTypes.delete({
         *     name: 'projects/my-project/agent/entityTypes/my-entityType',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {}
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Projects$Agent$Entitytypes$Delete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        delete(params?: Params$Resource$Projects$Agent$Entitytypes$Delete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleProtobufEmpty>>;
        delete(params: Params$Resource$Projects$Agent$Entitytypes$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Projects$Agent$Entitytypes$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleProtobufEmpty>, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(params: Params$Resource$Projects$Agent$Entitytypes$Delete, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.entityTypes.get({
         *     languageCode: 'placeholder-value',
         *
         *     name: 'projects/my-project/agent/entityTypes/my-entityType',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "autoExpansionMode": "my_autoExpansionMode",
         *   //   "displayName": "my_displayName",
         *   //   "enableFuzzyExtraction": false,
         *   //   "entities": [],
         *   //   "kind": "my_kind",
         *   //   "name": "my_name"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Agent$Entitytypes$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Agent$Entitytypes$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1EntityType>>;
        get(params: Params$Resource$Projects$Agent$Entitytypes$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Agent$Entitytypes$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1EntityType>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1EntityType>): void;
        get(params: Params$Resource$Projects$Agent$Entitytypes$Get, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1EntityType>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1EntityType>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.entityTypes.list({
         *     languageCode: 'placeholder-value',
         *
         *     pageSize: 'placeholder-value',
         *
         *     pageToken: 'placeholder-value',
         *
         *     parent: 'projects/my-project/agent',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "entityTypes": [],
         *   //   "nextPageToken": "my_nextPageToken"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Agent$Entitytypes$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Agent$Entitytypes$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1ListEntityTypesResponse>>;
        list(params: Params$Resource$Projects$Agent$Entitytypes$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Agent$Entitytypes$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListEntityTypesResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListEntityTypesResponse>): void;
        list(params: Params$Resource$Projects$Agent$Entitytypes$List, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListEntityTypesResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListEntityTypesResponse>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.entityTypes.patch({
         *     languageCode: 'placeholder-value',
         *
         *     name: 'projects/my-project/agent/entityTypes/my-entityType',
         *
         *     updateMask: 'placeholder-value',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "autoExpansionMode": "my_autoExpansionMode",
         *       //   "displayName": "my_displayName",
         *       //   "enableFuzzyExtraction": false,
         *       //   "entities": [],
         *       //   "kind": "my_kind",
         *       //   "name": "my_name"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "autoExpansionMode": "my_autoExpansionMode",
         *   //   "displayName": "my_displayName",
         *   //   "enableFuzzyExtraction": false,
         *   //   "entities": [],
         *   //   "kind": "my_kind",
         *   //   "name": "my_name"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        patch(params: Params$Resource$Projects$Agent$Entitytypes$Patch, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        patch(params?: Params$Resource$Projects$Agent$Entitytypes$Patch, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1EntityType>>;
        patch(params: Params$Resource$Projects$Agent$Entitytypes$Patch, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        patch(params: Params$Resource$Projects$Agent$Entitytypes$Patch, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1EntityType>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1EntityType>): void;
        patch(params: Params$Resource$Projects$Agent$Entitytypes$Patch, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1EntityType>): void;
        patch(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1EntityType>): void;
    }
    export interface Params$Resource$Projects$Agent$Entitytypes$Batchdelete extends StandardParameters {
        /**
         *
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1BatchDeleteEntityTypesRequest;
    }
    export interface Params$Resource$Projects$Agent$Entitytypes$Batchupdate extends StandardParameters {
        /**
         *
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1BatchUpdateEntityTypesRequest;
    }
    export interface Params$Resource$Projects$Agent$Entitytypes$Create extends StandardParameters {
        /**
         *
         */
        languageCode?: string;
        /**
         *
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1EntityType;
    }
    export interface Params$Resource$Projects$Agent$Entitytypes$Delete extends StandardParameters {
        /**
         *
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Agent$Entitytypes$Get extends StandardParameters {
        /**
         *
         */
        languageCode?: string;
        /**
         *
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Agent$Entitytypes$List extends StandardParameters {
        /**
         *
         */
        languageCode?: string;
        /**
         *
         */
        pageSize?: number;
        /**
         *
         */
        pageToken?: string;
        /**
         *
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Agent$Entitytypes$Patch extends StandardParameters {
        /**
         *
         */
        languageCode?: string;
        /**
         *
         */
        name?: string;
        /**
         *
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1EntityType;
    }
    export class Resource$Projects$Agent$Entitytypes$Entities {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.entityTypes.entities.batchCreate({
         *     parent: 'projects/my-project/agent/entityTypes/my-entityType',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "entities": [],
         *       //   "languageCode": "my_languageCode"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        batchCreate(params: Params$Resource$Projects$Agent$Entitytypes$Entities$Batchcreate, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        batchCreate(params?: Params$Resource$Projects$Agent$Entitytypes$Entities$Batchcreate, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        batchCreate(params: Params$Resource$Projects$Agent$Entitytypes$Entities$Batchcreate, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        batchCreate(params: Params$Resource$Projects$Agent$Entitytypes$Entities$Batchcreate, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        batchCreate(params: Params$Resource$Projects$Agent$Entitytypes$Entities$Batchcreate, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        batchCreate(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.entityTypes.entities.batchDelete({
         *     parent: 'projects/my-project/agent/entityTypes/my-entityType',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "entityValues": [],
         *       //   "languageCode": "my_languageCode"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        batchDelete(params: Params$Resource$Projects$Agent$Entitytypes$Entities$Batchdelete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        batchDelete(params?: Params$Resource$Projects$Agent$Entitytypes$Entities$Batchdelete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        batchDelete(params: Params$Resource$Projects$Agent$Entitytypes$Entities$Batchdelete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        batchDelete(params: Params$Resource$Projects$Agent$Entitytypes$Entities$Batchdelete, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        batchDelete(params: Params$Resource$Projects$Agent$Entitytypes$Entities$Batchdelete, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        batchDelete(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.entityTypes.entities.batchUpdate({
         *     parent: 'projects/my-project/agent/entityTypes/my-entityType',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "entities": [],
         *       //   "languageCode": "my_languageCode",
         *       //   "updateMask": "my_updateMask"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        batchUpdate(params: Params$Resource$Projects$Agent$Entitytypes$Entities$Batchupdate, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        batchUpdate(params?: Params$Resource$Projects$Agent$Entitytypes$Entities$Batchupdate, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        batchUpdate(params: Params$Resource$Projects$Agent$Entitytypes$Entities$Batchupdate, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        batchUpdate(params: Params$Resource$Projects$Agent$Entitytypes$Entities$Batchupdate, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        batchUpdate(params: Params$Resource$Projects$Agent$Entitytypes$Entities$Batchupdate, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        batchUpdate(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
    }
    export interface Params$Resource$Projects$Agent$Entitytypes$Entities$Batchcreate extends StandardParameters {
        /**
         *
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1BatchCreateEntitiesRequest;
    }
    export interface Params$Resource$Projects$Agent$Entitytypes$Entities$Batchdelete extends StandardParameters {
        /**
         *
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1BatchDeleteEntitiesRequest;
    }
    export interface Params$Resource$Projects$Agent$Entitytypes$Entities$Batchupdate extends StandardParameters {
        /**
         *
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1BatchUpdateEntitiesRequest;
    }
    export class Resource$Projects$Agent$Environments {
        context: APIRequestContext;
        intents: Resource$Projects$Agent$Environments$Intents;
        users: Resource$Projects$Agent$Environments$Users;
        constructor(context: APIRequestContext);
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.environments.create({
         *     environmentId: 'placeholder-value',
         *
         *     parent: 'projects/my-project/agent',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "agentVersion": "my_agentVersion",
         *       //   "description": "my_description",
         *       //   "fulfillment": {},
         *       //   "name": "my_name",
         *       //   "state": "my_state",
         *       //   "textToSpeechSettings": {},
         *       //   "updateTime": "my_updateTime"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "agentVersion": "my_agentVersion",
         *   //   "description": "my_description",
         *   //   "fulfillment": {},
         *   //   "name": "my_name",
         *   //   "state": "my_state",
         *   //   "textToSpeechSettings": {},
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Projects$Agent$Environments$Create, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        create(params?: Params$Resource$Projects$Agent$Environments$Create, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1Environment>>;
        create(params: Params$Resource$Projects$Agent$Environments$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Projects$Agent$Environments$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Environment>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Environment>): void;
        create(params: Params$Resource$Projects$Agent$Environments$Create, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Environment>): void;
        create(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Environment>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.environments.delete({
         *     name: 'projects/my-project/agent/environments/my-environment',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {}
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Projects$Agent$Environments$Delete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        delete(params?: Params$Resource$Projects$Agent$Environments$Delete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleProtobufEmpty>>;
        delete(params: Params$Resource$Projects$Agent$Environments$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Projects$Agent$Environments$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleProtobufEmpty>, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(params: Params$Resource$Projects$Agent$Environments$Delete, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.environments.get({
         *     name: 'projects/my-project/agent/environments/my-environment',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "agentVersion": "my_agentVersion",
         *   //   "description": "my_description",
         *   //   "fulfillment": {},
         *   //   "name": "my_name",
         *   //   "state": "my_state",
         *   //   "textToSpeechSettings": {},
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Agent$Environments$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Agent$Environments$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1Environment>>;
        get(params: Params$Resource$Projects$Agent$Environments$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Agent$Environments$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Environment>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Environment>): void;
        get(params: Params$Resource$Projects$Agent$Environments$Get, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Environment>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Environment>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.environments.getHistory({
         *     pageSize: 'placeholder-value',
         *
         *     pageToken: 'placeholder-value',
         *
         *     parent: 'projects/my-project/agent/environments/my-environment',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "entries": [],
         *   //   "nextPageToken": "my_nextPageToken",
         *   //   "parent": "my_parent"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        getHistory(params: Params$Resource$Projects$Agent$Environments$Gethistory, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        getHistory(params?: Params$Resource$Projects$Agent$Environments$Gethistory, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1EnvironmentHistory>>;
        getHistory(params: Params$Resource$Projects$Agent$Environments$Gethistory, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        getHistory(params: Params$Resource$Projects$Agent$Environments$Gethistory, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1EnvironmentHistory>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1EnvironmentHistory>): void;
        getHistory(params: Params$Resource$Projects$Agent$Environments$Gethistory, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1EnvironmentHistory>): void;
        getHistory(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1EnvironmentHistory>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.environments.list({
         *     pageSize: 'placeholder-value',
         *
         *     pageToken: 'placeholder-value',
         *
         *     parent: 'projects/my-project/agent',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "environments": [],
         *   //   "nextPageToken": "my_nextPageToken"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Agent$Environments$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Agent$Environments$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1ListEnvironmentsResponse>>;
        list(params: Params$Resource$Projects$Agent$Environments$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Agent$Environments$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListEnvironmentsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListEnvironmentsResponse>): void;
        list(params: Params$Resource$Projects$Agent$Environments$List, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListEnvironmentsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListEnvironmentsResponse>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.environments.patch({
         *     allowLoadToDraftAndDiscardChanges: 'placeholder-value',
         *
         *     name: 'projects/my-project/agent/environments/my-environment',
         *
         *     updateMask: 'placeholder-value',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "agentVersion": "my_agentVersion",
         *       //   "description": "my_description",
         *       //   "fulfillment": {},
         *       //   "name": "my_name",
         *       //   "state": "my_state",
         *       //   "textToSpeechSettings": {},
         *       //   "updateTime": "my_updateTime"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "agentVersion": "my_agentVersion",
         *   //   "description": "my_description",
         *   //   "fulfillment": {},
         *   //   "name": "my_name",
         *   //   "state": "my_state",
         *   //   "textToSpeechSettings": {},
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        patch(params: Params$Resource$Projects$Agent$Environments$Patch, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        patch(params?: Params$Resource$Projects$Agent$Environments$Patch, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1Environment>>;
        patch(params: Params$Resource$Projects$Agent$Environments$Patch, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        patch(params: Params$Resource$Projects$Agent$Environments$Patch, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Environment>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Environment>): void;
        patch(params: Params$Resource$Projects$Agent$Environments$Patch, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Environment>): void;
        patch(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Environment>): void;
    }
    export interface Params$Resource$Projects$Agent$Environments$Create extends StandardParameters {
        /**
         *
         */
        environmentId?: string;
        /**
         *
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1Environment;
    }
    export interface Params$Resource$Projects$Agent$Environments$Delete extends StandardParameters {
        /**
         *
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Agent$Environments$Get extends StandardParameters {
        /**
         *
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Agent$Environments$Gethistory extends StandardParameters {
        /**
         *
         */
        pageSize?: number;
        /**
         *
         */
        pageToken?: string;
        /**
         *
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Agent$Environments$List extends StandardParameters {
        /**
         *
         */
        pageSize?: number;
        /**
         *
         */
        pageToken?: string;
        /**
         *
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Agent$Environments$Patch extends StandardParameters {
        /**
         *
         */
        allowLoadToDraftAndDiscardChanges?: boolean;
        /**
         *
         */
        name?: string;
        /**
         *
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1Environment;
    }
    export class Resource$Projects$Agent$Environments$Intents {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.environments.intents.list({
         *     intentView: 'placeholder-value',
         *
         *     languageCode: 'placeholder-value',
         *
         *     pageSize: 'placeholder-value',
         *
         *     pageToken: 'placeholder-value',
         *
         *     parent: 'projects/my-project/agent/environments/my-environment',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "intents": [],
         *   //   "nextPageToken": "my_nextPageToken"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Agent$Environments$Intents$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Agent$Environments$Intents$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1ListIntentsResponse>>;
        list(params: Params$Resource$Projects$Agent$Environments$Intents$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Agent$Environments$Intents$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListIntentsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListIntentsResponse>): void;
        list(params: Params$Resource$Projects$Agent$Environments$Intents$List, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListIntentsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListIntentsResponse>): void;
    }
    export interface Params$Resource$Projects$Agent$Environments$Intents$List extends StandardParameters {
        /**
         *
         */
        intentView?: string;
        /**
         *
         */
        languageCode?: string;
        /**
         *
         */
        pageSize?: number;
        /**
         *
         */
        pageToken?: string;
        /**
         *
         */
        parent?: string;
    }
    export class Resource$Projects$Agent$Environments$Users {
        context: APIRequestContext;
        sessions: Resource$Projects$Agent$Environments$Users$Sessions;
        constructor(context: APIRequestContext);
    }
    export class Resource$Projects$Agent$Environments$Users$Sessions {
        context: APIRequestContext;
        contexts: Resource$Projects$Agent$Environments$Users$Sessions$Contexts;
        entityTypes: Resource$Projects$Agent$Environments$Users$Sessions$Entitytypes;
        constructor(context: APIRequestContext);
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await dialogflow.projects.agent.environments.users.sessions.deleteContexts({
         *       parent:
         *         'projects/my-project/agent/environments/my-environment/users/my-user/sessions/my-session',
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {}
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        deleteContexts(params: Params$Resource$Projects$Agent$Environments$Users$Sessions$Deletecontexts, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        deleteContexts(params?: Params$Resource$Projects$Agent$Environments$Users$Sessions$Deletecontexts, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleProtobufEmpty>>;
        deleteContexts(params: Params$Resource$Projects$Agent$Environments$Users$Sessions$Deletecontexts, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        deleteContexts(params: Params$Resource$Projects$Agent$Environments$Users$Sessions$Deletecontexts, options: MethodOptions | BodyResponseCallback<Schema$GoogleProtobufEmpty>, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        deleteContexts(params: Params$Resource$Projects$Agent$Environments$Users$Sessions$Deletecontexts, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        deleteContexts(callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await dialogflow.projects.agent.environments.users.sessions.detectIntent({
         *       session:
         *         'projects/my-project/agent/environments/my-environment/users/my-user/sessions/my-session',
         *
         *       // Request body metadata
         *       requestBody: {
         *         // request body parameters
         *         // {
         *         //   "inputAudio": "my_inputAudio",
         *         //   "outputAudioConfig": {},
         *         //   "outputAudioConfigMask": "my_outputAudioConfigMask",
         *         //   "queryInput": {},
         *         //   "queryParams": {}
         *         // }
         *       },
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "alternativeQueryResults": [],
         *   //   "outputAudio": "my_outputAudio",
         *   //   "outputAudioConfig": {},
         *   //   "queryResult": {},
         *   //   "responseId": "my_responseId",
         *   //   "webhookStatus": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        detectIntent(params: Params$Resource$Projects$Agent$Environments$Users$Sessions$Detectintent, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        detectIntent(params?: Params$Resource$Projects$Agent$Environments$Users$Sessions$Detectintent, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1DetectIntentResponse>>;
        detectIntent(params: Params$Resource$Projects$Agent$Environments$Users$Sessions$Detectintent, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        detectIntent(params: Params$Resource$Projects$Agent$Environments$Users$Sessions$Detectintent, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1DetectIntentResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1DetectIntentResponse>): void;
        detectIntent(params: Params$Resource$Projects$Agent$Environments$Users$Sessions$Detectintent, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1DetectIntentResponse>): void;
        detectIntent(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1DetectIntentResponse>): void;
    }
    export interface Params$Resource$Projects$Agent$Environments$Users$Sessions$Deletecontexts extends StandardParameters {
        /**
         *
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Agent$Environments$Users$Sessions$Detectintent extends StandardParameters {
        /**
         *
         */
        session?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1DetectIntentRequest;
    }
    export class Resource$Projects$Agent$Environments$Users$Sessions$Contexts {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await dialogflow.projects.agent.environments.users.sessions.contexts.create(
         *       {
         *         parent:
         *           'projects/my-project/agent/environments/my-environment/users/my-user/sessions/my-session',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "lifespanCount": 0,
         *           //   "name": "my_name",
         *           //   "parameters": {}
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "lifespanCount": 0,
         *   //   "name": "my_name",
         *   //   "parameters": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Projects$Agent$Environments$Users$Sessions$Contexts$Create, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        create(params?: Params$Resource$Projects$Agent$Environments$Users$Sessions$Contexts$Create, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1Context>>;
        create(params: Params$Resource$Projects$Agent$Environments$Users$Sessions$Contexts$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Projects$Agent$Environments$Users$Sessions$Contexts$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Context>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Context>): void;
        create(params: Params$Resource$Projects$Agent$Environments$Users$Sessions$Contexts$Create, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Context>): void;
        create(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Context>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await dialogflow.projects.agent.environments.users.sessions.contexts.delete(
         *       {
         *         name: 'projects/my-project/agent/environments/my-environment/users/my-user/sessions/my-session/contexts/my-context',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {}
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Projects$Agent$Environments$Users$Sessions$Contexts$Delete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        delete(params?: Params$Resource$Projects$Agent$Environments$Users$Sessions$Contexts$Delete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleProtobufEmpty>>;
        delete(params: Params$Resource$Projects$Agent$Environments$Users$Sessions$Contexts$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Projects$Agent$Environments$Users$Sessions$Contexts$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleProtobufEmpty>, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(params: Params$Resource$Projects$Agent$Environments$Users$Sessions$Contexts$Delete, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await dialogflow.projects.agent.environments.users.sessions.contexts.get({
         *       name: 'projects/my-project/agent/environments/my-environment/users/my-user/sessions/my-session/contexts/my-context',
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "lifespanCount": 0,
         *   //   "name": "my_name",
         *   //   "parameters": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Agent$Environments$Users$Sessions$Contexts$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Agent$Environments$Users$Sessions$Contexts$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1Context>>;
        get(params: Params$Resource$Projects$Agent$Environments$Users$Sessions$Contexts$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Agent$Environments$Users$Sessions$Contexts$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Context>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Context>): void;
        get(params: Params$Resource$Projects$Agent$Environments$Users$Sessions$Contexts$Get, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Context>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Context>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await dialogflow.projects.agent.environments.users.sessions.contexts.list({
         *       pageSize: 'placeholder-value',
         *
         *       pageToken: 'placeholder-value',
         *
         *       parent:
         *         'projects/my-project/agent/environments/my-environment/users/my-user/sessions/my-session',
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "contexts": [],
         *   //   "nextPageToken": "my_nextPageToken"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Agent$Environments$Users$Sessions$Contexts$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Agent$Environments$Users$Sessions$Contexts$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1ListContextsResponse>>;
        list(params: Params$Resource$Projects$Agent$Environments$Users$Sessions$Contexts$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Agent$Environments$Users$Sessions$Contexts$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListContextsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListContextsResponse>): void;
        list(params: Params$Resource$Projects$Agent$Environments$Users$Sessions$Contexts$List, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListContextsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListContextsResponse>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await dialogflow.projects.agent.environments.users.sessions.contexts.patch({
         *       name: 'projects/my-project/agent/environments/my-environment/users/my-user/sessions/my-session/contexts/my-context',
         *
         *       updateMask: 'placeholder-value',
         *
         *       // Request body metadata
         *       requestBody: {
         *         // request body parameters
         *         // {
         *         //   "lifespanCount": 0,
         *         //   "name": "my_name",
         *         //   "parameters": {}
         *         // }
         *       },
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "lifespanCount": 0,
         *   //   "name": "my_name",
         *   //   "parameters": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        patch(params: Params$Resource$Projects$Agent$Environments$Users$Sessions$Contexts$Patch, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        patch(params?: Params$Resource$Projects$Agent$Environments$Users$Sessions$Contexts$Patch, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1Context>>;
        patch(params: Params$Resource$Projects$Agent$Environments$Users$Sessions$Contexts$Patch, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        patch(params: Params$Resource$Projects$Agent$Environments$Users$Sessions$Contexts$Patch, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Context>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Context>): void;
        patch(params: Params$Resource$Projects$Agent$Environments$Users$Sessions$Contexts$Patch, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Context>): void;
        patch(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Context>): void;
    }
    export interface Params$Resource$Projects$Agent$Environments$Users$Sessions$Contexts$Create extends StandardParameters {
        /**
         *
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1Context;
    }
    export interface Params$Resource$Projects$Agent$Environments$Users$Sessions$Contexts$Delete extends StandardParameters {
        /**
         *
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Agent$Environments$Users$Sessions$Contexts$Get extends StandardParameters {
        /**
         *
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Agent$Environments$Users$Sessions$Contexts$List extends StandardParameters {
        /**
         *
         */
        pageSize?: number;
        /**
         *
         */
        pageToken?: string;
        /**
         *
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Agent$Environments$Users$Sessions$Contexts$Patch extends StandardParameters {
        /**
         *
         */
        name?: string;
        /**
         *
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1Context;
    }
    export class Resource$Projects$Agent$Environments$Users$Sessions$Entitytypes {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await dialogflow.projects.agent.environments.users.sessions.entityTypes.create(
         *       {
         *         parent:
         *           'projects/my-project/agent/environments/my-environment/users/my-user/sessions/my-session',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "entities": [],
         *           //   "entityOverrideMode": "my_entityOverrideMode",
         *           //   "name": "my_name"
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "entities": [],
         *   //   "entityOverrideMode": "my_entityOverrideMode",
         *   //   "name": "my_name"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Projects$Agent$Environments$Users$Sessions$Entitytypes$Create, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        create(params?: Params$Resource$Projects$Agent$Environments$Users$Sessions$Entitytypes$Create, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>>;
        create(params: Params$Resource$Projects$Agent$Environments$Users$Sessions$Entitytypes$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Projects$Agent$Environments$Users$Sessions$Entitytypes$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>): void;
        create(params: Params$Resource$Projects$Agent$Environments$Users$Sessions$Entitytypes$Create, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>): void;
        create(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await dialogflow.projects.agent.environments.users.sessions.entityTypes.delete(
         *       {
         *         name: 'projects/my-project/agent/environments/my-environment/users/my-user/sessions/my-session/entityTypes/my-entityType',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {}
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Projects$Agent$Environments$Users$Sessions$Entitytypes$Delete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        delete(params?: Params$Resource$Projects$Agent$Environments$Users$Sessions$Entitytypes$Delete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleProtobufEmpty>>;
        delete(params: Params$Resource$Projects$Agent$Environments$Users$Sessions$Entitytypes$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Projects$Agent$Environments$Users$Sessions$Entitytypes$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleProtobufEmpty>, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(params: Params$Resource$Projects$Agent$Environments$Users$Sessions$Entitytypes$Delete, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await dialogflow.projects.agent.environments.users.sessions.entityTypes.get(
         *       {
         *         name: 'projects/my-project/agent/environments/my-environment/users/my-user/sessions/my-session/entityTypes/my-entityType',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "entities": [],
         *   //   "entityOverrideMode": "my_entityOverrideMode",
         *   //   "name": "my_name"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Agent$Environments$Users$Sessions$Entitytypes$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Agent$Environments$Users$Sessions$Entitytypes$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>>;
        get(params: Params$Resource$Projects$Agent$Environments$Users$Sessions$Entitytypes$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Agent$Environments$Users$Sessions$Entitytypes$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>): void;
        get(params: Params$Resource$Projects$Agent$Environments$Users$Sessions$Entitytypes$Get, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await dialogflow.projects.agent.environments.users.sessions.entityTypes.list(
         *       {
         *         pageSize: 'placeholder-value',
         *
         *         pageToken: 'placeholder-value',
         *
         *         parent:
         *           'projects/my-project/agent/environments/my-environment/users/my-user/sessions/my-session',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "nextPageToken": "my_nextPageToken",
         *   //   "sessionEntityTypes": []
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Agent$Environments$Users$Sessions$Entitytypes$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Agent$Environments$Users$Sessions$Entitytypes$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1ListSessionEntityTypesResponse>>;
        list(params: Params$Resource$Projects$Agent$Environments$Users$Sessions$Entitytypes$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Agent$Environments$Users$Sessions$Entitytypes$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListSessionEntityTypesResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListSessionEntityTypesResponse>): void;
        list(params: Params$Resource$Projects$Agent$Environments$Users$Sessions$Entitytypes$List, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListSessionEntityTypesResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListSessionEntityTypesResponse>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await dialogflow.projects.agent.environments.users.sessions.entityTypes.patch(
         *       {
         *         name: 'projects/my-project/agent/environments/my-environment/users/my-user/sessions/my-session/entityTypes/my-entityType',
         *
         *         updateMask: 'placeholder-value',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "entities": [],
         *           //   "entityOverrideMode": "my_entityOverrideMode",
         *           //   "name": "my_name"
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "entities": [],
         *   //   "entityOverrideMode": "my_entityOverrideMode",
         *   //   "name": "my_name"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        patch(params: Params$Resource$Projects$Agent$Environments$Users$Sessions$Entitytypes$Patch, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        patch(params?: Params$Resource$Projects$Agent$Environments$Users$Sessions$Entitytypes$Patch, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>>;
        patch(params: Params$Resource$Projects$Agent$Environments$Users$Sessions$Entitytypes$Patch, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        patch(params: Params$Resource$Projects$Agent$Environments$Users$Sessions$Entitytypes$Patch, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>): void;
        patch(params: Params$Resource$Projects$Agent$Environments$Users$Sessions$Entitytypes$Patch, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>): void;
        patch(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>): void;
    }
    export interface Params$Resource$Projects$Agent$Environments$Users$Sessions$Entitytypes$Create extends StandardParameters {
        /**
         *
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1SessionEntityType;
    }
    export interface Params$Resource$Projects$Agent$Environments$Users$Sessions$Entitytypes$Delete extends StandardParameters {
        /**
         *
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Agent$Environments$Users$Sessions$Entitytypes$Get extends StandardParameters {
        /**
         *
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Agent$Environments$Users$Sessions$Entitytypes$List extends StandardParameters {
        /**
         *
         */
        pageSize?: number;
        /**
         *
         */
        pageToken?: string;
        /**
         *
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Agent$Environments$Users$Sessions$Entitytypes$Patch extends StandardParameters {
        /**
         *
         */
        name?: string;
        /**
         *
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1SessionEntityType;
    }
    export class Resource$Projects$Agent$Intents {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.intents.batchDelete({
         *     parent: 'projects/my-project/agent',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "intents": []
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        batchDelete(params: Params$Resource$Projects$Agent$Intents$Batchdelete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        batchDelete(params?: Params$Resource$Projects$Agent$Intents$Batchdelete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        batchDelete(params: Params$Resource$Projects$Agent$Intents$Batchdelete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        batchDelete(params: Params$Resource$Projects$Agent$Intents$Batchdelete, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        batchDelete(params: Params$Resource$Projects$Agent$Intents$Batchdelete, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        batchDelete(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.intents.batchUpdate({
         *     parent: 'projects/my-project/agent',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "intentBatchInline": {},
         *       //   "intentBatchUri": "my_intentBatchUri",
         *       //   "intentView": "my_intentView",
         *       //   "languageCode": "my_languageCode",
         *       //   "updateMask": "my_updateMask"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        batchUpdate(params: Params$Resource$Projects$Agent$Intents$Batchupdate, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        batchUpdate(params?: Params$Resource$Projects$Agent$Intents$Batchupdate, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        batchUpdate(params: Params$Resource$Projects$Agent$Intents$Batchupdate, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        batchUpdate(params: Params$Resource$Projects$Agent$Intents$Batchupdate, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        batchUpdate(params: Params$Resource$Projects$Agent$Intents$Batchupdate, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        batchUpdate(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.intents.create({
         *     intentView: 'placeholder-value',
         *
         *     languageCode: 'placeholder-value',
         *
         *     parent: 'projects/my-project/agent',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "action": "my_action",
         *       //   "defaultResponsePlatforms": [],
         *       //   "displayName": "my_displayName",
         *       //   "endInteraction": false,
         *       //   "events": [],
         *       //   "followupIntentInfo": [],
         *       //   "inputContextNames": [],
         *       //   "isFallback": false,
         *       //   "liveAgentHandoff": false,
         *       //   "messages": [],
         *       //   "mlDisabled": false,
         *       //   "mlEnabled": false,
         *       //   "name": "my_name",
         *       //   "outputContexts": [],
         *       //   "parameters": [],
         *       //   "parentFollowupIntentName": "my_parentFollowupIntentName",
         *       //   "priority": 0,
         *       //   "resetContexts": false,
         *       //   "rootFollowupIntentName": "my_rootFollowupIntentName",
         *       //   "trainingPhrases": [],
         *       //   "webhookState": "my_webhookState"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "action": "my_action",
         *   //   "defaultResponsePlatforms": [],
         *   //   "displayName": "my_displayName",
         *   //   "endInteraction": false,
         *   //   "events": [],
         *   //   "followupIntentInfo": [],
         *   //   "inputContextNames": [],
         *   //   "isFallback": false,
         *   //   "liveAgentHandoff": false,
         *   //   "messages": [],
         *   //   "mlDisabled": false,
         *   //   "mlEnabled": false,
         *   //   "name": "my_name",
         *   //   "outputContexts": [],
         *   //   "parameters": [],
         *   //   "parentFollowupIntentName": "my_parentFollowupIntentName",
         *   //   "priority": 0,
         *   //   "resetContexts": false,
         *   //   "rootFollowupIntentName": "my_rootFollowupIntentName",
         *   //   "trainingPhrases": [],
         *   //   "webhookState": "my_webhookState"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Projects$Agent$Intents$Create, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        create(params?: Params$Resource$Projects$Agent$Intents$Create, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1Intent>>;
        create(params: Params$Resource$Projects$Agent$Intents$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Projects$Agent$Intents$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Intent>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Intent>): void;
        create(params: Params$Resource$Projects$Agent$Intents$Create, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Intent>): void;
        create(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Intent>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.intents.delete({
         *     name: 'projects/my-project/agent/intents/my-intent',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {}
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Projects$Agent$Intents$Delete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        delete(params?: Params$Resource$Projects$Agent$Intents$Delete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleProtobufEmpty>>;
        delete(params: Params$Resource$Projects$Agent$Intents$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Projects$Agent$Intents$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleProtobufEmpty>, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(params: Params$Resource$Projects$Agent$Intents$Delete, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.intents.get({
         *     intentView: 'placeholder-value',
         *
         *     languageCode: 'placeholder-value',
         *
         *     name: 'projects/my-project/agent/intents/my-intent',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "action": "my_action",
         *   //   "defaultResponsePlatforms": [],
         *   //   "displayName": "my_displayName",
         *   //   "endInteraction": false,
         *   //   "events": [],
         *   //   "followupIntentInfo": [],
         *   //   "inputContextNames": [],
         *   //   "isFallback": false,
         *   //   "liveAgentHandoff": false,
         *   //   "messages": [],
         *   //   "mlDisabled": false,
         *   //   "mlEnabled": false,
         *   //   "name": "my_name",
         *   //   "outputContexts": [],
         *   //   "parameters": [],
         *   //   "parentFollowupIntentName": "my_parentFollowupIntentName",
         *   //   "priority": 0,
         *   //   "resetContexts": false,
         *   //   "rootFollowupIntentName": "my_rootFollowupIntentName",
         *   //   "trainingPhrases": [],
         *   //   "webhookState": "my_webhookState"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Agent$Intents$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Agent$Intents$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1Intent>>;
        get(params: Params$Resource$Projects$Agent$Intents$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Agent$Intents$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Intent>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Intent>): void;
        get(params: Params$Resource$Projects$Agent$Intents$Get, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Intent>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Intent>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.intents.list({
         *     intentView: 'placeholder-value',
         *
         *     languageCode: 'placeholder-value',
         *
         *     pageSize: 'placeholder-value',
         *
         *     pageToken: 'placeholder-value',
         *
         *     parent: 'projects/my-project/agent',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "intents": [],
         *   //   "nextPageToken": "my_nextPageToken"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Agent$Intents$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Agent$Intents$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1ListIntentsResponse>>;
        list(params: Params$Resource$Projects$Agent$Intents$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Agent$Intents$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListIntentsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListIntentsResponse>): void;
        list(params: Params$Resource$Projects$Agent$Intents$List, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListIntentsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListIntentsResponse>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.intents.patch({
         *     intentView: 'placeholder-value',
         *
         *     languageCode: 'placeholder-value',
         *
         *     name: 'projects/my-project/agent/intents/my-intent',
         *
         *     updateMask: 'placeholder-value',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "action": "my_action",
         *       //   "defaultResponsePlatforms": [],
         *       //   "displayName": "my_displayName",
         *       //   "endInteraction": false,
         *       //   "events": [],
         *       //   "followupIntentInfo": [],
         *       //   "inputContextNames": [],
         *       //   "isFallback": false,
         *       //   "liveAgentHandoff": false,
         *       //   "messages": [],
         *       //   "mlDisabled": false,
         *       //   "mlEnabled": false,
         *       //   "name": "my_name",
         *       //   "outputContexts": [],
         *       //   "parameters": [],
         *       //   "parentFollowupIntentName": "my_parentFollowupIntentName",
         *       //   "priority": 0,
         *       //   "resetContexts": false,
         *       //   "rootFollowupIntentName": "my_rootFollowupIntentName",
         *       //   "trainingPhrases": [],
         *       //   "webhookState": "my_webhookState"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "action": "my_action",
         *   //   "defaultResponsePlatforms": [],
         *   //   "displayName": "my_displayName",
         *   //   "endInteraction": false,
         *   //   "events": [],
         *   //   "followupIntentInfo": [],
         *   //   "inputContextNames": [],
         *   //   "isFallback": false,
         *   //   "liveAgentHandoff": false,
         *   //   "messages": [],
         *   //   "mlDisabled": false,
         *   //   "mlEnabled": false,
         *   //   "name": "my_name",
         *   //   "outputContexts": [],
         *   //   "parameters": [],
         *   //   "parentFollowupIntentName": "my_parentFollowupIntentName",
         *   //   "priority": 0,
         *   //   "resetContexts": false,
         *   //   "rootFollowupIntentName": "my_rootFollowupIntentName",
         *   //   "trainingPhrases": [],
         *   //   "webhookState": "my_webhookState"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        patch(params: Params$Resource$Projects$Agent$Intents$Patch, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        patch(params?: Params$Resource$Projects$Agent$Intents$Patch, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1Intent>>;
        patch(params: Params$Resource$Projects$Agent$Intents$Patch, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        patch(params: Params$Resource$Projects$Agent$Intents$Patch, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Intent>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Intent>): void;
        patch(params: Params$Resource$Projects$Agent$Intents$Patch, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Intent>): void;
        patch(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Intent>): void;
    }
    export interface Params$Resource$Projects$Agent$Intents$Batchdelete extends StandardParameters {
        /**
         *
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1BatchDeleteIntentsRequest;
    }
    export interface Params$Resource$Projects$Agent$Intents$Batchupdate extends StandardParameters {
        /**
         *
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1BatchUpdateIntentsRequest;
    }
    export interface Params$Resource$Projects$Agent$Intents$Create extends StandardParameters {
        /**
         *
         */
        intentView?: string;
        /**
         *
         */
        languageCode?: string;
        /**
         *
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1Intent;
    }
    export interface Params$Resource$Projects$Agent$Intents$Delete extends StandardParameters {
        /**
         *
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Agent$Intents$Get extends StandardParameters {
        /**
         *
         */
        intentView?: string;
        /**
         *
         */
        languageCode?: string;
        /**
         *
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Agent$Intents$List extends StandardParameters {
        /**
         *
         */
        intentView?: string;
        /**
         *
         */
        languageCode?: string;
        /**
         *
         */
        pageSize?: number;
        /**
         *
         */
        pageToken?: string;
        /**
         *
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Agent$Intents$Patch extends StandardParameters {
        /**
         *
         */
        intentView?: string;
        /**
         *
         */
        languageCode?: string;
        /**
         *
         */
        name?: string;
        /**
         *
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1Intent;
    }
    export class Resource$Projects$Agent$Knowledgebases {
        context: APIRequestContext;
        documents: Resource$Projects$Agent$Knowledgebases$Documents;
        constructor(context: APIRequestContext);
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.knowledgeBases.create({
         *     parent: 'projects/my-project/agent',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "displayName": "my_displayName",
         *       //   "languageCode": "my_languageCode",
         *       //   "name": "my_name"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "displayName": "my_displayName",
         *   //   "languageCode": "my_languageCode",
         *   //   "name": "my_name"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Projects$Agent$Knowledgebases$Create, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        create(params?: Params$Resource$Projects$Agent$Knowledgebases$Create, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1KnowledgeBase>>;
        create(params: Params$Resource$Projects$Agent$Knowledgebases$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Projects$Agent$Knowledgebases$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1KnowledgeBase>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1KnowledgeBase>): void;
        create(params: Params$Resource$Projects$Agent$Knowledgebases$Create, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1KnowledgeBase>): void;
        create(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1KnowledgeBase>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.knowledgeBases.delete({
         *     force: 'placeholder-value',
         *
         *     name: 'projects/my-project/agent/knowledgeBases/my-knowledgeBase',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {}
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Projects$Agent$Knowledgebases$Delete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        delete(params?: Params$Resource$Projects$Agent$Knowledgebases$Delete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleProtobufEmpty>>;
        delete(params: Params$Resource$Projects$Agent$Knowledgebases$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Projects$Agent$Knowledgebases$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleProtobufEmpty>, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(params: Params$Resource$Projects$Agent$Knowledgebases$Delete, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.knowledgeBases.get({
         *     name: 'projects/my-project/agent/knowledgeBases/my-knowledgeBase',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "displayName": "my_displayName",
         *   //   "languageCode": "my_languageCode",
         *   //   "name": "my_name"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Agent$Knowledgebases$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Agent$Knowledgebases$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1KnowledgeBase>>;
        get(params: Params$Resource$Projects$Agent$Knowledgebases$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Agent$Knowledgebases$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1KnowledgeBase>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1KnowledgeBase>): void;
        get(params: Params$Resource$Projects$Agent$Knowledgebases$Get, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1KnowledgeBase>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1KnowledgeBase>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.knowledgeBases.list({
         *     filter: 'placeholder-value',
         *
         *     pageSize: 'placeholder-value',
         *
         *     pageToken: 'placeholder-value',
         *
         *     parent: 'projects/my-project/agent',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "knowledgeBases": [],
         *   //   "nextPageToken": "my_nextPageToken"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Agent$Knowledgebases$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Agent$Knowledgebases$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1ListKnowledgeBasesResponse>>;
        list(params: Params$Resource$Projects$Agent$Knowledgebases$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Agent$Knowledgebases$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListKnowledgeBasesResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListKnowledgeBasesResponse>): void;
        list(params: Params$Resource$Projects$Agent$Knowledgebases$List, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListKnowledgeBasesResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListKnowledgeBasesResponse>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.knowledgeBases.patch({
         *     name: 'projects/my-project/agent/knowledgeBases/my-knowledgeBase',
         *
         *     updateMask: 'placeholder-value',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "displayName": "my_displayName",
         *       //   "languageCode": "my_languageCode",
         *       //   "name": "my_name"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "displayName": "my_displayName",
         *   //   "languageCode": "my_languageCode",
         *   //   "name": "my_name"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        patch(params: Params$Resource$Projects$Agent$Knowledgebases$Patch, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        patch(params?: Params$Resource$Projects$Agent$Knowledgebases$Patch, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1KnowledgeBase>>;
        patch(params: Params$Resource$Projects$Agent$Knowledgebases$Patch, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        patch(params: Params$Resource$Projects$Agent$Knowledgebases$Patch, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1KnowledgeBase>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1KnowledgeBase>): void;
        patch(params: Params$Resource$Projects$Agent$Knowledgebases$Patch, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1KnowledgeBase>): void;
        patch(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1KnowledgeBase>): void;
    }
    export interface Params$Resource$Projects$Agent$Knowledgebases$Create extends StandardParameters {
        /**
         *
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1KnowledgeBase;
    }
    export interface Params$Resource$Projects$Agent$Knowledgebases$Delete extends StandardParameters {
        /**
         *
         */
        force?: boolean;
        /**
         *
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Agent$Knowledgebases$Get extends StandardParameters {
        /**
         *
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Agent$Knowledgebases$List extends StandardParameters {
        /**
         *
         */
        filter?: string;
        /**
         *
         */
        pageSize?: number;
        /**
         *
         */
        pageToken?: string;
        /**
         *
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Agent$Knowledgebases$Patch extends StandardParameters {
        /**
         *
         */
        name?: string;
        /**
         *
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1KnowledgeBase;
    }
    export class Resource$Projects$Agent$Knowledgebases$Documents {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.knowledgeBases.documents.create({
         *     importGcsCustomMetadata: 'placeholder-value',
         *
         *     parent: 'projects/my-project/agent/knowledgeBases/my-knowledgeBase',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "content": "my_content",
         *       //   "contentUri": "my_contentUri",
         *       //   "displayName": "my_displayName",
         *       //   "enableAutoReload": false,
         *       //   "knowledgeTypes": [],
         *       //   "latestReloadStatus": {},
         *       //   "metadata": {},
         *       //   "mimeType": "my_mimeType",
         *       //   "name": "my_name",
         *       //   "rawContent": "my_rawContent",
         *       //   "state": "my_state"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Projects$Agent$Knowledgebases$Documents$Create, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        create(params?: Params$Resource$Projects$Agent$Knowledgebases$Documents$Create, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        create(params: Params$Resource$Projects$Agent$Knowledgebases$Documents$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Projects$Agent$Knowledgebases$Documents$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        create(params: Params$Resource$Projects$Agent$Knowledgebases$Documents$Create, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        create(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.knowledgeBases.documents.delete({
         *     name: 'projects/my-project/agent/knowledgeBases/my-knowledgeBase/documents/my-document',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Projects$Agent$Knowledgebases$Documents$Delete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        delete(params?: Params$Resource$Projects$Agent$Knowledgebases$Documents$Delete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        delete(params: Params$Resource$Projects$Agent$Knowledgebases$Documents$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Projects$Agent$Knowledgebases$Documents$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        delete(params: Params$Resource$Projects$Agent$Knowledgebases$Documents$Delete, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.knowledgeBases.documents.get({
         *     name: 'projects/my-project/agent/knowledgeBases/my-knowledgeBase/documents/my-document',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "content": "my_content",
         *   //   "contentUri": "my_contentUri",
         *   //   "displayName": "my_displayName",
         *   //   "enableAutoReload": false,
         *   //   "knowledgeTypes": [],
         *   //   "latestReloadStatus": {},
         *   //   "metadata": {},
         *   //   "mimeType": "my_mimeType",
         *   //   "name": "my_name",
         *   //   "rawContent": "my_rawContent",
         *   //   "state": "my_state"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Agent$Knowledgebases$Documents$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Agent$Knowledgebases$Documents$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1Document>>;
        get(params: Params$Resource$Projects$Agent$Knowledgebases$Documents$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Agent$Knowledgebases$Documents$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Document>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Document>): void;
        get(params: Params$Resource$Projects$Agent$Knowledgebases$Documents$Get, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Document>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Document>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.knowledgeBases.documents.list({
         *     filter: 'placeholder-value',
         *
         *     pageSize: 'placeholder-value',
         *
         *     pageToken: 'placeholder-value',
         *
         *     parent: 'projects/my-project/agent/knowledgeBases/my-knowledgeBase',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "documents": [],
         *   //   "nextPageToken": "my_nextPageToken"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Agent$Knowledgebases$Documents$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Agent$Knowledgebases$Documents$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1ListDocumentsResponse>>;
        list(params: Params$Resource$Projects$Agent$Knowledgebases$Documents$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Agent$Knowledgebases$Documents$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListDocumentsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListDocumentsResponse>): void;
        list(params: Params$Resource$Projects$Agent$Knowledgebases$Documents$List, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListDocumentsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListDocumentsResponse>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.knowledgeBases.documents.patch({
         *     name: 'projects/my-project/agent/knowledgeBases/my-knowledgeBase/documents/my-document',
         *
         *     updateMask: 'placeholder-value',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "content": "my_content",
         *       //   "contentUri": "my_contentUri",
         *       //   "displayName": "my_displayName",
         *       //   "enableAutoReload": false,
         *       //   "knowledgeTypes": [],
         *       //   "latestReloadStatus": {},
         *       //   "metadata": {},
         *       //   "mimeType": "my_mimeType",
         *       //   "name": "my_name",
         *       //   "rawContent": "my_rawContent",
         *       //   "state": "my_state"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        patch(params: Params$Resource$Projects$Agent$Knowledgebases$Documents$Patch, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        patch(params?: Params$Resource$Projects$Agent$Knowledgebases$Documents$Patch, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        patch(params: Params$Resource$Projects$Agent$Knowledgebases$Documents$Patch, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        patch(params: Params$Resource$Projects$Agent$Knowledgebases$Documents$Patch, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        patch(params: Params$Resource$Projects$Agent$Knowledgebases$Documents$Patch, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        patch(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.knowledgeBases.documents.reload({
         *     name: 'projects/my-project/agent/knowledgeBases/my-knowledgeBase/documents/my-document',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "gcsSource": {},
         *       //   "importGcsCustomMetadata": false
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        reload(params: Params$Resource$Projects$Agent$Knowledgebases$Documents$Reload, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        reload(params?: Params$Resource$Projects$Agent$Knowledgebases$Documents$Reload, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        reload(params: Params$Resource$Projects$Agent$Knowledgebases$Documents$Reload, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        reload(params: Params$Resource$Projects$Agent$Knowledgebases$Documents$Reload, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        reload(params: Params$Resource$Projects$Agent$Knowledgebases$Documents$Reload, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        reload(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
    }
    export interface Params$Resource$Projects$Agent$Knowledgebases$Documents$Create extends StandardParameters {
        /**
         *
         */
        importGcsCustomMetadata?: boolean;
        /**
         *
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1Document;
    }
    export interface Params$Resource$Projects$Agent$Knowledgebases$Documents$Delete extends StandardParameters {
        /**
         *
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Agent$Knowledgebases$Documents$Get extends StandardParameters {
        /**
         *
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Agent$Knowledgebases$Documents$List extends StandardParameters {
        /**
         *
         */
        filter?: string;
        /**
         *
         */
        pageSize?: number;
        /**
         *
         */
        pageToken?: string;
        /**
         *
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Agent$Knowledgebases$Documents$Patch extends StandardParameters {
        /**
         *
         */
        name?: string;
        /**
         *
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1Document;
    }
    export interface Params$Resource$Projects$Agent$Knowledgebases$Documents$Reload extends StandardParameters {
        /**
         *
         */
        name?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1ReloadDocumentRequest;
    }
    export class Resource$Projects$Agent$Sessions {
        context: APIRequestContext;
        contexts: Resource$Projects$Agent$Sessions$Contexts;
        entityTypes: Resource$Projects$Agent$Sessions$Entitytypes;
        constructor(context: APIRequestContext);
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.sessions.deleteContexts({
         *     parent: 'projects/my-project/agent/sessions/my-session',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {}
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        deleteContexts(params: Params$Resource$Projects$Agent$Sessions$Deletecontexts, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        deleteContexts(params?: Params$Resource$Projects$Agent$Sessions$Deletecontexts, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleProtobufEmpty>>;
        deleteContexts(params: Params$Resource$Projects$Agent$Sessions$Deletecontexts, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        deleteContexts(params: Params$Resource$Projects$Agent$Sessions$Deletecontexts, options: MethodOptions | BodyResponseCallback<Schema$GoogleProtobufEmpty>, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        deleteContexts(params: Params$Resource$Projects$Agent$Sessions$Deletecontexts, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        deleteContexts(callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.sessions.detectIntent({
         *     session: 'projects/my-project/agent/sessions/my-session',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "inputAudio": "my_inputAudio",
         *       //   "outputAudioConfig": {},
         *       //   "outputAudioConfigMask": "my_outputAudioConfigMask",
         *       //   "queryInput": {},
         *       //   "queryParams": {}
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "alternativeQueryResults": [],
         *   //   "outputAudio": "my_outputAudio",
         *   //   "outputAudioConfig": {},
         *   //   "queryResult": {},
         *   //   "responseId": "my_responseId",
         *   //   "webhookStatus": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        detectIntent(params: Params$Resource$Projects$Agent$Sessions$Detectintent, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        detectIntent(params?: Params$Resource$Projects$Agent$Sessions$Detectintent, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1DetectIntentResponse>>;
        detectIntent(params: Params$Resource$Projects$Agent$Sessions$Detectintent, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        detectIntent(params: Params$Resource$Projects$Agent$Sessions$Detectintent, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1DetectIntentResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1DetectIntentResponse>): void;
        detectIntent(params: Params$Resource$Projects$Agent$Sessions$Detectintent, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1DetectIntentResponse>): void;
        detectIntent(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1DetectIntentResponse>): void;
    }
    export interface Params$Resource$Projects$Agent$Sessions$Deletecontexts extends StandardParameters {
        /**
         *
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Agent$Sessions$Detectintent extends StandardParameters {
        /**
         *
         */
        session?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1DetectIntentRequest;
    }
    export class Resource$Projects$Agent$Sessions$Contexts {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.sessions.contexts.create({
         *     parent: 'projects/my-project/agent/sessions/my-session',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "lifespanCount": 0,
         *       //   "name": "my_name",
         *       //   "parameters": {}
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "lifespanCount": 0,
         *   //   "name": "my_name",
         *   //   "parameters": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Projects$Agent$Sessions$Contexts$Create, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        create(params?: Params$Resource$Projects$Agent$Sessions$Contexts$Create, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1Context>>;
        create(params: Params$Resource$Projects$Agent$Sessions$Contexts$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Projects$Agent$Sessions$Contexts$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Context>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Context>): void;
        create(params: Params$Resource$Projects$Agent$Sessions$Contexts$Create, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Context>): void;
        create(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Context>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.sessions.contexts.delete({
         *     name: 'projects/my-project/agent/sessions/my-session/contexts/my-context',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {}
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Projects$Agent$Sessions$Contexts$Delete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        delete(params?: Params$Resource$Projects$Agent$Sessions$Contexts$Delete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleProtobufEmpty>>;
        delete(params: Params$Resource$Projects$Agent$Sessions$Contexts$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Projects$Agent$Sessions$Contexts$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleProtobufEmpty>, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(params: Params$Resource$Projects$Agent$Sessions$Contexts$Delete, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.sessions.contexts.get({
         *     name: 'projects/my-project/agent/sessions/my-session/contexts/my-context',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "lifespanCount": 0,
         *   //   "name": "my_name",
         *   //   "parameters": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Agent$Sessions$Contexts$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Agent$Sessions$Contexts$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1Context>>;
        get(params: Params$Resource$Projects$Agent$Sessions$Contexts$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Agent$Sessions$Contexts$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Context>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Context>): void;
        get(params: Params$Resource$Projects$Agent$Sessions$Contexts$Get, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Context>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Context>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.sessions.contexts.list({
         *     pageSize: 'placeholder-value',
         *
         *     pageToken: 'placeholder-value',
         *
         *     parent: 'projects/my-project/agent/sessions/my-session',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "contexts": [],
         *   //   "nextPageToken": "my_nextPageToken"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Agent$Sessions$Contexts$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Agent$Sessions$Contexts$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1ListContextsResponse>>;
        list(params: Params$Resource$Projects$Agent$Sessions$Contexts$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Agent$Sessions$Contexts$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListContextsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListContextsResponse>): void;
        list(params: Params$Resource$Projects$Agent$Sessions$Contexts$List, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListContextsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListContextsResponse>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.sessions.contexts.patch({
         *     name: 'projects/my-project/agent/sessions/my-session/contexts/my-context',
         *
         *     updateMask: 'placeholder-value',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "lifespanCount": 0,
         *       //   "name": "my_name",
         *       //   "parameters": {}
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "lifespanCount": 0,
         *   //   "name": "my_name",
         *   //   "parameters": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        patch(params: Params$Resource$Projects$Agent$Sessions$Contexts$Patch, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        patch(params?: Params$Resource$Projects$Agent$Sessions$Contexts$Patch, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1Context>>;
        patch(params: Params$Resource$Projects$Agent$Sessions$Contexts$Patch, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        patch(params: Params$Resource$Projects$Agent$Sessions$Contexts$Patch, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Context>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Context>): void;
        patch(params: Params$Resource$Projects$Agent$Sessions$Contexts$Patch, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Context>): void;
        patch(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Context>): void;
    }
    export interface Params$Resource$Projects$Agent$Sessions$Contexts$Create extends StandardParameters {
        /**
         *
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1Context;
    }
    export interface Params$Resource$Projects$Agent$Sessions$Contexts$Delete extends StandardParameters {
        /**
         *
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Agent$Sessions$Contexts$Get extends StandardParameters {
        /**
         *
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Agent$Sessions$Contexts$List extends StandardParameters {
        /**
         *
         */
        pageSize?: number;
        /**
         *
         */
        pageToken?: string;
        /**
         *
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Agent$Sessions$Contexts$Patch extends StandardParameters {
        /**
         *
         */
        name?: string;
        /**
         *
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1Context;
    }
    export class Resource$Projects$Agent$Sessions$Entitytypes {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.sessions.entityTypes.create({
         *     parent: 'projects/my-project/agent/sessions/my-session',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "entities": [],
         *       //   "entityOverrideMode": "my_entityOverrideMode",
         *       //   "name": "my_name"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "entities": [],
         *   //   "entityOverrideMode": "my_entityOverrideMode",
         *   //   "name": "my_name"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Projects$Agent$Sessions$Entitytypes$Create, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        create(params?: Params$Resource$Projects$Agent$Sessions$Entitytypes$Create, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>>;
        create(params: Params$Resource$Projects$Agent$Sessions$Entitytypes$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Projects$Agent$Sessions$Entitytypes$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>): void;
        create(params: Params$Resource$Projects$Agent$Sessions$Entitytypes$Create, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>): void;
        create(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.sessions.entityTypes.delete({
         *     name: 'projects/my-project/agent/sessions/my-session/entityTypes/my-entityType',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {}
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Projects$Agent$Sessions$Entitytypes$Delete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        delete(params?: Params$Resource$Projects$Agent$Sessions$Entitytypes$Delete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleProtobufEmpty>>;
        delete(params: Params$Resource$Projects$Agent$Sessions$Entitytypes$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Projects$Agent$Sessions$Entitytypes$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleProtobufEmpty>, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(params: Params$Resource$Projects$Agent$Sessions$Entitytypes$Delete, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.sessions.entityTypes.get({
         *     name: 'projects/my-project/agent/sessions/my-session/entityTypes/my-entityType',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "entities": [],
         *   //   "entityOverrideMode": "my_entityOverrideMode",
         *   //   "name": "my_name"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Agent$Sessions$Entitytypes$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Agent$Sessions$Entitytypes$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>>;
        get(params: Params$Resource$Projects$Agent$Sessions$Entitytypes$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Agent$Sessions$Entitytypes$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>): void;
        get(params: Params$Resource$Projects$Agent$Sessions$Entitytypes$Get, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.sessions.entityTypes.list({
         *     pageSize: 'placeholder-value',
         *
         *     pageToken: 'placeholder-value',
         *
         *     parent: 'projects/my-project/agent/sessions/my-session',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "nextPageToken": "my_nextPageToken",
         *   //   "sessionEntityTypes": []
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Agent$Sessions$Entitytypes$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Agent$Sessions$Entitytypes$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1ListSessionEntityTypesResponse>>;
        list(params: Params$Resource$Projects$Agent$Sessions$Entitytypes$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Agent$Sessions$Entitytypes$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListSessionEntityTypesResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListSessionEntityTypesResponse>): void;
        list(params: Params$Resource$Projects$Agent$Sessions$Entitytypes$List, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListSessionEntityTypesResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListSessionEntityTypesResponse>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.sessions.entityTypes.patch({
         *     name: 'projects/my-project/agent/sessions/my-session/entityTypes/my-entityType',
         *
         *     updateMask: 'placeholder-value',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "entities": [],
         *       //   "entityOverrideMode": "my_entityOverrideMode",
         *       //   "name": "my_name"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "entities": [],
         *   //   "entityOverrideMode": "my_entityOverrideMode",
         *   //   "name": "my_name"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        patch(params: Params$Resource$Projects$Agent$Sessions$Entitytypes$Patch, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        patch(params?: Params$Resource$Projects$Agent$Sessions$Entitytypes$Patch, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>>;
        patch(params: Params$Resource$Projects$Agent$Sessions$Entitytypes$Patch, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        patch(params: Params$Resource$Projects$Agent$Sessions$Entitytypes$Patch, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>): void;
        patch(params: Params$Resource$Projects$Agent$Sessions$Entitytypes$Patch, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>): void;
        patch(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>): void;
    }
    export interface Params$Resource$Projects$Agent$Sessions$Entitytypes$Create extends StandardParameters {
        /**
         *
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1SessionEntityType;
    }
    export interface Params$Resource$Projects$Agent$Sessions$Entitytypes$Delete extends StandardParameters {
        /**
         *
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Agent$Sessions$Entitytypes$Get extends StandardParameters {
        /**
         *
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Agent$Sessions$Entitytypes$List extends StandardParameters {
        /**
         *
         */
        pageSize?: number;
        /**
         *
         */
        pageToken?: string;
        /**
         *
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Agent$Sessions$Entitytypes$Patch extends StandardParameters {
        /**
         *
         */
        name?: string;
        /**
         *
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1SessionEntityType;
    }
    export class Resource$Projects$Agent$Versions {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.versions.create({
         *     parent: 'projects/my-project/agent',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "createTime": "my_createTime",
         *       //   "description": "my_description",
         *       //   "name": "my_name",
         *       //   "status": "my_status",
         *       //   "versionNumber": 0
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "createTime": "my_createTime",
         *   //   "description": "my_description",
         *   //   "name": "my_name",
         *   //   "status": "my_status",
         *   //   "versionNumber": 0
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Projects$Agent$Versions$Create, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        create(params?: Params$Resource$Projects$Agent$Versions$Create, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1Version>>;
        create(params: Params$Resource$Projects$Agent$Versions$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Projects$Agent$Versions$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Version>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Version>): void;
        create(params: Params$Resource$Projects$Agent$Versions$Create, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Version>): void;
        create(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Version>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.versions.delete({
         *     name: 'projects/my-project/agent/versions/my-version',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {}
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Projects$Agent$Versions$Delete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        delete(params?: Params$Resource$Projects$Agent$Versions$Delete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleProtobufEmpty>>;
        delete(params: Params$Resource$Projects$Agent$Versions$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Projects$Agent$Versions$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleProtobufEmpty>, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(params: Params$Resource$Projects$Agent$Versions$Delete, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.versions.get({
         *     name: 'projects/my-project/agent/versions/my-version',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "createTime": "my_createTime",
         *   //   "description": "my_description",
         *   //   "name": "my_name",
         *   //   "status": "my_status",
         *   //   "versionNumber": 0
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Agent$Versions$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Agent$Versions$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1Version>>;
        get(params: Params$Resource$Projects$Agent$Versions$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Agent$Versions$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Version>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Version>): void;
        get(params: Params$Resource$Projects$Agent$Versions$Get, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Version>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Version>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.versions.list({
         *     pageSize: 'placeholder-value',
         *
         *     pageToken: 'placeholder-value',
         *
         *     parent: 'projects/my-project/agent',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "nextPageToken": "my_nextPageToken",
         *   //   "versions": []
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Agent$Versions$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Agent$Versions$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1ListVersionsResponse>>;
        list(params: Params$Resource$Projects$Agent$Versions$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Agent$Versions$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListVersionsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListVersionsResponse>): void;
        list(params: Params$Resource$Projects$Agent$Versions$List, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListVersionsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListVersionsResponse>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.agent.versions.patch({
         *     name: 'projects/my-project/agent/versions/my-version',
         *
         *     updateMask: 'placeholder-value',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "createTime": "my_createTime",
         *       //   "description": "my_description",
         *       //   "name": "my_name",
         *       //   "status": "my_status",
         *       //   "versionNumber": 0
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "createTime": "my_createTime",
         *   //   "description": "my_description",
         *   //   "name": "my_name",
         *   //   "status": "my_status",
         *   //   "versionNumber": 0
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        patch(params: Params$Resource$Projects$Agent$Versions$Patch, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        patch(params?: Params$Resource$Projects$Agent$Versions$Patch, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1Version>>;
        patch(params: Params$Resource$Projects$Agent$Versions$Patch, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        patch(params: Params$Resource$Projects$Agent$Versions$Patch, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Version>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Version>): void;
        patch(params: Params$Resource$Projects$Agent$Versions$Patch, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Version>): void;
        patch(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Version>): void;
    }
    export interface Params$Resource$Projects$Agent$Versions$Create extends StandardParameters {
        /**
         *
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1Version;
    }
    export interface Params$Resource$Projects$Agent$Versions$Delete extends StandardParameters {
        /**
         *
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Agent$Versions$Get extends StandardParameters {
        /**
         *
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Agent$Versions$List extends StandardParameters {
        /**
         *
         */
        pageSize?: number;
        /**
         *
         */
        pageToken?: string;
        /**
         *
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Agent$Versions$Patch extends StandardParameters {
        /**
         *
         */
        name?: string;
        /**
         *
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1Version;
    }
    export class Resource$Projects$Answerrecords {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.answerRecords.get({
         *     name: 'projects/my-project/answerRecords/my-answerRecord',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "agentAssistantRecord": {},
         *   //   "answerFeedback": {},
         *   //   "name": "my_name"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Answerrecords$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Answerrecords$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1AnswerRecord>>;
        get(params: Params$Resource$Projects$Answerrecords$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Answerrecords$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1AnswerRecord>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1AnswerRecord>): void;
        get(params: Params$Resource$Projects$Answerrecords$Get, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1AnswerRecord>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1AnswerRecord>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.answerRecords.list({
         *     filter: 'placeholder-value',
         *
         *     pageSize: 'placeholder-value',
         *
         *     pageToken: 'placeholder-value',
         *
         *     parent: 'projects/my-project',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "answerRecords": [],
         *   //   "nextPageToken": "my_nextPageToken"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Answerrecords$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Answerrecords$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1ListAnswerRecordsResponse>>;
        list(params: Params$Resource$Projects$Answerrecords$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Answerrecords$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListAnswerRecordsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListAnswerRecordsResponse>): void;
        list(params: Params$Resource$Projects$Answerrecords$List, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListAnswerRecordsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListAnswerRecordsResponse>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.answerRecords.patch({
         *     name: 'projects/my-project/answerRecords/my-answerRecord',
         *
         *     updateMask: 'placeholder-value',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "agentAssistantRecord": {},
         *       //   "answerFeedback": {},
         *       //   "name": "my_name"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "agentAssistantRecord": {},
         *   //   "answerFeedback": {},
         *   //   "name": "my_name"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        patch(params: Params$Resource$Projects$Answerrecords$Patch, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        patch(params?: Params$Resource$Projects$Answerrecords$Patch, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1AnswerRecord>>;
        patch(params: Params$Resource$Projects$Answerrecords$Patch, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        patch(params: Params$Resource$Projects$Answerrecords$Patch, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1AnswerRecord>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1AnswerRecord>): void;
        patch(params: Params$Resource$Projects$Answerrecords$Patch, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1AnswerRecord>): void;
        patch(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1AnswerRecord>): void;
    }
    export interface Params$Resource$Projects$Answerrecords$Get extends StandardParameters {
        /**
         *
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Answerrecords$List extends StandardParameters {
        /**
         *
         */
        filter?: string;
        /**
         *
         */
        pageSize?: number;
        /**
         *
         */
        pageToken?: string;
        /**
         *
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Answerrecords$Patch extends StandardParameters {
        /**
         *
         */
        name?: string;
        /**
         *
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1AnswerRecord;
    }
    export class Resource$Projects$Conversationprofiles {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await dialogflow.projects.conversationProfiles.clearSuggestionFeatureConfig(
         *       {
         *         conversationProfile:
         *           'projects/my-project/conversationProfiles/my-conversationProfile',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "participantRole": "my_participantRole",
         *           //   "suggestionFeatureType": "my_suggestionFeatureType"
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        clearSuggestionFeatureConfig(params: Params$Resource$Projects$Conversationprofiles$Clearsuggestionfeatureconfig, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        clearSuggestionFeatureConfig(params?: Params$Resource$Projects$Conversationprofiles$Clearsuggestionfeatureconfig, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        clearSuggestionFeatureConfig(params: Params$Resource$Projects$Conversationprofiles$Clearsuggestionfeatureconfig, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        clearSuggestionFeatureConfig(params: Params$Resource$Projects$Conversationprofiles$Clearsuggestionfeatureconfig, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        clearSuggestionFeatureConfig(params: Params$Resource$Projects$Conversationprofiles$Clearsuggestionfeatureconfig, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        clearSuggestionFeatureConfig(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.conversationProfiles.create({
         *     parent: 'projects/my-project',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "automatedAgentConfig": {},
         *       //   "createTime": "my_createTime",
         *       //   "displayName": "my_displayName",
         *       //   "humanAgentAssistantConfig": {},
         *       //   "humanAgentHandoffConfig": {},
         *       //   "languageCode": "my_languageCode",
         *       //   "loggingConfig": {},
         *       //   "name": "my_name",
         *       //   "newMessageEventNotificationConfig": {},
         *       //   "newRecognitionResultNotificationConfig": {},
         *       //   "notificationConfig": {},
         *       //   "securitySettings": "my_securitySettings",
         *       //   "sttConfig": {},
         *       //   "timeZone": "my_timeZone",
         *       //   "ttsConfig": {},
         *       //   "updateTime": "my_updateTime"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "automatedAgentConfig": {},
         *   //   "createTime": "my_createTime",
         *   //   "displayName": "my_displayName",
         *   //   "humanAgentAssistantConfig": {},
         *   //   "humanAgentHandoffConfig": {},
         *   //   "languageCode": "my_languageCode",
         *   //   "loggingConfig": {},
         *   //   "name": "my_name",
         *   //   "newMessageEventNotificationConfig": {},
         *   //   "newRecognitionResultNotificationConfig": {},
         *   //   "notificationConfig": {},
         *   //   "securitySettings": "my_securitySettings",
         *   //   "sttConfig": {},
         *   //   "timeZone": "my_timeZone",
         *   //   "ttsConfig": {},
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Projects$Conversationprofiles$Create, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        create(params?: Params$Resource$Projects$Conversationprofiles$Create, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1ConversationProfile>>;
        create(params: Params$Resource$Projects$Conversationprofiles$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Projects$Conversationprofiles$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ConversationProfile>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ConversationProfile>): void;
        create(params: Params$Resource$Projects$Conversationprofiles$Create, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ConversationProfile>): void;
        create(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ConversationProfile>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.conversationProfiles.delete({
         *     name: 'projects/my-project/conversationProfiles/my-conversationProfile',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {}
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Projects$Conversationprofiles$Delete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        delete(params?: Params$Resource$Projects$Conversationprofiles$Delete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleProtobufEmpty>>;
        delete(params: Params$Resource$Projects$Conversationprofiles$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Projects$Conversationprofiles$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleProtobufEmpty>, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(params: Params$Resource$Projects$Conversationprofiles$Delete, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.conversationProfiles.get({
         *     name: 'projects/my-project/conversationProfiles/my-conversationProfile',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "automatedAgentConfig": {},
         *   //   "createTime": "my_createTime",
         *   //   "displayName": "my_displayName",
         *   //   "humanAgentAssistantConfig": {},
         *   //   "humanAgentHandoffConfig": {},
         *   //   "languageCode": "my_languageCode",
         *   //   "loggingConfig": {},
         *   //   "name": "my_name",
         *   //   "newMessageEventNotificationConfig": {},
         *   //   "newRecognitionResultNotificationConfig": {},
         *   //   "notificationConfig": {},
         *   //   "securitySettings": "my_securitySettings",
         *   //   "sttConfig": {},
         *   //   "timeZone": "my_timeZone",
         *   //   "ttsConfig": {},
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Conversationprofiles$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Conversationprofiles$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1ConversationProfile>>;
        get(params: Params$Resource$Projects$Conversationprofiles$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Conversationprofiles$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ConversationProfile>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ConversationProfile>): void;
        get(params: Params$Resource$Projects$Conversationprofiles$Get, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ConversationProfile>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ConversationProfile>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.conversationProfiles.list({
         *     pageSize: 'placeholder-value',
         *
         *     pageToken: 'placeholder-value',
         *
         *     parent: 'projects/my-project',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "conversationProfiles": [],
         *   //   "nextPageToken": "my_nextPageToken"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Conversationprofiles$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Conversationprofiles$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1ListConversationProfilesResponse>>;
        list(params: Params$Resource$Projects$Conversationprofiles$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Conversationprofiles$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListConversationProfilesResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListConversationProfilesResponse>): void;
        list(params: Params$Resource$Projects$Conversationprofiles$List, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListConversationProfilesResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListConversationProfilesResponse>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.conversationProfiles.patch({
         *     name: 'projects/my-project/conversationProfiles/my-conversationProfile',
         *
         *     updateMask: 'placeholder-value',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "automatedAgentConfig": {},
         *       //   "createTime": "my_createTime",
         *       //   "displayName": "my_displayName",
         *       //   "humanAgentAssistantConfig": {},
         *       //   "humanAgentHandoffConfig": {},
         *       //   "languageCode": "my_languageCode",
         *       //   "loggingConfig": {},
         *       //   "name": "my_name",
         *       //   "newMessageEventNotificationConfig": {},
         *       //   "newRecognitionResultNotificationConfig": {},
         *       //   "notificationConfig": {},
         *       //   "securitySettings": "my_securitySettings",
         *       //   "sttConfig": {},
         *       //   "timeZone": "my_timeZone",
         *       //   "ttsConfig": {},
         *       //   "updateTime": "my_updateTime"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "automatedAgentConfig": {},
         *   //   "createTime": "my_createTime",
         *   //   "displayName": "my_displayName",
         *   //   "humanAgentAssistantConfig": {},
         *   //   "humanAgentHandoffConfig": {},
         *   //   "languageCode": "my_languageCode",
         *   //   "loggingConfig": {},
         *   //   "name": "my_name",
         *   //   "newMessageEventNotificationConfig": {},
         *   //   "newRecognitionResultNotificationConfig": {},
         *   //   "notificationConfig": {},
         *   //   "securitySettings": "my_securitySettings",
         *   //   "sttConfig": {},
         *   //   "timeZone": "my_timeZone",
         *   //   "ttsConfig": {},
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        patch(params: Params$Resource$Projects$Conversationprofiles$Patch, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        patch(params?: Params$Resource$Projects$Conversationprofiles$Patch, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1ConversationProfile>>;
        patch(params: Params$Resource$Projects$Conversationprofiles$Patch, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        patch(params: Params$Resource$Projects$Conversationprofiles$Patch, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ConversationProfile>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ConversationProfile>): void;
        patch(params: Params$Resource$Projects$Conversationprofiles$Patch, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ConversationProfile>): void;
        patch(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ConversationProfile>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await dialogflow.projects.conversationProfiles.setSuggestionFeatureConfig({
         *       conversationProfile:
         *         'projects/my-project/conversationProfiles/my-conversationProfile',
         *
         *       // Request body metadata
         *       requestBody: {
         *         // request body parameters
         *         // {
         *         //   "participantRole": "my_participantRole",
         *         //   "suggestionFeatureConfig": {}
         *         // }
         *       },
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        setSuggestionFeatureConfig(params: Params$Resource$Projects$Conversationprofiles$Setsuggestionfeatureconfig, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        setSuggestionFeatureConfig(params?: Params$Resource$Projects$Conversationprofiles$Setsuggestionfeatureconfig, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        setSuggestionFeatureConfig(params: Params$Resource$Projects$Conversationprofiles$Setsuggestionfeatureconfig, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        setSuggestionFeatureConfig(params: Params$Resource$Projects$Conversationprofiles$Setsuggestionfeatureconfig, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        setSuggestionFeatureConfig(params: Params$Resource$Projects$Conversationprofiles$Setsuggestionfeatureconfig, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        setSuggestionFeatureConfig(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
    }
    export interface Params$Resource$Projects$Conversationprofiles$Clearsuggestionfeatureconfig extends StandardParameters {
        /**
         *
         */
        conversationProfile?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1ClearSuggestionFeatureConfigRequest;
    }
    export interface Params$Resource$Projects$Conversationprofiles$Create extends StandardParameters {
        /**
         *
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1ConversationProfile;
    }
    export interface Params$Resource$Projects$Conversationprofiles$Delete extends StandardParameters {
        /**
         *
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Conversationprofiles$Get extends StandardParameters {
        /**
         *
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Conversationprofiles$List extends StandardParameters {
        /**
         *
         */
        pageSize?: number;
        /**
         *
         */
        pageToken?: string;
        /**
         *
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Conversationprofiles$Patch extends StandardParameters {
        /**
         *
         */
        name?: string;
        /**
         *
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1ConversationProfile;
    }
    export interface Params$Resource$Projects$Conversationprofiles$Setsuggestionfeatureconfig extends StandardParameters {
        /**
         *
         */
        conversationProfile?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1SetSuggestionFeatureConfigRequest;
    }
    export class Resource$Projects$Conversations {
        context: APIRequestContext;
        messages: Resource$Projects$Conversations$Messages;
        participants: Resource$Projects$Conversations$Participants;
        suggestions: Resource$Projects$Conversations$Suggestions;
        constructor(context: APIRequestContext);
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.conversations.complete({
         *     name: 'projects/my-project/conversations/my-conversation',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {}
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "conversationProfile": "my_conversationProfile",
         *   //   "conversationStage": "my_conversationStage",
         *   //   "endTime": "my_endTime",
         *   //   "ingestedContextReferences": {},
         *   //   "lifecycleState": "my_lifecycleState",
         *   //   "name": "my_name",
         *   //   "phoneNumber": {},
         *   //   "startTime": "my_startTime",
         *   //   "telephonyConnectionInfo": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        complete(params: Params$Resource$Projects$Conversations$Complete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        complete(params?: Params$Resource$Projects$Conversations$Complete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1Conversation>>;
        complete(params: Params$Resource$Projects$Conversations$Complete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        complete(params: Params$Resource$Projects$Conversations$Complete, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Conversation>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Conversation>): void;
        complete(params: Params$Resource$Projects$Conversations$Complete, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Conversation>): void;
        complete(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Conversation>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.conversations.create({
         *     conversationId: 'placeholder-value',
         *
         *     parent: 'projects/my-project',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "conversationProfile": "my_conversationProfile",
         *       //   "conversationStage": "my_conversationStage",
         *       //   "endTime": "my_endTime",
         *       //   "ingestedContextReferences": {},
         *       //   "lifecycleState": "my_lifecycleState",
         *       //   "name": "my_name",
         *       //   "phoneNumber": {},
         *       //   "startTime": "my_startTime",
         *       //   "telephonyConnectionInfo": {}
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "conversationProfile": "my_conversationProfile",
         *   //   "conversationStage": "my_conversationStage",
         *   //   "endTime": "my_endTime",
         *   //   "ingestedContextReferences": {},
         *   //   "lifecycleState": "my_lifecycleState",
         *   //   "name": "my_name",
         *   //   "phoneNumber": {},
         *   //   "startTime": "my_startTime",
         *   //   "telephonyConnectionInfo": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Projects$Conversations$Create, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        create(params?: Params$Resource$Projects$Conversations$Create, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1Conversation>>;
        create(params: Params$Resource$Projects$Conversations$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Projects$Conversations$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Conversation>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Conversation>): void;
        create(params: Params$Resource$Projects$Conversations$Create, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Conversation>): void;
        create(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Conversation>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.conversations.get({
         *     name: 'projects/my-project/conversations/my-conversation',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "conversationProfile": "my_conversationProfile",
         *   //   "conversationStage": "my_conversationStage",
         *   //   "endTime": "my_endTime",
         *   //   "ingestedContextReferences": {},
         *   //   "lifecycleState": "my_lifecycleState",
         *   //   "name": "my_name",
         *   //   "phoneNumber": {},
         *   //   "startTime": "my_startTime",
         *   //   "telephonyConnectionInfo": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Conversations$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Conversations$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1Conversation>>;
        get(params: Params$Resource$Projects$Conversations$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Conversations$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Conversation>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Conversation>): void;
        get(params: Params$Resource$Projects$Conversations$Get, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Conversation>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Conversation>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.conversations.list({
         *     filter: 'placeholder-value',
         *
         *     pageSize: 'placeholder-value',
         *
         *     pageToken: 'placeholder-value',
         *
         *     parent: 'projects/my-project',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "conversations": [],
         *   //   "nextPageToken": "my_nextPageToken"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Conversations$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Conversations$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1ListConversationsResponse>>;
        list(params: Params$Resource$Projects$Conversations$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Conversations$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListConversationsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListConversationsResponse>): void;
        list(params: Params$Resource$Projects$Conversations$List, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListConversationsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListConversationsResponse>): void;
    }
    export interface Params$Resource$Projects$Conversations$Complete extends StandardParameters {
        /**
         *
         */
        name?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1CompleteConversationRequest;
    }
    export interface Params$Resource$Projects$Conversations$Create extends StandardParameters {
        /**
         *
         */
        conversationId?: string;
        /**
         *
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1Conversation;
    }
    export interface Params$Resource$Projects$Conversations$Get extends StandardParameters {
        /**
         *
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Conversations$List extends StandardParameters {
        /**
         *
         */
        filter?: string;
        /**
         *
         */
        pageSize?: number;
        /**
         *
         */
        pageToken?: string;
        /**
         *
         */
        parent?: string;
    }
    export class Resource$Projects$Conversations$Messages {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.conversations.messages.batchCreate({
         *     parent: 'projects/my-project/conversations/my-conversation',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "requests": []
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "messages": []
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        batchCreate(params: Params$Resource$Projects$Conversations$Messages$Batchcreate, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        batchCreate(params?: Params$Resource$Projects$Conversations$Messages$Batchcreate, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1BatchCreateMessagesResponse>>;
        batchCreate(params: Params$Resource$Projects$Conversations$Messages$Batchcreate, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        batchCreate(params: Params$Resource$Projects$Conversations$Messages$Batchcreate, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1BatchCreateMessagesResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1BatchCreateMessagesResponse>): void;
        batchCreate(params: Params$Resource$Projects$Conversations$Messages$Batchcreate, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1BatchCreateMessagesResponse>): void;
        batchCreate(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1BatchCreateMessagesResponse>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.conversations.messages.list({
         *     filter: 'placeholder-value',
         *
         *     pageSize: 'placeholder-value',
         *
         *     pageToken: 'placeholder-value',
         *
         *     parent: 'projects/my-project/conversations/my-conversation',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "messages": [],
         *   //   "nextPageToken": "my_nextPageToken"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Conversations$Messages$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Conversations$Messages$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1ListMessagesResponse>>;
        list(params: Params$Resource$Projects$Conversations$Messages$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Conversations$Messages$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListMessagesResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListMessagesResponse>): void;
        list(params: Params$Resource$Projects$Conversations$Messages$List, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListMessagesResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListMessagesResponse>): void;
    }
    export interface Params$Resource$Projects$Conversations$Messages$Batchcreate extends StandardParameters {
        /**
         *
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1BatchCreateMessagesRequest;
    }
    export interface Params$Resource$Projects$Conversations$Messages$List extends StandardParameters {
        /**
         *
         */
        filter?: string;
        /**
         *
         */
        pageSize?: number;
        /**
         *
         */
        pageToken?: string;
        /**
         *
         */
        parent?: string;
    }
    export class Resource$Projects$Conversations$Participants {
        context: APIRequestContext;
        suggestions: Resource$Projects$Conversations$Participants$Suggestions;
        constructor(context: APIRequestContext);
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await dialogflow.projects.conversations.participants.analyzeContent({
         *       participant:
         *         'projects/my-project/conversations/my-conversation/participants/my-participant',
         *
         *       // Request body metadata
         *       requestBody: {
         *         // request body parameters
         *         // {
         *         //   "assistQueryParams": {},
         *         //   "audioInput": {},
         *         //   "cxCurrentPage": "my_cxCurrentPage",
         *         //   "cxParameters": {},
         *         //   "eventInput": {},
         *         //   "intentInput": {},
         *         //   "messageSendTime": "my_messageSendTime",
         *         //   "queryParams": {},
         *         //   "replyAudioConfig": {},
         *         //   "requestId": "my_requestId",
         *         //   "suggestionInput": {},
         *         //   "textInput": {}
         *         // }
         *       },
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "automatedAgentReply": {},
         *   //   "dtmfParameters": {},
         *   //   "endUserSuggestionResults": [],
         *   //   "humanAgentSuggestionResults": [],
         *   //   "message": {},
         *   //   "replyAudio": {},
         *   //   "replyText": "my_replyText"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        analyzeContent(params: Params$Resource$Projects$Conversations$Participants$Analyzecontent, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        analyzeContent(params?: Params$Resource$Projects$Conversations$Participants$Analyzecontent, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1AnalyzeContentResponse>>;
        analyzeContent(params: Params$Resource$Projects$Conversations$Participants$Analyzecontent, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        analyzeContent(params: Params$Resource$Projects$Conversations$Participants$Analyzecontent, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1AnalyzeContentResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1AnalyzeContentResponse>): void;
        analyzeContent(params: Params$Resource$Projects$Conversations$Participants$Analyzecontent, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1AnalyzeContentResponse>): void;
        analyzeContent(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1AnalyzeContentResponse>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.conversations.participants.create({
         *     parent: 'projects/my-project/conversations/my-conversation',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "agentDesktopSource": "my_agentDesktopSource",
         *       //   "documentsMetadataFilters": {},
         *       //   "name": "my_name",
         *       //   "obfuscatedExternalUserId": "my_obfuscatedExternalUserId",
         *       //   "role": "my_role"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "agentDesktopSource": "my_agentDesktopSource",
         *   //   "documentsMetadataFilters": {},
         *   //   "name": "my_name",
         *   //   "obfuscatedExternalUserId": "my_obfuscatedExternalUserId",
         *   //   "role": "my_role"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Projects$Conversations$Participants$Create, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        create(params?: Params$Resource$Projects$Conversations$Participants$Create, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1Participant>>;
        create(params: Params$Resource$Projects$Conversations$Participants$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Projects$Conversations$Participants$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Participant>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Participant>): void;
        create(params: Params$Resource$Projects$Conversations$Participants$Create, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Participant>): void;
        create(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Participant>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.conversations.participants.get({
         *     name: 'projects/my-project/conversations/my-conversation/participants/my-participant',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "agentDesktopSource": "my_agentDesktopSource",
         *   //   "documentsMetadataFilters": {},
         *   //   "name": "my_name",
         *   //   "obfuscatedExternalUserId": "my_obfuscatedExternalUserId",
         *   //   "role": "my_role"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Conversations$Participants$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Conversations$Participants$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1Participant>>;
        get(params: Params$Resource$Projects$Conversations$Participants$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Conversations$Participants$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Participant>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Participant>): void;
        get(params: Params$Resource$Projects$Conversations$Participants$Get, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Participant>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Participant>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.conversations.participants.list({
         *     pageSize: 'placeholder-value',
         *
         *     pageToken: 'placeholder-value',
         *
         *     parent: 'projects/my-project/conversations/my-conversation',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "nextPageToken": "my_nextPageToken",
         *   //   "participants": []
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Conversations$Participants$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Conversations$Participants$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1ListParticipantsResponse>>;
        list(params: Params$Resource$Projects$Conversations$Participants$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Conversations$Participants$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListParticipantsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListParticipantsResponse>): void;
        list(params: Params$Resource$Projects$Conversations$Participants$List, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListParticipantsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListParticipantsResponse>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.conversations.participants.patch({
         *     name: 'projects/my-project/conversations/my-conversation/participants/my-participant',
         *
         *     updateMask: 'placeholder-value',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "agentDesktopSource": "my_agentDesktopSource",
         *       //   "documentsMetadataFilters": {},
         *       //   "name": "my_name",
         *       //   "obfuscatedExternalUserId": "my_obfuscatedExternalUserId",
         *       //   "role": "my_role"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "agentDesktopSource": "my_agentDesktopSource",
         *   //   "documentsMetadataFilters": {},
         *   //   "name": "my_name",
         *   //   "obfuscatedExternalUserId": "my_obfuscatedExternalUserId",
         *   //   "role": "my_role"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        patch(params: Params$Resource$Projects$Conversations$Participants$Patch, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        patch(params?: Params$Resource$Projects$Conversations$Participants$Patch, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1Participant>>;
        patch(params: Params$Resource$Projects$Conversations$Participants$Patch, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        patch(params: Params$Resource$Projects$Conversations$Participants$Patch, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Participant>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Participant>): void;
        patch(params: Params$Resource$Projects$Conversations$Participants$Patch, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Participant>): void;
        patch(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Participant>): void;
    }
    export interface Params$Resource$Projects$Conversations$Participants$Analyzecontent extends StandardParameters {
        /**
         *
         */
        participant?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1AnalyzeContentRequest;
    }
    export interface Params$Resource$Projects$Conversations$Participants$Create extends StandardParameters {
        /**
         *
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1Participant;
    }
    export interface Params$Resource$Projects$Conversations$Participants$Get extends StandardParameters {
        /**
         *
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Conversations$Participants$List extends StandardParameters {
        /**
         *
         */
        pageSize?: number;
        /**
         *
         */
        pageToken?: string;
        /**
         *
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Conversations$Participants$Patch extends StandardParameters {
        /**
         *
         */
        name?: string;
        /**
         *
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1Participant;
    }
    export class Resource$Projects$Conversations$Participants$Suggestions {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await dialogflow.projects.conversations.participants.suggestions.compile({
         *       parent:
         *         'projects/my-project/conversations/my-conversation/participants/my-participant',
         *
         *       // Request body metadata
         *       requestBody: {
         *         // request body parameters
         *         // {
         *         //   "contextSize": 0,
         *         //   "latestMessage": "my_latestMessage"
         *         // }
         *       },
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "contextSize": 0,
         *   //   "latestMessage": "my_latestMessage",
         *   //   "suggestion": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        compile(params: Params$Resource$Projects$Conversations$Participants$Suggestions$Compile, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        compile(params?: Params$Resource$Projects$Conversations$Participants$Suggestions$Compile, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1CompileSuggestionResponse>>;
        compile(params: Params$Resource$Projects$Conversations$Participants$Suggestions$Compile, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        compile(params: Params$Resource$Projects$Conversations$Participants$Suggestions$Compile, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1CompileSuggestionResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1CompileSuggestionResponse>): void;
        compile(params: Params$Resource$Projects$Conversations$Participants$Suggestions$Compile, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1CompileSuggestionResponse>): void;
        compile(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1CompileSuggestionResponse>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await dialogflow.projects.conversations.participants.suggestions.list({
         *       filter: 'placeholder-value',
         *
         *       pageSize: 'placeholder-value',
         *
         *       pageToken: 'placeholder-value',
         *
         *       parent:
         *         'projects/my-project/conversations/my-conversation/participants/my-participant',
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "nextPageToken": "my_nextPageToken",
         *   //   "suggestions": []
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Conversations$Participants$Suggestions$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Conversations$Participants$Suggestions$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1ListSuggestionsResponse>>;
        list(params: Params$Resource$Projects$Conversations$Participants$Suggestions$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Conversations$Participants$Suggestions$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListSuggestionsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListSuggestionsResponse>): void;
        list(params: Params$Resource$Projects$Conversations$Participants$Suggestions$List, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListSuggestionsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListSuggestionsResponse>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await dialogflow.projects.conversations.participants.suggestions.suggestArticles(
         *       {
         *         parent:
         *           'projects/my-project/conversations/my-conversation/participants/my-participant',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "assistQueryParams": {},
         *           //   "contextSize": 0,
         *           //   "latestMessage": "my_latestMessage"
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "articleAnswers": [],
         *   //   "contextSize": 0,
         *   //   "latestMessage": "my_latestMessage"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        suggestArticles(params: Params$Resource$Projects$Conversations$Participants$Suggestions$Suggestarticles, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        suggestArticles(params?: Params$Resource$Projects$Conversations$Participants$Suggestions$Suggestarticles, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1SuggestArticlesResponse>>;
        suggestArticles(params: Params$Resource$Projects$Conversations$Participants$Suggestions$Suggestarticles, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        suggestArticles(params: Params$Resource$Projects$Conversations$Participants$Suggestions$Suggestarticles, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SuggestArticlesResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SuggestArticlesResponse>): void;
        suggestArticles(params: Params$Resource$Projects$Conversations$Participants$Suggestions$Suggestarticles, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SuggestArticlesResponse>): void;
        suggestArticles(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SuggestArticlesResponse>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await dialogflow.projects.conversations.participants.suggestions.suggestFaqAnswers(
         *       {
         *         parent:
         *           'projects/my-project/conversations/my-conversation/participants/my-participant',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "assistQueryParams": {},
         *           //   "contextSize": 0,
         *           //   "latestMessage": "my_latestMessage"
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "contextSize": 0,
         *   //   "faqAnswers": [],
         *   //   "latestMessage": "my_latestMessage"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        suggestFaqAnswers(params: Params$Resource$Projects$Conversations$Participants$Suggestions$Suggestfaqanswers, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        suggestFaqAnswers(params?: Params$Resource$Projects$Conversations$Participants$Suggestions$Suggestfaqanswers, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1SuggestFaqAnswersResponse>>;
        suggestFaqAnswers(params: Params$Resource$Projects$Conversations$Participants$Suggestions$Suggestfaqanswers, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        suggestFaqAnswers(params: Params$Resource$Projects$Conversations$Participants$Suggestions$Suggestfaqanswers, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SuggestFaqAnswersResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SuggestFaqAnswersResponse>): void;
        suggestFaqAnswers(params: Params$Resource$Projects$Conversations$Participants$Suggestions$Suggestfaqanswers, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SuggestFaqAnswersResponse>): void;
        suggestFaqAnswers(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SuggestFaqAnswersResponse>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await dialogflow.projects.conversations.participants.suggestions.suggestKnowledgeAssist(
         *       {
         *         parent:
         *           'projects/my-project/conversations/my-conversation/participants/my-participant',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "contextSize": 0,
         *           //   "latestMessage": "my_latestMessage",
         *           //   "previousSuggestedQuery": "my_previousSuggestedQuery"
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "contextSize": 0,
         *   //   "knowledgeAssistAnswer": {},
         *   //   "latestMessage": "my_latestMessage"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        suggestKnowledgeAssist(params: Params$Resource$Projects$Conversations$Participants$Suggestions$Suggestknowledgeassist, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        suggestKnowledgeAssist(params?: Params$Resource$Projects$Conversations$Participants$Suggestions$Suggestknowledgeassist, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1SuggestKnowledgeAssistResponse>>;
        suggestKnowledgeAssist(params: Params$Resource$Projects$Conversations$Participants$Suggestions$Suggestknowledgeassist, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        suggestKnowledgeAssist(params: Params$Resource$Projects$Conversations$Participants$Suggestions$Suggestknowledgeassist, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SuggestKnowledgeAssistResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SuggestKnowledgeAssistResponse>): void;
        suggestKnowledgeAssist(params: Params$Resource$Projects$Conversations$Participants$Suggestions$Suggestknowledgeassist, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SuggestKnowledgeAssistResponse>): void;
        suggestKnowledgeAssist(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SuggestKnowledgeAssistResponse>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await dialogflow.projects.conversations.participants.suggestions.suggestSmartReplies(
         *       {
         *         parent:
         *           'projects/my-project/conversations/my-conversation/participants/my-participant',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "contextSize": 0,
         *           //   "currentTextInput": {},
         *           //   "latestMessage": "my_latestMessage"
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "contextSize": 0,
         *   //   "latestMessage": "my_latestMessage",
         *   //   "smartReplyAnswers": []
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        suggestSmartReplies(params: Params$Resource$Projects$Conversations$Participants$Suggestions$Suggestsmartreplies, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        suggestSmartReplies(params?: Params$Resource$Projects$Conversations$Participants$Suggestions$Suggestsmartreplies, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1SuggestSmartRepliesResponse>>;
        suggestSmartReplies(params: Params$Resource$Projects$Conversations$Participants$Suggestions$Suggestsmartreplies, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        suggestSmartReplies(params: Params$Resource$Projects$Conversations$Participants$Suggestions$Suggestsmartreplies, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SuggestSmartRepliesResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SuggestSmartRepliesResponse>): void;
        suggestSmartReplies(params: Params$Resource$Projects$Conversations$Participants$Suggestions$Suggestsmartreplies, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SuggestSmartRepliesResponse>): void;
        suggestSmartReplies(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SuggestSmartRepliesResponse>): void;
    }
    export interface Params$Resource$Projects$Conversations$Participants$Suggestions$Compile extends StandardParameters {
        /**
         *
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1CompileSuggestionRequest;
    }
    export interface Params$Resource$Projects$Conversations$Participants$Suggestions$List extends StandardParameters {
        /**
         *
         */
        filter?: string;
        /**
         *
         */
        pageSize?: number;
        /**
         *
         */
        pageToken?: string;
        /**
         *
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Conversations$Participants$Suggestions$Suggestarticles extends StandardParameters {
        /**
         *
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1SuggestArticlesRequest;
    }
    export interface Params$Resource$Projects$Conversations$Participants$Suggestions$Suggestfaqanswers extends StandardParameters {
        /**
         *
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1SuggestFaqAnswersRequest;
    }
    export interface Params$Resource$Projects$Conversations$Participants$Suggestions$Suggestknowledgeassist extends StandardParameters {
        /**
         *
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1SuggestKnowledgeAssistRequest;
    }
    export interface Params$Resource$Projects$Conversations$Participants$Suggestions$Suggestsmartreplies extends StandardParameters {
        /**
         *
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1SuggestSmartRepliesRequest;
    }
    export class Resource$Projects$Conversations$Suggestions {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.conversations.suggestions.generate({
         *     conversation: 'projects/my-project/conversations/my-conversation',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "latestMessage": "my_latestMessage",
         *       //   "triggerEvents": []
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "generatorSuggestionAnswers": [],
         *   //   "latestMessage": "my_latestMessage"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        generate(params: Params$Resource$Projects$Conversations$Suggestions$Generate, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        generate(params?: Params$Resource$Projects$Conversations$Suggestions$Generate, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1GenerateSuggestionsResponse>>;
        generate(params: Params$Resource$Projects$Conversations$Suggestions$Generate, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        generate(params: Params$Resource$Projects$Conversations$Suggestions$Generate, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1GenerateSuggestionsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1GenerateSuggestionsResponse>): void;
        generate(params: Params$Resource$Projects$Conversations$Suggestions$Generate, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1GenerateSuggestionsResponse>): void;
        generate(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1GenerateSuggestionsResponse>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await dialogflow.projects.conversations.suggestions.searchKnowledge({
         *       conversation: 'projects/my-project/conversations/my-conversation',
         *
         *       // Request body metadata
         *       requestBody: {
         *         // request body parameters
         *         // {
         *         //   "conversation": "my_conversation",
         *         //   "conversationProfile": "my_conversationProfile",
         *         //   "endUserMetadata": {},
         *         //   "exactSearch": false,
         *         //   "latestMessage": "my_latestMessage",
         *         //   "parent": "my_parent",
         *         //   "query": {},
         *         //   "querySource": "my_querySource",
         *         //   "searchConfig": {},
         *         //   "sessionId": "my_sessionId"
         *         // }
         *       },
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "answers": [],
         *   //   "rewrittenQuery": "my_rewrittenQuery",
         *   //   "searchKnowledgeDebugInfo": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        searchKnowledge(params: Params$Resource$Projects$Conversations$Suggestions$Searchknowledge, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        searchKnowledge(params?: Params$Resource$Projects$Conversations$Suggestions$Searchknowledge, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1SearchKnowledgeResponse>>;
        searchKnowledge(params: Params$Resource$Projects$Conversations$Suggestions$Searchknowledge, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        searchKnowledge(params: Params$Resource$Projects$Conversations$Suggestions$Searchknowledge, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SearchKnowledgeResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SearchKnowledgeResponse>): void;
        searchKnowledge(params: Params$Resource$Projects$Conversations$Suggestions$Searchknowledge, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SearchKnowledgeResponse>): void;
        searchKnowledge(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SearchKnowledgeResponse>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await dialogflow.projects.conversations.suggestions.suggestConversationSummary(
         *       {
         *         conversation: 'projects/my-project/conversations/my-conversation',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "assistQueryParams": {},
         *           //   "contextSize": 0,
         *           //   "latestMessage": "my_latestMessage"
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "contextSize": 0,
         *   //   "latestMessage": "my_latestMessage",
         *   //   "summary": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        suggestConversationSummary(params: Params$Resource$Projects$Conversations$Suggestions$Suggestconversationsummary, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        suggestConversationSummary(params?: Params$Resource$Projects$Conversations$Suggestions$Suggestconversationsummary, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1SuggestConversationSummaryResponse>>;
        suggestConversationSummary(params: Params$Resource$Projects$Conversations$Suggestions$Suggestconversationsummary, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        suggestConversationSummary(params: Params$Resource$Projects$Conversations$Suggestions$Suggestconversationsummary, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SuggestConversationSummaryResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SuggestConversationSummaryResponse>): void;
        suggestConversationSummary(params: Params$Resource$Projects$Conversations$Suggestions$Suggestconversationsummary, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SuggestConversationSummaryResponse>): void;
        suggestConversationSummary(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SuggestConversationSummaryResponse>): void;
    }
    export interface Params$Resource$Projects$Conversations$Suggestions$Generate extends StandardParameters {
        /**
         *
         */
        conversation?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1GenerateSuggestionsRequest;
    }
    export interface Params$Resource$Projects$Conversations$Suggestions$Searchknowledge extends StandardParameters {
        /**
         *
         */
        conversation?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1SearchKnowledgeRequest;
    }
    export interface Params$Resource$Projects$Conversations$Suggestions$Suggestconversationsummary extends StandardParameters {
        /**
         *
         */
        conversation?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1SuggestConversationSummaryRequest;
    }
    export class Resource$Projects$Generators {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.generators.create({
         *     generatorId: 'placeholder-value',
         *
         *     parent: 'projects/my-project',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "agentCoachingContext": {},
         *       //   "createTime": "my_createTime",
         *       //   "description": "my_description",
         *       //   "freeFormContext": {},
         *       //   "inferenceParameter": {},
         *       //   "name": "my_name",
         *       //   "publishedModel": "my_publishedModel",
         *       //   "suggestionDedupingConfig": {},
         *       //   "summarizationContext": {},
         *       //   "tools": [],
         *       //   "triggerEvent": "my_triggerEvent",
         *       //   "updateTime": "my_updateTime"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "agentCoachingContext": {},
         *   //   "createTime": "my_createTime",
         *   //   "description": "my_description",
         *   //   "freeFormContext": {},
         *   //   "inferenceParameter": {},
         *   //   "name": "my_name",
         *   //   "publishedModel": "my_publishedModel",
         *   //   "suggestionDedupingConfig": {},
         *   //   "summarizationContext": {},
         *   //   "tools": [],
         *   //   "triggerEvent": "my_triggerEvent",
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Projects$Generators$Create, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        create(params?: Params$Resource$Projects$Generators$Create, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1Generator>>;
        create(params: Params$Resource$Projects$Generators$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Projects$Generators$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Generator>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Generator>): void;
        create(params: Params$Resource$Projects$Generators$Create, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Generator>): void;
        create(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Generator>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.generators.list({
         *     pageSize: 'placeholder-value',
         *
         *     pageToken: 'placeholder-value',
         *
         *     parent: 'projects/my-project',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "generators": [],
         *   //   "nextPageToken": "my_nextPageToken"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Generators$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Generators$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1ListGeneratorsResponse>>;
        list(params: Params$Resource$Projects$Generators$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Generators$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListGeneratorsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListGeneratorsResponse>): void;
        list(params: Params$Resource$Projects$Generators$List, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListGeneratorsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListGeneratorsResponse>): void;
    }
    export interface Params$Resource$Projects$Generators$Create extends StandardParameters {
        /**
         *
         */
        generatorId?: string;
        /**
         *
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1Generator;
    }
    export interface Params$Resource$Projects$Generators$List extends StandardParameters {
        /**
         *
         */
        pageSize?: number;
        /**
         *
         */
        pageToken?: string;
        /**
         *
         */
        parent?: string;
    }
    export class Resource$Projects$Knowledgebases {
        context: APIRequestContext;
        documents: Resource$Projects$Knowledgebases$Documents;
        constructor(context: APIRequestContext);
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.knowledgeBases.create({
         *     parent: 'projects/my-project',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "displayName": "my_displayName",
         *       //   "languageCode": "my_languageCode",
         *       //   "name": "my_name"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "displayName": "my_displayName",
         *   //   "languageCode": "my_languageCode",
         *   //   "name": "my_name"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Projects$Knowledgebases$Create, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        create(params?: Params$Resource$Projects$Knowledgebases$Create, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1KnowledgeBase>>;
        create(params: Params$Resource$Projects$Knowledgebases$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Projects$Knowledgebases$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1KnowledgeBase>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1KnowledgeBase>): void;
        create(params: Params$Resource$Projects$Knowledgebases$Create, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1KnowledgeBase>): void;
        create(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1KnowledgeBase>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.knowledgeBases.delete({
         *     force: 'placeholder-value',
         *
         *     name: 'projects/my-project/knowledgeBases/my-knowledgeBase',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {}
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Projects$Knowledgebases$Delete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        delete(params?: Params$Resource$Projects$Knowledgebases$Delete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleProtobufEmpty>>;
        delete(params: Params$Resource$Projects$Knowledgebases$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Projects$Knowledgebases$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleProtobufEmpty>, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(params: Params$Resource$Projects$Knowledgebases$Delete, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.knowledgeBases.get({
         *     name: 'projects/my-project/knowledgeBases/my-knowledgeBase',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "displayName": "my_displayName",
         *   //   "languageCode": "my_languageCode",
         *   //   "name": "my_name"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Knowledgebases$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Knowledgebases$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1KnowledgeBase>>;
        get(params: Params$Resource$Projects$Knowledgebases$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Knowledgebases$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1KnowledgeBase>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1KnowledgeBase>): void;
        get(params: Params$Resource$Projects$Knowledgebases$Get, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1KnowledgeBase>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1KnowledgeBase>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.knowledgeBases.list({
         *     filter: 'placeholder-value',
         *
         *     pageSize: 'placeholder-value',
         *
         *     pageToken: 'placeholder-value',
         *
         *     parent: 'projects/my-project',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "knowledgeBases": [],
         *   //   "nextPageToken": "my_nextPageToken"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Knowledgebases$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Knowledgebases$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1ListKnowledgeBasesResponse>>;
        list(params: Params$Resource$Projects$Knowledgebases$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Knowledgebases$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListKnowledgeBasesResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListKnowledgeBasesResponse>): void;
        list(params: Params$Resource$Projects$Knowledgebases$List, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListKnowledgeBasesResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListKnowledgeBasesResponse>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.knowledgeBases.patch({
         *     name: 'projects/my-project/knowledgeBases/my-knowledgeBase',
         *
         *     updateMask: 'placeholder-value',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "displayName": "my_displayName",
         *       //   "languageCode": "my_languageCode",
         *       //   "name": "my_name"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "displayName": "my_displayName",
         *   //   "languageCode": "my_languageCode",
         *   //   "name": "my_name"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        patch(params: Params$Resource$Projects$Knowledgebases$Patch, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        patch(params?: Params$Resource$Projects$Knowledgebases$Patch, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1KnowledgeBase>>;
        patch(params: Params$Resource$Projects$Knowledgebases$Patch, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        patch(params: Params$Resource$Projects$Knowledgebases$Patch, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1KnowledgeBase>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1KnowledgeBase>): void;
        patch(params: Params$Resource$Projects$Knowledgebases$Patch, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1KnowledgeBase>): void;
        patch(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1KnowledgeBase>): void;
    }
    export interface Params$Resource$Projects$Knowledgebases$Create extends StandardParameters {
        /**
         *
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1KnowledgeBase;
    }
    export interface Params$Resource$Projects$Knowledgebases$Delete extends StandardParameters {
        /**
         *
         */
        force?: boolean;
        /**
         *
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Knowledgebases$Get extends StandardParameters {
        /**
         *
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Knowledgebases$List extends StandardParameters {
        /**
         *
         */
        filter?: string;
        /**
         *
         */
        pageSize?: number;
        /**
         *
         */
        pageToken?: string;
        /**
         *
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Knowledgebases$Patch extends StandardParameters {
        /**
         *
         */
        name?: string;
        /**
         *
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1KnowledgeBase;
    }
    export class Resource$Projects$Knowledgebases$Documents {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.knowledgeBases.documents.create({
         *     importGcsCustomMetadata: 'placeholder-value',
         *
         *     parent: 'projects/my-project/knowledgeBases/my-knowledgeBase',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "content": "my_content",
         *       //   "contentUri": "my_contentUri",
         *       //   "displayName": "my_displayName",
         *       //   "enableAutoReload": false,
         *       //   "knowledgeTypes": [],
         *       //   "latestReloadStatus": {},
         *       //   "metadata": {},
         *       //   "mimeType": "my_mimeType",
         *       //   "name": "my_name",
         *       //   "rawContent": "my_rawContent",
         *       //   "state": "my_state"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Projects$Knowledgebases$Documents$Create, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        create(params?: Params$Resource$Projects$Knowledgebases$Documents$Create, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        create(params: Params$Resource$Projects$Knowledgebases$Documents$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Projects$Knowledgebases$Documents$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        create(params: Params$Resource$Projects$Knowledgebases$Documents$Create, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        create(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.knowledgeBases.documents.delete({
         *     name: 'projects/my-project/knowledgeBases/my-knowledgeBase/documents/my-document',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Projects$Knowledgebases$Documents$Delete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        delete(params?: Params$Resource$Projects$Knowledgebases$Documents$Delete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        delete(params: Params$Resource$Projects$Knowledgebases$Documents$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Projects$Knowledgebases$Documents$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        delete(params: Params$Resource$Projects$Knowledgebases$Documents$Delete, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.knowledgeBases.documents.get({
         *     name: 'projects/my-project/knowledgeBases/my-knowledgeBase/documents/my-document',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "content": "my_content",
         *   //   "contentUri": "my_contentUri",
         *   //   "displayName": "my_displayName",
         *   //   "enableAutoReload": false,
         *   //   "knowledgeTypes": [],
         *   //   "latestReloadStatus": {},
         *   //   "metadata": {},
         *   //   "mimeType": "my_mimeType",
         *   //   "name": "my_name",
         *   //   "rawContent": "my_rawContent",
         *   //   "state": "my_state"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Knowledgebases$Documents$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Knowledgebases$Documents$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1Document>>;
        get(params: Params$Resource$Projects$Knowledgebases$Documents$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Knowledgebases$Documents$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Document>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Document>): void;
        get(params: Params$Resource$Projects$Knowledgebases$Documents$Get, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Document>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Document>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.knowledgeBases.documents.import({
         *     parent: 'projects/my-project/knowledgeBases/my-knowledgeBase',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "documentTemplate": {},
         *       //   "gcsSource": {},
         *       //   "importGcsCustomMetadata": false
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        import(params: Params$Resource$Projects$Knowledgebases$Documents$Import, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        import(params?: Params$Resource$Projects$Knowledgebases$Documents$Import, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        import(params: Params$Resource$Projects$Knowledgebases$Documents$Import, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        import(params: Params$Resource$Projects$Knowledgebases$Documents$Import, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        import(params: Params$Resource$Projects$Knowledgebases$Documents$Import, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        import(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.knowledgeBases.documents.list({
         *     filter: 'placeholder-value',
         *
         *     pageSize: 'placeholder-value',
         *
         *     pageToken: 'placeholder-value',
         *
         *     parent: 'projects/my-project/knowledgeBases/my-knowledgeBase',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "documents": [],
         *   //   "nextPageToken": "my_nextPageToken"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Knowledgebases$Documents$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Knowledgebases$Documents$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1ListDocumentsResponse>>;
        list(params: Params$Resource$Projects$Knowledgebases$Documents$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Knowledgebases$Documents$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListDocumentsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListDocumentsResponse>): void;
        list(params: Params$Resource$Projects$Knowledgebases$Documents$List, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListDocumentsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListDocumentsResponse>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.knowledgeBases.documents.patch({
         *     name: 'projects/my-project/knowledgeBases/my-knowledgeBase/documents/my-document',
         *
         *     updateMask: 'placeholder-value',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "content": "my_content",
         *       //   "contentUri": "my_contentUri",
         *       //   "displayName": "my_displayName",
         *       //   "enableAutoReload": false,
         *       //   "knowledgeTypes": [],
         *       //   "latestReloadStatus": {},
         *       //   "metadata": {},
         *       //   "mimeType": "my_mimeType",
         *       //   "name": "my_name",
         *       //   "rawContent": "my_rawContent",
         *       //   "state": "my_state"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        patch(params: Params$Resource$Projects$Knowledgebases$Documents$Patch, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        patch(params?: Params$Resource$Projects$Knowledgebases$Documents$Patch, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        patch(params: Params$Resource$Projects$Knowledgebases$Documents$Patch, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        patch(params: Params$Resource$Projects$Knowledgebases$Documents$Patch, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        patch(params: Params$Resource$Projects$Knowledgebases$Documents$Patch, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        patch(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.knowledgeBases.documents.reload({
         *     name: 'projects/my-project/knowledgeBases/my-knowledgeBase/documents/my-document',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "gcsSource": {},
         *       //   "importGcsCustomMetadata": false
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        reload(params: Params$Resource$Projects$Knowledgebases$Documents$Reload, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        reload(params?: Params$Resource$Projects$Knowledgebases$Documents$Reload, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        reload(params: Params$Resource$Projects$Knowledgebases$Documents$Reload, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        reload(params: Params$Resource$Projects$Knowledgebases$Documents$Reload, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        reload(params: Params$Resource$Projects$Knowledgebases$Documents$Reload, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        reload(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
    }
    export interface Params$Resource$Projects$Knowledgebases$Documents$Create extends StandardParameters {
        /**
         *
         */
        importGcsCustomMetadata?: boolean;
        /**
         *
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1Document;
    }
    export interface Params$Resource$Projects$Knowledgebases$Documents$Delete extends StandardParameters {
        /**
         *
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Knowledgebases$Documents$Get extends StandardParameters {
        /**
         *
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Knowledgebases$Documents$Import extends StandardParameters {
        /**
         *
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1ImportDocumentsRequest;
    }
    export interface Params$Resource$Projects$Knowledgebases$Documents$List extends StandardParameters {
        /**
         *
         */
        filter?: string;
        /**
         *
         */
        pageSize?: number;
        /**
         *
         */
        pageToken?: string;
        /**
         *
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Knowledgebases$Documents$Patch extends StandardParameters {
        /**
         *
         */
        name?: string;
        /**
         *
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1Document;
    }
    export interface Params$Resource$Projects$Knowledgebases$Documents$Reload extends StandardParameters {
        /**
         *
         */
        name?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1ReloadDocumentRequest;
    }
    export class Resource$Projects$Locations {
        context: APIRequestContext;
        agent: Resource$Projects$Locations$Agent;
        answerRecords: Resource$Projects$Locations$Answerrecords;
        conversationProfiles: Resource$Projects$Locations$Conversationprofiles;
        conversations: Resource$Projects$Locations$Conversations;
        encryptionSpec: Resource$Projects$Locations$Encryptionspec;
        generators: Resource$Projects$Locations$Generators;
        knowledgeBases: Resource$Projects$Locations$Knowledgebases;
        operations: Resource$Projects$Locations$Operations;
        phoneNumbers: Resource$Projects$Locations$Phonenumbers;
        sipTrunks: Resource$Projects$Locations$Siptrunks;
        statelessSuggestion: Resource$Projects$Locations$Statelesssuggestion;
        suggestions: Resource$Projects$Locations$Suggestions;
        tools: Resource$Projects$Locations$Tools;
        constructor(context: APIRequestContext);
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.locations.deleteAgent({
         *     parent: 'projects/my-project/locations/my-location',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {}
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        deleteAgent(params: Params$Resource$Projects$Locations$Deleteagent, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        deleteAgent(params?: Params$Resource$Projects$Locations$Deleteagent, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleProtobufEmpty>>;
        deleteAgent(params: Params$Resource$Projects$Locations$Deleteagent, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        deleteAgent(params: Params$Resource$Projects$Locations$Deleteagent, options: MethodOptions | BodyResponseCallback<Schema$GoogleProtobufEmpty>, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        deleteAgent(params: Params$Resource$Projects$Locations$Deleteagent, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        deleteAgent(callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.locations.get({
         *     name: 'projects/my-project/locations/my-location',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "displayName": "my_displayName",
         *   //   "labels": {},
         *   //   "locationId": "my_locationId",
         *   //   "metadata": {},
         *   //   "name": "my_name"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Locations$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Locations$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudLocationLocation>>;
        get(params: Params$Resource$Projects$Locations$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Locations$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudLocationLocation>, callback: BodyResponseCallback<Schema$GoogleCloudLocationLocation>): void;
        get(params: Params$Resource$Projects$Locations$Get, callback: BodyResponseCallback<Schema$GoogleCloudLocationLocation>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudLocationLocation>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.locations.getAgent({
         *     parent: 'projects/my-project/locations/my-location',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "apiVersion": "my_apiVersion",
         *   //   "avatarUri": "my_avatarUri",
         *   //   "classificationThreshold": {},
         *   //   "defaultLanguageCode": "my_defaultLanguageCode",
         *   //   "description": "my_description",
         *   //   "displayName": "my_displayName",
         *   //   "enableLogging": false,
         *   //   "matchMode": "my_matchMode",
         *   //   "parent": "my_parent",
         *   //   "supportedLanguageCodes": [],
         *   //   "tier": "my_tier",
         *   //   "timeZone": "my_timeZone"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        getAgent(params: Params$Resource$Projects$Locations$Getagent, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        getAgent(params?: Params$Resource$Projects$Locations$Getagent, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1Agent>>;
        getAgent(params: Params$Resource$Projects$Locations$Getagent, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        getAgent(params: Params$Resource$Projects$Locations$Getagent, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Agent>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Agent>): void;
        getAgent(params: Params$Resource$Projects$Locations$Getagent, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Agent>): void;
        getAgent(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Agent>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.locations.getEncryptionSpec({
         *     name: 'projects/my-project/locations/my-location/encryptionSpec',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "kmsKey": "my_kmsKey",
         *   //   "name": "my_name"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        getEncryptionSpec(params: Params$Resource$Projects$Locations$Getencryptionspec, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        getEncryptionSpec(params?: Params$Resource$Projects$Locations$Getencryptionspec, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1EncryptionSpec>>;
        getEncryptionSpec(params: Params$Resource$Projects$Locations$Getencryptionspec, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        getEncryptionSpec(params: Params$Resource$Projects$Locations$Getencryptionspec, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1EncryptionSpec>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1EncryptionSpec>): void;
        getEncryptionSpec(params: Params$Resource$Projects$Locations$Getencryptionspec, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1EncryptionSpec>): void;
        getEncryptionSpec(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1EncryptionSpec>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.locations.list({
         *     extraLocationTypes: 'placeholder-value',
         *
         *     filter: 'placeholder-value',
         *
         *     name: 'projects/my-project',
         *
         *     pageSize: 'placeholder-value',
         *
         *     pageToken: 'placeholder-value',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "locations": [],
         *   //   "nextPageToken": "my_nextPageToken"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Locations$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Locations$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudLocationListLocationsResponse>>;
        list(params: Params$Resource$Projects$Locations$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Locations$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudLocationListLocationsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudLocationListLocationsResponse>): void;
        list(params: Params$Resource$Projects$Locations$List, callback: BodyResponseCallback<Schema$GoogleCloudLocationListLocationsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudLocationListLocationsResponse>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.locations.setAgent({
         *     parent: 'projects/my-project/locations/my-location',
         *
         *     updateMask: 'placeholder-value',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "apiVersion": "my_apiVersion",
         *       //   "avatarUri": "my_avatarUri",
         *       //   "classificationThreshold": {},
         *       //   "defaultLanguageCode": "my_defaultLanguageCode",
         *       //   "description": "my_description",
         *       //   "displayName": "my_displayName",
         *       //   "enableLogging": false,
         *       //   "matchMode": "my_matchMode",
         *       //   "parent": "my_parent",
         *       //   "supportedLanguageCodes": [],
         *       //   "tier": "my_tier",
         *       //   "timeZone": "my_timeZone"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "apiVersion": "my_apiVersion",
         *   //   "avatarUri": "my_avatarUri",
         *   //   "classificationThreshold": {},
         *   //   "defaultLanguageCode": "my_defaultLanguageCode",
         *   //   "description": "my_description",
         *   //   "displayName": "my_displayName",
         *   //   "enableLogging": false,
         *   //   "matchMode": "my_matchMode",
         *   //   "parent": "my_parent",
         *   //   "supportedLanguageCodes": [],
         *   //   "tier": "my_tier",
         *   //   "timeZone": "my_timeZone"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        setAgent(params: Params$Resource$Projects$Locations$Setagent, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        setAgent(params?: Params$Resource$Projects$Locations$Setagent, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1Agent>>;
        setAgent(params: Params$Resource$Projects$Locations$Setagent, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        setAgent(params: Params$Resource$Projects$Locations$Setagent, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Agent>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Agent>): void;
        setAgent(params: Params$Resource$Projects$Locations$Setagent, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Agent>): void;
        setAgent(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Agent>): void;
    }
    export interface Params$Resource$Projects$Locations$Deleteagent extends StandardParameters {
        /**
         *
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Locations$Get extends StandardParameters {
        /**
         *
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Getagent extends StandardParameters {
        /**
         *
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Locations$Getencryptionspec extends StandardParameters {
        /**
         *
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$List extends StandardParameters {
        /**
         *
         */
        extraLocationTypes?: string[];
        /**
         *
         */
        filter?: string;
        /**
         *
         */
        name?: string;
        /**
         *
         */
        pageSize?: number;
        /**
         *
         */
        pageToken?: string;
    }
    export interface Params$Resource$Projects$Locations$Setagent extends StandardParameters {
        /**
         *
         */
        parent?: string;
        /**
         *
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1Agent;
    }
    export class Resource$Projects$Locations$Agent {
        context: APIRequestContext;
        entityTypes: Resource$Projects$Locations$Agent$Entitytypes;
        environments: Resource$Projects$Locations$Agent$Environments;
        intents: Resource$Projects$Locations$Agent$Intents;
        sessions: Resource$Projects$Locations$Agent$Sessions;
        versions: Resource$Projects$Locations$Agent$Versions;
        constructor(context: APIRequestContext);
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.locations.agent.export({
         *     parent: 'projects/my-project/locations/my-location',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "agentUri": "my_agentUri"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        export(params: Params$Resource$Projects$Locations$Agent$Export, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        export(params?: Params$Resource$Projects$Locations$Agent$Export, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        export(params: Params$Resource$Projects$Locations$Agent$Export, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        export(params: Params$Resource$Projects$Locations$Agent$Export, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        export(params: Params$Resource$Projects$Locations$Agent$Export, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        export(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.locations.agent.getFulfillment({
         *     name: 'projects/my-project/locations/my-location/agent/fulfillment',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "displayName": "my_displayName",
         *   //   "enabled": false,
         *   //   "features": [],
         *   //   "genericWebService": {},
         *   //   "name": "my_name"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        getFulfillment(params: Params$Resource$Projects$Locations$Agent$Getfulfillment, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        getFulfillment(params?: Params$Resource$Projects$Locations$Agent$Getfulfillment, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1Fulfillment>>;
        getFulfillment(params: Params$Resource$Projects$Locations$Agent$Getfulfillment, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        getFulfillment(params: Params$Resource$Projects$Locations$Agent$Getfulfillment, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Fulfillment>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Fulfillment>): void;
        getFulfillment(params: Params$Resource$Projects$Locations$Agent$Getfulfillment, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Fulfillment>): void;
        getFulfillment(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Fulfillment>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.locations.agent.getValidationResult({
         *     languageCode: 'placeholder-value',
         *
         *     parent: 'projects/my-project/locations/my-location',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "validationErrors": []
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        getValidationResult(params: Params$Resource$Projects$Locations$Agent$Getvalidationresult, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        getValidationResult(params?: Params$Resource$Projects$Locations$Agent$Getvalidationresult, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1ValidationResult>>;
        getValidationResult(params: Params$Resource$Projects$Locations$Agent$Getvalidationresult, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        getValidationResult(params: Params$Resource$Projects$Locations$Agent$Getvalidationresult, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ValidationResult>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ValidationResult>): void;
        getValidationResult(params: Params$Resource$Projects$Locations$Agent$Getvalidationresult, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ValidationResult>): void;
        getValidationResult(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ValidationResult>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.locations.agent.import({
         *     parent: 'projects/my-project/locations/my-location',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "agentContent": "my_agentContent",
         *       //   "agentUri": "my_agentUri"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        import(params: Params$Resource$Projects$Locations$Agent$Import, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        import(params?: Params$Resource$Projects$Locations$Agent$Import, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        import(params: Params$Resource$Projects$Locations$Agent$Import, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        import(params: Params$Resource$Projects$Locations$Agent$Import, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        import(params: Params$Resource$Projects$Locations$Agent$Import, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        import(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.locations.agent.restore({
         *     parent: 'projects/my-project/locations/my-location',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "agentContent": "my_agentContent",
         *       //   "agentUri": "my_agentUri"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        restore(params: Params$Resource$Projects$Locations$Agent$Restore, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        restore(params?: Params$Resource$Projects$Locations$Agent$Restore, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        restore(params: Params$Resource$Projects$Locations$Agent$Restore, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        restore(params: Params$Resource$Projects$Locations$Agent$Restore, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        restore(params: Params$Resource$Projects$Locations$Agent$Restore, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        restore(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.locations.agent.search({
         *     pageSize: 'placeholder-value',
         *
         *     pageToken: 'placeholder-value',
         *
         *     parent: 'projects/my-project/locations/my-location',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "agents": [],
         *   //   "nextPageToken": "my_nextPageToken"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        search(params: Params$Resource$Projects$Locations$Agent$Search, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        search(params?: Params$Resource$Projects$Locations$Agent$Search, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1SearchAgentsResponse>>;
        search(params: Params$Resource$Projects$Locations$Agent$Search, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        search(params: Params$Resource$Projects$Locations$Agent$Search, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SearchAgentsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SearchAgentsResponse>): void;
        search(params: Params$Resource$Projects$Locations$Agent$Search, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SearchAgentsResponse>): void;
        search(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SearchAgentsResponse>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.locations.agent.train({
         *     parent: 'projects/my-project/locations/my-location',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {}
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        train(params: Params$Resource$Projects$Locations$Agent$Train, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        train(params?: Params$Resource$Projects$Locations$Agent$Train, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        train(params: Params$Resource$Projects$Locations$Agent$Train, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        train(params: Params$Resource$Projects$Locations$Agent$Train, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        train(params: Params$Resource$Projects$Locations$Agent$Train, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        train(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.locations.agent.updateFulfillment({
         *     name: 'projects/my-project/locations/my-location/agent/fulfillment',
         *
         *     updateMask: 'placeholder-value',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "displayName": "my_displayName",
         *       //   "enabled": false,
         *       //   "features": [],
         *       //   "genericWebService": {},
         *       //   "name": "my_name"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "displayName": "my_displayName",
         *   //   "enabled": false,
         *   //   "features": [],
         *   //   "genericWebService": {},
         *   //   "name": "my_name"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        updateFulfillment(params: Params$Resource$Projects$Locations$Agent$Updatefulfillment, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        updateFulfillment(params?: Params$Resource$Projects$Locations$Agent$Updatefulfillment, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1Fulfillment>>;
        updateFulfillment(params: Params$Resource$Projects$Locations$Agent$Updatefulfillment, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        updateFulfillment(params: Params$Resource$Projects$Locations$Agent$Updatefulfillment, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Fulfillment>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Fulfillment>): void;
        updateFulfillment(params: Params$Resource$Projects$Locations$Agent$Updatefulfillment, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Fulfillment>): void;
        updateFulfillment(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Fulfillment>): void;
    }
    export interface Params$Resource$Projects$Locations$Agent$Export extends StandardParameters {
        /**
         *
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1ExportAgentRequest;
    }
    export interface Params$Resource$Projects$Locations$Agent$Getfulfillment extends StandardParameters {
        /**
         *
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Agent$Getvalidationresult extends StandardParameters {
        /**
         *
         */
        languageCode?: string;
        /**
         *
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Locations$Agent$Import extends StandardParameters {
        /**
         *
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1ImportAgentRequest;
    }
    export interface Params$Resource$Projects$Locations$Agent$Restore extends StandardParameters {
        /**
         *
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1RestoreAgentRequest;
    }
    export interface Params$Resource$Projects$Locations$Agent$Search extends StandardParameters {
        /**
         *
         */
        pageSize?: number;
        /**
         *
         */
        pageToken?: string;
        /**
         *
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Locations$Agent$Train extends StandardParameters {
        /**
         *
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1TrainAgentRequest;
    }
    export interface Params$Resource$Projects$Locations$Agent$Updatefulfillment extends StandardParameters {
        /**
         *
         */
        name?: string;
        /**
         *
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1Fulfillment;
    }
    export class Resource$Projects$Locations$Agent$Entitytypes {
        context: APIRequestContext;
        entities: Resource$Projects$Locations$Agent$Entitytypes$Entities;
        constructor(context: APIRequestContext);
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.locations.agent.entityTypes.batchDelete(
         *     {
         *       parent: 'projects/my-project/locations/my-location/agent',
         *
         *       // Request body metadata
         *       requestBody: {
         *         // request body parameters
         *         // {
         *         //   "entityTypeNames": []
         *         // }
         *       },
         *     },
         *   );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        batchDelete(params: Params$Resource$Projects$Locations$Agent$Entitytypes$Batchdelete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        batchDelete(params?: Params$Resource$Projects$Locations$Agent$Entitytypes$Batchdelete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        batchDelete(params: Params$Resource$Projects$Locations$Agent$Entitytypes$Batchdelete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        batchDelete(params: Params$Resource$Projects$Locations$Agent$Entitytypes$Batchdelete, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        batchDelete(params: Params$Resource$Projects$Locations$Agent$Entitytypes$Batchdelete, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        batchDelete(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.locations.agent.entityTypes.batchUpdate(
         *     {
         *       parent: 'projects/my-project/locations/my-location/agent',
         *
         *       // Request body metadata
         *       requestBody: {
         *         // request body parameters
         *         // {
         *         //   "entityTypeBatchInline": {},
         *         //   "entityTypeBatchUri": "my_entityTypeBatchUri",
         *         //   "languageCode": "my_languageCode",
         *         //   "updateMask": "my_updateMask"
         *         // }
         *       },
         *     },
         *   );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        batchUpdate(params: Params$Resource$Projects$Locations$Agent$Entitytypes$Batchupdate, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        batchUpdate(params?: Params$Resource$Projects$Locations$Agent$Entitytypes$Batchupdate, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        batchUpdate(params: Params$Resource$Projects$Locations$Agent$Entitytypes$Batchupdate, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        batchUpdate(params: Params$Resource$Projects$Locations$Agent$Entitytypes$Batchupdate, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        batchUpdate(params: Params$Resource$Projects$Locations$Agent$Entitytypes$Batchupdate, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        batchUpdate(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.locations.agent.entityTypes.create({
         *     languageCode: 'placeholder-value',
         *
         *     parent: 'projects/my-project/locations/my-location/agent',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "autoExpansionMode": "my_autoExpansionMode",
         *       //   "displayName": "my_displayName",
         *       //   "enableFuzzyExtraction": false,
         *       //   "entities": [],
         *       //   "kind": "my_kind",
         *       //   "name": "my_name"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "autoExpansionMode": "my_autoExpansionMode",
         *   //   "displayName": "my_displayName",
         *   //   "enableFuzzyExtraction": false,
         *   //   "entities": [],
         *   //   "kind": "my_kind",
         *   //   "name": "my_name"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Projects$Locations$Agent$Entitytypes$Create, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        create(params?: Params$Resource$Projects$Locations$Agent$Entitytypes$Create, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1EntityType>>;
        create(params: Params$Resource$Projects$Locations$Agent$Entitytypes$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Projects$Locations$Agent$Entitytypes$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1EntityType>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1EntityType>): void;
        create(params: Params$Resource$Projects$Locations$Agent$Entitytypes$Create, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1EntityType>): void;
        create(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1EntityType>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.locations.agent.entityTypes.delete({
         *     name: 'projects/my-project/locations/my-location/agent/entityTypes/my-entityType',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {}
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Projects$Locations$Agent$Entitytypes$Delete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        delete(params?: Params$Resource$Projects$Locations$Agent$Entitytypes$Delete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleProtobufEmpty>>;
        delete(params: Params$Resource$Projects$Locations$Agent$Entitytypes$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Projects$Locations$Agent$Entitytypes$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleProtobufEmpty>, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(params: Params$Resource$Projects$Locations$Agent$Entitytypes$Delete, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.locations.agent.entityTypes.get({
         *     languageCode: 'placeholder-value',
         *
         *     name: 'projects/my-project/locations/my-location/agent/entityTypes/my-entityType',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "autoExpansionMode": "my_autoExpansionMode",
         *   //   "displayName": "my_displayName",
         *   //   "enableFuzzyExtraction": false,
         *   //   "entities": [],
         *   //   "kind": "my_kind",
         *   //   "name": "my_name"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Locations$Agent$Entitytypes$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Locations$Agent$Entitytypes$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1EntityType>>;
        get(params: Params$Resource$Projects$Locations$Agent$Entitytypes$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Locations$Agent$Entitytypes$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1EntityType>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1EntityType>): void;
        get(params: Params$Resource$Projects$Locations$Agent$Entitytypes$Get, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1EntityType>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1EntityType>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.locations.agent.entityTypes.list({
         *     languageCode: 'placeholder-value',
         *
         *     pageSize: 'placeholder-value',
         *
         *     pageToken: 'placeholder-value',
         *
         *     parent: 'projects/my-project/locations/my-location/agent',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "entityTypes": [],
         *   //   "nextPageToken": "my_nextPageToken"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Locations$Agent$Entitytypes$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Locations$Agent$Entitytypes$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1ListEntityTypesResponse>>;
        list(params: Params$Resource$Projects$Locations$Agent$Entitytypes$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Locations$Agent$Entitytypes$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListEntityTypesResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListEntityTypesResponse>): void;
        list(params: Params$Resource$Projects$Locations$Agent$Entitytypes$List, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListEntityTypesResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListEntityTypesResponse>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.locations.agent.entityTypes.patch({
         *     languageCode: 'placeholder-value',
         *
         *     name: 'projects/my-project/locations/my-location/agent/entityTypes/my-entityType',
         *
         *     updateMask: 'placeholder-value',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "autoExpansionMode": "my_autoExpansionMode",
         *       //   "displayName": "my_displayName",
         *       //   "enableFuzzyExtraction": false,
         *       //   "entities": [],
         *       //   "kind": "my_kind",
         *       //   "name": "my_name"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "autoExpansionMode": "my_autoExpansionMode",
         *   //   "displayName": "my_displayName",
         *   //   "enableFuzzyExtraction": false,
         *   //   "entities": [],
         *   //   "kind": "my_kind",
         *   //   "name": "my_name"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        patch(params: Params$Resource$Projects$Locations$Agent$Entitytypes$Patch, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        patch(params?: Params$Resource$Projects$Locations$Agent$Entitytypes$Patch, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1EntityType>>;
        patch(params: Params$Resource$Projects$Locations$Agent$Entitytypes$Patch, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        patch(params: Params$Resource$Projects$Locations$Agent$Entitytypes$Patch, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1EntityType>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1EntityType>): void;
        patch(params: Params$Resource$Projects$Locations$Agent$Entitytypes$Patch, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1EntityType>): void;
        patch(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1EntityType>): void;
    }
    export interface Params$Resource$Projects$Locations$Agent$Entitytypes$Batchdelete extends StandardParameters {
        /**
         *
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1BatchDeleteEntityTypesRequest;
    }
    export interface Params$Resource$Projects$Locations$Agent$Entitytypes$Batchupdate extends StandardParameters {
        /**
         *
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1BatchUpdateEntityTypesRequest;
    }
    export interface Params$Resource$Projects$Locations$Agent$Entitytypes$Create extends StandardParameters {
        /**
         *
         */
        languageCode?: string;
        /**
         *
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1EntityType;
    }
    export interface Params$Resource$Projects$Locations$Agent$Entitytypes$Delete extends StandardParameters {
        /**
         *
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Agent$Entitytypes$Get extends StandardParameters {
        /**
         *
         */
        languageCode?: string;
        /**
         *
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Agent$Entitytypes$List extends StandardParameters {
        /**
         *
         */
        languageCode?: string;
        /**
         *
         */
        pageSize?: number;
        /**
         *
         */
        pageToken?: string;
        /**
         *
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Locations$Agent$Entitytypes$Patch extends StandardParameters {
        /**
         *
         */
        languageCode?: string;
        /**
         *
         */
        name?: string;
        /**
         *
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1EntityType;
    }
    export class Resource$Projects$Locations$Agent$Entitytypes$Entities {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await dialogflow.projects.locations.agent.entityTypes.entities.batchCreate({
         *       parent:
         *         'projects/my-project/locations/my-location/agent/entityTypes/my-entityType',
         *
         *       // Request body metadata
         *       requestBody: {
         *         // request body parameters
         *         // {
         *         //   "entities": [],
         *         //   "languageCode": "my_languageCode"
         *         // }
         *       },
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        batchCreate(params: Params$Resource$Projects$Locations$Agent$Entitytypes$Entities$Batchcreate, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        batchCreate(params?: Params$Resource$Projects$Locations$Agent$Entitytypes$Entities$Batchcreate, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        batchCreate(params: Params$Resource$Projects$Locations$Agent$Entitytypes$Entities$Batchcreate, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        batchCreate(params: Params$Resource$Projects$Locations$Agent$Entitytypes$Entities$Batchcreate, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        batchCreate(params: Params$Resource$Projects$Locations$Agent$Entitytypes$Entities$Batchcreate, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        batchCreate(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await dialogflow.projects.locations.agent.entityTypes.entities.batchDelete({
         *       parent:
         *         'projects/my-project/locations/my-location/agent/entityTypes/my-entityType',
         *
         *       // Request body metadata
         *       requestBody: {
         *         // request body parameters
         *         // {
         *         //   "entityValues": [],
         *         //   "languageCode": "my_languageCode"
         *         // }
         *       },
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        batchDelete(params: Params$Resource$Projects$Locations$Agent$Entitytypes$Entities$Batchdelete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        batchDelete(params?: Params$Resource$Projects$Locations$Agent$Entitytypes$Entities$Batchdelete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        batchDelete(params: Params$Resource$Projects$Locations$Agent$Entitytypes$Entities$Batchdelete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        batchDelete(params: Params$Resource$Projects$Locations$Agent$Entitytypes$Entities$Batchdelete, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        batchDelete(params: Params$Resource$Projects$Locations$Agent$Entitytypes$Entities$Batchdelete, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        batchDelete(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await dialogflow.projects.locations.agent.entityTypes.entities.batchUpdate({
         *       parent:
         *         'projects/my-project/locations/my-location/agent/entityTypes/my-entityType',
         *
         *       // Request body metadata
         *       requestBody: {
         *         // request body parameters
         *         // {
         *         //   "entities": [],
         *         //   "languageCode": "my_languageCode",
         *         //   "updateMask": "my_updateMask"
         *         // }
         *       },
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        batchUpdate(params: Params$Resource$Projects$Locations$Agent$Entitytypes$Entities$Batchupdate, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        batchUpdate(params?: Params$Resource$Projects$Locations$Agent$Entitytypes$Entities$Batchupdate, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        batchUpdate(params: Params$Resource$Projects$Locations$Agent$Entitytypes$Entities$Batchupdate, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        batchUpdate(params: Params$Resource$Projects$Locations$Agent$Entitytypes$Entities$Batchupdate, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        batchUpdate(params: Params$Resource$Projects$Locations$Agent$Entitytypes$Entities$Batchupdate, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        batchUpdate(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
    }
    export interface Params$Resource$Projects$Locations$Agent$Entitytypes$Entities$Batchcreate extends StandardParameters {
        /**
         *
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1BatchCreateEntitiesRequest;
    }
    export interface Params$Resource$Projects$Locations$Agent$Entitytypes$Entities$Batchdelete extends StandardParameters {
        /**
         *
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1BatchDeleteEntitiesRequest;
    }
    export interface Params$Resource$Projects$Locations$Agent$Entitytypes$Entities$Batchupdate extends StandardParameters {
        /**
         *
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1BatchUpdateEntitiesRequest;
    }
    export class Resource$Projects$Locations$Agent$Environments {
        context: APIRequestContext;
        intents: Resource$Projects$Locations$Agent$Environments$Intents;
        users: Resource$Projects$Locations$Agent$Environments$Users;
        constructor(context: APIRequestContext);
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.locations.agent.environments.create({
         *     environmentId: 'placeholder-value',
         *
         *     parent: 'projects/my-project/locations/my-location/agent',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "agentVersion": "my_agentVersion",
         *       //   "description": "my_description",
         *       //   "fulfillment": {},
         *       //   "name": "my_name",
         *       //   "state": "my_state",
         *       //   "textToSpeechSettings": {},
         *       //   "updateTime": "my_updateTime"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "agentVersion": "my_agentVersion",
         *   //   "description": "my_description",
         *   //   "fulfillment": {},
         *   //   "name": "my_name",
         *   //   "state": "my_state",
         *   //   "textToSpeechSettings": {},
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Projects$Locations$Agent$Environments$Create, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        create(params?: Params$Resource$Projects$Locations$Agent$Environments$Create, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1Environment>>;
        create(params: Params$Resource$Projects$Locations$Agent$Environments$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Projects$Locations$Agent$Environments$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Environment>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Environment>): void;
        create(params: Params$Resource$Projects$Locations$Agent$Environments$Create, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Environment>): void;
        create(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Environment>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.locations.agent.environments.delete({
         *     name: 'projects/my-project/locations/my-location/agent/environments/my-environment',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {}
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Projects$Locations$Agent$Environments$Delete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        delete(params?: Params$Resource$Projects$Locations$Agent$Environments$Delete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleProtobufEmpty>>;
        delete(params: Params$Resource$Projects$Locations$Agent$Environments$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Projects$Locations$Agent$Environments$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleProtobufEmpty>, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(params: Params$Resource$Projects$Locations$Agent$Environments$Delete, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.locations.agent.environments.get({
         *     name: 'projects/my-project/locations/my-location/agent/environments/my-environment',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "agentVersion": "my_agentVersion",
         *   //   "description": "my_description",
         *   //   "fulfillment": {},
         *   //   "name": "my_name",
         *   //   "state": "my_state",
         *   //   "textToSpeechSettings": {},
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Locations$Agent$Environments$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Locations$Agent$Environments$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1Environment>>;
        get(params: Params$Resource$Projects$Locations$Agent$Environments$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Locations$Agent$Environments$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Environment>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Environment>): void;
        get(params: Params$Resource$Projects$Locations$Agent$Environments$Get, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Environment>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Environment>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.locations.agent.environments.getHistory(
         *     {
         *       pageSize: 'placeholder-value',
         *
         *       pageToken: 'placeholder-value',
         *
         *       parent:
         *         'projects/my-project/locations/my-location/agent/environments/my-environment',
         *     },
         *   );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "entries": [],
         *   //   "nextPageToken": "my_nextPageToken",
         *   //   "parent": "my_parent"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        getHistory(params: Params$Resource$Projects$Locations$Agent$Environments$Gethistory, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        getHistory(params?: Params$Resource$Projects$Locations$Agent$Environments$Gethistory, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1EnvironmentHistory>>;
        getHistory(params: Params$Resource$Projects$Locations$Agent$Environments$Gethistory, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        getHistory(params: Params$Resource$Projects$Locations$Agent$Environments$Gethistory, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1EnvironmentHistory>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1EnvironmentHistory>): void;
        getHistory(params: Params$Resource$Projects$Locations$Agent$Environments$Gethistory, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1EnvironmentHistory>): void;
        getHistory(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1EnvironmentHistory>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.locations.agent.environments.list({
         *     pageSize: 'placeholder-value',
         *
         *     pageToken: 'placeholder-value',
         *
         *     parent: 'projects/my-project/locations/my-location/agent',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "environments": [],
         *   //   "nextPageToken": "my_nextPageToken"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Locations$Agent$Environments$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Locations$Agent$Environments$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1ListEnvironmentsResponse>>;
        list(params: Params$Resource$Projects$Locations$Agent$Environments$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Locations$Agent$Environments$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListEnvironmentsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListEnvironmentsResponse>): void;
        list(params: Params$Resource$Projects$Locations$Agent$Environments$List, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListEnvironmentsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListEnvironmentsResponse>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.locations.agent.environments.patch({
         *     allowLoadToDraftAndDiscardChanges: 'placeholder-value',
         *
         *     name: 'projects/my-project/locations/my-location/agent/environments/my-environment',
         *
         *     updateMask: 'placeholder-value',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "agentVersion": "my_agentVersion",
         *       //   "description": "my_description",
         *       //   "fulfillment": {},
         *       //   "name": "my_name",
         *       //   "state": "my_state",
         *       //   "textToSpeechSettings": {},
         *       //   "updateTime": "my_updateTime"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "agentVersion": "my_agentVersion",
         *   //   "description": "my_description",
         *   //   "fulfillment": {},
         *   //   "name": "my_name",
         *   //   "state": "my_state",
         *   //   "textToSpeechSettings": {},
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        patch(params: Params$Resource$Projects$Locations$Agent$Environments$Patch, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        patch(params?: Params$Resource$Projects$Locations$Agent$Environments$Patch, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1Environment>>;
        patch(params: Params$Resource$Projects$Locations$Agent$Environments$Patch, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        patch(params: Params$Resource$Projects$Locations$Agent$Environments$Patch, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Environment>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Environment>): void;
        patch(params: Params$Resource$Projects$Locations$Agent$Environments$Patch, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Environment>): void;
        patch(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Environment>): void;
    }
    export interface Params$Resource$Projects$Locations$Agent$Environments$Create extends StandardParameters {
        /**
         *
         */
        environmentId?: string;
        /**
         *
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1Environment;
    }
    export interface Params$Resource$Projects$Locations$Agent$Environments$Delete extends StandardParameters {
        /**
         *
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Agent$Environments$Get extends StandardParameters {
        /**
         *
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Agent$Environments$Gethistory extends StandardParameters {
        /**
         *
         */
        pageSize?: number;
        /**
         *
         */
        pageToken?: string;
        /**
         *
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Locations$Agent$Environments$List extends StandardParameters {
        /**
         *
         */
        pageSize?: number;
        /**
         *
         */
        pageToken?: string;
        /**
         *
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Locations$Agent$Environments$Patch extends StandardParameters {
        /**
         *
         */
        allowLoadToDraftAndDiscardChanges?: boolean;
        /**
         *
         */
        name?: string;
        /**
         *
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1Environment;
    }
    export class Resource$Projects$Locations$Agent$Environments$Intents {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await dialogflow.projects.locations.agent.environments.intents.list({
         *       intentView: 'placeholder-value',
         *
         *       languageCode: 'placeholder-value',
         *
         *       pageSize: 'placeholder-value',
         *
         *       pageToken: 'placeholder-value',
         *
         *       parent:
         *         'projects/my-project/locations/my-location/agent/environments/my-environment',
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "intents": [],
         *   //   "nextPageToken": "my_nextPageToken"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Locations$Agent$Environments$Intents$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Locations$Agent$Environments$Intents$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1ListIntentsResponse>>;
        list(params: Params$Resource$Projects$Locations$Agent$Environments$Intents$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Locations$Agent$Environments$Intents$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListIntentsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListIntentsResponse>): void;
        list(params: Params$Resource$Projects$Locations$Agent$Environments$Intents$List, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListIntentsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListIntentsResponse>): void;
    }
    export interface Params$Resource$Projects$Locations$Agent$Environments$Intents$List extends StandardParameters {
        /**
         *
         */
        intentView?: string;
        /**
         *
         */
        languageCode?: string;
        /**
         *
         */
        pageSize?: number;
        /**
         *
         */
        pageToken?: string;
        /**
         *
         */
        parent?: string;
    }
    export class Resource$Projects$Locations$Agent$Environments$Users {
        context: APIRequestContext;
        sessions: Resource$Projects$Locations$Agent$Environments$Users$Sessions;
        constructor(context: APIRequestContext);
    }
    export class Resource$Projects$Locations$Agent$Environments$Users$Sessions {
        context: APIRequestContext;
        contexts: Resource$Projects$Locations$Agent$Environments$Users$Sessions$Contexts;
        entityTypes: Resource$Projects$Locations$Agent$Environments$Users$Sessions$Entitytypes;
        constructor(context: APIRequestContext);
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await dialogflow.projects.locations.agent.environments.users.sessions.deleteContexts(
         *       {
         *         parent:
         *           'projects/my-project/locations/my-location/agent/environments/my-environment/users/my-user/sessions/my-session',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {}
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        deleteContexts(params: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Deletecontexts, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        deleteContexts(params?: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Deletecontexts, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleProtobufEmpty>>;
        deleteContexts(params: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Deletecontexts, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        deleteContexts(params: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Deletecontexts, options: MethodOptions | BodyResponseCallback<Schema$GoogleProtobufEmpty>, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        deleteContexts(params: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Deletecontexts, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        deleteContexts(callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await dialogflow.projects.locations.agent.environments.users.sessions.detectIntent(
         *       {
         *         session:
         *           'projects/my-project/locations/my-location/agent/environments/my-environment/users/my-user/sessions/my-session',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "inputAudio": "my_inputAudio",
         *           //   "outputAudioConfig": {},
         *           //   "outputAudioConfigMask": "my_outputAudioConfigMask",
         *           //   "queryInput": {},
         *           //   "queryParams": {}
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "alternativeQueryResults": [],
         *   //   "outputAudio": "my_outputAudio",
         *   //   "outputAudioConfig": {},
         *   //   "queryResult": {},
         *   //   "responseId": "my_responseId",
         *   //   "webhookStatus": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        detectIntent(params: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Detectintent, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        detectIntent(params?: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Detectintent, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1DetectIntentResponse>>;
        detectIntent(params: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Detectintent, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        detectIntent(params: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Detectintent, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1DetectIntentResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1DetectIntentResponse>): void;
        detectIntent(params: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Detectintent, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1DetectIntentResponse>): void;
        detectIntent(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1DetectIntentResponse>): void;
    }
    export interface Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Deletecontexts extends StandardParameters {
        /**
         *
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Detectintent extends StandardParameters {
        /**
         *
         */
        session?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1DetectIntentRequest;
    }
    export class Resource$Projects$Locations$Agent$Environments$Users$Sessions$Contexts {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await dialogflow.projects.locations.agent.environments.users.sessions.contexts.create(
         *       {
         *         parent:
         *           'projects/my-project/locations/my-location/agent/environments/my-environment/users/my-user/sessions/my-session',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "lifespanCount": 0,
         *           //   "name": "my_name",
         *           //   "parameters": {}
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "lifespanCount": 0,
         *   //   "name": "my_name",
         *   //   "parameters": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Contexts$Create, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        create(params?: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Contexts$Create, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1Context>>;
        create(params: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Contexts$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Contexts$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Context>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Context>): void;
        create(params: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Contexts$Create, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Context>): void;
        create(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Context>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await dialogflow.projects.locations.agent.environments.users.sessions.contexts.delete(
         *       {
         *         name: 'projects/my-project/locations/my-location/agent/environments/my-environment/users/my-user/sessions/my-session/contexts/my-context',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {}
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Contexts$Delete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        delete(params?: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Contexts$Delete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleProtobufEmpty>>;
        delete(params: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Contexts$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Contexts$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleProtobufEmpty>, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(params: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Contexts$Delete, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await dialogflow.projects.locations.agent.environments.users.sessions.contexts.get(
         *       {
         *         name: 'projects/my-project/locations/my-location/agent/environments/my-environment/users/my-user/sessions/my-session/contexts/my-context',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "lifespanCount": 0,
         *   //   "name": "my_name",
         *   //   "parameters": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Contexts$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Contexts$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1Context>>;
        get(params: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Contexts$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Contexts$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Context>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Context>): void;
        get(params: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Contexts$Get, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Context>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Context>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await dialogflow.projects.locations.agent.environments.users.sessions.contexts.list(
         *       {
         *         pageSize: 'placeholder-value',
         *
         *         pageToken: 'placeholder-value',
         *
         *         parent:
         *           'projects/my-project/locations/my-location/agent/environments/my-environment/users/my-user/sessions/my-session',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "contexts": [],
         *   //   "nextPageToken": "my_nextPageToken"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Contexts$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Contexts$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1ListContextsResponse>>;
        list(params: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Contexts$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Contexts$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListContextsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListContextsResponse>): void;
        list(params: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Contexts$List, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListContextsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListContextsResponse>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await dialogflow.projects.locations.agent.environments.users.sessions.contexts.patch(
         *       {
         *         name: 'projects/my-project/locations/my-location/agent/environments/my-environment/users/my-user/sessions/my-session/contexts/my-context',
         *
         *         updateMask: 'placeholder-value',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "lifespanCount": 0,
         *           //   "name": "my_name",
         *           //   "parameters": {}
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "lifespanCount": 0,
         *   //   "name": "my_name",
         *   //   "parameters": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        patch(params: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Contexts$Patch, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        patch(params?: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Contexts$Patch, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1Context>>;
        patch(params: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Contexts$Patch, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        patch(params: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Contexts$Patch, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Context>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Context>): void;
        patch(params: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Contexts$Patch, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Context>): void;
        patch(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Context>): void;
    }
    export interface Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Contexts$Create extends StandardParameters {
        /**
         *
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1Context;
    }
    export interface Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Contexts$Delete extends StandardParameters {
        /**
         *
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Contexts$Get extends StandardParameters {
        /**
         *
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Contexts$List extends StandardParameters {
        /**
         *
         */
        pageSize?: number;
        /**
         *
         */
        pageToken?: string;
        /**
         *
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Contexts$Patch extends StandardParameters {
        /**
         *
         */
        name?: string;
        /**
         *
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1Context;
    }
    export class Resource$Projects$Locations$Agent$Environments$Users$Sessions$Entitytypes {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await dialogflow.projects.locations.agent.environments.users.sessions.entityTypes.create(
         *       {
         *         parent:
         *           'projects/my-project/locations/my-location/agent/environments/my-environment/users/my-user/sessions/my-session',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "entities": [],
         *           //   "entityOverrideMode": "my_entityOverrideMode",
         *           //   "name": "my_name"
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "entities": [],
         *   //   "entityOverrideMode": "my_entityOverrideMode",
         *   //   "name": "my_name"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Entitytypes$Create, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        create(params?: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Entitytypes$Create, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>>;
        create(params: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Entitytypes$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Entitytypes$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>): void;
        create(params: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Entitytypes$Create, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>): void;
        create(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await dialogflow.projects.locations.agent.environments.users.sessions.entityTypes.delete(
         *       {
         *         name: 'projects/my-project/locations/my-location/agent/environments/my-environment/users/my-user/sessions/my-session/entityTypes/my-entityType',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {}
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Entitytypes$Delete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        delete(params?: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Entitytypes$Delete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleProtobufEmpty>>;
        delete(params: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Entitytypes$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Entitytypes$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleProtobufEmpty>, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(params: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Entitytypes$Delete, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await dialogflow.projects.locations.agent.environments.users.sessions.entityTypes.get(
         *       {
         *         name: 'projects/my-project/locations/my-location/agent/environments/my-environment/users/my-user/sessions/my-session/entityTypes/my-entityType',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "entities": [],
         *   //   "entityOverrideMode": "my_entityOverrideMode",
         *   //   "name": "my_name"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Entitytypes$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Entitytypes$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>>;
        get(params: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Entitytypes$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Entitytypes$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>): void;
        get(params: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Entitytypes$Get, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await dialogflow.projects.locations.agent.environments.users.sessions.entityTypes.list(
         *       {
         *         pageSize: 'placeholder-value',
         *
         *         pageToken: 'placeholder-value',
         *
         *         parent:
         *           'projects/my-project/locations/my-location/agent/environments/my-environment/users/my-user/sessions/my-session',
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "nextPageToken": "my_nextPageToken",
         *   //   "sessionEntityTypes": []
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Entitytypes$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Entitytypes$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1ListSessionEntityTypesResponse>>;
        list(params: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Entitytypes$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Entitytypes$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListSessionEntityTypesResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListSessionEntityTypesResponse>): void;
        list(params: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Entitytypes$List, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListSessionEntityTypesResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListSessionEntityTypesResponse>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await dialogflow.projects.locations.agent.environments.users.sessions.entityTypes.patch(
         *       {
         *         name: 'projects/my-project/locations/my-location/agent/environments/my-environment/users/my-user/sessions/my-session/entityTypes/my-entityType',
         *
         *         updateMask: 'placeholder-value',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "entities": [],
         *           //   "entityOverrideMode": "my_entityOverrideMode",
         *           //   "name": "my_name"
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "entities": [],
         *   //   "entityOverrideMode": "my_entityOverrideMode",
         *   //   "name": "my_name"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        patch(params: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Entitytypes$Patch, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        patch(params?: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Entitytypes$Patch, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>>;
        patch(params: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Entitytypes$Patch, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        patch(params: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Entitytypes$Patch, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>): void;
        patch(params: Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Entitytypes$Patch, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>): void;
        patch(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>): void;
    }
    export interface Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Entitytypes$Create extends StandardParameters {
        /**
         *
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1SessionEntityType;
    }
    export interface Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Entitytypes$Delete extends StandardParameters {
        /**
         *
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Entitytypes$Get extends StandardParameters {
        /**
         *
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Entitytypes$List extends StandardParameters {
        /**
         *
         */
        pageSize?: number;
        /**
         *
         */
        pageToken?: string;
        /**
         *
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Locations$Agent$Environments$Users$Sessions$Entitytypes$Patch extends StandardParameters {
        /**
         *
         */
        name?: string;
        /**
         *
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1SessionEntityType;
    }
    export class Resource$Projects$Locations$Agent$Intents {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.locations.agent.intents.batchDelete({
         *     parent: 'projects/my-project/locations/my-location/agent',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "intents": []
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        batchDelete(params: Params$Resource$Projects$Locations$Agent$Intents$Batchdelete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        batchDelete(params?: Params$Resource$Projects$Locations$Agent$Intents$Batchdelete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        batchDelete(params: Params$Resource$Projects$Locations$Agent$Intents$Batchdelete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        batchDelete(params: Params$Resource$Projects$Locations$Agent$Intents$Batchdelete, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        batchDelete(params: Params$Resource$Projects$Locations$Agent$Intents$Batchdelete, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        batchDelete(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.locations.agent.intents.batchUpdate({
         *     parent: 'projects/my-project/locations/my-location/agent',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "intentBatchInline": {},
         *       //   "intentBatchUri": "my_intentBatchUri",
         *       //   "intentView": "my_intentView",
         *       //   "languageCode": "my_languageCode",
         *       //   "updateMask": "my_updateMask"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        batchUpdate(params: Params$Resource$Projects$Locations$Agent$Intents$Batchupdate, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        batchUpdate(params?: Params$Resource$Projects$Locations$Agent$Intents$Batchupdate, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        batchUpdate(params: Params$Resource$Projects$Locations$Agent$Intents$Batchupdate, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        batchUpdate(params: Params$Resource$Projects$Locations$Agent$Intents$Batchupdate, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        batchUpdate(params: Params$Resource$Projects$Locations$Agent$Intents$Batchupdate, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        batchUpdate(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.locations.agent.intents.create({
         *     intentView: 'placeholder-value',
         *
         *     languageCode: 'placeholder-value',
         *
         *     parent: 'projects/my-project/locations/my-location/agent',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "action": "my_action",
         *       //   "defaultResponsePlatforms": [],
         *       //   "displayName": "my_displayName",
         *       //   "endInteraction": false,
         *       //   "events": [],
         *       //   "followupIntentInfo": [],
         *       //   "inputContextNames": [],
         *       //   "isFallback": false,
         *       //   "liveAgentHandoff": false,
         *       //   "messages": [],
         *       //   "mlDisabled": false,
         *       //   "mlEnabled": false,
         *       //   "name": "my_name",
         *       //   "outputContexts": [],
         *       //   "parameters": [],
         *       //   "parentFollowupIntentName": "my_parentFollowupIntentName",
         *       //   "priority": 0,
         *       //   "resetContexts": false,
         *       //   "rootFollowupIntentName": "my_rootFollowupIntentName",
         *       //   "trainingPhrases": [],
         *       //   "webhookState": "my_webhookState"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "action": "my_action",
         *   //   "defaultResponsePlatforms": [],
         *   //   "displayName": "my_displayName",
         *   //   "endInteraction": false,
         *   //   "events": [],
         *   //   "followupIntentInfo": [],
         *   //   "inputContextNames": [],
         *   //   "isFallback": false,
         *   //   "liveAgentHandoff": false,
         *   //   "messages": [],
         *   //   "mlDisabled": false,
         *   //   "mlEnabled": false,
         *   //   "name": "my_name",
         *   //   "outputContexts": [],
         *   //   "parameters": [],
         *   //   "parentFollowupIntentName": "my_parentFollowupIntentName",
         *   //   "priority": 0,
         *   //   "resetContexts": false,
         *   //   "rootFollowupIntentName": "my_rootFollowupIntentName",
         *   //   "trainingPhrases": [],
         *   //   "webhookState": "my_webhookState"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Projects$Locations$Agent$Intents$Create, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        create(params?: Params$Resource$Projects$Locations$Agent$Intents$Create, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1Intent>>;
        create(params: Params$Resource$Projects$Locations$Agent$Intents$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Projects$Locations$Agent$Intents$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Intent>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Intent>): void;
        create(params: Params$Resource$Projects$Locations$Agent$Intents$Create, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Intent>): void;
        create(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Intent>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.locations.agent.intents.delete({
         *     name: 'projects/my-project/locations/my-location/agent/intents/my-intent',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {}
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Projects$Locations$Agent$Intents$Delete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        delete(params?: Params$Resource$Projects$Locations$Agent$Intents$Delete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleProtobufEmpty>>;
        delete(params: Params$Resource$Projects$Locations$Agent$Intents$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Projects$Locations$Agent$Intents$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleProtobufEmpty>, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(params: Params$Resource$Projects$Locations$Agent$Intents$Delete, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.locations.agent.intents.get({
         *     intentView: 'placeholder-value',
         *
         *     languageCode: 'placeholder-value',
         *
         *     name: 'projects/my-project/locations/my-location/agent/intents/my-intent',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "action": "my_action",
         *   //   "defaultResponsePlatforms": [],
         *   //   "displayName": "my_displayName",
         *   //   "endInteraction": false,
         *   //   "events": [],
         *   //   "followupIntentInfo": [],
         *   //   "inputContextNames": [],
         *   //   "isFallback": false,
         *   //   "liveAgentHandoff": false,
         *   //   "messages": [],
         *   //   "mlDisabled": false,
         *   //   "mlEnabled": false,
         *   //   "name": "my_name",
         *   //   "outputContexts": [],
         *   //   "parameters": [],
         *   //   "parentFollowupIntentName": "my_parentFollowupIntentName",
         *   //   "priority": 0,
         *   //   "resetContexts": false,
         *   //   "rootFollowupIntentName": "my_rootFollowupIntentName",
         *   //   "trainingPhrases": [],
         *   //   "webhookState": "my_webhookState"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Locations$Agent$Intents$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Locations$Agent$Intents$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1Intent>>;
        get(params: Params$Resource$Projects$Locations$Agent$Intents$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Locations$Agent$Intents$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Intent>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Intent>): void;
        get(params: Params$Resource$Projects$Locations$Agent$Intents$Get, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Intent>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Intent>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.locations.agent.intents.list({
         *     intentView: 'placeholder-value',
         *
         *     languageCode: 'placeholder-value',
         *
         *     pageSize: 'placeholder-value',
         *
         *     pageToken: 'placeholder-value',
         *
         *     parent: 'projects/my-project/locations/my-location/agent',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "intents": [],
         *   //   "nextPageToken": "my_nextPageToken"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Locations$Agent$Intents$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Locations$Agent$Intents$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1ListIntentsResponse>>;
        list(params: Params$Resource$Projects$Locations$Agent$Intents$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Locations$Agent$Intents$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListIntentsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListIntentsResponse>): void;
        list(params: Params$Resource$Projects$Locations$Agent$Intents$List, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListIntentsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListIntentsResponse>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.locations.agent.intents.patch({
         *     intentView: 'placeholder-value',
         *
         *     languageCode: 'placeholder-value',
         *
         *     name: 'projects/my-project/locations/my-location/agent/intents/my-intent',
         *
         *     updateMask: 'placeholder-value',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "action": "my_action",
         *       //   "defaultResponsePlatforms": [],
         *       //   "displayName": "my_displayName",
         *       //   "endInteraction": false,
         *       //   "events": [],
         *       //   "followupIntentInfo": [],
         *       //   "inputContextNames": [],
         *       //   "isFallback": false,
         *       //   "liveAgentHandoff": false,
         *       //   "messages": [],
         *       //   "mlDisabled": false,
         *       //   "mlEnabled": false,
         *       //   "name": "my_name",
         *       //   "outputContexts": [],
         *       //   "parameters": [],
         *       //   "parentFollowupIntentName": "my_parentFollowupIntentName",
         *       //   "priority": 0,
         *       //   "resetContexts": false,
         *       //   "rootFollowupIntentName": "my_rootFollowupIntentName",
         *       //   "trainingPhrases": [],
         *       //   "webhookState": "my_webhookState"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "action": "my_action",
         *   //   "defaultResponsePlatforms": [],
         *   //   "displayName": "my_displayName",
         *   //   "endInteraction": false,
         *   //   "events": [],
         *   //   "followupIntentInfo": [],
         *   //   "inputContextNames": [],
         *   //   "isFallback": false,
         *   //   "liveAgentHandoff": false,
         *   //   "messages": [],
         *   //   "mlDisabled": false,
         *   //   "mlEnabled": false,
         *   //   "name": "my_name",
         *   //   "outputContexts": [],
         *   //   "parameters": [],
         *   //   "parentFollowupIntentName": "my_parentFollowupIntentName",
         *   //   "priority": 0,
         *   //   "resetContexts": false,
         *   //   "rootFollowupIntentName": "my_rootFollowupIntentName",
         *   //   "trainingPhrases": [],
         *   //   "webhookState": "my_webhookState"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        patch(params: Params$Resource$Projects$Locations$Agent$Intents$Patch, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        patch(params?: Params$Resource$Projects$Locations$Agent$Intents$Patch, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1Intent>>;
        patch(params: Params$Resource$Projects$Locations$Agent$Intents$Patch, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        patch(params: Params$Resource$Projects$Locations$Agent$Intents$Patch, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Intent>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Intent>): void;
        patch(params: Params$Resource$Projects$Locations$Agent$Intents$Patch, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Intent>): void;
        patch(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Intent>): void;
    }
    export interface Params$Resource$Projects$Locations$Agent$Intents$Batchdelete extends StandardParameters {
        /**
         *
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1BatchDeleteIntentsRequest;
    }
    export interface Params$Resource$Projects$Locations$Agent$Intents$Batchupdate extends StandardParameters {
        /**
         *
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1BatchUpdateIntentsRequest;
    }
    export interface Params$Resource$Projects$Locations$Agent$Intents$Create extends StandardParameters {
        /**
         *
         */
        intentView?: string;
        /**
         *
         */
        languageCode?: string;
        /**
         *
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1Intent;
    }
    export interface Params$Resource$Projects$Locations$Agent$Intents$Delete extends StandardParameters {
        /**
         *
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Agent$Intents$Get extends StandardParameters {
        /**
         *
         */
        intentView?: string;
        /**
         *
         */
        languageCode?: string;
        /**
         *
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Agent$Intents$List extends StandardParameters {
        /**
         *
         */
        intentView?: string;
        /**
         *
         */
        languageCode?: string;
        /**
         *
         */
        pageSize?: number;
        /**
         *
         */
        pageToken?: string;
        /**
         *
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Locations$Agent$Intents$Patch extends StandardParameters {
        /**
         *
         */
        intentView?: string;
        /**
         *
         */
        languageCode?: string;
        /**
         *
         */
        name?: string;
        /**
         *
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1Intent;
    }
    export class Resource$Projects$Locations$Agent$Sessions {
        context: APIRequestContext;
        contexts: Resource$Projects$Locations$Agent$Sessions$Contexts;
        entityTypes: Resource$Projects$Locations$Agent$Sessions$Entitytypes;
        constructor(context: APIRequestContext);
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.locations.agent.sessions.deleteContexts(
         *     {
         *       parent:
         *         'projects/my-project/locations/my-location/agent/sessions/my-session',
         *     },
         *   );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {}
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        deleteContexts(params: Params$Resource$Projects$Locations$Agent$Sessions$Deletecontexts, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        deleteContexts(params?: Params$Resource$Projects$Locations$Agent$Sessions$Deletecontexts, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleProtobufEmpty>>;
        deleteContexts(params: Params$Resource$Projects$Locations$Agent$Sessions$Deletecontexts, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        deleteContexts(params: Params$Resource$Projects$Locations$Agent$Sessions$Deletecontexts, options: MethodOptions | BodyResponseCallback<Schema$GoogleProtobufEmpty>, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        deleteContexts(params: Params$Resource$Projects$Locations$Agent$Sessions$Deletecontexts, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        deleteContexts(callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.locations.agent.sessions.detectIntent({
         *     session:
         *       'projects/my-project/locations/my-location/agent/sessions/my-session',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "inputAudio": "my_inputAudio",
         *       //   "outputAudioConfig": {},
         *       //   "outputAudioConfigMask": "my_outputAudioConfigMask",
         *       //   "queryInput": {},
         *       //   "queryParams": {}
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "alternativeQueryResults": [],
         *   //   "outputAudio": "my_outputAudio",
         *   //   "outputAudioConfig": {},
         *   //   "queryResult": {},
         *   //   "responseId": "my_responseId",
         *   //   "webhookStatus": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        detectIntent(params: Params$Resource$Projects$Locations$Agent$Sessions$Detectintent, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        detectIntent(params?: Params$Resource$Projects$Locations$Agent$Sessions$Detectintent, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1DetectIntentResponse>>;
        detectIntent(params: Params$Resource$Projects$Locations$Agent$Sessions$Detectintent, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        detectIntent(params: Params$Resource$Projects$Locations$Agent$Sessions$Detectintent, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1DetectIntentResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1DetectIntentResponse>): void;
        detectIntent(params: Params$Resource$Projects$Locations$Agent$Sessions$Detectintent, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1DetectIntentResponse>): void;
        detectIntent(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1DetectIntentResponse>): void;
    }
    export interface Params$Resource$Projects$Locations$Agent$Sessions$Deletecontexts extends StandardParameters {
        /**
         *
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Locations$Agent$Sessions$Detectintent extends StandardParameters {
        /**
         *
         */
        session?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1DetectIntentRequest;
    }
    export class Resource$Projects$Locations$Agent$Sessions$Contexts {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await dialogflow.projects.locations.agent.sessions.contexts.create({
         *       parent:
         *         'projects/my-project/locations/my-location/agent/sessions/my-session',
         *
         *       // Request body metadata
         *       requestBody: {
         *         // request body parameters
         *         // {
         *         //   "lifespanCount": 0,
         *         //   "name": "my_name",
         *         //   "parameters": {}
         *         // }
         *       },
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "lifespanCount": 0,
         *   //   "name": "my_name",
         *   //   "parameters": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Projects$Locations$Agent$Sessions$Contexts$Create, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        create(params?: Params$Resource$Projects$Locations$Agent$Sessions$Contexts$Create, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1Context>>;
        create(params: Params$Resource$Projects$Locations$Agent$Sessions$Contexts$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Projects$Locations$Agent$Sessions$Contexts$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Context>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Context>): void;
        create(params: Params$Resource$Projects$Locations$Agent$Sessions$Contexts$Create, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Context>): void;
        create(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Context>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await dialogflow.projects.locations.agent.sessions.contexts.delete({
         *       name: 'projects/my-project/locations/my-location/agent/sessions/my-session/contexts/my-context',
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {}
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Projects$Locations$Agent$Sessions$Contexts$Delete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        delete(params?: Params$Resource$Projects$Locations$Agent$Sessions$Contexts$Delete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleProtobufEmpty>>;
        delete(params: Params$Resource$Projects$Locations$Agent$Sessions$Contexts$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Projects$Locations$Agent$Sessions$Contexts$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleProtobufEmpty>, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(params: Params$Resource$Projects$Locations$Agent$Sessions$Contexts$Delete, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.locations.agent.sessions.contexts.get({
         *     name: 'projects/my-project/locations/my-location/agent/sessions/my-session/contexts/my-context',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "lifespanCount": 0,
         *   //   "name": "my_name",
         *   //   "parameters": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Locations$Agent$Sessions$Contexts$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Locations$Agent$Sessions$Contexts$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1Context>>;
        get(params: Params$Resource$Projects$Locations$Agent$Sessions$Contexts$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Locations$Agent$Sessions$Contexts$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Context>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Context>): void;
        get(params: Params$Resource$Projects$Locations$Agent$Sessions$Contexts$Get, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Context>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Context>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.locations.agent.sessions.contexts.list({
         *     pageSize: 'placeholder-value',
         *
         *     pageToken: 'placeholder-value',
         *
         *     parent:
         *       'projects/my-project/locations/my-location/agent/sessions/my-session',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "contexts": [],
         *   //   "nextPageToken": "my_nextPageToken"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Locations$Agent$Sessions$Contexts$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Locations$Agent$Sessions$Contexts$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1ListContextsResponse>>;
        list(params: Params$Resource$Projects$Locations$Agent$Sessions$Contexts$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Locations$Agent$Sessions$Contexts$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListContextsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListContextsResponse>): void;
        list(params: Params$Resource$Projects$Locations$Agent$Sessions$Contexts$List, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListContextsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListContextsResponse>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.locations.agent.sessions.contexts.patch(
         *     {
         *       name: 'projects/my-project/locations/my-location/agent/sessions/my-session/contexts/my-context',
         *
         *       updateMask: 'placeholder-value',
         *
         *       // Request body metadata
         *       requestBody: {
         *         // request body parameters
         *         // {
         *         //   "lifespanCount": 0,
         *         //   "name": "my_name",
         *         //   "parameters": {}
         *         // }
         *       },
         *     },
         *   );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "lifespanCount": 0,
         *   //   "name": "my_name",
         *   //   "parameters": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        patch(params: Params$Resource$Projects$Locations$Agent$Sessions$Contexts$Patch, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        patch(params?: Params$Resource$Projects$Locations$Agent$Sessions$Contexts$Patch, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1Context>>;
        patch(params: Params$Resource$Projects$Locations$Agent$Sessions$Contexts$Patch, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        patch(params: Params$Resource$Projects$Locations$Agent$Sessions$Contexts$Patch, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Context>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Context>): void;
        patch(params: Params$Resource$Projects$Locations$Agent$Sessions$Contexts$Patch, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Context>): void;
        patch(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Context>): void;
    }
    export interface Params$Resource$Projects$Locations$Agent$Sessions$Contexts$Create extends StandardParameters {
        /**
         *
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1Context;
    }
    export interface Params$Resource$Projects$Locations$Agent$Sessions$Contexts$Delete extends StandardParameters {
        /**
         *
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Agent$Sessions$Contexts$Get extends StandardParameters {
        /**
         *
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Agent$Sessions$Contexts$List extends StandardParameters {
        /**
         *
         */
        pageSize?: number;
        /**
         *
         */
        pageToken?: string;
        /**
         *
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Locations$Agent$Sessions$Contexts$Patch extends StandardParameters {
        /**
         *
         */
        name?: string;
        /**
         *
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1Context;
    }
    export class Resource$Projects$Locations$Agent$Sessions$Entitytypes {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await dialogflow.projects.locations.agent.sessions.entityTypes.create({
         *       parent:
         *         'projects/my-project/locations/my-location/agent/sessions/my-session',
         *
         *       // Request body metadata
         *       requestBody: {
         *         // request body parameters
         *         // {
         *         //   "entities": [],
         *         //   "entityOverrideMode": "my_entityOverrideMode",
         *         //   "name": "my_name"
         *         // }
         *       },
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "entities": [],
         *   //   "entityOverrideMode": "my_entityOverrideMode",
         *   //   "name": "my_name"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Projects$Locations$Agent$Sessions$Entitytypes$Create, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        create(params?: Params$Resource$Projects$Locations$Agent$Sessions$Entitytypes$Create, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>>;
        create(params: Params$Resource$Projects$Locations$Agent$Sessions$Entitytypes$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Projects$Locations$Agent$Sessions$Entitytypes$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>): void;
        create(params: Params$Resource$Projects$Locations$Agent$Sessions$Entitytypes$Create, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>): void;
        create(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await dialogflow.projects.locations.agent.sessions.entityTypes.delete({
         *       name: 'projects/my-project/locations/my-location/agent/sessions/my-session/entityTypes/my-entityType',
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {}
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Projects$Locations$Agent$Sessions$Entitytypes$Delete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        delete(params?: Params$Resource$Projects$Locations$Agent$Sessions$Entitytypes$Delete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleProtobufEmpty>>;
        delete(params: Params$Resource$Projects$Locations$Agent$Sessions$Entitytypes$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Projects$Locations$Agent$Sessions$Entitytypes$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleProtobufEmpty>, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(params: Params$Resource$Projects$Locations$Agent$Sessions$Entitytypes$Delete, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await dialogflow.projects.locations.agent.sessions.entityTypes.get({
         *       name: 'projects/my-project/locations/my-location/agent/sessions/my-session/entityTypes/my-entityType',
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "entities": [],
         *   //   "entityOverrideMode": "my_entityOverrideMode",
         *   //   "name": "my_name"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Locations$Agent$Sessions$Entitytypes$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Locations$Agent$Sessions$Entitytypes$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>>;
        get(params: Params$Resource$Projects$Locations$Agent$Sessions$Entitytypes$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Locations$Agent$Sessions$Entitytypes$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>): void;
        get(params: Params$Resource$Projects$Locations$Agent$Sessions$Entitytypes$Get, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await dialogflow.projects.locations.agent.sessions.entityTypes.list({
         *       pageSize: 'placeholder-value',
         *
         *       pageToken: 'placeholder-value',
         *
         *       parent:
         *         'projects/my-project/locations/my-location/agent/sessions/my-session',
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "nextPageToken": "my_nextPageToken",
         *   //   "sessionEntityTypes": []
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Locations$Agent$Sessions$Entitytypes$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Locations$Agent$Sessions$Entitytypes$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1ListSessionEntityTypesResponse>>;
        list(params: Params$Resource$Projects$Locations$Agent$Sessions$Entitytypes$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Locations$Agent$Sessions$Entitytypes$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListSessionEntityTypesResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListSessionEntityTypesResponse>): void;
        list(params: Params$Resource$Projects$Locations$Agent$Sessions$Entitytypes$List, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListSessionEntityTypesResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListSessionEntityTypesResponse>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await dialogflow.projects.locations.agent.sessions.entityTypes.patch({
         *       name: 'projects/my-project/locations/my-location/agent/sessions/my-session/entityTypes/my-entityType',
         *
         *       updateMask: 'placeholder-value',
         *
         *       // Request body metadata
         *       requestBody: {
         *         // request body parameters
         *         // {
         *         //   "entities": [],
         *         //   "entityOverrideMode": "my_entityOverrideMode",
         *         //   "name": "my_name"
         *         // }
         *       },
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "entities": [],
         *   //   "entityOverrideMode": "my_entityOverrideMode",
         *   //   "name": "my_name"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        patch(params: Params$Resource$Projects$Locations$Agent$Sessions$Entitytypes$Patch, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        patch(params?: Params$Resource$Projects$Locations$Agent$Sessions$Entitytypes$Patch, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>>;
        patch(params: Params$Resource$Projects$Locations$Agent$Sessions$Entitytypes$Patch, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        patch(params: Params$Resource$Projects$Locations$Agent$Sessions$Entitytypes$Patch, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>): void;
        patch(params: Params$Resource$Projects$Locations$Agent$Sessions$Entitytypes$Patch, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>): void;
        patch(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1SessionEntityType>): void;
    }
    export interface Params$Resource$Projects$Locations$Agent$Sessions$Entitytypes$Create extends StandardParameters {
        /**
         *
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1SessionEntityType;
    }
    export interface Params$Resource$Projects$Locations$Agent$Sessions$Entitytypes$Delete extends StandardParameters {
        /**
         *
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Agent$Sessions$Entitytypes$Get extends StandardParameters {
        /**
         *
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Agent$Sessions$Entitytypes$List extends StandardParameters {
        /**
         *
         */
        pageSize?: number;
        /**
         *
         */
        pageToken?: string;
        /**
         *
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Locations$Agent$Sessions$Entitytypes$Patch extends StandardParameters {
        /**
         *
         */
        name?: string;
        /**
         *
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1SessionEntityType;
    }
    export class Resource$Projects$Locations$Agent$Versions {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.locations.agent.versions.create({
         *     parent: 'projects/my-project/locations/my-location/agent',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "createTime": "my_createTime",
         *       //   "description": "my_description",
         *       //   "name": "my_name",
         *       //   "status": "my_status",
         *       //   "versionNumber": 0
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "createTime": "my_createTime",
         *   //   "description": "my_description",
         *   //   "name": "my_name",
         *   //   "status": "my_status",
         *   //   "versionNumber": 0
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Projects$Locations$Agent$Versions$Create, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        create(params?: Params$Resource$Projects$Locations$Agent$Versions$Create, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1Version>>;
        create(params: Params$Resource$Projects$Locations$Agent$Versions$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Projects$Locations$Agent$Versions$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Version>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Version>): void;
        create(params: Params$Resource$Projects$Locations$Agent$Versions$Create, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Version>): void;
        create(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Version>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.locations.agent.versions.delete({
         *     name: 'projects/my-project/locations/my-location/agent/versions/my-version',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {}
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Projects$Locations$Agent$Versions$Delete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        delete(params?: Params$Resource$Projects$Locations$Agent$Versions$Delete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleProtobufEmpty>>;
        delete(params: Params$Resource$Projects$Locations$Agent$Versions$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Projects$Locations$Agent$Versions$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleProtobufEmpty>, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(params: Params$Resource$Projects$Locations$Agent$Versions$Delete, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.locations.agent.versions.get({
         *     name: 'projects/my-project/locations/my-location/agent/versions/my-version',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "createTime": "my_createTime",
         *   //   "description": "my_description",
         *   //   "name": "my_name",
         *   //   "status": "my_status",
         *   //   "versionNumber": 0
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Locations$Agent$Versions$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Locations$Agent$Versions$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1Version>>;
        get(params: Params$Resource$Projects$Locations$Agent$Versions$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Locations$Agent$Versions$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Version>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Version>): void;
        get(params: Params$Resource$Projects$Locations$Agent$Versions$Get, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Version>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Version>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.locations.agent.versions.list({
         *     pageSize: 'placeholder-value',
         *
         *     pageToken: 'placeholder-value',
         *
         *     parent: 'projects/my-project/locations/my-location/agent',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "nextPageToken": "my_nextPageToken",
         *   //   "versions": []
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Locations$Agent$Versions$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Locations$Agent$Versions$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1ListVersionsResponse>>;
        list(params: Params$Resource$Projects$Locations$Agent$Versions$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Locations$Agent$Versions$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListVersionsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListVersionsResponse>): void;
        list(params: Params$Resource$Projects$Locations$Agent$Versions$List, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListVersionsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListVersionsResponse>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.locations.agent.versions.patch({
         *     name: 'projects/my-project/locations/my-location/agent/versions/my-version',
         *
         *     updateMask: 'placeholder-value',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "createTime": "my_createTime",
         *       //   "description": "my_description",
         *       //   "name": "my_name",
         *       //   "status": "my_status",
         *       //   "versionNumber": 0
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "createTime": "my_createTime",
         *   //   "description": "my_description",
         *   //   "name": "my_name",
         *   //   "status": "my_status",
         *   //   "versionNumber": 0
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        patch(params: Params$Resource$Projects$Locations$Agent$Versions$Patch, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        patch(params?: Params$Resource$Projects$Locations$Agent$Versions$Patch, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1Version>>;
        patch(params: Params$Resource$Projects$Locations$Agent$Versions$Patch, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        patch(params: Params$Resource$Projects$Locations$Agent$Versions$Patch, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Version>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Version>): void;
        patch(params: Params$Resource$Projects$Locations$Agent$Versions$Patch, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Version>): void;
        patch(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Version>): void;
    }
    export interface Params$Resource$Projects$Locations$Agent$Versions$Create extends StandardParameters {
        /**
         *
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1Version;
    }
    export interface Params$Resource$Projects$Locations$Agent$Versions$Delete extends StandardParameters {
        /**
         *
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Agent$Versions$Get extends StandardParameters {
        /**
         *
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Agent$Versions$List extends StandardParameters {
        /**
         *
         */
        pageSize?: number;
        /**
         *
         */
        pageToken?: string;
        /**
         *
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Locations$Agent$Versions$Patch extends StandardParameters {
        /**
         *
         */
        name?: string;
        /**
         *
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1Version;
    }
    export class Resource$Projects$Locations$Answerrecords {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.locations.answerRecords.get({
         *     name: 'projects/my-project/locations/my-location/answerRecords/my-answerRecord',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "agentAssistantRecord": {},
         *   //   "answerFeedback": {},
         *   //   "name": "my_name"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Locations$Answerrecords$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Locations$Answerrecords$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1AnswerRecord>>;
        get(params: Params$Resource$Projects$Locations$Answerrecords$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Locations$Answerrecords$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1AnswerRecord>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1AnswerRecord>): void;
        get(params: Params$Resource$Projects$Locations$Answerrecords$Get, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1AnswerRecord>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1AnswerRecord>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.locations.answerRecords.list({
         *     filter: 'placeholder-value',
         *
         *     pageSize: 'placeholder-value',
         *
         *     pageToken: 'placeholder-value',
         *
         *     parent: 'projects/my-project/locations/my-location',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "answerRecords": [],
         *   //   "nextPageToken": "my_nextPageToken"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Locations$Answerrecords$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Locations$Answerrecords$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1ListAnswerRecordsResponse>>;
        list(params: Params$Resource$Projects$Locations$Answerrecords$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Locations$Answerrecords$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListAnswerRecordsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListAnswerRecordsResponse>): void;
        list(params: Params$Resource$Projects$Locations$Answerrecords$List, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListAnswerRecordsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListAnswerRecordsResponse>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.locations.answerRecords.patch({
         *     name: 'projects/my-project/locations/my-location/answerRecords/my-answerRecord',
         *
         *     updateMask: 'placeholder-value',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "agentAssistantRecord": {},
         *       //   "answerFeedback": {},
         *       //   "name": "my_name"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "agentAssistantRecord": {},
         *   //   "answerFeedback": {},
         *   //   "name": "my_name"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        patch(params: Params$Resource$Projects$Locations$Answerrecords$Patch, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        patch(params?: Params$Resource$Projects$Locations$Answerrecords$Patch, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1AnswerRecord>>;
        patch(params: Params$Resource$Projects$Locations$Answerrecords$Patch, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        patch(params: Params$Resource$Projects$Locations$Answerrecords$Patch, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1AnswerRecord>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1AnswerRecord>): void;
        patch(params: Params$Resource$Projects$Locations$Answerrecords$Patch, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1AnswerRecord>): void;
        patch(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1AnswerRecord>): void;
    }
    export interface Params$Resource$Projects$Locations$Answerrecords$Get extends StandardParameters {
        /**
         *
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Answerrecords$List extends StandardParameters {
        /**
         *
         */
        filter?: string;
        /**
         *
         */
        pageSize?: number;
        /**
         *
         */
        pageToken?: string;
        /**
         *
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Locations$Answerrecords$Patch extends StandardParameters {
        /**
         *
         */
        name?: string;
        /**
         *
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1AnswerRecord;
    }
    export class Resource$Projects$Locations$Conversationprofiles {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await dialogflow.projects.locations.conversationProfiles.clearSuggestionFeatureConfig(
         *       {
         *         conversationProfile:
         *           'projects/my-project/locations/my-location/conversationProfiles/my-conversationProfile',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "participantRole": "my_participantRole",
         *           //   "suggestionFeatureType": "my_suggestionFeatureType"
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        clearSuggestionFeatureConfig(params: Params$Resource$Projects$Locations$Conversationprofiles$Clearsuggestionfeatureconfig, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        clearSuggestionFeatureConfig(params?: Params$Resource$Projects$Locations$Conversationprofiles$Clearsuggestionfeatureconfig, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        clearSuggestionFeatureConfig(params: Params$Resource$Projects$Locations$Conversationprofiles$Clearsuggestionfeatureconfig, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        clearSuggestionFeatureConfig(params: Params$Resource$Projects$Locations$Conversationprofiles$Clearsuggestionfeatureconfig, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        clearSuggestionFeatureConfig(params: Params$Resource$Projects$Locations$Conversationprofiles$Clearsuggestionfeatureconfig, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        clearSuggestionFeatureConfig(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.locations.conversationProfiles.create({
         *     parent: 'projects/my-project/locations/my-location',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "automatedAgentConfig": {},
         *       //   "createTime": "my_createTime",
         *       //   "displayName": "my_displayName",
         *       //   "humanAgentAssistantConfig": {},
         *       //   "humanAgentHandoffConfig": {},
         *       //   "languageCode": "my_languageCode",
         *       //   "loggingConfig": {},
         *       //   "name": "my_name",
         *       //   "newMessageEventNotificationConfig": {},
         *       //   "newRecognitionResultNotificationConfig": {},
         *       //   "notificationConfig": {},
         *       //   "securitySettings": "my_securitySettings",
         *       //   "sttConfig": {},
         *       //   "timeZone": "my_timeZone",
         *       //   "ttsConfig": {},
         *       //   "updateTime": "my_updateTime"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "automatedAgentConfig": {},
         *   //   "createTime": "my_createTime",
         *   //   "displayName": "my_displayName",
         *   //   "humanAgentAssistantConfig": {},
         *   //   "humanAgentHandoffConfig": {},
         *   //   "languageCode": "my_languageCode",
         *   //   "loggingConfig": {},
         *   //   "name": "my_name",
         *   //   "newMessageEventNotificationConfig": {},
         *   //   "newRecognitionResultNotificationConfig": {},
         *   //   "notificationConfig": {},
         *   //   "securitySettings": "my_securitySettings",
         *   //   "sttConfig": {},
         *   //   "timeZone": "my_timeZone",
         *   //   "ttsConfig": {},
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Projects$Locations$Conversationprofiles$Create, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        create(params?: Params$Resource$Projects$Locations$Conversationprofiles$Create, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1ConversationProfile>>;
        create(params: Params$Resource$Projects$Locations$Conversationprofiles$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Projects$Locations$Conversationprofiles$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ConversationProfile>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ConversationProfile>): void;
        create(params: Params$Resource$Projects$Locations$Conversationprofiles$Create, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ConversationProfile>): void;
        create(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ConversationProfile>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.locations.conversationProfiles.delete({
         *     name: 'projects/my-project/locations/my-location/conversationProfiles/my-conversationProfile',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {}
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        delete(params: Params$Resource$Projects$Locations$Conversationprofiles$Delete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        delete(params?: Params$Resource$Projects$Locations$Conversationprofiles$Delete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleProtobufEmpty>>;
        delete(params: Params$Resource$Projects$Locations$Conversationprofiles$Delete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        delete(params: Params$Resource$Projects$Locations$Conversationprofiles$Delete, options: MethodOptions | BodyResponseCallback<Schema$GoogleProtobufEmpty>, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(params: Params$Resource$Projects$Locations$Conversationprofiles$Delete, callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        delete(callback: BodyResponseCallback<Schema$GoogleProtobufEmpty>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.locations.conversationProfiles.get({
         *     name: 'projects/my-project/locations/my-location/conversationProfiles/my-conversationProfile',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "automatedAgentConfig": {},
         *   //   "createTime": "my_createTime",
         *   //   "displayName": "my_displayName",
         *   //   "humanAgentAssistantConfig": {},
         *   //   "humanAgentHandoffConfig": {},
         *   //   "languageCode": "my_languageCode",
         *   //   "loggingConfig": {},
         *   //   "name": "my_name",
         *   //   "newMessageEventNotificationConfig": {},
         *   //   "newRecognitionResultNotificationConfig": {},
         *   //   "notificationConfig": {},
         *   //   "securitySettings": "my_securitySettings",
         *   //   "sttConfig": {},
         *   //   "timeZone": "my_timeZone",
         *   //   "ttsConfig": {},
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Locations$Conversationprofiles$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Locations$Conversationprofiles$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1ConversationProfile>>;
        get(params: Params$Resource$Projects$Locations$Conversationprofiles$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Locations$Conversationprofiles$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ConversationProfile>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ConversationProfile>): void;
        get(params: Params$Resource$Projects$Locations$Conversationprofiles$Get, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ConversationProfile>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ConversationProfile>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.locations.conversationProfiles.list({
         *     pageSize: 'placeholder-value',
         *
         *     pageToken: 'placeholder-value',
         *
         *     parent: 'projects/my-project/locations/my-location',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "conversationProfiles": [],
         *   //   "nextPageToken": "my_nextPageToken"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Locations$Conversationprofiles$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Locations$Conversationprofiles$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1ListConversationProfilesResponse>>;
        list(params: Params$Resource$Projects$Locations$Conversationprofiles$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Locations$Conversationprofiles$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListConversationProfilesResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListConversationProfilesResponse>): void;
        list(params: Params$Resource$Projects$Locations$Conversationprofiles$List, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListConversationProfilesResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListConversationProfilesResponse>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.locations.conversationProfiles.patch({
         *     name: 'projects/my-project/locations/my-location/conversationProfiles/my-conversationProfile',
         *
         *     updateMask: 'placeholder-value',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "automatedAgentConfig": {},
         *       //   "createTime": "my_createTime",
         *       //   "displayName": "my_displayName",
         *       //   "humanAgentAssistantConfig": {},
         *       //   "humanAgentHandoffConfig": {},
         *       //   "languageCode": "my_languageCode",
         *       //   "loggingConfig": {},
         *       //   "name": "my_name",
         *       //   "newMessageEventNotificationConfig": {},
         *       //   "newRecognitionResultNotificationConfig": {},
         *       //   "notificationConfig": {},
         *       //   "securitySettings": "my_securitySettings",
         *       //   "sttConfig": {},
         *       //   "timeZone": "my_timeZone",
         *       //   "ttsConfig": {},
         *       //   "updateTime": "my_updateTime"
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "automatedAgentConfig": {},
         *   //   "createTime": "my_createTime",
         *   //   "displayName": "my_displayName",
         *   //   "humanAgentAssistantConfig": {},
         *   //   "humanAgentHandoffConfig": {},
         *   //   "languageCode": "my_languageCode",
         *   //   "loggingConfig": {},
         *   //   "name": "my_name",
         *   //   "newMessageEventNotificationConfig": {},
         *   //   "newRecognitionResultNotificationConfig": {},
         *   //   "notificationConfig": {},
         *   //   "securitySettings": "my_securitySettings",
         *   //   "sttConfig": {},
         *   //   "timeZone": "my_timeZone",
         *   //   "ttsConfig": {},
         *   //   "updateTime": "my_updateTime"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        patch(params: Params$Resource$Projects$Locations$Conversationprofiles$Patch, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        patch(params?: Params$Resource$Projects$Locations$Conversationprofiles$Patch, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1ConversationProfile>>;
        patch(params: Params$Resource$Projects$Locations$Conversationprofiles$Patch, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        patch(params: Params$Resource$Projects$Locations$Conversationprofiles$Patch, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ConversationProfile>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ConversationProfile>): void;
        patch(params: Params$Resource$Projects$Locations$Conversationprofiles$Patch, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ConversationProfile>): void;
        patch(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ConversationProfile>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await dialogflow.projects.locations.conversationProfiles.setSuggestionFeatureConfig(
         *       {
         *         conversationProfile:
         *           'projects/my-project/locations/my-location/conversationProfiles/my-conversationProfile',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "participantRole": "my_participantRole",
         *           //   "suggestionFeatureConfig": {}
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "done": false,
         *   //   "error": {},
         *   //   "metadata": {},
         *   //   "name": "my_name",
         *   //   "response": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        setSuggestionFeatureConfig(params: Params$Resource$Projects$Locations$Conversationprofiles$Setsuggestionfeatureconfig, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        setSuggestionFeatureConfig(params?: Params$Resource$Projects$Locations$Conversationprofiles$Setsuggestionfeatureconfig, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleLongrunningOperation>>;
        setSuggestionFeatureConfig(params: Params$Resource$Projects$Locations$Conversationprofiles$Setsuggestionfeatureconfig, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        setSuggestionFeatureConfig(params: Params$Resource$Projects$Locations$Conversationprofiles$Setsuggestionfeatureconfig, options: MethodOptions | BodyResponseCallback<Schema$GoogleLongrunningOperation>, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        setSuggestionFeatureConfig(params: Params$Resource$Projects$Locations$Conversationprofiles$Setsuggestionfeatureconfig, callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
        setSuggestionFeatureConfig(callback: BodyResponseCallback<Schema$GoogleLongrunningOperation>): void;
    }
    export interface Params$Resource$Projects$Locations$Conversationprofiles$Clearsuggestionfeatureconfig extends StandardParameters {
        /**
         *
         */
        conversationProfile?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1ClearSuggestionFeatureConfigRequest;
    }
    export interface Params$Resource$Projects$Locations$Conversationprofiles$Create extends StandardParameters {
        /**
         *
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1ConversationProfile;
    }
    export interface Params$Resource$Projects$Locations$Conversationprofiles$Delete extends StandardParameters {
        /**
         *
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Conversationprofiles$Get extends StandardParameters {
        /**
         *
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Conversationprofiles$List extends StandardParameters {
        /**
         *
         */
        pageSize?: number;
        /**
         *
         */
        pageToken?: string;
        /**
         *
         */
        parent?: string;
    }
    export interface Params$Resource$Projects$Locations$Conversationprofiles$Patch extends StandardParameters {
        /**
         *
         */
        name?: string;
        /**
         *
         */
        updateMask?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1ConversationProfile;
    }
    export interface Params$Resource$Projects$Locations$Conversationprofiles$Setsuggestionfeatureconfig extends StandardParameters {
        /**
         *
         */
        conversationProfile?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1SetSuggestionFeatureConfigRequest;
    }
    export class Resource$Projects$Locations$Conversations {
        context: APIRequestContext;
        messages: Resource$Projects$Locations$Conversations$Messages;
        participants: Resource$Projects$Locations$Conversations$Participants;
        suggestions: Resource$Projects$Locations$Conversations$Suggestions;
        constructor(context: APIRequestContext);
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.locations.conversations.complete({
         *     name: 'projects/my-project/locations/my-location/conversations/my-conversation',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {}
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "conversationProfile": "my_conversationProfile",
         *   //   "conversationStage": "my_conversationStage",
         *   //   "endTime": "my_endTime",
         *   //   "ingestedContextReferences": {},
         *   //   "lifecycleState": "my_lifecycleState",
         *   //   "name": "my_name",
         *   //   "phoneNumber": {},
         *   //   "startTime": "my_startTime",
         *   //   "telephonyConnectionInfo": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        complete(params: Params$Resource$Projects$Locations$Conversations$Complete, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        complete(params?: Params$Resource$Projects$Locations$Conversations$Complete, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1Conversation>>;
        complete(params: Params$Resource$Projects$Locations$Conversations$Complete, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        complete(params: Params$Resource$Projects$Locations$Conversations$Complete, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Conversation>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Conversation>): void;
        complete(params: Params$Resource$Projects$Locations$Conversations$Complete, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Conversation>): void;
        complete(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Conversation>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.locations.conversations.create({
         *     conversationId: 'placeholder-value',
         *
         *     parent: 'projects/my-project/locations/my-location',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "conversationProfile": "my_conversationProfile",
         *       //   "conversationStage": "my_conversationStage",
         *       //   "endTime": "my_endTime",
         *       //   "ingestedContextReferences": {},
         *       //   "lifecycleState": "my_lifecycleState",
         *       //   "name": "my_name",
         *       //   "phoneNumber": {},
         *       //   "startTime": "my_startTime",
         *       //   "telephonyConnectionInfo": {}
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "conversationProfile": "my_conversationProfile",
         *   //   "conversationStage": "my_conversationStage",
         *   //   "endTime": "my_endTime",
         *   //   "ingestedContextReferences": {},
         *   //   "lifecycleState": "my_lifecycleState",
         *   //   "name": "my_name",
         *   //   "phoneNumber": {},
         *   //   "startTime": "my_startTime",
         *   //   "telephonyConnectionInfo": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Projects$Locations$Conversations$Create, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        create(params?: Params$Resource$Projects$Locations$Conversations$Create, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1Conversation>>;
        create(params: Params$Resource$Projects$Locations$Conversations$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Projects$Locations$Conversations$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Conversation>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Conversation>): void;
        create(params: Params$Resource$Projects$Locations$Conversations$Create, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Conversation>): void;
        create(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Conversation>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.locations.conversations.get({
         *     name: 'projects/my-project/locations/my-location/conversations/my-conversation',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "conversationProfile": "my_conversationProfile",
         *   //   "conversationStage": "my_conversationStage",
         *   //   "endTime": "my_endTime",
         *   //   "ingestedContextReferences": {},
         *   //   "lifecycleState": "my_lifecycleState",
         *   //   "name": "my_name",
         *   //   "phoneNumber": {},
         *   //   "startTime": "my_startTime",
         *   //   "telephonyConnectionInfo": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Locations$Conversations$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Locations$Conversations$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1Conversation>>;
        get(params: Params$Resource$Projects$Locations$Conversations$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Locations$Conversations$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Conversation>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Conversation>): void;
        get(params: Params$Resource$Projects$Locations$Conversations$Get, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Conversation>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Conversation>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await dialogflow.projects.locations.conversations.ingestContextReferences({
         *       conversation:
         *         'projects/my-project/locations/my-location/conversations/my-conversation',
         *
         *       // Request body metadata
         *       requestBody: {
         *         // request body parameters
         *         // {
         *         //   "contextReferences": {}
         *         // }
         *       },
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "ingestedContextReferences": {}
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        ingestContextReferences(params: Params$Resource$Projects$Locations$Conversations$Ingestcontextreferences, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        ingestContextReferences(params?: Params$Resource$Projects$Locations$Conversations$Ingestcontextreferences, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1IngestContextReferencesResponse>>;
        ingestContextReferences(params: Params$Resource$Projects$Locations$Conversations$Ingestcontextreferences, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        ingestContextReferences(params: Params$Resource$Projects$Locations$Conversations$Ingestcontextreferences, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1IngestContextReferencesResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1IngestContextReferencesResponse>): void;
        ingestContextReferences(params: Params$Resource$Projects$Locations$Conversations$Ingestcontextreferences, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1IngestContextReferencesResponse>): void;
        ingestContextReferences(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1IngestContextReferencesResponse>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.locations.conversations.list({
         *     filter: 'placeholder-value',
         *
         *     pageSize: 'placeholder-value',
         *
         *     pageToken: 'placeholder-value',
         *
         *     parent: 'projects/my-project/locations/my-location',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "conversations": [],
         *   //   "nextPageToken": "my_nextPageToken"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Locations$Conversations$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Locations$Conversations$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1ListConversationsResponse>>;
        list(params: Params$Resource$Projects$Locations$Conversations$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Locations$Conversations$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListConversationsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListConversationsResponse>): void;
        list(params: Params$Resource$Projects$Locations$Conversations$List, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListConversationsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListConversationsResponse>): void;
    }
    export interface Params$Resource$Projects$Locations$Conversations$Complete extends StandardParameters {
        /**
         *
         */
        name?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1CompleteConversationRequest;
    }
    export interface Params$Resource$Projects$Locations$Conversations$Create extends StandardParameters {
        /**
         *
         */
        conversationId?: string;
        /**
         *
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1Conversation;
    }
    export interface Params$Resource$Projects$Locations$Conversations$Get extends StandardParameters {
        /**
         *
         */
        name?: string;
    }
    export interface Params$Resource$Projects$Locations$Conversations$Ingestcontextreferences extends StandardParameters {
        /**
         *
         */
        conversation?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1IngestContextReferencesRequest;
    }
    export interface Params$Resource$Projects$Locations$Conversations$List extends StandardParameters {
        /**
         *
         */
        filter?: string;
        /**
         *
         */
        pageSize?: number;
        /**
         *
         */
        pageToken?: string;
        /**
         *
         */
        parent?: string;
    }
    export class Resource$Projects$Locations$Conversations$Messages {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await dialogflow.projects.locations.conversations.messages.batchCreate({
         *       parent:
         *         'projects/my-project/locations/my-location/conversations/my-conversation',
         *
         *       // Request body metadata
         *       requestBody: {
         *         // request body parameters
         *         // {
         *         //   "requests": []
         *         // }
         *       },
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "messages": []
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        batchCreate(params: Params$Resource$Projects$Locations$Conversations$Messages$Batchcreate, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        batchCreate(params?: Params$Resource$Projects$Locations$Conversations$Messages$Batchcreate, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1BatchCreateMessagesResponse>>;
        batchCreate(params: Params$Resource$Projects$Locations$Conversations$Messages$Batchcreate, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        batchCreate(params: Params$Resource$Projects$Locations$Conversations$Messages$Batchcreate, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1BatchCreateMessagesResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1BatchCreateMessagesResponse>): void;
        batchCreate(params: Params$Resource$Projects$Locations$Conversations$Messages$Batchcreate, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1BatchCreateMessagesResponse>): void;
        batchCreate(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1BatchCreateMessagesResponse>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await dialogflow.projects.locations.conversations.messages.list({
         *     filter: 'placeholder-value',
         *
         *     pageSize: 'placeholder-value',
         *
         *     pageToken: 'placeholder-value',
         *
         *     parent:
         *       'projects/my-project/locations/my-location/conversations/my-conversation',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "messages": [],
         *   //   "nextPageToken": "my_nextPageToken"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Locations$Conversations$Messages$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Locations$Conversations$Messages$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1ListMessagesResponse>>;
        list(params: Params$Resource$Projects$Locations$Conversations$Messages$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Locations$Conversations$Messages$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListMessagesResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListMessagesResponse>): void;
        list(params: Params$Resource$Projects$Locations$Conversations$Messages$List, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListMessagesResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListMessagesResponse>): void;
    }
    export interface Params$Resource$Projects$Locations$Conversations$Messages$Batchcreate extends StandardParameters {
        /**
         *
         */
        parent?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$GoogleCloudDialogflowV2beta1BatchCreateMessagesRequest;
    }
    export interface Params$Resource$Projects$Locations$Conversations$Messages$List extends StandardParameters {
        /**
         *
         */
        filter?: string;
        /**
         *
         */
        pageSize?: number;
        /**
         *
         */
        pageToken?: string;
        /**
         *
         */
        parent?: string;
    }
    export class Resource$Projects$Locations$Conversations$Participants {
        context: APIRequestContext;
        suggestions: Resource$Projects$Locations$Conversations$Participants$Suggestions;
        constructor(context: APIRequestContext);
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await dialogflow.projects.locations.conversations.participants.analyzeContent(
         *       {
         *         participant:
         *           'projects/my-project/locations/my-location/conversations/my-conversation/participants/my-participant',
         *
         *         // Request body metadata
         *         requestBody: {
         *           // request body parameters
         *           // {
         *           //   "assistQueryParams": {},
         *           //   "audioInput": {},
         *           //   "cxCurrentPage": "my_cxCurrentPage",
         *           //   "cxParameters": {},
         *           //   "eventInput": {},
         *           //   "intentInput": {},
         *           //   "messageSendTime": "my_messageSendTime",
         *           //   "queryParams": {},
         *           //   "replyAudioConfig": {},
         *           //   "requestId": "my_requestId",
         *           //   "suggestionInput": {},
         *           //   "textInput": {}
         *           // }
         *         },
         *       },
         *     );
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "automatedAgentReply": {},
         *   //   "dtmfParameters": {},
         *   //   "endUserSuggestionResults": [],
         *   //   "humanAgentSuggestionResults": [],
         *   //   "message": {},
         *   //   "replyAudio": {},
         *   //   "replyText": "my_replyText"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        analyzeContent(params: Params$Resource$Projects$Locations$Conversations$Participants$Analyzecontent, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        analyzeContent(params?: Params$Resource$Projects$Locations$Conversations$Participants$Analyzecontent, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1AnalyzeContentResponse>>;
        analyzeContent(params: Params$Resource$Projects$Locations$Conversations$Participants$Analyzecontent, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        analyzeContent(params: Params$Resource$Projects$Locations$Conversations$Participants$Analyzecontent, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1AnalyzeContentResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1AnalyzeContentResponse>): void;
        analyzeContent(params: Params$Resource$Projects$Locations$Conversations$Participants$Analyzecontent, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1AnalyzeContentResponse>): void;
        analyzeContent(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1AnalyzeContentResponse>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await dialogflow.projects.locations.conversations.participants.create({
         *       parent:
         *         'projects/my-project/locations/my-location/conversations/my-conversation',
         *
         *       // Request body metadata
         *       requestBody: {
         *         // request body parameters
         *         // {
         *         //   "agentDesktopSource": "my_agentDesktopSource",
         *         //   "documentsMetadataFilters": {},
         *         //   "name": "my_name",
         *         //   "obfuscatedExternalUserId": "my_obfuscatedExternalUserId",
         *         //   "role": "my_role"
         *         // }
         *       },
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "agentDesktopSource": "my_agentDesktopSource",
         *   //   "documentsMetadataFilters": {},
         *   //   "name": "my_name",
         *   //   "obfuscatedExternalUserId": "my_obfuscatedExternalUserId",
         *   //   "role": "my_role"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        create(params: Params$Resource$Projects$Locations$Conversations$Participants$Create, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        create(params?: Params$Resource$Projects$Locations$Conversations$Participants$Create, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1Participant>>;
        create(params: Params$Resource$Projects$Locations$Conversations$Participants$Create, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        create(params: Params$Resource$Projects$Locations$Conversations$Participants$Create, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Participant>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Participant>): void;
        create(params: Params$Resource$Projects$Locations$Conversations$Participants$Create, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Participant>): void;
        create(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Participant>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await dialogflow.projects.locations.conversations.participants.get({
         *       name: 'projects/my-project/locations/my-location/conversations/my-conversation/participants/my-participant',
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "agentDesktopSource": "my_agentDesktopSource",
         *   //   "documentsMetadataFilters": {},
         *   //   "name": "my_name",
         *   //   "obfuscatedExternalUserId": "my_obfuscatedExternalUserId",
         *   //   "role": "my_role"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        get(params: Params$Resource$Projects$Locations$Conversations$Participants$Get, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        get(params?: Params$Resource$Projects$Locations$Conversations$Participants$Get, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1Participant>>;
        get(params: Params$Resource$Projects$Locations$Conversations$Participants$Get, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        get(params: Params$Resource$Projects$Locations$Conversations$Participants$Get, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Participant>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Participant>): void;
        get(params: Params$Resource$Projects$Locations$Conversations$Participants$Get, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Participant>): void;
        get(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1Participant>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await dialogflow.projects.locations.conversations.participants.list({
         *       pageSize: 'placeholder-value',
         *
         *       pageToken: 'placeholder-value',
         *
         *       parent:
         *         'projects/my-project/locations/my-location/conversations/my-conversation',
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "nextPageToken": "my_nextPageToken",
         *   //   "participants": []
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        list(params: Params$Resource$Projects$Locations$Conversations$Participants$List, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        list(params?: Params$Resource$Projects$Locations$Conversations$Participants$List, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$GoogleCloudDialogflowV2beta1ListParticipantsResponse>>;
        list(params: Params$Resource$Projects$Locations$Conversations$Participants$List, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        list(params: Params$Resource$Projects$Locations$Conversations$Participants$List, options: MethodOptions | BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListParticipantsResponse>, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListParticipantsResponse>): void;
        list(params: Params$Resource$Projects$Locations$Conversations$Participants$List, callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListParticipantsResponse>): void;
        list(callback: BodyResponseCallback<Schema$GoogleCloudDialogflowV2beta1ListParticipantsResponse>): void;
        /**
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/dialogflow.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const dialogflow = google.dialogflow('v2beta1');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/cloud-platform',
         *       'https://www.googleapis.com/auth/dialogflow',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await dialogflow.projects.locations.conversations.participants.patch({
         *       name: 'projects/my-project/locations/my-location/conversations/my-conversation/participants/my-participant',
         *
         *       updateMask: 'placeholder-value',
         *
         *       // Request body metadata
         *       requestBody: {
         *         // request body parameters
         *         // {
         *         //   "agentDesktopSource": "my_agentDesktopSource",
         *         //   "documentsMetadataFilters": {},
         *         //   "name": "my_name",
         *         //   "obfuscatedExternalUserId": "my_obfuscatedExternalUserId",
         *         //   "role": "my_role"
         *         // }
         *       },
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "agentDesktopSource": "my_agentDesktopSource",
         *   //   "documentsMetadataFilters": {},
         *   //   "name": "my_name",
         *   //   "obfuscatedExternalUserId": "my_obfuscatedExternalUserId",
         *   //   "role": "my_role"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        patch(params: Params$Resource$Projects$Locations$Conversations$Participants$Patch, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        patch(params?