'use strict';

const { Transform } = require('stream');
const encodingJapanese = require('encoding-japanese');

class JPDecoder extends Transform {
    constructor(charset) {
        super();

        this.charset = charset;
        this.chunks = [];
        this.chunklen = 0;
    }

    _transform(chunk, encoding, done) {
        if (typeof chunk === 'string') {
            chunk = Buffer.from(chunk, encoding);
        }

        this.chunks.push(chunk);
        this.chunklen += chunk.length;
        done();
    }

    _flush(done) {
        let input = Buffer.concat(this.chunks, this.chunklen);
        try {
            let output = encodingJapanese.convert(input, {
                to: 'UNICODE', // to_encoding
                from: this.charset, // from_encoding
                type: 'string'
            });
            if (typeof output === 'string') {
                output = Buffer.from(output);
            }
            this.push(output);
        } catch {
            // keep as is on errors
            this.push(input);
        }

        done();
    }

    _destroy(err, callback) {
        this.chunks = [];
        this.chunklen = 0;
        callback(err);
    }
}

module.exports.JPDecoder = JPDecoder;
